#include <CarbonCore/CarbonCore.h>

//work

/*Dequeue

Removes a queue element directly from an operating-system queue or from a queue that you have created.

OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to a queue element to remove from a queue. 
qHeader

A pointer to a queue header. 
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Discussion

The Dequeue function attempts to find the queue element specified by the qElement parameter in the queue specified by the qHeader parameter. If Dequeue finds the element, it removes the element from the queue, adjusts the other elements in the queue accordingly, and returns noErr. Otherwise, it returns qErr, indicating that it could not find the element in the queue. The Dequeue function does not deallocate the memory occupied by the queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

The Dequeue function disables interrupts as it searches through the queue for the element to be removed. The time during which interrupts are disabled depends on the length of the queue and the position of the entry in the queue. The Dequeue function can be called at interrupt time. However, the Dequeue function is ordinarily used only by system software and, whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose removal functions. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Dequeue:
SlotVRemove

Removes a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VRemove

Removes a system-based VBL task. This function is available with the Vertical Retrace Manager.
WaitNextEvent

Removes an Event. This function is available with the Event manager.
SIntRemove

Removes a slot interrupt task. This function is available with the Slot Manager.
NMRemove

Removes a Notification request. This function is available with the Notification Manager.
SleepQRemove

Removes a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader
){};

/*Enqueue

Adds elements directly to an operating-system queue or a queue that you create.

void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to the queue element to add to a queue. 
qHeader

A pointer to a queue header. 
Discussion

The Enqueue function adds the queue element specified by the qElement parameter to the end of the queue specified by the qHeader parameter. The specified queue header is updated to reflect the new queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

Because interrupt functions are likely to manipulate operating-system queues, interrupts are disabled for a short time while the specified queue is updated. You can call the Enqueue function at interrupt time. However, the Enqueue function is ordinarily used only by system software. Whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose functions whenever possible, instead of the Enqueue function. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Enqueue:
SlotVInstall

Installs a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VInstall

Installs a system-based VBL task. This function is available with the Vertical Retrace Manager.
AddDrive

Adds a disk drive. This function is available with the Device Manager.
PPostEvent and PostEvent

Installs an Event. This function is available with the Event manager.
DTInstall

Installs a deferred task. This function is available with the Memory Management Utilities.
SIntInstall

Installs a slot interrupt task. This function is available with the Slot Manager.
NMInstall

Installs a Notification request. This function is available with the Notification Manager.
SleepQInstall

Installs a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader
){};

/*TickCount

Obtains the current number of ticks (a tick is approximately 1/60 of a second) since the system last started up.

UInt32 TickCount ();
Discussion

The TickCount function returns an unsigned 32-bit integer that indicates the current number of ticks since the system last started up. You can use this value to compare the number of ticks that have elapsed since a given event or other action occurred. For example, you could compare the current value returned by TickCount with the value of the when field of an event structure.

The tick count is incremented during the vertical retrace interrupt, but this interrupt can be disabled. Your application should not rely on the tick count to increment with absolute precision. Your application also should not assume that the tick count always increments by 1 an interrupt task might keep control for more than one tick. If your application keeps track of the previous tick count and then compares this value with the current tick count, your application should compare the two values by checking for a “greater than or equal” condition rather than “equal to previous tick count plus 1.”

Do not rely on the tick count being exact; it is usually accurate to within one tick, but this level of accuracy is not guaranteed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
UInt32 TickCount (){};

/*MakeDataExecutable

Notifies the system that the specified data is subject to execution.

void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
);
Parameters
baseAddress

The starting address of the data to be flushed.
length

The length of the data pointed to by the baseAddress parameter.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
){};

/*Delay

Delays execture for the specified amount of time.

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
);
Parameters
numTicks
finalTicks
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
){};

/*SetCurrentA5

Sets the value in register A5 to the value of the low-memory global variable CurrentA5. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetCurrentA5 ();
Return Value

The value in the A5 register before SetCurrentA5 changes it to the value of the low-memory global variable CurrentA5. 
Discussion

The CurrentA5 variable points to the boundary between the parameters and global variables of the current application.

You cannot reliably call SetCurrentA5 in code that executes at interrupt time unless you first guarantee that your application is the current process (for example, by calling the Process Manager function GetCurrentProcess). In general, you should call SetCurrentA5 at noninterrupt time and then pass the returned value to the interrupt code. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
long SetCurrentA5 (){};

/*SetA5

Sets the A5 register to the address specified. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetA5 (
   long newA5
);
Parameters
newA5

The value to which the A5 register is to be changed. 
Return Value

The value in the A5 register before SetA5 changes it to newA5. 
Discussion

In interrupt code that accesses application global variables, use the SetA5 function first to restore a value previously saved using SetCurrentA5, and then, at the end of the code, to restore the A5 register to the value it had before the first call to SetA5. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/

long SetA5 (
   long newA5
){};

/*Changing the Addressing Mode
pascal char GetMMUMode		(void);
pascal void SwapMMUMode		(char *mode);*/
pascal char GetMMUMode		(void){};
pascal void SwapMMUMode		(char *mode){};


/*Getting Information About the Operating Environment
pascal OSErr Gestalt	(OSType selector, long *response);
pascal OSErr SysEnvirons(short versionRequested, SysEnvRec *theWorld);*/
pascal OSErr SysEnvirons(short versionRequested, SysEnvRec *theWorld){};

/*InitUtil

Copies the contents of parameter RAM into low memory. (Deprecated in Mac OS X v10.3. There is no replacement because Mac OS X doesn’t require this initialization.)

OSErr InitUtil ();
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
OSUtils.h*/
OSErr InitUtil (){};

/*GetSysPPtr

Returns a pointer to the low-memory copy of parameter RAM. (Deprecated in Mac OS X v10.4. There is no replacement; this function always returns NULL in Mac OS X.)

SysPPtr GetSysPPtr ();
Return Value

See the description of the SysPPtr data type.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
SysPPtr GetSysPPtr (){};

/*WriteParam

Write the modified values in the system parameters data structure to parameter RAM. (Deprecated in Mac OS X v10.4. There is no replacement, because this function does nothing in Mac OS X.)

OSErr WriteParam ();
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
OSErr WriteParam (){};

/*ReadLocation

Obtains information about a geographic location or time zone.

void ReadLocation (
   MachineLocation * loc
);
Parameters
loc

On return, the fields of the geographic location structure containing the geographic location and the time-zone information.The ReadLocation procedure reads the stored geographic location and time zone of the Macintosh computer from extended parameter RAM. 

You can get values for the latitude, longitude, daylight savings time (DST), or Greenwich mean time (GMT). If the geographic location record has never been set, all fields contain 0.

Discussion

The latitude and longitude are stored as Fract values, giving accuracy to within one foot. For example, a Fract value of 1.0 equals 90 degrees –1.0 equals –90 degrees and –2.0 equals –180 degrees. 

To convert these values to a degrees format, you need to convert the Fract values first to the Fixed data type, then to the LongInt data type. Use the Mathematical and Logical Utilities functions Fract2Fix and Fix2Long to accomplish this task.

The DST value is a signed byte value that specifies the offset for the hour field—whether to add one hour, subtract one hour, or make no change at all. 

The GMT value is in seconds east of GMT. For example, San Francisco is at –28,800 seconds (8 hours * 3,600 seconds per hour) east of GMT. The gmtDelta field is a 3-byte value contained in a long word, so you must take care to get it properly.

The ReadLocation function was previously available with the Script Manager.

For more information on the geographic location record, see MachineLocation. 

For more information on the Fract data type and the conversion routines Long2Fix, Fix2Fract, Fract2Fix, and Fix2Long, see Mathematical and Logical Utilities. 
Special Considerations

Do not call the ReadLocation function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void ReadLocation (
   MachineLocation * loc
){};

/*CSCopyUserName

Returns a reference to the CFString that represents the user name.

CFStringRef CSCopyUserName (
   Boolean useShortName
);
Parameters
useShortName

A Boolean value that specifies whether to return the short name or full name of the user.
Return Value

A CFStringRef. See the Base Services documentation for a description of the CFStringRef data type.
Discussion

The function CSCopyUserName returns a CFStringRef based on the read UID (RUID, as returned by getuid) of the calling process. This can result in unexpected behavior (that is, CSCopyUserName returning different results than SCDynamicStoreCopyConsoleUser) for processes that manipulate their UID.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
CFStringRef CSCopyUserName (
   Boolean useShortName
){};

/*CSCopyMachineName

Returns a reference to the CFString that represents the computer name.

CFStringRef CSCopyMachineName ();
Return Value

A CFStringRef. See the Base Services documentation for a description of the CFStringRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
CFStringRef CSCopyMachineName (){};

/*Manipulating the Processor Caches
pascal Boolean SwapInstructionCache
				(Boolean cacheEnable);
pascal void FlushInstructionCache
				(void);
pascal Boolean SwapDataCache(Boolean cacheEnable);
pascal void FlushDataCache	(void);
void FlushCodeCache		(void);
OSErr FlushCodeCacheRange	(void *address, unsigned long count);*/
OSErr FlushCodeCacheRange	(void *address, unsigned long count){};
