#include <stdio.h>
#include <CommonPanels/FontPanel.h>

/*SetFontInfoForSelection

Sets the selections that appear in the Fonts window.

OSStatus SetFontInfoForSelection (
   OSType iStyleType,
   UInt32 iNumStyles,
   void * iStyles,
   EventTargetRef   iFPEventTarget
);
Parameters
iStyleType

The type of style data you are passing to the Fonts window. Pass kFontSelectionQDType if you supply a FontSelectionQDStyle data structure in the iStyles parameter. Pass kFontSelectionATSUIType if you supply ATSUStyle data in the iStyles parameter.
iNumStyles

The number of styles passed in the iStyles parameter.
iStyles

A pointer to an array of data structures that correspond to the style type specified by the iStyleType parameter.
iFPEventTarget

The event target you want to receive the Carbon event kEventFontSelection that is associated with the Fonts window. You typically specify the event target for the window that is sending the style selection to the Fonts window.
Return Value

A result code. See “Fonts Window Services Results Codes”.
Discussion

You can programmatically set a selection in the Fonts window by calling the function SetFontInfoForSelection. You can call this function even when the Fonts window is not open or visible. When the Fonts window becomes visible later, the style information specified in the most recent call to SetFontInfoForSelection is selected in the window.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X version 10.2.
Declared In
FontPanel.h*/
OSStatus SetFontInfoForSelection (
   OSType iStyleType,
   UInt32 iNumStyles,
   void * iStyles,
   EventTargetRef   iFPEventTarget
){
printf ("SetFontInfoForSelection",iStyleType,iNumStyles,iStyles,iFPEventTarget);
};

