#include <CoreFoundation/CoreFoundation.h>




/*Predefined Callback Structures

CFDictionary provides some predefined callbacks for your convenience.

const CFDictionaryKeyCallBacks kCFCopyStringDictionaryKeyCallBacks;
const CFDictionaryKeyCallBacks kCFTypeDictionaryKeyCallBacks;
const CFDictionaryValueCallBacks kCFTypeDictionaryValueCallBacks;
Constants
kCFCopyStringDictionaryKeyCallBacks

Predefined CFDictionaryKeyCallBacks structure containing a set of callbacks appropriate for use when the keys of a CFDictionary are all CFString objects, which may be mutable and need to be copied in order to serve as constant keys for the values in the dictionary.

You typically use a pointer to this constant when creating a new dictionary.

Important: For performance reasons, the default kCFCopyStringDictionaryKeyCallBacks behavior uses CFEqual which does not normalize the strings. This means that, for example, it does not consider CFStrings to be equal when they are the same but one is in pre-composed form (say, originating from a UTF-16 text file) and the other in decomposed form (say, originating from a file name). In cases where you use strings from different sources, you may want to pre-normalize the keys or else use a different set of functions to perform the comparison.


Available in Mac OS X v10.0 and later.
kCFTypeDictionaryKeyCallBacks

Predefined CFDictionaryKeyCallBacks structure containing a set of callbacks appropriate for use when the keys of a CFDictionary are all CFType-derived objects.

The retain callback is CFRetain, the release callback is CFRelease, the copy callback is CFCopyDescription, the equal callback is CFEqual. Therefore, if you use a pointer to this constant when creating the dictionary, keys are automatically retained when added to the collection, and released when removed from the collection.

Available in Mac OS X v10.0 and later.
kCFTypeDictionaryValueCallBacks

Predefined CFDictionaryValueCallBacks structure containing a set of callbacks appropriate for use when the values in a CFDictionary are all CFType-derived objects.

The retain callback is CFRetain, the release callback is CFRelease, the copy callback is CFCopyDescription, and the equal callback is CFEqual. Therefore, if you use a pointer to this constant when creating the dictionary, values are automatically retained when added to the collection, and released when removed from the collection.

Available in Mac OS X v10.0 and later.*/
const CFDictionaryKeyCallBacks kCFCopyStringDictionaryKeyCallBacks;
const CFDictionaryKeyCallBacks kCFTypeDictionaryKeyCallBacks;
const CFDictionaryValueCallBacks kCFTypeDictionaryValueCallBacks;

//work

/*CFDictionarySetValue

Sets the value corresponding to a given key.

void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. If this parameter is a fixed-capacity dictionary and it is full before this operation, and the key does not exist in the dictionary, the behavior is undefined. 
key

The key of the value to set in theDict. If a key which matches key is already present in the dictionary, only the value for the key is changed ("add if absent, replace if present"). If no key matches key, the key-value pair is added to the dictionary.

If a key-value pair is added, both key and value are retained by the dictionary, using the retain callback provided when theDict was created. key must be of the type expected by the key retain callback. 
value

The value to add to or replace in theDict. value is retained using the value retain callback provided when theDict was created, and the previous value if any is released. value must be of the type expected by the retain and release callbacks.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
){};

/*CFDictionaryGetTypeID

Returns the type identifier of all CFDictionary objects.

CFTypeID CFDictionaryGetTypeID ();
Return Value

The type identifier for the CFDictionary opaque type. 
Discussion

CFMutableDictionary objects have the same type identifier as CFDictionary objects.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDictionaryGetTypeID (){};

/*CFDictionaryContainsKey

Reports whether or not a key is in a dictionary.

Boolean CFDictionaryContainsKey (
   CFDictionaryRef theDict,
   const void *key
);
Parameters
theDict

The dictionary to examine. 
key

The key for which to find matches in the dictionary. The key hash and equal callbacks provided when the dictionary was created, are used to compare. If the hash callback is NULL, key is treated as a pointer and converted to an integer. If the equal callback is NULL, pointer equality (in C, ==) is used. If key, or any of the keys in the dictionary, is not understood by the equal callback, the behavior is undefined. 
Return Value

true, if key is in the dictionary, otherwise false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFDictionaryContainsKey (
   CFDictionaryRef theDict,
   const void *key
){};

/*CFDictionaryCreate

Creates an immutable dictionary containing the specified key-value pairs.

CFDictionaryRef CFDictionaryCreate (
   CFAllocatorRef allocator,
   const void **keys,
   const void **values,
   CFIndex numValues,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new dictionary. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
keys

A C array of the pointer-sized keys to be in the new dictionary. This value may be NULL if the numValues parameter is 0. This C array is not changed or freed by this function. The value must be a valid pointer to a C array of at least numValues pointers. 
values

A C array of the pointer-sized values to be in the new dictionary. This value may be NULL if the numValues parameter is 0. This C array is not changed or freed by this function. The value must be a valid pointer to a C array of at least numValues elements.
numValues

The number of key-value pairs to copy from the keys and values C arrays into the new dictionary. This number will be the count of the dictionary; it must be non-negative and less than or equal to the actual number of keys or values. 
keyCallBacks

A pointer to a CFDictionaryKeyCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare keys in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFDictionaryKeyCallBacks structure, the behavior is undefined. If any of the keys put into the collection is not one understood by one of the callback functions the behavior when that callback function is used is undefined.

If the collection will contain CFType objects only, then pass a pointer to kCFTypeDictionaryKeyCallBacks as this parameter to use the default callback functions.
valueCallBacks

A pointer to a CFDictionaryValueCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare values in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFDictionaryValueCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions the behavior when that callback function is used is undefined.

If the collection will contain CFType objects only, then pass a pointer to kCFTypeDictionaryValueCallBacks as this parameter to use the default callback functions.
Return Value

A new dictionary, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDictionaryRef CFDictionaryCreate (
   CFAllocatorRef allocator,
   const void **keys,
   const void **values,
   CFIndex numValues,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
){};

/*CFDictionaryGetValue

Returns the value associated with a key.

const void *CFDictionaryGetValue (
   CFDictionaryRef theDict,
   const void *key
);
Parameters
theDict

The dictionary examine.
key

The key for which to find a match in theDict. The key hash and equal callbacks provided when the dictionary was created are used to compare. If the hash callback was NULL, the key is treated as a pointer and converted to an integer. If the equal callback was NULL, pointer equality (in C, ==) is used. If key, or any of the keys in theDict, is not understood by the equal callback, the behavior is undefined. 
Return Value

The value associated with key in theDict, or NULL if no key-value pair matching key exists. Since NULL is also a valid value in some dictionaries, use CFDictionaryGetValueIfPresent to distinguish between a value that is not found, and a NULL value. If the value is a Core Foundation object, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const void *CFDictionaryGetValue (
   CFDictionaryRef theDict,
   const void *key
){};

/*CFDictionaryAddValue

Adds a key-value pair to a dictionary if the specified key is not already present.

void CFDictionaryAddValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. If the dictionary is a fixed-capacity dictionary and it is full before this operation, the behavior is undefined. 
key

The key for the value to add to the dictionary—a CFType object or a pointer value. The key is retained by the dictionary using the retain callback provided when the dictionary was created, so must be of the type expected by the callback. If a key which matches key is already present in the dictionary, this function does nothing ("add if absent"). 
value

A CFType object or a pointer value to add to the dictionary. The value is retained by the dictionary using the retain callback provided when the dictionary was created, so must be of the type expected by the callback.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionaryAddValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
){};

/*CFDictionaryCreateMutable

Creates a new mutable dictionary.

CFMutableDictionaryRef CFDictionaryCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new dictionary and its storage for key-value pairs. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
capacity

The maximum number of key-value pairs that can be contained by the dictionary. The dictionary starts empty and can grow to this number of key-value pairs (and it can have less). Pass 0 to specify no limit. The value must not be negative.
keyCallBacks

A pointer to a CFDictionaryKeyCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare keys in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as a valid structure of version 0 with all fields NULL. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this value is not a valid pointer to a CFDictionaryKeyCallBacks structure, the behavior is undefined. If any of the keys put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the dictionary will contain only CFType objects, then pass a pointer to kCFTypeDictionaryKeyCallBacks as this parameter to use the default callback functions. 
valueCallBacks

A pointer to a CFDictionaryValueCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare values in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as a valid structure of version 0 with all fields NULL. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this value is not a valid pointer to a CFDictionaryValueCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the dictionary will contain CFType objects only, then pass a pointer to kCFTypeDictionaryValueCallBacks as this parameter to use the default callback functions. 
Return Value

A new dictionary, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableDictionaryRef CFDictionaryCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
){};

/*CFDictionaryGetValueIfPresent

Reports whether or not a value for a key is in a dictionary, and returns that value indirectly if it exists.

Boolean CFDictionaryGetValueIfPresent (
   CFDictionaryRef theDict,
   const void *key,
   const void **value
);
Parameters
theDict

The dictionary to examine. 
key

The key for which to find a match in the dictionary. The key hash and equal callbacks provided when the dictionary was created are used to compare. If the hash callback was NULL, key is treated as a pointer and converted to an integer. If the equal callback was NULL, pointer equality (in C, ==) is used. If key, or any of the keys in theDict, is not understood by the equal callback, the behavior is undefined. 
value

A pointer to memory which, on return, is filled with the pointer-sized value if a matching key is found. If no key match is found, the contents of the storage pointed to by this parameter are undefined. This value may be NULL, in which case the value from the dictionary is not returned (but the return value of this function still indicates whether or not the key-value pair was present). If the value is a Core Foundation object, ownership follows the Get Rule.
Return Value

true, if a matching key was found, otherwise false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

Boolean CFDictionaryGetValueIfPresent (
   CFDictionaryRef theDict,
   const void *key,
   const void **value
){};

/*CFDictionaryRemoveValue

Removes a key-value pair.

void CFDictionaryRemoveValue (
   CFMutableDictionaryRef theDict,
   const void *key
);
Parameters
theDict

The dictionary to modify. 
key

The key of the value to remove from theDict. If a key which matches key is present in theDict, the key-value pair is removed from the dictionary, otherwise this function does nothing ("remove if present"). 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionaryRemoveValue (
   CFMutableDictionaryRef theDict,
   const void *key
){};

/*CFDictionaryCreateMutableCopy

Creates a new mutable dictionary with the key-value pairs from another dictionary.

CFMutableDictionaryRef CFDictionaryCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFDictionaryRef theDict
);
Parameters
allocator

The allocator to use to allocate memory for the new dictionary and its storage for key-value pairs. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of key-value pairs that can be contained by the returned dictionary. The dictionary starts empty, and can grow to this number of key-value pairs (and it can have less). The value must be greater than or equal to the count of theDict, or 0 to specify no limit
theDict

The dictionary to copy. The keys and values from the dictionary are copied as pointers into the new dictionary, not that which the values point to (if anything). The keys and values are also retained by the new dictionary. The count of the new dictionary is the same as the count of theDict. The new dictionary uses the same callbacks as theDict. 
Return Value

A new dictionary that contains the same values as theDict. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableDictionaryRef CFDictionaryCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFDictionaryRef theDict
){};

/*CFDictionaryGetCount

Returns the number of key-value pairs in a dictionary.

CFIndex CFDictionaryGetCount (
   CFDictionaryRef theDict
);
Parameters
dict

The dictionary to examine. 
Return Value

The number of number of key-value pairs in dict. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFDictionaryGetCount (
   CFDictionaryRef theDict
){};

/*CFDictionaryRemoveAllValues

Removes all the key-value pairs from a dictionary, making it empty.

void CFDictionaryRemoveAllValues (
   CFMutableDictionaryRef theDict
);
Parameters
theDict

The dictionary to modify. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionaryRemoveAllValues (
   CFMutableDictionaryRef theDict
){};

/*CFDictionaryGetKeysAndValues

Fills two buffers with the keys and values from a dictionary.

void CFDictionaryGetKeysAndValues (
   CFDictionaryRef theDict,
   const void **keys,
   const void **values
);
Parameters
theDict

The dictionary to examine. 
keys

A C array of pointer-sized values that, on return, is filled with keys from the theDict. The keys and values C arrays are parallel to each other (that is, the items at the same indices form a key-value pair from the dictionary). This value must be a valid pointer to a C array of the appropriate type and size (that is, a size equal to the count of theDict), or NULL if the keys are not required. If the keys are Core Foundation objects, ownership follows the Get Rule.
values

A C array of pointer-sized values that, on return, is filled with values from the theDict. The keys and values C arrays are parallel to each other (that is, the items at the same indices form a key-value pair from the dictionary). This value must be a valid pointer to a C array of the appropriate type and size (that is, a size equal to the count of theDict), or NULL if the values are not required. If the values are Core Foundation objects, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFDictionaryGetKeysAndValues (
   CFDictionaryRef theDict,
   const void **keys,
   const void **values
){
printf ("CFDictionaryGetKeysAndValues",theDict,keys,values);
};

/*CFDictionaryApplyFunction

Calls a function once for each key-value pair in a dictionary.

void CFDictionaryApplyFunction (
   CFDictionaryRef theDict,
   CFDictionaryApplierFunction applier,
   void *context
);
Parameters
theDict

The dictionary to operate upon. 
applier

The callback function to call once for each key-value pair in the dictionary. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. If there are keys or values which the applier function does not expect or cannot properly apply to, the behavior is undefined. 
context

A pointer-sized program-defined value, which is passed as the third parameter to the applier function, but is otherwise unused by this function. The value must be appropriate for the applier function.
Discussion

If this function iterates over a mutable collection, it is unsafe for the applier function to change the contents of the collection. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionaryApplyFunction (
   CFDictionaryRef theDict,
   CFDictionaryApplierFunction applier,
   void *context
){};

/*CFDictionaryReplaceValue

Replaces a value corresponding to a given key.

void CFDictionaryReplaceValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. 
key

The key of the value to replace in theDict. If a key which matches key is present in the dictionary, the value is changed to the value, otherwise this function does nothing ("replace if present"). 
value

The new value for key. The value object is retained by theDict using the retain callback provided when theDict was created, and the old value is released. value must be of the type expected by the retain and release callbacks.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFDictionaryReplaceValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
){};



/*CFDictionaryContainsValue

Reports whether or not a value is in a dictionary.

Boolean CFDictionaryContainsValue (
   CFDictionaryRef theDict,
   const void *value
);
Parameters
theDict

The dictionary to examine. 
value

The value for which to find matches in the dictionary. The value equal callback provided when the dictionary was created is used to compare. If the equal callback was NULL, pointer equality (in C, ==) is used. If value, or any other value in the dictionary, is not understood by the equal callback, the behavior is undefined. 
Return Value

true, if value is in the dictionary, otherwise false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

Boolean CFDictionaryContainsValue (
   CFDictionaryRef theDict,
   const void *value
){};
