#include <CoreGraphics/CoreGraphics.h>

/*Generic Color Spaces

Identify specific color spaces that are defined in a ColorSync document.

CFStringRef kCGColorSpaceGenericGray
CFStringRef kCGColorSpaceGenericRGB
CFStringRef kCGColorSpaceGenericCMYK
Constants
kCGColorSpaceGenericGray

Specifies a gray color space.

Available in Mac OS X v10.4 and later.
kCGColorSpaceGenericRGB

Specifies an RGB color space.

Available in Mac OS X v10.4 and later.
kCGColorSpaceGenericCMYK

Specifies a CMYK color space.

Available in Mac OS X v10.4 and later.
Discussion

A “generic” color space constant can be passed as a parameter to the function CGColorSpaceCreateWithName. Generic color spaces replace Named Color Spaces (Deprecated), which are deprecated in Mac OS X v10.4.
Availability
Available in Mac OS X v10.4 and later.*/

const CFStringRef kCGColorSpaceGenericGray;
const CFStringRef kCGColorSpaceGenericRGB;
const CFStringRef kCGColorSpaceGenericCMYK;

//work

/*CGColorSpaceCreateWithPlatformColorSpace

Creates a platform-specific color space.

CGColorSpaceRef CGColorSpaceCreateWithPlatformColorSpace(
   void *platformColorSpace
);
Parameters
platformColorSpace

A generic pointer to a platform-specific color space. In Mac OS X, pass a CMProfileRef—a ColorSync profile. Quartz uses this pointer (and the underlying information) only during the function call.
Return Value

A new color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateWithPlatformColorSpace(
   void *platformColorSpace
){};

/*CGColorSpaceRelease

Decrements the retain count of a color space.

void CGColorSpaceRelease (
   CGColorSpaceRef cs
);
Parameters
cs

The Quartz color space to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the cs parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
void CGColorSpaceRelease (
   CGColorSpaceRef cs
){};

/*CGColorSpaceCreateDeviceGray

Creates a device-dependent grayscale color space.

CGColorSpaceRef CGColorSpaceCreateDeviceGray (void);
Return Value

A device-dependent gray color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

In Mac OS X v10.4 and later, this color space is no longer device-dependent and is replaced by the generic counterpart—kCGColorSpaceGenericGray—described in “Generic Color Spaces”. If you use this function in Mac OS X v10.4 and later, colors are mapped to the generic color spaces. If you want to bypass color matching, use the colorspace of the destination context.

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateDeviceGray (void){};

/*CGColorSpaceCreateDeviceRGB

Creates a device-dependent RGB color space.

CGColorSpaceRef CGColorSpaceCreateDeviceRGB (void);
Return Value

A device-dependent RGB color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

In Mac OS X v10.4 and later, this color space is no longer device-dependent and is replaced by the generic counterpart—kCGColorSpaceGenericRGB—described in “Generic Color Spaces”. If you use this function in Mac OS X v10.4 and later, colors are mapped to the generic color spaces. If you want to bypass color matching, use the colorspace of the destination context.

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateDeviceRGB (void){};

/*CGColorSpaceCreateWithName

Creates a specified type of Quartz color space.

CGColorSpaceRef CGColorSpaceCreateWithName (
CFStringRef name
);
Parameters
name

A color space name. See “Generic Color Spaces” for a list of the valid Quartz-defined names.
Return Value

A new generic color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

You can use this function to create a generic color space. For more information, see “Generic Color Spaces”.

Prior to Mac OS X v10.4, you could pass this function one of the constants defined in “Named Color Spaces (Deprecated)”. As of Mac OS X v10.4, this function returns a generic color space even if you pass is one of the deprecated named color spaces. 
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateWithName (
CFStringRef name
){};

/*CGColorSpaceGetNumberOfComponents

Returns the number of color components in a color space.

size_t CGColorSpaceGetNumberOfComponents (
   CGColorSpaceRef cs
);
Parameters
cs

The Quartz color space to examine. 
Return Value

The number of color components in the specified color space, not including the alpha value. For example, for an RGB color space, CGColorSpaceGetNumberOfComponents returns a value of 3.
Discussion

A color space defines an n-dimensional space whose dimensions (or components) represent intensity values. For example, you specify colors in RGB space as three intensity values: red, green, and blue. You can use the CGColorSpaceGetNumberOfComponents function to obtain the number of components in a given color space. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/

size_t CGColorSpaceGetNumberOfComponents (
   CGColorSpaceRef cs
){};

/*CGColorSpaceCreateDeviceCMYK

Creates a device-dependent CMYK color space.

CGColorSpaceRef CGColorSpaceCreateDeviceCMYK (void);
Return Value

A device-dependent CMYK color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

In Mac OS X v10.4 and later, this color space is no longer device-dependent and is replaced by the generic counterpart—kCGColorSpaceGenericCMYK—described in “Generic Color Spaces”. If you use this function in Mac OS X v10.4 and later, colors are mapped to the generic color spaces. If you want to bypass color matching, use the colorspace of the destination context.

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateDeviceCMYK (void){};

/*CGColorSpaceRetain

Increments the retain count of a color space.

CGColorSpaceRef CGColorSpaceRetain (
   CGColorSpaceRef cs
);
Parameters
cs

The Quartz color space to retain. 
Return Value

The same color space you passed in as the cs parameter.
Discussion

This function is equivalent to CFRetain, except that it does not cause an error if the cs parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/

CGColorSpaceRef CGColorSpaceRetain (
   CGColorSpaceRef cs
){};
