#include <HIToolbox/HIToolbox.h>

/*SetDataBrowserTableViewRowHeight

Sets the default row height for all rows in a data browser.

OSStatus SetDataBrowserTableViewRowHeight (
   ControlRef  browser,
   UInt16 height
);
Parameters
browser

A data browser. 
height

The row height, in pixels.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

This function sets the default row height for all rows. You override the default row height for an individual row by calling the function SetDataBrowserTableViewItemRowHeight.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserTableViewRowHeight (
   ControlRef  browser,
   UInt16 height
){
printf ("SetDataBrowserTableViewRowHeight",browser,height);
};


/*CreateDataBrowserControl

Creates a data browser programmatically.

OSStatus CreateDataBrowserControl (
   WindowRef window,
   const Rect *boundsRect,
   DataBrowserViewStyle style,
   ControlRef *outControl
);
Parameters
window

The window in which to place the data browser. 
boundsRect

A pointer to a rectangle that specifies the location where you want the control to appear in the window.
style

The view style to use. Pass the constant kDataBrowserListView to draw the data browser using list view or kDataBrowserColumnView draw the data browser using column view. See “View Styles” for more information on these constants.
outControl

On input, a pointer to a control reference. On return, this is set to the newly created data browser. When you no longer need the data browser, call the Control Manager function DisposeControl to release it. When you dispose of the control, deallocate any universal procedure pointers you allocated for use with the control.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

This function creates a data browser programmatically. If you create a data browser using Interface Builder, you don’t need to call CreateDataBrowserControl. Instead, you call the function GetControlByID to obtain a control reference that points to your data browser.

After you create a data browser by calling CreateDataBrowserControl, you can set such attributes as sorting order, scroll bars, and scroll position. See “Manipulating Data Browser Attributes” for the functions you can use to set data browser attributes.

You need to set up the display characteristics of the data browser by calling the appropriate functions. See “Formatting Table View”, “Formatting List View”, and “Formatting Column View” for information on the formatting functions you can call. 

You need to call the functions InitDataBrowserCallbacks and SetDataBrowserCallbacks to install the callbacks needed for your data browser. At the very least, you must provide an item-data callback to add or change data items; you must do so regardless of the content your data browser displays—noncustom or custom. Otherwise, your data browser will be empty. See DataBrowserItemDataProcPtr for more information. If you present hierarchical data in list view, or use column view for browsing data, you must provide a callback to handle item notifications. See DataBrowserItemNotificationProcPtr and DataBrowserItemNotificationWithItemProcPtr.

You can optionally provide callbacks to:
Perform sorting. See DataBrowserItemCompareProcPtr.
Handle drag-and-drop behavior. See DataBrowserAddDragItemProcPtr, DataBrowserAcceptDragProcPtr, DataBrowserReceiveDragProcPtr, and DataBrowserPostProcessDragProcPtr.
Provide contextual menus. See DataBrowserGetContextualMenuProcPtr and DataBrowserSelectContextualMenuProcPtr.
Display help tags. See DataBrowserItemHelpContentProcPtr.

If your data browser uses a list whose columns require custom drawing or behavior, you must also provide callbacks to handle the custom tasks. See InitDataBrowserCustomCallbacks and SetDataBrowserCustomCallbacks for more information on initializing and installing callbacks for custom behavior. The custom tasks you can handle in list view include:
Drawing custom content. See DataBrowserDrawItemProcPtr.
Supporting editing of custom content. See DataBrowserEditItemProcPtr. Note that editing is built-in for noncustom content. 
Performing hit-testing and tracking. See DataBrowserHitTestProcPtr and DataBrowserTrackingProcPtr.
Handling drag-and-drop behavior. See DataBrowserItemDragRgnProcPtr, DataBrowserItemAcceptDragProcPtr, and DataBrowserItemReceiveDragProcPtr.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateDataBrowserControl (
   WindowRef window,
   const Rect *boundsRect,
   DataBrowserViewStyle style,
   ControlRef *outControl
){
printf ("CreateDataBrowserControl",window,*boundsRect,style,*outControl);
};


/*SetDataBrowserSortOrder

Sets the sorting order for a list in list view. 

OSStatus SetDataBrowserSortOrder (
   ControlRef browser,
   DataBrowserSortOrder order
);
Parameters
browser

A data browser.
order

The sorting order. See “Sorting Orders” for a list of the constants you can supply.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

List view tracks the sorting order by column. In Mac OS X, setting the sorting order only affects the sorting order of the column currently set for sorting. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserSortOrder (
   ControlRef browser,
   DataBrowserSortOrder order
){
printf ("SetDataBrowserSortOrder",browser,order);
};


/*SetDataBrowserSortProperty

Designates the list view column to use for sorting.

OSStatus SetDataBrowserSortProperty (
   ControlRef browser,
   DataBrowserPropertyID property
);
Parameters
browser

A data browser.
property

The property ID of the column to use for sorting. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

If the list is not currently sorted, or if the list is currently sorted with a different column, then the list is sorted and redrawn. You can all the function GetDataBrowserSortProperty to obtain the property ID of the column currently used for sorting.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserSortProperty (
   ControlRef browser,
   DataBrowserPropertyID property
){
printf ("SetDataBrowserSortProperty",browser,property);
};

/*AddDataBrowserListViewColumn

Adds a column to a data browser that uses list view.

OSStatus AddDataBrowserListViewColumn (
   ControlRef browser,
   DataBrowserListViewColumnDesc *columnDesc,
   DataBrowserTableViewColumnIndex position
);
Parameters
browser

A data browser.
columnDesc

A pointer to the list view column description data structure that you have filled out with data that specifies the column property and display information for the column heading.
position

The position, among the columns already installed in the data browser, to insert this column. To insert this column to the right of all other columns, pass kDataBrowserListViewAppendColumn. The value 0 means the leftmost column.
Return Value

A result code; paramErr is returned if the columnDesc parameter is not properly initialized. See “Data Browser Result Codes”.
Discussion

Typically you use the function AddDataBrowserListViewColumn in these cases:
When you create a data browser programmatically. If you use Interface Builder to design and lay out the data browser, you do not need to call the function AddDataBrowserListViewColumn. Interface Builder lets you position a column graphically and then specify the column description in the column pane of the Info window. 
When you switch from column view to list view. Regardless of how you first create a data browser, if your application allows the user to switch between views, you need to add list view columns each time the view switches from column to list view.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus AddDataBrowserListViewColumn (
   ControlRef browser,
   DataBrowserListViewColumnDesc *columnDesc,
   DataBrowserTableViewColumnIndex position
){
printf ("AddDataBrowserListViewColumn",browser,*columnDesc,position);
};

/*SetDataBrowserItemDataIcon

Specifies the icon to draw.

OSStatus SetDataBrowserItemDataIcon (
   DataBrowserItemDataRef itemData,
   IconRef theData
);
Parameters
itemData

The item data reference for the item whose icon you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataIcon.
theData

The icon to display. The data browser retains the icon, so you may release the IconRef after the function returns.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

You call the function SetDataBrowserItemDataIcon from within a DataBrowserItemDataProcPtr callback routine to specify an icon to draw. You can specify an icon for any column that has the kDataBrowserIconType display type or the kDataBrowserIconAndTextType display type.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataIcon (
   DataBrowserItemDataRef itemData,
   IconRef theData
){
printf ("SetDataBrowserItemDataIcon",itemData,theData);
};


/*GetDataBrowserItemCount

Obtains the number of items whose state matches the specified state.

OSStatus GetDataBrowserItemCount (
   ControlRef browser,
   DataBrowserItemID container,
   Boolean recurse,
   DataBrowserItemState state,
   UInt32 *numItems
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. To obtain the number of items that are organized as subitems of a container item, pass the item ID for the container. To obtain the number of items displayed at the root of the data browser, provide the constant kDataBrowserNoItem.
recurse

A value that indicates whether or not to traverse the entire item hierarchy when counting. Pass true to obtain a count for all items in the hierarchy. Pass false if you want to count only those items at the top level of the container or data browser.
state

A value that specifies the state of the items to obtain. Only items that have this state are counted. Pass kDataBrowserItemNoState if you want to count all items regardless of state. Otherwise, pass one of the constants described in Item States.
numItems

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the number of items in the container that have the specified state.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserItemCount (
   ControlRef browser,
   DataBrowserItemID container,
   Boolean recurse,
   DataBrowserItemState state,
   UInt32 *numItems
){
printf ("GetDataBrowserItemCount",browser,container,recurse,state,*numItems);
};




/*NewControlEditTextValidationUPP

Creates a UPP for a control edit text validation callback function. 

ControlEditTextValidationUPP NewControlEditTextValidationUPP (
   ControlEditTextValidationProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlEditTextValidationUPP NewControlEditTextValidationUPP (
   ControlEditTextValidationProcPtr userRoutine
){
printf ("NewControlEditTextValidationUPP",userRoutine);
};


/*CreateTabsControl

Creates a tabs control.

OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
size

The control tab size. See Control Tab Size Constants for possible values.
direction

The control tab direction. See Control Tab Direction Constants for possible values.
numTabs

The initial number of tabs.
tabArray

Information about each tab. There must be the same number of entries as specified by the numTabs parameter.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

If you want to customize the accessibility information provided for individual tabs of a tabs control, such as by handling various kEventClassAccessibility Carbon Events and by calling HIObjectSetAuxiliaryAccessibilityAttribute, you need to know how to build or interpret AXUIElement reference that represent individual tabs. The AXUIElement representing an individual tab must be constructed using the tab control’s ControlRef and the UInt64 identifier of the one-based index of the tab to which the element refers. A UInt64 identifier of 0 represents the tabs control as a whole. You cannot interpret or create tab control elements whose identifiers are greater than the count of tabs in the tabs control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl){
printf ("CreateTabsControl",window,*boundsRect,size,direction,numTabs,*tabArray,*outControl);
};


/*CreateUserPaneControl

Creates a user pane control.

OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
features

The user pane features with which the user pane is to be created. For possible constants, see “Control Features Constants”. 
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

User panes have two primary purposes: to allow easy implementation of a custom control by the developer, and to provide a generic container for embedding other controls.

In Carbon, with the advent of Carbon-event-based controls, you may find it easier to write a new control from scratch than to customize a user pane control. The set of callbacks provided by the user pane will not be extended to support new Control Manager features; instead, you should just write a real control.User panes do not, by default, support embedding. If you try to embed a control into a user pane, you will get the errControlIsNotEmbedder. You can make a user pane support embedding by passing the kControlSupportsEmbedding flag in the features parameter when you create the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl){
printf ("CreateUserPaneControl",window,*boundsRect,features,*outControl);
};


/*CreateStaticTextControl

Creates a new static text control.

OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl){
printf ("CreateStaticTextControl",window,*boundsRect,text,*style,*outControl);
};

/*CreatePushButtonControl

Creates a push button control.

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The control title. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl){
printf ("CreatePushButtonControl",window,*boundsRect,title,*outControl);
};

/*CreatePictureControl

Creates a picture control.

OSStatus CreatePictureControl (
   WindowRef window,
   const Rect * boundsRect,
   const ControlButtonContentInfo * content,
   Boolean dontTrack,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
content

The descriptor for the picture you want the control to display. Only picture content is supported. You can change the picture by calling SetControlData and passing the kControlPictureHandleTag constant.
dontTrack

A Boolean whose value is true to indicate that the control should not be highlighted when it is clicked; false means that the control should be highlighted and the mouse tracked when the control is clicked.
outControl

On return, the new control.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreatePictureControl (
   WindowRef window,
   const Rect * boundsRect,
   const ControlButtonContentInfo * content,
   Boolean dontTrack,
   ControlRef * outControl
){
printf ("CreatePictureControl",window,*boundsRect,*content,dontTrack,*outControl);
};

/*CreateSliderControl

Creates a slider control.

OSStatus CreateSliderControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   ControlSliderOrientation orientation,
   UInt16 numTickMarks,
   Boolean liveTracking,
   ControlActionUPP liveTrackingProc,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value of the control.
maximum

The maximum value of the control.
orientation

The orientation of the control. For possible values, see “Control Slider Orientation Constants”.
numTickMarks

The number of tick marks the slider control is to have.
liveTracking

A Boolean whose value is true to enable live tracking for the control; otherwise, false.
liveTrackingProc

If the value of the liveTracking parameter is true, a ControlActionUPP callback is to be called as the control live tracks. This callback is called repeatedly as the slider is moved during tracking.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Mac OS X has a “Scroll to here” option in the General pane of System Preferences that allows users to click in the page up or page down regions of a slider and have the indicator jump directly to the clicked position, which alters the value of the slider and moves any associated content appropriately. As long as the mouse button is held down, the click is treated as though the user clicked the indicator. 

If you want the sliders in your application to work with the “Scroll to here” option, you must do the following:
Create live-tracking sliders, not sliders that show a “ghost” thumb when you click on it. You can request live-tracking sliders by passing true in the liveTracking parameter to CreateSliderControl. If you create sliders with NewControl, use the kControlSliderLiveFeedback variant.
Write an appropriate ControlActionProc and associate it with your slider by calling SetControlAction. This allows your application to update its content appropriately when the live-tracking slider is clicked.
When callingHandleControlClick or TrackControl TrackControl, pass -1 in the action proc parameter. This is a request for the Control Manager to use the action proc you associated with your control in step 2. If you rely on the standard window event handler to do your control tracking, this step is handled for you automatically.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateSliderControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   ControlSliderOrientation orientation,
   UInt16 numTickMarks,
   Boolean liveTracking,
   ControlActionUPP liveTrackingProc,
   ControlRef * outControl
){
printf ("CreateSliderControl",window,*boundsRect,value,minimum,maximum,orientation,numTickMarks,liveTracking,liveTrackingProc,*outControl);
};

/*CreateEditUnicodeTextControl

Creates a new edit text control.

OSStatus CreateEditUnicodeTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
isPassword

A Boolean indicating whether the field is to be used as a password field. Passing false indicates that text entered in the field is to be displayed normally. Passing true means that the field is to be used as a password field; any text typed into the field is displayed as bullets.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This function is the preferred way of creating edit text controls. Use it instead of the CreateEditTextControl function. The resulting control handles Unicode text and draws its text using anti-aliasing. Controls created by CreateEditTextControl do not handle Unicode text and are not drawn with anti-aliasing.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateEditUnicodeTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   const ControlFontStyleRec * style,
   ControlRef * outControl
){
printf ("CreateEditUnicodeTextControl",window,*boundsRect,text,isPassword,*style,*outControl);
};



/*NewDataBrowserItemNotificationUPP

Creates a universal procedure pointer to an item-notification callback function.

DataBrowserItemNotificationUPP NewDataBrowserItemNotificationUPP  (
   DataBrowserItemNotificationProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-notification callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemNotificationProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemNotificationUPP NewDataBrowserItemNotificationUPP  (
   DataBrowserItemNotificationProcPtr userRoutine
){
printf ("NewDataBrowserItemNotificationUPP",userRoutine);
};



/*InitDataBrowserCustomCallbacks

Initializes the data browser custom callback structure in preparation for adding your own callbacks for custom drawing or custom behavior to the structure.

OSStatus InitDataBrowserCustomCallbacks (
   DataBrowserCustomCallbacks *callbacks
);
Parameters
callbacks

A pointer to a DataBrowserCustomCallbacks structure. Before calling the function InitDataBrowserCustomCallbacks, set the version field of this structure to kDataBrowserLatestCustomCallbacks. On return, the fields in this structure are set to NULL.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Custom callbacks refer to those callback routines that are used to implement custom drawing or custom behavior in your data browser. The data browser API supports a limited set of built-in display types: text, icon and text, checkboxes, and so forth. If you want to display something else, you install custom callbacks to perform drawing and handle user interaction.

After you call the function InitDataBrowserCustomCallbacks, set the appropriate fields in the DataBrowserCustomCallbacks structure to your callbacks. The DataBrowserCustomCallbacks structure contains fields for the following:
DataBrowserDrawItemProcPtr
DataBrowserEditItemProcPtr
DataBrowserHitTestProcPtr
DataBrowserTrackingProcPtr
DataBrowserItemDragRgnProcPtr
DataBrowserItemAcceptDragProcPtr
DataBrowserItemReceiveDragProcPtr

After you assign your custom callbacks to the appropriate field, call the function SetDataBrowserCustomCallbacks.

Note that this is a different set of callbacks from those that are assigned to fields in the DataBrowserCallbacks data structure.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus InitDataBrowserCustomCallbacks (
   DataBrowserCustomCallbacks *callbacks
){
printf ("InitDataBrowserCustomCallbacks",*callbacks);
};


/*NewDataBrowserDrawItemUPP

Creates a universal procedure pointer to a draw-item callback function.

DataBrowserDrawItemUPP NewDataBrowserDrawItemUPP (
   DataBrowserDrawItemProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your draw-item callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserDrawItemProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.1 and later.
Declared In
ControlDefinitions.h*/
DataBrowserDrawItemUPP NewDataBrowserDrawItemUPP (
   DataBrowserDrawItemProcPtr userRoutine
){
printf ("NewDataBrowserDrawItemUPP",userRoutine);
};



/*NewDataBrowserItemCompareUPP

Creates a universal procedure pointer to an item-comparison callback function.

DataBrowserItemCompareUPP NewDataBrowserItemCompareUPP (
   DataBrowserItemCompareProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-comparison callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemCompareProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

DataBrowserItemCompareUPP NewDataBrowserItemCompareUPP (
   DataBrowserItemCompareProcPtr userRoutine
){
printf ("NewDataBrowserItemCompareUPP",userRoutine);
};


/*NewDataBrowserAcceptDragUPP

Creates a universal procedure pointer to an accept-drag callback function.

DataBrowserAcceptDragUPP NewDataBrowserAcceptDragUPP (
   DataBrowserAcceptDragProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your accept-drag callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserAcceptDragProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserAcceptDragUPP NewDataBrowserAcceptDragUPP (
   DataBrowserAcceptDragProcPtr userRoutine
){
printf ("NewDataBrowserAcceptDragUPP",userRoutine);
};


/*NewDataBrowserReceiveDragUPP

Creates a universal procedure pointer to a receive-drag callback function.

DataBrowserReceiveDragUPP NewDataBrowserReceiveDragUPP (
   DataBrowserReceiveDragProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your receive-drag callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserReceiveDragProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserReceiveDragUPP NewDataBrowserReceiveDragUPP (
   DataBrowserReceiveDragProcPtr userRoutine
){
printf ("NewDataBrowserReceiveDragUPP",userRoutine);
};



/*NewDataBrowserAddDragItemUPP

Creates a universal procedure pointer to an add-drag-item callback function.

DataBrowserAddDragItemUPP NewDataBrowserAddDragItemUPP (
   DataBrowserAddDragItemProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your add-drag-item callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserAddDragItemProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

DataBrowserAddDragItemUPP NewDataBrowserAddDragItemUPP (
   DataBrowserAddDragItemProcPtr userRoutine
){
printf ("NewDataBrowserAddDragItemUPP",userRoutine);
};

/*NewDataBrowserItemHelpContentUPP

Creates a universal procedure pointer to an item-help-content callback function.

DataBrowserItemHelpContentUPP NewDataBrowserItemHelpContentUPP (
   DataBrowserItemHelpContentProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-help-content callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemHelpContentProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemHelpContentUPP NewDataBrowserItemHelpContentUPP (
   DataBrowserItemHelpContentProcPtr userRoutine
){
printf ("NewDataBrowserItemHelpContentUPP",userRoutine);
};

/*Creates a universal procedure pointer to a get-contextual-menu callback function.

DataBrowserGetContextualMenuUPP NewDataBrowserGetContextualMenuUPP  (
   DataBrowserGetContextualMenuProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your get-contextual-menu callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserGetContextualMenuProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

DataBrowserGetContextualMenuUPP NewDataBrowserGetContextualMenuUPP  (
   DataBrowserGetContextualMenuProcPtr userRoutine
){
printf ("NewDataBrowserGetContextualMenuUPP",userRoutine);
};


/*SetDataBrowserTarget

Sets the target for a data browser.

OSStatus SetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID target
);
Parameters
browser

A data browser. 
target

The item ID to assign as the target for the browser control. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application can set an item ID to use as a target if you do not want to use the default target set by the data browser. By default, the target is a container whose ID is kDataBrowserNoItem. For the list view, the target can be thought of as the root container. For the column view, the target is the rightmost column. When an item is dragged over a data browser but not dropped over any particular item, the target becomes the destination.

SetDataBrowserTarget changes the container that the data browser displays, thereby populating the data browser with items. If you use the function in column view, you must make sure your item-data callback responds to the property kDataBrowserItemParentContainerProperty by providing the item ID of the target’s parent. This allows the function SetDataBrowserColumnViewPath to process the data properly. The target is the leaf node item whose contents you want to display. However, unlike GetDataBrowserColumnViewPathLength, the function SetDataBrowserTarget doesn’t offer a way for you to communicate the item IDs of the rest of the column containers, so SetDataBrowserTarget asks for them explicitly by requesting the item’s parent, then the parent of the item’s parent, and so on.

You can pass a noncontainer item to this function in either list or column views. If you do, you must also respond to the property kDataBrowserItemParentContainerProperty. The data browser requests the parent of the target so it knows which container to display the contents of in the list view. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID target
){
printf ("SetDataBrowserTarget",browser,target);
};

/*GetDataBrowserActiveItems

Obtains what determines the active state of the items in a data browser.

OSStatus GetDataBrowserActiveItems (
   ControlRef browser,
   Boolean *active
);
Parameters
browser

A data browser. 
active

On input, a pointer to a Boolean variable. On return, the variable is set to true if the active state of each item in the list is determined by the item property kDataBrowserItemIsActiveProperty. Otherwise, the variable is set to false to indicate that all items are inactive.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserActiveItems (
   ControlRef browser,
   Boolean *active
){
printf ("GetDataBrowserActiveItems",browser,*active);
};

/*GetDataBrowserHasScrollBars

Obtains the display state of horizontal and vertical scroll bars for a list view data browser.

OSStatus GetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean *horiz,
   Boolean *vert
);
Parameters
browser

A list view data browser. 
horiz

On input, a pointer to a Boolean variable. On return, the variable is set to true if the browser control has a horizontal scroll bar. 
vert

On input, a pointer to a Boolean variable. On return, the variable is set to true if the browser control has a vertical scroll bar.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

The function GetDataBrowserHasScrollBars is useful for determining if the browser control currently has scroll bars. For example, you would call the function AutoSizeDataBrowserListViewColumns only after you have determined the data browser does not have a horizontal scroll bar.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean *horiz,
   Boolean *vert
){
printf ("GetDataBrowserHasScrollBars",browser,*horiz,*vert);
};

/*GetDataBrowserTableViewGeometry

Determines whether columns and rows are set to have variable widths.

OSStatus GetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean *variableWidthColumns,
   Boolean *variableHeightRows
);
Parameters
browser

A data browser. 
variableWidthColumns

On input, a pointer to a Boolean variable. On return, the variable is set to true if column widths can be changed or false if they cannot be changed.
variableHeightRows

On input, a pointer to a Boolean variable. On return, the variable is set to true if row heights can be changed or false if they cannot be changed. 
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean *variableWidthColumns,
   Boolean *variableHeightRows
){
printf ("GetDataBrowserTableViewGeometry",browser,*variableWidthColumns,*variableHeightRows);
};

/*GetDataBrowserListViewDisclosureColumn

Obtains the property ID of the column whose items can display a disclosure triangle, and tells whether a disclosed item expands the row or adds rows.

OSStatus GetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID *column,
   Boolean *expandableRows
);
Parameters
browser

A data browser. 
column

On input, a pointer to a column ID variable. On return, the variable is set to the property ID of the currently selected column. If there is no disclosure column, the variable is set to kDataBrowserItemNoProperty. The DataBrowserTableViewColumnID data type is the same as the DataBrowserPropertyID data type.
expandableRows

On input, a pointer to a Boolean variable. On return, the variable specifies how a disclosed row behaves. The value true means that a container opens as a single row with an expanded height. The value false means a container opens to expose individual rows. See the Discussion for more details on expandable rows.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

When the expandableRows variable is set to true:
Disclosure triangles are drawn top-justified in the row. 
Custom row height, if any, for that row is respected only while the row is disclosed. At other times, the default row height is used.

When the expandableRows variable is set to false:
Disclosure triangles are centered vertically in the row.
Custom row height, if any, for that row is always respected.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID *column,
   Boolean *expandableRows
){
printf ("GetDataBrowserListViewDisclosureColumn",browser,*column,*expandableRows);
};

/*GetDataBrowserPropertyFlags

Obtains the appearance and behavior attributes for a column.

OSStatus GetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags *flags
);
Parameters
browser

A data browser. 
property

The property ID of the column whose properties you want to obtain.
flags

On input, a data browser property flags variable. On return, the variable is set to the property flags that specify the appearance and behavior attributes for a column. A DataBrowserPropertyFlags value is a 32-bit value that is divided into four parts as follows: 
Bits 0–7 specify properties applied to the data browser as a whole—see “Property Flags: Universal”
Bits 8–15 modify display behavior—see “Property Flags: Modifiers”
Bits 16–23 are properties specific to list view—see “Property Flags: Offset and Mask for List View Properties” and “Property Flags: List View Column Behavior”
Bits 24–31 can be defined by your application—see “Property Flags: Offset and Mask for Client-Defined Properties”
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags *flags
){
printf ("GetDataBrowserPropertyFlags",browser,property,*flags);
};


/*GetDataBrowserTableViewHiliteStyle

Obtains the highlighting style used for a list view data browser.

OSStatus GetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle *hiliteStyle
);
Parameters
browser

A list view data browser. 
hiliteStyle

On input, a pointer to a highlighting style variable. On return, the variable is set to the highlighting style in use. See “Table View Highlighting Styles” for a description of the values that can be returned.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle *hiliteStyle
){
printf ("GetDataBrowserTableViewHiliteStyle",browser,*hiliteStyle);
};


/*GetDataBrowserListViewHeaderBtnHeight

Obtains the height of the rectangular area where the column title appears.

OSStatus GetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 *height
);
Parameters
browser

A data browser. 
height

On input, a pointer to an unsigned 16-bit integer. On return, this value is set to the height of the rectangular area where the column title appears. You can save this value if you plan to call the function SetDataBrowserListViewHeaderBtnHeight to turn off header button display. You can then use the value later to turn on header button display.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 *height
){
printf ("GetDataBrowserListViewHeaderBtnHeight",browser,*height);
};

/*NewDataBrowserItemDataUPP

Creates a universal procedure pointer to an item-data callback function.

DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-data callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemDataProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine){
printf ("NewDataBrowserItemDataUPP",userRoutine);
};


/*InitDataBrowserCallbacks

Initializes a data browser callback structure in preparation for adding your own callbacks to the structure.

OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks
);
Parameters
callbacks

A pointer to a DataBrowserCallbacks structure. Before calling the function InitDataBrowserCallbacks, set the version field of this structure to kDataBrowserLatestCallbacks. On return, the fields in this structure are set to NULL.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

After you call this function, set the appropriate fields in the DataBrowserCallbacks structure to your callbacks. The DataBrowserCallbacks structure contains fields for the following:
DataBrowserItemDataProcPtr
DataBrowserItemCompareProcPtr
DataBrowserItemNotificationProcPtr or DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr
DataBrowserAcceptDragProcPtr
DataBrowserReceiveDragProcPtr
DataBrowserPostProcessDragProcPtr
DataBrowserGetContextualMenuProcPtr
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr

After you assign your callbacks to the appropriate field, call the function SetDataBrowserCallbacks.

Note that this is a different set of callbacks from those that are assigned to fields in the DataBrowserCustomCallbacks data structure.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks){
printf ("InitDataBrowserCallbacks",*callbacks);
};


/*IsDataBrowserItemSelected

Checks to see if a data item is selected.

Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item
);
Parameters
browser

A data browser.
item

The item ID of the item to check.
Return Value

A value of true if the item is a member of the current selection. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item){
printf ("IsDataBrowserItemSelected",browser,item);
};


/*SetDataBrowserItemDataText

Specifies the text to draw.

OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData
);
Parameters
itemData

The item data reference for the item whose text you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataText. 
theData

The CFString object that contains the text you want to draw. You are responsible for releasing the CFString object.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

You call the function SetDataBrowserItemDataText from inside a data callback routine when the item being drawn is inside a column that has the kDataBrowserTextType display type or the kDataBrowserIconAndTextType display type. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData){
printf ("SetDataBrowserItemDataText",itemData,theData);
};

/*(NewControlUserPaneIdleUPP

ControlUserPaneIdleUPP NewControlUserPaneIdleUPP (
   ControlUserPaneIdleProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneIdleUPP NewControlUserPaneIdleUPP (
   ControlUserPaneIdleProcPtr userRoutine
){
printf ("NewControlUserPaneIdleUPP",userRoutine);
};

/*GetDataBrowserViewStyle

Obtains the current view style for the specified data browser.

OSStatus GetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle *style
);
Parameters
browser

A data browser. 
style

On input, a pointer to a view style variable. On return, the variable is set to the current view style for the specified data browser; can be either list view (kDataBrowserListView) or column view (kDataBrowserColumnView). See “View Styles” for more information on these constants.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle *style
){
printf ("GetDataBrowserViewStyle",browser,*style);
};

/*SetDataBrowserItemDataBooleanValue

Specifies a Boolean value for an item.

OSStatus SetDataBrowserItemDataBooleanValue (
   DataBrowserItemDataRef itemData,
   Boolean theData
);
Parameters
itemData

The item data reference for the item whose Boolean value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataBooleanValue. 
theData

The value to display.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your item-data callback calls this function in response to an inquiry for the following properties:
kDataBrowserItemIsActiveProperty
kDataBrowserItemIsSelectableProperty
kDataBrowserItemIsEditableProperty
kDataBrowserItemIsContainerProperty
kDataBrowserItemIsOpenableProperty
kDataBrowserItemIsClosableProperty
kDataBrowserItemIsSortableProperty
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataBooleanValue (
   DataBrowserItemDataRef itemData,
   Boolean theData
){
printf ("SetDataBrowserItemDataBooleanValue",itemData,theData);
};

/*CreateLittleArrowsControl

Creates a little arrows control.

OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value the control can have.
maximum

The maximum value the control can have.
increment

The amount to increment each time an arrow is clicked.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements the little up and down arrows seen in the Date & Time system preferences panel. To change the value of this control, you need to create a control action proc. The following sample code creates the control and sets the action proc:CreateLittleArrowsControl(&rect, minimum, maximum, increment,  value);
SetControlAction(Arrows, LittleArrowActionProc);


Here is sample code for the action proc:void LittleArrowActionProc(ControlRef cref, ControlPartCode part)  {
    SInt32 val = GetControl32BitValue(cref);
    SInt32 s = 0;
    GetControlData(MWArrows, 0, kControlLittleArrowsIncrementValueTag,  sizeof(SInt32), &s, nil;
    switch (part) {
        case kControlUpButtonPart:
            SetControl32BitValue(cref, val+s);
            break;
        case kControlDownButtonPart:
            SetControl32BitValue(cref, val-s);
            break;
        };
    };

Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl){
printf ("CreateLittleArrowsControl",window,*boundsRect,value,minimum,maximum,increment,*outControl);
};


/*CreateScrollingTextBoxControl

Creates a scrolling text box control.

OSStatus CreateScrollingTextBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt16 contentResID,
   Boolean autoScroll,
   UInt32 delayBeforeAutoScroll,
   UInt32 delayBetweenAutoScroll,
   UInt16 autoScrollAmount,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
contentResID

The resource ID of ‘TEXT’ and (optionally) ‘style’ resources whose contents are to be displayed. 
autoScroll

A Boolean whose value is true to enable automatic scrolling; otherwise, false.
delayBeforeAutoScroll

The number of ticks to wait before scrolling automatically. This parameter is ignored and can be set to 0 if the value of the autoScroll parameter is false. 
delayBetweenAutoScroll

The number of ticks to wait between automatic scrolls. This parameter is ignored and can be set to 0 if the value of the autoScroll parameter is false.
autoScrollAmount

The number of pixels to scroll. This parameter is ignored and can be set to 0 if the value of the autoScroll parameter is false.
outControl

On return, outControl points to the newly-created control. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements a scrolling box of text that cannot be edited. This is useful for credits in about boxes.

The standard version of this control has a scroll bar, but the autoscrolling variant does not. The autoscrolling variant needs two pieces of information to work: delay (in ticks) before the scrolling starts, and time (in ticks) between scrolls. This control scrolls one pixel at a time if created by NewControl, unless changed by calling SetControlData.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateScrollingTextBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt16 contentResID,
   Boolean autoScroll,
   UInt32 delayBeforeAutoScroll,
   UInt32 delayBetweenAutoScroll,
   UInt16 autoScrollAmount,
   ControlRef * outControl
){
printf ("CreateScrollingTextBoxControl",window,*boundsRect,contentResID,autoScroll,delayBeforeAutoScroll,delayBetweenAutoScroll,autoScrollAmount,*outControl);
};



/*CreateEditTextControl

Creates a new edit text control. (Deprecated in Mac OS X v10.4. Use CreateEditUnicodeTextControl instead.)

OSStatus CreateEditTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   Boolean useInlineInput,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. May be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
isPassword

A Boolean indicating whether the field is to be used as a password field. Passing false indicates that the field is to display entered text normally. Passing true means that the field is to be used as a password field; any text typed into the field is displayed as bullets.
useInlineInput

A Boolean indicating whether the control is to accept inline input. Pass true to accept inline input; otherwise pass false.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Deprecated in Mac OS X v10.4; use CreateEditUnicodeTextControl instead.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
ControlDefinitions.h*/
OSStatus CreateEditTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   Boolean useInlineInput,
   const ControlFontStyleRec * style,
   ControlRef * outControl
){
printf ("CreateEditTextControll",window,*boundsRect,text,isPassword,useInlineInput,*style,*outControl);
};


/*SetDataBrowserCallbacks

Sets the callback routines to use with a data browser, replacing any previously installed callbacks.

OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks
);
Parameters
browser

A data browser.
callbacks

A pointer to a DataBrowserCallbacks structure that is filled out with universal procedure pointers (UPPs) to the callback routines your application provides. At a minimum, you need to provide a UPP to an item-data callback (DataBrowserItemDataProcPtr).
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling the function SetDataBrowserCallbacks you must first call InitDataBrowserCallbacks to initialize the data browser callback structure. Calling SetDataBrowserCallbacks replaces any callback routines you installed previously by calling this function.

You can supply the following callbacks. If you don’t supply callbacks in cases for which it’s optional, you get the default behavior provided by the data browser API.
DataBrowserItemDataProcPtr. You must provide this callback because communicates the text, icons, or other data to display in list view. It also communicates the metadata that defines how data is displayed, such as whether or not an item is a container or has a parent. If you set up your data browser to allow the user to edit, this callback informs your application when the user makes a change.
DataBrowserItemCompareProcPtr. You must provide a sorting callback if you want users to be able to sort the items in a column. If you want containers in a hierarchical list to be sorted independently, then you must provide a sorting callback that handles the hierarchical lists appropriately.
DataBrowserItemNotificationProcPtr. You must provide this (or the next) callback if you have hierarchical data in a list, or if you use column view.
DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr. You can provide this callback to allow dragging out of your data browser. 
DataBrowserAcceptDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to accept a drag item.
DataBrowserReceiveDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to receive a drag item.
DataBrowserPostProcessDragProcPtr. If you provide callbacks to allow dragging into your data browser, you can optionally provide a postprocess-drag callback to perform cleanup tasks.
DataBrowserGetContextualMenuProcPtr. You can optionally support a contextual menu. If so, you’ll need to provide the next callback too.
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr. You can optionally provide help tags.

Note that this function sets a different set of callbacks from those that are set by calling the function SetDataBrowserCustomCallbacks.

To replace a callback, you first need to get the current set of callbacks by calling the function GetDataBrowserCallbacks. Set the appropriate fields in the DataBrowserCallbacks structure to your callback. Then you call the function SetDataBrowserCallbacks. Your application can set as many callbacks as appropriate. 

The following code shows how to assign UPPs to the callbacks structure and then call the function SetDataBrowserCallbacks. The code assumes you have already called the function InitDataBrowserCallbacks to initialize the data browser callback structure.myCallbacks.u.v1.itemNotificationCallback =
        NewDataBrowserItemNotificationUPP (MyItemNotificationCallback);
 
myCallbacks.u.v1.acceptDragCallback =
        NewDataBrowserAcceptDragUPP (MyAcceptDragCallback);
myCallbacks.u.v1.receiveDragCallback =
        NewDataBrowserReceiveDragUPP (MyReceiveDragCallback);
myCallbacks.u.v1.addDragItemCallback =
        NewDataBrowserAddDragItemUPP (MyAddDragItemCallback);
myCallbacks.u.v1.itemHelpContentCallback =
        NewDataBrowserItemHelpContentUPP (MyItemHelpContentCallback);
myCallbacks.u.v1.getContextualMenuCallback =
        NewDataBrowserGetContextualMenuUPP (MyGetContextualMenuCallback);
myCallbacks.u.v1.selectContextualMenuCallback =
        NewDataBrowserSelectContextualMenuUPP (
                    MySelectContextualMenuCallback);
SetDataBrowserCallbacks (browser, &myCallbacks);

Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks){
printf ("SetDataBrowserCallbacks",browser,*callbacks);
};


/*AddDataBrowserItems

Adds one or more items to a data browser. 

OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container to which you want to add items. Adding one or more items to an existing container opens the container. If you a pass kDataBrowserNoItem, the items are added to the root container.
numItems

The number of items in the array pointed to by the items parameter.
items

A pointer to an array of item ID values for the items you want to add to the data browser. You supply item ID values based on your own identification scheme. If you pass NULL, each time you call AddDataBrowserItems the data browser generates item ID values starting at 1. Calling the function in this way clears whatever items are in the container. Because of this clearing behavior, passing NULL is not recommended unless your application uses a data browser to display a simple list that is populated only once with data.
preSortProperty

The property ID of the column whose sorting order matches the sorting order of the items array. A property ID is a four-character sequence that you assign to represent a column in list view. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order of your data. You’ll get the best performance from this function if you provide a sorting order. 
Return Value

A result code. If the item ID specified by the container parameter is not classified as a container, returns errDataBrowserItemNotAdded if you attempt to add subitems to it. See “Data Browser Result Codes”.
Discussion

Hierarchical lists are constructed in a top-down fashion. Your application must install all the top-level, or parent, item IDs in the data browser before it associates a list of item ID values as subitems. You can add items to a parent item only after the parent item is classified as a container. A container is an item for which the property kDataBrowserItemIsContainerProperty is set to true. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty){
printf ("AddDataBrowserListViewColumn",browser,container,numItems,*items,preSortProperty);
};


/*CreatePopupButtonControl

Creates a pop-up button control.

OSStatus CreatePopupButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt16 menuID,
   Boolean variableWidth,
   SInt16 titleWidth,
   SInt16 titleJustification,
   Style titleStyle,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The title of the control.
menuID

The ID of a menu that should be used by the control. A menu with this ID should be inserted into the menubar with InsertMenu(menu, kInsertHierarchicalMenu). You can also pass -12345 to have the control delay its acquisition of a menu; in this case, you can build the menu and later provide it to the control with SetControlData and kControlPopupButtonMenuRefTag or kControlPopupButtonOwnedMenuRefTag.
variableWidth

A Boolean whose value indicates whether the width of the control is allowed to vary according to the width of the selected menu item text (true), or should remain fixed to the original control bounds width (false).
titleWidth

The width of the title.
titleJustification

The justification of the title. Use a TextEdit justification constant (teFlushDefault, teCenter, teFlushRight, or teFlushLeft).
titleStyle

A QuickDraw style bitfield indicating the font style of the title.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreatePopupButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt16 menuID,
   Boolean variableWidth,
   SInt16 titleWidth,
   SInt16 titleJustification,
   Style titleStyle,
   ControlRef * outControl
){
printf ("CreatePushButtonControl",window,*boundsRect,title,menuID,variableWidth,titleWidth,titleJustification,titleStyle,*outControl);
};



/*RemoveDataBrowserItems

Removes one or more items from a data browser.

OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container from which you want to remove items. Pass kDataBrowserNoItem to remove items from the root container.
numItems

The number of items in the array pointed to by the items parameter. To remove all items pass 0 and also pass NULL in the items parameter.
items

A pointer to an array of item ID values for the items you want to remove from the data browser. You can delete an arbitrary list of items from a container. To remove all items, pass NULL, and also pass 0 in the numItems parameter. 
preSortProperty

The property ID of the column whose sorting order is the same as the sorting order of the items array. A property ID is a value that identifies a column independent of its position in a data browser. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order. You’ll get the best performance from this function if you provide a sorting order.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty){
printf ("RemoveDataBrowserItems",browser,container,numItems,*items,preSortProperty);
};

//work

/*CreateCheckBoxControl

Creates a checkbox control.

OSStatus CreateCheckBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt32 initialValue,
   Boolean autoToggle,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the checkbox control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the desired checkbox in the window’s local coordinates.
title

The title of the checkbox.
initialValue

The initial setting of the checkbox. Set to a non-zero value to indicate the checked state. 
autoToggle

If set to true, clicking the checkbox will automatically toggle its state (checked or unchecked).
outControl

On return, outControl points to the new checkbox. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateCheckBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt32 initialValue,
   Boolean autoToggle,
   ControlRef * outControl
){};



/*CreateScrollBarControl

Creates a scroll bar control.

OSStatus CreateScrollBarControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 viewSize,
   Boolean liveTracking,
   ControlActionUPP liveTrackingProc,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value of the control.
maximum

The maximum value of the control.
viewSize

The size of the visible area of the scroll bar content. If this parameter is a non-zero value, this function creates a proportional scroll bar thumb; a value of 0 causes a non-proportional scroll bar thumb to be created.
liveTracking

A Boolean indicating whether or not live tracking is enabled for this scroll bar. If set to true and a valid liveTrackingProc is also passed in, the callback is called repeatedly as the thumb is moved during tracking. If set to false, a semi-transparent thumb called a “ghost thumb” draws and no live tracking occurs.
liveTrackingProc

If the value of the liveTracking parameter is true, a ControlActionUPP callback is to be called as the control live tracks. This callback is called repeatedly as the scroll thumb is moved during tracking.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateScrollBarControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 viewSize,
   Boolean liveTracking,
   ControlActionUPP liveTrackingProc,
   ControlRef * outControl
){};


/*CreateProgressBarControl

Creates a progress bar control.

OSStatus CreateProgressBarControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   Boolean indeterminate,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value of the control.
maximum

The maximum value of the control.
indeterminate

A Boolean whose value is true if you want the control to display a rotating barber pole effect to indicate that something is happening (an indeterminate progress bar) or false if you want to display a determinate progress bar that uses the values of the minimum and maximum parameters to show progress from minimum to maximum. 
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateProgressBarControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   Boolean indeterminate,
   ControlRef * outControl
){};


/*OpenDataBrowserContainer

Opens a data browser container.

OSStatus OpenDataBrowserContainer (
   ControlRef browser,
   DataBrowserItemID container
);
Parameters
browser

A data browser. 
container

The item ID of the container to open.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Normally the user navigates through a data hierarchy by clicking the disclosure triangle next to a container item in list view, or the container item (such as a folder icon) in column view. In either of these cases, the system automatically opens or closes the container. Under some circumstances your application may need to open or close a container programmatically, such as when you are restoring a display to its last known state. In such cases, you can call the function OpenDataBrowserContainer to disclose items in a container or the function CloseDataBrowserContainer to hide items in a container. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus OpenDataBrowserContainer (
   ControlRef browser,
   DataBrowserItemID container
){};


/*SetDataBrowserScrollPosition

Scrolls a list to the specified position.

OSStatus SetDataBrowserScrollPosition (
   ControlRef browser,
   UInt32 top,
   UInt32 left
);
Parameters
browser

A data browser. 
top

The vertical scrolling position to use.
left

The horizontal scrolling position to use.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

The scrolling position (0,0) represents the home position, and is located at the top left of the data browser. Horizontal and vertical units are relative to the home position.

You can call this function to scroll a list to any arbitrary scrolling position. Normally, you use the function GetDataBrowserScrollPosition in conjunction with SetDataBrowserScrollPosition to save and restore the scrolling position of a list to the user’s last scrolling position. These functions should not be used to scroll particular cells into the view. For that, call the function RevealDataBrowserItem.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserScrollPosition (
   ControlRef browser,
   UInt32 top,
   UInt32 left
){};


/*GetDataBrowserScrollBarInset

Obtains the inset rectangle used by a data browser to position the scroll bar.

OSStatus GetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
);
Parameters
browser

A data browser.
insetRect

On input, a pointer to a rectangle structure. On return, the rectangle contains the current inset settings for the data browser scroll bars. The left and right fields contain the horizontal inset values for the horizontal scroll bar, and the top and bottom fields contain the vertical inset values for the vertical scroll bar. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application can call the functions GetDataBrowserScrollBarInset and SetDataBrowserScrollBarInset if you want to place placards or controls beside the horizontal scroll bars or above the vertical ones. To do so, first call GetDataBrowserScrollBarInset to obtain the current settings. After modifying the current inset settings to provide space for the placard or control, call SetDataBrowserScrollBarInset with the new values.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
){};


/*SetDataBrowserHasScrollBars

Sets the display state of horizontal and vertical scroll bars for a list view data browser. 

OSStatus SetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean horiz,
   Boolean vert
);
Parameters
browser

A list view data browser. 
horiz

A value that specifies whether to display the browser control with (true) or without (false) a horizontal scroll bar. 
vert

A value that specifies whether to display the browser control with (true) or without (false) a vertical scroll bar. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

If the list your application displays is small and its coordinates do not extend beyond the bounds of the area used to display the list, then you can call SetDataBrowserHasScrollBars to turn off the display of scroll bars. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean horiz,
   Boolean vert
){};

/*SetDataBrowserTableViewHiliteStyle

Sets the highlighting style to use for a list view data browser.

OSStatus SetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle hiliteStyle
);
Parameters
browser

A list view data browser. 
hiliteStyle

The highlighting style you want to use. See “Table View Highlighting Styles” for a description of the constants you can supply.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle hiliteStyle
){};


/*SetDataBrowserPropertyFlags

Sets the appearance and behavior attributes for a column in list view.

OSStatus SetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags flags
);
Parameters
browser

A data browser. 
property

The property ID of the column whose appearance and behavior you want to set.
flags

The property flags to apply. A DataBrowserPropertyFlags value is a 32-bit value that is divided into four parts as follows: 
Bits 0–7 specify properties applied to the data browser as a whole—see “Property Flags: Universal”
Bits 8–15 modify display behavior—see “Property Flags: Modifiers”
Bits 16–23 are properties specific to list view—see “Property Flags: Offset and Mask for List View Properties” and “Property Flags: List View Column Behavior”
Bits 24–31 can be defined by your application—see “Property Flags: Offset and Mask for Client-Defined Properties”
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags flags
){};



/*SetDataBrowserListViewDisclosureColumn

Specifies whether there is a column that has disclosure triangles and, if so, which column.

OSStatus SetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID column,
   Boolean expandableRows
);
Parameters
browser

A data browser. 
column

The property ID for the column for which you want to set as disclosure column. Only one column in list view can be designated as a disclosure column. Pass kDataBrowserNoItemProperty if you do not want a disclosure column. The DataBrowserTableViewColumnID data type is the same as the DataBrowserPropertyID data type.
expandableRows

A value that specifies how a disclosed row behaves. Pass true to have a container open as a single row with an expanded height. Pass false to have a container opens to expose other rows. See the Discussion for more details on expandable rows.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

A disclosure triangle next to an item denotes the item is a container. You can use the expandableRows parameter to specify whether an opened container displays its items in individual rows, as shown in the top of Figure 1 or increases its row height to accommodate the contained information, as shown in the bottom of the figure.


Figure 1  A container can open to more rows or expand to show more information



When the expandableRows parameter is set to true:
Disclosure triangles are drawn top-justified in the row. 
Custom row height, if any, for that row is respected only while the row is disclosed. At other times, the default row height is used.

When the expandableRows parameter is set to false:
Disclosure triangles are centered vertically in the row.
Custom row height, if any, for that row is always respected.

When a disclosure triangle is clicked by the user, your application receives the same notifications regardless of whether expandableRows is set to true or false. When your application receives a notification that an expandable row is toggled to open, call the function SetDataBrowserTableViewItemRowHeight to set the row to the appropriate height.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID column,
   Boolean expandableRows
){};


/*GetDataBrowserListViewUsePlainBackground

Determines whether list view is set to use a plain white background.

OSStatus GetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean *usePlainBackground
);
Parameters
browser

A data browser. 
usePlainBackground

On input, a pointer to a Boolean variable. On return, the variable is true if list view is set to use a plain white background. Regardless of the value that is returned, Mac OS X supports only a plain white background. Mac OS 9 supports a plain white background as well as a shaded background. 
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean *usePlainBackground
){};


/*NewControlUserPaneDrawUPP

ControlUserPaneDrawUPP NewControlUserPaneDrawUPP (
   ControlUserPaneDrawProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneDrawUPP NewControlUserPaneDrawUPP (
   ControlUserPaneDrawProcPtr userRoutine
){};



/*SetDataBrowserTableViewGeometry

Sets whether columns and rows can have variable widths in list view.

OSStatus SetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean variableWidthColumns,
   Boolean variableHeightRows
);
Parameters
browser

A data browser. 
variableWidthColumns

A Boolean value that specifies whether column widths can be variable (true) or not (false).
variableHeightRows

A Boolean value that specifies whether row heights can be variable (true) or not (false).
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

After you call the function SetDataBrowserTableViewGeometry to set up variable row heights or columns widths in list view, you can modify individual row heights or columns widths in list view by calling the appropriate function—either SetDataBrowserTableViewItemRowHeight or SetDataBrowserTableViewNamedColumnWidth. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean variableWidthColumns,
   Boolean variableHeightRows
){};


/*SetDataBrowserActiveItems

Sets what determines the active state of the items in a data browser.

OSStatus SetDataBrowserActiveItems (
   ControlRef browser,
   Boolean active
);
Parameters
browser

A data browser. 
active

A value that specifies the new active state for the items displayed in the list. Pass true to make the active state of each item determined by what your callback reports for each item’s kDataBrowserItemIsActiveProperty property, or false to make all items inactive. Inactive items appear dimmed.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Passing true for the active parameter does not make all the items active. Instead it sets the active state of each individual item according to the value associated with the kDataBrowserItemIsActiveProperty property for that item. This means if the active property for an item is set to false, and you pass true for the active parameter, then the item is inactive.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserActiveItems (
   ControlRef browser,
   Boolean active
){};



/*SetDataBrowserScrollBarInset

Sets the inset values to use for the scroll bars of a data browser.

OSStatus SetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
);
Parameters
browser

A data browser. 
insetRect

A pointer to a rectangle that specifies the inset values you want the data browser to use. The left and right fields contain the horizontal inset values for the horizontal scroll bar, and the top and bottom fields contain the vertical inset values for the vertical scroll bar.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application can call the functions GetDataBrowserScrollBarInset and SetDataBrowserScrollBarInset if you want to place placards or controls beside the horizontal scroll bars or above the vertical ones. To do so, first call GetDataBrowserScrollBarInset to obtain the current settings. After modifying the current inset settings to provide space for the placard or control, call SetDataBrowserScrollBarInset with the new values.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
){};


/*NewControlUserPaneFocusUPP

ControlUserPaneFocusUPP NewControlUserPaneFocusUPP (
   ControlUserPaneFocusProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneFocusUPP NewControlUserPaneFocusUPP (
   ControlUserPaneFocusProcPtr userRoutine
){};


/*NewControlUserPaneActivateUPP

ControlUserPaneActivateUPP NewControlUserPaneActivateUPP (
   ControlUserPaneActivateProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneActivateUPP NewControlUserPaneActivateUPP (
   ControlUserPaneActivateProcPtr userRoutine
){};



/*NewControlUserPaneKeyDownUPP

ControlUserPaneKeyDownUPP NewControlUserPaneKeyDownUPP (
   ControlUserPaneKeyDownProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneKeyDownUPP NewControlUserPaneKeyDownUPP (
   ControlUserPaneKeyDownProcPtr userRoutine
){};


/*NewControlUserPaneTrackingUPP

ControlUserPaneTrackingUPP NewControlUserPaneTrackingUPP (
   ControlUserPaneTrackingProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneTrackingUPP NewControlUserPaneTrackingUPP (
   ControlUserPaneTrackingProcPtr userRoutine
){};



/*NewControlUserPaneHitTestUPP

ControlUserPaneHitTestUPP NewControlUserPaneHitTestUPP (
   ControlUserPaneHitTestProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneHitTestUPP NewControlUserPaneHitTestUPP (
   ControlUserPaneHitTestProcPtr userRoutine
){};



/*SetDataBrowserListViewUsePlainBackground

Specifies whether list view uses a plain white background.

OSStatus SetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean usePlainBackground
);
Parameters
browser

A data browser. 
usePlainBackground

A value that specifies whether to use a plain background (true) or not to use a plain background (false). A plain background is an all-white background. In Mac OS X, passing false currently does nothing, as Mac OS X supports only a plain white background. However, pass true if you want a plain white background just in case the API changes in the future. In Mac OS 9, passing false causes the data browser to use a shaded background. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

A list view that does not use a plain background can use colors or patterns to distinguish one column from another. For example, you could specify a color to designate a column as the sorted column.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean usePlainBackground
){};


/*SetDataBrowserSelectionFlags

Sets allowable selection behavior for a data browser.

OSStatus SetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags selectionFlags
);
Parameters
browser

A data browser.
selectionFlags

Flags that specify the selection behavior you want to allow in the data browser. The flags control such things as whether discontinuous selections are allowed by the user. See “User Selection Flags” for detailed descriptions of these flags.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags selectionFlags
){};

/*SetDataBrowserViewStyle

Sets the view style of the specified data browser.

OSStatus SetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle style
);
Parameters
browser

A data browser. 
style

The view style to use. Pass the constant kDataBrowserListView to draw the data browser using list view or kDataBrowserColumnView to use column view. See “View Styles” for more information on these constants.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Although you specify a view style when you call the function CreateDataBrowserControl, you can call SetDataBrowserViewStyle to change the style. Use SetDataBrowserViewStyle when you provide users the option of changing between list and column views.

After calling SetDataBrowserViewStyle, you need to perform the necessary tasks to configure the data browser for the view style you switched to. If you switch to list view, you need to set up list view header and column descriptions and call the function AddDataBrowserListViewColumn. You might also need to call other functions such as SetDataBrowserListViewDisclosureColumn (for hierarchical lists).
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle style
){};

/*GetDataBrowserSelectionFlags

Obtains the current selection behavior for a data browser.

OSStatus GetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags *selectionFlags
);
Parameters
browser

A data browser. 
selectionFlags

On input, a data browser selection flags variable. On return, the variable is set to the current selection flags. See “User Selection Flags” for a list of the flags that can be returned. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Selection flags specify the selection behavior available to the user, such as whether the user can select discontinuous items.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags *selectionFlags
){};


/*SetDataBrowserCustomCallbacks

Sets the custom callback routines to use with a data browser, replacing any previously installed custom callbacks.

OSStatus SetDataBrowserCustomCallbacks (
   ControlRef browser,
   const DataBrowserCustomCallbacks *callbacks
);
Parameters
browser

A data browser. 
callbacks

A pointer to a DataBrowserCustomCallbacks structure that is filled out with universal procedure pointers (UPPs) to the custom callback routines your application provides.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling the function SetDataBrowserCustomCallbacks you must first call InitDataBrowserCustomCallbacks to initialize the data browser custom callback structure. Calling SetDataBrowserCustomCallbacks replaces any callback routines you installed previously by calling this function.

You can supply the following custom callback routines. 
DataBrowserDrawItemProcPtr. This callback is invoked by the data browser whenever your content needs to be drawn. You must supply this callback for data whose display type is kDataBrowserCustomType.
DataBrowserEditItemProcPtr. Supply this callback when you want to support editing of your content.
DataBrowserHitTestProcPtr. You can provide this callback to determine if the pointer is over content that can be selected or dragged.
DataBrowserTrackingProcPtr. This callback implements custom tracking behavior.
DataBrowserItemDragRgnProcPtr. You can supply this callback when you need to determine which part of an item to use to create a transparent image for a dragged item.
DataBrowserItemAcceptDragProcPtr. This callback determines if an item can accept a drag object.
DataBrowserItemReceiveDragProcPtr. This callback receives a drop over an item.

Note that this is a different set of callbacks from those that are installed by calling the function SetDataBrowserCallbacks.

To replace a callback, you first need to set the appropriate fields in the DataBrowserCustomCallbacks structure to your callbacks. Then you call the function SetDataBrowserCustomCallbacks. The following code shows how to set custom callbacks. It assumes you have already called the function InitDataBrowserCustomCallbacks to initialize the data browser custom callback structure. Your application can set as many callbacks as appropriate.myCustomCallbacks.u.v1.drawItemCallback =
        NewDataBrowserDrawItemUPP (MyDataBrowserDrawItemCallback);
myCustomCallbacks.u.v1.editItemCallback =
        NewDataBrowserEditItemUPP (MyDataBrowserEditItemCallback);
SetDataBrowserCustomCallbacks (browser,&myCustomCallbacks);

Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserCustomCallbacks (
   ControlRef browser,
   const DataBrowserCustomCallbacks *callbacks
){};



/*SetDataBrowserListViewHeaderBtnHeight

Sets the height of the rectangular area where the column title appears.

OSStatus SetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 height
);
Parameters
browser

A data browser. 
height

The height, in pixels, to use for the rectangular area where the column title appears. Pass 0 to turn off header button display. To turn on header button display, pass the value previously obtained from the function GetDataBrowserListViewHeaderBtnHeight. The default height is currently 17 pixels.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 height
){};





/*CreateBevelButtonControl

Creates a bevel button control.

OSStatus CreateBevelButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlBevelThickness thickness,
   ControlBevelButtonBehavior behavior,
   ControlButtonContentInfoPtr info,
   SInt16 menuID,
   ControlBevelButtonMenuBehavior menuBehavior,
   ControlBevelButtonMenuPlacement menuPlacement,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the desired control in the window’s local coordinates.
title

The title of the control.
thickness

The thickness of the button. For possible values, see “Control Bevel Thickness Constants”.
behavior

The behavior the button is to have. For possible values, see “Bevel Button Behavior Constants”.
info

A value of type ControlButtonContentInfoPtr for the content information.
menuID

The menu ID. This parameter may be 0 if you don’t have a menu. Icon suite, picture, color icon, and IconRef are supported on Mac OS X v10.0 through Mac OS X v10.4. Values of type CGImageRef are supported in Mac OS X v10.4.
menuBehavior

The behavior of the menu. For possible values, see “Bevel Button Menu Constant”.
menuPlacement

The placement of the menu. For possible values, see “Control Bevel Button Menu Placement Constants”.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreateBevelButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlBevelThickness thickness,
   ControlBevelButtonBehavior behavior,
   ControlButtonContentInfoPtr info,
   SInt16 menuID,
   ControlBevelButtonMenuBehavior menuBehavior,
   ControlBevelButtonMenuPlacement menuPlacement,
   ControlRef * outControl
){}




/*NewControlUserPaneBackgroundUPP

ControlUserPaneBackgroundUPP NewControlUserPaneBackgroundUPP (
   ControlUserPaneBackgroundProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneBackgroundUPP NewControlUserPaneBackgroundUPP (
   ControlUserPaneBackgroundProcPtr userRoutine
){};



/*CreateListBoxControl

Creates a list box control.

OSStatus CreateListBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   Boolean autoSize,
   SInt16 numRows,
   SInt16 numColumns,
   Boolean horizScroll,
   Boolean vertScroll,
   SInt16 cellHeight,
   SInt16 cellWidth,
   Boolean hasGrowSpace,
   const ListDefSpec * listDef,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
autoSize

A Boolean whose value is true to enable auto-sizing; otherwise, false. When auto-sizing is enabled, the control automatically resizes itself as necessary to ensure that the height of the control is an exact multiple of the cell height.
numRows

The number of rows the control is to have.
numColumns

The number of columns the control is to have.
horizScroll

A Boolean whose value is true if the control is to have a horizontal scroll bar; otherwise, false.
vertScroll

A Boolean whose value is true if the control is to have a vertical scroll bar; otherwise, false.
cellHeight

The height of cells in the control.
cellWidth

The width of cells in the control.
hasGrowSpace

A Boolean whose value is true to indicate that the control is drawn so that there is room for a size box; otherwise, false.
listDef

A pointer to the list definition function you want to associate with the new control. This parameter may be NULL if you want to use the standard list definition function, which only displays text.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The list is created with default values, and uses the standard LDEF (0) if you don’t specify a custom list definition function in the listDef parameter. You can set the LDEF to use by using kControlListBoxLDEFTag. You can change the list by getting the list handle. To get the list handle, call GetControlData and pass the kControlListBoxListHandletag constant.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateListBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   Boolean autoSize,
   SInt16 numRows,
   SInt16 numColumns,
   Boolean horizScroll,
   Boolean vertScroll,
   SInt16 cellHeight,
   SInt16 cellWidth,
   Boolean hasGrowSpace,
   const ListDefSpec * listDef,
   ControlRef * outControl
){
printf ("CreateListBoxControl",window,*boundsRect,autoSize,numRows,numColumns,horizScroll,vertScroll,cellHeight,cellWidth,hasGrowSpace,*listDef,*outControl);
};

/*CreateRadioGroupControl

Creates a radio group control.

OSStatus CreateRadioGroupControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements a radio group. It is an embedding control and can therefore only be used when a control hierarchy is established for its owning window. You should only embed radio buttons within it. As radio buttons are embedded into it, the group sets up its value, min, and max to represent the number of embedded items. The current value of the control is the index of the sub-control that is the current “on” radio button. To get the current radio button control handle, you can use the Control Manager call GetIndexedSubControl, passing in the value of the radio group. 

Note that when creating radio buttons for use in a radio group control, you should not use the auto-toggle version of the radio button. The radio group control handles toggling the radio button values itself; auto-toggle radio buttons do not work properly in a radio group control on Mac OS 9.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateRadioGroupControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlRef * outControl
){
printf ("CreateRadioGroupControl",window,*boundsRect,*outControl);
};


/*CreateRadioButtonControl

Creates a radio button control.

OSStatus CreateRadioButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt32 initialValue,
   Boolean autoToggle,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The control title. May be NULL.
initialValue

The initial value of the control. Should be 0 (off), 1 (on), or 2 (mixed). The control is automatically given a minimum value of 0 and a maximum value of 2.
autoToggle

A Boolean whose value indicates whether this control should have auto-toggle behavior. If true, the control automatically toggles between on and off states when clicked. This parameter should be false if the control is embedded into a radio group control; in that case, the radio group handles setting the correct control value in response to a click.
outControl

On return, the new control.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateRadioButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt32 initialValue,
   Boolean autoToggle,
   ControlRef * outControl
){
printf ("CreateRadioButtonControl",window,*boundsRect,title,initialValue,autoToggle,*outControl);
};

/*CreateGroupBoxControl

Creates a group box control.

OSStatus CreateGroupBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   Boolean primary,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the desired control in the window’s local coordinates.
title

The title of the control. This parameter can be NULL if you don’t want the control to have a title.
primary

A Boolean whose value is true to create a primary group box or false to create a secondary group box. Secondary group boxes are intended to be contained within primary group boxes and have a slightly different appearance.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreateGroupBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   Boolean primary,
   ControlRef * outControl
){
printf ("CreateGroupBoxControl",window,*boundsRect,title,primary,*outControl);
};
/*GetDataBrowserTarget

Obtains the target for the data browser

OSStatus GetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID *target
);
Parameters
browser

A data browser. 
target

On input, a pointer to an item ID variable. On return, the variable is set to the item ID for the currently assigned target.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

In column view, the target is the rightmost column. In list view, the target can be thought of as the root container.

Your application can call the function SetDataBrowserTarget to set an item ID to use as a target if you do not want to use the default target set by the data browser. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID *target
){};

/*SetDataBrowserItemDataButtonValue

Specifies a checkbox value.

OSStatus SetDataBrowserItemDataButtonValue (
   DataBrowserItemDataRef itemData,
   ThemeButtonValue theData
);

Parameters
itemData

The item data reference for the item whose checkbox value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataButtonValue.
theData

The checkbox setting. You can supply any of the following theme button value constants defined by the Appearance Manager:
kThemeButtonOff draws a checkbox that is not selected.
kThemeButtonOn draws a checkbox that is selected.
kThemeButtonMixed draws a checkbox that in a mixed state, indicating that a setting is on for some items in a selection and off for others.

See Appearance Manager Reference for more information.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your item-data callback calls this function in response to a set-data request for items that have the display type kDataBrowserCheckboxType.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataButtonValue (
   DataBrowserItemDataRef itemData,
   ThemeButtonValue theData
){};


/*NewDataBrowserSelectContextualMenuUPP

Creates a universal procedure pointer to a select-contextual-menu callback function.

DataBrowserSelectContextualMenuUPP NewDataBrowserSelectContextualMenuUPP  (
   DataBrowserSelectContextualMenuProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your select-contextual-menu callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserSelectContextualMenuProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserSelectContextualMenuUPP NewDataBrowserSelectContextualMenuUPP  (
   DataBrowserSelectContextualMenuProcPtr userRoutine
){};



/*GetDataBrowserItemState

Obtains the state of an item.

OSStatus GetDataBrowserItemState (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserItemState *state
);

Parameters
browser

A data browser.
item

The item ID of the item whose state you want to check. 
state

On input, a pointer to an item state variable. On return, the variable is set to a value that specifies the state of the item. See “Item States” for a description of the values that can be returned. 
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserItemState (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserItemState *state
){};



/*SetDataBrowserItemDataDrawState

Specifies whether to draw a checkbox in the active or inactive state.

OSStatus SetDataBrowserItemDataDrawState (
   DataBrowserItemDataRef itemData,
   ThemeDrawState theData
);

Parameters
itemData

The item data reference for the item whose drawing state you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataDrawState. 
theData

The drawing state to use for the checkbox item. You can supply the following theme drawing state constants:
kThemeStateInactive draws the item in the inactive state.
kThemeStateActive draws the item in the active state.

See Appearance Manager Reference for more information on these constants.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your item-data callback calls this function in response to a set-data request for items that have the display type kDataBrowserCheckboxType.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataDrawState (
   DataBrowserItemDataRef itemData,
   ThemeDrawState theData
){};


/*SetDataBrowserItemDataLongDateTime

Specifies, as a 64-bit value, a date and time value to display.

OSStatus SetDataBrowserItemDataLongDateTime (
   DataBrowserItemDataRef itemData,
   const LongDateTime *theData
);
Parameters
itemData

The item data reference for the item whose long date and time value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataLongDateTime.
theData

A pointer to a 64-bit value that represents the time as the number of elapsed seconds since midnight, January 1, 1904. For more information about date and time encodings used in the Mac OS, see Date, Time, and Measurement Utilities Reference in Carbon Text & International Documentation.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

This function works only with items that have the property kDataBrowserDateTimeType. If the column has the property kDataBrowserRelativeDateTime, the date is displayed relative to the current time for the computer. For example, a time 24 hours before the current time is displayed as “Yesterday.” Other examples of relative date and time values are “Today, 1:45 PM” and “Yesterday, 7:30 AM.”
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataLongDateTime (
   DataBrowserItemDataRef itemData,
   const LongDateTime *theData
){};

/*SetDataBrowserTableViewItemRowHeight

Sets the row height for a single row in a list view data browser.

OSStatus SetDataBrowserTableViewItemRowHeight (
   ControlRef browser,
   DataBrowserItemID item,
   UInt16 height
);

Parameters
browser

A data browser. 
item

The item ID for the item whose row height you want to set. 
height

The row height, in pixels.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling this function, you must call the function SetDataBrowserTableViewGeometry to set up variable row heights.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserTableViewItemRowHeight (
   ControlRef browser,
   DataBrowserItemID item,
   UInt16 height
){};

/*SetDataBrowserItemDataValue

Sets the value of an item; useful for such display types as sliders, progress bars, relevance indicators, and pop-up menus.

OSStatus SetDataBrowserItemDataValue (
   DataBrowserItemDataRef itemData,
   SInt32 theData
);

Parameters
itemData

The item data reference for the item whose integer value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataValue.
theData

The value to display. The value must be between the minimum and maximum values specified by calling the functions SetDataBrowserItemDataMinimum and SetDataBrowserItemDataMaximum. Values displayed by a progress bar can vary between the minimum and maximum values, inclusive.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application calls the function SetDataBrowserItemDataValue to set a new value for a display type when your item-data callback routine is called with the setValue parameter set to false. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataValue (
   DataBrowserItemDataRef itemData,
   SInt32 theData
){};

/*SetDataBrowserItemDataItemID

Communicates a property of an item when that property is another item’s ID.

OSStatus SetDataBrowserItemDataItemID (
   DataBrowserItemDataRef itemData,
   DataBrowserItemID theData
);

Parameters
itemData

The item data reference passed to your item-data callback.
theData

The item ID to set.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

To display hierarchical data correctly the data browser needs to know whether an item is a container and whether the item is in a container (has a parent). So it sends a get-data request for the properties kDataBrowserParentContainerProperty and kDataBrowserContainerAliasIDProperty to your item-data callback. 

The property kDataBrowserContainerAliasIDProperty is sent to your item-data callback to provide your application with a chance to follow an alias that the item might represent. If the incoming item is an alias to another item, you can call SetDataBrowserItemDataItemID to inform the data browser which other item the incoming item points to.

The property kDataBrowserParentContainerProperty is sent to your item-data callback to check whether an item has a parent. If it does, you call SetDataBrowserItemDataItemID, supplying the item ID of the parent in the parameter theData. If the item has no parent, set theData to 0.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataItemID (
   DataBrowserItemDataRef itemData,
   DataBrowserItemID theData
){};


/*SetDataBrowserItemDataMenuRef

Sets the pop-up menu to display.

OSStatus SetDataBrowserItemDataMenuRef (
   DataBrowserItemDataRef itemData,
   MenuRef theData
);
Parameters
itemData

The item data reference for the item whose pop-up menu value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataMenuRef.
theData

The pop-up menu set to the value you want to display. The system retains the menu reference that you pass; you must release it when you no longer need it. Pass NULL if you no longer want a menu. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your item-data callback calls this function in response to a set-data request for an item whose display type is kDataBrowserPopupMenuType.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataMenuRef (
   DataBrowserItemDataRef itemData,
   MenuRef theData
){};










