
#include <HIToolbox/HIToolbox.h>
//#include <HIToolbox/Draf.h>

OSStatus 
GetDragPasteboard(
  DragRef          inDrag,
  PasteboardRef *  outPasteboard){
printf ("GetDragPasteboard",inDrag,outPasteboard);
};

/*GetDragMouse

Gets the current mouse and pinned mouse locations.

OSErr GetDragMouse (
   DragRef theDrag,
   Point * mouse,
   Point * globalPinnedMouse
);
Parameters
theDrag

A drag reference. 
mouse

A pointer to a variable containing, on return, the current mouse location in global screen coordinates. You may pass NULL if you wish to ignore this value. The value will be (0, 0) if the drag is not yet used. After a drag completes, the drop location is returned.
globalPinnedMouse

A pointer to a variable containing, on return, the current pinned mouse location in global screen coordinates. You may pass NULL if you wish to ignore this value. The value will be (0, 0) if the drag is not yet used. After a drag completes, the drop location is returned.The pinned mouse location is the mouse location that is used to draw the drag region on the screen. The pinned mouse location is different from the mouse location when the cursor is being constrained in either dimension by a tracking handler.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDragMouse (
   DragRef theDrag,
   Point * mouse,
   Point * globalPinnedMouse
){
printf ("GetDragMouse",theDrag,*mouse,*globalPinnedMouse);
};


/*GetDragModifiers

Gets the current set of keyboard modifiers.

OSErr GetDragModifiers (
   DragRef theDrag,
   SInt16 * modifiers,
   SInt16 * mouseDownModifiers,
   SInt16 * mouseUpModifiers
);
Parameters
theDrag

A drag reference. 
modifiers

A pointer to a variable that, on return, contains the current keyboard modifiers. You may pass NULL if you wish to disregard this value. The value will be 0 if the drag has not been started.
mouseDownModifiers

A pointer to a variable that, on return, contains the keyboard modifiers at the mouseDown parameter time. You may pass NULL if you wish to disregard this value. The value will be 0 if the drag has not been started.
mouseUpModifiers

A pointer to a variable that, on return, contains the keyboard modifiers at the mouseUp parameter time. You may pass NULL if you wish to disregard this value. The value will be 0 if the drag has not been completed.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDragModifiers (
   DragRef theDrag,
   SInt16 * modifiers,
   SInt16 * mouseDownModifiers,
   SInt16 * mouseUpModifiers
){
printf ("GetDragModifiers",theDrag,*modifiers,*mouseDownModifiers,*mouseUpModifiers);
};


/*SetDragItemBounds

Sets the bounding rectangle of a drag item.

OSErr SetDragItemBounds (
   DragRef theDrag,
   DragItemRef theItemRef,
   const Rect * itemBounds
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item whose bounds you wish to set. 
itemBounds

A pointer to the bounding rectangle to set for the specified drag item. This rectangle is specified in global coordinates relative to the mouse down position.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

Your application would normally call the SetDragItemBounds function on each drag item before starting a drag with the TrackDrag function.

If you do not set the bounds of an item, the rectangle returned by the GetDragItemBounds function is an empty rectangle centered under the pinned mouse location. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr SetDragItemBounds (
   DragRef theDrag,
   DragItemRef theItemRef,
   const Rect * itemBounds
){
printf ("SetDragItemBounds",theDrag,theItemRef,*itemBounds);
};

//work


/*GetFlavorData

Gets all or part of the data for a specific flavor in a drag item.

OSErr GetFlavorData (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   void * dataPtr,
   Size * dataSize,
   UInt32 dataOffset
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item containing the flavor data. 
theType

The flavor type of the flavor to get the data from. 
dataPtr

A pointer to a data buffer. On return, the buffer contains the requested flavor data. Your application is responsible for allocating the memory for the flavor data and for setting the dataSize parameter to the number of bytes that you have allocated for the data.
dataSize

On input, a pointer to the size of the data (in bytes) that you have allocated memory for and wish to receive from the flavor. On return, a pointer to the actual number of bytes copied into the buffer specified by the dataPtr parameter. 

If you specify a dataSize that is smaller than the amount of data in the flavor, the data is copied into your buffer and the dataSize parameter is unchanged. If you specify a dataSize that is larger than the amount of data in the flavor, only the amount of data in the flavor is copied into your buffer and the dataSize parameter contains, on return, the actual number of bytes copied. You have reached the end of the flavor’s data when the dataSize parameter points to a number of bytes lower than you provided. 

If you wish to receive the flavor data in smaller pieces than the entire size of the data, you can set the dataSize parameter to be as large as your buffer and call the GetFlavorData function multiple times while incrementing the dataOffset parameter by the size of your buffer. If the dataOffset parameter is larger than the amount of data contained within the flavor, 0 (zero) will be returned in the number pointed to by the dataSize parameter indicating that no data was copied into your buffer.
dataOffset

A pointer to the offset (in bytes) within the flavor structure at which to begin copying data.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

You can first determine the size of a flavor’s data by calling the GetFlavorDataSize function.

Note that calling the GetFlavorData function on a flavor that requires translation will force that translation to occur in order to return the data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetFlavorData (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   void * dataPtr,
   Size * dataSize,
   UInt32 dataOffset
){};


/*GetFlavorType

Gets the type of a specific flavor in a drag item.

OSErr GetFlavorType (
   DragRef theDrag,
   DragItemRef theItemRef,
   UInt16 index,
   FlavorType * theType
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item containing the flavor. 
index

The index of the desired flavor.
theType

On return, a pointer to the type of the specified flavor. If a flavor is marked with the flavorSenderOnly flag, it is not returned to any application other than the sender. 
Return Value

A result code. See “Drag Manager Result Codes”. If index is 0 or larger than the number of flavors in the item, GetFlavorType returns the badDragFlavorErr result code.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetFlavorType (
   DragRef theDrag,
   DragItemRef theItemRef,
   UInt16 index,
   FlavorType * theType
){};


/*GetDragItemReferenceNumber

Gets the reference number of a specific item in a drag reference.

OSErr GetDragItemReferenceNumber (
   DragRef theDrag,
   UInt16 index,
   DragItemRef * theItemRef
);
Parameters
theDrag

The drag reference. 
index

The index of an item in a drag for which to get the reference. 
theItemRef

On return, a pointer to the reference number of the item with the specified index. 
Return Value

A result code. See “Drag Manager Result Codes”. If index is 0 or larger than the number of items in the drag, GetDragItemReferenceNumber returns the badDragItemErr result code.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDragItemReferenceNumber (
   DragRef theDrag,
   UInt16 index,
   DragItemRef * theItemRef
){};


/*GetFlavorDataSize

Gets the size of the data for a specific flavor in a drag item.

OSErr GetFlavorDataSize (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   Size * dataSize
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item containing the flavor. 
theType

The flavor type for which to get the size of the data. 
dataSize

On return, a pointer to the size of the data for the specified drag item flavor.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

Note that calling the GetFlavorDataSize function on a flavor that requires translation will force that translation to be performed in order to determine the data size. Since translation may require a significant amount of time and memory during processing, call the GetFlavorDataSize function only when necessary. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr GetFlavorDataSize (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   Size * dataSize
){};


/*InstallTrackingHandler

Installs a tracking handler function for one or all of your application’s windows.

OSErr InstallTrackingHandler (
   DragTrackingHandlerUPP trackingHandler,
   WindowRef theWindow,
   void * handlerRefCon
);
Parameters
trackingHandler

A pointer to a tracking handler function. Installing a tracking handler function allows your application to track the user’s movements through your application’s windows during a drag. 
theWindow

A reference to the window for which to track and handle dragging. When the cursor moves into this window during a drag, the Drag Manager sends tracking messages to the tracking handler function. If you pass NULL, the tracking handler function is installed in the default handler space for your application. Tracking handler functions installed in this way are called when the user moves the mouse over any window that belongs to your application. You may install more than one drag tracking handler on a single window.
handlerRefCon

A pointer to a reference constant that will be forwarded to your tracking handler function when it is called by the Drag Manager. Use this constant to pass any data you wish to forward to your tracking handler function. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The Drag Manager sequentially calls all of the tracking handler functions installed for a window when the user moves the cursor over that window during a drag. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr InstallTrackingHandler (
   DragTrackingHandlerUPP trackingHandler,
   WindowRef theWindow,
   void * handlerRefCon
){};


/*InstallReceiveHandler

Installs a receive handler function for one or all of your application’s windows.

OSErr InstallReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow,
   void * handlerRefCon
);
Parameters
receiveHandler

A pointer to a receive handler function. Installing a receive handler function allows your application to accept a drag by getting drag item flavor data from the Drag Manager when the user releases the mouse button while dragging over one of your application’s windows. 
theWindow

A reference to the window for which to install the receive handler. When a drop occurs over this window, the Drag Manager calls your receive handler function to allow your application to accept the drag. If you pass NULL, the receive handler function is installed in the default handler space for your application. Receive handler functions installed in this way are called when a drop occurs over any window that belongs to your application. You may install more than one receive handler function on a single window.
handlerRefCon

A pointer to a reference constant that will be forwarded to your receive handler function when it is called by the Drag Manager. Use this constant to pass any data you wish to forward to your drag receive handler. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The Drag Manager sequentially calls all of the receive handler functions installed on a window when a drop occurs in that window. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr InstallReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow,
   void * handlerRefCon
){};



/*HideDragHilite

Removes highlighting created with the ShowDragHilite function.

OSErr HideDragHilite (
   DragRef theDrag
);
Parameters
theDrag

The drag reference that is currently showing a drag highlight. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The HideDragHilite function assumes that the highlighting should be erased from the current port. Your application should make sure that the correct port is set before calling the HideDragHilite function. Also, highlighting erased by the HideDragHilite function is clipped to the current port. Make sure that the port’s clip region is appropriately sized to remove the highlighting. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr HideDragHilite (
   DragRef theDrag
){};


/*CountDragItems

Gets the number of drag items that are contained in a drag reference.

OSErr CountDragItems (
   DragRef theDrag,
   UInt16 * numItems
);
Parameters
theDrag

The drag reference. 
numItems

On return, a pointer to the number of drag items in the specified drag reference.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr CountDragItems (
   DragRef theDrag,
   UInt16 * numItems
){};



/*ShowDragHilite

Highlights an area of your window during a drag.

OSErr ShowDragHilite (
   DragRef theDrag,
   RgnHandle hiliteFrame,
   Boolean inside
);
Parameters
theDrag

The drag reference of the drag currently in progress. 
hiliteFrame

A QuickDraw region of the frame of the window, pane, or shape you wish to highlight, in the window’s local coordinate system. 
inside

Pass true to draw the highlighting inside the frame shape. Otherwise it will be drawn outside the frame shape. Note that in either case, the highlight will not include the boundary edge of the frame. This allows you to highlight inside a window frame or a pane, or to highlight outside of a container or object in your window.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The ShowDragHilite function creates a standard drag and drop highlight in your window. Your tracking handler function should call this if a drop is allowed at the current mouse position.

You can only have one highlight showing at a time, and if you call this function when a highlight is currently visible, the first one is removed before the newly requested highlight is shown.

The ShowDragHilite function uses a two pixel thick line when drawing the highlight.

The ShowDragHilite function assumes that the highlighting should be drawn in the current port. Your application should make sure that the correct port is set before calling the ShowDragHilite function. Also, highlighting drawn by the ShowDragHilite function is clipped to the current port. Make sure that the port’s clip region is appropriately sized to draw the highlighting.

The Drag Manager maintains the currently highlighted portion of your window if you use the HideDragHilite and UpdateDragHilite functions. If you intend to scroll the window that contains the highlighting, you can use the DragPreScroll and DragPostScroll functions to properly update the drag highlighting. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr ShowDragHilite (
   DragRef theDrag,
   RgnHandle hiliteFrame,
   Boolean inside
){};

/*NewDragTrackingHandlerUPP

Creates a new universal procedure pointer (UPP) to a drag tracking handler.

DragTrackingHandlerUPP NewDragTrackingHandlerUPP (
   DragTrackingHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your drag tracking handler.
Return Value

On return, a UPP to the drag tracking handler. See the description of the DragTrackingHandlerUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
DragTrackingHandlerUPP NewDragTrackingHandlerUPP (
   DragTrackingHandlerProcPtr userRoutine
){};


/*NewDragReceiveHandlerUPP

Creates a new universal procedure pointer (UPP) to a drag receive handler.

DragReceiveHandlerUPP NewDragReceiveHandlerUPP (
   DragReceiveHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your drag receive handler.
Return Value

On return, a UPP to the drag receive handler. See the description of the DragReceiveHandlerUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
DragReceiveHandlerUPP NewDragReceiveHandlerUPP (
   DragReceiveHandlerProcPtr userRoutine
){};

/*GetFlavorFlags

Gets the flags for a specific flavor in a drag item. 

OSErr GetFlavorFlags (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   FlavorFlags * theFlags
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item containing the flavor. 
theType

The flavor type for which to get the attributes. 
theFlags

On return, a pointer to the attributes of the specified flavor. If a flavor is marked with the flavorSenderOnly flag, it is not returned to any application other than the sender. 
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr GetFlavorFlags (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   FlavorFlags * theFlags
){};

/*NewDragSendDataUPP

Creates a new universal procedure pointer (UPP) to a drag send data callback.

DragSendDataUPP NewDragSendDataUPP (
   DragSendDataProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your drag send data callback.
Return Value

On return, a UPP to the drag send data callback. See the description of the DragSendDataUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

DragSendDataUPP NewDragSendDataUPP (
   DragSendDataProcPtr userRoutine
){};


/*RemoveReceiveHandler

Removes a receive handler function from one or all of your application’s windows.

OSErr RemoveReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow
);
Parameters
receiveHandler

A pointer to a receive handler function. 
theWindow

A reference to the window from which to remove the receive handler function. Pass NULL to remove the specified receive handler function from the default handler space for your application.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr RemoveReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow
){};

/*RemoveTrackingHandler

Removes a tracking handler function from one or all of your application’s windows.

OSErr RemoveTrackingHandler (
   DragTrackingHandlerUPP trackingHandler,
   WindowRef theWindow
);
Parameters
trackingHandler

A pointer to the tracking handler function to be removed. 
theWindow

A reference to the window from which to remove the drag tracking handler function. Pass NULL to remove the specified tracking handler function from the default handler space for your application.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr RemoveTrackingHandler (
   DragTrackingHandlerUPP trackingHandler,
   WindowRef theWindow
){};


/*WaitMouseMoved

Returns true if a mouse movement is the beginning of a drag.

Boolean WaitMouseMoved (
   Point initialGlobalMouse
);
Parameters
initialMouse

The point where a mouseDown event occurred in global screen coordinates.
Return Value

True if the mouse moves away from the initialMouse location before the mouse button is released, otherwise false. 
Discussion

You can use this function to determine whether you should begin to drag the object when your application receives a mouseDown event on a draggable object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
Boolean WaitMouseMoved (
   Point initialGlobalMouse
){};



/*SetDropLocation

Sets the Apple Event descriptor for the drop location of a drag.

OSErr SetDropLocation (
   DragRef theDrag,
   const AEDesc * dropLocation
);
Parameters
theDrag

A drag reference. 
dropLocation

A pointer to the Apple Event descriptor of the drop location to set. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

This function is typically called by a receive handler before attempting to get any flavor data using the GetFlavorDataSize or GetFlavorData functions. When a sender application's drag send data function is called to provide flavor data to a receiver, the GetDropLocation function can be called to determine the drop location while providing data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr SetDropLocation (
   DragRef theDrag,
   const AEDesc * dropLocation
){};

/*SetDragImage

Associates an image with a drag reference. (Deprecated in Mac OS X v10.4. Use SetDragImageWithCGImage instead.)

OSErr SetDragImage (
   DragRef theDrag,
   PixMapHandle imagePixMap,
   RgnHandle imageRgn,
   Point imageOffsetPt,
   DragImageFlags theImageFlags
);
Parameters
theDrag

The drag reference. 
imagePixMap

A handle to a PixMap describing the image. The Drag Manager temporarily locks the PixMapHandle during the drag. The Drag Manager does not copy the information in this parameter; you must ensure that the data to which this parameter refers continues to exist until TrackDrag completes. 
imageRgn

A mask describing the portion of the PixMap contained in the imagePixMap parameter which contains the drag image. Pass NULL for imageRgn if the entire PixMap, including white space, should be dragged. 

The Drag Manager does not copy the imageRgn parameter data. Until TrackDrag completes or SetDragImage is called again to update the image, you must ensure that the data to which this parameter refers continues to exist. 

Don't confuse the region passed to the function TrackDrag and that passed to the SetDragImage function. The former is what's drawn to the screen during dragging, while the latter is used only for drawing the correct portion of the drag image.

imageOffsetPt

The offset required to move the PixMap specified in the imagePixMap parameter to the global coordinates where the image initially appears. If this parameter is (0,0), the PixMap should already be in global coordinates.
theImageFlags

Flags controlling the appearance of the drag image. See “Drag Image Flags” for a description of the values you can use in this parameter.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The sending application should call SetDragImage prior to calling TrackDrag. Prior to calling SetDragImage, the application should draw a solid, opaque image into the PixMap specified in the imagePixMap parameter. The Drag Manager will provide translucency effects. Your application can obtain a PixMap by calling the QuickDraw function GetGWorldPixMap and supplying a GWorld into which your application has drawn the image.

To allow the Drag Manager to analyze the PixMap’s colors in order to determine if it can be rendered on the available screens, Apple recommends using an 8-bit GWorld for the PixMap.
Special Considerations

SetDragImage installs a custom drawing procedure to do the translucent drawing. Applications calling SetDragImage should not also call SetDragDrawingProc for the same drag.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Drag.h 
 Show TOC 	*/
OSErr SetDragImage (
   DragRef theDrag,
   PixMapHandle imagePixMap,
   RgnHandle imageRgn,
   Point imageOffsetPt,
   DragImageFlags theImageFlags
){};


/*GetDropLocation

Gets the Apple Event descriptor of the drop location.

OSErr GetDropLocation (
   DragRef theDrag,
   AEDesc * dropLocation
);
Parameters
theDrag

A drag reference. 
dropLocation

On return, a pointer to the Apple Event descriptor of the drop location. The drop location is only valid after the receiver has set the drop location by calling the SetDropLocation function. If the destination is in the Finder, the drop location will be an alias to the location in the file system that received the drag. If the receiver of the drag has not set a drop location by calling the SetDropLocation function, typeNull will be returned. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The GetDropLocation function may be called both during a drag as well as after a drag has completed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDropLocation (
   DragRef theDrag,
   AEDesc * dropLocation
){};



/*(SetDragItemFlavorData

Sets the data or part of the data contained within an existing flavor.

OSErr SetDragItemFlavorData (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   const void * dataPtr,
   Size dataSize,
   UInt32 dataOffset
);
Parameters
theDrag

The drag reference whose flavor data will be set. 
theItemRef

The drag item reference of the item that contains the flavor you wish to set all or part of the data for. The data pointed to by the dataPtr parameter with the size specified in the dataSize parameter is placed into the flavor structure at the offset specified by the dataOffset parameter. 
theType

The data type of the existing flavor for which all or part of the data will be set. 
dataPtr

A pointer to the flavor data. 
dataSize

The size, in bytes, of the flavor data.
dataOffset

The offset, in bytes, into the flavor structure at which to place the data specified by the dataPtr and the dataSize parameters.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

This function is commonly used in situations where a flavor’s data is not added to the flavor when the flavor is created using the AddDragItemFlavor function. When the sender's drag send data function is called, the SetDragItemFlavorData function can be used to provide the requested data to the Drag Manager. This method is useful when the data needs to be translated by the sender and it would be expensive to compute the data before it is required.

Unlike the functions that add flavors, this function may be called both before and during a drag. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr SetDragItemFlavorData (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   const void * dataPtr,
   Size dataSize,
   UInt32 dataOffset
){};

/*SetDragSendProc

Sets the send data function for the Drag Manager to use with a particular drag.

OSErr SetDragSendProc (
   DragRef theDrag,
   DragSendDataUPP sendProc,
   void * dragSendRefCon
);
Parameters
theDrag

The drag reference to set the send data function for. 
sendProc

The send data function that will be called by the Drag Manager when the receiver of a drop requests the flavor data of a flavor that has not been cached by the Drag Manager. 
dragSendRefCon

A pointer to a reference constant that will be forwarded to your send data function when it is called by the Drag Manager. Use this constant to pass any data you wish to forward to your send data function. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The Drag Manager caches drag item flavor data when the flavor is added to a drag by calling the AddDragItemFlavor function. If NULL is passed to the AddDragItemFlavor function as the data pointer, the flavor data is not cached and the Drag Manager will call your send data function when the drag item flavor data is requested.

You do not need to provide a send data function if your application never passes NULL to the AddDragItemFlavor function when adding a drag item flavor to a drag.

Details for how to write a send data function are covered in the “Drag Manager Callbacks” section. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr SetDragSendProc (
   DragRef theDrag,
   DragSendDataUPP sendProc,
   void * dragSendRefCon
){};


/*AddDragItemFlavor

Adds a flavor to a drag item, creating a new item if necessary.

OSErr AddDragItemFlavor (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   const void * dataPtr,
   Size dataSize,
   FlavorFlags theFlags
);
Parameters
theDrag

A drag reference. 
theItemRef

The drag item to add the flavor to. You create a new drag item by providing a unique item reference number here. You add a flavor to an existing item by using the same item reference number as in a previous call. You may use any item reference number when adding a flavor to an item. Item reference numbers do not need to be specified in order, nor must they be sequential. In many cases it is easiest to use index numbers as item reference numbers (1, 2, 3...). Item reference numbers are only used as unique “key” numbers for each item. Depending on your application, it might be easier to use your own internal memory addresses as item reference numbers (as long as each item being dragged has a unique item reference number). 
theType

The data type of the flavor to add. This may be any four-character scrap type. You may use your application’s signature for a unique type for internal use. You must add all of the drag item flavors to a drag item before calling the TrackDrag function. Once the TrackDrag function is called, receiving applications may not operate properly if new drag items or drag item flavors are added. 
dataPtr

A pointer to the flavor data to add. Pass NULL to defer the creation of a particular data type until a receiver has specifically requested it. If you pass NULL, a promise is added to the drag; when the flavor is requested, the Drag Manager calls the drag’s send data function to get the data from your application.

Note that this method of setting promises differs from the method of setting Scrap Manager promises. See the Scrap Manager function PutScrapFlavor for more information.
dataSize

The size, in bytes, of the flavor data to add. If you pass NULL in the dataPtr parameter, the value in this parameter is ignored.
theFlags

The set of attributes to set for this flavor. 
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr AddDragItemFlavor (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   const void * dataPtr,
   Size dataSize,
   FlavorFlags theFlags
){};



/*NewDrag

Creates a new drag reference for your application to use with the Drag Manager.

OSErr NewDrag (
   DragRef * theDrag
);
Parameters
theDrag

On return, a pointer to the newly created drag reference. This drag reference is required when adding drag item flavors and calling the TrackDrag function. Your installed drag handler functions receive this drag reference so they can call other Drag Manager functions. 
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr NewDrag (
   DragRef * theDrag
){};


/*GetDragAttributes

Gets the current set of drag attribute flags.

OSErr GetDragAttributes (
   DragRef theDrag,
   DragAttributes * flags
);
Parameters
theDrag

A drag reference. 
flags

On return, a pointer to the drag attribute flags for the specified drag reference. See “Drag Attributes” for a description of the values that may be returned here.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

If the GetDragAttributes function is called during a drag, the current set of drag attributes is returned. If the GetDragAttributes function is called after a drag, the set of drag attributes that were set at drop time is returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDragAttributes (
   DragRef theDrag,
   DragAttributes * flags
){};



/*DisposeDrag

Disposes of a drag reference and its associated data.

OSErr DisposeDrag (
   DragRef theDrag
);
Parameters
theDrag

The drag reference of the drag object to dispose of. If the drag reference contains any drag item flavors, the memory associated with the drag item flavors is disposed of as well. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

You should call the DisposeDrag function after a drag has been performed using the TrackDrag function or if a drag reference was created but is no longer needed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr DisposeDrag (
   DragRef theDrag
){};




/*TrackDrag

Drags an item or collection of items from your application.

OSErr TrackDrag (
   DragRef theDrag,
   const EventRecord * theEvent,
   RgnHandle theRegion
);
Parameters
theDrag

A drag reference for performing the drag operation. 
theEvent

A pointer to the mouseDown event record that your application received that resulted in starting a drag. 
theRegion

A region that represents the item or items being dragged. Note that under normal circumstances, the drag region should only include the pixels that represent the outline of the items being dragged. The Drag Manager draws the region on the screen by calling the PaintRgn function (not the FrameRgn function). 
Return Value

A result code. See “Drag Manager Result Codes”. Under some circumstances, TrackDrag may fail with a procNotFound error. See "Special Considerations" below for a description of the events that may cause this problem.
Discussion

The Drag Manager follows the cursor on the screen with the “dotted outline” drag feedback and sends tracking messages to applications that have registered drag tracking handlers. The drag item flavor information cached for the drag is available to each application that becomes active during a drag.

When the user releases the mouse button, the Drag Manager calls any drag receive handlers that have been registered on the destination window. An application’s drag receive handler(s) are responsible for accepting the drag and transferring the dragged data into their application.

The TrackDrag function returns noErr in situations where the user selected a destination for the drag and the destination received data from the Drag Manager. If the user drops over a non-aware application or the receiver does not accept any data from the Drag Manager, the Drag Manager automatically provides a "zoom back" animation and returns the userCanceledErr flag. 
Special Considerations

During the call to the TrackDrag function, your application’s context is temporarily switched out when the Drag Manager calls a different application’s tracking and receive handlers. Do not depend on your application’s context to be active for the entire duration of a drag.

The following actions may cause TrackDrag to fail with a procNotFound error:
Using a high-level debugger with the Drag Manager. Although there is no workaround for this problem, your code should work fine when run without the debugger.
Passing TrackDrag an event record in which the where field is expressed in local coordinates. In such cases, the where field often points outside of the window in which the drag originated. This problem can cause a crash as well as a procNotFound error.
Using the Drag Manager with Text Services Manager windows when the gestaltDragMgrFloatingWind bit isn't defined. 

For more information, see the Q&A at:

http://developer.apple.com/dev/techsupport/develop/issue29/macqa.html.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr TrackDrag (
   DragRef theDrag,
   const EventRecord * theEvent,
   RgnHandle theRegion
){};


OSStatus 
NewDragWithPasteboard(
  PasteboardRef   inPasteboard,
  DragRef *       outDrag){
printf ("NewDragWithPasteboard",inPasteboard,*outDrag);
};


/*SetDragImageWithCGImage

Associates a Core Graphics image with a drag reference.

OSStatus SetDragImageWithCGImage (
   DragRef inDrag,
   CGImageRef inCGImage,
   const HIPoint * inImageOffsetPt,
   DragImageFlags inImageFlags
);
Parameters
inDrag

The drag reference for which to display the image. 
inCGImage

A reference to the image to display during the drag. The Drag Manager retains this image for the duration of the drag, so you may release the image immediately after calling SetDragImageWithCGImage. 
inImageOffsetPt

A pointer to the offset from the mouse location to the upper left corner of the image, normally expressed in negative values. For example, an offset of (-30, -30) centers a 60 by 60 pixel image on the mouse. Note that this differs from the usage of the offset passed to the SetDragImage function.
inImageFlags

Flags controlling the appearance of the drag image. See “Drag Image Flags” for a description of the values you can use in this parameter.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

This function is called by the sender of a drag to set the image displayed to provide user feedback during the drag. You can call the SetDragImageWithCGImage function at any point during the drag to update the image.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Drag.h*/
OSStatus SetDragImageWithCGImage (
   DragRef inDrag,
   CGImageRef inCGImage,
   const HIPoint * inImageOffsetPt,
   DragImageFlags inImageFlags
){
printf ("SetDragImageWithCGImage",inDrag,inCGImage,*inImageOffsetPt,inImageFlags);
};




