#include <HIToolbox/HIToolbox.h>

/*HIObjectGetEventTarget

Obtains the event target of an HIObjectRef. 

EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject
);
Parameters
inObject

The object whose target you want.
Return Value

An EventTargetRef.
Availability
Available in Mac OS X v10.2 and later.*/
EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject
){
printf ("HIObjectGetEventTarget",inObject);
};


/*HIObjectRegisterSubclass

Registers an HIObject subclass.

OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
);
Parameters
inClassID

The class ID of your class. It should be unique. We recommend using Java-style com.company.foo naming conventions to avoid collisions.
inBaseClassID

The class ID of the class you derive from. Passing NULL indicates you want to subclass HIObject (the base class) directly.
inOptions

Any special options for your class. Currently you must pass 0 for this parameter.
inConstructProc

A universal procedure pointer to the event handler for this subclass. You pass the address of an event handler into this parameter. This handler is called directly, rather than through the normal event-dispatching mechanism. This means that the EventHandlerCallRef passed in will be NULL, and you cannot use it for calls like CallNextEventHandler. Other than that, you should return a result as usual. After your object is constructed, this procedure is installed as the event handler for the remaining events specified in the inEventList parameter. In Mac OS X v10.4 and later, passing NULL creates an “abstract class” that cannot be instantiated but can still be used as a base class for subclasses. If you pass NULL, HIObjectCreate on the class ID will return hiObjectClassIsAbstractErr.
inNumEvents

The number of events you are installing.
inEventList

The events your handler wants to receive. You must handle the kEventHIObjectConstruct and kEventHIObjectDestruct event. If these events are not specified, an error is returned.
inConstructData

Pass any info you want passed into your event handler here. For a C++ hierarchy based on HIObjects, you might actually pass a static method to construct your object here, and the base class event handler to do construction as your event handler.
outClassRef

The newly created class reference. Pass NULL if you don’t care.
Return Value

A result code. See “HIObject Result Codes”.
Availability
Available in Mac OS X version 10.2 (v10.2) and later.*/
OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
){
printf ("HIObjectRegisterSubclass",inClassID,inBaseClassID,inOptions,inConstructProc,inNumEvents,*inEventList,inConstructData,*outClassRef);
};

/*HIObjectCreate

Creates an object derived from HIObject.

OSStatus HIObjectCreate (
   CFStringRef inClassID,
   EventRef inConstructData,
   HIObjectRef* outObject
);
Parameters
inClassID

The class ID of the class of object you want to instantiate.
inConstructData

If your class (or any class you derive from) accepts creation parameters, you need to pass an event into this parameter. The class must be kEventClassHIObject, and the kind should be kEventHIObjectInitialize. Any other parameters should be added as necessary. Specific subclasses of HIObject which require initialization parameters will specify those parameters in the appropriate headers.
outObject

The instance of the object you create.
Return Value

A result code. See “HIObject Result Codes”.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIObjectCreate (
   CFStringRef inClassID,
   EventRef inConstructData,
   HIObjectRef* outObject
){
printf ("HIObjectCreate",inClassID,inConstructData,*outObject);
};

/*HIObjectDynamicCast

Obtains the instance data for a specific class of an HIObject. 

void* HIObjectDynamicCast (
   HIObjectRef inObject,
   CFStringRef inClassID
);
Parameters
inObject

The object whose class ID you want to check.
inClassID

The class ID to get the instance data for.
Return Value

A void * result containing the instance data for the object, or NULL if the object is not an instance of the class.
Discussion

The instance data returned is the same instance data the class’s construction event handler returns in the instance data parameter. This is stored off with the class reference so that it can be fetched later for use by this function. It allows your subclass to easily get at the data it created, if your subclass needs that data outside of an event handler. (Inside an event handler, your subclass can get at its instance data via the userData parameter to the event handler.) 
Availability
Available in Mac OS X v10.2 and later.*/

void* HIObjectDynamicCast (
   HIObjectRef inObject,
   CFStringRef inClassID
){
printf ("HIObjectDynamicCast",inObject,inClassID);
};

/*HIObjectIsOfClass

Determines whether an object is of a certain class.

Boolean HIObjectIsOfClass (
   HIObjectRef inObject,
   CFStringRef inObjectClassID
);
Parameters
inObject

The object whose class ID you want to check.
inObjectClassID

The class ID in question.
Return Value

A Boolean whose value is true if the object is of the specified class; otherwise, false.
Discussion

You can use this to see whether an object you have derives from an expected superclass.
Availability
Available in Mac OS X v10.2 and later.*/
Boolean HIObjectIsOfClass (
   HIObjectRef inObject,
   CFStringRef inObjectClassID
){
printf ("HIObjectIsOfClass",inObject,inObjectClassID);
};

/*HIObjectPrintDebugInfo

Prints the internal information of an HIObject for debugging purposes. 

void HIObjectPrintDebugInfo (
   HIObjectRef inObject
);
Parameters
inObject

The object to inspect.
Discussion

This function sends the information to stdout. 
Availability
Available in Mac OS X v10.2 and later.*/
void HIObjectPrintDebugInfo (
   HIObjectRef inObject
){
printf ("HIObjectPrintDebugInfo",inObject);
};

/*HIObjectSetArchivingIgnored

Changes the state of archiving for an HIObject. 

OSStatus HIObjectSetArchivingIgnored (
   HIObjectRef inObject,
   Boolean inIgnored
);
Parameters
inObject

The HIObject whose archiving ignored state is to be changed.
inIgnored

A Boolean whose value is true to indicate that the specified HIObject does not support the archiving protocol and should be ignored; otherwise, false.
Return Value

An operating system result code.
Discussion

Call this function to mark or unmark an HIObject as ignored for archiving. By default, HIObjects are marked as ignored for archiving. HIObject subclasses supporting archiving with the kEventHIObjectInitialize and kEventHIObjectEncode events must set their archiving ignored state to false in order to receive archiving requests from clients. A client may still reset the archive ignored state to true on a particular object. An HIObject marked as ignored for archiving will never be requested to encode itself into an archive.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIObjectSetArchivingIgnored (
   HIObjectRef inObject,
   Boolean inIgnored
){
printf ("HIObjectSetArchivingIgnored",inObject,inIgnored);
};

