#include <LaunchServices/LaunchServices.h>


/*LSOpenApplication

Launches the specified application.

OSStatus LSOpenApplication (
const LSApplicationParameters * inAppParams,
ProcessSerialNumber * outPSN
);
Parameters
inAppParams

A LSApplicationParameters structure specifying the application to launch and its launch parameters. This parameter cannot be NULL.
outPSN

On input, a pointer to a value of type ProcessSerialNumber that, on return, contains the process serial number (PSN) of the application specified by inAppParams, or NULL if you don’t want to receive the PSN.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The LSOpenApplication launches one application. This function is an updated alternative to the Process Manager's LaunchApplication function. Launch arguments are specified in the inAppParams argument, which must be supplied. If the application is already running in the current session, it is made the front process (unless the kLSLaunchNewInstance flag is used, which always causes a new process to be created).

If outPSN is not NULL, on return, the structure it points to contains the PSN of the launched (or activated) process. Note that for asynchronous launches, the application may not have finished launching when this function returns.
Version Notes

Thread-safe since Mac OS X v10.4.
Availability
Available in Mac OS X v10.4 and later.
Declared In
LSOpen.h*/
OSStatus LSOpenApplication (
const LSApplicationParameters * inAppParams,
ProcessSerialNumber * outPSN
){
printf ("LSOpenApplication",*inAppParams,*outPSN);
};

/*LSOpenFSRef

Opens an item designated by file-system reference, in the default manner in its preferred application.

OSStatus LSOpenFSRef (
   const FSRef *inRef,
   FSRef *outLaunchedRef
);
Parameters
inRef

A pointer to a file-system reference designating the item to open; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
outLaunchedRef

A pointer to a file-system reference that, on return, will identify the application launched. Pass NULL if this information is unimportant.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The designated item is opened in the default manner, as if it had been opened with the LSOpenFromRefSpec function with a launch specification specifying the launch flag kLSLaunchDefaults: that is, asynchronously, starting the Classic emulation environment if necessary, and with the remaining launch parameters taken from the application’s information property list. For greater control, call LSOpenFromRefSpec directly. See “Launch Flags” for more information about launch flags.

The application is launched or activated, as required, and sent an appropriate Apple event depending on the circumstances:
If the item is a document, its preferred application is launched (or activated if it is already running) and sent an 'odoc' (“open document”) Apple event.
If the item is an application that is not already running, it is launched and sent an 'oapp' (“open application”) Apple event.
If the item is an application that is already running, it is activated and sent an 'rapp' (“reopen application”) Apple event.

As of Mac OS X v10.4 and later, LSOpenItemsWithRole is the preferred way of opening an item.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSOpen.h*/

OSStatus LSOpenFSRef (
   const FSRef *inRef,
   FSRef *outLaunchedRef
){
printf ("LSOpenFSRef",*inRef,*outLaunchedRef);
};

/*LSOpenFromURLSpec

Opens one or more items designated by URL, in either their preferred applications or a designated application.

OSStatus LSOpenFromURLSpec (
   const LSLaunchURLSpec *inLaunchSpec,
   CFURLRef *outLaunchedURL
);
Parameters
inLaunchSpec

A pointer to a URL-based launch specification indicating what to open and how to launch the relevant application or applications; see “LSLaunchURLSpec” for a description of this structure.
outLaunchedURL

A pointer to a Core Foundation URL reference that, on return, will identify the application launched; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type. Pass NULL if this information is unimportant. If more than one application is launched, the one identified will be the one corresponding to the first item designated in the launch specification.

Despite the absence of the word Copy in its name, this function retains the URL reference object on your behalf; you are responsible for releasing this object.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

This function affords greater control of how items are opened or applications launched than is possible with the LSOpenCFURLRef function. For instance, you can use it to open multiple items in a single call, in either the same or different applications; open documents for printing rather than for simple viewing or editing; or force a document to open in an application other than its own preferred application.

The launch specification supplied for the inLaunchSpec parameter may designate an application to launch, items to open, or both. The relevant application or applications are launched or activated, as required, and sent an appropriate Apple event depending on the circumstances:
If the launch specification designates both items to open and an application with which to open them, the designated application is used to open all of the items. The application is launched (or activated if it is already running) and sent one or more Apple events: 
If one or more of the item URLs have scheme file and designate documents to open, and if the application claims to accept file URLs, it is sent a 'GURL' (“get URL”) Apple event for each such URL.
If one or more of the item URLs have scheme file and designate documents to open, and if the application does not claim to accept file URLs, it is sent a single 'odoc' (“open document”) Apple event containing the list of items to open; if the items are to be printed, the Apple event is 'pdoc' (“print document”) instead.
For each item URL with a scheme other than file, the application is sent a 'GURL' (“get URL”) Apple event containing the item’s URL.

Note: When both an application and a list of items are supplied, the designated application is asked to open all of the items, whether or not it claims the ability to do so. Launch Services does not report an error if the application is unable to open one or more of the items; any error processing is the application’s responsibility.

If the launch specification designates items to open but not an application with which to open them, each item is opened in its own preferred application. Each application is launched or activated and sent one or more Apple events, as described for the preceding case. (If two or more of the items have the same preferred application, the application receives a single 'odoc' or 'pdoc' event listing all of the relevant items.)
If the launch specification designates only an application to launch (or if one or more of the items to open are file URLs designating applications):
If the application is not already running, it is launched and sent an 'oapp' (“open application”) Apple event.
If the application is already running, it is activated and sent an 'rapp' (“reopen application”) Apple event.

As of Mac OS X v10.4 and later, LSOpenURLsWithRole is the preferred way of opening URLs.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSOpen.h*/
OSStatus LSOpenFromURLSpec (
   const LSLaunchURLSpec *inLaunchSpec,
   CFURLRef *outLaunchedURL
){
printf ("LSOpenFromURLSpec",*inLaunchSpec,*outLaunchedURL);
};


/*LSOpenCFURLRef

Opens an item designated by URL, in the default manner in its preferred application.

OSStatus LSOpenCFURLRef (
   CFURLRef inURL,
   CFURLRef *outLaunchedURL
);
Parameters
inURL

A Core Foundation URL reference designating the item to open; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type.
outLaunchedURL

A pointer to a Core Foundation URL reference that, on return, will identify the application launched. Pass NULL if this information is unimportant. 

Despite the absence of the word Copy in its name, this function retains the URL reference object on your behalf; you are responsible for releasing this object.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The designated item is opened in the default manner, as if it had been opened with the LSOpenFromURLSpec function with a launch specification specifying the launch flag kLSLaunchDefaults: that is, asynchronously, starting the Classic emulation environment if necessary, and with the remaining launch parameters taken from the application’s information property list. For greater control, call LSOpenFromURLSpec directly. See “Launch Flags” for more information about launch flags.

If the item URL’s scheme is file (designating either a file or a directory), the selection of the preferred application is based on the designated item’s filename extension, file type, and creator signature; otherwise, it is based on the URL scheme (such as http, ftp, or mailto). The application is launched or activated, as required, and sent an appropriate Apple event depending on the circumstances:
If the URL’s scheme is file and it designates a document, the document’s preferred application is launched (or activated if it is already running). 
If the application claims to accept file URLs, it is sent a 'GURL' (“get URL”) Apple event containing the item’s URL.
If the application does not claim to accept file URLs, it is sent an 'odoc' (“open document”) Apple event identifying the document to open.
If the URL’s scheme is file and it designates an application: 
If the application is not already running, it is launched and sent an 'oapp' (“open application”) Apple event.
If the application is already running, it is activated and sent an 'rapp' (“reopen application”) Apple event.
If the URL has a scheme other than file, the scheme’s preferred application is launched (or activated if it is already running) and sent a 'GURL' (“get URL”) Apple event containing the item’s URL.

As of Mac OS X v10.4 and later, LSOpenURLsWithRole is the preferred way of opening a URL.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSOpen.h*/

OSStatus LSOpenCFURLRef (
   CFURLRef inURL,
   CFURLRef *outLaunchedURL
){
printf ("LSOpenCFURLRef",inURL,*outLaunchedURL);
};



