#include <OSServices/OSServices.h>

//work


/*InitOpenTransportInContext

Initializes the parts of Open Transport for use by the application or code resource. (Deprecated in Mac OS X v10.4.)

OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
);
Parameters
flags

Tells Open Transport whether your code is an application or a plug-in.
outClientContext

Returns the client context pointer. 
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

In Carbon, the InitOpenTransportInContext function acts like the pre-Carbon InitOpenTransport function, except that it takes parameters that specify initialization context explicitly.

Use the flags parameter to tell Open Transport whether your code is an application or some other target (for example, a plug-in that runs in an application context but is not the application itself). The second parameter returns the client context pointer, which you must pass to other asset-creation routines. For more information, see Understanding Open Transport Asset Tracking at http://developer.apple.com/technotes/tn/tn1173.html.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
){};

/*OTOpenEndpointInContext

Opens an endpoint that operates synchronously. (Deprecated in Mac OS X v10.4.)

EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
);
Parameters
config
oflag
info
err
clientContext
Return Value

See the description of the EndpointRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
){};

/*OTCreateConfiguration

Creates a structure defining a provider’s configuration. (Deprecated in Mac OS X v10.4.)

Modified

OTConfigurationRef OTCreateConfiguration (
   const char * path
);
Parameters
path

A pointer to a character string describing the provider.
Return Value

See the description of the OTConfigurationRef data type.
Discussion

The OTCreateConfiguration function creates a configuration structure that defines the software modules, hardware ports, and options that Open Transport is to use when you call a function to open a provider. This is a private structure, defined by the OTConfiguration data type . To create one, you use the path parameter to pass the OTCreateConfiguration function a string describing the provider service desired.

The simplest possible value of the path parameter is a single protocol module name of the highest-level protocol you want to use; for example, “tcp.” If you do not specify a complete communications path, the Open Transport software uses default settings to construct the rest of the path. For example, if you specify “adsp” for the path parameter, Open Transport defaults to using the AppleTalk DataStream Protocol (ADSP) protocol module layered above the Datagram Delivery Protocol (DDP) protocol module and with LocalTalk on the default port, which is the printer port.

If you want to identify a particular port in the configuration string, you use the port name to do so (described in the section “About Port Information,” beginning on page 6-5). More typically, however, you leave this value blank— for example, using a string with only “adsp” or “adsp, ddp,” which configures the provider with whatever port is specified in the control panel.

To specify more than one protocol module, separate the module names with commas. You can also specify values for options by putting them in parentheses after the protocol name; for example, “adsp, ddp (Checksum=1)” specifies that ADSP is to run on top of DDP and that the checksum option is enabled.

If Open Transport cannot parse the list that you pass in the path parameter, the OTCreateConfiguration function returns ((OTConfiguration*)-1L). If there is insufficient memory to create an OTConfiguration structure, the OTCreateConfiguration function returns NULL.

The OTCreateConfiguration function returns a pointer to the configuration structure it creates. You pass this pointer as a parameter to the open-provider functions such as the OTOpenEndpoint or OTOpenMapper functions.
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Passing inline options to OTCreateConfiguration-for example, OTCreateConfiguration("tcp(NoDelay=1)")-is not supported on Mac OS X. Instead, you should explicitly set any options using the function OTOptionManagement.

Declared In
OpenTransport.h*/

OTConfigurationRef OTCreateConfiguration (
   const char * path
){};

/*OTCloseProvider

Closes a provider of any type—endpoint, mapper, or service provider. (Deprecated in Mac OS X v10.4.)

OSStatus OTCloseProvider (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTCloseProvider function closes the provider that you specify in the ref parameter. Closing the provider deletes all memory reserved for it in the system heap, deletes its resources, and cancels any provider functions that are currently executing.

Open Transport does not guarantee that all outstanding functions have completed before it closes the provider. It is ultimately your responsibility to make sure that all provider functions that you care about have finished executing, before you close and delete a provider.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTCloseProvider (
   ProviderRef ref
){};

/*CloseOpenTransportInContext

Unregisters your application or code resource connection to Open Transport. (Deprecated in Mac OS X v10.4.)

void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
);
Parameters
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

The CloseOpenTransportinContext function acts like the pre-Carbon CloseOpenTransport function except that it takes an additional parameter, an OTClientContextPtr, which can be NULL for applications. Other types of clients must provide a valid client context pointer.
Declared In
OpenTransport.h*/
void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
){};

/*OTGetEndpointInfo

Obtains information about an endpoint that has been opened. (Deprecated in Mac OS X v10.4.)

OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
);
Parameters
ref
info
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTGetEndpointInfo function returns information about
the maximum size of buffers used to specify an endpoint’s address and option values
the maximum size of normal and expedited data you can transfer using this endpoint or, for transaction-based endpoints, the maximum size of requests and replies
the size of data you can transfer when initiating or tearing down a connection
the services supported by the endpoint
any additional characteristics of this endpoint
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
){};

/*OTAllocMemInContext

Allocates memory using an explicit client context. (Deprecated in Mac OS X v10.4.)

void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
);
Parameters
size
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
){};

/*OTOptionManagement

Determines an endpoint’s current or default option values or changes these values. (Deprecated in Mac OS X v10.4.)

OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
);
Parameters
ref
req
ret
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

To use the OTOptionManagement function, you must have opened an endpoint using the OTOpenEndpoint or OTAsyncOpenEndpoint functions.

You use the OTOptionManagement function to negotiate, retrieve, or verify an endpoint’s protocol options. If the endpoint is in asynchronous mode and you have not installed a notifier function, it is not possible to determine when the function completes.

The action taken by the OTOptionManagement function is determined by the setting of the req->flags field. The following bulleted items describe the different operations that you can perform and the flag settings that you use to specify these operations.
To negotiate values for the endpoint, you must call the OTOptionManagement function, specifying T_NEGOTIATE for the req->flags field. The endpoint provider evaluates the requested options, negotiates the values, and returns the resulting values in the option management structure pointed to by the ret->opt.buf field. The status field of each returned option is set to a constant that indicates the result of the negotiation. These constants are described by the “Open Transport Flags and Status Codes” enumeration.

For any protocol specified, you can negotiate for the default values of all options supported by the endpoint by specifying the value T_ALLOPT for the name field of the TOption structure. This might be useful if you want to change current settings or if negotiations for other values have failed. The success of the negotiations depends partly on the state of the endpoint—that is, simply because these are default values does not guarantee a completely successful negotiation. When the function returns, the resulting values are returned, option by option, in the buffer pointed to by the ret->opt.buf field.
To retrieve an endpoint’s default option values, call the OTOptionManagement function, specifying T_DEFAULT for the req->flags field. You must also specify the name of the option (but not its value) in the TOption structure that you create for each of the options you are interested in.

When the function returns, it passes the default values for the options back to you in the buffer pointed to by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.

When getting an endpoint’s default option values, you can specify T_ALLOPT for the option name. This returns all supported options for the specified level with their default values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To retrieve an endpoint’s current option values, call the OTOptionManagement function, specifying T_CURRENT for the req->flags field. For each option in the buffer referenced by the req->opt.buf field, specify the name of the option you are interested in. The function ignores any option valuesyou specify.

When the function returns, it passes the current values for the options back to you in the buffer referenced by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the “Open Transport Flags and Status Codes” enumeration.

When retrieving an endpoint’s current option values, you can specify T_ALLOPT for the option name. The function returns all supported options for the specified protocol, with their current values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To check whether an endpoint provider supports certain options or option values, you must call the OTOptionManagement function, specifying T_CHECK for the req->flags field. Checking options or their values does not change the current settings of an endpoint’s options.
To check whether an option is supported, set the name field of the TOption structure to the option name, but do not specify an option value. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set to T_SUCCESS if the option is supported, T_NOTSUPPORT if it is not supported or needs additional client privileges, and T_READONLY if it is read-only.
To check whether an option value is supported, set the name field of the TOption structure to the option name, and set the value field to the value you want to check. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set as it would be if you had specified the T_NEGOTIATE flag. The overall result of the option checks is returned in the ret->flags field, which contains the single worst result of the option checks. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
){};

/*OTFreeMem

Frees memory allocated with the OTAllocMem function. (Deprecated in Mac OS X v10.4.)

void OTFreeMem (
   void * mem
);
Parameters
mem
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTFreeMem (
   void * mem
){};

/*OTNextOption

Locates the next TOption structure in a buffer. (Deprecated in Mac OS X v10.4.)

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
);
Parameters
buffer

A pointer to the buffer containing the option to be found.
buflen

A long specifying the size of the buffer containing the option to be found.
prevOptPtr
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTNextOption function allows you to parse through a buffer containing TOption structures describing an endpoint’s option values. Within the buffer, TOption structures are aligned to long-word boundaries. This function takes into account this padding when it calculates the beginning address of the next TOption structure and it returns that address in the prevOptPtr parameter.

The first time you call the option, set the prevOptPtr parameter to the beginning address of the buffer. When the function returns, the prevOptPtr parameter points to the next (second) option in the buffer. You can continue this process, specifying the value returned for the prevOptPtr parameter by the previous invocation of the function, each time you call the function to obtain the beginning address of each option in the buffer.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
){};

/*OTStrLength

Returns the length of a C string. (Deprecated in Mac OS X v10.4.)

OTByteCount OTStrLength (
   const char * str
);
Parameters
str
Return Value

See the description of the OTByteCount data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTByteCount OTStrLength (
   const char * str
){};

/*OTInstallNotifier

Installs a notifier function. (Deprecated in Mac OS X v10.4.)

OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
);
Parameters
ref
proc

For C++ applications, the proc parameter must point to either a C function or a static member function. See OTNotifyUPP data type.
contextPtr

A context pointer for your use. The provider passes this value unchanged to your notifier function when it calls the function.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTInstallNotifier function installs a notifier function for the provider that you specify. Changing a provider’s mode of execution does not affect the notifier function. The notifier function remains installed until you remove it using the OTRemoveNotifier function or until you close the provider.

Before calling the OTInstallNotifier function, you must open the provider for which you want to install the notifier. If you open a provider asynchronously (for example, with the OTAsyncOpenEndpoint function), you must pass a pointer to a notifier function as a parameter to the function used to open the provider. In this case, you don’t need to call the OTInstallNotifier function unless you want to install a different notifier function. If you do, you must call the OTRemoveNotifier function before calling the OTInstallNotifier function.

Opening a provider synchronously (for example, with the OTOpenEndpoint function) opens the provider but does not install a notifier function for it. If you need a notifier function for a provider opened synchronously, you must call the OTInstallNotifier function. This notifier would not return completion events, but would return asynchronous events advising you of the arrival of data, of changes in flow-control restrictions, and so on.

Call the OTInstallNotifier function only when no provider functions are executing for the provider that you specify. Otherwise, the OTInstallNotifier function returns the result code kOTStateChangeErr.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
){};

/*OTSetSynchronous

Sets a provider’s mode of execution to synchronous. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetSynchronous (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetSynchronous function causes all provider functions to run synchronously when using the provider that you specify.

Changing a provider’s mode of execution does not affect its notifier function, if any is installed for this provider; the notifier function remains installed.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetSynchronous (
   ProviderRef ref
){};

/*OTSetNonBlocking

Disallows a provider from waiting if it cannot currently complete a function that sends or receives data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetNonBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetNonBlocking function causes provider functions to return a result code immediately, instead of waiting for a function that sends or receives data to complete. When you open a provider, its mode of operation is set to nonblocking by default.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetNonBlocking (
   ProviderRef ref
){};

/*OTUseSyncIdleEvents

Allows synchronous idle events to be sent to your notifier. (Deprecated in Mac OS X v10.4.)

OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
);
Parameters
ref
useEvents
Return Value

A result code. See “Open Transport Result Codes”.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
){};

/*OTBind

Assigns an address to an endpoint. (Deprecated in Mac OS X v10.4.)

OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
);
Parameters
ref
reqAddr

If you specify NIL for the reqAddr parameter, Open Transport chooses a protocol address for you and requests 0 as the endpoint’s maximum number of concurrent outstanding connect indications.

If you want Open Transport to assign an address for you, setthe addr.len field of the TBind structure to 0.
retAddr

You can set this parameter to nil if you do not care to know what address the endpoint is bound to or what the negotiated value of qlen is.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTBind function to request an address that an endpoint be bound to. You can either use the reqAddr parameter to request that the endpoint be bound to a specific address or allow the endpoint provider to assign an address dynamically by passing nil for this parameter. Consult the documentation for the top-level protocol you are using to determine whether it is preferable to have the address assigned dynamically. The function returns the address to which the endpoint is actually bound in the retAddr parameter. This might be different from the address you requested, if you requested a specific address.

If you are binding a connection-oriented endpoint, you must use the reqAddr->qlen field to specify the number of connection requests that may be outstanding for this endpoint. The retAddr->qlen field specifies, on return, the actual number of connection requests allowed for the endpoint. This number might be smaller than the number you requested. Note that when the endpoint is actually connected, the number might be further decreased by negotiations taking place at that time.

If you call the OTBind function asynchronously and you have not installed a notifier function, the only way to determine when the function completes is to poll the endpoint using the OTGetEndpointState function. This function returns a kOTStateChangeErr until the bind completes. When the endpoint is bound, the state is either T_UNBND if the bind failed, or T_IDLE if it succeeded.

You can cancel an asynchronous bind that is still in progress by calling the OTUnbind function.

You must not bind more than one connectionless endpoint to a single address. Some connection-oriented protocols let you bind two or more endpoints to the same address. In such instances, you must use only one of the endpoints to listen for connection requests for that address. When binding the endpoint listening for a connection, you must set the reqAddr->qlen field of the OTBind function to a value greater than or equal to 1. When binding the other endpoints, you must set the reqAddr->qlen field to 0.

If you accept a connection for an endpoint that is also listening for connection requests, the address of that endpoint is deemed “busy” for the duration of the connection, and you must not bind another endpoint for listening to that same address. This requirement prevents more than one endpoint bound to the same address from accepting connection requests. If you have to bind another listening endpoint to the same address, you must first use the OTUnbind function to unbind the first endpoint or use the OTCloseProvider function to close it.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
){};

/*OTRcv

Reads data sent using a connection-oriented transactionless protocol. (Deprecated in Mac OS X v10.4.)

OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
);
Parameters
ref
buf

A pointer to a memory location where the incoming data is to be copied. You must allocate this buffer before you call the function.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You call the OTRcv function to read data sent by the peer to which you are connected. If the OTRcv function succeeds, it returns an integer (OTStatus) specifying the number of bytes received. The function places the data read into the buffer referenced by the buf parameter. If the function fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure. You can call this function to receive either normal or expedited data. If the data is expedited, the T_EXPEDITED flag is set in the flags parameter.

If T_MORE is set in the flags parameter when the function returns, this means that the buffer you allocated is too small to contain the data to be read and that you must call the OTRcv function again. If you have read x bytes with the first call, the next call to the OTRcv function begins to read at the (x + 1) byte. Of course, if you need it, you must copy the data in the buffer to another location before calling the function again. Each call to this function that returns with the T_MORE flag set means that you must call the function again to get more data. When you have read all the data, the OTRcv function returns with the T_MORE flag not set. If the endpoint does not support the concept of a TSDU (Transport Service Data Unit), the T_MORE flag is not meaningful and should be ignored. To determine whether the endpoint supports TSDUs, examine the tsdu field of the TEndpointInfo structure. A value of T_INVALID means that the endpoint does not support it.

Some protocols allow you to send zero-length data to signal the end of a logical unit. In this case, if you request more than 0 bytes when calling the OTRcv function, the function returns 0 bytes only to signal the end of a TSDU.

If the OTRcv function returns and the T_EXPEDITED bit is set in the flags parameter, this means that you are about to read expedited data. If the number of bytes of expedited data exceeds the number of bytes you specified in the reqCount parameter, both the T_EXPEDITED and the T_MORE bits are set. You must call the OTRcv function until the T_MORE flag is not set to retrieve the rest of the expedited data.

If you are calling the OTRcv function repeatedly to read normal data and a call to the function returns T_EXPEDITED in the flags parameter, the next call to the OTRcv function that returns without the T_EXPEDITED flag set returns normal data at the place it was interrupted. It is your responsibility to remember where that was and to continue processing normal data. You can determine how much normal data you read by maintaining a running total of the number of bytes returned in the OTStatus result.

If the endpoint is in asynchronous mode or is not blocking, the function returns with the kOTNoDataErr result if no data is available. If you have installed a notifier, the endpoint provider calls your notifier and passes T_DATA or T_EXDATA for the code parameter when there is data available. If you have not installed a notifier, you may poll for these events using the OTLook function. Once you receive a T_DATA or T_EXDATA event, you should continue in a loop, calling the OTRcv function until it returns with the kOTNoDataErr result.

If the endpoint is in synchronous mode and is blocking, the endpoint waits for data if none is currently available. You should avoid calling the OTRcv function this way because it might cause processing to hang if no data is available. If you are doing other operations in synchronous mode, you should put the endpoint in nonblocking mode before calling the OTRcv function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
){};

/*OTSnd

Sends data to a remote peer. (Deprecated in Mac OS X v10.4.)

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
);
Parameters
ref
buf

A pointer to the data being sent. If you are sending data that is not stored contiguously, this is a pointer to an OTData structure that describes the first data fragment.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You use the OTSnd function to send data to a remote peer. Before you use this function, you must establish a connection with the peer.

If the OTSnd function succeeds, it returns an integer (OSStatus) specifying the number of bytes that were actually sent. If it fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure.

You specify the data to be sent by passing a pointer to the data (buf) and byspecifying the size of the data (nbytes). The maximum size of the data you can send is specified by the tsdu field of the TEndpointInfo structure for the endpoint.

Some protocols use expedited data for control or attention messages. To determine whether the endpoint supports this service, examine the etsdu field of the TEndpointInfo structure. A positive integer for the etsdu field indicates the maximum size in bytes of expedited data that you can send. To send expedited data, you must set the T_EXPEDITED bit of the flags parameter.

If you want to break up the data sent into smaller logical units, you can set the T_MORE bit of the flags parameter to indicate that you are using additional calls to the OTSnd function to send more data that belongs to the same logical unit. To indicate that the last data unit is being sent, you must specify 0 for nbytes and turn off the T_MORE flag. This is the only circumstance under which it is permitted to send a zero-length data unit. If the endpoint does not support the sending of zero-length data, the OTSnd function fails with the kOTBadDataErr result.

If the endpoint is in blocking mode, the OTSnd function returns after it actually sends the data. If flow-control restrictions prevent its sending the data, it retries the operation until it is able to send it. If the endpoint is in nonblocking mode, the OTSnd function returns with the kOTFlowErr result if flow-control restrictions prevent the data from being sent. When the endpoint provider is able to send the data, it returns a T_GODATA event to let you know that it is possible to send data.

The following table shows how the endpoint’s mode of execution and blocking status affects the behavior of the OTSnd function.
Table A-1  
	
Blocking	
Nonblocking

Synchronous	
The function returns when the provider lifts flow-control restrictions The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Asynchronous	
The function returns immediately. The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
){};

/*OTConnect

Requests a connection to a remote peer. (Deprecated in Mac OS X v10.4.)

OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
);
Parameters
ref
sndCall
rcvCall

This parameter is only meaningful for synchronous calls to the OTConnect function. See TCall data type.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If the endpoint is in synchronous mode, the OTConnect function returns after the connection is established and fills in the fields of the TCall structure (referenced by the rcvCall parameter) with the actual values associated with this connection. These might be different from the values you specified using the sndCall parameter.

If the OTConnect function returns with the kOTLookErr result, this might be either because of a pending T_LISTEN or T_DISCONNECT event. That is, either a connection request from another endpoint has interrupted execution of the function, or the remote endpoint has rejected the connection. If you don’t have a notifier installed, you can call the OTLook function to identify the event that caused the kOTLookErr result. If the event is T_LISTEN, you must accept or reject the incoming request and then continue processing the OTConnect function by calling OTRcvConnect. If the event is T_DISCONNECT, you must call the OTRcvDisconnect function to clear the error condition—that is, to deallocate memory and place the endpoint in the correct state.

If the endpoint is in asynchronous mode, the OTConnect function returns before the connection is established with a kOTNoDataErr result to indicate that the connection is in progress. When the connection is established, the endpoint provider calls your notifier, passing T_CONNECT for the code parameter. In response, you must call the OTRcvConnect function to read the connection parameters that would have been returned using the rcvCall parameter if the endpoint were in synchronous mode.

It is possible that the remote address returned in the addr field of the rcvCall parameter is not the same as the address you requested using the sndCall->addr field. This happens when the connection is accepted for a different endpoint than the one receiving the connection request.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
){};

/*OTSetBlocking

Allows a provider to wait or block until it is able to send or receive data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetBlocking function causes provider functions that send or receive data to wait if current conditions prevent them from completing an operation. By default, a provider is in nonblocking mode, in which case, if a provider function were unable to complete sending or receiving data, it would return immediately with a result that would tell you why the operation was unable to complete.

If a provider is in blocking mode and you call the OTCloseProvider function to close the provider, Open Transport gives each Streams module up to 15 seconds to process outgoing commands. It is recommended that you call the OTSetNonBlocking function before you call the OTCloseProvider function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetBlocking (
   ProviderRef ref
){};

/*NewOTNotifyUPP

Creates a new universal procedure pointer (UPP) to a notification callback. (Deprecated in Mac OS X v10.4.)

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the OTNotifyUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
){};

/*OTMemzero

Initializes the specified memory range to 0. (Deprecated in Mac OS X v10.4.)

void OTMemzero (
   void * dest,
   OTByteCount nBytes
);
Parameters
dest
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

void OTMemzero (
   void * dest,
   OTByteCount nBytes
){};


/*OTAtomicAdd32

Atomically adds a 32-bit value to a memory location. (Deprecated in Mac OS X v10.4.)

SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
);
Parameters
toAdd
dest
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
){};

/*OTGetTimeStamp

Obtains the current timestamp. (Deprecated in Mac OS X v10.4.)

void OTGetTimeStamp (
   OTTimeStamp * currentTime
);
Parameters
currentTime
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTGetTimeStamp (
   OTTimeStamp * currentTime
){};

/*OTLIFOEnqueue

Places a link at the front of a LIFO list. (Deprecated in Mac OS X v10.4.)

void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
);
Parameters
list
link
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
){};

/*OTLIFODequeue

Removes the first link in a LIFO list and returns a pointer to it. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFODequeue (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFODequeue (
   OTLIFO * list
){};

/*OTLIFOStealList

Removes all links in a LIFO list and returns a pointer to the first link in the list. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFOStealList (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFOStealList (
   OTLIFO * list
){};

/*OTReverseList

Reverses the order in which entries are linked in a list. (Deprecated in Mac OS X v10.4.)

OTLink * OTReverseList (
   OTLink * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTLink * OTReverseList (
   OTLink * list
){};

/*OTGetEndpointState

Obtains the current state of an endpoint. (Deprecated in Mac OS X v10.4.)

OTResult OTGetEndpointState (
   EndpointRef ref
);
Parameters
ref
Return Value

See the description of the OTResult data type.
Discussion

The OTGetEndpointState function returns an integer greater than or equal to 0 indicating the state of the specified endpoint. The endpoint state enumeration describes possible endpoint states and lists their decimal value.

If the function fails, it returns a negative integer specifying the error code. You must open an endpoint before you can determine its state.

You might need to know an endpoint’s state in order to determine whether a function has completed or whether the endpoint is in an appropriate state for the function that you want to call next.

This function returns endpoint state information immediately, whether the endpoint is in synchronous or asynchronous mode.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTGetEndpointState (
   EndpointRef ref
){};

/*OTAtomicTestBit

Tests a bit in a byte and returns its current state. (Deprecated in Mac OS X v10.4.)

Boolean OTAtomicTestBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);
Parameters
bytePtr
bitNumber
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTAtomicTestBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
){};

/*OTAtomicSetBit

Sets a specified bit in a byte. (Deprecated in Mac OS X v10.4.)

Boolean OTAtomicSetBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);
Parameters
bytePtr
bitNumber
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTAtomicSetBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
){};

/*OTAsyncOpenEndpoint
Opens an endpoint and installs a notifier callback function for the endpoint.

C INTERFACE
OSStatus OTAsyncOpenEndpoint( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OTNotifyProcPtr proc, 
                     void* contextPtr);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

PARAMETERS 
config 
A pointer to an endpoint configuration structure that specifies the endpoint's characteristics. You obtain a value for the config parameter by calling the OTCreateConfiguration function. The OTAsyncOpenEndpoint function disposes of the configuration structure before returning. 
oflag 
Reserved; must be set to 0. 
info 
A pointer to a TEndpointInfo structure to be filled in by the OTAsyncOpenEndpoint function. Specify NULL for this parameter if you do not want the OTAsyncOpenEndpoint function to return endpoint information. 
proc 
A pointer to a notifier callback function for this endpoint. If you do not provide a notifier function, your application cannot receive completion events, including the event advising you that the endpoint has been created. Never pass a universal procedure pointer as the proc parameter. 
contextPtr 
A pointer for your use. The endpoint passes this pointer value when calling the notifier function you specify in the proc parameter. You might use the contextPtr parameter to pass your notifier function information about the endpoint, for example. 
function result 
An error code. See Discussion. 
DISCUSSION
The OTAsyncOpenEndpoint function opens an endpoint having the characteristics specified by the config parameter. How processing proceeds depends on this result code.

If the result code is any except kOTNoError, an error occurred and Open Transport does not queue the function for execution. The OTAsyncOpenEndpoint function creates no endpoint and does not call the notifier function that you specified in the proc parameter.

If the result code is kOTNoError, the OTAsyncOpenEndpoint function has queued the operation for execution. When it completes it calls the notifier function that you specified in the proc parameter, passing the event T_OPENCOMPLETE for the code parameter, a result code in the result parameter, and the endpoint reference for the newly created endpoint in the cookie parameter. For information about notifier functions, see "Application-Defined Notifier Functions" and "Event Codes". 

An endpoint created by the OTAsyncOpenEndpoint function operates in asynchronous mode, does not block, and does not acknowledge sends. To change these default settings, you can call the OTSetSynchronous function, OTSetBlocking function and the OTAckSends function. 

The initial state of an endpoint is T_UNBND, meaning that the endpoint is not bound to a protocol address. Before using the endpoint to transfer data, you must bind it to a protocol address by calling the OTBind function.

SPECIAL CONSIDERATIONS
The first time you open a provider of any kind, Open Transport allocates needed resources at system task time, calling the ScheduleSystemTask function to do this. To allow this processing to take place, you need to call SystemTask or WaitNextEvent from a foreground task while waiting for the endpoint to be created.

The OTAsyncOpenEndpoint function disposes of the configuration structure returned by the OTCreateConfiguration function. If you want to use the same configuration to open additional endpoints, you must obtain a valid copy of the configuration structure by calling the OTCloneConfiguration function before you call the OTAsyncOpenEndpoint function. For more information, see "Configuring and Opening a Provider".

SEE ALSO
The OTOpenEndpoint function.*/
OSStatus OTAsyncOpenEndpoint( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OTNotifyProcPtr proc, 
                     void* contextPtr){};

/*OTAtomicClearBit

Clears a bit in a byte. (Deprecated in Mac OS X v10.4.)

Boolean OTAtomicClearBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);
Parameters
bytePtr
bitNumber
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTAtomicClearBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
){};

/*OTDestroyConfiguration

Deletes an OTConfiguration structure. (Deprecated in Mac OS X v10.4.)

void OTDestroyConfiguration (
   OTConfigurationRef cfig
);
Parameters
cfig
Discussion

The OTDestroyConfiguration function deletes the OTConfiguration structure that you specify in the cfig parameter and releases all associated memory.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTDestroyConfiguration (
   OTConfigurationRef cfig
){};

/*OTUnbind

Dissociates an endpoint from its address or cancels an asynchronous call to the OTBind function. (Deprecated in Mac OS X v10.4.)

OSStatus OTUnbind (
   EndpointRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If you call the OTUnbind function asynchronously and you have not installed a notifier function, the only way to determine that the endpoint has been unbound is to use the OTGetEndpointState function to poll the state of the endpoint. The function returns the kOTStateChangeErr result when the OTUnbind function returns. If the function succeeds, the state of the endpoint is T_UNBND. If it fails, its state is T_IDLE.

After you unbind an endpoint, you can no longer use it to send or receive information. You can use the OTCloseProvider function to deallocate memory reserved for the endpoint, or you can use the OTBind function to associate it with another address and then resume transferring data or establishing a connection.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTUnbind (
   EndpointRef ref
){};

/*InitOpenTransport
Initializes the parts of Open Transport for use by the application or code resource.

C INTERFACE 
OSStatus InitOpenTransport(void);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

PARAMETERS 
function result 
An error code. See Appendix B. 
DISCUSSION
Call this function before using other Open Transport functions. 

If you need to know whether Open Transport is present at start-up time, but you don't need to use it (e.g. an installer),you can use the Gestalt function and its Open Transport selectors as described in "The Gestalt Selector and Response Bits". However, for normal applications, your calling the InitOpenTransport function is sufficient to test for the presence of Open Transport.

To initialize only the parts of Open Transport that handle ports and implement the Open Transport utility functions call the InitOpenTransportUtilities function.

SPECIAL CONSIDERATIONS 
You must make sure that your A5 world is correctly initialized for 68000 code resources.

If your program uses the Apple Shared Library Manager (ASLM), you must call the InitLibraryManager function to initialize ASLM before calling the InitOpenTransport function. To initialize ASLM, use the InitLibraryManager function, described in the Apple Shared Library Manager Developer's Guide.

For applications, Open Transport patches the ExitToShell trap when you call the function InitOpenTransport. The patch calls the function CloseOpenTransport if Open Transport is still active when your application quits.

SEE ALSO
"The Gestalt Selector and Response Bits".

"Initializing and Closing Open Transport". 

The CloseOpenTransport function.*/
OSStatus InitOpenTransport(void){};

/*CloseOpenTransport
Unregisters your application or code resource connection to Open Transport.

C INTERFACE 
void CloseOpenTransport(void);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

DISCUSSION
The CloseOpenTransport function tells Open Transport that your application or code resource has finished using it. You can call this function only at system task time. You must not call this function if you have any outstanding network I/O in progress, such as an outstanding asynchronous operation.

When your application finishes using Open Transport, you have the option of using this function to unload Open Transport without stopping execution if your application has other tasks to perform that do not require Open Transport. If you are writing an application, you are not required to use this function, but it is strongly recommended that you do so.

If you are writing a code resource, a CFM code fragment, or a shared library, you must call the CloseOpenTransport function before unloading from memory.

System software cannot unload the Open Transport kernel until the last software module on your computer that called the InitOpenTransport function has also called the CloseOpenTransport function.

SPECIAL CONSIDERATIONS 
If your client uses the Apple Shared Library Manager, be sure you call the CleanupLibraryManager function after calling the CloseOpenTransport function. 

SEE ALSO
The InitOpenTransport function. 

The InitOpenTransportUtilities function. 

"Getting Started With Open Transport" in Networking With Open Transport.*/
void CloseOpenTransport(void){};

/*OTRcvConnect

Reads the status of an outstanding or completed asynchronous call to theOTConnect function. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvConnect (
   EndpointRef ref,
   TCall * call
);
Parameters
ref
call
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTRcvConnect function to determine the status of a previously issued OTConnect call. If you want to retrieve information about the connection, you must allocate buffers for the addr field and, if required, the opt and udata fields before you make the call.

If the endpoint is synchronous and blocking, the OTRcvConnect function waits for the connection to be accepted or rejected. If the connection is accepted, the function returns with a kOTNoError result. If the connection is rejected, the function returns with a kOTLookErr result. In this case, you should call the OTLook function to verify that a T_DISCONNECT event is the reason for the kOTLookErr, and then you should call the OTRcvDisconnect function to clear the event.

If the endpoint is asynchronous or nonblocking, the OTRcvConnect function returns with the kOTNoDataErr result if the connection has not yet been established.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvConnect (
   EndpointRef ref,
   TCall * call
){};

/*OTCloneConfiguration

Copies an OTConfiguration structure. (Deprecated in Mac OS X v10.4.)

OTConfigurationRef OTCloneConfiguration (
   OTConfigurationRef cfig
);
Parameters
cfig
Return Value

See the description of the OTConfigurationRef data type.
Discussion

The OTCloneConfiguration function copies the OTConfiguration structure that you specify in the cfig parameter and returns a pointer to the copy. Because the internal format of an OTConfiguration structure is private, you must use the OTCloneConfiguration function to obtain two identical structures. For example, you can use this function when another application passes you a configuration structure that you want to reuse but for which you do not have the original configuration string. By cloning the structure, you have access to an additional copy of the configuration even without knowing its configuration string.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTConfigurationRef OTCloneConfiguration (
   OTConfigurationRef cfig
){};

/*OTLook

Determines the current asynchronous event pending for an endpoint. (Deprecated in Mac OS X v10.4.)

OTResult OTLook (
   EndpointRef ref
);
Parameters
ref
Return Value

See the description of the OTResult data type.
Discussion

You use the OTLook function in one of two cases. First, if the endpoint is in synchronous mode, you can call the OTLook function to poll for incoming data or connection requests. Second, certain asynchronous events might cause a synchronous function to fail with the result kOTLookErr. For example, if you call OTAccept and the endpoint gets a T_DISCONNECT event, the OTAccept function returns with kOTLookErr. In this case, you need to call the OTLook function to determine what event caused the original function to fail. Table 3-7 on page 3-26 lists the functions that might return the kOTLookErr result and the events that can cause these functions to fail.

The OTLook function returns an integer value that specifies the asynchronous event pending for the endpoint specified by the ref parameter. On error, OTLook returns a negative integer corresponding to a result code.

If there are multiple events pending, the OTLook function first looks for one ofthe following events: T_LISTEN, T_CONNECT, T_DISCONNECT, T_UDERR, or T_ORDREL. If it finds more than one of these, it returns them to you in first-in, first-out order. After processing these events, the OTLook function looks for the T_DATA, T_REQUEST, and T_REPLY events. If it finds more than one of these, it returns them to you in first-in, first-out order. You cannot use the OTLook function to poll for completion events.

Unless you are operating exclusively in synchronous mode, it is recommended that you use notifier functions to get information about pending events for an endpoint.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTLook (
   EndpointRef ref
){};

/*OTSndOrderlyDisconnect

Initiates or completes an orderly disconnection. (Deprecated in Mac OS X v10.4.)

OSStatus OTSndOrderlyDisconnect (
   EndpointRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTSndOrderlyDisconnect function to initiate an orderly release of a connection and to indicate to the peer endpoint that you have no more data to send. After calling this function, you must not send any more data over the connection. However, you can still continue to receive data if the peer endpoint has not yet called the OTSndOrderlyDisconnect function.

This function is a service that is not supported by all protocols. If it is supported, the servtype field of the TEndpointInfo structure has the value T_COTS_ORD or T_TRANS_ORD.

The OTSndOrderlyDisconnect function behaves exactly the same in all modes of operation.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSndOrderlyDisconnect (
   EndpointRef ref
){};

/*OTRcvDisconnect

Identifies the cause of a connection break or of a connection rejection, acknowledges and clears the corresponding disconnection event. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvDisconnect (
   EndpointRef ref,
   TDiscon * discon
);
Parameters
ref
discon
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Calling the OTRcvDisconnect function clears the corresponding disconnection event and retrieves any user data sent with the disconnection.

If you do not care about data returned with the disconnection and do not needto know the reason for the disconnection nor the sequence ID, you may specify a nil pointer for the discon parameter. In this case, the provider discards any user data associated with the disconnection.

The OTRcvDisconnect function behaves in the same way for all modes of operation. If there is no disconnection request pending, the function returns with the kOTNoDisconnectErr result. If there is a disconnection request pending, the function returns either the kOTNoError or kOTBufferOverflowErr result. In the latter instance, you need to check the discon field of the TEndpointInfo structure for your endpoint and make sure that the buffer referenced by the udata.buf field is at least as big as the value specified for the discon field.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvDisconnect (
   EndpointRef ref,
   TDiscon * discon
){};


/*OTRcvOrderlyDisconnect

Acknowledges a request for an orderly disconnect. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvOrderlyDisconnect (
   EndpointRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTRcvOrderlyDisconnect function is a service that is not supported by all protocols. If it is, the servtype field of the TEndpointInfo structure has the value T_COTS_ORD or T_TRANS_ORD for the endpoint.

After using the OTRcvOrderlyDisconnect function to acknowledge receipt of a disconnection request, there will not be any more data to receive. Calls to the OTRcv function (for a transactionless connection) or to the OTRcvRequest function (for a transaction-based connection) after acknowledging a disconnection request fail with the kOTOutStateErr result. If the endpoint supports a remote orderly disconnect, you can still send data over the connection if you have not yet called the OTSndOrderlyDisconnect function.

The OTRcvOrderlyDisconnect function behaves in the same way in all modes of operation. If there is no disconnection request pending, the function returns with the kOTNoReleaseErr result. It there is a disconnection request pending, the function returns either the kOTNoError or kOTBufferOverflowErr result. In the latter instance, you need to check the discon field of theTEndpointInfo structure for your endpoint and make sure that the buffer referenced by the udata.buf field is at least as big as the value specified for the discon field.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvOrderlyDisconnect (
   EndpointRef ref
){};

/*OTEnterNotifier

Limits the notifications that can be sent to your notifier. (Deprecated in Mac OS X v10.4.)

Boolean OTEnterNotifier (
   ProviderRef ref
);
Parameters
ref
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTEnterNotifier (
   ProviderRef ref
){};

/*OTSndDisconnect

Tears down an open connection (abortive disconnect) or rejects an incoming connection request. (Deprecated in Mac OS X v10.4.)

OSStatus OTSndDisconnect (
   EndpointRef ref,
   TCall * call
);
Parameters
ref
call
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

There are two functions that you can use to tear down a connection: OTSndDisconnect for an abortive disconnect, or OTSndOrderlyDisconnect for an orderly disconnect. It is recommended that you use the OTSndOrderlyDisconnect function for tearing down a connection whenever possible and that you use the OTSndDisconnect function only for rejecting incoming connection requests.

If the endpoint is in asynchronous mode, the OTSndDisconnect function returns immediately with a result of kOTNoError to indicate that the disconnection process has begun and that your notifier function will be called when the process completes.

When the connection has been broken, the provider issues a T_DISCONNECTCOMPLETE event. If you have installed a notifier function, Open Transport calls your notifier and passes this event in the code parameter. The cookie parameter contains the call parameter. If you have not installed a notifier function, you cannot determine when this function completes.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTSndDisconnect (
   EndpointRef ref,
   TCall * call
){};

/*OTListen

Listens for an incoming connection request. (Deprecated in Mac OS X v10.4.)

OSStatus OTListen (
   EndpointRef ref,
   TCall * call
);
Parameters
ref
call
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You use the OTListen function to listen for incoming connection requests. On return, the function fills in the TCall structure referenced by the call parameter with information about the connection request. After retrieving the connection request using the OTListen function, you can reject the request using the OTSndDisconnect function, or you can accept the request using the OTAccept function.

If the endpoint is in synchronous mode and is blocking, the OTListen function returns when a connection request has arrived. If the endpoint is in asynchronous mode or is not blocking, the OTListen function returns any pending connection requests or returns the kOTNoDataErr result if there are no pending connection requests. You can also call the OTListen function from within a notifier function in response to the T_LISTEN event. In this case, the function returns a result immediately.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTListen (
   EndpointRef ref,
   TCall * call
){};

/*OTLeaveNotifier

Allows Open Transport to resume sending primary and completion events. (Deprecated in Mac OS X v10.4.)

void OTLeaveNotifier (
   ProviderRef ref
);
Parameters
ref
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTLeaveNotifier (
   ProviderRef ref
){};

/*OTAckSends

Specifies that a provider make an internal copy of data being sent and that it notify you when it has finished sending data. (Deprecated in Mac OS X v10.4.)

OSStatus OTAckSends (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

By default, providers make an internal copy of data before sending it and they do not acknowledge sends. If you use the OTAckSends function to specify that the provider acknowledge sends and you call a function that sends data, the provider does not copy the data before sending it. Instead, it reads data directly from your buffer while sending. For this reason, you must not change the contents of your buffer until the provider is no longer using it. The provider lets you know that it has finished using the buffer by calling your notifier function and passing T_MEMORYRELEASED event code for the code parameter, a pointer to the buffer that was sent in the cookie parameter, and the size of the buffer in the result parameter.

If you have not installed a notifier function for the provider, this function returns the kOTAccessErr result.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTAckSends (
   ProviderRef ref
){};

/*OTIoctl

Sends a module-specific command to an Open Transport protocol module. (Deprecated in Mac OS X v10.4.)

SInt32 OTIoctl (
   ProviderRef ref,
   UInt32 cmd,
   void * data
);
Parameters
ref
cmd

A routine selector for the module-specific command.
data

Data to be used by the module-specific command, or a pointer to such data. The interpretation of the data parameter is command specific.
Discussion

The OTIoctl function sends a module-specific command to an Open Transport protocol module. The OTIoctl function runs synchronously or asynchronously, matching the provider’s mode of execution.

If the OTIoctl function completes synchronously without error, it returns 0 or a positive integer. The positive integer’s meaning is command specific. If the OTIoctl function fails while executing synchronously, its return value is a negative integer corresponding to an Open Transport result code.

If the OTIoctl function runs asynchronously, it returns immediately with a return value kOTNoError or another Open Transport result code. When the function completes execution, Open Transport calls the notifier function you specify, passing the event code kStreamIoctlEvent and a result parameter indicating the result of the completed OTIoctl function. If the value of the result parameter is greater than 0, the corresponding result code is defined by the command; otherwise, the value of the result parameter corresponds to an Open Transport result code.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

SInt32 OTIoctl (
   ProviderRef ref,
   UInt32 cmd,
   void * data
){};

/*OTAccept

Accepts an incoming connection request. (Deprecated in Mac OS X v10.4.)

OSStatus OTAccept (
   EndpointRef listener,
   EndpointRef worker,
   TCall * call
);
Parameters
listener
worker
call
Return Value

A result code. See “Open Transport Result Codes”.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTAccept (
   EndpointRef listener,
   EndpointRef worker,
   TCall * call
){};

/*OTOpenEndpoint
Opens an endpoint. This function is synchronous, and creates an endpoint that operates synchronously.

C INTERFACE 
EndpointRef OTOpenEndpoint ( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OSStatus* err);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

PARAMETERS 
config 
A pointer to an endpoint configuration structure that specifies the endpoint's characteristics. You obtain a value for the config parameter by calling the OTCreateConfiguration function. The OTOpenEndpoint function disposes of the configuration structure before returning. 
oflag 
Reserved; must be set to 0. 
info 
A pointer to a TEndpointInfo structure to be filled in by the OTOpenEndpoint function. Specify NULL for this parameter if you do not want the OTOpenEndpoint function to provide endpoint information. 
err 
A pointer to the result code for this function. 
function result 
An endpoint reference for the endpoint that has been created or NULL if the endpoint has not been created. 
DISCUSSION
The OTOpenEndpoint function opens an endpoint having the configuration specified by the config parameter. The function returns an endpoint reference, by which you refer to the created endpoint when calling provider functions. If the OTOpenEndpoint function fails, its return value is kOTInvalidEndpointRef. 

The function creates an endpoint that is synchronous, does not block, and does not acknowledge sends. To change these settings, you can call the OTSetAsynchronous function, the OTSetBlocking function and the OTAckSends function. 

The initial state of an endpoint is T_UNBND, meaning that the endpoint is not bound to an address. Before using the endpoint to transfer data, you must bind it to an address by calling the OTBind function.

To close and delete an endpoint, call the OTCloseProvider function.

SPECIAL CONSIDERATIONS 
The OTOpenEndpoint function can only be called at system task time because it is a synchronous function. 

The OTOpenEndpoint function disposes of the configuration structure passed in as a parameter. If you want to use the same configuration to open additional endpoints, you must obtain a copy of the configuration structure before calling the OTOpenEndpoint function, by calling the OTCloneConfiguration function. 

SEE ALSO
"Creating a Configuration Structure". 

"Reusing Provider Configurations". 

The OTAsyncOpenEndpoint function.

"Endpoint States".*/
EndpointRef OTOpenEndpoint ( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OSStatus* err){};

/*OTMemcpy

Copies data from one memory location to another; the source and destination locations must not overlap. (Deprecated in Mac OS X v10.4.)

void OTMemcpy (
   void * dest,
   const void * src,
   OTByteCount nBytes
);
Parameters
dest
src
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTMemcpy (
   void * dest,
   const void * src,
   OTByteCount nBytes
){};

/*OTOpenMapperInContext

Creates a synchronous mapper provider and returns a mapper reference. (Deprecated in Mac OS X v10.4.)

MapperRef OTOpenMapperInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   OSStatus * err,
   OTClientContextPtr clientContext
);
Parameters
config
oflag
err
clientContext
Return Value

See the description of the MapperRef data type.
Discussion

Applications may pass a NULL pointer but non-applications must always pass a valid client context pointer.

You receive a client context pointer when you call the function InitOpenTransportInContext. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

MapperRef OTOpenMapperInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   OSStatus * err,
   OTClientContextPtr clientContext
){};

/*OTLookupName

Finds and returns all addresses that correspond to a particular name or name pattern, or confirms that a name is registered. (Deprecated in Mac OS X v10.4.)

OSStatus OTLookupName (
   MapperRef ref,
   TLookupRequest * req,
   TLookupReply * reply
);
Parameters
ref
req
reply
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You can use the OTLookupName function to find out whether a name is registered and what address is associated with that name. You use the req parameter to supply the information needed for the search: what name should be looked up and, optionally, what node contains that information, how many matches you expect to find, and how long the search should continue before the function returns. On return, the reply parameter contains the names field that points to the buffer where the matching entries are stored and the rspcount field that specifies the number of matching entries.

For each registered name found, the OTLookupName function stores the following information in the buffer referenced by the names field of the reply parameter:unsigned short addrLen; / length of address that follows/
unsigned short nameLen; / length of name that follows /
unsigned char addr[]; / address /
unsigned char name[]; / name, padded to quad-word boundary/


If you are searching for names using a name pattern and you expect that more than one name will be returned to you, you need to parse the reply buffer to extract the matching names.

If you call the OTLookupName function asynchronously, the mapper provider calls your notifier function passing one of two completion codes for the code parameter (T_LKUPNAMERESULT or T_LKUPNAMECOMPLETE) and passing the reply parameter in the cookie parameter. The mapper provider passes the T_LKUPNAMERESULT code each time it stores a name in the reply buffer, and it passes the T_LKUPNAMECOMPLETE code when it is done. When you receive this event, examine the rspcount field to determine whether there is a last name to retrieve from the reply buffer. The use of both codes is a feature that gives you a choice about how to process multiple names when searching for names matching a pattern.
If you decide to allocate a buffer that is large enough to contain all the names returned, you can ignore the T_LKUPNAMERESULT code and call a function that parses the buffer once the OTLookupName function has completed—that is, once the provider calls your notifier function using the T_LKUPNAMECOMPLETE event.
If you want to save memory or if you don’t know how large a buffer to allocate, you can use the following method to process the names returned. Each time that the T_LKUPNAMERESULT event is passed, you must do something with the reply from the reply buffer. You can copy it somewhere, or you can delete it if it isn’t a name you’re interested in. Then, from inside your notifier you must set the reply->names.len field or the reply->rspcount field back to 0 (thus allowing the mapper provider to overwrite the original name). This tells the mapper provider that you are ready to receive another name. Accordingly, when the mapper provider has inserted another name into your reply buffer, it calls your notifier passing the T_LKUPNAMERESULT code, and you can process the new entry as you have processed the first entry. This method also saves you the trouble of having to parse through the buffer to extract name and address information.

The cookie parameter to the notifier contains the reply parameter.

The format of the names and protocol addresses are specific to the underlying protocol. Consult the documentation supplied for your protocol for more information.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTLookupName (
   MapperRef ref,
   TLookupRequest * req,
   TLookupReply * reply
){};

/*OTSndUData

Sends data using a connectionless transactionless endpoint. (Deprecated in Mac OS X v10.4.)

OSStatus OTSndUData (
   EndpointRef ref,
   TUnitData * udata
);
Parameters
ref
udata

A pointer to a TUnitData structure that specifies thedata to be sent and its destination. 
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If the endpoint is in synchronous, blocking mode, the OTSndUData function returns immediately. If flow-control restrictions prevent its sending the data, it retries the operation until it is able to send it. If the endpoint is in nonblocking mode, the OTSndUData function returns a kOTFlowErr result if flow-control restrictions prevent the data from being sent. When the endpoint provider is able to send the data, it calls your notifier function, passing T_GODATA for the code parameter. You can then call the OTSndUData function from your notifier to send the data. You can also retrieve this event by polling the endpoint using the OTLook function.

Some endpoint providers are not able to detect immediately whether you specified incorrect address or option information. In such cases, the provider calls your notifier function when it detects the error, passing the T_UDERR for the code parameter to advise you that an error has occurred. You can determine the cause of this event by calling the OTRcvUDErr function and examining the value of the uderr->error parameter. It is important that you call the OTRcvUDErr function even if you are not interested in examining the cause of the error. Failing to do this leaves the endpoint in an invalid state for doing other sends and makes the endpoint provider unable to deallocate memory reserved for internal buffers associated with the send.

The next table shows how the endpoint’s mode of execution and blocking status affects the behavior of the OTSndUData function.
Table A-2  
	
Blocking	
Nonblocking

Synchronous	
The function returns when the provider lifts flow-control restrictions The kOTFlowErr result is never returned.	
The function returns immediately. the kOTFlowErr result might be returned

Asynchronous	
The function returns immediately. The kOTFlowErr result is never returned.	
the function returns immediately. the kOTFlowErr result might be returned.

Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSndUData (
   EndpointRef ref,
   TUnitData * udata
){};

/*OTRcvUData

Reads data sent by a client using a connectionless transactionless protocol. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvUData (
   EndpointRef ref,
   TUnitData * udata,
   OTFlags * flags
);
Parameters
ref
udata
flags
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

When the OTRcvUData function returns, it passes a pointer to a TUnitData structure containing information about the data read and a pointer to a flags variable that is set to indicate whether there is more data to be retrieved. If the buffer pointed to by the udata->udata.buf field is not large enough to hold the current data unit, the endpoint provider fills the buffer and sets the flags parameter to T_MORE to indicate that you must call the OTRcvUData function again to receive additional data. Subsequent calls to the OTRcvUData function return 0 for the length of the address and option buffers until you receive the full data unit. The last unit to be received does not have the T_MORE flag set.

If the endpoint is in asynchronous mode or is not blocking and data is not available, the OTRcvUData function fails with the kOTNoDataErr result. The endpoint provider uses the T_DATA event to notify the endpoint when data becomes available. You can use a notifier function or the OTLook function to retrieve the event. Once you get the T_DATA event, you should continue calling the OTRcvUData function until it returns the kOTNoDataErr result.

It is possible that the provider generates an erroneous T_DATA event. This is the case when the provider calls your notifier, passing T_DATA for the code parameter; but when you execute the OTRcvUData function, it returns with a kOTNoDataErr result. If this happens, you should continue normal processing and assume that the next T_DATA event is genuine.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvUData (
   EndpointRef ref,
   TUnitData * udata,
   OTFlags * flags
){};

/*OTElapsedMicroseconds

Calculates the time elapsed in microseconds since a specified time. (Deprecated in Mac OS X v10.4.)

UInt32 OTElapsedMicroseconds (
   OTTimeStamp * startTime
);
Parameters
startTime
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
UInt32 OTElapsedMicroseconds (
   OTTimeStamp * startTime
){};

/*DisposeOTNotifyUPP

Disposes of a universal procedure pointer (UPP) to a notification callback. (Deprecated in Mac OS X v10.4.)

void DisposeOTNotifyUPP (
   OTNotifyUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void DisposeOTNotifyUPP (
   OTNotifyUPP userUPP
){};

/*OTSetAsynchronous

Sets a provider’s mode of execution to asynchronous. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetAsynchronous (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetAsynchronous function causes all functions for the provider specified in the ref parameter to run asynchronously. You must install a notifier function for the provider if it needs to receive completion events. You can install a notifier function either before or after calling the OTSetAsynchronous function.

Changing a provider’s mode of execution does not affect its notifier function, if any; the notifier function remains installed.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetAsynchronous (
   ProviderRef ref
){};

/*OTTimeStampInMilliseconds

Calculates the time elapsed in milliseconds since since a specified time. (Deprecated in Mac OS X v10.4.)

UInt32 OTTimeStampInMilliseconds (
   OTTimeStamp * delta
);
Parameters
delta
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
UInt32 OTTimeStampInMilliseconds (
   OTTimeStamp * delta
){};

/*OTSubtractTimeStamps

Subtracts one timestamp value from another. (Deprecated in Mac OS X v10.4.)

OTTimeStamp * OTSubtractTimeStamps (
   OTTimeStamp * result,
   OTTimeStamp * startTime,
   OTTimeStamp * endEnd
);
Parameters
result
startTime
endEnd
Return Value

See the description of the OTTimeStamp data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTTimeStamp * OTSubtractTimeStamps (
   OTTimeStamp * result,
   OTTimeStamp * startTime,
   OTTimeStamp * endEnd
){};

/*OTMemset

Sets the specified memory range to a specific value. (Deprecated in Mac OS X v10.4.)

void OTMemset (
   void * dest,
   OTUInt8Param toSet,
   OTByteCount nBytes
);
Parameters
dest
toSet
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTMemset (
   void * dest,
   OTUInt8Param toSet,
   OTByteCount nBytes
){};

