#include <QD/QD.h>

//work


/*ATSUFindFontName

Obtains a name string and index value for the first font in a name table that matches the specified ATSUI font ID, name code, platform, script, and/or language.

OSStatus ATSUFindFontName (
   ATSUFontID iFontID,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ByteCount iMaximumNameLength,
   Ptr oName,
   ByteCount *oActualNameLength,
   ItemCount *oFontNameIndex
);
Parameters
iFontID

The ATSUFontID value of the font for which to obtain a name string. Note that because Apple Type Services assigns ATSUFontID values systemwide at runtime, font IDs can change across system restarts. 
iFontNameCode

The FontNameCode value of the font for which to obtain a name string. The FontNameCode is a UInt32 data type, and it is defined in the SFNTTypes.h header file.
iFontNamePlatform

A FontPlatformCode value specifying the encoding of the font, for example, kFontUnicodePlatform, kFontMacintoshPlatform, kFontReservedPlatform, kFontMicrosoftPlatform, or kFontCustomPlatform. If you pass the kFontNoPlatformCode constant, ATSUFindFontName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontPlatformCode type and a list of possible values.
iFontNameScript

A FontScriptCode value specifying the script code of the font, for example, kFontRomanScript. If you pass the kFontNoScriptCode constant, ATSUFindFontName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontScriptCode type and a list of possible values.
iFontNameLanguage

A FontLanguageCode value specifying the language of the font, for example, kFontNorwegianLanguage. If you pass the kFontNoLanguageCode constant, ATSUFindFontName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontLanguageCode type and a list of possible values.
iMaximumNameLength

A ByteCount value specifying the maximum length of the font name to obtain. Typically, this is equivalent to the size of the buffer that you have allocated in the oName parameter. To determine this length, see the Discussion.
oName

A pointer to a buffer. On return, the buffer contains the name string of the first font in the font name table matching your specified parameters. If the buffer you allocate is not large enough, ATSUFindFontName produces a partial string.
oActualNameLength

A pointer to a ByteCount value. On return, the value specifies the actual length of the complete name string. This may be greater than the value passed in the iMaximumNameLength parameter. You should check this value to ensure that you have allocated sufficient memory and therefore obtained the complete name string for the font.
oFontNameIndex

A pointer to an ItemCount value. On return, the value provides a 0-based index to the font name in the font name table.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUFindFontName function obtains a name string and index value for the first font in a name table that matches the specified ATSUI font ID, name code, platform, script, and/or language.

Typically you use the ATSUFindFontName function by calling it twice, as follows:
Pass NULL for the oName and OFontNameIndex parameters, 0 for the iMaximumNameLength parameter, and valid values for the other parameters. ATSUFindFontName returns the length of the font name string in the oActualNameLength parameter.
Allocate enough space for a buffer of the returned size, then call the function again, passing a valid pointer to the buffer in the oName parameter. On return, the buffer contains the font name string. 

To obtain an ATSUI font ID for the first font in a name table that matches the specified name string, name code, platform, script, and/or language, call the function ATSUFindFontFromName. To obtain the font name string, name code, platform, script, and language for the font that matches an ATSUI font ID and name table index, call the function ATSUGetIndFontName.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicode.h*/
OSStatus ATSUFindFontName (
   ATSUFontID iFontID,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ByteCount iMaximumNameLength,
   Ptr oName,
   ByteCount *oActualNameLength,
   ItemCount *oFontNameIndex
){};

