#include <QD/ATSUnicodeGlyphs.h>

/*ATSUGetNativeCurveType

Obtains the type of outline path used for glyphs associated with a given style object.

OSStatus ATSUGetNativeCurveType (
   ATSUStyle iATSUStyle,
   ATSCurveType *oCurveType
);
Parameters
iATSUStyle

An ATSUStyle value specifying the style object to examine. 
oCurveType

A pointer to an ATSCurveType value. On return, the value provides a constant specifying the type of outline path being used. Possible values include kATSCubicCurveType, kATSQuadCurveType, and kATSOtherCurveType. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

You can call the ATSUGetNativeCurveType function to obtain the type of outline path used for glyphs associated with a given style object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
OSStatus ATSUGetNativeCurveType (
   ATSUStyle iATSUStyle,
   ATSCurveType *oCurveType
){
printf ("ATSUGetNativeCurveType",iATSUStyle,*oCurveType);
};

/*ATSUGetGlyphInfo

Obtains a copy of the style and layout information for each glyph in a line. (Deprecated in Mac OS X v10.3. Use functions from “Accessing Glyph Data” instead.)

Not recommended.

OSStatus ATSUGetGlyphInfo (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineStart,
   UniCharCount iLineLength,
   ByteCount *ioBufferSize,
   ATSUGlyphInfoArray *oGlyphInfoPtr
);

Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iLineStart

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the line to examine. To indicate that the line starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iLineLength parameter. 
iLineLength

A UniCharCount value specifying the length of the line. If you want the line to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
ioBufferSize

A pointer to a ByteCount value specifying the size of the buffer you have allocated for the ATSUGlyphInfoArray structure produced in the oGlyphInfoPtr parameter. On return, the value specifies the actual size of the ATSUGlyphInfoArray structure.
oGlyphInfoPtr

A pointer to an ATSUGlyphInfoArray structure. On return, the structure contains values identifying the text layout object, the number of glyphs in the specified line, and an array of ATSUGlyphInfo structures for each of the glyphs. Each ATSUGlyphInfo structure contains information identifying the glyph, the style object with which it is associated, and other related layout values. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUGetGlyphInfo function obtains a copy of the style and layout information for each glyph in a line of text. Copying can be slow, so it’s best to use this function only if you do not plan to modify the glyph information. If you do modify the glyph information, you can only draw the modified glyphs by calling the function ATSUDrawGlyphInfo. Because you are working with a copy of the glyph data and not the actual data that ATSUI has, if you try to draw text by calling the ATSUDrawText function, none of the changes you make to the glyph information will be reflected in the drawn text. 

Note that is you obtain glyph information with the function ATSUGetGlyphInfo and then draw glyphs using ATSUDrawGlyphInfo, ATSUI does not take synthetic styles into account when it draw. This means that font substitution will not work.

If you want to modify glyph information you should instead use the ATSUI direct-access functions ATSUGlyphGetQuadraticPaths or ATSUGlyphGetCubicPaths. You use each of these functions along with callback functions you supply for drawing the glyphs. When you modify and draw glyphs using ATSUI’s direct-access functions, you obtain access to the same information as that supplied by the function ATSUGetGlyphInfo, but in a way that allows font substitution to work. For more information on retrieving and drawing glyph outlines, see Inside Mac OS X: Rendering Unicode Text With ATSUI.

The Unicode characters in the text layout object (ATSUTextLayout) and the glyphs returned by the function ATSUGetGlyphInfo do not necessarily have a one-to-one correspondence. For example, the accented Latin character é can be represented by an e with a combining ´ accent. In this case, two characters map to one glyph.

Common ligatures such as ﬁ also form automatically for some fonts, causing two characters to map to one glyph. Right-to-left scripts such as Arabic, and complex scripts such as Devanagari or Thai have even more complicated mappings from characters to glyphs.

For this reason it's best to use the high level ATSUI functions whenever possible, and to associate a paragraph of text with a text layout object. Your application is then completely insulated from such issues.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
ATSUnicodeGlyphs.h*/
OSStatus ATSUGetGlyphInfo (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineStart,
   UniCharCount iLineLength,
   ByteCount *ioBufferSize,
   ATSUGlyphInfoArray *oGlyphInfoPtr
){};

/*DisposeATSQuadraticClosePathUPP

Disposes of a universal procedure pointer (UPP) to a quadratic close-path callback.

void DisposeATSQuadraticClosePathUPP (
   ATSQuadraticClosePathUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSQuadraticClosePathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSQuadraticClosePathUPP (
   ATSQuadraticClosePathUPP userUPP
){};


/*DisposeATSQuadraticCurveUPP

Disposes of a universal procedure pointer (UPP) to a quadratic curve callback.

void DisposeATSQuadraticCurveUPP (
   ATSQuadraticCurveUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSQuadraticCurveProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSQuadraticCurveUPP (
   ATSQuadraticCurveUPP userUPP
){};

/*DisposeATSQuadraticLineUPP

Disposes of a universal procedure pointer (UPP) to a quadratic line callback.

void DisposeATSQuadraticLineUPP (
   ATSQuadraticLineUPP userUPP
);
Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSQuadraticLineProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSQuadraticLineUPP (
   ATSQuadraticLineUPP userUPP
){};


/*DisposeATSQuadraticNewPathUPP

Disposes of a universal procedure pointer (UPP) to a quadratic new-path callback.

void DisposeATSQuadraticNewPathUPP (
   ATSQuadraticNewPathUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSQuadraticNewPathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/

void DisposeATSQuadraticNewPathUPP (
   ATSQuadraticNewPathUPP userUPP
){};



/*ATSUGlyphGetQuadraticPaths

Obtains the quadratic outline paths for a glyph.

OSStatus ATSUGlyphGetQuadraticPaths (
   ATSUStyle iATSUStyle,
   GlyphID iGlyphID,
   ATSQuadraticNewPathUPP iNewPathProc,
   ATSQuadraticLineUPP iLineProc,
   ATSQuadraticCurveUPP iCurveProc,
   ATSQuadraticClosePathUPP iClosePathProc,
   void *iCallbackDataPtr,
   OSStatus *oCallbackResult
);

Parameters
iATSUStyle

An ATSUStyle value specifying the style object to examine. 
iGlyphID

A GlyphID value identifying the glyph for which to obtain an outline path. 
iNewPathProc

A pointer to your callback function for handling the new-path operation.
iLineProc

A pointer to your callback function for handling the line operation.
iCurveProc

A pointer to your callback function for handling the curve operation.
iClosePathProc

A pointer to your callback function for handling the close-path operation.
iCallbackDataPtr

A pointer to any data your callback functions need. This pointer is passed through to your callback functions.
oCallbackResult

On output, a value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetQuadraticPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The glyph outlines that are returned are the hinted outlines at the font size specified in the style object. If you want to use unhinted outlines, set the font size to a very large size, (for example, 1000 points) and then scale down the returned curves to the desired size.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
OSStatus ATSUGlyphGetQuadraticPaths (
   ATSUStyle iATSUStyle,
   GlyphID iGlyphID,
   ATSQuadraticNewPathUPP iNewPathProc,
   ATSQuadraticLineUPP iLineProc,
   ATSQuadraticCurveUPP iCurveProc,
   ATSQuadraticClosePathUPP iClosePathProc,
   void *iCallbackDataPtr,
   OSStatus *oCallbackResult
){};

/*NewATSQuadraticClosePathUPP

Creates a new universal procedure pointer (UPP) to a quadratic close-path callback.

ATSQuadraticClosePathUPP NewATSQuadraticClosePathUPP (
   ATSQuadraticClosePathProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your quadratic close-path callback. 
Return Value

On return, a UPP to the quadratic close-path callback.
Discussion

See the callback ATSQuadraticClosePathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSQuadraticClosePathUPP NewATSQuadraticClosePathUPP (
   ATSQuadraticClosePathProcPtr userRoutine
){};


/*NewATSQuadraticCurveUPP

Creates a new universal procedure pointer (UPP) to a quadratic curve callback.

ATSQuadraticCurveUPP NewATSQuadraticCurveUPP (
   ATSQuadraticCurveProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your quadratic curve callback. 
Return Value

On return, a UPP to the quadratic curve callback.
Discussion

See the callback ATSQuadraticCurveProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSQuadraticCurveUPP NewATSQuadraticCurveUPP (
   ATSQuadraticCurveProcPtr userRoutine
){};

/*NewATSCubicMoveToUPP

Creates a new universal procedure pointer (UPP) to a cubic move-to callback.

ATSCubicMoveToUPP NewATSCubicMoveToUPP (
   ATSCubicMoveToProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your cubic move-to callback. 
Return Value

On return, a UPP to the cubic move-to callback.
Discussion

See the callback ATSCubicMoveToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSCubicMoveToUPP NewATSCubicMoveToUPP (
   ATSCubicMoveToProcPtr userRoutine
){};

/*NewATSQuadraticLineUPP

Creates a new universal procedure pointer (UPP) to a quadratic line callback.

ATSQuadraticLineUPP NewATSQuadraticLineUPP (
   ATSQuadraticLineProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your quadratic line callback. 
Return Value

On return, a UPP to the quadratic line callback.
Discussion

See the callback ATSQuadraticLineProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSQuadraticLineUPP NewATSQuadraticLineUPP (
   ATSQuadraticLineProcPtr userRoutine
){};


/*NewATSQuadraticNewPathUPP

Creates a new universal procedure pointer (UPP) to a quadratic new-path callback.

ATSQuadraticNewPathUPP NewATSQuadraticNewPathUPP (
   ATSQuadraticNewPathProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your quadratic new-path callback. 
Return Value

On return, a UPP to the quadratic new-path callback.
Discussion

See the callback ATSQuadraticNewPathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSQuadraticNewPathUPP NewATSQuadraticNewPathUPP (
   ATSQuadraticNewPathProcPtr userRoutine
){};


/*NewATSCubicLineToUPP

Creates a new universal procedure pointer (UPP) to a cubic line-to callback.

ATSCubicLineToUPP NewATSCubicLineToUPP (
   ATSCubicLineToProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your cubic line-to callback. 
Return Value

On return, a UPP to the cubic line-to callback.
Discussion

See the callback ATSCubicLineToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSCubicLineToUPP NewATSCubicLineToUPP (
   ATSCubicLineToProcPtr userRoutine
){};

/*DisposeATSCubicClosePathUPP

Disposes of a universal procedure pointer (UPP) to a cubic close-path callback.

void DisposeATSCubicClosePathUPP (
   ATSCubicClosePathUPP userUPP
);
Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSCubicClosePathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSCubicClosePathUPP (
   ATSCubicClosePathUPP userUPP
){};


/*DisposeATSCubicCurveToUPP

Disposes of a universal procedure pointer (UPP) to a cubic curve-to callback.

void DisposeATSCubicCurveToUPP (
   ATSCubicCurveToUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSCubicCurveToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/

void DisposeATSCubicCurveToUPP (
   ATSCubicCurveToUPP userUPP
){};

/*NewATSCubicClosePathUPP

Creates a new universal procedure pointer (UPP) to a cubic close-path callback.

ATSCubicClosePathUPP NewATSCubicClosePathUPP (
   ATSCubicClosePathProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your cubic close-path callback. 
Return Value

On return, a UPP to the cubic close-path callback.
Discussion

See the callback ATSCubicClosePathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSCubicClosePathUPP NewATSCubicClosePathUPP (
   ATSCubicClosePathProcPtr userRoutine
){};


/*ATSUGlyphGetCubicPaths

Obtains the cubic outline paths for a glyph.

OSStatus ATSUGlyphGetCubicPaths (
   ATSUStyle iATSUStyle,
   GlyphID iGlyphID,
   ATSCubicMoveToUPP iMoveToProc,
   ATSCubicLineToUPP iLineToProc,
   ATSCubicCurveToUPP iCurveToProc,
   ATSCubicClosePathUPP iClosePathProc,
   void *iCallbackDataPtr,
   OSStatus *oCallbackResult
);
Parameters
iATSUStyle

An ATSUStyle value specifying the style object to examine. 
iGlyphID

A GlyphID value identifying the glyph for which to obtain an outline path. 
iMoveToProc

A pointer to your callback function for handling the pen move-to operation.
iLineToProc

A pointer to your callback function for handling the line-to operation.
iCurveToProc

A pointer to your callback function for handling the curve-to operation.
iClosePathProc

A pointer to your callback function for handling the close-path operation.
iCallbackDataPtr

A pointer to any data your callback functions need. This pointer is passed through to your callback functions.
oCallbackResult

On output, a value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetCubicPaths function stops parsing the glyph path outline and returns the result kATSOutlineParseAbortedErr. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The glyph outlines that are returned are the hinted outlines at the font size specified in the style object. If you want to use unhinted outlines, set the font size to a very large size, (for example, 1000 points) and then scale down the returned curves to the desired size.

As of Mac OS X version 10.1, the curves returned by this function are derived from quadratic curves, irrespective of the native curve type of the font.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/


OSStatus ATSUGlyphGetCubicPaths (
   ATSUStyle iATSUStyle,
   GlyphID iGlyphID,
   ATSCubicMoveToUPP iMoveToProc,
   ATSCubicLineToUPP iLineToProc,
   ATSCubicCurveToUPP iCurveToProc,
   ATSCubicClosePathUPP iClosePathProc,
   void *iCallbackDataPtr,
   OSStatus *oCallbackResult
){};


/*DisposeATSCubicMoveToUPP

Disposes of a universal procedure pointer (UPP) to a cubic move-to callback.

void DisposeATSCubicMoveToUPP (
   ATSCubicMoveToUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSCubicMoveToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSCubicMoveToUPP (
   ATSCubicMoveToUPP userUPP
){};

/*DisposeATSCubicLineToUPP

Disposes of a universal procedure pointer (UPP) to a cubic line-to callback.

void DisposeATSCubicLineToUPP (
   ATSCubicLineToUPP userUPP
);
Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSCubicLineToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSCubicLineToUPP (
   ATSCubicLineToUPP userUPP
){};

/*NewATSCubicCurveToUPP

Creates a new universal procedure pointer (UPP) to a cubic curve-to callback.

ATSCubicCurveToUPP NewATSCubicCurveToUPP (
   ATSCubicCurveToProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your cubic curve-to callback. 
Return Value

On return, a UPP to the cubic curve-to callback.
Discussion

See the callback ATSCubicCurveToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSCubicCurveToUPP NewATSCubicCurveToUPP (
   ATSCubicCurveToProcPtr userRoutine
){};














