#include <QD/QD.h>

//work

/*QDPictRelease

Releases a QDPict picture.

void QDPictRelease (
   QDPictRef picture
);
Parameters
picture

A QDPict picture which you created or retained.
Discussion

After you finish using a QDPict picture that you created or retained, you should call this function to release the picture. If the picture’s retain count becomes 0, this function frees the picture and any associated resources such as the picture’s data provider.
Availability
Available in Mac OS X v10.1 and later.
Declared In
QDPictToCGContext.h*/

void QDPictRelease (
   QDPictRef picture
){};

/*QDPictCreateWithURL

Creates a QDPict picture, using QuickDraw picture data specified with a Core Foundation URL.

QDPictRef QDPictCreateWithURL (
   CFURLRef url
);
Parameters
url

A Core Foundation URL that specifies a PICT file containing the QuickDraw picture data. The picture header data must begin at either the first byte or the 513th byte in the PICT file. The picture bounds must not be an empty rectangle.
Return Value

A new QDPict picture, or NULL if the picture data is not valid. The initial retain count is 1. After you finish using the picture, you should release it by calling QDPictRelease.
Discussion

This function creates a QDPict picture that you can draw in a Quartz context. For general information about QDPict pictures, see QDPictRef.
Availability
Available in Mac OS X v10.1 and later.
Declared In
QDPictToCGContext.h*/

QDPictRef QDPictCreateWithURL (
   CFURLRef url
){};


/*QDPictGetBounds

Returns the intended location and size of a QDPict picture.

CGRect QDPictGetBounds (
   QDPictRef picture
);
Parameters
picture

A QDPict picture.
Return Value

A Quartz rectangle that represents the intended location and size of the picture. The rectangle is in default user space with one unit = 1/72 inch, and the origin is the lower-left corner of the picture. 
Discussion

If the native resolution in the picture data is not 72 pixels per inch, the bounding rectangle returned by this function is scaled as follows:    width = width in pixels * 72 / horizontal resolution
    height = height in pixels * 72 / vertical resolution

Availability
Available in Mac OS X v10.1 and later.
Declared In
QDPictToCGContext.h*/
CGRect QDPictGetBounds (
   QDPictRef picture
){};

/*QDPictDrawToCGContext

Draws a QuickDraw picture in a Quartz context.

OSStatus QDPictDrawToCGContext (
   CGContextRef context,
   CGRect rect,
   QDPictRef picture
);
Parameters
context

The Quartz context in which to draw.
rect

The rectangular area in which to draw the picture. You should specify the origin and size of this rectangle in user space units. The origin is the lower left corner of the picture when drawn. If necessary, the picture is scaled to fit inside this rectangle. To get unscaled results, you should pass the rectangle returned by QDPictGetBounds. For additional information about scaling, see the discussion below.
picture

A QDPict picture.
Return Value

A result code. A non-zero result indicates that the picture was not successfully drawn.
Discussion

This function converts the picture data in a QDPict picture into an equivalent sequence of Quartz 2D graphics operations. Conceptually this is the same processing path taken when an application running in Mac OS X draws into a QuickDraw printing port. 

When drawing a QDPict picture in a Quartz context, there are two ways to change the horizontal or vertical scale of the picture:
Construct the drawing rectangle (see the rect parameter) by applying the change of scale to the bounds rectangle returned by QDPictGetBounds. In this case, QuickDraw scales all the graphic elements in the picture except for patterns—the same behavior as DrawPicture.
Prior to calling QDPictDrawToCGContext, apply the change of scale to the current transformation matrix in the Quartz context—for example, by calling CGContextScaleCTM. In this case, QuickDraw scales the entire picture including patterns.

In a bitmap-based context, the picture is rendered into the bitmap. In a PDF-based context, the picture is converted into a PDF content stream. If the picture uses transfer modes such as srcXor that do not have an analog in Quartz 2D, the PDF representation may not match the original exactly.
Availability
Available in Mac OS X v10.1 and later.
Declared In
QDPictToCGContext.h*/
OSStatus QDPictDrawToCGContext (
   CGContextRef context,
   CGRect rect,
   QDPictRef picture
){};

