#import <Cocoa/Cocoa.h>
#import <QuickTime/QuickTime.h>
#import <QTKit/QTKit.h>
//#import <QTKit/QTTime.h>
//#import <QTKit/QTTimeRange.h>
//#import <QTKit/QTMovie.h>


/*Constants

The following constants specify the movie attributes that you can get and set using the movieAttributes and setMovieAttributes methods. To get or set a single attribute, use attributeForKey or setAttribute.
Constant	
Description
QTMovieActiveSegmentAttribute	
The active segment of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTimeRange structure. 

Available in Mac OS X v10.3 and later.
QTMovieAutoAlternatesAttribute	
The auto-alternate state of a QTMovie object. The value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieCopyrightAttribute	
The copyright string of a QTMovie object; the value for this key is of type NSString. 

Available in Mac OS X v10.3 and later.
QTMovieCreationTimeAttribute	
The creation time of a QTMovie object; the value for this key is of type NSDate.

Available in Mac OS X v10.3 and later.
QTMovieCurrentSizeAttribute	
The current size of a QTMovie object; the value for this key is of type NSValue, interpreted as an NSSize structure.

Available in Mac OS X v10.3 and later.
QTMovieCurrentTimeAttribute	
The current time of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTime structure. 

Available in Mac OS X v10.3 and later.
QTMovieDataSizeAttribute	
The data size of a QTMovie. The value for this key is of type NSNumber, which is interpreted as a long long.

Available in Mac OS X v10.3 and later.
QTMovieDelegateAttribute	
The delegate for a QTMovie object. The value for this key is of type NSObject. 

Available in Mac OS X v10.3 and later.
QTMovieDisplayNameAttribute	
The display name of a QTMovie object. A display name is stored as user data in a movie file and hence may differ from the base name of the movie’s filename or URL. The value for this key is of type NSString.

Available in Mac OS X v10.3 and later.
QTMovieDontInteractWithUserAttribute	
When set in a dictionary passed to movieWithAttributes or initWithAttributes, this prevents QuickTime from interacting with the user during movie initialization. The value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieDurationAttribute	
The duration of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTime structure.

Available in Mac OS X v10.3 and later.
QTMovieEditableAttribute	
The editable setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie can be edited.

Available in Mac OS X v10.3 and later.
QTMovieFileNameAttribute	
The file name string of a QTMovie object; the value for this key is of type NSString.

Available in Mac OS X v10.3 and later.
QTMovieHasAudioAttribute	
The audio data setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie contains audio data.

Available in Mac OS X v10.3 and later.
QTMovieHasDurationAttribute	
The duration setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie has a duration. (Some types of movies, for instance QuickTime VR movies, have no duration.)

Available in Mac OS X v10.3 and later.
QTMovieHasVideoAttribute	
The video data setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie contains video data.

Available in Mac OS X v10.3 and later.
QTMovieIsActiveAttribute	
The active setting; the value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieIsInteractiveAttribute	
The interactive setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is interactive.

Available in Mac OS X v10.3 and later.
QTMovieIsLinearAttribute	
The linear setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is linear, as opposed to a non-linear QuickTime VR movie. 

Available in Mac OS X v10.3 and later.
QTMovieIsSteppableAttribute	
The steppable setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie can step from frame to frame.

Available in Mac OS X v10.3 and later.
QTMovieLoadStateAttribute	
The load state value; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMovieLoopsAttribute	
The looping setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is set to loop.

Available in Mac OS X v10.3 and later.
QTMovieLoopsBackAndForthAttribute	
The palindrome looping setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is set to loop back and forth. Note that QTMovieLoopsAttribute and QTMovieLoopsBackAndForthAttribute are independent and indeed exclusive. QTMovieLoopsAttribute is used to get and set the state of normal looping; QTMovieLoopsBackAndForthAttribute is used to get and set the state of palindrome looping. 

Available in Mac OS X v10.3 and later.
QTMovieModificationTimeAttribute	
The modification time of a QTMovie object; the value for this key is of type NSDate.

Available in Mac OS X v10.3 and later.
QTMovieMutedAttribute	
The mute setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie volume is muted.

Available in Mac OS X v10.3 and later.
QTMovieNaturalSizeAttribute	
The natural size of a QTMovie object; the value for this key is of type NSValue, interpreted as an NSSize structure.

Available in Mac OS X v10.3 and later.
QTMoviePlaysAllFramesAttribute	
The play-all-frames setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie will play all frames.

Available in Mac OS X v10.3 and later.
QTMoviePlaysSelectionOnlyAttribute	
The play-selection setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie will play only the current selection.

Available in Mac OS X v10.3 and later.
QTMoviePosterTimeAttribute	
The movie poster time of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTime structure.

Available in Mac OS X v10.3 and later.
QTMoviePreferredMutedAttribute	
The preferred mute setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie preferred mute setting is muted.

Available in Mac OS X v10.3 and later.
QTMoviePreferredRateAttribute	
The preferred rate; the value for this key is of type NSNumber, interpreted as a float.

Available in Mac OS X v10.3 and later.
QTMoviePreferredVolumeAttribute	
The preferred volume; the value for this key is of type NSNumber, interpreted as a float.

Available in Mac OS X v10.3 and later.
QTMoviePreviewModeAttribute	
The preview mode setting; the value for this key is of type NSNumber, interpreted as a BOOL. This value is YES if the movie is in preview mode.

Available in Mac OS X v10.3 and later.
QTMoviePreviewRangeAttribute	
The preview range of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTimeRange structure.

Available in Mac OS X v10.3 and later.
QTMovieRateAttribute	
The movie rate; the value for this key is of type NSNumber, interpreted as a float.

Available in Mac OS X v10.3 and later.
QTMovieRateChangesPreservePitchAttribute	
When the playback rate is not unity, audio must be resampled in order to play at the new rate. The default resampling affects the pitch of the audio (for example, playing at 2x speed raises the pitch by an octave, 1/2x lowers an octave). If this property is set on the Movie, an alternative algorithm is used, which alters the speed without changing the pitch. As this is more computationally expensive, this property may be silently ignored on some slow CPUs.

Available in Mac OS X v10.3 and later.
QTMovieSelectionAttribute	
The selection range of a QTMovie object; the value for this key is of type NSValue, interpreted as a QTTimeRange structure.

Available in Mac OS X v10.3 and later.
QTMovieTimeScaleAttribute	
The movie time scale; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMovieURLAttribute	
The URL of a QTMovie object; the value for this key is of type NSURL.

Available in Mac OS X v10.3 and later.
QTMovieVolumeAttribute	
The movie volume; the value for this key is of type NSNumber, interpreted as a float.

Available in Mac OS X v10.3 and later.


The following constants specify items in dictionaries passed to QTMovie notifications and delegate methods. 
Constant	
Description
QTMovieMessageNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieMessageNotification notification to indicate the message. The associated value is an NSString.

Available in Mac OS X v10.3 and later.
QTMovieRateDidChangeNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieRateDidChangeNotification notification to indicate the new playback rate. The associated value is an NSNumber that holds a float.

Available in Mac OS X v10.3 and later.
QTMovieStatusFlagsNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieStatusStringPostedNotification notification to indicate status flags. The associated value is an NSNumber that holds a long.

Available in Mac OS X v10.3 and later.
QTMovieStatusCodeNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieStatusStringPostedNotification notification to indicate a status code (or error code). The associated value is an NSNumber that holds an int.

Available in Mac OS X v10.3 and later.
QTMovieStatusStringNotificationParameter	
Used as a key in the userInfo dictionary passed to the QTMovieStatusStringPostedNotification notification to indicate a status string.

Available in Mac OS X v10.3 and later.
QTMovieTargetIDNotificationParameter	
Used as a key in the dictionary passed to the externalMovie: delegate method to indicate that the delegate should return a QTMovie object that has the movie ID specified by the key’s value.

Available in Mac OS X v10.3 and later.
QTMovieTargetNameNotificationParameter	
Used as a key in the dictionary passed to the externalMovie: delegate method to indicate that the delegate should return a QTMovie object that has the movie name specified by the key’s value.

Available in Mac OS X v10.3 and later.


The following constants are dictionary keys that you can use to specify movie attributes, using the writeToFile method.
Constant	
Description
QTMovieExport	
The movie export setting; the value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieExportType	
The movie export type; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMovieFlatten	
The movie flatten setting; the value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.
QTMovieExportSettings	
Information to come.

Available in Mac OS X v10.3 and later.
QTMovieExportManufacturer	
The export manufacturer value; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.


The following constants are dictionary keys that you can use to specify movie attributes, using the addImage method.
Constant	
Description
QTAddImageCodecType	
The image codec string; the value for this key is of type NSString.

Available in Mac OS X v10.3 and later.
QTAddImageCodecQuality	
The image codec value; the value for this key is of type NSNumber.

Available in Mac OS X v10.3 and later.


The following constants are data locators that you can use to specify movie attributes, using the movieWithAttributes and initWithAttributes methods.
Constant	
Description
QTMovieDataReferenceAttribute	
The data reference of a QTMovie object. 

Available in Mac OS X v10.3 and later.
QTMoviePasteboardAttribute	
The pasteboard setting of a QTMovie object.

Available in Mac OS X v10.3 and later.
QTMovieDataAttribute	
The data of a QTMovie object.

Available in Mac OS X v10.3 and later.


The following constants are movie instantiation options that you can use to specify movie attributes, using the movieWithAttributes and initWithAttributes methods.
Constant	
Description
QTMovieFileOffsetAttribute	
The file offset value; the value for this key is of type NSNumber, interpreted as a long long.

Available in Mac OS X v10.3 and later.
QTMovieResolveDataRefAttribute	
The resolved data reference setting; the value for this key is of type NSNumber, interpreted as a BOOL. 
QTMovieAskUnresolvedDataRefAttribute	
The unresolved data reference setting; the value for this key is of type NSNumber, interpreted as a BOOL. 
QTMovieOpenAsyncOKAttribute	
The open async setting; the value for this key is of type NSNumber, interpreted as a BOOL. 

Available in Mac OS X v10.3 and later.*/
 NSString *QTMovieActiveSegmentAttribute;	
 NSString *QTMovieAutoAlternatesAttribute;
 NSString *QTMovieCopyrightAttribute	;
 NSString *QTMovieCreationTimeAttribute;	
 NSString *QTMovieCurrentSizeAttribute	;
 NSString *QTMovieCurrentTimeAttribute;	
 NSString *QTMovieDataSizeAttribute	;
 NSString *QTMovieDelegateAttribute	;
 NSString *QTMovieDisplayNameAttribute	;
 NSString *QTMovieDontInteractWithUserAttribute	;
 NSString *QTMovieDurationAttribute	;
 NSString *QTMovieEditableAttribute	;
 NSString *QTMovieFileNameAttribute	;
 NSString *QTMovieHasAudioAttribute	;
 NSString *QTMovieHasDurationAttribute;	
 NSString *QTMovieHasVideoAttribute	;
 NSString *QTMovieIsActiveAttribute	;
 NSString *QTMovieIsInteractiveAttribute	;
 NSString *QTMovieIsLinearAttribute	;
 NSString *QTMovieIsSteppableAttribute	;
 NSString *QTMovieLoadStateAttribute	;
 NSString *QTMovieLoopsAttribute	;
 NSString *QTMovieLoopsBackAndForthAttribute	;
 NSString *QTMovieModificationTimeAttribute	;
 NSString *QTMovieMutedAttribute	;
 NSString *QTMovieNaturalSizeAttribute	;
 NSString *QTMoviePlaysAllFramesAttribute	;
 NSString *QTMoviePlaysSelectionOnlyAttribute	;
 NSString *QTMoviePosterTimeAttribute	;
 NSString *QTMoviePreferredMutedAttribute	;
 NSString *QTMoviePreferredRateAttribute	;
 NSString *QTMoviePreferredVolumeAttribute	;
 NSString *QTMoviePreviewModeAttribute	;
 NSString *QTMoviePreviewRangeAttribute	;
 NSString *QTMovieRateAttribute	;
 NSString *QTMovieRateChangesPreservePitchAttribute	;
 NSString *QTMovieSelectionAttribute	;
 NSString *QTMovieTimeScaleAttribute	;
 NSString *QTMovieURLAttribute	;
 NSString *QTMovieVolumeAttribute	;
 NSString *QTMovieRateDidChangeNotificationParameter	;
 NSString *QTMovieStatusFlagsNotificationParameter	;
 NSString *QTMovieStatusCodeNotificationParameter	;
 NSString *QTMovieStatusStringNotificationParameter	;
 NSString *QTMovieTargetIDNotificationParameter	;
 NSString *QTMovieTargetNameNotificationParameter	;
 NSString *QTMovieExport	;
 NSString *QTMovieExportType	;
 NSString *QTMovieFlatten	;
 NSString *QTMovieExportSettings	;
 NSString *QTMovieExportManufacturer	;
 NSString *QTAddImageCodecType	;
 NSString *QTAddImageCodecQuality	;
 NSString *QTMovieDataReferenceAttribute	;
 NSString *QTMoviePasteboardAttribute	;
 NSString *QTMovieDataAttribute	;
 NSString *QTMovieFileOffsetAttribute	;
 NSString *QTMovieResolveDataRefAttribute	;
 NSString *QTMovieAskUnresolvedDataRefAttribute	;
 NSString *QTMovieOpenAsyncOKAttribute	;


/*QTMovieSizeDidChangeNotification

Sent when the size of a movie has changed.

This notification contains no userInfo dictionary.
Availability
Available in Mac OS X v10.3 and later.*/

 NSString * QTMovieSizeDidChangeNotification;



//work

@implementation QTMovie

/*initWithFile:error:

- (id)initWithFile:(NSString *)fileName error:(NSError **)errorPtr
Discussion

Initializes a QTMovie object with the data in the file specified by the name fileName. The fileName is assumed to be a full path name for a file. If a QTMovie object cannot be created, an NSError object is returned in the location pointed to by errorPtr. Pass NIL if you do not want an NSError object returned.

Note that alias files should not be passed into this method; the client application is responsible for resolving aliases before handing them to QTKit methods.
Availability
Available in Mac OS X v10.3 and later.*/
- (id)initWithFile:(NSString *)fileName error:(NSError **)errorPtr
 {
}

/*setAttribute:forKey:

- (void)setAttribute:(id)value forKey:(NS String *)attributeKey
Discussion

Set the movie attribute attributeKey to the value specified by the value parameter. A list of supported movie attributes and their acceptable values can be found in the “Constants” section.
Availability
Available in Mac OS X v10.3 and later.*/

- (void) setAttribute: (id)value forKey: (NSString *)attributeKey
 {
//TODO
}

/*quickTimeMovie

- (Movie)quickTimeMovie
Discussion

Returns the QuickTime movie associated with a QTMovie object.
Availability
Available in Mac OS X v10.3 and later.
See Also
– quickTimeMovieController*/
- (Movie)quickTimeMovie{
//TODO
}

/*attributeForKey:

- (id)attributeForKey:(NSString *)attributeKey
Discussion

Returns the current value of the movie attribute attributeKey. A list of supported movie attributes and their acceptable values can be found in the “Constants” section.
Availability
Available in Mac OS X v10.3 and later.*/
- (id)attributeForKey:(NSString *)attributeKey{
//TODO
}

/*play

- (void)play
Discussion

Plays the movie.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)play{
//TODO
}

/*movieFileTypes:

+ (NSArray *)movieFileTypes:(QTMovieTypeOptions)types
Discussion

Returns an array of file types that can be opened as QuickTime movies. Passing zero as the options parameter returns an array of all the common file types that QuickTime can open in place on the current system. This array includes the file type .mov and .mqv, and any files types that can be opened using a movie importer that does not need to write data into a new file while performing the import. This array excludes any file types for still images and any file types that require an aggressive movie importer (for instance, the movie importer for text files). The following values can be used to include some or all of the file types that are normally excluded:enum {
    QTIncludeStillImageTypes  =  1 << 0,
    QTIncludeTranslatableTypes =  1 << 1,
    QTIncludeAggressiveTypes =  1 << 2,
    QTIncludeCommonTypes = 0,
    QTIncludeAllTypes = 0xffff
} QTMovieFileTypeOptions;

Constants	
Description

QTIncludeStillImageTypes	
This value adds to the array all file types for still images that can be opened using a graphics importer.

QTIncludeTranslatableTypes	
This value adds to the array all file types for files that can be opened using a movie importer but for which a new file must be created.

QTIncludeAggressiveTypes	
This value adds to the array all file types for files that can be opened using a movie importer but that are not commonly used in connection with movies (for instance, text or HTML files).

QTIncludeCommonTypes	
This value adds to the array all common file types that QuickTime can open in place on the current system.

QTIncludeAllTypes	
This value adds to the array all file types that QuickTime can open on the current system, using any available movie or graphics importer.

Availability
Available in Mac OS X v10.3 and later.*/
+ (NSArray *)movieFileTypes:(QTMovieFileTypeOptions)types{}


/*movieWithURL:error:

+ (id)movieWithURL:(NSURL *)url error:(NSError **)errorPtr
Discussion

Creates a QTMovie object initialized with the data in the URL specified by url. 

If a QTMovie object cannot be created, an NSError object is returned in the location pointed to by errorPtr. Pass NIL if you do not want an NSError object returned.
Availability
Available in Mac OS X v10.3 and later.*/
+ (id)movieWithURL:(NSURL *)url error:(NSError **)errorPtr{}


/*movieAttributes

- (NSDictionary *)movieAttributes
Discussion

Returns a dictionary containing the current values of all defined movie attributes. A list of supported movie attributes and their acceptable values can be found in the “Constants” section.
Availability
Available in Mac OS X v10.3 and later.*/
- (NSDictionary *)movieAttributes{}

/*currentTime

- (QTTime)currentTime
Discussion

Returns the current time of a QTMovie object as a structure of type QTTime.
Availability
Available in Mac OS X v10.3 and later.*/
- (QTTime)currentTime{}


/*setCurrentTime:

- (void)setCurrentTime:(QTTime)time
Discussion

Sets the movie’s current time setting to time. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void)setCurrentTime:(QTTime)time{}

/*stepForward

- (void)stepForward
Discussion

Sets the movie forward a single frame.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)stepForward{}


/*stepBackward

- (void)stepBackward
Discussion

Sets the movie backward a single frame.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)stepBackward{}


/*stop

- (void)stop
Discussion

Stops the movie playing.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)stop{}


/*gotoBeginning

- (void)gotoBeginning
Discussion

Repositions the play position to the beginning of the movie. If the movie is playing, the movie continues playing from the new position. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void)gotoBeginning{}

/*tracksOfMediaType:

-(NSArray *)tracksOfMediaType:(NSString *)type
Discussion

Returns an array of tracks with the specified media type.
Availability
Available in Mac OS X v10.3 and later.*/
-(NSArray *)tracksOfMediaType:(NSString *)type{}


/*movieWithFile:error:

+ (id)movieWithFile:(NSString *)fileName error:(NSError **)errorPtr
Discussion

Creates a QTMovie object initialized with the data in the file specified by the name fileName. The fileName is assumed to be a full path name for a file. 

If a QTMovie object cannot be created, an NSError object is returned in the location pointed to by errorPtr. Pass NIL if you do not want an NSError object returned.
Availability
Available in Mac OS X v10.3 and later.*/
+ (id)movieWithFile:(NSString *)fileName error:(NSError **)errorPtr{}


/*addImage:forDuration:withAttributes:

- (void)addImage:(NSImage *)image forDuration:(QTTime)duration withAttributes:(NSDictionary *)attributes
Discussion

Adds an image for the specified duration to the receiver, using attributes specified in the attributes dictionary. Keys in the dictionary can be QTAddImageCodecType to select a codec type and QTAddImageCodecQuality to select a quality. Qualities are expected to be specified as NSNumbers, using the codec values like codecNormalQuality. (See ImageCompression.h for the complete list.)
Availability
Available in Mac OS X v10.3 and later.*/
- (void)addImage:(NSImage *)image forDuration:(QTTime)duration withAttributes:(NSDictionary *)attributes{}



/*writeToFile:withAttributes:

-(BOOL)writeToFile:(NSString *)fileName withAttributes:(NSDictionary *)attributes
Discussion

Creates a new movie file of the specified name and having the specified attributes. If the dictionary attributes contains an object whose key is QTMovieFlatten, then the movie is flattened into the specified file. If the dictionary attributes contains an object whose key is QTMovieExport, then the movie is exported into the specified file using a movie exporter whose type is specified by the value of the key QTMovieExportType. The value associated with the QTMovieExportSettings key should be an object of type NSData that contains an atom container of movie export settings. 
Availability
Available in Mac OS X v10.3 and later.
See Also
– movieFormatRepresentation*/
-(BOOL)writeToFile:(NSString *)fileName withAttributes:(NSDictionary *)attributes{}
/*setDelegate:

- (void)setDelegate:(id)delegate
Discussion

Sets the movie’s delegate to delegate. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void)setDelegate:(id)delegate{}



/*updateMovieFile

- (BOOL)updateMovieFile
Discussion

Updates the movie file of a QTMovie. Returns YES if the update succeeds and NO otherwise.
Availability
Available in Mac OS X v10.3 and later.
volume

- (float)volume
Discussion

Returns the movie’s volume as a scalar value of type float. The valid range is 0.0 to 1.0.
Availability
Available in Mac OS X v10.3 and later.*/
- (BOOL)updateMovieFile{}

/*canInitWithFile:

+ (BOOL)canInitWithFile:(NSString *)fileName
Discussion

Returns YES if the contents of the specified file can be used to initialize a QTMovie object.
Availability
Available in Mac OS X v10.3 and later.*/
+ (BOOL)canInitWithFile:(NSString *)fileName{}


/*movieWithData:error:

+ (id)movieWithData:(NSData *)data error:(NSError **)errorPtr
Discussion

Creates a QTMovie object initialized with the data specified by data. 

If a QTMovie object cannot be created, an NSError object is returned in the location pointed to by errorPtr. Pass NIL if you do not want an NSError object returned.
Availability
Available in Mac OS X v10.3 and later.*/
+ (id)movieWithData:(NSData *)data error:(NSError **)errorPtr{}

/*movie

+ (id)movie
Discussion

Creates an empty QTMovie object.
Availability
Available in Mac OS X v10.3 and later.*/
+ (id)movie{}


/*movieFormatRepresentation

- (NSData *)movieFormatRepresentation
Discussion

Returns the movie’s data in an NSData object.
Availability
Available in Mac OS X v10.3 and later.
See Also
– writeToFile:withAttributes:*/
- (NSData *)movieFormatRepresentation{}

/*tracks

-(NSArray *)tracks
Discussion

Returns an array of QTTrack objects associated with the receiver.
Availability
Available in Mac OS X v10.3 and later.*/
-(NSArray *)tracks{}



/*rate

- (float)rate
Discussion

Returns the current rate of a QTMovie object.
Availability
Available in Mac OS X v10.3 and later.*/
- (float)rate{}


/*movieUnfilteredFileTypes

+ (NSArray *)movieUnfilteredFileTypes
Discussion

Returns an array of file types that can be used to initialize a QTMovie object.
Availability
Available in Mac OS X v10.3 and later.*/
+ (NSArray *)movieUnfilteredFileTypes{}


/*setRate:

- (void)setRate:(float)rate
Discussion

Sets the movie’s rate to rate. For instance, 0.0 is stop, 1.0 is playback at normal speed, 2.0 is twice normal speed, and so on.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)setRate:(float)rate{}

/*deleteSegment:

- (void)deleteSegment:(QTTimeRange)segment
Discussion

Deletes from a QTMovie the segment delimited by segment. If the movie is not editable, this method raises an exception. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void)deleteSegment:(QTTimeRange)segment{}

/*canInitWithURL:

+ (BOOL)canInitWithURL:(NSURL *)url
Discussion

Returns YES if the contents of the specified URL can be used to initialize a QTMovie object.
Availability
Available in Mac OS X v10.3 and later.*/
+ (BOOL)canInitWithURL:(NSURL *)url{
printf ("canInitWithURL",url);
}

/*movieWithQuickTimeMovie:disposeWhenDone:error:

+ (id)movieWithQuickTimeMovie:(Movie)movie disposeWhenDone:(BOOL)dispose error:(NSError **)errorPtr
Discussion

Creates a QTMovie object initialized with the data from an existing QuickTime movie movie. The dispose parameter (a BOOL) indicates whether the QTKit should call DisposeMovie on the specified movie when the QTMovie object is deallocated. Passing YES effectively transfers “ownership” of the Movie to the QTKit. (Note that most applications will probably want to pass YES; passing NO means that the application wants to call DisposeMovie itself, perhaps so that it can operate on a Movie after it has been disassociated with a QTMovie object.) 

If a QTMovie object cannot be created, an NSError object is returned in the location pointed to by errorPtr. Pass NIL if you do not want an NSError object returned.

Note that command-line tools that pass NO for the disposeWhenDone parameter must make sure to release the active autorelease pool before calling DisposeMovie on the specified QuickTime movie. Failure to do this may result in a crash. Tools that need to call DisposeMovie before releasing the main autorelease pool can create another autorelease pool associated with the movie.
Availability
Available in Mac OS X v10.3 and later.*/
+ (id)movieWithQuickTimeMovie:(Movie)movie disposeWhenDone:(BOOL)dispose error:(NSError **)errorPtr{
printf ("movieWithQuickTimeMovie",movie,dispose,errorPtr);
}


/*duration

- (QTTime)duration
Discussion

Returns the duration of a QTMovie object as a structure of type QTTime.
Availability
Available in Mac OS X v10.3 and later.*/
- (QTTime)duration{
printf ("duration");
}

/*currentFrameImage

- (NSImage *)currentFrameImage
Discussion

Returns an NSImage for the frame at the current time in a QTMovie.
Availability
Available in Mac OS X v10.3 and later.
See Also
– frameImageAtTime:
– posterImage*/
- (NSImage *)currentFrameImage{}

/*initWithURL:error:

- (id)initWithURL:(NSURL *)url error:(NSError **)errorPtr
Discussion

Initializes a QTMovie object with the data in the URL specified by url. If a QTMovie object cannot be created, an NSError object is returned in the location pointed to by errorPtr. Pass NIL if you do not want an NSError object returned.
Availability
Available in Mac OS X v10.3 and later.*/

- (id)initWithURL:(NSURL *)url error:(NSError **)errorPtr{}


/*setVolume:

- (void)setVolume:(float)volume
Discussion

Sets the movie’s volume to volume. Note that this does not affect the movie’s stored settings.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)setVolume:(float)volume{}

@end
