#include <QuartzCore/CVImageBuffer.h>


/*Image Buffer Attachment Keys

Specify attachment types associated with image buffers.

const CFStringRef   kCVImageBufferCGColorSpaceKey;
const CFStringRef   kCVImageBufferGammaLevelKey;
const CFStringRef   kCVImageBufferCleanApertureKey;
const CFStringRef   kCVImageBufferPreferredCleanApertureKey;
const CFStringRef   kCVImageBufferCleanApertureWidthKey;
const CFStringRef   kCVImageBufferCleanApertureHeightKey;
const CFStringRef   kCVImageBufferCleanApertureHorizontalOffsetKey;
const CFStringRef   kCVImageBufferCleanApertureVerticalOffsetKey;
const CFStringRef   kCVImageBufferFieldCountKey;
const CFStringRef   kCVImageBufferFieldDetailKey;
const CFStringRef   kCVImageBufferFieldDetailTemporalTopFirst;
const CFStringRef   kCVImageBufferFieldDetailTemporalBottomFirst;
const CFStringRef   kCVImageBufferFieldDetailSpatialFirstLineEarly;
const CFStringRef   kCVImageBufferFieldDetailSpatialFirstLineLate;
const CFStringRef   kCVImageBufferPixelAspectRatioKey;
const CFStringRef   kCVImageBufferPixelAspectRatioHorizontalSpacingKey;
const CFStringRef   kCVImageBufferPixelAspectRatioVerticalSpacingKey;
const CFStringRef   kCVImageBufferDisplayDimensionsKey;
const CFStringRef   kCVImageBufferDisplayWidthKey;
const CFStringRef   kCVImageBufferDisplayHeightKey;
const CFStringRef   kCVImageBufferYCbCrMatrixKey;
const CFStringRef   kCVImageBufferYCbCrMatrix_ITU_R_709_2;
const CFStringRef   kCVImageBufferYCbCrMatrix_ITU_R_601_4;
const CFStringRef   kCVImageBufferYCbCrMatrix_SMPTE_240M_1995;
Constants
kCVImageBufferCGColorSpaceKey

The color space for the buffer (type CGColorSpaceRef).

Available in Mac OS X v10.3 and later.
kCVImageBufferGammaLevelKey

The gamma level for this buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureKey

The clean aperture for the buffer (type CFDictionary , containing the clean aperture width, height, and horizontal and vertical offset key-value pairs).

Available in Mac OS X v10.3 and later.
kCVImageBufferPreferredCleanApertureKey

The preferred clean aperture for the buffer (type CFDictionary , containing the clean aperture width, height, and horizontal and vertical offset key-value pairs).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureWidthKey

The clean aperture width (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureHeightKey

The clean aperture height (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureHorizontalOffsetKey

The clean aperture horizontal offset (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureVerticalOffsetKey

The clean aperture vertical offset (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldCountKey

The field count for the buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailKey

Specific information about the field of a video frame in the buffer (type CFDictionary, containing the temporal bottom first and top first and spacial first-line-early and first-line-late keys). 

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailTemporalTopFirst

(type CFString).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailTemporalBottomFirst

(type CFString).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailSpatialFirstLineEarly

(type CFString).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailSpatialFirstLineLate

(type CFString).

Available in Mac OS X v10.3 and later.
kCVImageBufferPixelAspectRatioKey

The pixel aspect ratio of the buffer (type CFDictionary, containing the horizontal and vertical spacing keys).

Available in Mac OS X v10.3 and later.
kCVImageBufferPixelAspectRatioHorizontalSpacingKey

The horizontal component of the buffer aspect ratio (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferPixelAspectRatioVerticalSpacingKey

The vertical component of the buffer aspect ratio (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferDisplayDimensionsKey

The buffer display dimensions (type CFDictionary containing the buffer display width and height keys).

Available in Mac OS X v10.3 and later.
kCVImageBufferDisplayWidthKey

The buffer display width (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferDisplayHeightKey

The buffer display height (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferYCbCrMatrixKey

The type of conversion matrix used for this buffer when converting from YCbCr to RGB images (type CFString). The value for this key should be one of the following constants: kCVImageBufferYCbCrMatrix_ITU_R_709_2, kCVImageBufferYCbCrMatrix_ITU_R_601_4, or kCVImageBufferYCbCrMatrix_SMPTE_240M_1995.

Available in Mac OS X v10.3 and later.
kCVImageBufferYCbCrMatrix_ITU_R_709_2

Specifies the YCbCr to RGB conversion matrix for HDTV digital television (ITU R 709) images. 

Available in Mac OS X v10.3 and later.
kCVImageBufferYCbCrMatrix_ITU_R_601_4

Specifies the YCbCr to RGB conversion matrix for standard digital television ( ITU R 601) images. 

Available in Mac OS X v10.3 and later.
kCVImageBufferYCbCrMatrix_SMPTE_240M_1995

Specifies the YCbCR to RGB conversion matrix for 1920 x 1135 HDTV (SMPTE 240M 1995). 

Available in Mac OS X v10.3 and later.
Discussion

Image buffer attachment keys are stored in a Core Foundation dictionary associated with an image buffer. Note that some of these keys are stored in subdictionaries keyed by a higher-level attribute. For example, the kCVImageBufferDisplayWidthKey and kCVImageBufferDisplayHeightKey attributes are stored in a Core Foundation dictionary keyed to the kCVImageBufferDisplayDimensionsKey attribute.*/
const CFStringRef   kCVImageBufferCGColorSpaceKey;
 const CFStringRef   kCVImageBufferGammaLevelKey;
 const CFStringRef   kCVImageBufferCleanApertureKey;
 const CFStringRef   kCVImageBufferPreferredCleanApertureKey;
 const CFStringRef   kCVImageBufferCleanApertureWidthKey;
 const CFStringRef   kCVImageBufferCleanApertureHeightKey;
 const CFStringRef   kCVImageBufferCleanApertureHorizontalOffsetKey;
 const CFStringRef   kCVImageBufferCleanApertureVerticalOffsetKey;
 const CFStringRef   kCVImageBufferFieldCountKey;
 const CFStringRef   kCVImageBufferFieldDetailKey;
 const CFStringRef   kCVImageBufferFieldDetailTemporalTopFirst;
 const CFStringRef   kCVImageBufferFieldDetailTemporalBottomFirst;
 const CFStringRef   kCVImageBufferFieldDetailSpatialFirstLineEarly;
 const CFStringRef   kCVImageBufferFieldDetailSpatialFirstLineLate;
 const CFStringRef   kCVImageBufferPixelAspectRatioKey;
 const CFStringRef   kCVImageBufferPixelAspectRatioHorizontalSpacingKey;
 const CFStringRef   kCVImageBufferPixelAspectRatioVerticalSpacingKey;
 const CFStringRef   kCVImageBufferDisplayDimensionsKey;
 const CFStringRef   kCVImageBufferDisplayWidthKey;
 const CFStringRef   kCVImageBufferDisplayHeightKey;
 const CFStringRef   kCVImageBufferYCbCrMatrixKey;
 const CFStringRef   kCVImageBufferYCbCrMatrix_ITU_R_709_2;
 const CFStringRef   kCVImageBufferYCbCrMatrix_ITU_R_601_4;
 const CFStringRef   kCVImageBufferYCbCrMatrix_SMPTE_240M_1995;

/*CVImageBufferGetCleanRect

Returns the source rectangle of a Core Video image buffer that represents the clean aperture of the buffer in encoded pixels. 

CGRect CVImageBufferGetCleanRect (
   CVImageBufferRef imageBuffer
);
Parameters
imageBuffer

The image buffer that you want to retrieve the display size from.
Return Value

A CGRect structure returning the nominal display size of the buffer. Returns a rectangle of zero size if called with either a non-CVImageBufferRef type or NULL.
Discussion

The clean aperture size is smaller than the full size of the image. For example, an NTSC DV frame would return a CGRect structure with an origin of (8,0) and a size of (704,480). Note that the origin of this rectangle is always in the lower-left corner. This is the same coordinate system as that used by Quartz and Core Image.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVImageBuffer.h*/
CGRect CVImageBufferGetCleanRect (
   CVImageBufferRef imageBuffer
){
printf ("CVImageBufferGetCleanRect",imageBuffer);
};

