#include <SyncServices/ISyncClient.h>

/*Constants

Use the following constants to specify the type of client you might want to sync simultaneously with using the setShouldSynchronize:withClientsOfType: method. The clientType method also returns one of these constants.
Constant	
Description
ISyncClientTypeApplication	
Indicates the client is an application, such as Mail or iCal.

Available in Mac OS X v10.4 and later.
ISyncClientTypeDevice	
Indicates the client is used to sync a device such as a phone or an iPod.

Available in Mac OS X v10.4 and later.
ISyncClientTypeServer	
Indicates the client is used to sync a remote server such as .Mac.

Available in Mac OS X v10.4 and later.
ISyncClientTypePeer	
Indicates the client is a peer, such as another computer.

Available in Mac OS X v10.4 and later.


The following constants are returned by the lastSyncStatusForEntityName: method to indicate the state of the last sync session.
Constant	
Description
ISyncStatusRunning	
Indicates the client is syncing.

Available in Mac OS X v10.4 and later.
ISyncStatusSuccess	
Indicates the last sync was successful.

Available in Mac OS X v10.4 and later.
ISyncStatusWarnings	
Indicates the last sync resulted in warnings.

Available in Mac OS X v10.4 and later.
ISyncStatusErrors	
Indicates the last sync resulted in errors.

Available in Mac OS X v10.4 and later.
ISyncStatusCancelled	
Indicates the last sync was canceled.

Available in Mac OS X v10.4 and later.
ISyncStatusFailed	
Indicates the last sync failed to complete (for example, the client crashed).

Available in Mac OS X v10.4 and later.
ISyncStatusNever	
Indicates the client has never synced.

Available in Mac OS X v10.4 and later.*/
 NSString * const ISyncClientTypeApplication;
  NSString * const ISyncClientTypeDevice;
  NSString * const ISyncClientTypeServer;
  NSString * const ISyncClientTypePeer;
   NSString * const ISyncStatusRunning;	
  NSString * const ISyncStatusSuccess;	
  NSString * const ISyncStatusWarnings;	
  NSString * const ISyncStatusErrors;
  NSString * const ISyncStatusCancelled;
  NSString * const ISyncStatusFailed;
   NSString * const ISyncStatusNever;


//work

@implementation    ISyncClient
/*setShouldReplaceClientRecords:forEntityNames:

Sets whether or not a client should pull the truth—replace all its records for the specified entities on the next sync.

- (void)setShouldReplaceClientRecords:(BOOL)flag forEntityNames:(NSArray *)entityNames
Discussion

If flag is YES, the client should replace all its local records with the records pulled from the sync engine.

After invoking this method, sending shouldReplaceClientRecordsForEntityName: to any new sessions created for this client returns YES, and sending shouldPushChangesForEntityName: or shouldPushAllRecordsForEntityName: returns NO.

This request takes effect on the next session created after invoking this method and remains in effect until the client successfully passes through the pull phase of that session. The sync engine needs to know whether a client is going to pull the truth before entering the negotiation phase. This is necessary to detect conflicting push the truth and pull the truth requests.

A client should not remove its local records until after the records are successfully pulled from the sync engine. The local records can be safely removed after shouldReplaceClientRecordsForEntityName: returns YES.

This method is typically used by a configuration tool that allows the user to revert to the state of the truth.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)setShouldReplaceClientRecords:(BOOL)flag forEntityNames:(NSArray *)entityNames{}


/*supportedEntityNames

Returns an array of NSString objects containing the names of the entities the client supports.

- (NSArray *)supportedEntityNames
Discussion

This property is set when registering the client.
Availability
Available in Mac OS X v10.4 and later.
See Also
registerClientWithIdentifier:descriptionFilePath: (ISyncManager)*/
- (NSArray *)supportedEntityNames{}


/*SetSyncAlertHandler:selector:

Sets the target and action to be invoked when an observed client creates a session and begins syncing.

- (void)setSyncAlertHandler:(id)handler selector:(SEL)selector
Discussion

When selector is sent to handler, your client has the opportunity to join the sync session. 

The selector method is expected to take the receiver (an ISyncClient object) as the first argument and an array of entity names (an NSArray object) as the second argument. The method signature for selector should look like:- (void)client:(ISyncClient *)client willSyncEntityNames:(NSArray  *)entityNames


If selector returns without creating a session, the sync engine assumes the client will not join the session. If this client already has another handler registered—for example, from another client process—this method raises an exception. An observer is automatically removed when the client terminates.

When you create a session using the beginSessionWithClient:entityNames:beforeDate: ISyncSession class method, you specify how long you are willing to wait for the sync session. This is the length of time you are willing to wait for all the other clients to join the session. If a client takes too long to join a session, the sync engine may proceed without it.

Use this method instead of setSyncAlertToolPath: if you want to notify a running application only. Use setShouldSynchronize:withClientsOfType: to specify the types of clients the receiver wishes to observe. If both a tool and an observer are registered, only the observer is notified.

Note: If your client is multithreaded, the thread that registers the alert handler has to exist, otherwise the client does not receive the alert.

Availability
Available in Mac OS X v10.4 and later.
See Also
shouldSynchronizeWithClientsOfType:
syncAlertToolPath*/
- (void)setSyncAlertHandler:(id)handler selector:(SEL)selector{}


/*setFilters:

Sets the receiver’s filters used to control the records pulled from the sync engine to filters, an array of objects conforming to the ISyncFiltering protocol.

- (void)setFilters:(NSArray *)filters
Discussion

You use filters to define a subset of the records that this client syncs.

When pulling changes, the sync engine passes each record to each filter before giving changes to that record to the client. If any one of the filters rejects the record, it is not be given to the client. See ISyncFilter for some default filters.

This method recomputes the records that need to be sent to the client during the next sync operation which can be expensive. Consequently, do not invoke this method frequently. 
Availability
Available in Mac OS X v10.4 and later.
See Also
filters*/
- (void)setFilters:(NSArray *)filters{}


/*setShouldSynchronize:withClientsOfType:

Adds the receiver as an observer of alerts when clients of the specified type sync.

- (void)setShouldSynchronize:(BOOL)flag withClientsOfType:(NSString *)clientType
Discussion

If flag is YES the receiver is added; otherwise the receiver is removed as an observer for alerts of the specified type. Alternatively, you can specify this information when registering the client using the client description file. You can invoke this method multiple times to register additional client types.

Typically, you use this method to setup a dependency between two clients. For example, Address Book might observe all types of clients, and is given an opportunity to join any syncs which synchronize entities defined in the contacts schema. The .Mac client might observe only device clients, so it can join a Palm or phone sync session. The client is notified only if it has entities in common with the client that initiated the sync.
Availability
Available in Mac OS X v10.4 and later.
See Also
shouldSynchronizeWithClientsOfType: (ISyncManager)
setSyncAlertHandler:selector:
setSyncAlertToolPath:
registerClientWithIdentifier:descriptionFilePath:*/
- (void)setShouldSynchronize:(BOOL)flag withClientsOfType:(NSString *)clientType{}




@end