#include <SystemConfiguration/SystemConfiguration.h>

//work


/*SCPreferencesGetValue

CFPropertyListRef SCPreferencesGetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef key );  
Parameters
prefs
The preferences session.
key
The preference key to be returned.
Return Value

Returns the value associated with the specified preference key; NULL if no value was located. 
Discussion 

Returns the data associated with a preference key. 

This function retrieves data associated with the specified key. 

Note: To avoid inadvertantly reading stale data, first call the SCPreferencesLock function.*/
CFPropertyListRef SCPreferencesGetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef key ){};  

/*SCPreferencesCreate

SCPreferencesRef SCPreferencesCreate ( 
    CFAllocatorRef allocator, 
    CFStringRef name, 
    CFStringRef prefsID );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for this preferences session. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
name
A string that describes the name of the calling process.
prefsID
A string that identifies the name of the group of preferences to be accessed or updated.
Return Value

Returns a reference to the new SCPreferences. You must release the returned value. 
Discussion 

Initiates access to the per-system set of configuration preferences.*/
SCPreferencesRef SCPreferencesCreate ( 
    CFAllocatorRef allocator, 
    CFStringRef name, 
    CFStringRef prefsID ){};

  
/*SCPreferencesLock

Boolean SCPreferencesLock ( 
    SCPreferencesRef prefs, 
    Boolean wait );  
Parameters
prefs
The preferences session.
wait
A boolean flag indicating whether the calling process should block waiting for another process to complete its update operation and release its lock.
Return Value

Returns TRUE if the lock was obtained; FALSE if an error occurred. 
Discussion 

Locks access to the configuration preferences. 

This function obtains exclusive access to the configuration preferences. Clients attempting to obtain exclusive access to the preferences will either receive a kSCStatusPrefsBusy error or block waiting for the lock to be released.*/
Boolean SCPreferencesLock ( 
    SCPreferencesRef prefs, 
    Boolean wait ){};

 /*SCPreferencesCommitChanges

Boolean SCPreferencesCommitChanges ( 
    SCPreferencesRef prefs );  
Parameters
prefs
The preferences session.
Return Value

Returns TRUE if the lock was obtained; FALSE if an error occurred. 
Discussion 

Commits changes made to the configuration preferences to persistent storage. 

This function commits any changes to permanent storage. Implicit calls to the SCPreferencesLock and SCPreferencesUnlock functions will be made if exclusive access has not already been established. 

Note: This routine commits changes to persistent storage. Call the SCPreferencesApplyChanges function to apply the changes to the running system*/
Boolean SCPreferencesCommitChanges ( 
    SCPreferencesRef prefs ){};

  /*SCPreferencesSetValue

Boolean SCPreferencesSetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef key, 
    CFPropertyListRef value );  
Parameters
prefs
The preferences session.
key
The preference key to be updated.
value
The CFPropertyListRef object containing the data to be associated with the specified preference key.
Return Value

Returns TRUE if the value was set; FALSE if an error occurred. 
Discussion 

Updates the data associated with a preference key. 

This function adds or replaces the value associated with the specified key. To commit these changes to permanent storage a call must be made to the SCPreferencesCommitChanges function.*/
Boolean SCPreferencesSetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef key, 
    CFPropertyListRef value ){};
  
/*SCPreferencesUnlock

Boolean SCPreferencesUnlock ( 
    SCPreferencesRef prefs );  
Parameters
prefs
The preferences session.
Return Value

Returns TRUE if the lock was obtained; FALSE if an error occurred. 
Discussion 

Releases exclusive access to the configuration preferences. 

This function releases the exclusive access lock to the preferences. Other clients will be now be able to establish exclusive access to the preferences.*/

Boolean SCPreferencesUnlock ( 
    SCPreferencesRef prefs ){};

  
/*SCPreferencesApplyChanges

Boolean SCPreferencesApplyChanges ( 
    SCPreferencesRef prefs );  
Parameters
prefs
The preferences session.
Return Value

Returns TRUE if the lock was obtained; FALSE if an error occurred. 
Discussion 

Requests that the currently stored configuration preferences be applied to the active configuration.*/
Boolean SCPreferencesApplyChanges ( 
    SCPreferencesRef prefs ){};

  
/*SCPreferencesCopyKeyList

CFArrayRef SCPreferencesCopyKeyList ( 
    SCPreferencesRef prefs );  
Parameters
prefs
The preferences session.
Return Value

Returns the list of keys. You must release the returned value. 
Discussion 

Returns an array of currently defined preference keys.*/
CFArrayRef SCPreferencesCopyKeyList ( 
    SCPreferencesRef prefs ){};

 




