/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Subgraph;

public class Node {
    public Object[] workingData = new Object[3];
    public int[] workingInts = new int[4];
    public Object data;
    public boolean flag;
    public int height = 40;
    public int rowOrder = -1;
    public EdgeList incoming = new EdgeList();
    public int incomingOffset = -1;
    public int index;
    public int nestingIndex = -1;
    public EdgeList outgoing = new EdgeList();
    public int outgoingOffset = -1;
    Insets padding;
    private Subgraph parent;
    public int rank;
    public double sortValue;
    public int width = 50;
    public int x;
    public int y;

    public Node() {
    }

    public Node(Object data) {
        this(data, null);
    }

    public Node(Subgraph parent) {
        this(null, parent);
    }

    public Node(Object data, Subgraph parent) {
        this.data = data;
        this.parent = parent;
        if (parent != null) {
            parent.addMember(this);
        }
    }

    public int getOffsetIncoming() {
        if (this.incomingOffset == -1) {
            return this.width / 2;
        }
        return this.incomingOffset;
    }

    public int getOffsetOutgoing() {
        if (this.outgoingOffset == -1) {
            return this.width / 2;
        }
        return this.outgoingOffset;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public Subgraph getParent() {
        return this.parent;
    }

    public boolean isNested(Node node) {
        return node == this;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public void setParent(Subgraph parent) {
        this.parent = parent;
    }

    public String toString() {
        return "N(" + this.data + ")";
    }
}

