/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.p1cartoon;

import com.ibm.java2dhelper.Graphics2DRenderer;
import info.jinwoomin.logging.ILoggable;
import info.jinwoomin.logging.ILogger;
import info.jinwoomin.logging.SimpleLogger;
import info.jinwoomin.p1cartoon.PageCounter;
import java.awt.Button;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class P1Cartoon
implements PaintListener,
SelectionListener,
KeyListener,
ILoggable,
Observer {
    private final Graphics2DRenderer renderer = new Graphics2DRenderer();
    private ILogger logger = null;
    private Display display = null;
    private Shell shell = null;
    private Canvas canvas = null;
    private Text txtPage = null;
    private Button comp = new Button();
    private Image awtImage = null;
    private org.eclipse.swt.graphics.Image image = null;
    private String imageFolder = new String();
    private List imageFiles = new ArrayList();
    private int currPosition = 0;
    private boolean isOneInTwoPages = false;
    private boolean isRightToLeft = false;
    private boolean useResample = false;
    private PageCounter counter = new PageCounter();

    public void start() {
        this.logger.info("P1Cartoon v0.3 by mio (yeoupooh) started.");
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setImage(ImageDescriptor.createFromURL((URL)this.getClass().getResource("/pooh.ico")).createImage());
        this.shell.setText("P1Cartoon v0.3 by mio (yeoupooh)");
        this.shell.setSize(400, 300);
        this.shell.addKeyListener((KeyListener)this);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        this.loadSettings();
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 5;
        this.canvas = new Canvas((Composite)this.shell, 0);
        this.image = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/pooh.jpg")).createImage();
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addKeyListener((KeyListener)this);
        this.canvas.setLayoutData((Object)gridData);
        this.canvas.setFocus();
        gridData = new GridData();
        org.eclipse.swt.widgets.Button chkOneInTwoPages = new org.eclipse.swt.widgets.Button((Composite)this.shell, 32);
        chkOneInTwoPages.setText("Double Page");
        chkOneInTwoPages.addKeyListener((KeyListener)this);
        chkOneInTwoPages.addSelectionListener((SelectionListener)this);
        chkOneInTwoPages.setSelection(this.isOneInTwoPages);
        chkOneInTwoPages.setToolTipText("2\uba74\uc744 \ud55c \uc7a5\uc758 \uc774\ubbf8\uc9c0\uc5d0 \uc2a4\uce94\ud55c \uacbd\uc6b0 \uccb4\ud06c\ud569\ub2c8\ub2e4.");
        chkOneInTwoPages.setLayoutData((Object)gridData);
        gridData = new GridData();
        org.eclipse.swt.widgets.Button chkRightToLeft = new org.eclipse.swt.widgets.Button((Composite)this.shell, 32);
        chkRightToLeft.setText("Right To Left");
        chkRightToLeft.addKeyListener((KeyListener)this);
        chkRightToLeft.addSelectionListener((SelectionListener)this);
        chkRightToLeft.setSelection(this.isRightToLeft);
        chkRightToLeft.setToolTipText("2\uba74\uc774 \ud55c \uc7a5\uc758 \uc774\ubbf8\uc9c0\uc774\uace0 \uc624\ub978\ucabd\uc5d0\uc11c \uc67c\ucabd\uc73c\ub85c \uc77d\uc5b4\uc57c \ud558\ub294 \uacbd\uc6b0 \uccb4\ud06c\ud569\ub2c8\ub2e4.");
        chkRightToLeft.setLayoutData((Object)gridData);
        gridData = new GridData();
        org.eclipse.swt.widgets.Button chkResample = new org.eclipse.swt.widgets.Button((Composite)this.shell, 32);
        chkResample.setText("Resample");
        chkResample.addKeyListener((KeyListener)this);
        chkResample.addSelectionListener((SelectionListener)this);
        chkResample.setSelection(this.useResample);
        chkResample.setToolTipText("\uc774\ubbf8\uc9c0\ub97c \uc880 \ub354 \ubd80\ub4dc\ub7fd\uac8c \ubcf4\ub824\uba74 \uccb4\ud06c\ud569\ub2c8\ub2e4.");
        chkResample.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.txtPage = new Text((Composite)this.shell, 131084);
        this.txtPage.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        org.eclipse.swt.widgets.Button btnSetFolder = new org.eclipse.swt.widgets.Button((Composite)this.shell, 0);
        btnSetFolder.setText("Set Folder...");
        btnSetFolder.addKeyListener((KeyListener)this);
        btnSetFolder.addSelectionListener((SelectionListener)this);
        btnSetFolder.setLayoutData((Object)gridData);
        this.shell.setLayout((Layout)layout);
        this.shell.open();
        this.counter.addObserver(this);
        if (this.imageFolder != null) {
            this.loadFileList();
            this.reloadImage();
            this.canvas.redraw();
            this.counter.setChanged();
        }
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
        this.saveSettings();
        this.logger.info("P1Cartoon v0.3 by mio (yeoupooh) finishied.");
    }

    public static void main(String[] args) {
        P1Cartoon app = new P1Cartoon();
        app.setLogger(new SimpleLogger());
        app.start();
    }

    public void paintControl(PaintEvent e) {
        int srcHeight;
        int srcWidth;
        int srcY;
        int srcX;
        if (this.isOneInTwoPages) {
            srcX = this.image.getImageData().width / 2 * this.currPosition;
            srcY = 0;
            srcWidth = this.image.getImageData().width / 2;
            srcHeight = this.image.getImageData().height;
        } else {
            srcX = 0;
            srcY = 0;
            srcWidth = this.image.getImageData().width;
            srcHeight = this.image.getImageData().height;
        }
        this.logger.debug("useResample=[" + this.useResample + "]");
        if (this.useResample) {
            GC gc = e.gc;
            this.renderer.prepareRendering(gc);
            Graphics2D g2d = this.renderer.getGraphics2D();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.drawImage(this.awtImage, 0, 0, this.canvas.getSize().x, this.canvas.getSize().y, srcX, srcY, srcX + srcWidth, srcHeight, null);
            this.renderer.render(gc);
        } else {
            e.gc.drawImage(this.image, srcX, srcY, srcWidth, srcHeight, 0, 0, this.canvas.getSize().x, this.canvas.getSize().y);
        }
    }

    public void loadFileList() {
        int i;
        File file = new File(this.imageFolder);
        File[] files = file.listFiles();
        file = null;
        this.imageFiles.clear();
        if (files == null) {
            return;
        }
        this.logger.info("Loading file list.");
        for (i = 0; i < files.length; ++i) {
            if (!files[i].getName().toLowerCase().endsWith(".jpg") && !files[i].getName().toLowerCase().endsWith(".png") && !files[i].getName().toLowerCase().endsWith(".bmp") && !files[i].getName().toLowerCase().endsWith(".gif")) continue;
            this.imageFiles.add(files[i]);
        }
        this.counter.setTotalPage(this.imageFiles.size());
        for (i = 0; i < this.imageFiles.size(); ++i) {
            this.logger.debug(this.imageFiles.get(i).toString());
        }
        this.logger.info("File list loaded.");
    }

    public void widgetSelected(SelectionEvent e) {
        this.logger.debug(e.toString());
        String s = ((org.eclipse.swt.widgets.Button)e.getSource()).getText();
        if (s.equals("Set Folder...")) {
            DirectoryDialog dlg = new DirectoryDialog(this.shell);
            dlg.setMessage("Choose cartoons folder");
            String dir = dlg.open();
            if (dir != null) {
                this.imageFolder = dir;
                this.logger.info("Choosed new cartoons folder. [" + this.imageFolder + "]");
                this.counter.changeCurPage(0);
                this.loadFileList();
                this.reloadImage();
                this.canvas.redraw();
            } else {
                this.logger.info("Setting new cartoons folder canceled.");
            }
            Object var3_3 = null;
        } else if (s.equals("Double Page")) {
            this.isOneInTwoPages = ((org.eclipse.swt.widgets.Button)e.getSource()).getSelection();
            this.canvas.redraw();
        } else if (s.equals("Right To Left")) {
            this.isRightToLeft = ((org.eclipse.swt.widgets.Button)e.getSource()).getSelection();
            this.canvas.redraw();
        } else if (s.equals("Resample")) {
            this.useResample = ((org.eclipse.swt.widgets.Button)e.getSource()).getSelection();
            this.canvas.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public static boolean waitForImage(Image image, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }

    public void reloadImage() {
        if (this.imageFiles.size() > 0) {
            File imageFile = (File)this.imageFiles.get(this.counter.getCurPage());
            this.image.dispose();
            this.image = new org.eclipse.swt.graphics.Image((Device)this.display, imageFile.getAbsolutePath());
            this.awtImage = this.comp.getToolkit().getImage(imageFile.getAbsolutePath());
            P1Cartoon.waitForImage(this.awtImage, this.comp);
            this.logger.info("New image loaded. [" + imageFile.getName() + "]");
        }
    }

    public void keyPressed(KeyEvent e) {
        this.logger.debug(e.toString());
        switch (e.keyCode) {
            case 0x1000006: {
                this.logger.debug("page down");
                if (this.isOneInTwoPages) {
                    if (this.isRightToLeft) {
                        if (this.currPosition == 0) {
                            this.currPosition = 1;
                            this.counter.goNextPage();
                        } else {
                            this.currPosition = 0;
                        }
                    } else if (this.currPosition == 1) {
                        this.currPosition = 0;
                        this.counter.goNextPage();
                    } else {
                        this.currPosition = 1;
                    }
                } else {
                    this.counter.goNextPage();
                }
                this.reloadImage();
                this.canvas.redraw();
                break;
            }
            case 0x1000005: {
                this.logger.debug("page up");
                if (this.isOneInTwoPages) {
                    if (this.isRightToLeft) {
                        if (this.currPosition == 1) {
                            this.currPosition = 0;
                            this.counter.goPrevPage();
                        } else {
                            this.currPosition = 1;
                        }
                    } else if (this.currPosition == 0) {
                        this.currPosition = 1;
                        this.counter.goPrevPage();
                    } else {
                        this.currPosition = 0;
                    }
                } else {
                    this.counter.goPrevPage();
                }
                this.reloadImage();
                this.canvas.redraw();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        Properties props = new Properties();
        props.setProperty("p1cartoon.program.name", "P1Cartoon v0.3 by mio (yeoupooh)");
        props.setProperty("p1cartoon.cartoons.folder", this.imageFolder);
        this.logger.debug("currImageNum=" + this.counter.getCurPage());
        props.setProperty("p1cartoon.curr.image.num", new Integer(this.counter.getCurPage()).toString());
        props.setProperty("p1cartoon.curr.position", new Integer(this.currPosition).toString());
        props.setProperty("p1cartoon.1in2pages", new Boolean(this.isOneInTwoPages).toString());
        props.setProperty("p1cartoon.right2left", new Boolean(this.isRightToLeft).toString());
        props.setProperty("p1cartoon.resample", new Boolean(this.useResample).toString());
        try {
            props.store(new FileOutputStream("p1cartoon.properties"), "P1Cartoon v0.3 by mio (yeoupooh) Settings");
            this.logger.info("Settings saved.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            props.clear();
            props = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream("p1cartoon.properties"));
            this.imageFolder = props.getProperty("p1cartoon.cartoons.folder", "");
            this.counter.setCurPage(Integer.parseInt(props.getProperty("p1cartoon.curr.image.num")));
            this.currPosition = Integer.parseInt(props.getProperty("p1cartoon.curr.position"));
            this.isOneInTwoPages = Boolean.parseBoolean(props.getProperty("p1cartoon.1in2pages"));
            this.isRightToLeft = Boolean.parseBoolean(props.getProperty("p1cartoon.right2left"));
            this.useResample = Boolean.parseBoolean(props.getProperty("p1cartoon.resample"));
            this.logger.info("Settings loaded.");
        }
        catch (NumberFormatException e) {
            this.logger.warn("Can't load settings.");
        }
        catch (FileNotFoundException e) {
            this.logger.warn("Can't load settings.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            props.clear();
            props = null;
        }
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public void update(Observable observable, Object obj) {
        this.logger.debug("observable=[" + observable + "]");
        if (observable instanceof PageCounter) {
            PageCounter counter = (PageCounter)observable;
            this.txtPage.setText(new Integer(counter.getCurPage() + 1).toString() + "/" + new Integer(counter.getTotalPage()).toString());
        }
    }
}

