/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableEditorImpl;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableViewer
extends StructuredViewer {
    private VirtualManager virtualManager;
    private TableEditorImpl tableViewerImpl;
    private Table table;
    private TableEditor tableEditor;
    private TableColorAndFontNoOp tableColorAndFont = new TableColorAndFontNoOp();

    public TableViewer(Composite parent) {
        this(parent, 2818);
    }

    public TableViewer(Composite parent, int style) {
        this(new Table(parent, style));
    }

    public TableViewer(Table table) {
        this.table = table;
        this.hookControl((Control)table);
        this.tableEditor = new TableEditor(table);
        this.initTableViewerImpl();
        this.initializeVirtualManager(table.getStyle());
    }

    private void initializeVirtualManager(int style) {
        if ((style & 0x10000000) == 0) {
            return;
        }
        this.virtualManager = new VirtualManager();
    }

    public void add(Object[] elements) {
        this.assertElementsNotNull(elements);
        Object[] filtered = this.filter(elements);
        int i = 0;
        while (i < filtered.length) {
            Object element = filtered[i];
            int index = this.indexForElement(element);
            this.createItem(element, index);
            ++i;
        }
    }

    private void createItem(Object element, int index) {
        if (this.virtualManager == null) {
            this.updateItem((Widget)new TableItem(this.getTable(), 0, index), element);
        } else {
            this.virtualManager.notVisibleAdded(element, index);
        }
    }

    public void add(Object element) {
        this.add(new Object[]{element});
    }

    public void cancelEditing() {
        this.tableViewerImpl.cancelEditing();
    }

    protected Widget doFindInputItem(Object element) {
        if (this.equals(element, this.getRoot())) {
            return this.getTable();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        TableItem[] children = this.table.getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            Object data = item.getData();
            if (data != null && this.equals(data, element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            if (fullMap) {
                this.associate(element, (Item)item);
            } else {
                Object data = item.getData();
                if (data != null) {
                    this.unmapElement(data, (Widget)item);
                }
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            IBaseLabelProvider prov = this.getLabelProvider();
            ITableLabelProvider tprov = null;
            ILabelProvider lprov = null;
            IViewerLabelProvider vprov = null;
            if (prov instanceof ILabelProvider) {
                lprov = (ILabelProvider)prov;
            }
            if (prov instanceof IViewerLabelProvider) {
                vprov = (IViewerLabelProvider)prov;
            }
            if (prov instanceof ITableLabelProvider) {
                tprov = (ITableLabelProvider)prov;
            }
            int columnCount = this.table.getColumnCount();
            TableItem ti = item;
            this.getColorAndFontCollector().setFontsAndColors(element);
            int column = 0;
            while (column < columnCount || column == 0) {
                String text = "";
                Image image = null;
                this.tableColorAndFont.setFontsAndColors(ti, element, column);
                if (tprov == null) {
                    if (column == 0) {
                        ViewerLabel updateLabel = new ViewerLabel(item.getText(), item.getImage());
                        if (vprov != null) {
                            this.buildLabel(updateLabel, element, vprov);
                        } else if (lprov != null) {
                            this.buildLabel(updateLabel, element, lprov);
                        }
                        if (item.isDisposed()) {
                            this.unmapElement(element, (Widget)item);
                            return;
                        }
                        text = updateLabel.getText();
                        image = updateLabel.getImage();
                    }
                } else {
                    text = tprov.getColumnText(element, column);
                    image = tprov.getColumnImage(element, column);
                }
                if (text == null) {
                    text = "";
                }
                ti.setText(column, text);
                if (ti.getImage(column) != image) {
                    ti.setImage(column, image);
                }
                ++column;
            }
            this.getColorAndFontCollector().applyFontsAndColors(ti);
        }
    }

    public void editElement(Object element, int column) {
        this.tableViewerImpl.editElement(element, column);
    }

    public CellEditor[] getCellEditors() {
        return this.tableViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.tableViewerImpl.getCellModifier();
    }

    public Object[] getColumnProperties() {
        return this.tableViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.table;
    }

    public Object getElementAt(int index) {
        TableItem i;
        if (index >= 0 && index < this.table.getItemCount() && (i = this.table.getItem(index)) != null) {
            return i.getData();
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        if (this.virtualManager != null) {
            return this.getVirtualSelection();
        }
        TableItem[] items = this.table.getSelection();
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object e = item.getData();
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    private List getVirtualSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        int[] selectionIndices = this.getTable().getSelectionIndices();
        if (this.getContentProvider() instanceof ILazyContentProvider) {
            ILazyContentProvider lazy = (ILazyContentProvider)this.getContentProvider();
            int i = 0;
            while (i < selectionIndices.length) {
                int selectionIndex = selectionIndices[i];
                lazy.updateElement(selectionIndex);
                Object element = this.getTable().getItem(selectionIndex).getData();
                if (element != null) {
                    result.add(element);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < selectionIndices.length) {
                Object element = null;
                int selectionIndex = selectionIndices[i];
                if (selectionIndex < this.virtualManager.cachedElements.length) {
                    element = this.virtualManager.cachedElements[selectionIndex];
                }
                if (element == null) {
                    TableItem item = this.getTable().getItem(selectionIndex);
                    element = item.getData();
                }
                if (element != null) {
                    result.add(element);
                }
                ++i;
            }
        }
        return result;
    }

    public Table getTable() {
        return this.table;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Table tableControl = (Table)control;
        tableControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableViewer.this.tableViewerImpl.handleMouseDown(e);
            }
        });
    }

    protected int indexForElement(Object element) {
        ViewerSorter sorter = this.getSorter();
        if (sorter == null) {
            return this.table.getItemCount();
        }
        int count = this.table.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.table.getItem(mid).getData();
            int compare = sorter.compare(this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.table.getItem(mid).getData();
                    compare = sorter.compare(this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    private void initTableViewerImpl() {
        this.tableViewerImpl = new TableEditorImpl(this){

            Rectangle getBounds(Item item, int columnNumber) {
                return ((TableItem)item).getBounds(columnNumber);
            }

            int getColumnCount() {
                return TableViewer.this.getTable().getColumnCount();
            }

            Item[] getSelection() {
                return TableViewer.this.getTable().getSelection();
            }

            void setEditor(Control w, Item item, int columnNumber) {
                TableViewer.this.tableEditor.setEditor(w, (TableItem)item, columnNumber);
            }

            void setSelection(StructuredSelection selection, boolean b) {
                TableViewer.this.setSelection(selection, b);
            }

            void showSelection() {
                TableViewer.this.getTable().showSelection();
            }

            void setLayoutData(CellEditor.LayoutData layoutData) {
                ((TableViewer)TableViewer.this).tableEditor.grabHorizontal = layoutData.grabHorizontal;
                ((TableViewer)TableViewer.this).tableEditor.horizontalAlignment = layoutData.horizontalAlignment;
                ((TableViewer)TableViewer.this).tableEditor.minimumWidth = layoutData.minimumWidth;
            }

            void handleDoubleClickEvent() {
                StructuredViewer viewer = this.getViewer();
                TableViewer.this.fireDoubleClick(new DoubleClickEvent(viewer, ((Viewer)viewer).getSelection()));
                TableViewer.this.fireOpen(new OpenEvent(viewer, ((Viewer)viewer).getSelection()));
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void inputChanged(Object input, Object oldInput) {
        this.getControl().setRedraw(false);
        try {
            this.refresh();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.getControl().setRedraw(true);
    }

    public void insert(Object element, int position) {
        this.tableViewerImpl.applyEditorValue();
        if (this.getSorter() != null || this.hasFilters()) {
            this.add(element);
            return;
        }
        if (position == -1) {
            position = this.table.getItemCount();
        }
        this.createItem(element, position);
    }

    protected void internalRefresh(Object element) {
        this.internalRefresh(element, true);
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        this.tableViewerImpl.applyEditorValue();
        if (element == null || this.equals(element, this.getRoot())) {
            if (this.virtualManager == null) {
                this.internalRefreshAll(updateLabels);
            } else {
                this.internalVirtualRefreshAll();
            }
        } else {
            Widget w = this.findItem(element);
            if (w != null) {
                this.updateItem(w, element);
            }
        }
    }

    private void internalVirtualRefreshAll() {
        Object root = this.getRoot();
        IContentProvider contentProvider = this.getContentProvider();
        if (!(contentProvider instanceof ILazyContentProvider) && contentProvider instanceof IStructuredContentProvider && root != null) {
            this.virtualManager.cachedElements = ((IStructuredContentProvider)this.getContentProvider()).getElements(root);
            this.getTable().setItemCount(this.virtualManager.cachedElements.length);
        }
        this.getTable().clearAll();
    }

    private void internalRefreshAll(boolean updateLabels) {
        TableItem item;
        Object[] children = this.getSortedChildren(this.getRoot());
        TableItem[] items = this.getTable().getItems();
        int min = Math.min(children.length, items.length);
        int i = 0;
        while (i < min) {
            item = items[i];
            if (this.equals(children[i], item.getData())) {
                if (updateLabels) {
                    this.updateItem((Widget)item, children[i]);
                } else {
                    this.associate(children[i], (Item)item);
                }
            } else {
                item.setText("");
                item.setImage(new Image[Math.max(1, this.table.getColumnCount())]);
                this.disassociate((Item)item);
            }
            ++i;
        }
        if (min < items.length) {
            i = items.length;
            while (--i >= min) {
                this.disassociate((Item)items[i]);
            }
            this.table.remove(min, items.length - 1);
        }
        if (this.table.getItemCount() == 0) {
            this.table.removeAll();
        }
        i = 0;
        while (i < min) {
            item = items[i];
            if (item.getData() == null) {
                this.updateItem((Widget)item, children[i]);
            }
            ++i;
        }
        i = min;
        while (i < children.length) {
            this.createItem(children[i], i);
            ++i;
        }
    }

    private void internalRemove(Object[] elements) {
        Object input = this.getInput();
        int i = 0;
        while (i < elements.length) {
            if (this.equals(elements[i], input)) {
                this.setInput(null);
                return;
            }
            ++i;
        }
        int[] indices = new int[elements.length];
        int count = 0;
        int i2 = 0;
        while (i2 < elements.length) {
            Widget w = this.findItem(elements[i2]);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                this.disassociate((Item)item);
                indices[count++] = this.table.indexOf(item);
            }
            ++i2;
        }
        if (count < indices.length) {
            int[] nArray = indices;
            indices = new int[count];
            System.arraycopy(nArray, 0, indices, 0, count);
        }
        this.table.remove(indices);
        if (this.table.getItemCount() == 0) {
            this.table.removeAll();
        }
    }

    public boolean isCellEditorActive() {
        return this.tableViewerImpl.isCellEditorActive();
    }

    public void remove(final Object[] elements) {
        this.assertElementsNotNull(elements);
        if (elements.length == 0) {
            return;
        }
        this.preservingSelection(new Runnable(){

            public void run() {
                TableViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void reveal(Object element) {
        Assert.isNotNull(element);
        Widget w = this.findItem(element);
        if (w instanceof TableItem) {
            this.getTable().showItem((TableItem)w);
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.tableViewerImpl.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.tableViewerImpl.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this.tableViewerImpl.setColumnProperties(columnProperties);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue(labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider);
        super.setLabelProvider(labelProvider);
        this.tableColorAndFont = labelProvider instanceof ITableFontProvider || labelProvider instanceof ITableColorProvider ? new TableColorAndFontCollector(labelProvider) : new TableColorAndFontNoOp();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        super.setSelection(selection, reveal);
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        if (list == null) {
            this.table.deselectAll();
            return;
        }
        if (this.virtualManager != null) {
            this.virtualSetSelectionToWidget(list, reveal);
            return;
        }
        int size = list.size();
        TableItem[] items = new TableItem[size];
        int count = 0;
        int i = 0;
        while (i < size) {
            Object o = list.get(i);
            Widget w = this.findItem(o);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                items[count++] = item;
            }
            ++i;
        }
        if (count < size) {
            TableItem[] tableItemArray = items;
            items = new TableItem[count];
            System.arraycopy(tableItemArray, 0, items, 0, count);
        }
        this.table.setSelection(items);
        if (reveal) {
            this.table.showSelection();
        }
    }

    private void virtualSetSelectionToWidget(List list, boolean reveal) {
        TableItem item;
        int size = list.size();
        int[] indices = new int[list.size()];
        TableItem firstItem = null;
        int count = 0;
        HashSet virtualElements = new HashSet();
        int i = 0;
        while (i < size) {
            Object o = list.get(i);
            Widget w = this.findItem(o);
            if (w instanceof TableItem) {
                TableItem item2 = (TableItem)w;
                indices[count++] = this.getTable().indexOf(item2);
                if (firstItem == null) {
                    firstItem = item2;
                }
            } else {
                virtualElements.add(o);
            }
            ++i;
        }
        if (this.getContentProvider() instanceof ILazyContentProvider) {
            ILazyContentProvider provider = (ILazyContentProvider)this.getContentProvider();
            int i2 = 0;
            while (virtualElements.size() > 0 && i2 < this.getTable().getItemCount()) {
                provider.updateElement(i2);
                item = this.getTable().getItem(i2);
                if (virtualElements.contains(item.getData())) {
                    indices[count++] = i2;
                    virtualElements.remove(item.getData());
                    if (firstItem == null) {
                        firstItem = item;
                    }
                }
                ++i2;
            }
        } else if (count != list.size()) {
            i = 0;
            while (i < this.virtualManager.cachedElements.length) {
                Object element = this.virtualManager.cachedElements[i];
                if (virtualElements.contains(element)) {
                    item = this.getTable().getItem(i);
                    item.getText();
                    indices[count++] = i;
                    virtualElements.remove(element);
                    if (firstItem == null) {
                        firstItem = item;
                    }
                }
                ++i;
            }
        }
        if (count < size) {
            int[] nArray = indices;
            indices = new int[count];
            System.arraycopy(nArray, 0, indices, 0, count);
        }
        this.table.setSelection(indices);
        if (reveal && firstItem != null) {
            this.table.showItem(firstItem);
        }
    }

    public void setItemCount(int count) {
        this.getTable().setItemCount(count);
        this.getTable().redraw();
    }

    public void replace(Object element, int index) {
        TableItem item = this.getTable().getItem(index);
        this.refreshItem((Widget)item, element);
    }

    public void clear(int index) {
        TableItem item = this.getTable().getItem(index);
        if (item.getData() != null) {
            this.disassociate((Item)item);
        }
        this.table.clear(index);
    }

    protected Object[] getRawChildren(Object parent) {
        Assert.isTrue(!(this.getContentProvider() instanceof ILazyContentProvider), "Cannot get raw children with an ILazyContentProvider");
        return super.getRawChildren(parent);
    }

    protected void assertContentProviderType(IContentProvider provider) {
        Assert.isTrue(provider instanceof IStructuredContentProvider || provider instanceof ILazyContentProvider);
    }

    private class VirtualManager {
        private Object[] cachedElements = new Object[0];

        public VirtualManager() {
            this.addTableListener();
        }

        private void addTableListener() {
            TableViewer.this.table.addListener(36, new Listener(this){
                final /* synthetic */ VirtualManager this$1;
                {
                    this.this$1 = virtualManager;
                }

                public void handleEvent(Event event) {
                    IContentProvider contentProvider;
                    TableItem item = (TableItem)event.item;
                    int index = TableViewer.access$0(VirtualManager.access$2(this.this$1)).indexOf(item);
                    Object element = this.this$1.resolveElement(index);
                    if (element == null && (contentProvider = VirtualManager.access$2(this.this$1).getContentProvider()) instanceof ILazyContentProvider) {
                        ((ILazyContentProvider)contentProvider).updateElement(index);
                        return;
                    }
                    VirtualManager.access$2(this.this$1).associate(element, (Item)item);
                    VirtualManager.access$2(this.this$1).updateItem((Widget)item, element);
                }
            });
        }

        protected Object resolveElement(int index) {
            Object element = null;
            if (index < this.cachedElements.length) {
                element = this.cachedElements[index];
            }
            return element;
        }

        public void notVisibleAdded(Object element, int index) {
            int requiredCount = index + 1;
            if (requiredCount > TableViewer.this.getTable().getItemCount()) {
                TableViewer.this.getTable().setItemCount(requiredCount);
                Object[] newCache = new Object[requiredCount];
                System.arraycopy(this.cachedElements, 0, newCache, 0, this.cachedElements.length);
                this.cachedElements = newCache;
            }
            this.cachedElements[index] = element;
        }

        static /* synthetic */ TableViewer access$2(VirtualManager virtualManager) {
            return virtualManager.TableViewer.this;
        }
    }

    private class TableColorAndFontNoOp {
        TableColorAndFontNoOp() {
        }

        public void setFontsAndColors(TableItem tableItem, Object element, int column) {
        }
    }

    private class TableColorAndFontCollector
    extends TableColorAndFontNoOp {
        ITableFontProvider fontProvider = null;
        ITableColorProvider colorProvider = null;

        public TableColorAndFontCollector(IBaseLabelProvider provider) {
            if (provider instanceof ITableFontProvider) {
                this.fontProvider = (ITableFontProvider)((Object)provider);
            }
            if (provider instanceof ITableColorProvider) {
                this.colorProvider = (ITableColorProvider)((Object)provider);
            }
        }

        public void setFontsAndColors(TableItem tableItem, Object element, int column) {
            if (this.colorProvider != null) {
                tableItem.setBackground(column, this.colorProvider.getBackground(element, column));
                tableItem.setForeground(column, this.colorProvider.getForeground(element, column));
            }
            if (this.fontProvider != null) {
                tableItem.setFont(column, this.fontProvider.getFont(element, column));
            }
        }
    }
}

