/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java2dhelper;

import info.jinwoomin.logging.ILoggable;
import info.jinwoomin.logging.ILogger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Graphics2DRenderer
implements ILoggable {
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);
    private ILogger logger = null;
    private BufferedImage awtImage;
    private Image swtImage;
    private ImageData swtImageData;
    private int[] awtPixels;
    private static final int TRANSPARENT_COLOR = 1193046;

    public void prepareRendering(GC gc) {
        Rectangle clip = gc.getClipping();
        this.prepareRendering(clip.x, clip.y, clip.width, clip.height);
    }

    public void prepareRendering(Graphics graphics) {
        org.eclipse.draw2d.geometry.Rectangle clip = graphics.getClip(new org.eclipse.draw2d.geometry.Rectangle());
        this.prepareRendering(clip.x, clip.y, clip.width, clip.height);
    }

    private void prepareRendering(int clipX, int clipY, int clipW, int clipH) {
        this.checkOffScreenImages(clipW, clipH);
        java.awt.Graphics awtGraphics = this.awtImage.getGraphics();
        awtGraphics.setColor(new Color(1193046));
        awtGraphics.fillRect(clipX, clipY, clipW, clipH);
    }

    public Graphics2D getGraphics2D() {
        if (this.awtImage == null) {
            return null;
        }
        return (Graphics2D)this.awtImage.getGraphics();
    }

    public void render(GC gc) {
        if (this.awtImage == null) {
            return;
        }
        Rectangle clip = gc.getClipping();
        this.transferPixels(clip.x, clip.y, clip.width, clip.height);
        try {
            gc.drawImage(this.swtImage, clip.x, clip.y, clip.width, clip.height, clip.x, clip.y, clip.width, clip.height);
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.toString());
        }
    }

    public void render(Graphics graphics) {
        if (this.awtImage == null) {
            return;
        }
        org.eclipse.draw2d.geometry.Rectangle clip = graphics.getClip(new org.eclipse.draw2d.geometry.Rectangle());
        this.transferPixels(clip.x, clip.y, clip.width, clip.height);
        graphics.drawImage(this.swtImage, clip.x, clip.y, clip.width, clip.height, clip.x, clip.y, clip.width, clip.height);
    }

    private void transferPixels(int clipX, int clipY, int clipW, int clipH) {
        int step = this.swtImageData.depth / 8;
        byte[] data = this.swtImageData.data;
        try {
            this.awtImage.getRGB(clipX, clipY, clipW, clipH, this.awtPixels, 0, clipW);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.error(e.toString());
            return;
        }
        for (int i = 0; i < clipH; ++i) {
            int idx = (clipY + i) * this.swtImageData.bytesPerLine + clipX * step;
            for (int j = 0; j < clipW; ++j) {
                int rgb = this.awtPixels[j + i * clipW];
                for (int k = this.swtImageData.depth - 8; k >= 0; k -= 8) {
                    data[idx++] = (byte)(rgb >> k & 0xFF);
                }
            }
        }
        if (this.swtImage != null) {
            this.swtImage.dispose();
        }
        this.swtImage = new Image((Device)Display.getDefault(), this.swtImageData);
    }

    public void dispose() {
        if (this.awtImage != null) {
            this.awtImage.flush();
        }
        if (this.swtImage != null) {
            this.swtImage.dispose();
        }
        this.awtImage = null;
        this.swtImageData = null;
        this.awtPixels = null;
    }

    private void checkOffScreenImages(int width, int height) {
        int currentImageWidth = 0;
        int currentImageHeight = 0;
        if (this.swtImage != null) {
            currentImageWidth = this.swtImage.getImageData().width;
            currentImageHeight = this.swtImage.getImageData().height;
        }
        if (width > currentImageWidth || height > currentImageHeight) {
            this.dispose();
            width = Math.max(width, currentImageWidth);
            height = Math.max(height, currentImageHeight);
            this.awtImage = new BufferedImage(width, height, 2);
            this.swtImageData = new ImageData(width, height, 24, PALETTE_DATA);
            this.swtImageData.transparentPixel = 1193046;
            this.awtPixels = new int[width * height];
        }
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }
}

