/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.p1cartoon.gui;

import info.jinwoomin.p1cartoon.data.P1CartoonData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SettingsDialog {
    private Shell sShell = null;
    private Composite compositeSettings = null;
    private Composite compositeButtons = null;
    private Button buttonSave = null;
    private Button buttonCancel = null;
    private Button checkBoxTwoInOnePage = null;
    private Button checkBoxRightToLeft = null;
    private Button checkBoxResample = null;
    private Button checkBoxMouseClick = null;
    private P1CartoonData data = null;
    private Button checkBoxAutoMode = null;

    private void createSShell() {
        this.sShell = new Shell(132336);
        this.sShell.setText("Settings");
        this.sShell.setLayout((Layout)new GridLayout());
        this.sShell.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/ico3470.ico")));
        this.createCompositeSettings();
        this.createCompositeButtons();
        this.sShell.setSize(new Point(253, 203));
    }

    public void dataToControl(P1CartoonData data) {
        this.checkBoxAutoMode.setSelection(data.isAutoMode());
        this.checkBoxTwoInOnePage.setSelection(data.isTwoInOnePage());
        this.checkBoxRightToLeft.setSelection(data.isRightToLeft());
        this.checkBoxResample.setSelection(data.isUseResample());
        this.checkBoxMouseClick.setSelection(data.isUseMouseClick());
        if (data.isAutoMode()) {
            this.checkBoxTwoInOnePage.setEnabled(false);
            this.checkBoxRightToLeft.setEnabled(false);
        } else {
            this.checkBoxTwoInOnePage.setEnabled(true);
            this.checkBoxRightToLeft.setEnabled(data.isTwoInOnePage());
        }
    }

    public void controlToData(P1CartoonData data) {
        data.setAutoMode(this.checkBoxAutoMode.getSelection());
        data.setTwoInOnePage(this.checkBoxTwoInOnePage.getSelection());
        data.setRightToLeft(this.checkBoxRightToLeft.getSelection());
        data.setUseResample(this.checkBoxResample.getSelection());
        data.setUseMouseClick(this.checkBoxMouseClick.getSelection());
    }

    public void open(Display display, P1CartoonData data) {
        this.data = data;
        this.createSShell();
        this.dataToControl(data);
        this.sShell.open();
        while (!this.sShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.sShell.dispose();
    }

    private void createCompositeSettings() {
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 4;
        gridData3.grabExcessVerticalSpace = true;
        gridData3.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.compositeSettings = new Composite((Composite)this.sShell, 0);
        this.compositeSettings.setLayout((Layout)gridLayout);
        this.compositeSettings.setLayoutData((Object)gridData3);
        this.checkBoxAutoMode = new Button(this.compositeSettings, 32);
        this.checkBoxAutoMode.setText("Auto Mode");
        this.checkBoxAutoMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsDialog.this.checkBoxTwoInOnePage.setEnabled(!SettingsDialog.this.checkBoxAutoMode.getSelection());
                SettingsDialog.this.checkBoxRightToLeft.setEnabled(!SettingsDialog.this.checkBoxAutoMode.getSelection());
            }
        });
        this.checkBoxTwoInOnePage = new Button(this.compositeSettings, 32);
        this.checkBoxTwoInOnePage.setText("2 in 1 page");
        this.checkBoxTwoInOnePage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsDialog.this.checkBoxRightToLeft.setEnabled(SettingsDialog.this.checkBoxTwoInOnePage.getSelection());
            }
        });
        this.checkBoxRightToLeft = new Button(this.compositeSettings, 32);
        this.checkBoxRightToLeft.setText("Right to left");
        this.checkBoxResample = new Button(this.compositeSettings, 32);
        this.checkBoxResample.setText("Resample");
        this.checkBoxMouseClick = new Button(this.compositeSettings, 32);
        this.checkBoxMouseClick.setText("Mouse Click");
    }

    private void createCompositeButtons() {
        GridData gridData5 = new GridData();
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.widthHint = 50;
        gridData5.horizontalAlignment = 3;
        GridData gridData4 = new GridData();
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.widthHint = 50;
        gridData4.horizontalAlignment = 3;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 3;
        gridData2.grabExcessHorizontalSpace = false;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 3;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        this.compositeButtons = new Composite((Composite)this.sShell, 0);
        this.compositeButtons.setLayout((Layout)gridLayout1);
        this.compositeButtons.setLayoutData((Object)gridData2);
        this.buttonSave = new Button(this.compositeButtons, 0);
        this.buttonSave.setText("Save");
        this.buttonSave.setLayoutData((Object)gridData5);
        this.buttonSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsDialog.this.controlToData(SettingsDialog.this.data);
                SettingsDialog.this.sShell.dispose();
                System.out.println("widgetSelected()");
            }
        });
        this.buttonCancel = new Button(this.compositeButtons, 0);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.setLayoutData((Object)gridData4);
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("widgetSelected()");
                SettingsDialog.this.sShell.dispose();
            }
        });
    }
}

