// Purpose: Win32 GDI  Ŭ 
// Author : ڱ
// Update : 2003/05/07
// Date   : 2003/05/07

#if defined(_WIN32) && defined(_GUI)

#ifndef __DC_H_
#define __DC_H_

//
// Includes
//

#include <pesc.h>

//
// Definitions
//

//
// Class
//

class C_DC
{
// Constants, Enumerations & Structures
private:

// Constructors & Destructors
public:
    C_DC();
    C_DC(HWND hWnd);
    ~C_DC()
    {
        if (NULL != m_hDC) EndPaint();
    }

// Operators
public:

// Attributes
private:
    HDC         m_hDC;
    PAINTSTRUCT m_pS;
    HWND        m_hWnd;    

// Overridables
public:

// Methods
public:
    void Attach(HWND hWnd)
    {
        ASSERT(NULL != hWnd);
        ASSERT(NULL == m_hWnd);
        m_hWnd = hWnd;
    }
    void Detach()
    {
        ASSERT(NULL != m_hWnd);
        m_hWnd = NULL;
    }

    //
    // API Wrapper inline Լ 
    //
    
    bool BeginPaint()
    {
        ASSERT(NULL != m_hWnd);
        ASSERT(NULL == m_hDC);
        m_hDC = ::BeginPaint(m_hWnd, &m_pS);
        WARNING_WIN32(NULL != m_hDC);
        return (NULL != m_hDC);
    }
    void EndPaint()
    {
        ASSERT(NULL != m_hWnd);
        ASSERT(NULL != m_hDC);
        ::EndPaint(m_hWnd, &m_pS);
        m_hDC = NULL;
    }
    int DrawText(LPCSTR lpszString, LPRECT lpRect, UINT uFormat,
        int nCount = -1)
    {
        ASSERT(NULL != m_hDC);
        int iRet = ::DrawText(m_hDC, lpszString, nCount, lpRect, uFormat);
        WARNING_WIN32(0 != iRet);
        return iRet;            
    }
};

#endif  // __DC_H_

#endif  // _WIN32, _GUI
