// Purpose: Win32 GUI application  Ŭ 
// Author : ڱ
// Update : 2003/05/06
// Date   : 2003/04/28
// Comment:
//      Win32 GUI ǥϴ  Ŭ ַ Win32 API WrapperԼ ޼
//      óԼ Ǿ ִ.
//       Ŭ ε GUI ǥ   Ϲ C_Frame Ŭ
//      ϸ SDI, MDI 츦     ִ. 
//
//  Windows  ޼ ߻ 
//  WM_GETMINMAXINFO
//  WM_NCCREATE
//  WM_NCCALCSIZE
//  WM_CREATE
//   ޼... 
//  WM_DESTROY
//  WM_NCDESTROY

#if defined(_WIN32) && defined(_GUI)

#ifndef __WND_H_ 
#define __WND_H_

//
// Includes
//

#include <pesc.h>

//
// Definitions
//

#define DECLARE_MESSAGE_MAP() \
    private: \
        static const MSD rgmsd[];   \
    protected: \
        static const MSDM messageMap;  \
        virtual const MSDM* GetMessageMap() const;

#define BEGIN_MESSAGE_MAP(CLASS, BASECLASS) \
    const C_Wnd::MSDM* CLASS::GetMessageMap() const    \
        { return &CLASS::messageMap; }  \
    const C_Wnd::MSDM CLASS::messageMap = \
        { &BASECLASS::messageMap, CLASS::rgmsd };   \
    const C_Wnd::MSD CLASS::rgmsd[] = {

#define END_MESSAGE_MAP() \
    {0, 0, 0, 0}, \
};

#define ON_MESSAGE(MESSAGE, FUNCTION)   \
    { MESSAGE, 0, (LRESULT (C_Wnd::*)(WPARAM, LPARAM))&FUNCTION, 0 },

#define ON_COMMAND(MESSAGE, FUNCTION)   \
    { WM_COMMAND, MESSAGE, 0, (LRESULT (C_Wnd::*)(WPARAM, LPARAM))&FUNCTION },

//
// Class
//

class C_Wnd
{
// Constants, Enumerations & Structures
private:
    // Message ڵ鸵 Լ  Լ  prototype
    typedef LRESULT (C_Wnd::*PFNMSG)(WPARAM,LPARAM);

    // Command ڵ鸵 Լ  Լ  prototype    
    typedef LRESULT (C_Wnd::*PFNCMD)(WORD,HWND);

    // ޼ Լ   ִ ü 
    typedef struct _MSD
    {
        UINT   uMessage;    // ޼ 
        WORD   wCommand;    // WM_COMMAND϶  
        PFNMSG pfnmsg;      // ޼ Լ 
        PFNCMD pfncmd;      //  Լ 
        
    } MSD;  // MeSsage Dispatch structure

    typedef struct _MSDM
    {
        const   _MSDM*  baseMsd;
        const   MSD*    Msd;
    } MSDM; // MeSsage Dispatch structure Map

    // ȣؾ ϴ ⺻  ν  
    typedef enum
    {
        edwpNone,           // ⺻  ν ȣ ʴ´.
                            // (ǥ ȭڿ) 
        edwpWindow,         // Call DefWindowProc.
        edwpDialog,         // Call DefDlgProc (custom ȭڿ)
        edwpMDIChild,       // Call DefMDIChildProc.
        edwpMDIFrame        // Call DefFrameProc.
    } EDWP;					// Enumeration for Default Window Procedures

    // WndProc DispMessage ͸ Ѱٶ ʿ   
    typedef struct _MSDI
    {
        int  cmsd;          // ޼  
        MSD *rgmsd;         // ޼ Լ   ִ ü 
        EDWP edwp;          // ʿ ϴ ⺻  ν 
    } MSDI, FAR *LPMSDI;	// MeSsage Dipatch Information

protected:
    
// Constructors & Destructors
public:
    C_Wnd();
    ~C_Wnd(); 

// Operators
public:

// Attributes
private:
    HWND    m_hWnd;         // Window handle
    static  HHOOK   m_hHook;

// Overridables
public:
    virtual bool PreCreateWindow(CREATESTRUCT& cs);

// Methods
    //
    // ޼ ó Լ 
    //

    DECLARE_MESSAGE_MAP()

public:
    virtual LRESULT OnDestroy(WPARAM wParam, LPARAM lParam);
    virtual LRESULT OnNCDestroy(WPARAM wParam, LPARAM lParam);

private:
    LRESULT DispMessage(UINT uMessage, WPARAM wParam, LPARAM lParam);
   	LRESULT DispDefault(EDWP edwp, UINT uMessage, WPARAM wparam, LPARAM lparam);

    static LRESULT CALLBACK WndProc(HWND hWnd, UINT uMessage, WPARAM wParam,
        LPARAM lParam);
    static LRESULT CALLBACK CBTProc(int iCode, WPARAM wParam, LPARAM lParam);
   	
public:
    // Purpose: Ŭ  ڵ Ѵ.
    // Accepts: hWnd-  ڵ 
    void Attach(HWND hWnd)
    {
        ASSERT(NULL == m_hWnd);
        ASSERT(NULL != hWnd);
        m_hWnd = hWnd;
    }
    // Purpose:  ڵ ȯѴ. 
    // Returns:  ڵ
    HWND GetHandle() { return m_hWnd; }
    // Purpose:    ڵ Ŭ Ѵ.
    // Accepts: hWnd- Ϸ  ڵ 
    void RemoveFromMap(HWND hWnd)
    {
        m_hWnd = NULL;
        PescGetWndMap()->RemoveHandle(hWnd);
    } 
    C_Wnd* GetClassPointer() { return this; }
    bool RegisterClassWithIcon(LPCSTR c_lpszClassName, UINT nIDIcon,
        UINT nClassStyle, HBRUSH hbrBackground = 0);

    //
    // API Wrapper Լ
    //
    
    bool RegisterClass(LPCSTR c_lpszClassName, UINT nClassStyle,
        HCURSOR hCursor = 0, HBRUSH hbrBackground = 0, HICON hIcon = 0);
    bool CreateWindowEx(DWORD dwExStyle, LPCSTR c_lpszClassName, 
	   LPCSTR c_lpszWindowName, DWORD dwStyle,
	   int x, int y, int nWidth, int nHeight,
	   HWND hWndParent, HMENU nIDorHMenu, LPVOID lpParam);

    //
    // API Wrapper inline Լ 
    //
    
    BOOL ShowWindow(int iCmdShow)
    {
        ASSERT(NULL != m_hWnd);
        return ::ShowWindow(m_hWnd, iCmdShow);
    }
    bool DestroyWindow()
    {
        ASSERT(NULL != m_hWnd);
        BOOL bRet = ::DestroyWindow(m_hWnd);
        WARNING_WIN32(TRUE == bRet);
        return (TRUE == bRet);
    }
    bool GetClientRect(LPRECT lpRect)
    {
        ASSERT(NULL != m_hWnd);
        BOOL bRet = ::GetClientRect(m_hWnd, lpRect);
        WARNING_WIN32(TRUE == bRet);
        return (TRUE == bRet);
    }
};

#endif  // __WND_H_

#endif  // _WIN32, _GUI
