// Purpose:	Application class
// Author : ڱ
// Update : 2003/05/20
// Date	  : 2003/04/18

//
// Headers
//

#include <pesc.h>

//
// Definitions
//

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#if defined(_GUI) && defined(_WIN32)
    C_Wnd* C_App::m_pWnd = NULL;
#endif

C_App* C_App::ms_pApp = NULL;

//
// Construction/Destruction
//

// Purpose:	  C_App Ѵ.
// Comment:
//      C_App, C_AssertѴ ü Ͽ Ǳ  C_App
//      C_Assert    ASSERT ߻   ASSERT
//      ۵   ó  C_App ó   
//      ASSERT ߻ ʱ  .           
C_App::C_App()
{
    //  νϽ ϱ  assert Ͽ.
    ASSERT("C_App", NULL == ms_pApp);
 	ms_pApp = this;

    //
    // main, WinMain Parameter ʱȭ
    //

#if defined(_CONSOLE)
	m_iArgc = 0;
    m_lpszArgv = NULL;
    #if defined(_WIN32)
	   m_lpszEnvp = NULL;
    #endif
#elif defined(_GUI)
    #if defined(_WIN32)
        m_lpCmdLine = NULL;
        m_hInstance = NULL;
        m_iCmdShow = 0;
        m_pMainFrame = NULL;
    #endif
#endif
}

// Purpose:  ü ҸŲ.
C_App::~C_App()
{
}

//
// Overridables
//

// Purpose: Application Ѵ. 
// Returns:  ȯѴ.
// Comment:
//      CONSOLE  κ Override ؼ  WIN32 GUI mode  
//      Run ޼ ϱ  Overrideؼ  ʴ´.
int C_App::Run()
{
#if defined(_WIN32) && defined(_GUI)
    ASSERT("Run", NULL != m_pMainFrame);

    MSG msg;
    
    if (NULL != m_pMainFrame->GetHandleClient())
    {
        HWND    hWndFrame = m_pMainFrame->GetHandle();
        HWND    hWndClient = m_pMainFrame->GetHandleClient();
    
        while (GetMessage (&msg, NULL, 0, 0))
        {
//            if (!TranslateMDISysAccel (hWndClient, &msg) &&
//                !TranslateAccelerator (hWndFrame, hAccel, &msg))
            if (!TranslateMDISysAccel(hWndClient, &msg))
            {
                ::TranslateMessage(&msg);
                ::DispatchMessage(&msg);
            }
        }
    }
    else
    {
        while (::GetMessage (&msg, NULL, 0, 0))
        {
            ::TranslateMessage(&msg);
            ::DispatchMessage(&msg);
        }
    }

    // PostQuitMessage()Լ  ȯѴ. 
    return msg.wParam;
#else
    return 0;
#endif
}

//
// Methods
//

// Purpose:  C_App   ְ ϴ Լ
// Returns: C_Appü 
inline C_App& C_App::GetApp()
{
    ASSERT("GetApp", NULL != ms_pApp);
    return *ms_pApp;
};
