<?php

	/**
	 * List tables in a database
	 *
	 * $Id: tables.php,v 1.82.2.2 2007/07/09 14:55:22 xzilla Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');

	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';

	/**
	 * Show confirmation of empty and perform actual empty
	 */
	function doEmpty($confirm) {
		global $data, $misc;
		global $lang;

		if ($confirm) {
			$misc->printTrail('table');
			$misc->printTitle($lang['strempty'],'');

			echo "<p>", sprintf($lang['strconfemptytable'], $misc->printVal($_REQUEST['table'])), "</p>\n";
      include_once "waiting.php";

			echo "<form action=\"tables.php\" method=\"post\">\n";
			echo "<input type=\"hidden\" name=\"action\" value=\"empty\" />\n";
			echo "<input type=\"hidden\" name=\"table\" value=\"", htmlspecialchars($_REQUEST['table']), "\" />\n";
			echo $misc->form;
			echo "<input type=\"submit\" name=\"empty\" value=\"{$lang['strempty']}\" onclick=\"show_waiting();\"/> <input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
			echo "</form>\n";
		}
		else {
		  $con = $misc->SQLLogin($err);
		  if ($con === false) {
        doDefault($err);
      }
      else {
      	if (($rst = cubrid_execute($con,"DELETE FROM ".$_POST['table']))) {
      	  cubrid_commit($con);
      	  cubrid_disconnect($con);
      	  doDefault($lang['strtableemptied']);
        }
        else {
          doDefault(cubrid_error_msg());
        }
      }
		}
		
	}

	/**
	 * Show confirmation of drop and perform actual drop
	 */
	function doDrop($confirm) {
		global $data, $misc, $_server_info, $db;
		global $lang, $_reload_browser;

		if ($confirm) {
			$misc->printTrail('table');
			$misc->printTitle($lang['strdrop'],'');

			echo "<p>", sprintf($lang['strconfdroptable'], $misc->printVal($_REQUEST['table'])), "</p>\n";
      include_once "waiting.php";
			echo "<form action=\"tables.php\" method=\"post\">\n";
			echo "<input type=\"hidden\" name=\"action\" value=\"drop\" />\n";
			echo "<input type=\"hidden\" name=\"table\" value=\"", htmlspecialchars($_REQUEST['table']), "\" />\n";
			echo $misc->form;
			echo "<input type=\"submit\" name=\"drop\" value=\"{$lang['strdrop']}\" onclick=\"show_waiting();\"/>\n";
			echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
			echo "</form>\n";
		}
		else {
      $tk = $misc->ManagerCommand($_server_info['id'], "dropclass" , "dbname:$db\nclassname:".$_POST['table']."\n");
    	if ($tk['status']!="success") {
  			doDefault($tk['note']);
  		}
  		else {
  			$_reload_browser = true;
  			doDefault($lang['strtabledropped'], true);
  		}
		}
		
	}


	/**
	 * Show default list of tables in the database
	 */
	function doDefault($msg = '', $refresh=false) {
		global $conf, $misc, $lang, $_server_info;
		
		$misc->printTrail('database');
		$misc->printTabs('database','tables');
		$misc->printMsg($msg);
		
		$tables = $misc->getTables($refresh);
		
		$columns = array(
			'table' => array(
				'title' => $lang['strtable'],
				'field' => 'classname',
			),
			'owner' => array(
				'title' => $lang['strowner'],
				'field' => 'owner',
			),
			'type' => array(
				'title' => $lang['strtype'],
				'field' => 'virtual',
			),
			'actions' => array(
				'title' => $lang['stractions'],
			)
		);
		
		$actions = array(
			'properties' => array(
				'title' => $lang['strproperties'],
				'url'   => "redirect.php?subject=table&amp;{$misc->href}&amp;",
				'vars'  => array('table' => 'classname'),
			),
			'drop' => array(
				'title' => $lang['strdrop'],
				'url'   => "tables.php?action=confirm_drop&amp;{$misc->href}&amp;",
				'vars'  => array('table' => 'classname'),
			),
		);
    if ($_server_info['broker']=="ON" &&
			  isset($_server_info['sqlport'])) {
			//@@@TODO 1.2 browse
			//@@@TODO 1.2 select
			$actions = array_merge($actions, array(
  			'empty' => array(
  				'title' => $lang['strempty'],
  				'url'   => "tables.php?action=confirm_empty&amp;{$misc->href}&amp;",
  				'vars'  => array('table' => 'classname'),
  			)
  		));
			//@@@TODO 1.2 insert
    }
		
		$misc->printTable($tables, $columns, $actions, $lang['strnotables']);

    //@@@TODO 1.2 create
		echo "<br><ul>\n";
    echo "<li><a class=\"navlink\" href=\"tables.php?action=refresh&amp;{$misc->href}\">{$lang['strrefresh']}</a></li>\n";
    echo "</ul>\n";
	}
	
	/**
	 * Generate XML for the browser tree.
	 */
	function doTree() {
		global $misc;
		
		$tables = $misc->getTables();
		
		$reqvars = $misc->getRequestVars('table');
		
		$attrs = array(
			'text'   => field('classname'),
			'icon'   => 'Table',
			'iconAction' => url('display.php',
							$reqvars,
							array('table' => field('classname'))
						),
			'action' => url('redirect.php',
							$reqvars,
							array('table' => field('classname'))
						)
		);
		
		$misc->printTreeXML($tables, $attrs);
		exit;
	}
	
	if ($action == 'tree') doTree();
	
	$misc->printHeader($lang['strtables']);
	$misc->printBody();

	switch ($action) {
		case 'empty':
			if (isset($_POST['empty'])) doEmpty(false);
			else doDefault();
			break;
		case 'confirm_empty':
			doEmpty(true);
			break;
		case 'drop':
			if (isset($_POST['drop'])) doDrop(false);
			else doDefault();
			break;
		case 'confirm_drop':
			doDrop(true);
			break;
		case 'refresh':
			doDefault('',true);
			break;
		default:
			doDefault();
			break;
	}	

	$misc->printFooter();

?>
