<?php

	/**
	 * Function library read in upon startup
	 *
	 * $Id: lib.inc.php,v 1.111.2.7 2007/07/09 15:11:27 xzilla Exp $
	 */

	include_once('./libraries/decorator.inc.php');
	include_once('./lang/translations.php');

  function selmake($ary,$val,$nam)
  {
  	$str="<select name='$nam'>";
  	for ($i1=0; $i1<count($ary); $i1++) {
  		$sel=($ary[$i1]==$val) ? "selected" : "";
  		$str.="<option value='".$ary[$i1]."' $sel>".$ary[$i1]."</option>\n";
  	}
  	$str.="</select>";
  	return $str;
  }


  function global_error($str = "  ֽϴ.", $isclose = false)
  {
  	echo("<script language=\"javascript\">\n" .
  	     "<!--\n" .
  	     "alert(\"$str\\n  ưϴ...\");\n");
  	if ($isclose)
  	     "window.close();\n";
  	else
  	     "history.back();\n";
    echo("//-->\n" .
  	     "</script>\n");
  	exit;
  }
	
	// Set error reporting level to max
	error_reporting(E_ALL);

	// Application name 
	$appName = 'phpCubAdmin';

	// Application version
	$appVersion = '1.0.2';

	// CUBRID and PHP minimum version
	$CubridMinVer = '7.1';
	$phpMinVer = '4.1';

	// Check the version of PHP
	if (version_compare(phpversion(), $phpMinVer, '<'))
		exit(sprintf('Version of PHP not supported. Please upgrade to version %s or later.', $phpMinVer));

	// Check to see if the configuration file exists, if not, explain
	if (file_exists('conf/config.inc.php')) {
		$conf = array();
		include('./conf/config.inc.php');
	}
	else {
		echo 'Configuration error: Copy conf/config.inc.php-dist to conf/config.inc.php and edit appropriately.';
		exit;
	}

	// Configuration file version.  If this is greater than that in config.inc.php, then
	// the app will refuse to run.  This and $conf['version'] should be incremented whenever
	// backwards incompatible changes are made to config.inc.php-dist.
	$conf['base_version'] = 16;

	// Always include english.php, since it's the master language file
	if (!isset($conf['default_lang'])) $conf['default_lang'] = 'korean';
	$lang = array();
	require_once('./lang/recoded/korean.php');

	// Create Misc class references
	require_once('./classes/Misc.php');
	$misc = new Misc();

	// Check for https
	if (isset($conf['https']) && $conf['https'] === TRUE && (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] !== TRUE)) {
		echo $lang['strnothttps'];
		exit;
	}

	// Start session (if not auto-started)
	if (!ini_get('session.auto_start')) {
		session_name('PPA_ID'); 
		session_start();
	}

	// Do basic PHP configuration checks
	if (ini_get('magic_quotes_gpc')) {
		$misc->stripVar($_GET);
		$misc->stripVar($_POST);
		$misc->stripVar($_COOKIE);
		$misc->stripVar($_REQUEST);
	}

	// This has to be deferred until after stripVar above
	$misc->setHREF();
	$misc->setForm();

	// Enforce PHP environment
	ini_set('magic_quotes_gpc', 0);
	ini_set('magic_quotes_runtime', 0);
	ini_set('magic_quotes_sybase', 0);
	ini_set('arg_separator.output', '&amp;');
	
	// If login action is set, then set session variables
	if (isset($_POST['loginServer']) && isset($_POST['loginUsername']) && 
		isset($_POST['loginPassword'])) {
		if (!isset($_POST['database'])) {
  		$mgr_login = $misc->ManagerLogin($_POST['loginServer'], $_POST['loginUsername'], $_POST['loginPassword']);
  		if ($mgr_login === FALSE) {
  			$msg = $mgrmsg.'<br>fail to connect to '.$_POST['loginServer'].' '.$_POST['loginUsername'];
  			$subject = "login";
  		}
  	}
  	else {
  		$_server_info = $misc->getServerInfo($_POST['loginServer']);
  		if ($misc->DbLogin($_server_info, $_POST['database'], $_POST['loginUsername'], $_POST['loginPassword']) === FALSE) {
  			$msg = $mgrmsg.'<br>fail to connect to '.$_POST['loginServer'].' '.$_POST['database'].' '.$_POST['loginUsername'];
  			$subject = "login_to_db";
  		}
  	}
		
		$_reload_browser = true;
	}

	// Determine language file to import:
	// 1. Check for the language from a request var
	if (isset($_REQUEST['language']) && isset($appLangFiles[$_REQUEST['language']]))
		$_language = $_REQUEST['language'];
	
	// 2. Check for language session var
	if (!isset($_language) && isset($_SESSION['webdbLanguage']) && isset($appLangFiles[$_SESSION['webdbLanguage']])) {
		$_language = $_SESSION['webdbLanguage'];
	}
	
	// 3. Check for acceptable languages in HTTP_ACCEPT_LANGUAGE var
	if (!isset($_language) && $conf['default_lang'] == 'auto' && isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
		// extract acceptable language tags
		// (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.4)
		preg_match_all('/\s*([a-z]{1,8}(?:-[a-z]{1,8})*)(?:;q=([01](?:.[0-9]{0,3})?))?\s*(?:,|$)/', strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE']), $_m, PREG_SET_ORDER);
		foreach($_m as $_l) {  // $_l[1] = language tag, [2] = quality
			if (!isset($_l[2])) $_l[2] = 1;  // Default quality to 1
			if ($_l[2] > 0 && $_l[2] <= 1 && isset($availableLanguages[$_l[1]])) {
				// Build up array of (quality => language_file)
				$_acceptLang[$_l[2]] = $availableLanguages[$_l[1]];
			}
		}
		unset($_m);
		unset($_l);
		if (isset($_acceptLang)) {
			// Sort acceptable languages by quality
			krsort($_acceptLang, SORT_NUMERIC);
			$_language = reset($_acceptLang);
			unset($_acceptLang);
		}
	}

	// 4. Otherwise resort to the default set in the config file
	if (!isset($_language) && $conf['default_lang'] != 'auto' && isset($appLangFiles[$conf['default_lang']])) {
		$_language = $conf['default_lang'];
	}

	// Import the language file
	if (isset($_language)) {
		include("./lang/recoded/{$_language}.php");
		$_SESSION['webdbLanguage'] = $_language;
	}

	// Check for config file version mismatch
	if (!isset($conf['version']) || $conf['base_version'] > $conf['version']) {
		echo $lang['strbadconfig'];
		exit;
	}
	
	// Check database support is properly compiled in
	if (!function_exists('cubrid_connect')) {
		echo $lang['strnotloaded'];
		exit;
	}

	// Check socket
	if (!function_exists('socket_create')) {
		echo $lang['strnosocket'];
		exit;
	}

	// Create data accessor object, if necessary
	if (!isset($_no_db_connection)) {
		if (!isset($_REQUEST['server'])) {
			die('No server supplied!');
			# TODO: nice error
		}
		$_server_info = $misc->getServerInfo();

		// Redirect to the login form if not logged in
		if (!isset($_server_info['username'])) {
			include('./login.php');
			exit;
		}
	}

	$_server_info = $misc->getServerInfo();
	if (isset($_REQUEST['database'])) $db = $_REQUEST['database'];
	if (isset($_REQUEST['table'])) $table = $_REQUEST['table'];
  if (isset($_REQUEST['database'])) {
    $db = $_REQUEST['database'];

		// Redirect to the login form if not logged in
		if (!isset($_server_info['login'][$db]) || 
		    strlen($_server_info['login'][$db])<=0) {
			include('./login_to_db.php');
			exit;
		}
  }
  
  $data->_maxNameLen = 255;
  $data->_maxDbLen = (isset($_server_info['osinfo']) && $_server_info['osinfo'] == 'NT') ? 6 : 255
?>
