<?php

	/**
	 * Manage users in a database cluster
	 *
	 * $Id: users.php,v 1.32.2.2 2007/07/09 14:55:22 xzilla Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');

	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
	if (!isset($msg)) $msg = '';
		
	/**
	 * Show confirmation of change password and actually change password
	 */
	function doChangePassword($confirm, $msg = '') {
		global $data, $misc, $db;
		global $lang, $conf, $_server_info;
		
		if ($confirm) {
			$_REQUEST['user'] = $_REQUEST['username'];
			$misc->printTrail('user');
			$misc->printTitle($lang['strchangepassword'],'');
			$misc->printMsg($msg);
			
			if (!isset($_POST['password'])) $_POST['password'] = '';
			if (!isset($_POST['confirm'])) $_POST['confirm'] = '';
			
			include_once "waiting.php";
			
			echo "<form action=\"users.php\" method=\"post\">\n";
			echo $misc->form;
			echo "<table>\n";
			echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['strpassword']}</th>\n";
			echo "\t\t<td><input type=\"password\" name=\"password\" size=\"32\" value=\"", 
				htmlspecialchars($_POST['password']), "\" /></td>\n\t</tr>\n";
			echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['strconfirm']}</th>\n";
			echo "\t\t<td><input type=\"password\" name=\"confirm\" size=\"32\" value=\"\" /></td>\n\t</tr>\n";
			echo "<table>\n";
			echo "<input type=\"hidden\" name=\"username\" value=\"".$_REQUEST['username']."\" />\n";
			echo "<input type=\"hidden\" name=\"action\" value=\"changepassword\" />\n";
			echo "<input type=\"submit\" name=\"ok\" value=\"{$lang['strok']}\" onclick=\"show_waiting();\"/>\n";
			echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
			echo "</p></form>\n";
		}
		else {
			// Check that password matches confirmation password
			if ($_POST['password'] != $_POST['confirm'])
				doChangePassword(true, $lang['strpasswordconfirm']);
			else {
				$message = "dbname:$db\n";
        $message .= "username:".$_REQUEST['username']."\n";
        
        $_POST['password'] = trim($_POST['password']);
				
				if (strlen($_POST['password'])<=0)
					$message .= "userpass:__NULL__\n";
				else 
					$message .= "userpass:".$_POST['password']."\n";
					
				$message .= $misc->getUserMessage('group', $_REQUEST['username']);
				$message .= $misc->getUserMessage('auth', $_REQUEST['username']);

        $tk = $misc->ManagerCommand($_server_info['id'], "updateuser" , $message);
      	if ($tk['status']!="success") {
    			doChangePassword(true, $tk['note']);
    		}
    		else {
    			doDefault($lang['strpasswordchanged'], true);
    		}
			}
		}		
	}

	/**
	 * Show confirmation of drop and perform actual drop
	 */
	function doDrop($confirm) {
		global $data, $misc, $db, $_server_info;
		global $lang;

		if ($confirm) {
			$misc->printTrail('user');
			$misc->printTitle($lang['strdrop'],'');
			
			echo "<p>", sprintf($lang['strconfdropuser'], $misc->printVal($_REQUEST['username'])), "</p>\n";	
			
      include_once "waiting.php";
			echo "<form action=\"users.php\" method=\"post\">\n";
			echo $misc->form;
			echo "<input type=\"hidden\" name=\"action\" value=\"drop\" />\n";
			echo "<input type=\"hidden\" name=\"username\" value=\"", htmlspecialchars($_REQUEST['username']), "\" />\n";
			echo "<input type=\"submit\" name=\"drop\" value=\"{$lang['strdrop']}\" onclick=\"show_waiting();\"/>\n";
			echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
			echo "</form>\n";
		}
		else {
      $tk = $misc->ManagerCommand($_server_info['id'], "deleteuser" , "dbname:$db\nusername:".$_REQUEST['username']."\n");
    	if ($tk['status']!="success") {
  			doDefault($tk['note']);
  		}
  		else {
  			doDefault($lang['struserdropped'], true);
  		}
		}		
	}
	
	/**
	 * Displays a screen where they can enter a new user
	 */
	function doCreate($msg = '') {
		global $data, $misc, $username;
		global $lang;
		
		if (!isset($_POST['formUsername'])) $_POST['formUsername'] = '';
		if (!isset($_POST['formPassword'])) $_POST['formPassword'] = '';
		if (!isset($_POST['formConfirm'])) $_POST['formConfirm'] = '';
		
		$misc->printTrail('user');
		$misc->printTitle($lang['strcreateuser'],'');
		$misc->printMsg($msg);

    include_once "waiting.php";
    
		echo "<form action=\"users.php\" method=\"post\">\n";
		echo $misc->form;
		echo "<table>\n";
		echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['strusername']}</th>\n";
		echo "\t\t<td class=\"data1\"><input size=\"15\" name=\"formUsername\" value=\"", htmlspecialchars($_POST['formUsername']), "\" /></td>\n\t</tr>\n";
		echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['strpassword']}</th>\n";
		echo "\t\t<td class=\"data1\"><input size=\"15\" type=\"password\" name=\"formPassword\" value=\"", htmlspecialchars($_POST['formPassword']), "\" /></td>\n\t</tr>\n";
		echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['strconfirm']}</th>\n";
		echo "\t\t<td class=\"data1\"><input size=\"15\" type=\"password\" name=\"formConfirm\" value=\"", htmlspecialchars($_POST['formConfirm']), "\" /></td>\n\t</tr>\n";
		echo "</table>\n";
		echo "<p><input type=\"hidden\" name=\"action\" value=\"save_create\" />\n";
		echo "<input type=\"submit\" value=\"{$lang['strcreate']}\" onclick=\"show_waiting();\"/>\n";
		echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" /></p>\n";
		echo "</form>\n";
	}
	
	/**
	 * Actually creates the new user in the database
	 */
	function doSaveCreate() {
		global $data;
		global $lang, $misc, $db, $_server_info;

		// Check data
		if ($_POST['formUsername'] == '')
			doCreate($lang['struserneedsname']);
		else if ($_POST['formPassword'] != $_POST['formConfirm'])
			doCreate($lang['strpasswordconfirm']);
		else {		
			$message = "dbname:$db\n";
      $message .= "username:".$_POST['formUsername']."\n";
      
      $_POST['formPassword'] = trim($_POST['formPassword']);
			if (strlen($_POST['formPassword'])<=0)
				$message .= "userpass:__NULL__\n";
			else 
				$message .= "userpass:".$_POST['formPassword']."\n";

      $message .= "open:groups\n";
			$message .= "group:PUBLIC\n";
			$message .= "close:groups\n";
			$message .= "open:authorization\n";
			$message .= "close:authorization\n";

      $tk = $misc->ManagerCommand($_server_info['id'], "createuser" , $message);
    	if ($tk['status']!="success") {
  			doDefault($tk['note']);
  		}
  		else {
  			doDefault($lang['strusercreated'], true);
  		}
		}
	}	

	/**
	 * Show default list of users in the database
	 */
	function doDefault($msg = '', $refresh = false) {
		global $data, $misc, $_server_info, $db;
		global $lang;
		
		$misc->printTrail('database');
		$misc->printTabs('database','users');
		$misc->printMsg($msg);

		function svPre(&$rowdata, $actions) {
		  global $_server_info, $db;
		  
		  if ($rowdata->f['name'] == "PUBLIC" || $rowdata->f['name'] == "DBA")
		    $actions['drop']['disable'] = true;
		  if ($_server_info['isdba'][$db] != 'y' &&
		      $_server_info['login'][$db] != $rowdata->f['name']) {
			  $actions['chgpass']['disable'] = true;
			  $actions['drop']['disable'] = true;
			}
			return $actions;
		}
		
		$users = $misc->getDbUsers($refresh);
		
		$columns = array(
			'name' => array(
				'title' => $lang['strusername'],
				'field' => 'name',
			),
			'groups' => array(
				'title' => $lang['strgroup'],
				'field' => 'groups',
				'type'  => 'array'
			),
			'actions' => array(
				'title' => $lang['stractions'],
			),
		);
		
		$actions = array(
      //@@@TODO 1.2 edit group
		  //@@@TODO 1.2 grant/revoke
		  'drop' => array(
				'title' => $lang['strdrop'],
				'url'   => "users.php?action=confirm_drop&amp;{$misc->href}&amp;",
				'vars'  => array('username' => 'name'),
			),
		  'chgpass' => array(
				'title' => $lang['strchangepassword'],
				'url'   => "users.php?action=confchangepassword&amp;{$misc->href}&amp;",
				'vars'  => array('username' => 'name'),
			),
		);

		$misc->printTable($users, $columns, $actions, $lang['strnousers'], 'svPre');

    echo "<br><ul>\n";
	  if ($_server_info['isdba'][$db] == 'y')
  		echo "<li><a class=\"navlink\" href=\"users.php?action=create&amp;{$misc->href}\">{$lang['strcreateuser']}</a></li>\n";
 		echo "<li><a class=\"navlink\" href=\"users.php?action=refresh&amp;{$misc->href}\">{$lang['strrefresh']}</a></li>\n";
    echo "</ul>\n";
	}

	$misc->printHeader($lang['strusers']);
	$misc->printBody();

	switch ($action) {
		case 'changepassword':
			if (isset($_REQUEST['ok'])) doChangePassword(false);
			else doDefault();
			break;
		case 'confchangepassword':
			doChangePassword(true);
			break;			
		case 'save_create':
			if (isset($_REQUEST['cancel'])) doDefault();
			else doSaveCreate();
			break;
		case 'create':			
			doCreate();
			break;
		case 'drop':
			if (isset($_REQUEST['cancel'])) doDefault();
			else doDrop(false);
			break;
		case 'confirm_drop':
			doDrop(true);
			break;
		case 'refresh':
			doDefault('', true);
			break;
		default:
			doDefault();
			break;
	}	

	$misc->printFooter();

?>
