<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +--------------------------------------------------------+
// | PHP version 5.x                                        |
// +--------------------------------------------------------+
// | Copyright : Song Hyo-Jin <shj at xenosi.de>            |
// +--------------------------------------------------------+
// | License : BSD                                          |
// +--------------------------------------------------------+
//
// $Id: PDOMySQL.inc.php, 2009. 3. 24. crucify Exp $

include_once 'PDOExt.inc.php';

class SHJPDOMySQL extends SHJPDOExt
{
	public function __construct($conninfo, $pconnect = false)
	{
		$conndata = parse_ini_file($conninfo);
		$conntext = 'mysql:';
		if(isset($conndata['host'])) {
			$conntext .= 'host=' . $conndata['host'] . ';';
		}
		if(isset($conndata['port'])) {
			$conntext .= 'port=' . $conndata['port'] . ';';
		}
		$conntext .= 'dbname=' . $conndata['db'] . ';';
		if(isset($conndata['charset'])) {
			$this->charset = $conndata['charset'];
		}
		parent::__construct($conntext, $conndata['user'], $conndata['pass'], $pconnect);
		$this->setDsn('mysql');
		$this->setSelect('MySQL');
	}
	
	public function escape_string($str)
	{
		return mysql_escape_string($str);
	}
}

class SHJPDOMySQLSelect extends SHJPDOSelect
{
	public function compile($lock = false)
	{
		$query = parent::compile();
		if($lock) {
			$query .= ' FOR UPDATE';
		}
		return $query;
	}
	
	public function prepare($lock = false)
	{
		$fields = null;
		$stmt = $this->class->prepare($this->compile($lock));
		if($fields != null) {
			$stmt->bind($fields);
		}
		if($this->wfields != null) {
			$stmt->bind($this->wfields);
		}
		if($this->limit) {
			$this->class->bindParam('limit', $this->limit, PDO::PARAM_INT);
		}
		if($this->offset) {
			$this->class->bindParam('offset', $this->offset, PDO::PARAM_INT);
		}
		return $stmt;
	}
}
