<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +--------------------------------------------------------+
// | PHP version 5.x                                        |
// +--------------------------------------------------------+
// | Copyright : Song Hyo-Jin <shj at xenosi.de>            |
// +--------------------------------------------------------+
// | License : BSD                                          |
// +--------------------------------------------------------+
//
// $Id: PDOSQLite.inc.php, 2009. 3. 24. crucify Exp $

include_once 'PDOExt.inc.php';

class SHJPDOSQLite extends SHJPDOExt
{
	public function __construct($conninfo)
	{
		$this->class = new PDO('sqlite:' . $conninfo);
		$this->preset();
		$this->setDsn('sqlite');
	}
	
	public function begin()
	{
		return parent::begin();
	}
	
	public function query($query = false)
	{
		return parent::query($query);
	}
	
	public function prepare($query = false)
	{
		return parent::prepare($query);
	}
	
	public function escape_string($str)
	{
		return sqlite_escape_string($str);
	}
}