<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +--------------------------------------------------------+
// | PHP version 5.x                                        |
// +--------------------------------------------------------+
// | Copyright : Song Hyo-Jin <shj at xenosi.de>            |
// +--------------------------------------------------------+
// | License : BSD                                          |
// +--------------------------------------------------------+
//
// $Id: CommonSQL.inc.php, 2009. 3. 24. crucify Exp $

/*
define('SQL_BIGINT', '18446744073709551615');
define('SQL_INT', 4294967295);
define('SQL_MEDIUMINT', 16777215);
define('SQL_SMALLINT', 65535);
define('SQL_TINYINT', 255);
*/

function make_table($rows, $title = array ())
{
	array_walk($rows, 'apply_all', 'htmlspecialchars');
	array_walk($rows, 'apply_all', 'nl2br');
	$html = '<table border="1" style="border-collapse:collapse;">';
	if(count($title) == 0) {
		foreach($rows[0] as $key => $value) {
			$title[] = $key;
		}
	}
	array_walk($title, 'apply_all', 'htmlspecialchars');
	$html .= '<tr bgcolor="#e0e0ff">';
	$html .= '<td><strong>'.implode('</strong></td><td><strong>', $title).'</strong></td>';
	$html .= '</tr>';
	$flag = 0;
	$switch = array(
		'',
		'#efefef'
	);
	foreach($rows as $value) {
		$html .= '<tr bgcolor="'.$switch[$flag].'">';
		$html .= '<td>'.implode('</td><td>', $value).'</td>';
		$html .= '</tr>';
		$flag = !$flag;
	}
	$html .= '</table>';

	return $html;
}