/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<HSBase.c>		2006-03-30,22:11

*/

#if !defined(_WIN32_WCE)
#include <time.h>
#endif

#include "HSBase.h"





/* vendor list

  1. voiper
  2. my vendor

*/





#define SEC_PER_YEAR	31536000
#define SEC_PER_MONTH	2592000
/* licence time
*/
#define EXPIRE_YEAR		3000
#define EXPIRE_MONTH	7
#define EXPIRE_TARGET	(SEC_PER_YEAR*(EXPIRE_YEAR-1970) + SEC_PER_MONTH*EXPIRE_MONTH)





void HSSrand()
{
#if defined(_WIN32_WCE)
	SYSTEMTIME tSystemTime;
	GetLocalTime(&tSystemTime);
	srand((HS_UINT)(tSystemTime.wMilliseconds));
#else
	srand((unsigned)time(NULL));
#endif
}


HS_RESULT LoadHSResource(HS_UINT pMaxThread)
{
#if defined(_WIN32) || defined(_WIN32_WCE)
	WSADATA wsaData;
	WSAStartup(MAKEWORD(2,2),&wsaData);
#endif

	OpenThreadPool((pMaxThread==0)? 100:pMaxThread);
	OpenTimerList();
	OpenHSPrint();

	return HS_OK;
}


HS_RESULT UnloadHSResource(HS_UINT pDelayMilliSecond)
{

	HSSleep(pDelayMilliSecond);

	CloseHSPrint();
	CloseTimerList();
	CloseThreadPool();

#if defined(_WIN32) || defined(_WIN32_WCE)
	WSACleanup();
#endif

	return HS_OK;
}


HS_RESULT HSCheckLicenceTime()
{
#if 0
#if defined(_WIN32_WCE)
	SYSTEMTIME tSysTime;
	GetLocalTime(&tSysTime);
	if( tSysTime.wYear>EXPIRE_YEAR ) return HS_ERR;
	if( tSysTime.wYear==EXPIRE_YEAR && tSysTime.wMonth>EXPIRE_MONTH ) return HS_ERR;
#else
	if( time(0) > EXPIRE_TARGET ) return HS_ERR;
#endif
#endif

	return HS_OK;
}


HS_RESULT HSResponseVendorCheckPacket(HS_UCHAR *pBuffer,int pLen,SOCKET pSocket,struct sockaddr_in pRecvIn)
{
	if( pBuffer==NULL || pSocket==INVALID_SOCKET ) return HS_ERR;
	if( pLen != 16 ) return HS_ERR;
	if( memcmp(pBuffer,"show your vendor",16) ) return HS_ERR;

	sendto(pSocket,RELEASED_VENDOR,strlen(RELEASED_VENDOR),0,(struct sockaddr*)(&pRecvIn),sizeof(pRecvIn));
	return HS_OK;
}



