/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<HSDefine.h>	2004-07-03,12:02

*/

#ifndef __HSDEFINE_H__
#define __HSDEFINE_H__





/* released vendor
*/
#define RELEASED_VENDOR		"voiper"





/* include base header
*/
#if defined(_WIN32) || defined(_WIN32_WCE)
	#include <malloc.h>
	#include <memory.h>
	#include <stdio.h>
	#include <string.h>
	#include <winsock.h>
	#define HS_SMALL_ENDIAN
#elif defined(_VXWORKS)
	#include <vxWorks.h>
	#include <stdio.h>
	#include <string.h>
	#include <fioLib.h>
	#include <semLib.h>
	#include <taskLib.h>
	#include <string.h>

	#include <config.h>
	#include <arpa/inet.h>
	#include <sys/socket.h>
	#include <sys/times.h>
	#include <msgQLib.h>
	#include <netLib.h>
	#include <sysLib.h>
	#define HS_BIG_ENDIAN
#elif defined(_LINUX)
	#include <malloc.h>
	#include <memory.h>
	#include <stdio.h>
	#include <stdarg.h>
	#include <string.h>
	#include <arpa/inet.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <sys/ipc.h>
	#include <sys/msg.h>
	#include <sys/sem.h>
	#include <errno.h>
	#include <pthread.h>
	#include <unistd.h>
	#define HS_BIG_ENDIAN
#endif





/* set debug range
*/
#define HS_DEBUG_ASN
#define HS_DEBUG_ASN_MEMBER
#define HS_DEBUG_ASN_PRINT





/* type definitions
*/
typedef char				HS_CHAR;
typedef unsigned char		HS_UCHAR;
#define HS_UCHAR_MAX		0xff
typedef short				HS_SHORT;
typedef unsigned short		HS_USHORT;
#define HS_USHORT_MAX		0xffff
typedef int					HS_INT;
typedef unsigned int		HS_UINT;
#define HS_UINT_MAX			0xffffffff

#if defined(_WIN32) || defined(_WIN32_WCE)
	typedef signed __int64		HS_INT64;
	typedef unsigned __int64	HS_UINT64;
#elif defined(_LINUX) || defined(_VXWORKS)
	typedef signed long long	HS_INT64;
	typedef unsigned long long	HS_UINT64;
#endif

typedef int					HS_RESULT;

#ifndef BOOL
#define BOOL				int
#endif
#ifndef FALSE
#define FALSE				0
#endif
#ifndef TRUE
#define TRUE				1
#endif
#ifndef NULL
#define NULL				0
#endif
#define HS_NULL				NULL

#define HS_QID				HS_UINT
#define HS_INVALID_QID		HS_UINT_MAX

#define HS_TID							HS_UINT
#define HS_TR_HANDLE					HS_UINT
#define HS_CALL_HANDLE					HS_UINT
#define HS_STACK_HANDLE					void*
#define HS_INVALID_STACK_HANDLE			NULL
#define HS_INVALID_TID					HS_UINT_MAX
#define HS_INVALID_POS					HS_UINT_MAX
#define HS_INVALID_HANDLE				HS_UINT_MAX
#define HS_INVALID_TSAP_PORT			HS_USHORT_MAX

#if !defined(INVALID_SOCKET)
typedef int SOCKET;
#define INVALID_SOCKET		-1
#define closesocket			close
#endif

#define HS_INVALID_SOCKET	INVALID_SOCKET

#if !defined(INADDR_NONE)
#define INADDR_NONE 0xffffffff
#endif

#if defined(_LINUX) || defined(_VXWORKS)
	#define WM_USER		10000
	#define WPARAM		HS_USHORT
	#define LPARAM		HS_UINT
#endif





/* malloc / free wrapping
*/
#ifdef HS_DEBUG_MALLOC
#else/*HS_DEBUG_MALLOC*/

#define HSMalloc	malloc
#define HSFree		free

#endif/*HS_DEBUG_MALLOC*/





/* semaphore definitions
*/
#if defined(_WIN32) || defined(_WIN32_WCE)
	#define HSSemaphore				CRITICAL_SECTION
	#define HSOpenSemaphore(sem)	InitializeCriticalSection(&sem)
	#define HSCloseSemaphore(sem)	DeleteCriticalSection(&sem)
	#define HSLockSemaphore(sem)	EnterCriticalSection(&sem)
	#define HSUnlockSemaphore(sem)	LeaveCriticalSection(&sem)
#elif defined(_VXWORKS)
	#define HSSemaphore				SEM_ID
	#define HSOpenSemaphore(sem)	sem = semBCreate(SEM_Q_PRIORITY,SEM_FULL)
	#define HSCloseSemaphore(sem)	semTerminate(sem)
	#define HSLockSemaphore(sem)	semTake(sem,WAIT_FOREVER)
	#define HSUnlockSemaphore(sem)	semGive(sem)
#elif defined(_LINUX)
	#define HSSemaphore				int
	#define HS_INVALID_SEM			(-1)
	#define HSOpenSemaphore(sem)	sem=_HSOpenSemaphore()
	#define HSCloseSemaphore(sem)	_HSCloseSemaphore(sem)
	#define HSLockSemaphore(sem)	_HSLockSemaphore(sem)
	#define HSUnlockSemaphore(sem)	_HSUnlockSemaphore(sem)

	#define HS_LINUX_SEM_KEY_MIN	10000
	#define HS_LINUX_SEM_KEY_MAX	HS_LINUX_SEM_KEY_MIN +2000

	int _HSOpenSemaphore();
	HS_RESULT _HSCloseSemaphore(HSSemaphore pSem);
	HS_RESULT _HSLockSemaphore(HSSemaphore pSem);
	HS_RESULT _HSUnlockSemaphore(HSSemaphore pSem);
#endif





/* base thread queue messages
*/
#define HS_QM								1120
#define HS_QM_USER							1200
#define HS_QM_MAX							2000
/* wparam: 0
   lparam: any value
*/
#define HS_QM_START							HS_QM +1
/* wparam: 0
   lparam: null
*/
#define HS_QM_CHECK							HS_QM_START +1
/* wparam: 0
   lparam: null
*/
#define HS_QM_STOP							HS_QM_CHECK +1
/* wparam: 0
   lparam: HSTimerEvent object pointer
*/
#define HS_QM_TIMER							HS_QM_STOP +1
/* wparam: 0
   lparam: QmConnected object pointer
*/
#define HS_QM_CONNECTED							HS_QM_TIMER +1





/* base return value
   (-): not ok, but not error.
   (0): every thing is ok.
   (+): error.
*/
#define HS_NOK								-1

#define HS_OK								0

#define HS_ERR								1
#define HS_ERR_NULL							2
#define HS_ERR_NULL_PARAM					3
#define HS_ERR_MALLOC						4
#define HS_ERR_INVALID						5
#define HS_ERR_INVALID_PARAM				6
#define HS_ERR_INVALID_VALUE				7
#define HS_ERR_CONFLICT						8
#define HS_ERR_NO_EXIST						9
#define HS_ERR_OVER							10
#define HS_ERR_EMPTY						11
#define HS_ERR_FILE							12

#define HS_ERR_NET_SOCKET					30
#define HS_ERR_NET_BIND						31
#define HS_ERR_NET_SEND						32
#define HS_ERR_NET_RECV						33

#define HS_ERR_NOT_SUPPORT_YET				100
#define HS_ERR_LICENCE						1000

#define HS_TRY(t)					{if( (tRet=t) != HS_OK ) return tRet;}
#define HS_TRY_OK(t)				{if(    t    != HS_OK ) return HS_OK;}





#endif/*__HSDEFINE_H__*/

