/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<HSSocketList.h>	2006-04-28,16:31,hskim

*/

#ifndef __HSSOCKET_LIST_H__
#define __HSSOCKET_LIST_H__





#include "HSDefine.h"
#include "TcpConnect.h"





#define HS_SPECIAL_SOCKET_ID		HS_USHORT_MAX
#define HS_INVALID_SOCKET_ID		HS_UINT_MAX





typedef struct
{
	HS_UINT	mId;

	BOOL	mIsTcp;
	BOOL	mIsConnected;

	SOCKET	mSocket;
	struct sockaddr_in	mLocalIn;
	struct sockaddr_in	mRemoteIn;

	/* ! NOTE: if this callback function return HS_NOK,
	           ChainUnit of this unit shall be deleted.
	*/
	HS_RESULT (*CallbackFdEvent)(void*,void*);
} HSSocketUnit;

HS_RESULT new_HSSocketUnit(void *pObject,BOOL pIsTcp,HS_RESULT (*pCallbackFdEvent)(void*,void*));
HSSocketUnit *newm_HSSocketUnit(BOOL pIsTcp,HS_RESULT (*pCallbackFdEvent)(void*,void*));
HS_RESULT delete_HSSocketUnit(void *pObject);
HS_RESULT deletem_HSSocketUnit(void *pObject);

HS_RESULT HSSocketUnit_Socket(void *pObject);
HS_RESULT HSSocketUnit_Bind(void *pObject,HS_UINT pIp,HS_USHORT pPort);
HS_RESULT HSSocketUnit_BindEx(void *pObject,HS_UCHAR *pIp,HS_USHORT pPort);
HS_RESULT HSSocketUnit_Listen(void *pObject);
HS_RESULT HSSocketUnit_Connect(void *pObject,HS_UINT pIp,HS_USHORT pPort,HS_QID pQid);
HS_RESULT HSSocketUnit_ConnectEx(void *pObject,HS_QID pQid);
HS_RESULT HSSocketUnit_ConnectBlock(void *pObject);
HSSocketUnit *HSSocketUnit_Accept(void *pObject,HS_RESULT (*pCallbackFdEvent)(void*,void*));
HS_RESULT HSSocketUnit_AcceptEx(void *pObject,HSSocketUnit *pUnit);

HS_RESULT HSSocketUnit_Receive(void *pObject,unsigned char *pData,int *pLen);
HS_RESULT HSSocketUnit_ReceiveFrom(void *pObject,unsigned char *pData,int *pLen);
HS_RESULT HSSocketUnit_ReceiveFromEx(void *pObject,unsigned char *pData,int *pLen,struct sockaddr_in *pRemoteIn);
HS_RESULT HSSocketUnit_Send(void *pObject,unsigned char *pData,int pLen);
HS_RESULT HSSocketUnit_SendTo(void *pObject,unsigned char *pData,int pLen);
HS_RESULT HSSocketUnit_SendToEx(void *pObject,unsigned char *pData,int pLen,struct sockaddr_in pRemoteIn);
HS_RESULT HSSocketUnit_SendToEx1(void *pObject,unsigned char *pData,int pLen,HS_UINT pIp,HS_USHORT pPort);
HS_RESULT HSSocketUnit_SendToEx2(void *pObject,unsigned char *pData,int pLen,HS_UCHAR *pIp,HS_USHORT pPort);
HS_RESULT HSSocketUnit_Close(void *pObject);

HS_RESULT HSSocketUnit_FdSet(void *pObject,fd_set *pFdSet,int *pFdMax);
HS_RESULT HSSocketUnit_FdIsSet(void *pObject,fd_set *pFdSet,void *pArg);





typedef struct
{
	HS_UINT		mSeed;
	NoLockList	mList;
} HSSocketList;

HS_RESULT new_HSSocketList(void *pObject);
HSSocketList *newm_HSSocketList();
HS_RESULT delete_HSSocketList(void *pObject);
HS_RESULT deletem_HSSocketList(void *pObject);

HS_RESULT HSSocketList_AttachData(void *pObject,HSSocketUnit *pUnit);
HS_RESULT HSSocketList_MakeId(void *pObject,HSSocketUnit *pUnit);

HS_RESULT HSSocketList_FdSet(void *pObject,fd_set *pFdSet,int *pFdMax);
HS_RESULT HSSocketList_FdIsSet(void *pObject,fd_set *pFdSet,void *pArg);
HS_RESULT HSSocketList_Select(void *pObject,fd_set *pFdSet,int pFdMax,HS_UINT pSec,HS_UINT pUSec);

HSSocketUnit *HSSocketList_GetUnitById(void *pObject,HS_UINT pId);
ChainUnit    *HSSocketList_GetChainByRemoteIp(void *pObject,HS_UINT pIp);





#endif/*__HSSOCKET_LIST_H__*/


