/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<H225.h>	2005-03-27,12:37

*/
#ifndef __2005_03_27__12_37__H225_H__
#define __2005_03_27__12_37__H225_H__


#include "H323Define.h"
#include "handship.h"



ASN_NO_USE_YET(H225ClearToken,"H225ClearToken")
ASN_NO_USE_YET(H225CryptoH323Token,"H225CryptoH323Token")
ASN_NO_USE_YET(H225AuthenticationMechanism,"H225AuthenticationMechanism")
#include "H235.h"
#define ASNH225TimeStamp ASNH235TimeStamp
#define new_ASNH225TimeStamp new_ASNH235TimeStamp
#define delete_ASNH225TimeStamp delete_ASNH235TimeStamp
#define ASNH225TimeStamp_MakeMold ASNH235TimeStamp_MakeMold
#define ASNH225TimeStamp_Print ASNH235TimeStamp_Print
#define ASNH225TimeStamp_Encode ASNH235TimeStamp_Encode
#define ASNH225TimeStamp_Decode ASNH235TimeStamp_Decode
#include "H245.h"
#define ASNH225DataProtocolCapability ASNH245DataProtocolCapability
#define new_ASNH225DataProtocolCapability new_ASNH245DataProtocolCapability
#define delete_ASNH225DataProtocolCapability delete_ASNH245DataProtocolCapability
#define ASNH225DataProtocolCapability_MakeMold ASNH245DataProtocolCapability_MakeMold
#define ASNH225DataProtocolCapability_Print ASNH245DataProtocolCapability_Print
#define ASNH225DataProtocolCapability_Encode ASNH245DataProtocolCapability_Encode
#define ASNH225DataProtocolCapability_Decode ASNH245DataProtocolCapability_Decode
#define ASNH225T38FaxProfile ASNH245T38FaxProfile
#define new_ASNH225T38FaxProfile new_ASNH245T38FaxProfile
#define delete_ASNH225T38FaxProfile delete_ASNH245T38FaxProfile
#define ASNH225T38FaxProfile_MakeMold ASNH245T38FaxProfile_MakeMold
#define ASNH225T38FaxProfile_Print ASNH245T38FaxProfile_Print
#define ASNH225T38FaxProfile_Encode ASNH245T38FaxProfile_Encode
#define ASNH225T38FaxProfile_Decode ASNH245T38FaxProfile_Decode


typedef struct
{
	AsnSingleString	inheritance;
} ASNH225NumberDigits;
HS_RESULT new_ASNH225NumberDigits( void *pObject );
HS_RESULT delete_ASNH225NumberDigits( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225NumberDigits_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225NumberDigits_MakeMold( void *pObject );
HS_RESULT ASNH225NumberDigits_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225NumberDigits_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnSingleString	inheritance;
} ASNH225TBCD_STRING;
HS_RESULT new_ASNH225TBCD_STRING( void *pObject );
HS_RESULT delete_ASNH225TBCD_STRING( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TBCD_STRING_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TBCD_STRING_MakeMold( void *pObject );
HS_RESULT ASNH225TBCD_STRING_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TBCD_STRING_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnOctetString	inheritance;
} ASNH225GloballyUniqueID;
HS_RESULT new_ASNH225GloballyUniqueID( void *pObject );
HS_RESULT delete_ASNH225GloballyUniqueID( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GloballyUniqueID_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GloballyUniqueID_MakeMold( void *pObject );
HS_RESULT ASNH225GloballyUniqueID_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GloballyUniqueID_Decode( void *pObject, AsnStream *pStrm );

#define ASNH225ConferenceIdentifier          ASNH225GloballyUniqueID
#define new_ASNH225ConferenceIdentifier      new_ASNH225GloballyUniqueID
#define delete_ASNH225ConferenceIdentifier   delete_ASNH225GloballyUniqueID
#define ASNH225ConferenceIdentifier_MakeMold ASNH225GloballyUniqueID_MakeMold
#define ASNH225ConferenceIdentifier_Print    ASNH225GloballyUniqueID_Print
#define ASNH225ConferenceIdentifier_Encode   ASNH225GloballyUniqueID_Encode
#define ASNH225ConferenceIdentifier_Decode   ASNH225GloballyUniqueID_Decode

typedef struct
{
	AsnInteger	inheritance;
} ASNH225RequestSeqNum;
HS_RESULT new_ASNH225RequestSeqNum( void *pObject );
HS_RESULT delete_ASNH225RequestSeqNum( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RequestSeqNum_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RequestSeqNum_MakeMold( void *pObject );
HS_RESULT ASNH225RequestSeqNum_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RequestSeqNum_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnDoubleString	inheritance;
} ASNH225GatekeeperIdentifier;
HS_RESULT new_ASNH225GatekeeperIdentifier( void *pObject );
HS_RESULT delete_ASNH225GatekeeperIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GatekeeperIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GatekeeperIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH225GatekeeperIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GatekeeperIdentifier_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH225BandWidth;
HS_RESULT new_ASNH225BandWidth( void *pObject );
HS_RESULT delete_ASNH225BandWidth( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225BandWidth_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225BandWidth_MakeMold( void *pObject );
HS_RESULT ASNH225BandWidth_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225BandWidth_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH225CallReferenceValue;
HS_RESULT new_ASNH225CallReferenceValue( void *pObject );
HS_RESULT delete_ASNH225CallReferenceValue( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallReferenceValue_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CallReferenceValue_MakeMold( void *pObject );
HS_RESULT ASNH225CallReferenceValue_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallReferenceValue_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnDoubleString	inheritance;
} ASNH225EndpointIdentifier;
HS_RESULT new_ASNH225EndpointIdentifier( void *pObject );
HS_RESULT delete_ASNH225EndpointIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225EndpointIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225EndpointIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH225EndpointIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225EndpointIdentifier_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnObjectIdentifier	inheritance;
} ASNH225ProtocolIdentifier;
HS_RESULT new_ASNH225ProtocolIdentifier( void *pObject );
HS_RESULT delete_ASNH225ProtocolIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ProtocolIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ProtocolIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH225ProtocolIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ProtocolIdentifier_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH225TimeToLive;
HS_RESULT new_ASNH225TimeToLive( void *pObject );
HS_RESULT delete_ASNH225TimeToLive( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TimeToLive_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TimeToLive_MakeMold( void *pObject );
HS_RESULT ASNH225TimeToLive_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TimeToLive_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnOctetString	inheritance;
} ASNH225H248PackagesDescriptor;
HS_RESULT new_ASNH225H248PackagesDescriptor( void *pObject );
HS_RESULT delete_ASNH225H248PackagesDescriptor( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H248PackagesDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H248PackagesDescriptor_MakeMold( void *pObject );
HS_RESULT ASNH225H248PackagesDescriptor_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H248PackagesDescriptor_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnOctetString	inheritance;
} ASNH225H248SignalsDescriptor;
HS_RESULT new_ASNH225H248SignalsDescriptor( void *pObject );
HS_RESULT delete_ASNH225H248SignalsDescriptor( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H248SignalsDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H248SignalsDescriptor_MakeMold( void *pObject );
HS_RESULT ASNH225H248SignalsDescriptor_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H248SignalsDescriptor_Decode( void *pObject, AsnStream *pStrm );

#define ASNH225FeatureDescriptor          ASNH225GenericData
#define new_ASNH225FeatureDescriptor      new_ASNH225GenericData
#define delete_ASNH225FeatureDescriptor   delete_ASNH225GenericData
#define ASNH225FeatureDescriptor_MakeMold ASNH225GenericData_MakeMold
#define ASNH225FeatureDescriptor_Print    ASNH225GenericData_Print
#define ASNH225FeatureDescriptor_Encode   ASNH225GenericData_Encode
#define ASNH225FeatureDescriptor_Decode   ASNH225GenericData_Decode


#define e_ASNH225H323_UserInformation_user_dataOptionMapSize 0
#define e_ASNH225H323_UserInformation_user_dataOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_protocol_discriminator;
	AsnOctetString m_user_information;
	/*...,*/
} ASNH225H323_UserInformation_user_data;
HS_RESULT new_ASNH225H323_UserInformation_user_data( void *pObject );
HS_RESULT delete_ASNH225H323_UserInformation_user_data( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H323_UserInformation_user_data_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H323_UserInformation_user_data_MakeMold( void *pObject );
HS_RESULT ASNH225H323_UserInformation_user_data_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H323_UserInformation_user_data_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225TransportAddress_ipAddressOptionMapSize 0
#define e_ASNH225TransportAddress_ipAddressOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_ip;
	AsnInteger m_port;
} ASNH225TransportAddress_ipAddress;
HS_RESULT new_ASNH225TransportAddress_ipAddress( void *pObject );
HS_RESULT delete_ASNH225TransportAddress_ipAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TransportAddress_ipAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TransportAddress_ipAddress_MakeMold( void *pObject );
HS_RESULT ASNH225TransportAddress_ipAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TransportAddress_ipAddress_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225TransportAddress_ipSourceRoute_routingChoice_strict,
	e_ASNH225TransportAddress_ipSourceRoute_routingChoice_loose

} ASNH225TransportAddress_ipSourceRoute_routingChoice;


#define e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSize		2
#define e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSizeExt	2
typedef struct
{
	ASNH225TransportAddress_ipSourceRoute_routingChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225TransportAddress_ipSourceRoute_routing;
HS_RESULT new_ASNH225TransportAddress_ipSourceRoute_routing( void *pObject );
HS_RESULT delete_ASNH225TransportAddress_ipSourceRoute_routing( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225TransportAddress_ipSourceRoute_routing_SetChoice( void *pObject, ASNH225TransportAddress_ipSourceRoute_routingChoice pChoice );
HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_DeleteAlternation( void *pObject );
HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_MakeMold( void *pObject );
HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225TransportAddress_ipSourceRouteOptionMapSize 0
#define e_ASNH225TransportAddress_ipSourceRouteOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_ip;
	AsnInteger m_port;
	AsnSequenceOf m_route;
	ASNH225TransportAddress_ipSourceRoute_routing m_routing;
	/*...,*/
} ASNH225TransportAddress_ipSourceRoute;
HS_RESULT new_ASNH225TransportAddress_ipSourceRoute( void *pObject );
HS_RESULT delete_ASNH225TransportAddress_ipSourceRoute( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TransportAddress_ipSourceRoute_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TransportAddress_ipSourceRoute_MakeMold( void *pObject );
HS_RESULT ASNH225TransportAddress_ipSourceRoute_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TransportAddress_ipSourceRoute_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225TransportAddress_ipxAddressOptionMapSize 0
#define e_ASNH225TransportAddress_ipxAddressOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_node;
	AsnOctetString m_netnum;
	AsnOctetString m_port;
} ASNH225TransportAddress_ipxAddress;
HS_RESULT new_ASNH225TransportAddress_ipxAddress( void *pObject );
HS_RESULT delete_ASNH225TransportAddress_ipxAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TransportAddress_ipxAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TransportAddress_ipxAddress_MakeMold( void *pObject );
HS_RESULT ASNH225TransportAddress_ipxAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TransportAddress_ipxAddress_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225TransportAddress_ip6AddressOptionMapSize 0
#define e_ASNH225TransportAddress_ip6AddressOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_ip;
	AsnInteger m_port;
	/*...,*/
} ASNH225TransportAddress_ip6Address;
HS_RESULT new_ASNH225TransportAddress_ip6Address( void *pObject );
HS_RESULT delete_ASNH225TransportAddress_ip6Address( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TransportAddress_ip6Address_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TransportAddress_ip6Address_MakeMold( void *pObject );
HS_RESULT ASNH225TransportAddress_ip6Address_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TransportAddress_ip6Address_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225H221NonStandardOptionMapSize 0
#define e_ASNH225H221NonStandardOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_t35CountryCode;
	AsnInteger m_t35Extension;
	AsnInteger m_manufacturerCode;
	/*...,*/
} ASNH225H221NonStandard;
HS_RESULT new_ASNH225H221NonStandard( void *pObject );
HS_RESULT delete_ASNH225H221NonStandard( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H221NonStandard_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H221NonStandard_MakeMold( void *pObject );
HS_RESULT ASNH225H221NonStandard_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H221NonStandard_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225NonStandardIdentifierChoice_object,
	e_ASNH225NonStandardIdentifierChoice_h221NonStandard

} ASNH225NonStandardIdentifierChoice;


#define e_ASNH225NonStandardIdentifierChoiceSize		2
#define e_ASNH225NonStandardIdentifierChoiceSizeExt	2
typedef struct
{
	ASNH225NonStandardIdentifierChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225NonStandardIdentifier;
HS_RESULT new_ASNH225NonStandardIdentifier( void *pObject );
HS_RESULT delete_ASNH225NonStandardIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225NonStandardIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225NonStandardIdentifier_SetChoice( void *pObject, ASNH225NonStandardIdentifierChoice pChoice );
HS_RESULT ASNH225NonStandardIdentifier_DeleteAlternation( void *pObject );
HS_RESULT ASNH225NonStandardIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH225NonStandardIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225NonStandardIdentifier_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225NonStandardParameterOptionMapSize 0
#define e_ASNH225NonStandardParameterOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH225NonStandardIdentifier m_nonStandardIdentifier;
	AsnOctetString m_data;
} ASNH225NonStandardParameter;
HS_RESULT new_ASNH225NonStandardParameter( void *pObject );
HS_RESULT delete_ASNH225NonStandardParameter( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225NonStandardParameter_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225NonStandardParameter_MakeMold( void *pObject );
HS_RESULT ASNH225NonStandardParameter_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225NonStandardParameter_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225TransportAddressChoice_ipAddress,
	e_ASNH225TransportAddressChoice_ipSourceRoute,
	e_ASNH225TransportAddressChoice_ipxAddress,
	e_ASNH225TransportAddressChoice_ip6Address,
	e_ASNH225TransportAddressChoice_netBios,
	e_ASNH225TransportAddressChoice_nsap,
	e_ASNH225TransportAddressChoice_nonStandardAddress

} ASNH225TransportAddressChoice;


#define e_ASNH225TransportAddressChoiceSize		7
#define e_ASNH225TransportAddressChoiceSizeExt	7
typedef struct
{
	ASNH225TransportAddressChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225TransportAddress;
HS_RESULT new_ASNH225TransportAddress( void *pObject );
HS_RESULT delete_ASNH225TransportAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TransportAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225TransportAddress_SetChoice( void *pObject, ASNH225TransportAddressChoice pChoice );
HS_RESULT ASNH225TransportAddress_DeleteAlternation( void *pObject );
HS_RESULT ASNH225TransportAddress_MakeMold( void *pObject );
HS_RESULT ASNH225TransportAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TransportAddress_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225PublicTypeOfNumberChoice_unknown,
	e_ASNH225PublicTypeOfNumberChoice_internationalNumber,
	e_ASNH225PublicTypeOfNumberChoice_nationalNumber,
	e_ASNH225PublicTypeOfNumberChoice_networkSpecificNumber,
	e_ASNH225PublicTypeOfNumberChoice_subscriberNumber,
	e_ASNH225PublicTypeOfNumberChoice_abbreviatedNumber

} ASNH225PublicTypeOfNumberChoice;


#define e_ASNH225PublicTypeOfNumberChoiceSize		6
#define e_ASNH225PublicTypeOfNumberChoiceSizeExt	6
typedef struct
{
	ASNH225PublicTypeOfNumberChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225PublicTypeOfNumber;
HS_RESULT new_ASNH225PublicTypeOfNumber( void *pObject );
HS_RESULT delete_ASNH225PublicTypeOfNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225PublicTypeOfNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225PublicTypeOfNumber_SetChoice( void *pObject, ASNH225PublicTypeOfNumberChoice pChoice );
HS_RESULT ASNH225PublicTypeOfNumber_DeleteAlternation( void *pObject );
HS_RESULT ASNH225PublicTypeOfNumber_MakeMold( void *pObject );
HS_RESULT ASNH225PublicTypeOfNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225PublicTypeOfNumber_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225PublicPartyNumberOptionMapSize 0
#define e_ASNH225PublicPartyNumberOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH225PublicTypeOfNumber m_publicTypeOfNumber;
	ASNH225NumberDigits m_publicNumberDigits;
} ASNH225PublicPartyNumber;
HS_RESULT new_ASNH225PublicPartyNumber( void *pObject );
HS_RESULT delete_ASNH225PublicPartyNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225PublicPartyNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225PublicPartyNumber_MakeMold( void *pObject );
HS_RESULT ASNH225PublicPartyNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225PublicPartyNumber_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225PrivateTypeOfNumberChoice_unknown,
	e_ASNH225PrivateTypeOfNumberChoice_level2RegionalNumber,
	e_ASNH225PrivateTypeOfNumberChoice_level1RegionalNumber,
	e_ASNH225PrivateTypeOfNumberChoice_pISNSpecificNumber,
	e_ASNH225PrivateTypeOfNumberChoice_localNumber,
	e_ASNH225PrivateTypeOfNumberChoice_abbreviatedNumber

} ASNH225PrivateTypeOfNumberChoice;


#define e_ASNH225PrivateTypeOfNumberChoiceSize		6
#define e_ASNH225PrivateTypeOfNumberChoiceSizeExt	6
typedef struct
{
	ASNH225PrivateTypeOfNumberChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225PrivateTypeOfNumber;
HS_RESULT new_ASNH225PrivateTypeOfNumber( void *pObject );
HS_RESULT delete_ASNH225PrivateTypeOfNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225PrivateTypeOfNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225PrivateTypeOfNumber_SetChoice( void *pObject, ASNH225PrivateTypeOfNumberChoice pChoice );
HS_RESULT ASNH225PrivateTypeOfNumber_DeleteAlternation( void *pObject );
HS_RESULT ASNH225PrivateTypeOfNumber_MakeMold( void *pObject );
HS_RESULT ASNH225PrivateTypeOfNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225PrivateTypeOfNumber_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225PrivatePartyNumberOptionMapSize 0
#define e_ASNH225PrivatePartyNumberOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH225PrivateTypeOfNumber m_privateTypeOfNumber;
	ASNH225NumberDigits m_privateNumberDigits;
} ASNH225PrivatePartyNumber;
HS_RESULT new_ASNH225PrivatePartyNumber( void *pObject );
HS_RESULT delete_ASNH225PrivatePartyNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225PrivatePartyNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225PrivatePartyNumber_MakeMold( void *pObject );
HS_RESULT ASNH225PrivatePartyNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225PrivatePartyNumber_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225PartyNumberChoice_e164Number,
	e_ASNH225PartyNumberChoice_dataPartyNumber,
	e_ASNH225PartyNumberChoice_telexPartyNumber,
	e_ASNH225PartyNumberChoice_privateNumber,
	e_ASNH225PartyNumberChoice_nationalStandardPartyNumber

} ASNH225PartyNumberChoice;


#define e_ASNH225PartyNumberChoiceSize		5
#define e_ASNH225PartyNumberChoiceSizeExt	5
typedef struct
{
	ASNH225PartyNumberChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225PartyNumber;
HS_RESULT new_ASNH225PartyNumber( void *pObject );
HS_RESULT delete_ASNH225PartyNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225PartyNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225PartyNumber_SetChoice( void *pObject, ASNH225PartyNumberChoice pChoice );
HS_RESULT ASNH225PartyNumber_DeleteAlternation( void *pObject );
HS_RESULT ASNH225PartyNumber_MakeMold( void *pObject );
HS_RESULT ASNH225PartyNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225PartyNumber_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ANSI_41_UIM_system_idChoice_sid,
	e_ASNH225ANSI_41_UIM_system_idChoice_mid

} ASNH225ANSI_41_UIM_system_idChoice;


#define e_ASNH225ANSI_41_UIM_system_idChoiceSize		2
#define e_ASNH225ANSI_41_UIM_system_idChoiceSizeExt	2
typedef struct
{
	ASNH225ANSI_41_UIM_system_idChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225ANSI_41_UIM_system_id;
HS_RESULT new_ASNH225ANSI_41_UIM_system_id( void *pObject );
HS_RESULT delete_ASNH225ANSI_41_UIM_system_id( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ANSI_41_UIM_system_id_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225ANSI_41_UIM_system_id_SetChoice( void *pObject, ASNH225ANSI_41_UIM_system_idChoice pChoice );
HS_RESULT ASNH225ANSI_41_UIM_system_id_DeleteAlternation( void *pObject );
HS_RESULT ASNH225ANSI_41_UIM_system_id_MakeMold( void *pObject );
HS_RESULT ASNH225ANSI_41_UIM_system_id_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ANSI_41_UIM_system_id_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ANSI_41_UIMOptionMap_imsi,
	e_ASNH225ANSI_41_UIMOptionMap_min,
	e_ASNH225ANSI_41_UIMOptionMap_mdn,
	e_ASNH225ANSI_41_UIMOptionMap_msisdn,
	e_ASNH225ANSI_41_UIMOptionMap_esn,
	e_ASNH225ANSI_41_UIMOptionMap_mscid,
	e_ASNH225ANSI_41_UIMOptionMap_systemMyTypeCode,
	e_ASNH225ANSI_41_UIMOptionMap_systemAccessType,
	e_ASNH225ANSI_41_UIMOptionMap_qualificationInformationCode,
	e_ASNH225ANSI_41_UIMOptionMap_sesn,
	e_ASNH225ANSI_41_UIMOptionMap_soc

} ASNH225ANSI_41_UIMOptionMap;


#define e_ASNH225ANSI_41_UIMOptionMapSize 11
#define e_ASNH225ANSI_41_UIMOptionMapSizeExt 11
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225TBCD_STRING m_imsi;
	ASNH225TBCD_STRING m_min;
	ASNH225TBCD_STRING m_mdn;
	ASNH225TBCD_STRING m_msisdn;
	ASNH225TBCD_STRING m_esn;
	ASNH225TBCD_STRING m_mscid;
	ASNH225ANSI_41_UIM_system_id m_system_id;
	AsnOctetString m_systemMyTypeCode;
	AsnOctetString m_systemAccessType;
	AsnOctetString m_qualificationInformationCode;
	ASNH225TBCD_STRING m_sesn;
	ASNH225TBCD_STRING m_soc;
	/*...,*/
} ASNH225ANSI_41_UIM;
HS_RESULT new_ASNH225ANSI_41_UIM( void *pObject );
HS_RESULT delete_ASNH225ANSI_41_UIM( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ANSI_41_UIM_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ANSI_41_UIM_IncludeOptionField( void *pObject, ASNH225ANSI_41_UIMOptionMap pOptionMap );
BOOL	  ASNH225ANSI_41_UIM_IsIncludeOptionField( void *pObject, ASNH225ANSI_41_UIMOptionMap pOptionMap );
HS_RESULT ASNH225ANSI_41_UIM_MakeMold( void *pObject );
HS_RESULT ASNH225ANSI_41_UIM_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ANSI_41_UIM_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GSM_UIMOptionMap_imsi,
	e_ASNH225GSM_UIMOptionMap_tmsi,
	e_ASNH225GSM_UIMOptionMap_msisdn,
	e_ASNH225GSM_UIMOptionMap_imei,
	e_ASNH225GSM_UIMOptionMap_hplmn,
	e_ASNH225GSM_UIMOptionMap_vplmn

} ASNH225GSM_UIMOptionMap;


#define e_ASNH225GSM_UIMOptionMapSize 6
#define e_ASNH225GSM_UIMOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225TBCD_STRING m_imsi;
	AsnOctetString m_tmsi;
	ASNH225TBCD_STRING m_msisdn;
	ASNH225TBCD_STRING m_imei;
	ASNH225TBCD_STRING m_hplmn;
	ASNH225TBCD_STRING m_vplmn;
	/*...,*/
} ASNH225GSM_UIM;
HS_RESULT new_ASNH225GSM_UIM( void *pObject );
HS_RESULT delete_ASNH225GSM_UIM( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GSM_UIM_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GSM_UIM_IncludeOptionField( void *pObject, ASNH225GSM_UIMOptionMap pOptionMap );
BOOL	  ASNH225GSM_UIM_IsIncludeOptionField( void *pObject, ASNH225GSM_UIMOptionMap pOptionMap );
HS_RESULT ASNH225GSM_UIM_MakeMold( void *pObject );
HS_RESULT ASNH225GSM_UIM_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GSM_UIM_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225MobileUIMChoice_ansi_41_uim,
	e_ASNH225MobileUIMChoice_gsm_uim

} ASNH225MobileUIMChoice;


#define e_ASNH225MobileUIMChoiceSize		2
#define e_ASNH225MobileUIMChoiceSizeExt	2
typedef struct
{
	ASNH225MobileUIMChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225MobileUIM;
HS_RESULT new_ASNH225MobileUIM( void *pObject );
HS_RESULT delete_ASNH225MobileUIM( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225MobileUIM_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225MobileUIM_SetChoice( void *pObject, ASNH225MobileUIMChoice pChoice );
HS_RESULT ASNH225MobileUIM_DeleteAlternation( void *pObject );
HS_RESULT ASNH225MobileUIM_MakeMold( void *pObject );
HS_RESULT ASNH225MobileUIM_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225MobileUIM_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225AliasAddressChoice_dialedDigits,
	e_ASNH225AliasAddressChoice_h323_ID
,
	e_ASNH225AliasAddressChoice_url_ID,
	e_ASNH225AliasAddressChoice_transportID,
	e_ASNH225AliasAddressChoice_email_ID,
	e_ASNH225AliasAddressChoice_partyNumber,
	e_ASNH225AliasAddressChoice_mobileUIM
} ASNH225AliasAddressChoice;


#define e_ASNH225AliasAddressChoiceSize		2
#define e_ASNH225AliasAddressChoiceSizeExt	7
typedef struct
{
	ASNH225AliasAddressChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225AliasAddress;
HS_RESULT new_ASNH225AliasAddress( void *pObject );
HS_RESULT delete_ASNH225AliasAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AliasAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225AliasAddress_SetChoice( void *pObject, ASNH225AliasAddressChoice pChoice );
HS_RESULT ASNH225AliasAddress_DeleteAlternation( void *pObject );
HS_RESULT ASNH225AliasAddress_MakeMold( void *pObject );
HS_RESULT ASNH225AliasAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AliasAddress_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225VendorIdentifierOptionMap_productId,
	e_ASNH225VendorIdentifierOptionMap_versionId

} ASNH225VendorIdentifierOptionMap;


#define e_ASNH225VendorIdentifierOptionMapSize 2
#define e_ASNH225VendorIdentifierOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225H221NonStandard m_vendor;
	AsnOctetString m_productId;
	AsnOctetString m_versionId;
	/*...,*/
} ASNH225VendorIdentifier;
HS_RESULT new_ASNH225VendorIdentifier( void *pObject );
HS_RESULT delete_ASNH225VendorIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225VendorIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225VendorIdentifier_IncludeOptionField( void *pObject, ASNH225VendorIdentifierOptionMap pOptionMap );
BOOL	  ASNH225VendorIdentifier_IsIncludeOptionField( void *pObject, ASNH225VendorIdentifierOptionMap pOptionMap );
HS_RESULT ASNH225VendorIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH225VendorIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225VendorIdentifier_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GatekeeperInfoOptionMap_nonStandardData

} ASNH225GatekeeperInfoOptionMap;


#define e_ASNH225GatekeeperInfoOptionMapSize 1
#define e_ASNH225GatekeeperInfoOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
} ASNH225GatekeeperInfo;
HS_RESULT new_ASNH225GatekeeperInfo( void *pObject );
HS_RESULT delete_ASNH225GatekeeperInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GatekeeperInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GatekeeperInfo_IncludeOptionField( void *pObject, ASNH225GatekeeperInfoOptionMap pOptionMap );
BOOL	  ASNH225GatekeeperInfo_IsIncludeOptionField( void *pObject, ASNH225GatekeeperInfoOptionMap pOptionMap );
HS_RESULT ASNH225GatekeeperInfo_MakeMold( void *pObject );
HS_RESULT ASNH225GatekeeperInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GatekeeperInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225DataRateOptionMap_nonStandardData,
	e_ASNH225DataRateOptionMap_channelMultiplier

} ASNH225DataRateOptionMap;


#define e_ASNH225DataRateOptionMapSize 2
#define e_ASNH225DataRateOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225BandWidth m_channelRate;
	AsnInteger m_channelMultiplier;
	/*...,*/
} ASNH225DataRate;
HS_RESULT new_ASNH225DataRate( void *pObject );
HS_RESULT delete_ASNH225DataRate( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225DataRate_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225DataRate_IncludeOptionField( void *pObject, ASNH225DataRateOptionMap pOptionMap );
BOOL	  ASNH225DataRate_IsIncludeOptionField( void *pObject, ASNH225DataRateOptionMap pOptionMap );
HS_RESULT ASNH225DataRate_MakeMold( void *pObject );
HS_RESULT ASNH225DataRate_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225DataRate_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225SupportedPrefixOptionMap_nonStandardData

} ASNH225SupportedPrefixOptionMap;


#define e_ASNH225SupportedPrefixOptionMapSize 1
#define e_ASNH225SupportedPrefixOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225AliasAddress m_prefix;
	/*...,*/
} ASNH225SupportedPrefix;
HS_RESULT new_ASNH225SupportedPrefix( void *pObject );
HS_RESULT delete_ASNH225SupportedPrefix( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225SupportedPrefix_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225SupportedPrefix_IncludeOptionField( void *pObject, ASNH225SupportedPrefixOptionMap pOptionMap );
BOOL	  ASNH225SupportedPrefix_IsIncludeOptionField( void *pObject, ASNH225SupportedPrefixOptionMap pOptionMap );
HS_RESULT ASNH225SupportedPrefix_MakeMold( void *pObject );
HS_RESULT ASNH225SupportedPrefix_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225SupportedPrefix_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H310CapsOptionMap_nonStandardData
,
	e_ASNH225H310CapsOptionMap_dataRatesSupported,
	e_ASNH225H310CapsOptionMap_supportedPrefixes
} ASNH225H310CapsOptionMap;


#define e_ASNH225H310CapsOptionMapSize 1
#define e_ASNH225H310CapsOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
} ASNH225H310Caps;
HS_RESULT new_ASNH225H310Caps( void *pObject );
HS_RESULT delete_ASNH225H310Caps( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H310Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H310Caps_IncludeOptionField( void *pObject, ASNH225H310CapsOptionMap pOptionMap );
BOOL	  ASNH225H310Caps_IsIncludeOptionField( void *pObject, ASNH225H310CapsOptionMap pOptionMap );
HS_RESULT ASNH225H310Caps_MakeMold( void *pObject );
HS_RESULT ASNH225H310Caps_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H310Caps_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H320CapsOptionMap_nonStandardData
,
	e_ASNH225H320CapsOptionMap_dataRatesSupported,
	e_ASNH225H320CapsOptionMap_supportedPrefixes
} ASNH225H320CapsOptionMap;


#define e_ASNH225H320CapsOptionMapSize 1
#define e_ASNH225H320CapsOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
} ASNH225H320Caps;
HS_RESULT new_ASNH225H320Caps( void *pObject );
HS_RESULT delete_ASNH225H320Caps( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H320Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H320Caps_IncludeOptionField( void *pObject, ASNH225H320CapsOptionMap pOptionMap );
BOOL	  ASNH225H320Caps_IsIncludeOptionField( void *pObject, ASNH225H320CapsOptionMap pOptionMap );
HS_RESULT ASNH225H320Caps_MakeMold( void *pObject );
HS_RESULT ASNH225H320Caps_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H320Caps_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H321CapsOptionMap_nonStandardData
,
	e_ASNH225H321CapsOptionMap_dataRatesSupported,
	e_ASNH225H321CapsOptionMap_supportedPrefixes
} ASNH225H321CapsOptionMap;


#define e_ASNH225H321CapsOptionMapSize 1
#define e_ASNH225H321CapsOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
} ASNH225H321Caps;
HS_RESULT new_ASNH225H321Caps( void *pObject );
HS_RESULT delete_ASNH225H321Caps( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H321Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H321Caps_IncludeOptionField( void *pObject, ASNH225H321CapsOptionMap pOptionMap );
BOOL	  ASNH225H321Caps_IsIncludeOptionField( void *pObject, ASNH225H321CapsOptionMap pOptionMap );
HS_RESULT ASNH225H321Caps_MakeMold( void *pObject );
HS_RESULT ASNH225H321Caps_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H321Caps_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H322CapsOptionMap_nonStandardData
,
	e_ASNH225H322CapsOptionMap_dataRatesSupported,
	e_ASNH225H322CapsOptionMap_supportedPrefixes
} ASNH225H322CapsOptionMap;


#define e_ASNH225H322CapsOptionMapSize 1
#define e_ASNH225H322CapsOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
} ASNH225H322Caps;
HS_RESULT new_ASNH225H322Caps( void *pObject );
HS_RESULT delete_ASNH225H322Caps( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H322Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H322Caps_IncludeOptionField( void *pObject, ASNH225H322CapsOptionMap pOptionMap );
BOOL	  ASNH225H322Caps_IsIncludeOptionField( void *pObject, ASNH225H322CapsOptionMap pOptionMap );
HS_RESULT ASNH225H322Caps_MakeMold( void *pObject );
HS_RESULT ASNH225H322Caps_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H322Caps_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H323CapsOptionMap_nonStandardData
,
	e_ASNH225H323CapsOptionMap_dataRatesSupported,
	e_ASNH225H323CapsOptionMap_supportedPrefixes
} ASNH225H323CapsOptionMap;


#define e_ASNH225H323CapsOptionMapSize 1
#define e_ASNH225H323CapsOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
} ASNH225H323Caps;
HS_RESULT new_ASNH225H323Caps( void *pObject );
HS_RESULT delete_ASNH225H323Caps( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H323Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H323Caps_IncludeOptionField( void *pObject, ASNH225H323CapsOptionMap pOptionMap );
BOOL	  ASNH225H323Caps_IsIncludeOptionField( void *pObject, ASNH225H323CapsOptionMap pOptionMap );
HS_RESULT ASNH225H323Caps_MakeMold( void *pObject );
HS_RESULT ASNH225H323Caps_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H323Caps_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H324CapsOptionMap_nonStandardData
,
	e_ASNH225H324CapsOptionMap_dataRatesSupported,
	e_ASNH225H324CapsOptionMap_supportedPrefixes
} ASNH225H324CapsOptionMap;


#define e_ASNH225H324CapsOptionMapSize 1
#define e_ASNH225H324CapsOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
} ASNH225H324Caps;
HS_RESULT new_ASNH225H324Caps( void *pObject );
HS_RESULT delete_ASNH225H324Caps( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H324Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H324Caps_IncludeOptionField( void *pObject, ASNH225H324CapsOptionMap pOptionMap );
BOOL	  ASNH225H324Caps_IsIncludeOptionField( void *pObject, ASNH225H324CapsOptionMap pOptionMap );
HS_RESULT ASNH225H324Caps_MakeMold( void *pObject );
HS_RESULT ASNH225H324Caps_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H324Caps_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225VoiceCapsOptionMap_nonStandardData
,
	e_ASNH225VoiceCapsOptionMap_dataRatesSupported,
	e_ASNH225VoiceCapsOptionMap_supportedPrefixes
} ASNH225VoiceCapsOptionMap;


#define e_ASNH225VoiceCapsOptionMapSize 1
#define e_ASNH225VoiceCapsOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
} ASNH225VoiceCaps;
HS_RESULT new_ASNH225VoiceCaps( void *pObject );
HS_RESULT delete_ASNH225VoiceCaps( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225VoiceCaps_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225VoiceCaps_IncludeOptionField( void *pObject, ASNH225VoiceCapsOptionMap pOptionMap );
BOOL	  ASNH225VoiceCaps_IsIncludeOptionField( void *pObject, ASNH225VoiceCapsOptionMap pOptionMap );
HS_RESULT ASNH225VoiceCaps_MakeMold( void *pObject );
HS_RESULT ASNH225VoiceCaps_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225VoiceCaps_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225T120OnlyCapsOptionMap_nonStandardData
,
	e_ASNH225T120OnlyCapsOptionMap_dataRatesSupported,
	e_ASNH225T120OnlyCapsOptionMap_supportedPrefixes
} ASNH225T120OnlyCapsOptionMap;


#define e_ASNH225T120OnlyCapsOptionMapSize 1
#define e_ASNH225T120OnlyCapsOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
} ASNH225T120OnlyCaps;
HS_RESULT new_ASNH225T120OnlyCaps( void *pObject );
HS_RESULT delete_ASNH225T120OnlyCaps( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225T120OnlyCaps_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225T120OnlyCaps_IncludeOptionField( void *pObject, ASNH225T120OnlyCapsOptionMap pOptionMap );
BOOL	  ASNH225T120OnlyCaps_IsIncludeOptionField( void *pObject, ASNH225T120OnlyCapsOptionMap pOptionMap );
HS_RESULT ASNH225T120OnlyCaps_MakeMold( void *pObject );
HS_RESULT ASNH225T120OnlyCaps_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225T120OnlyCaps_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225NonStandardProtocolOptionMap_nonStandardData,
	e_ASNH225NonStandardProtocolOptionMap_dataRatesSupported

} ASNH225NonStandardProtocolOptionMap;


#define e_ASNH225NonStandardProtocolOptionMapSize 2
#define e_ASNH225NonStandardProtocolOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
	/*...,*/
} ASNH225NonStandardProtocol;
HS_RESULT new_ASNH225NonStandardProtocol( void *pObject );
HS_RESULT delete_ASNH225NonStandardProtocol( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225NonStandardProtocol_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225NonStandardProtocol_IncludeOptionField( void *pObject, ASNH225NonStandardProtocolOptionMap pOptionMap );
BOOL	  ASNH225NonStandardProtocol_IsIncludeOptionField( void *pObject, ASNH225NonStandardProtocolOptionMap pOptionMap );
HS_RESULT ASNH225NonStandardProtocol_MakeMold( void *pObject );
HS_RESULT ASNH225NonStandardProtocol_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225NonStandardProtocol_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225T38FaxAnnexbOnlyCapsOptionMap_nonStandardData,
	e_ASNH225T38FaxAnnexbOnlyCapsOptionMap_dataRatesSupported

} ASNH225T38FaxAnnexbOnlyCapsOptionMap;


#define e_ASNH225T38FaxAnnexbOnlyCapsOptionMapSize 2
#define e_ASNH225T38FaxAnnexbOnlyCapsOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	AsnSequenceOf m_dataRatesSupported;
	AsnSequenceOf m_supportedPrefixes;
	ASNH225DataProtocolCapability m_t38FaxProtocol;
	ASNH225T38FaxProfile m_t38FaxProfile;
	/*...,*/
} ASNH225T38FaxAnnexbOnlyCaps;
HS_RESULT new_ASNH225T38FaxAnnexbOnlyCaps( void *pObject );
HS_RESULT delete_ASNH225T38FaxAnnexbOnlyCaps( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_IncludeOptionField( void *pObject, ASNH225T38FaxAnnexbOnlyCapsOptionMap pOptionMap );
BOOL	  ASNH225T38FaxAnnexbOnlyCaps_IsIncludeOptionField( void *pObject, ASNH225T38FaxAnnexbOnlyCapsOptionMap pOptionMap );
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_MakeMold( void *pObject );
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225SupportedProtocolsChoice_nonStandardData,
	e_ASNH225SupportedProtocolsChoice_h310,
	e_ASNH225SupportedProtocolsChoice_h320,
	e_ASNH225SupportedProtocolsChoice_h321,
	e_ASNH225SupportedProtocolsChoice_h322,
	e_ASNH225SupportedProtocolsChoice_h323,
	e_ASNH225SupportedProtocolsChoice_h324,
	e_ASNH225SupportedProtocolsChoice_voice,
	e_ASNH225SupportedProtocolsChoice_t120_only
,
	e_ASNH225SupportedProtocolsChoice_nonStandardProtocol,
	e_ASNH225SupportedProtocolsChoice_t38FaxAnnexbOnly
} ASNH225SupportedProtocolsChoice;


#define e_ASNH225SupportedProtocolsChoiceSize		9
#define e_ASNH225SupportedProtocolsChoiceSizeExt	11
typedef struct
{
	ASNH225SupportedProtocolsChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225SupportedProtocols;
HS_RESULT new_ASNH225SupportedProtocols( void *pObject );
HS_RESULT delete_ASNH225SupportedProtocols( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225SupportedProtocols_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225SupportedProtocols_SetChoice( void *pObject, ASNH225SupportedProtocolsChoice pChoice );
HS_RESULT ASNH225SupportedProtocols_DeleteAlternation( void *pObject );
HS_RESULT ASNH225SupportedProtocols_MakeMold( void *pObject );
HS_RESULT ASNH225SupportedProtocols_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225SupportedProtocols_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GatewayInfoOptionMap_protocol,
	e_ASNH225GatewayInfoOptionMap_nonStandardData

} ASNH225GatewayInfoOptionMap;


#define e_ASNH225GatewayInfoOptionMapSize 2
#define e_ASNH225GatewayInfoOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_protocol;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
} ASNH225GatewayInfo;
HS_RESULT new_ASNH225GatewayInfo( void *pObject );
HS_RESULT delete_ASNH225GatewayInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GatewayInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GatewayInfo_IncludeOptionField( void *pObject, ASNH225GatewayInfoOptionMap pOptionMap );
BOOL	  ASNH225GatewayInfo_IsIncludeOptionField( void *pObject, ASNH225GatewayInfoOptionMap pOptionMap );
HS_RESULT ASNH225GatewayInfo_MakeMold( void *pObject );
HS_RESULT ASNH225GatewayInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GatewayInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225McuInfoOptionMap_nonStandardData
,
	e_ASNH225McuInfoOptionMap_protocol
} ASNH225McuInfoOptionMap;


#define e_ASNH225McuInfoOptionMapSize 1
#define e_ASNH225McuInfoOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_protocol;
} ASNH225McuInfo;
HS_RESULT new_ASNH225McuInfo( void *pObject );
HS_RESULT delete_ASNH225McuInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225McuInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225McuInfo_IncludeOptionField( void *pObject, ASNH225McuInfoOptionMap pOptionMap );
BOOL	  ASNH225McuInfo_IsIncludeOptionField( void *pObject, ASNH225McuInfoOptionMap pOptionMap );
HS_RESULT ASNH225McuInfo_MakeMold( void *pObject );
HS_RESULT ASNH225McuInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225McuInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225TerminalInfoOptionMap_nonStandardData

} ASNH225TerminalInfoOptionMap;


#define e_ASNH225TerminalInfoOptionMapSize 1
#define e_ASNH225TerminalInfoOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
} ASNH225TerminalInfo;
HS_RESULT new_ASNH225TerminalInfo( void *pObject );
HS_RESULT delete_ASNH225TerminalInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TerminalInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TerminalInfo_IncludeOptionField( void *pObject, ASNH225TerminalInfoOptionMap pOptionMap );
BOOL	  ASNH225TerminalInfo_IsIncludeOptionField( void *pObject, ASNH225TerminalInfoOptionMap pOptionMap );
HS_RESULT ASNH225TerminalInfo_MakeMold( void *pObject );
HS_RESULT ASNH225TerminalInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TerminalInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225TunnelledProtocolAlternateIdentifierOptionMap_protocolVariant

} ASNH225TunnelledProtocolAlternateIdentifierOptionMap;


#define e_ASNH225TunnelledProtocolAlternateIdentifierOptionMapSize 1
#define e_ASNH225TunnelledProtocolAlternateIdentifierOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSingleString m_protocolType;
	AsnSingleString m_protocolVariant;
	/*...,*/
} ASNH225TunnelledProtocolAlternateIdentifier;
HS_RESULT new_ASNH225TunnelledProtocolAlternateIdentifier( void *pObject );
HS_RESULT delete_ASNH225TunnelledProtocolAlternateIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_IncludeOptionField( void *pObject, ASNH225TunnelledProtocolAlternateIdentifierOptionMap pOptionMap );
BOOL	  ASNH225TunnelledProtocolAlternateIdentifier_IsIncludeOptionField( void *pObject, ASNH225TunnelledProtocolAlternateIdentifierOptionMap pOptionMap );
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolObjectID,
	e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolAlternateID

} ASNH225TunnelledProtocol_idChoice;


#define e_ASNH225TunnelledProtocol_idChoiceSize		2
#define e_ASNH225TunnelledProtocol_idChoiceSizeExt	2
typedef struct
{
	ASNH225TunnelledProtocol_idChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225TunnelledProtocol_id;
HS_RESULT new_ASNH225TunnelledProtocol_id( void *pObject );
HS_RESULT delete_ASNH225TunnelledProtocol_id( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TunnelledProtocol_id_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225TunnelledProtocol_id_SetChoice( void *pObject, ASNH225TunnelledProtocol_idChoice pChoice );
HS_RESULT ASNH225TunnelledProtocol_id_DeleteAlternation( void *pObject );
HS_RESULT ASNH225TunnelledProtocol_id_MakeMold( void *pObject );
HS_RESULT ASNH225TunnelledProtocol_id_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TunnelledProtocol_id_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225TunnelledProtocolOptionMap_subIdentifier

} ASNH225TunnelledProtocolOptionMap;


#define e_ASNH225TunnelledProtocolOptionMapSize 1
#define e_ASNH225TunnelledProtocolOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225TunnelledProtocol_id m_id;
	AsnSingleString m_subIdentifier;
	/*...,*/
} ASNH225TunnelledProtocol;
HS_RESULT new_ASNH225TunnelledProtocol( void *pObject );
HS_RESULT delete_ASNH225TunnelledProtocol( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TunnelledProtocol_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TunnelledProtocol_IncludeOptionField( void *pObject, ASNH225TunnelledProtocolOptionMap pOptionMap );
BOOL	  ASNH225TunnelledProtocol_IsIncludeOptionField( void *pObject, ASNH225TunnelledProtocolOptionMap pOptionMap );
HS_RESULT ASNH225TunnelledProtocol_MakeMold( void *pObject );
HS_RESULT ASNH225TunnelledProtocol_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TunnelledProtocol_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225EndpointTypeOptionMap_nonStandardData,
	e_ASNH225EndpointTypeOptionMap_vendor,
	e_ASNH225EndpointTypeOptionMap_gatekeeper,
	e_ASNH225EndpointTypeOptionMap_gateway,
	e_ASNH225EndpointTypeOptionMap_mcu,
	e_ASNH225EndpointTypeOptionMap_terminal
,
	e_ASNH225EndpointTypeOptionMap_set,
	e_ASNH225EndpointTypeOptionMap_supportedTunnelledProtocols
} ASNH225EndpointTypeOptionMap;


#define e_ASNH225EndpointTypeOptionMapSize 6
#define e_ASNH225EndpointTypeOptionMapSizeExt 8
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225VendorIdentifier m_vendor;
	ASNH225GatekeeperInfo m_gatekeeper;
	ASNH225GatewayInfo m_gateway;
	ASNH225McuInfo m_mcu;
	ASNH225TerminalInfo m_terminal;
	AsnBoolean m_mc;
	AsnBoolean m_undefinedNode;
	/*...,*/
	AsnBitString m_set;
	AsnSequenceOf m_supportedTunnelledProtocols;
} ASNH225EndpointType;
HS_RESULT new_ASNH225EndpointType( void *pObject );
HS_RESULT delete_ASNH225EndpointType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225EndpointType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225EndpointType_IncludeOptionField( void *pObject, ASNH225EndpointTypeOptionMap pOptionMap );
BOOL	  ASNH225EndpointType_IsIncludeOptionField( void *pObject, ASNH225EndpointTypeOptionMap pOptionMap );
HS_RESULT ASNH225EndpointType_MakeMold( void *pObject );
HS_RESULT ASNH225EndpointType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225EndpointType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225Setup_UUIE_conferenceGoalChoice_create,
	e_ASNH225Setup_UUIE_conferenceGoalChoice_join,
	e_ASNH225Setup_UUIE_conferenceGoalChoice_invite
,
	e_ASNH225Setup_UUIE_conferenceGoalChoice_capability_negotiation,
	e_ASNH225Setup_UUIE_conferenceGoalChoice_callIndependentSupplementaryService
} ASNH225Setup_UUIE_conferenceGoalChoice;


#define e_ASNH225Setup_UUIE_conferenceGoalChoiceSize		3
#define e_ASNH225Setup_UUIE_conferenceGoalChoiceSizeExt	5
typedef struct
{
	ASNH225Setup_UUIE_conferenceGoalChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225Setup_UUIE_conferenceGoal;
HS_RESULT new_ASNH225Setup_UUIE_conferenceGoal( void *pObject );
HS_RESULT delete_ASNH225Setup_UUIE_conferenceGoal( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Setup_UUIE_conferenceGoal_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225Setup_UUIE_conferenceGoal_SetChoice( void *pObject, ASNH225Setup_UUIE_conferenceGoalChoice pChoice );
HS_RESULT ASNH225Setup_UUIE_conferenceGoal_DeleteAlternation( void *pObject );
HS_RESULT ASNH225Setup_UUIE_conferenceGoal_MakeMold( void *pObject );
HS_RESULT ASNH225Setup_UUIE_conferenceGoal_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Setup_UUIE_conferenceGoal_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225Q954DetailsOptionMapSize 0
#define e_ASNH225Q954DetailsOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_conferenceCalling;
	AsnBoolean m_threePartyService;
	/*...,*/
} ASNH225Q954Details;
HS_RESULT new_ASNH225Q954Details( void *pObject );
HS_RESULT delete_ASNH225Q954Details( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Q954Details_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Q954Details_MakeMold( void *pObject );
HS_RESULT ASNH225Q954Details_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Q954Details_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225QseriesOptionsOptionMapSize 0
#define e_ASNH225QseriesOptionsOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_q932Full;
	AsnBoolean m_q951Full;
	AsnBoolean m_q952Full;
	AsnBoolean m_q953Full;
	AsnBoolean m_q955Full;
	AsnBoolean m_q956Full;
	AsnBoolean m_q957Full;
	ASNH225Q954Details m_q954Info;
	/*...,*/
} ASNH225QseriesOptions;
HS_RESULT new_ASNH225QseriesOptions( void *pObject );
HS_RESULT delete_ASNH225QseriesOptions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225QseriesOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225QseriesOptions_MakeMold( void *pObject );
HS_RESULT ASNH225QseriesOptions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225QseriesOptions_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallTypeChoice_pointToPoint,
	e_ASNH225CallTypeChoice_oneToN,
	e_ASNH225CallTypeChoice_nToOne,
	e_ASNH225CallTypeChoice_nToN

} ASNH225CallTypeChoice;


#define e_ASNH225CallTypeChoiceSize		4
#define e_ASNH225CallTypeChoiceSizeExt	4
typedef struct
{
	ASNH225CallTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225CallType;
HS_RESULT new_ASNH225CallType( void *pObject );
HS_RESULT delete_ASNH225CallType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225CallType_SetChoice( void *pObject, ASNH225CallTypeChoice pChoice );
HS_RESULT ASNH225CallType_DeleteAlternation( void *pObject );
HS_RESULT ASNH225CallType_MakeMold( void *pObject );
HS_RESULT ASNH225CallType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallType_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225CallIdentifierOptionMapSize 0
#define e_ASNH225CallIdentifierOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH225GloballyUniqueID m_guid;
	/*...,*/
} ASNH225CallIdentifier;
HS_RESULT new_ASNH225CallIdentifier( void *pObject );
HS_RESULT delete_ASNH225CallIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CallIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH225CallIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallIdentifier_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225SecurityServiceModeChoice_nonStandard,
	e_ASNH225SecurityServiceModeChoice_none,
	e_ASNH225SecurityServiceModeChoice_default

} ASNH225SecurityServiceModeChoice;


#define e_ASNH225SecurityServiceModeChoiceSize		3
#define e_ASNH225SecurityServiceModeChoiceSizeExt	3
typedef struct
{
	ASNH225SecurityServiceModeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225SecurityServiceMode;
HS_RESULT new_ASNH225SecurityServiceMode( void *pObject );
HS_RESULT delete_ASNH225SecurityServiceMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225SecurityServiceMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225SecurityServiceMode_SetChoice( void *pObject, ASNH225SecurityServiceModeChoice pChoice );
HS_RESULT ASNH225SecurityServiceMode_DeleteAlternation( void *pObject );
HS_RESULT ASNH225SecurityServiceMode_MakeMold( void *pObject );
HS_RESULT ASNH225SecurityServiceMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225SecurityServiceMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225SecurityCapabilitiesOptionMap_nonStandard

} ASNH225SecurityCapabilitiesOptionMap;


#define e_ASNH225SecurityCapabilitiesOptionMapSize 1
#define e_ASNH225SecurityCapabilitiesOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandard;
	ASNH225SecurityServiceMode m_encryption;
	ASNH225SecurityServiceMode m_authenticaton;
	ASNH225SecurityServiceMode m_integrity;
	/*...,*/
} ASNH225SecurityCapabilities;
HS_RESULT new_ASNH225SecurityCapabilities( void *pObject );
HS_RESULT delete_ASNH225SecurityCapabilities( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225SecurityCapabilities_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225SecurityCapabilities_IncludeOptionField( void *pObject, ASNH225SecurityCapabilitiesOptionMap pOptionMap );
BOOL	  ASNH225SecurityCapabilities_IsIncludeOptionField( void *pObject, ASNH225SecurityCapabilitiesOptionMap pOptionMap );
HS_RESULT ASNH225SecurityCapabilities_MakeMold( void *pObject );
HS_RESULT ASNH225SecurityCapabilities_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225SecurityCapabilities_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H245SecurityChoice_nonStandard,
	e_ASNH225H245SecurityChoice_noSecurity,
	e_ASNH225H245SecurityChoice_tls,
	e_ASNH225H245SecurityChoice_ipsec

} ASNH225H245SecurityChoice;


#define e_ASNH225H245SecurityChoiceSize		4
#define e_ASNH225H245SecurityChoiceSizeExt	4
typedef struct
{
	ASNH225H245SecurityChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225H245Security;
HS_RESULT new_ASNH225H245Security( void *pObject );
HS_RESULT delete_ASNH225H245Security( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H245Security_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225H245Security_SetChoice( void *pObject, ASNH225H245SecurityChoice pChoice );
HS_RESULT ASNH225H245Security_DeleteAlternation( void *pObject );
HS_RESULT ASNH225H245Security_MakeMold( void *pObject );
HS_RESULT ASNH225H245Security_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H245Security_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ScnConnectionTypeChoice_unknown,
	e_ASNH225ScnConnectionTypeChoice_bChannel,
	e_ASNH225ScnConnectionTypeChoice_hybrid2x64,
	e_ASNH225ScnConnectionTypeChoice_hybrid384,
	e_ASNH225ScnConnectionTypeChoice_hybrid1536,
	e_ASNH225ScnConnectionTypeChoice_hybrid1920,
	e_ASNH225ScnConnectionTypeChoice_multirate

} ASNH225ScnConnectionTypeChoice;


#define e_ASNH225ScnConnectionTypeChoiceSize		7
#define e_ASNH225ScnConnectionTypeChoiceSizeExt	7
typedef struct
{
	ASNH225ScnConnectionTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225ScnConnectionType;
HS_RESULT new_ASNH225ScnConnectionType( void *pObject );
HS_RESULT delete_ASNH225ScnConnectionType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ScnConnectionType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225ScnConnectionType_SetChoice( void *pObject, ASNH225ScnConnectionTypeChoice pChoice );
HS_RESULT ASNH225ScnConnectionType_DeleteAlternation( void *pObject );
HS_RESULT ASNH225ScnConnectionType_MakeMold( void *pObject );
HS_RESULT ASNH225ScnConnectionType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ScnConnectionType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ScnConnectionAggregationChoice_auto,
	e_ASNH225ScnConnectionAggregationChoice_none,
	e_ASNH225ScnConnectionAggregationChoice_h221,
	e_ASNH225ScnConnectionAggregationChoice_bonded_mode1,
	e_ASNH225ScnConnectionAggregationChoice_bonded_mode2,
	e_ASNH225ScnConnectionAggregationChoice_bonded_mode3

} ASNH225ScnConnectionAggregationChoice;


#define e_ASNH225ScnConnectionAggregationChoiceSize		6
#define e_ASNH225ScnConnectionAggregationChoiceSizeExt	6
typedef struct
{
	ASNH225ScnConnectionAggregationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225ScnConnectionAggregation;
HS_RESULT new_ASNH225ScnConnectionAggregation( void *pObject );
HS_RESULT delete_ASNH225ScnConnectionAggregation( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ScnConnectionAggregation_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225ScnConnectionAggregation_SetChoice( void *pObject, ASNH225ScnConnectionAggregationChoice pChoice );
HS_RESULT ASNH225ScnConnectionAggregation_DeleteAlternation( void *pObject );
HS_RESULT ASNH225ScnConnectionAggregation_MakeMold( void *pObject );
HS_RESULT ASNH225ScnConnectionAggregation_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ScnConnectionAggregation_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225Setup_UUIE_connectionParametersOptionMapSize 0
#define e_ASNH225Setup_UUIE_connectionParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH225ScnConnectionType m_connectionType;
	AsnInteger m_numberOfScnConnections;
	ASNH225ScnConnectionAggregation m_connectionAggregation;
	/*...,*/
} ASNH225Setup_UUIE_connectionParameters;
HS_RESULT new_ASNH225Setup_UUIE_connectionParameters( void *pObject );
HS_RESULT delete_ASNH225Setup_UUIE_connectionParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Setup_UUIE_connectionParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Setup_UUIE_connectionParameters_MakeMold( void *pObject );
HS_RESULT ASNH225Setup_UUIE_connectionParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Setup_UUIE_connectionParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225PresentationIndicatorChoice_presentationAllowed,
	e_ASNH225PresentationIndicatorChoice_presentationRestricted,
	e_ASNH225PresentationIndicatorChoice_addressNotAvailable

} ASNH225PresentationIndicatorChoice;


#define e_ASNH225PresentationIndicatorChoiceSize		3
#define e_ASNH225PresentationIndicatorChoiceSizeExt	3
typedef struct
{
	ASNH225PresentationIndicatorChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225PresentationIndicator;
HS_RESULT new_ASNH225PresentationIndicator( void *pObject );
HS_RESULT delete_ASNH225PresentationIndicator( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225PresentationIndicator_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225PresentationIndicator_SetChoice( void *pObject, ASNH225PresentationIndicatorChoice pChoice );
HS_RESULT ASNH225PresentationIndicator_DeleteAlternation( void *pObject );
HS_RESULT ASNH225PresentationIndicator_MakeMold( void *pObject );
HS_RESULT ASNH225PresentationIndicator_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225PresentationIndicator_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallCreditServiceControl_billingModeChoice_credit,
	e_ASNH225CallCreditServiceControl_billingModeChoice_debit

} ASNH225CallCreditServiceControl_billingModeChoice;


#define e_ASNH225CallCreditServiceControl_billingModeChoiceSize		2
#define e_ASNH225CallCreditServiceControl_billingModeChoiceSizeExt	2
typedef struct
{
	ASNH225CallCreditServiceControl_billingModeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225CallCreditServiceControl_billingMode;
HS_RESULT new_ASNH225CallCreditServiceControl_billingMode( void *pObject );
HS_RESULT delete_ASNH225CallCreditServiceControl_billingMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallCreditServiceControl_billingMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225CallCreditServiceControl_billingMode_SetChoice( void *pObject, ASNH225CallCreditServiceControl_billingModeChoice pChoice );
HS_RESULT ASNH225CallCreditServiceControl_billingMode_DeleteAlternation( void *pObject );
HS_RESULT ASNH225CallCreditServiceControl_billingMode_MakeMold( void *pObject );
HS_RESULT ASNH225CallCreditServiceControl_billingMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallCreditServiceControl_billingMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallCreditServiceControl_callStartingPointChoice_alerting,
	e_ASNH225CallCreditServiceControl_callStartingPointChoice_connect

} ASNH225CallCreditServiceControl_callStartingPointChoice;


#define e_ASNH225CallCreditServiceControl_callStartingPointChoiceSize		2
#define e_ASNH225CallCreditServiceControl_callStartingPointChoiceSizeExt	2
typedef struct
{
	ASNH225CallCreditServiceControl_callStartingPointChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225CallCreditServiceControl_callStartingPoint;
HS_RESULT new_ASNH225CallCreditServiceControl_callStartingPoint( void *pObject );
HS_RESULT delete_ASNH225CallCreditServiceControl_callStartingPoint( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225CallCreditServiceControl_callStartingPoint_SetChoice( void *pObject, ASNH225CallCreditServiceControl_callStartingPointChoice pChoice );
HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_DeleteAlternation( void *pObject );
HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_MakeMold( void *pObject );
HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallCreditServiceControlOptionMap_amountString,
	e_ASNH225CallCreditServiceControlOptionMap_billingMode,
	e_ASNH225CallCreditServiceControlOptionMap_callDurationLimit,
	e_ASNH225CallCreditServiceControlOptionMap_enforceCallDurationLimit,
	e_ASNH225CallCreditServiceControlOptionMap_callStartingPoint

} ASNH225CallCreditServiceControlOptionMap;


#define e_ASNH225CallCreditServiceControlOptionMapSize 5
#define e_ASNH225CallCreditServiceControlOptionMapSizeExt 5
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnDoubleString m_amountString;
	ASNH225CallCreditServiceControl_billingMode m_billingMode;
	AsnInteger m_callDurationLimit;
	AsnBoolean m_enforceCallDurationLimit;
	ASNH225CallCreditServiceControl_callStartingPoint m_callStartingPoint;
	/*...,*/
} ASNH225CallCreditServiceControl;
HS_RESULT new_ASNH225CallCreditServiceControl( void *pObject );
HS_RESULT delete_ASNH225CallCreditServiceControl( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallCreditServiceControl_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CallCreditServiceControl_IncludeOptionField( void *pObject, ASNH225CallCreditServiceControlOptionMap pOptionMap );
BOOL	  ASNH225CallCreditServiceControl_IsIncludeOptionField( void *pObject, ASNH225CallCreditServiceControlOptionMap pOptionMap );
HS_RESULT ASNH225CallCreditServiceControl_MakeMold( void *pObject );
HS_RESULT ASNH225CallCreditServiceControl_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallCreditServiceControl_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ServiceControlDescriptorChoice_url,
	e_ASNH225ServiceControlDescriptorChoice_signal,
	e_ASNH225ServiceControlDescriptorChoice_nonStandard,
	e_ASNH225ServiceControlDescriptorChoice_callCreditServiceControl

} ASNH225ServiceControlDescriptorChoice;


#define e_ASNH225ServiceControlDescriptorChoiceSize		4
#define e_ASNH225ServiceControlDescriptorChoiceSizeExt	4
typedef struct
{
	ASNH225ServiceControlDescriptorChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225ServiceControlDescriptor;
HS_RESULT new_ASNH225ServiceControlDescriptor( void *pObject );
HS_RESULT delete_ASNH225ServiceControlDescriptor( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ServiceControlDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225ServiceControlDescriptor_SetChoice( void *pObject, ASNH225ServiceControlDescriptorChoice pChoice );
HS_RESULT ASNH225ServiceControlDescriptor_DeleteAlternation( void *pObject );
HS_RESULT ASNH225ServiceControlDescriptor_MakeMold( void *pObject );
HS_RESULT ASNH225ServiceControlDescriptor_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ServiceControlDescriptor_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ServiceControlSession_reasonChoice_open,
	e_ASNH225ServiceControlSession_reasonChoice_refresh,
	e_ASNH225ServiceControlSession_reasonChoice_close

} ASNH225ServiceControlSession_reasonChoice;


#define e_ASNH225ServiceControlSession_reasonChoiceSize		3
#define e_ASNH225ServiceControlSession_reasonChoiceSizeExt	3
typedef struct
{
	ASNH225ServiceControlSession_reasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225ServiceControlSession_reason;
HS_RESULT new_ASNH225ServiceControlSession_reason( void *pObject );
HS_RESULT delete_ASNH225ServiceControlSession_reason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ServiceControlSession_reason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225ServiceControlSession_reason_SetChoice( void *pObject, ASNH225ServiceControlSession_reasonChoice pChoice );
HS_RESULT ASNH225ServiceControlSession_reason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225ServiceControlSession_reason_MakeMold( void *pObject );
HS_RESULT ASNH225ServiceControlSession_reason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ServiceControlSession_reason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ServiceControlSessionOptionMap_contents

} ASNH225ServiceControlSessionOptionMap;


#define e_ASNH225ServiceControlSessionOptionMapSize 1
#define e_ASNH225ServiceControlSessionOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_sessionId;
	ASNH225ServiceControlDescriptor m_contents;
	ASNH225ServiceControlSession_reason m_reason;
	/*...,*/
} ASNH225ServiceControlSession;
HS_RESULT new_ASNH225ServiceControlSession( void *pObject );
HS_RESULT delete_ASNH225ServiceControlSession( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ServiceControlSession_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ServiceControlSession_IncludeOptionField( void *pObject, ASNH225ServiceControlSessionOptionMap pOptionMap );
BOOL	  ASNH225ServiceControlSession_IsIncludeOptionField( void *pObject, ASNH225ServiceControlSessionOptionMap pOptionMap );
HS_RESULT ASNH225ServiceControlSession_MakeMold( void *pObject );
HS_RESULT ASNH225ServiceControlSession_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ServiceControlSession_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallsAvailableOptionMap_group

} ASNH225CallsAvailableOptionMap;


#define e_ASNH225CallsAvailableOptionMapSize 1
#define e_ASNH225CallsAvailableOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_calls;
	AsnSingleString m_group;
	/*...,*/
} ASNH225CallsAvailable;
HS_RESULT new_ASNH225CallsAvailable( void *pObject );
HS_RESULT delete_ASNH225CallsAvailable( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallsAvailable_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CallsAvailable_IncludeOptionField( void *pObject, ASNH225CallsAvailableOptionMap pOptionMap );
BOOL	  ASNH225CallsAvailable_IsIncludeOptionField( void *pObject, ASNH225CallsAvailableOptionMap pOptionMap );
HS_RESULT ASNH225CallsAvailable_MakeMold( void *pObject );
HS_RESULT ASNH225CallsAvailable_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallsAvailable_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallCapacityInfoOptionMap_voiceGwCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_h310GwCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_h320GwCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_h321GwCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_h322GwCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_h323GwCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_h324GwCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_t120OnlyGwCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_t38FaxAnnexbOnlyGwCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_terminalCallsAvailable,
	e_ASNH225CallCapacityInfoOptionMap_mcuCallsAvailable

} ASNH225CallCapacityInfoOptionMap;


#define e_ASNH225CallCapacityInfoOptionMapSize 11
#define e_ASNH225CallCapacityInfoOptionMapSizeExt 11
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_voiceGwCallsAvailable;
	AsnSequenceOf m_h310GwCallsAvailable;
	AsnSequenceOf m_h320GwCallsAvailable;
	AsnSequenceOf m_h321GwCallsAvailable;
	AsnSequenceOf m_h322GwCallsAvailable;
	AsnSequenceOf m_h323GwCallsAvailable;
	AsnSequenceOf m_h324GwCallsAvailable;
	AsnSequenceOf m_t120OnlyGwCallsAvailable;
	AsnSequenceOf m_t38FaxAnnexbOnlyGwCallsAvailable;
	AsnSequenceOf m_terminalCallsAvailable;
	AsnSequenceOf m_mcuCallsAvailable;
	/*...,*/
} ASNH225CallCapacityInfo;
HS_RESULT new_ASNH225CallCapacityInfo( void *pObject );
HS_RESULT delete_ASNH225CallCapacityInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallCapacityInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CallCapacityInfo_IncludeOptionField( void *pObject, ASNH225CallCapacityInfoOptionMap pOptionMap );
BOOL	  ASNH225CallCapacityInfo_IsIncludeOptionField( void *pObject, ASNH225CallCapacityInfoOptionMap pOptionMap );
HS_RESULT ASNH225CallCapacityInfo_MakeMold( void *pObject );
HS_RESULT ASNH225CallCapacityInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallCapacityInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallCapacityOptionMap_maximumCallCapacity,
	e_ASNH225CallCapacityOptionMap_currentCallCapacity

} ASNH225CallCapacityOptionMap;


#define e_ASNH225CallCapacityOptionMapSize 2
#define e_ASNH225CallCapacityOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225CallCapacityInfo m_maximumCallCapacity;
	ASNH225CallCapacityInfo m_currentCallCapacity;
	/*...,*/
} ASNH225CallCapacity;
HS_RESULT new_ASNH225CallCapacity( void *pObject );
HS_RESULT delete_ASNH225CallCapacity( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallCapacity_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CallCapacity_IncludeOptionField( void *pObject, ASNH225CallCapacityOptionMap pOptionMap );
BOOL	  ASNH225CallCapacity_IsIncludeOptionField( void *pObject, ASNH225CallCapacityOptionMap pOptionMap );
HS_RESULT ASNH225CallCapacity_MakeMold( void *pObject );
HS_RESULT ASNH225CallCapacity_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallCapacity_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225CicInfoOptionMapSize 0
#define e_ASNH225CicInfoOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_cic;
	AsnOctetString m_pointCode;
	/*...,*/
} ASNH225CicInfo;
HS_RESULT new_ASNH225CicInfo( void *pObject );
HS_RESULT delete_ASNH225CicInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CicInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CicInfo_MakeMold( void *pObject );
HS_RESULT ASNH225CicInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CicInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GroupIDOptionMap_member

} ASNH225GroupIDOptionMap;


#define e_ASNH225GroupIDOptionMapSize 1
#define e_ASNH225GroupIDOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_member;
	AsnSingleString m_group;
	/*...,*/
} ASNH225GroupID;
HS_RESULT new_ASNH225GroupID( void *pObject );
HS_RESULT delete_ASNH225GroupID( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GroupID_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GroupID_IncludeOptionField( void *pObject, ASNH225GroupIDOptionMap pOptionMap );
BOOL	  ASNH225GroupID_IsIncludeOptionField( void *pObject, ASNH225GroupIDOptionMap pOptionMap );
HS_RESULT ASNH225GroupID_MakeMold( void *pObject );
HS_RESULT ASNH225GroupID_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GroupID_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CircuitIdentifierChoice_cic,
	e_ASNH225CircuitIdentifierChoice_group

} ASNH225CircuitIdentifierChoice;


#define e_ASNH225CircuitIdentifierChoiceSize		2
#define e_ASNH225CircuitIdentifierChoiceSizeExt	2
typedef struct
{
	ASNH225CircuitIdentifierChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225CircuitIdentifier;
HS_RESULT new_ASNH225CircuitIdentifier( void *pObject );
HS_RESULT delete_ASNH225CircuitIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CircuitIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225CircuitIdentifier_SetChoice( void *pObject, ASNH225CircuitIdentifierChoice pChoice );
HS_RESULT ASNH225CircuitIdentifier_DeleteAlternation( void *pObject );
HS_RESULT ASNH225CircuitIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH225CircuitIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CircuitIdentifier_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GenericIdentifierChoice_standard,
	e_ASNH225GenericIdentifierChoice_oid,
	e_ASNH225GenericIdentifierChoice_nonStandard

} ASNH225GenericIdentifierChoice;


#define e_ASNH225GenericIdentifierChoiceSize		3
#define e_ASNH225GenericIdentifierChoiceSizeExt	3
typedef struct
{
	ASNH225GenericIdentifierChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225GenericIdentifier;
HS_RESULT new_ASNH225GenericIdentifier( void *pObject );
HS_RESULT delete_ASNH225GenericIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GenericIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225GenericIdentifier_SetChoice( void *pObject, ASNH225GenericIdentifierChoice pChoice );
HS_RESULT ASNH225GenericIdentifier_DeleteAlternation( void *pObject );
HS_RESULT ASNH225GenericIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH225GenericIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GenericIdentifier_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ContentChoice_raw,
	e_ASNH225ContentChoice_text,
	e_ASNH225ContentChoice_unicode,
	e_ASNH225ContentChoice_bool,
	e_ASNH225ContentChoice_number8,
	e_ASNH225ContentChoice_number16,
	e_ASNH225ContentChoice_number32,
	e_ASNH225ContentChoice_id,
	e_ASNH225ContentChoice_alias,
	e_ASNH225ContentChoice_transport,
	e_ASNH225ContentChoice_compound,
	e_ASNH225ContentChoice_nested

} ASNH225ContentChoice;


#define e_ASNH225ContentChoiceSize		12
#define e_ASNH225ContentChoiceSizeExt	12
typedef struct
{
	ASNH225ContentChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225Content;
HS_RESULT new_ASNH225Content( void *pObject );
HS_RESULT delete_ASNH225Content( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Content_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225Content_SetChoice( void *pObject, ASNH225ContentChoice pChoice );
HS_RESULT ASNH225Content_DeleteAlternation( void *pObject );
HS_RESULT ASNH225Content_MakeMold( void *pObject );
HS_RESULT ASNH225Content_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Content_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225EnumeratedParameterOptionMap_content

} ASNH225EnumeratedParameterOptionMap;


#define e_ASNH225EnumeratedParameterOptionMapSize 1
#define e_ASNH225EnumeratedParameterOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225GenericIdentifier m_id;
	ASNH225Content m_content;
	/*...,*/
} ASNH225EnumeratedParameter;
HS_RESULT new_ASNH225EnumeratedParameter( void *pObject );
HS_RESULT delete_ASNH225EnumeratedParameter( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225EnumeratedParameter_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225EnumeratedParameter_IncludeOptionField( void *pObject, ASNH225EnumeratedParameterOptionMap pOptionMap );
BOOL	  ASNH225EnumeratedParameter_IsIncludeOptionField( void *pObject, ASNH225EnumeratedParameterOptionMap pOptionMap );
HS_RESULT ASNH225EnumeratedParameter_MakeMold( void *pObject );
HS_RESULT ASNH225EnumeratedParameter_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225EnumeratedParameter_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GenericDataOptionMap_parameters

} ASNH225GenericDataOptionMap;


#define e_ASNH225GenericDataOptionMapSize 1
#define e_ASNH225GenericDataOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225GenericIdentifier m_id;
	AsnSequenceOf m_parameters;
	/*...,*/
} ASNH225GenericData;
HS_RESULT new_ASNH225GenericData( void *pObject );
HS_RESULT delete_ASNH225GenericData( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GenericData_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GenericData_IncludeOptionField( void *pObject, ASNH225GenericDataOptionMap pOptionMap );
BOOL	  ASNH225GenericData_IsIncludeOptionField( void *pObject, ASNH225GenericDataOptionMap pOptionMap );
HS_RESULT ASNH225GenericData_MakeMold( void *pObject );
HS_RESULT ASNH225GenericData_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GenericData_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CircuitInfoOptionMap_sourceCircuitID,
	e_ASNH225CircuitInfoOptionMap_destinationCircuitID,
	e_ASNH225CircuitInfoOptionMap_genericData

} ASNH225CircuitInfoOptionMap;


#define e_ASNH225CircuitInfoOptionMapSize 3
#define e_ASNH225CircuitInfoOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225CircuitIdentifier m_sourceCircuitID;
	ASNH225CircuitIdentifier m_destinationCircuitID;
	AsnSequenceOf m_genericData;
	/*...,*/
} ASNH225CircuitInfo;
HS_RESULT new_ASNH225CircuitInfo( void *pObject );
HS_RESULT delete_ASNH225CircuitInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CircuitInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CircuitInfo_IncludeOptionField( void *pObject, ASNH225CircuitInfoOptionMap pOptionMap );
BOOL	  ASNH225CircuitInfo_IsIncludeOptionField( void *pObject, ASNH225CircuitInfoOptionMap pOptionMap );
HS_RESULT ASNH225CircuitInfo_MakeMold( void *pObject );
HS_RESULT ASNH225CircuitInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CircuitInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ExtendedAliasAddressOptionMap_presentationIndicator,
	e_ASNH225ExtendedAliasAddressOptionMap_screeningIndicator

} ASNH225ExtendedAliasAddressOptionMap;


#define e_ASNH225ExtendedAliasAddressOptionMapSize 2
#define e_ASNH225ExtendedAliasAddressOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225AliasAddress m_address;
	ASNH225PresentationIndicator m_presentationIndicator;
	ASNH225ScreeningIndicator m_screeningIndicator;
	/*...,*/
} ASNH225ExtendedAliasAddress;
HS_RESULT new_ASNH225ExtendedAliasAddress( void *pObject );
HS_RESULT delete_ASNH225ExtendedAliasAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ExtendedAliasAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ExtendedAliasAddress_IncludeOptionField( void *pObject, ASNH225ExtendedAliasAddressOptionMap pOptionMap );
BOOL	  ASNH225ExtendedAliasAddress_IsIncludeOptionField( void *pObject, ASNH225ExtendedAliasAddressOptionMap pOptionMap );
HS_RESULT ASNH225ExtendedAliasAddress_MakeMold( void *pObject );
HS_RESULT ASNH225ExtendedAliasAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ExtendedAliasAddress_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225Setup_UUIEOptionMap_h245Address,
	e_ASNH225Setup_UUIEOptionMap_sourceAddress,
	e_ASNH225Setup_UUIEOptionMap_destinationAddress,
	e_ASNH225Setup_UUIEOptionMap_destCallSignalAddress,
	e_ASNH225Setup_UUIEOptionMap_destExtraCallInfo,
	e_ASNH225Setup_UUIEOptionMap_destExtraCRV,
	e_ASNH225Setup_UUIEOptionMap_callServices
,
	e_ASNH225Setup_UUIEOptionMap_sourceCallSignalAddress,
	e_ASNH225Setup_UUIEOptionMap_remoteExtensionAddress,
	e_ASNH225Setup_UUIEOptionMap_callIdentifier,
	e_ASNH225Setup_UUIEOptionMap_h245SecurityCapability,
	e_ASNH225Setup_UUIEOptionMap_tokens,
	e_ASNH225Setup_UUIEOptionMap_cryptoTokens,
	e_ASNH225Setup_UUIEOptionMap_fastStart,
	e_ASNH225Setup_UUIEOptionMap_mediaWaitForConnect,
	e_ASNH225Setup_UUIEOptionMap_canOverlapSend,
	e_ASNH225Setup_UUIEOptionMap_endpointIdentifier,
	e_ASNH225Setup_UUIEOptionMap_multipleCalls,
	e_ASNH225Setup_UUIEOptionMap_maintainConnection,
	e_ASNH225Setup_UUIEOptionMap_connectionParameters,
	e_ASNH225Setup_UUIEOptionMap_language,
	e_ASNH225Setup_UUIEOptionMap_presentationIndicator,
	e_ASNH225Setup_UUIEOptionMap_screeningIndicator,
	e_ASNH225Setup_UUIEOptionMap_serviceControl,
	e_ASNH225Setup_UUIEOptionMap_symmetricOperationRequired,
	e_ASNH225Setup_UUIEOptionMap_capacity,
	e_ASNH225Setup_UUIEOptionMap_circuitInfo,
	e_ASNH225Setup_UUIEOptionMap_desiredProtocols,
	e_ASNH225Setup_UUIEOptionMap_neededFeatures,
	e_ASNH225Setup_UUIEOptionMap_desiredFeatures,
	e_ASNH225Setup_UUIEOptionMap_supportedFeatures,
	e_ASNH225Setup_UUIEOptionMap_parallelH245Control,
	e_ASNH225Setup_UUIEOptionMap_additionalSourceAddresses
} ASNH225Setup_UUIEOptionMap;


#define e_ASNH225Setup_UUIEOptionMapSize 7
#define e_ASNH225Setup_UUIEOptionMapSizeExt 33
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225TransportAddress m_h245Address;
	AsnSequenceOf m_sourceAddress;
	ASNH225EndpointType m_sourceInfo;
	AsnSequenceOf m_destinationAddress;
	ASNH225TransportAddress m_destCallSignalAddress;
	AsnSequenceOf m_destExtraCallInfo;
	AsnSequenceOf m_destExtraCRV;
	AsnBoolean m_activeMC;
	ASNH225ConferenceIdentifier m_conferenceID;
	ASNH225Setup_UUIE_conferenceGoal m_conferenceGoal;
	ASNH225QseriesOptions m_callServices;
	ASNH225CallType m_callType;
	/*...,*/
	ASNH225TransportAddress m_sourceCallSignalAddress;
	ASNH225AliasAddress m_remoteExtensionAddress;
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_h245SecurityCapability;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_fastStart;
	AsnBoolean m_mediaWaitForConnect;
	AsnBoolean m_canOverlapSend;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	AsnBoolean m_multipleCalls;
	AsnBoolean m_maintainConnection;
	ASNH225Setup_UUIE_connectionParameters m_connectionParameters;
	AsnSequenceOf m_language;
	ASNH225PresentationIndicator m_presentationIndicator;
	ASNH225ScreeningIndicator m_screeningIndicator;
	AsnSequenceOf m_serviceControl;
	AsnNull m_symmetricOperationRequired;
	ASNH225CallCapacity m_capacity;
	ASNH225CircuitInfo m_circuitInfo;
	AsnSequenceOf m_desiredProtocols;
	AsnSequenceOf m_neededFeatures;
	AsnSequenceOf m_desiredFeatures;
	AsnSequenceOf m_supportedFeatures;
	AsnSequenceOf m_parallelH245Control;
	AsnSequenceOf m_additionalSourceAddresses;
} ASNH225Setup_UUIE;
HS_RESULT new_ASNH225Setup_UUIE( void *pObject );
HS_RESULT delete_ASNH225Setup_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Setup_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Setup_UUIE_IncludeOptionField( void *pObject, ASNH225Setup_UUIEOptionMap pOptionMap );
BOOL	  ASNH225Setup_UUIE_IsIncludeOptionField( void *pObject, ASNH225Setup_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225Setup_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225Setup_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Setup_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225FeatureSetOptionMap_neededFeatures,
	e_ASNH225FeatureSetOptionMap_desiredFeatures,
	e_ASNH225FeatureSetOptionMap_supportedFeatures

} ASNH225FeatureSetOptionMap;


#define e_ASNH225FeatureSetOptionMapSize 3
#define e_ASNH225FeatureSetOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_replacementFeatureSet;
	AsnSequenceOf m_neededFeatures;
	AsnSequenceOf m_desiredFeatures;
	AsnSequenceOf m_supportedFeatures;
	/*...,*/
} ASNH225FeatureSet;
HS_RESULT new_ASNH225FeatureSet( void *pObject );
HS_RESULT delete_ASNH225FeatureSet( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225FeatureSet_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225FeatureSet_IncludeOptionField( void *pObject, ASNH225FeatureSetOptionMap pOptionMap );
BOOL	  ASNH225FeatureSet_IsIncludeOptionField( void *pObject, ASNH225FeatureSetOptionMap pOptionMap );
HS_RESULT ASNH225FeatureSet_MakeMold( void *pObject );
HS_RESULT ASNH225FeatureSet_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225FeatureSet_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallProceeding_UUIEOptionMap_h245Address
,
	e_ASNH225CallProceeding_UUIEOptionMap_callIdentifier,
	e_ASNH225CallProceeding_UUIEOptionMap_h245SecurityMode,
	e_ASNH225CallProceeding_UUIEOptionMap_tokens,
	e_ASNH225CallProceeding_UUIEOptionMap_cryptoTokens,
	e_ASNH225CallProceeding_UUIEOptionMap_fastStart,
	e_ASNH225CallProceeding_UUIEOptionMap_multipleCalls,
	e_ASNH225CallProceeding_UUIEOptionMap_maintainConnection,
	e_ASNH225CallProceeding_UUIEOptionMap_fastConnectRefused,
	e_ASNH225CallProceeding_UUIEOptionMap_featureSet
} ASNH225CallProceeding_UUIEOptionMap;


#define e_ASNH225CallProceeding_UUIEOptionMapSize 1
#define e_ASNH225CallProceeding_UUIEOptionMapSizeExt 10
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225EndpointType m_destinationInfo;
	ASNH225TransportAddress m_h245Address;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	ASNH225H245Security m_h245SecurityMode;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_fastStart;
	AsnBoolean m_multipleCalls;
	AsnBoolean m_maintainConnection;
	AsnNull m_fastConnectRefused;
	ASNH225FeatureSet m_featureSet;
} ASNH225CallProceeding_UUIE;
HS_RESULT new_ASNH225CallProceeding_UUIE( void *pObject );
HS_RESULT delete_ASNH225CallProceeding_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallProceeding_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CallProceeding_UUIE_IncludeOptionField( void *pObject, ASNH225CallProceeding_UUIEOptionMap pOptionMap );
BOOL	  ASNH225CallProceeding_UUIE_IsIncludeOptionField( void *pObject, ASNH225CallProceeding_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225CallProceeding_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225CallProceeding_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallProceeding_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225Connect_UUIEOptionMap_h245Address
,
	e_ASNH225Connect_UUIEOptionMap_callIdentifier,
	e_ASNH225Connect_UUIEOptionMap_h245SecurityMode,
	e_ASNH225Connect_UUIEOptionMap_tokens,
	e_ASNH225Connect_UUIEOptionMap_cryptoTokens,
	e_ASNH225Connect_UUIEOptionMap_fastStart,
	e_ASNH225Connect_UUIEOptionMap_multipleCalls,
	e_ASNH225Connect_UUIEOptionMap_maintainConnection,
	e_ASNH225Connect_UUIEOptionMap_language,
	e_ASNH225Connect_UUIEOptionMap_connectedAddress,
	e_ASNH225Connect_UUIEOptionMap_presentationIndicator,
	e_ASNH225Connect_UUIEOptionMap_screeningIndicator,
	e_ASNH225Connect_UUIEOptionMap_fastConnectRefused,
	e_ASNH225Connect_UUIEOptionMap_serviceControl,
	e_ASNH225Connect_UUIEOptionMap_capacity,
	e_ASNH225Connect_UUIEOptionMap_featureSet
} ASNH225Connect_UUIEOptionMap;


#define e_ASNH225Connect_UUIEOptionMapSize 1
#define e_ASNH225Connect_UUIEOptionMapSizeExt 16
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225TransportAddress m_h245Address;
	ASNH225EndpointType m_destinationInfo;
	ASNH225ConferenceIdentifier m_conferenceID;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	ASNH225H245Security m_h245SecurityMode;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_fastStart;
	AsnBoolean m_multipleCalls;
	AsnBoolean m_maintainConnection;
	AsnSequenceOf m_language;
	AsnSequenceOf m_connectedAddress;
	ASNH225PresentationIndicator m_presentationIndicator;
	ASNH225ScreeningIndicator m_screeningIndicator;
	AsnNull m_fastConnectRefused;
	AsnSequenceOf m_serviceControl;
	ASNH225CallCapacity m_capacity;
	ASNH225FeatureSet m_featureSet;
} ASNH225Connect_UUIE;
HS_RESULT new_ASNH225Connect_UUIE( void *pObject );
HS_RESULT delete_ASNH225Connect_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Connect_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Connect_UUIE_IncludeOptionField( void *pObject, ASNH225Connect_UUIEOptionMap pOptionMap );
BOOL	  ASNH225Connect_UUIE_IsIncludeOptionField( void *pObject, ASNH225Connect_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225Connect_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225Connect_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Connect_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225Alerting_UUIEOptionMap_h245Address
,
	e_ASNH225Alerting_UUIEOptionMap_callIdentifier,
	e_ASNH225Alerting_UUIEOptionMap_h245SecurityMode,
	e_ASNH225Alerting_UUIEOptionMap_tokens,
	e_ASNH225Alerting_UUIEOptionMap_cryptoTokens,
	e_ASNH225Alerting_UUIEOptionMap_fastStart,
	e_ASNH225Alerting_UUIEOptionMap_multipleCalls,
	e_ASNH225Alerting_UUIEOptionMap_maintainConnection,
	e_ASNH225Alerting_UUIEOptionMap_alertingAddress,
	e_ASNH225Alerting_UUIEOptionMap_presentationIndicator,
	e_ASNH225Alerting_UUIEOptionMap_screeningIndicator,
	e_ASNH225Alerting_UUIEOptionMap_fastConnectRefused,
	e_ASNH225Alerting_UUIEOptionMap_serviceControl,
	e_ASNH225Alerting_UUIEOptionMap_capacity,
	e_ASNH225Alerting_UUIEOptionMap_featureSet
} ASNH225Alerting_UUIEOptionMap;


#define e_ASNH225Alerting_UUIEOptionMapSize 1
#define e_ASNH225Alerting_UUIEOptionMapSizeExt 15
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225EndpointType m_destinationInfo;
	ASNH225TransportAddress m_h245Address;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	ASNH225H245Security m_h245SecurityMode;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_fastStart;
	AsnBoolean m_multipleCalls;
	AsnBoolean m_maintainConnection;
	AsnSequenceOf m_alertingAddress;
	ASNH225PresentationIndicator m_presentationIndicator;
	ASNH225ScreeningIndicator m_screeningIndicator;
	AsnNull m_fastConnectRefused;
	AsnSequenceOf m_serviceControl;
	ASNH225CallCapacity m_capacity;
	ASNH225FeatureSet m_featureSet;
} ASNH225Alerting_UUIE;
HS_RESULT new_ASNH225Alerting_UUIE( void *pObject );
HS_RESULT delete_ASNH225Alerting_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Alerting_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Alerting_UUIE_IncludeOptionField( void *pObject, ASNH225Alerting_UUIEOptionMap pOptionMap );
BOOL	  ASNH225Alerting_UUIE_IsIncludeOptionField( void *pObject, ASNH225Alerting_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225Alerting_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225Alerting_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Alerting_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH225Information_UUIEOptionMap_callIdentifier,
	e_ASNH225Information_UUIEOptionMap_tokens,
	e_ASNH225Information_UUIEOptionMap_cryptoTokens,
	e_ASNH225Information_UUIEOptionMap_fastStart,
	e_ASNH225Information_UUIEOptionMap_fastConnectRefused,
	e_ASNH225Information_UUIEOptionMap_circuitInfo
} ASNH225Information_UUIEOptionMap;


#define e_ASNH225Information_UUIEOptionMapSize 0
#define e_ASNH225Information_UUIEOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_fastStart;
	AsnNull m_fastConnectRefused;
	ASNH225CircuitInfo m_circuitInfo;
} ASNH225Information_UUIE;
HS_RESULT new_ASNH225Information_UUIE( void *pObject );
HS_RESULT delete_ASNH225Information_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Information_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Information_UUIE_IncludeOptionField( void *pObject, ASNH225Information_UUIEOptionMap pOptionMap );
BOOL	  ASNH225Information_UUIE_IsIncludeOptionField( void *pObject, ASNH225Information_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225Information_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225Information_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Information_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ReleaseCompleteReasonChoice_noBandwidth,
	e_ASNH225ReleaseCompleteReasonChoice_gatekeeperResources,
	e_ASNH225ReleaseCompleteReasonChoice_unreachableDestination,
	e_ASNH225ReleaseCompleteReasonChoice_destinationRejection,
	e_ASNH225ReleaseCompleteReasonChoice_invalidRevision,
	e_ASNH225ReleaseCompleteReasonChoice_noPermission,
	e_ASNH225ReleaseCompleteReasonChoice_unreachableGatekeeper,
	e_ASNH225ReleaseCompleteReasonChoice_gatewayResources,
	e_ASNH225ReleaseCompleteReasonChoice_badFormatAddress,
	e_ASNH225ReleaseCompleteReasonChoice_adaptiveBusy,
	e_ASNH225ReleaseCompleteReasonChoice_inConf,
	e_ASNH225ReleaseCompleteReasonChoice_undefinedReason
,
	e_ASNH225ReleaseCompleteReasonChoice_facilityCallDeflection,
	e_ASNH225ReleaseCompleteReasonChoice_securityDenied,
	e_ASNH225ReleaseCompleteReasonChoice_calledPartyNotRegistered,
	e_ASNH225ReleaseCompleteReasonChoice_callerNotRegistered,
	e_ASNH225ReleaseCompleteReasonChoice_newConnectionNeeded,
	e_ASNH225ReleaseCompleteReasonChoice_nonStandardReason,
	e_ASNH225ReleaseCompleteReasonChoice_replaceWithConferenceInvite,
	e_ASNH225ReleaseCompleteReasonChoice_genericDataReason,
	e_ASNH225ReleaseCompleteReasonChoice_neededFeatureNotSupported,
	e_ASNH225ReleaseCompleteReasonChoice_tunnelledSignallingRejected
} ASNH225ReleaseCompleteReasonChoice;


#define e_ASNH225ReleaseCompleteReasonChoiceSize		12
#define e_ASNH225ReleaseCompleteReasonChoiceSizeExt	22
typedef struct
{
	ASNH225ReleaseCompleteReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225ReleaseCompleteReason;
HS_RESULT new_ASNH225ReleaseCompleteReason( void *pObject );
HS_RESULT delete_ASNH225ReleaseCompleteReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ReleaseCompleteReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225ReleaseCompleteReason_SetChoice( void *pObject, ASNH225ReleaseCompleteReasonChoice pChoice );
HS_RESULT ASNH225ReleaseCompleteReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225ReleaseCompleteReason_MakeMold( void *pObject );
HS_RESULT ASNH225ReleaseCompleteReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ReleaseCompleteReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ReleaseComplete_UUIEOptionMap_reason
,
	e_ASNH225ReleaseComplete_UUIEOptionMap_callIdentifier,
	e_ASNH225ReleaseComplete_UUIEOptionMap_tokens,
	e_ASNH225ReleaseComplete_UUIEOptionMap_cryptoTokens,
	e_ASNH225ReleaseComplete_UUIEOptionMap_busyAddress,
	e_ASNH225ReleaseComplete_UUIEOptionMap_presentationIndicator,
	e_ASNH225ReleaseComplete_UUIEOptionMap_screeningIndicator,
	e_ASNH225ReleaseComplete_UUIEOptionMap_capacity,
	e_ASNH225ReleaseComplete_UUIEOptionMap_serviceControl,
	e_ASNH225ReleaseComplete_UUIEOptionMap_featureSet
} ASNH225ReleaseComplete_UUIEOptionMap;


#define e_ASNH225ReleaseComplete_UUIEOptionMapSize 1
#define e_ASNH225ReleaseComplete_UUIEOptionMapSizeExt 10
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225ReleaseCompleteReason m_reason;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_busyAddress;
	ASNH225PresentationIndicator m_presentationIndicator;
	ASNH225ScreeningIndicator m_screeningIndicator;
	ASNH225CallCapacity m_capacity;
	AsnSequenceOf m_serviceControl;
	ASNH225FeatureSet m_featureSet;
} ASNH225ReleaseComplete_UUIE;
HS_RESULT new_ASNH225ReleaseComplete_UUIE( void *pObject );
HS_RESULT delete_ASNH225ReleaseComplete_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ReleaseComplete_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ReleaseComplete_UUIE_IncludeOptionField( void *pObject, ASNH225ReleaseComplete_UUIEOptionMap pOptionMap );
BOOL	  ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( void *pObject, ASNH225ReleaseComplete_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225ReleaseComplete_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225ReleaseComplete_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ReleaseComplete_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225FacilityReasonChoice_routeCallToGatekeeper,
	e_ASNH225FacilityReasonChoice_callForwarded,
	e_ASNH225FacilityReasonChoice_routeCallToMC,
	e_ASNH225FacilityReasonChoice_undefinedReason
,
	e_ASNH225FacilityReasonChoice_conferenceListChoice,
	e_ASNH225FacilityReasonChoice_startH245,
	e_ASNH225FacilityReasonChoice_noH245,
	e_ASNH225FacilityReasonChoice_newTokens,
	e_ASNH225FacilityReasonChoice_featureSetUpdate,
	e_ASNH225FacilityReasonChoice_forwardedElements,
	e_ASNH225FacilityReasonChoice_transportedInformation
} ASNH225FacilityReasonChoice;


#define e_ASNH225FacilityReasonChoiceSize		4
#define e_ASNH225FacilityReasonChoiceSizeExt	11
typedef struct
{
	ASNH225FacilityReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225FacilityReason;
HS_RESULT new_ASNH225FacilityReason( void *pObject );
HS_RESULT delete_ASNH225FacilityReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225FacilityReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225FacilityReason_SetChoice( void *pObject, ASNH225FacilityReasonChoice pChoice );
HS_RESULT ASNH225FacilityReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225FacilityReason_MakeMold( void *pObject );
HS_RESULT ASNH225FacilityReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225FacilityReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ConferenceListOptionMap_conferenceID,
	e_ASNH225ConferenceListOptionMap_conferenceAlias,
	e_ASNH225ConferenceListOptionMap_nonStandardData

} ASNH225ConferenceListOptionMap;


#define e_ASNH225ConferenceListOptionMapSize 3
#define e_ASNH225ConferenceListOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ConferenceIdentifier m_conferenceID;
	ASNH225AliasAddress m_conferenceAlias;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
} ASNH225ConferenceList;
HS_RESULT new_ASNH225ConferenceList( void *pObject );
HS_RESULT delete_ASNH225ConferenceList( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ConferenceList_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ConferenceList_IncludeOptionField( void *pObject, ASNH225ConferenceListOptionMap pOptionMap );
BOOL	  ASNH225ConferenceList_IsIncludeOptionField( void *pObject, ASNH225ConferenceListOptionMap pOptionMap );
HS_RESULT ASNH225ConferenceList_MakeMold( void *pObject );
HS_RESULT ASNH225ConferenceList_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ConferenceList_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225Facility_UUIEOptionMap_alternativeAddress,
	e_ASNH225Facility_UUIEOptionMap_alternativeAliasAddress,
	e_ASNH225Facility_UUIEOptionMap_conferenceID
,
	e_ASNH225Facility_UUIEOptionMap_callIdentifier,
	e_ASNH225Facility_UUIEOptionMap_destExtraCallInfo,
	e_ASNH225Facility_UUIEOptionMap_remoteExtensionAddress,
	e_ASNH225Facility_UUIEOptionMap_tokens,
	e_ASNH225Facility_UUIEOptionMap_cryptoTokens,
	e_ASNH225Facility_UUIEOptionMap_conferences,
	e_ASNH225Facility_UUIEOptionMap_h245Address,
	e_ASNH225Facility_UUIEOptionMap_fastStart,
	e_ASNH225Facility_UUIEOptionMap_multipleCalls,
	e_ASNH225Facility_UUIEOptionMap_maintainConnection,
	e_ASNH225Facility_UUIEOptionMap_fastConnectRefused,
	e_ASNH225Facility_UUIEOptionMap_serviceControl,
	e_ASNH225Facility_UUIEOptionMap_circuitInfo,
	e_ASNH225Facility_UUIEOptionMap_featureSet,
	e_ASNH225Facility_UUIEOptionMap_destinationInfo,
	e_ASNH225Facility_UUIEOptionMap_h245SecurityMode
} ASNH225Facility_UUIEOptionMap;


#define e_ASNH225Facility_UUIEOptionMapSize 3
#define e_ASNH225Facility_UUIEOptionMapSizeExt 19
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225TransportAddress m_alternativeAddress;
	AsnSequenceOf m_alternativeAliasAddress;
	ASNH225ConferenceIdentifier m_conferenceID;
	ASNH225FacilityReason m_reason;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_destExtraCallInfo;
	ASNH225AliasAddress m_remoteExtensionAddress;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_conferences;
	ASNH225TransportAddress m_h245Address;
	AsnSequenceOf m_fastStart;
	AsnBoolean m_multipleCalls;
	AsnBoolean m_maintainConnection;
	AsnNull m_fastConnectRefused;
	AsnSequenceOf m_serviceControl;
	ASNH225CircuitInfo m_circuitInfo;
	ASNH225FeatureSet m_featureSet;
	ASNH225EndpointType m_destinationInfo;
	ASNH225H245Security m_h245SecurityMode;
} ASNH225Facility_UUIE;
HS_RESULT new_ASNH225Facility_UUIE( void *pObject );
HS_RESULT delete_ASNH225Facility_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Facility_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Facility_UUIE_IncludeOptionField( void *pObject, ASNH225Facility_UUIEOptionMap pOptionMap );
BOOL	  ASNH225Facility_UUIE_IsIncludeOptionField( void *pObject, ASNH225Facility_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225Facility_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225Facility_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Facility_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225Progress_UUIEOptionMap_h245Address,
	e_ASNH225Progress_UUIEOptionMap_h245SecurityMode,
	e_ASNH225Progress_UUIEOptionMap_tokens,
	e_ASNH225Progress_UUIEOptionMap_cryptoTokens,
	e_ASNH225Progress_UUIEOptionMap_fastStart
,
	e_ASNH225Progress_UUIEOptionMap_multipleCalls,
	e_ASNH225Progress_UUIEOptionMap_maintainConnection,
	e_ASNH225Progress_UUIEOptionMap_fastConnectRefused
} ASNH225Progress_UUIEOptionMap;


#define e_ASNH225Progress_UUIEOptionMapSize 5
#define e_ASNH225Progress_UUIEOptionMapSizeExt 8
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225EndpointType m_destinationInfo;
	ASNH225TransportAddress m_h245Address;
	ASNH225CallIdentifier m_callIdentifier;
	ASNH225H245Security m_h245SecurityMode;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_fastStart;
	/*...,*/
	AsnBoolean m_multipleCalls;
	AsnBoolean m_maintainConnection;
	AsnNull m_fastConnectRefused;
} ASNH225Progress_UUIE;
HS_RESULT new_ASNH225Progress_UUIE( void *pObject );
HS_RESULT delete_ASNH225Progress_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Progress_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Progress_UUIE_IncludeOptionField( void *pObject, ASNH225Progress_UUIEOptionMap pOptionMap );
BOOL	  ASNH225Progress_UUIE_IsIncludeOptionField( void *pObject, ASNH225Progress_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225Progress_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225Progress_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Progress_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225Status_UUIEOptionMap_tokens,
	e_ASNH225Status_UUIEOptionMap_cryptoTokens

} ASNH225Status_UUIEOptionMap;


#define e_ASNH225Status_UUIEOptionMapSize 2
#define e_ASNH225Status_UUIEOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	/*...,*/
} ASNH225Status_UUIE;
HS_RESULT new_ASNH225Status_UUIE( void *pObject );
HS_RESULT delete_ASNH225Status_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Status_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Status_UUIE_IncludeOptionField( void *pObject, ASNH225Status_UUIEOptionMap pOptionMap );
BOOL	  ASNH225Status_UUIE_IsIncludeOptionField( void *pObject, ASNH225Status_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225Status_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225Status_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Status_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225StatusInquiry_UUIEOptionMap_tokens,
	e_ASNH225StatusInquiry_UUIEOptionMap_cryptoTokens

} ASNH225StatusInquiry_UUIEOptionMap;


#define e_ASNH225StatusInquiry_UUIEOptionMapSize 2
#define e_ASNH225StatusInquiry_UUIEOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	/*...,*/
} ASNH225StatusInquiry_UUIE;
HS_RESULT new_ASNH225StatusInquiry_UUIE( void *pObject );
HS_RESULT delete_ASNH225StatusInquiry_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225StatusInquiry_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225StatusInquiry_UUIE_IncludeOptionField( void *pObject, ASNH225StatusInquiry_UUIEOptionMap pOptionMap );
BOOL	  ASNH225StatusInquiry_UUIE_IsIncludeOptionField( void *pObject, ASNH225StatusInquiry_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225StatusInquiry_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225StatusInquiry_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225StatusInquiry_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225SetupAcknowledge_UUIEOptionMap_tokens,
	e_ASNH225SetupAcknowledge_UUIEOptionMap_cryptoTokens

} ASNH225SetupAcknowledge_UUIEOptionMap;


#define e_ASNH225SetupAcknowledge_UUIEOptionMapSize 2
#define e_ASNH225SetupAcknowledge_UUIEOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	/*...,*/
} ASNH225SetupAcknowledge_UUIE;
HS_RESULT new_ASNH225SetupAcknowledge_UUIE( void *pObject );
HS_RESULT delete_ASNH225SetupAcknowledge_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225SetupAcknowledge_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225SetupAcknowledge_UUIE_IncludeOptionField( void *pObject, ASNH225SetupAcknowledge_UUIEOptionMap pOptionMap );
BOOL	  ASNH225SetupAcknowledge_UUIE_IsIncludeOptionField( void *pObject, ASNH225SetupAcknowledge_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225SetupAcknowledge_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225SetupAcknowledge_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225SetupAcknowledge_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225Notify_UUIEOptionMap_tokens,
	e_ASNH225Notify_UUIEOptionMap_cryptoTokens

} ASNH225Notify_UUIEOptionMap;


#define e_ASNH225Notify_UUIEOptionMapSize 2
#define e_ASNH225Notify_UUIEOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	/*...,*/
} ASNH225Notify_UUIE;
HS_RESULT new_ASNH225Notify_UUIE( void *pObject );
HS_RESULT delete_ASNH225Notify_UUIE( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Notify_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Notify_UUIE_IncludeOptionField( void *pObject, ASNH225Notify_UUIEOptionMap pOptionMap );
BOOL	  ASNH225Notify_UUIE_IsIncludeOptionField( void *pObject, ASNH225Notify_UUIEOptionMap pOptionMap );
HS_RESULT ASNH225Notify_UUIE_MakeMold( void *pObject );
HS_RESULT ASNH225Notify_UUIE_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Notify_UUIE_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setup,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_callProceeding,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_alerting,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_information,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_releaseComplete,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_facility
,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_progress,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_empty,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_status,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_statusInquiry,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setupAcknowledge,
	e_ASNH225H323_UU_PDU_h323_message_bodyChoice_notify
} ASNH225H323_UU_PDU_h323_message_bodyChoice;


#define e_ASNH225H323_UU_PDU_h323_message_bodyChoiceSize		7
#define e_ASNH225H323_UU_PDU_h323_message_bodyChoiceSizeExt	13
typedef struct
{
	ASNH225H323_UU_PDU_h323_message_bodyChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225H323_UU_PDU_h323_message_body;
HS_RESULT new_ASNH225H323_UU_PDU_h323_message_body( void *pObject );
HS_RESULT delete_ASNH225H323_UU_PDU_h323_message_body( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H323_UU_PDU_h323_message_body_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225H323_UU_PDU_h323_message_body_SetChoice( void *pObject, ASNH225H323_UU_PDU_h323_message_bodyChoice pChoice );
HS_RESULT ASNH225H323_UU_PDU_h323_message_body_DeleteAlternation( void *pObject );
HS_RESULT ASNH225H323_UU_PDU_h323_message_body_MakeMold( void *pObject );
HS_RESULT ASNH225H323_UU_PDU_h323_message_body_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H323_UU_PDU_h323_message_body_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallLinkageOptionMap_globalCallId,
	e_ASNH225CallLinkageOptionMap_threadId

} ASNH225CallLinkageOptionMap;


#define e_ASNH225CallLinkageOptionMapSize 2
#define e_ASNH225CallLinkageOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225GloballyUniqueID m_globalCallId;
	ASNH225GloballyUniqueID m_threadId;
	/*...,*/
} ASNH225CallLinkage;
HS_RESULT new_ASNH225CallLinkage( void *pObject );
HS_RESULT delete_ASNH225CallLinkage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallLinkage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CallLinkage_IncludeOptionField( void *pObject, ASNH225CallLinkageOptionMap pOptionMap );
BOOL	  ASNH225CallLinkage_IsIncludeOptionField( void *pObject, ASNH225CallLinkageOptionMap pOptionMap );
HS_RESULT ASNH225CallLinkage_MakeMold( void *pObject );
HS_RESULT ASNH225CallLinkage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallLinkage_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H323_UU_PDU_tunnelledSignallingMessageOptionMap_tunnellingRequired,
	e_ASNH225H323_UU_PDU_tunnelledSignallingMessageOptionMap_nonStandardData

} ASNH225H323_UU_PDU_tunnelledSignallingMessageOptionMap;


#define e_ASNH225H323_UU_PDU_tunnelledSignallingMessageOptionMapSize 2
#define e_ASNH225H323_UU_PDU_tunnelledSignallingMessageOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225TunnelledProtocol m_tunnelledProtocolID;
	AsnSequenceOf m_messageContent;
	AsnNull m_tunnellingRequired;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
} ASNH225H323_UU_PDU_tunnelledSignallingMessage;
HS_RESULT new_ASNH225H323_UU_PDU_tunnelledSignallingMessage( void *pObject );
HS_RESULT delete_ASNH225H323_UU_PDU_tunnelledSignallingMessage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H323_UU_PDU_tunnelledSignallingMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H323_UU_PDU_tunnelledSignallingMessage_IncludeOptionField( void *pObject, ASNH225H323_UU_PDU_tunnelledSignallingMessageOptionMap pOptionMap );
BOOL	  ASNH225H323_UU_PDU_tunnelledSignallingMessage_IsIncludeOptionField( void *pObject, ASNH225H323_UU_PDU_tunnelledSignallingMessageOptionMap pOptionMap );
HS_RESULT ASNH225H323_UU_PDU_tunnelledSignallingMessage_MakeMold( void *pObject );
HS_RESULT ASNH225H323_UU_PDU_tunnelledSignallingMessage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H323_UU_PDU_tunnelledSignallingMessage_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225StimulusControlOptionMap_nonStandard,
	e_ASNH225StimulusControlOptionMap_isText,
	e_ASNH225StimulusControlOptionMap_h248Message

} ASNH225StimulusControlOptionMap;


#define e_ASNH225StimulusControlOptionMapSize 3
#define e_ASNH225StimulusControlOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandard;
	AsnNull m_isText;
	AsnOctetString m_h248Message;
	/*...,*/
} ASNH225StimulusControl;
HS_RESULT new_ASNH225StimulusControl( void *pObject );
HS_RESULT delete_ASNH225StimulusControl( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225StimulusControl_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225StimulusControl_IncludeOptionField( void *pObject, ASNH225StimulusControlOptionMap pOptionMap );
BOOL	  ASNH225StimulusControl_IsIncludeOptionField( void *pObject, ASNH225StimulusControlOptionMap pOptionMap );
HS_RESULT ASNH225StimulusControl_MakeMold( void *pObject );
HS_RESULT ASNH225StimulusControl_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225StimulusControl_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H323_UU_PDUOptionMap_nonStandardData
,
	e_ASNH225H323_UU_PDUOptionMap_h4501SupplementaryService,
	e_ASNH225H323_UU_PDUOptionMap_h245Tunneling,
	e_ASNH225H323_UU_PDUOptionMap_h245Control,
	e_ASNH225H323_UU_PDUOptionMap_nonStandardControl,
	e_ASNH225H323_UU_PDUOptionMap_callLinkage,
	e_ASNH225H323_UU_PDUOptionMap_tunnelledSignallingMessage,
	e_ASNH225H323_UU_PDUOptionMap_provisionalRespToH245Tunneling,
	e_ASNH225H323_UU_PDUOptionMap_stimulusControl,
	e_ASNH225H323_UU_PDUOptionMap_genericData
} ASNH225H323_UU_PDUOptionMap;


#define e_ASNH225H323_UU_PDUOptionMapSize 1
#define e_ASNH225H323_UU_PDUOptionMapSizeExt 10
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225H323_UU_PDU_h323_message_body m_h323_message_body;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_h4501SupplementaryService;
	AsnBoolean m_h245Tunneling;
	AsnSequenceOf m_h245Control;
	AsnSequenceOf m_nonStandardControl;
	ASNH225CallLinkage m_callLinkage;
	ASNH225H323_UU_PDU_tunnelledSignallingMessage m_tunnelledSignallingMessage;
	AsnNull m_provisionalRespToH245Tunneling;
	ASNH225StimulusControl m_stimulusControl;
	AsnSequenceOf m_genericData;
} ASNH225H323_UU_PDU;
HS_RESULT new_ASNH225H323_UU_PDU( void *pObject );
HS_RESULT delete_ASNH225H323_UU_PDU( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H323_UU_PDU_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H323_UU_PDU_IncludeOptionField( void *pObject, ASNH225H323_UU_PDUOptionMap pOptionMap );
BOOL	  ASNH225H323_UU_PDU_IsIncludeOptionField( void *pObject, ASNH225H323_UU_PDUOptionMap pOptionMap );
HS_RESULT ASNH225H323_UU_PDU_MakeMold( void *pObject );
HS_RESULT ASNH225H323_UU_PDU_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H323_UU_PDU_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225H323_UserInformationOptionMap_user_data

} ASNH225H323_UserInformationOptionMap;


#define e_ASNH225H323_UserInformationOptionMapSize 1
#define e_ASNH225H323_UserInformationOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225H323_UU_PDU m_h323_uu_pdu;
	ASNH225H323_UserInformation_user_data m_user_data;
	/*...,*/
} ASNH225H323_UserInformation;
HS_RESULT new_ASNH225H323_UserInformation( void *pObject );
HS_RESULT delete_ASNH225H323_UserInformation( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H323_UserInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225H323_UserInformation_IncludeOptionField( void *pObject, ASNH225H323_UserInformationOptionMap pOptionMap );
BOOL	  ASNH225H323_UserInformation_IsIncludeOptionField( void *pObject, ASNH225H323_UserInformationOptionMap pOptionMap );
HS_RESULT ASNH225H323_UserInformation_MakeMold( void *pObject );
HS_RESULT ASNH225H323_UserInformation_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225H323_UserInformation_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225AddressPattern_rangeOptionMapSize 0
#define e_ASNH225AddressPattern_rangeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH225PartyNumber m_startOfRange;
	ASNH225PartyNumber m_endOfRange;
} ASNH225AddressPattern_range;
HS_RESULT new_ASNH225AddressPattern_range( void *pObject );
HS_RESULT delete_ASNH225AddressPattern_range( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AddressPattern_range_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225AddressPattern_range_MakeMold( void *pObject );
HS_RESULT ASNH225AddressPattern_range_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AddressPattern_range_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225AddressPatternChoice_wildcard,
	e_ASNH225AddressPatternChoice_range

} ASNH225AddressPatternChoice;


#define e_ASNH225AddressPatternChoiceSize		2
#define e_ASNH225AddressPatternChoiceSizeExt	2
typedef struct
{
	ASNH225AddressPatternChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225AddressPattern;
HS_RESULT new_ASNH225AddressPattern( void *pObject );
HS_RESULT delete_ASNH225AddressPattern( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AddressPattern_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225AddressPattern_SetChoice( void *pObject, ASNH225AddressPatternChoice pChoice );
HS_RESULT ASNH225AddressPattern_DeleteAlternation( void *pObject );
HS_RESULT ASNH225AddressPattern_MakeMold( void *pObject );
HS_RESULT ASNH225AddressPattern_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AddressPattern_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225AlternateTransportAddressesOptionMap_annexE

} ASNH225AlternateTransportAddressesOptionMap;


#define e_ASNH225AlternateTransportAddressesOptionMapSize 1
#define e_ASNH225AlternateTransportAddressesOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_annexE;
	/*...,*/
} ASNH225AlternateTransportAddresses;
HS_RESULT new_ASNH225AlternateTransportAddresses( void *pObject );
HS_RESULT delete_ASNH225AlternateTransportAddresses( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AlternateTransportAddresses_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225AlternateTransportAddresses_IncludeOptionField( void *pObject, ASNH225AlternateTransportAddressesOptionMap pOptionMap );
BOOL	  ASNH225AlternateTransportAddresses_IsIncludeOptionField( void *pObject, ASNH225AlternateTransportAddressesOptionMap pOptionMap );
HS_RESULT ASNH225AlternateTransportAddresses_MakeMold( void *pObject );
HS_RESULT ASNH225AlternateTransportAddresses_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AlternateTransportAddresses_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225EndpointOptionMap_nonStandardData,
	e_ASNH225EndpointOptionMap_aliasAddress,
	e_ASNH225EndpointOptionMap_callSignalAddress,
	e_ASNH225EndpointOptionMap_rasAddress,
	e_ASNH225EndpointOptionMap_endpointType,
	e_ASNH225EndpointOptionMap_tokens,
	e_ASNH225EndpointOptionMap_cryptoTokens,
	e_ASNH225EndpointOptionMap_priority,
	e_ASNH225EndpointOptionMap_remoteExtensionAddress,
	e_ASNH225EndpointOptionMap_destExtraCallInfo
,
	e_ASNH225EndpointOptionMap_alternateTransportAddresses
} ASNH225EndpointOptionMap;


#define e_ASNH225EndpointOptionMapSize 10
#define e_ASNH225EndpointOptionMapSizeExt 11
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	AsnSequenceOf m_aliasAddress;
	AsnSequenceOf m_callSignalAddress;
	AsnSequenceOf m_rasAddress;
	ASNH225EndpointType m_endpointType;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnInteger m_priority;
	AsnSequenceOf m_remoteExtensionAddress;
	AsnSequenceOf m_destExtraCallInfo;
	/*...,*/
	ASNH225AlternateTransportAddresses m_alternateTransportAddresses;
} ASNH225Endpoint;
HS_RESULT new_ASNH225Endpoint( void *pObject );
HS_RESULT delete_ASNH225Endpoint( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225Endpoint_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225Endpoint_IncludeOptionField( void *pObject, ASNH225EndpointOptionMap pOptionMap );
BOOL	  ASNH225Endpoint_IsIncludeOptionField( void *pObject, ASNH225EndpointOptionMap pOptionMap );
HS_RESULT ASNH225Endpoint_MakeMold( void *pObject );
HS_RESULT ASNH225Endpoint_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225Endpoint_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225UseSpecifiedTransportChoice_tcp,
	e_ASNH225UseSpecifiedTransportChoice_annexE

} ASNH225UseSpecifiedTransportChoice;


#define e_ASNH225UseSpecifiedTransportChoiceSize		2
#define e_ASNH225UseSpecifiedTransportChoiceSizeExt	2
typedef struct
{
	ASNH225UseSpecifiedTransportChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225UseSpecifiedTransport;
HS_RESULT new_ASNH225UseSpecifiedTransport( void *pObject );
HS_RESULT delete_ASNH225UseSpecifiedTransport( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225UseSpecifiedTransport_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225UseSpecifiedTransport_SetChoice( void *pObject, ASNH225UseSpecifiedTransportChoice pChoice );
HS_RESULT ASNH225UseSpecifiedTransport_DeleteAlternation( void *pObject );
HS_RESULT ASNH225UseSpecifiedTransport_MakeMold( void *pObject );
HS_RESULT ASNH225UseSpecifiedTransport_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225UseSpecifiedTransport_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225AlternateGKOptionMap_gatekeeperIdentifier

} ASNH225AlternateGKOptionMap;


#define e_ASNH225AlternateGKOptionMapSize 1
#define e_ASNH225AlternateGKOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225TransportAddress m_rasAddress;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	AsnBoolean m_needToRegister;
	AsnInteger m_priority;
	/*...,*/
} ASNH225AlternateGK;
HS_RESULT new_ASNH225AlternateGK( void *pObject );
HS_RESULT delete_ASNH225AlternateGK( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AlternateGK_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225AlternateGK_IncludeOptionField( void *pObject, ASNH225AlternateGKOptionMap pOptionMap );
BOOL	  ASNH225AlternateGK_IsIncludeOptionField( void *pObject, ASNH225AlternateGKOptionMap pOptionMap );
HS_RESULT ASNH225AlternateGK_MakeMold( void *pObject );
HS_RESULT ASNH225AlternateGK_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AlternateGK_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225AltGKInfoOptionMapSize 0
#define e_ASNH225AltGKInfoOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_alternateGatekeeper;
	AsnBoolean m_altGKisPermanent;
	/*...,*/
} ASNH225AltGKInfo;
HS_RESULT new_ASNH225AltGKInfo( void *pObject );
HS_RESULT delete_ASNH225AltGKInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AltGKInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225AltGKInfo_MakeMold( void *pObject );
HS_RESULT ASNH225AltGKInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AltGKInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225EncryptIntAlgChoice_nonStandard,
	e_ASNH225EncryptIntAlgChoice_isoAlgorithm

} ASNH225EncryptIntAlgChoice;


#define e_ASNH225EncryptIntAlgChoiceSize		2
#define e_ASNH225EncryptIntAlgChoiceSizeExt	2
typedef struct
{
	ASNH225EncryptIntAlgChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225EncryptIntAlg;
HS_RESULT new_ASNH225EncryptIntAlg( void *pObject );
HS_RESULT delete_ASNH225EncryptIntAlg( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225EncryptIntAlg_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225EncryptIntAlg_SetChoice( void *pObject, ASNH225EncryptIntAlgChoice pChoice );
HS_RESULT ASNH225EncryptIntAlg_DeleteAlternation( void *pObject );
HS_RESULT ASNH225EncryptIntAlg_MakeMold( void *pObject );
HS_RESULT ASNH225EncryptIntAlg_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225EncryptIntAlg_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225NonIsoIntegrityMechanismChoice_hMAC_MD5,
	e_ASNH225NonIsoIntegrityMechanismChoice_hMAC_iso10118_2_s,
	e_ASNH225NonIsoIntegrityMechanismChoice_hMAC_iso10118_2_l,
	e_ASNH225NonIsoIntegrityMechanismChoice_hMAC_iso10118_3

} ASNH225NonIsoIntegrityMechanismChoice;


#define e_ASNH225NonIsoIntegrityMechanismChoiceSize		4
#define e_ASNH225NonIsoIntegrityMechanismChoiceSizeExt	4
typedef struct
{
	ASNH225NonIsoIntegrityMechanismChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225NonIsoIntegrityMechanism;
HS_RESULT new_ASNH225NonIsoIntegrityMechanism( void *pObject );
HS_RESULT delete_ASNH225NonIsoIntegrityMechanism( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225NonIsoIntegrityMechanism_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225NonIsoIntegrityMechanism_SetChoice( void *pObject, ASNH225NonIsoIntegrityMechanismChoice pChoice );
HS_RESULT ASNH225NonIsoIntegrityMechanism_DeleteAlternation( void *pObject );
HS_RESULT ASNH225NonIsoIntegrityMechanism_MakeMold( void *pObject );
HS_RESULT ASNH225NonIsoIntegrityMechanism_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225NonIsoIntegrityMechanism_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225IntegrityMechanismChoice_nonStandard,
	e_ASNH225IntegrityMechanismChoice_digSig,
	e_ASNH225IntegrityMechanismChoice_iso9797,
	e_ASNH225IntegrityMechanismChoice_nonIsoIM

} ASNH225IntegrityMechanismChoice;


#define e_ASNH225IntegrityMechanismChoiceSize		4
#define e_ASNH225IntegrityMechanismChoiceSizeExt	4
typedef struct
{
	ASNH225IntegrityMechanismChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225IntegrityMechanism;
HS_RESULT new_ASNH225IntegrityMechanism( void *pObject );
HS_RESULT delete_ASNH225IntegrityMechanism( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225IntegrityMechanism_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225IntegrityMechanism_SetChoice( void *pObject, ASNH225IntegrityMechanismChoice pChoice );
HS_RESULT ASNH225IntegrityMechanism_DeleteAlternation( void *pObject );
HS_RESULT ASNH225IntegrityMechanism_MakeMold( void *pObject );
HS_RESULT ASNH225IntegrityMechanism_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225IntegrityMechanism_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225ICVOptionMapSize 0
#define e_ASNH225ICVOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnObjectIdentifier m_algorithmOID;
	AsnBitString m_icv;
} ASNH225ICV;
HS_RESULT new_ASNH225ICV( void *pObject );
HS_RESULT delete_ASNH225ICV( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ICV_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ICV_MakeMold( void *pObject );
HS_RESULT ASNH225ICV_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ICV_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225CapacityReportingCapabilityOptionMapSize 0
#define e_ASNH225CapacityReportingCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_canReportCallCapacity;
	/*...,*/
} ASNH225CapacityReportingCapability;
HS_RESULT new_ASNH225CapacityReportingCapability( void *pObject );
HS_RESULT delete_ASNH225CapacityReportingCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CapacityReportingCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CapacityReportingCapability_MakeMold( void *pObject );
HS_RESULT ASNH225CapacityReportingCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CapacityReportingCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CapacityReportingSpecification_whenOptionMap_callStart,
	e_ASNH225CapacityReportingSpecification_whenOptionMap_callEnd

} ASNH225CapacityReportingSpecification_whenOptionMap;


#define e_ASNH225CapacityReportingSpecification_whenOptionMapSize 2
#define e_ASNH225CapacityReportingSpecification_whenOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnNull m_callStart;
	AsnNull m_callEnd;
	/*...,*/
} ASNH225CapacityReportingSpecification_when;
HS_RESULT new_ASNH225CapacityReportingSpecification_when( void *pObject );
HS_RESULT delete_ASNH225CapacityReportingSpecification_when( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CapacityReportingSpecification_when_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CapacityReportingSpecification_when_IncludeOptionField( void *pObject, ASNH225CapacityReportingSpecification_whenOptionMap pOptionMap );
BOOL	  ASNH225CapacityReportingSpecification_when_IsIncludeOptionField( void *pObject, ASNH225CapacityReportingSpecification_whenOptionMap pOptionMap );
HS_RESULT ASNH225CapacityReportingSpecification_when_MakeMold( void *pObject );
HS_RESULT ASNH225CapacityReportingSpecification_when_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CapacityReportingSpecification_when_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225CapacityReportingSpecificationOptionMapSize 0
#define e_ASNH225CapacityReportingSpecificationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH225CapacityReportingSpecification_when m_when;
	/*...,*/
} ASNH225CapacityReportingSpecification;
HS_RESULT new_ASNH225CapacityReportingSpecification( void *pObject );
HS_RESULT delete_ASNH225CapacityReportingSpecification( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CapacityReportingSpecification_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CapacityReportingSpecification_MakeMold( void *pObject );
HS_RESULT ASNH225CapacityReportingSpecification_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CapacityReportingSpecification_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RasUsageInfoTypesOptionMap_startTime,
	e_ASNH225RasUsageInfoTypesOptionMap_endTime,
	e_ASNH225RasUsageInfoTypesOptionMap_terminationCause

} ASNH225RasUsageInfoTypesOptionMap;


#define e_ASNH225RasUsageInfoTypesOptionMapSize 3
#define e_ASNH225RasUsageInfoTypesOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_nonStandardUsageTypes;
	AsnNull m_startTime;
	AsnNull m_endTime;
	AsnNull m_terminationCause;
	/*...,*/
} ASNH225RasUsageInfoTypes;
HS_RESULT new_ASNH225RasUsageInfoTypes( void *pObject );
HS_RESULT delete_ASNH225RasUsageInfoTypes( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RasUsageInfoTypes_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RasUsageInfoTypes_IncludeOptionField( void *pObject, ASNH225RasUsageInfoTypesOptionMap pOptionMap );
BOOL	  ASNH225RasUsageInfoTypes_IsIncludeOptionField( void *pObject, ASNH225RasUsageInfoTypesOptionMap pOptionMap );
HS_RESULT ASNH225RasUsageInfoTypes_MakeMold( void *pObject );
HS_RESULT ASNH225RasUsageInfoTypes_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RasUsageInfoTypes_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RasUsageSpecification_whenOptionMap_start,
	e_ASNH225RasUsageSpecification_whenOptionMap_end,
	e_ASNH225RasUsageSpecification_whenOptionMap_inIrr

} ASNH225RasUsageSpecification_whenOptionMap;


#define e_ASNH225RasUsageSpecification_whenOptionMapSize 3
#define e_ASNH225RasUsageSpecification_whenOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnNull m_start;
	AsnNull m_end;
	AsnNull m_inIrr;
	/*...,*/
} ASNH225RasUsageSpecification_when;
HS_RESULT new_ASNH225RasUsageSpecification_when( void *pObject );
HS_RESULT delete_ASNH225RasUsageSpecification_when( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RasUsageSpecification_when_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RasUsageSpecification_when_IncludeOptionField( void *pObject, ASNH225RasUsageSpecification_whenOptionMap pOptionMap );
BOOL	  ASNH225RasUsageSpecification_when_IsIncludeOptionField( void *pObject, ASNH225RasUsageSpecification_whenOptionMap pOptionMap );
HS_RESULT ASNH225RasUsageSpecification_when_MakeMold( void *pObject );
HS_RESULT ASNH225RasUsageSpecification_when_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RasUsageSpecification_when_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RasUsageSpecification_callStartingPointOptionMap_alerting,
	e_ASNH225RasUsageSpecification_callStartingPointOptionMap_connect

} ASNH225RasUsageSpecification_callStartingPointOptionMap;


#define e_ASNH225RasUsageSpecification_callStartingPointOptionMapSize 2
#define e_ASNH225RasUsageSpecification_callStartingPointOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnNull m_alerting;
	AsnNull m_connect;
	/*...,*/
} ASNH225RasUsageSpecification_callStartingPoint;
HS_RESULT new_ASNH225RasUsageSpecification_callStartingPoint( void *pObject );
HS_RESULT delete_ASNH225RasUsageSpecification_callStartingPoint( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RasUsageSpecification_callStartingPoint_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RasUsageSpecification_callStartingPoint_IncludeOptionField( void *pObject, ASNH225RasUsageSpecification_callStartingPointOptionMap pOptionMap );
BOOL	  ASNH225RasUsageSpecification_callStartingPoint_IsIncludeOptionField( void *pObject, ASNH225RasUsageSpecification_callStartingPointOptionMap pOptionMap );
HS_RESULT ASNH225RasUsageSpecification_callStartingPoint_MakeMold( void *pObject );
HS_RESULT ASNH225RasUsageSpecification_callStartingPoint_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RasUsageSpecification_callStartingPoint_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RasUsageSpecificationOptionMap_callStartingPoint

} ASNH225RasUsageSpecificationOptionMap;


#define e_ASNH225RasUsageSpecificationOptionMapSize 1
#define e_ASNH225RasUsageSpecificationOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RasUsageSpecification_when m_when;
	ASNH225RasUsageSpecification_callStartingPoint m_callStartingPoint;
	ASNH225RasUsageInfoTypes m_required;
	/*...,*/
} ASNH225RasUsageSpecification;
HS_RESULT new_ASNH225RasUsageSpecification( void *pObject );
HS_RESULT delete_ASNH225RasUsageSpecification( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RasUsageSpecification_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RasUsageSpecification_IncludeOptionField( void *pObject, ASNH225RasUsageSpecificationOptionMap pOptionMap );
BOOL	  ASNH225RasUsageSpecification_IsIncludeOptionField( void *pObject, ASNH225RasUsageSpecificationOptionMap pOptionMap );
HS_RESULT ASNH225RasUsageSpecification_MakeMold( void *pObject );
HS_RESULT ASNH225RasUsageSpecification_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RasUsageSpecification_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RasUsageInformationOptionMap_alertingTime,
	e_ASNH225RasUsageInformationOptionMap_connectTime,
	e_ASNH225RasUsageInformationOptionMap_endTime

} ASNH225RasUsageInformationOptionMap;


#define e_ASNH225RasUsageInformationOptionMapSize 3
#define e_ASNH225RasUsageInformationOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_nonStandardUsageFields;
	ASNH225TimeStamp m_alertingTime;
	ASNH225TimeStamp m_connectTime;
	ASNH225TimeStamp m_endTime;
	/*...,*/
} ASNH225RasUsageInformation;
HS_RESULT new_ASNH225RasUsageInformation( void *pObject );
HS_RESULT delete_ASNH225RasUsageInformation( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RasUsageInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RasUsageInformation_IncludeOptionField( void *pObject, ASNH225RasUsageInformationOptionMap pOptionMap );
BOOL	  ASNH225RasUsageInformation_IsIncludeOptionField( void *pObject, ASNH225RasUsageInformationOptionMap pOptionMap );
HS_RESULT ASNH225RasUsageInformation_MakeMold( void *pObject );
HS_RESULT ASNH225RasUsageInformation_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RasUsageInformation_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallTerminationCauseChoice_releaseCompleteReason,
	e_ASNH225CallTerminationCauseChoice_releaseCompleteCauseIE

} ASNH225CallTerminationCauseChoice;


#define e_ASNH225CallTerminationCauseChoiceSize		2
#define e_ASNH225CallTerminationCauseChoiceSizeExt	2
typedef struct
{
	ASNH225CallTerminationCauseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225CallTerminationCause;
HS_RESULT new_ASNH225CallTerminationCause( void *pObject );
HS_RESULT delete_ASNH225CallTerminationCause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallTerminationCause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225CallTerminationCause_SetChoice( void *pObject, ASNH225CallTerminationCauseChoice pChoice );
HS_RESULT ASNH225CallTerminationCause_DeleteAlternation( void *pObject );
HS_RESULT ASNH225CallTerminationCause_MakeMold( void *pObject );
HS_RESULT ASNH225CallTerminationCause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallTerminationCause_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225TransportChannelInfoOptionMap_sendAddress,
	e_ASNH225TransportChannelInfoOptionMap_recvAddress

} ASNH225TransportChannelInfoOptionMap;


#define e_ASNH225TransportChannelInfoOptionMapSize 2
#define e_ASNH225TransportChannelInfoOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225TransportAddress m_sendAddress;
	ASNH225TransportAddress m_recvAddress;
	/*...,*/
} ASNH225TransportChannelInfo;
HS_RESULT new_ASNH225TransportChannelInfo( void *pObject );
HS_RESULT delete_ASNH225TransportChannelInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TransportChannelInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225TransportChannelInfo_IncludeOptionField( void *pObject, ASNH225TransportChannelInfoOptionMap pOptionMap );
BOOL	  ASNH225TransportChannelInfo_IsIncludeOptionField( void *pObject, ASNH225TransportChannelInfoOptionMap pOptionMap );
HS_RESULT ASNH225TransportChannelInfo_MakeMold( void *pObject );
HS_RESULT ASNH225TransportChannelInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TransportChannelInfo_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225BandwidthDetailsOptionMapSize 0
#define e_ASNH225BandwidthDetailsOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_sender;
	AsnBoolean m_multicast;
	ASNH225BandWidth m_bandwidth;
	ASNH225TransportChannelInfo m_rtcpAddresses;
	/*...,*/
} ASNH225BandwidthDetails;
HS_RESULT new_ASNH225BandwidthDetails( void *pObject );
HS_RESULT delete_ASNH225BandwidthDetails( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225BandwidthDetails_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225BandwidthDetails_MakeMold( void *pObject );
HS_RESULT ASNH225BandwidthDetails_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225BandwidthDetails_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallCreditCapabilityOptionMap_canDisplayAmountString,
	e_ASNH225CallCreditCapabilityOptionMap_canEnforceDurationLimit

} ASNH225CallCreditCapabilityOptionMap;


#define e_ASNH225CallCreditCapabilityOptionMapSize 2
#define e_ASNH225CallCreditCapabilityOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_canDisplayAmountString;
	AsnBoolean m_canEnforceDurationLimit;
	/*...,*/
} ASNH225CallCreditCapability;
HS_RESULT new_ASNH225CallCreditCapability( void *pObject );
HS_RESULT delete_ASNH225CallCreditCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallCreditCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225CallCreditCapability_IncludeOptionField( void *pObject, ASNH225CallCreditCapabilityOptionMap pOptionMap );
BOOL	  ASNH225CallCreditCapability_IsIncludeOptionField( void *pObject, ASNH225CallCreditCapabilityOptionMap pOptionMap );
HS_RESULT ASNH225CallCreditCapability_MakeMold( void *pObject );
HS_RESULT ASNH225CallCreditCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallCreditCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH225RTPSessionOptionMap_multicast,
	e_ASNH225RTPSessionOptionMap_bandwidth
} ASNH225RTPSessionOptionMap;


#define e_ASNH225RTPSessionOptionMapSize 0
#define e_ASNH225RTPSessionOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225TransportChannelInfo m_rtpAddress;
	ASNH225TransportChannelInfo m_rtcpAddress;
	AsnSingleString m_cname;
	AsnInteger m_ssrc;
	AsnInteger m_sessionId;
	AsnSequenceOf m_associatedSessionIds;
	/*...,*/
	AsnNull m_multicast;
	ASNH225BandWidth m_bandwidth;
} ASNH225RTPSession;
HS_RESULT new_ASNH225RTPSession( void *pObject );
HS_RESULT delete_ASNH225RTPSession( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RTPSession_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RTPSession_IncludeOptionField( void *pObject, ASNH225RTPSessionOptionMap pOptionMap );
BOOL	  ASNH225RTPSession_IsIncludeOptionField( void *pObject, ASNH225RTPSessionOptionMap pOptionMap );
HS_RESULT ASNH225RTPSession_MakeMold( void *pObject );
HS_RESULT ASNH225RTPSession_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RTPSession_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GatekeeperRequestOptionMap_nonStandardData,
	e_ASNH225GatekeeperRequestOptionMap_gatekeeperIdentifier,
	e_ASNH225GatekeeperRequestOptionMap_callServices,
	e_ASNH225GatekeeperRequestOptionMap_endpointAlias
,
	e_ASNH225GatekeeperRequestOptionMap_alternateEndpoints,
	e_ASNH225GatekeeperRequestOptionMap_tokens,
	e_ASNH225GatekeeperRequestOptionMap_cryptoTokens,
	e_ASNH225GatekeeperRequestOptionMap_authenticationCapability,
	e_ASNH225GatekeeperRequestOptionMap_algorithmOIDs,
	e_ASNH225GatekeeperRequestOptionMap_integrity,
	e_ASNH225GatekeeperRequestOptionMap_integrityCheckValue,
	e_ASNH225GatekeeperRequestOptionMap_supportsAltGK,
	e_ASNH225GatekeeperRequestOptionMap_featureSet,
	e_ASNH225GatekeeperRequestOptionMap_genericData
} ASNH225GatekeeperRequestOptionMap;


#define e_ASNH225GatekeeperRequestOptionMapSize 4
#define e_ASNH225GatekeeperRequestOptionMapSizeExt 14
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225TransportAddress m_rasAddress;
	ASNH225EndpointType m_endpointType;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	ASNH225QseriesOptions m_callServices;
	AsnSequenceOf m_endpointAlias;
	/*...,*/
	AsnSequenceOf m_alternateEndpoints;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_authenticationCapability;
	AsnSequenceOf m_algorithmOIDs;
	AsnSequenceOf m_integrity;
	ASNH225ICV m_integrityCheckValue;
	AsnNull m_supportsAltGK;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225GatekeeperRequest;
HS_RESULT new_ASNH225GatekeeperRequest( void *pObject );
HS_RESULT delete_ASNH225GatekeeperRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GatekeeperRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GatekeeperRequest_IncludeOptionField( void *pObject, ASNH225GatekeeperRequestOptionMap pOptionMap );
BOOL	  ASNH225GatekeeperRequest_IsIncludeOptionField( void *pObject, ASNH225GatekeeperRequestOptionMap pOptionMap );
HS_RESULT ASNH225GatekeeperRequest_MakeMold( void *pObject );
HS_RESULT ASNH225GatekeeperRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GatekeeperRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GatekeeperConfirmOptionMap_nonStandardData,
	e_ASNH225GatekeeperConfirmOptionMap_gatekeeperIdentifier
,
	e_ASNH225GatekeeperConfirmOptionMap_alternateGatekeeper,
	e_ASNH225GatekeeperConfirmOptionMap_authenticationMode,
	e_ASNH225GatekeeperConfirmOptionMap_tokens,
	e_ASNH225GatekeeperConfirmOptionMap_cryptoTokens,
	e_ASNH225GatekeeperConfirmOptionMap_algorithmOID,
	e_ASNH225GatekeeperConfirmOptionMap_integrity,
	e_ASNH225GatekeeperConfirmOptionMap_integrityCheckValue,
	e_ASNH225GatekeeperConfirmOptionMap_featureSet,
	e_ASNH225GatekeeperConfirmOptionMap_genericData
} ASNH225GatekeeperConfirmOptionMap;


#define e_ASNH225GatekeeperConfirmOptionMapSize 2
#define e_ASNH225GatekeeperConfirmOptionMapSizeExt 11
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	ASNH225TransportAddress m_rasAddress;
	/*...,*/
	AsnSequenceOf m_alternateGatekeeper;
	ASNH225AuthenticationMechanism m_authenticationMode;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnObjectIdentifier m_algorithmOID;
	AsnSequenceOf m_integrity;
	ASNH225ICV m_integrityCheckValue;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225GatekeeperConfirm;
HS_RESULT new_ASNH225GatekeeperConfirm( void *pObject );
HS_RESULT delete_ASNH225GatekeeperConfirm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GatekeeperConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GatekeeperConfirm_IncludeOptionField( void *pObject, ASNH225GatekeeperConfirmOptionMap pOptionMap );
BOOL	  ASNH225GatekeeperConfirm_IsIncludeOptionField( void *pObject, ASNH225GatekeeperConfirmOptionMap pOptionMap );
HS_RESULT ASNH225GatekeeperConfirm_MakeMold( void *pObject );
HS_RESULT ASNH225GatekeeperConfirm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GatekeeperConfirm_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GatekeeperRejectReasonChoice_resourceUnavailable,
	e_ASNH225GatekeeperRejectReasonChoice_terminalExcluded,
	e_ASNH225GatekeeperRejectReasonChoice_invalidRevision,
	e_ASNH225GatekeeperRejectReasonChoice_undefinedReason
,
	e_ASNH225GatekeeperRejectReasonChoice_securityDenial,
	e_ASNH225GatekeeperRejectReasonChoice_genericDataReason,
	e_ASNH225GatekeeperRejectReasonChoice_neededFeatureNotSupported
} ASNH225GatekeeperRejectReasonChoice;


#define e_ASNH225GatekeeperRejectReasonChoiceSize		4
#define e_ASNH225GatekeeperRejectReasonChoiceSizeExt	7
typedef struct
{
	ASNH225GatekeeperRejectReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225GatekeeperRejectReason;
HS_RESULT new_ASNH225GatekeeperRejectReason( void *pObject );
HS_RESULT delete_ASNH225GatekeeperRejectReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GatekeeperRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225GatekeeperRejectReason_SetChoice( void *pObject, ASNH225GatekeeperRejectReasonChoice pChoice );
HS_RESULT ASNH225GatekeeperRejectReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225GatekeeperRejectReason_MakeMold( void *pObject );
HS_RESULT ASNH225GatekeeperRejectReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GatekeeperRejectReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225GatekeeperRejectOptionMap_nonStandardData,
	e_ASNH225GatekeeperRejectOptionMap_gatekeeperIdentifier
,
	e_ASNH225GatekeeperRejectOptionMap_altGKInfo,
	e_ASNH225GatekeeperRejectOptionMap_tokens,
	e_ASNH225GatekeeperRejectOptionMap_cryptoTokens,
	e_ASNH225GatekeeperRejectOptionMap_integrityCheckValue,
	e_ASNH225GatekeeperRejectOptionMap_featureSet,
	e_ASNH225GatekeeperRejectOptionMap_genericData
} ASNH225GatekeeperRejectOptionMap;


#define e_ASNH225GatekeeperRejectOptionMapSize 2
#define e_ASNH225GatekeeperRejectOptionMapSizeExt 8
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	ASNH225GatekeeperRejectReason m_rejectReason;
	/*...,*/
	ASNH225AltGKInfo m_altGKInfo;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225GatekeeperReject;
HS_RESULT new_ASNH225GatekeeperReject( void *pObject );
HS_RESULT delete_ASNH225GatekeeperReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GatekeeperReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225GatekeeperReject_IncludeOptionField( void *pObject, ASNH225GatekeeperRejectOptionMap pOptionMap );
BOOL	  ASNH225GatekeeperReject_IsIncludeOptionField( void *pObject, ASNH225GatekeeperRejectOptionMap pOptionMap );
HS_RESULT ASNH225GatekeeperReject_MakeMold( void *pObject );
HS_RESULT ASNH225GatekeeperReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225GatekeeperReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RegistrationRequestOptionMap_nonStandardData,
	e_ASNH225RegistrationRequestOptionMap_terminalAlias,
	e_ASNH225RegistrationRequestOptionMap_gatekeeperIdentifier
,
	e_ASNH225RegistrationRequestOptionMap_alternateEndpoints,
	e_ASNH225RegistrationRequestOptionMap_timeToLive,
	e_ASNH225RegistrationRequestOptionMap_tokens,
	e_ASNH225RegistrationRequestOptionMap_cryptoTokens,
	e_ASNH225RegistrationRequestOptionMap_integrityCheckValue,
	e_ASNH225RegistrationRequestOptionMap_keepAlive,
	e_ASNH225RegistrationRequestOptionMap_endpointIdentifier,
	e_ASNH225RegistrationRequestOptionMap_willSupplyUUIEs,
	e_ASNH225RegistrationRequestOptionMap_maintainConnection,
	e_ASNH225RegistrationRequestOptionMap_alternateTransportAddresses,
	e_ASNH225RegistrationRequestOptionMap_additiveRegistration,
	e_ASNH225RegistrationRequestOptionMap_terminalAliasPattern,
	e_ASNH225RegistrationRequestOptionMap_supportsAltGK,
	e_ASNH225RegistrationRequestOptionMap_usageReportingCapability,
	e_ASNH225RegistrationRequestOptionMap_multipleCalls,
	e_ASNH225RegistrationRequestOptionMap_supportedH248Packages,
	e_ASNH225RegistrationRequestOptionMap_callCreditCapability,
	e_ASNH225RegistrationRequestOptionMap_capacityReportingCapability,
	e_ASNH225RegistrationRequestOptionMap_capacity,
	e_ASNH225RegistrationRequestOptionMap_featureSet,
	e_ASNH225RegistrationRequestOptionMap_genericData
} ASNH225RegistrationRequestOptionMap;


#define e_ASNH225RegistrationRequestOptionMapSize 3
#define e_ASNH225RegistrationRequestOptionMapSizeExt 24
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225NonStandardParameter m_nonStandardData;
	AsnBoolean m_discoveryComplete;
	AsnSequenceOf m_callSignalAddress;
	AsnSequenceOf m_rasAddress;
	ASNH225EndpointType m_terminalType;
	AsnSequenceOf m_terminalAlias;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	ASNH225VendorIdentifier m_endpointVendor;
	/*...,*/
	AsnSequenceOf m_alternateEndpoints;
	ASNH225TimeToLive m_timeToLive;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnBoolean m_keepAlive;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	AsnBoolean m_willSupplyUUIEs;
	AsnBoolean m_maintainConnection;
	ASNH225AlternateTransportAddresses m_alternateTransportAddresses;
	AsnNull m_additiveRegistration;
	AsnSequenceOf m_terminalAliasPattern;
	AsnNull m_supportsAltGK;
	ASNH225RasUsageInfoTypes m_usageReportingCapability;
	AsnBoolean m_multipleCalls;
	AsnSequenceOf m_supportedH248Packages;
	ASNH225CallCreditCapability m_callCreditCapability;
	ASNH225CapacityReportingCapability m_capacityReportingCapability;
	ASNH225CallCapacity m_capacity;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225RegistrationRequest;
HS_RESULT new_ASNH225RegistrationRequest( void *pObject );
HS_RESULT delete_ASNH225RegistrationRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RegistrationRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RegistrationRequest_IncludeOptionField( void *pObject, ASNH225RegistrationRequestOptionMap pOptionMap );
BOOL	  ASNH225RegistrationRequest_IsIncludeOptionField( void *pObject, ASNH225RegistrationRequestOptionMap pOptionMap );
HS_RESULT ASNH225RegistrationRequest_MakeMold( void *pObject );
HS_RESULT ASNH225RegistrationRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RegistrationRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH225RegistrationConfirm_preGrantedARQOptionMap_irrFrequencyInCall,
	e_ASNH225RegistrationConfirm_preGrantedARQOptionMap_totalBandwidthRestriction,
	e_ASNH225RegistrationConfirm_preGrantedARQOptionMap_alternateTransportAddresses,
	e_ASNH225RegistrationConfirm_preGrantedARQOptionMap_useSpecifiedTransport
} ASNH225RegistrationConfirm_preGrantedARQOptionMap;


#define e_ASNH225RegistrationConfirm_preGrantedARQOptionMapSize 0
#define e_ASNH225RegistrationConfirm_preGrantedARQOptionMapSizeExt 4
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_makeCall;
	AsnBoolean m_useGKCallSignalAddressToMakeCall;
	AsnBoolean m_answerCall;
	AsnBoolean m_useGKCallSignalAddressToAnswer;
	/*...,*/
	AsnInteger m_irrFrequencyInCall;
	ASNH225BandWidth m_totalBandwidthRestriction;
	ASNH225AlternateTransportAddresses m_alternateTransportAddresses;
	ASNH225UseSpecifiedTransport m_useSpecifiedTransport;
} ASNH225RegistrationConfirm_preGrantedARQ;
HS_RESULT new_ASNH225RegistrationConfirm_preGrantedARQ( void *pObject );
HS_RESULT delete_ASNH225RegistrationConfirm_preGrantedARQ( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RegistrationConfirm_preGrantedARQ_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RegistrationConfirm_preGrantedARQ_IncludeOptionField( void *pObject, ASNH225RegistrationConfirm_preGrantedARQOptionMap pOptionMap );
BOOL	  ASNH225RegistrationConfirm_preGrantedARQ_IsIncludeOptionField( void *pObject, ASNH225RegistrationConfirm_preGrantedARQOptionMap pOptionMap );
HS_RESULT ASNH225RegistrationConfirm_preGrantedARQ_MakeMold( void *pObject );
HS_RESULT ASNH225RegistrationConfirm_preGrantedARQ_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RegistrationConfirm_preGrantedARQ_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RegistrationConfirmOptionMap_nonStandardData,
	e_ASNH225RegistrationConfirmOptionMap_terminalAlias,
	e_ASNH225RegistrationConfirmOptionMap_gatekeeperIdentifier
,
	e_ASNH225RegistrationConfirmOptionMap_alternateGatekeeper,
	e_ASNH225RegistrationConfirmOptionMap_timeToLive,
	e_ASNH225RegistrationConfirmOptionMap_tokens,
	e_ASNH225RegistrationConfirmOptionMap_cryptoTokens,
	e_ASNH225RegistrationConfirmOptionMap_integrityCheckValue,
	e_ASNH225RegistrationConfirmOptionMap_willRespondToIRR,
	e_ASNH225RegistrationConfirmOptionMap_preGrantedARQ,
	e_ASNH225RegistrationConfirmOptionMap_maintainConnection,
	e_ASNH225RegistrationConfirmOptionMap_serviceControl,
	e_ASNH225RegistrationConfirmOptionMap_supportsAdditiveRegistration,
	e_ASNH225RegistrationConfirmOptionMap_terminalAliasPattern,
	e_ASNH225RegistrationConfirmOptionMap_supportedPrefixes,
	e_ASNH225RegistrationConfirmOptionMap_usageSpec,
	e_ASNH225RegistrationConfirmOptionMap_featureServerAlias,
	e_ASNH225RegistrationConfirmOptionMap_capacityReportingSpec,
	e_ASNH225RegistrationConfirmOptionMap_featureSet,
	e_ASNH225RegistrationConfirmOptionMap_genericData
} ASNH225RegistrationConfirmOptionMap;


#define e_ASNH225RegistrationConfirmOptionMapSize 3
#define e_ASNH225RegistrationConfirmOptionMapSizeExt 20
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225NonStandardParameter m_nonStandardData;
	AsnSequenceOf m_callSignalAddress;
	AsnSequenceOf m_terminalAlias;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	/*...,*/
	AsnSequenceOf m_alternateGatekeeper;
	ASNH225TimeToLive m_timeToLive;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnBoolean m_willRespondToIRR;
	ASNH225RegistrationConfirm_preGrantedARQ m_preGrantedARQ;
	AsnBoolean m_maintainConnection;
	AsnSequenceOf m_serviceControl;
	AsnNull m_supportsAdditiveRegistration;
	AsnSequenceOf m_terminalAliasPattern;
	AsnSequenceOf m_supportedPrefixes;
	AsnSequenceOf m_usageSpec;
	ASNH225AliasAddress m_featureServerAlias;
	ASNH225CapacityReportingSpecification m_capacityReportingSpec;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225RegistrationConfirm;
HS_RESULT new_ASNH225RegistrationConfirm( void *pObject );
HS_RESULT delete_ASNH225RegistrationConfirm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RegistrationConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RegistrationConfirm_IncludeOptionField( void *pObject, ASNH225RegistrationConfirmOptionMap pOptionMap );
BOOL	  ASNH225RegistrationConfirm_IsIncludeOptionField( void *pObject, ASNH225RegistrationConfirmOptionMap pOptionMap );
HS_RESULT ASNH225RegistrationConfirm_MakeMold( void *pObject );
HS_RESULT ASNH225RegistrationConfirm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RegistrationConfirm_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RegistrationRejectReason_invalidTerminalAliasesOptionMap_terminalAlias,
	e_ASNH225RegistrationRejectReason_invalidTerminalAliasesOptionMap_terminalAliasPattern,
	e_ASNH225RegistrationRejectReason_invalidTerminalAliasesOptionMap_supportedPrefixes

} ASNH225RegistrationRejectReason_invalidTerminalAliasesOptionMap;


#define e_ASNH225RegistrationRejectReason_invalidTerminalAliasesOptionMapSize 3
#define e_ASNH225RegistrationRejectReason_invalidTerminalAliasesOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_terminalAlias;
	AsnSequenceOf m_terminalAliasPattern;
	AsnSequenceOf m_supportedPrefixes;
	/*...,*/
} ASNH225RegistrationRejectReason_invalidTerminalAliases;
HS_RESULT new_ASNH225RegistrationRejectReason_invalidTerminalAliases( void *pObject );
HS_RESULT delete_ASNH225RegistrationRejectReason_invalidTerminalAliases( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RegistrationRejectReason_invalidTerminalAliases_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RegistrationRejectReason_invalidTerminalAliases_IncludeOptionField( void *pObject, ASNH225RegistrationRejectReason_invalidTerminalAliasesOptionMap pOptionMap );
BOOL	  ASNH225RegistrationRejectReason_invalidTerminalAliases_IsIncludeOptionField( void *pObject, ASNH225RegistrationRejectReason_invalidTerminalAliasesOptionMap pOptionMap );
HS_RESULT ASNH225RegistrationRejectReason_invalidTerminalAliases_MakeMold( void *pObject );
HS_RESULT ASNH225RegistrationRejectReason_invalidTerminalAliases_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RegistrationRejectReason_invalidTerminalAliases_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RegistrationRejectReasonChoice_discoveryRequired,
	e_ASNH225RegistrationRejectReasonChoice_invalidRevision,
	e_ASNH225RegistrationRejectReasonChoice_invalidCallSignalAddress,
	e_ASNH225RegistrationRejectReasonChoice_invalidRASAddress,
	e_ASNH225RegistrationRejectReasonChoice_duplicateAlias,
	e_ASNH225RegistrationRejectReasonChoice_invalidTerminalType,
	e_ASNH225RegistrationRejectReasonChoice_undefinedReason,
	e_ASNH225RegistrationRejectReasonChoice_transportNotSupported
,
	e_ASNH225RegistrationRejectReasonChoice_transportQOSNotSupported,
	e_ASNH225RegistrationRejectReasonChoice_resourceUnavailable,
	e_ASNH225RegistrationRejectReasonChoice_invalidAlias,
	e_ASNH225RegistrationRejectReasonChoice_securityDenial,
	e_ASNH225RegistrationRejectReasonChoice_fullRegistrationRequired,
	e_ASNH225RegistrationRejectReasonChoice_additiveRegistrationNotSupported,
	e_ASNH225RegistrationRejectReasonChoice_invalidTerminalAliases,
	e_ASNH225RegistrationRejectReasonChoice_genericDataReason,
	e_ASNH225RegistrationRejectReasonChoice_neededFeatureNotSupported
} ASNH225RegistrationRejectReasonChoice;


#define e_ASNH225RegistrationRejectReasonChoiceSize		8
#define e_ASNH225RegistrationRejectReasonChoiceSizeExt	17
typedef struct
{
	ASNH225RegistrationRejectReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225RegistrationRejectReason;
HS_RESULT new_ASNH225RegistrationRejectReason( void *pObject );
HS_RESULT delete_ASNH225RegistrationRejectReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RegistrationRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225RegistrationRejectReason_SetChoice( void *pObject, ASNH225RegistrationRejectReasonChoice pChoice );
HS_RESULT ASNH225RegistrationRejectReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225RegistrationRejectReason_MakeMold( void *pObject );
HS_RESULT ASNH225RegistrationRejectReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RegistrationRejectReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RegistrationRejectOptionMap_nonStandardData,
	e_ASNH225RegistrationRejectOptionMap_gatekeeperIdentifier
,
	e_ASNH225RegistrationRejectOptionMap_altGKInfo,
	e_ASNH225RegistrationRejectOptionMap_tokens,
	e_ASNH225RegistrationRejectOptionMap_cryptoTokens,
	e_ASNH225RegistrationRejectOptionMap_integrityCheckValue,
	e_ASNH225RegistrationRejectOptionMap_featureSet,
	e_ASNH225RegistrationRejectOptionMap_genericData
} ASNH225RegistrationRejectOptionMap;


#define e_ASNH225RegistrationRejectOptionMapSize 2
#define e_ASNH225RegistrationRejectOptionMapSizeExt 8
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225RegistrationRejectReason m_rejectReason;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	/*...,*/
	ASNH225AltGKInfo m_altGKInfo;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225RegistrationReject;
HS_RESULT new_ASNH225RegistrationReject( void *pObject );
HS_RESULT delete_ASNH225RegistrationReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RegistrationReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RegistrationReject_IncludeOptionField( void *pObject, ASNH225RegistrationRejectOptionMap pOptionMap );
BOOL	  ASNH225RegistrationReject_IsIncludeOptionField( void *pObject, ASNH225RegistrationRejectOptionMap pOptionMap );
HS_RESULT ASNH225RegistrationReject_MakeMold( void *pObject );
HS_RESULT ASNH225RegistrationReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RegistrationReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225UnregRequestReasonChoice_reregistrationRequired,
	e_ASNH225UnregRequestReasonChoice_ttlExpired,
	e_ASNH225UnregRequestReasonChoice_securityDenial,
	e_ASNH225UnregRequestReasonChoice_undefinedReason
,
	e_ASNH225UnregRequestReasonChoice_maintenance
} ASNH225UnregRequestReasonChoice;


#define e_ASNH225UnregRequestReasonChoiceSize		4
#define e_ASNH225UnregRequestReasonChoiceSizeExt	5
typedef struct
{
	ASNH225UnregRequestReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225UnregRequestReason;
HS_RESULT new_ASNH225UnregRequestReason( void *pObject );
HS_RESULT delete_ASNH225UnregRequestReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225UnregRequestReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225UnregRequestReason_SetChoice( void *pObject, ASNH225UnregRequestReasonChoice pChoice );
HS_RESULT ASNH225UnregRequestReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225UnregRequestReason_MakeMold( void *pObject );
HS_RESULT ASNH225UnregRequestReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225UnregRequestReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225UnregistrationRequestOptionMap_endpointAlias,
	e_ASNH225UnregistrationRequestOptionMap_nonStandardData,
	e_ASNH225UnregistrationRequestOptionMap_endpointIdentifier
,
	e_ASNH225UnregistrationRequestOptionMap_alternateEndpoints,
	e_ASNH225UnregistrationRequestOptionMap_gatekeeperIdentifier,
	e_ASNH225UnregistrationRequestOptionMap_tokens,
	e_ASNH225UnregistrationRequestOptionMap_cryptoTokens,
	e_ASNH225UnregistrationRequestOptionMap_integrityCheckValue,
	e_ASNH225UnregistrationRequestOptionMap_reason,
	e_ASNH225UnregistrationRequestOptionMap_endpointAliasPattern,
	e_ASNH225UnregistrationRequestOptionMap_supportedPrefixes,
	e_ASNH225UnregistrationRequestOptionMap_alternateGatekeeper,
	e_ASNH225UnregistrationRequestOptionMap_genericData
} ASNH225UnregistrationRequestOptionMap;


#define e_ASNH225UnregistrationRequestOptionMapSize 3
#define e_ASNH225UnregistrationRequestOptionMapSizeExt 13
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	AsnSequenceOf m_callSignalAddress;
	AsnSequenceOf m_endpointAlias;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	/*...,*/
	AsnSequenceOf m_alternateEndpoints;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225UnregRequestReason m_reason;
	AsnSequenceOf m_endpointAliasPattern;
	AsnSequenceOf m_supportedPrefixes;
	AsnSequenceOf m_alternateGatekeeper;
	AsnSequenceOf m_genericData;
} ASNH225UnregistrationRequest;
HS_RESULT new_ASNH225UnregistrationRequest( void *pObject );
HS_RESULT delete_ASNH225UnregistrationRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225UnregistrationRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225UnregistrationRequest_IncludeOptionField( void *pObject, ASNH225UnregistrationRequestOptionMap pOptionMap );
BOOL	  ASNH225UnregistrationRequest_IsIncludeOptionField( void *pObject, ASNH225UnregistrationRequestOptionMap pOptionMap );
HS_RESULT ASNH225UnregistrationRequest_MakeMold( void *pObject );
HS_RESULT ASNH225UnregistrationRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225UnregistrationRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225UnregistrationConfirmOptionMap_nonStandardData
,
	e_ASNH225UnregistrationConfirmOptionMap_tokens,
	e_ASNH225UnregistrationConfirmOptionMap_cryptoTokens,
	e_ASNH225UnregistrationConfirmOptionMap_integrityCheckValue,
	e_ASNH225UnregistrationConfirmOptionMap_genericData
} ASNH225UnregistrationConfirmOptionMap;


#define e_ASNH225UnregistrationConfirmOptionMapSize 1
#define e_ASNH225UnregistrationConfirmOptionMapSizeExt 5
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnSequenceOf m_genericData;
} ASNH225UnregistrationConfirm;
HS_RESULT new_ASNH225UnregistrationConfirm( void *pObject );
HS_RESULT delete_ASNH225UnregistrationConfirm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225UnregistrationConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225UnregistrationConfirm_IncludeOptionField( void *pObject, ASNH225UnregistrationConfirmOptionMap pOptionMap );
BOOL	  ASNH225UnregistrationConfirm_IsIncludeOptionField( void *pObject, ASNH225UnregistrationConfirmOptionMap pOptionMap );
HS_RESULT ASNH225UnregistrationConfirm_MakeMold( void *pObject );
HS_RESULT ASNH225UnregistrationConfirm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225UnregistrationConfirm_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225UnregRejectReasonChoice_notCurrentlyRegistered,
	e_ASNH225UnregRejectReasonChoice_callInProgress,
	e_ASNH225UnregRejectReasonChoice_undefinedReason
,
	e_ASNH225UnregRejectReasonChoice_permissionDenied,
	e_ASNH225UnregRejectReasonChoice_securityDenial
} ASNH225UnregRejectReasonChoice;


#define e_ASNH225UnregRejectReasonChoiceSize		3
#define e_ASNH225UnregRejectReasonChoiceSizeExt	5
typedef struct
{
	ASNH225UnregRejectReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225UnregRejectReason;
HS_RESULT new_ASNH225UnregRejectReason( void *pObject );
HS_RESULT delete_ASNH225UnregRejectReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225UnregRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225UnregRejectReason_SetChoice( void *pObject, ASNH225UnregRejectReasonChoice pChoice );
HS_RESULT ASNH225UnregRejectReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225UnregRejectReason_MakeMold( void *pObject );
HS_RESULT ASNH225UnregRejectReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225UnregRejectReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225UnregistrationRejectOptionMap_nonStandardData
,
	e_ASNH225UnregistrationRejectOptionMap_altGKInfo,
	e_ASNH225UnregistrationRejectOptionMap_tokens,
	e_ASNH225UnregistrationRejectOptionMap_cryptoTokens,
	e_ASNH225UnregistrationRejectOptionMap_integrityCheckValue,
	e_ASNH225UnregistrationRejectOptionMap_genericData
} ASNH225UnregistrationRejectOptionMap;


#define e_ASNH225UnregistrationRejectOptionMapSize 1
#define e_ASNH225UnregistrationRejectOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225UnregRejectReason m_rejectReason;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	ASNH225AltGKInfo m_altGKInfo;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnSequenceOf m_genericData;
} ASNH225UnregistrationReject;
HS_RESULT new_ASNH225UnregistrationReject( void *pObject );
HS_RESULT delete_ASNH225UnregistrationReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225UnregistrationReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225UnregistrationReject_IncludeOptionField( void *pObject, ASNH225UnregistrationRejectOptionMap pOptionMap );
BOOL	  ASNH225UnregistrationReject_IsIncludeOptionField( void *pObject, ASNH225UnregistrationRejectOptionMap pOptionMap );
HS_RESULT ASNH225UnregistrationReject_MakeMold( void *pObject );
HS_RESULT ASNH225UnregistrationReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225UnregistrationReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225CallModelChoice_direct,
	e_ASNH225CallModelChoice_gatekeeperRouted

} ASNH225CallModelChoice;


#define e_ASNH225CallModelChoiceSize		2
#define e_ASNH225CallModelChoiceSizeExt	2
typedef struct
{
	ASNH225CallModelChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225CallModel;
HS_RESULT new_ASNH225CallModel( void *pObject );
HS_RESULT delete_ASNH225CallModel( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallModel_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225CallModel_SetChoice( void *pObject, ASNH225CallModelChoice pChoice );
HS_RESULT ASNH225CallModel_DeleteAlternation( void *pObject );
HS_RESULT ASNH225CallModel_MakeMold( void *pObject );
HS_RESULT ASNH225CallModel_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225CallModel_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225TransportQOSChoice_endpointControlled,
	e_ASNH225TransportQOSChoice_gatekeeperControlled,
	e_ASNH225TransportQOSChoice_noControl

} ASNH225TransportQOSChoice;


#define e_ASNH225TransportQOSChoiceSize		3
#define e_ASNH225TransportQOSChoiceSizeExt	3
typedef struct
{
	ASNH225TransportQOSChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225TransportQOS;
HS_RESULT new_ASNH225TransportQOS( void *pObject );
HS_RESULT delete_ASNH225TransportQOS( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TransportQOS_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225TransportQOS_SetChoice( void *pObject, ASNH225TransportQOSChoice pChoice );
HS_RESULT ASNH225TransportQOS_DeleteAlternation( void *pObject );
HS_RESULT ASNH225TransportQOS_MakeMold( void *pObject );
HS_RESULT ASNH225TransportQOS_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225TransportQOS_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225AdmissionRequestOptionMap_callModel,
	e_ASNH225AdmissionRequestOptionMap_destinationInfo,
	e_ASNH225AdmissionRequestOptionMap_destCallSignalAddress,
	e_ASNH225AdmissionRequestOptionMap_destExtraCallInfo,
	e_ASNH225AdmissionRequestOptionMap_srcCallSignalAddress,
	e_ASNH225AdmissionRequestOptionMap_nonStandardData,
	e_ASNH225AdmissionRequestOptionMap_callServices
,
	e_ASNH225AdmissionRequestOptionMap_canMapAlias,
	e_ASNH225AdmissionRequestOptionMap_callIdentifier,
	e_ASNH225AdmissionRequestOptionMap_srcAlternatives,
	e_ASNH225AdmissionRequestOptionMap_destAlternatives,
	e_ASNH225AdmissionRequestOptionMap_gatekeeperIdentifier,
	e_ASNH225AdmissionRequestOptionMap_tokens,
	e_ASNH225AdmissionRequestOptionMap_cryptoTokens,
	e_ASNH225AdmissionRequestOptionMap_integrityCheckValue,
	e_ASNH225AdmissionRequestOptionMap_transportQOS,
	e_ASNH225AdmissionRequestOptionMap_willSupplyUUIEs,
	e_ASNH225AdmissionRequestOptionMap_callLinkage,
	e_ASNH225AdmissionRequestOptionMap_gatewayDataRate,
	e_ASNH225AdmissionRequestOptionMap_capacity,
	e_ASNH225AdmissionRequestOptionMap_circuitInfo,
	e_ASNH225AdmissionRequestOptionMap_desiredProtocols,
	e_ASNH225AdmissionRequestOptionMap_desiredTunnelledProtocol,
	e_ASNH225AdmissionRequestOptionMap_featureSet,
	e_ASNH225AdmissionRequestOptionMap_genericData
} ASNH225AdmissionRequestOptionMap;


#define e_ASNH225AdmissionRequestOptionMapSize 7
#define e_ASNH225AdmissionRequestOptionMapSizeExt 25
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225CallType m_callType;
	ASNH225CallModel m_callModel;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	AsnSequenceOf m_destinationInfo;
	ASNH225TransportAddress m_destCallSignalAddress;
	AsnSequenceOf m_destExtraCallInfo;
	AsnSequenceOf m_srcInfo;
	ASNH225TransportAddress m_srcCallSignalAddress;
	ASNH225BandWidth m_bandWidth;
	ASNH225CallReferenceValue m_callReferenceValue;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225QseriesOptions m_callServices;
	ASNH225ConferenceIdentifier m_conferenceID;
	AsnBoolean m_activeMC;
	AsnBoolean m_answerCall;
	/*...,*/
	AsnBoolean m_canMapAlias;
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_srcAlternatives;
	AsnSequenceOf m_destAlternatives;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225TransportQOS m_transportQOS;
	AsnBoolean m_willSupplyUUIEs;
	ASNH225CallLinkage m_callLinkage;
	ASNH225DataRate m_gatewayDataRate;
	ASNH225CallCapacity m_capacity;
	ASNH225CircuitInfo m_circuitInfo;
	AsnSequenceOf m_desiredProtocols;
	ASNH225TunnelledProtocol m_desiredTunnelledProtocol;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225AdmissionRequest;
HS_RESULT new_ASNH225AdmissionRequest( void *pObject );
HS_RESULT delete_ASNH225AdmissionRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AdmissionRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225AdmissionRequest_IncludeOptionField( void *pObject, ASNH225AdmissionRequestOptionMap pOptionMap );
BOOL	  ASNH225AdmissionRequest_IsIncludeOptionField( void *pObject, ASNH225AdmissionRequestOptionMap pOptionMap );
HS_RESULT ASNH225AdmissionRequest_MakeMold( void *pObject );
HS_RESULT ASNH225AdmissionRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AdmissionRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH225UUIEsRequestedOptionMap_status,
	e_ASNH225UUIEsRequestedOptionMap_statusInquiry,
	e_ASNH225UUIEsRequestedOptionMap_setupAcknowledge,
	e_ASNH225UUIEsRequestedOptionMap_notify
} ASNH225UUIEsRequestedOptionMap;


#define e_ASNH225UUIEsRequestedOptionMapSize 0
#define e_ASNH225UUIEsRequestedOptionMapSizeExt 4
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_setup;
	AsnBoolean m_callProceeding;
	AsnBoolean m_connect;
	AsnBoolean m_alerting;
	AsnBoolean m_information;
	AsnBoolean m_releaseComplete;
	AsnBoolean m_facility;
	AsnBoolean m_progress;
	AsnBoolean m_empty;
	/*...,*/
	AsnBoolean m_status;
	AsnBoolean m_statusInquiry;
	AsnBoolean m_setupAcknowledge;
	AsnBoolean m_notify;
} ASNH225UUIEsRequested;
HS_RESULT new_ASNH225UUIEsRequested( void *pObject );
HS_RESULT delete_ASNH225UUIEsRequested( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225UUIEsRequested_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225UUIEsRequested_IncludeOptionField( void *pObject, ASNH225UUIEsRequestedOptionMap pOptionMap );
BOOL	  ASNH225UUIEsRequested_IsIncludeOptionField( void *pObject, ASNH225UUIEsRequestedOptionMap pOptionMap );
HS_RESULT ASNH225UUIEsRequested_MakeMold( void *pObject );
HS_RESULT ASNH225UUIEsRequested_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225UUIEsRequested_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225AdmissionConfirmOptionMap_irrFrequency,
	e_ASNH225AdmissionConfirmOptionMap_nonStandardData
,
	e_ASNH225AdmissionConfirmOptionMap_destinationInfo,
	e_ASNH225AdmissionConfirmOptionMap_destExtraCallInfo,
	e_ASNH225AdmissionConfirmOptionMap_destinationType,
	e_ASNH225AdmissionConfirmOptionMap_remoteExtensionAddress,
	e_ASNH225AdmissionConfirmOptionMap_alternateEndpoints,
	e_ASNH225AdmissionConfirmOptionMap_tokens,
	e_ASNH225AdmissionConfirmOptionMap_cryptoTokens,
	e_ASNH225AdmissionConfirmOptionMap_integrityCheckValue,
	e_ASNH225AdmissionConfirmOptionMap_transportQOS,
	e_ASNH225AdmissionConfirmOptionMap_willRespondToIRR,
	e_ASNH225AdmissionConfirmOptionMap_uuiesRequested,
	e_ASNH225AdmissionConfirmOptionMap_language,
	e_ASNH225AdmissionConfirmOptionMap_alternateTransportAddresses,
	e_ASNH225AdmissionConfirmOptionMap_useSpecifiedTransport,
	e_ASNH225AdmissionConfirmOptionMap_circuitInfo,
	e_ASNH225AdmissionConfirmOptionMap_usageSpec,
	e_ASNH225AdmissionConfirmOptionMap_supportedProtocols,
	e_ASNH225AdmissionConfirmOptionMap_serviceControl,
	e_ASNH225AdmissionConfirmOptionMap_multipleCalls,
	e_ASNH225AdmissionConfirmOptionMap_featureSet,
	e_ASNH225AdmissionConfirmOptionMap_genericData
} ASNH225AdmissionConfirmOptionMap;


#define e_ASNH225AdmissionConfirmOptionMapSize 2
#define e_ASNH225AdmissionConfirmOptionMapSizeExt 23
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225BandWidth m_bandWidth;
	ASNH225CallModel m_callModel;
	ASNH225TransportAddress m_destCallSignalAddress;
	AsnInteger m_irrFrequency;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_destinationInfo;
	AsnSequenceOf m_destExtraCallInfo;
	ASNH225EndpointType m_destinationType;
	AsnSequenceOf m_remoteExtensionAddress;
	AsnSequenceOf m_alternateEndpoints;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225TransportQOS m_transportQOS;
	AsnBoolean m_willRespondToIRR;
	ASNH225UUIEsRequested m_uuiesRequested;
	AsnSequenceOf m_language;
	ASNH225AlternateTransportAddresses m_alternateTransportAddresses;
	ASNH225UseSpecifiedTransport m_useSpecifiedTransport;
	ASNH225CircuitInfo m_circuitInfo;
	AsnSequenceOf m_usageSpec;
	AsnSequenceOf m_supportedProtocols;
	AsnSequenceOf m_serviceControl;
	AsnBoolean m_multipleCalls;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225AdmissionConfirm;
HS_RESULT new_ASNH225AdmissionConfirm( void *pObject );
HS_RESULT delete_ASNH225AdmissionConfirm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AdmissionConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225AdmissionConfirm_IncludeOptionField( void *pObject, ASNH225AdmissionConfirmOptionMap pOptionMap );
BOOL	  ASNH225AdmissionConfirm_IsIncludeOptionField( void *pObject, ASNH225AdmissionConfirmOptionMap pOptionMap );
HS_RESULT ASNH225AdmissionConfirm_MakeMold( void *pObject );
HS_RESULT ASNH225AdmissionConfirm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AdmissionConfirm_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225AdmissionRejectReasonChoice_calledPartyNotRegistered,
	e_ASNH225AdmissionRejectReasonChoice_invalidPermission,
	e_ASNH225AdmissionRejectReasonChoice_requestDenied,
	e_ASNH225AdmissionRejectReasonChoice_undefinedReason,
	e_ASNH225AdmissionRejectReasonChoice_callerNotRegistered,
	e_ASNH225AdmissionRejectReasonChoice_routeCallToGatekeeper,
	e_ASNH225AdmissionRejectReasonChoice_invalidEndpointIdentifier,
	e_ASNH225AdmissionRejectReasonChoice_resourceUnavailable
,
	e_ASNH225AdmissionRejectReasonChoice_securityDenial,
	e_ASNH225AdmissionRejectReasonChoice_qosControlNotSupported,
	e_ASNH225AdmissionRejectReasonChoice_incompleteAddress,
	e_ASNH225AdmissionRejectReasonChoice_aliasesInconsistent,
	e_ASNH225AdmissionRejectReasonChoice_routeCallToSCN,
	e_ASNH225AdmissionRejectReasonChoice_exceedsCallCapacity,
	e_ASNH225AdmissionRejectReasonChoice_collectDestination,
	e_ASNH225AdmissionRejectReasonChoice_collectPIN,
	e_ASNH225AdmissionRejectReasonChoice_genericDataReason,
	e_ASNH225AdmissionRejectReasonChoice_neededFeatureNotSupported
} ASNH225AdmissionRejectReasonChoice;


#define e_ASNH225AdmissionRejectReasonChoiceSize		8
#define e_ASNH225AdmissionRejectReasonChoiceSizeExt	18
typedef struct
{
	ASNH225AdmissionRejectReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225AdmissionRejectReason;
HS_RESULT new_ASNH225AdmissionRejectReason( void *pObject );
HS_RESULT delete_ASNH225AdmissionRejectReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AdmissionRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225AdmissionRejectReason_SetChoice( void *pObject, ASNH225AdmissionRejectReasonChoice pChoice );
HS_RESULT ASNH225AdmissionRejectReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225AdmissionRejectReason_MakeMold( void *pObject );
HS_RESULT ASNH225AdmissionRejectReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AdmissionRejectReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225AdmissionRejectOptionMap_nonStandardData
,
	e_ASNH225AdmissionRejectOptionMap_altGKInfo,
	e_ASNH225AdmissionRejectOptionMap_tokens,
	e_ASNH225AdmissionRejectOptionMap_cryptoTokens,
	e_ASNH225AdmissionRejectOptionMap_callSignalAddress,
	e_ASNH225AdmissionRejectOptionMap_integrityCheckValue,
	e_ASNH225AdmissionRejectOptionMap_serviceControl,
	e_ASNH225AdmissionRejectOptionMap_featureSet,
	e_ASNH225AdmissionRejectOptionMap_genericData
} ASNH225AdmissionRejectOptionMap;


#define e_ASNH225AdmissionRejectOptionMapSize 1
#define e_ASNH225AdmissionRejectOptionMapSizeExt 9
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225AdmissionRejectReason m_rejectReason;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	ASNH225AltGKInfo m_altGKInfo;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_callSignalAddress;
	ASNH225ICV m_integrityCheckValue;
	AsnSequenceOf m_serviceControl;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225AdmissionReject;
HS_RESULT new_ASNH225AdmissionReject( void *pObject );
HS_RESULT delete_ASNH225AdmissionReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225AdmissionReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225AdmissionReject_IncludeOptionField( void *pObject, ASNH225AdmissionRejectOptionMap pOptionMap );
BOOL	  ASNH225AdmissionReject_IsIncludeOptionField( void *pObject, ASNH225AdmissionRejectOptionMap pOptionMap );
HS_RESULT ASNH225AdmissionReject_MakeMold( void *pObject );
HS_RESULT ASNH225AdmissionReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225AdmissionReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225BandwidthRequestOptionMap_callType,
	e_ASNH225BandwidthRequestOptionMap_nonStandardData
,
	e_ASNH225BandwidthRequestOptionMap_callIdentifier,
	e_ASNH225BandwidthRequestOptionMap_gatekeeperIdentifier,
	e_ASNH225BandwidthRequestOptionMap_tokens,
	e_ASNH225BandwidthRequestOptionMap_cryptoTokens,
	e_ASNH225BandwidthRequestOptionMap_integrityCheckValue,
	e_ASNH225BandwidthRequestOptionMap_answeredCall,
	e_ASNH225BandwidthRequestOptionMap_callLinkage,
	e_ASNH225BandwidthRequestOptionMap_capacity,
	e_ASNH225BandwidthRequestOptionMap_usageInformation,
	e_ASNH225BandwidthRequestOptionMap_bandwidthDetails,
	e_ASNH225BandwidthRequestOptionMap_genericData
} ASNH225BandwidthRequestOptionMap;


#define e_ASNH225BandwidthRequestOptionMapSize 2
#define e_ASNH225BandwidthRequestOptionMapSizeExt 13
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	ASNH225ConferenceIdentifier m_conferenceID;
	ASNH225CallReferenceValue m_callReferenceValue;
	ASNH225CallType m_callType;
	ASNH225BandWidth m_bandWidth;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnBoolean m_answeredCall;
	ASNH225CallLinkage m_callLinkage;
	ASNH225CallCapacity m_capacity;
	ASNH225RasUsageInformation m_usageInformation;
	AsnSequenceOf m_bandwidthDetails;
	AsnSequenceOf m_genericData;
} ASNH225BandwidthRequest;
HS_RESULT new_ASNH225BandwidthRequest( void *pObject );
HS_RESULT delete_ASNH225BandwidthRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225BandwidthRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225BandwidthRequest_IncludeOptionField( void *pObject, ASNH225BandwidthRequestOptionMap pOptionMap );
BOOL	  ASNH225BandwidthRequest_IsIncludeOptionField( void *pObject, ASNH225BandwidthRequestOptionMap pOptionMap );
HS_RESULT ASNH225BandwidthRequest_MakeMold( void *pObject );
HS_RESULT ASNH225BandwidthRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225BandwidthRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225BandwidthConfirmOptionMap_nonStandardData
,
	e_ASNH225BandwidthConfirmOptionMap_tokens,
	e_ASNH225BandwidthConfirmOptionMap_cryptoTokens,
	e_ASNH225BandwidthConfirmOptionMap_integrityCheckValue,
	e_ASNH225BandwidthConfirmOptionMap_capacity,
	e_ASNH225BandwidthConfirmOptionMap_genericData
} ASNH225BandwidthConfirmOptionMap;


#define e_ASNH225BandwidthConfirmOptionMapSize 1
#define e_ASNH225BandwidthConfirmOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225BandWidth m_bandWidth;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225CallCapacity m_capacity;
	AsnSequenceOf m_genericData;
} ASNH225BandwidthConfirm;
HS_RESULT new_ASNH225BandwidthConfirm( void *pObject );
HS_RESULT delete_ASNH225BandwidthConfirm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225BandwidthConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225BandwidthConfirm_IncludeOptionField( void *pObject, ASNH225BandwidthConfirmOptionMap pOptionMap );
BOOL	  ASNH225BandwidthConfirm_IsIncludeOptionField( void *pObject, ASNH225BandwidthConfirmOptionMap pOptionMap );
HS_RESULT ASNH225BandwidthConfirm_MakeMold( void *pObject );
HS_RESULT ASNH225BandwidthConfirm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225BandwidthConfirm_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225BandRejectReasonChoice_notBound,
	e_ASNH225BandRejectReasonChoice_invalidConferenceID,
	e_ASNH225BandRejectReasonChoice_invalidPermission,
	e_ASNH225BandRejectReasonChoice_insufficientResources,
	e_ASNH225BandRejectReasonChoice_invalidRevision,
	e_ASNH225BandRejectReasonChoice_undefinedReason
,
	e_ASNH225BandRejectReasonChoice_securityDenial
} ASNH225BandRejectReasonChoice;


#define e_ASNH225BandRejectReasonChoiceSize		6
#define e_ASNH225BandRejectReasonChoiceSizeExt	7
typedef struct
{
	ASNH225BandRejectReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225BandRejectReason;
HS_RESULT new_ASNH225BandRejectReason( void *pObject );
HS_RESULT delete_ASNH225BandRejectReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225BandRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225BandRejectReason_SetChoice( void *pObject, ASNH225BandRejectReasonChoice pChoice );
HS_RESULT ASNH225BandRejectReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225BandRejectReason_MakeMold( void *pObject );
HS_RESULT ASNH225BandRejectReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225BandRejectReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225BandwidthRejectOptionMap_nonStandardData
,
	e_ASNH225BandwidthRejectOptionMap_altGKInfo,
	e_ASNH225BandwidthRejectOptionMap_tokens,
	e_ASNH225BandwidthRejectOptionMap_cryptoTokens,
	e_ASNH225BandwidthRejectOptionMap_integrityCheckValue,
	e_ASNH225BandwidthRejectOptionMap_genericData
} ASNH225BandwidthRejectOptionMap;


#define e_ASNH225BandwidthRejectOptionMapSize 1
#define e_ASNH225BandwidthRejectOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225BandRejectReason m_rejectReason;
	ASNH225BandWidth m_allowedBandWidth;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	ASNH225AltGKInfo m_altGKInfo;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnSequenceOf m_genericData;
} ASNH225BandwidthReject;
HS_RESULT new_ASNH225BandwidthReject( void *pObject );
HS_RESULT delete_ASNH225BandwidthReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225BandwidthReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225BandwidthReject_IncludeOptionField( void *pObject, ASNH225BandwidthRejectOptionMap pOptionMap );
BOOL	  ASNH225BandwidthReject_IsIncludeOptionField( void *pObject, ASNH225BandwidthRejectOptionMap pOptionMap );
HS_RESULT ASNH225BandwidthReject_MakeMold( void *pObject );
HS_RESULT ASNH225BandwidthReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225BandwidthReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225DisengageReasonChoice_forcedDrop,
	e_ASNH225DisengageReasonChoice_normalDrop,
	e_ASNH225DisengageReasonChoice_undefinedReason

} ASNH225DisengageReasonChoice;


#define e_ASNH225DisengageReasonChoiceSize		3
#define e_ASNH225DisengageReasonChoiceSizeExt	3
typedef struct
{
	ASNH225DisengageReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225DisengageReason;
HS_RESULT new_ASNH225DisengageReason( void *pObject );
HS_RESULT delete_ASNH225DisengageReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225DisengageReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225DisengageReason_SetChoice( void *pObject, ASNH225DisengageReasonChoice pChoice );
HS_RESULT ASNH225DisengageReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225DisengageReason_MakeMold( void *pObject );
HS_RESULT ASNH225DisengageReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225DisengageReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225DisengageRequestOptionMap_nonStandardData
,
	e_ASNH225DisengageRequestOptionMap_callIdentifier,
	e_ASNH225DisengageRequestOptionMap_gatekeeperIdentifier,
	e_ASNH225DisengageRequestOptionMap_tokens,
	e_ASNH225DisengageRequestOptionMap_cryptoTokens,
	e_ASNH225DisengageRequestOptionMap_integrityCheckValue,
	e_ASNH225DisengageRequestOptionMap_answeredCall,
	e_ASNH225DisengageRequestOptionMap_callLinkage,
	e_ASNH225DisengageRequestOptionMap_capacity,
	e_ASNH225DisengageRequestOptionMap_circuitInfo,
	e_ASNH225DisengageRequestOptionMap_usageInformation,
	e_ASNH225DisengageRequestOptionMap_terminationCause,
	e_ASNH225DisengageRequestOptionMap_serviceControl,
	e_ASNH225DisengageRequestOptionMap_genericData
} ASNH225DisengageRequestOptionMap;


#define e_ASNH225DisengageRequestOptionMapSize 1
#define e_ASNH225DisengageRequestOptionMapSizeExt 14
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	ASNH225ConferenceIdentifier m_conferenceID;
	ASNH225CallReferenceValue m_callReferenceValue;
	ASNH225DisengageReason m_disengageReason;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnBoolean m_answeredCall;
	ASNH225CallLinkage m_callLinkage;
	ASNH225CallCapacity m_capacity;
	ASNH225CircuitInfo m_circuitInfo;
	ASNH225RasUsageInformation m_usageInformation;
	ASNH225CallTerminationCause m_terminationCause;
	AsnSequenceOf m_serviceControl;
	AsnSequenceOf m_genericData;
} ASNH225DisengageRequest;
HS_RESULT new_ASNH225DisengageRequest( void *pObject );
HS_RESULT delete_ASNH225DisengageRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225DisengageRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225DisengageRequest_IncludeOptionField( void *pObject, ASNH225DisengageRequestOptionMap pOptionMap );
BOOL	  ASNH225DisengageRequest_IsIncludeOptionField( void *pObject, ASNH225DisengageRequestOptionMap pOptionMap );
HS_RESULT ASNH225DisengageRequest_MakeMold( void *pObject );
HS_RESULT ASNH225DisengageRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225DisengageRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225DisengageConfirmOptionMap_nonStandardData
,
	e_ASNH225DisengageConfirmOptionMap_tokens,
	e_ASNH225DisengageConfirmOptionMap_cryptoTokens,
	e_ASNH225DisengageConfirmOptionMap_integrityCheckValue,
	e_ASNH225DisengageConfirmOptionMap_capacity,
	e_ASNH225DisengageConfirmOptionMap_circuitInfo,
	e_ASNH225DisengageConfirmOptionMap_usageInformation,
	e_ASNH225DisengageConfirmOptionMap_genericData
} ASNH225DisengageConfirmOptionMap;


#define e_ASNH225DisengageConfirmOptionMapSize 1
#define e_ASNH225DisengageConfirmOptionMapSizeExt 8
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225CallCapacity m_capacity;
	ASNH225CircuitInfo m_circuitInfo;
	ASNH225RasUsageInformation m_usageInformation;
	AsnSequenceOf m_genericData;
} ASNH225DisengageConfirm;
HS_RESULT new_ASNH225DisengageConfirm( void *pObject );
HS_RESULT delete_ASNH225DisengageConfirm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225DisengageConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225DisengageConfirm_IncludeOptionField( void *pObject, ASNH225DisengageConfirmOptionMap pOptionMap );
BOOL	  ASNH225DisengageConfirm_IsIncludeOptionField( void *pObject, ASNH225DisengageConfirmOptionMap pOptionMap );
HS_RESULT ASNH225DisengageConfirm_MakeMold( void *pObject );
HS_RESULT ASNH225DisengageConfirm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225DisengageConfirm_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225DisengageRejectReasonChoice_notRegistered,
	e_ASNH225DisengageRejectReasonChoice_requestToDropOther
,
	e_ASNH225DisengageRejectReasonChoice_securityDenial
} ASNH225DisengageRejectReasonChoice;


#define e_ASNH225DisengageRejectReasonChoiceSize		2
#define e_ASNH225DisengageRejectReasonChoiceSizeExt	3
typedef struct
{
	ASNH225DisengageRejectReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225DisengageRejectReason;
HS_RESULT new_ASNH225DisengageRejectReason( void *pObject );
HS_RESULT delete_ASNH225DisengageRejectReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225DisengageRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225DisengageRejectReason_SetChoice( void *pObject, ASNH225DisengageRejectReasonChoice pChoice );
HS_RESULT ASNH225DisengageRejectReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225DisengageRejectReason_MakeMold( void *pObject );
HS_RESULT ASNH225DisengageRejectReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225DisengageRejectReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225DisengageRejectOptionMap_nonStandardData
,
	e_ASNH225DisengageRejectOptionMap_altGKInfo,
	e_ASNH225DisengageRejectOptionMap_tokens,
	e_ASNH225DisengageRejectOptionMap_cryptoTokens,
	e_ASNH225DisengageRejectOptionMap_integrityCheckValue,
	e_ASNH225DisengageRejectOptionMap_genericData
} ASNH225DisengageRejectOptionMap;


#define e_ASNH225DisengageRejectOptionMapSize 1
#define e_ASNH225DisengageRejectOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225DisengageRejectReason m_rejectReason;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	ASNH225AltGKInfo m_altGKInfo;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnSequenceOf m_genericData;
} ASNH225DisengageReject;
HS_RESULT new_ASNH225DisengageReject( void *pObject );
HS_RESULT delete_ASNH225DisengageReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225DisengageReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225DisengageReject_IncludeOptionField( void *pObject, ASNH225DisengageRejectOptionMap pOptionMap );
BOOL	  ASNH225DisengageReject_IsIncludeOptionField( void *pObject, ASNH225DisengageRejectOptionMap pOptionMap );
HS_RESULT ASNH225DisengageReject_MakeMold( void *pObject );
HS_RESULT ASNH225DisengageReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225DisengageReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225LocationRequestOptionMap_endpointIdentifier,
	e_ASNH225LocationRequestOptionMap_nonStandardData
,
	e_ASNH225LocationRequestOptionMap_sourceInfo,
	e_ASNH225LocationRequestOptionMap_canMapAlias,
	e_ASNH225LocationRequestOptionMap_gatekeeperIdentifier,
	e_ASNH225LocationRequestOptionMap_tokens,
	e_ASNH225LocationRequestOptionMap_cryptoTokens,
	e_ASNH225LocationRequestOptionMap_integrityCheckValue,
	e_ASNH225LocationRequestOptionMap_desiredProtocols,
	e_ASNH225LocationRequestOptionMap_desiredTunnelledProtocol,
	e_ASNH225LocationRequestOptionMap_featureSet,
	e_ASNH225LocationRequestOptionMap_genericData,
	e_ASNH225LocationRequestOptionMap_hopCount,
	e_ASNH225LocationRequestOptionMap_circuitInfo
} ASNH225LocationRequestOptionMap;


#define e_ASNH225LocationRequestOptionMapSize 2
#define e_ASNH225LocationRequestOptionMapSizeExt 14
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	AsnSequenceOf m_destinationInfo;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225TransportAddress m_replyAddress;
	/*...,*/
	AsnSequenceOf m_sourceInfo;
	AsnBoolean m_canMapAlias;
	ASNH225GatekeeperIdentifier m_gatekeeperIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnSequenceOf m_desiredProtocols;
	ASNH225TunnelledProtocol m_desiredTunnelledProtocol;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
	AsnInteger m_hopCount;
	ASNH225CircuitInfo m_circuitInfo;
} ASNH225LocationRequest;
HS_RESULT new_ASNH225LocationRequest( void *pObject );
HS_RESULT delete_ASNH225LocationRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225LocationRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225LocationRequest_IncludeOptionField( void *pObject, ASNH225LocationRequestOptionMap pOptionMap );
BOOL	  ASNH225LocationRequest_IsIncludeOptionField( void *pObject, ASNH225LocationRequestOptionMap pOptionMap );
HS_RESULT ASNH225LocationRequest_MakeMold( void *pObject );
HS_RESULT ASNH225LocationRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225LocationRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225LocationConfirmOptionMap_nonStandardData
,
	e_ASNH225LocationConfirmOptionMap_destinationInfo,
	e_ASNH225LocationConfirmOptionMap_destExtraCallInfo,
	e_ASNH225LocationConfirmOptionMap_destinationType,
	e_ASNH225LocationConfirmOptionMap_remoteExtensionAddress,
	e_ASNH225LocationConfirmOptionMap_alternateEndpoints,
	e_ASNH225LocationConfirmOptionMap_tokens,
	e_ASNH225LocationConfirmOptionMap_cryptoTokens,
	e_ASNH225LocationConfirmOptionMap_integrityCheckValue,
	e_ASNH225LocationConfirmOptionMap_alternateTransportAddresses,
	e_ASNH225LocationConfirmOptionMap_supportedProtocols,
	e_ASNH225LocationConfirmOptionMap_multipleCalls,
	e_ASNH225LocationConfirmOptionMap_featureSet,
	e_ASNH225LocationConfirmOptionMap_genericData,
	e_ASNH225LocationConfirmOptionMap_circuitInfo,
	e_ASNH225LocationConfirmOptionMap_serviceControl
} ASNH225LocationConfirmOptionMap;


#define e_ASNH225LocationConfirmOptionMapSize 1
#define e_ASNH225LocationConfirmOptionMapSizeExt 16
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225TransportAddress m_callSignalAddress;
	ASNH225TransportAddress m_rasAddress;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_destinationInfo;
	AsnSequenceOf m_destExtraCallInfo;
	ASNH225EndpointType m_destinationType;
	AsnSequenceOf m_remoteExtensionAddress;
	AsnSequenceOf m_alternateEndpoints;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225AlternateTransportAddresses m_alternateTransportAddresses;
	AsnSequenceOf m_supportedProtocols;
	AsnBoolean m_multipleCalls;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
	ASNH225CircuitInfo m_circuitInfo;
	AsnSequenceOf m_serviceControl;
} ASNH225LocationConfirm;
HS_RESULT new_ASNH225LocationConfirm( void *pObject );
HS_RESULT delete_ASNH225LocationConfirm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225LocationConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225LocationConfirm_IncludeOptionField( void *pObject, ASNH225LocationConfirmOptionMap pOptionMap );
BOOL	  ASNH225LocationConfirm_IsIncludeOptionField( void *pObject, ASNH225LocationConfirmOptionMap pOptionMap );
HS_RESULT ASNH225LocationConfirm_MakeMold( void *pObject );
HS_RESULT ASNH225LocationConfirm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225LocationConfirm_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225LocationRejectReasonChoice_notRegistered,
	e_ASNH225LocationRejectReasonChoice_invalidPermission,
	e_ASNH225LocationRejectReasonChoice_requestDenied,
	e_ASNH225LocationRejectReasonChoice_undefinedReason
,
	e_ASNH225LocationRejectReasonChoice_securityDenial,
	e_ASNH225LocationRejectReasonChoice_aliasesInconsistent,
	e_ASNH225LocationRejectReasonChoice_routeCalltoSCN,
	e_ASNH225LocationRejectReasonChoice_resourceUnavailable,
	e_ASNH225LocationRejectReasonChoice_genericDataReason,
	e_ASNH225LocationRejectReasonChoice_neededFeatureNotSupported
} ASNH225LocationRejectReasonChoice;


#define e_ASNH225LocationRejectReasonChoiceSize		4
#define e_ASNH225LocationRejectReasonChoiceSizeExt	10
typedef struct
{
	ASNH225LocationRejectReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225LocationRejectReason;
HS_RESULT new_ASNH225LocationRejectReason( void *pObject );
HS_RESULT delete_ASNH225LocationRejectReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225LocationRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225LocationRejectReason_SetChoice( void *pObject, ASNH225LocationRejectReasonChoice pChoice );
HS_RESULT ASNH225LocationRejectReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225LocationRejectReason_MakeMold( void *pObject );
HS_RESULT ASNH225LocationRejectReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225LocationRejectReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225LocationRejectOptionMap_nonStandardData
,
	e_ASNH225LocationRejectOptionMap_altGKInfo,
	e_ASNH225LocationRejectOptionMap_tokens,
	e_ASNH225LocationRejectOptionMap_cryptoTokens,
	e_ASNH225LocationRejectOptionMap_integrityCheckValue,
	e_ASNH225LocationRejectOptionMap_featureSet,
	e_ASNH225LocationRejectOptionMap_genericData,
	e_ASNH225LocationRejectOptionMap_serviceControl
} ASNH225LocationRejectOptionMap;


#define e_ASNH225LocationRejectOptionMapSize 1
#define e_ASNH225LocationRejectOptionMapSizeExt 8
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225LocationRejectReason m_rejectReason;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	ASNH225AltGKInfo m_altGKInfo;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
	AsnSequenceOf m_serviceControl;
} ASNH225LocationReject;
HS_RESULT new_ASNH225LocationReject( void *pObject );
HS_RESULT delete_ASNH225LocationReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225LocationReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225LocationReject_IncludeOptionField( void *pObject, ASNH225LocationRejectOptionMap pOptionMap );
BOOL	  ASNH225LocationReject_IsIncludeOptionField( void *pObject, ASNH225LocationRejectOptionMap pOptionMap );
HS_RESULT ASNH225LocationReject_MakeMold( void *pObject );
HS_RESULT ASNH225LocationReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225LocationReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225InfoRequestOptionMap_nonStandardData,
	e_ASNH225InfoRequestOptionMap_replyAddress
,
	e_ASNH225InfoRequestOptionMap_callIdentifier,
	e_ASNH225InfoRequestOptionMap_tokens,
	e_ASNH225InfoRequestOptionMap_cryptoTokens,
	e_ASNH225InfoRequestOptionMap_integrityCheckValue,
	e_ASNH225InfoRequestOptionMap_uuiesRequested,
	e_ASNH225InfoRequestOptionMap_callLinkage,
	e_ASNH225InfoRequestOptionMap_usageInfoRequested,
	e_ASNH225InfoRequestOptionMap_segmentedResponseSupported,
	e_ASNH225InfoRequestOptionMap_nextSegmentRequested,
	e_ASNH225InfoRequestOptionMap_capacityInfoRequested,
	e_ASNH225InfoRequestOptionMap_genericData
} ASNH225InfoRequestOptionMap;


#define e_ASNH225InfoRequestOptionMapSize 2
#define e_ASNH225InfoRequestOptionMapSizeExt 13
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225CallReferenceValue m_callReferenceValue;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225TransportAddress m_replyAddress;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225UUIEsRequested m_uuiesRequested;
	ASNH225CallLinkage m_callLinkage;
	ASNH225RasUsageInfoTypes m_usageInfoRequested;
	AsnNull m_segmentedResponseSupported;
	AsnInteger m_nextSegmentRequested;
	AsnNull m_capacityInfoRequested;
	AsnSequenceOf m_genericData;
} ASNH225InfoRequest;
HS_RESULT new_ASNH225InfoRequest( void *pObject );
HS_RESULT delete_ASNH225InfoRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225InfoRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225InfoRequest_IncludeOptionField( void *pObject, ASNH225InfoRequestOptionMap pOptionMap );
BOOL	  ASNH225InfoRequest_IsIncludeOptionField( void *pObject, ASNH225InfoRequestOptionMap pOptionMap );
HS_RESULT ASNH225InfoRequest_MakeMold( void *pObject );
HS_RESULT ASNH225InfoRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225InfoRequest_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225InfoRequestResponse_perCallInfo_pduOptionMapSize 0
#define e_ASNH225InfoRequestResponse_perCallInfo_pduOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH225H323_UU_PDU m_h323pdu;
	AsnBoolean m_sent;
} ASNH225InfoRequestResponse_perCallInfo_pdu;
HS_RESULT new_ASNH225InfoRequestResponse_perCallInfo_pdu( void *pObject );
HS_RESULT delete_ASNH225InfoRequestResponse_perCallInfo_pdu( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_pdu_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_pdu_MakeMold( void *pObject );
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_pdu_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_pdu_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_nonStandardData,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_originator,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_audio,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_video,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_data
,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_callIdentifier,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_tokens,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_cryptoTokens,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_substituteConfIDs,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_pdu,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_callLinkage,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_usageInformation,
	e_ASNH225InfoRequestResponse_perCallInfoOptionMap_circuitInfo
} ASNH225InfoRequestResponse_perCallInfoOptionMap;


#define e_ASNH225InfoRequestResponse_perCallInfoOptionMapSize 5
#define e_ASNH225InfoRequestResponse_perCallInfoOptionMapSizeExt 13
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225CallReferenceValue m_callReferenceValue;
	ASNH225ConferenceIdentifier m_conferenceID;
	AsnBoolean m_originator;
	AsnSequenceOf m_audio;
	AsnSequenceOf m_video;
	AsnSequenceOf m_data;
	ASNH225TransportChannelInfo m_h245;
	ASNH225TransportChannelInfo m_callSignaling;
	ASNH225CallType m_callType;
	ASNH225BandWidth m_bandWidth;
	ASNH225CallModel m_callModel;
	/*...,*/
	ASNH225CallIdentifier m_callIdentifier;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	AsnSequenceOf m_substituteConfIDs;
	AsnSequenceOf m_pdu;
	ASNH225CallLinkage m_callLinkage;
	ASNH225RasUsageInformation m_usageInformation;
	ASNH225CircuitInfo m_circuitInfo;
} ASNH225InfoRequestResponse_perCallInfo;
HS_RESULT new_ASNH225InfoRequestResponse_perCallInfo( void *pObject );
HS_RESULT delete_ASNH225InfoRequestResponse_perCallInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_IncludeOptionField( void *pObject, ASNH225InfoRequestResponse_perCallInfoOptionMap pOptionMap );
BOOL	  ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( void *pObject, ASNH225InfoRequestResponse_perCallInfoOptionMap pOptionMap );
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_MakeMold( void *pObject );
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225InfoRequestResponseStatusChoice_complete,
	e_ASNH225InfoRequestResponseStatusChoice_incomplete,
	e_ASNH225InfoRequestResponseStatusChoice_segment,
	e_ASNH225InfoRequestResponseStatusChoice_invalidCall

} ASNH225InfoRequestResponseStatusChoice;


#define e_ASNH225InfoRequestResponseStatusChoiceSize		4
#define e_ASNH225InfoRequestResponseStatusChoiceSizeExt	4
typedef struct
{
	ASNH225InfoRequestResponseStatusChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225InfoRequestResponseStatus;
HS_RESULT new_ASNH225InfoRequestResponseStatus( void *pObject );
HS_RESULT delete_ASNH225InfoRequestResponseStatus( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225InfoRequestResponseStatus_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225InfoRequestResponseStatus_SetChoice( void *pObject, ASNH225InfoRequestResponseStatusChoice pChoice );
HS_RESULT ASNH225InfoRequestResponseStatus_DeleteAlternation( void *pObject );
HS_RESULT ASNH225InfoRequestResponseStatus_MakeMold( void *pObject );
HS_RESULT ASNH225InfoRequestResponseStatus_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225InfoRequestResponseStatus_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225InfoRequestResponseOptionMap_nonStandardData,
	e_ASNH225InfoRequestResponseOptionMap_endpointAlias,
	e_ASNH225InfoRequestResponseOptionMap_perCallInfo
,
	e_ASNH225InfoRequestResponseOptionMap_tokens,
	e_ASNH225InfoRequestResponseOptionMap_cryptoTokens,
	e_ASNH225InfoRequestResponseOptionMap_integrityCheckValue,
	e_ASNH225InfoRequestResponseOptionMap_needResponse,
	e_ASNH225InfoRequestResponseOptionMap_capacity,
	e_ASNH225InfoRequestResponseOptionMap_irrStatus,
	e_ASNH225InfoRequestResponseOptionMap_unsolicited,
	e_ASNH225InfoRequestResponseOptionMap_genericData
} ASNH225InfoRequestResponseOptionMap;


#define e_ASNH225InfoRequestResponseOptionMapSize 3
#define e_ASNH225InfoRequestResponseOptionMapSizeExt 11
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225EndpointType m_endpointType;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	ASNH225TransportAddress m_rasAddress;
	AsnSequenceOf m_callSignalAddress;
	AsnSequenceOf m_endpointAlias;
	AsnSequenceOf m_perCallInfo;
	/*...,*/
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnBoolean m_needResponse;
	ASNH225CallCapacity m_capacity;
	ASNH225InfoRequestResponseStatus m_irrStatus;
	AsnBoolean m_unsolicited;
	AsnSequenceOf m_genericData;
} ASNH225InfoRequestResponse;
HS_RESULT new_ASNH225InfoRequestResponse( void *pObject );
HS_RESULT delete_ASNH225InfoRequestResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225InfoRequestResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225InfoRequestResponse_IncludeOptionField( void *pObject, ASNH225InfoRequestResponseOptionMap pOptionMap );
BOOL	  ASNH225InfoRequestResponse_IsIncludeOptionField( void *pObject, ASNH225InfoRequestResponseOptionMap pOptionMap );
HS_RESULT ASNH225InfoRequestResponse_MakeMold( void *pObject );
HS_RESULT ASNH225InfoRequestResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225InfoRequestResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH225NonStandardMessageOptionMap_tokens,
	e_ASNH225NonStandardMessageOptionMap_cryptoTokens,
	e_ASNH225NonStandardMessageOptionMap_integrityCheckValue,
	e_ASNH225NonStandardMessageOptionMap_featureSet,
	e_ASNH225NonStandardMessageOptionMap_genericData
} ASNH225NonStandardMessageOptionMap;


#define e_ASNH225NonStandardMessageOptionMapSize 0
#define e_ASNH225NonStandardMessageOptionMapSizeExt 5
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225NonStandardParameter m_nonStandardData;
	/*...,*/
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
} ASNH225NonStandardMessage;
HS_RESULT new_ASNH225NonStandardMessage( void *pObject );
HS_RESULT delete_ASNH225NonStandardMessage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225NonStandardMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225NonStandardMessage_IncludeOptionField( void *pObject, ASNH225NonStandardMessageOptionMap pOptionMap );
BOOL	  ASNH225NonStandardMessage_IsIncludeOptionField( void *pObject, ASNH225NonStandardMessageOptionMap pOptionMap );
HS_RESULT ASNH225NonStandardMessage_MakeMold( void *pObject );
HS_RESULT ASNH225NonStandardMessage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225NonStandardMessage_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH225UnknownMessageResponseOptionMap_tokens,
	e_ASNH225UnknownMessageResponseOptionMap_cryptoTokens,
	e_ASNH225UnknownMessageResponseOptionMap_integrityCheckValue,
	e_ASNH225UnknownMessageResponseOptionMap_messageNotUnderstood
} ASNH225UnknownMessageResponseOptionMap;


#define e_ASNH225UnknownMessageResponseOptionMapSize 0
#define e_ASNH225UnknownMessageResponseOptionMapSizeExt 4
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	/*...,*/
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnOctetString m_messageNotUnderstood;
} ASNH225UnknownMessageResponse;
HS_RESULT new_ASNH225UnknownMessageResponse( void *pObject );
HS_RESULT delete_ASNH225UnknownMessageResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225UnknownMessageResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225UnknownMessageResponse_IncludeOptionField( void *pObject, ASNH225UnknownMessageResponseOptionMap pOptionMap );
BOOL	  ASNH225UnknownMessageResponse_IsIncludeOptionField( void *pObject, ASNH225UnknownMessageResponseOptionMap pOptionMap );
HS_RESULT ASNH225UnknownMessageResponse_MakeMold( void *pObject );
HS_RESULT ASNH225UnknownMessageResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225UnknownMessageResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RequestInProgressOptionMap_nonStandardData,
	e_ASNH225RequestInProgressOptionMap_tokens,
	e_ASNH225RequestInProgressOptionMap_cryptoTokens,
	e_ASNH225RequestInProgressOptionMap_integrityCheckValue

} ASNH225RequestInProgressOptionMap;


#define e_ASNH225RequestInProgressOptionMapSize 4
#define e_ASNH225RequestInProgressOptionMapSizeExt 4
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225NonStandardParameter m_nonStandardData;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	AsnInteger m_delay;
	/*...,*/
} ASNH225RequestInProgress;
HS_RESULT new_ASNH225RequestInProgress( void *pObject );
HS_RESULT delete_ASNH225RequestInProgress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RequestInProgress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225RequestInProgress_IncludeOptionField( void *pObject, ASNH225RequestInProgressOptionMap pOptionMap );
BOOL	  ASNH225RequestInProgress_IsIncludeOptionField( void *pObject, ASNH225RequestInProgressOptionMap pOptionMap );
HS_RESULT ASNH225RequestInProgress_MakeMold( void *pObject );
HS_RESULT ASNH225RequestInProgress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RequestInProgress_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ResourcesAvailableIndicateOptionMap_nonStandardData,
	e_ASNH225ResourcesAvailableIndicateOptionMap_tokens,
	e_ASNH225ResourcesAvailableIndicateOptionMap_cryptoTokens,
	e_ASNH225ResourcesAvailableIndicateOptionMap_integrityCheckValue
,
	e_ASNH225ResourcesAvailableIndicateOptionMap_capacity,
	e_ASNH225ResourcesAvailableIndicateOptionMap_genericData
} ASNH225ResourcesAvailableIndicateOptionMap;


#define e_ASNH225ResourcesAvailableIndicateOptionMapSize 4
#define e_ASNH225ResourcesAvailableIndicateOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	AsnSequenceOf m_protocols;
	AsnBoolean m_almostOutOfResources;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	/*...,*/
	ASNH225CallCapacity m_capacity;
	AsnSequenceOf m_genericData;
} ASNH225ResourcesAvailableIndicate;
HS_RESULT new_ASNH225ResourcesAvailableIndicate( void *pObject );
HS_RESULT delete_ASNH225ResourcesAvailableIndicate( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ResourcesAvailableIndicate_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ResourcesAvailableIndicate_IncludeOptionField( void *pObject, ASNH225ResourcesAvailableIndicateOptionMap pOptionMap );
BOOL	  ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( void *pObject, ASNH225ResourcesAvailableIndicateOptionMap pOptionMap );
HS_RESULT ASNH225ResourcesAvailableIndicate_MakeMold( void *pObject );
HS_RESULT ASNH225ResourcesAvailableIndicate_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ResourcesAvailableIndicate_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ResourcesAvailableConfirmOptionMap_nonStandardData,
	e_ASNH225ResourcesAvailableConfirmOptionMap_tokens,
	e_ASNH225ResourcesAvailableConfirmOptionMap_cryptoTokens,
	e_ASNH225ResourcesAvailableConfirmOptionMap_integrityCheckValue
,
	e_ASNH225ResourcesAvailableConfirmOptionMap_genericData
} ASNH225ResourcesAvailableConfirmOptionMap;


#define e_ASNH225ResourcesAvailableConfirmOptionMapSize 4
#define e_ASNH225ResourcesAvailableConfirmOptionMapSizeExt 5
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225ProtocolIdentifier m_protocolIdentifier;
	ASNH225NonStandardParameter m_nonStandardData;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	/*...,*/
	AsnSequenceOf m_genericData;
} ASNH225ResourcesAvailableConfirm;
HS_RESULT new_ASNH225ResourcesAvailableConfirm( void *pObject );
HS_RESULT delete_ASNH225ResourcesAvailableConfirm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ResourcesAvailableConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ResourcesAvailableConfirm_IncludeOptionField( void *pObject, ASNH225ResourcesAvailableConfirmOptionMap pOptionMap );
BOOL	  ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( void *pObject, ASNH225ResourcesAvailableConfirmOptionMap pOptionMap );
HS_RESULT ASNH225ResourcesAvailableConfirm_MakeMold( void *pObject );
HS_RESULT ASNH225ResourcesAvailableConfirm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ResourcesAvailableConfirm_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225InfoRequestAckOptionMap_nonStandardData,
	e_ASNH225InfoRequestAckOptionMap_tokens,
	e_ASNH225InfoRequestAckOptionMap_cryptoTokens,
	e_ASNH225InfoRequestAckOptionMap_integrityCheckValue

} ASNH225InfoRequestAckOptionMap;


#define e_ASNH225InfoRequestAckOptionMapSize 4
#define e_ASNH225InfoRequestAckOptionMapSizeExt 4
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225NonStandardParameter m_nonStandardData;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	/*...,*/
} ASNH225InfoRequestAck;
HS_RESULT new_ASNH225InfoRequestAck( void *pObject );
HS_RESULT delete_ASNH225InfoRequestAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225InfoRequestAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225InfoRequestAck_IncludeOptionField( void *pObject, ASNH225InfoRequestAckOptionMap pOptionMap );
BOOL	  ASNH225InfoRequestAck_IsIncludeOptionField( void *pObject, ASNH225InfoRequestAckOptionMap pOptionMap );
HS_RESULT ASNH225InfoRequestAck_MakeMold( void *pObject );
HS_RESULT ASNH225InfoRequestAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225InfoRequestAck_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225InfoRequestNakReasonChoice_notRegistered,
	e_ASNH225InfoRequestNakReasonChoice_securityDenial,
	e_ASNH225InfoRequestNakReasonChoice_undefinedReason

} ASNH225InfoRequestNakReasonChoice;


#define e_ASNH225InfoRequestNakReasonChoiceSize		3
#define e_ASNH225InfoRequestNakReasonChoiceSizeExt	3
typedef struct
{
	ASNH225InfoRequestNakReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225InfoRequestNakReason;
HS_RESULT new_ASNH225InfoRequestNakReason( void *pObject );
HS_RESULT delete_ASNH225InfoRequestNakReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225InfoRequestNakReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225InfoRequestNakReason_SetChoice( void *pObject, ASNH225InfoRequestNakReasonChoice pChoice );
HS_RESULT ASNH225InfoRequestNakReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH225InfoRequestNakReason_MakeMold( void *pObject );
HS_RESULT ASNH225InfoRequestNakReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225InfoRequestNakReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225InfoRequestNakOptionMap_nonStandardData,
	e_ASNH225InfoRequestNakOptionMap_altGKInfo,
	e_ASNH225InfoRequestNakOptionMap_tokens,
	e_ASNH225InfoRequestNakOptionMap_cryptoTokens,
	e_ASNH225InfoRequestNakOptionMap_integrityCheckValue

} ASNH225InfoRequestNakOptionMap;


#define e_ASNH225InfoRequestNakOptionMapSize 5
#define e_ASNH225InfoRequestNakOptionMapSizeExt 5
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225NonStandardParameter m_nonStandardData;
	ASNH225InfoRequestNakReason m_nakReason;
	ASNH225AltGKInfo m_altGKInfo;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	/*...,*/
} ASNH225InfoRequestNak;
HS_RESULT new_ASNH225InfoRequestNak( void *pObject );
HS_RESULT delete_ASNH225InfoRequestNak( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225InfoRequestNak_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225InfoRequestNak_IncludeOptionField( void *pObject, ASNH225InfoRequestNakOptionMap pOptionMap );
BOOL	  ASNH225InfoRequestNak_IsIncludeOptionField( void *pObject, ASNH225InfoRequestNakOptionMap pOptionMap );
HS_RESULT ASNH225InfoRequestNak_MakeMold( void *pObject );
HS_RESULT ASNH225InfoRequestNak_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225InfoRequestNak_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH225ServiceControlIndication_callSpecificOptionMapSize 0
#define e_ASNH225ServiceControlIndication_callSpecificOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH225CallIdentifier m_callIdentifier;
	ASNH225ConferenceIdentifier m_conferenceID;
	AsnBoolean m_answeredCall;
	/*...,*/
} ASNH225ServiceControlIndication_callSpecific;
HS_RESULT new_ASNH225ServiceControlIndication_callSpecific( void *pObject );
HS_RESULT delete_ASNH225ServiceControlIndication_callSpecific( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ServiceControlIndication_callSpecific_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ServiceControlIndication_callSpecific_MakeMold( void *pObject );
HS_RESULT ASNH225ServiceControlIndication_callSpecific_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ServiceControlIndication_callSpecific_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ServiceControlIndicationOptionMap_nonStandardData,
	e_ASNH225ServiceControlIndicationOptionMap_endpointIdentifier,
	e_ASNH225ServiceControlIndicationOptionMap_callSpecific,
	e_ASNH225ServiceControlIndicationOptionMap_tokens,
	e_ASNH225ServiceControlIndicationOptionMap_cryptoTokens,
	e_ASNH225ServiceControlIndicationOptionMap_integrityCheckValue,
	e_ASNH225ServiceControlIndicationOptionMap_featureSet,
	e_ASNH225ServiceControlIndicationOptionMap_genericData

} ASNH225ServiceControlIndicationOptionMap;


#define e_ASNH225ServiceControlIndicationOptionMapSize 8
#define e_ASNH225ServiceControlIndicationOptionMapSizeExt 8
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225NonStandardParameter m_nonStandardData;
	AsnSequenceOf m_serviceControl;
	ASNH225EndpointIdentifier m_endpointIdentifier;
	ASNH225ServiceControlIndication_callSpecific m_callSpecific;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
	/*...,*/
} ASNH225ServiceControlIndication;
HS_RESULT new_ASNH225ServiceControlIndication( void *pObject );
HS_RESULT delete_ASNH225ServiceControlIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ServiceControlIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ServiceControlIndication_IncludeOptionField( void *pObject, ASNH225ServiceControlIndicationOptionMap pOptionMap );
BOOL	  ASNH225ServiceControlIndication_IsIncludeOptionField( void *pObject, ASNH225ServiceControlIndicationOptionMap pOptionMap );
HS_RESULT ASNH225ServiceControlIndication_MakeMold( void *pObject );
HS_RESULT ASNH225ServiceControlIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ServiceControlIndication_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ServiceControlResponse_resultChoice_started,
	e_ASNH225ServiceControlResponse_resultChoice_failed,
	e_ASNH225ServiceControlResponse_resultChoice_stopped,
	e_ASNH225ServiceControlResponse_resultChoice_notAvailable,
	e_ASNH225ServiceControlResponse_resultChoice_neededFeatureNotSupported

} ASNH225ServiceControlResponse_resultChoice;


#define e_ASNH225ServiceControlResponse_resultChoiceSize		5
#define e_ASNH225ServiceControlResponse_resultChoiceSizeExt	5
typedef struct
{
	ASNH225ServiceControlResponse_resultChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225ServiceControlResponse_result;
HS_RESULT new_ASNH225ServiceControlResponse_result( void *pObject );
HS_RESULT delete_ASNH225ServiceControlResponse_result( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ServiceControlResponse_result_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225ServiceControlResponse_result_SetChoice( void *pObject, ASNH225ServiceControlResponse_resultChoice pChoice );
HS_RESULT ASNH225ServiceControlResponse_result_DeleteAlternation( void *pObject );
HS_RESULT ASNH225ServiceControlResponse_result_MakeMold( void *pObject );
HS_RESULT ASNH225ServiceControlResponse_result_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ServiceControlResponse_result_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225ServiceControlResponseOptionMap_result,
	e_ASNH225ServiceControlResponseOptionMap_nonStandardData,
	e_ASNH225ServiceControlResponseOptionMap_tokens,
	e_ASNH225ServiceControlResponseOptionMap_cryptoTokens,
	e_ASNH225ServiceControlResponseOptionMap_integrityCheckValue,
	e_ASNH225ServiceControlResponseOptionMap_featureSet,
	e_ASNH225ServiceControlResponseOptionMap_genericData

} ASNH225ServiceControlResponseOptionMap;


#define e_ASNH225ServiceControlResponseOptionMapSize 7
#define e_ASNH225ServiceControlResponseOptionMapSizeExt 7
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH225RequestSeqNum m_requestSeqNum;
	ASNH225ServiceControlResponse_result m_result;
	ASNH225NonStandardParameter m_nonStandardData;
	AsnSequenceOf m_tokens;
	AsnSequenceOf m_cryptoTokens;
	ASNH225ICV m_integrityCheckValue;
	ASNH225FeatureSet m_featureSet;
	AsnSequenceOf m_genericData;
	/*...,*/
} ASNH225ServiceControlResponse;
HS_RESULT new_ASNH225ServiceControlResponse( void *pObject );
HS_RESULT delete_ASNH225ServiceControlResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ServiceControlResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ServiceControlResponse_IncludeOptionField( void *pObject, ASNH225ServiceControlResponseOptionMap pOptionMap );
BOOL	  ASNH225ServiceControlResponse_IsIncludeOptionField( void *pObject, ASNH225ServiceControlResponseOptionMap pOptionMap );
HS_RESULT ASNH225ServiceControlResponse_MakeMold( void *pObject );
HS_RESULT ASNH225ServiceControlResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ServiceControlResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH225RasMessageChoice_gatekeeperRequest,
	e_ASNH225RasMessageChoice_gatekeeperConfirm,
	e_ASNH225RasMessageChoice_gatekeeperReject,
	e_ASNH225RasMessageChoice_registrationRequest,
	e_ASNH225RasMessageChoice_registrationConfirm,
	e_ASNH225RasMessageChoice_registrationReject,
	e_ASNH225RasMessageChoice_unregistrationRequest,
	e_ASNH225RasMessageChoice_unregistrationConfirm,
	e_ASNH225RasMessageChoice_unregistrationReject,
	e_ASNH225RasMessageChoice_admissionRequest,
	e_ASNH225RasMessageChoice_admissionConfirm,
	e_ASNH225RasMessageChoice_admissionReject,
	e_ASNH225RasMessageChoice_bandwidthRequest,
	e_ASNH225RasMessageChoice_bandwidthConfirm,
	e_ASNH225RasMessageChoice_bandwidthReject,
	e_ASNH225RasMessageChoice_disengageRequest,
	e_ASNH225RasMessageChoice_disengageConfirm,
	e_ASNH225RasMessageChoice_disengageReject,
	e_ASNH225RasMessageChoice_locationRequest,
	e_ASNH225RasMessageChoice_locationConfirm,
	e_ASNH225RasMessageChoice_locationReject,
	e_ASNH225RasMessageChoice_infoRequest,
	e_ASNH225RasMessageChoice_infoRequestResponse,
	e_ASNH225RasMessageChoice_nonStandardMessage,
	e_ASNH225RasMessageChoice_unknownMessageResponse
,
	e_ASNH225RasMessageChoice_requestInProgress,
	e_ASNH225RasMessageChoice_resourcesAvailableIndicate,
	e_ASNH225RasMessageChoice_resourcesAvailableConfirm,
	e_ASNH225RasMessageChoice_infoRequestAck,
	e_ASNH225RasMessageChoice_infoRequestNak,
	e_ASNH225RasMessageChoice_serviceControlIndication,
	e_ASNH225RasMessageChoice_serviceControlResponse
} ASNH225RasMessageChoice;


#define e_ASNH225RasMessageChoiceSize		25
#define e_ASNH225RasMessageChoiceSizeExt	32
typedef struct
{
	ASNH225RasMessageChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH225RasMessage;
HS_RESULT new_ASNH225RasMessage( void *pObject );
HS_RESULT delete_ASNH225RasMessage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RasMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH225RasMessage_SetChoice( void *pObject, ASNH225RasMessageChoice pChoice );
HS_RESULT ASNH225RasMessage_DeleteAlternation( void *pObject );
HS_RESULT ASNH225RasMessage_MakeMold( void *pObject );
HS_RESULT ASNH225RasMessage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225RasMessage_Decode( void *pObject, AsnStream *pStrm );







#endif/*__2005_03_27__12_37__H225_HXX__*/


