/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<h225_1.c>

*/

#include "H225.h"

/***************************************************************************************/
/* ASNH225AdmissionRequest Class
*/
/*ASNH225AdmissionRequest Constructor*/
HS_RESULT new_ASNH225AdmissionRequest(void *pObject)
{
	ASNH225AdmissionRequest *pObj = (ASNH225AdmissionRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225AdmissionRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225CallType( &(pObj->m_callType) );
	new_ASNH225CallModel( &(pObj->m_callModel) );
	new_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	new_AsnSequenceOf( &(pObj->m_destinationInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TransportAddress( &(pObj->m_destCallSignalAddress) );
	new_AsnSequenceOf( &(pObj->m_destExtraCallInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_srcInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TransportAddress( &(pObj->m_srcCallSignalAddress) );
	new_ASNH225BandWidth( &(pObj->m_bandWidth) );
	new_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225QseriesOptions( &(pObj->m_callServices) );
	new_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	new_AsnBoolean( &(pObj->m_activeMC) );
	new_AsnBoolean( &(pObj->m_answerCall) );
	new_AsnBoolean( &(pObj->m_canMapAlias) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_AsnSequenceOf( &(pObj->m_srcAlternatives), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_destAlternatives), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225GatekeeperIdentifier( &(pObj->m_gatekeeperIdentifier) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225TransportQOS( &(pObj->m_transportQOS) );
	new_AsnBoolean( &(pObj->m_willSupplyUUIEs) );
	new_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	new_ASNH225DataRate( &(pObj->m_gatewayDataRate) );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	new_AsnSequenceOf( &(pObj->m_desiredProtocols), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TunnelledProtocol( &(pObj->m_desiredTunnelledProtocol) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225AdmissionRequest Destructor */
HS_RESULT delete_ASNH225AdmissionRequest(void *pObject)
{
	ASNH225AdmissionRequest *pObj = (ASNH225AdmissionRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225AdmissionRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225CallType( &(pObj->m_callType) );
	delete_ASNH225CallModel( &(pObj->m_callModel) );
	delete_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_destinationInfo) );
	delete_ASNH225TransportAddress( &(pObj->m_destCallSignalAddress) );
	delete_AsnSequenceOf( &(pObj->m_destExtraCallInfo) );
	delete_AsnSequenceOf( &(pObj->m_srcInfo) );
	delete_ASNH225TransportAddress( &(pObj->m_srcCallSignalAddress) );
	delete_ASNH225BandWidth( &(pObj->m_bandWidth) );
	delete_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225QseriesOptions( &(pObj->m_callServices) );
	delete_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	delete_AsnBoolean( &(pObj->m_activeMC) );
	delete_AsnBoolean( &(pObj->m_answerCall) );
	delete_AsnBoolean( &(pObj->m_canMapAlias) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_srcAlternatives) );
	delete_AsnSequenceOf( &(pObj->m_destAlternatives) );
	delete_ASNH225GatekeeperIdentifier( &(pObj->m_gatekeeperIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225TransportQOS( &(pObj->m_transportQOS) );
	delete_AsnBoolean( &(pObj->m_willSupplyUUIEs) );
	delete_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	delete_ASNH225DataRate( &(pObj->m_gatewayDataRate) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	delete_AsnSequenceOf( &(pObj->m_desiredProtocols) );
	delete_ASNH225TunnelledProtocol( &(pObj->m_desiredTunnelledProtocol) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225AdmissionRequest MakeMold */
HS_RESULT ASNH225AdmissionRequest_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225AdmissionRequest *pObj = (ASNH225AdmissionRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225CallType_MakeMold(&(pObj->m_callType));
	ASNH225CallModel_MakeMold(&(pObj->m_callModel));
	ASNH225EndpointIdentifier_MakeMold(&(pObj->m_endpointIdentifier));
	{
	ASNH225AliasAddress *tmold_destinationInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destinationInfo);
	ASNH225AliasAddress_MakeMold(tmold_destinationInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destinationInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destinationInfo), moldObject );
	}
	ASNH225TransportAddress_MakeMold(&(pObj->m_destCallSignalAddress));
	{
	ASNH225AliasAddress *tmold_destExtraCallInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destExtraCallInfo);
	ASNH225AliasAddress_MakeMold(tmold_destExtraCallInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destExtraCallInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destExtraCallInfo), moldObject );
	}
	{
	ASNH225AliasAddress *tmold_srcInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_srcInfo);
	ASNH225AliasAddress_MakeMold(tmold_srcInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_srcInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_srcInfo), moldObject );
	}
	ASNH225TransportAddress_MakeMold(&(pObj->m_srcCallSignalAddress));
	ASNH225BandWidth_MakeMold(&(pObj->m_bandWidth));
	ASNH225CallReferenceValue_MakeMold(&(pObj->m_callReferenceValue));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225QseriesOptions_MakeMold(&(pObj->m_callServices));
	ASNH225ConferenceIdentifier_MakeMold(&(pObj->m_conferenceID));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	{
	ASNH225Endpoint *tmold_srcAlternatives = (ASNH225Endpoint *)HSMalloc( sizeof(ASNH225Endpoint) );
	new_ASNH225Endpoint(tmold_srcAlternatives);
	ASNH225Endpoint_MakeMold(tmold_srcAlternatives);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_srcAlternatives,sizeof(ASNH225Endpoint),ASNH225Endpoint_MakeMold,ASNH225Endpoint_Encode,ASNH225Endpoint_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225Endpoint_Print,
#endif
		delete_ASNH225Endpoint);
	AsnSequenceOf_SetMold( &(pObj->m_srcAlternatives), moldObject );
	}
	{
	ASNH225Endpoint *tmold_destAlternatives = (ASNH225Endpoint *)HSMalloc( sizeof(ASNH225Endpoint) );
	new_ASNH225Endpoint(tmold_destAlternatives);
	ASNH225Endpoint_MakeMold(tmold_destAlternatives);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destAlternatives,sizeof(ASNH225Endpoint),ASNH225Endpoint_MakeMold,ASNH225Endpoint_Encode,ASNH225Endpoint_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225Endpoint_Print,
#endif
		delete_ASNH225Endpoint);
	AsnSequenceOf_SetMold( &(pObj->m_destAlternatives), moldObject );
	}
	ASNH225GatekeeperIdentifier_MakeMold(&(pObj->m_gatekeeperIdentifier));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225TransportQOS_MakeMold(&(pObj->m_transportQOS));
	ASNH225CallLinkage_MakeMold(&(pObj->m_callLinkage));
	ASNH225DataRate_MakeMold(&(pObj->m_gatewayDataRate));
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	{
	ASNH225SupportedProtocols *tmold_desiredProtocols = (ASNH225SupportedProtocols *)HSMalloc( sizeof(ASNH225SupportedProtocols) );
	new_ASNH225SupportedProtocols(tmold_desiredProtocols);
	ASNH225SupportedProtocols_MakeMold(tmold_desiredProtocols);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_desiredProtocols,sizeof(ASNH225SupportedProtocols),ASNH225SupportedProtocols_MakeMold,ASNH225SupportedProtocols_Encode,ASNH225SupportedProtocols_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedProtocols_Print,
#endif
		delete_ASNH225SupportedProtocols);
	AsnSequenceOf_SetMold( &(pObj->m_desiredProtocols), moldObject );
	}
	ASNH225TunnelledProtocol_MakeMold(&(pObj->m_desiredTunnelledProtocol));
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225AdmissionRequest IncludeOptionalField */
HS_RESULT ASNH225AdmissionRequest_IncludeOptionField( void *pObject, ASNH225AdmissionRequestOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225AdmissionRequest *pObj = (ASNH225AdmissionRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225AdmissionRequestOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225AdmissionRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225AdmissionRequestOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225AdmissionRequest IsIncludeOptionalField */
BOOL ASNH225AdmissionRequest_IsIncludeOptionField( void *pObject, ASNH225AdmissionRequestOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225AdmissionRequest *pObj = (ASNH225AdmissionRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225AdmissionRequestOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225AdmissionRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225AdmissionRequestOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225AdmissionRequest Encode */
HS_RESULT ASNH225AdmissionRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225AdmissionRequest *pObj = (ASNH225AdmissionRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225AdmissionRequestOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225AdmissionRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallType_Encode( &(pObj->m_callType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callModel ) ){
		if( (tRet=ASNH225CallModel_Encode( &(pObj->m_callModel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225EndpointIdentifier_Encode( &(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destinationInfo ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_destinationInfo),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destCallSignalAddress ) ){
		if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_destCallSignalAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destExtraCallInfo ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_destExtraCallInfo),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_srcInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_srcCallSignalAddress ) ){
		if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_srcCallSignalAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225BandWidth_Encode( &(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallReferenceValue_Encode( &(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callServices ) ){
		if( (tRet=ASNH225QseriesOptions_Encode( &(pObj->m_callServices),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225ConferenceIdentifier_Encode( &(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_activeMC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_answerCall),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_canMapAlias ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_canMapAlias), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_srcAlternatives ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_srcAlternatives), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destAlternatives ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destAlternatives), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_gatekeeperIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_gatekeeperIdentifier), ASNH225GatekeeperIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_transportQOS ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_transportQOS), ASNH225TransportQOS_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_willSupplyUUIEs ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_willSupplyUUIEs), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callLinkage ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_gatewayDataRate ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_gatewayDataRate), ASNH225DataRate_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_desiredProtocols ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_desiredProtocols), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_desiredTunnelledProtocol ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_desiredTunnelledProtocol), ASNH225TunnelledProtocol_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225AdmissionRequest Decode */
HS_RESULT ASNH225AdmissionRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225AdmissionRequest *pObj = (ASNH225AdmissionRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225AdmissionRequestOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225AdmissionRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallType_Decode(&(pObj->m_callType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callModel ) ){
		if( (tRet=ASNH225CallModel_Decode(&(pObj->m_callModel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225EndpointIdentifier_Decode(&(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destinationInfo ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_destinationInfo),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destCallSignalAddress ) ){
		if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_destCallSignalAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destExtraCallInfo ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_destExtraCallInfo),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_srcInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_srcCallSignalAddress ) ){
		if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_srcCallSignalAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225BandWidth_Decode(&(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallReferenceValue_Decode(&(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callServices ) ){
		if( (tRet=ASNH225QseriesOptions_Decode(&(pObj->m_callServices),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225ConferenceIdentifier_Decode(&(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_activeMC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_answerCall),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_canMapAlias ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_canMapAlias), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_srcAlternatives ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_srcAlternatives), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destAlternatives ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_destAlternatives), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_gatekeeperIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_gatekeeperIdentifier), ASNH225GatekeeperIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_transportQOS ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_transportQOS), ASNH225TransportQOS_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_willSupplyUUIEs ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_willSupplyUUIEs), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callLinkage ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_gatewayDataRate ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_gatewayDataRate), ASNH225DataRate_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_circuitInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_desiredProtocols ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_desiredProtocols), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_desiredTunnelledProtocol ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_desiredTunnelledProtocol), ASNH225TunnelledProtocol_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225AdmissionRequest Print */
HS_RESULT ASNH225AdmissionRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225AdmissionRequest *pObj = (ASNH225AdmissionRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225AdmissionRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225CallType_Print( &(pObj->m_callType), pDepth+1, "callType" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callModel ) )
		ASNH225CallModel_Print( &(pObj->m_callModel), pDepth+1, "callModel" );
	ASNH225EndpointIdentifier_Print( &(pObj->m_endpointIdentifier), pDepth+1, "endpointIdentifier" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destinationInfo ) )
		AsnSequenceOf_Print( &(pObj->m_destinationInfo), pDepth+1, "destinationInfo" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destCallSignalAddress ) )
		ASNH225TransportAddress_Print( &(pObj->m_destCallSignalAddress), pDepth+1, "destCallSignalAddress" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destExtraCallInfo ) )
		AsnSequenceOf_Print( &(pObj->m_destExtraCallInfo), pDepth+1, "destExtraCallInfo" );
	AsnSequenceOf_Print( &(pObj->m_srcInfo), pDepth+1, "srcInfo" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_srcCallSignalAddress ) )
		ASNH225TransportAddress_Print( &(pObj->m_srcCallSignalAddress), pDepth+1, "srcCallSignalAddress" );
	ASNH225BandWidth_Print( &(pObj->m_bandWidth), pDepth+1, "bandWidth" );
	ASNH225CallReferenceValue_Print( &(pObj->m_callReferenceValue), pDepth+1, "callReferenceValue" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callServices ) )
		ASNH225QseriesOptions_Print( &(pObj->m_callServices), pDepth+1, "callServices" );
	ASNH225ConferenceIdentifier_Print( &(pObj->m_conferenceID), pDepth+1, "conferenceID" );
	AsnBoolean_Print( &(pObj->m_activeMC), pDepth+1, "activeMC" );
	AsnBoolean_Print( &(pObj->m_answerCall), pDepth+1, "answerCall" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_canMapAlias ) )
		AsnBoolean_Print( &(pObj->m_canMapAlias), pDepth+1, "canMapAlias" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_srcAlternatives ) )
		AsnSequenceOf_Print( &(pObj->m_srcAlternatives), pDepth+1, "srcAlternatives" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_destAlternatives ) )
		AsnSequenceOf_Print( &(pObj->m_destAlternatives), pDepth+1, "destAlternatives" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_gatekeeperIdentifier ) )
		ASNH225GatekeeperIdentifier_Print( &(pObj->m_gatekeeperIdentifier), pDepth+1, "gatekeeperIdentifier" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_transportQOS ) )
		ASNH225TransportQOS_Print( &(pObj->m_transportQOS), pDepth+1, "transportQOS" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_willSupplyUUIEs ) )
		AsnBoolean_Print( &(pObj->m_willSupplyUUIEs), pDepth+1, "willSupplyUUIEs" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_callLinkage ) )
		ASNH225CallLinkage_Print( &(pObj->m_callLinkage), pDepth+1, "callLinkage" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_gatewayDataRate ) )
		ASNH225DataRate_Print( &(pObj->m_gatewayDataRate), pDepth+1, "gatewayDataRate" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_circuitInfo ) )
		ASNH225CircuitInfo_Print( &(pObj->m_circuitInfo), pDepth+1, "circuitInfo" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_desiredProtocols ) )
		AsnSequenceOf_Print( &(pObj->m_desiredProtocols), pDepth+1, "desiredProtocols" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_desiredTunnelledProtocol ) )
		ASNH225TunnelledProtocol_Print( &(pObj->m_desiredTunnelledProtocol), pDepth+1, "desiredTunnelledProtocol" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	if( ASNH225AdmissionRequest_IsIncludeOptionField( pObj, e_ASNH225AdmissionRequestOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225UUIEsRequested Class
*/
/*ASNH225UUIEsRequested Constructor*/
HS_RESULT new_ASNH225UUIEsRequested(void *pObject)
{
	ASNH225UUIEsRequested *pObj = (ASNH225UUIEsRequested *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225UUIEsRequested(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_setup) );
	new_AsnBoolean( &(pObj->m_callProceeding) );
	new_AsnBoolean( &(pObj->m_connect) );
	new_AsnBoolean( &(pObj->m_alerting) );
	new_AsnBoolean( &(pObj->m_information) );
	new_AsnBoolean( &(pObj->m_releaseComplete) );
	new_AsnBoolean( &(pObj->m_facility) );
	new_AsnBoolean( &(pObj->m_progress) );
	new_AsnBoolean( &(pObj->m_empty) );
	new_AsnBoolean( &(pObj->m_status) );
	new_AsnBoolean( &(pObj->m_statusInquiry) );
	new_AsnBoolean( &(pObj->m_setupAcknowledge) );
	new_AsnBoolean( &(pObj->m_notify) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225UUIEsRequested Destructor */
HS_RESULT delete_ASNH225UUIEsRequested(void *pObject)
{
	ASNH225UUIEsRequested *pObj = (ASNH225UUIEsRequested *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225UUIEsRequested(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_setup) );
	delete_AsnBoolean( &(pObj->m_callProceeding) );
	delete_AsnBoolean( &(pObj->m_connect) );
	delete_AsnBoolean( &(pObj->m_alerting) );
	delete_AsnBoolean( &(pObj->m_information) );
	delete_AsnBoolean( &(pObj->m_releaseComplete) );
	delete_AsnBoolean( &(pObj->m_facility) );
	delete_AsnBoolean( &(pObj->m_progress) );
	delete_AsnBoolean( &(pObj->m_empty) );
	delete_AsnBoolean( &(pObj->m_status) );
	delete_AsnBoolean( &(pObj->m_statusInquiry) );
	delete_AsnBoolean( &(pObj->m_setupAcknowledge) );
	delete_AsnBoolean( &(pObj->m_notify) );
	return HS_OK;
}

/* ASNH225UUIEsRequested MakeMold */
HS_RESULT ASNH225UUIEsRequested_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225UUIEsRequested *pObj = (ASNH225UUIEsRequested *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225UUIEsRequested IncludeOptionalField */
HS_RESULT ASNH225UUIEsRequested_IncludeOptionField( void *pObject, ASNH225UUIEsRequestedOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225UUIEsRequested *pObj = (ASNH225UUIEsRequested *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225UUIEsRequestedOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225UUIEsRequestedOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH225UUIEsRequested IsIncludeOptionalField */
BOOL ASNH225UUIEsRequested_IsIncludeOptionField( void *pObject, ASNH225UUIEsRequestedOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225UUIEsRequested *pObj = (ASNH225UUIEsRequested *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225UUIEsRequestedOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225UUIEsRequestedOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225UUIEsRequested Encode */
HS_RESULT ASNH225UUIEsRequested_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225UUIEsRequested *pObj = (ASNH225UUIEsRequested *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_setup),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_callProceeding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_connect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_alerting),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_information),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_releaseComplete),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_facility),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_progress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_empty),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_status ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_status), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_statusInquiry ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_statusInquiry), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_setupAcknowledge ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_setupAcknowledge), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_notify ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_notify), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225UUIEsRequested_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225UUIEsRequested Decode */
HS_RESULT ASNH225UUIEsRequested_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225UUIEsRequested *pObj = (ASNH225UUIEsRequested *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_setup),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_callProceeding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_connect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_alerting),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_information),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_releaseComplete),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_facility),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_progress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_empty),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_status ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_status), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_statusInquiry ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_statusInquiry), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_setupAcknowledge ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_setupAcknowledge), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_notify ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_notify), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225UUIEsRequested_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225UUIEsRequested Print */
HS_RESULT ASNH225UUIEsRequested_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225UUIEsRequested *pObj = (ASNH225UUIEsRequested *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225UUIEsRequested_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_setup), pDepth+1, "setup" );
	AsnBoolean_Print( &(pObj->m_callProceeding), pDepth+1, "callProceeding" );
	AsnBoolean_Print( &(pObj->m_connect), pDepth+1, "connect" );
	AsnBoolean_Print( &(pObj->m_alerting), pDepth+1, "alerting" );
	AsnBoolean_Print( &(pObj->m_information), pDepth+1, "information" );
	AsnBoolean_Print( &(pObj->m_releaseComplete), pDepth+1, "releaseComplete" );
	AsnBoolean_Print( &(pObj->m_facility), pDepth+1, "facility" );
	AsnBoolean_Print( &(pObj->m_progress), pDepth+1, "progress" );
	AsnBoolean_Print( &(pObj->m_empty), pDepth+1, "empty" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_status ) )
		AsnBoolean_Print( &(pObj->m_status), pDepth+1, "status" );
	if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_statusInquiry ) )
		AsnBoolean_Print( &(pObj->m_statusInquiry), pDepth+1, "statusInquiry" );
	if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_setupAcknowledge ) )
		AsnBoolean_Print( &(pObj->m_setupAcknowledge), pDepth+1, "setupAcknowledge" );
	if( ASNH225UUIEsRequested_IsIncludeOptionField( pObj, e_ASNH225UUIEsRequestedOptionMap_notify ) )
		AsnBoolean_Print( &(pObj->m_notify), pDepth+1, "notify" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225AdmissionConfirm Class
*/
/*ASNH225AdmissionConfirm Constructor*/
HS_RESULT new_ASNH225AdmissionConfirm(void *pObject)
{
	ASNH225AdmissionConfirm *pObj = (ASNH225AdmissionConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225AdmissionConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225BandWidth( &(pObj->m_bandWidth) );
	new_ASNH225CallModel( &(pObj->m_callModel) );
	new_ASNH225TransportAddress( &(pObj->m_destCallSignalAddress) );
	new_AsnInteger( &(pObj->m_irrFrequency), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_destinationInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_destExtraCallInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225EndpointType( &(pObj->m_destinationType) );
	new_AsnSequenceOf( &(pObj->m_remoteExtensionAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_alternateEndpoints), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225TransportQOS( &(pObj->m_transportQOS) );
	new_AsnBoolean( &(pObj->m_willRespondToIRR) );
	new_ASNH225UUIEsRequested( &(pObj->m_uuiesRequested) );
	new_AsnSequenceOf( &(pObj->m_language), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225AlternateTransportAddresses( &(pObj->m_alternateTransportAddresses) );
	new_ASNH225UseSpecifiedTransport( &(pObj->m_useSpecifiedTransport) );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	new_AsnSequenceOf( &(pObj->m_usageSpec), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedProtocols), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_multipleCalls) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225AdmissionConfirm Destructor */
HS_RESULT delete_ASNH225AdmissionConfirm(void *pObject)
{
	ASNH225AdmissionConfirm *pObj = (ASNH225AdmissionConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225AdmissionConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225BandWidth( &(pObj->m_bandWidth) );
	delete_ASNH225CallModel( &(pObj->m_callModel) );
	delete_ASNH225TransportAddress( &(pObj->m_destCallSignalAddress) );
	delete_AsnInteger( &(pObj->m_irrFrequency) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_destinationInfo) );
	delete_AsnSequenceOf( &(pObj->m_destExtraCallInfo) );
	delete_ASNH225EndpointType( &(pObj->m_destinationType) );
	delete_AsnSequenceOf( &(pObj->m_remoteExtensionAddress) );
	delete_AsnSequenceOf( &(pObj->m_alternateEndpoints) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225TransportQOS( &(pObj->m_transportQOS) );
	delete_AsnBoolean( &(pObj->m_willRespondToIRR) );
	delete_ASNH225UUIEsRequested( &(pObj->m_uuiesRequested) );
	delete_AsnSequenceOf( &(pObj->m_language) );
	delete_ASNH225AlternateTransportAddresses( &(pObj->m_alternateTransportAddresses) );
	delete_ASNH225UseSpecifiedTransport( &(pObj->m_useSpecifiedTransport) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	delete_AsnSequenceOf( &(pObj->m_usageSpec) );
	delete_AsnSequenceOf( &(pObj->m_supportedProtocols) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	delete_AsnBoolean( &(pObj->m_multipleCalls) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225AdmissionConfirm MakeMold */
HS_RESULT ASNH225AdmissionConfirm_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225AdmissionConfirm *pObj = (ASNH225AdmissionConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225BandWidth_MakeMold(&(pObj->m_bandWidth));
	ASNH225CallModel_MakeMold(&(pObj->m_callModel));
	ASNH225TransportAddress_MakeMold(&(pObj->m_destCallSignalAddress));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225AliasAddress *tmold_destinationInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destinationInfo);
	ASNH225AliasAddress_MakeMold(tmold_destinationInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destinationInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destinationInfo), moldObject );
	}
	{
	ASNH225AliasAddress *tmold_destExtraCallInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destExtraCallInfo);
	ASNH225AliasAddress_MakeMold(tmold_destExtraCallInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destExtraCallInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destExtraCallInfo), moldObject );
	}
	ASNH225EndpointType_MakeMold(&(pObj->m_destinationType));
	{
	ASNH225AliasAddress *tmold_remoteExtensionAddress = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_remoteExtensionAddress);
	ASNH225AliasAddress_MakeMold(tmold_remoteExtensionAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_remoteExtensionAddress,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_remoteExtensionAddress), moldObject );
	}
	{
	ASNH225Endpoint *tmold_alternateEndpoints = (ASNH225Endpoint *)HSMalloc( sizeof(ASNH225Endpoint) );
	new_ASNH225Endpoint(tmold_alternateEndpoints);
	ASNH225Endpoint_MakeMold(tmold_alternateEndpoints);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_alternateEndpoints,sizeof(ASNH225Endpoint),ASNH225Endpoint_MakeMold,ASNH225Endpoint_Encode,ASNH225Endpoint_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225Endpoint_Print,
#endif
		delete_ASNH225Endpoint);
	AsnSequenceOf_SetMold( &(pObj->m_alternateEndpoints), moldObject );
	}
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225TransportQOS_MakeMold(&(pObj->m_transportQOS));
	ASNH225UUIEsRequested_MakeMold(&(pObj->m_uuiesRequested));
	{
	AsnSingleString *tmold_language = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
	new_AsnSingleString(tmold_language,e_asnTagIA5String,e_constrained,1,32,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_language,sizeof(AsnSingleString),AsnSingleString_MakeMold,AsnSingleString_Encode,AsnSingleString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnSingleString_Print,
#endif
		delete_AsnSingleString);
	AsnSequenceOf_SetMold( &(pObj->m_language), moldObject );
	}
	ASNH225AlternateTransportAddresses_MakeMold(&(pObj->m_alternateTransportAddresses));
	ASNH225UseSpecifiedTransport_MakeMold(&(pObj->m_useSpecifiedTransport));
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	{
	ASNH225RasUsageSpecification *tmold_usageSpec = (ASNH225RasUsageSpecification *)HSMalloc( sizeof(ASNH225RasUsageSpecification) );
	new_ASNH225RasUsageSpecification(tmold_usageSpec);
	ASNH225RasUsageSpecification_MakeMold(tmold_usageSpec);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_usageSpec,sizeof(ASNH225RasUsageSpecification),ASNH225RasUsageSpecification_MakeMold,ASNH225RasUsageSpecification_Encode,ASNH225RasUsageSpecification_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225RasUsageSpecification_Print,
#endif
		delete_ASNH225RasUsageSpecification);
	AsnSequenceOf_SetMold( &(pObj->m_usageSpec), moldObject );
	}
	{
	ASNH225SupportedProtocols *tmold_supportedProtocols = (ASNH225SupportedProtocols *)HSMalloc( sizeof(ASNH225SupportedProtocols) );
	new_ASNH225SupportedProtocols(tmold_supportedProtocols);
	ASNH225SupportedProtocols_MakeMold(tmold_supportedProtocols);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedProtocols,sizeof(ASNH225SupportedProtocols),ASNH225SupportedProtocols_MakeMold,ASNH225SupportedProtocols_Encode,ASNH225SupportedProtocols_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedProtocols_Print,
#endif
		delete_ASNH225SupportedProtocols);
	AsnSequenceOf_SetMold( &(pObj->m_supportedProtocols), moldObject );
	}
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225AdmissionConfirm IncludeOptionalField */
HS_RESULT ASNH225AdmissionConfirm_IncludeOptionField( void *pObject, ASNH225AdmissionConfirmOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225AdmissionConfirm *pObj = (ASNH225AdmissionConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225AdmissionConfirmOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225AdmissionConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225AdmissionConfirmOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225AdmissionConfirm IsIncludeOptionalField */
BOOL ASNH225AdmissionConfirm_IsIncludeOptionField( void *pObject, ASNH225AdmissionConfirmOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225AdmissionConfirm *pObj = (ASNH225AdmissionConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225AdmissionConfirmOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225AdmissionConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225AdmissionConfirmOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225AdmissionConfirm Encode */
HS_RESULT ASNH225AdmissionConfirm_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225AdmissionConfirm *pObj = (ASNH225AdmissionConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225AdmissionConfirmOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225AdmissionConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandWidth_Encode( &(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallModel_Encode( &(pObj->m_callModel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_destCallSignalAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_irrFrequency ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_irrFrequency),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_destinationInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destinationInfo), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_destExtraCallInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destExtraCallInfo), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_destinationType ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destinationType), ASNH225EndpointType_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_remoteExtensionAddress ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_remoteExtensionAddress), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_alternateEndpoints ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_alternateEndpoints), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_transportQOS ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_transportQOS), ASNH225TransportQOS_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_willRespondToIRR ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_willRespondToIRR), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_uuiesRequested ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_uuiesRequested), ASNH225UUIEsRequested_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_language ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_language), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_alternateTransportAddresses ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_alternateTransportAddresses), ASNH225AlternateTransportAddresses_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_useSpecifiedTransport ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_useSpecifiedTransport), ASNH225UseSpecifiedTransport_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_usageSpec ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_usageSpec), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_supportedProtocols ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedProtocols), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_multipleCalls ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_multipleCalls), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225AdmissionConfirm Decode */
HS_RESULT ASNH225AdmissionConfirm_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225AdmissionConfirm *pObj = (ASNH225AdmissionConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225AdmissionConfirmOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225AdmissionConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandWidth_Decode(&(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallModel_Decode(&(pObj->m_callModel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_destCallSignalAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_irrFrequency ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_irrFrequency),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_destinationInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_destinationInfo), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_destExtraCallInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_destExtraCallInfo), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_destinationType ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_destinationType), ASNH225EndpointType_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_remoteExtensionAddress ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_remoteExtensionAddress), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_alternateEndpoints ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_alternateEndpoints), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_transportQOS ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_transportQOS), ASNH225TransportQOS_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_willRespondToIRR ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_willRespondToIRR), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_uuiesRequested ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_uuiesRequested), ASNH225UUIEsRequested_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_language ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_language), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_alternateTransportAddresses ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_alternateTransportAddresses), ASNH225AlternateTransportAddresses_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_useSpecifiedTransport ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_useSpecifiedTransport), ASNH225UseSpecifiedTransport_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_circuitInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_usageSpec ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_usageSpec), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_supportedProtocols ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedProtocols), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_serviceControl ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_serviceControl), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_multipleCalls ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_multipleCalls), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225AdmissionConfirm Print */
HS_RESULT ASNH225AdmissionConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225AdmissionConfirm *pObj = (ASNH225AdmissionConfirm *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225AdmissionConfirm_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225BandWidth_Print( &(pObj->m_bandWidth), pDepth+1, "bandWidth" );
	ASNH225CallModel_Print( &(pObj->m_callModel), pDepth+1, "callModel" );
	ASNH225TransportAddress_Print( &(pObj->m_destCallSignalAddress), pDepth+1, "destCallSignalAddress" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_irrFrequency ) )
		AsnInteger_Print( &(pObj->m_irrFrequency), pDepth+1, "irrFrequency" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_destinationInfo ) )
		AsnSequenceOf_Print( &(pObj->m_destinationInfo), pDepth+1, "destinationInfo" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_destExtraCallInfo ) )
		AsnSequenceOf_Print( &(pObj->m_destExtraCallInfo), pDepth+1, "destExtraCallInfo" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_destinationType ) )
		ASNH225EndpointType_Print( &(pObj->m_destinationType), pDepth+1, "destinationType" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_remoteExtensionAddress ) )
		AsnSequenceOf_Print( &(pObj->m_remoteExtensionAddress), pDepth+1, "remoteExtensionAddress" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_alternateEndpoints ) )
		AsnSequenceOf_Print( &(pObj->m_alternateEndpoints), pDepth+1, "alternateEndpoints" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_transportQOS ) )
		ASNH225TransportQOS_Print( &(pObj->m_transportQOS), pDepth+1, "transportQOS" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_willRespondToIRR ) )
		AsnBoolean_Print( &(pObj->m_willRespondToIRR), pDepth+1, "willRespondToIRR" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_uuiesRequested ) )
		ASNH225UUIEsRequested_Print( &(pObj->m_uuiesRequested), pDepth+1, "uuiesRequested" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_language ) )
		AsnSequenceOf_Print( &(pObj->m_language), pDepth+1, "language" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_alternateTransportAddresses ) )
		ASNH225AlternateTransportAddresses_Print( &(pObj->m_alternateTransportAddresses), pDepth+1, "alternateTransportAddresses" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_useSpecifiedTransport ) )
		ASNH225UseSpecifiedTransport_Print( &(pObj->m_useSpecifiedTransport), pDepth+1, "useSpecifiedTransport" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_circuitInfo ) )
		ASNH225CircuitInfo_Print( &(pObj->m_circuitInfo), pDepth+1, "circuitInfo" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_usageSpec ) )
		AsnSequenceOf_Print( &(pObj->m_usageSpec), pDepth+1, "usageSpec" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_supportedProtocols ) )
		AsnSequenceOf_Print( &(pObj->m_supportedProtocols), pDepth+1, "supportedProtocols" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_serviceControl ) )
		AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_multipleCalls ) )
		AsnBoolean_Print( &(pObj->m_multipleCalls), pDepth+1, "multipleCalls" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	if( ASNH225AdmissionConfirm_IsIncludeOptionField( pObj, e_ASNH225AdmissionConfirmOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225AdmissionRejectReason Struct
*/
/* ASNH225AdmissionRejectReason Constructor */
HS_RESULT new_ASNH225AdmissionRejectReason( void *pObject )
{
	ASNH225AdmissionRejectReason *pObj = (ASNH225AdmissionRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225AdmissionRejectReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225AdmissionRejectReasonChoice_calledPartyNotRegistered;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225AdmissionRejectReasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225AdmissionRejectReason Destructor */
HS_RESULT delete_ASNH225AdmissionRejectReason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225AdmissionRejectReason *pObj = (ASNH225AdmissionRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225AdmissionRejectReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225AdmissionRejectReason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225AdmissionRejectReason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225AdmissionRejectReason SetChoice */
void* ASNH225AdmissionRejectReason_SetChoice( void *pObject, ASNH225AdmissionRejectReasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225AdmissionRejectReason *pObj = (ASNH225AdmissionRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225AdmissionRejectReasonChoiceSizeExt ){
		if( pChoice > (ASNH225AdmissionRejectReasonChoice)(e_ASNH225AdmissionRejectReasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225AdmissionRejectReason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225AdmissionRejectReasonChoice_calledPartyNotRegistered ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_invalidPermission ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_requestDenied ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_undefinedReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_callerNotRegistered ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_routeCallToGatekeeper ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_invalidEndpointIdentifier ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_resourceUnavailable ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_securityDenial ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_qosControlNotSupported ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_incompleteAddress ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_aliasesInconsistent ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_routeCallToSCN ){
		ASNH225PartyNumber *tAlter = (ASNH225PartyNumber *)HSMalloc( sizeof(ASNH225PartyNumber) );
		new_ASNH225PartyNumber(tAlter);
		ASNH225PartyNumber_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH225PartyNumber),ASNH225PartyNumber_MakeMold,ASNH225PartyNumber_Encode,ASNH225PartyNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH225PartyNumber_Print,
#endif
			delete_ASNH225PartyNumber );
		AsnSequenceOf_SetMold(aso,tmold);
		pObj->alter = aso;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_exceedsCallCapacity ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_collectDestination ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_collectPIN ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_genericDataReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AdmissionRejectReasonChoice_neededFeatureNotSupported ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225AdmissionRejectReason DeleteAlternation */
HS_RESULT ASNH225AdmissionRejectReason_DeleteAlternation(void *pObject)
{
	ASNH225AdmissionRejectReason *pObj = (ASNH225AdmissionRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_calledPartyNotRegistered ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_invalidPermission ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_requestDenied ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_undefinedReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_callerNotRegistered ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_routeCallToGatekeeper ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_invalidEndpointIdentifier ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_resourceUnavailable ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_securityDenial ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_qosControlNotSupported ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_incompleteAddress ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_aliasesInconsistent ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_routeCallToSCN ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_exceedsCallCapacity ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_collectDestination ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_collectPIN ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_genericDataReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_neededFeatureNotSupported ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225AdmissionRejectReason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225AdmissionRejectReason Encode */
HS_RESULT ASNH225AdmissionRejectReason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225AdmissionRejectReason *pObj = (ASNH225AdmissionRejectReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225AdmissionRejectReasonChoiceSize )
		{
			if( pObj->choice > ((ASNH225AdmissionRejectReasonChoice)(e_ASNH225AdmissionRejectReasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225AdmissionRejectReasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH225AdmissionRejectReasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_calledPartyNotRegistered ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_invalidPermission ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_requestDenied ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_callerNotRegistered ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_routeCallToGatekeeper ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_invalidEndpointIdentifier ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_resourceUnavailable ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_securityDenial ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_qosControlNotSupported ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_incompleteAddress ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_aliasesInconsistent ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_routeCallToSCN ){
		AsnStream tTempStrm;
		 new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_exceedsCallCapacity ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_collectDestination ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_collectPIN ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_genericDataReason ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_neededFeatureNotSupported ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225AdmissionRejectReason Decode */
HS_RESULT ASNH225AdmissionRejectReason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225AdmissionRejectReason *pObj = (ASNH225AdmissionRejectReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225AdmissionRejectReasonChoiceSize;
	}
	else
	{
		if( e_ASNH225AdmissionRejectReasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225AdmissionRejectReasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225AdmissionRejectReasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225AdmissionRejectReason_SetChoice( pObj, (ASNH225AdmissionRejectReasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_calledPartyNotRegistered ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_invalidPermission ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_requestDenied ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_callerNotRegistered ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_routeCallToGatekeeper ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_invalidEndpointIdentifier ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_resourceUnavailable ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_securityDenial ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_qosControlNotSupported ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_incompleteAddress ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_aliasesInconsistent ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_routeCallToSCN ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_exceedsCallCapacity ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_collectDestination ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_collectPIN ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_genericDataReason ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_neededFeatureNotSupported ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225AdmissionRejectReason Print */
HS_RESULT ASNH225AdmissionRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225AdmissionRejectReason *pObj = (ASNH225AdmissionRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225AdmissionRejectReason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_calledPartyNotRegistered ){
		AsnNull_Print( pObj->alter, pDepth+1, "calledPartyNotRegistered" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_invalidPermission ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidPermission" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_requestDenied ){
		AsnNull_Print( pObj->alter, pDepth+1, "requestDenied" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_undefinedReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "undefinedReason" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_callerNotRegistered ){
		AsnNull_Print( pObj->alter, pDepth+1, "callerNotRegistered" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_routeCallToGatekeeper ){
		AsnNull_Print( pObj->alter, pDepth+1, "routeCallToGatekeeper" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_invalidEndpointIdentifier ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidEndpointIdentifier" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_resourceUnavailable ){
		AsnNull_Print( pObj->alter, pDepth+1, "resourceUnavailable" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_securityDenial ){
		AsnNull_Print( pObj->alter, pDepth+1, "securityDenial" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_qosControlNotSupported ){
		AsnNull_Print( pObj->alter, pDepth+1, "qosControlNotSupported" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_incompleteAddress ){
		AsnNull_Print( pObj->alter, pDepth+1, "incompleteAddress" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_aliasesInconsistent ){
		AsnNull_Print( pObj->alter, pDepth+1, "aliasesInconsistent" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_routeCallToSCN ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "routeCallToSCN" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_exceedsCallCapacity ){
		AsnNull_Print( pObj->alter, pDepth+1, "exceedsCallCapacity" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_collectDestination ){
		AsnNull_Print( pObj->alter, pDepth+1, "collectDestination" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_collectPIN ){
		AsnNull_Print( pObj->alter, pDepth+1, "collectPIN" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_genericDataReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "genericDataReason" );
	}
	else if ( pObj->choice == e_ASNH225AdmissionRejectReasonChoice_neededFeatureNotSupported ){
		AsnNull_Print( pObj->alter, pDepth+1, "neededFeatureNotSupported" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225AdmissionReject Class
*/
/*ASNH225AdmissionReject Constructor*/
HS_RESULT new_ASNH225AdmissionReject(void *pObject)
{
	ASNH225AdmissionReject *pObj = (ASNH225AdmissionReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225AdmissionReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225AdmissionRejectReason( &(pObj->m_rejectReason) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_callSignalAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225AdmissionReject Destructor */
HS_RESULT delete_ASNH225AdmissionReject(void *pObject)
{
	ASNH225AdmissionReject *pObj = (ASNH225AdmissionReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225AdmissionReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225AdmissionRejectReason( &(pObj->m_rejectReason) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_AsnSequenceOf( &(pObj->m_callSignalAddress) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225AdmissionReject MakeMold */
HS_RESULT ASNH225AdmissionReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225AdmissionReject *pObj = (ASNH225AdmissionReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225AdmissionRejectReason_MakeMold(&(pObj->m_rejectReason));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225AltGKInfo_MakeMold(&(pObj->m_altGKInfo));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	{
	ASNH225TransportAddress *tmold_callSignalAddress = (ASNH225TransportAddress *)HSMalloc( sizeof(ASNH225TransportAddress) );
	new_ASNH225TransportAddress(tmold_callSignalAddress);
	ASNH225TransportAddress_MakeMold(tmold_callSignalAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_callSignalAddress,sizeof(ASNH225TransportAddress),ASNH225TransportAddress_MakeMold,ASNH225TransportAddress_Encode,ASNH225TransportAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225TransportAddress_Print,
#endif
		delete_ASNH225TransportAddress);
	AsnSequenceOf_SetMold( &(pObj->m_callSignalAddress), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225AdmissionReject IncludeOptionalField */
HS_RESULT ASNH225AdmissionReject_IncludeOptionField( void *pObject, ASNH225AdmissionRejectOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225AdmissionReject *pObj = (ASNH225AdmissionReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionReject_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225AdmissionRejectOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225AdmissionRejectOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225AdmissionRejectOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225AdmissionReject IsIncludeOptionalField */
BOOL ASNH225AdmissionReject_IsIncludeOptionField( void *pObject, ASNH225AdmissionRejectOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225AdmissionReject *pObj = (ASNH225AdmissionReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionReject_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225AdmissionRejectOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225AdmissionRejectOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225AdmissionRejectOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225AdmissionReject Encode */
HS_RESULT ASNH225AdmissionReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225AdmissionReject *pObj = (ASNH225AdmissionReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225AdmissionRejectOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225AdmissionRejectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225AdmissionRejectReason_Encode( &(pObj->m_rejectReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_altGKInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_altGKInfo), ASNH225AltGKInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_callSignalAddress ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callSignalAddress), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225AdmissionReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225AdmissionReject Decode */
HS_RESULT ASNH225AdmissionReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225AdmissionReject *pObj = (ASNH225AdmissionReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225AdmissionRejectOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225AdmissionRejectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225AdmissionRejectReason_Decode(&(pObj->m_rejectReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_altGKInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_altGKInfo), ASNH225AltGKInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_callSignalAddress ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callSignalAddress), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_serviceControl ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_serviceControl), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AdmissionReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225AdmissionReject Print */
HS_RESULT ASNH225AdmissionReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225AdmissionReject *pObj = (ASNH225AdmissionReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225AdmissionReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225AdmissionRejectReason_Print( &(pObj->m_rejectReason), pDepth+1, "rejectReason" );
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_altGKInfo ) )
		ASNH225AltGKInfo_Print( &(pObj->m_altGKInfo), pDepth+1, "altGKInfo" );
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_callSignalAddress ) )
		AsnSequenceOf_Print( &(pObj->m_callSignalAddress), pDepth+1, "callSignalAddress" );
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_serviceControl ) )
		AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	if( ASNH225AdmissionReject_IsIncludeOptionField( pObj, e_ASNH225AdmissionRejectOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225BandwidthRequest Class
*/
/*ASNH225BandwidthRequest Constructor*/
HS_RESULT new_ASNH225BandwidthRequest(void *pObject)
{
	ASNH225BandwidthRequest *pObj = (ASNH225BandwidthRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225BandwidthRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	new_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	new_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	new_ASNH225CallType( &(pObj->m_callType) );
	new_ASNH225BandWidth( &(pObj->m_bandWidth) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_ASNH225GatekeeperIdentifier( &(pObj->m_gatekeeperIdentifier) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnBoolean( &(pObj->m_answeredCall) );
	new_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_ASNH225RasUsageInformation( &(pObj->m_usageInformation) );
	new_AsnSequenceOf( &(pObj->m_bandwidthDetails), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225BandwidthRequest Destructor */
HS_RESULT delete_ASNH225BandwidthRequest(void *pObject)
{
	ASNH225BandwidthRequest *pObj = (ASNH225BandwidthRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225BandwidthRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	delete_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	delete_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	delete_ASNH225CallType( &(pObj->m_callType) );
	delete_ASNH225BandWidth( &(pObj->m_bandWidth) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_ASNH225GatekeeperIdentifier( &(pObj->m_gatekeeperIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnBoolean( &(pObj->m_answeredCall) );
	delete_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_ASNH225RasUsageInformation( &(pObj->m_usageInformation) );
	delete_AsnSequenceOf( &(pObj->m_bandwidthDetails) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225BandwidthRequest MakeMold */
HS_RESULT ASNH225BandwidthRequest_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225BandwidthRequest *pObj = (ASNH225BandwidthRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225EndpointIdentifier_MakeMold(&(pObj->m_endpointIdentifier));
	ASNH225ConferenceIdentifier_MakeMold(&(pObj->m_conferenceID));
	ASNH225CallReferenceValue_MakeMold(&(pObj->m_callReferenceValue));
	ASNH225CallType_MakeMold(&(pObj->m_callType));
	ASNH225BandWidth_MakeMold(&(pObj->m_bandWidth));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	ASNH225GatekeeperIdentifier_MakeMold(&(pObj->m_gatekeeperIdentifier));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225CallLinkage_MakeMold(&(pObj->m_callLinkage));
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	ASNH225RasUsageInformation_MakeMold(&(pObj->m_usageInformation));
	{
	ASNH225BandwidthDetails *tmold_bandwidthDetails = (ASNH225BandwidthDetails *)HSMalloc( sizeof(ASNH225BandwidthDetails) );
	new_ASNH225BandwidthDetails(tmold_bandwidthDetails);
	ASNH225BandwidthDetails_MakeMold(tmold_bandwidthDetails);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_bandwidthDetails,sizeof(ASNH225BandwidthDetails),ASNH225BandwidthDetails_MakeMold,ASNH225BandwidthDetails_Encode,ASNH225BandwidthDetails_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225BandwidthDetails_Print,
#endif
		delete_ASNH225BandwidthDetails);
	AsnSequenceOf_SetMold( &(pObj->m_bandwidthDetails), moldObject );
	}
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225BandwidthRequest IncludeOptionalField */
HS_RESULT ASNH225BandwidthRequest_IncludeOptionField( void *pObject, ASNH225BandwidthRequestOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225BandwidthRequest *pObj = (ASNH225BandwidthRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225BandwidthRequestOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225BandwidthRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225BandwidthRequestOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225BandwidthRequest IsIncludeOptionalField */
BOOL ASNH225BandwidthRequest_IsIncludeOptionField( void *pObject, ASNH225BandwidthRequestOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225BandwidthRequest *pObj = (ASNH225BandwidthRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225BandwidthRequestOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225BandwidthRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225BandwidthRequestOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225BandwidthRequest Encode */
HS_RESULT ASNH225BandwidthRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225BandwidthRequest *pObj = (ASNH225BandwidthRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225BandwidthRequestOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225BandwidthRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointIdentifier_Encode( &(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Encode( &(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallReferenceValue_Encode( &(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_callType ) ){
		if( (tRet=ASNH225CallType_Encode( &(pObj->m_callType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225BandWidth_Encode( &(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_gatekeeperIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_gatekeeperIdentifier), ASNH225GatekeeperIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_answeredCall ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_answeredCall), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_callLinkage ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_usageInformation ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_usageInformation), ASNH225RasUsageInformation_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_bandwidthDetails ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_bandwidthDetails), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225BandwidthRequest Decode */
HS_RESULT ASNH225BandwidthRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225BandwidthRequest *pObj = (ASNH225BandwidthRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225BandwidthRequestOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225BandwidthRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointIdentifier_Decode(&(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Decode(&(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallReferenceValue_Decode(&(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_callType ) ){
		if( (tRet=ASNH225CallType_Decode(&(pObj->m_callType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225BandWidth_Decode(&(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_gatekeeperIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_gatekeeperIdentifier), ASNH225GatekeeperIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_answeredCall ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_answeredCall), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_callLinkage ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_usageInformation ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_usageInformation), ASNH225RasUsageInformation_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_bandwidthDetails ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_bandwidthDetails), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225BandwidthRequest Print */
HS_RESULT ASNH225BandwidthRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225BandwidthRequest *pObj = (ASNH225BandwidthRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225BandwidthRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225EndpointIdentifier_Print( &(pObj->m_endpointIdentifier), pDepth+1, "endpointIdentifier" );
	ASNH225ConferenceIdentifier_Print( &(pObj->m_conferenceID), pDepth+1, "conferenceID" );
	ASNH225CallReferenceValue_Print( &(pObj->m_callReferenceValue), pDepth+1, "callReferenceValue" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_callType ) )
		ASNH225CallType_Print( &(pObj->m_callType), pDepth+1, "callType" );
	ASNH225BandWidth_Print( &(pObj->m_bandWidth), pDepth+1, "bandWidth" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_gatekeeperIdentifier ) )
		ASNH225GatekeeperIdentifier_Print( &(pObj->m_gatekeeperIdentifier), pDepth+1, "gatekeeperIdentifier" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_answeredCall ) )
		AsnBoolean_Print( &(pObj->m_answeredCall), pDepth+1, "answeredCall" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_callLinkage ) )
		ASNH225CallLinkage_Print( &(pObj->m_callLinkage), pDepth+1, "callLinkage" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_usageInformation ) )
		ASNH225RasUsageInformation_Print( &(pObj->m_usageInformation), pDepth+1, "usageInformation" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_bandwidthDetails ) )
		AsnSequenceOf_Print( &(pObj->m_bandwidthDetails), pDepth+1, "bandwidthDetails" );
	if( ASNH225BandwidthRequest_IsIncludeOptionField( pObj, e_ASNH225BandwidthRequestOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225BandwidthConfirm Class
*/
/*ASNH225BandwidthConfirm Constructor*/
HS_RESULT new_ASNH225BandwidthConfirm(void *pObject)
{
	ASNH225BandwidthConfirm *pObj = (ASNH225BandwidthConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225BandwidthConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225BandWidth( &(pObj->m_bandWidth) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225BandwidthConfirm Destructor */
HS_RESULT delete_ASNH225BandwidthConfirm(void *pObject)
{
	ASNH225BandwidthConfirm *pObj = (ASNH225BandwidthConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225BandwidthConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225BandWidth( &(pObj->m_bandWidth) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225BandwidthConfirm MakeMold */
HS_RESULT ASNH225BandwidthConfirm_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225BandwidthConfirm *pObj = (ASNH225BandwidthConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthConfirm_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225BandWidth_MakeMold(&(pObj->m_bandWidth));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225BandwidthConfirm IncludeOptionalField */
HS_RESULT ASNH225BandwidthConfirm_IncludeOptionField( void *pObject, ASNH225BandwidthConfirmOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225BandwidthConfirm *pObj = (ASNH225BandwidthConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225BandwidthConfirmOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225BandwidthConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225BandwidthConfirmOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225BandwidthConfirm IsIncludeOptionalField */
BOOL ASNH225BandwidthConfirm_IsIncludeOptionField( void *pObject, ASNH225BandwidthConfirmOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225BandwidthConfirm *pObj = (ASNH225BandwidthConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225BandwidthConfirmOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225BandwidthConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225BandwidthConfirmOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225BandwidthConfirm Encode */
HS_RESULT ASNH225BandwidthConfirm_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225BandwidthConfirm *pObj = (ASNH225BandwidthConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthConfirm_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225BandwidthConfirmOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225BandwidthConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandWidth_Encode( &(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225BandwidthConfirm Decode */
HS_RESULT ASNH225BandwidthConfirm_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225BandwidthConfirm *pObj = (ASNH225BandwidthConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthConfirm_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225BandwidthConfirmOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225BandwidthConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandWidth_Decode(&(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225BandwidthConfirm Print */
HS_RESULT ASNH225BandwidthConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225BandwidthConfirm *pObj = (ASNH225BandwidthConfirm *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225BandwidthConfirm_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225BandWidth_Print( &(pObj->m_bandWidth), pDepth+1, "bandWidth" );
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225BandwidthConfirm_IsIncludeOptionField( pObj, e_ASNH225BandwidthConfirmOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225BandRejectReason Struct
*/
/* ASNH225BandRejectReason Constructor */
HS_RESULT new_ASNH225BandRejectReason( void *pObject )
{
	ASNH225BandRejectReason *pObj = (ASNH225BandRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225BandRejectReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225BandRejectReasonChoice_notBound;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225BandRejectReasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225BandRejectReason Destructor */
HS_RESULT delete_ASNH225BandRejectReason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225BandRejectReason *pObj = (ASNH225BandRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225BandRejectReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225BandRejectReason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225BandRejectReason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225BandRejectReason SetChoice */
void* ASNH225BandRejectReason_SetChoice( void *pObject, ASNH225BandRejectReasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225BandRejectReason *pObj = (ASNH225BandRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandRejectReason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225BandRejectReasonChoiceSizeExt ){
		if( pChoice > (ASNH225BandRejectReasonChoice)(e_ASNH225BandRejectReasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225BandRejectReason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225BandRejectReasonChoice_notBound ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225BandRejectReasonChoice_invalidConferenceID ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225BandRejectReasonChoice_invalidPermission ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225BandRejectReasonChoice_insufficientResources ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225BandRejectReasonChoice_invalidRevision ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225BandRejectReasonChoice_undefinedReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225BandRejectReasonChoice_securityDenial ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandRejectReason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225BandRejectReason DeleteAlternation */
HS_RESULT ASNH225BandRejectReason_DeleteAlternation(void *pObject)
{
	ASNH225BandRejectReason *pObj = (ASNH225BandRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandRejectReason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225BandRejectReasonChoice_notBound ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidConferenceID ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidPermission ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_insufficientResources ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidRevision ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_undefinedReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_securityDenial ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225BandRejectReason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225BandRejectReason Encode */
HS_RESULT ASNH225BandRejectReason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225BandRejectReason *pObj = (ASNH225BandRejectReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandRejectReason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandRejectReason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225BandRejectReasonChoiceSize )
		{
			if( pObj->choice > ((ASNH225BandRejectReasonChoice)(e_ASNH225BandRejectReasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225BandRejectReasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH225BandRejectReasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225BandRejectReasonChoice_notBound ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidConferenceID ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidPermission ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_insufficientResources ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidRevision ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_securityDenial ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandRejectReason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225BandRejectReason Decode */
HS_RESULT ASNH225BandRejectReason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225BandRejectReason *pObj = (ASNH225BandRejectReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandRejectReason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225BandRejectReasonChoiceSize;
	}
	else
	{
		if( e_ASNH225BandRejectReasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225BandRejectReasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225BandRejectReasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225BandRejectReason_SetChoice( pObj, (ASNH225BandRejectReasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandRejectReason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225BandRejectReasonChoice_notBound ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidConferenceID ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidPermission ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_insufficientResources ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidRevision ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_securityDenial ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandRejectReason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225BandRejectReason Print */
HS_RESULT ASNH225BandRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225BandRejectReason *pObj = (ASNH225BandRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225BandRejectReason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225BandRejectReasonChoice_notBound ){
		AsnNull_Print( pObj->alter, pDepth+1, "notBound" );
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidConferenceID ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidConferenceID" );
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidPermission ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidPermission" );
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_insufficientResources ){
		AsnNull_Print( pObj->alter, pDepth+1, "insufficientResources" );
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_invalidRevision ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidRevision" );
	}
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_undefinedReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "undefinedReason" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225BandRejectReasonChoice_securityDenial ){
		AsnNull_Print( pObj->alter, pDepth+1, "securityDenial" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225BandwidthReject Class
*/
/*ASNH225BandwidthReject Constructor*/
HS_RESULT new_ASNH225BandwidthReject(void *pObject)
{
	ASNH225BandwidthReject *pObj = (ASNH225BandwidthReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225BandwidthReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225BandRejectReason( &(pObj->m_rejectReason) );
	new_ASNH225BandWidth( &(pObj->m_allowedBandWidth) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225BandwidthReject Destructor */
HS_RESULT delete_ASNH225BandwidthReject(void *pObject)
{
	ASNH225BandwidthReject *pObj = (ASNH225BandwidthReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225BandwidthReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225BandRejectReason( &(pObj->m_rejectReason) );
	delete_ASNH225BandWidth( &(pObj->m_allowedBandWidth) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225BandwidthReject MakeMold */
HS_RESULT ASNH225BandwidthReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225BandwidthReject *pObj = (ASNH225BandwidthReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225BandRejectReason_MakeMold(&(pObj->m_rejectReason));
	ASNH225BandWidth_MakeMold(&(pObj->m_allowedBandWidth));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225AltGKInfo_MakeMold(&(pObj->m_altGKInfo));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225BandwidthReject IncludeOptionalField */
HS_RESULT ASNH225BandwidthReject_IncludeOptionField( void *pObject, ASNH225BandwidthRejectOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225BandwidthReject *pObj = (ASNH225BandwidthReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225BandwidthRejectOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225BandwidthRejectOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225BandwidthRejectOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225BandwidthReject IsIncludeOptionalField */
BOOL ASNH225BandwidthReject_IsIncludeOptionField( void *pObject, ASNH225BandwidthRejectOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225BandwidthReject *pObj = (ASNH225BandwidthReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225BandwidthRejectOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225BandwidthRejectOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225BandwidthRejectOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225BandwidthReject Encode */
HS_RESULT ASNH225BandwidthReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225BandwidthReject *pObj = (ASNH225BandwidthReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225BandwidthRejectOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225BandwidthRejectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandRejectReason_Encode( &(pObj->m_rejectReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandWidth_Encode( &(pObj->m_allowedBandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_altGKInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_altGKInfo), ASNH225AltGKInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225BandwidthReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225BandwidthReject Decode */
HS_RESULT ASNH225BandwidthReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225BandwidthReject *pObj = (ASNH225BandwidthReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225BandwidthRejectOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225BandwidthRejectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandRejectReason_Decode(&(pObj->m_rejectReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandWidth_Decode(&(pObj->m_allowedBandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225BandwidthReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_altGKInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_altGKInfo), ASNH225AltGKInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225BandwidthReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225BandwidthReject Print */
HS_RESULT ASNH225BandwidthReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225BandwidthReject *pObj = (ASNH225BandwidthReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225BandwidthReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225BandRejectReason_Print( &(pObj->m_rejectReason), pDepth+1, "rejectReason" );
	ASNH225BandWidth_Print( &(pObj->m_allowedBandWidth), pDepth+1, "allowedBandWidth" );
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_altGKInfo ) )
		ASNH225AltGKInfo_Print( &(pObj->m_altGKInfo), pDepth+1, "altGKInfo" );
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225BandwidthReject_IsIncludeOptionField( pObj, e_ASNH225BandwidthRejectOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225DisengageReason Struct
*/
/* ASNH225DisengageReason Constructor */
HS_RESULT new_ASNH225DisengageReason( void *pObject )
{
	ASNH225DisengageReason *pObj = (ASNH225DisengageReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225DisengageReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225DisengageReasonChoice_forcedDrop;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225DisengageReasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225DisengageReason Destructor */
HS_RESULT delete_ASNH225DisengageReason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225DisengageReason *pObj = (ASNH225DisengageReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225DisengageReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225DisengageReason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225DisengageReason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225DisengageReason SetChoice */
void* ASNH225DisengageReason_SetChoice( void *pObject, ASNH225DisengageReasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225DisengageReason *pObj = (ASNH225DisengageReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225DisengageReasonChoiceSizeExt ){
		if( pChoice > (ASNH225DisengageReasonChoice)(e_ASNH225DisengageReasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225DisengageReason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225DisengageReasonChoice_forcedDrop ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225DisengageReasonChoice_normalDrop ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225DisengageReasonChoice_undefinedReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225DisengageReason DeleteAlternation */
HS_RESULT ASNH225DisengageReason_DeleteAlternation(void *pObject)
{
	ASNH225DisengageReason *pObj = (ASNH225DisengageReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225DisengageReasonChoice_forcedDrop ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225DisengageReasonChoice_normalDrop ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225DisengageReasonChoice_undefinedReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225DisengageReason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225DisengageReason Encode */
HS_RESULT ASNH225DisengageReason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225DisengageReason *pObj = (ASNH225DisengageReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225DisengageReasonChoiceSize )
		{
			if( pObj->choice > ((ASNH225DisengageReasonChoice)(e_ASNH225DisengageReasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225DisengageReasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH225DisengageReasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225DisengageReasonChoice_forcedDrop ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225DisengageReasonChoice_normalDrop ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225DisengageReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225DisengageReason Decode */
HS_RESULT ASNH225DisengageReason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225DisengageReason *pObj = (ASNH225DisengageReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225DisengageReasonChoiceSize;
	}
	else
	{
		if( e_ASNH225DisengageReasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225DisengageReasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225DisengageReasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225DisengageReason_SetChoice( pObj, (ASNH225DisengageReasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225DisengageReasonChoice_forcedDrop ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225DisengageReasonChoice_normalDrop ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225DisengageReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225DisengageReason Print */
HS_RESULT ASNH225DisengageReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225DisengageReason *pObj = (ASNH225DisengageReason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225DisengageReason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225DisengageReasonChoice_forcedDrop ){
		AsnNull_Print( pObj->alter, pDepth+1, "forcedDrop" );
	}
	else if ( pObj->choice == e_ASNH225DisengageReasonChoice_normalDrop ){
		AsnNull_Print( pObj->alter, pDepth+1, "normalDrop" );
	}
	else if ( pObj->choice == e_ASNH225DisengageReasonChoice_undefinedReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "undefinedReason" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225DisengageRequest Class
*/
/*ASNH225DisengageRequest Constructor*/
HS_RESULT new_ASNH225DisengageRequest(void *pObject)
{
	ASNH225DisengageRequest *pObj = (ASNH225DisengageRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225DisengageRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	new_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	new_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	new_ASNH225DisengageReason( &(pObj->m_disengageReason) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_ASNH225GatekeeperIdentifier( &(pObj->m_gatekeeperIdentifier) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnBoolean( &(pObj->m_answeredCall) );
	new_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	new_ASNH225RasUsageInformation( &(pObj->m_usageInformation) );
	new_ASNH225CallTerminationCause( &(pObj->m_terminationCause) );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225DisengageRequest Destructor */
HS_RESULT delete_ASNH225DisengageRequest(void *pObject)
{
	ASNH225DisengageRequest *pObj = (ASNH225DisengageRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225DisengageRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	delete_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	delete_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	delete_ASNH225DisengageReason( &(pObj->m_disengageReason) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_ASNH225GatekeeperIdentifier( &(pObj->m_gatekeeperIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnBoolean( &(pObj->m_answeredCall) );
	delete_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	delete_ASNH225RasUsageInformation( &(pObj->m_usageInformation) );
	delete_ASNH225CallTerminationCause( &(pObj->m_terminationCause) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225DisengageRequest MakeMold */
HS_RESULT ASNH225DisengageRequest_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225DisengageRequest *pObj = (ASNH225DisengageRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225EndpointIdentifier_MakeMold(&(pObj->m_endpointIdentifier));
	ASNH225ConferenceIdentifier_MakeMold(&(pObj->m_conferenceID));
	ASNH225CallReferenceValue_MakeMold(&(pObj->m_callReferenceValue));
	ASNH225DisengageReason_MakeMold(&(pObj->m_disengageReason));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	ASNH225GatekeeperIdentifier_MakeMold(&(pObj->m_gatekeeperIdentifier));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225CallLinkage_MakeMold(&(pObj->m_callLinkage));
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	ASNH225RasUsageInformation_MakeMold(&(pObj->m_usageInformation));
	ASNH225CallTerminationCause_MakeMold(&(pObj->m_terminationCause));
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225DisengageRequest IncludeOptionalField */
HS_RESULT ASNH225DisengageRequest_IncludeOptionField( void *pObject, ASNH225DisengageRequestOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225DisengageRequest *pObj = (ASNH225DisengageRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225DisengageRequestOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225DisengageRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225DisengageRequestOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225DisengageRequest IsIncludeOptionalField */
BOOL ASNH225DisengageRequest_IsIncludeOptionField( void *pObject, ASNH225DisengageRequestOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225DisengageRequest *pObj = (ASNH225DisengageRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225DisengageRequestOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225DisengageRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225DisengageRequestOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225DisengageRequest Encode */
HS_RESULT ASNH225DisengageRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225DisengageRequest *pObj = (ASNH225DisengageRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225DisengageRequestOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225DisengageRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointIdentifier_Encode( &(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Encode( &(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallReferenceValue_Encode( &(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225DisengageReason_Encode( &(pObj->m_disengageReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_gatekeeperIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_gatekeeperIdentifier), ASNH225GatekeeperIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_answeredCall ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_answeredCall), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_callLinkage ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_usageInformation ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_usageInformation), ASNH225RasUsageInformation_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_terminationCause ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_terminationCause), ASNH225CallTerminationCause_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225DisengageRequest Decode */
HS_RESULT ASNH225DisengageRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225DisengageRequest *pObj = (ASNH225DisengageRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225DisengageRequestOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225DisengageRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointIdentifier_Decode(&(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Decode(&(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallReferenceValue_Decode(&(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225DisengageReason_Decode(&(pObj->m_disengageReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_gatekeeperIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_gatekeeperIdentifier), ASNH225GatekeeperIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_answeredCall ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_answeredCall), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_callLinkage ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_circuitInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_usageInformation ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_usageInformation), ASNH225RasUsageInformation_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_terminationCause ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_terminationCause), ASNH225CallTerminationCause_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_serviceControl ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_serviceControl), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225DisengageRequest Print */
HS_RESULT ASNH225DisengageRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225DisengageRequest *pObj = (ASNH225DisengageRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225DisengageRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225EndpointIdentifier_Print( &(pObj->m_endpointIdentifier), pDepth+1, "endpointIdentifier" );
	ASNH225ConferenceIdentifier_Print( &(pObj->m_conferenceID), pDepth+1, "conferenceID" );
	ASNH225CallReferenceValue_Print( &(pObj->m_callReferenceValue), pDepth+1, "callReferenceValue" );
	ASNH225DisengageReason_Print( &(pObj->m_disengageReason), pDepth+1, "disengageReason" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_gatekeeperIdentifier ) )
		ASNH225GatekeeperIdentifier_Print( &(pObj->m_gatekeeperIdentifier), pDepth+1, "gatekeeperIdentifier" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_answeredCall ) )
		AsnBoolean_Print( &(pObj->m_answeredCall), pDepth+1, "answeredCall" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_callLinkage ) )
		ASNH225CallLinkage_Print( &(pObj->m_callLinkage), pDepth+1, "callLinkage" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_circuitInfo ) )
		ASNH225CircuitInfo_Print( &(pObj->m_circuitInfo), pDepth+1, "circuitInfo" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_usageInformation ) )
		ASNH225RasUsageInformation_Print( &(pObj->m_usageInformation), pDepth+1, "usageInformation" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_terminationCause ) )
		ASNH225CallTerminationCause_Print( &(pObj->m_terminationCause), pDepth+1, "terminationCause" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_serviceControl ) )
		AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	if( ASNH225DisengageRequest_IsIncludeOptionField( pObj, e_ASNH225DisengageRequestOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225DisengageConfirm Class
*/
/*ASNH225DisengageConfirm Constructor*/
HS_RESULT new_ASNH225DisengageConfirm(void *pObject)
{
	ASNH225DisengageConfirm *pObj = (ASNH225DisengageConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225DisengageConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	new_ASNH225RasUsageInformation( &(pObj->m_usageInformation) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225DisengageConfirm Destructor */
HS_RESULT delete_ASNH225DisengageConfirm(void *pObject)
{
	ASNH225DisengageConfirm *pObj = (ASNH225DisengageConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225DisengageConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	delete_ASNH225RasUsageInformation( &(pObj->m_usageInformation) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225DisengageConfirm MakeMold */
HS_RESULT ASNH225DisengageConfirm_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225DisengageConfirm *pObj = (ASNH225DisengageConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageConfirm_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	ASNH225RasUsageInformation_MakeMold(&(pObj->m_usageInformation));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225DisengageConfirm IncludeOptionalField */
HS_RESULT ASNH225DisengageConfirm_IncludeOptionField( void *pObject, ASNH225DisengageConfirmOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225DisengageConfirm *pObj = (ASNH225DisengageConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225DisengageConfirmOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225DisengageConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225DisengageConfirmOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225DisengageConfirm IsIncludeOptionalField */
BOOL ASNH225DisengageConfirm_IsIncludeOptionField( void *pObject, ASNH225DisengageConfirmOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225DisengageConfirm *pObj = (ASNH225DisengageConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225DisengageConfirmOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225DisengageConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225DisengageConfirmOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225DisengageConfirm Encode */
HS_RESULT ASNH225DisengageConfirm_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225DisengageConfirm *pObj = (ASNH225DisengageConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225DisengageConfirmOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225DisengageConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_usageInformation ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_usageInformation), ASNH225RasUsageInformation_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225DisengageConfirm Decode */
HS_RESULT ASNH225DisengageConfirm_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225DisengageConfirm *pObj = (ASNH225DisengageConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225DisengageConfirmOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225DisengageConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_circuitInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_usageInformation ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_usageInformation), ASNH225RasUsageInformation_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225DisengageConfirm Print */
HS_RESULT ASNH225DisengageConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225DisengageConfirm *pObj = (ASNH225DisengageConfirm *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225DisengageConfirm_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_circuitInfo ) )
		ASNH225CircuitInfo_Print( &(pObj->m_circuitInfo), pDepth+1, "circuitInfo" );
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_usageInformation ) )
		ASNH225RasUsageInformation_Print( &(pObj->m_usageInformation), pDepth+1, "usageInformation" );
	if( ASNH225DisengageConfirm_IsIncludeOptionField( pObj, e_ASNH225DisengageConfirmOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225DisengageRejectReason Struct
*/
/* ASNH225DisengageRejectReason Constructor */
HS_RESULT new_ASNH225DisengageRejectReason( void *pObject )
{
	ASNH225DisengageRejectReason *pObj = (ASNH225DisengageRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225DisengageRejectReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225DisengageRejectReasonChoice_notRegistered;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225DisengageRejectReasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225DisengageRejectReason Destructor */
HS_RESULT delete_ASNH225DisengageRejectReason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225DisengageRejectReason *pObj = (ASNH225DisengageRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225DisengageRejectReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225DisengageRejectReason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225DisengageRejectReason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225DisengageRejectReason SetChoice */
void* ASNH225DisengageRejectReason_SetChoice( void *pObject, ASNH225DisengageRejectReasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225DisengageRejectReason *pObj = (ASNH225DisengageRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRejectReason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225DisengageRejectReasonChoiceSizeExt ){
		if( pChoice > (ASNH225DisengageRejectReasonChoice)(e_ASNH225DisengageRejectReasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225DisengageRejectReason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225DisengageRejectReasonChoice_notRegistered ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225DisengageRejectReasonChoice_requestToDropOther ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225DisengageRejectReasonChoice_securityDenial ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRejectReason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225DisengageRejectReason DeleteAlternation */
HS_RESULT ASNH225DisengageRejectReason_DeleteAlternation(void *pObject)
{
	ASNH225DisengageRejectReason *pObj = (ASNH225DisengageRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRejectReason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225DisengageRejectReasonChoice_notRegistered ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225DisengageRejectReasonChoice_requestToDropOther ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225DisengageRejectReasonChoice_securityDenial ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225DisengageRejectReason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225DisengageRejectReason Encode */
HS_RESULT ASNH225DisengageRejectReason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225DisengageRejectReason *pObj = (ASNH225DisengageRejectReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRejectReason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRejectReason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225DisengageRejectReasonChoiceSize )
		{
			if( pObj->choice > ((ASNH225DisengageRejectReasonChoice)(e_ASNH225DisengageRejectReasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225DisengageRejectReasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH225DisengageRejectReasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225DisengageRejectReasonChoice_notRegistered ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225DisengageRejectReasonChoice_requestToDropOther ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225DisengageRejectReasonChoice_securityDenial ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRejectReason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225DisengageRejectReason Decode */
HS_RESULT ASNH225DisengageRejectReason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225DisengageRejectReason *pObj = (ASNH225DisengageRejectReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRejectReason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225DisengageRejectReasonChoiceSize;
	}
	else
	{
		if( e_ASNH225DisengageRejectReasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225DisengageRejectReasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225DisengageRejectReasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225DisengageRejectReason_SetChoice( pObj, (ASNH225DisengageRejectReasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRejectReason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225DisengageRejectReasonChoice_notRegistered ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225DisengageRejectReasonChoice_requestToDropOther ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225DisengageRejectReasonChoice_securityDenial ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageRejectReason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225DisengageRejectReason Print */
HS_RESULT ASNH225DisengageRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225DisengageRejectReason *pObj = (ASNH225DisengageRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225DisengageRejectReason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225DisengageRejectReasonChoice_notRegistered ){
		AsnNull_Print( pObj->alter, pDepth+1, "notRegistered" );
	}
	else if ( pObj->choice == e_ASNH225DisengageRejectReasonChoice_requestToDropOther ){
		AsnNull_Print( pObj->alter, pDepth+1, "requestToDropOther" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225DisengageRejectReasonChoice_securityDenial ){
		AsnNull_Print( pObj->alter, pDepth+1, "securityDenial" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225DisengageReject Class
*/
/*ASNH225DisengageReject Constructor*/
HS_RESULT new_ASNH225DisengageReject(void *pObject)
{
	ASNH225DisengageReject *pObj = (ASNH225DisengageReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225DisengageReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225DisengageRejectReason( &(pObj->m_rejectReason) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225DisengageReject Destructor */
HS_RESULT delete_ASNH225DisengageReject(void *pObject)
{
	ASNH225DisengageReject *pObj = (ASNH225DisengageReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225DisengageReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225DisengageRejectReason( &(pObj->m_rejectReason) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225DisengageReject MakeMold */
HS_RESULT ASNH225DisengageReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225DisengageReject *pObj = (ASNH225DisengageReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225DisengageRejectReason_MakeMold(&(pObj->m_rejectReason));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225AltGKInfo_MakeMold(&(pObj->m_altGKInfo));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225DisengageReject IncludeOptionalField */
HS_RESULT ASNH225DisengageReject_IncludeOptionField( void *pObject, ASNH225DisengageRejectOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225DisengageReject *pObj = (ASNH225DisengageReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReject_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225DisengageRejectOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225DisengageRejectOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225DisengageRejectOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225DisengageReject IsIncludeOptionalField */
BOOL ASNH225DisengageReject_IsIncludeOptionField( void *pObject, ASNH225DisengageRejectOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225DisengageReject *pObj = (ASNH225DisengageReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReject_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225DisengageRejectOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225DisengageRejectOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225DisengageRejectOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225DisengageReject Encode */
HS_RESULT ASNH225DisengageReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225DisengageReject *pObj = (ASNH225DisengageReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225DisengageRejectOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225DisengageRejectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225DisengageRejectReason_Encode( &(pObj->m_rejectReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_altGKInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_altGKInfo), ASNH225AltGKInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225DisengageReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225DisengageReject Decode */
HS_RESULT ASNH225DisengageReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225DisengageReject *pObj = (ASNH225DisengageReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225DisengageRejectOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225DisengageRejectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225DisengageRejectReason_Decode(&(pObj->m_rejectReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DisengageReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_altGKInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_altGKInfo), ASNH225AltGKInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DisengageReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225DisengageReject Print */
HS_RESULT ASNH225DisengageReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225DisengageReject *pObj = (ASNH225DisengageReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225DisengageReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225DisengageRejectReason_Print( &(pObj->m_rejectReason), pDepth+1, "rejectReason" );
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_altGKInfo ) )
		ASNH225AltGKInfo_Print( &(pObj->m_altGKInfo), pDepth+1, "altGKInfo" );
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225DisengageReject_IsIncludeOptionField( pObj, e_ASNH225DisengageRejectOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225LocationRequest Class
*/
/*ASNH225LocationRequest Constructor*/
HS_RESULT new_ASNH225LocationRequest(void *pObject)
{
	ASNH225LocationRequest *pObj = (ASNH225LocationRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225LocationRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	new_AsnSequenceOf( &(pObj->m_destinationInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225TransportAddress( &(pObj->m_replyAddress) );
	new_AsnSequenceOf( &(pObj->m_sourceInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_canMapAlias) );
	new_ASNH225GatekeeperIdentifier( &(pObj->m_gatekeeperIdentifier) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnSequenceOf( &(pObj->m_desiredProtocols), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TunnelledProtocol( &(pObj->m_desiredTunnelledProtocol) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_hopCount), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225LocationRequest Destructor */
HS_RESULT delete_ASNH225LocationRequest(void *pObject)
{
	ASNH225LocationRequest *pObj = (ASNH225LocationRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225LocationRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_destinationInfo) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225TransportAddress( &(pObj->m_replyAddress) );
	delete_AsnSequenceOf( &(pObj->m_sourceInfo) );
	delete_AsnBoolean( &(pObj->m_canMapAlias) );
	delete_ASNH225GatekeeperIdentifier( &(pObj->m_gatekeeperIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnSequenceOf( &(pObj->m_desiredProtocols) );
	delete_ASNH225TunnelledProtocol( &(pObj->m_desiredTunnelledProtocol) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	delete_AsnInteger( &(pObj->m_hopCount) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	return HS_OK;
}

/* ASNH225LocationRequest MakeMold */
HS_RESULT ASNH225LocationRequest_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225LocationRequest *pObj = (ASNH225LocationRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225EndpointIdentifier_MakeMold(&(pObj->m_endpointIdentifier));
	{
	ASNH225AliasAddress *tmold_destinationInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destinationInfo);
	ASNH225AliasAddress_MakeMold(tmold_destinationInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destinationInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destinationInfo), moldObject );
	}
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225TransportAddress_MakeMold(&(pObj->m_replyAddress));
	{
	ASNH225AliasAddress *tmold_sourceInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_sourceInfo);
	ASNH225AliasAddress_MakeMold(tmold_sourceInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_sourceInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_sourceInfo), moldObject );
	}
	ASNH225GatekeeperIdentifier_MakeMold(&(pObj->m_gatekeeperIdentifier));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	{
	ASNH225SupportedProtocols *tmold_desiredProtocols = (ASNH225SupportedProtocols *)HSMalloc( sizeof(ASNH225SupportedProtocols) );
	new_ASNH225SupportedProtocols(tmold_desiredProtocols);
	ASNH225SupportedProtocols_MakeMold(tmold_desiredProtocols);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_desiredProtocols,sizeof(ASNH225SupportedProtocols),ASNH225SupportedProtocols_MakeMold,ASNH225SupportedProtocols_Encode,ASNH225SupportedProtocols_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedProtocols_Print,
#endif
		delete_ASNH225SupportedProtocols);
	AsnSequenceOf_SetMold( &(pObj->m_desiredProtocols), moldObject );
	}
	ASNH225TunnelledProtocol_MakeMold(&(pObj->m_desiredTunnelledProtocol));
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	return HS_OK;
}

/* ASNH225LocationRequest IncludeOptionalField */
HS_RESULT ASNH225LocationRequest_IncludeOptionField( void *pObject, ASNH225LocationRequestOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225LocationRequest *pObj = (ASNH225LocationRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225LocationRequestOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225LocationRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225LocationRequestOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225LocationRequest IsIncludeOptionalField */
BOOL ASNH225LocationRequest_IsIncludeOptionField( void *pObject, ASNH225LocationRequestOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225LocationRequest *pObj = (ASNH225LocationRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225LocationRequestOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225LocationRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225LocationRequestOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225LocationRequest Encode */
HS_RESULT ASNH225LocationRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225LocationRequest *pObj = (ASNH225LocationRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225LocationRequestOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225LocationRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_endpointIdentifier ) ){
		if( (tRet=ASNH225EndpointIdentifier_Encode( &(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_destinationInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_replyAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_sourceInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_sourceInfo), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_canMapAlias ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_canMapAlias), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_gatekeeperIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_gatekeeperIdentifier), ASNH225GatekeeperIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_desiredProtocols ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_desiredProtocols), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_desiredTunnelledProtocol ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_desiredTunnelledProtocol), ASNH225TunnelledProtocol_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_hopCount ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_hopCount), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225LocationRequest Decode */
HS_RESULT ASNH225LocationRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225LocationRequest *pObj = (ASNH225LocationRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225LocationRequestOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225LocationRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_endpointIdentifier ) ){
		if( (tRet=ASNH225EndpointIdentifier_Decode(&(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_destinationInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_replyAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_sourceInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_sourceInfo), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_canMapAlias ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_canMapAlias), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_gatekeeperIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_gatekeeperIdentifier), ASNH225GatekeeperIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_desiredProtocols ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_desiredProtocols), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_desiredTunnelledProtocol ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_desiredTunnelledProtocol), ASNH225TunnelledProtocol_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_hopCount ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_hopCount), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_circuitInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225LocationRequest Print */
HS_RESULT ASNH225LocationRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225LocationRequest *pObj = (ASNH225LocationRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225LocationRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_endpointIdentifier ) )
		ASNH225EndpointIdentifier_Print( &(pObj->m_endpointIdentifier), pDepth+1, "endpointIdentifier" );
	AsnSequenceOf_Print( &(pObj->m_destinationInfo), pDepth+1, "destinationInfo" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	ASNH225TransportAddress_Print( &(pObj->m_replyAddress), pDepth+1, "replyAddress" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_sourceInfo ) )
		AsnSequenceOf_Print( &(pObj->m_sourceInfo), pDepth+1, "sourceInfo" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_canMapAlias ) )
		AsnBoolean_Print( &(pObj->m_canMapAlias), pDepth+1, "canMapAlias" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_gatekeeperIdentifier ) )
		ASNH225GatekeeperIdentifier_Print( &(pObj->m_gatekeeperIdentifier), pDepth+1, "gatekeeperIdentifier" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_desiredProtocols ) )
		AsnSequenceOf_Print( &(pObj->m_desiredProtocols), pDepth+1, "desiredProtocols" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_desiredTunnelledProtocol ) )
		ASNH225TunnelledProtocol_Print( &(pObj->m_desiredTunnelledProtocol), pDepth+1, "desiredTunnelledProtocol" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_hopCount ) )
		AsnInteger_Print( &(pObj->m_hopCount), pDepth+1, "hopCount" );
	if( ASNH225LocationRequest_IsIncludeOptionField( pObj, e_ASNH225LocationRequestOptionMap_circuitInfo ) )
		ASNH225CircuitInfo_Print( &(pObj->m_circuitInfo), pDepth+1, "circuitInfo" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225LocationConfirm Class
*/
/*ASNH225LocationConfirm Constructor*/
HS_RESULT new_ASNH225LocationConfirm(void *pObject)
{
	ASNH225LocationConfirm *pObj = (ASNH225LocationConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225LocationConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225TransportAddress( &(pObj->m_callSignalAddress) );
	new_ASNH225TransportAddress( &(pObj->m_rasAddress) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_destinationInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_destExtraCallInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225EndpointType( &(pObj->m_destinationType) );
	new_AsnSequenceOf( &(pObj->m_remoteExtensionAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_alternateEndpoints), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225AlternateTransportAddresses( &(pObj->m_alternateTransportAddresses) );
	new_AsnSequenceOf( &(pObj->m_supportedProtocols), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_multipleCalls) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225LocationConfirm Destructor */
HS_RESULT delete_ASNH225LocationConfirm(void *pObject)
{
	ASNH225LocationConfirm *pObj = (ASNH225LocationConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225LocationConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225TransportAddress( &(pObj->m_callSignalAddress) );
	delete_ASNH225TransportAddress( &(pObj->m_rasAddress) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_destinationInfo) );
	delete_AsnSequenceOf( &(pObj->m_destExtraCallInfo) );
	delete_ASNH225EndpointType( &(pObj->m_destinationType) );
	delete_AsnSequenceOf( &(pObj->m_remoteExtensionAddress) );
	delete_AsnSequenceOf( &(pObj->m_alternateEndpoints) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225AlternateTransportAddresses( &(pObj->m_alternateTransportAddresses) );
	delete_AsnSequenceOf( &(pObj->m_supportedProtocols) );
	delete_AsnBoolean( &(pObj->m_multipleCalls) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	return HS_OK;
}

/* ASNH225LocationConfirm MakeMold */
HS_RESULT ASNH225LocationConfirm_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225LocationConfirm *pObj = (ASNH225LocationConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225TransportAddress_MakeMold(&(pObj->m_callSignalAddress));
	ASNH225TransportAddress_MakeMold(&(pObj->m_rasAddress));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225AliasAddress *tmold_destinationInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destinationInfo);
	ASNH225AliasAddress_MakeMold(tmold_destinationInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destinationInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destinationInfo), moldObject );
	}
	{
	ASNH225AliasAddress *tmold_destExtraCallInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destExtraCallInfo);
	ASNH225AliasAddress_MakeMold(tmold_destExtraCallInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destExtraCallInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destExtraCallInfo), moldObject );
	}
	ASNH225EndpointType_MakeMold(&(pObj->m_destinationType));
	{
	ASNH225AliasAddress *tmold_remoteExtensionAddress = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_remoteExtensionAddress);
	ASNH225AliasAddress_MakeMold(tmold_remoteExtensionAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_remoteExtensionAddress,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_remoteExtensionAddress), moldObject );
	}
	{
	ASNH225Endpoint *tmold_alternateEndpoints = (ASNH225Endpoint *)HSMalloc( sizeof(ASNH225Endpoint) );
	new_ASNH225Endpoint(tmold_alternateEndpoints);
	ASNH225Endpoint_MakeMold(tmold_alternateEndpoints);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_alternateEndpoints,sizeof(ASNH225Endpoint),ASNH225Endpoint_MakeMold,ASNH225Endpoint_Encode,ASNH225Endpoint_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225Endpoint_Print,
#endif
		delete_ASNH225Endpoint);
	AsnSequenceOf_SetMold( &(pObj->m_alternateEndpoints), moldObject );
	}
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225AlternateTransportAddresses_MakeMold(&(pObj->m_alternateTransportAddresses));
	{
	ASNH225SupportedProtocols *tmold_supportedProtocols = (ASNH225SupportedProtocols *)HSMalloc( sizeof(ASNH225SupportedProtocols) );
	new_ASNH225SupportedProtocols(tmold_supportedProtocols);
	ASNH225SupportedProtocols_MakeMold(tmold_supportedProtocols);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedProtocols,sizeof(ASNH225SupportedProtocols),ASNH225SupportedProtocols_MakeMold,ASNH225SupportedProtocols_Encode,ASNH225SupportedProtocols_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedProtocols_Print,
#endif
		delete_ASNH225SupportedProtocols);
	AsnSequenceOf_SetMold( &(pObj->m_supportedProtocols), moldObject );
	}
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	return HS_OK;
}

/* ASNH225LocationConfirm IncludeOptionalField */
HS_RESULT ASNH225LocationConfirm_IncludeOptionField( void *pObject, ASNH225LocationConfirmOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225LocationConfirm *pObj = (ASNH225LocationConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225LocationConfirmOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225LocationConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225LocationConfirmOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225LocationConfirm IsIncludeOptionalField */
BOOL ASNH225LocationConfirm_IsIncludeOptionField( void *pObject, ASNH225LocationConfirmOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225LocationConfirm *pObj = (ASNH225LocationConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225LocationConfirmOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225LocationConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225LocationConfirmOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225LocationConfirm Encode */
HS_RESULT ASNH225LocationConfirm_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225LocationConfirm *pObj = (ASNH225LocationConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225LocationConfirmOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225LocationConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_callSignalAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_rasAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_destinationInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destinationInfo), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_destExtraCallInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destExtraCallInfo), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_destinationType ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destinationType), ASNH225EndpointType_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_remoteExtensionAddress ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_remoteExtensionAddress), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_alternateEndpoints ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_alternateEndpoints), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_alternateTransportAddresses ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_alternateTransportAddresses), ASNH225AlternateTransportAddresses_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_supportedProtocols ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedProtocols), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_multipleCalls ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_multipleCalls), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225LocationConfirm Decode */
HS_RESULT ASNH225LocationConfirm_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225LocationConfirm *pObj = (ASNH225LocationConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225LocationConfirmOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225LocationConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_callSignalAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_rasAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_destinationInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_destinationInfo), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_destExtraCallInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_destExtraCallInfo), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_destinationType ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_destinationType), ASNH225EndpointType_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_remoteExtensionAddress ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_remoteExtensionAddress), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_alternateEndpoints ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_alternateEndpoints), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_alternateTransportAddresses ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_alternateTransportAddresses), ASNH225AlternateTransportAddresses_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_supportedProtocols ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedProtocols), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_multipleCalls ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_multipleCalls), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_circuitInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_serviceControl ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_serviceControl), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225LocationConfirm Print */
HS_RESULT ASNH225LocationConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225LocationConfirm *pObj = (ASNH225LocationConfirm *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225LocationConfirm_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225TransportAddress_Print( &(pObj->m_callSignalAddress), pDepth+1, "callSignalAddress" );
	ASNH225TransportAddress_Print( &(pObj->m_rasAddress), pDepth+1, "rasAddress" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_destinationInfo ) )
		AsnSequenceOf_Print( &(pObj->m_destinationInfo), pDepth+1, "destinationInfo" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_destExtraCallInfo ) )
		AsnSequenceOf_Print( &(pObj->m_destExtraCallInfo), pDepth+1, "destExtraCallInfo" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_destinationType ) )
		ASNH225EndpointType_Print( &(pObj->m_destinationType), pDepth+1, "destinationType" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_remoteExtensionAddress ) )
		AsnSequenceOf_Print( &(pObj->m_remoteExtensionAddress), pDepth+1, "remoteExtensionAddress" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_alternateEndpoints ) )
		AsnSequenceOf_Print( &(pObj->m_alternateEndpoints), pDepth+1, "alternateEndpoints" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_alternateTransportAddresses ) )
		ASNH225AlternateTransportAddresses_Print( &(pObj->m_alternateTransportAddresses), pDepth+1, "alternateTransportAddresses" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_supportedProtocols ) )
		AsnSequenceOf_Print( &(pObj->m_supportedProtocols), pDepth+1, "supportedProtocols" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_multipleCalls ) )
		AsnBoolean_Print( &(pObj->m_multipleCalls), pDepth+1, "multipleCalls" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_circuitInfo ) )
		ASNH225CircuitInfo_Print( &(pObj->m_circuitInfo), pDepth+1, "circuitInfo" );
	if( ASNH225LocationConfirm_IsIncludeOptionField( pObj, e_ASNH225LocationConfirmOptionMap_serviceControl ) )
		AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225LocationRejectReason Struct
*/
/* ASNH225LocationRejectReason Constructor */
HS_RESULT new_ASNH225LocationRejectReason( void *pObject )
{
	ASNH225LocationRejectReason *pObj = (ASNH225LocationRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225LocationRejectReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225LocationRejectReasonChoice_notRegistered;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225LocationRejectReasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225LocationRejectReason Destructor */
HS_RESULT delete_ASNH225LocationRejectReason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225LocationRejectReason *pObj = (ASNH225LocationRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225LocationRejectReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225LocationRejectReason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225LocationRejectReason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225LocationRejectReason SetChoice */
void* ASNH225LocationRejectReason_SetChoice( void *pObject, ASNH225LocationRejectReasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225LocationRejectReason *pObj = (ASNH225LocationRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRejectReason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225LocationRejectReasonChoiceSizeExt ){
		if( pChoice > (ASNH225LocationRejectReasonChoice)(e_ASNH225LocationRejectReasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225LocationRejectReason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225LocationRejectReasonChoice_notRegistered ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225LocationRejectReasonChoice_invalidPermission ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225LocationRejectReasonChoice_requestDenied ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225LocationRejectReasonChoice_undefinedReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225LocationRejectReasonChoice_securityDenial ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225LocationRejectReasonChoice_aliasesInconsistent ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225LocationRejectReasonChoice_routeCalltoSCN ){
		ASNH225PartyNumber *tAlter = (ASNH225PartyNumber *)HSMalloc( sizeof(ASNH225PartyNumber) );
		new_ASNH225PartyNumber(tAlter);
		ASNH225PartyNumber_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH225PartyNumber),ASNH225PartyNumber_MakeMold,ASNH225PartyNumber_Encode,ASNH225PartyNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH225PartyNumber_Print,
#endif
			delete_ASNH225PartyNumber );
		AsnSequenceOf_SetMold(aso,tmold);
		pObj->alter = aso;
	}
	else if ( pChoice == e_ASNH225LocationRejectReasonChoice_resourceUnavailable ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225LocationRejectReasonChoice_genericDataReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225LocationRejectReasonChoice_neededFeatureNotSupported ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRejectReason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225LocationRejectReason DeleteAlternation */
HS_RESULT ASNH225LocationRejectReason_DeleteAlternation(void *pObject)
{
	ASNH225LocationRejectReason *pObj = (ASNH225LocationRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRejectReason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225LocationRejectReasonChoice_notRegistered ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_invalidPermission ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_requestDenied ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_undefinedReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_securityDenial ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_aliasesInconsistent ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_routeCalltoSCN ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_resourceUnavailable ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_genericDataReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_neededFeatureNotSupported ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225LocationRejectReason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225LocationRejectReason Encode */
HS_RESULT ASNH225LocationRejectReason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225LocationRejectReason *pObj = (ASNH225LocationRejectReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225LocationRejectReasonChoiceSize )
		{
			if( pObj->choice > ((ASNH225LocationRejectReasonChoice)(e_ASNH225LocationRejectReasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225LocationRejectReasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH225LocationRejectReasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225LocationRejectReasonChoice_notRegistered ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_invalidPermission ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_requestDenied ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_securityDenial ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_aliasesInconsistent ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_routeCalltoSCN ){
		AsnStream tTempStrm;
		 new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_resourceUnavailable ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_genericDataReason ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_neededFeatureNotSupported ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRejectReason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225LocationRejectReason Decode */
HS_RESULT ASNH225LocationRejectReason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225LocationRejectReason *pObj = (ASNH225LocationRejectReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225LocationRejectReasonChoiceSize;
	}
	else
	{
		if( e_ASNH225LocationRejectReasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225LocationRejectReasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225LocationRejectReasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225LocationRejectReason_SetChoice( pObj, (ASNH225LocationRejectReasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225LocationRejectReasonChoice_notRegistered ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_invalidPermission ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_requestDenied ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_securityDenial ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_aliasesInconsistent ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_routeCalltoSCN ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_resourceUnavailable ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_genericDataReason ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_neededFeatureNotSupported ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationRejectReason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225LocationRejectReason Print */
HS_RESULT ASNH225LocationRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225LocationRejectReason *pObj = (ASNH225LocationRejectReason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225LocationRejectReason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225LocationRejectReasonChoice_notRegistered ){
		AsnNull_Print( pObj->alter, pDepth+1, "notRegistered" );
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_invalidPermission ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidPermission" );
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_requestDenied ){
		AsnNull_Print( pObj->alter, pDepth+1, "requestDenied" );
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_undefinedReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "undefinedReason" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_securityDenial ){
		AsnNull_Print( pObj->alter, pDepth+1, "securityDenial" );
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_aliasesInconsistent ){
		AsnNull_Print( pObj->alter, pDepth+1, "aliasesInconsistent" );
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_routeCalltoSCN ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "routeCalltoSCN" );
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_resourceUnavailable ){
		AsnNull_Print( pObj->alter, pDepth+1, "resourceUnavailable" );
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_genericDataReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "genericDataReason" );
	}
	else if ( pObj->choice == e_ASNH225LocationRejectReasonChoice_neededFeatureNotSupported ){
		AsnNull_Print( pObj->alter, pDepth+1, "neededFeatureNotSupported" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225LocationReject Class
*/
/*ASNH225LocationReject Constructor*/
HS_RESULT new_ASNH225LocationReject(void *pObject)
{
	ASNH225LocationReject *pObj = (ASNH225LocationReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225LocationReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225LocationRejectReason( &(pObj->m_rejectReason) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225LocationReject Destructor */
HS_RESULT delete_ASNH225LocationReject(void *pObject)
{
	ASNH225LocationReject *pObj = (ASNH225LocationReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225LocationReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225LocationRejectReason( &(pObj->m_rejectReason) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	return HS_OK;
}

/* ASNH225LocationReject MakeMold */
HS_RESULT ASNH225LocationReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225LocationReject *pObj = (ASNH225LocationReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225LocationRejectReason_MakeMold(&(pObj->m_rejectReason));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225AltGKInfo_MakeMold(&(pObj->m_altGKInfo));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	return HS_OK;
}

/* ASNH225LocationReject IncludeOptionalField */
HS_RESULT ASNH225LocationReject_IncludeOptionField( void *pObject, ASNH225LocationRejectOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225LocationReject *pObj = (ASNH225LocationReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationReject_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225LocationRejectOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225LocationRejectOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225LocationRejectOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225LocationReject IsIncludeOptionalField */
BOOL ASNH225LocationReject_IsIncludeOptionField( void *pObject, ASNH225LocationRejectOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225LocationReject *pObj = (ASNH225LocationReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationReject_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225LocationRejectOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225LocationRejectOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225LocationRejectOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225LocationReject Encode */
HS_RESULT ASNH225LocationReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225LocationReject *pObj = (ASNH225LocationReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225LocationRejectOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225LocationRejectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225LocationRejectReason_Encode( &(pObj->m_rejectReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_altGKInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_altGKInfo), ASNH225AltGKInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225LocationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225LocationReject Decode */
HS_RESULT ASNH225LocationReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225LocationReject *pObj = (ASNH225LocationReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225LocationRejectOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225LocationRejectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225LocationRejectReason_Decode(&(pObj->m_rejectReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_altGKInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_altGKInfo), ASNH225AltGKInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_serviceControl ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_serviceControl), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225LocationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225LocationReject Print */
HS_RESULT ASNH225LocationReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225LocationReject *pObj = (ASNH225LocationReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225LocationReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225LocationRejectReason_Print( &(pObj->m_rejectReason), pDepth+1, "rejectReason" );
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_altGKInfo ) )
		ASNH225AltGKInfo_Print( &(pObj->m_altGKInfo), pDepth+1, "altGKInfo" );
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	if( ASNH225LocationReject_IsIncludeOptionField( pObj, e_ASNH225LocationRejectOptionMap_serviceControl ) )
		AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225InfoRequest Class
*/
/*ASNH225InfoRequest Constructor*/
HS_RESULT new_ASNH225InfoRequest(void *pObject)
{
	ASNH225InfoRequest *pObj = (ASNH225InfoRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225InfoRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225TransportAddress( &(pObj->m_replyAddress) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225UUIEsRequested( &(pObj->m_uuiesRequested) );
	new_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	new_ASNH225RasUsageInfoTypes( &(pObj->m_usageInfoRequested) );
	new_AsnNull( &(pObj->m_segmentedResponseSupported) );
	new_AsnInteger( &(pObj->m_nextSegmentRequested), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnNull( &(pObj->m_capacityInfoRequested) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225InfoRequest Destructor */
HS_RESULT delete_ASNH225InfoRequest(void *pObject)
{
	ASNH225InfoRequest *pObj = (ASNH225InfoRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225TransportAddress( &(pObj->m_replyAddress) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225UUIEsRequested( &(pObj->m_uuiesRequested) );
	delete_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	delete_ASNH225RasUsageInfoTypes( &(pObj->m_usageInfoRequested) );
	delete_AsnNull( &(pObj->m_segmentedResponseSupported) );
	delete_AsnInteger( &(pObj->m_nextSegmentRequested) );
	delete_AsnNull( &(pObj->m_capacityInfoRequested) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225InfoRequest MakeMold */
HS_RESULT ASNH225InfoRequest_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225InfoRequest *pObj = (ASNH225InfoRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequest_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225CallReferenceValue_MakeMold(&(pObj->m_callReferenceValue));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225TransportAddress_MakeMold(&(pObj->m_replyAddress));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225UUIEsRequested_MakeMold(&(pObj->m_uuiesRequested));
	ASNH225CallLinkage_MakeMold(&(pObj->m_callLinkage));
	ASNH225RasUsageInfoTypes_MakeMold(&(pObj->m_usageInfoRequested));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225InfoRequest IncludeOptionalField */
HS_RESULT ASNH225InfoRequest_IncludeOptionField( void *pObject, ASNH225InfoRequestOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225InfoRequest *pObj = (ASNH225InfoRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225InfoRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225InfoRequestOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225InfoRequest IsIncludeOptionalField */
BOOL ASNH225InfoRequest_IsIncludeOptionField( void *pObject, ASNH225InfoRequestOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225InfoRequest *pObj = (ASNH225InfoRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequest_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225InfoRequestOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225InfoRequestOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225InfoRequest Encode */
HS_RESULT ASNH225InfoRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequest *pObj = (ASNH225InfoRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225InfoRequestOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallReferenceValue_Encode( &(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_replyAddress ) ){
		if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_replyAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_uuiesRequested ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_uuiesRequested), ASNH225UUIEsRequested_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_callLinkage ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_usageInfoRequested ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_usageInfoRequested), ASNH225RasUsageInfoTypes_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_segmentedResponseSupported ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_segmentedResponseSupported), AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_nextSegmentRequested ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_nextSegmentRequested), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_capacityInfoRequested ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacityInfoRequested), AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225InfoRequest Decode */
HS_RESULT ASNH225InfoRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequest *pObj = (ASNH225InfoRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225InfoRequestOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallReferenceValue_Decode(&(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_replyAddress ) ){
		if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_replyAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_uuiesRequested ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_uuiesRequested), ASNH225UUIEsRequested_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_callLinkage ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_usageInfoRequested ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_usageInfoRequested), ASNH225RasUsageInfoTypes_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_segmentedResponseSupported ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_segmentedResponseSupported), AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_nextSegmentRequested ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_nextSegmentRequested), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_capacityInfoRequested ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacityInfoRequested), AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225InfoRequest Print */
HS_RESULT ASNH225InfoRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225InfoRequest *pObj = (ASNH225InfoRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225InfoRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225CallReferenceValue_Print( &(pObj->m_callReferenceValue), pDepth+1, "callReferenceValue" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_replyAddress ) )
		ASNH225TransportAddress_Print( &(pObj->m_replyAddress), pDepth+1, "replyAddress" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_uuiesRequested ) )
		ASNH225UUIEsRequested_Print( &(pObj->m_uuiesRequested), pDepth+1, "uuiesRequested" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_callLinkage ) )
		ASNH225CallLinkage_Print( &(pObj->m_callLinkage), pDepth+1, "callLinkage" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_usageInfoRequested ) )
		ASNH225RasUsageInfoTypes_Print( &(pObj->m_usageInfoRequested), pDepth+1, "usageInfoRequested" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_segmentedResponseSupported ) )
		AsnNull_Print( &(pObj->m_segmentedResponseSupported), pDepth+1, "segmentedResponseSupported" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_nextSegmentRequested ) )
		AsnInteger_Print( &(pObj->m_nextSegmentRequested), pDepth+1, "nextSegmentRequested" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_capacityInfoRequested ) )
		AsnNull_Print( &(pObj->m_capacityInfoRequested), pDepth+1, "capacityInfoRequested" );
	if( ASNH225InfoRequest_IsIncludeOptionField( pObj, e_ASNH225InfoRequestOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225InfoRequestResponse_perCallInfo_pdu Class
*/
/*ASNH225InfoRequestResponse_perCallInfo_pdu Constructor*/
HS_RESULT new_ASNH225InfoRequestResponse_perCallInfo_pdu(void *pObject)
{
	ASNH225InfoRequestResponse_perCallInfo_pdu *pObj = (ASNH225InfoRequestResponse_perCallInfo_pdu *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225InfoRequestResponse_perCallInfo_pdu(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH225H323_UU_PDU( &(pObj->m_h323pdu) );
	new_AsnBoolean( &(pObj->m_sent) );

	return HS_OK;
}

/* ASNH225InfoRequestResponse_perCallInfo_pdu Destructor */
HS_RESULT delete_ASNH225InfoRequestResponse_perCallInfo_pdu(void *pObject)
{
	ASNH225InfoRequestResponse_perCallInfo_pdu *pObj = (ASNH225InfoRequestResponse_perCallInfo_pdu *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequestResponse_perCallInfo_pdu(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225H323_UU_PDU( &(pObj->m_h323pdu) );
	delete_AsnBoolean( &(pObj->m_sent) );
	return HS_OK;
}

/* ASNH225InfoRequestResponse_perCallInfo_pdu MakeMold */
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_pdu_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225InfoRequestResponse_perCallInfo_pdu *pObj = (ASNH225InfoRequestResponse_perCallInfo_pdu *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_pdu_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225H323_UU_PDU_MakeMold(&(pObj->m_h323pdu));
	return HS_OK;
}

/* ASNH225InfoRequestResponse_perCallInfo_pdu Encode */
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_pdu_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225InfoRequestResponse_perCallInfo_pdu *pObj = (ASNH225InfoRequestResponse_perCallInfo_pdu *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_pdu_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225H323_UU_PDU_Encode( &(pObj->m_h323pdu),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_pdu_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_sent),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_pdu_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225InfoRequestResponse_perCallInfo_pdu Decode */
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_pdu_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225InfoRequestResponse_perCallInfo_pdu *pObj = (ASNH225InfoRequestResponse_perCallInfo_pdu *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_pdu_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225H323_UU_PDU_Decode(&(pObj->m_h323pdu),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_pdu_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_sent),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_pdu_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225InfoRequestResponse_perCallInfo_pdu Print */
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_pdu_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225InfoRequestResponse_perCallInfo_pdu *pObj = (ASNH225InfoRequestResponse_perCallInfo_pdu *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_pdu_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225H323_UU_PDU_Print( &(pObj->m_h323pdu), pDepth+1, "h323pdu" );
	AsnBoolean_Print( &(pObj->m_sent), pDepth+1, "sent" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225InfoRequestResponse_perCallInfo Class
*/
/*ASNH225InfoRequestResponse_perCallInfo Constructor*/
HS_RESULT new_ASNH225InfoRequestResponse_perCallInfo(void *pObject)
{
	ASNH225InfoRequestResponse_perCallInfo *pObj = (ASNH225InfoRequestResponse_perCallInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225InfoRequestResponse_perCallInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	new_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	new_AsnBoolean( &(pObj->m_originator) );
	new_AsnSequenceOf( &(pObj->m_audio), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_video), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_data), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TransportChannelInfo( &(pObj->m_h245) );
	new_ASNH225TransportChannelInfo( &(pObj->m_callSignaling) );
	new_ASNH225CallType( &(pObj->m_callType) );
	new_ASNH225BandWidth( &(pObj->m_bandWidth) );
	new_ASNH225CallModel( &(pObj->m_callModel) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_substituteConfIDs), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_pdu), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	new_ASNH225RasUsageInformation( &(pObj->m_usageInformation) );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225InfoRequestResponse_perCallInfo Destructor */
HS_RESULT delete_ASNH225InfoRequestResponse_perCallInfo(void *pObject)
{
	ASNH225InfoRequestResponse_perCallInfo *pObj = (ASNH225InfoRequestResponse_perCallInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequestResponse_perCallInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225CallReferenceValue( &(pObj->m_callReferenceValue) );
	delete_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	delete_AsnBoolean( &(pObj->m_originator) );
	delete_AsnSequenceOf( &(pObj->m_audio) );
	delete_AsnSequenceOf( &(pObj->m_video) );
	delete_AsnSequenceOf( &(pObj->m_data) );
	delete_ASNH225TransportChannelInfo( &(pObj->m_h245) );
	delete_ASNH225TransportChannelInfo( &(pObj->m_callSignaling) );
	delete_ASNH225CallType( &(pObj->m_callType) );
	delete_ASNH225BandWidth( &(pObj->m_bandWidth) );
	delete_ASNH225CallModel( &(pObj->m_callModel) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_AsnSequenceOf( &(pObj->m_substituteConfIDs) );
	delete_AsnSequenceOf( &(pObj->m_pdu) );
	delete_ASNH225CallLinkage( &(pObj->m_callLinkage) );
	delete_ASNH225RasUsageInformation( &(pObj->m_usageInformation) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	return HS_OK;
}

/* ASNH225InfoRequestResponse_perCallInfo MakeMold */
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225InfoRequestResponse_perCallInfo *pObj = (ASNH225InfoRequestResponse_perCallInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225CallReferenceValue_MakeMold(&(pObj->m_callReferenceValue));
	ASNH225ConferenceIdentifier_MakeMold(&(pObj->m_conferenceID));
	{
	ASNH225RTPSession *tmold_audio = (ASNH225RTPSession *)HSMalloc( sizeof(ASNH225RTPSession) );
	new_ASNH225RTPSession(tmold_audio);
	ASNH225RTPSession_MakeMold(tmold_audio);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_audio,sizeof(ASNH225RTPSession),ASNH225RTPSession_MakeMold,ASNH225RTPSession_Encode,ASNH225RTPSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225RTPSession_Print,
#endif
		delete_ASNH225RTPSession);
	AsnSequenceOf_SetMold( &(pObj->m_audio), moldObject );
	}
	{
	ASNH225RTPSession *tmold_video = (ASNH225RTPSession *)HSMalloc( sizeof(ASNH225RTPSession) );
	new_ASNH225RTPSession(tmold_video);
	ASNH225RTPSession_MakeMold(tmold_video);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_video,sizeof(ASNH225RTPSession),ASNH225RTPSession_MakeMold,ASNH225RTPSession_Encode,ASNH225RTPSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225RTPSession_Print,
#endif
		delete_ASNH225RTPSession);
	AsnSequenceOf_SetMold( &(pObj->m_video), moldObject );
	}
	{
	ASNH225TransportChannelInfo *tmold_data = (ASNH225TransportChannelInfo *)HSMalloc( sizeof(ASNH225TransportChannelInfo) );
	new_ASNH225TransportChannelInfo(tmold_data);
	ASNH225TransportChannelInfo_MakeMold(tmold_data);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_data,sizeof(ASNH225TransportChannelInfo),ASNH225TransportChannelInfo_MakeMold,ASNH225TransportChannelInfo_Encode,ASNH225TransportChannelInfo_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225TransportChannelInfo_Print,
#endif
		delete_ASNH225TransportChannelInfo);
	AsnSequenceOf_SetMold( &(pObj->m_data), moldObject );
	}
	ASNH225TransportChannelInfo_MakeMold(&(pObj->m_h245));
	ASNH225TransportChannelInfo_MakeMold(&(pObj->m_callSignaling));
	ASNH225CallType_MakeMold(&(pObj->m_callType));
	ASNH225BandWidth_MakeMold(&(pObj->m_bandWidth));
	ASNH225CallModel_MakeMold(&(pObj->m_callModel));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	{
	ASNH225ConferenceIdentifier *tmold_substituteConfIDs = (ASNH225ConferenceIdentifier *)HSMalloc( sizeof(ASNH225ConferenceIdentifier) );
	new_ASNH225ConferenceIdentifier(tmold_substituteConfIDs);
	ASNH225ConferenceIdentifier_MakeMold(tmold_substituteConfIDs);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_substituteConfIDs,sizeof(ASNH225ConferenceIdentifier),ASNH225ConferenceIdentifier_MakeMold,ASNH225ConferenceIdentifier_Encode,ASNH225ConferenceIdentifier_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ConferenceIdentifier_Print,
#endif
		delete_ASNH225ConferenceIdentifier);
	AsnSequenceOf_SetMold( &(pObj->m_substituteConfIDs), moldObject );
	}
	{
	ASNH225InfoRequestResponse_perCallInfo_pdu *tmold_pdu = (ASNH225InfoRequestResponse_perCallInfo_pdu *)HSMalloc( sizeof(ASNH225InfoRequestResponse_perCallInfo_pdu) );
	new_ASNH225InfoRequestResponse_perCallInfo_pdu(tmold_pdu);
	ASNH225InfoRequestResponse_perCallInfo_pdu_MakeMold(tmold_pdu);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_pdu,sizeof(ASNH225InfoRequestResponse_perCallInfo_pdu),ASNH225InfoRequestResponse_perCallInfo_pdu_MakeMold,ASNH225InfoRequestResponse_perCallInfo_pdu_Encode,ASNH225InfoRequestResponse_perCallInfo_pdu_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225InfoRequestResponse_perCallInfo_pdu_Print,
#endif
		delete_ASNH225InfoRequestResponse_perCallInfo_pdu);
	AsnSequenceOf_SetMold( &(pObj->m_pdu), moldObject );
	}
	ASNH225CallLinkage_MakeMold(&(pObj->m_callLinkage));
	ASNH225RasUsageInformation_MakeMold(&(pObj->m_usageInformation));
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	return HS_OK;
}

/* ASNH225InfoRequestResponse_perCallInfo IncludeOptionalField */
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_IncludeOptionField( void *pObject, ASNH225InfoRequestResponse_perCallInfoOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225InfoRequestResponse_perCallInfo *pObj = (ASNH225InfoRequestResponse_perCallInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestResponse_perCallInfoOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225InfoRequestResponse_perCallInfoOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225InfoRequestResponse_perCallInfoOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225InfoRequestResponse_perCallInfo IsIncludeOptionalField */
BOOL ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( void *pObject, ASNH225InfoRequestResponse_perCallInfoOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225InfoRequestResponse_perCallInfo *pObj = (ASNH225InfoRequestResponse_perCallInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestResponse_perCallInfoOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225InfoRequestResponse_perCallInfoOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225InfoRequestResponse_perCallInfoOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225InfoRequestResponse_perCallInfo Encode */
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestResponse_perCallInfo *pObj = (ASNH225InfoRequestResponse_perCallInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225InfoRequestResponse_perCallInfoOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestResponse_perCallInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225CallReferenceValue_Encode( &(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Encode( &(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_originator ) ){
		if( (tRet=AsnBoolean_Encode( &(pObj->m_originator),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_audio ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_audio),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_video ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_video),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_data ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_data),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225TransportChannelInfo_Encode( &(pObj->m_h245),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportChannelInfo_Encode( &(pObj->m_callSignaling),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallType_Encode( &(pObj->m_callType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandWidth_Encode( &(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallModel_Encode( &(pObj->m_callModel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_substituteConfIDs ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_substituteConfIDs), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_pdu ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_pdu), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_callLinkage ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_usageInformation ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_usageInformation), ASNH225RasUsageInformation_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225InfoRequestResponse_perCallInfo Decode */
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestResponse_perCallInfo *pObj = (ASNH225InfoRequestResponse_perCallInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225InfoRequestResponse_perCallInfoOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestResponse_perCallInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225CallReferenceValue_Decode(&(pObj->m_callReferenceValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Decode(&(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_originator ) ){
		if( (tRet=AsnBoolean_Decode(&(pObj->m_originator),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_audio ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_audio),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_video ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_video),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_data ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_data),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225TransportChannelInfo_Decode(&(pObj->m_h245),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportChannelInfo_Decode(&(pObj->m_callSignaling),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallType_Decode(&(pObj->m_callType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225BandWidth_Decode(&(pObj->m_bandWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225CallModel_Decode(&(pObj->m_callModel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_substituteConfIDs ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_substituteConfIDs), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_pdu ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_pdu), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_callLinkage ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callLinkage), ASNH225CallLinkage_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_usageInformation ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_usageInformation), ASNH225RasUsageInformation_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_circuitInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225InfoRequestResponse_perCallInfo Print */
HS_RESULT ASNH225InfoRequestResponse_perCallInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225InfoRequestResponse_perCallInfo *pObj = (ASNH225InfoRequestResponse_perCallInfo *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225InfoRequestResponse_perCallInfo_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	ASNH225CallReferenceValue_Print( &(pObj->m_callReferenceValue), pDepth+1, "callReferenceValue" );
	ASNH225ConferenceIdentifier_Print( &(pObj->m_conferenceID), pDepth+1, "conferenceID" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_originator ) )
		AsnBoolean_Print( &(pObj->m_originator), pDepth+1, "originator" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_audio ) )
		AsnSequenceOf_Print( &(pObj->m_audio), pDepth+1, "audio" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_video ) )
		AsnSequenceOf_Print( &(pObj->m_video), pDepth+1, "video" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_data ) )
		AsnSequenceOf_Print( &(pObj->m_data), pDepth+1, "data" );
	ASNH225TransportChannelInfo_Print( &(pObj->m_h245), pDepth+1, "h245" );
	ASNH225TransportChannelInfo_Print( &(pObj->m_callSignaling), pDepth+1, "callSignaling" );
	ASNH225CallType_Print( &(pObj->m_callType), pDepth+1, "callType" );
	ASNH225BandWidth_Print( &(pObj->m_bandWidth), pDepth+1, "bandWidth" );
	ASNH225CallModel_Print( &(pObj->m_callModel), pDepth+1, "callModel" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_substituteConfIDs ) )
		AsnSequenceOf_Print( &(pObj->m_substituteConfIDs), pDepth+1, "substituteConfIDs" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_pdu ) )
		AsnSequenceOf_Print( &(pObj->m_pdu), pDepth+1, "pdu" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_callLinkage ) )
		ASNH225CallLinkage_Print( &(pObj->m_callLinkage), pDepth+1, "callLinkage" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_usageInformation ) )
		ASNH225RasUsageInformation_Print( &(pObj->m_usageInformation), pDepth+1, "usageInformation" );
	if( ASNH225InfoRequestResponse_perCallInfo_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponse_perCallInfoOptionMap_circuitInfo ) )
		ASNH225CircuitInfo_Print( &(pObj->m_circuitInfo), pDepth+1, "circuitInfo" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225InfoRequestResponseStatus Struct
*/
/* ASNH225InfoRequestResponseStatus Constructor */
HS_RESULT new_ASNH225InfoRequestResponseStatus( void *pObject )
{
	ASNH225InfoRequestResponseStatus *pObj = (ASNH225InfoRequestResponseStatus *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225InfoRequestResponseStatus(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225InfoRequestResponseStatusChoice_complete;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225InfoRequestResponseStatusChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225InfoRequestResponseStatus Destructor */
HS_RESULT delete_ASNH225InfoRequestResponseStatus( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestResponseStatus *pObj = (ASNH225InfoRequestResponseStatus *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequestResponseStatus(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225InfoRequestResponseStatus_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequestResponseStatus(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225InfoRequestResponseStatus SetChoice */
void* ASNH225InfoRequestResponseStatus_SetChoice( void *pObject, ASNH225InfoRequestResponseStatusChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225InfoRequestResponseStatus *pObj = (ASNH225InfoRequestResponseStatus *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225InfoRequestResponseStatusChoiceSizeExt ){
		if( pChoice > (ASNH225InfoRequestResponseStatusChoice)(e_ASNH225InfoRequestResponseStatusChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225InfoRequestResponseStatus_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225InfoRequestResponseStatusChoice_complete ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225InfoRequestResponseStatusChoice_incomplete ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225InfoRequestResponseStatusChoice_segment ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225InfoRequestResponseStatusChoice_invalidCall ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225InfoRequestResponseStatus DeleteAlternation */
HS_RESULT ASNH225InfoRequestResponseStatus_DeleteAlternation(void *pObject)
{
	ASNH225InfoRequestResponseStatus *pObj = (ASNH225InfoRequestResponseStatus *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_complete ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_incomplete ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_segment ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_invalidCall ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225InfoRequestResponseStatus_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225InfoRequestResponseStatus Encode */
HS_RESULT ASNH225InfoRequestResponseStatus_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225InfoRequestResponseStatus *pObj = (ASNH225InfoRequestResponseStatus *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225InfoRequestResponseStatusChoiceSize )
		{
			if( pObj->choice > ((ASNH225InfoRequestResponseStatusChoice)(e_ASNH225InfoRequestResponseStatusChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225InfoRequestResponseStatusChoiceSize)) )
	}
	else
	{
		if( e_ASNH225InfoRequestResponseStatusChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_complete ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_incomplete ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_segment ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_invalidCall ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225InfoRequestResponseStatus Decode */
HS_RESULT ASNH225InfoRequestResponseStatus_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225InfoRequestResponseStatus *pObj = (ASNH225InfoRequestResponseStatus *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225InfoRequestResponseStatusChoiceSize;
	}
	else
	{
		if( e_ASNH225InfoRequestResponseStatusChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225InfoRequestResponseStatusChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225InfoRequestResponseStatusChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225InfoRequestResponseStatus_SetChoice( pObj, (ASNH225InfoRequestResponseStatusChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_complete ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_incomplete ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_segment ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_invalidCall ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225InfoRequestResponseStatus Print */
HS_RESULT ASNH225InfoRequestResponseStatus_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225InfoRequestResponseStatus *pObj = (ASNH225InfoRequestResponseStatus *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225InfoRequestResponseStatus_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_complete ){
		AsnNull_Print( pObj->alter, pDepth+1, "complete" );
	}
	else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_incomplete ){
		AsnNull_Print( pObj->alter, pDepth+1, "incomplete" );
	}
	else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_segment ){
		AsnInteger_Print( pObj->alter, pDepth+1, "segment" );
	}
	else if ( pObj->choice == e_ASNH225InfoRequestResponseStatusChoice_invalidCall ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidCall" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225InfoRequestResponse Class
*/
/*ASNH225InfoRequestResponse Constructor*/
HS_RESULT new_ASNH225InfoRequestResponse(void *pObject)
{
	ASNH225InfoRequestResponse *pObj = (ASNH225InfoRequestResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225InfoRequestResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225EndpointType( &(pObj->m_endpointType) );
	new_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	new_ASNH225TransportAddress( &(pObj->m_rasAddress) );
	new_AsnSequenceOf( &(pObj->m_callSignalAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_endpointAlias), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_perCallInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnBoolean( &(pObj->m_needResponse) );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_ASNH225InfoRequestResponseStatus( &(pObj->m_irrStatus) );
	new_AsnBoolean( &(pObj->m_unsolicited) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225InfoRequestResponse Destructor */
HS_RESULT delete_ASNH225InfoRequestResponse(void *pObject)
{
	ASNH225InfoRequestResponse *pObj = (ASNH225InfoRequestResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequestResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225EndpointType( &(pObj->m_endpointType) );
	delete_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	delete_ASNH225TransportAddress( &(pObj->m_rasAddress) );
	delete_AsnSequenceOf( &(pObj->m_callSignalAddress) );
	delete_AsnSequenceOf( &(pObj->m_endpointAlias) );
	delete_AsnSequenceOf( &(pObj->m_perCallInfo) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnBoolean( &(pObj->m_needResponse) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_ASNH225InfoRequestResponseStatus( &(pObj->m_irrStatus) );
	delete_AsnBoolean( &(pObj->m_unsolicited) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225InfoRequestResponse MakeMold */
HS_RESULT ASNH225InfoRequestResponse_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225InfoRequestResponse *pObj = (ASNH225InfoRequestResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225EndpointType_MakeMold(&(pObj->m_endpointType));
	ASNH225EndpointIdentifier_MakeMold(&(pObj->m_endpointIdentifier));
	ASNH225TransportAddress_MakeMold(&(pObj->m_rasAddress));
	{
	ASNH225TransportAddress *tmold_callSignalAddress = (ASNH225TransportAddress *)HSMalloc( sizeof(ASNH225TransportAddress) );
	new_ASNH225TransportAddress(tmold_callSignalAddress);
	ASNH225TransportAddress_MakeMold(tmold_callSignalAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_callSignalAddress,sizeof(ASNH225TransportAddress),ASNH225TransportAddress_MakeMold,ASNH225TransportAddress_Encode,ASNH225TransportAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225TransportAddress_Print,
#endif
		delete_ASNH225TransportAddress);
	AsnSequenceOf_SetMold( &(pObj->m_callSignalAddress), moldObject );
	}
	{
	ASNH225AliasAddress *tmold_endpointAlias = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_endpointAlias);
	ASNH225AliasAddress_MakeMold(tmold_endpointAlias);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_endpointAlias,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_endpointAlias), moldObject );
	}
	{
	ASNH225InfoRequestResponse_perCallInfo *tmold_perCallInfo = (ASNH225InfoRequestResponse_perCallInfo *)HSMalloc( sizeof(ASNH225InfoRequestResponse_perCallInfo) );
	new_ASNH225InfoRequestResponse_perCallInfo(tmold_perCallInfo);
	ASNH225InfoRequestResponse_perCallInfo_MakeMold(tmold_perCallInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_perCallInfo,sizeof(ASNH225InfoRequestResponse_perCallInfo),ASNH225InfoRequestResponse_perCallInfo_MakeMold,ASNH225InfoRequestResponse_perCallInfo_Encode,ASNH225InfoRequestResponse_perCallInfo_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225InfoRequestResponse_perCallInfo_Print,
#endif
		delete_ASNH225InfoRequestResponse_perCallInfo);
	AsnSequenceOf_SetMold( &(pObj->m_perCallInfo), moldObject );
	}
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	ASNH225InfoRequestResponseStatus_MakeMold(&(pObj->m_irrStatus));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225InfoRequestResponse IncludeOptionalField */
HS_RESULT ASNH225InfoRequestResponse_IncludeOptionField( void *pObject, ASNH225InfoRequestResponseOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225InfoRequestResponse *pObj = (ASNH225InfoRequestResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestResponseOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225InfoRequestResponseOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225InfoRequestResponseOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225InfoRequestResponse IsIncludeOptionalField */
BOOL ASNH225InfoRequestResponse_IsIncludeOptionField( void *pObject, ASNH225InfoRequestResponseOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225InfoRequestResponse *pObj = (ASNH225InfoRequestResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestResponseOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225InfoRequestResponseOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225InfoRequestResponseOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225InfoRequestResponse Encode */
HS_RESULT ASNH225InfoRequestResponse_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestResponse *pObj = (ASNH225InfoRequestResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225InfoRequestResponseOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestResponseOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointType_Encode( &(pObj->m_endpointType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointIdentifier_Encode( &(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_rasAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_callSignalAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_endpointAlias ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_endpointAlias),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_perCallInfo ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_perCallInfo),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_needResponse ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_needResponse), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_irrStatus ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_irrStatus), ASNH225InfoRequestResponseStatus_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_unsolicited ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_unsolicited), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225InfoRequestResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225InfoRequestResponse Decode */
HS_RESULT ASNH225InfoRequestResponse_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestResponse *pObj = (ASNH225InfoRequestResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225InfoRequestResponseOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestResponseOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointType_Decode(&(pObj->m_endpointType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointIdentifier_Decode(&(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_rasAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_callSignalAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_endpointAlias ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_endpointAlias),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_perCallInfo ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_perCallInfo),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_needResponse ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_needResponse), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_irrStatus ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_irrStatus), ASNH225InfoRequestResponseStatus_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_unsolicited ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_unsolicited), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225InfoRequestResponse Print */
HS_RESULT ASNH225InfoRequestResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225InfoRequestResponse *pObj = (ASNH225InfoRequestResponse *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225InfoRequestResponse_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225EndpointType_Print( &(pObj->m_endpointType), pDepth+1, "endpointType" );
	ASNH225EndpointIdentifier_Print( &(pObj->m_endpointIdentifier), pDepth+1, "endpointIdentifier" );
	ASNH225TransportAddress_Print( &(pObj->m_rasAddress), pDepth+1, "rasAddress" );
	AsnSequenceOf_Print( &(pObj->m_callSignalAddress), pDepth+1, "callSignalAddress" );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_endpointAlias ) )
		AsnSequenceOf_Print( &(pObj->m_endpointAlias), pDepth+1, "endpointAlias" );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_perCallInfo ) )
		AsnSequenceOf_Print( &(pObj->m_perCallInfo), pDepth+1, "perCallInfo" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_needResponse ) )
		AsnBoolean_Print( &(pObj->m_needResponse), pDepth+1, "needResponse" );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_irrStatus ) )
		ASNH225InfoRequestResponseStatus_Print( &(pObj->m_irrStatus), pDepth+1, "irrStatus" );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_unsolicited ) )
		AsnBoolean_Print( &(pObj->m_unsolicited), pDepth+1, "unsolicited" );
	if( ASNH225InfoRequestResponse_IsIncludeOptionField( pObj, e_ASNH225InfoRequestResponseOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225NonStandardMessage Class
*/
/*ASNH225NonStandardMessage Constructor*/
HS_RESULT new_ASNH225NonStandardMessage(void *pObject)
{
	ASNH225NonStandardMessage *pObj = (ASNH225NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225NonStandardMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225NonStandardMessage Destructor */
HS_RESULT delete_ASNH225NonStandardMessage(void *pObject)
{
	ASNH225NonStandardMessage *pObj = (ASNH225NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225NonStandardMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225NonStandardMessage MakeMold */
HS_RESULT ASNH225NonStandardMessage_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225NonStandardMessage *pObj = (ASNH225NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardMessage_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225NonStandardMessage IncludeOptionalField */
HS_RESULT ASNH225NonStandardMessage_IncludeOptionField( void *pObject, ASNH225NonStandardMessageOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225NonStandardMessage *pObj = (ASNH225NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardMessage_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225NonStandardMessageOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225NonStandardMessageOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH225NonStandardMessage IsIncludeOptionalField */
BOOL ASNH225NonStandardMessage_IsIncludeOptionField( void *pObject, ASNH225NonStandardMessageOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225NonStandardMessage *pObj = (ASNH225NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardMessage_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225NonStandardMessageOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225NonStandardMessageOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225NonStandardMessage Encode */
HS_RESULT ASNH225NonStandardMessage_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225NonStandardMessage *pObj = (ASNH225NonStandardMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardMessage_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225NonStandardMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225NonStandardMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225NonStandardMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225NonStandardMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225NonStandardMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225NonStandardMessage Decode */
HS_RESULT ASNH225NonStandardMessage_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225NonStandardMessage *pObj = (ASNH225NonStandardMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardMessage_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardMessage_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardMessage_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardMessage_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardMessage_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardMessage_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardMessage_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardMessage_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225NonStandardMessage Print */
HS_RESULT ASNH225NonStandardMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225NonStandardMessage *pObj = (ASNH225NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225NonStandardMessage_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	if( ASNH225NonStandardMessage_IsIncludeOptionField( pObj, e_ASNH225NonStandardMessageOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225UnknownMessageResponse Class
*/
/*ASNH225UnknownMessageResponse Constructor*/
HS_RESULT new_ASNH225UnknownMessageResponse(void *pObject)
{
	ASNH225UnknownMessageResponse *pObj = (ASNH225UnknownMessageResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225UnknownMessageResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnOctetString( &(pObj->m_messageNotUnderstood), e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225UnknownMessageResponse Destructor */
HS_RESULT delete_ASNH225UnknownMessageResponse(void *pObject)
{
	ASNH225UnknownMessageResponse *pObj = (ASNH225UnknownMessageResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225UnknownMessageResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnOctetString( &(pObj->m_messageNotUnderstood) );
	return HS_OK;
}

/* ASNH225UnknownMessageResponse MakeMold */
HS_RESULT ASNH225UnknownMessageResponse_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225UnknownMessageResponse *pObj = (ASNH225UnknownMessageResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UnknownMessageResponse_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	return HS_OK;
}

/* ASNH225UnknownMessageResponse IncludeOptionalField */
HS_RESULT ASNH225UnknownMessageResponse_IncludeOptionField( void *pObject, ASNH225UnknownMessageResponseOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225UnknownMessageResponse *pObj = (ASNH225UnknownMessageResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UnknownMessageResponse_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225UnknownMessageResponseOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225UnknownMessageResponseOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH225UnknownMessageResponse IsIncludeOptionalField */
BOOL ASNH225UnknownMessageResponse_IsIncludeOptionField( void *pObject, ASNH225UnknownMessageResponseOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225UnknownMessageResponse *pObj = (ASNH225UnknownMessageResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UnknownMessageResponse_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225UnknownMessageResponseOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225UnknownMessageResponseOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225UnknownMessageResponse Encode */
HS_RESULT ASNH225UnknownMessageResponse_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225UnknownMessageResponse *pObj = (ASNH225UnknownMessageResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UnknownMessageResponse_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UnknownMessageResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225UnknownMessageResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225UnknownMessageResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_integrityCheckValue ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225UnknownMessageResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_messageNotUnderstood ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_messageNotUnderstood), AsnOctetString_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225UnknownMessageResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225UnknownMessageResponse Decode */
HS_RESULT ASNH225UnknownMessageResponse_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225UnknownMessageResponse *pObj = (ASNH225UnknownMessageResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UnknownMessageResponse_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225UnknownMessageResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225UnknownMessageResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225UnknownMessageResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_integrityCheckValue ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_integrityCheckValue), ASNH225ICV_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225UnknownMessageResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_messageNotUnderstood ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_messageNotUnderstood), AsnOctetString_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225UnknownMessageResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225UnknownMessageResponse Print */
HS_RESULT ASNH225UnknownMessageResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225UnknownMessageResponse *pObj = (ASNH225UnknownMessageResponse *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225UnknownMessageResponse_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225UnknownMessageResponse_IsIncludeOptionField( pObj, e_ASNH225UnknownMessageResponseOptionMap_messageNotUnderstood ) )
		AsnOctetString_Print( &(pObj->m_messageNotUnderstood), pDepth+1, "messageNotUnderstood" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225RequestInProgress Class
*/
/*ASNH225RequestInProgress Constructor*/
HS_RESULT new_ASNH225RequestInProgress(void *pObject)
{
	ASNH225RequestInProgress *pObj = (ASNH225RequestInProgress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225RequestInProgress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnInteger( &(pObj->m_delay), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225RequestInProgress Destructor */
HS_RESULT delete_ASNH225RequestInProgress(void *pObject)
{
	ASNH225RequestInProgress *pObj = (ASNH225RequestInProgress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225RequestInProgress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnInteger( &(pObj->m_delay) );
	return HS_OK;
}

/* ASNH225RequestInProgress MakeMold */
HS_RESULT ASNH225RequestInProgress_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225RequestInProgress *pObj = (ASNH225RequestInProgress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RequestInProgress_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	return HS_OK;
}

/* ASNH225RequestInProgress IncludeOptionalField */
HS_RESULT ASNH225RequestInProgress_IncludeOptionField( void *pObject, ASNH225RequestInProgressOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225RequestInProgress *pObj = (ASNH225RequestInProgress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RequestInProgress_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225RequestInProgressOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225RequestInProgress IsIncludeOptionalField */
BOOL ASNH225RequestInProgress_IsIncludeOptionField( void *pObject, ASNH225RequestInProgressOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225RequestInProgress *pObj = (ASNH225RequestInProgress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RequestInProgress_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225RequestInProgressOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225RequestInProgress Encode */
HS_RESULT ASNH225RequestInProgress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225RequestInProgress *pObj = (ASNH225RequestInProgress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RequestInProgress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225RequestInProgressOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225RequestInProgressOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RequestInProgress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RequestInProgress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_tokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RequestInProgress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_cryptoTokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RequestInProgress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Encode( &(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RequestInProgress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_delay),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RequestInProgress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225RequestInProgress Decode */
HS_RESULT ASNH225RequestInProgress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225RequestInProgress *pObj = (ASNH225RequestInProgress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RequestInProgress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225RequestInProgressOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225RequestInProgressOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RequestInProgress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RequestInProgress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_tokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RequestInProgress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_cryptoTokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RequestInProgress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Decode(&(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RequestInProgress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_delay),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RequestInProgress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225RequestInProgress Print */
HS_RESULT ASNH225RequestInProgress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225RequestInProgress *pObj = (ASNH225RequestInProgress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225RequestInProgress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225RequestInProgress_IsIncludeOptionField( pObj, e_ASNH225RequestInProgressOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	AsnInteger_Print( &(pObj->m_delay), pDepth+1, "delay" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ResourcesAvailableIndicate Class
*/
/*ASNH225ResourcesAvailableIndicate Constructor*/
HS_RESULT new_ASNH225ResourcesAvailableIndicate(void *pObject)
{
	ASNH225ResourcesAvailableIndicate *pObj = (ASNH225ResourcesAvailableIndicate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ResourcesAvailableIndicate(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	new_AsnSequenceOf( &(pObj->m_protocols), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_almostOutOfResources) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225ResourcesAvailableIndicate Destructor */
HS_RESULT delete_ASNH225ResourcesAvailableIndicate(void *pObject)
{
	ASNH225ResourcesAvailableIndicate *pObj = (ASNH225ResourcesAvailableIndicate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ResourcesAvailableIndicate(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_protocols) );
	delete_AsnBoolean( &(pObj->m_almostOutOfResources) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225ResourcesAvailableIndicate MakeMold */
HS_RESULT ASNH225ResourcesAvailableIndicate_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ResourcesAvailableIndicate *pObj = (ASNH225ResourcesAvailableIndicate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225ProtocolIdentifier_MakeMold(&(pObj->m_protocolIdentifier));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225EndpointIdentifier_MakeMold(&(pObj->m_endpointIdentifier));
	{
	ASNH225SupportedProtocols *tmold_protocols = (ASNH225SupportedProtocols *)HSMalloc( sizeof(ASNH225SupportedProtocols) );
	new_ASNH225SupportedProtocols(tmold_protocols);
	ASNH225SupportedProtocols_MakeMold(tmold_protocols);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_protocols,sizeof(ASNH225SupportedProtocols),ASNH225SupportedProtocols_MakeMold,ASNH225SupportedProtocols_Encode,ASNH225SupportedProtocols_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedProtocols_Print,
#endif
		delete_ASNH225SupportedProtocols);
	AsnSequenceOf_SetMold( &(pObj->m_protocols), moldObject );
	}
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225ResourcesAvailableIndicate IncludeOptionalField */
HS_RESULT ASNH225ResourcesAvailableIndicate_IncludeOptionField( void *pObject, ASNH225ResourcesAvailableIndicateOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225ResourcesAvailableIndicate *pObj = (ASNH225ResourcesAvailableIndicate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225ResourcesAvailableIndicateOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225ResourcesAvailableIndicateOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225ResourcesAvailableIndicateOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225ResourcesAvailableIndicate IsIncludeOptionalField */
BOOL ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( void *pObject, ASNH225ResourcesAvailableIndicateOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225ResourcesAvailableIndicate *pObj = (ASNH225ResourcesAvailableIndicate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225ResourcesAvailableIndicateOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225ResourcesAvailableIndicateOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225ResourcesAvailableIndicateOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225ResourcesAvailableIndicate Encode */
HS_RESULT ASNH225ResourcesAvailableIndicate_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ResourcesAvailableIndicate *pObj = (ASNH225ResourcesAvailableIndicate *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225ResourcesAvailableIndicateOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225ResourcesAvailableIndicateOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ProtocolIdentifier_Encode( &(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225EndpointIdentifier_Encode( &(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_protocols),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_almostOutOfResources),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_tokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_cryptoTokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Encode( &(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225ResourcesAvailableIndicate Decode */
HS_RESULT ASNH225ResourcesAvailableIndicate_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ResourcesAvailableIndicate *pObj = (ASNH225ResourcesAvailableIndicate *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225ResourcesAvailableIndicateOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225ResourcesAvailableIndicateOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ProtocolIdentifier_Decode(&(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225EndpointIdentifier_Decode(&(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_protocols),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_almostOutOfResources),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_tokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_cryptoTokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Decode(&(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ResourcesAvailableIndicate Print */
HS_RESULT ASNH225ResourcesAvailableIndicate_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ResourcesAvailableIndicate *pObj = (ASNH225ResourcesAvailableIndicate *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ResourcesAvailableIndicate_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225ProtocolIdentifier_Print( &(pObj->m_protocolIdentifier), pDepth+1, "protocolIdentifier" );
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	ASNH225EndpointIdentifier_Print( &(pObj->m_endpointIdentifier), pDepth+1, "endpointIdentifier" );
	AsnSequenceOf_Print( &(pObj->m_protocols), pDepth+1, "protocols" );
	AsnBoolean_Print( &(pObj->m_almostOutOfResources), pDepth+1, "almostOutOfResources" );
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225ResourcesAvailableIndicate_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableIndicateOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ResourcesAvailableConfirm Class
*/
/*ASNH225ResourcesAvailableConfirm Constructor*/
HS_RESULT new_ASNH225ResourcesAvailableConfirm(void *pObject)
{
	ASNH225ResourcesAvailableConfirm *pObj = (ASNH225ResourcesAvailableConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ResourcesAvailableConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225ResourcesAvailableConfirm Destructor */
HS_RESULT delete_ASNH225ResourcesAvailableConfirm(void *pObject)
{
	ASNH225ResourcesAvailableConfirm *pObj = (ASNH225ResourcesAvailableConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ResourcesAvailableConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225ResourcesAvailableConfirm MakeMold */
HS_RESULT ASNH225ResourcesAvailableConfirm_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ResourcesAvailableConfirm *pObj = (ASNH225ResourcesAvailableConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225ProtocolIdentifier_MakeMold(&(pObj->m_protocolIdentifier));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225ResourcesAvailableConfirm IncludeOptionalField */
HS_RESULT ASNH225ResourcesAvailableConfirm_IncludeOptionField( void *pObject, ASNH225ResourcesAvailableConfirmOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225ResourcesAvailableConfirm *pObj = (ASNH225ResourcesAvailableConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225ResourcesAvailableConfirmOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225ResourcesAvailableConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225ResourcesAvailableConfirmOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225ResourcesAvailableConfirm IsIncludeOptionalField */
BOOL ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( void *pObject, ASNH225ResourcesAvailableConfirmOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225ResourcesAvailableConfirm *pObj = (ASNH225ResourcesAvailableConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225ResourcesAvailableConfirmOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225ResourcesAvailableConfirmOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225ResourcesAvailableConfirmOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225ResourcesAvailableConfirm Encode */
HS_RESULT ASNH225ResourcesAvailableConfirm_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ResourcesAvailableConfirm *pObj = (ASNH225ResourcesAvailableConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225ResourcesAvailableConfirmOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225ResourcesAvailableConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ProtocolIdentifier_Encode( &(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_tokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_cryptoTokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Encode( &(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_genericData ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_genericData), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225ResourcesAvailableConfirm Decode */
HS_RESULT ASNH225ResourcesAvailableConfirm_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ResourcesAvailableConfirm *pObj = (ASNH225ResourcesAvailableConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225ResourcesAvailableConfirmOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225ResourcesAvailableConfirmOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ProtocolIdentifier_Decode(&(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_tokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_cryptoTokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Decode(&(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_genericData ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_genericData), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ResourcesAvailableConfirm Print */
HS_RESULT ASNH225ResourcesAvailableConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ResourcesAvailableConfirm *pObj = (ASNH225ResourcesAvailableConfirm *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ResourcesAvailableConfirm_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	ASNH225ProtocolIdentifier_Print( &(pObj->m_protocolIdentifier), pDepth+1, "protocolIdentifier" );
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225ResourcesAvailableConfirm_IsIncludeOptionField( pObj, e_ASNH225ResourcesAvailableConfirmOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225InfoRequestAck Class
*/
/*ASNH225InfoRequestAck Constructor*/
HS_RESULT new_ASNH225InfoRequestAck(void *pObject)
{
	ASNH225InfoRequestAck *pObj = (ASNH225InfoRequestAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225InfoRequestAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225InfoRequestAck Destructor */
HS_RESULT delete_ASNH225InfoRequestAck(void *pObject)
{
	ASNH225InfoRequestAck *pObj = (ASNH225InfoRequestAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequestAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	return HS_OK;
}

/* ASNH225InfoRequestAck MakeMold */
HS_RESULT ASNH225InfoRequestAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225InfoRequestAck *pObj = (ASNH225InfoRequestAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	return HS_OK;
}

/* ASNH225InfoRequestAck IncludeOptionalField */
HS_RESULT ASNH225InfoRequestAck_IncludeOptionField( void *pObject, ASNH225InfoRequestAckOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225InfoRequestAck *pObj = (ASNH225InfoRequestAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestAck_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestAckOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225InfoRequestAck IsIncludeOptionalField */
BOOL ASNH225InfoRequestAck_IsIncludeOptionField( void *pObject, ASNH225InfoRequestAckOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225InfoRequestAck *pObj = (ASNH225InfoRequestAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestAck_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestAckOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225InfoRequestAck Encode */
HS_RESULT ASNH225InfoRequestAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestAck *pObj = (ASNH225InfoRequestAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225InfoRequestAckOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestAckOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_tokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_cryptoTokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Encode( &(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225InfoRequestAck Decode */
HS_RESULT ASNH225InfoRequestAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestAck *pObj = (ASNH225InfoRequestAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225InfoRequestAckOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestAckOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_tokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_cryptoTokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Decode(&(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225InfoRequestAck Print */
HS_RESULT ASNH225InfoRequestAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225InfoRequestAck *pObj = (ASNH225InfoRequestAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225InfoRequestAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225InfoRequestAck_IsIncludeOptionField( pObj, e_ASNH225InfoRequestAckOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225InfoRequestNakReason Struct
*/
/* ASNH225InfoRequestNakReason Constructor */
HS_RESULT new_ASNH225InfoRequestNakReason( void *pObject )
{
	ASNH225InfoRequestNakReason *pObj = (ASNH225InfoRequestNakReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225InfoRequestNakReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225InfoRequestNakReasonChoice_notRegistered;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225InfoRequestNakReasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225InfoRequestNakReason Destructor */
HS_RESULT delete_ASNH225InfoRequestNakReason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestNakReason *pObj = (ASNH225InfoRequestNakReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequestNakReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225InfoRequestNakReason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequestNakReason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225InfoRequestNakReason SetChoice */
void* ASNH225InfoRequestNakReason_SetChoice( void *pObject, ASNH225InfoRequestNakReasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225InfoRequestNakReason *pObj = (ASNH225InfoRequestNakReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225InfoRequestNakReasonChoiceSizeExt ){
		if( pChoice > (ASNH225InfoRequestNakReasonChoice)(e_ASNH225InfoRequestNakReasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225InfoRequestNakReason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225InfoRequestNakReasonChoice_notRegistered ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225InfoRequestNakReasonChoice_securityDenial ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225InfoRequestNakReasonChoice_undefinedReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225InfoRequestNakReason DeleteAlternation */
HS_RESULT ASNH225InfoRequestNakReason_DeleteAlternation(void *pObject)
{
	ASNH225InfoRequestNakReason *pObj = (ASNH225InfoRequestNakReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_notRegistered ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_securityDenial ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_undefinedReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225InfoRequestNakReason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225InfoRequestNakReason Encode */
HS_RESULT ASNH225InfoRequestNakReason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225InfoRequestNakReason *pObj = (ASNH225InfoRequestNakReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225InfoRequestNakReasonChoiceSize )
		{
			if( pObj->choice > ((ASNH225InfoRequestNakReasonChoice)(e_ASNH225InfoRequestNakReasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225InfoRequestNakReasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH225InfoRequestNakReasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_notRegistered ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_securityDenial ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225InfoRequestNakReason Decode */
HS_RESULT ASNH225InfoRequestNakReason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225InfoRequestNakReason *pObj = (ASNH225InfoRequestNakReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225InfoRequestNakReasonChoiceSize;
	}
	else
	{
		if( e_ASNH225InfoRequestNakReasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225InfoRequestNakReasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225InfoRequestNakReasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225InfoRequestNakReason_SetChoice( pObj, (ASNH225InfoRequestNakReasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_notRegistered ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_securityDenial ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNakReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225InfoRequestNakReason Print */
HS_RESULT ASNH225InfoRequestNakReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225InfoRequestNakReason *pObj = (ASNH225InfoRequestNakReason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225InfoRequestNakReason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_notRegistered ){
		AsnNull_Print( pObj->alter, pDepth+1, "notRegistered" );
	}
	else if ( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_securityDenial ){
		AsnNull_Print( pObj->alter, pDepth+1, "securityDenial" );
	}
	else if ( pObj->choice == e_ASNH225InfoRequestNakReasonChoice_undefinedReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "undefinedReason" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225InfoRequestNak Class
*/
/*ASNH225InfoRequestNak Constructor*/
HS_RESULT new_ASNH225InfoRequestNak(void *pObject)
{
	ASNH225InfoRequestNak *pObj = (ASNH225InfoRequestNak *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225InfoRequestNak(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225InfoRequestNakReason( &(pObj->m_nakReason) );
	new_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225InfoRequestNak Destructor */
HS_RESULT delete_ASNH225InfoRequestNak(void *pObject)
{
	ASNH225InfoRequestNak *pObj = (ASNH225InfoRequestNak *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225InfoRequestNak(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225InfoRequestNakReason( &(pObj->m_nakReason) );
	delete_ASNH225AltGKInfo( &(pObj->m_altGKInfo) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	return HS_OK;
}

/* ASNH225InfoRequestNak MakeMold */
HS_RESULT ASNH225InfoRequestNak_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225InfoRequestNak *pObj = (ASNH225InfoRequestNak *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNak_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225InfoRequestNakReason_MakeMold(&(pObj->m_nakReason));
	ASNH225AltGKInfo_MakeMold(&(pObj->m_altGKInfo));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	return HS_OK;
}

/* ASNH225InfoRequestNak IncludeOptionalField */
HS_RESULT ASNH225InfoRequestNak_IncludeOptionField( void *pObject, ASNH225InfoRequestNakOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225InfoRequestNak *pObj = (ASNH225InfoRequestNak *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNak_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestNakOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225InfoRequestNak IsIncludeOptionalField */
BOOL ASNH225InfoRequestNak_IsIncludeOptionField( void *pObject, ASNH225InfoRequestNakOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225InfoRequestNak *pObj = (ASNH225InfoRequestNak *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNak_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225InfoRequestNakOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225InfoRequestNak Encode */
HS_RESULT ASNH225InfoRequestNak_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestNak *pObj = (ASNH225InfoRequestNak *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNak_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225InfoRequestNakOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestNakOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNak_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225InfoRequestNakReason_Encode( &(pObj->m_nakReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNak_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_altGKInfo ) ){
		if( (tRet=ASNH225AltGKInfo_Encode( &(pObj->m_altGKInfo),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_tokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_cryptoTokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Encode( &(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225InfoRequestNak Decode */
HS_RESULT ASNH225InfoRequestNak_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225InfoRequestNak *pObj = (ASNH225InfoRequestNak *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNak_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225InfoRequestNakOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225InfoRequestNakOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNak_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225InfoRequestNakReason_Decode(&(pObj->m_nakReason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225InfoRequestNak_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_altGKInfo ) ){
		if( (tRet=ASNH225AltGKInfo_Decode(&(pObj->m_altGKInfo),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_tokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_cryptoTokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Decode(&(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225InfoRequestNak_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225InfoRequestNak Print */
HS_RESULT ASNH225InfoRequestNak_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225InfoRequestNak *pObj = (ASNH225InfoRequestNak *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225InfoRequestNak_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	ASNH225InfoRequestNakReason_Print( &(pObj->m_nakReason), pDepth+1, "nakReason" );
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_altGKInfo ) )
		ASNH225AltGKInfo_Print( &(pObj->m_altGKInfo), pDepth+1, "altGKInfo" );
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225InfoRequestNak_IsIncludeOptionField( pObj, e_ASNH225InfoRequestNakOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ServiceControlIndication_callSpecific Class
*/
/*ASNH225ServiceControlIndication_callSpecific Constructor*/
HS_RESULT new_ASNH225ServiceControlIndication_callSpecific(void *pObject)
{
	ASNH225ServiceControlIndication_callSpecific *pObj = (ASNH225ServiceControlIndication_callSpecific *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ServiceControlIndication_callSpecific(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	new_AsnBoolean( &(pObj->m_answeredCall) );

	return HS_OK;
}

/* ASNH225ServiceControlIndication_callSpecific Destructor */
HS_RESULT delete_ASNH225ServiceControlIndication_callSpecific(void *pObject)
{
	ASNH225ServiceControlIndication_callSpecific *pObj = (ASNH225ServiceControlIndication_callSpecific *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlIndication_callSpecific(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	delete_AsnBoolean( &(pObj->m_answeredCall) );
	return HS_OK;
}

/* ASNH225ServiceControlIndication_callSpecific MakeMold */
HS_RESULT ASNH225ServiceControlIndication_callSpecific_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ServiceControlIndication_callSpecific *pObj = (ASNH225ServiceControlIndication_callSpecific *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	ASNH225ConferenceIdentifier_MakeMold(&(pObj->m_conferenceID));
	return HS_OK;
}

/* ASNH225ServiceControlIndication_callSpecific Encode */
HS_RESULT ASNH225ServiceControlIndication_callSpecific_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225ServiceControlIndication_callSpecific *pObj = (ASNH225ServiceControlIndication_callSpecific *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225CallIdentifier_Encode( &(pObj->m_callIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Encode( &(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_answeredCall),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225ServiceControlIndication_callSpecific Decode */
HS_RESULT ASNH225ServiceControlIndication_callSpecific_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225ServiceControlIndication_callSpecific *pObj = (ASNH225ServiceControlIndication_callSpecific *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225CallIdentifier_Decode(&(pObj->m_callIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Decode(&(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_answeredCall),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ServiceControlIndication_callSpecific Print */
HS_RESULT ASNH225ServiceControlIndication_callSpecific_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ServiceControlIndication_callSpecific *pObj = (ASNH225ServiceControlIndication_callSpecific *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ServiceControlIndication_callSpecific_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	ASNH225ConferenceIdentifier_Print( &(pObj->m_conferenceID), pDepth+1, "conferenceID" );
	AsnBoolean_Print( &(pObj->m_answeredCall), pDepth+1, "answeredCall" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ServiceControlIndication Class
*/
/*ASNH225ServiceControlIndication Constructor*/
HS_RESULT new_ASNH225ServiceControlIndication(void *pObject)
{
	ASNH225ServiceControlIndication *pObj = (ASNH225ServiceControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ServiceControlIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	new_ASNH225ServiceControlIndication_callSpecific( &(pObj->m_callSpecific) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225ServiceControlIndication Destructor */
HS_RESULT delete_ASNH225ServiceControlIndication(void *pObject)
{
	ASNH225ServiceControlIndication *pObj = (ASNH225ServiceControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	delete_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	delete_ASNH225ServiceControlIndication_callSpecific( &(pObj->m_callSpecific) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225ServiceControlIndication MakeMold */
HS_RESULT ASNH225ServiceControlIndication_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ServiceControlIndication *pObj = (ASNH225ServiceControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	ASNH225EndpointIdentifier_MakeMold(&(pObj->m_endpointIdentifier));
	ASNH225ServiceControlIndication_callSpecific_MakeMold(&(pObj->m_callSpecific));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225ServiceControlIndication IncludeOptionalField */
HS_RESULT ASNH225ServiceControlIndication_IncludeOptionField( void *pObject, ASNH225ServiceControlIndicationOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225ServiceControlIndication *pObj = (ASNH225ServiceControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225ServiceControlIndicationOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225ServiceControlIndication IsIncludeOptionalField */
BOOL ASNH225ServiceControlIndication_IsIncludeOptionField( void *pObject, ASNH225ServiceControlIndicationOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225ServiceControlIndication *pObj = (ASNH225ServiceControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225ServiceControlIndicationOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225ServiceControlIndication Encode */
HS_RESULT ASNH225ServiceControlIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ServiceControlIndication *pObj = (ASNH225ServiceControlIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225ServiceControlIndicationOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225ServiceControlIndicationOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_serviceControl),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_endpointIdentifier ) ){
		if( (tRet=ASNH225EndpointIdentifier_Encode( &(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_callSpecific ) ){
		if( (tRet=ASNH225ServiceControlIndication_callSpecific_Encode( &(pObj->m_callSpecific),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_tokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_cryptoTokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Encode( &(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_featureSet ) ){
		if( (tRet=ASNH225FeatureSet_Encode( &(pObj->m_featureSet),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_genericData ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_genericData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225ServiceControlIndication Decode */
HS_RESULT ASNH225ServiceControlIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ServiceControlIndication *pObj = (ASNH225ServiceControlIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225ServiceControlIndicationOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225ServiceControlIndicationOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_serviceControl),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_endpointIdentifier ) ){
		if( (tRet=ASNH225EndpointIdentifier_Decode(&(pObj->m_endpointIdentifier),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_callSpecific ) ){
		if( (tRet=ASNH225ServiceControlIndication_callSpecific_Decode(&(pObj->m_callSpecific),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_tokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_cryptoTokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Decode(&(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_featureSet ) ){
		if( (tRet=ASNH225FeatureSet_Decode(&(pObj->m_featureSet),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_genericData ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_genericData),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ServiceControlIndication Print */
HS_RESULT ASNH225ServiceControlIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ServiceControlIndication *pObj = (ASNH225ServiceControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ServiceControlIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_endpointIdentifier ) )
		ASNH225EndpointIdentifier_Print( &(pObj->m_endpointIdentifier), pDepth+1, "endpointIdentifier" );
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_callSpecific ) )
		ASNH225ServiceControlIndication_callSpecific_Print( &(pObj->m_callSpecific), pDepth+1, "callSpecific" );
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	if( ASNH225ServiceControlIndication_IsIncludeOptionField( pObj, e_ASNH225ServiceControlIndicationOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ServiceControlResponse_result Struct
*/
/* ASNH225ServiceControlResponse_result Constructor */
HS_RESULT new_ASNH225ServiceControlResponse_result( void *pObject )
{
	ASNH225ServiceControlResponse_result *pObj = (ASNH225ServiceControlResponse_result *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ServiceControlResponse_result(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225ServiceControlResponse_resultChoice_started;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225ServiceControlResponse_resultChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225ServiceControlResponse_result Destructor */
HS_RESULT delete_ASNH225ServiceControlResponse_result( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225ServiceControlResponse_result *pObj = (ASNH225ServiceControlResponse_result *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlResponse_result(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225ServiceControlResponse_result_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlResponse_result(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225ServiceControlResponse_result SetChoice */
void* ASNH225ServiceControlResponse_result_SetChoice( void *pObject, ASNH225ServiceControlResponse_resultChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225ServiceControlResponse_result *pObj = (ASNH225ServiceControlResponse_result *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225ServiceControlResponse_resultChoiceSizeExt ){
		if( pChoice > (ASNH225ServiceControlResponse_resultChoice)(e_ASNH225ServiceControlResponse_resultChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225ServiceControlResponse_result_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225ServiceControlResponse_resultChoice_started ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ServiceControlResponse_resultChoice_failed ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ServiceControlResponse_resultChoice_stopped ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ServiceControlResponse_resultChoice_notAvailable ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ServiceControlResponse_resultChoice_neededFeatureNotSupported ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225ServiceControlResponse_result DeleteAlternation */
HS_RESULT ASNH225ServiceControlResponse_result_DeleteAlternation(void *pObject)
{
	ASNH225ServiceControlResponse_result *pObj = (ASNH225ServiceControlResponse_result *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_started ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_failed ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_stopped ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_notAvailable ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_neededFeatureNotSupported ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225ServiceControlResponse_result_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225ServiceControlResponse_result Encode */
HS_RESULT ASNH225ServiceControlResponse_result_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225ServiceControlResponse_result *pObj = (ASNH225ServiceControlResponse_result *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225ServiceControlResponse_resultChoiceSize )
		{
			if( pObj->choice > ((ASNH225ServiceControlResponse_resultChoice)(e_ASNH225ServiceControlResponse_resultChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225ServiceControlResponse_resultChoiceSize)) )
	}
	else
	{
		if( e_ASNH225ServiceControlResponse_resultChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_started ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_failed ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_stopped ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_notAvailable ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_neededFeatureNotSupported ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225ServiceControlResponse_result Decode */
HS_RESULT ASNH225ServiceControlResponse_result_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225ServiceControlResponse_result *pObj = (ASNH225ServiceControlResponse_result *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225ServiceControlResponse_resultChoiceSize;
	}
	else
	{
		if( e_ASNH225ServiceControlResponse_resultChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225ServiceControlResponse_resultChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225ServiceControlResponse_resultChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225ServiceControlResponse_result_SetChoice( pObj, (ASNH225ServiceControlResponse_resultChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_started ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_failed ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_stopped ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_notAvailable ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_neededFeatureNotSupported ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ServiceControlResponse_result Print */
HS_RESULT ASNH225ServiceControlResponse_result_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ServiceControlResponse_result *pObj = (ASNH225ServiceControlResponse_result *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ServiceControlResponse_result_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_started ){
		AsnNull_Print( pObj->alter, pDepth+1, "started" );
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_failed ){
		AsnNull_Print( pObj->alter, pDepth+1, "failed" );
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_stopped ){
		AsnNull_Print( pObj->alter, pDepth+1, "stopped" );
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_notAvailable ){
		AsnNull_Print( pObj->alter, pDepth+1, "notAvailable" );
	}
	else if ( pObj->choice == e_ASNH225ServiceControlResponse_resultChoice_neededFeatureNotSupported ){
		AsnNull_Print( pObj->alter, pDepth+1, "neededFeatureNotSupported" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ServiceControlResponse Class
*/
/*ASNH225ServiceControlResponse Constructor*/
HS_RESULT new_ASNH225ServiceControlResponse(void *pObject)
{
	ASNH225ServiceControlResponse *pObj = (ASNH225ServiceControlResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ServiceControlResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	new_ASNH225ServiceControlResponse_result( &(pObj->m_result) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225ServiceControlResponse Destructor */
HS_RESULT delete_ASNH225ServiceControlResponse(void *pObject)
{
	ASNH225ServiceControlResponse *pObj = (ASNH225ServiceControlResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225RequestSeqNum( &(pObj->m_requestSeqNum) );
	delete_ASNH225ServiceControlResponse_result( &(pObj->m_result) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_ASNH225ICV( &(pObj->m_integrityCheckValue) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225ServiceControlResponse MakeMold */
HS_RESULT ASNH225ServiceControlResponse_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ServiceControlResponse *pObj = (ASNH225ServiceControlResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225RequestSeqNum_MakeMold(&(pObj->m_requestSeqNum));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	ASNH225ICV_MakeMold(&(pObj->m_integrityCheckValue));
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225ServiceControlResponse IncludeOptionalField */
HS_RESULT ASNH225ServiceControlResponse_IncludeOptionField( void *pObject, ASNH225ServiceControlResponseOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225ServiceControlResponse *pObj = (ASNH225ServiceControlResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225ServiceControlResponseOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225ServiceControlResponse IsIncludeOptionalField */
BOOL ASNH225ServiceControlResponse_IsIncludeOptionField( void *pObject, ASNH225ServiceControlResponseOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225ServiceControlResponse *pObj = (ASNH225ServiceControlResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225ServiceControlResponseOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225ServiceControlResponse Encode */
HS_RESULT ASNH225ServiceControlResponse_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ServiceControlResponse *pObj = (ASNH225ServiceControlResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225ServiceControlResponseOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225ServiceControlResponseOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Encode( &(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_result ) ){
		if( (tRet=ASNH225ServiceControlResponse_result_Encode( &(pObj->m_result),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_tokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_cryptoTokens),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Encode( &(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_featureSet ) ){
		if( (tRet=ASNH225FeatureSet_Encode( &(pObj->m_featureSet),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_genericData ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_genericData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225ServiceControlResponse Decode */
HS_RESULT ASNH225ServiceControlResponse_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ServiceControlResponse *pObj = (ASNH225ServiceControlResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225ServiceControlResponseOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225ServiceControlResponseOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225RequestSeqNum_Decode(&(pObj->m_requestSeqNum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_result ) ){
		if( (tRet=ASNH225ServiceControlResponse_result_Decode(&(pObj->m_result),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_tokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_tokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_cryptoTokens ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_cryptoTokens),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_integrityCheckValue ) ){
		if( (tRet=ASNH225ICV_Decode(&(pObj->m_integrityCheckValue),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_featureSet ) ){
		if( (tRet=ASNH225FeatureSet_Decode(&(pObj->m_featureSet),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_genericData ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_genericData),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ServiceControlResponse Print */
HS_RESULT ASNH225ServiceControlResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ServiceControlResponse *pObj = (ASNH225ServiceControlResponse *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ServiceControlResponse_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225RequestSeqNum_Print( &(pObj->m_requestSeqNum), pDepth+1, "requestSeqNum" );
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_result ) )
		ASNH225ServiceControlResponse_result_Print( &(pObj->m_result), pDepth+1, "result" );
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_integrityCheckValue ) )
		ASNH225ICV_Print( &(pObj->m_integrityCheckValue), pDepth+1, "integrityCheckValue" );
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	if( ASNH225ServiceControlResponse_IsIncludeOptionField( pObj, e_ASNH225ServiceControlResponseOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225RasMessage Struct
*/
/* ASNH225RasMessage Constructor */
HS_RESULT new_ASNH225RasMessage( void *pObject )
{
	ASNH225RasMessage *pObj = (ASNH225RasMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225RasMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225RasMessageChoice_gatekeeperRequest;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225RasMessageChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225RasMessage Destructor */
HS_RESULT delete_ASNH225RasMessage( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225RasMessage *pObj = (ASNH225RasMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225RasMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225RasMessage_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225RasMessage(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225RasMessage SetChoice */
void* ASNH225RasMessage_SetChoice( void *pObject, ASNH225RasMessageChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225RasMessage *pObj = (ASNH225RasMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RasMessage_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225RasMessageChoiceSizeExt ){
		if( pChoice > (ASNH225RasMessageChoice)(e_ASNH225RasMessageChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225RasMessage_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225RasMessageChoice_gatekeeperRequest ){
		ASNH225GatekeeperRequest *tAlter = (ASNH225GatekeeperRequest *)HSMalloc( sizeof(ASNH225GatekeeperRequest) );
		new_ASNH225GatekeeperRequest(tAlter);
		ASNH225GatekeeperRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_gatekeeperConfirm ){
		ASNH225GatekeeperConfirm *tAlter = (ASNH225GatekeeperConfirm *)HSMalloc( sizeof(ASNH225GatekeeperConfirm) );
		new_ASNH225GatekeeperConfirm(tAlter);
		ASNH225GatekeeperConfirm_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_gatekeeperReject ){
		ASNH225GatekeeperReject *tAlter = (ASNH225GatekeeperReject *)HSMalloc( sizeof(ASNH225GatekeeperReject) );
		new_ASNH225GatekeeperReject(tAlter);
		ASNH225GatekeeperReject_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_registrationRequest ){
		ASNH225RegistrationRequest *tAlter = (ASNH225RegistrationRequest *)HSMalloc( sizeof(ASNH225RegistrationRequest) );
		new_ASNH225RegistrationRequest(tAlter);
		ASNH225RegistrationRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_registrationConfirm ){
		ASNH225RegistrationConfirm *tAlter = (ASNH225RegistrationConfirm *)HSMalloc( sizeof(ASNH225RegistrationConfirm) );
		new_ASNH225RegistrationConfirm(tAlter);
		ASNH225RegistrationConfirm_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_registrationReject ){
		ASNH225RegistrationReject *tAlter = (ASNH225RegistrationReject *)HSMalloc( sizeof(ASNH225RegistrationReject) );
		new_ASNH225RegistrationReject(tAlter);
		ASNH225RegistrationReject_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_unregistrationRequest ){
		ASNH225UnregistrationRequest *tAlter = (ASNH225UnregistrationRequest *)HSMalloc( sizeof(ASNH225UnregistrationRequest) );
		new_ASNH225UnregistrationRequest(tAlter);
		ASNH225UnregistrationRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_unregistrationConfirm ){
		ASNH225UnregistrationConfirm *tAlter = (ASNH225UnregistrationConfirm *)HSMalloc( sizeof(ASNH225UnregistrationConfirm) );
		new_ASNH225UnregistrationConfirm(tAlter);
		ASNH225UnregistrationConfirm_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_unregistrationReject ){
		ASNH225UnregistrationReject *tAlter = (ASNH225UnregistrationReject *)HSMalloc( sizeof(ASNH225UnregistrationReject) );
		new_ASNH225UnregistrationReject(tAlter);
		ASNH225UnregistrationReject_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_admissionRequest ){
		ASNH225AdmissionRequest *tAlter = (ASNH225AdmissionRequest *)HSMalloc( sizeof(ASNH225AdmissionRequest) );
		new_ASNH225AdmissionRequest(tAlter);
		ASNH225AdmissionRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_admissionConfirm ){
		ASNH225AdmissionConfirm *tAlter = (ASNH225AdmissionConfirm *)HSMalloc( sizeof(ASNH225AdmissionConfirm) );
		new_ASNH225AdmissionConfirm(tAlter);
		ASNH225AdmissionConfirm_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_admissionReject ){
		ASNH225AdmissionReject *tAlter = (ASNH225AdmissionReject *)HSMalloc( sizeof(ASNH225AdmissionReject) );
		new_ASNH225AdmissionReject(tAlter);
		ASNH225AdmissionReject_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_bandwidthRequest ){
		ASNH225BandwidthRequest *tAlter = (ASNH225BandwidthRequest *)HSMalloc( sizeof(ASNH225BandwidthRequest) );
		new_ASNH225BandwidthRequest(tAlter);
		ASNH225BandwidthRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_bandwidthConfirm ){
		ASNH225BandwidthConfirm *tAlter = (ASNH225BandwidthConfirm *)HSMalloc( sizeof(ASNH225BandwidthConfirm) );
		new_ASNH225BandwidthConfirm(tAlter);
		ASNH225BandwidthConfirm_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_bandwidthReject ){
		ASNH225BandwidthReject *tAlter = (ASNH225BandwidthReject *)HSMalloc( sizeof(ASNH225BandwidthReject) );
		new_ASNH225BandwidthReject(tAlter);
		ASNH225BandwidthReject_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_disengageRequest ){
		ASNH225DisengageRequest *tAlter = (ASNH225DisengageRequest *)HSMalloc( sizeof(ASNH225DisengageRequest) );
		new_ASNH225DisengageRequest(tAlter);
		ASNH225DisengageRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_disengageConfirm ){
		ASNH225DisengageConfirm *tAlter = (ASNH225DisengageConfirm *)HSMalloc( sizeof(ASNH225DisengageConfirm) );
		new_ASNH225DisengageConfirm(tAlter);
		ASNH225DisengageConfirm_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_disengageReject ){
		ASNH225DisengageReject *tAlter = (ASNH225DisengageReject *)HSMalloc( sizeof(ASNH225DisengageReject) );
		new_ASNH225DisengageReject(tAlter);
		ASNH225DisengageReject_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_locationRequest ){
		ASNH225LocationRequest *tAlter = (ASNH225LocationRequest *)HSMalloc( sizeof(ASNH225LocationRequest) );
		new_ASNH225LocationRequest(tAlter);
		ASNH225LocationRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_locationConfirm ){
		ASNH225LocationConfirm *tAlter = (ASNH225LocationConfirm *)HSMalloc( sizeof(ASNH225LocationConfirm) );
		new_ASNH225LocationConfirm(tAlter);
		ASNH225LocationConfirm_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_locationReject ){
		ASNH225LocationReject *tAlter = (ASNH225LocationReject *)HSMalloc( sizeof(ASNH225LocationReject) );
		new_ASNH225LocationReject(tAlter);
		ASNH225LocationReject_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_infoRequest ){
		ASNH225InfoRequest *tAlter = (ASNH225InfoRequest *)HSMalloc( sizeof(ASNH225InfoRequest) );
		new_ASNH225InfoRequest(tAlter);
		ASNH225InfoRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_infoRequestResponse ){
		ASNH225InfoRequestResponse *tAlter = (ASNH225InfoRequestResponse *)HSMalloc( sizeof(ASNH225InfoRequestResponse) );
		new_ASNH225InfoRequestResponse(tAlter);
		ASNH225InfoRequestResponse_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_nonStandardMessage ){
		ASNH225NonStandardMessage *tAlter = (ASNH225NonStandardMessage *)HSMalloc( sizeof(ASNH225NonStandardMessage) );
		new_ASNH225NonStandardMessage(tAlter);
		ASNH225NonStandardMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_unknownMessageResponse ){
		ASNH225UnknownMessageResponse *tAlter = (ASNH225UnknownMessageResponse *)HSMalloc( sizeof(ASNH225UnknownMessageResponse) );
		new_ASNH225UnknownMessageResponse(tAlter);
		ASNH225UnknownMessageResponse_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225RasMessageChoice_requestInProgress ){
		ASNH225RequestInProgress *tAlter = (ASNH225RequestInProgress *)HSMalloc( sizeof(ASNH225RequestInProgress) );
		new_ASNH225RequestInProgress(tAlter);
		ASNH225RequestInProgress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_resourcesAvailableIndicate ){
		ASNH225ResourcesAvailableIndicate *tAlter = (ASNH225ResourcesAvailableIndicate *)HSMalloc( sizeof(ASNH225ResourcesAvailableIndicate) );
		new_ASNH225ResourcesAvailableIndicate(tAlter);
		ASNH225ResourcesAvailableIndicate_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_resourcesAvailableConfirm ){
		ASNH225ResourcesAvailableConfirm *tAlter = (ASNH225ResourcesAvailableConfirm *)HSMalloc( sizeof(ASNH225ResourcesAvailableConfirm) );
		new_ASNH225ResourcesAvailableConfirm(tAlter);
		ASNH225ResourcesAvailableConfirm_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_infoRequestAck ){
		ASNH225InfoRequestAck *tAlter = (ASNH225InfoRequestAck *)HSMalloc( sizeof(ASNH225InfoRequestAck) );
		new_ASNH225InfoRequestAck(tAlter);
		ASNH225InfoRequestAck_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_infoRequestNak ){
		ASNH225InfoRequestNak *tAlter = (ASNH225InfoRequestNak *)HSMalloc( sizeof(ASNH225InfoRequestNak) );
		new_ASNH225InfoRequestNak(tAlter);
		ASNH225InfoRequestNak_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_serviceControlIndication ){
		ASNH225ServiceControlIndication *tAlter = (ASNH225ServiceControlIndication *)HSMalloc( sizeof(ASNH225ServiceControlIndication) );
		new_ASNH225ServiceControlIndication(tAlter);
		ASNH225ServiceControlIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225RasMessageChoice_serviceControlResponse ){
		ASNH225ServiceControlResponse *tAlter = (ASNH225ServiceControlResponse *)HSMalloc( sizeof(ASNH225ServiceControlResponse) );
		new_ASNH225ServiceControlResponse(tAlter);
		ASNH225ServiceControlResponse_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RasMessage_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225RasMessage DeleteAlternation */
HS_RESULT ASNH225RasMessage_DeleteAlternation(void *pObject)
{
	ASNH225RasMessage *pObj = (ASNH225RasMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RasMessage_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperRequest ){
			delete_ASNH225GatekeeperRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperConfirm ){
			delete_ASNH225GatekeeperConfirm(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperReject ){
			delete_ASNH225GatekeeperReject(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationRequest ){
			delete_ASNH225RegistrationRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationConfirm ){
			delete_ASNH225RegistrationConfirm(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationReject ){
			delete_ASNH225RegistrationReject(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationRequest ){
			delete_ASNH225UnregistrationRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationConfirm ){
			delete_ASNH225UnregistrationConfirm(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationReject ){
			delete_ASNH225UnregistrationReject(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionRequest ){
			delete_ASNH225AdmissionRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionConfirm ){
			delete_ASNH225AdmissionConfirm(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionReject ){
			delete_ASNH225AdmissionReject(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthRequest ){
			delete_ASNH225BandwidthRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthConfirm ){
			delete_ASNH225BandwidthConfirm(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthReject ){
			delete_ASNH225BandwidthReject(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageRequest ){
			delete_ASNH225DisengageRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageConfirm ){
			delete_ASNH225DisengageConfirm(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageReject ){
			delete_ASNH225DisengageReject(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_locationRequest ){
			delete_ASNH225LocationRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_locationConfirm ){
			delete_ASNH225LocationConfirm(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_locationReject ){
			delete_ASNH225LocationReject(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequest ){
			delete_ASNH225InfoRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestResponse ){
			delete_ASNH225InfoRequestResponse(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_nonStandardMessage ){
			delete_ASNH225NonStandardMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_unknownMessageResponse ){
			delete_ASNH225UnknownMessageResponse(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225RasMessageChoice_requestInProgress ){
			delete_ASNH225RequestInProgress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_resourcesAvailableIndicate ){
			delete_ASNH225ResourcesAvailableIndicate(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_resourcesAvailableConfirm ){
			delete_ASNH225ResourcesAvailableConfirm(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestAck ){
			delete_ASNH225InfoRequestAck(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestNak ){
			delete_ASNH225InfoRequestNak(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_serviceControlIndication ){
			delete_ASNH225ServiceControlIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225RasMessageChoice_serviceControlResponse ){
			delete_ASNH225ServiceControlResponse(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225RasMessage_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225RasMessage Encode */
HS_RESULT ASNH225RasMessage_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225RasMessage *pObj = (ASNH225RasMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RasMessage_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RasMessage_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225RasMessageChoiceSize )
		{
			if( pObj->choice > ((ASNH225RasMessageChoice)(e_ASNH225RasMessageChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225RasMessageChoiceSize)) )
	}
	else
	{
		if( e_ASNH225RasMessageChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperRequest ){
		if( (tRet=ASNH225GatekeeperRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperConfirm ){
		if( (tRet=ASNH225GatekeeperConfirm_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperReject ){
		if( (tRet=ASNH225GatekeeperReject_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationRequest ){
		if( (tRet=ASNH225RegistrationRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationConfirm ){
		if( (tRet=ASNH225RegistrationConfirm_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationReject ){
		if( (tRet=ASNH225RegistrationReject_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationRequest ){
		if( (tRet=ASNH225UnregistrationRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationConfirm ){
		if( (tRet=ASNH225UnregistrationConfirm_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationReject ){
		if( (tRet=ASNH225UnregistrationReject_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionRequest ){
		if( (tRet=ASNH225AdmissionRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionConfirm ){
		if( (tRet=ASNH225AdmissionConfirm_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionReject ){
		if( (tRet=ASNH225AdmissionReject_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthRequest ){
		if( (tRet=ASNH225BandwidthRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthConfirm ){
		if( (tRet=ASNH225BandwidthConfirm_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthReject ){
		if( (tRet=ASNH225BandwidthReject_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageRequest ){
		if( (tRet=ASNH225DisengageRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageConfirm ){
		if( (tRet=ASNH225DisengageConfirm_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageReject ){
		if( (tRet=ASNH225DisengageReject_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_locationRequest ){
		if( (tRet=ASNH225LocationRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_locationConfirm ){
		if( (tRet=ASNH225LocationConfirm_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_locationReject ){
		if( (tRet=ASNH225LocationReject_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequest ){
		if( (tRet=ASNH225InfoRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestResponse ){
		if( (tRet=ASNH225InfoRequestResponse_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_nonStandardMessage ){
		if( (tRet=ASNH225NonStandardMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unknownMessageResponse ){
		if( (tRet=ASNH225UnknownMessageResponse_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225RasMessageChoice_requestInProgress ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225RequestInProgress_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_resourcesAvailableIndicate ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225ResourcesAvailableIndicate_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_resourcesAvailableConfirm ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225ResourcesAvailableConfirm_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestAck ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225InfoRequestAck_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestNak ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225InfoRequestNak_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_serviceControlIndication ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225ServiceControlIndication_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_serviceControlResponse ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225ServiceControlResponse_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RasMessage_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225RasMessage Decode */
HS_RESULT ASNH225RasMessage_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225RasMessage *pObj = (ASNH225RasMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RasMessage_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225RasMessageChoiceSize;
	}
	else
	{
		if( e_ASNH225RasMessageChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225RasMessageChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225RasMessageChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225RasMessage_SetChoice( pObj, (ASNH225RasMessageChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RasMessage_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperRequest ){
		if( (tRet=ASNH225GatekeeperRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperConfirm ){
		if( (tRet=ASNH225GatekeeperConfirm_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperReject ){
		if( (tRet=ASNH225GatekeeperReject_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationRequest ){
		if( (tRet=ASNH225RegistrationRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationConfirm ){
		if( (tRet=ASNH225RegistrationConfirm_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationReject ){
		if( (tRet=ASNH225RegistrationReject_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationRequest ){
		if( (tRet=ASNH225UnregistrationRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationConfirm ){
		if( (tRet=ASNH225UnregistrationConfirm_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationReject ){
		if( (tRet=ASNH225UnregistrationReject_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionRequest ){
		if( (tRet=ASNH225AdmissionRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionConfirm ){
		if( (tRet=ASNH225AdmissionConfirm_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionReject ){
		if( (tRet=ASNH225AdmissionReject_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthRequest ){
		if( (tRet=ASNH225BandwidthRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthConfirm ){
		if( (tRet=ASNH225BandwidthConfirm_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthReject ){
		if( (tRet=ASNH225BandwidthReject_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageRequest ){
		if( (tRet=ASNH225DisengageRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageConfirm ){
		if( (tRet=ASNH225DisengageConfirm_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageReject ){
		if( (tRet=ASNH225DisengageReject_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_locationRequest ){
		if( (tRet=ASNH225LocationRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_locationConfirm ){
		if( (tRet=ASNH225LocationConfirm_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_locationReject ){
		if( (tRet=ASNH225LocationReject_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequest ){
		if( (tRet=ASNH225InfoRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestResponse ){
		if( (tRet=ASNH225InfoRequestResponse_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_nonStandardMessage ){
		if( (tRet=ASNH225NonStandardMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unknownMessageResponse ){
		if( (tRet=ASNH225UnknownMessageResponse_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225RasMessageChoice_requestInProgress ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225RequestInProgress_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_resourcesAvailableIndicate ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225ResourcesAvailableIndicate_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_resourcesAvailableConfirm ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225ResourcesAvailableConfirm_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestAck ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225InfoRequestAck_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestNak ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225InfoRequestNak_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_serviceControlIndication ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225ServiceControlIndication_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_serviceControlResponse ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225ServiceControlResponse_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225RasMessage_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225RasMessage Print */
HS_RESULT ASNH225RasMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225RasMessage *pObj = (ASNH225RasMessage *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225RasMessage_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperRequest ){
		ASNH225GatekeeperRequest_Print( pObj->alter, pDepth+1, "gatekeeperRequest" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperConfirm ){
		ASNH225GatekeeperConfirm_Print( pObj->alter, pDepth+1, "gatekeeperConfirm" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_gatekeeperReject ){
		ASNH225GatekeeperReject_Print( pObj->alter, pDepth+1, "gatekeeperReject" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationRequest ){
		ASNH225RegistrationRequest_Print( pObj->alter, pDepth+1, "registrationRequest" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationConfirm ){
		ASNH225RegistrationConfirm_Print( pObj->alter, pDepth+1, "registrationConfirm" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_registrationReject ){
		ASNH225RegistrationReject_Print( pObj->alter, pDepth+1, "registrationReject" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationRequest ){
		ASNH225UnregistrationRequest_Print( pObj->alter, pDepth+1, "unregistrationRequest" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationConfirm ){
		ASNH225UnregistrationConfirm_Print( pObj->alter, pDepth+1, "unregistrationConfirm" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unregistrationReject ){
		ASNH225UnregistrationReject_Print( pObj->alter, pDepth+1, "unregistrationReject" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionRequest ){
		ASNH225AdmissionRequest_Print( pObj->alter, pDepth+1, "admissionRequest" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionConfirm ){
		ASNH225AdmissionConfirm_Print( pObj->alter, pDepth+1, "admissionConfirm" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_admissionReject ){
		ASNH225AdmissionReject_Print( pObj->alter, pDepth+1, "admissionReject" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthRequest ){
		ASNH225BandwidthRequest_Print( pObj->alter, pDepth+1, "bandwidthRequest" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthConfirm ){
		ASNH225BandwidthConfirm_Print( pObj->alter, pDepth+1, "bandwidthConfirm" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_bandwidthReject ){
		ASNH225BandwidthReject_Print( pObj->alter, pDepth+1, "bandwidthReject" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageRequest ){
		ASNH225DisengageRequest_Print( pObj->alter, pDepth+1, "disengageRequest" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageConfirm ){
		ASNH225DisengageConfirm_Print( pObj->alter, pDepth+1, "disengageConfirm" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_disengageReject ){
		ASNH225DisengageReject_Print( pObj->alter, pDepth+1, "disengageReject" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_locationRequest ){
		ASNH225LocationRequest_Print( pObj->alter, pDepth+1, "locationRequest" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_locationConfirm ){
		ASNH225LocationConfirm_Print( pObj->alter, pDepth+1, "locationConfirm" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_locationReject ){
		ASNH225LocationReject_Print( pObj->alter, pDepth+1, "locationReject" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequest ){
		ASNH225InfoRequest_Print( pObj->alter, pDepth+1, "infoRequest" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestResponse ){
		ASNH225InfoRequestResponse_Print( pObj->alter, pDepth+1, "infoRequestResponse" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_nonStandardMessage ){
		ASNH225NonStandardMessage_Print( pObj->alter, pDepth+1, "nonStandardMessage" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_unknownMessageResponse ){
		ASNH225UnknownMessageResponse_Print( pObj->alter, pDepth+1, "unknownMessageResponse" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225RasMessageChoice_requestInProgress ){
		ASNH225RequestInProgress_Print( pObj->alter, pDepth+1, "requestInProgress" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_resourcesAvailableIndicate ){
		ASNH225ResourcesAvailableIndicate_Print( pObj->alter, pDepth+1, "resourcesAvailableIndicate" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_resourcesAvailableConfirm ){
		ASNH225ResourcesAvailableConfirm_Print( pObj->alter, pDepth+1, "resourcesAvailableConfirm" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestAck ){
		ASNH225InfoRequestAck_Print( pObj->alter, pDepth+1, "infoRequestAck" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_infoRequestNak ){
		ASNH225InfoRequestNak_Print( pObj->alter, pDepth+1, "infoRequestNak" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_serviceControlIndication ){
		ASNH225ServiceControlIndication_Print( pObj->alter, pDepth+1, "serviceControlIndication" );
	}
	else if ( pObj->choice == e_ASNH225RasMessageChoice_serviceControlResponse ){
		ASNH225ServiceControlResponse_Print( pObj->alter, pDepth+1, "serviceControlResponse" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

