/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<H245.h>	2005-03-27,12:37

*/
#ifndef __2005_03_27__12_37__H245_H__
#define __2005_03_27__12_37__H245_H__


#include "H323Define.h"
#include "handship.h"





typedef struct
{
	AsnInteger	inheritance;
} ASNH245SequenceNumber;
HS_RESULT new_ASNH245SequenceNumber( void *pObject );
HS_RESULT delete_ASNH245SequenceNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245SequenceNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245SequenceNumber_MakeMold( void *pObject );
HS_RESULT ASNH245SequenceNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245SequenceNumber_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnSequenceOf	inheritance;
} ASNH245AlternativeCapabilitySet;
HS_RESULT new_ASNH245AlternativeCapabilitySet( void *pObject );
HS_RESULT delete_ASNH245AlternativeCapabilitySet( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245AlternativeCapabilitySet_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245AlternativeCapabilitySet_MakeMold( void *pObject );
HS_RESULT ASNH245AlternativeCapabilitySet_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245AlternativeCapabilitySet_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH245CapabilityTableEntryNumber;
HS_RESULT new_ASNH245CapabilityTableEntryNumber( void *pObject );
HS_RESULT delete_ASNH245CapabilityTableEntryNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CapabilityTableEntryNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CapabilityTableEntryNumber_MakeMold( void *pObject );
HS_RESULT ASNH245CapabilityTableEntryNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CapabilityTableEntryNumber_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH245CapabilityDescriptorNumber;
HS_RESULT new_ASNH245CapabilityDescriptorNumber( void *pObject );
HS_RESULT delete_ASNH245CapabilityDescriptorNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CapabilityDescriptorNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CapabilityDescriptorNumber_MakeMold( void *pObject );
HS_RESULT ASNH245CapabilityDescriptorNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CapabilityDescriptorNumber_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnSequenceOf	inheritance;
} ASNH245EncryptionCapability;
HS_RESULT new_ASNH245EncryptionCapability( void *pObject );
HS_RESULT delete_ASNH245EncryptionCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EncryptionCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245EncryptionCapability_MakeMold( void *pObject );
HS_RESULT ASNH245EncryptionCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EncryptionCapability_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH245LogicalChannelNumber;
HS_RESULT new_ASNH245LogicalChannelNumber( void *pObject );
HS_RESULT delete_ASNH245LogicalChannelNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245LogicalChannelNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245LogicalChannelNumber_MakeMold( void *pObject );
HS_RESULT ASNH245LogicalChannelNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245LogicalChannelNumber_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH245MultiplexTableEntryNumber;
HS_RESULT new_ASNH245MultiplexTableEntryNumber( void *pObject );
HS_RESULT delete_ASNH245MultiplexTableEntryNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexTableEntryNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexTableEntryNumber_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexTableEntryNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexTableEntryNumber_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnSequenceOf	inheritance;
} ASNH245ModeDescription;
HS_RESULT new_ASNH245ModeDescription( void *pObject );
HS_RESULT delete_ASNH245ModeDescription( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ModeDescription_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ModeDescription_MakeMold( void *pObject );
HS_RESULT ASNH245ModeDescription_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ModeDescription_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnSequenceOf	inheritance;
} ASNH245CertSelectionCriteria;
HS_RESULT new_ASNH245CertSelectionCriteria( void *pObject );
HS_RESULT delete_ASNH245CertSelectionCriteria( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CertSelectionCriteria_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CertSelectionCriteria_MakeMold( void *pObject );
HS_RESULT ASNH245CertSelectionCriteria_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CertSelectionCriteria_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH245McuNumber;
HS_RESULT new_ASNH245McuNumber( void *pObject );
HS_RESULT delete_ASNH245McuNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245McuNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245McuNumber_MakeMold( void *pObject );
HS_RESULT ASNH245McuNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245McuNumber_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH245TerminalNumber;
HS_RESULT new_ASNH245TerminalNumber( void *pObject );
HS_RESULT delete_ASNH245TerminalNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TerminalNumber_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalNumber_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnOctetString	inheritance;
} ASNH245TerminalID;
HS_RESULT new_ASNH245TerminalID( void *pObject );
HS_RESULT delete_ASNH245TerminalID( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalID_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TerminalID_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalID_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalID_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnOctetString	inheritance;
} ASNH245ConferenceID;
HS_RESULT new_ASNH245ConferenceID( void *pObject );
HS_RESULT delete_ASNH245ConferenceID( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceID_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceID_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceID_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceID_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnOctetString	inheritance;
} ASNH245Password;
HS_RESULT new_ASNH245Password( void *pObject );
HS_RESULT delete_ASNH245Password( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245Password_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245Password_MakeMold( void *pObject );
HS_RESULT ASNH245Password_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245Password_Decode( void *pObject, AsnStream *pStrm );

typedef struct
{
	AsnInteger	inheritance;
} ASNH245MaximumBitRate;
HS_RESULT new_ASNH245MaximumBitRate( void *pObject );
HS_RESULT delete_ASNH245MaximumBitRate( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaximumBitRate_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MaximumBitRate_MakeMold( void *pObject );
HS_RESULT ASNH245MaximumBitRate_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MaximumBitRate_Decode( void *pObject, AsnStream *pStrm );


#define e_ASNH245NonStandardIdentifier_h221NonStandardOptionMapSize 0
#define e_ASNH245NonStandardIdentifier_h221NonStandardOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_t35CountryCode;
	AsnInteger m_t35Extension;
	AsnInteger m_manufacturerCode;
} ASNH245NonStandardIdentifier_h221NonStandard;
HS_RESULT new_ASNH245NonStandardIdentifier_h221NonStandard( void *pObject );
HS_RESULT delete_ASNH245NonStandardIdentifier_h221NonStandard( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NonStandardIdentifier_h221NonStandard_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NonStandardIdentifier_h221NonStandard_MakeMold( void *pObject );
HS_RESULT ASNH245NonStandardIdentifier_h221NonStandard_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NonStandardIdentifier_h221NonStandard_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NonStandardIdentifierChoice_object,
	e_ASNH245NonStandardIdentifierChoice_h221NonStandard
} ASNH245NonStandardIdentifierChoice;


#define e_ASNH245NonStandardIdentifierChoiceSize		2
#define e_ASNH245NonStandardIdentifierChoiceSizeExt	2
typedef struct
{
	ASNH245NonStandardIdentifierChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NonStandardIdentifier;
HS_RESULT new_ASNH245NonStandardIdentifier( void *pObject );
HS_RESULT delete_ASNH245NonStandardIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NonStandardIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NonStandardIdentifier_SetChoice( void *pObject, ASNH245NonStandardIdentifierChoice pChoice );
HS_RESULT ASNH245NonStandardIdentifier_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NonStandardIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH245NonStandardIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NonStandardIdentifier_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245NonStandardParameterOptionMapSize 0
#define e_ASNH245NonStandardParameterOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245NonStandardIdentifier m_nonStandardIdentifier;
	AsnOctetString m_data;
} ASNH245NonStandardParameter;
HS_RESULT new_ASNH245NonStandardParameter( void *pObject );
HS_RESULT delete_ASNH245NonStandardParameter( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NonStandardParameter_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NonStandardParameter_MakeMold( void *pObject );
HS_RESULT ASNH245NonStandardParameter_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NonStandardParameter_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245NonStandardMessageOptionMapSize 0
#define e_ASNH245NonStandardMessageOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245NonStandardParameter m_nonStandardData;
	/*...,*/
} ASNH245NonStandardMessage;
HS_RESULT new_ASNH245NonStandardMessage( void *pObject );
HS_RESULT delete_ASNH245NonStandardMessage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NonStandardMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NonStandardMessage_MakeMold( void *pObject );
HS_RESULT ASNH245NonStandardMessage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NonStandardMessage_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MasterSlaveDeterminationOptionMapSize 0
#define e_ASNH245MasterSlaveDeterminationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_terminalType;
	AsnInteger m_statusDeterminationNumber;
	/*...,*/
} ASNH245MasterSlaveDetermination;
HS_RESULT new_ASNH245MasterSlaveDetermination( void *pObject );
HS_RESULT delete_ASNH245MasterSlaveDetermination( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MasterSlaveDetermination_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MasterSlaveDetermination_MakeMold( void *pObject );
HS_RESULT ASNH245MasterSlaveDetermination_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MasterSlaveDetermination_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245VCCapability_aal1OptionMapSize 0
#define e_ASNH245VCCapability_aal1OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_nullClockRecovery;
	AsnBoolean m_srtsClockRecovery;
	AsnBoolean m_adaptiveClockRecovery;
	AsnBoolean m_nullErrorCorrection;
	AsnBoolean m_longInterleaver;
	AsnBoolean m_shortInterleaver;
	AsnBoolean m_errorCorrectionOnly;
	AsnBoolean m_structuredDataTransfer;
	AsnBoolean m_partiallyFilledCells;
	/*...,*/
} ASNH245VCCapability_aal1;
HS_RESULT new_ASNH245VCCapability_aal1( void *pObject );
HS_RESULT delete_ASNH245VCCapability_aal1( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VCCapability_aal1_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245VCCapability_aal1_MakeMold( void *pObject );
HS_RESULT ASNH245VCCapability_aal1_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VCCapability_aal1_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245VCCapability_aal5OptionMapSize 0
#define e_ASNH245VCCapability_aal5OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_forwardMaximumSDUSize;
	AsnInteger m_backwardMaximumSDUSize;
	/*...,*/
} ASNH245VCCapability_aal5;
HS_RESULT new_ASNH245VCCapability_aal5( void *pObject );
HS_RESULT delete_ASNH245VCCapability_aal5( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VCCapability_aal5_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245VCCapability_aal5_MakeMold( void *pObject );
HS_RESULT ASNH245VCCapability_aal5_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VCCapability_aal5_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245VCCapability_availableBitRates_type_rangeOfBitRatesOptionMapSize 0
#define e_ASNH245VCCapability_availableBitRates_type_rangeOfBitRatesOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_lowerBitRate;
	AsnInteger m_higherBitRate;
} ASNH245VCCapability_availableBitRates_type_rangeOfBitRates;
HS_RESULT new_ASNH245VCCapability_availableBitRates_type_rangeOfBitRates( void *pObject );
HS_RESULT delete_ASNH245VCCapability_availableBitRates_type_rangeOfBitRates( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_MakeMold( void *pObject );
HS_RESULT ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245VCCapability_availableBitRates_typeChoice_singleBitRate,
	e_ASNH245VCCapability_availableBitRates_typeChoice_rangeOfBitRates
} ASNH245VCCapability_availableBitRates_typeChoice;


#define e_ASNH245VCCapability_availableBitRates_typeChoiceSize		2
#define e_ASNH245VCCapability_availableBitRates_typeChoiceSizeExt	2
typedef struct
{
	ASNH245VCCapability_availableBitRates_typeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245VCCapability_availableBitRates_type;
HS_RESULT new_ASNH245VCCapability_availableBitRates_type( void *pObject );
HS_RESULT delete_ASNH245VCCapability_availableBitRates_type( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VCCapability_availableBitRates_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245VCCapability_availableBitRates_type_SetChoice( void *pObject, ASNH245VCCapability_availableBitRates_typeChoice pChoice );
HS_RESULT ASNH245VCCapability_availableBitRates_type_DeleteAlternation( void *pObject );
HS_RESULT ASNH245VCCapability_availableBitRates_type_MakeMold( void *pObject );
HS_RESULT ASNH245VCCapability_availableBitRates_type_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VCCapability_availableBitRates_type_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245VCCapability_availableBitRatesOptionMapSize 0
#define e_ASNH245VCCapability_availableBitRatesOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245VCCapability_availableBitRates_type m_type;
	/*...,*/
} ASNH245VCCapability_availableBitRates;
HS_RESULT new_ASNH245VCCapability_availableBitRates( void *pObject );
HS_RESULT delete_ASNH245VCCapability_availableBitRates( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VCCapability_availableBitRates_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245VCCapability_availableBitRates_MakeMold( void *pObject );
HS_RESULT ASNH245VCCapability_availableBitRates_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VCCapability_availableBitRates_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245Q2931Address_addressChoice_internationalNumber,
	e_ASNH245Q2931Address_addressChoice_nsapAddress

} ASNH245Q2931Address_addressChoice;


#define e_ASNH245Q2931Address_addressChoiceSize		2
#define e_ASNH245Q2931Address_addressChoiceSizeExt	2
typedef struct
{
	ASNH245Q2931Address_addressChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245Q2931Address_address;
HS_RESULT new_ASNH245Q2931Address_address( void *pObject );
HS_RESULT delete_ASNH245Q2931Address_address( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245Q2931Address_address_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245Q2931Address_address_SetChoice( void *pObject, ASNH245Q2931Address_addressChoice pChoice );
HS_RESULT ASNH245Q2931Address_address_DeleteAlternation( void *pObject );
HS_RESULT ASNH245Q2931Address_address_MakeMold( void *pObject );
HS_RESULT ASNH245Q2931Address_address_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245Q2931Address_address_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245Q2931AddressOptionMap_subaddress

} ASNH245Q2931AddressOptionMap;


#define e_ASNH245Q2931AddressOptionMapSize 1
#define e_ASNH245Q2931AddressOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245Q2931Address_address m_address;
	AsnOctetString m_subaddress;
	/*...,*/
} ASNH245Q2931Address;
HS_RESULT new_ASNH245Q2931Address( void *pObject );
HS_RESULT delete_ASNH245Q2931Address( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245Q2931Address_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245Q2931Address_IncludeOptionField( void *pObject, ASNH245Q2931AddressOptionMap pOptionMap );
BOOL	  ASNH245Q2931Address_IsIncludeOptionField( void *pObject, ASNH245Q2931AddressOptionMap pOptionMap );
HS_RESULT ASNH245Q2931Address_MakeMold( void *pObject );
HS_RESULT ASNH245Q2931Address_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245Q2931Address_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245VCCapability_aal1ViaGatewayOptionMapSize 0
#define e_ASNH245VCCapability_aal1ViaGatewayOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_gatewayAddress;
	AsnBoolean m_nullClockRecovery;
	AsnBoolean m_srtsClockRecovery;
	AsnBoolean m_adaptiveClockRecovery;
	AsnBoolean m_nullErrorCorrection;
	AsnBoolean m_longInterleaver;
	AsnBoolean m_shortInterleaver;
	AsnBoolean m_errorCorrectionOnly;
	AsnBoolean m_structuredDataTransfer;
	AsnBoolean m_partiallyFilledCells;
	/*...,*/
} ASNH245VCCapability_aal1ViaGateway;
HS_RESULT new_ASNH245VCCapability_aal1ViaGateway( void *pObject );
HS_RESULT delete_ASNH245VCCapability_aal1ViaGateway( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VCCapability_aal1ViaGateway_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245VCCapability_aal1ViaGateway_MakeMold( void *pObject );
HS_RESULT ASNH245VCCapability_aal1ViaGateway_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VCCapability_aal1ViaGateway_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245VCCapabilityOptionMap_aal1,
	e_ASNH245VCCapabilityOptionMap_aal5
,
	e_ASNH245VCCapabilityOptionMap_aal1ViaGateway
} ASNH245VCCapabilityOptionMap;


#define e_ASNH245VCCapabilityOptionMapSize 2
#define e_ASNH245VCCapabilityOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245VCCapability_aal1 m_aal1;
	ASNH245VCCapability_aal5 m_aal5;
	AsnBoolean m_transportStream;
	AsnBoolean m_programStream;
	ASNH245VCCapability_availableBitRates m_availableBitRates;
	/*...,*/
	ASNH245VCCapability_aal1ViaGateway m_aal1ViaGateway;
} ASNH245VCCapability;
HS_RESULT new_ASNH245VCCapability( void *pObject );
HS_RESULT delete_ASNH245VCCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VCCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245VCCapability_IncludeOptionField( void *pObject, ASNH245VCCapabilityOptionMap pOptionMap );
BOOL	  ASNH245VCCapability_IsIncludeOptionField( void *pObject, ASNH245VCCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245VCCapability_MakeMold( void *pObject );
HS_RESULT ASNH245VCCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VCCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H222CapabilityOptionMapSize 0
#define e_ASNH245H222CapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_numberOfVCs;
	AsnSequenceOf m_vcCapability;
	/*...,*/
} ASNH245H222Capability;
HS_RESULT new_ASNH245H222Capability( void *pObject );
HS_RESULT delete_ASNH245H222Capability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H222Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H222Capability_MakeMold( void *pObject );
HS_RESULT ASNH245H222Capability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H222Capability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223Capability_h223MultiplexTableCapability_enhancedOptionMapSize 0
#define e_ASNH245H223Capability_h223MultiplexTableCapability_enhancedOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_maximumNestingDepth;
	AsnInteger m_maximumElementListSize;
	AsnInteger m_maximumSubElementListSize;
	/*...,*/
} ASNH245H223Capability_h223MultiplexTableCapability_enhanced;
HS_RESULT new_ASNH245H223Capability_h223MultiplexTableCapability_enhanced( void *pObject );
HS_RESULT delete_ASNH245H223Capability_h223MultiplexTableCapability_enhanced( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_enhanced_MakeMold( void *pObject );
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_basic,
	e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_enhanced
} ASNH245H223Capability_h223MultiplexTableCapabilityChoice;


#define e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSize		2
#define e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSizeExt	2
typedef struct
{
	ASNH245H223Capability_h223MultiplexTableCapabilityChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223Capability_h223MultiplexTableCapability;
HS_RESULT new_ASNH245H223Capability_h223MultiplexTableCapability( void *pObject );
HS_RESULT delete_ASNH245H223Capability_h223MultiplexTableCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223Capability_h223MultiplexTableCapability_SetChoice( void *pObject, ASNH245H223Capability_h223MultiplexTableCapabilityChoice pChoice );
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_MakeMold( void *pObject );
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223Capability_mobileOperationTransmitCapabilityOptionMapSize 0
#define e_ASNH245H223Capability_mobileOperationTransmitCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_modeChangeCapability;
	AsnBoolean m_h223AnnexA;
	AsnBoolean m_h223AnnexADoubleFlag;
	AsnBoolean m_h223AnnexB;
	AsnBoolean m_h223AnnexBwithHeader;
	/*...,*/
} ASNH245H223Capability_mobileOperationTransmitCapability;
HS_RESULT new_ASNH245H223Capability_mobileOperationTransmitCapability( void *pObject );
HS_RESULT delete_ASNH245H223Capability_mobileOperationTransmitCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223Capability_mobileOperationTransmitCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223Capability_mobileOperationTransmitCapability_MakeMold( void *pObject );
HS_RESULT ASNH245H223Capability_mobileOperationTransmitCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223Capability_mobileOperationTransmitCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245H223AnnexCCapabilityOptionMap_rsCodeCapability
} ASNH245H223AnnexCCapabilityOptionMap;


#define e_ASNH245H223AnnexCCapabilityOptionMapSize 0
#define e_ASNH245H223AnnexCCapabilityOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_videoWithAL1M;
	AsnBoolean m_videoWithAL2M;
	AsnBoolean m_videoWithAL3M;
	AsnBoolean m_audioWithAL1M;
	AsnBoolean m_audioWithAL2M;
	AsnBoolean m_audioWithAL3M;
	AsnBoolean m_dataWithAL1M;
	AsnBoolean m_dataWithAL2M;
	AsnBoolean m_dataWithAL3M;
	AsnBoolean m_alpduInterleaving;
	AsnInteger m_maximumAL1MPDUSize;
	AsnInteger m_maximumAL2MSDUSize;
	AsnInteger m_maximumAL3MSDUSize;
	/*...,*/
	AsnBoolean m_rsCodeCapability;
} ASNH245H223AnnexCCapability;
HS_RESULT new_ASNH245H223AnnexCCapability( void *pObject );
HS_RESULT delete_ASNH245H223AnnexCCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AnnexCCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223AnnexCCapability_IncludeOptionField( void *pObject, ASNH245H223AnnexCCapabilityOptionMap pOptionMap );
BOOL	  ASNH245H223AnnexCCapability_IsIncludeOptionField( void *pObject, ASNH245H223AnnexCCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245H223AnnexCCapability_MakeMold( void *pObject );
HS_RESULT ASNH245H223AnnexCCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AnnexCCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223Capability_mobileMultilinkFrameCapabilityOptionMapSize 0
#define e_ASNH245H223Capability_mobileMultilinkFrameCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_maximumSampleSize;
	AsnInteger m_maximumPayloadLength;
	/*...,*/
} ASNH245H223Capability_mobileMultilinkFrameCapability;
HS_RESULT new_ASNH245H223Capability_mobileMultilinkFrameCapability( void *pObject );
HS_RESULT delete_ASNH245H223Capability_mobileMultilinkFrameCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223Capability_mobileMultilinkFrameCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223Capability_mobileMultilinkFrameCapability_MakeMold( void *pObject );
HS_RESULT ASNH245H223Capability_mobileMultilinkFrameCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223Capability_mobileMultilinkFrameCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245H223CapabilityOptionMap_maxMUXPDUSizeCapability,
	e_ASNH245H223CapabilityOptionMap_nsrpSupport,
	e_ASNH245H223CapabilityOptionMap_mobileOperationTransmitCapability,
	e_ASNH245H223CapabilityOptionMap_h223AnnexCCapability,
	e_ASNH245H223CapabilityOptionMap_bitRate,
	e_ASNH245H223CapabilityOptionMap_mobileMultilinkFrameCapability
} ASNH245H223CapabilityOptionMap;


#define e_ASNH245H223CapabilityOptionMapSize 0
#define e_ASNH245H223CapabilityOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_transportWithI_frames;
	AsnBoolean m_videoWithAL1;
	AsnBoolean m_videoWithAL2;
	AsnBoolean m_videoWithAL3;
	AsnBoolean m_audioWithAL1;
	AsnBoolean m_audioWithAL2;
	AsnBoolean m_audioWithAL3;
	AsnBoolean m_dataWithAL1;
	AsnBoolean m_dataWithAL2;
	AsnBoolean m_dataWithAL3;
	AsnInteger m_maximumAl2SDUSize;
	AsnInteger m_maximumAl3SDUSize;
	AsnInteger m_maximumDelayJitter;
	ASNH245H223Capability_h223MultiplexTableCapability m_h223MultiplexTableCapability;
	/*...,*/
	AsnBoolean m_maxMUXPDUSizeCapability;
	AsnBoolean m_nsrpSupport;
	ASNH245H223Capability_mobileOperationTransmitCapability m_mobileOperationTransmitCapability;
	ASNH245H223AnnexCCapability m_h223AnnexCCapability;
	AsnInteger m_bitRate;
	ASNH245H223Capability_mobileMultilinkFrameCapability m_mobileMultilinkFrameCapability;
} ASNH245H223Capability;
HS_RESULT new_ASNH245H223Capability( void *pObject );
HS_RESULT delete_ASNH245H223Capability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223Capability_IncludeOptionField( void *pObject, ASNH245H223CapabilityOptionMap pOptionMap );
BOOL	  ASNH245H223Capability_IsIncludeOptionField( void *pObject, ASNH245H223CapabilityOptionMap pOptionMap );
HS_RESULT ASNH245H223Capability_MakeMold( void *pObject );
HS_RESULT ASNH245H223Capability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223Capability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245V75CapabilityOptionMapSize 0
#define e_ASNH245V75CapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_audioHeader;
	/*...,*/
} ASNH245V75Capability;
HS_RESULT new_ASNH245V75Capability( void *pObject );
HS_RESULT delete_ASNH245V75Capability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V75Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245V75Capability_MakeMold( void *pObject );
HS_RESULT ASNH245V75Capability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V75Capability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245V76CapabilityOptionMapSize 0
#define e_ASNH245V76CapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_suspendResumeCapabilitywAddress;
	AsnBoolean m_suspendResumeCapabilitywoAddress;
	AsnBoolean m_rejCapability;
	AsnBoolean m_sREJCapability;
	AsnBoolean m_mREJCapability;
	AsnBoolean m_crc8bitCapability;
	AsnBoolean m_crc16bitCapability;
	AsnBoolean m_crc32bitCapability;
	AsnBoolean m_uihCapability;
	AsnInteger m_numOfDLCS;
	AsnBoolean m_twoOctetAddressFieldCapability;
	AsnBoolean m_loopBackTestCapability;
	AsnInteger m_n401Capability;
	AsnInteger m_maxWindowSizeCapability;
	ASNH245V75Capability m_v75Capability;
	/*...,*/
} ASNH245V76Capability;
HS_RESULT new_ASNH245V76Capability( void *pObject );
HS_RESULT delete_ASNH245V76Capability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V76Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245V76Capability_MakeMold( void *pObject );
HS_RESULT ASNH245V76Capability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V76Capability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245V42bisOptionMapSize 0
#define e_ASNH245V42bisOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_numberOfCodewords;
	AsnInteger m_maximumStringLength;
	/*...,*/
} ASNH245V42bis;
HS_RESULT new_ASNH245V42bis( void *pObject );
HS_RESULT delete_ASNH245V42bis( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V42bis_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245V42bis_MakeMold( void *pObject );
HS_RESULT ASNH245V42bis_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V42bis_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CompressionTypeChoice_v42bis

} ASNH245CompressionTypeChoice;


#define e_ASNH245CompressionTypeChoiceSize		1
#define e_ASNH245CompressionTypeChoiceSizeExt	1
typedef struct
{
	ASNH245CompressionTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245CompressionType;
HS_RESULT new_ASNH245CompressionType( void *pObject );
HS_RESULT delete_ASNH245CompressionType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CompressionType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245CompressionType_SetChoice( void *pObject, ASNH245CompressionTypeChoice pChoice );
HS_RESULT ASNH245CompressionType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245CompressionType_MakeMold( void *pObject );
HS_RESULT ASNH245CompressionType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CompressionType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitCompression,
	e_ASNH245DataProtocolCapability_v76wCompressionChoice_receiveCompression,
	e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitAndReceiveCompression

} ASNH245DataProtocolCapability_v76wCompressionChoice;


#define e_ASNH245DataProtocolCapability_v76wCompressionChoiceSize		3
#define e_ASNH245DataProtocolCapability_v76wCompressionChoiceSizeExt	3
typedef struct
{
	ASNH245DataProtocolCapability_v76wCompressionChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245DataProtocolCapability_v76wCompression;
HS_RESULT new_ASNH245DataProtocolCapability_v76wCompression( void *pObject );
HS_RESULT delete_ASNH245DataProtocolCapability_v76wCompression( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataProtocolCapability_v76wCompression_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245DataProtocolCapability_v76wCompression_SetChoice( void *pObject, ASNH245DataProtocolCapability_v76wCompressionChoice pChoice );
HS_RESULT ASNH245DataProtocolCapability_v76wCompression_DeleteAlternation( void *pObject );
HS_RESULT ASNH245DataProtocolCapability_v76wCompression_MakeMold( void *pObject );
HS_RESULT ASNH245DataProtocolCapability_v76wCompression_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataProtocolCapability_v76wCompression_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245DataProtocolCapabilityChoice_nonStandard,
	e_ASNH245DataProtocolCapabilityChoice_v14buffered,
	e_ASNH245DataProtocolCapabilityChoice_v42lapm,
	e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelling,
	e_ASNH245DataProtocolCapabilityChoice_h310SeparateVCStack,
	e_ASNH245DataProtocolCapabilityChoice_h310SingleVCStack,
	e_ASNH245DataProtocolCapabilityChoice_transparent
,
	e_ASNH245DataProtocolCapabilityChoice_segmentationAndReassembly,
	e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelingwSAR,
	e_ASNH245DataProtocolCapabilityChoice_v120,
	e_ASNH245DataProtocolCapabilityChoice_separateLANStack,
	e_ASNH245DataProtocolCapabilityChoice_v76wCompression,
	e_ASNH245DataProtocolCapabilityChoice_tcp,
	e_ASNH245DataProtocolCapabilityChoice_udp
} ASNH245DataProtocolCapabilityChoice;


#define e_ASNH245DataProtocolCapabilityChoiceSize		7
#define e_ASNH245DataProtocolCapabilityChoiceSizeExt	14
typedef struct
{
	ASNH245DataProtocolCapabilityChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245DataProtocolCapability;
HS_RESULT new_ASNH245DataProtocolCapability( void *pObject );
HS_RESULT delete_ASNH245DataProtocolCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataProtocolCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245DataProtocolCapability_SetChoice( void *pObject, ASNH245DataProtocolCapabilityChoice pChoice );
HS_RESULT ASNH245DataProtocolCapability_DeleteAlternation( void *pObject );
HS_RESULT ASNH245DataProtocolCapability_MakeMold( void *pObject );
HS_RESULT ASNH245DataProtocolCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataProtocolCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245T84Profile_t84RestrictedOptionMapSize 0
#define e_ASNH245T84Profile_t84RestrictedOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_qcif;
	AsnBoolean m_cif;
	AsnBoolean m_ccir601Seq;
	AsnBoolean m_ccir601Prog;
	AsnBoolean m_hdtvSeq;
	AsnBoolean m_hdtvProg;
	AsnBoolean m_g3FacsMH200x100;
	AsnBoolean m_g3FacsMH200x200;
	AsnBoolean m_g4FacsMMR200x100;
	AsnBoolean m_g4FacsMMR200x200;
	AsnBoolean m_jbig200x200Seq;
	AsnBoolean m_jbig200x200Prog;
	AsnBoolean m_jbig300x300Seq;
	AsnBoolean m_jbig300x300Prog;
	AsnBoolean m_digPhotoLow;
	AsnBoolean m_digPhotoMedSeq;
	AsnBoolean m_digPhotoMedProg;
	AsnBoolean m_digPhotoHighSeq;
	AsnBoolean m_digPhotoHighProg;
	/*...,*/
} ASNH245T84Profile_t84Restricted;
HS_RESULT new_ASNH245T84Profile_t84Restricted( void *pObject );
HS_RESULT delete_ASNH245T84Profile_t84Restricted( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245T84Profile_t84Restricted_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245T84Profile_t84Restricted_MakeMold( void *pObject );
HS_RESULT ASNH245T84Profile_t84Restricted_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245T84Profile_t84Restricted_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245T84ProfileChoice_t84Unrestricted,
	e_ASNH245T84ProfileChoice_t84Restricted
} ASNH245T84ProfileChoice;


#define e_ASNH245T84ProfileChoiceSize		2
#define e_ASNH245T84ProfileChoiceSizeExt	2
typedef struct
{
	ASNH245T84ProfileChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245T84Profile;
HS_RESULT new_ASNH245T84Profile( void *pObject );
HS_RESULT delete_ASNH245T84Profile( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245T84Profile_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245T84Profile_SetChoice( void *pObject, ASNH245T84ProfileChoice pChoice );
HS_RESULT ASNH245T84Profile_DeleteAlternation( void *pObject );
HS_RESULT ASNH245T84Profile_MakeMold( void *pObject );
HS_RESULT ASNH245T84Profile_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245T84Profile_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245DataApplicationCapability_application_t84OptionMapSize 0
#define e_ASNH245DataApplicationCapability_application_t84OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245DataProtocolCapability m_t84Protocol;
	ASNH245T84Profile m_t84Profile;
} ASNH245DataApplicationCapability_application_t84;
HS_RESULT new_ASNH245DataApplicationCapability_application_t84( void *pObject );
HS_RESULT delete_ASNH245DataApplicationCapability_application_t84( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataApplicationCapability_application_t84_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245DataApplicationCapability_application_t84_MakeMold( void *pObject );
HS_RESULT ASNH245DataApplicationCapability_application_t84_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataApplicationCapability_application_t84_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245DataApplicationCapability_application_nlpidOptionMapSize 0
#define e_ASNH245DataApplicationCapability_application_nlpidOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245DataProtocolCapability m_nlpidProtocol;
	AsnOctetString m_nlpidData;
} ASNH245DataApplicationCapability_application_nlpid;
HS_RESULT new_ASNH245DataApplicationCapability_application_nlpid( void *pObject );
HS_RESULT delete_ASNH245DataApplicationCapability_application_nlpid( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataApplicationCapability_application_nlpid_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245DataApplicationCapability_application_nlpid_MakeMold( void *pObject );
HS_RESULT ASNH245DataApplicationCapability_application_nlpid_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataApplicationCapability_application_nlpid_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245T38FaxRateManagementChoice_localTCF,
	e_ASNH245T38FaxRateManagementChoice_transferredTCF

} ASNH245T38FaxRateManagementChoice;


#define e_ASNH245T38FaxRateManagementChoiceSize		2
#define e_ASNH245T38FaxRateManagementChoiceSizeExt	2
typedef struct
{
	ASNH245T38FaxRateManagementChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245T38FaxRateManagement;
HS_RESULT new_ASNH245T38FaxRateManagement( void *pObject );
HS_RESULT delete_ASNH245T38FaxRateManagement( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245T38FaxRateManagement_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245T38FaxRateManagement_SetChoice( void *pObject, ASNH245T38FaxRateManagementChoice pChoice );
HS_RESULT ASNH245T38FaxRateManagement_DeleteAlternation( void *pObject );
HS_RESULT ASNH245T38FaxRateManagement_MakeMold( void *pObject );
HS_RESULT ASNH245T38FaxRateManagement_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245T38FaxRateManagement_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPFEC,
	e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPRedundancy

} ASNH245T38FaxUdpOptions_t38FaxUdpECChoice;


#define e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSize		2
#define e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSizeExt	2
typedef struct
{
	ASNH245T38FaxUdpOptions_t38FaxUdpECChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245T38FaxUdpOptions_t38FaxUdpEC;
HS_RESULT new_ASNH245T38FaxUdpOptions_t38FaxUdpEC( void *pObject );
HS_RESULT delete_ASNH245T38FaxUdpOptions_t38FaxUdpEC( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245T38FaxUdpOptions_t38FaxUdpEC_SetChoice( void *pObject, ASNH245T38FaxUdpOptions_t38FaxUdpECChoice pChoice );
HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_DeleteAlternation( void *pObject );
HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_MakeMold( void *pObject );
HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245T38FaxUdpOptionsOptionMap_t38FaxMaxBuffer,
	e_ASNH245T38FaxUdpOptionsOptionMap_t38FaxMaxDatagram
} ASNH245T38FaxUdpOptionsOptionMap;


#define e_ASNH245T38FaxUdpOptionsOptionMapSize 2
#define e_ASNH245T38FaxUdpOptionsOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_t38FaxMaxBuffer;
	AsnInteger m_t38FaxMaxDatagram;
	ASNH245T38FaxUdpOptions_t38FaxUdpEC m_t38FaxUdpEC;
} ASNH245T38FaxUdpOptions;
HS_RESULT new_ASNH245T38FaxUdpOptions( void *pObject );
HS_RESULT delete_ASNH245T38FaxUdpOptions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245T38FaxUdpOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245T38FaxUdpOptions_IncludeOptionField( void *pObject, ASNH245T38FaxUdpOptionsOptionMap pOptionMap );
BOOL	  ASNH245T38FaxUdpOptions_IsIncludeOptionField( void *pObject, ASNH245T38FaxUdpOptionsOptionMap pOptionMap );
HS_RESULT ASNH245T38FaxUdpOptions_MakeMold( void *pObject );
HS_RESULT ASNH245T38FaxUdpOptions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245T38FaxUdpOptions_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245T38FaxTcpOptionsOptionMapSize 0
#define e_ASNH245T38FaxTcpOptionsOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_t38TCPBidirectionalMode;
	/*...,*/
} ASNH245T38FaxTcpOptions;
HS_RESULT new_ASNH245T38FaxTcpOptions( void *pObject );
HS_RESULT delete_ASNH245T38FaxTcpOptions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245T38FaxTcpOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245T38FaxTcpOptions_MakeMold( void *pObject );
HS_RESULT ASNH245T38FaxTcpOptions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245T38FaxTcpOptions_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245T38FaxProfileOptionMap_version,
	e_ASNH245T38FaxProfileOptionMap_t38FaxRateManagement,
	e_ASNH245T38FaxProfileOptionMap_t38FaxUdpOptions,
	e_ASNH245T38FaxProfileOptionMap_t38FaxTcpOptions
} ASNH245T38FaxProfileOptionMap;


#define e_ASNH245T38FaxProfileOptionMapSize 0
#define e_ASNH245T38FaxProfileOptionMapSizeExt 4
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_fillBitRemoval;
	AsnBoolean m_transcodingJBIG;
	AsnBoolean m_transcodingMMR;
	/*...,*/
	AsnInteger m_version;
	ASNH245T38FaxRateManagement m_t38FaxRateManagement;
	ASNH245T38FaxUdpOptions m_t38FaxUdpOptions;
	ASNH245T38FaxTcpOptions m_t38FaxTcpOptions;
} ASNH245T38FaxProfile;
HS_RESULT new_ASNH245T38FaxProfile( void *pObject );
HS_RESULT delete_ASNH245T38FaxProfile( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245T38FaxProfile_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245T38FaxProfile_IncludeOptionField( void *pObject, ASNH245T38FaxProfileOptionMap pOptionMap );
BOOL	  ASNH245T38FaxProfile_IsIncludeOptionField( void *pObject, ASNH245T38FaxProfileOptionMap pOptionMap );
HS_RESULT ASNH245T38FaxProfile_MakeMold( void *pObject );
HS_RESULT ASNH245T38FaxProfile_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245T38FaxProfile_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245DataApplicationCapability_application_t38faxOptionMapSize 0
#define e_ASNH245DataApplicationCapability_application_t38faxOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245DataProtocolCapability m_t38FaxProtocol;
	ASNH245T38FaxProfile m_t38FaxProfile;
} ASNH245DataApplicationCapability_application_t38fax;
HS_RESULT new_ASNH245DataApplicationCapability_application_t38fax( void *pObject );
HS_RESULT delete_ASNH245DataApplicationCapability_application_t38fax( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataApplicationCapability_application_t38fax_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245DataApplicationCapability_application_t38fax_MakeMold( void *pObject );
HS_RESULT ASNH245DataApplicationCapability_application_t38fax_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataApplicationCapability_application_t38fax_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CapabilityIdentifierChoice_standard,
	e_ASNH245CapabilityIdentifierChoice_h221NonStandard,
	e_ASNH245CapabilityIdentifierChoice_uuid,
	e_ASNH245CapabilityIdentifierChoice_domainBased

} ASNH245CapabilityIdentifierChoice;


#define e_ASNH245CapabilityIdentifierChoiceSize		4
#define e_ASNH245CapabilityIdentifierChoiceSizeExt	4
typedef struct
{
	ASNH245CapabilityIdentifierChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245CapabilityIdentifier;
HS_RESULT new_ASNH245CapabilityIdentifier( void *pObject );
HS_RESULT delete_ASNH245CapabilityIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CapabilityIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245CapabilityIdentifier_SetChoice( void *pObject, ASNH245CapabilityIdentifierChoice pChoice );
HS_RESULT ASNH245CapabilityIdentifier_DeleteAlternation( void *pObject );
HS_RESULT ASNH245CapabilityIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH245CapabilityIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CapabilityIdentifier_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ParameterIdentifierChoice_standard,
	e_ASNH245ParameterIdentifierChoice_h221NonStandard,
	e_ASNH245ParameterIdentifierChoice_uuid,
	e_ASNH245ParameterIdentifierChoice_domainBased

} ASNH245ParameterIdentifierChoice;


#define e_ASNH245ParameterIdentifierChoiceSize		4
#define e_ASNH245ParameterIdentifierChoiceSizeExt	4
typedef struct
{
	ASNH245ParameterIdentifierChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ParameterIdentifier;
HS_RESULT new_ASNH245ParameterIdentifier( void *pObject );
HS_RESULT delete_ASNH245ParameterIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ParameterIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ParameterIdentifier_SetChoice( void *pObject, ASNH245ParameterIdentifierChoice pChoice );
HS_RESULT ASNH245ParameterIdentifier_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ParameterIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH245ParameterIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ParameterIdentifier_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ParameterValueChoice_logical,
	e_ASNH245ParameterValueChoice_booleanArray,
	e_ASNH245ParameterValueChoice_unsignedMin,
	e_ASNH245ParameterValueChoice_unsignedMax,
	e_ASNH245ParameterValueChoice_unsigned32Min,
	e_ASNH245ParameterValueChoice_unsigned32Max,
	e_ASNH245ParameterValueChoice_octetString,
	e_ASNH245ParameterValueChoice_genericParameter

} ASNH245ParameterValueChoice;


#define e_ASNH245ParameterValueChoiceSize		8
#define e_ASNH245ParameterValueChoiceSizeExt	8
typedef struct
{
	ASNH245ParameterValueChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ParameterValue;
HS_RESULT new_ASNH245ParameterValue( void *pObject );
HS_RESULT delete_ASNH245ParameterValue( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ParameterValue_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ParameterValue_SetChoice( void *pObject, ASNH245ParameterValueChoice pChoice );
HS_RESULT ASNH245ParameterValue_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ParameterValue_MakeMold( void *pObject );
HS_RESULT ASNH245ParameterValue_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ParameterValue_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245GenericParameterOptionMap_supersedes

} ASNH245GenericParameterOptionMap;


#define e_ASNH245GenericParameterOptionMapSize 1
#define e_ASNH245GenericParameterOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245ParameterIdentifier m_parameterIdentifier;
	ASNH245ParameterValue m_parameterValue;
	AsnSequenceOf m_supersedes;
	/*...,*/
} ASNH245GenericParameter;
HS_RESULT new_ASNH245GenericParameter( void *pObject );
HS_RESULT delete_ASNH245GenericParameter( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245GenericParameter_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245GenericParameter_IncludeOptionField( void *pObject, ASNH245GenericParameterOptionMap pOptionMap );
BOOL	  ASNH245GenericParameter_IsIncludeOptionField( void *pObject, ASNH245GenericParameterOptionMap pOptionMap );
HS_RESULT ASNH245GenericParameter_MakeMold( void *pObject );
HS_RESULT ASNH245GenericParameter_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245GenericParameter_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245GenericCapabilityOptionMap_maxBitRate,
	e_ASNH245GenericCapabilityOptionMap_collapsing,
	e_ASNH245GenericCapabilityOptionMap_nonCollapsing,
	e_ASNH245GenericCapabilityOptionMap_nonCollapsingRaw,
	e_ASNH245GenericCapabilityOptionMap_transport

} ASNH245GenericCapabilityOptionMap;


#define e_ASNH245GenericCapabilityOptionMapSize 5
#define e_ASNH245GenericCapabilityOptionMapSizeExt 5
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245CapabilityIdentifier m_capabilityIdentifier;
	AsnInteger m_maxBitRate;
	AsnSequenceOf m_collapsing;
	AsnSequenceOf m_nonCollapsing;
	AsnOctetString m_nonCollapsingRaw;
	ASNH245DataProtocolCapability m_transport;
	/*...,*/
} ASNH245GenericCapability;
HS_RESULT new_ASNH245GenericCapability( void *pObject );
HS_RESULT delete_ASNH245GenericCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245GenericCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245GenericCapability_IncludeOptionField( void *pObject, ASNH245GenericCapabilityOptionMap pOptionMap );
BOOL	  ASNH245GenericCapability_IsIncludeOptionField( void *pObject, ASNH245GenericCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245GenericCapability_MakeMold( void *pObject );
HS_RESULT ASNH245GenericCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245GenericCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245DataApplicationCapability_applicationChoice_nonStandard,
	e_ASNH245DataApplicationCapability_applicationChoice_t120,
	e_ASNH245DataApplicationCapability_applicationChoice_dsm_cc,
	e_ASNH245DataApplicationCapability_applicationChoice_userData,
	e_ASNH245DataApplicationCapability_applicationChoice_t84,
	e_ASNH245DataApplicationCapability_applicationChoice_t434,
	e_ASNH245DataApplicationCapability_applicationChoice_h224,
	e_ASNH245DataApplicationCapability_applicationChoice_nlpid,
	e_ASNH245DataApplicationCapability_applicationChoice_dsvdControl,
	e_ASNH245DataApplicationCapability_applicationChoice_h222DataPartitioning
,
	e_ASNH245DataApplicationCapability_applicationChoice_t30fax,
	e_ASNH245DataApplicationCapability_applicationChoice_t140,
	e_ASNH245DataApplicationCapability_applicationChoice_t38fax,
	e_ASNH245DataApplicationCapability_applicationChoice_genericDataCapability
} ASNH245DataApplicationCapability_applicationChoice;


#define e_ASNH245DataApplicationCapability_applicationChoiceSize		10
#define e_ASNH245DataApplicationCapability_applicationChoiceSizeExt	14
typedef struct
{
	ASNH245DataApplicationCapability_applicationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245DataApplicationCapability_application;
HS_RESULT new_ASNH245DataApplicationCapability_application( void *pObject );
HS_RESULT delete_ASNH245DataApplicationCapability_application( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataApplicationCapability_application_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245DataApplicationCapability_application_SetChoice( void *pObject, ASNH245DataApplicationCapability_applicationChoice pChoice );
HS_RESULT ASNH245DataApplicationCapability_application_DeleteAlternation( void *pObject );
HS_RESULT ASNH245DataApplicationCapability_application_MakeMold( void *pObject );
HS_RESULT ASNH245DataApplicationCapability_application_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataApplicationCapability_application_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245DataApplicationCapabilityOptionMapSize 0
#define e_ASNH245DataApplicationCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245DataApplicationCapability_application m_application;
	AsnInteger m_maxBitRate;
	/*...,*/
} ASNH245DataApplicationCapability;
HS_RESULT new_ASNH245DataApplicationCapability( void *pObject );
HS_RESULT delete_ASNH245DataApplicationCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataApplicationCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245DataApplicationCapability_MakeMold( void *pObject );
HS_RESULT ASNH245DataApplicationCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataApplicationCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MediaDistributionCapabilityOptionMap_centralizedData,
	e_ASNH245MediaDistributionCapabilityOptionMap_distributedData

} ASNH245MediaDistributionCapabilityOptionMap;


#define e_ASNH245MediaDistributionCapabilityOptionMapSize 2
#define e_ASNH245MediaDistributionCapabilityOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_centralizedControl;
	AsnBoolean m_distributedControl;
	AsnBoolean m_centralizedAudio;
	AsnBoolean m_distributedAudio;
	AsnBoolean m_centralizedVideo;
	AsnBoolean m_distributedVideo;
	AsnSequenceOf m_centralizedData;
	AsnSequenceOf m_distributedData;
	/*...,*/
} ASNH245MediaDistributionCapability;
HS_RESULT new_ASNH245MediaDistributionCapability( void *pObject );
HS_RESULT delete_ASNH245MediaDistributionCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MediaDistributionCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MediaDistributionCapability_IncludeOptionField( void *pObject, ASNH245MediaDistributionCapabilityOptionMap pOptionMap );
BOOL	  ASNH245MediaDistributionCapability_IsIncludeOptionField( void *pObject, ASNH245MediaDistributionCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245MediaDistributionCapability_MakeMold( void *pObject );
HS_RESULT ASNH245MediaDistributionCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MediaDistributionCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultipointCapabilityOptionMapSize 0
#define e_ASNH245MultipointCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_multicastCapability;
	AsnBoolean m_multiUniCastConference;
	AsnSequenceOf m_mediaDistributionCapability;
	/*...,*/
} ASNH245MultipointCapability;
HS_RESULT new_ASNH245MultipointCapability( void *pObject );
HS_RESULT delete_ASNH245MultipointCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultipointCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultipointCapability_MakeMold( void *pObject );
HS_RESULT ASNH245MultipointCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultipointCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H2250Capability_mcCapabilityOptionMapSize 0
#define e_ASNH245H2250Capability_mcCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_centralizedConferenceMC;
	AsnBoolean m_decentralizedConferenceMC;
	/*...,*/
} ASNH245H2250Capability_mcCapability;
HS_RESULT new_ASNH245H2250Capability_mcCapability( void *pObject );
HS_RESULT delete_ASNH245H2250Capability_mcCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H2250Capability_mcCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H2250Capability_mcCapability_MakeMold( void *pObject );
HS_RESULT ASNH245H2250Capability_mcCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H2250Capability_mcCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RTPPayloadType_payloadDescriptorChoice_nonStandardIdentifier,
	e_ASNH245RTPPayloadType_payloadDescriptorChoice_rfc_number,
	e_ASNH245RTPPayloadType_payloadDescriptorChoice_oid

} ASNH245RTPPayloadType_payloadDescriptorChoice;


#define e_ASNH245RTPPayloadType_payloadDescriptorChoiceSize		3
#define e_ASNH245RTPPayloadType_payloadDescriptorChoiceSizeExt	3
typedef struct
{
	ASNH245RTPPayloadType_payloadDescriptorChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RTPPayloadType_payloadDescriptor;
HS_RESULT new_ASNH245RTPPayloadType_payloadDescriptor( void *pObject );
HS_RESULT delete_ASNH245RTPPayloadType_payloadDescriptor( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RTPPayloadType_payloadDescriptor_SetChoice( void *pObject, ASNH245RTPPayloadType_payloadDescriptorChoice pChoice );
HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_MakeMold( void *pObject );
HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RTPPayloadTypeOptionMap_payloadType

} ASNH245RTPPayloadTypeOptionMap;


#define e_ASNH245RTPPayloadTypeOptionMapSize 1
#define e_ASNH245RTPPayloadTypeOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245RTPPayloadType_payloadDescriptor m_payloadDescriptor;
	AsnInteger m_payloadType;
	/*...,*/
} ASNH245RTPPayloadType;
HS_RESULT new_ASNH245RTPPayloadType( void *pObject );
HS_RESULT delete_ASNH245RTPPayloadType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RTPPayloadType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RTPPayloadType_IncludeOptionField( void *pObject, ASNH245RTPPayloadTypeOptionMap pOptionMap );
BOOL	  ASNH245RTPPayloadType_IsIncludeOptionField( void *pObject, ASNH245RTPPayloadTypeOptionMap pOptionMap );
HS_RESULT ASNH245RTPPayloadType_MakeMold( void *pObject );
HS_RESULT ASNH245RTPPayloadType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RTPPayloadType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245MediaPacketizationCapabilityOptionMap_rtpPayloadType
} ASNH245MediaPacketizationCapabilityOptionMap;


#define e_ASNH245MediaPacketizationCapabilityOptionMapSize 0
#define e_ASNH245MediaPacketizationCapabilityOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_h261aVideoPacketization;
	/*...,*/
	AsnSequenceOf m_rtpPayloadType;
} ASNH245MediaPacketizationCapability;
HS_RESULT new_ASNH245MediaPacketizationCapability( void *pObject );
HS_RESULT delete_ASNH245MediaPacketizationCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MediaPacketizationCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MediaPacketizationCapability_IncludeOptionField( void *pObject, ASNH245MediaPacketizationCapabilityOptionMap pOptionMap );
BOOL	  ASNH245MediaPacketizationCapability_IsIncludeOptionField( void *pObject, ASNH245MediaPacketizationCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245MediaPacketizationCapability_MakeMold( void *pObject );
HS_RESULT ASNH245MediaPacketizationCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MediaPacketizationCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245QOSModeChoice_guaranteedQOS,
	e_ASNH245QOSModeChoice_controlledLoad

} ASNH245QOSModeChoice;


#define e_ASNH245QOSModeChoiceSize		2
#define e_ASNH245QOSModeChoiceSizeExt	2
typedef struct
{
	ASNH245QOSModeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245QOSMode;
HS_RESULT new_ASNH245QOSMode( void *pObject );
HS_RESULT delete_ASNH245QOSMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245QOSMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245QOSMode_SetChoice( void *pObject, ASNH245QOSModeChoice pChoice );
HS_RESULT ASNH245QOSMode_DeleteAlternation( void *pObject );
HS_RESULT ASNH245QOSMode_MakeMold( void *pObject );
HS_RESULT ASNH245QOSMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245QOSMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RSVPParametersOptionMap_qosMode,
	e_ASNH245RSVPParametersOptionMap_tokenRate,
	e_ASNH245RSVPParametersOptionMap_bucketSize,
	e_ASNH245RSVPParametersOptionMap_peakRate,
	e_ASNH245RSVPParametersOptionMap_minPoliced,
	e_ASNH245RSVPParametersOptionMap_maxPktSize

} ASNH245RSVPParametersOptionMap;


#define e_ASNH245RSVPParametersOptionMapSize 6
#define e_ASNH245RSVPParametersOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245QOSMode m_qosMode;
	AsnInteger m_tokenRate;
	AsnInteger m_bucketSize;
	AsnInteger m_peakRate;
	AsnInteger m_minPoliced;
	AsnInteger m_maxPktSize;
	/*...,*/
} ASNH245RSVPParameters;
HS_RESULT new_ASNH245RSVPParameters( void *pObject );
HS_RESULT delete_ASNH245RSVPParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RSVPParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RSVPParameters_IncludeOptionField( void *pObject, ASNH245RSVPParametersOptionMap pOptionMap );
BOOL	  ASNH245RSVPParameters_IsIncludeOptionField( void *pObject, ASNH245RSVPParametersOptionMap pOptionMap );
HS_RESULT ASNH245RSVPParameters_MakeMold( void *pObject );
HS_RESULT ASNH245RSVPParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RSVPParameters_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245ATMParametersOptionMapSize 0
#define e_ASNH245ATMParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_maxNTUSize;
	AsnBoolean m_atmUBR;
	AsnBoolean m_atmrtVBR;
	AsnBoolean m_atmnrtVBR;
	AsnBoolean m_atmABR;
	AsnBoolean m_atmCBR;
	/*...,*/
} ASNH245ATMParameters;
HS_RESULT new_ASNH245ATMParameters( void *pObject );
HS_RESULT delete_ASNH245ATMParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ATMParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ATMParameters_MakeMold( void *pObject );
HS_RESULT ASNH245ATMParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ATMParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245QOSCapabilityOptionMap_nonStandardData,
	e_ASNH245QOSCapabilityOptionMap_rsvpParameters,
	e_ASNH245QOSCapabilityOptionMap_atmParameters

} ASNH245QOSCapabilityOptionMap;


#define e_ASNH245QOSCapabilityOptionMapSize 3
#define e_ASNH245QOSCapabilityOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245NonStandardParameter m_nonStandardData;
	ASNH245RSVPParameters m_rsvpParameters;
	ASNH245ATMParameters m_atmParameters;
	/*...,*/
} ASNH245QOSCapability;
HS_RESULT new_ASNH245QOSCapability( void *pObject );
HS_RESULT delete_ASNH245QOSCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245QOSCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245QOSCapability_IncludeOptionField( void *pObject, ASNH245QOSCapabilityOptionMap pOptionMap );
BOOL	  ASNH245QOSCapability_IsIncludeOptionField( void *pObject, ASNH245QOSCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245QOSCapability_MakeMold( void *pObject );
HS_RESULT ASNH245QOSCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245QOSCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MediaTransportType_atm_AAL5_compressedOptionMapSize 0
#define e_ASNH245MediaTransportType_atm_AAL5_compressedOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_variable_delta;
	/*...,*/
} ASNH245MediaTransportType_atm_AAL5_compressed;
HS_RESULT new_ASNH245MediaTransportType_atm_AAL5_compressed( void *pObject );
HS_RESULT delete_ASNH245MediaTransportType_atm_AAL5_compressed( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MediaTransportType_atm_AAL5_compressed_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MediaTransportType_atm_AAL5_compressed_MakeMold( void *pObject );
HS_RESULT ASNH245MediaTransportType_atm_AAL5_compressed_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MediaTransportType_atm_AAL5_compressed_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MediaTransportTypeChoice_ip_UDP,
	e_ASNH245MediaTransportTypeChoice_ip_TCP,
	e_ASNH245MediaTransportTypeChoice_atm_AAL5_UNIDIR,
	e_ASNH245MediaTransportTypeChoice_atm_AAL5_BIDIR
,
	e_ASNH245MediaTransportTypeChoice_atm_AAL5_compressed
} ASNH245MediaTransportTypeChoice;


#define e_ASNH245MediaTransportTypeChoiceSize		4
#define e_ASNH245MediaTransportTypeChoiceSizeExt	5
typedef struct
{
	ASNH245MediaTransportTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MediaTransportType;
HS_RESULT new_ASNH245MediaTransportType( void *pObject );
HS_RESULT delete_ASNH245MediaTransportType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MediaTransportType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MediaTransportType_SetChoice( void *pObject, ASNH245MediaTransportTypeChoice pChoice );
HS_RESULT ASNH245MediaTransportType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MediaTransportType_MakeMold( void *pObject );
HS_RESULT ASNH245MediaTransportType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MediaTransportType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MediaChannelCapabilityOptionMap_mediaTransport

} ASNH245MediaChannelCapabilityOptionMap;


#define e_ASNH245MediaChannelCapabilityOptionMapSize 1
#define e_ASNH245MediaChannelCapabilityOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245MediaTransportType m_mediaTransport;
	/*...,*/
} ASNH245MediaChannelCapability;
HS_RESULT new_ASNH245MediaChannelCapability( void *pObject );
HS_RESULT delete_ASNH245MediaChannelCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MediaChannelCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MediaChannelCapability_IncludeOptionField( void *pObject, ASNH245MediaChannelCapabilityOptionMap pOptionMap );
BOOL	  ASNH245MediaChannelCapability_IsIncludeOptionField( void *pObject, ASNH245MediaChannelCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245MediaChannelCapability_MakeMold( void *pObject );
HS_RESULT ASNH245MediaChannelCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MediaChannelCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245TransportCapabilityOptionMap_nonStandard,
	e_ASNH245TransportCapabilityOptionMap_qOSCapabilities,
	e_ASNH245TransportCapabilityOptionMap_mediaChannelCapabilities

} ASNH245TransportCapabilityOptionMap;


#define e_ASNH245TransportCapabilityOptionMapSize 3
#define e_ASNH245TransportCapabilityOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245NonStandardParameter m_nonStandard;
	AsnSequenceOf m_qOSCapabilities;
	AsnSequenceOf m_mediaChannelCapabilities;
	/*...,*/
} ASNH245TransportCapability;
HS_RESULT new_ASNH245TransportCapability( void *pObject );
HS_RESULT delete_ASNH245TransportCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TransportCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TransportCapability_IncludeOptionField( void *pObject, ASNH245TransportCapabilityOptionMap pOptionMap );
BOOL	  ASNH245TransportCapability_IsIncludeOptionField( void *pObject, ASNH245TransportCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245TransportCapability_MakeMold( void *pObject );
HS_RESULT ASNH245TransportCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TransportCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RTPH263VideoRedundancyFrameMappingOptionMapSize 0
#define e_ASNH245RTPH263VideoRedundancyFrameMappingOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_threadNumber;
	AsnSequenceOf m_frameSequence;
	/*...,*/
} ASNH245RTPH263VideoRedundancyFrameMapping;
HS_RESULT new_ASNH245RTPH263VideoRedundancyFrameMapping( void *pObject );
HS_RESULT delete_ASNH245RTPH263VideoRedundancyFrameMapping( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RTPH263VideoRedundancyFrameMapping_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RTPH263VideoRedundancyFrameMapping_MakeMold( void *pObject );
HS_RESULT ASNH245RTPH263VideoRedundancyFrameMapping_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RTPH263VideoRedundancyFrameMapping_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_roundrobin,
	e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_custom

} ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice;


#define e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSize		2
#define e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSizeExt	2
typedef struct
{
	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping;
HS_RESULT new_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping( void *pObject );
HS_RESULT delete_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_SetChoice( void *pObject, ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice pChoice );
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_MakeMold( void *pObject );
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RTPH263VideoRedundancyEncodingOptionMap_containedThreads

} ASNH245RTPH263VideoRedundancyEncodingOptionMap;


#define e_ASNH245RTPH263VideoRedundancyEncodingOptionMapSize 1
#define e_ASNH245RTPH263VideoRedundancyEncodingOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_numberOfThreads;
	AsnInteger m_framesBetweenSyncPoints;
	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping m_frameToThreadMapping;
	AsnSequenceOf m_containedThreads;
	/*...,*/
} ASNH245RTPH263VideoRedundancyEncoding;
HS_RESULT new_ASNH245RTPH263VideoRedundancyEncoding( void *pObject );
HS_RESULT delete_ASNH245RTPH263VideoRedundancyEncoding( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_IncludeOptionField( void *pObject, ASNH245RTPH263VideoRedundancyEncodingOptionMap pOptionMap );
BOOL	  ASNH245RTPH263VideoRedundancyEncoding_IsIncludeOptionField( void *pObject, ASNH245RTPH263VideoRedundancyEncodingOptionMap pOptionMap );
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_MakeMold( void *pObject );
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RedundancyEncodingMethodChoice_nonStandard,
	e_ASNH245RedundancyEncodingMethodChoice_rtpAudioRedundancyEncoding
,
	e_ASNH245RedundancyEncodingMethodChoice_rtpH263VideoRedundancyEncoding
} ASNH245RedundancyEncodingMethodChoice;


#define e_ASNH245RedundancyEncodingMethodChoiceSize		2
#define e_ASNH245RedundancyEncodingMethodChoiceSizeExt	3
typedef struct
{
	ASNH245RedundancyEncodingMethodChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RedundancyEncodingMethod;
HS_RESULT new_ASNH245RedundancyEncodingMethod( void *pObject );
HS_RESULT delete_ASNH245RedundancyEncodingMethod( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RedundancyEncodingMethod_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RedundancyEncodingMethod_SetChoice( void *pObject, ASNH245RedundancyEncodingMethodChoice pChoice );
HS_RESULT ASNH245RedundancyEncodingMethod_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RedundancyEncodingMethod_MakeMold( void *pObject );
HS_RESULT ASNH245RedundancyEncodingMethod_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RedundancyEncodingMethod_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RedundancyEncodingCapabilityOptionMap_secondaryEncoding

} ASNH245RedundancyEncodingCapabilityOptionMap;


#define e_ASNH245RedundancyEncodingCapabilityOptionMapSize 1
#define e_ASNH245RedundancyEncodingCapabilityOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245RedundancyEncodingMethod m_redundancyEncodingMethod;
	ASNH245CapabilityTableEntryNumber m_primaryEncoding;
	AsnSequenceOf m_secondaryEncoding;
	/*...,*/
} ASNH245RedundancyEncodingCapability;
HS_RESULT new_ASNH245RedundancyEncodingCapability( void *pObject );
HS_RESULT delete_ASNH245RedundancyEncodingCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RedundancyEncodingCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RedundancyEncodingCapability_IncludeOptionField( void *pObject, ASNH245RedundancyEncodingCapabilityOptionMap pOptionMap );
BOOL	  ASNH245RedundancyEncodingCapability_IsIncludeOptionField( void *pObject, ASNH245RedundancyEncodingCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245RedundancyEncodingCapability_MakeMold( void *pObject );
HS_RESULT ASNH245RedundancyEncodingCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RedundancyEncodingCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245H2250CapabilityOptionMap_transportCapability,
	e_ASNH245H2250CapabilityOptionMap_redundancyEncodingCapability,
	e_ASNH245H2250CapabilityOptionMap_logicalChannelSwitchingCapability,
	e_ASNH245H2250CapabilityOptionMap_t120DynamicPortCapability
} ASNH245H2250CapabilityOptionMap;


#define e_ASNH245H2250CapabilityOptionMapSize 0
#define e_ASNH245H2250CapabilityOptionMapSizeExt 4
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_maximumAudioDelayJitter;
	ASNH245MultipointCapability m_receiveMultipointCapability;
	ASNH245MultipointCapability m_transmitMultipointCapability;
	ASNH245MultipointCapability m_receiveAndTransmitMultipointCapability;
	ASNH245H2250Capability_mcCapability m_mcCapability;
	AsnBoolean m_rtcpVideoControlCapability;
	ASNH245MediaPacketizationCapability m_mediaPacketizationCapability;
	/*...,*/
	ASNH245TransportCapability m_transportCapability;
	AsnSequenceOf m_redundancyEncodingCapability;
	AsnBoolean m_logicalChannelSwitchingCapability;
	AsnBoolean m_t120DynamicPortCapability;
} ASNH245H2250Capability;
HS_RESULT new_ASNH245H2250Capability( void *pObject );
HS_RESULT delete_ASNH245H2250Capability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H2250Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H2250Capability_IncludeOptionField( void *pObject, ASNH245H2250CapabilityOptionMap pOptionMap );
BOOL	  ASNH245H2250Capability_IsIncludeOptionField( void *pObject, ASNH245H2250CapabilityOptionMap pOptionMap );
HS_RESULT ASNH245H2250Capability_MakeMold( void *pObject );
HS_RESULT ASNH245H2250Capability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H2250Capability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultiplexCapabilityChoice_nonStandard,
	e_ASNH245MultiplexCapabilityChoice_h222Capability,
	e_ASNH245MultiplexCapabilityChoice_h223Capability,
	e_ASNH245MultiplexCapabilityChoice_v76Capability
,
	e_ASNH245MultiplexCapabilityChoice_h2250Capability,
	e_ASNH245MultiplexCapabilityChoice_genericMultiplexCapability
} ASNH245MultiplexCapabilityChoice;


#define e_ASNH245MultiplexCapabilityChoiceSize		4
#define e_ASNH245MultiplexCapabilityChoiceSizeExt	6
typedef struct
{
	ASNH245MultiplexCapabilityChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultiplexCapability;
HS_RESULT new_ASNH245MultiplexCapability( void *pObject );
HS_RESULT delete_ASNH245MultiplexCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultiplexCapability_SetChoice( void *pObject, ASNH245MultiplexCapabilityChoice pChoice );
HS_RESULT ASNH245MultiplexCapability_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultiplexCapability_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H261VideoCapabilityOptionMap_qcifMPI,
	e_ASNH245H261VideoCapabilityOptionMap_cifMPI
,
	e_ASNH245H261VideoCapabilityOptionMap_videoBadMBsCap
} ASNH245H261VideoCapabilityOptionMap;


#define e_ASNH245H261VideoCapabilityOptionMapSize 2
#define e_ASNH245H261VideoCapabilityOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_qcifMPI;
	AsnInteger m_cifMPI;
	AsnBoolean m_temporalSpatialTradeOffCapability;
	AsnInteger m_maxBitRate;
	AsnBoolean m_stillImageTransmission;
	/*...,*/
	AsnBoolean m_videoBadMBsCap;
} ASNH245H261VideoCapability;
HS_RESULT new_ASNH245H261VideoCapability( void *pObject );
HS_RESULT delete_ASNH245H261VideoCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H261VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H261VideoCapability_IncludeOptionField( void *pObject, ASNH245H261VideoCapabilityOptionMap pOptionMap );
BOOL	  ASNH245H261VideoCapability_IsIncludeOptionField( void *pObject, ASNH245H261VideoCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245H261VideoCapability_MakeMold( void *pObject );
HS_RESULT ASNH245H261VideoCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H261VideoCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H262VideoCapabilityOptionMap_videoBitRate,
	e_ASNH245H262VideoCapabilityOptionMap_vbvBufferSize,
	e_ASNH245H262VideoCapabilityOptionMap_samplesPerLine,
	e_ASNH245H262VideoCapabilityOptionMap_linesPerFrame,
	e_ASNH245H262VideoCapabilityOptionMap_framesPerSecond,
	e_ASNH245H262VideoCapabilityOptionMap_luminanceSampleRate
,
	e_ASNH245H262VideoCapabilityOptionMap_videoBadMBsCap
} ASNH245H262VideoCapabilityOptionMap;


#define e_ASNH245H262VideoCapabilityOptionMapSize 6
#define e_ASNH245H262VideoCapabilityOptionMapSizeExt 7
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_profileAndLevel_SPatML;
	AsnBoolean m_profileAndLevel_MPatLL;
	AsnBoolean m_profileAndLevel_MPatML;
	AsnBoolean m_profileAndLevel_MPatH_14;
	AsnBoolean m_profileAndLevel_MPatHL;
	AsnBoolean m_profileAndLevel_SNRatLL;
	AsnBoolean m_profileAndLevel_SNRatML;
	AsnBoolean m_profileAndLevel_SpatialatH_14;
	AsnBoolean m_profileAndLevel_HPatML;
	AsnBoolean m_profileAndLevel_HPatH_14;
	AsnBoolean m_profileAndLevel_HPatHL;
	AsnInteger m_videoBitRate;
	AsnInteger m_vbvBufferSize;
	AsnInteger m_samplesPerLine;
	AsnInteger m_linesPerFrame;
	AsnInteger m_framesPerSecond;
	AsnInteger m_luminanceSampleRate;
	/*...,*/
	AsnBoolean m_videoBadMBsCap;
} ASNH245H262VideoCapability;
HS_RESULT new_ASNH245H262VideoCapability( void *pObject );
HS_RESULT delete_ASNH245H262VideoCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H262VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H262VideoCapability_IncludeOptionField( void *pObject, ASNH245H262VideoCapabilityOptionMap pOptionMap );
BOOL	  ASNH245H262VideoCapability_IsIncludeOptionField( void *pObject, ASNH245H262VideoCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245H262VideoCapability_MakeMold( void *pObject );
HS_RESULT ASNH245H262VideoCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H262VideoCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245TransparencyParametersOptionMapSize 0
#define e_ASNH245TransparencyParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_presentationOrder;
	AsnInteger m_offset_x;
	AsnInteger m_offset_y;
	AsnInteger m_scale_x;
	AsnInteger m_scale_y;
	/*...,*/
} ASNH245TransparencyParameters;
HS_RESULT new_ASNH245TransparencyParameters( void *pObject );
HS_RESULT delete_ASNH245TransparencyParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TransparencyParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TransparencyParameters_MakeMold( void *pObject );
HS_RESULT ASNH245TransparencyParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TransparencyParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_sqcifAdditionalPictureMemory,
	e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_qcifAdditionalPictureMemory,
	e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cifAdditionalPictureMemory,
	e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cif4AdditionalPictureMemory,
	e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cif16AdditionalPictureMemory,
	e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_bigCpfAdditionalPictureMemory

} ASNH245RefPictureSelection_additionalPictureMemoryOptionMap;


#define e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMapSize 6
#define e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_sqcifAdditionalPictureMemory;
	AsnInteger m_qcifAdditionalPictureMemory;
	AsnInteger m_cifAdditionalPictureMemory;
	AsnInteger m_cif4AdditionalPictureMemory;
	AsnInteger m_cif16AdditionalPictureMemory;
	AsnInteger m_bigCpfAdditionalPictureMemory;
	/*...,*/
} ASNH245RefPictureSelection_additionalPictureMemory;
HS_RESULT new_ASNH245RefPictureSelection_additionalPictureMemory( void *pObject );
HS_RESULT delete_ASNH245RefPictureSelection_additionalPictureMemory( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_IncludeOptionField( void *pObject, ASNH245RefPictureSelection_additionalPictureMemoryOptionMap pOptionMap );
BOOL	  ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( void *pObject, ASNH245RefPictureSelection_additionalPictureMemoryOptionMap pOptionMap );
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_MakeMold( void *pObject );
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RefPictureSelection_videoBackChannelSendChoice_none,
	e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackMessageOnly,
	e_ASNH245RefPictureSelection_videoBackChannelSendChoice_nackMessageOnly,
	e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackOrNackMessageOnly,
	e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackAndNackMessage

} ASNH245RefPictureSelection_videoBackChannelSendChoice;


#define e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSize		5
#define e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSizeExt	5
typedef struct
{
	ASNH245RefPictureSelection_videoBackChannelSendChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RefPictureSelection_videoBackChannelSend;
HS_RESULT new_ASNH245RefPictureSelection_videoBackChannelSend( void *pObject );
HS_RESULT delete_ASNH245RefPictureSelection_videoBackChannelSend( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RefPictureSelection_videoBackChannelSend_SetChoice( void *pObject, ASNH245RefPictureSelection_videoBackChannelSendChoice pChoice );
HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_MakeMold( void *pObject );
HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParametersOptionMapSize 0
#define e_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_mpuHorizMBs;
	AsnInteger m_mpuVertMBs;
	AsnInteger m_mpuTotalNumber;
	/*...,*/
} ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters;
HS_RESULT new_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters( void *pObject );
HS_RESULT delete_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_MakeMold( void *pObject );
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMap_subPictureRemovalParameters

} ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMap;


#define e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMapSize 1
#define e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters m_subPictureRemovalParameters;
	/*...,*/
} ASNH245RefPictureSelection_enhancedReferencePicSelect;
HS_RESULT new_ASNH245RefPictureSelection_enhancedReferencePicSelect( void *pObject );
HS_RESULT delete_ASNH245RefPictureSelection_enhancedReferencePicSelect( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_IncludeOptionField( void *pObject, ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMap pOptionMap );
BOOL	  ASNH245RefPictureSelection_enhancedReferencePicSelect_IsIncludeOptionField( void *pObject, ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMap pOptionMap );
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_MakeMold( void *pObject );
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RefPictureSelectionOptionMap_additionalPictureMemory
,
	e_ASNH245RefPictureSelectionOptionMap_enhancedReferencePicSelect
} ASNH245RefPictureSelectionOptionMap;


#define e_ASNH245RefPictureSelectionOptionMapSize 1
#define e_ASNH245RefPictureSelectionOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245RefPictureSelection_additionalPictureMemory m_additionalPictureMemory;
	AsnBoolean m_videoMux;
	ASNH245RefPictureSelection_videoBackChannelSend m_videoBackChannelSend;
	/*...,*/
	ASNH245RefPictureSelection_enhancedReferencePicSelect m_enhancedReferencePicSelect;
} ASNH245RefPictureSelection;
HS_RESULT new_ASNH245RefPictureSelection( void *pObject );
HS_RESULT delete_ASNH245RefPictureSelection( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RefPictureSelection_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RefPictureSelection_IncludeOptionField( void *pObject, ASNH245RefPictureSelectionOptionMap pOptionMap );
BOOL	  ASNH245RefPictureSelection_IsIncludeOptionField( void *pObject, ASNH245RefPictureSelectionOptionMap pOptionMap );
HS_RESULT ASNH245RefPictureSelection_MakeMold( void *pObject );
HS_RESULT ASNH245RefPictureSelection_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RefPictureSelection_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CustomPictureClockFrequencyOptionMap_sqcifMPI,
	e_ASNH245CustomPictureClockFrequencyOptionMap_qcifMPI,
	e_ASNH245CustomPictureClockFrequencyOptionMap_cifMPI,
	e_ASNH245CustomPictureClockFrequencyOptionMap_cif4MPI,
	e_ASNH245CustomPictureClockFrequencyOptionMap_cif16MPI

} ASNH245CustomPictureClockFrequencyOptionMap;


#define e_ASNH245CustomPictureClockFrequencyOptionMapSize 5
#define e_ASNH245CustomPictureClockFrequencyOptionMapSizeExt 5
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_clockConversionCode;
	AsnInteger m_clockDivisor;
	AsnInteger m_sqcifMPI;
	AsnInteger m_qcifMPI;
	AsnInteger m_cifMPI;
	AsnInteger m_cif4MPI;
	AsnInteger m_cif16MPI;
	/*...,*/
} ASNH245CustomPictureClockFrequency;
HS_RESULT new_ASNH245CustomPictureClockFrequency( void *pObject );
HS_RESULT delete_ASNH245CustomPictureClockFrequency( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CustomPictureClockFrequency_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CustomPictureClockFrequency_IncludeOptionField( void *pObject, ASNH245CustomPictureClockFrequencyOptionMap pOptionMap );
BOOL	  ASNH245CustomPictureClockFrequency_IsIncludeOptionField( void *pObject, ASNH245CustomPictureClockFrequencyOptionMap pOptionMap );
HS_RESULT ASNH245CustomPictureClockFrequency_MakeMold( void *pObject );
HS_RESULT ASNH245CustomPictureClockFrequency_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CustomPictureClockFrequency_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245CustomPictureFormat_mPI_customPCFOptionMapSize 0
#define e_ASNH245CustomPictureFormat_mPI_customPCFOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_clockConversionCode;
	AsnInteger m_clockDivisor;
	AsnInteger m_customMPI;
	/*...,*/
} ASNH245CustomPictureFormat_mPI_customPCF;
HS_RESULT new_ASNH245CustomPictureFormat_mPI_customPCF( void *pObject );
HS_RESULT delete_ASNH245CustomPictureFormat_mPI_customPCF( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CustomPictureFormat_mPI_customPCF_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CustomPictureFormat_mPI_customPCF_MakeMold( void *pObject );
HS_RESULT ASNH245CustomPictureFormat_mPI_customPCF_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CustomPictureFormat_mPI_customPCF_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CustomPictureFormat_mPIOptionMap_standardMPI,
	e_ASNH245CustomPictureFormat_mPIOptionMap_customPCF

} ASNH245CustomPictureFormat_mPIOptionMap;


#define e_ASNH245CustomPictureFormat_mPIOptionMapSize 2
#define e_ASNH245CustomPictureFormat_mPIOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_standardMPI;
	AsnSequenceOf m_customPCF;
	/*...,*/
} ASNH245CustomPictureFormat_mPI;
HS_RESULT new_ASNH245CustomPictureFormat_mPI( void *pObject );
HS_RESULT delete_ASNH245CustomPictureFormat_mPI( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CustomPictureFormat_mPI_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CustomPictureFormat_mPI_IncludeOptionField( void *pObject, ASNH245CustomPictureFormat_mPIOptionMap pOptionMap );
BOOL	  ASNH245CustomPictureFormat_mPI_IsIncludeOptionField( void *pObject, ASNH245CustomPictureFormat_mPIOptionMap pOptionMap );
HS_RESULT ASNH245CustomPictureFormat_mPI_MakeMold( void *pObject );
HS_RESULT ASNH245CustomPictureFormat_mPI_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CustomPictureFormat_mPI_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAROptionMapSize 0
#define e_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAROptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_width;
	AsnInteger m_height;
	/*...,*/
} ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR;
HS_RESULT new_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR( void *pObject );
HS_RESULT delete_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_MakeMold( void *pObject );
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_anyPixelAspectRatio,
	e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_pixelAspectCode,
	e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_extendedPAR

} ASNH245CustomPictureFormat_pixelAspectInformationChoice;


#define e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSize		3
#define e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSizeExt	3
typedef struct
{
	ASNH245CustomPictureFormat_pixelAspectInformationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245CustomPictureFormat_pixelAspectInformation;
HS_RESULT new_ASNH245CustomPictureFormat_pixelAspectInformation( void *pObject );
HS_RESULT delete_ASNH245CustomPictureFormat_pixelAspectInformation( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245CustomPictureFormat_pixelAspectInformation_SetChoice( void *pObject, ASNH245CustomPictureFormat_pixelAspectInformationChoice pChoice );
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_DeleteAlternation( void *pObject );
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_MakeMold( void *pObject );
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245CustomPictureFormatOptionMapSize 0
#define e_ASNH245CustomPictureFormatOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_maxCustomPictureWidth;
	AsnInteger m_maxCustomPictureHeight;
	AsnInteger m_minCustomPictureWidth;
	AsnInteger m_minCustomPictureHeight;
	ASNH245CustomPictureFormat_mPI m_mPI;
	ASNH245CustomPictureFormat_pixelAspectInformation m_pixelAspectInformation;
	/*...,*/
} ASNH245CustomPictureFormat;
HS_RESULT new_ASNH245CustomPictureFormat( void *pObject );
HS_RESULT delete_ASNH245CustomPictureFormat( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CustomPictureFormat_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CustomPictureFormat_MakeMold( void *pObject );
HS_RESULT ASNH245CustomPictureFormat_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CustomPictureFormat_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H263Version3OptionsOptionMapSize 0
#define e_ASNH245H263Version3OptionsOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_dataPartitionedSlices;
	AsnBoolean m_fixedPointIDCT0;
	AsnBoolean m_interlacedFields;
	AsnBoolean m_currentPictureHeaderRepetition;
	AsnBoolean m_previousPictureHeaderRepetition;
	AsnBoolean m_nextPictureHeaderRepetition;
	AsnBoolean m_pictureNumber;
	AsnBoolean m_spareReferencePictures;
	/*...,*/
} ASNH245H263Version3Options;
HS_RESULT new_ASNH245H263Version3Options( void *pObject );
HS_RESULT delete_ASNH245H263Version3Options( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H263Version3Options_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H263Version3Options_MakeMold( void *pObject );
HS_RESULT ASNH245H263Version3Options_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H263Version3Options_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245H263ModeComboFlagsOptionMap_enhancedReferencePicSelect,
	e_ASNH245H263ModeComboFlagsOptionMap_h263Version3Options
} ASNH245H263ModeComboFlagsOptionMap;


#define e_ASNH245H263ModeComboFlagsOptionMapSize 0
#define e_ASNH245H263ModeComboFlagsOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_unrestrictedVector;
	AsnBoolean m_arithmeticCoding;
	AsnBoolean m_advancedPrediction;
	AsnBoolean m_pbFrames;
	AsnBoolean m_advancedIntraCodingMode;
	AsnBoolean m_deblockingFilterMode;
	AsnBoolean m_unlimitedMotionVectors;
	AsnBoolean m_slicesInOrder_NonRect;
	AsnBoolean m_slicesInOrder_Rect;
	AsnBoolean m_slicesNoOrder_NonRect;
	AsnBoolean m_slicesNoOrder_Rect;
	AsnBoolean m_improvedPBFramesMode;
	AsnBoolean m_referencePicSelect;
	AsnBoolean m_dynamicPictureResizingByFour;
	AsnBoolean m_dynamicPictureResizingSixteenthPel;
	AsnBoolean m_dynamicWarpingHalfPel;
	AsnBoolean m_dynamicWarpingSixteenthPel;
	AsnBoolean m_reducedResolutionUpdate;
	AsnBoolean m_independentSegmentDecoding;
	AsnBoolean m_alternateInterVLCMode;
	AsnBoolean m_modifiedQuantizationMode;
	/*...,*/
	AsnBoolean m_enhancedReferencePicSelect;
	ASNH245H263Version3Options m_h263Version3Options;
} ASNH245H263ModeComboFlags;
HS_RESULT new_ASNH245H263ModeComboFlags( void *pObject );
HS_RESULT delete_ASNH245H263ModeComboFlags( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H263ModeComboFlags_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H263ModeComboFlags_IncludeOptionField( void *pObject, ASNH245H263ModeComboFlagsOptionMap pOptionMap );
BOOL	  ASNH245H263ModeComboFlags_IsIncludeOptionField( void *pObject, ASNH245H263ModeComboFlagsOptionMap pOptionMap );
HS_RESULT ASNH245H263ModeComboFlags_MakeMold( void *pObject );
HS_RESULT ASNH245H263ModeComboFlags_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H263ModeComboFlags_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H263VideoModeCombosOptionMapSize 0
#define e_ASNH245H263VideoModeCombosOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245H263ModeComboFlags m_h263VideoUncoupledModes;
	AsnSequenceOf m_h263VideoCoupledModes;
	/*...,*/
} ASNH245H263VideoModeCombos;
HS_RESULT new_ASNH245H263VideoModeCombos( void *pObject );
HS_RESULT delete_ASNH245H263VideoModeCombos( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H263VideoModeCombos_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H263VideoModeCombos_MakeMold( void *pObject );
HS_RESULT ASNH245H263VideoModeCombos_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H263VideoModeCombos_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H263OptionsOptionMap_transparencyParameters,
	e_ASNH245H263OptionsOptionMap_refPictureSelection,
	e_ASNH245H263OptionsOptionMap_customPictureClockFrequency,
	e_ASNH245H263OptionsOptionMap_customPictureFormat,
	e_ASNH245H263OptionsOptionMap_modeCombos
,
	e_ASNH245H263OptionsOptionMap_videoBadMBsCap,
	e_ASNH245H263OptionsOptionMap_h263Version3Options
} ASNH245H263OptionsOptionMap;


#define e_ASNH245H263OptionsOptionMapSize 5
#define e_ASNH245H263OptionsOptionMapSizeExt 7
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_advancedIntraCodingMode;
	AsnBoolean m_deblockingFilterMode;
	AsnBoolean m_improvedPBFramesMode;
	AsnBoolean m_unlimitedMotionVectors;
	AsnBoolean m_fullPictureFreeze;
	AsnBoolean m_partialPictureFreezeAndRelease;
	AsnBoolean m_resizingPartPicFreezeAndRelease;
	AsnBoolean m_fullPictureSnapshot;
	AsnBoolean m_partialPictureSnapshot;
	AsnBoolean m_videoSegmentTagging;
	AsnBoolean m_progressiveRefinement;
	AsnBoolean m_dynamicPictureResizingByFour;
	AsnBoolean m_dynamicPictureResizingSixteenthPel;
	AsnBoolean m_dynamicWarpingHalfPel;
	AsnBoolean m_dynamicWarpingSixteenthPel;
	AsnBoolean m_independentSegmentDecoding;
	AsnBoolean m_slicesInOrder_NonRect;
	AsnBoolean m_slicesInOrder_Rect;
	AsnBoolean m_slicesNoOrder_NonRect;
	AsnBoolean m_slicesNoOrder_Rect;
	AsnBoolean m_alternateInterVLCMode;
	AsnBoolean m_modifiedQuantizationMode;
	AsnBoolean m_reducedResolutionUpdate;
	ASNH245TransparencyParameters m_transparencyParameters;
	AsnBoolean m_separateVideoBackChannel;
	ASNH245RefPictureSelection m_refPictureSelection;
	AsnSequenceOf m_customPictureClockFrequency;
	AsnSequenceOf m_customPictureFormat;
	AsnSequenceOf m_modeCombos;
	/*...,*/
	AsnBoolean m_videoBadMBsCap;
	ASNH245H263Version3Options m_h263Version3Options;
} ASNH245H263Options;
HS_RESULT new_ASNH245H263Options( void *pObject );
HS_RESULT delete_ASNH245H263Options( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H263Options_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H263Options_IncludeOptionField( void *pObject, ASNH245H263OptionsOptionMap pOptionMap );
BOOL	  ASNH245H263Options_IsIncludeOptionField( void *pObject, ASNH245H263OptionsOptionMap pOptionMap );
HS_RESULT ASNH245H263Options_MakeMold( void *pObject );
HS_RESULT ASNH245H263Options_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H263Options_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EnhancementOptionsOptionMap_sqcifMPI,
	e_ASNH245EnhancementOptionsOptionMap_qcifMPI,
	e_ASNH245EnhancementOptionsOptionMap_cifMPI,
	e_ASNH245EnhancementOptionsOptionMap_cif4MPI,
	e_ASNH245EnhancementOptionsOptionMap_cif16MPI,
	e_ASNH245EnhancementOptionsOptionMap_slowSqcifMPI,
	e_ASNH245EnhancementOptionsOptionMap_slowQcifMPI,
	e_ASNH245EnhancementOptionsOptionMap_slowCifMPI,
	e_ASNH245EnhancementOptionsOptionMap_slowCif4MPI,
	e_ASNH245EnhancementOptionsOptionMap_slowCif16MPI,
	e_ASNH245EnhancementOptionsOptionMap_h263Options

} ASNH245EnhancementOptionsOptionMap;


#define e_ASNH245EnhancementOptionsOptionMapSize 11
#define e_ASNH245EnhancementOptionsOptionMapSizeExt 11
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_sqcifMPI;
	AsnInteger m_qcifMPI;
	AsnInteger m_cifMPI;
	AsnInteger m_cif4MPI;
	AsnInteger m_cif16MPI;
	AsnInteger m_maxBitRate;
	AsnBoolean m_unrestrictedVector;
	AsnBoolean m_arithmeticCoding;
	AsnBoolean m_temporalSpatialTradeOffCapability;
	AsnInteger m_slowSqcifMPI;
	AsnInteger m_slowQcifMPI;
	AsnInteger m_slowCifMPI;
	AsnInteger m_slowCif4MPI;
	AsnInteger m_slowCif16MPI;
	AsnBoolean m_errorCompensation;
	ASNH245H263Options m_h263Options;
	/*...,*/
} ASNH245EnhancementOptions;
HS_RESULT new_ASNH245EnhancementOptions( void *pObject );
HS_RESULT delete_ASNH245EnhancementOptions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EnhancementOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245EnhancementOptions_IncludeOptionField( void *pObject, ASNH245EnhancementOptionsOptionMap pOptionMap );
BOOL	  ASNH245EnhancementOptions_IsIncludeOptionField( void *pObject, ASNH245EnhancementOptionsOptionMap pOptionMap );
HS_RESULT ASNH245EnhancementOptions_MakeMold( void *pObject );
HS_RESULT ASNH245EnhancementOptions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EnhancementOptions_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245BEnhancementParametersOptionMapSize 0
#define e_ASNH245BEnhancementParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245EnhancementOptions m_enhancementOptions;
	AsnInteger m_numberOfBPictures;
	/*...,*/
} ASNH245BEnhancementParameters;
HS_RESULT new_ASNH245BEnhancementParameters( void *pObject );
HS_RESULT delete_ASNH245BEnhancementParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245BEnhancementParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245BEnhancementParameters_MakeMold( void *pObject );
HS_RESULT ASNH245BEnhancementParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245BEnhancementParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EnhancementLayerInfoOptionMap_snrEnhancement,
	e_ASNH245EnhancementLayerInfoOptionMap_spatialEnhancement,
	e_ASNH245EnhancementLayerInfoOptionMap_bPictureEnhancement

} ASNH245EnhancementLayerInfoOptionMap;


#define e_ASNH245EnhancementLayerInfoOptionMapSize 3
#define e_ASNH245EnhancementLayerInfoOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_baseBitRateConstrained;
	AsnSequenceOf m_snrEnhancement;
	AsnSequenceOf m_spatialEnhancement;
	AsnSequenceOf m_bPictureEnhancement;
	/*...,*/
} ASNH245EnhancementLayerInfo;
HS_RESULT new_ASNH245EnhancementLayerInfo( void *pObject );
HS_RESULT delete_ASNH245EnhancementLayerInfo( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EnhancementLayerInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245EnhancementLayerInfo_IncludeOptionField( void *pObject, ASNH245EnhancementLayerInfoOptionMap pOptionMap );
BOOL	  ASNH245EnhancementLayerInfo_IsIncludeOptionField( void *pObject, ASNH245EnhancementLayerInfoOptionMap pOptionMap );
HS_RESULT ASNH245EnhancementLayerInfo_MakeMold( void *pObject );
HS_RESULT ASNH245EnhancementLayerInfo_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EnhancementLayerInfo_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H263VideoCapabilityOptionMap_sqcifMPI,
	e_ASNH245H263VideoCapabilityOptionMap_qcifMPI,
	e_ASNH245H263VideoCapabilityOptionMap_cifMPI,
	e_ASNH245H263VideoCapabilityOptionMap_cif4MPI,
	e_ASNH245H263VideoCapabilityOptionMap_cif16MPI,
	e_ASNH245H263VideoCapabilityOptionMap_hrd_B,
	e_ASNH245H263VideoCapabilityOptionMap_bppMaxKb
,
	e_ASNH245H263VideoCapabilityOptionMap_slowSqcifMPI,
	e_ASNH245H263VideoCapabilityOptionMap_slowQcifMPI,
	e_ASNH245H263VideoCapabilityOptionMap_slowCifMPI,
	e_ASNH245H263VideoCapabilityOptionMap_slowCif4MPI,
	e_ASNH245H263VideoCapabilityOptionMap_slowCif16MPI,
	e_ASNH245H263VideoCapabilityOptionMap_errorCompensation,
	e_ASNH245H263VideoCapabilityOptionMap_enhancementLayerInfo,
	e_ASNH245H263VideoCapabilityOptionMap_h263Options
} ASNH245H263VideoCapabilityOptionMap;


#define e_ASNH245H263VideoCapabilityOptionMapSize 7
#define e_ASNH245H263VideoCapabilityOptionMapSizeExt 15
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_sqcifMPI;
	AsnInteger m_qcifMPI;
	AsnInteger m_cifMPI;
	AsnInteger m_cif4MPI;
	AsnInteger m_cif16MPI;
	AsnInteger m_maxBitRate;
	AsnBoolean m_unrestrictedVector;
	AsnBoolean m_arithmeticCoding;
	AsnBoolean m_advancedPrediction;
	AsnBoolean m_pbFrames;
	AsnBoolean m_temporalSpatialTradeOffCapability;
	AsnInteger m_hrd_B;
	AsnInteger m_bppMaxKb;
	/*...,*/
	AsnInteger m_slowSqcifMPI;
	AsnInteger m_slowQcifMPI;
	AsnInteger m_slowCifMPI;
	AsnInteger m_slowCif4MPI;
	AsnInteger m_slowCif16MPI;
	AsnBoolean m_errorCompensation;
	ASNH245EnhancementLayerInfo m_enhancementLayerInfo;
	ASNH245H263Options m_h263Options;
} ASNH245H263VideoCapability;
HS_RESULT new_ASNH245H263VideoCapability( void *pObject );
HS_RESULT delete_ASNH245H263VideoCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H263VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H263VideoCapability_IncludeOptionField( void *pObject, ASNH245H263VideoCapabilityOptionMap pOptionMap );
BOOL	  ASNH245H263VideoCapability_IsIncludeOptionField( void *pObject, ASNH245H263VideoCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245H263VideoCapability_MakeMold( void *pObject );
HS_RESULT ASNH245H263VideoCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H263VideoCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IS11172VideoCapabilityOptionMap_videoBitRate,
	e_ASNH245IS11172VideoCapabilityOptionMap_vbvBufferSize,
	e_ASNH245IS11172VideoCapabilityOptionMap_samplesPerLine,
	e_ASNH245IS11172VideoCapabilityOptionMap_linesPerFrame,
	e_ASNH245IS11172VideoCapabilityOptionMap_pictureRate,
	e_ASNH245IS11172VideoCapabilityOptionMap_luminanceSampleRate
,
	e_ASNH245IS11172VideoCapabilityOptionMap_videoBadMBsCap
} ASNH245IS11172VideoCapabilityOptionMap;


#define e_ASNH245IS11172VideoCapabilityOptionMapSize 6
#define e_ASNH245IS11172VideoCapabilityOptionMapSizeExt 7
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_constrainedBitstream;
	AsnInteger m_videoBitRate;
	AsnInteger m_vbvBufferSize;
	AsnInteger m_samplesPerLine;
	AsnInteger m_linesPerFrame;
	AsnInteger m_pictureRate;
	AsnInteger m_luminanceSampleRate;
	/*...,*/
	AsnBoolean m_videoBadMBsCap;
} ASNH245IS11172VideoCapability;
HS_RESULT new_ASNH245IS11172VideoCapability( void *pObject );
HS_RESULT delete_ASNH245IS11172VideoCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS11172VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245IS11172VideoCapability_IncludeOptionField( void *pObject, ASNH245IS11172VideoCapabilityOptionMap pOptionMap );
BOOL	  ASNH245IS11172VideoCapability_IsIncludeOptionField( void *pObject, ASNH245IS11172VideoCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245IS11172VideoCapability_MakeMold( void *pObject );
HS_RESULT ASNH245IS11172VideoCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS11172VideoCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245VideoCapabilityChoice_nonStandard,
	e_ASNH245VideoCapabilityChoice_h261VideoCapability,
	e_ASNH245VideoCapabilityChoice_h262VideoCapability,
	e_ASNH245VideoCapabilityChoice_h263VideoCapability,
	e_ASNH245VideoCapabilityChoice_is11172VideoCapability
,
	e_ASNH245VideoCapabilityChoice_genericVideoCapability
} ASNH245VideoCapabilityChoice;


#define e_ASNH245VideoCapabilityChoiceSize		5
#define e_ASNH245VideoCapabilityChoiceSizeExt	6
typedef struct
{
	ASNH245VideoCapabilityChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245VideoCapability;
HS_RESULT new_ASNH245VideoCapability( void *pObject );
HS_RESULT delete_ASNH245VideoCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245VideoCapability_SetChoice( void *pObject, ASNH245VideoCapabilityChoice pChoice );
HS_RESULT ASNH245VideoCapability_DeleteAlternation( void *pObject );
HS_RESULT ASNH245VideoCapability_MakeMold( void *pObject );
HS_RESULT ASNH245VideoCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VideoCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245AudioCapability_g7231OptionMapSize 0
#define e_ASNH245AudioCapability_g7231OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_maxAl_sduAudioFrames;
	AsnBoolean m_silenceSuppression;
} ASNH245AudioCapability_g7231;
HS_RESULT new_ASNH245AudioCapability_g7231( void *pObject );
HS_RESULT delete_ASNH245AudioCapability_g7231( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245AudioCapability_g7231_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245AudioCapability_g7231_MakeMold( void *pObject );
HS_RESULT ASNH245AudioCapability_g7231_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245AudioCapability_g7231_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245IS11172AudioCapabilityOptionMapSize 0
#define e_ASNH245IS11172AudioCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_audioLayer1;
	AsnBoolean m_audioLayer2;
	AsnBoolean m_audioLayer3;
	AsnBoolean m_audioSampling32k;
	AsnBoolean m_audioSampling44k1;
	AsnBoolean m_audioSampling48k;
	AsnBoolean m_singleChannel;
	AsnBoolean m_twoChannels;
	AsnInteger m_bitRate;
	/*...,*/
} ASNH245IS11172AudioCapability;
HS_RESULT new_ASNH245IS11172AudioCapability( void *pObject );
HS_RESULT delete_ASNH245IS11172AudioCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS11172AudioCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245IS11172AudioCapability_MakeMold( void *pObject );
HS_RESULT ASNH245IS11172AudioCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS11172AudioCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245IS13818AudioCapabilityOptionMapSize 0
#define e_ASNH245IS13818AudioCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_audioLayer1;
	AsnBoolean m_audioLayer2;
	AsnBoolean m_audioLayer3;
	AsnBoolean m_audioSampling16k;
	AsnBoolean m_audioSampling22k05;
	AsnBoolean m_audioSampling24k;
	AsnBoolean m_audioSampling32k;
	AsnBoolean m_audioSampling44k1;
	AsnBoolean m_audioSampling48k;
	AsnBoolean m_singleChannel;
	AsnBoolean m_twoChannels;
	AsnBoolean m_threeChannels2_1;
	AsnBoolean m_threeChannels3_0;
	AsnBoolean m_fourChannels2_0_2_0;
	AsnBoolean m_fourChannels2_2;
	AsnBoolean m_fourChannels3_1;
	AsnBoolean m_fiveChannels3_0_2_0;
	AsnBoolean m_fiveChannels3_2;
	AsnBoolean m_lowFrequencyEnhancement;
	AsnBoolean m_multilingual;
	AsnInteger m_bitRate;
	/*...,*/
} ASNH245IS13818AudioCapability;
HS_RESULT new_ASNH245IS13818AudioCapability( void *pObject );
HS_RESULT delete_ASNH245IS13818AudioCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS13818AudioCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245IS13818AudioCapability_MakeMold( void *pObject );
HS_RESULT ASNH245IS13818AudioCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS13818AudioCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245G7231AnnexCCapability_g723AnnexCAudioModeOptionMapSize 0
#define e_ASNH245G7231AnnexCCapability_g723AnnexCAudioModeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_highRateMode0;
	AsnInteger m_highRateMode1;
	AsnInteger m_lowRateMode0;
	AsnInteger m_lowRateMode1;
	AsnInteger m_sidMode0;
	AsnInteger m_sidMode1;
	/*...,*/
} ASNH245G7231AnnexCCapability_g723AnnexCAudioMode;
HS_RESULT new_ASNH245G7231AnnexCCapability_g723AnnexCAudioMode( void *pObject );
HS_RESULT delete_ASNH245G7231AnnexCCapability_g723AnnexCAudioMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245G7231AnnexCCapability_g723AnnexCAudioMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245G7231AnnexCCapability_g723AnnexCAudioMode_MakeMold( void *pObject );
HS_RESULT ASNH245G7231AnnexCCapability_g723AnnexCAudioMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245G7231AnnexCCapability_g723AnnexCAudioMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245G7231AnnexCCapabilityOptionMap_g723AnnexCAudioMode

} ASNH245G7231AnnexCCapabilityOptionMap;


#define e_ASNH245G7231AnnexCCapabilityOptionMapSize 1
#define e_ASNH245G7231AnnexCCapabilityOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_maxAl_sduAudioFrames;
	AsnBoolean m_silenceSuppression;
	ASNH245G7231AnnexCCapability_g723AnnexCAudioMode m_g723AnnexCAudioMode;
	/*...,*/
} ASNH245G7231AnnexCCapability;
HS_RESULT new_ASNH245G7231AnnexCCapability( void *pObject );
HS_RESULT delete_ASNH245G7231AnnexCCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245G7231AnnexCCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245G7231AnnexCCapability_IncludeOptionField( void *pObject, ASNH245G7231AnnexCCapabilityOptionMap pOptionMap );
BOOL	  ASNH245G7231AnnexCCapability_IsIncludeOptionField( void *pObject, ASNH245G7231AnnexCCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245G7231AnnexCCapability_MakeMold( void *pObject );
HS_RESULT ASNH245G7231AnnexCCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245G7231AnnexCCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245GSMAudioCapabilityOptionMapSize 0
#define e_ASNH245GSMAudioCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_audioUnitSize;
	AsnBoolean m_comfortNoise;
	AsnBoolean m_scrambled;
	/*...,*/
} ASNH245GSMAudioCapability;
HS_RESULT new_ASNH245GSMAudioCapability( void *pObject );
HS_RESULT delete_ASNH245GSMAudioCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245GSMAudioCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245GSMAudioCapability_MakeMold( void *pObject );
HS_RESULT ASNH245GSMAudioCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245GSMAudioCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245G729ExtensionsOptionMap_audioUnit

} ASNH245G729ExtensionsOptionMap;


#define e_ASNH245G729ExtensionsOptionMapSize 1
#define e_ASNH245G729ExtensionsOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_audioUnit;
	AsnBoolean m_annexA;
	AsnBoolean m_annexB;
	AsnBoolean m_annexD;
	AsnBoolean m_annexE;
	AsnBoolean m_annexF;
	AsnBoolean m_annexG;
	AsnBoolean m_annexH;
	/*...,*/
} ASNH245G729Extensions;
HS_RESULT new_ASNH245G729Extensions( void *pObject );
HS_RESULT delete_ASNH245G729Extensions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245G729Extensions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245G729Extensions_IncludeOptionField( void *pObject, ASNH245G729ExtensionsOptionMap pOptionMap );
BOOL	  ASNH245G729Extensions_IsIncludeOptionField( void *pObject, ASNH245G729ExtensionsOptionMap pOptionMap );
HS_RESULT ASNH245G729Extensions_MakeMold( void *pObject );
HS_RESULT ASNH245G729Extensions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245G729Extensions_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245AudioCapabilityChoice_nonStandard,
	e_ASNH245AudioCapabilityChoice_g711Alaw64k,
	e_ASNH245AudioCapabilityChoice_g711Alaw56k,
	e_ASNH245AudioCapabilityChoice_g711Ulaw64k,
	e_ASNH245AudioCapabilityChoice_g711Ulaw56k,
	e_ASNH245AudioCapabilityChoice_g722_64k,
	e_ASNH245AudioCapabilityChoice_g722_56k,
	e_ASNH245AudioCapabilityChoice_g722_48k,
	e_ASNH245AudioCapabilityChoice_g7231,
	e_ASNH245AudioCapabilityChoice_g728,
	e_ASNH245AudioCapabilityChoice_g729,
	e_ASNH245AudioCapabilityChoice_g729AnnexA,
	e_ASNH245AudioCapabilityChoice_is11172AudioCapability,
	e_ASNH245AudioCapabilityChoice_is13818AudioCapability
,
	e_ASNH245AudioCapabilityChoice_g729wAnnexB,
	e_ASNH245AudioCapabilityChoice_g729AnnexAwAnnexB,
	e_ASNH245AudioCapabilityChoice_g7231AnnexCCapability,
	e_ASNH245AudioCapabilityChoice_gsmFullRate,
	e_ASNH245AudioCapabilityChoice_gsmHalfRate,
	e_ASNH245AudioCapabilityChoice_gsmEnhancedFullRate,
	e_ASNH245AudioCapabilityChoice_genericAudioCapability,
	e_ASNH245AudioCapabilityChoice_g729Extensions
} ASNH245AudioCapabilityChoice;


#define e_ASNH245AudioCapabilityChoiceSize		14
#define e_ASNH245AudioCapabilityChoiceSizeExt	22
typedef struct
{
	ASNH245AudioCapabilityChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245AudioCapability;
HS_RESULT new_ASNH245AudioCapability( void *pObject );
HS_RESULT delete_ASNH245AudioCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245AudioCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245AudioCapability_SetChoice( void *pObject, ASNH245AudioCapabilityChoice pChoice );
HS_RESULT ASNH245AudioCapability_DeleteAlternation( void *pObject );
HS_RESULT ASNH245AudioCapability_MakeMold( void *pObject );
HS_RESULT ASNH245AudioCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245AudioCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245Capability_h233EncryptionReceiveCapabilityOptionMapSize 0
#define e_ASNH245Capability_h233EncryptionReceiveCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_h233IVResponseTime;
	/*...,*/
} ASNH245Capability_h233EncryptionReceiveCapability;
HS_RESULT new_ASNH245Capability_h233EncryptionReceiveCapability( void *pObject );
HS_RESULT delete_ASNH245Capability_h233EncryptionReceiveCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245Capability_h233EncryptionReceiveCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245Capability_h233EncryptionReceiveCapability_MakeMold( void *pObject );
HS_RESULT ASNH245Capability_h233EncryptionReceiveCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245Capability_h233EncryptionReceiveCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceCapabilityOptionMap_nonStandardData
,
	e_ASNH245ConferenceCapabilityOptionMap_videoIndicateMixingCapability,
	e_ASNH245ConferenceCapabilityOptionMap_multipointVisualizationCapability
} ASNH245ConferenceCapabilityOptionMap;


#define e_ASNH245ConferenceCapabilityOptionMapSize 1
#define e_ASNH245ConferenceCapabilityOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_nonStandardData;
	AsnBoolean m_chairControlCapability;
	/*...,*/
	AsnBoolean m_videoIndicateMixingCapability;
	AsnBoolean m_multipointVisualizationCapability;
} ASNH245ConferenceCapability;
HS_RESULT new_ASNH245ConferenceCapability( void *pObject );
HS_RESULT delete_ASNH245ConferenceCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceCapability_IncludeOptionField( void *pObject, ASNH245ConferenceCapabilityOptionMap pOptionMap );
BOOL	  ASNH245ConferenceCapability_IsIncludeOptionField( void *pObject, ASNH245ConferenceCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245ConferenceCapability_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245AuthenticationCapabilityOptionMap_nonStandard
,
	e_ASNH245AuthenticationCapabilityOptionMap_antiSpamAlgorithm
} ASNH245AuthenticationCapabilityOptionMap;


#define e_ASNH245AuthenticationCapabilityOptionMapSize 1
#define e_ASNH245AuthenticationCapabilityOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245NonStandardParameter m_nonStandard;
	/*...,*/
	AsnObjectIdentifier m_antiSpamAlgorithm;
} ASNH245AuthenticationCapability;
HS_RESULT new_ASNH245AuthenticationCapability( void *pObject );
HS_RESULT delete_ASNH245AuthenticationCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245AuthenticationCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245AuthenticationCapability_IncludeOptionField( void *pObject, ASNH245AuthenticationCapabilityOptionMap pOptionMap );
BOOL	  ASNH245AuthenticationCapability_IsIncludeOptionField( void *pObject, ASNH245AuthenticationCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245AuthenticationCapability_MakeMold( void *pObject );
HS_RESULT ASNH245AuthenticationCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245AuthenticationCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IntegrityCapabilityOptionMap_nonStandard

} ASNH245IntegrityCapabilityOptionMap;


#define e_ASNH245IntegrityCapabilityOptionMapSize 1
#define e_ASNH245IntegrityCapabilityOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245NonStandardParameter m_nonStandard;
	/*...,*/
} ASNH245IntegrityCapability;
HS_RESULT new_ASNH245IntegrityCapability( void *pObject );
HS_RESULT delete_ASNH245IntegrityCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IntegrityCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245IntegrityCapability_IncludeOptionField( void *pObject, ASNH245IntegrityCapabilityOptionMap pOptionMap );
BOOL	  ASNH245IntegrityCapability_IsIncludeOptionField( void *pObject, ASNH245IntegrityCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245IntegrityCapability_MakeMold( void *pObject );
HS_RESULT ASNH245IntegrityCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IntegrityCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EncryptionAuthenticationAndIntegrityOptionMap_encryptionCapability,
	e_ASNH245EncryptionAuthenticationAndIntegrityOptionMap_authenticationCapability,
	e_ASNH245EncryptionAuthenticationAndIntegrityOptionMap_integrityCapability

} ASNH245EncryptionAuthenticationAndIntegrityOptionMap;


#define e_ASNH245EncryptionAuthenticationAndIntegrityOptionMapSize 3
#define e_ASNH245EncryptionAuthenticationAndIntegrityOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245EncryptionCapability m_encryptionCapability;
	ASNH245AuthenticationCapability m_authenticationCapability;
	ASNH245IntegrityCapability m_integrityCapability;
	/*...,*/
} ASNH245EncryptionAuthenticationAndIntegrity;
HS_RESULT new_ASNH245EncryptionAuthenticationAndIntegrity( void *pObject );
HS_RESULT delete_ASNH245EncryptionAuthenticationAndIntegrity( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EncryptionAuthenticationAndIntegrity_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245EncryptionAuthenticationAndIntegrity_IncludeOptionField( void *pObject, ASNH245EncryptionAuthenticationAndIntegrityOptionMap pOptionMap );
BOOL	  ASNH245EncryptionAuthenticationAndIntegrity_IsIncludeOptionField( void *pObject, ASNH245EncryptionAuthenticationAndIntegrityOptionMap pOptionMap );
HS_RESULT ASNH245EncryptionAuthenticationAndIntegrity_MakeMold( void *pObject );
HS_RESULT ASNH245EncryptionAuthenticationAndIntegrity_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EncryptionAuthenticationAndIntegrity_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H235SecurityCapabilityOptionMapSize 0
#define e_ASNH245H235SecurityCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245EncryptionAuthenticationAndIntegrity m_encryptionAuthenticationAndIntegrity;
	ASNH245CapabilityTableEntryNumber m_mediaCapability;
	/*...,*/
} ASNH245H235SecurityCapability;
HS_RESULT new_ASNH245H235SecurityCapability( void *pObject );
HS_RESULT delete_ASNH245H235SecurityCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H235SecurityCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H235SecurityCapability_MakeMold( void *pObject );
HS_RESULT ASNH245H235SecurityCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H235SecurityCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245UserInputCapabilityChoice_nonStandard,
	e_ASNH245UserInputCapabilityChoice_basicString,
	e_ASNH245UserInputCapabilityChoice_iA5String,
	e_ASNH245UserInputCapabilityChoice_generalString,
	e_ASNH245UserInputCapabilityChoice_dtmf,
	e_ASNH245UserInputCapabilityChoice_hookflash
,
	e_ASNH245UserInputCapabilityChoice_extendedAlphanumeric
} ASNH245UserInputCapabilityChoice;


#define e_ASNH245UserInputCapabilityChoiceSize		6
#define e_ASNH245UserInputCapabilityChoiceSizeExt	7
typedef struct
{
	ASNH245UserInputCapabilityChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245UserInputCapability;
HS_RESULT new_ASNH245UserInputCapability( void *pObject );
HS_RESULT delete_ASNH245UserInputCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UserInputCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245UserInputCapability_SetChoice( void *pObject, ASNH245UserInputCapabilityChoice pChoice );
HS_RESULT ASNH245UserInputCapability_DeleteAlternation( void *pObject );
HS_RESULT ASNH245UserInputCapability_MakeMold( void *pObject );
HS_RESULT ASNH245UserInputCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UserInputCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultiplexFormatChoice_nonStandard,
	e_ASNH245MultiplexFormatChoice_h222Capability,
	e_ASNH245MultiplexFormatChoice_h223Capability

} ASNH245MultiplexFormatChoice;


#define e_ASNH245MultiplexFormatChoiceSize		3
#define e_ASNH245MultiplexFormatChoiceSizeExt	3
typedef struct
{
	ASNH245MultiplexFormatChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultiplexFormat;
HS_RESULT new_ASNH245MultiplexFormat( void *pObject );
HS_RESULT delete_ASNH245MultiplexFormat( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexFormat_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultiplexFormat_SetChoice( void *pObject, ASNH245MultiplexFormatChoice pChoice );
HS_RESULT ASNH245MultiplexFormat_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultiplexFormat_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexFormat_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexFormat_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultiplexedStreamCapabilityOptionMap_capabilityOnMuxStream

} ASNH245MultiplexedStreamCapabilityOptionMap;


#define e_ASNH245MultiplexedStreamCapabilityOptionMapSize 1
#define e_ASNH245MultiplexedStreamCapabilityOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245MultiplexFormat m_multiplexFormat;
	AsnBoolean m_controlOnMuxStream;
	AsnSequenceOf m_capabilityOnMuxStream;
	/*...,*/
} ASNH245MultiplexedStreamCapability;
HS_RESULT new_ASNH245MultiplexedStreamCapability( void *pObject );
HS_RESULT delete_ASNH245MultiplexedStreamCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexedStreamCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexedStreamCapability_IncludeOptionField( void *pObject, ASNH245MultiplexedStreamCapabilityOptionMap pOptionMap );
BOOL	  ASNH245MultiplexedStreamCapability_IsIncludeOptionField( void *pObject, ASNH245MultiplexedStreamCapabilityOptionMap pOptionMap );
HS_RESULT ASNH245MultiplexedStreamCapability_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexedStreamCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexedStreamCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245AudioTelephonyEventCapabilityOptionMapSize 0
#define e_ASNH245AudioTelephonyEventCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_dynamicRTPPayloadType;
	AsnSingleString m_audioTelephoneEvent;
	/*...,*/
} ASNH245AudioTelephonyEventCapability;
HS_RESULT new_ASNH245AudioTelephonyEventCapability( void *pObject );
HS_RESULT delete_ASNH245AudioTelephonyEventCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245AudioTelephonyEventCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245AudioTelephonyEventCapability_MakeMold( void *pObject );
HS_RESULT ASNH245AudioTelephonyEventCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245AudioTelephonyEventCapability_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245AudioToneCapabilityOptionMapSize 0
#define e_ASNH245AudioToneCapabilityOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_dynamicRTPPayloadType;
	/*...,*/
} ASNH245AudioToneCapability;
HS_RESULT new_ASNH245AudioToneCapability( void *pObject );
HS_RESULT delete_ASNH245AudioToneCapability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245AudioToneCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245AudioToneCapability_MakeMold( void *pObject );
HS_RESULT ASNH245AudioToneCapability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245AudioToneCapability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CapabilityChoice_nonStandard,
	e_ASNH245CapabilityChoice_receiveVideoCapability,
	e_ASNH245CapabilityChoice_transmitVideoCapability,
	e_ASNH245CapabilityChoice_receiveAndTransmitVideoCapability,
	e_ASNH245CapabilityChoice_receiveAudioCapability,
	e_ASNH245CapabilityChoice_transmitAudioCapability,
	e_ASNH245CapabilityChoice_receiveAndTransmitAudioCapability,
	e_ASNH245CapabilityChoice_receiveDataApplicationCapability,
	e_ASNH245CapabilityChoice_transmitDataApplicationCapability,
	e_ASNH245CapabilityChoice_receiveAndTransmitDataApplicationCapability,
	e_ASNH245CapabilityChoice_h233EncryptionTransmitCapability,
	e_ASNH245CapabilityChoice_h233EncryptionReceiveCapability
,
	e_ASNH245CapabilityChoice_conferenceCapability,
	e_ASNH245CapabilityChoice_h235SecurityCapability,
	e_ASNH245CapabilityChoice_maxPendingReplacementFor,
	e_ASNH245CapabilityChoice_receiveUserInputCapability,
	e_ASNH245CapabilityChoice_transmitUserInputCapability,
	e_ASNH245CapabilityChoice_receiveAndTransmitUserInputCapability,
	e_ASNH245CapabilityChoice_genericControlCapability,
	e_ASNH245CapabilityChoice_receiveMultiplexedStreamCapability,
	e_ASNH245CapabilityChoice_transmitMultiplexedStreamCapability,
	e_ASNH245CapabilityChoice_receiveAndTransmitMultiplexedStreamCapability,
	e_ASNH245CapabilityChoice_receiveRTPAudioTelephonyEventCapability,
	e_ASNH245CapabilityChoice_receiveRTPAudioToneCapability
} ASNH245CapabilityChoice;


#define e_ASNH245CapabilityChoiceSize		12
#define e_ASNH245CapabilityChoiceSizeExt	24
typedef struct
{
	ASNH245CapabilityChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245Capability;
HS_RESULT new_ASNH245Capability( void *pObject );
HS_RESULT delete_ASNH245Capability( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245Capability_SetChoice( void *pObject, ASNH245CapabilityChoice pChoice );
HS_RESULT ASNH245Capability_DeleteAlternation( void *pObject );
HS_RESULT ASNH245Capability_MakeMold( void *pObject );
HS_RESULT ASNH245Capability_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245Capability_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CapabilityTableEntryOptionMap_capability
} ASNH245CapabilityTableEntryOptionMap;


#define e_ASNH245CapabilityTableEntryOptionMapSize 1
#define e_ASNH245CapabilityTableEntryOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245CapabilityTableEntryNumber m_capabilityTableEntryNumber;
	ASNH245Capability m_capability;
} ASNH245CapabilityTableEntry;
HS_RESULT new_ASNH245CapabilityTableEntry( void *pObject );
HS_RESULT delete_ASNH245CapabilityTableEntry( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CapabilityTableEntry_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CapabilityTableEntry_IncludeOptionField( void *pObject, ASNH245CapabilityTableEntryOptionMap pOptionMap );
BOOL	  ASNH245CapabilityTableEntry_IsIncludeOptionField( void *pObject, ASNH245CapabilityTableEntryOptionMap pOptionMap );
HS_RESULT ASNH245CapabilityTableEntry_MakeMold( void *pObject );
HS_RESULT ASNH245CapabilityTableEntry_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CapabilityTableEntry_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CapabilityDescriptorOptionMap_simultaneousCapabilities
} ASNH245CapabilityDescriptorOptionMap;


#define e_ASNH245CapabilityDescriptorOptionMapSize 1
#define e_ASNH245CapabilityDescriptorOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245CapabilityDescriptorNumber m_capabilityDescriptorNumber;
	AsnSequenceOf m_simultaneousCapabilities;
} ASNH245CapabilityDescriptor;
HS_RESULT new_ASNH245CapabilityDescriptor( void *pObject );
HS_RESULT delete_ASNH245CapabilityDescriptor( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CapabilityDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CapabilityDescriptor_IncludeOptionField( void *pObject, ASNH245CapabilityDescriptorOptionMap pOptionMap );
BOOL	  ASNH245CapabilityDescriptor_IsIncludeOptionField( void *pObject, ASNH245CapabilityDescriptorOptionMap pOptionMap );
HS_RESULT ASNH245CapabilityDescriptor_MakeMold( void *pObject );
HS_RESULT ASNH245CapabilityDescriptor_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CapabilityDescriptor_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245TerminalCapabilitySetOptionMap_multiplexCapability,
	e_ASNH245TerminalCapabilitySetOptionMap_capabilityTable,
	e_ASNH245TerminalCapabilitySetOptionMap_capabilityDescriptors

} ASNH245TerminalCapabilitySetOptionMap;


#define e_ASNH245TerminalCapabilitySetOptionMapSize 3
#define e_ASNH245TerminalCapabilitySetOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	AsnObjectIdentifier m_protocolIdentifier;
	ASNH245MultiplexCapability m_multiplexCapability;
	AsnSequenceOf m_capabilityTable;
	AsnSequenceOf m_capabilityDescriptors;
	/*...,*/
} ASNH245TerminalCapabilitySet;
HS_RESULT new_ASNH245TerminalCapabilitySet( void *pObject );
HS_RESULT delete_ASNH245TerminalCapabilitySet( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalCapabilitySet_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TerminalCapabilitySet_IncludeOptionField( void *pObject, ASNH245TerminalCapabilitySetOptionMap pOptionMap );
BOOL	  ASNH245TerminalCapabilitySet_IsIncludeOptionField( void *pObject, ASNH245TerminalCapabilitySetOptionMap pOptionMap );
HS_RESULT ASNH245TerminalCapabilitySet_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalCapabilitySet_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalCapabilitySet_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EncryptionModeChoice_nonStandard,
	e_ASNH245EncryptionModeChoice_h233Encryption

} ASNH245EncryptionModeChoice;


#define e_ASNH245EncryptionModeChoiceSize		2
#define e_ASNH245EncryptionModeChoiceSizeExt	2
typedef struct
{
	ASNH245EncryptionModeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245EncryptionMode;
HS_RESULT new_ASNH245EncryptionMode( void *pObject );
HS_RESULT delete_ASNH245EncryptionMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EncryptionMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245EncryptionMode_SetChoice( void *pObject, ASNH245EncryptionModeChoice pChoice );
HS_RESULT ASNH245EncryptionMode_DeleteAlternation( void *pObject );
HS_RESULT ASNH245EncryptionMode_MakeMold( void *pObject );
HS_RESULT ASNH245EncryptionMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EncryptionMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H235Media_mediaTypeChoice_nonStandard,
	e_ASNH245H235Media_mediaTypeChoice_videoData,
	e_ASNH245H235Media_mediaTypeChoice_audioData,
	e_ASNH245H235Media_mediaTypeChoice_data

} ASNH245H235Media_mediaTypeChoice;


#define e_ASNH245H235Media_mediaTypeChoiceSize		4
#define e_ASNH245H235Media_mediaTypeChoiceSizeExt	4
typedef struct
{
	ASNH245H235Media_mediaTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H235Media_mediaType;
HS_RESULT new_ASNH245H235Media_mediaType( void *pObject );
HS_RESULT delete_ASNH245H235Media_mediaType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H235Media_mediaType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H235Media_mediaType_SetChoice( void *pObject, ASNH245H235Media_mediaTypeChoice pChoice );
HS_RESULT ASNH245H235Media_mediaType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H235Media_mediaType_MakeMold( void *pObject );
HS_RESULT ASNH245H235Media_mediaType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H235Media_mediaType_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H235MediaOptionMapSize 0
#define e_ASNH245H235MediaOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245EncryptionAuthenticationAndIntegrity m_encryptionAuthenticationAndIntegrity;
	ASNH245H235Media_mediaType m_mediaType;
	/*...,*/
} ASNH245H235Media;
HS_RESULT new_ASNH245H235Media( void *pObject );
HS_RESULT delete_ASNH245H235Media( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H235Media_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H235Media_MakeMold( void *pObject );
HS_RESULT ASNH245H235Media_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H235Media_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultiplexedStreamParameterOptionMapSize 0
#define e_ASNH245MultiplexedStreamParameterOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MultiplexFormat m_multiplexFormat;
	AsnBoolean m_controlOnMuxStream;
	/*...,*/
} ASNH245MultiplexedStreamParameter;
HS_RESULT new_ASNH245MultiplexedStreamParameter( void *pObject );
HS_RESULT delete_ASNH245MultiplexedStreamParameter( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexedStreamParameter_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexedStreamParameter_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexedStreamParameter_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexedStreamParameter_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245DataTypeChoice_nonStandard,
	e_ASNH245DataTypeChoice_nullData,
	e_ASNH245DataTypeChoice_videoData,
	e_ASNH245DataTypeChoice_audioData,
	e_ASNH245DataTypeChoice_data,
	e_ASNH245DataTypeChoice_encryptionData
,
	e_ASNH245DataTypeChoice_h235Control,
	e_ASNH245DataTypeChoice_h235Media,
	e_ASNH245DataTypeChoice_multiplexedStream
} ASNH245DataTypeChoice;


#define e_ASNH245DataTypeChoiceSize		6
#define e_ASNH245DataTypeChoiceSizeExt	9
typedef struct
{
	ASNH245DataTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245DataType;
HS_RESULT new_ASNH245DataType( void *pObject );
HS_RESULT delete_ASNH245DataType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245DataType_SetChoice( void *pObject, ASNH245DataTypeChoice pChoice );
HS_RESULT ASNH245DataType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245DataType_MakeMold( void *pObject );
HS_RESULT ASNH245DataType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H222LogicalChannelParametersOptionMap_pcr_pid,
	e_ASNH245H222LogicalChannelParametersOptionMap_programDescriptors,
	e_ASNH245H222LogicalChannelParametersOptionMap_streamDescriptors

} ASNH245H222LogicalChannelParametersOptionMap;


#define e_ASNH245H222LogicalChannelParametersOptionMapSize 3
#define e_ASNH245H222LogicalChannelParametersOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_resourceID;
	AsnInteger m_subChannelID;
	AsnInteger m_pcr_pid;
	AsnOctetString m_programDescriptors;
	AsnOctetString m_streamDescriptors;
	/*...,*/
} ASNH245H222LogicalChannelParameters;
HS_RESULT new_ASNH245H222LogicalChannelParameters( void *pObject );
HS_RESULT delete_ASNH245H222LogicalChannelParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H222LogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H222LogicalChannelParameters_IncludeOptionField( void *pObject, ASNH245H222LogicalChannelParametersOptionMap pOptionMap );
BOOL	  ASNH245H222LogicalChannelParameters_IsIncludeOptionField( void *pObject, ASNH245H222LogicalChannelParametersOptionMap pOptionMap );
HS_RESULT ASNH245H222LogicalChannelParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H222LogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H222LogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223LogicalChannelParameters_adaptationLayerType_al3OptionMapSize 0
#define e_ASNH245H223LogicalChannelParameters_adaptationLayerType_al3OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_controlFieldOctets;
	AsnInteger m_sendBufferSize;
} ASNH245H223LogicalChannelParameters_adaptationLayerType_al3;
HS_RESULT new_ASNH245H223LogicalChannelParameters_adaptationLayerType_al3( void *pObject );
HS_RESULT delete_ASNH245H223LogicalChannelParameters_adaptationLayerType_al3( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223LogicalChannelParameters_adaptationLayerType_al3_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223LogicalChannelParameters_adaptationLayerType_al3_MakeMold( void *pObject );
HS_RESULT ASNH245H223LogicalChannelParameters_adaptationLayerType_al3_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223LogicalChannelParameters_adaptationLayerType_al3_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223AL1MParameters_transferModeChoice_framed,
	e_ASNH245H223AL1MParameters_transferModeChoice_unframed

} ASNH245H223AL1MParameters_transferModeChoice;


#define e_ASNH245H223AL1MParameters_transferModeChoiceSize		2
#define e_ASNH245H223AL1MParameters_transferModeChoiceSizeExt	2
typedef struct
{
	ASNH245H223AL1MParameters_transferModeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223AL1MParameters_transferMode;
HS_RESULT new_ASNH245H223AL1MParameters_transferMode( void *pObject );
HS_RESULT delete_ASNH245H223AL1MParameters_transferMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL1MParameters_transferMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223AL1MParameters_transferMode_SetChoice( void *pObject, ASNH245H223AL1MParameters_transferModeChoice pChoice );
HS_RESULT ASNH245H223AL1MParameters_transferMode_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223AL1MParameters_transferMode_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL1MParameters_transferMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL1MParameters_transferMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223AL1MParameters_headerFECChoice_sebch16_7,
	e_ASNH245H223AL1MParameters_headerFECChoice_golay24_12

} ASNH245H223AL1MParameters_headerFECChoice;


#define e_ASNH245H223AL1MParameters_headerFECChoiceSize		2
#define e_ASNH245H223AL1MParameters_headerFECChoiceSizeExt	2
typedef struct
{
	ASNH245H223AL1MParameters_headerFECChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223AL1MParameters_headerFEC;
HS_RESULT new_ASNH245H223AL1MParameters_headerFEC( void *pObject );
HS_RESULT delete_ASNH245H223AL1MParameters_headerFEC( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL1MParameters_headerFEC_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223AL1MParameters_headerFEC_SetChoice( void *pObject, ASNH245H223AL1MParameters_headerFECChoice pChoice );
HS_RESULT ASNH245H223AL1MParameters_headerFEC_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223AL1MParameters_headerFEC_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL1MParameters_headerFEC_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL1MParameters_headerFEC_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223AL1MParameters_crcLengthChoice_crc4bit,
	e_ASNH245H223AL1MParameters_crcLengthChoice_crc12bit,
	e_ASNH245H223AL1MParameters_crcLengthChoice_crc20bit,
	e_ASNH245H223AL1MParameters_crcLengthChoice_crc28bit
,
	e_ASNH245H223AL1MParameters_crcLengthChoice_crc8bit,
	e_ASNH245H223AL1MParameters_crcLengthChoice_crc16bit,
	e_ASNH245H223AL1MParameters_crcLengthChoice_crc32bit,
	e_ASNH245H223AL1MParameters_crcLengthChoice_crcNotUsed
} ASNH245H223AL1MParameters_crcLengthChoice;


#define e_ASNH245H223AL1MParameters_crcLengthChoiceSize		4
#define e_ASNH245H223AL1MParameters_crcLengthChoiceSizeExt	8
typedef struct
{
	ASNH245H223AL1MParameters_crcLengthChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223AL1MParameters_crcLength;
HS_RESULT new_ASNH245H223AL1MParameters_crcLength( void *pObject );
HS_RESULT delete_ASNH245H223AL1MParameters_crcLength( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL1MParameters_crcLength_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223AL1MParameters_crcLength_SetChoice( void *pObject, ASNH245H223AL1MParameters_crcLengthChoice pChoice );
HS_RESULT ASNH245H223AL1MParameters_crcLength_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223AL1MParameters_crcLength_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL1MParameters_crcLength_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL1MParameters_crcLength_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223AnnexCArqParameters_numberOfRetransmissionsChoice_finite,
	e_ASNH245H223AnnexCArqParameters_numberOfRetransmissionsChoice_infinite

} ASNH245H223AnnexCArqParameters_numberOfRetransmissionsChoice;


#define e_ASNH245H223AnnexCArqParameters_numberOfRetransmissionsChoiceSize		2
#define e_ASNH245H223AnnexCArqParameters_numberOfRetransmissionsChoiceSizeExt	2
typedef struct
{
	ASNH245H223AnnexCArqParameters_numberOfRetransmissionsChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223AnnexCArqParameters_numberOfRetransmissions;
HS_RESULT new_ASNH245H223AnnexCArqParameters_numberOfRetransmissions( void *pObject );
HS_RESULT delete_ASNH245H223AnnexCArqParameters_numberOfRetransmissions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AnnexCArqParameters_numberOfRetransmissions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223AnnexCArqParameters_numberOfRetransmissions_SetChoice( void *pObject, ASNH245H223AnnexCArqParameters_numberOfRetransmissionsChoice pChoice );
HS_RESULT ASNH245H223AnnexCArqParameters_numberOfRetransmissions_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223AnnexCArqParameters_numberOfRetransmissions_MakeMold( void *pObject );
HS_RESULT ASNH245H223AnnexCArqParameters_numberOfRetransmissions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AnnexCArqParameters_numberOfRetransmissions_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223AnnexCArqParametersOptionMapSize 0
#define e_ASNH245H223AnnexCArqParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245H223AnnexCArqParameters_numberOfRetransmissions m_numberOfRetransmissions;
	AsnInteger m_sendBufferSize;
	/*...,*/
} ASNH245H223AnnexCArqParameters;
HS_RESULT new_ASNH245H223AnnexCArqParameters( void *pObject );
HS_RESULT delete_ASNH245H223AnnexCArqParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AnnexCArqParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223AnnexCArqParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H223AnnexCArqParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AnnexCArqParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223AL1MParameters_arqTypeChoice_noArq,
	e_ASNH245H223AL1MParameters_arqTypeChoice_typeIArq,
	e_ASNH245H223AL1MParameters_arqTypeChoice_typeIIArq

} ASNH245H223AL1MParameters_arqTypeChoice;


#define e_ASNH245H223AL1MParameters_arqTypeChoiceSize		3
#define e_ASNH245H223AL1MParameters_arqTypeChoiceSizeExt	3
typedef struct
{
	ASNH245H223AL1MParameters_arqTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223AL1MParameters_arqType;
HS_RESULT new_ASNH245H223AL1MParameters_arqType( void *pObject );
HS_RESULT delete_ASNH245H223AL1MParameters_arqType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL1MParameters_arqType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223AL1MParameters_arqType_SetChoice( void *pObject, ASNH245H223AL1MParameters_arqTypeChoice pChoice );
HS_RESULT ASNH245H223AL1MParameters_arqType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223AL1MParameters_arqType_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL1MParameters_arqType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL1MParameters_arqType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245H223AL1MParametersOptionMap_rsCodeCorrection
} ASNH245H223AL1MParametersOptionMap;


#define e_ASNH245H223AL1MParametersOptionMapSize 0
#define e_ASNH245H223AL1MParametersOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245H223AL1MParameters_transferMode m_transferMode;
	ASNH245H223AL1MParameters_headerFEC m_headerFEC;
	ASNH245H223AL1MParameters_crcLength m_crcLength;
	AsnInteger m_rcpcCodeRate;
	ASNH245H223AL1MParameters_arqType m_arqType;
	AsnBoolean m_alpduInterleaving;
	AsnBoolean m_alsduSplitting;
	/*...,*/
	AsnInteger m_rsCodeCorrection;
} ASNH245H223AL1MParameters;
HS_RESULT new_ASNH245H223AL1MParameters( void *pObject );
HS_RESULT delete_ASNH245H223AL1MParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL1MParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223AL1MParameters_IncludeOptionField( void *pObject, ASNH245H223AL1MParametersOptionMap pOptionMap );
BOOL	  ASNH245H223AL1MParameters_IsIncludeOptionField( void *pObject, ASNH245H223AL1MParametersOptionMap pOptionMap );
HS_RESULT ASNH245H223AL1MParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL1MParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL1MParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223AL2MParameters_headerFECChoice_sebch16_5,
	e_ASNH245H223AL2MParameters_headerFECChoice_golay24_12

} ASNH245H223AL2MParameters_headerFECChoice;


#define e_ASNH245H223AL2MParameters_headerFECChoiceSize		2
#define e_ASNH245H223AL2MParameters_headerFECChoiceSizeExt	2
typedef struct
{
	ASNH245H223AL2MParameters_headerFECChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223AL2MParameters_headerFEC;
HS_RESULT new_ASNH245H223AL2MParameters_headerFEC( void *pObject );
HS_RESULT delete_ASNH245H223AL2MParameters_headerFEC( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL2MParameters_headerFEC_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223AL2MParameters_headerFEC_SetChoice( void *pObject, ASNH245H223AL2MParameters_headerFECChoice pChoice );
HS_RESULT ASNH245H223AL2MParameters_headerFEC_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223AL2MParameters_headerFEC_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL2MParameters_headerFEC_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL2MParameters_headerFEC_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223AL2MParametersOptionMapSize 0
#define e_ASNH245H223AL2MParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245H223AL2MParameters_headerFEC m_headerFEC;
	AsnBoolean m_alpduInterleaving;
	/*...,*/
} ASNH245H223AL2MParameters;
HS_RESULT new_ASNH245H223AL2MParameters( void *pObject );
HS_RESULT delete_ASNH245H223AL2MParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL2MParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223AL2MParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL2MParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL2MParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223AL3MParameters_headerFormatChoice_sebch16_7,
	e_ASNH245H223AL3MParameters_headerFormatChoice_golay24_12

} ASNH245H223AL3MParameters_headerFormatChoice;


#define e_ASNH245H223AL3MParameters_headerFormatChoiceSize		2
#define e_ASNH245H223AL3MParameters_headerFormatChoiceSizeExt	2
typedef struct
{
	ASNH245H223AL3MParameters_headerFormatChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223AL3MParameters_headerFormat;
HS_RESULT new_ASNH245H223AL3MParameters_headerFormat( void *pObject );
HS_RESULT delete_ASNH245H223AL3MParameters_headerFormat( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL3MParameters_headerFormat_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223AL3MParameters_headerFormat_SetChoice( void *pObject, ASNH245H223AL3MParameters_headerFormatChoice pChoice );
HS_RESULT ASNH245H223AL3MParameters_headerFormat_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223AL3MParameters_headerFormat_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL3MParameters_headerFormat_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL3MParameters_headerFormat_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223AL3MParameters_crcLengthChoice_crc4bit,
	e_ASNH245H223AL3MParameters_crcLengthChoice_crc12bit,
	e_ASNH245H223AL3MParameters_crcLengthChoice_crc20bit,
	e_ASNH245H223AL3MParameters_crcLengthChoice_crc28bit
,
	e_ASNH245H223AL3MParameters_crcLengthChoice_crc8bit,
	e_ASNH245H223AL3MParameters_crcLengthChoice_crc16bit,
	e_ASNH245H223AL3MParameters_crcLengthChoice_crc32bit,
	e_ASNH245H223AL3MParameters_crcLengthChoice_crcNotUsed
} ASNH245H223AL3MParameters_crcLengthChoice;


#define e_ASNH245H223AL3MParameters_crcLengthChoiceSize		4
#define e_ASNH245H223AL3MParameters_crcLengthChoiceSizeExt	8
typedef struct
{
	ASNH245H223AL3MParameters_crcLengthChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223AL3MParameters_crcLength;
HS_RESULT new_ASNH245H223AL3MParameters_crcLength( void *pObject );
HS_RESULT delete_ASNH245H223AL3MParameters_crcLength( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL3MParameters_crcLength_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223AL3MParameters_crcLength_SetChoice( void *pObject, ASNH245H223AL3MParameters_crcLengthChoice pChoice );
HS_RESULT ASNH245H223AL3MParameters_crcLength_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223AL3MParameters_crcLength_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL3MParameters_crcLength_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL3MParameters_crcLength_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223AL3MParameters_arqTypeChoice_noArq,
	e_ASNH245H223AL3MParameters_arqTypeChoice_typeIArq,
	e_ASNH245H223AL3MParameters_arqTypeChoice_typeIIArq

} ASNH245H223AL3MParameters_arqTypeChoice;


#define e_ASNH245H223AL3MParameters_arqTypeChoiceSize		3
#define e_ASNH245H223AL3MParameters_arqTypeChoiceSizeExt	3
typedef struct
{
	ASNH245H223AL3MParameters_arqTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223AL3MParameters_arqType;
HS_RESULT new_ASNH245H223AL3MParameters_arqType( void *pObject );
HS_RESULT delete_ASNH245H223AL3MParameters_arqType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL3MParameters_arqType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223AL3MParameters_arqType_SetChoice( void *pObject, ASNH245H223AL3MParameters_arqTypeChoice pChoice );
HS_RESULT ASNH245H223AL3MParameters_arqType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223AL3MParameters_arqType_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL3MParameters_arqType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL3MParameters_arqType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245H223AL3MParametersOptionMap_rsCodeCorrection
} ASNH245H223AL3MParametersOptionMap;


#define e_ASNH245H223AL3MParametersOptionMapSize 0
#define e_ASNH245H223AL3MParametersOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245H223AL3MParameters_headerFormat m_headerFormat;
	ASNH245H223AL3MParameters_crcLength m_crcLength;
	AsnInteger m_rcpcCodeRate;
	ASNH245H223AL3MParameters_arqType m_arqType;
	AsnBoolean m_alpduInterleaving;
	/*...,*/
	AsnInteger m_rsCodeCorrection;
} ASNH245H223AL3MParameters;
HS_RESULT new_ASNH245H223AL3MParameters( void *pObject );
HS_RESULT delete_ASNH245H223AL3MParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223AL3MParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223AL3MParameters_IncludeOptionField( void *pObject, ASNH245H223AL3MParametersOptionMap pOptionMap );
BOOL	  ASNH245H223AL3MParameters_IsIncludeOptionField( void *pObject, ASNH245H223AL3MParametersOptionMap pOptionMap );
HS_RESULT ASNH245H223AL3MParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H223AL3MParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223AL3MParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice_nonStandard,
	e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice_al1Framed,
	e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice_al1NotFramed,
	e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice_al2WithoutSequenceNumbers,
	e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice_al2WithSequenceNumbers,
	e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice_al3
,
	e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice_al1M,
	e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice_al2M,
	e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice_al3M
} ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice;


#define e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoiceSize		6
#define e_ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoiceSizeExt	9
typedef struct
{
	ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223LogicalChannelParameters_adaptationLayerType;
HS_RESULT new_ASNH245H223LogicalChannelParameters_adaptationLayerType( void *pObject );
HS_RESULT delete_ASNH245H223LogicalChannelParameters_adaptationLayerType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223LogicalChannelParameters_adaptationLayerType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223LogicalChannelParameters_adaptationLayerType_SetChoice( void *pObject, ASNH245H223LogicalChannelParameters_adaptationLayerTypeChoice pChoice );
HS_RESULT ASNH245H223LogicalChannelParameters_adaptationLayerType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223LogicalChannelParameters_adaptationLayerType_MakeMold( void *pObject );
HS_RESULT ASNH245H223LogicalChannelParameters_adaptationLayerType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223LogicalChannelParameters_adaptationLayerType_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223LogicalChannelParametersOptionMapSize 0
#define e_ASNH245H223LogicalChannelParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245H223LogicalChannelParameters_adaptationLayerType m_adaptationLayerType;
	AsnBoolean m_segmentableFlag;
	/*...,*/
} ASNH245H223LogicalChannelParameters;
HS_RESULT new_ASNH245H223LogicalChannelParameters( void *pObject );
HS_RESULT delete_ASNH245H223LogicalChannelParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223LogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223LogicalChannelParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H223LogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223LogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CRCLengthChoice_crc8bit,
	e_ASNH245CRCLengthChoice_crc16bit,
	e_ASNH245CRCLengthChoice_crc32bit

} ASNH245CRCLengthChoice;


#define e_ASNH245CRCLengthChoiceSize		3
#define e_ASNH245CRCLengthChoiceSizeExt	3
typedef struct
{
	ASNH245CRCLengthChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245CRCLength;
HS_RESULT new_ASNH245CRCLength( void *pObject );
HS_RESULT delete_ASNH245CRCLength( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CRCLength_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245CRCLength_SetChoice( void *pObject, ASNH245CRCLengthChoice pChoice );
HS_RESULT ASNH245CRCLength_DeleteAlternation( void *pObject );
HS_RESULT ASNH245CRCLength_MakeMold( void *pObject );
HS_RESULT ASNH245CRCLength_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CRCLength_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245V76HDLCParametersOptionMapSize 0
#define e_ASNH245V76HDLCParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245CRCLength m_crcLength;
	AsnInteger m_n401;
	AsnBoolean m_loopbackTestProcedure;
	/*...,*/
} ASNH245V76HDLCParameters;
HS_RESULT new_ASNH245V76HDLCParameters( void *pObject );
HS_RESULT delete_ASNH245V76HDLCParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V76HDLCParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245V76HDLCParameters_MakeMold( void *pObject );
HS_RESULT ASNH245V76HDLCParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V76HDLCParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_noSuspendResume,
	e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewAddress,
	e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewoAddress

} ASNH245V76LogicalChannelParameters_suspendResumeChoice;


#define e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSize		3
#define e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSizeExt	3
typedef struct
{
	ASNH245V76LogicalChannelParameters_suspendResumeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245V76LogicalChannelParameters_suspendResume;
HS_RESULT new_ASNH245V76LogicalChannelParameters_suspendResume( void *pObject );
HS_RESULT delete_ASNH245V76LogicalChannelParameters_suspendResume( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245V76LogicalChannelParameters_suspendResume_SetChoice( void *pObject, ASNH245V76LogicalChannelParameters_suspendResumeChoice pChoice );
HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_DeleteAlternation( void *pObject );
HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_MakeMold( void *pObject );
HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_rej,
	e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_sREJ,
	e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_mSREJ

} ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice;


#define e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSize		3
#define e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSizeExt	3
typedef struct
{
	ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245V76LogicalChannelParameters_mode_eRM_recovery;
HS_RESULT new_ASNH245V76LogicalChannelParameters_mode_eRM_recovery( void *pObject );
HS_RESULT delete_ASNH245V76LogicalChannelParameters_mode_eRM_recovery( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245V76LogicalChannelParameters_mode_eRM_recovery_SetChoice( void *pObject, ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice pChoice );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_DeleteAlternation( void *pObject );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_MakeMold( void *pObject );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245V76LogicalChannelParameters_mode_eRMOptionMapSize 0
#define e_ASNH245V76LogicalChannelParameters_mode_eRMOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_windowSize;
	ASNH245V76LogicalChannelParameters_mode_eRM_recovery m_recovery;
	/*...,*/
} ASNH245V76LogicalChannelParameters_mode_eRM;
HS_RESULT new_ASNH245V76LogicalChannelParameters_mode_eRM( void *pObject );
HS_RESULT delete_ASNH245V76LogicalChannelParameters_mode_eRM( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_MakeMold( void *pObject );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245V76LogicalChannelParameters_modeChoice_eRM,
	e_ASNH245V76LogicalChannelParameters_modeChoice_uNERM

} ASNH245V76LogicalChannelParameters_modeChoice;


#define e_ASNH245V76LogicalChannelParameters_modeChoiceSize		2
#define e_ASNH245V76LogicalChannelParameters_modeChoiceSizeExt	2
typedef struct
{
	ASNH245V76LogicalChannelParameters_modeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245V76LogicalChannelParameters_mode;
HS_RESULT new_ASNH245V76LogicalChannelParameters_mode( void *pObject );
HS_RESULT delete_ASNH245V76LogicalChannelParameters_mode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V76LogicalChannelParameters_mode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245V76LogicalChannelParameters_mode_SetChoice( void *pObject, ASNH245V76LogicalChannelParameters_modeChoice pChoice );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_DeleteAlternation( void *pObject );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_MakeMold( void *pObject );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V76LogicalChannelParameters_mode_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245V75ParametersOptionMapSize 0
#define e_ASNH245V75ParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_audioHeaderPresent;
	/*...,*/
} ASNH245V75Parameters;
HS_RESULT new_ASNH245V75Parameters( void *pObject );
HS_RESULT delete_ASNH245V75Parameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V75Parameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245V75Parameters_MakeMold( void *pObject );
HS_RESULT ASNH245V75Parameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V75Parameters_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245V76LogicalChannelParametersOptionMapSize 0
#define e_ASNH245V76LogicalChannelParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245V76HDLCParameters m_hdlcParameters;
	ASNH245V76LogicalChannelParameters_suspendResume m_suspendResume;
	AsnBoolean m_uIH;
	ASNH245V76LogicalChannelParameters_mode m_mode;
	ASNH245V75Parameters m_v75Parameters;
	/*...,*/
} ASNH245V76LogicalChannelParameters;
HS_RESULT new_ASNH245V76LogicalChannelParameters( void *pObject );
HS_RESULT delete_ASNH245V76LogicalChannelParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V76LogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245V76LogicalChannelParameters_MakeMold( void *pObject );
HS_RESULT ASNH245V76LogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V76LogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245UnicastAddress_iPAddressOptionMapSize 0
#define e_ASNH245UnicastAddress_iPAddressOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_network;
	AsnInteger m_tsapIdentifier;
	/*...,*/
} ASNH245UnicastAddress_iPAddress;
HS_RESULT new_ASNH245UnicastAddress_iPAddress( void *pObject );
HS_RESULT delete_ASNH245UnicastAddress_iPAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UnicastAddress_iPAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245UnicastAddress_iPAddress_MakeMold( void *pObject );
HS_RESULT ASNH245UnicastAddress_iPAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UnicastAddress_iPAddress_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245UnicastAddress_iPXAddressOptionMapSize 0
#define e_ASNH245UnicastAddress_iPXAddressOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_node;
	AsnOctetString m_netnum;
	AsnOctetString m_tsapIdentifier;
	/*...,*/
} ASNH245UnicastAddress_iPXAddress;
HS_RESULT new_ASNH245UnicastAddress_iPXAddress( void *pObject );
HS_RESULT delete_ASNH245UnicastAddress_iPXAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UnicastAddress_iPXAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245UnicastAddress_iPXAddress_MakeMold( void *pObject );
HS_RESULT ASNH245UnicastAddress_iPXAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UnicastAddress_iPXAddress_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245UnicastAddress_iP6AddressOptionMapSize 0
#define e_ASNH245UnicastAddress_iP6AddressOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_network;
	AsnInteger m_tsapIdentifier;
	/*...,*/
} ASNH245UnicastAddress_iP6Address;
HS_RESULT new_ASNH245UnicastAddress_iP6Address( void *pObject );
HS_RESULT delete_ASNH245UnicastAddress_iP6Address( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UnicastAddress_iP6Address_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245UnicastAddress_iP6Address_MakeMold( void *pObject );
HS_RESULT ASNH245UnicastAddress_iP6Address_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UnicastAddress_iP6Address_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_strict,
	e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_loose
} ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice;


#define e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSize		2
#define e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSizeExt	2
typedef struct
{
	ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245UnicastAddress_iPSourceRouteAddress_routing;
HS_RESULT new_ASNH245UnicastAddress_iPSourceRouteAddress_routing( void *pObject );
HS_RESULT delete_ASNH245UnicastAddress_iPSourceRouteAddress_routing( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245UnicastAddress_iPSourceRouteAddress_routing_SetChoice( void *pObject, ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice pChoice );
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_DeleteAlternation( void *pObject );
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_MakeMold( void *pObject );
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245UnicastAddress_iPSourceRouteAddressOptionMapSize 0
#define e_ASNH245UnicastAddress_iPSourceRouteAddressOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245UnicastAddress_iPSourceRouteAddress_routing m_routing;
	AsnOctetString m_network;
	AsnInteger m_tsapIdentifier;
	AsnSequenceOf m_route;
	/*...,*/
} ASNH245UnicastAddress_iPSourceRouteAddress;
HS_RESULT new_ASNH245UnicastAddress_iPSourceRouteAddress( void *pObject );
HS_RESULT delete_ASNH245UnicastAddress_iPSourceRouteAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_MakeMold( void *pObject );
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245UnicastAddressChoice_iPAddress,
	e_ASNH245UnicastAddressChoice_iPXAddress,
	e_ASNH245UnicastAddressChoice_iP6Address,
	e_ASNH245UnicastAddressChoice_netBios,
	e_ASNH245UnicastAddressChoice_iPSourceRouteAddress
,
	e_ASNH245UnicastAddressChoice_nsap,
	e_ASNH245UnicastAddressChoice_nonStandardAddress
} ASNH245UnicastAddressChoice;


#define e_ASNH245UnicastAddressChoiceSize		5
#define e_ASNH245UnicastAddressChoiceSizeExt	7
typedef struct
{
	ASNH245UnicastAddressChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245UnicastAddress;
HS_RESULT new_ASNH245UnicastAddress( void *pObject );
HS_RESULT delete_ASNH245UnicastAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UnicastAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245UnicastAddress_SetChoice( void *pObject, ASNH245UnicastAddressChoice pChoice );
HS_RESULT ASNH245UnicastAddress_DeleteAlternation( void *pObject );
HS_RESULT ASNH245UnicastAddress_MakeMold( void *pObject );
HS_RESULT ASNH245UnicastAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UnicastAddress_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MulticastAddress_iPAddressOptionMapSize 0
#define e_ASNH245MulticastAddress_iPAddressOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_network;
	AsnInteger m_tsapIdentifier;
	/*...,*/
} ASNH245MulticastAddress_iPAddress;
HS_RESULT new_ASNH245MulticastAddress_iPAddress( void *pObject );
HS_RESULT delete_ASNH245MulticastAddress_iPAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MulticastAddress_iPAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MulticastAddress_iPAddress_MakeMold( void *pObject );
HS_RESULT ASNH245MulticastAddress_iPAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MulticastAddress_iPAddress_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MulticastAddress_iP6AddressOptionMapSize 0
#define e_ASNH245MulticastAddress_iP6AddressOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_network;
	AsnInteger m_tsapIdentifier;
	/*...,*/
} ASNH245MulticastAddress_iP6Address;
HS_RESULT new_ASNH245MulticastAddress_iP6Address( void *pObject );
HS_RESULT delete_ASNH245MulticastAddress_iP6Address( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MulticastAddress_iP6Address_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MulticastAddress_iP6Address_MakeMold( void *pObject );
HS_RESULT ASNH245MulticastAddress_iP6Address_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MulticastAddress_iP6Address_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MulticastAddressChoice_iPAddress,
	e_ASNH245MulticastAddressChoice_iP6Address
,
	e_ASNH245MulticastAddressChoice_nsap,
	e_ASNH245MulticastAddressChoice_nonStandardAddress
} ASNH245MulticastAddressChoice;


#define e_ASNH245MulticastAddressChoiceSize		2
#define e_ASNH245MulticastAddressChoiceSizeExt	4
typedef struct
{
	ASNH245MulticastAddressChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MulticastAddress;
HS_RESULT new_ASNH245MulticastAddress( void *pObject );
HS_RESULT delete_ASNH245MulticastAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MulticastAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MulticastAddress_SetChoice( void *pObject, ASNH245MulticastAddressChoice pChoice );
HS_RESULT ASNH245MulticastAddress_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MulticastAddress_MakeMold( void *pObject );
HS_RESULT ASNH245MulticastAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MulticastAddress_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245TransportAddressChoice_unicastAddress,
	e_ASNH245TransportAddressChoice_multicastAddress

} ASNH245TransportAddressChoice;


#define e_ASNH245TransportAddressChoiceSize		2
#define e_ASNH245TransportAddressChoiceSizeExt	2
typedef struct
{
	ASNH245TransportAddressChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245TransportAddress;
HS_RESULT new_ASNH245TransportAddress( void *pObject );
HS_RESULT delete_ASNH245TransportAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TransportAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245TransportAddress_SetChoice( void *pObject, ASNH245TransportAddressChoice pChoice );
HS_RESULT ASNH245TransportAddress_DeleteAlternation( void *pObject );
HS_RESULT ASNH245TransportAddress_MakeMold( void *pObject );
HS_RESULT ASNH245TransportAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TransportAddress_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245TerminalLabelOptionMapSize 0
#define e_ASNH245TerminalLabelOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245McuNumber m_mcuNumber;
	ASNH245TerminalNumber m_terminalNumber;
	/*...,*/
} ASNH245TerminalLabel;
HS_RESULT new_ASNH245TerminalLabel( void *pObject );
HS_RESULT delete_ASNH245TerminalLabel( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalLabel_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TerminalLabel_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalLabel_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalLabel_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_h261aVideoPacketization
,
	e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_rtpPayloadType
} ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice;


#define e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSize		1
#define e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSizeExt	2
typedef struct
{
	ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H2250LogicalChannelParameters_mediaPacketization;
HS_RESULT new_ASNH245H2250LogicalChannelParameters_mediaPacketization( void *pObject );
HS_RESULT delete_ASNH245H2250LogicalChannelParameters_mediaPacketization( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H2250LogicalChannelParameters_mediaPacketization_SetChoice( void *pObject, ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice pChoice );
HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_MakeMold( void *pObject );
HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RedundancyEncodingOptionMap_secondaryEncoding

} ASNH245RedundancyEncodingOptionMap;


#define e_ASNH245RedundancyEncodingOptionMapSize 1
#define e_ASNH245RedundancyEncodingOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245RedundancyEncodingMethod m_redundancyEncodingMethod;
	ASNH245DataType m_secondaryEncoding;
	/*...,*/
} ASNH245RedundancyEncoding;
HS_RESULT new_ASNH245RedundancyEncoding( void *pObject );
HS_RESULT delete_ASNH245RedundancyEncoding( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RedundancyEncoding_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RedundancyEncoding_IncludeOptionField( void *pObject, ASNH245RedundancyEncodingOptionMap pOptionMap );
BOOL	  ASNH245RedundancyEncoding_IsIncludeOptionField( void *pObject, ASNH245RedundancyEncodingOptionMap pOptionMap );
HS_RESULT ASNH245RedundancyEncoding_MakeMold( void *pObject );
HS_RESULT ASNH245RedundancyEncoding_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RedundancyEncoding_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H2250LogicalChannelParametersOptionMap_nonStandard,
	e_ASNH245H2250LogicalChannelParametersOptionMap_associatedSessionID,
	e_ASNH245H2250LogicalChannelParametersOptionMap_mediaChannel,
	e_ASNH245H2250LogicalChannelParametersOptionMap_mediaGuaranteedDelivery,
	e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlChannel,
	e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlGuaranteedDelivery,
	e_ASNH245H2250LogicalChannelParametersOptionMap_silenceSuppression,
	e_ASNH245H2250LogicalChannelParametersOptionMap_destination,
	e_ASNH245H2250LogicalChannelParametersOptionMap_dynamicRTPPayloadType,
	e_ASNH245H2250LogicalChannelParametersOptionMap_mediaPacketization
,
	e_ASNH245H2250LogicalChannelParametersOptionMap_transportCapability,
	e_ASNH245H2250LogicalChannelParametersOptionMap_redundancyEncoding,
	e_ASNH245H2250LogicalChannelParametersOptionMap_source
} ASNH245H2250LogicalChannelParametersOptionMap;


#define e_ASNH245H2250LogicalChannelParametersOptionMapSize 10
#define e_ASNH245H2250LogicalChannelParametersOptionMapSizeExt 13
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_nonStandard;
	AsnInteger m_sessionID;
	AsnInteger m_associatedSessionID;
	ASNH245TransportAddress m_mediaChannel;
	AsnBoolean m_mediaGuaranteedDelivery;
	ASNH245TransportAddress m_mediaControlChannel;
	AsnBoolean m_mediaControlGuaranteedDelivery;
	AsnBoolean m_silenceSuppression;
	ASNH245TerminalLabel m_destination;
	AsnInteger m_dynamicRTPPayloadType;
	ASNH245H2250LogicalChannelParameters_mediaPacketization m_mediaPacketization;
	/*...,*/
	ASNH245TransportCapability m_transportCapability;
	ASNH245RedundancyEncoding m_redundancyEncoding;
	ASNH245TerminalLabel m_source;
} ASNH245H2250LogicalChannelParameters;
HS_RESULT new_ASNH245H2250LogicalChannelParameters( void *pObject );
HS_RESULT delete_ASNH245H2250LogicalChannelParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H2250LogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H2250LogicalChannelParameters_IncludeOptionField( void *pObject, ASNH245H2250LogicalChannelParametersOptionMap pOptionMap );
BOOL	  ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( void *pObject, ASNH245H2250LogicalChannelParametersOptionMap pOptionMap );
HS_RESULT ASNH245H2250LogicalChannelParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H2250LogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H2250LogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters,
	e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters,
	e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters
,
	e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters,
	e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_none
} ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice;


#define e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSize		3
#define e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSizeExt	5
typedef struct
{
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters;
HS_RESULT new_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice( void *pObject, ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice pChoice );
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_DeleteAlternation( void *pObject );
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_portNumber
,
	e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_forwardLogicalChannelDependency,
	e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_replacementFor
} ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap;


#define e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSize 1
#define e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_portNumber;
	ASNH245DataType m_dataType;
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters m_multiplexParameters;
	/*...,*/
	ASNH245LogicalChannelNumber m_forwardLogicalChannelDependency;
	ASNH245LogicalChannelNumber m_replacementFor;
} ASNH245OpenLogicalChannel_forwardLogicalChannelParameters;
HS_RESULT new_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap pOptionMap );
BOOL	  ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap pOptionMap );
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters,
	e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters
,
	e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters
} ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice;


#define e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSize		2
#define e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt	3
typedef struct
{
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters;
HS_RESULT new_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_SetChoice( void *pObject, ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice pChoice );
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation( void *pObject );
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_multiplexParameters
,
	e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_reverseLogicalChannelDependency,
	e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_replacementFor
} ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap;


#define e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSize 1
#define e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245DataType m_dataType;
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters m_multiplexParameters;
	/*...,*/
	ASNH245LogicalChannelNumber m_reverseLogicalChannelDependency;
	ASNH245LogicalChannelNumber m_replacementFor;
} ASNH245OpenLogicalChannel_reverseLogicalChannelParameters;
HS_RESULT new_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap pOptionMap );
BOOL	  ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap pOptionMap );
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NetworkAccessParameters_distributionChoice_unicast,
	e_ASNH245NetworkAccessParameters_distributionChoice_multicast

} ASNH245NetworkAccessParameters_distributionChoice;


#define e_ASNH245NetworkAccessParameters_distributionChoiceSize		2
#define e_ASNH245NetworkAccessParameters_distributionChoiceSizeExt	2
typedef struct
{
	ASNH245NetworkAccessParameters_distributionChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NetworkAccessParameters_distribution;
HS_RESULT new_ASNH245NetworkAccessParameters_distribution( void *pObject );
HS_RESULT delete_ASNH245NetworkAccessParameters_distribution( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NetworkAccessParameters_distribution_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NetworkAccessParameters_distribution_SetChoice( void *pObject, ASNH245NetworkAccessParameters_distributionChoice pChoice );
HS_RESULT ASNH245NetworkAccessParameters_distribution_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NetworkAccessParameters_distribution_MakeMold( void *pObject );
HS_RESULT ASNH245NetworkAccessParameters_distribution_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NetworkAccessParameters_distribution_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NetworkAccessParameters_networkAddressChoice_q2931Address,
	e_ASNH245NetworkAccessParameters_networkAddressChoice_e164Address,
	e_ASNH245NetworkAccessParameters_networkAddressChoice_localAreaAddress

} ASNH245NetworkAccessParameters_networkAddressChoice;


#define e_ASNH245NetworkAccessParameters_networkAddressChoiceSize		3
#define e_ASNH245NetworkAccessParameters_networkAddressChoiceSizeExt	3
typedef struct
{
	ASNH245NetworkAccessParameters_networkAddressChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NetworkAccessParameters_networkAddress;
HS_RESULT new_ASNH245NetworkAccessParameters_networkAddress( void *pObject );
HS_RESULT delete_ASNH245NetworkAccessParameters_networkAddress( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NetworkAccessParameters_networkAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NetworkAccessParameters_networkAddress_SetChoice( void *pObject, ASNH245NetworkAccessParameters_networkAddressChoice pChoice );
HS_RESULT ASNH245NetworkAccessParameters_networkAddress_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NetworkAccessParameters_networkAddress_MakeMold( void *pObject );
HS_RESULT ASNH245NetworkAccessParameters_networkAddress_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NetworkAccessParameters_networkAddress_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_originateCall,
	e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_waitForCall,
	e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_issueQuery

} ASNH245NetworkAccessParameters_t120SetupProcedureChoice;


#define e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSize		3
#define e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSizeExt	3
typedef struct
{
	ASNH245NetworkAccessParameters_t120SetupProcedureChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NetworkAccessParameters_t120SetupProcedure;
HS_RESULT new_ASNH245NetworkAccessParameters_t120SetupProcedure( void *pObject );
HS_RESULT delete_ASNH245NetworkAccessParameters_t120SetupProcedure( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NetworkAccessParameters_t120SetupProcedure_SetChoice( void *pObject, ASNH245NetworkAccessParameters_t120SetupProcedureChoice pChoice );
HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_MakeMold( void *pObject );
HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NetworkAccessParametersOptionMap_distribution,
	e_ASNH245NetworkAccessParametersOptionMap_externalReference
,
	e_ASNH245NetworkAccessParametersOptionMap_t120SetupProcedure
} ASNH245NetworkAccessParametersOptionMap;


#define e_ASNH245NetworkAccessParametersOptionMapSize 2
#define e_ASNH245NetworkAccessParametersOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245NetworkAccessParameters_distribution m_distribution;
	ASNH245NetworkAccessParameters_networkAddress m_networkAddress;
	AsnBoolean m_associateConference;
	AsnOctetString m_externalReference;
	/*...,*/
	ASNH245NetworkAccessParameters_t120SetupProcedure m_t120SetupProcedure;
} ASNH245NetworkAccessParameters;
HS_RESULT new_ASNH245NetworkAccessParameters( void *pObject );
HS_RESULT delete_ASNH245NetworkAccessParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NetworkAccessParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NetworkAccessParameters_IncludeOptionField( void *pObject, ASNH245NetworkAccessParametersOptionMap pOptionMap );
BOOL	  ASNH245NetworkAccessParameters_IsIncludeOptionField( void *pObject, ASNH245NetworkAccessParametersOptionMap pOptionMap );
HS_RESULT ASNH245NetworkAccessParameters_MakeMold( void *pObject );
HS_RESULT ASNH245NetworkAccessParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NetworkAccessParameters_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245EscrowDataOptionMapSize 0
#define e_ASNH245EscrowDataOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnObjectIdentifier m_escrowID;
	AsnBitString m_escrowValue;
	/*...,*/
} ASNH245EscrowData;
HS_RESULT new_ASNH245EscrowData( void *pObject );
HS_RESULT delete_ASNH245EscrowData( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EscrowData_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245EscrowData_MakeMold( void *pObject );
HS_RESULT ASNH245EscrowData_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EscrowData_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EncryptionSyncOptionMap_nonStandard,
	e_ASNH245EncryptionSyncOptionMap_escrowentry

} ASNH245EncryptionSyncOptionMap;


#define e_ASNH245EncryptionSyncOptionMapSize 2
#define e_ASNH245EncryptionSyncOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245NonStandardParameter m_nonStandard;
	AsnInteger m_synchFlag;
	AsnOctetString m_h235Key;
	AsnSequenceOf m_escrowentry;
	/*...,*/
} ASNH245EncryptionSync;
HS_RESULT new_ASNH245EncryptionSync( void *pObject );
HS_RESULT delete_ASNH245EncryptionSync( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EncryptionSync_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245EncryptionSync_IncludeOptionField( void *pObject, ASNH245EncryptionSyncOptionMap pOptionMap );
BOOL	  ASNH245EncryptionSync_IsIncludeOptionField( void *pObject, ASNH245EncryptionSyncOptionMap pOptionMap );
HS_RESULT ASNH245EncryptionSync_MakeMold( void *pObject );
HS_RESULT ASNH245EncryptionSync_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EncryptionSync_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannelOptionMap_reverseLogicalChannelParameters
,
	e_ASNH245OpenLogicalChannelOptionMap_separateStack,
	e_ASNH245OpenLogicalChannelOptionMap_encryptionSync
} ASNH245OpenLogicalChannelOptionMap;


#define e_ASNH245OpenLogicalChannelOptionMapSize 1
#define e_ASNH245OpenLogicalChannelOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters m_forwardLogicalChannelParameters;
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters m_reverseLogicalChannelParameters;
	/*...,*/
	ASNH245NetworkAccessParameters m_separateStack;
	ASNH245EncryptionSync m_encryptionSync;
} ASNH245OpenLogicalChannel;
HS_RESULT new_ASNH245OpenLogicalChannel( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannel( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannel_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245OpenLogicalChannel_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannelOptionMap pOptionMap );
BOOL	  ASNH245OpenLogicalChannel_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannelOptionMap pOptionMap );
HS_RESULT ASNH245OpenLogicalChannel_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannel_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannel_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CloseLogicalChannel_sourceChoice_user,
	e_ASNH245CloseLogicalChannel_sourceChoice_lcse
} ASNH245CloseLogicalChannel_sourceChoice;


#define e_ASNH245CloseLogicalChannel_sourceChoiceSize		2
#define e_ASNH245CloseLogicalChannel_sourceChoiceSizeExt	2
typedef struct
{
	ASNH245CloseLogicalChannel_sourceChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245CloseLogicalChannel_source;
HS_RESULT new_ASNH245CloseLogicalChannel_source( void *pObject );
HS_RESULT delete_ASNH245CloseLogicalChannel_source( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CloseLogicalChannel_source_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245CloseLogicalChannel_source_SetChoice( void *pObject, ASNH245CloseLogicalChannel_sourceChoice pChoice );
HS_RESULT ASNH245CloseLogicalChannel_source_DeleteAlternation( void *pObject );
HS_RESULT ASNH245CloseLogicalChannel_source_MakeMold( void *pObject );
HS_RESULT ASNH245CloseLogicalChannel_source_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CloseLogicalChannel_source_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CloseLogicalChannel_reasonChoice_unknown,
	e_ASNH245CloseLogicalChannel_reasonChoice_reopen,
	e_ASNH245CloseLogicalChannel_reasonChoice_reservationFailure

} ASNH245CloseLogicalChannel_reasonChoice;


#define e_ASNH245CloseLogicalChannel_reasonChoiceSize		3
#define e_ASNH245CloseLogicalChannel_reasonChoiceSizeExt	3
typedef struct
{
	ASNH245CloseLogicalChannel_reasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245CloseLogicalChannel_reason;
HS_RESULT new_ASNH245CloseLogicalChannel_reason( void *pObject );
HS_RESULT delete_ASNH245CloseLogicalChannel_reason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CloseLogicalChannel_reason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245CloseLogicalChannel_reason_SetChoice( void *pObject, ASNH245CloseLogicalChannel_reasonChoice pChoice );
HS_RESULT ASNH245CloseLogicalChannel_reason_DeleteAlternation( void *pObject );
HS_RESULT ASNH245CloseLogicalChannel_reason_MakeMold( void *pObject );
HS_RESULT ASNH245CloseLogicalChannel_reason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CloseLogicalChannel_reason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245CloseLogicalChannelOptionMap_reason
} ASNH245CloseLogicalChannelOptionMap;


#define e_ASNH245CloseLogicalChannelOptionMapSize 0
#define e_ASNH245CloseLogicalChannelOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	ASNH245CloseLogicalChannel_source m_source;
	/*...,*/
	ASNH245CloseLogicalChannel_reason m_reason;
} ASNH245CloseLogicalChannel;
HS_RESULT new_ASNH245CloseLogicalChannel( void *pObject );
HS_RESULT delete_ASNH245CloseLogicalChannel( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CloseLogicalChannel_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CloseLogicalChannel_IncludeOptionField( void *pObject, ASNH245CloseLogicalChannelOptionMap pOptionMap );
BOOL	  ASNH245CloseLogicalChannel_IsIncludeOptionField( void *pObject, ASNH245CloseLogicalChannelOptionMap pOptionMap );
HS_RESULT ASNH245CloseLogicalChannel_MakeMold( void *pObject );
HS_RESULT ASNH245CloseLogicalChannel_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CloseLogicalChannel_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RequestChannelClose_reasonChoice_unknown,
	e_ASNH245RequestChannelClose_reasonChoice_normal,
	e_ASNH245RequestChannelClose_reasonChoice_reopen,
	e_ASNH245RequestChannelClose_reasonChoice_reservationFailure

} ASNH245RequestChannelClose_reasonChoice;


#define e_ASNH245RequestChannelClose_reasonChoiceSize		4
#define e_ASNH245RequestChannelClose_reasonChoiceSizeExt	4
typedef struct
{
	ASNH245RequestChannelClose_reasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RequestChannelClose_reason;
HS_RESULT new_ASNH245RequestChannelClose_reason( void *pObject );
HS_RESULT delete_ASNH245RequestChannelClose_reason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestChannelClose_reason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RequestChannelClose_reason_SetChoice( void *pObject, ASNH245RequestChannelClose_reasonChoice pChoice );
HS_RESULT ASNH245RequestChannelClose_reason_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RequestChannelClose_reason_MakeMold( void *pObject );
HS_RESULT ASNH245RequestChannelClose_reason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestChannelClose_reason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245RequestChannelCloseOptionMap_qosCapability,
	e_ASNH245RequestChannelCloseOptionMap_reason
} ASNH245RequestChannelCloseOptionMap;


#define e_ASNH245RequestChannelCloseOptionMapSize 0
#define e_ASNH245RequestChannelCloseOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	/*...,*/
	ASNH245QOSCapability m_qosCapability;
	ASNH245RequestChannelClose_reason m_reason;
} ASNH245RequestChannelClose;
HS_RESULT new_ASNH245RequestChannelClose( void *pObject );
HS_RESULT delete_ASNH245RequestChannelClose( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestChannelClose_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestChannelClose_IncludeOptionField( void *pObject, ASNH245RequestChannelCloseOptionMap pOptionMap );
BOOL	  ASNH245RequestChannelClose_IsIncludeOptionField( void *pObject, ASNH245RequestChannelCloseOptionMap pOptionMap );
HS_RESULT ASNH245RequestChannelClose_MakeMold( void *pObject );
HS_RESULT ASNH245RequestChannelClose_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestChannelClose_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultiplexElement_typeChoice_logicalChannelNumber,
	e_ASNH245MultiplexElement_typeChoice_subElementList
} ASNH245MultiplexElement_typeChoice;


#define e_ASNH245MultiplexElement_typeChoiceSize		2
#define e_ASNH245MultiplexElement_typeChoiceSizeExt	2
typedef struct
{
	ASNH245MultiplexElement_typeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultiplexElement_type;
HS_RESULT new_ASNH245MultiplexElement_type( void *pObject );
HS_RESULT delete_ASNH245MultiplexElement_type( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexElement_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultiplexElement_type_SetChoice( void *pObject, ASNH245MultiplexElement_typeChoice pChoice );
HS_RESULT ASNH245MultiplexElement_type_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultiplexElement_type_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexElement_type_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexElement_type_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultiplexElement_repeatCountChoice_finite,
	e_ASNH245MultiplexElement_repeatCountChoice_untilClosingFlag
} ASNH245MultiplexElement_repeatCountChoice;


#define e_ASNH245MultiplexElement_repeatCountChoiceSize		2
#define e_ASNH245MultiplexElement_repeatCountChoiceSizeExt	2
typedef struct
{
	ASNH245MultiplexElement_repeatCountChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultiplexElement_repeatCount;
HS_RESULT new_ASNH245MultiplexElement_repeatCount( void *pObject );
HS_RESULT delete_ASNH245MultiplexElement_repeatCount( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexElement_repeatCount_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultiplexElement_repeatCount_SetChoice( void *pObject, ASNH245MultiplexElement_repeatCountChoice pChoice );
HS_RESULT ASNH245MultiplexElement_repeatCount_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultiplexElement_repeatCount_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexElement_repeatCount_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexElement_repeatCount_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultiplexElementOptionMapSize 0
#define e_ASNH245MultiplexElementOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MultiplexElement_type m_type;
	ASNH245MultiplexElement_repeatCount m_repeatCount;
} ASNH245MultiplexElement;
HS_RESULT new_ASNH245MultiplexElement( void *pObject );
HS_RESULT delete_ASNH245MultiplexElement( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexElement_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexElement_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexElement_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexElement_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultiplexEntryDescriptorOptionMap_elementList
} ASNH245MultiplexEntryDescriptorOptionMap;


#define e_ASNH245MultiplexEntryDescriptorOptionMapSize 1
#define e_ASNH245MultiplexEntryDescriptorOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245MultiplexTableEntryNumber m_multiplexTableEntryNumber;
	AsnSequenceOf m_elementList;
} ASNH245MultiplexEntryDescriptor;
HS_RESULT new_ASNH245MultiplexEntryDescriptor( void *pObject );
HS_RESULT delete_ASNH245MultiplexEntryDescriptor( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexEntryDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexEntryDescriptor_IncludeOptionField( void *pObject, ASNH245MultiplexEntryDescriptorOptionMap pOptionMap );
BOOL	  ASNH245MultiplexEntryDescriptor_IsIncludeOptionField( void *pObject, ASNH245MultiplexEntryDescriptorOptionMap pOptionMap );
HS_RESULT ASNH245MultiplexEntryDescriptor_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexEntryDescriptor_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexEntryDescriptor_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultiplexEntrySendOptionMapSize 0
#define e_ASNH245MultiplexEntrySendOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	AsnSequenceOf m_multiplexEntryDescriptors;
	/*...,*/
} ASNH245MultiplexEntrySend;
HS_RESULT new_ASNH245MultiplexEntrySend( void *pObject );
HS_RESULT delete_ASNH245MultiplexEntrySend( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexEntrySend_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexEntrySend_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexEntrySend_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexEntrySend_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestMultiplexEntryOptionMapSize 0
#define e_ASNH245RequestMultiplexEntryOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_entryNumbers;
	/*...,*/
} ASNH245RequestMultiplexEntry;
HS_RESULT new_ASNH245RequestMultiplexEntry( void *pObject );
HS_RESULT delete_ASNH245RequestMultiplexEntry( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestMultiplexEntry_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestMultiplexEntry_MakeMold( void *pObject );
HS_RESULT ASNH245RequestMultiplexEntry_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestMultiplexEntry_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestModeOptionMapSize 0
#define e_ASNH245RequestModeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	AsnSequenceOf m_requestedModes;
	/*...,*/
} ASNH245RequestMode;
HS_RESULT new_ASNH245RequestMode( void *pObject );
HS_RESULT delete_ASNH245RequestMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestMode_MakeMold( void *pObject );
HS_RESULT ASNH245RequestMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestMode_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RoundTripDelayRequestOptionMapSize 0
#define e_ASNH245RoundTripDelayRequestOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	/*...,*/
} ASNH245RoundTripDelayRequest;
HS_RESULT new_ASNH245RoundTripDelayRequest( void *pObject );
HS_RESULT delete_ASNH245RoundTripDelayRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RoundTripDelayRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RoundTripDelayRequest_MakeMold( void *pObject );
HS_RESULT ASNH245RoundTripDelayRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RoundTripDelayRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MaintenanceLoopRequest_typeChoice_systemLoop,
	e_ASNH245MaintenanceLoopRequest_typeChoice_mediaLoop,
	e_ASNH245MaintenanceLoopRequest_typeChoice_logicalChannelLoop

} ASNH245MaintenanceLoopRequest_typeChoice;


#define e_ASNH245MaintenanceLoopRequest_typeChoiceSize		3
#define e_ASNH245MaintenanceLoopRequest_typeChoiceSizeExt	3
typedef struct
{
	ASNH245MaintenanceLoopRequest_typeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MaintenanceLoopRequest_type;
HS_RESULT new_ASNH245MaintenanceLoopRequest_type( void *pObject );
HS_RESULT delete_ASNH245MaintenanceLoopRequest_type( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaintenanceLoopRequest_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MaintenanceLoopRequest_type_SetChoice( void *pObject, ASNH245MaintenanceLoopRequest_typeChoice pChoice );
HS_RESULT ASNH245MaintenanceLoopRequest_type_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MaintenanceLoopRequest_type_MakeMold( void *pObject );
HS_RESULT ASNH245MaintenanceLoopRequest_type_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MaintenanceLoopRequest_type_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MaintenanceLoopRequestOptionMapSize 0
#define e_ASNH245MaintenanceLoopRequestOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MaintenanceLoopRequest_type m_type;
	/*...,*/
} ASNH245MaintenanceLoopRequest;
HS_RESULT new_ASNH245MaintenanceLoopRequest( void *pObject );
HS_RESULT delete_ASNH245MaintenanceLoopRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaintenanceLoopRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MaintenanceLoopRequest_MakeMold( void *pObject );
HS_RESULT ASNH245MaintenanceLoopRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MaintenanceLoopRequest_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245CommunicationModeRequestOptionMapSize 0
#define e_ASNH245CommunicationModeRequestOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	/*...,*/
} ASNH245CommunicationModeRequest;
HS_RESULT new_ASNH245CommunicationModeRequest( void *pObject );
HS_RESULT delete_ASNH245CommunicationModeRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CommunicationModeRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CommunicationModeRequest_MakeMold( void *pObject );
HS_RESULT ASNH245CommunicationModeRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CommunicationModeRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_terminalLabel,
	e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_certSelectionCriteria,
	e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_sRandom

} ASNH245ConferenceRequest_requestTerminalCertificateOptionMap;


#define e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMapSize 3
#define e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245TerminalLabel m_terminalLabel;
	ASNH245CertSelectionCriteria m_certSelectionCriteria;
	AsnInteger m_sRandom;
	/*...,*/
} ASNH245ConferenceRequest_requestTerminalCertificate;
HS_RESULT new_ASNH245ConferenceRequest_requestTerminalCertificate( void *pObject );
HS_RESULT delete_ASNH245ConferenceRequest_requestTerminalCertificate( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_IncludeOptionField( void *pObject, ASNH245ConferenceRequest_requestTerminalCertificateOptionMap pOptionMap );
BOOL	  ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( void *pObject, ASNH245ConferenceRequest_requestTerminalCertificateOptionMap pOptionMap );
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RemoteMCRequestChoice_masterActivate,
	e_ASNH245RemoteMCRequestChoice_slaveActivate,
	e_ASNH245RemoteMCRequestChoice_deActivate

} ASNH245RemoteMCRequestChoice;


#define e_ASNH245RemoteMCRequestChoiceSize		3
#define e_ASNH245RemoteMCRequestChoiceSizeExt	3
typedef struct
{
	ASNH245RemoteMCRequestChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RemoteMCRequest;
HS_RESULT new_ASNH245RemoteMCRequest( void *pObject );
HS_RESULT delete_ASNH245RemoteMCRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RemoteMCRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RemoteMCRequest_SetChoice( void *pObject, ASNH245RemoteMCRequestChoice pChoice );
HS_RESULT ASNH245RemoteMCRequest_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RemoteMCRequest_MakeMold( void *pObject );
HS_RESULT ASNH245RemoteMCRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RemoteMCRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceRequestChoice_terminalListRequest,
	e_ASNH245ConferenceRequestChoice_makeMeChair,
	e_ASNH245ConferenceRequestChoice_cancelMakeMeChair,
	e_ASNH245ConferenceRequestChoice_dropTerminal,
	e_ASNH245ConferenceRequestChoice_requestTerminalID,
	e_ASNH245ConferenceRequestChoice_enterH243Password,
	e_ASNH245ConferenceRequestChoice_enterH243TerminalID,
	e_ASNH245ConferenceRequestChoice_enterH243ConferenceID
,
	e_ASNH245ConferenceRequestChoice_enterExtensionAddress,
	e_ASNH245ConferenceRequestChoice_requestChairTokenOwner,
	e_ASNH245ConferenceRequestChoice_requestTerminalCertificate,
	e_ASNH245ConferenceRequestChoice_broadcastMyLogicalChannel,
	e_ASNH245ConferenceRequestChoice_makeTerminalBroadcaster,
	e_ASNH245ConferenceRequestChoice_sendThisSource,
	e_ASNH245ConferenceRequestChoice_requestAllTerminalIDs,
	e_ASNH245ConferenceRequestChoice_remoteMCRequest
} ASNH245ConferenceRequestChoice;


#define e_ASNH245ConferenceRequestChoiceSize		8
#define e_ASNH245ConferenceRequestChoiceSizeExt	16
typedef struct
{
	ASNH245ConferenceRequestChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ConferenceRequest;
HS_RESULT new_ASNH245ConferenceRequest( void *pObject );
HS_RESULT delete_ASNH245ConferenceRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ConferenceRequest_SetChoice( void *pObject, ASNH245ConferenceRequestChoice pChoice );
HS_RESULT ASNH245ConferenceRequest_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ConferenceRequest_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceRequest_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkRequest_callInformationOptionMapSize 0
#define e_ASNH245MultilinkRequest_callInformationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_maxNumberOfAdditionalConnections;
	/*...,*/
} ASNH245MultilinkRequest_callInformation;
HS_RESULT new_ASNH245MultilinkRequest_callInformation( void *pObject );
HS_RESULT delete_ASNH245MultilinkRequest_callInformation( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkRequest_callInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkRequest_callInformation_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkRequest_callInformation_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkRequest_callInformation_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245DialingInformationNetworkTypeChoice_nonStandard,
	e_ASNH245DialingInformationNetworkTypeChoice_n_isdn,
	e_ASNH245DialingInformationNetworkTypeChoice_gstn
,
	e_ASNH245DialingInformationNetworkTypeChoice_mobile
} ASNH245DialingInformationNetworkTypeChoice;


#define e_ASNH245DialingInformationNetworkTypeChoiceSize		3
#define e_ASNH245DialingInformationNetworkTypeChoiceSizeExt	4
typedef struct
{
	ASNH245DialingInformationNetworkTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245DialingInformationNetworkType;
HS_RESULT new_ASNH245DialingInformationNetworkType( void *pObject );
HS_RESULT delete_ASNH245DialingInformationNetworkType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DialingInformationNetworkType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245DialingInformationNetworkType_SetChoice( void *pObject, ASNH245DialingInformationNetworkTypeChoice pChoice );
HS_RESULT ASNH245DialingInformationNetworkType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245DialingInformationNetworkType_MakeMold( void *pObject );
HS_RESULT ASNH245DialingInformationNetworkType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DialingInformationNetworkType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245DialingInformationNumberOptionMap_subAddress

} ASNH245DialingInformationNumberOptionMap;


#define e_ASNH245DialingInformationNumberOptionMapSize 1
#define e_ASNH245DialingInformationNumberOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSingleString m_networkAddress;
	AsnSingleString m_subAddress;
	AsnSequenceOf m_networkType;
	/*...,*/
} ASNH245DialingInformationNumber;
HS_RESULT new_ASNH245DialingInformationNumber( void *pObject );
HS_RESULT delete_ASNH245DialingInformationNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DialingInformationNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245DialingInformationNumber_IncludeOptionField( void *pObject, ASNH245DialingInformationNumberOptionMap pOptionMap );
BOOL	  ASNH245DialingInformationNumber_IsIncludeOptionField( void *pObject, ASNH245DialingInformationNumberOptionMap pOptionMap );
HS_RESULT ASNH245DialingInformationNumber_MakeMold( void *pObject );
HS_RESULT ASNH245DialingInformationNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DialingInformationNumber_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245DialingInformationChoice_nonStandard,
	e_ASNH245DialingInformationChoice_differential,
	e_ASNH245DialingInformationChoice_infoNotAvailable

} ASNH245DialingInformationChoice;


#define e_ASNH245DialingInformationChoiceSize		3
#define e_ASNH245DialingInformationChoiceSizeExt	3
typedef struct
{
	ASNH245DialingInformationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245DialingInformation;
HS_RESULT new_ASNH245DialingInformation( void *pObject );
HS_RESULT delete_ASNH245DialingInformation( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DialingInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245DialingInformation_SetChoice( void *pObject, ASNH245DialingInformationChoice pChoice );
HS_RESULT ASNH245DialingInformation_DeleteAlternation( void *pObject );
HS_RESULT ASNH245DialingInformation_MakeMold( void *pObject );
HS_RESULT ASNH245DialingInformation_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DialingInformation_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkRequest_addConnectionOptionMapSize 0
#define e_ASNH245MultilinkRequest_addConnectionOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	ASNH245DialingInformation m_dialingInformation;
	/*...,*/
} ASNH245MultilinkRequest_addConnection;
HS_RESULT new_ASNH245MultilinkRequest_addConnection( void *pObject );
HS_RESULT delete_ASNH245MultilinkRequest_addConnection( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkRequest_addConnection_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkRequest_addConnection_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkRequest_addConnection_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkRequest_addConnection_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245ConnectionIdentifierOptionMapSize 0
#define e_ASNH245ConnectionIdentifierOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_channelTag;
	AsnInteger m_sequenceNumber;
	/*...,*/
} ASNH245ConnectionIdentifier;
HS_RESULT new_ASNH245ConnectionIdentifier( void *pObject );
HS_RESULT delete_ASNH245ConnectionIdentifier( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConnectionIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConnectionIdentifier_MakeMold( void *pObject );
HS_RESULT ASNH245ConnectionIdentifier_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConnectionIdentifier_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkRequest_removeConnectionOptionMapSize 0
#define e_ASNH245MultilinkRequest_removeConnectionOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245ConnectionIdentifier m_connectionIdentifier;
	/*...,*/
} ASNH245MultilinkRequest_removeConnection;
HS_RESULT new_ASNH245MultilinkRequest_removeConnection( void *pObject );
HS_RESULT delete_ASNH245MultilinkRequest_removeConnection( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkRequest_removeConnection_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkRequest_removeConnection_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkRequest_removeConnection_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkRequest_removeConnection_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_currentIntervalInformation,
	e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_requestedInterval

} ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice;


#define e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSize		2
#define e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSizeExt	2
typedef struct
{
	ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultilinkRequest_maximumHeaderInterval_requestType;
HS_RESULT new_ASNH245MultilinkRequest_maximumHeaderInterval_requestType( void *pObject );
HS_RESULT delete_ASNH245MultilinkRequest_maximumHeaderInterval_requestType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultilinkRequest_maximumHeaderInterval_requestType_SetChoice( void *pObject, ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice pChoice );
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkRequest_maximumHeaderIntervalOptionMapSize 0
#define e_ASNH245MultilinkRequest_maximumHeaderIntervalOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MultilinkRequest_maximumHeaderInterval_requestType m_requestType;
	/*...,*/
} ASNH245MultilinkRequest_maximumHeaderInterval;
HS_RESULT new_ASNH245MultilinkRequest_maximumHeaderInterval( void *pObject );
HS_RESULT delete_ASNH245MultilinkRequest_maximumHeaderInterval( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultilinkRequestChoice_nonStandard,
	e_ASNH245MultilinkRequestChoice_callInformation,
	e_ASNH245MultilinkRequestChoice_addConnection,
	e_ASNH245MultilinkRequestChoice_removeConnection,
	e_ASNH245MultilinkRequestChoice_maximumHeaderInterval

} ASNH245MultilinkRequestChoice;


#define e_ASNH245MultilinkRequestChoiceSize		5
#define e_ASNH245MultilinkRequestChoiceSizeExt	5
typedef struct
{
	ASNH245MultilinkRequestChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultilinkRequest;
HS_RESULT new_ASNH245MultilinkRequest( void *pObject );
HS_RESULT delete_ASNH245MultilinkRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultilinkRequest_SetChoice( void *pObject, ASNH245MultilinkRequestChoice pChoice );
HS_RESULT ASNH245MultilinkRequest_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultilinkRequest_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkRequest_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245LogicalChannelRateRequestOptionMapSize 0
#define e_ASNH245LogicalChannelRateRequestOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	ASNH245LogicalChannelNumber m_logicalChannelNumber;
	ASNH245MaximumBitRate m_maximumBitRate;
	/*...,*/
} ASNH245LogicalChannelRateRequest;
HS_RESULT new_ASNH245LogicalChannelRateRequest( void *pObject );
HS_RESULT delete_ASNH245LogicalChannelRateRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245LogicalChannelRateRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245LogicalChannelRateRequest_MakeMold( void *pObject );
HS_RESULT ASNH245LogicalChannelRateRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245LogicalChannelRateRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RequestMessageChoice_nonStandard,
	e_ASNH245RequestMessageChoice_masterSlaveDetermination,
	e_ASNH245RequestMessageChoice_terminalCapabilitySet,
	e_ASNH245RequestMessageChoice_openLogicalChannel,
	e_ASNH245RequestMessageChoice_closeLogicalChannel,
	e_ASNH245RequestMessageChoice_requestChannelClose,
	e_ASNH245RequestMessageChoice_multiplexEntrySend,
	e_ASNH245RequestMessageChoice_requestMultiplexEntry,
	e_ASNH245RequestMessageChoice_requestMode,
	e_ASNH245RequestMessageChoice_roundTripDelayRequest,
	e_ASNH245RequestMessageChoice_maintenanceLoopRequest
,
	e_ASNH245RequestMessageChoice_communicationModeRequest,
	e_ASNH245RequestMessageChoice_conferenceRequest,
	e_ASNH245RequestMessageChoice_multilinkRequest,
	e_ASNH245RequestMessageChoice_logicalChannelRateRequest
} ASNH245RequestMessageChoice;


#define e_ASNH245RequestMessageChoiceSize		11
#define e_ASNH245RequestMessageChoiceSizeExt	15
typedef struct
{
	ASNH245RequestMessageChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RequestMessage;
HS_RESULT new_ASNH245RequestMessage( void *pObject );
HS_RESULT delete_ASNH245RequestMessage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RequestMessage_SetChoice( void *pObject, ASNH245RequestMessageChoice pChoice );
HS_RESULT ASNH245RequestMessage_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RequestMessage_MakeMold( void *pObject );
HS_RESULT ASNH245RequestMessage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestMessage_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MasterSlaveDeterminationAck_decisionChoice_master,
	e_ASNH245MasterSlaveDeterminationAck_decisionChoice_slave
} ASNH245MasterSlaveDeterminationAck_decisionChoice;


#define e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSize		2
#define e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSizeExt	2
typedef struct
{
	ASNH245MasterSlaveDeterminationAck_decisionChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MasterSlaveDeterminationAck_decision;
HS_RESULT new_ASNH245MasterSlaveDeterminationAck_decision( void *pObject );
HS_RESULT delete_ASNH245MasterSlaveDeterminationAck_decision( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MasterSlaveDeterminationAck_decision_SetChoice( void *pObject, ASNH245MasterSlaveDeterminationAck_decisionChoice pChoice );
HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_MakeMold( void *pObject );
HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MasterSlaveDeterminationAckOptionMapSize 0
#define e_ASNH245MasterSlaveDeterminationAckOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MasterSlaveDeterminationAck_decision m_decision;
	/*...,*/
} ASNH245MasterSlaveDeterminationAck;
HS_RESULT new_ASNH245MasterSlaveDeterminationAck( void *pObject );
HS_RESULT delete_ASNH245MasterSlaveDeterminationAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MasterSlaveDeterminationAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MasterSlaveDeterminationAck_MakeMold( void *pObject );
HS_RESULT ASNH245MasterSlaveDeterminationAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MasterSlaveDeterminationAck_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MasterSlaveDeterminationReject_causeChoice_identicalNumbers

} ASNH245MasterSlaveDeterminationReject_causeChoice;


#define e_ASNH245MasterSlaveDeterminationReject_causeChoiceSize		1
#define e_ASNH245MasterSlaveDeterminationReject_causeChoiceSizeExt	1
typedef struct
{
	ASNH245MasterSlaveDeterminationReject_causeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MasterSlaveDeterminationReject_cause;
HS_RESULT new_ASNH245MasterSlaveDeterminationReject_cause( void *pObject );
HS_RESULT delete_ASNH245MasterSlaveDeterminationReject_cause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MasterSlaveDeterminationReject_cause_SetChoice( void *pObject, ASNH245MasterSlaveDeterminationReject_causeChoice pChoice );
HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_MakeMold( void *pObject );
HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MasterSlaveDeterminationRejectOptionMapSize 0
#define e_ASNH245MasterSlaveDeterminationRejectOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MasterSlaveDeterminationReject_cause m_cause;
	/*...,*/
} ASNH245MasterSlaveDeterminationReject;
HS_RESULT new_ASNH245MasterSlaveDeterminationReject( void *pObject );
HS_RESULT delete_ASNH245MasterSlaveDeterminationReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MasterSlaveDeterminationReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MasterSlaveDeterminationReject_MakeMold( void *pObject );
HS_RESULT ASNH245MasterSlaveDeterminationReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MasterSlaveDeterminationReject_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245TerminalCapabilitySetAckOptionMapSize 0
#define e_ASNH245TerminalCapabilitySetAckOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	/*...,*/
} ASNH245TerminalCapabilitySetAck;
HS_RESULT new_ASNH245TerminalCapabilitySetAck( void *pObject );
HS_RESULT delete_ASNH245TerminalCapabilitySetAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalCapabilitySetAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TerminalCapabilitySetAck_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalCapabilitySetAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalCapabilitySetAck_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_highestEntryNumberProcessed,
	e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_noneProcessed
} ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice;


#define e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSize		2
#define e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSizeExt	2
typedef struct
{
	ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded;
HS_RESULT new_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded( void *pObject );
HS_RESULT delete_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_SetChoice( void *pObject, ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice pChoice );
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_DeleteAlternation( void *pObject );
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245TerminalCapabilitySetReject_causeChoice_unspecified,
	e_ASNH245TerminalCapabilitySetReject_causeChoice_undefinedTableEntryUsed,
	e_ASNH245TerminalCapabilitySetReject_causeChoice_descriptorCapacityExceeded,
	e_ASNH245TerminalCapabilitySetReject_causeChoice_tableEntryCapacityExceeded

} ASNH245TerminalCapabilitySetReject_causeChoice;


#define e_ASNH245TerminalCapabilitySetReject_causeChoiceSize		4
#define e_ASNH245TerminalCapabilitySetReject_causeChoiceSizeExt	4
typedef struct
{
	ASNH245TerminalCapabilitySetReject_causeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245TerminalCapabilitySetReject_cause;
HS_RESULT new_ASNH245TerminalCapabilitySetReject_cause( void *pObject );
HS_RESULT delete_ASNH245TerminalCapabilitySetReject_cause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245TerminalCapabilitySetReject_cause_SetChoice( void *pObject, ASNH245TerminalCapabilitySetReject_causeChoice pChoice );
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_DeleteAlternation( void *pObject );
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245TerminalCapabilitySetRejectOptionMapSize 0
#define e_ASNH245TerminalCapabilitySetRejectOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	ASNH245TerminalCapabilitySetReject_cause m_cause;
	/*...,*/
} ASNH245TerminalCapabilitySetReject;
HS_RESULT new_ASNH245TerminalCapabilitySetReject( void *pObject );
HS_RESULT delete_ASNH245TerminalCapabilitySetReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalCapabilitySetReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TerminalCapabilitySetReject_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalCapabilitySetReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalCapabilitySetReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters
,
	e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters
} ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice;


#define e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSize		1
#define e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt	2
typedef struct
{
	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters;
HS_RESULT new_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_SetChoice( void *pObject, ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice pChoice );
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_portNumber,
	e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_multiplexParameters
,
	e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_replacementFor
} ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap;


#define e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSize 2
#define e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_reverseLogicalChannelNumber;
	AsnInteger m_portNumber;
	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters m_multiplexParameters;
	/*...,*/
	ASNH245LogicalChannelNumber m_replacementFor;
} ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters;
HS_RESULT new_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap pOptionMap );
BOOL	  ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap pOptionMap );
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H2250LogicalChannelAckParametersOptionMap_nonStandard,
	e_ASNH245H2250LogicalChannelAckParametersOptionMap_sessionID,
	e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaChannel,
	e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaControlChannel,
	e_ASNH245H2250LogicalChannelAckParametersOptionMap_dynamicRTPPayloadType
,
	e_ASNH245H2250LogicalChannelAckParametersOptionMap_flowControlToZero,
	e_ASNH245H2250LogicalChannelAckParametersOptionMap_portNumber
} ASNH245H2250LogicalChannelAckParametersOptionMap;


#define e_ASNH245H2250LogicalChannelAckParametersOptionMapSize 5
#define e_ASNH245H2250LogicalChannelAckParametersOptionMapSizeExt 7
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_nonStandard;
	AsnInteger m_sessionID;
	ASNH245TransportAddress m_mediaChannel;
	ASNH245TransportAddress m_mediaControlChannel;
	AsnInteger m_dynamicRTPPayloadType;
	/*...,*/
	AsnBoolean m_flowControlToZero;
	AsnInteger m_portNumber;
} ASNH245H2250LogicalChannelAckParameters;
HS_RESULT new_ASNH245H2250LogicalChannelAckParameters( void *pObject );
HS_RESULT delete_ASNH245H2250LogicalChannelAckParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H2250LogicalChannelAckParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H2250LogicalChannelAckParameters_IncludeOptionField( void *pObject, ASNH245H2250LogicalChannelAckParametersOptionMap pOptionMap );
BOOL	  ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( void *pObject, ASNH245H2250LogicalChannelAckParametersOptionMap pOptionMap );
HS_RESULT ASNH245H2250LogicalChannelAckParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H2250LogicalChannelAckParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H2250LogicalChannelAckParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice_h2250LogicalChannelAckParameters

} ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice;


#define e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSize		1
#define e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSizeExt	1
typedef struct
{
	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters;
HS_RESULT new_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_SetChoice( void *pObject, ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice pChoice );
HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_DeleteAlternation( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannelAckOptionMap_reverseLogicalChannelParameters
,
	e_ASNH245OpenLogicalChannelAckOptionMap_separateStack,
	e_ASNH245OpenLogicalChannelAckOptionMap_forwardMultiplexAckParameters,
	e_ASNH245OpenLogicalChannelAckOptionMap_encryptionSync
} ASNH245OpenLogicalChannelAckOptionMap;


#define e_ASNH245OpenLogicalChannelAckOptionMapSize 1
#define e_ASNH245OpenLogicalChannelAckOptionMapSizeExt 4
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters m_reverseLogicalChannelParameters;
	/*...,*/
	ASNH245NetworkAccessParameters m_separateStack;
	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters m_forwardMultiplexAckParameters;
	ASNH245EncryptionSync m_encryptionSync;
} ASNH245OpenLogicalChannelAck;
HS_RESULT new_ASNH245OpenLogicalChannelAck( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannelAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannelAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245OpenLogicalChannelAck_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannelAckOptionMap pOptionMap );
BOOL	  ASNH245OpenLogicalChannelAck_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannelAckOptionMap pOptionMap );
HS_RESULT ASNH245OpenLogicalChannelAck_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannelAck_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245OpenLogicalChannelReject_causeChoice_unspecified,
	e_ASNH245OpenLogicalChannelReject_causeChoice_unsuitableReverseParameters,
	e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotSupported,
	e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotAvailable,
	e_ASNH245OpenLogicalChannelReject_causeChoice_unknownDataType,
	e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeALCombinationNotSupported
,
	e_ASNH245OpenLogicalChannelReject_causeChoice_multicastChannelNotAllowed,
	e_ASNH245OpenLogicalChannelReject_causeChoice_insufficientBandwidth,
	e_ASNH245OpenLogicalChannelReject_causeChoice_separateStackEstablishmentFailed,
	e_ASNH245OpenLogicalChannelReject_causeChoice_invalidSessionID,
	e_ASNH245OpenLogicalChannelReject_causeChoice_masterSlaveConflict,
	e_ASNH245OpenLogicalChannelReject_causeChoice_waitForCommunicationMode,
	e_ASNH245OpenLogicalChannelReject_causeChoice_invalidDependentChannel,
	e_ASNH245OpenLogicalChannelReject_causeChoice_replacementForRejected
} ASNH245OpenLogicalChannelReject_causeChoice;


#define e_ASNH245OpenLogicalChannelReject_causeChoiceSize		6
#define e_ASNH245OpenLogicalChannelReject_causeChoiceSizeExt	14
typedef struct
{
	ASNH245OpenLogicalChannelReject_causeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245OpenLogicalChannelReject_cause;
HS_RESULT new_ASNH245OpenLogicalChannelReject_cause( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannelReject_cause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannelReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245OpenLogicalChannelReject_cause_SetChoice( void *pObject, ASNH245OpenLogicalChannelReject_causeChoice pChoice );
HS_RESULT ASNH245OpenLogicalChannelReject_cause_DeleteAlternation( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelReject_cause_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelReject_cause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannelReject_cause_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245OpenLogicalChannelRejectOptionMapSize 0
#define e_ASNH245OpenLogicalChannelRejectOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	ASNH245OpenLogicalChannelReject_cause m_cause;
	/*...,*/
} ASNH245OpenLogicalChannelReject;
HS_RESULT new_ASNH245OpenLogicalChannelReject( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannelReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannelReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245OpenLogicalChannelReject_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannelReject_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245CloseLogicalChannelAckOptionMapSize 0
#define e_ASNH245CloseLogicalChannelAckOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	/*...,*/
} ASNH245CloseLogicalChannelAck;
HS_RESULT new_ASNH245CloseLogicalChannelAck( void *pObject );
HS_RESULT delete_ASNH245CloseLogicalChannelAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CloseLogicalChannelAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CloseLogicalChannelAck_MakeMold( void *pObject );
HS_RESULT ASNH245CloseLogicalChannelAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CloseLogicalChannelAck_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestChannelCloseAckOptionMapSize 0
#define e_ASNH245RequestChannelCloseAckOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	/*...,*/
} ASNH245RequestChannelCloseAck;
HS_RESULT new_ASNH245RequestChannelCloseAck( void *pObject );
HS_RESULT delete_ASNH245RequestChannelCloseAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestChannelCloseAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestChannelCloseAck_MakeMold( void *pObject );
HS_RESULT ASNH245RequestChannelCloseAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestChannelCloseAck_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RequestChannelCloseReject_causeChoice_unspecified

} ASNH245RequestChannelCloseReject_causeChoice;


#define e_ASNH245RequestChannelCloseReject_causeChoiceSize		1
#define e_ASNH245RequestChannelCloseReject_causeChoiceSizeExt	1
typedef struct
{
	ASNH245RequestChannelCloseReject_causeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RequestChannelCloseReject_cause;
HS_RESULT new_ASNH245RequestChannelCloseReject_cause( void *pObject );
HS_RESULT delete_ASNH245RequestChannelCloseReject_cause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestChannelCloseReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RequestChannelCloseReject_cause_SetChoice( void *pObject, ASNH245RequestChannelCloseReject_causeChoice pChoice );
HS_RESULT ASNH245RequestChannelCloseReject_cause_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RequestChannelCloseReject_cause_MakeMold( void *pObject );
HS_RESULT ASNH245RequestChannelCloseReject_cause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestChannelCloseReject_cause_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestChannelCloseRejectOptionMapSize 0
#define e_ASNH245RequestChannelCloseRejectOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	ASNH245RequestChannelCloseReject_cause m_cause;
	/*...,*/
} ASNH245RequestChannelCloseReject;
HS_RESULT new_ASNH245RequestChannelCloseReject( void *pObject );
HS_RESULT delete_ASNH245RequestChannelCloseReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestChannelCloseReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestChannelCloseReject_MakeMold( void *pObject );
HS_RESULT ASNH245RequestChannelCloseReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestChannelCloseReject_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultiplexEntrySendAckOptionMapSize 0
#define e_ASNH245MultiplexEntrySendAckOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	AsnSequenceOf m_multiplexTableEntryNumber;
	/*...,*/
} ASNH245MultiplexEntrySendAck;
HS_RESULT new_ASNH245MultiplexEntrySendAck( void *pObject );
HS_RESULT delete_ASNH245MultiplexEntrySendAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexEntrySendAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexEntrySendAck_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexEntrySendAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexEntrySendAck_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause,
	e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_descriptorTooComplex

} ASNH245MultiplexEntryRejectionDescriptions_causeChoice;


#define e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSize		2
#define e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSizeExt	2
typedef struct
{
	ASNH245MultiplexEntryRejectionDescriptions_causeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultiplexEntryRejectionDescriptions_cause;
HS_RESULT new_ASNH245MultiplexEntryRejectionDescriptions_cause( void *pObject );
HS_RESULT delete_ASNH245MultiplexEntryRejectionDescriptions_cause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultiplexEntryRejectionDescriptions_cause_SetChoice( void *pObject, ASNH245MultiplexEntryRejectionDescriptions_causeChoice pChoice );
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultiplexEntryRejectionDescriptionsOptionMapSize 0
#define e_ASNH245MultiplexEntryRejectionDescriptionsOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MultiplexTableEntryNumber m_multiplexTableEntryNumber;
	ASNH245MultiplexEntryRejectionDescriptions_cause m_cause;
	/*...,*/
} ASNH245MultiplexEntryRejectionDescriptions;
HS_RESULT new_ASNH245MultiplexEntryRejectionDescriptions( void *pObject );
HS_RESULT delete_ASNH245MultiplexEntryRejectionDescriptions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultiplexEntrySendRejectOptionMapSize 0
#define e_ASNH245MultiplexEntrySendRejectOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	AsnSequenceOf m_rejectionDescriptions;
	/*...,*/
} ASNH245MultiplexEntrySendReject;
HS_RESULT new_ASNH245MultiplexEntrySendReject( void *pObject );
HS_RESULT delete_ASNH245MultiplexEntrySendReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexEntrySendReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexEntrySendReject_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexEntrySendReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexEntrySendReject_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestMultiplexEntryAckOptionMapSize 0
#define e_ASNH245RequestMultiplexEntryAckOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_entryNumbers;
	/*...,*/
} ASNH245RequestMultiplexEntryAck;
HS_RESULT new_ASNH245RequestMultiplexEntryAck( void *pObject );
HS_RESULT delete_ASNH245RequestMultiplexEntryAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestMultiplexEntryAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestMultiplexEntryAck_MakeMold( void *pObject );
HS_RESULT ASNH245RequestMultiplexEntryAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestMultiplexEntryAck_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause

} ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice;


#define e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSize		1
#define e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSizeExt	1
typedef struct
{
	ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RequestMultiplexEntryRejectionDescriptions_cause;
HS_RESULT new_ASNH245RequestMultiplexEntryRejectionDescriptions_cause( void *pObject );
HS_RESULT delete_ASNH245RequestMultiplexEntryRejectionDescriptions_cause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RequestMultiplexEntryRejectionDescriptions_cause_SetChoice( void *pObject, ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice pChoice );
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_MakeMold( void *pObject );
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestMultiplexEntryRejectionDescriptionsOptionMapSize 0
#define e_ASNH245RequestMultiplexEntryRejectionDescriptionsOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MultiplexTableEntryNumber m_multiplexTableEntryNumber;
	ASNH245RequestMultiplexEntryRejectionDescriptions_cause m_cause;
	/*...,*/
} ASNH245RequestMultiplexEntryRejectionDescriptions;
HS_RESULT new_ASNH245RequestMultiplexEntryRejectionDescriptions( void *pObject );
HS_RESULT delete_ASNH245RequestMultiplexEntryRejectionDescriptions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_MakeMold( void *pObject );
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestMultiplexEntryRejectOptionMapSize 0
#define e_ASNH245RequestMultiplexEntryRejectOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_entryNumbers;
	AsnSequenceOf m_rejectionDescriptions;
	/*...,*/
} ASNH245RequestMultiplexEntryReject;
HS_RESULT new_ASNH245RequestMultiplexEntryReject( void *pObject );
HS_RESULT delete_ASNH245RequestMultiplexEntryReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestMultiplexEntryReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestMultiplexEntryReject_MakeMold( void *pObject );
HS_RESULT ASNH245RequestMultiplexEntryReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestMultiplexEntryReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RequestModeAck_responseChoice_willTransmitMostPreferredMode,
	e_ASNH245RequestModeAck_responseChoice_willTransmitLessPreferredMode

} ASNH245RequestModeAck_responseChoice;


#define e_ASNH245RequestModeAck_responseChoiceSize		2
#define e_ASNH245RequestModeAck_responseChoiceSizeExt	2
typedef struct
{
	ASNH245RequestModeAck_responseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RequestModeAck_response;
HS_RESULT new_ASNH245RequestModeAck_response( void *pObject );
HS_RESULT delete_ASNH245RequestModeAck_response( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestModeAck_response_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RequestModeAck_response_SetChoice( void *pObject, ASNH245RequestModeAck_responseChoice pChoice );
HS_RESULT ASNH245RequestModeAck_response_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RequestModeAck_response_MakeMold( void *pObject );
HS_RESULT ASNH245RequestModeAck_response_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestModeAck_response_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestModeAckOptionMapSize 0
#define e_ASNH245RequestModeAckOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	ASNH245RequestModeAck_response m_response;
	/*...,*/
} ASNH245RequestModeAck;
HS_RESULT new_ASNH245RequestModeAck( void *pObject );
HS_RESULT delete_ASNH245RequestModeAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestModeAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestModeAck_MakeMold( void *pObject );
HS_RESULT ASNH245RequestModeAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestModeAck_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RequestModeReject_causeChoice_modeUnavailable,
	e_ASNH245RequestModeReject_causeChoice_multipointConstraint,
	e_ASNH245RequestModeReject_causeChoice_requestDenied

} ASNH245RequestModeReject_causeChoice;


#define e_ASNH245RequestModeReject_causeChoiceSize		3
#define e_ASNH245RequestModeReject_causeChoiceSizeExt	3
typedef struct
{
	ASNH245RequestModeReject_causeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RequestModeReject_cause;
HS_RESULT new_ASNH245RequestModeReject_cause( void *pObject );
HS_RESULT delete_ASNH245RequestModeReject_cause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestModeReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RequestModeReject_cause_SetChoice( void *pObject, ASNH245RequestModeReject_causeChoice pChoice );
HS_RESULT ASNH245RequestModeReject_cause_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RequestModeReject_cause_MakeMold( void *pObject );
HS_RESULT ASNH245RequestModeReject_cause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestModeReject_cause_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestModeRejectOptionMapSize 0
#define e_ASNH245RequestModeRejectOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	ASNH245RequestModeReject_cause m_cause;
	/*...,*/
} ASNH245RequestModeReject;
HS_RESULT new_ASNH245RequestModeReject( void *pObject );
HS_RESULT delete_ASNH245RequestModeReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestModeReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestModeReject_MakeMold( void *pObject );
HS_RESULT ASNH245RequestModeReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestModeReject_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RoundTripDelayResponseOptionMapSize 0
#define e_ASNH245RoundTripDelayResponseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	/*...,*/
} ASNH245RoundTripDelayResponse;
HS_RESULT new_ASNH245RoundTripDelayResponse( void *pObject );
HS_RESULT delete_ASNH245RoundTripDelayResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RoundTripDelayResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RoundTripDelayResponse_MakeMold( void *pObject );
HS_RESULT ASNH245RoundTripDelayResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RoundTripDelayResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MaintenanceLoopAck_typeChoice_systemLoop,
	e_ASNH245MaintenanceLoopAck_typeChoice_mediaLoop,
	e_ASNH245MaintenanceLoopAck_typeChoice_logicalChannelLoop

} ASNH245MaintenanceLoopAck_typeChoice;


#define e_ASNH245MaintenanceLoopAck_typeChoiceSize		3
#define e_ASNH245MaintenanceLoopAck_typeChoiceSizeExt	3
typedef struct
{
	ASNH245MaintenanceLoopAck_typeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MaintenanceLoopAck_type;
HS_RESULT new_ASNH245MaintenanceLoopAck_type( void *pObject );
HS_RESULT delete_ASNH245MaintenanceLoopAck_type( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaintenanceLoopAck_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MaintenanceLoopAck_type_SetChoice( void *pObject, ASNH245MaintenanceLoopAck_typeChoice pChoice );
HS_RESULT ASNH245MaintenanceLoopAck_type_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MaintenanceLoopAck_type_MakeMold( void *pObject );
HS_RESULT ASNH245MaintenanceLoopAck_type_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MaintenanceLoopAck_type_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MaintenanceLoopAckOptionMapSize 0
#define e_ASNH245MaintenanceLoopAckOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MaintenanceLoopAck_type m_type;
	/*...,*/
} ASNH245MaintenanceLoopAck;
HS_RESULT new_ASNH245MaintenanceLoopAck( void *pObject );
HS_RESULT delete_ASNH245MaintenanceLoopAck( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaintenanceLoopAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MaintenanceLoopAck_MakeMold( void *pObject );
HS_RESULT ASNH245MaintenanceLoopAck_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MaintenanceLoopAck_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MaintenanceLoopReject_typeChoice_systemLoop,
	e_ASNH245MaintenanceLoopReject_typeChoice_mediaLoop,
	e_ASNH245MaintenanceLoopReject_typeChoice_logicalChannelLoop

} ASNH245MaintenanceLoopReject_typeChoice;


#define e_ASNH245MaintenanceLoopReject_typeChoiceSize		3
#define e_ASNH245MaintenanceLoopReject_typeChoiceSizeExt	3
typedef struct
{
	ASNH245MaintenanceLoopReject_typeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MaintenanceLoopReject_type;
HS_RESULT new_ASNH245MaintenanceLoopReject_type( void *pObject );
HS_RESULT delete_ASNH245MaintenanceLoopReject_type( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaintenanceLoopReject_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MaintenanceLoopReject_type_SetChoice( void *pObject, ASNH245MaintenanceLoopReject_typeChoice pChoice );
HS_RESULT ASNH245MaintenanceLoopReject_type_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MaintenanceLoopReject_type_MakeMold( void *pObject );
HS_RESULT ASNH245MaintenanceLoopReject_type_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MaintenanceLoopReject_type_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MaintenanceLoopReject_causeChoice_canNotPerformLoop

} ASNH245MaintenanceLoopReject_causeChoice;


#define e_ASNH245MaintenanceLoopReject_causeChoiceSize		1
#define e_ASNH245MaintenanceLoopReject_causeChoiceSizeExt	1
typedef struct
{
	ASNH245MaintenanceLoopReject_causeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MaintenanceLoopReject_cause;
HS_RESULT new_ASNH245MaintenanceLoopReject_cause( void *pObject );
HS_RESULT delete_ASNH245MaintenanceLoopReject_cause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaintenanceLoopReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MaintenanceLoopReject_cause_SetChoice( void *pObject, ASNH245MaintenanceLoopReject_causeChoice pChoice );
HS_RESULT ASNH245MaintenanceLoopReject_cause_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MaintenanceLoopReject_cause_MakeMold( void *pObject );
HS_RESULT ASNH245MaintenanceLoopReject_cause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MaintenanceLoopReject_cause_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MaintenanceLoopRejectOptionMapSize 0
#define e_ASNH245MaintenanceLoopRejectOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MaintenanceLoopReject_type m_type;
	ASNH245MaintenanceLoopReject_cause m_cause;
	/*...,*/
} ASNH245MaintenanceLoopReject;
HS_RESULT new_ASNH245MaintenanceLoopReject( void *pObject );
HS_RESULT delete_ASNH245MaintenanceLoopReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaintenanceLoopReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MaintenanceLoopReject_MakeMold( void *pObject );
HS_RESULT ASNH245MaintenanceLoopReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MaintenanceLoopReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CommunicationModeTableEntry_dataTypeChoice_videoData,
	e_ASNH245CommunicationModeTableEntry_dataTypeChoice_audioData,
	e_ASNH245CommunicationModeTableEntry_dataTypeChoice_data

} ASNH245CommunicationModeTableEntry_dataTypeChoice;


#define e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSize		3
#define e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSizeExt	3
typedef struct
{
	ASNH245CommunicationModeTableEntry_dataTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245CommunicationModeTableEntry_dataType;
HS_RESULT new_ASNH245CommunicationModeTableEntry_dataType( void *pObject );
HS_RESULT delete_ASNH245CommunicationModeTableEntry_dataType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CommunicationModeTableEntry_dataType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245CommunicationModeTableEntry_dataType_SetChoice( void *pObject, ASNH245CommunicationModeTableEntry_dataTypeChoice pChoice );
HS_RESULT ASNH245CommunicationModeTableEntry_dataType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245CommunicationModeTableEntry_dataType_MakeMold( void *pObject );
HS_RESULT ASNH245CommunicationModeTableEntry_dataType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CommunicationModeTableEntry_dataType_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CommunicationModeTableEntryOptionMap_nonStandard,
	e_ASNH245CommunicationModeTableEntryOptionMap_associatedSessionID,
	e_ASNH245CommunicationModeTableEntryOptionMap_terminalLabel,
	e_ASNH245CommunicationModeTableEntryOptionMap_mediaChannel,
	e_ASNH245CommunicationModeTableEntryOptionMap_mediaGuaranteedDelivery,
	e_ASNH245CommunicationModeTableEntryOptionMap_mediaControlChannel,
	e_ASNH245CommunicationModeTableEntryOptionMap_mediaControlGuaranteedDelivery
,
	e_ASNH245CommunicationModeTableEntryOptionMap_redundancyEncoding,
	e_ASNH245CommunicationModeTableEntryOptionMap_sessionDependency,
	e_ASNH245CommunicationModeTableEntryOptionMap_destination
} ASNH245CommunicationModeTableEntryOptionMap;


#define e_ASNH245CommunicationModeTableEntryOptionMapSize 7
#define e_ASNH245CommunicationModeTableEntryOptionMapSizeExt 10
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSequenceOf m_nonStandard;
	AsnInteger m_sessionID;
	AsnInteger m_associatedSessionID;
	ASNH245TerminalLabel m_terminalLabel;
	AsnDoubleString m_sessionDescription;
	ASNH245CommunicationModeTableEntry_dataType m_dataType;
	ASNH245TransportAddress m_mediaChannel;
	AsnBoolean m_mediaGuaranteedDelivery;
	ASNH245TransportAddress m_mediaControlChannel;
	AsnBoolean m_mediaControlGuaranteedDelivery;
	/*...,*/
	ASNH245RedundancyEncoding m_redundancyEncoding;
	AsnInteger m_sessionDependency;
	ASNH245TerminalLabel m_destination;
} ASNH245CommunicationModeTableEntry;
HS_RESULT new_ASNH245CommunicationModeTableEntry( void *pObject );
HS_RESULT delete_ASNH245CommunicationModeTableEntry( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CommunicationModeTableEntry_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CommunicationModeTableEntry_IncludeOptionField( void *pObject, ASNH245CommunicationModeTableEntryOptionMap pOptionMap );
BOOL	  ASNH245CommunicationModeTableEntry_IsIncludeOptionField( void *pObject, ASNH245CommunicationModeTableEntryOptionMap pOptionMap );
HS_RESULT ASNH245CommunicationModeTableEntry_MakeMold( void *pObject );
HS_RESULT ASNH245CommunicationModeTableEntry_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CommunicationModeTableEntry_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CommunicationModeResponseChoice_communicationModeTable

} ASNH245CommunicationModeResponseChoice;


#define e_ASNH245CommunicationModeResponseChoiceSize		1
#define e_ASNH245CommunicationModeResponseChoiceSizeExt	1
typedef struct
{
	ASNH245CommunicationModeResponseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245CommunicationModeResponse;
HS_RESULT new_ASNH245CommunicationModeResponse( void *pObject );
HS_RESULT delete_ASNH245CommunicationModeResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CommunicationModeResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245CommunicationModeResponse_SetChoice( void *pObject, ASNH245CommunicationModeResponseChoice pChoice );
HS_RESULT ASNH245CommunicationModeResponse_DeleteAlternation( void *pObject );
HS_RESULT ASNH245CommunicationModeResponse_MakeMold( void *pObject );
HS_RESULT ASNH245CommunicationModeResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CommunicationModeResponse_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245ConferenceResponse_mCTerminalIDResponseOptionMapSize 0
#define e_ASNH245ConferenceResponse_mCTerminalIDResponseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245TerminalLabel m_terminalLabel;
	ASNH245TerminalID m_terminalID;
	/*...,*/
} ASNH245ConferenceResponse_mCTerminalIDResponse;
HS_RESULT new_ASNH245ConferenceResponse_mCTerminalIDResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_mCTerminalIDResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_mCTerminalIDResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceResponse_mCTerminalIDResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_mCTerminalIDResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_mCTerminalIDResponse_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245ConferenceResponse_terminalIDResponseOptionMapSize 0
#define e_ASNH245ConferenceResponse_terminalIDResponseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245TerminalLabel m_terminalLabel;
	ASNH245TerminalID m_terminalID;
	/*...,*/
} ASNH245ConferenceResponse_terminalIDResponse;
HS_RESULT new_ASNH245ConferenceResponse_terminalIDResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_terminalIDResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_terminalIDResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceResponse_terminalIDResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_terminalIDResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_terminalIDResponse_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245ConferenceResponse_conferenceIDResponseOptionMapSize 0
#define e_ASNH245ConferenceResponse_conferenceIDResponseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245TerminalLabel m_terminalLabel;
	ASNH245ConferenceID m_conferenceID;
	/*...,*/
} ASNH245ConferenceResponse_conferenceIDResponse;
HS_RESULT new_ASNH245ConferenceResponse_conferenceIDResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_conferenceIDResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_conferenceIDResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceResponse_conferenceIDResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_conferenceIDResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_conferenceIDResponse_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245ConferenceResponse_passwordResponseOptionMapSize 0
#define e_ASNH245ConferenceResponse_passwordResponseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245TerminalLabel m_terminalLabel;
	ASNH245Password m_password;
	/*...,*/
} ASNH245ConferenceResponse_passwordResponse;
HS_RESULT new_ASNH245ConferenceResponse_passwordResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_passwordResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_passwordResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceResponse_passwordResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_passwordResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_passwordResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceResponse_makeMeChairResponseChoice_grantedChairToken,
	e_ASNH245ConferenceResponse_makeMeChairResponseChoice_deniedChairToken

} ASNH245ConferenceResponse_makeMeChairResponseChoice;


#define e_ASNH245ConferenceResponse_makeMeChairResponseChoiceSize		2
#define e_ASNH245ConferenceResponse_makeMeChairResponseChoiceSizeExt	2
typedef struct
{
	ASNH245ConferenceResponse_makeMeChairResponseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ConferenceResponse_makeMeChairResponse;
HS_RESULT new_ASNH245ConferenceResponse_makeMeChairResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_makeMeChairResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_makeMeChairResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ConferenceResponse_makeMeChairResponse_SetChoice( void *pObject, ASNH245ConferenceResponse_makeMeChairResponseChoice pChoice );
HS_RESULT ASNH245ConferenceResponse_makeMeChairResponse_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ConferenceResponse_makeMeChairResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_makeMeChairResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_makeMeChairResponse_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245ConferenceResponse_extensionAddressResponseOptionMapSize 0
#define e_ASNH245ConferenceResponse_extensionAddressResponseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245TerminalID m_extensionAddress;
	/*...,*/
} ASNH245ConferenceResponse_extensionAddressResponse;
HS_RESULT new_ASNH245ConferenceResponse_extensionAddressResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_extensionAddressResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_extensionAddressResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceResponse_extensionAddressResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_extensionAddressResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_extensionAddressResponse_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245ConferenceResponse_chairTokenOwnerResponseOptionMapSize 0
#define e_ASNH245ConferenceResponse_chairTokenOwnerResponseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245TerminalLabel m_terminalLabel;
	ASNH245TerminalID m_terminalID;
	/*...,*/
} ASNH245ConferenceResponse_chairTokenOwnerResponse;
HS_RESULT new_ASNH245ConferenceResponse_chairTokenOwnerResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_chairTokenOwnerResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_chairTokenOwnerResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceResponse_chairTokenOwnerResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_chairTokenOwnerResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_chairTokenOwnerResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceResponse_terminalCertificateResponseOptionMap_terminalLabel,
	e_ASNH245ConferenceResponse_terminalCertificateResponseOptionMap_certificateResponse

} ASNH245ConferenceResponse_terminalCertificateResponseOptionMap;


#define e_ASNH245ConferenceResponse_terminalCertificateResponseOptionMapSize 2
#define e_ASNH245ConferenceResponse_terminalCertificateResponseOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245TerminalLabel m_terminalLabel;
	AsnOctetString m_certificateResponse;
	/*...,*/
} ASNH245ConferenceResponse_terminalCertificateResponse;
HS_RESULT new_ASNH245ConferenceResponse_terminalCertificateResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_terminalCertificateResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_terminalCertificateResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ConferenceResponse_terminalCertificateResponse_IncludeOptionField( void *pObject, ASNH245ConferenceResponse_terminalCertificateResponseOptionMap pOptionMap );
BOOL	  ASNH245ConferenceResponse_terminalCertificateResponse_IsIncludeOptionField( void *pObject, ASNH245ConferenceResponse_terminalCertificateResponseOptionMap pOptionMap );
HS_RESULT ASNH245ConferenceResponse_terminalCertificateResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_terminalCertificateResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_terminalCertificateResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceResponse_broadcastMyLogicalChannelResponseChoice_grantedBroadcastMyLogicalChannel,
	e_ASNH245ConferenceResponse_broadcastMyLogicalChannelResponseChoice_deniedBroadcastMyLogicalChannel

} ASNH245ConferenceResponse_broadcastMyLogicalChannelResponseChoice;


#define e_ASNH245ConferenceResponse_broadcastMyLogicalChannelResponseChoiceSize		2
#define e_ASNH245ConferenceResponse_broadcastMyLogicalChannelResponseChoiceSizeExt	2
typedef struct
{
	ASNH245ConferenceResponse_broadcastMyLogicalChannelResponseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ConferenceResponse_broadcastMyLogicalChannelResponse;
HS_RESULT new_ASNH245ConferenceResponse_broadcastMyLogicalChannelResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_broadcastMyLogicalChannelResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_broadcastMyLogicalChannelResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ConferenceResponse_broadcastMyLogicalChannelResponse_SetChoice( void *pObject, ASNH245ConferenceResponse_broadcastMyLogicalChannelResponseChoice pChoice );
HS_RESULT ASNH245ConferenceResponse_broadcastMyLogicalChannelResponse_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ConferenceResponse_broadcastMyLogicalChannelResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_broadcastMyLogicalChannelResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_broadcastMyLogicalChannelResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceResponse_makeTerminalBroadcasterResponseChoice_grantedMakeTerminalBroadcaster,
	e_ASNH245ConferenceResponse_makeTerminalBroadcasterResponseChoice_deniedMakeTerminalBroadcaster

} ASNH245ConferenceResponse_makeTerminalBroadcasterResponseChoice;


#define e_ASNH245ConferenceResponse_makeTerminalBroadcasterResponseChoiceSize		2
#define e_ASNH245ConferenceResponse_makeTerminalBroadcasterResponseChoiceSizeExt	2
typedef struct
{
	ASNH245ConferenceResponse_makeTerminalBroadcasterResponseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ConferenceResponse_makeTerminalBroadcasterResponse;
HS_RESULT new_ASNH245ConferenceResponse_makeTerminalBroadcasterResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_makeTerminalBroadcasterResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_makeTerminalBroadcasterResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ConferenceResponse_makeTerminalBroadcasterResponse_SetChoice( void *pObject, ASNH245ConferenceResponse_makeTerminalBroadcasterResponseChoice pChoice );
HS_RESULT ASNH245ConferenceResponse_makeTerminalBroadcasterResponse_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ConferenceResponse_makeTerminalBroadcasterResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_makeTerminalBroadcasterResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_makeTerminalBroadcasterResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceResponse_sendThisSourceResponseChoice_grantedSendThisSource,
	e_ASNH245ConferenceResponse_sendThisSourceResponseChoice_deniedSendThisSource

} ASNH245ConferenceResponse_sendThisSourceResponseChoice;


#define e_ASNH245ConferenceResponse_sendThisSourceResponseChoiceSize		2
#define e_ASNH245ConferenceResponse_sendThisSourceResponseChoiceSizeExt	2
typedef struct
{
	ASNH245ConferenceResponse_sendThisSourceResponseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ConferenceResponse_sendThisSourceResponse;
HS_RESULT new_ASNH245ConferenceResponse_sendThisSourceResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse_sendThisSourceResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_sendThisSourceResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ConferenceResponse_sendThisSourceResponse_SetChoice( void *pObject, ASNH245ConferenceResponse_sendThisSourceResponseChoice pChoice );
HS_RESULT ASNH245ConferenceResponse_sendThisSourceResponse_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ConferenceResponse_sendThisSourceResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_sendThisSourceResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_sendThisSourceResponse_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245TerminalInformationOptionMapSize 0
#define e_ASNH245TerminalInformationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245TerminalLabel m_terminalLabel;
	ASNH245TerminalID m_terminalID;
	/*...,*/
} ASNH245TerminalInformation;
HS_RESULT new_ASNH245TerminalInformation( void *pObject );
HS_RESULT delete_ASNH245TerminalInformation( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TerminalInformation_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalInformation_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalInformation_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestAllTerminalIDsResponseOptionMapSize 0
#define e_ASNH245RequestAllTerminalIDsResponseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_terminalInformation;
	/*...,*/
} ASNH245RequestAllTerminalIDsResponse;
HS_RESULT new_ASNH245RequestAllTerminalIDsResponse( void *pObject );
HS_RESULT delete_ASNH245RequestAllTerminalIDsResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestAllTerminalIDsResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestAllTerminalIDsResponse_MakeMold( void *pObject );
HS_RESULT ASNH245RequestAllTerminalIDsResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestAllTerminalIDsResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RemoteMCResponse_rejectChoice_unspecified,
	e_ASNH245RemoteMCResponse_rejectChoice_functionNotSupported

} ASNH245RemoteMCResponse_rejectChoice;


#define e_ASNH245RemoteMCResponse_rejectChoiceSize		2
#define e_ASNH245RemoteMCResponse_rejectChoiceSizeExt	2
typedef struct
{
	ASNH245RemoteMCResponse_rejectChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RemoteMCResponse_reject;
HS_RESULT new_ASNH245RemoteMCResponse_reject( void *pObject );
HS_RESULT delete_ASNH245RemoteMCResponse_reject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RemoteMCResponse_reject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RemoteMCResponse_reject_SetChoice( void *pObject, ASNH245RemoteMCResponse_rejectChoice pChoice );
HS_RESULT ASNH245RemoteMCResponse_reject_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RemoteMCResponse_reject_MakeMold( void *pObject );
HS_RESULT ASNH245RemoteMCResponse_reject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RemoteMCResponse_reject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RemoteMCResponseChoice_accept,
	e_ASNH245RemoteMCResponseChoice_reject

} ASNH245RemoteMCResponseChoice;


#define e_ASNH245RemoteMCResponseChoiceSize		2
#define e_ASNH245RemoteMCResponseChoiceSizeExt	2
typedef struct
{
	ASNH245RemoteMCResponseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RemoteMCResponse;
HS_RESULT new_ASNH245RemoteMCResponse( void *pObject );
HS_RESULT delete_ASNH245RemoteMCResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RemoteMCResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RemoteMCResponse_SetChoice( void *pObject, ASNH245RemoteMCResponseChoice pChoice );
HS_RESULT ASNH245RemoteMCResponse_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RemoteMCResponse_MakeMold( void *pObject );
HS_RESULT ASNH245RemoteMCResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RemoteMCResponse_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceResponseChoice_mCTerminalIDResponse,
	e_ASNH245ConferenceResponseChoice_terminalIDResponse,
	e_ASNH245ConferenceResponseChoice_conferenceIDResponse,
	e_ASNH245ConferenceResponseChoice_passwordResponse,
	e_ASNH245ConferenceResponseChoice_terminalListResponse,
	e_ASNH245ConferenceResponseChoice_videoCommandReject,
	e_ASNH245ConferenceResponseChoice_terminalDropReject,
	e_ASNH245ConferenceResponseChoice_makeMeChairResponse
,
	e_ASNH245ConferenceResponseChoice_extensionAddressResponse,
	e_ASNH245ConferenceResponseChoice_chairTokenOwnerResponse,
	e_ASNH245ConferenceResponseChoice_terminalCertificateResponse,
	e_ASNH245ConferenceResponseChoice_broadcastMyLogicalChannelResponse,
	e_ASNH245ConferenceResponseChoice_makeTerminalBroadcasterResponse,
	e_ASNH245ConferenceResponseChoice_sendThisSourceResponse,
	e_ASNH245ConferenceResponseChoice_requestAllTerminalIDsResponse,
	e_ASNH245ConferenceResponseChoice_remoteMCResponse
} ASNH245ConferenceResponseChoice;


#define e_ASNH245ConferenceResponseChoiceSize		8
#define e_ASNH245ConferenceResponseChoiceSizeExt	16
typedef struct
{
	ASNH245ConferenceResponseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ConferenceResponse;
HS_RESULT new_ASNH245ConferenceResponse( void *pObject );
HS_RESULT delete_ASNH245ConferenceResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ConferenceResponse_SetChoice( void *pObject, ASNH245ConferenceResponseChoice pChoice );
HS_RESULT ASNH245ConferenceResponse_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ConferenceResponse_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceResponse_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkResponse_callInformationOptionMapSize 0
#define e_ASNH245MultilinkResponse_callInformationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245DialingInformation m_dialingInformation;
	AsnInteger m_callAssociationNumber;
	/*...,*/
} ASNH245MultilinkResponse_callInformation;
HS_RESULT new_ASNH245MultilinkResponse_callInformation( void *pObject );
HS_RESULT delete_ASNH245MultilinkResponse_callInformation( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkResponse_callInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkResponse_callInformation_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkResponse_callInformation_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkResponse_callInformation_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultilinkResponse_addConnection_responseCode_rejectedChoice_connectionsNotAvailable,
	e_ASNH245MultilinkResponse_addConnection_responseCode_rejectedChoice_userRejected

} ASNH245MultilinkResponse_addConnection_responseCode_rejectedChoice;


#define e_ASNH245MultilinkResponse_addConnection_responseCode_rejectedChoiceSize		2
#define e_ASNH245MultilinkResponse_addConnection_responseCode_rejectedChoiceSizeExt	2
typedef struct
{
	ASNH245MultilinkResponse_addConnection_responseCode_rejectedChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultilinkResponse_addConnection_responseCode_rejected;
HS_RESULT new_ASNH245MultilinkResponse_addConnection_responseCode_rejected( void *pObject );
HS_RESULT delete_ASNH245MultilinkResponse_addConnection_responseCode_rejected( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_rejected_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultilinkResponse_addConnection_responseCode_rejected_SetChoice( void *pObject, ASNH245MultilinkResponse_addConnection_responseCode_rejectedChoice pChoice );
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_rejected_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_rejected_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_rejected_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_rejected_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultilinkResponse_addConnection_responseCodeChoice_accepted,
	e_ASNH245MultilinkResponse_addConnection_responseCodeChoice_rejected

} ASNH245MultilinkResponse_addConnection_responseCodeChoice;


#define e_ASNH245MultilinkResponse_addConnection_responseCodeChoiceSize		2
#define e_ASNH245MultilinkResponse_addConnection_responseCodeChoiceSizeExt	2
typedef struct
{
	ASNH245MultilinkResponse_addConnection_responseCodeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultilinkResponse_addConnection_responseCode;
HS_RESULT new_ASNH245MultilinkResponse_addConnection_responseCode( void *pObject );
HS_RESULT delete_ASNH245MultilinkResponse_addConnection_responseCode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultilinkResponse_addConnection_responseCode_SetChoice( void *pObject, ASNH245MultilinkResponse_addConnection_responseCodeChoice pChoice );
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkResponse_addConnection_responseCode_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkResponse_addConnectionOptionMapSize 0
#define e_ASNH245MultilinkResponse_addConnectionOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	ASNH245MultilinkResponse_addConnection_responseCode m_responseCode;
	/*...,*/
} ASNH245MultilinkResponse_addConnection;
HS_RESULT new_ASNH245MultilinkResponse_addConnection( void *pObject );
HS_RESULT delete_ASNH245MultilinkResponse_addConnection( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkResponse_addConnection_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkResponse_addConnection_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkResponse_addConnection_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkResponse_addConnection_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkResponse_removeConnectionOptionMapSize 0
#define e_ASNH245MultilinkResponse_removeConnectionOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245ConnectionIdentifier m_connectionIdentifier;
	/*...,*/
} ASNH245MultilinkResponse_removeConnection;
HS_RESULT new_ASNH245MultilinkResponse_removeConnection( void *pObject );
HS_RESULT delete_ASNH245MultilinkResponse_removeConnection( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkResponse_removeConnection_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkResponse_removeConnection_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkResponse_removeConnection_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkResponse_removeConnection_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkResponse_maximumHeaderIntervalOptionMapSize 0
#define e_ASNH245MultilinkResponse_maximumHeaderIntervalOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_currentInterval;
	/*...,*/
} ASNH245MultilinkResponse_maximumHeaderInterval;
HS_RESULT new_ASNH245MultilinkResponse_maximumHeaderInterval( void *pObject );
HS_RESULT delete_ASNH245MultilinkResponse_maximumHeaderInterval( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkResponse_maximumHeaderInterval_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkResponse_maximumHeaderInterval_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkResponse_maximumHeaderInterval_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkResponse_maximumHeaderInterval_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultilinkResponseChoice_nonStandard,
	e_ASNH245MultilinkResponseChoice_callInformation,
	e_ASNH245MultilinkResponseChoice_addConnection,
	e_ASNH245MultilinkResponseChoice_removeConnection,
	e_ASNH245MultilinkResponseChoice_maximumHeaderInterval

} ASNH245MultilinkResponseChoice;


#define e_ASNH245MultilinkResponseChoiceSize		5
#define e_ASNH245MultilinkResponseChoiceSizeExt	5
typedef struct
{
	ASNH245MultilinkResponseChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultilinkResponse;
HS_RESULT new_ASNH245MultilinkResponse( void *pObject );
HS_RESULT delete_ASNH245MultilinkResponse( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultilinkResponse_SetChoice( void *pObject, ASNH245MultilinkResponseChoice pChoice );
HS_RESULT ASNH245MultilinkResponse_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultilinkResponse_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkResponse_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkResponse_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245LogicalChannelRateAcknowledgeOptionMapSize 0
#define e_ASNH245LogicalChannelRateAcknowledgeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	ASNH245LogicalChannelNumber m_logicalChannelNumber;
	ASNH245MaximumBitRate m_maximumBitRate;
	/*...,*/
} ASNH245LogicalChannelRateAcknowledge;
HS_RESULT new_ASNH245LogicalChannelRateAcknowledge( void *pObject );
HS_RESULT delete_ASNH245LogicalChannelRateAcknowledge( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245LogicalChannelRateAcknowledge_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245LogicalChannelRateAcknowledge_MakeMold( void *pObject );
HS_RESULT ASNH245LogicalChannelRateAcknowledge_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245LogicalChannelRateAcknowledge_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245LogicalChannelRateRejectReasonChoice_undefinedReason,
	e_ASNH245LogicalChannelRateRejectReasonChoice_insufficientResources

} ASNH245LogicalChannelRateRejectReasonChoice;


#define e_ASNH245LogicalChannelRateRejectReasonChoiceSize		2
#define e_ASNH245LogicalChannelRateRejectReasonChoiceSizeExt	2
typedef struct
{
	ASNH245LogicalChannelRateRejectReasonChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245LogicalChannelRateRejectReason;
HS_RESULT new_ASNH245LogicalChannelRateRejectReason( void *pObject );
HS_RESULT delete_ASNH245LogicalChannelRateRejectReason( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245LogicalChannelRateRejectReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245LogicalChannelRateRejectReason_SetChoice( void *pObject, ASNH245LogicalChannelRateRejectReasonChoice pChoice );
HS_RESULT ASNH245LogicalChannelRateRejectReason_DeleteAlternation( void *pObject );
HS_RESULT ASNH245LogicalChannelRateRejectReason_MakeMold( void *pObject );
HS_RESULT ASNH245LogicalChannelRateRejectReason_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245LogicalChannelRateRejectReason_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245LogicalChannelRateRejectOptionMap_currentMaximumBitRate

} ASNH245LogicalChannelRateRejectOptionMap;


#define e_ASNH245LogicalChannelRateRejectOptionMapSize 1
#define e_ASNH245LogicalChannelRateRejectOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245SequenceNumber m_sequenceNumber;
	ASNH245LogicalChannelNumber m_logicalChannelNumber;
	ASNH245LogicalChannelRateRejectReason m_rejectReason;
	ASNH245MaximumBitRate m_currentMaximumBitRate;
	/*...,*/
} ASNH245LogicalChannelRateReject;
HS_RESULT new_ASNH245LogicalChannelRateReject( void *pObject );
HS_RESULT delete_ASNH245LogicalChannelRateReject( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245LogicalChannelRateReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245LogicalChannelRateReject_IncludeOptionField( void *pObject, ASNH245LogicalChannelRateRejectOptionMap pOptionMap );
BOOL	  ASNH245LogicalChannelRateReject_IsIncludeOptionField( void *pObject, ASNH245LogicalChannelRateRejectOptionMap pOptionMap );
HS_RESULT ASNH245LogicalChannelRateReject_MakeMold( void *pObject );
HS_RESULT ASNH245LogicalChannelRateReject_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245LogicalChannelRateReject_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ResponseMessageChoice_nonStandard,
	e_ASNH245ResponseMessageChoice_masterSlaveDeterminationAck,
	e_ASNH245ResponseMessageChoice_masterSlaveDeterminationReject,
	e_ASNH245ResponseMessageChoice_terminalCapabilitySetAck,
	e_ASNH245ResponseMessageChoice_terminalCapabilitySetReject,
	e_ASNH245ResponseMessageChoice_openLogicalChannelAck,
	e_ASNH245ResponseMessageChoice_openLogicalChannelReject,
	e_ASNH245ResponseMessageChoice_closeLogicalChannelAck,
	e_ASNH245ResponseMessageChoice_requestChannelCloseAck,
	e_ASNH245ResponseMessageChoice_requestChannelCloseReject,
	e_ASNH245ResponseMessageChoice_multiplexEntrySendAck,
	e_ASNH245ResponseMessageChoice_multiplexEntrySendReject,
	e_ASNH245ResponseMessageChoice_requestMultiplexEntryAck,
	e_ASNH245ResponseMessageChoice_requestMultiplexEntryReject,
	e_ASNH245ResponseMessageChoice_requestModeAck,
	e_ASNH245ResponseMessageChoice_requestModeReject,
	e_ASNH245ResponseMessageChoice_roundTripDelayResponse,
	e_ASNH245ResponseMessageChoice_maintenanceLoopAck,
	e_ASNH245ResponseMessageChoice_maintenanceLoopReject
,
	e_ASNH245ResponseMessageChoice_communicationModeResponse,
	e_ASNH245ResponseMessageChoice_conferenceResponse,
	e_ASNH245ResponseMessageChoice_multilinkResponse,
	e_ASNH245ResponseMessageChoice_logicalChannelRateAcknowledge,
	e_ASNH245ResponseMessageChoice_logicalChannelRateReject
} ASNH245ResponseMessageChoice;


#define e_ASNH245ResponseMessageChoiceSize		19
#define e_ASNH245ResponseMessageChoiceSizeExt	24
typedef struct
{
	ASNH245ResponseMessageChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ResponseMessage;
HS_RESULT new_ASNH245ResponseMessage( void *pObject );
HS_RESULT delete_ASNH245ResponseMessage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ResponseMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ResponseMessage_SetChoice( void *pObject, ASNH245ResponseMessageChoice pChoice );
HS_RESULT ASNH245ResponseMessage_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ResponseMessage_MakeMold( void *pObject );
HS_RESULT ASNH245ResponseMessage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ResponseMessage_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MaintenanceLoopOffCommandOptionMapSize 0
#define e_ASNH245MaintenanceLoopOffCommandOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	/*...,*/
} ASNH245MaintenanceLoopOffCommand;
HS_RESULT new_ASNH245MaintenanceLoopOffCommand( void *pObject );
HS_RESULT delete_ASNH245MaintenanceLoopOffCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaintenanceLoopOffCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MaintenanceLoopOffCommand_MakeMold( void *pObject );
HS_RESULT ASNH245MaintenanceLoopOffCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MaintenanceLoopOffCommand_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245SendTerminalCapabilitySet_specificRequestOptionMap_capabilityTableEntryNumbers,
	e_ASNH245SendTerminalCapabilitySet_specificRequestOptionMap_capabilityDescriptorNumbers

} ASNH245SendTerminalCapabilitySet_specificRequestOptionMap;


#define e_ASNH245SendTerminalCapabilitySet_specificRequestOptionMapSize 2
#define e_ASNH245SendTerminalCapabilitySet_specificRequestOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_multiplexCapability;
	AsnSequenceOf m_capabilityTableEntryNumbers;
	AsnSequenceOf m_capabilityDescriptorNumbers;
	/*...,*/
} ASNH245SendTerminalCapabilitySet_specificRequest;
HS_RESULT new_ASNH245SendTerminalCapabilitySet_specificRequest( void *pObject );
HS_RESULT delete_ASNH245SendTerminalCapabilitySet_specificRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245SendTerminalCapabilitySet_specificRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245SendTerminalCapabilitySet_specificRequest_IncludeOptionField( void *pObject, ASNH245SendTerminalCapabilitySet_specificRequestOptionMap pOptionMap );
BOOL	  ASNH245SendTerminalCapabilitySet_specificRequest_IsIncludeOptionField( void *pObject, ASNH245SendTerminalCapabilitySet_specificRequestOptionMap pOptionMap );
HS_RESULT ASNH245SendTerminalCapabilitySet_specificRequest_MakeMold( void *pObject );
HS_RESULT ASNH245SendTerminalCapabilitySet_specificRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245SendTerminalCapabilitySet_specificRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245SendTerminalCapabilitySetChoice_specificRequest,
	e_ASNH245SendTerminalCapabilitySetChoice_genericRequest

} ASNH245SendTerminalCapabilitySetChoice;


#define e_ASNH245SendTerminalCapabilitySetChoiceSize		2
#define e_ASNH245SendTerminalCapabilitySetChoiceSizeExt	2
typedef struct
{
	ASNH245SendTerminalCapabilitySetChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245SendTerminalCapabilitySet;
HS_RESULT new_ASNH245SendTerminalCapabilitySet( void *pObject );
HS_RESULT delete_ASNH245SendTerminalCapabilitySet( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245SendTerminalCapabilitySet_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245SendTerminalCapabilitySet_SetChoice( void *pObject, ASNH245SendTerminalCapabilitySetChoice pChoice );
HS_RESULT ASNH245SendTerminalCapabilitySet_DeleteAlternation( void *pObject );
HS_RESULT ASNH245SendTerminalCapabilitySet_MakeMold( void *pObject );
HS_RESULT ASNH245SendTerminalCapabilitySet_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245SendTerminalCapabilitySet_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245EncryptionCommand_encryptionAlgorithmIDOptionMapSize 0
#define e_ASNH245EncryptionCommand_encryptionAlgorithmIDOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245SequenceNumber m_h233AlgorithmIdentifier;
	ASNH245NonStandardParameter m_associatedAlgorithm;
} ASNH245EncryptionCommand_encryptionAlgorithmID;
HS_RESULT new_ASNH245EncryptionCommand_encryptionAlgorithmID( void *pObject );
HS_RESULT delete_ASNH245EncryptionCommand_encryptionAlgorithmID( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EncryptionCommand_encryptionAlgorithmID_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245EncryptionCommand_encryptionAlgorithmID_MakeMold( void *pObject );
HS_RESULT ASNH245EncryptionCommand_encryptionAlgorithmID_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EncryptionCommand_encryptionAlgorithmID_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EncryptionCommandChoice_encryptionSE,
	e_ASNH245EncryptionCommandChoice_encryptionIVRequest,
	e_ASNH245EncryptionCommandChoice_encryptionAlgorithmID

} ASNH245EncryptionCommandChoice;


#define e_ASNH245EncryptionCommandChoiceSize		3
#define e_ASNH245EncryptionCommandChoiceSizeExt	3
typedef struct
{
	ASNH245EncryptionCommandChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245EncryptionCommand;
HS_RESULT new_ASNH245EncryptionCommand( void *pObject );
HS_RESULT delete_ASNH245EncryptionCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EncryptionCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245EncryptionCommand_SetChoice( void *pObject, ASNH245EncryptionCommandChoice pChoice );
HS_RESULT ASNH245EncryptionCommand_DeleteAlternation( void *pObject );
HS_RESULT ASNH245EncryptionCommand_MakeMold( void *pObject );
HS_RESULT ASNH245EncryptionCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EncryptionCommand_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245FlowControlCommand_scopeChoice_logicalChannelNumber,
	e_ASNH245FlowControlCommand_scopeChoice_resourceID,
	e_ASNH245FlowControlCommand_scopeChoice_wholeMultiplex
} ASNH245FlowControlCommand_scopeChoice;


#define e_ASNH245FlowControlCommand_scopeChoiceSize		3
#define e_ASNH245FlowControlCommand_scopeChoiceSizeExt	3
typedef struct
{
	ASNH245FlowControlCommand_scopeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245FlowControlCommand_scope;
HS_RESULT new_ASNH245FlowControlCommand_scope( void *pObject );
HS_RESULT delete_ASNH245FlowControlCommand_scope( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245FlowControlCommand_scope_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245FlowControlCommand_scope_SetChoice( void *pObject, ASNH245FlowControlCommand_scopeChoice pChoice );
HS_RESULT ASNH245FlowControlCommand_scope_DeleteAlternation( void *pObject );
HS_RESULT ASNH245FlowControlCommand_scope_MakeMold( void *pObject );
HS_RESULT ASNH245FlowControlCommand_scope_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245FlowControlCommand_scope_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245FlowControlCommand_restrictionChoice_maximumBitRate,
	e_ASNH245FlowControlCommand_restrictionChoice_noRestriction
} ASNH245FlowControlCommand_restrictionChoice;


#define e_ASNH245FlowControlCommand_restrictionChoiceSize		2
#define e_ASNH245FlowControlCommand_restrictionChoiceSizeExt	2
typedef struct
{
	ASNH245FlowControlCommand_restrictionChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245FlowControlCommand_restriction;
HS_RESULT new_ASNH245FlowControlCommand_restriction( void *pObject );
HS_RESULT delete_ASNH245FlowControlCommand_restriction( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245FlowControlCommand_restriction_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245FlowControlCommand_restriction_SetChoice( void *pObject, ASNH245FlowControlCommand_restrictionChoice pChoice );
HS_RESULT ASNH245FlowControlCommand_restriction_DeleteAlternation( void *pObject );
HS_RESULT ASNH245FlowControlCommand_restriction_MakeMold( void *pObject );
HS_RESULT ASNH245FlowControlCommand_restriction_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245FlowControlCommand_restriction_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245FlowControlCommandOptionMapSize 0
#define e_ASNH245FlowControlCommandOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245FlowControlCommand_scope m_scope;
	ASNH245FlowControlCommand_restriction m_restriction;
	/*...,*/
} ASNH245FlowControlCommand;
HS_RESULT new_ASNH245FlowControlCommand( void *pObject );
HS_RESULT delete_ASNH245FlowControlCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245FlowControlCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245FlowControlCommand_MakeMold( void *pObject );
HS_RESULT ASNH245FlowControlCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245FlowControlCommand_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EndSessionCommand_gstnOptionsChoice_telephonyMode,
	e_ASNH245EndSessionCommand_gstnOptionsChoice_v8bis,
	e_ASNH245EndSessionCommand_gstnOptionsChoice_v34DSVD,
	e_ASNH245EndSessionCommand_gstnOptionsChoice_v34DuplexFAX,
	e_ASNH245EndSessionCommand_gstnOptionsChoice_v34H324

} ASNH245EndSessionCommand_gstnOptionsChoice;


#define e_ASNH245EndSessionCommand_gstnOptionsChoiceSize		5
#define e_ASNH245EndSessionCommand_gstnOptionsChoiceSizeExt	5
typedef struct
{
	ASNH245EndSessionCommand_gstnOptionsChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245EndSessionCommand_gstnOptions;
HS_RESULT new_ASNH245EndSessionCommand_gstnOptions( void *pObject );
HS_RESULT delete_ASNH245EndSessionCommand_gstnOptions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EndSessionCommand_gstnOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245EndSessionCommand_gstnOptions_SetChoice( void *pObject, ASNH245EndSessionCommand_gstnOptionsChoice pChoice );
HS_RESULT ASNH245EndSessionCommand_gstnOptions_DeleteAlternation( void *pObject );
HS_RESULT ASNH245EndSessionCommand_gstnOptions_MakeMold( void *pObject );
HS_RESULT ASNH245EndSessionCommand_gstnOptions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EndSessionCommand_gstnOptions_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EndSessionCommand_isdnOptionsChoice_telephonyMode,
	e_ASNH245EndSessionCommand_isdnOptionsChoice_v140,
	e_ASNH245EndSessionCommand_isdnOptionsChoice_terminalOnHold

} ASNH245EndSessionCommand_isdnOptionsChoice;


#define e_ASNH245EndSessionCommand_isdnOptionsChoiceSize		3
#define e_ASNH245EndSessionCommand_isdnOptionsChoiceSizeExt	3
typedef struct
{
	ASNH245EndSessionCommand_isdnOptionsChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245EndSessionCommand_isdnOptions;
HS_RESULT new_ASNH245EndSessionCommand_isdnOptions( void *pObject );
HS_RESULT delete_ASNH245EndSessionCommand_isdnOptions( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EndSessionCommand_isdnOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245EndSessionCommand_isdnOptions_SetChoice( void *pObject, ASNH245EndSessionCommand_isdnOptionsChoice pChoice );
HS_RESULT ASNH245EndSessionCommand_isdnOptions_DeleteAlternation( void *pObject );
HS_RESULT ASNH245EndSessionCommand_isdnOptions_MakeMold( void *pObject );
HS_RESULT ASNH245EndSessionCommand_isdnOptions_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EndSessionCommand_isdnOptions_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EndSessionCommandChoice_nonStandard,
	e_ASNH245EndSessionCommandChoice_disconnect,
	e_ASNH245EndSessionCommandChoice_gstnOptions
,
	e_ASNH245EndSessionCommandChoice_isdnOptions
} ASNH245EndSessionCommandChoice;


#define e_ASNH245EndSessionCommandChoiceSize		3
#define e_ASNH245EndSessionCommandChoiceSizeExt	4
typedef struct
{
	ASNH245EndSessionCommandChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245EndSessionCommand;
HS_RESULT new_ASNH245EndSessionCommand( void *pObject );
HS_RESULT delete_ASNH245EndSessionCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EndSessionCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245EndSessionCommand_SetChoice( void *pObject, ASNH245EndSessionCommandChoice pChoice );
HS_RESULT ASNH245EndSessionCommand_DeleteAlternation( void *pObject );
HS_RESULT ASNH245EndSessionCommand_MakeMold( void *pObject );
HS_RESULT ASNH245EndSessionCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EndSessionCommand_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MiscellaneousCommand_type_videoFastUpdateGOBOptionMapSize 0
#define e_ASNH245MiscellaneousCommand_type_videoFastUpdateGOBOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_firstGOB;
	AsnInteger m_numberOfGOBs;
} ASNH245MiscellaneousCommand_type_videoFastUpdateGOB;
HS_RESULT new_ASNH245MiscellaneousCommand_type_videoFastUpdateGOB( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousCommand_type_videoFastUpdateGOB( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousCommand_type_videoFastUpdateGOB_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MiscellaneousCommand_type_videoFastUpdateGOB_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_type_videoFastUpdateGOB_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousCommand_type_videoFastUpdateGOB_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MiscellaneousCommand_type_videoFastUpdateMBOptionMap_firstGOB,
	e_ASNH245MiscellaneousCommand_type_videoFastUpdateMBOptionMap_firstMB

} ASNH245MiscellaneousCommand_type_videoFastUpdateMBOptionMap;


#define e_ASNH245MiscellaneousCommand_type_videoFastUpdateMBOptionMapSize 2
#define e_ASNH245MiscellaneousCommand_type_videoFastUpdateMBOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_firstGOB;
	AsnInteger m_firstMB;
	AsnInteger m_numberOfMBs;
	/*...,*/
} ASNH245MiscellaneousCommand_type_videoFastUpdateMB;
HS_RESULT new_ASNH245MiscellaneousCommand_type_videoFastUpdateMB( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousCommand_type_videoFastUpdateMB( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousCommand_type_videoFastUpdateMB_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MiscellaneousCommand_type_videoFastUpdateMB_IncludeOptionField( void *pObject, ASNH245MiscellaneousCommand_type_videoFastUpdateMBOptionMap pOptionMap );
BOOL	  ASNH245MiscellaneousCommand_type_videoFastUpdateMB_IsIncludeOptionField( void *pObject, ASNH245MiscellaneousCommand_type_videoFastUpdateMBOptionMap pOptionMap );
HS_RESULT ASNH245MiscellaneousCommand_type_videoFastUpdateMB_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_type_videoFastUpdateMB_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousCommand_type_videoFastUpdateMB_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245KeyProtectionMethodOptionMapSize 0
#define e_ASNH245KeyProtectionMethodOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnBoolean m_secureChannel;
	AsnBoolean m_sharedSecret;
	AsnBoolean m_certProtectedKey;
	/*...,*/
} ASNH245KeyProtectionMethod;
HS_RESULT new_ASNH245KeyProtectionMethod( void *pObject );
HS_RESULT delete_ASNH245KeyProtectionMethod( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245KeyProtectionMethod_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245KeyProtectionMethod_MakeMold( void *pObject );
HS_RESULT ASNH245KeyProtectionMethod_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245KeyProtectionMethod_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245EncryptionUpdateRequestOptionMap_keyProtectionMethod

} ASNH245EncryptionUpdateRequestOptionMap;


#define e_ASNH245EncryptionUpdateRequestOptionMapSize 1
#define e_ASNH245EncryptionUpdateRequestOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245KeyProtectionMethod m_keyProtectionMethod;
	/*...,*/
} ASNH245EncryptionUpdateRequest;
HS_RESULT new_ASNH245EncryptionUpdateRequest( void *pObject );
HS_RESULT delete_ASNH245EncryptionUpdateRequest( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EncryptionUpdateRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245EncryptionUpdateRequest_IncludeOptionField( void *pObject, ASNH245EncryptionUpdateRequestOptionMap pOptionMap );
BOOL	  ASNH245EncryptionUpdateRequest_IsIncludeOptionField( void *pObject, ASNH245EncryptionUpdateRequestOptionMap pOptionMap );
HS_RESULT ASNH245EncryptionUpdateRequest_MakeMold( void *pObject );
HS_RESULT ASNH245EncryptionUpdateRequest_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245EncryptionUpdateRequest_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCountChoice_doOneProgression,
	e_ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCountChoice_doContinuousProgressions,
	e_ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCountChoice_doOneIndependentProgression,
	e_ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCountChoice_doContinuousIndependentProgressions

} ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCountChoice;


#define e_ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCountChoiceSize		4
#define e_ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCountChoiceSizeExt	4
typedef struct
{
	ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCountChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount;
HS_RESULT new_ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_SetChoice( void *pObject, ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCountChoice pChoice );
HS_RESULT ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MiscellaneousCommand_type_progressiveRefinementStartOptionMapSize 0
#define e_ASNH245MiscellaneousCommand_type_progressiveRefinementStartOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount m_repeatCount;
	/*...,*/
} ASNH245MiscellaneousCommand_type_progressiveRefinementStart;
HS_RESULT new_ASNH245MiscellaneousCommand_type_progressiveRefinementStart( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousCommand_type_progressiveRefinementStart( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousCommand_type_progressiveRefinementStart_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MiscellaneousCommand_type_progressiveRefinementStart_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_type_progressiveRefinementStart_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousCommand_type_progressiveRefinementStart_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MiscellaneousCommand_type_videoBadMBsOptionMapSize 0
#define e_ASNH245MiscellaneousCommand_type_videoBadMBsOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_firstMB;
	AsnInteger m_numberOfMBs;
	AsnInteger m_temporalReference;
	/*...,*/
} ASNH245MiscellaneousCommand_type_videoBadMBs;
HS_RESULT new_ASNH245MiscellaneousCommand_type_videoBadMBs( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousCommand_type_videoBadMBs( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousCommand_type_videoBadMBs_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MiscellaneousCommand_type_videoBadMBs_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_type_videoBadMBs_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousCommand_type_videoBadMBs_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245PictureReferenceChoice_pictureNumber,
	e_ASNH245PictureReferenceChoice_longTermPictureIndex

} ASNH245PictureReferenceChoice;


#define e_ASNH245PictureReferenceChoiceSize		2
#define e_ASNH245PictureReferenceChoiceSizeExt	2
typedef struct
{
	ASNH245PictureReferenceChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245PictureReference;
HS_RESULT new_ASNH245PictureReference( void *pObject );
HS_RESULT delete_ASNH245PictureReference( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245PictureReference_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245PictureReference_SetChoice( void *pObject, ASNH245PictureReferenceChoice pChoice );
HS_RESULT ASNH245PictureReference_DeleteAlternation( void *pObject );
HS_RESULT ASNH245PictureReference_MakeMold( void *pObject );
HS_RESULT ASNH245PictureReference_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245PictureReference_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MiscellaneousCommand_type_lostPartialPictureOptionMapSize 0
#define e_ASNH245MiscellaneousCommand_type_lostPartialPictureOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245PictureReference m_pictureReference;
	AsnInteger m_firstMB;
	AsnInteger m_numberOfMBs;
	/*...,*/
} ASNH245MiscellaneousCommand_type_lostPartialPicture;
HS_RESULT new_ASNH245MiscellaneousCommand_type_lostPartialPicture( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousCommand_type_lostPartialPicture( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousCommand_type_lostPartialPicture_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MiscellaneousCommand_type_lostPartialPicture_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_type_lostPartialPicture_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousCommand_type_lostPartialPicture_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MiscellaneousCommand_typeChoice_equaliseDelay,
	e_ASNH245MiscellaneousCommand_typeChoice_zeroDelay,
	e_ASNH245MiscellaneousCommand_typeChoice_multipointModeCommand,
	e_ASNH245MiscellaneousCommand_typeChoice_cancelMultipointModeCommand,
	e_ASNH245MiscellaneousCommand_typeChoice_videoFreezePicture,
	e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdatePicture,
	e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateGOB,
	e_ASNH245MiscellaneousCommand_typeChoice_videoTemporalSpatialTradeOff,
	e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOB,
	e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOBCancel
,
	e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateMB,
	e_ASNH245MiscellaneousCommand_typeChoice_maxH223MUXPDUsize,
	e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdate,
	e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdateRequest,
	e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOff,
	e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOn,
	e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementStart,
	e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortOne,
	e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortContinuous,
	e_ASNH245MiscellaneousCommand_typeChoice_videoBadMBs,
	e_ASNH245MiscellaneousCommand_typeChoice_lostPicture,
	e_ASNH245MiscellaneousCommand_typeChoice_lostPartialPicture,
	e_ASNH245MiscellaneousCommand_typeChoice_recoveryReferencePicture
} ASNH245MiscellaneousCommand_typeChoice;


#define e_ASNH245MiscellaneousCommand_typeChoiceSize		10
#define e_ASNH245MiscellaneousCommand_typeChoiceSizeExt	23
typedef struct
{
	ASNH245MiscellaneousCommand_typeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MiscellaneousCommand_type;
HS_RESULT new_ASNH245MiscellaneousCommand_type( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousCommand_type( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousCommand_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MiscellaneousCommand_type_SetChoice( void *pObject, ASNH245MiscellaneousCommand_typeChoice pChoice );
HS_RESULT ASNH245MiscellaneousCommand_type_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_type_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_type_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousCommand_type_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MiscellaneousCommandOptionMapSize 0
#define e_ASNH245MiscellaneousCommandOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_logicalChannelNumber;
	ASNH245MiscellaneousCommand_type m_type;
	/*...,*/
} ASNH245MiscellaneousCommand;
HS_RESULT new_ASNH245MiscellaneousCommand( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MiscellaneousCommand_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousCommand_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245CommunicationModeCommandOptionMapSize 0
#define e_ASNH245CommunicationModeCommandOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_communicationModeTable;
	/*...,*/
} ASNH245CommunicationModeCommand;
HS_RESULT new_ASNH245CommunicationModeCommand( void *pObject );
HS_RESULT delete_ASNH245CommunicationModeCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CommunicationModeCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245CommunicationModeCommand_MakeMold( void *pObject );
HS_RESULT ASNH245CommunicationModeCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CommunicationModeCommand_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245SubstituteConferenceIDCommandOptionMapSize 0
#define e_ASNH245SubstituteConferenceIDCommandOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnOctetString m_conferenceIdentifier;
	/*...,*/
} ASNH245SubstituteConferenceIDCommand;
HS_RESULT new_ASNH245SubstituteConferenceIDCommand( void *pObject );
HS_RESULT delete_ASNH245SubstituteConferenceIDCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245SubstituteConferenceIDCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245SubstituteConferenceIDCommand_MakeMold( void *pObject );
HS_RESULT ASNH245SubstituteConferenceIDCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245SubstituteConferenceIDCommand_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceCommandChoice_broadcastMyLogicalChannel,
	e_ASNH245ConferenceCommandChoice_cancelBroadcastMyLogicalChannel,
	e_ASNH245ConferenceCommandChoice_makeTerminalBroadcaster,
	e_ASNH245ConferenceCommandChoice_cancelMakeTerminalBroadcaster,
	e_ASNH245ConferenceCommandChoice_sendThisSource,
	e_ASNH245ConferenceCommandChoice_cancelSendThisSource,
	e_ASNH245ConferenceCommandChoice_dropConference
,
	e_ASNH245ConferenceCommandChoice_substituteConferenceIDCommand
} ASNH245ConferenceCommandChoice;


#define e_ASNH245ConferenceCommandChoiceSize		7
#define e_ASNH245ConferenceCommandChoiceSizeExt	8
typedef struct
{
	ASNH245ConferenceCommandChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ConferenceCommand;
HS_RESULT new_ASNH245ConferenceCommand( void *pObject );
HS_RESULT delete_ASNH245ConferenceCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ConferenceCommand_SetChoice( void *pObject, ASNH245ConferenceCommandChoice pChoice );
HS_RESULT ASNH245ConferenceCommand_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ConferenceCommand_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceCommand_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel0,
	e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel1,
	e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2,
	e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2withOptionalHeader

} ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice;


#define e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSize		4
#define e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSizeExt	4
typedef struct
{
	ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223MultiplexReconfiguration_h223ModeChange;
HS_RESULT new_ASNH245H223MultiplexReconfiguration_h223ModeChange( void *pObject );
HS_RESULT delete_ASNH245H223MultiplexReconfiguration_h223ModeChange( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223MultiplexReconfiguration_h223ModeChange_SetChoice( void *pObject, ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice pChoice );
HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_MakeMold( void *pObject );
HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_start,
	e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_stop

} ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice;


#define e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSize		2
#define e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSizeExt	2
typedef struct
{
	ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag;
HS_RESULT new_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag( void *pObject );
HS_RESULT delete_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_SetChoice( void *pObject, ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice pChoice );
HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_MakeMold( void *pObject );
HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223MultiplexReconfigurationChoice_h223ModeChange,
	e_ASNH245H223MultiplexReconfigurationChoice_h223AnnexADoubleFlag

} ASNH245H223MultiplexReconfigurationChoice;


#define e_ASNH245H223MultiplexReconfigurationChoiceSize		2
#define e_ASNH245H223MultiplexReconfigurationChoiceSizeExt	2
typedef struct
{
	ASNH245H223MultiplexReconfigurationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223MultiplexReconfiguration;
HS_RESULT new_ASNH245H223MultiplexReconfiguration( void *pObject );
HS_RESULT delete_ASNH245H223MultiplexReconfiguration( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223MultiplexReconfiguration_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223MultiplexReconfiguration_SetChoice( void *pObject, ASNH245H223MultiplexReconfigurationChoice pChoice );
HS_RESULT ASNH245H223MultiplexReconfiguration_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223MultiplexReconfiguration_MakeMold( void *pObject );
HS_RESULT ASNH245H223MultiplexReconfiguration_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223MultiplexReconfiguration_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_nullClockRecovery,
	e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_srtsClockRecovery,
	e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery

} ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice;


#define e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSize		3
#define e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSizeExt	3
typedef struct
{
	ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCCommand_aal_aal1_clockRecovery;
HS_RESULT new_ASNH245NewATMVCCommand_aal_aal1_clockRecovery( void *pObject );
HS_RESULT delete_ASNH245NewATMVCCommand_aal_aal1_clockRecovery( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCCommand_aal_aal1_clockRecovery_SetChoice( void *pObject, ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice pChoice );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_nullErrorCorrection,
	e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_longInterleaver,
	e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_shortInterleaver,
	e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_errorCorrectionOnly

} ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice;


#define e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSize		4
#define e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSizeExt	4
typedef struct
{
	ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCCommand_aal_aal1_errorCorrection;
HS_RESULT new_ASNH245NewATMVCCommand_aal_aal1_errorCorrection( void *pObject );
HS_RESULT delete_ASNH245NewATMVCCommand_aal_aal1_errorCorrection( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCCommand_aal_aal1_errorCorrection_SetChoice( void *pObject, ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice pChoice );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245NewATMVCCommand_aal_aal1OptionMapSize 0
#define e_ASNH245NewATMVCCommand_aal_aal1OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245NewATMVCCommand_aal_aal1_clockRecovery m_clockRecovery;
	ASNH245NewATMVCCommand_aal_aal1_errorCorrection m_errorCorrection;
	AsnBoolean m_structuredDataTransfer;
	AsnBoolean m_partiallyFilledCells;
	/*...,*/
} ASNH245NewATMVCCommand_aal_aal1;
HS_RESULT new_ASNH245NewATMVCCommand_aal_aal1( void *pObject );
HS_RESULT delete_ASNH245NewATMVCCommand_aal_aal1( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245NewATMVCCommand_aal_aal5OptionMapSize 0
#define e_ASNH245NewATMVCCommand_aal_aal5OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_forwardMaximumSDUSize;
	AsnInteger m_backwardMaximumSDUSize;
	/*...,*/
} ASNH245NewATMVCCommand_aal_aal5;
HS_RESULT new_ASNH245NewATMVCCommand_aal_aal5( void *pObject );
HS_RESULT delete_ASNH245NewATMVCCommand_aal_aal5( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCCommand_aal_aal5_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NewATMVCCommand_aal_aal5_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_aal_aal5_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCCommand_aal_aal5_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCCommand_aalChoice_aal1,
	e_ASNH245NewATMVCCommand_aalChoice_aal5

} ASNH245NewATMVCCommand_aalChoice;


#define e_ASNH245NewATMVCCommand_aalChoiceSize		2
#define e_ASNH245NewATMVCCommand_aalChoiceSizeExt	2
typedef struct
{
	ASNH245NewATMVCCommand_aalChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCCommand_aal;
HS_RESULT new_ASNH245NewATMVCCommand_aal( void *pObject );
HS_RESULT delete_ASNH245NewATMVCCommand_aal( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCCommand_aal_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCCommand_aal_SetChoice( void *pObject, ASNH245NewATMVCCommand_aalChoice pChoice );
HS_RESULT ASNH245NewATMVCCommand_aal_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_aal_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_aal_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCCommand_aal_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCCommand_multiplexChoice_noMultiplex,
	e_ASNH245NewATMVCCommand_multiplexChoice_transportStream,
	e_ASNH245NewATMVCCommand_multiplexChoice_programStream

} ASNH245NewATMVCCommand_multiplexChoice;


#define e_ASNH245NewATMVCCommand_multiplexChoiceSize		3
#define e_ASNH245NewATMVCCommand_multiplexChoiceSizeExt	3
typedef struct
{
	ASNH245NewATMVCCommand_multiplexChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCCommand_multiplex;
HS_RESULT new_ASNH245NewATMVCCommand_multiplex( void *pObject );
HS_RESULT delete_ASNH245NewATMVCCommand_multiplex( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCCommand_multiplex_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCCommand_multiplex_SetChoice( void *pObject, ASNH245NewATMVCCommand_multiplexChoice pChoice );
HS_RESULT ASNH245NewATMVCCommand_multiplex_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_multiplex_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_multiplex_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCCommand_multiplex_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_noMultiplex,
	e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_transportStream,
	e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_programStream

} ASNH245NewATMVCCommand_reverseParameters_multiplexChoice;


#define e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSize		3
#define e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSizeExt	3
typedef struct
{
	ASNH245NewATMVCCommand_reverseParameters_multiplexChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCCommand_reverseParameters_multiplex;
HS_RESULT new_ASNH245NewATMVCCommand_reverseParameters_multiplex( void *pObject );
HS_RESULT delete_ASNH245NewATMVCCommand_reverseParameters_multiplex( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCCommand_reverseParameters_multiplex_SetChoice( void *pObject, ASNH245NewATMVCCommand_reverseParameters_multiplexChoice pChoice );
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245NewATMVCCommand_reverseParametersOptionMapSize 0
#define e_ASNH245NewATMVCCommand_reverseParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_bitRate;
	AsnBoolean m_bitRateLockedToPCRClock;
	AsnBoolean m_bitRateLockedToNetworkClock;
	ASNH245NewATMVCCommand_reverseParameters_multiplex m_multiplex;
	/*...,*/
} ASNH245NewATMVCCommand_reverseParameters;
HS_RESULT new_ASNH245NewATMVCCommand_reverseParameters( void *pObject );
HS_RESULT delete_ASNH245NewATMVCCommand_reverseParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245NewATMVCCommandOptionMapSize 0
#define e_ASNH245NewATMVCCommandOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_resourceID;
	AsnInteger m_bitRate;
	AsnBoolean m_bitRateLockedToPCRClock;
	AsnBoolean m_bitRateLockedToNetworkClock;
	ASNH245NewATMVCCommand_aal m_aal;
	ASNH245NewATMVCCommand_multiplex m_multiplex;
	ASNH245NewATMVCCommand_reverseParameters m_reverseParameters;
	/*...,*/
} ASNH245NewATMVCCommand;
HS_RESULT new_ASNH245NewATMVCCommand( void *pObject );
HS_RESULT delete_ASNH245NewATMVCCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NewATMVCCommand_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCCommand_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_synchronized,
	e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_reconfiguration

} ASNH245MobileMultilinkReconfigurationCommand_statusChoice;


#define e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSize		2
#define e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSizeExt	2
typedef struct
{
	ASNH245MobileMultilinkReconfigurationCommand_statusChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MobileMultilinkReconfigurationCommand_status;
HS_RESULT new_ASNH245MobileMultilinkReconfigurationCommand_status( void *pObject );
HS_RESULT delete_ASNH245MobileMultilinkReconfigurationCommand_status( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MobileMultilinkReconfigurationCommand_status_SetChoice( void *pObject, ASNH245MobileMultilinkReconfigurationCommand_statusChoice pChoice );
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_MakeMold( void *pObject );
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MobileMultilinkReconfigurationCommandOptionMapSize 0
#define e_ASNH245MobileMultilinkReconfigurationCommandOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_sampleSize;
	AsnInteger m_samplesPerFrame;
	ASNH245MobileMultilinkReconfigurationCommand_status m_status;
	/*...,*/
} ASNH245MobileMultilinkReconfigurationCommand;
HS_RESULT new_ASNH245MobileMultilinkReconfigurationCommand( void *pObject );
HS_RESULT delete_ASNH245MobileMultilinkReconfigurationCommand( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_MakeMold( void *pObject );
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245CommandMessageChoice_nonStandard,
	e_ASNH245CommandMessageChoice_maintenanceLoopOffCommand,
	e_ASNH245CommandMessageChoice_sendTerminalCapabilitySet,
	e_ASNH245CommandMessageChoice_encryptionCommand,
	e_ASNH245CommandMessageChoice_flowControlCommand,
	e_ASNH245CommandMessageChoice_endSessionCommand,
	e_ASNH245CommandMessageChoice_miscellaneousCommand
,
	e_ASNH245CommandMessageChoice_communicationModeCommand,
	e_ASNH245CommandMessageChoice_conferenceCommand,
	e_ASNH245CommandMessageChoice_h223MultiplexReconfiguration,
	e_ASNH245CommandMessageChoice_newATMVCCommand,
	e_ASNH245CommandMessageChoice_mobileMultilinkReconfigurationCommand
} ASNH245CommandMessageChoice;


#define e_ASNH245CommandMessageChoiceSize		7
#define e_ASNH245CommandMessageChoiceSizeExt	12
typedef struct
{
	ASNH245CommandMessageChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245CommandMessage;
HS_RESULT new_ASNH245CommandMessage( void *pObject );
HS_RESULT delete_ASNH245CommandMessage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CommandMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245CommandMessage_SetChoice( void *pObject, ASNH245CommandMessageChoice pChoice );
HS_RESULT ASNH245CommandMessage_DeleteAlternation( void *pObject );
HS_RESULT ASNH245CommandMessage_MakeMold( void *pObject );
HS_RESULT ASNH245CommandMessage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245CommandMessage_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245FunctionNotUnderstoodChoice_request,
	e_ASNH245FunctionNotUnderstoodChoice_response,
	e_ASNH245FunctionNotUnderstoodChoice_command
} ASNH245FunctionNotUnderstoodChoice;


#define e_ASNH245FunctionNotUnderstoodChoiceSize		3
#define e_ASNH245FunctionNotUnderstoodChoiceSizeExt	3
typedef struct
{
	ASNH245FunctionNotUnderstoodChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245FunctionNotUnderstood;
HS_RESULT new_ASNH245FunctionNotUnderstood( void *pObject );
HS_RESULT delete_ASNH245FunctionNotUnderstood( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245FunctionNotUnderstood_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245FunctionNotUnderstood_SetChoice( void *pObject, ASNH245FunctionNotUnderstoodChoice pChoice );
HS_RESULT ASNH245FunctionNotUnderstood_DeleteAlternation( void *pObject );
HS_RESULT ASNH245FunctionNotUnderstood_MakeMold( void *pObject );
HS_RESULT ASNH245FunctionNotUnderstood_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245FunctionNotUnderstood_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MasterSlaveDeterminationReleaseOptionMapSize 0
#define e_ASNH245MasterSlaveDeterminationReleaseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	/*...,*/
} ASNH245MasterSlaveDeterminationRelease;
HS_RESULT new_ASNH245MasterSlaveDeterminationRelease( void *pObject );
HS_RESULT delete_ASNH245MasterSlaveDeterminationRelease( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MasterSlaveDeterminationRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MasterSlaveDeterminationRelease_MakeMold( void *pObject );
HS_RESULT ASNH245MasterSlaveDeterminationRelease_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MasterSlaveDeterminationRelease_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245TerminalCapabilitySetReleaseOptionMapSize 0
#define e_ASNH245TerminalCapabilitySetReleaseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	/*...,*/
} ASNH245TerminalCapabilitySetRelease;
HS_RESULT new_ASNH245TerminalCapabilitySetRelease( void *pObject );
HS_RESULT delete_ASNH245TerminalCapabilitySetRelease( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalCapabilitySetRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TerminalCapabilitySetRelease_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalCapabilitySetRelease_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalCapabilitySetRelease_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245OpenLogicalChannelConfirmOptionMapSize 0
#define e_ASNH245OpenLogicalChannelConfirmOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	/*...,*/
} ASNH245OpenLogicalChannelConfirm;
HS_RESULT new_ASNH245OpenLogicalChannelConfirm( void *pObject );
HS_RESULT delete_ASNH245OpenLogicalChannelConfirm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245OpenLogicalChannelConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245OpenLogicalChannelConfirm_MakeMold( void *pObject );
HS_RESULT ASNH245OpenLogicalChannelConfirm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245OpenLogicalChannelConfirm_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestChannelCloseReleaseOptionMapSize 0
#define e_ASNH245RequestChannelCloseReleaseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_forwardLogicalChannelNumber;
	/*...,*/
} ASNH245RequestChannelCloseRelease;
HS_RESULT new_ASNH245RequestChannelCloseRelease( void *pObject );
HS_RESULT delete_ASNH245RequestChannelCloseRelease( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestChannelCloseRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestChannelCloseRelease_MakeMold( void *pObject );
HS_RESULT ASNH245RequestChannelCloseRelease_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestChannelCloseRelease_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultiplexEntrySendReleaseOptionMapSize 0
#define e_ASNH245MultiplexEntrySendReleaseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_multiplexTableEntryNumber;
	/*...,*/
} ASNH245MultiplexEntrySendRelease;
HS_RESULT new_ASNH245MultiplexEntrySendRelease( void *pObject );
HS_RESULT delete_ASNH245MultiplexEntrySendRelease( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexEntrySendRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexEntrySendRelease_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexEntrySendRelease_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexEntrySendRelease_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestMultiplexEntryReleaseOptionMapSize 0
#define e_ASNH245RequestMultiplexEntryReleaseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnSequenceOf m_entryNumbers;
	/*...,*/
} ASNH245RequestMultiplexEntryRelease;
HS_RESULT new_ASNH245RequestMultiplexEntryRelease( void *pObject );
HS_RESULT delete_ASNH245RequestMultiplexEntryRelease( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestMultiplexEntryRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestMultiplexEntryRelease_MakeMold( void *pObject );
HS_RESULT ASNH245RequestMultiplexEntryRelease_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestMultiplexEntryRelease_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245RequestModeReleaseOptionMapSize 0
#define e_ASNH245RequestModeReleaseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	/*...,*/
} ASNH245RequestModeRelease;
HS_RESULT new_ASNH245RequestModeRelease( void *pObject );
HS_RESULT delete_ASNH245RequestModeRelease( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RequestModeRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RequestModeRelease_MakeMold( void *pObject );
HS_RESULT ASNH245RequestModeRelease_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RequestModeRelease_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MiscellaneousIndication_type_videoNotDecodedMBsOptionMapSize 0
#define e_ASNH245MiscellaneousIndication_type_videoNotDecodedMBsOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_firstMB;
	AsnInteger m_numberOfMBs;
	AsnInteger m_temporalReference;
	/*...,*/
} ASNH245MiscellaneousIndication_type_videoNotDecodedMBs;
HS_RESULT new_ASNH245MiscellaneousIndication_type_videoNotDecodedMBs( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousIndication_type_videoNotDecodedMBs( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelActive,
	e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelInactive,
	e_ASNH245MiscellaneousIndication_typeChoice_multipointConference,
	e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointConference,
	e_ASNH245MiscellaneousIndication_typeChoice_multipointZeroComm,
	e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointZeroComm,
	e_ASNH245MiscellaneousIndication_typeChoice_multipointSecondaryStatus,
	e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointSecondaryStatus,
	e_ASNH245MiscellaneousIndication_typeChoice_videoIndicateReadyToActivate,
	e_ASNH245MiscellaneousIndication_typeChoice_videoTemporalSpatialTradeOff
,
	e_ASNH245MiscellaneousIndication_typeChoice_videoNotDecodedMBs,
	e_ASNH245MiscellaneousIndication_typeChoice_transportCapability
} ASNH245MiscellaneousIndication_typeChoice;


#define e_ASNH245MiscellaneousIndication_typeChoiceSize		10
#define e_ASNH245MiscellaneousIndication_typeChoiceSizeExt	12
typedef struct
{
	ASNH245MiscellaneousIndication_typeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MiscellaneousIndication_type;
HS_RESULT new_ASNH245MiscellaneousIndication_type( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousIndication_type( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousIndication_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MiscellaneousIndication_type_SetChoice( void *pObject, ASNH245MiscellaneousIndication_typeChoice pChoice );
HS_RESULT ASNH245MiscellaneousIndication_type_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MiscellaneousIndication_type_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousIndication_type_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousIndication_type_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MiscellaneousIndicationOptionMapSize 0
#define e_ASNH245MiscellaneousIndicationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_logicalChannelNumber;
	ASNH245MiscellaneousIndication_type m_type;
	/*...,*/
} ASNH245MiscellaneousIndication;
HS_RESULT new_ASNH245MiscellaneousIndication( void *pObject );
HS_RESULT delete_ASNH245MiscellaneousIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MiscellaneousIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MiscellaneousIndication_MakeMold( void *pObject );
HS_RESULT ASNH245MiscellaneousIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MiscellaneousIndication_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245JitterIndication_scopeChoice_logicalChannelNumber,
	e_ASNH245JitterIndication_scopeChoice_resourceID,
	e_ASNH245JitterIndication_scopeChoice_wholeMultiplex
} ASNH245JitterIndication_scopeChoice;


#define e_ASNH245JitterIndication_scopeChoiceSize		3
#define e_ASNH245JitterIndication_scopeChoiceSizeExt	3
typedef struct
{
	ASNH245JitterIndication_scopeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245JitterIndication_scope;
HS_RESULT new_ASNH245JitterIndication_scope( void *pObject );
HS_RESULT delete_ASNH245JitterIndication_scope( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245JitterIndication_scope_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245JitterIndication_scope_SetChoice( void *pObject, ASNH245JitterIndication_scopeChoice pChoice );
HS_RESULT ASNH245JitterIndication_scope_DeleteAlternation( void *pObject );
HS_RESULT ASNH245JitterIndication_scope_MakeMold( void *pObject );
HS_RESULT ASNH245JitterIndication_scope_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245JitterIndication_scope_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245JitterIndicationOptionMap_skippedFrameCount,
	e_ASNH245JitterIndicationOptionMap_additionalDecoderBuffer

} ASNH245JitterIndicationOptionMap;


#define e_ASNH245JitterIndicationOptionMapSize 2
#define e_ASNH245JitterIndicationOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245JitterIndication_scope m_scope;
	AsnInteger m_estimatedReceivedJitterMantissa;
	AsnInteger m_estimatedReceivedJitterExponent;
	AsnInteger m_skippedFrameCount;
	AsnInteger m_additionalDecoderBuffer;
	/*...,*/
} ASNH245JitterIndication;
HS_RESULT new_ASNH245JitterIndication( void *pObject );
HS_RESULT delete_ASNH245JitterIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245JitterIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245JitterIndication_IncludeOptionField( void *pObject, ASNH245JitterIndicationOptionMap pOptionMap );
BOOL	  ASNH245JitterIndication_IsIncludeOptionField( void *pObject, ASNH245JitterIndicationOptionMap pOptionMap );
HS_RESULT ASNH245JitterIndication_MakeMold( void *pObject );
HS_RESULT ASNH245JitterIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245JitterIndication_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223SkewIndicationOptionMapSize 0
#define e_ASNH245H223SkewIndicationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_logicalChannelNumber1;
	ASNH245LogicalChannelNumber m_logicalChannelNumber2;
	AsnInteger m_skew;
	/*...,*/
} ASNH245H223SkewIndication;
HS_RESULT new_ASNH245H223SkewIndication( void *pObject );
HS_RESULT delete_ASNH245H223SkewIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223SkewIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223SkewIndication_MakeMold( void *pObject );
HS_RESULT ASNH245H223SkewIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223SkewIndication_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_nullClockRecovery,
	e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_srtsClockRecovery,
	e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery

} ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice;


#define e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSize		3
#define e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSizeExt	3
typedef struct
{
	ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCIndication_aal_aal1_clockRecovery;
HS_RESULT new_ASNH245NewATMVCIndication_aal_aal1_clockRecovery( void *pObject );
HS_RESULT delete_ASNH245NewATMVCIndication_aal_aal1_clockRecovery( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCIndication_aal_aal1_clockRecovery_SetChoice( void *pObject, ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice pChoice );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_nullErrorCorrection,
	e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_longInterleaver,
	e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_shortInterleaver,
	e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_errorCorrectionOnly

} ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice;


#define e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSize		4
#define e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSizeExt	4
typedef struct
{
	ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCIndication_aal_aal1_errorCorrection;
HS_RESULT new_ASNH245NewATMVCIndication_aal_aal1_errorCorrection( void *pObject );
HS_RESULT delete_ASNH245NewATMVCIndication_aal_aal1_errorCorrection( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCIndication_aal_aal1_errorCorrection_SetChoice( void *pObject, ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice pChoice );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245NewATMVCIndication_aal_aal1OptionMapSize 0
#define e_ASNH245NewATMVCIndication_aal_aal1OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245NewATMVCIndication_aal_aal1_clockRecovery m_clockRecovery;
	ASNH245NewATMVCIndication_aal_aal1_errorCorrection m_errorCorrection;
	AsnBoolean m_structuredDataTransfer;
	AsnBoolean m_partiallyFilledCells;
	/*...,*/
} ASNH245NewATMVCIndication_aal_aal1;
HS_RESULT new_ASNH245NewATMVCIndication_aal_aal1( void *pObject );
HS_RESULT delete_ASNH245NewATMVCIndication_aal_aal1( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245NewATMVCIndication_aal_aal5OptionMapSize 0
#define e_ASNH245NewATMVCIndication_aal_aal5OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_forwardMaximumSDUSize;
	AsnInteger m_backwardMaximumSDUSize;
	/*...,*/
} ASNH245NewATMVCIndication_aal_aal5;
HS_RESULT new_ASNH245NewATMVCIndication_aal_aal5( void *pObject );
HS_RESULT delete_ASNH245NewATMVCIndication_aal_aal5( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCIndication_aal_aal5_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NewATMVCIndication_aal_aal5_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_aal_aal5_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCIndication_aal_aal5_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCIndication_aalChoice_aal1,
	e_ASNH245NewATMVCIndication_aalChoice_aal5

} ASNH245NewATMVCIndication_aalChoice;


#define e_ASNH245NewATMVCIndication_aalChoiceSize		2
#define e_ASNH245NewATMVCIndication_aalChoiceSizeExt	2
typedef struct
{
	ASNH245NewATMVCIndication_aalChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCIndication_aal;
HS_RESULT new_ASNH245NewATMVCIndication_aal( void *pObject );
HS_RESULT delete_ASNH245NewATMVCIndication_aal( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCIndication_aal_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCIndication_aal_SetChoice( void *pObject, ASNH245NewATMVCIndication_aalChoice pChoice );
HS_RESULT ASNH245NewATMVCIndication_aal_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_aal_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_aal_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCIndication_aal_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCIndication_multiplexChoice_noMultiplex,
	e_ASNH245NewATMVCIndication_multiplexChoice_transportStream,
	e_ASNH245NewATMVCIndication_multiplexChoice_programStream

} ASNH245NewATMVCIndication_multiplexChoice;


#define e_ASNH245NewATMVCIndication_multiplexChoiceSize		3
#define e_ASNH245NewATMVCIndication_multiplexChoiceSizeExt	3
typedef struct
{
	ASNH245NewATMVCIndication_multiplexChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCIndication_multiplex;
HS_RESULT new_ASNH245NewATMVCIndication_multiplex( void *pObject );
HS_RESULT delete_ASNH245NewATMVCIndication_multiplex( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCIndication_multiplex_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCIndication_multiplex_SetChoice( void *pObject, ASNH245NewATMVCIndication_multiplexChoice pChoice );
HS_RESULT ASNH245NewATMVCIndication_multiplex_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_multiplex_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_multiplex_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCIndication_multiplex_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_noMultiplex,
	e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_transportStream,
	e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_programStream

} ASNH245NewATMVCIndication_reverseParameters_multiplexChoice;


#define e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSize		3
#define e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSizeExt	3
typedef struct
{
	ASNH245NewATMVCIndication_reverseParameters_multiplexChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245NewATMVCIndication_reverseParameters_multiplex;
HS_RESULT new_ASNH245NewATMVCIndication_reverseParameters_multiplex( void *pObject );
HS_RESULT delete_ASNH245NewATMVCIndication_reverseParameters_multiplex( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245NewATMVCIndication_reverseParameters_multiplex_SetChoice( void *pObject, ASNH245NewATMVCIndication_reverseParameters_multiplexChoice pChoice );
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_DeleteAlternation( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245NewATMVCIndication_reverseParametersOptionMapSize 0
#define e_ASNH245NewATMVCIndication_reverseParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_bitRate;
	AsnBoolean m_bitRateLockedToPCRClock;
	AsnBoolean m_bitRateLockedToNetworkClock;
	ASNH245NewATMVCIndication_reverseParameters_multiplex m_multiplex;
	/*...,*/
} ASNH245NewATMVCIndication_reverseParameters;
HS_RESULT new_ASNH245NewATMVCIndication_reverseParameters( void *pObject );
HS_RESULT delete_ASNH245NewATMVCIndication_reverseParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245NewATMVCIndicationOptionMap_reverseParameters
} ASNH245NewATMVCIndicationOptionMap;


#define e_ASNH245NewATMVCIndicationOptionMapSize 0
#define e_ASNH245NewATMVCIndicationOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_resourceID;
	AsnInteger m_bitRate;
	AsnBoolean m_bitRateLockedToPCRClock;
	AsnBoolean m_bitRateLockedToNetworkClock;
	ASNH245NewATMVCIndication_aal m_aal;
	ASNH245NewATMVCIndication_multiplex m_multiplex;
	/*...,*/
	ASNH245NewATMVCIndication_reverseParameters m_reverseParameters;
} ASNH245NewATMVCIndication;
HS_RESULT new_ASNH245NewATMVCIndication( void *pObject );
HS_RESULT delete_ASNH245NewATMVCIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245NewATMVCIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245NewATMVCIndication_IncludeOptionField( void *pObject, ASNH245NewATMVCIndicationOptionMap pOptionMap );
BOOL	  ASNH245NewATMVCIndication_IsIncludeOptionField( void *pObject, ASNH245NewATMVCIndicationOptionMap pOptionMap );
HS_RESULT ASNH245NewATMVCIndication_MakeMold( void *pObject );
HS_RESULT ASNH245NewATMVCIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245NewATMVCIndication_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245UserInputIndication_userInputSupportIndicationChoice_nonStandard,
	e_ASNH245UserInputIndication_userInputSupportIndicationChoice_basicString,
	e_ASNH245UserInputIndication_userInputSupportIndicationChoice_iA5String,
	e_ASNH245UserInputIndication_userInputSupportIndicationChoice_generalString

} ASNH245UserInputIndication_userInputSupportIndicationChoice;


#define e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSize		4
#define e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSizeExt	4
typedef struct
{
	ASNH245UserInputIndication_userInputSupportIndicationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245UserInputIndication_userInputSupportIndication;
HS_RESULT new_ASNH245UserInputIndication_userInputSupportIndication( void *pObject );
HS_RESULT delete_ASNH245UserInputIndication_userInputSupportIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245UserInputIndication_userInputSupportIndication_SetChoice( void *pObject, ASNH245UserInputIndication_userInputSupportIndicationChoice pChoice );
HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_DeleteAlternation( void *pObject );
HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_MakeMold( void *pObject );
HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245UserInputIndication_signal_rtpOptionMap_timestamp,
	e_ASNH245UserInputIndication_signal_rtpOptionMap_expirationTime

} ASNH245UserInputIndication_signal_rtpOptionMap;


#define e_ASNH245UserInputIndication_signal_rtpOptionMapSize 2
#define e_ASNH245UserInputIndication_signal_rtpOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_timestamp;
	AsnInteger m_expirationTime;
	ASNH245LogicalChannelNumber m_logicalChannelNumber;
	/*...,*/
} ASNH245UserInputIndication_signal_rtp;
HS_RESULT new_ASNH245UserInputIndication_signal_rtp( void *pObject );
HS_RESULT delete_ASNH245UserInputIndication_signal_rtp( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UserInputIndication_signal_rtp_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245UserInputIndication_signal_rtp_IncludeOptionField( void *pObject, ASNH245UserInputIndication_signal_rtpOptionMap pOptionMap );
BOOL	  ASNH245UserInputIndication_signal_rtp_IsIncludeOptionField( void *pObject, ASNH245UserInputIndication_signal_rtpOptionMap pOptionMap );
HS_RESULT ASNH245UserInputIndication_signal_rtp_MakeMold( void *pObject );
HS_RESULT ASNH245UserInputIndication_signal_rtp_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UserInputIndication_signal_rtp_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245UserInputIndication_signalOptionMap_duration,
	e_ASNH245UserInputIndication_signalOptionMap_rtp
,
	e_ASNH245UserInputIndication_signalOptionMap_rtpPayloadIndication
} ASNH245UserInputIndication_signalOptionMap;


#define e_ASNH245UserInputIndication_signalOptionMapSize 2
#define e_ASNH245UserInputIndication_signalOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSingleString m_signalType;
	AsnInteger m_duration;
	ASNH245UserInputIndication_signal_rtp m_rtp;
	/*...,*/
	AsnNull m_rtpPayloadIndication;
} ASNH245UserInputIndication_signal;
HS_RESULT new_ASNH245UserInputIndication_signal( void *pObject );
HS_RESULT delete_ASNH245UserInputIndication_signal( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UserInputIndication_signal_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245UserInputIndication_signal_IncludeOptionField( void *pObject, ASNH245UserInputIndication_signalOptionMap pOptionMap );
BOOL	  ASNH245UserInputIndication_signal_IsIncludeOptionField( void *pObject, ASNH245UserInputIndication_signalOptionMap pOptionMap );
HS_RESULT ASNH245UserInputIndication_signal_MakeMold( void *pObject );
HS_RESULT ASNH245UserInputIndication_signal_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UserInputIndication_signal_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245UserInputIndication_signalUpdate_rtpOptionMapSize 0
#define e_ASNH245UserInputIndication_signalUpdate_rtpOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_logicalChannelNumber;
	/*...,*/
} ASNH245UserInputIndication_signalUpdate_rtp;
HS_RESULT new_ASNH245UserInputIndication_signalUpdate_rtp( void *pObject );
HS_RESULT delete_ASNH245UserInputIndication_signalUpdate_rtp( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UserInputIndication_signalUpdate_rtp_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245UserInputIndication_signalUpdate_rtp_MakeMold( void *pObject );
HS_RESULT ASNH245UserInputIndication_signalUpdate_rtp_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UserInputIndication_signalUpdate_rtp_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245UserInputIndication_signalUpdateOptionMap_rtp

} ASNH245UserInputIndication_signalUpdateOptionMap;


#define e_ASNH245UserInputIndication_signalUpdateOptionMapSize 1
#define e_ASNH245UserInputIndication_signalUpdateOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnInteger m_duration;
	ASNH245UserInputIndication_signalUpdate_rtp m_rtp;
	/*...,*/
} ASNH245UserInputIndication_signalUpdate;
HS_RESULT new_ASNH245UserInputIndication_signalUpdate( void *pObject );
HS_RESULT delete_ASNH245UserInputIndication_signalUpdate( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UserInputIndication_signalUpdate_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245UserInputIndication_signalUpdate_IncludeOptionField( void *pObject, ASNH245UserInputIndication_signalUpdateOptionMap pOptionMap );
BOOL	  ASNH245UserInputIndication_signalUpdate_IsIncludeOptionField( void *pObject, ASNH245UserInputIndication_signalUpdateOptionMap pOptionMap );
HS_RESULT ASNH245UserInputIndication_signalUpdate_MakeMold( void *pObject );
HS_RESULT ASNH245UserInputIndication_signalUpdate_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UserInputIndication_signalUpdate_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245UserInputIndication_extendedAlphanumericOptionMap_rtpPayloadIndication

} ASNH245UserInputIndication_extendedAlphanumericOptionMap;


#define e_ASNH245UserInputIndication_extendedAlphanumericOptionMapSize 1
#define e_ASNH245UserInputIndication_extendedAlphanumericOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnSingleString m_alphanumeric;
	AsnNull m_rtpPayloadIndication;
	/*...,*/
} ASNH245UserInputIndication_extendedAlphanumeric;
HS_RESULT new_ASNH245UserInputIndication_extendedAlphanumeric( void *pObject );
HS_RESULT delete_ASNH245UserInputIndication_extendedAlphanumeric( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_IncludeOptionField( void *pObject, ASNH245UserInputIndication_extendedAlphanumericOptionMap pOptionMap );
BOOL	  ASNH245UserInputIndication_extendedAlphanumeric_IsIncludeOptionField( void *pObject, ASNH245UserInputIndication_extendedAlphanumericOptionMap pOptionMap );
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_MakeMold( void *pObject );
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245UserInputIndicationChoice_nonStandard,
	e_ASNH245UserInputIndicationChoice_alphanumeric
,
	e_ASNH245UserInputIndicationChoice_userInputSupportIndication,
	e_ASNH245UserInputIndicationChoice_signal,
	e_ASNH245UserInputIndicationChoice_signalUpdate,
	e_ASNH245UserInputIndicationChoice_extendedAlphanumeric
} ASNH245UserInputIndicationChoice;


#define e_ASNH245UserInputIndicationChoiceSize		2
#define e_ASNH245UserInputIndicationChoiceSizeExt	6
typedef struct
{
	ASNH245UserInputIndicationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245UserInputIndication;
HS_RESULT new_ASNH245UserInputIndication( void *pObject );
HS_RESULT delete_ASNH245UserInputIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245UserInputIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245UserInputIndication_SetChoice( void *pObject, ASNH245UserInputIndicationChoice pChoice );
HS_RESULT ASNH245UserInputIndication_DeleteAlternation( void *pObject );
HS_RESULT ASNH245UserInputIndication_MakeMold( void *pObject );
HS_RESULT ASNH245UserInputIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245UserInputIndication_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H2250MaximumSkewIndicationOptionMapSize 0
#define e_ASNH245H2250MaximumSkewIndicationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_logicalChannelNumber1;
	ASNH245LogicalChannelNumber m_logicalChannelNumber2;
	AsnInteger m_maximumSkew;
	/*...,*/
} ASNH245H2250MaximumSkewIndication;
HS_RESULT new_ASNH245H2250MaximumSkewIndication( void *pObject );
HS_RESULT delete_ASNH245H2250MaximumSkewIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H2250MaximumSkewIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H2250MaximumSkewIndication_MakeMold( void *pObject );
HS_RESULT ASNH245H2250MaximumSkewIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H2250MaximumSkewIndication_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MCLocationIndicationOptionMapSize 0
#define e_ASNH245MCLocationIndicationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245TransportAddress m_signalAddress;
	/*...,*/
} ASNH245MCLocationIndication;
HS_RESULT new_ASNH245MCLocationIndication( void *pObject );
HS_RESULT delete_ASNH245MCLocationIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MCLocationIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MCLocationIndication_MakeMold( void *pObject );
HS_RESULT ASNH245MCLocationIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MCLocationIndication_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245TerminalYouAreSeeingInSubPictureNumberOptionMapSize 0
#define e_ASNH245TerminalYouAreSeeingInSubPictureNumberOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245TerminalNumber m_terminalNumber;
	AsnInteger m_subPictureNumber;
	/*...,*/
} ASNH245TerminalYouAreSeeingInSubPictureNumber;
HS_RESULT new_ASNH245TerminalYouAreSeeingInSubPictureNumber( void *pObject );
HS_RESULT delete_ASNH245TerminalYouAreSeeingInSubPictureNumber( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalYouAreSeeingInSubPictureNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245TerminalYouAreSeeingInSubPictureNumber_MakeMold( void *pObject );
HS_RESULT ASNH245TerminalYouAreSeeingInSubPictureNumber_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245TerminalYouAreSeeingInSubPictureNumber_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245VideoIndicateComposeOptionMapSize 0
#define e_ASNH245VideoIndicateComposeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_compositionNumber;
	/*...,*/
} ASNH245VideoIndicateCompose;
HS_RESULT new_ASNH245VideoIndicateCompose( void *pObject );
HS_RESULT delete_ASNH245VideoIndicateCompose( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VideoIndicateCompose_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245VideoIndicateCompose_MakeMold( void *pObject );
HS_RESULT ASNH245VideoIndicateCompose_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VideoIndicateCompose_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ConferenceIndicationChoice_sbeNumber,
	e_ASNH245ConferenceIndicationChoice_terminalNumberAssign,
	e_ASNH245ConferenceIndicationChoice_terminalJoinedConference,
	e_ASNH245ConferenceIndicationChoice_terminalLeftConference,
	e_ASNH245ConferenceIndicationChoice_seenByAtLeastOneOther,
	e_ASNH245ConferenceIndicationChoice_cancelSeenByAtLeastOneOther,
	e_ASNH245ConferenceIndicationChoice_seenByAll,
	e_ASNH245ConferenceIndicationChoice_cancelSeenByAll,
	e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeing,
	e_ASNH245ConferenceIndicationChoice_requestForFloor
,
	e_ASNH245ConferenceIndicationChoice_withdrawChairToken,
	e_ASNH245ConferenceIndicationChoice_floorRequested,
	e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeingInSubPictureNumber,
	e_ASNH245ConferenceIndicationChoice_videoIndicateCompose
} ASNH245ConferenceIndicationChoice;


#define e_ASNH245ConferenceIndicationChoiceSize		10
#define e_ASNH245ConferenceIndicationChoiceSizeExt	14
typedef struct
{
	ASNH245ConferenceIndicationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ConferenceIndication;
HS_RESULT new_ASNH245ConferenceIndication( void *pObject );
HS_RESULT delete_ASNH245ConferenceIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ConferenceIndication_SetChoice( void *pObject, ASNH245ConferenceIndicationChoice pChoice );
HS_RESULT ASNH245ConferenceIndication_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ConferenceIndication_MakeMold( void *pObject );
HS_RESULT ASNH245ConferenceIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ConferenceIndication_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245VendorIdentificationOptionMap_productNumber,
	e_ASNH245VendorIdentificationOptionMap_versionNumber

} ASNH245VendorIdentificationOptionMap;


#define e_ASNH245VendorIdentificationOptionMapSize 2
#define e_ASNH245VendorIdentificationOptionMapSizeExt 2
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245NonStandardIdentifier m_vendor;
	AsnOctetString m_productNumber;
	AsnOctetString m_versionNumber;
	/*...,*/
} ASNH245VendorIdentification;
HS_RESULT new_ASNH245VendorIdentification( void *pObject );
HS_RESULT delete_ASNH245VendorIdentification( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VendorIdentification_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245VendorIdentification_IncludeOptionField( void *pObject, ASNH245VendorIdentificationOptionMap pOptionMap );
BOOL	  ASNH245VendorIdentification_IsIncludeOptionField( void *pObject, ASNH245VendorIdentificationOptionMap pOptionMap );
HS_RESULT ASNH245VendorIdentification_MakeMold( void *pObject );
HS_RESULT ASNH245VendorIdentification_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VendorIdentification_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245FunctionNotSupported_causeChoice_syntaxError,
	e_ASNH245FunctionNotSupported_causeChoice_semanticError,
	e_ASNH245FunctionNotSupported_causeChoice_unknownFunction

} ASNH245FunctionNotSupported_causeChoice;


#define e_ASNH245FunctionNotSupported_causeChoiceSize		3
#define e_ASNH245FunctionNotSupported_causeChoiceSizeExt	3
typedef struct
{
	ASNH245FunctionNotSupported_causeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245FunctionNotSupported_cause;
HS_RESULT new_ASNH245FunctionNotSupported_cause( void *pObject );
HS_RESULT delete_ASNH245FunctionNotSupported_cause( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245FunctionNotSupported_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245FunctionNotSupported_cause_SetChoice( void *pObject, ASNH245FunctionNotSupported_causeChoice pChoice );
HS_RESULT ASNH245FunctionNotSupported_cause_DeleteAlternation( void *pObject );
HS_RESULT ASNH245FunctionNotSupported_cause_MakeMold( void *pObject );
HS_RESULT ASNH245FunctionNotSupported_cause_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245FunctionNotSupported_cause_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245FunctionNotSupportedOptionMap_returnedFunction

} ASNH245FunctionNotSupportedOptionMap;


#define e_ASNH245FunctionNotSupportedOptionMapSize 1
#define e_ASNH245FunctionNotSupportedOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245FunctionNotSupported_cause m_cause;
	AsnOctetString m_returnedFunction;
	/*...,*/
} ASNH245FunctionNotSupported;
HS_RESULT new_ASNH245FunctionNotSupported( void *pObject );
HS_RESULT delete_ASNH245FunctionNotSupported( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245FunctionNotSupported_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245FunctionNotSupported_IncludeOptionField( void *pObject, ASNH245FunctionNotSupportedOptionMap pOptionMap );
BOOL	  ASNH245FunctionNotSupported_IsIncludeOptionField( void *pObject, ASNH245FunctionNotSupportedOptionMap pOptionMap );
HS_RESULT ASNH245FunctionNotSupported_MakeMold( void *pObject );
HS_RESULT ASNH245FunctionNotSupported_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245FunctionNotSupported_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkIndication_crcDesiredOptionMapSize 0
#define e_ASNH245MultilinkIndication_crcDesiredOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	/*...,*/
} ASNH245MultilinkIndication_crcDesired;
HS_RESULT new_ASNH245MultilinkIndication_crcDesired( void *pObject );
HS_RESULT delete_ASNH245MultilinkIndication_crcDesired( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkIndication_crcDesired_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkIndication_crcDesired_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkIndication_crcDesired_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkIndication_crcDesired_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultilinkIndication_excessiveErrorOptionMapSize 0
#define e_ASNH245MultilinkIndication_excessiveErrorOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245ConnectionIdentifier m_connectionIdentifier;
	/*...,*/
} ASNH245MultilinkIndication_excessiveError;
HS_RESULT new_ASNH245MultilinkIndication_excessiveError( void *pObject );
HS_RESULT delete_ASNH245MultilinkIndication_excessiveError( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkIndication_excessiveError_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultilinkIndication_excessiveError_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkIndication_excessiveError_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkIndication_excessiveError_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultilinkIndicationChoice_nonStandard,
	e_ASNH245MultilinkIndicationChoice_crcDesired,
	e_ASNH245MultilinkIndicationChoice_excessiveError

} ASNH245MultilinkIndicationChoice;


#define e_ASNH245MultilinkIndicationChoiceSize		3
#define e_ASNH245MultilinkIndicationChoiceSizeExt	3
typedef struct
{
	ASNH245MultilinkIndicationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultilinkIndication;
HS_RESULT new_ASNH245MultilinkIndication( void *pObject );
HS_RESULT delete_ASNH245MultilinkIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultilinkIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultilinkIndication_SetChoice( void *pObject, ASNH245MultilinkIndicationChoice pChoice );
HS_RESULT ASNH245MultilinkIndication_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultilinkIndication_MakeMold( void *pObject );
HS_RESULT ASNH245MultilinkIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultilinkIndication_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245LogicalChannelRateReleaseOptionMapSize 0
#define e_ASNH245LogicalChannelRateReleaseOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	/*...,*/
} ASNH245LogicalChannelRateRelease;
HS_RESULT new_ASNH245LogicalChannelRateRelease( void *pObject );
HS_RESULT delete_ASNH245LogicalChannelRateRelease( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245LogicalChannelRateRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245LogicalChannelRateRelease_MakeMold( void *pObject );
HS_RESULT ASNH245LogicalChannelRateRelease_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245LogicalChannelRateRelease_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245FlowControlIndication_scopeChoice_logicalChannelNumber,
	e_ASNH245FlowControlIndication_scopeChoice_resourceID,
	e_ASNH245FlowControlIndication_scopeChoice_wholeMultiplex
} ASNH245FlowControlIndication_scopeChoice;


#define e_ASNH245FlowControlIndication_scopeChoiceSize		3
#define e_ASNH245FlowControlIndication_scopeChoiceSizeExt	3
typedef struct
{
	ASNH245FlowControlIndication_scopeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245FlowControlIndication_scope;
HS_RESULT new_ASNH245FlowControlIndication_scope( void *pObject );
HS_RESULT delete_ASNH245FlowControlIndication_scope( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245FlowControlIndication_scope_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245FlowControlIndication_scope_SetChoice( void *pObject, ASNH245FlowControlIndication_scopeChoice pChoice );
HS_RESULT ASNH245FlowControlIndication_scope_DeleteAlternation( void *pObject );
HS_RESULT ASNH245FlowControlIndication_scope_MakeMold( void *pObject );
HS_RESULT ASNH245FlowControlIndication_scope_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245FlowControlIndication_scope_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245FlowControlIndication_restrictionChoice_maximumBitRate,
	e_ASNH245FlowControlIndication_restrictionChoice_noRestriction
} ASNH245FlowControlIndication_restrictionChoice;


#define e_ASNH245FlowControlIndication_restrictionChoiceSize		2
#define e_ASNH245FlowControlIndication_restrictionChoiceSizeExt	2
typedef struct
{
	ASNH245FlowControlIndication_restrictionChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245FlowControlIndication_restriction;
HS_RESULT new_ASNH245FlowControlIndication_restriction( void *pObject );
HS_RESULT delete_ASNH245FlowControlIndication_restriction( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245FlowControlIndication_restriction_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245FlowControlIndication_restriction_SetChoice( void *pObject, ASNH245FlowControlIndication_restrictionChoice pChoice );
HS_RESULT ASNH245FlowControlIndication_restriction_DeleteAlternation( void *pObject );
HS_RESULT ASNH245FlowControlIndication_restriction_MakeMold( void *pObject );
HS_RESULT ASNH245FlowControlIndication_restriction_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245FlowControlIndication_restriction_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245FlowControlIndicationOptionMapSize 0
#define e_ASNH245FlowControlIndicationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245FlowControlIndication_scope m_scope;
	ASNH245FlowControlIndication_restriction m_restriction;
	/*...,*/
} ASNH245FlowControlIndication;
HS_RESULT new_ASNH245FlowControlIndication( void *pObject );
HS_RESULT delete_ASNH245FlowControlIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245FlowControlIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245FlowControlIndication_MakeMold( void *pObject );
HS_RESULT ASNH245FlowControlIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245FlowControlIndication_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MobileMultilinkReconfigurationIndicationOptionMapSize 0
#define e_ASNH245MobileMultilinkReconfigurationIndicationOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_sampleSize;
	AsnInteger m_samplesPerFrame;
	/*...,*/
} ASNH245MobileMultilinkReconfigurationIndication;
HS_RESULT new_ASNH245MobileMultilinkReconfigurationIndication( void *pObject );
HS_RESULT delete_ASNH245MobileMultilinkReconfigurationIndication( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MobileMultilinkReconfigurationIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MobileMultilinkReconfigurationIndication_MakeMold( void *pObject );
HS_RESULT ASNH245MobileMultilinkReconfigurationIndication_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MobileMultilinkReconfigurationIndication_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IndicationMessageChoice_nonStandard,
	e_ASNH245IndicationMessageChoice_functionNotUnderstood,
	e_ASNH245IndicationMessageChoice_masterSlaveDeterminationRelease,
	e_ASNH245IndicationMessageChoice_terminalCapabilitySetRelease,
	e_ASNH245IndicationMessageChoice_openLogicalChannelConfirm,
	e_ASNH245IndicationMessageChoice_requestChannelCloseRelease,
	e_ASNH245IndicationMessageChoice_multiplexEntrySendRelease,
	e_ASNH245IndicationMessageChoice_requestMultiplexEntryRelease,
	e_ASNH245IndicationMessageChoice_requestModeRelease,
	e_ASNH245IndicationMessageChoice_miscellaneousIndication,
	e_ASNH245IndicationMessageChoice_jitterIndication,
	e_ASNH245IndicationMessageChoice_h223SkewIndication,
	e_ASNH245IndicationMessageChoice_newATMVCIndication,
	e_ASNH245IndicationMessageChoice_userInput
,
	e_ASNH245IndicationMessageChoice_h2250MaximumSkewIndication,
	e_ASNH245IndicationMessageChoice_mcLocationIndication,
	e_ASNH245IndicationMessageChoice_conferenceIndication,
	e_ASNH245IndicationMessageChoice_vendorIdentification,
	e_ASNH245IndicationMessageChoice_functionNotSupported,
	e_ASNH245IndicationMessageChoice_multilinkIndication,
	e_ASNH245IndicationMessageChoice_logicalChannelRateRelease,
	e_ASNH245IndicationMessageChoice_flowControlIndication,
	e_ASNH245IndicationMessageChoice_mobileMultilinkReconfigurationIndication
} ASNH245IndicationMessageChoice;


#define e_ASNH245IndicationMessageChoiceSize		14
#define e_ASNH245IndicationMessageChoiceSizeExt	23
typedef struct
{
	ASNH245IndicationMessageChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245IndicationMessage;
HS_RESULT new_ASNH245IndicationMessage( void *pObject );
HS_RESULT delete_ASNH245IndicationMessage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IndicationMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245IndicationMessage_SetChoice( void *pObject, ASNH245IndicationMessageChoice pChoice );
HS_RESULT ASNH245IndicationMessage_DeleteAlternation( void *pObject );
HS_RESULT ASNH245IndicationMessage_MakeMold( void *pObject );
HS_RESULT ASNH245IndicationMessage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IndicationMessage_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MultimediaSystemControlMessageChoice_request,
	e_ASNH245MultimediaSystemControlMessageChoice_response,
	e_ASNH245MultimediaSystemControlMessageChoice_command,
	e_ASNH245MultimediaSystemControlMessageChoice_indication

} ASNH245MultimediaSystemControlMessageChoice;


#define e_ASNH245MultimediaSystemControlMessageChoiceSize		4
#define e_ASNH245MultimediaSystemControlMessageChoiceSizeExt	4
typedef struct
{
	ASNH245MultimediaSystemControlMessageChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MultimediaSystemControlMessage;
HS_RESULT new_ASNH245MultimediaSystemControlMessage( void *pObject );
HS_RESULT delete_ASNH245MultimediaSystemControlMessage( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultimediaSystemControlMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MultimediaSystemControlMessage_SetChoice( void *pObject, ASNH245MultimediaSystemControlMessageChoice pChoice );
HS_RESULT ASNH245MultimediaSystemControlMessage_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MultimediaSystemControlMessage_MakeMold( void *pObject );
HS_RESULT ASNH245MultimediaSystemControlMessage_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultimediaSystemControlMessage_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245MediaEncryptionAlgorithmChoice_nonStandard,
	e_ASNH245MediaEncryptionAlgorithmChoice_algorithm

} ASNH245MediaEncryptionAlgorithmChoice;


#define e_ASNH245MediaEncryptionAlgorithmChoiceSize		2
#define e_ASNH245MediaEncryptionAlgorithmChoiceSizeExt	2
typedef struct
{
	ASNH245MediaEncryptionAlgorithmChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245MediaEncryptionAlgorithm;
HS_RESULT new_ASNH245MediaEncryptionAlgorithm( void *pObject );
HS_RESULT delete_ASNH245MediaEncryptionAlgorithm( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MediaEncryptionAlgorithm_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245MediaEncryptionAlgorithm_SetChoice( void *pObject, ASNH245MediaEncryptionAlgorithmChoice pChoice );
HS_RESULT ASNH245MediaEncryptionAlgorithm_DeleteAlternation( void *pObject );
HS_RESULT ASNH245MediaEncryptionAlgorithm_MakeMold( void *pObject );
HS_RESULT ASNH245MediaEncryptionAlgorithm_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MediaEncryptionAlgorithm_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H261VideoMode_resolutionChoice_qcif,
	e_ASNH245H261VideoMode_resolutionChoice_cif
} ASNH245H261VideoMode_resolutionChoice;


#define e_ASNH245H261VideoMode_resolutionChoiceSize		2
#define e_ASNH245H261VideoMode_resolutionChoiceSizeExt	2
typedef struct
{
	ASNH245H261VideoMode_resolutionChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H261VideoMode_resolution;
HS_RESULT new_ASNH245H261VideoMode_resolution( void *pObject );
HS_RESULT delete_ASNH245H261VideoMode_resolution( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H261VideoMode_resolution_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H261VideoMode_resolution_SetChoice( void *pObject, ASNH245H261VideoMode_resolutionChoice pChoice );
HS_RESULT ASNH245H261VideoMode_resolution_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H261VideoMode_resolution_MakeMold( void *pObject );
HS_RESULT ASNH245H261VideoMode_resolution_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H261VideoMode_resolution_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H261VideoModeOptionMapSize 0
#define e_ASNH245H261VideoModeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245H261VideoMode_resolution m_resolution;
	AsnInteger m_bitRate;
	AsnBoolean m_stillImageTransmission;
	/*...,*/
} ASNH245H261VideoMode;
HS_RESULT new_ASNH245H261VideoMode( void *pObject );
HS_RESULT delete_ASNH245H261VideoMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H261VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H261VideoMode_MakeMold( void *pObject );
HS_RESULT ASNH245H261VideoMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H261VideoMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SPatML,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatLL,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatML,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatH_14,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatHL,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatLL,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatML,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SpatialatH_14,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatML,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatH_14,
	e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatHL

} ASNH245H262VideoMode_profileAndLevelChoice;


#define e_ASNH245H262VideoMode_profileAndLevelChoiceSize		11
#define e_ASNH245H262VideoMode_profileAndLevelChoiceSizeExt	11
typedef struct
{
	ASNH245H262VideoMode_profileAndLevelChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H262VideoMode_profileAndLevel;
HS_RESULT new_ASNH245H262VideoMode_profileAndLevel( void *pObject );
HS_RESULT delete_ASNH245H262VideoMode_profileAndLevel( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H262VideoMode_profileAndLevel_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H262VideoMode_profileAndLevel_SetChoice( void *pObject, ASNH245H262VideoMode_profileAndLevelChoice pChoice );
HS_RESULT ASNH245H262VideoMode_profileAndLevel_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H262VideoMode_profileAndLevel_MakeMold( void *pObject );
HS_RESULT ASNH245H262VideoMode_profileAndLevel_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H262VideoMode_profileAndLevel_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H262VideoModeOptionMap_videoBitRate,
	e_ASNH245H262VideoModeOptionMap_vbvBufferSize,
	e_ASNH245H262VideoModeOptionMap_samplesPerLine,
	e_ASNH245H262VideoModeOptionMap_linesPerFrame,
	e_ASNH245H262VideoModeOptionMap_framesPerSecond,
	e_ASNH245H262VideoModeOptionMap_luminanceSampleRate

} ASNH245H262VideoModeOptionMap;


#define e_ASNH245H262VideoModeOptionMapSize 6
#define e_ASNH245H262VideoModeOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245H262VideoMode_profileAndLevel m_profileAndLevel;
	AsnInteger m_videoBitRate;
	AsnInteger m_vbvBufferSize;
	AsnInteger m_samplesPerLine;
	AsnInteger m_linesPerFrame;
	AsnInteger m_framesPerSecond;
	AsnInteger m_luminanceSampleRate;
	/*...,*/
} ASNH245H262VideoMode;
HS_RESULT new_ASNH245H262VideoMode( void *pObject );
HS_RESULT delete_ASNH245H262VideoMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H262VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H262VideoMode_IncludeOptionField( void *pObject, ASNH245H262VideoModeOptionMap pOptionMap );
BOOL	  ASNH245H262VideoMode_IsIncludeOptionField( void *pObject, ASNH245H262VideoModeOptionMap pOptionMap );
HS_RESULT ASNH245H262VideoMode_MakeMold( void *pObject );
HS_RESULT ASNH245H262VideoMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H262VideoMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H263VideoMode_resolutionChoice_sqcif,
	e_ASNH245H263VideoMode_resolutionChoice_qcif,
	e_ASNH245H263VideoMode_resolutionChoice_cif,
	e_ASNH245H263VideoMode_resolutionChoice_cif4,
	e_ASNH245H263VideoMode_resolutionChoice_cif16

} ASNH245H263VideoMode_resolutionChoice;


#define e_ASNH245H263VideoMode_resolutionChoiceSize		5
#define e_ASNH245H263VideoMode_resolutionChoiceSizeExt	5
typedef struct
{
	ASNH245H263VideoMode_resolutionChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H263VideoMode_resolution;
HS_RESULT new_ASNH245H263VideoMode_resolution( void *pObject );
HS_RESULT delete_ASNH245H263VideoMode_resolution( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H263VideoMode_resolution_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H263VideoMode_resolution_SetChoice( void *pObject, ASNH245H263VideoMode_resolutionChoice pChoice );
HS_RESULT ASNH245H263VideoMode_resolution_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H263VideoMode_resolution_MakeMold( void *pObject );
HS_RESULT ASNH245H263VideoMode_resolution_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H263VideoMode_resolution_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{

	e_ASNH245H263VideoModeOptionMap_errorCompensation,
	e_ASNH245H263VideoModeOptionMap_enhancementLayerInfo,
	e_ASNH245H263VideoModeOptionMap_h263Options
} ASNH245H263VideoModeOptionMap;


#define e_ASNH245H263VideoModeOptionMapSize 0
#define e_ASNH245H263VideoModeOptionMapSizeExt 3
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245H263VideoMode_resolution m_resolution;
	AsnInteger m_bitRate;
	AsnBoolean m_unrestrictedVector;
	AsnBoolean m_arithmeticCoding;
	AsnBoolean m_advancedPrediction;
	AsnBoolean m_pbFrames;
	/*...,*/
	AsnBoolean m_errorCompensation;
	ASNH245EnhancementLayerInfo m_enhancementLayerInfo;
	ASNH245H263Options m_h263Options;
} ASNH245H263VideoMode;
HS_RESULT new_ASNH245H263VideoMode( void *pObject );
HS_RESULT delete_ASNH245H263VideoMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H263VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H263VideoMode_IncludeOptionField( void *pObject, ASNH245H263VideoModeOptionMap pOptionMap );
BOOL	  ASNH245H263VideoMode_IsIncludeOptionField( void *pObject, ASNH245H263VideoModeOptionMap pOptionMap );
HS_RESULT ASNH245H263VideoMode_MakeMold( void *pObject );
HS_RESULT ASNH245H263VideoMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H263VideoMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IS11172VideoModeOptionMap_videoBitRate,
	e_ASNH245IS11172VideoModeOptionMap_vbvBufferSize,
	e_ASNH245IS11172VideoModeOptionMap_samplesPerLine,
	e_ASNH245IS11172VideoModeOptionMap_linesPerFrame,
	e_ASNH245IS11172VideoModeOptionMap_pictureRate,
	e_ASNH245IS11172VideoModeOptionMap_luminanceSampleRate

} ASNH245IS11172VideoModeOptionMap;


#define e_ASNH245IS11172VideoModeOptionMapSize 6
#define e_ASNH245IS11172VideoModeOptionMapSizeExt 6
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	AsnBoolean m_constrainedBitstream;
	AsnInteger m_videoBitRate;
	AsnInteger m_vbvBufferSize;
	AsnInteger m_samplesPerLine;
	AsnInteger m_linesPerFrame;
	AsnInteger m_pictureRate;
	AsnInteger m_luminanceSampleRate;
	/*...,*/
} ASNH245IS11172VideoMode;
HS_RESULT new_ASNH245IS11172VideoMode( void *pObject );
HS_RESULT delete_ASNH245IS11172VideoMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS11172VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245IS11172VideoMode_IncludeOptionField( void *pObject, ASNH245IS11172VideoModeOptionMap pOptionMap );
BOOL	  ASNH245IS11172VideoMode_IsIncludeOptionField( void *pObject, ASNH245IS11172VideoModeOptionMap pOptionMap );
HS_RESULT ASNH245IS11172VideoMode_MakeMold( void *pObject );
HS_RESULT ASNH245IS11172VideoMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS11172VideoMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245VideoModeChoice_nonStandard,
	e_ASNH245VideoModeChoice_h261VideoMode,
	e_ASNH245VideoModeChoice_h262VideoMode,
	e_ASNH245VideoModeChoice_h263VideoMode,
	e_ASNH245VideoModeChoice_is11172VideoMode
,
	e_ASNH245VideoModeChoice_genericVideoMode
} ASNH245VideoModeChoice;


#define e_ASNH245VideoModeChoiceSize		5
#define e_ASNH245VideoModeChoiceSizeExt	6
typedef struct
{
	ASNH245VideoModeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245VideoMode;
HS_RESULT new_ASNH245VideoMode( void *pObject );
HS_RESULT delete_ASNH245VideoMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245VideoMode_SetChoice( void *pObject, ASNH245VideoModeChoice pChoice );
HS_RESULT ASNH245VideoMode_DeleteAlternation( void *pObject );
HS_RESULT ASNH245VideoMode_MakeMold( void *pObject );
HS_RESULT ASNH245VideoMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245VideoMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionLowRate,
	e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionHighRate,
	e_ASNH245AudioMode_g7231Choice_silenceSuppressionLowRate,
	e_ASNH245AudioMode_g7231Choice_silenceSuppressionHighRate
} ASNH245AudioMode_g7231Choice;


#define e_ASNH245AudioMode_g7231ChoiceSize		4
#define e_ASNH245AudioMode_g7231ChoiceSizeExt	4
typedef struct
{
	ASNH245AudioMode_g7231Choice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245AudioMode_g7231;
HS_RESULT new_ASNH245AudioMode_g7231( void *pObject );
HS_RESULT delete_ASNH245AudioMode_g7231( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245AudioMode_g7231_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245AudioMode_g7231_SetChoice( void *pObject, ASNH245AudioMode_g7231Choice pChoice );
HS_RESULT ASNH245AudioMode_g7231_DeleteAlternation( void *pObject );
HS_RESULT ASNH245AudioMode_g7231_MakeMold( void *pObject );
HS_RESULT ASNH245AudioMode_g7231_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245AudioMode_g7231_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer1,
	e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer2,
	e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer3
} ASNH245IS11172AudioMode_audioLayerChoice;


#define e_ASNH245IS11172AudioMode_audioLayerChoiceSize		3
#define e_ASNH245IS11172AudioMode_audioLayerChoiceSizeExt	3
typedef struct
{
	ASNH245IS11172AudioMode_audioLayerChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245IS11172AudioMode_audioLayer;
HS_RESULT new_ASNH245IS11172AudioMode_audioLayer( void *pObject );
HS_RESULT delete_ASNH245IS11172AudioMode_audioLayer( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS11172AudioMode_audioLayer_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245IS11172AudioMode_audioLayer_SetChoice( void *pObject, ASNH245IS11172AudioMode_audioLayerChoice pChoice );
HS_RESULT ASNH245IS11172AudioMode_audioLayer_DeleteAlternation( void *pObject );
HS_RESULT ASNH245IS11172AudioMode_audioLayer_MakeMold( void *pObject );
HS_RESULT ASNH245IS11172AudioMode_audioLayer_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS11172AudioMode_audioLayer_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling32k,
	e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling44k1,
	e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling48k
} ASNH245IS11172AudioMode_audioSamplingChoice;


#define e_ASNH245IS11172AudioMode_audioSamplingChoiceSize		3
#define e_ASNH245IS11172AudioMode_audioSamplingChoiceSizeExt	3
typedef struct
{
	ASNH245IS11172AudioMode_audioSamplingChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245IS11172AudioMode_audioSampling;
HS_RESULT new_ASNH245IS11172AudioMode_audioSampling( void *pObject );
HS_RESULT delete_ASNH245IS11172AudioMode_audioSampling( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS11172AudioMode_audioSampling_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245IS11172AudioMode_audioSampling_SetChoice( void *pObject, ASNH245IS11172AudioMode_audioSamplingChoice pChoice );
HS_RESULT ASNH245IS11172AudioMode_audioSampling_DeleteAlternation( void *pObject );
HS_RESULT ASNH245IS11172AudioMode_audioSampling_MakeMold( void *pObject );
HS_RESULT ASNH245IS11172AudioMode_audioSampling_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS11172AudioMode_audioSampling_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IS11172AudioMode_multichannelTypeChoice_singleChannel,
	e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelStereo,
	e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelDual
} ASNH245IS11172AudioMode_multichannelTypeChoice;


#define e_ASNH245IS11172AudioMode_multichannelTypeChoiceSize		3
#define e_ASNH245IS11172AudioMode_multichannelTypeChoiceSizeExt	3
typedef struct
{
	ASNH245IS11172AudioMode_multichannelTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245IS11172AudioMode_multichannelType;
HS_RESULT new_ASNH245IS11172AudioMode_multichannelType( void *pObject );
HS_RESULT delete_ASNH245IS11172AudioMode_multichannelType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS11172AudioMode_multichannelType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245IS11172AudioMode_multichannelType_SetChoice( void *pObject, ASNH245IS11172AudioMode_multichannelTypeChoice pChoice );
HS_RESULT ASNH245IS11172AudioMode_multichannelType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245IS11172AudioMode_multichannelType_MakeMold( void *pObject );
HS_RESULT ASNH245IS11172AudioMode_multichannelType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS11172AudioMode_multichannelType_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245IS11172AudioModeOptionMapSize 0
#define e_ASNH245IS11172AudioModeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245IS11172AudioMode_audioLayer m_audioLayer;
	ASNH245IS11172AudioMode_audioSampling m_audioSampling;
	ASNH245IS11172AudioMode_multichannelType m_multichannelType;
	AsnInteger m_bitRate;
	/*...,*/
} ASNH245IS11172AudioMode;
HS_RESULT new_ASNH245IS11172AudioMode( void *pObject );
HS_RESULT delete_ASNH245IS11172AudioMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS11172AudioMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245IS11172AudioMode_MakeMold( void *pObject );
HS_RESULT ASNH245IS11172AudioMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS11172AudioMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer1,
	e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer2,
	e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer3
} ASNH245IS13818AudioMode_audioLayerChoice;


#define e_ASNH245IS13818AudioMode_audioLayerChoiceSize		3
#define e_ASNH245IS13818AudioMode_audioLayerChoiceSizeExt	3
typedef struct
{
	ASNH245IS13818AudioMode_audioLayerChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245IS13818AudioMode_audioLayer;
HS_RESULT new_ASNH245IS13818AudioMode_audioLayer( void *pObject );
HS_RESULT delete_ASNH245IS13818AudioMode_audioLayer( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS13818AudioMode_audioLayer_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245IS13818AudioMode_audioLayer_SetChoice( void *pObject, ASNH245IS13818AudioMode_audioLayerChoice pChoice );
HS_RESULT ASNH245IS13818AudioMode_audioLayer_DeleteAlternation( void *pObject );
HS_RESULT ASNH245IS13818AudioMode_audioLayer_MakeMold( void *pObject );
HS_RESULT ASNH245IS13818AudioMode_audioLayer_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS13818AudioMode_audioLayer_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling16k,
	e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling22k05,
	e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling24k,
	e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling32k,
	e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling44k1,
	e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling48k
} ASNH245IS13818AudioMode_audioSamplingChoice;


#define e_ASNH245IS13818AudioMode_audioSamplingChoiceSize		6
#define e_ASNH245IS13818AudioMode_audioSamplingChoiceSizeExt	6
typedef struct
{
	ASNH245IS13818AudioMode_audioSamplingChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245IS13818AudioMode_audioSampling;
HS_RESULT new_ASNH245IS13818AudioMode_audioSampling( void *pObject );
HS_RESULT delete_ASNH245IS13818AudioMode_audioSampling( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS13818AudioMode_audioSampling_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245IS13818AudioMode_audioSampling_SetChoice( void *pObject, ASNH245IS13818AudioMode_audioSamplingChoice pChoice );
HS_RESULT ASNH245IS13818AudioMode_audioSampling_DeleteAlternation( void *pObject );
HS_RESULT ASNH245IS13818AudioMode_audioSampling_MakeMold( void *pObject );
HS_RESULT ASNH245IS13818AudioMode_audioSampling_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS13818AudioMode_audioSampling_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_singleChannel,
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelStereo,
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelDual,
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels2_1,
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels3_0,
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_0_2_0,
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_2,
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels3_1,
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_0_2_0,
	e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_2
} ASNH245IS13818AudioMode_multichannelTypeChoice;


#define e_ASNH245IS13818AudioMode_multichannelTypeChoiceSize		10
#define e_ASNH245IS13818AudioMode_multichannelTypeChoiceSizeExt	10
typedef struct
{
	ASNH245IS13818AudioMode_multichannelTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245IS13818AudioMode_multichannelType;
HS_RESULT new_ASNH245IS13818AudioMode_multichannelType( void *pObject );
HS_RESULT delete_ASNH245IS13818AudioMode_multichannelType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS13818AudioMode_multichannelType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245IS13818AudioMode_multichannelType_SetChoice( void *pObject, ASNH245IS13818AudioMode_multichannelTypeChoice pChoice );
HS_RESULT ASNH245IS13818AudioMode_multichannelType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245IS13818AudioMode_multichannelType_MakeMold( void *pObject );
HS_RESULT ASNH245IS13818AudioMode_multichannelType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS13818AudioMode_multichannelType_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245IS13818AudioModeOptionMapSize 0
#define e_ASNH245IS13818AudioModeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245IS13818AudioMode_audioLayer m_audioLayer;
	ASNH245IS13818AudioMode_audioSampling m_audioSampling;
	ASNH245IS13818AudioMode_multichannelType m_multichannelType;
	AsnBoolean m_lowFrequencyEnhancement;
	AsnBoolean m_multilingual;
	AsnInteger m_bitRate;
	/*...,*/
} ASNH245IS13818AudioMode;
HS_RESULT new_ASNH245IS13818AudioMode( void *pObject );
HS_RESULT delete_ASNH245IS13818AudioMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245IS13818AudioMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245IS13818AudioMode_MakeMold( void *pObject );
HS_RESULT ASNH245IS13818AudioMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245IS13818AudioMode_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245G7231AnnexCMode_g723AnnexCAudioModeOptionMapSize 0
#define e_ASNH245G7231AnnexCMode_g723AnnexCAudioModeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_highRateMode0;
	AsnInteger m_highRateMode1;
	AsnInteger m_lowRateMode0;
	AsnInteger m_lowRateMode1;
	AsnInteger m_sidMode0;
	AsnInteger m_sidMode1;
	/*...,*/
} ASNH245G7231AnnexCMode_g723AnnexCAudioMode;
HS_RESULT new_ASNH245G7231AnnexCMode_g723AnnexCAudioMode( void *pObject );
HS_RESULT delete_ASNH245G7231AnnexCMode_g723AnnexCAudioMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245G7231AnnexCMode_g723AnnexCAudioMode_MakeMold( void *pObject );
HS_RESULT ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245G7231AnnexCModeOptionMapSize 0
#define e_ASNH245G7231AnnexCModeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_maxAl_sduAudioFrames;
	AsnBoolean m_silenceSuppression;
	ASNH245G7231AnnexCMode_g723AnnexCAudioMode m_g723AnnexCAudioMode;
	/*...,*/
} ASNH245G7231AnnexCMode;
HS_RESULT new_ASNH245G7231AnnexCMode( void *pObject );
HS_RESULT delete_ASNH245G7231AnnexCMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245G7231AnnexCMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245G7231AnnexCMode_MakeMold( void *pObject );
HS_RESULT ASNH245G7231AnnexCMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245G7231AnnexCMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245AudioModeChoice_nonStandard,
	e_ASNH245AudioModeChoice_g711Alaw64k,
	e_ASNH245AudioModeChoice_g711Alaw56k,
	e_ASNH245AudioModeChoice_g711Ulaw64k,
	e_ASNH245AudioModeChoice_g711Ulaw56k,
	e_ASNH245AudioModeChoice_g722_64k,
	e_ASNH245AudioModeChoice_g722_56k,
	e_ASNH245AudioModeChoice_g722_48k,
	e_ASNH245AudioModeChoice_g728,
	e_ASNH245AudioModeChoice_g729,
	e_ASNH245AudioModeChoice_g729AnnexA,
	e_ASNH245AudioModeChoice_g7231,
	e_ASNH245AudioModeChoice_is11172AudioMode,
	e_ASNH245AudioModeChoice_is13818AudioMode
,
	e_ASNH245AudioModeChoice_g729wAnnexB,
	e_ASNH245AudioModeChoice_g729AnnexAwAnnexB,
	e_ASNH245AudioModeChoice_g7231AnnexCMode,
	e_ASNH245AudioModeChoice_gsmFullRate,
	e_ASNH245AudioModeChoice_gsmHalfRate,
	e_ASNH245AudioModeChoice_gsmEnhancedFullRate,
	e_ASNH245AudioModeChoice_genericAudioMode,
	e_ASNH245AudioModeChoice_g729Extensions
} ASNH245AudioModeChoice;


#define e_ASNH245AudioModeChoiceSize		14
#define e_ASNH245AudioModeChoiceSizeExt	22
typedef struct
{
	ASNH245AudioModeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245AudioMode;
HS_RESULT new_ASNH245AudioMode( void *pObject );
HS_RESULT delete_ASNH245AudioMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245AudioMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245AudioMode_SetChoice( void *pObject, ASNH245AudioModeChoice pChoice );
HS_RESULT ASNH245AudioMode_DeleteAlternation( void *pObject );
HS_RESULT ASNH245AudioMode_MakeMold( void *pObject );
HS_RESULT ASNH245AudioMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245AudioMode_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245DataMode_application_nlpidOptionMapSize 0
#define e_ASNH245DataMode_application_nlpidOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245DataProtocolCapability m_nlpidProtocol;
	AsnOctetString m_nlpidData;
} ASNH245DataMode_application_nlpid;
HS_RESULT new_ASNH245DataMode_application_nlpid( void *pObject );
HS_RESULT delete_ASNH245DataMode_application_nlpid( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataMode_application_nlpid_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245DataMode_application_nlpid_MakeMold( void *pObject );
HS_RESULT ASNH245DataMode_application_nlpid_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataMode_application_nlpid_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245DataMode_application_t38faxOptionMapSize 0
#define e_ASNH245DataMode_application_t38faxOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245DataProtocolCapability m_t38FaxProtocol;
	ASNH245T38FaxProfile m_t38FaxProfile;
} ASNH245DataMode_application_t38fax;
HS_RESULT new_ASNH245DataMode_application_t38fax( void *pObject );
HS_RESULT delete_ASNH245DataMode_application_t38fax( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataMode_application_t38fax_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245DataMode_application_t38fax_MakeMold( void *pObject );
HS_RESULT ASNH245DataMode_application_t38fax_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataMode_application_t38fax_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245DataMode_applicationChoice_nonStandard,
	e_ASNH245DataMode_applicationChoice_t120,
	e_ASNH245DataMode_applicationChoice_dsm_cc,
	e_ASNH245DataMode_applicationChoice_userData,
	e_ASNH245DataMode_applicationChoice_t84,
	e_ASNH245DataMode_applicationChoice_t434,
	e_ASNH245DataMode_applicationChoice_h224,
	e_ASNH245DataMode_applicationChoice_nlpid,
	e_ASNH245DataMode_applicationChoice_dsvdControl,
	e_ASNH245DataMode_applicationChoice_h222DataPartitioning
,
	e_ASNH245DataMode_applicationChoice_t30fax,
	e_ASNH245DataMode_applicationChoice_t140,
	e_ASNH245DataMode_applicationChoice_t38fax,
	e_ASNH245DataMode_applicationChoice_genericDataMode
} ASNH245DataMode_applicationChoice;


#define e_ASNH245DataMode_applicationChoiceSize		10
#define e_ASNH245DataMode_applicationChoiceSizeExt	14
typedef struct
{
	ASNH245DataMode_applicationChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245DataMode_application;
HS_RESULT new_ASNH245DataMode_application( void *pObject );
HS_RESULT delete_ASNH245DataMode_application( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataMode_application_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245DataMode_application_SetChoice( void *pObject, ASNH245DataMode_applicationChoice pChoice );
HS_RESULT ASNH245DataMode_application_DeleteAlternation( void *pObject );
HS_RESULT ASNH245DataMode_application_MakeMold( void *pObject );
HS_RESULT ASNH245DataMode_application_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataMode_application_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245DataModeOptionMapSize 0
#define e_ASNH245DataModeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245DataMode_application m_application;
	AsnInteger m_bitRate;
	/*...,*/
} ASNH245DataMode;
HS_RESULT new_ASNH245DataMode( void *pObject );
HS_RESULT delete_ASNH245DataMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245DataMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245DataMode_MakeMold( void *pObject );
HS_RESULT ASNH245DataMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245DataMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H235Mode_mediaModeChoice_nonStandard,
	e_ASNH245H235Mode_mediaModeChoice_videoMode,
	e_ASNH245H235Mode_mediaModeChoice_audioMode,
	e_ASNH245H235Mode_mediaModeChoice_dataMode

} ASNH245H235Mode_mediaModeChoice;


#define e_ASNH245H235Mode_mediaModeChoiceSize		4
#define e_ASNH245H235Mode_mediaModeChoiceSizeExt	4
typedef struct
{
	ASNH245H235Mode_mediaModeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H235Mode_mediaMode;
HS_RESULT new_ASNH245H235Mode_mediaMode( void *pObject );
HS_RESULT delete_ASNH245H235Mode_mediaMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H235Mode_mediaMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H235Mode_mediaMode_SetChoice( void *pObject, ASNH245H235Mode_mediaModeChoice pChoice );
HS_RESULT ASNH245H235Mode_mediaMode_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H235Mode_mediaMode_MakeMold( void *pObject );
HS_RESULT ASNH245H235Mode_mediaMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H235Mode_mediaMode_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H235ModeOptionMapSize 0
#define e_ASNH245H235ModeOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245EncryptionAuthenticationAndIntegrity m_encryptionAuthenticationAndIntegrity;
	ASNH245H235Mode_mediaMode m_mediaMode;
	/*...,*/
} ASNH245H235Mode;
HS_RESULT new_ASNH245H235Mode( void *pObject );
HS_RESULT delete_ASNH245H235Mode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H235Mode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H235Mode_MakeMold( void *pObject );
HS_RESULT ASNH245H235Mode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H235Mode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ModeElement_typeChoice_nonStandard,
	e_ASNH245ModeElement_typeChoice_videoMode,
	e_ASNH245ModeElement_typeChoice_audioMode,
	e_ASNH245ModeElement_typeChoice_dataMode,
	e_ASNH245ModeElement_typeChoice_encryptionMode
,
	e_ASNH245ModeElement_typeChoice_h235Mode,
	e_ASNH245ModeElement_typeChoice_multiplexedStreamMode
} ASNH245ModeElement_typeChoice;


#define e_ASNH245ModeElement_typeChoiceSize		5
#define e_ASNH245ModeElement_typeChoiceSizeExt	7
typedef struct
{
	ASNH245ModeElement_typeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245ModeElement_type;
HS_RESULT new_ASNH245ModeElement_type( void *pObject );
HS_RESULT delete_ASNH245ModeElement_type( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ModeElement_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245ModeElement_type_SetChoice( void *pObject, ASNH245ModeElement_typeChoice pChoice );
HS_RESULT ASNH245ModeElement_type_DeleteAlternation( void *pObject );
HS_RESULT ASNH245ModeElement_type_MakeMold( void *pObject );
HS_RESULT ASNH245ModeElement_type_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ModeElement_type_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223ModeParameters_adaptationLayerType_al3OptionMapSize 0
#define e_ASNH245H223ModeParameters_adaptationLayerType_al3OptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnInteger m_controlFieldOctets;
	AsnInteger m_sendBufferSize;
} ASNH245H223ModeParameters_adaptationLayerType_al3;
HS_RESULT new_ASNH245H223ModeParameters_adaptationLayerType_al3( void *pObject );
HS_RESULT delete_ASNH245H223ModeParameters_adaptationLayerType_al3( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223ModeParameters_adaptationLayerType_al3_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223ModeParameters_adaptationLayerType_al3_MakeMold( void *pObject );
HS_RESULT ASNH245H223ModeParameters_adaptationLayerType_al3_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223ModeParameters_adaptationLayerType_al3_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H223ModeParameters_adaptationLayerTypeChoice_nonStandard,
	e_ASNH245H223ModeParameters_adaptationLayerTypeChoice_al1Framed,
	e_ASNH245H223ModeParameters_adaptationLayerTypeChoice_al1NotFramed,
	e_ASNH245H223ModeParameters_adaptationLayerTypeChoice_al2WithoutSequenceNumbers,
	e_ASNH245H223ModeParameters_adaptationLayerTypeChoice_al2WithSequenceNumbers,
	e_ASNH245H223ModeParameters_adaptationLayerTypeChoice_al3
,
	e_ASNH245H223ModeParameters_adaptationLayerTypeChoice_al1M,
	e_ASNH245H223ModeParameters_adaptationLayerTypeChoice_al2M,
	e_ASNH245H223ModeParameters_adaptationLayerTypeChoice_al3M
} ASNH245H223ModeParameters_adaptationLayerTypeChoice;


#define e_ASNH245H223ModeParameters_adaptationLayerTypeChoiceSize		6
#define e_ASNH245H223ModeParameters_adaptationLayerTypeChoiceSizeExt	9
typedef struct
{
	ASNH245H223ModeParameters_adaptationLayerTypeChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245H223ModeParameters_adaptationLayerType;
HS_RESULT new_ASNH245H223ModeParameters_adaptationLayerType( void *pObject );
HS_RESULT delete_ASNH245H223ModeParameters_adaptationLayerType( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223ModeParameters_adaptationLayerType_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245H223ModeParameters_adaptationLayerType_SetChoice( void *pObject, ASNH245H223ModeParameters_adaptationLayerTypeChoice pChoice );
HS_RESULT ASNH245H223ModeParameters_adaptationLayerType_DeleteAlternation( void *pObject );
HS_RESULT ASNH245H223ModeParameters_adaptationLayerType_MakeMold( void *pObject );
HS_RESULT ASNH245H223ModeParameters_adaptationLayerType_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223ModeParameters_adaptationLayerType_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245H223ModeParametersOptionMapSize 0
#define e_ASNH245H223ModeParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245H223ModeParameters_adaptationLayerType m_adaptationLayerType;
	AsnBoolean m_segmentableFlag;
	/*...,*/
} ASNH245H223ModeParameters;
HS_RESULT new_ASNH245H223ModeParameters( void *pObject );
HS_RESULT delete_ASNH245H223ModeParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H223ModeParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H223ModeParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H223ModeParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H223ModeParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245V76ModeParametersChoice_suspendResumewAddress,
	e_ASNH245V76ModeParametersChoice_suspendResumewoAddress

} ASNH245V76ModeParametersChoice;


#define e_ASNH245V76ModeParametersChoiceSize		2
#define e_ASNH245V76ModeParametersChoiceSizeExt	2
typedef struct
{
	ASNH245V76ModeParametersChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245V76ModeParameters;
HS_RESULT new_ASNH245V76ModeParameters( void *pObject );
HS_RESULT delete_ASNH245V76ModeParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245V76ModeParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245V76ModeParameters_SetChoice( void *pObject, ASNH245V76ModeParametersChoice pChoice );
HS_RESULT ASNH245V76ModeParameters_DeleteAlternation( void *pObject );
HS_RESULT ASNH245V76ModeParameters_MakeMold( void *pObject );
HS_RESULT ASNH245V76ModeParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245V76ModeParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RedundancyEncodingMode_secondaryEncodingChoice_nonStandard,
	e_ASNH245RedundancyEncodingMode_secondaryEncodingChoice_audioData

} ASNH245RedundancyEncodingMode_secondaryEncodingChoice;


#define e_ASNH245RedundancyEncodingMode_secondaryEncodingChoiceSize		2
#define e_ASNH245RedundancyEncodingMode_secondaryEncodingChoiceSizeExt	2
typedef struct
{
	ASNH245RedundancyEncodingMode_secondaryEncodingChoice choice;
	AsnInteger choiceInteger;

	BOOL extensible;
	void *alter;
} ASNH245RedundancyEncodingMode_secondaryEncoding;
HS_RESULT new_ASNH245RedundancyEncodingMode_secondaryEncoding( void *pObject );
HS_RESULT delete_ASNH245RedundancyEncodingMode_secondaryEncoding( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RedundancyEncodingMode_secondaryEncoding_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
void*	  ASNH245RedundancyEncodingMode_secondaryEncoding_SetChoice( void *pObject, ASNH245RedundancyEncodingMode_secondaryEncodingChoice pChoice );
HS_RESULT ASNH245RedundancyEncodingMode_secondaryEncoding_DeleteAlternation( void *pObject );
HS_RESULT ASNH245RedundancyEncodingMode_secondaryEncoding_MakeMold( void *pObject );
HS_RESULT ASNH245RedundancyEncodingMode_secondaryEncoding_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RedundancyEncodingMode_secondaryEncoding_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245RedundancyEncodingModeOptionMap_secondaryEncoding

} ASNH245RedundancyEncodingModeOptionMap;


#define e_ASNH245RedundancyEncodingModeOptionMapSize 1
#define e_ASNH245RedundancyEncodingModeOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245RedundancyEncodingMethod m_redundancyEncodingMethod;
	ASNH245RedundancyEncodingMode_secondaryEncoding m_secondaryEncoding;
	/*...,*/
} ASNH245RedundancyEncodingMode;
HS_RESULT new_ASNH245RedundancyEncodingMode( void *pObject );
HS_RESULT delete_ASNH245RedundancyEncodingMode( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245RedundancyEncodingMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245RedundancyEncodingMode_IncludeOptionField( void *pObject, ASNH245RedundancyEncodingModeOptionMap pOptionMap );
BOOL	  ASNH245RedundancyEncodingMode_IsIncludeOptionField( void *pObject, ASNH245RedundancyEncodingModeOptionMap pOptionMap );
HS_RESULT ASNH245RedundancyEncodingMode_MakeMold( void *pObject );
HS_RESULT ASNH245RedundancyEncodingMode_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245RedundancyEncodingMode_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245H2250ModeParametersOptionMap_redundancyEncodingMode

} ASNH245H2250ModeParametersOptionMap;


#define e_ASNH245H2250ModeParametersOptionMapSize 1
#define e_ASNH245H2250ModeParametersOptionMapSizeExt 1
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245RedundancyEncodingMode m_redundancyEncodingMode;
	/*...,*/
} ASNH245H2250ModeParameters;
HS_RESULT new_ASNH245H2250ModeParameters( void *pObject );
HS_RESULT delete_ASNH245H2250ModeParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245H2250ModeParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245H2250ModeParameters_IncludeOptionField( void *pObject, ASNH245H2250ModeParametersOptionMap pOptionMap );
BOOL	  ASNH245H2250ModeParameters_IsIncludeOptionField( void *pObject, ASNH245H2250ModeParametersOptionMap pOptionMap );
HS_RESULT ASNH245H2250ModeParameters_MakeMold( void *pObject );
HS_RESULT ASNH245H2250ModeParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245H2250ModeParameters_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245MultiplexedStreamModeParametersOptionMapSize 0
#define e_ASNH245MultiplexedStreamModeParametersOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	ASNH245LogicalChannelNumber m_logicalChannelNumber;
	/*...,*/
} ASNH245MultiplexedStreamModeParameters;
HS_RESULT new_ASNH245MultiplexedStreamModeParameters( void *pObject );
HS_RESULT delete_ASNH245MultiplexedStreamModeParameters( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexedStreamModeParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245MultiplexedStreamModeParameters_MakeMold( void *pObject );
HS_RESULT ASNH245MultiplexedStreamModeParameters_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245MultiplexedStreamModeParameters_Decode( void *pObject, AsnStream *pStrm );





typedef enum
{
	e_ASNH245ModeElementOptionMap_h223ModeParameters
,
	e_ASNH245ModeElementOptionMap_v76ModeParameters,
	e_ASNH245ModeElementOptionMap_h2250ModeParameters,
	e_ASNH245ModeElementOptionMap_genericModeParameters,
	e_ASNH245ModeElementOptionMap_multiplexedStreamModeParameters
} ASNH245ModeElementOptionMap;


#define e_ASNH245ModeElementOptionMapSize 1
#define e_ASNH245ModeElementOptionMapSizeExt 5
typedef struct
{
	BOOL extensible;
	BOOL extended;

	HS_UCHAR optionMap[HS_ASN_OPTION_MAP_MAX];

	HS_UINT		extOptionMapSize;	/* Bit Size */
	HS_UCHAR		extOptionMap[HS_ASN_OPTION_MAP_MAX];

	/* Member of ASN */
	ASNH245ModeElement_type m_type;
	ASNH245H223ModeParameters m_h223ModeParameters;
	/*...,*/
	ASNH245V76ModeParameters m_v76ModeParameters;
	ASNH245H2250ModeParameters m_h2250ModeParameters;
	ASNH245GenericCapability m_genericModeParameters;
	ASNH245MultiplexedStreamModeParameters m_multiplexedStreamModeParameters;
} ASNH245ModeElement;
HS_RESULT new_ASNH245ModeElement( void *pObject );
HS_RESULT delete_ASNH245ModeElement( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ModeElement_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245ModeElement_IncludeOptionField( void *pObject, ASNH245ModeElementOptionMap pOptionMap );
BOOL	  ASNH245ModeElement_IsIncludeOptionField( void *pObject, ASNH245ModeElementOptionMap pOptionMap );
HS_RESULT ASNH245ModeElement_MakeMold( void *pObject );
HS_RESULT ASNH245ModeElement_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245ModeElement_Decode( void *pObject, AsnStream *pStrm );






#define e_ASNH245CriteriaOptionMapSize 0
#define e_ASNH245CriteriaOptionMapSizeExt 0
typedef struct
{
	BOOL extensible;
	BOOL extended;

	/* Member of ASN */
	AsnObjectIdentifier m_field;
	AsnOctetString m_value;
	/*...,*/
} ASNH245Criteria;
HS_RESULT new_ASNH245Criteria( void *pObject );
HS_RESULT delete_ASNH245Criteria( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245Criteria_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH245Criteria_MakeMold( void *pObject );
HS_RESULT ASNH245Criteria_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH245Criteria_Decode( void *pObject, AsnStream *pStrm );







#endif/*__2005_03_27__12_37__H245_HXX__*/


