/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<h245_0.c>

*/

#include "H245.h"

/*Inheritance*/
HS_RESULT new_ASNH245SequenceNumber( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245SequenceNumber *pObj = (ASNH245SequenceNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245SequenceNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,0,255,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245SequenceNumber( void *pObject )
{
	ASNH245SequenceNumber *pObj = (ASNH245SequenceNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245SequenceNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245SequenceNumber *pObj = (ASNH245SequenceNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245SequenceNumber_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245SequenceNumber_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245SequenceNumber *pObj = (ASNH245SequenceNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245SequenceNumber_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245SequenceNumber *pObj = (ASNH245SequenceNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245AlternativeCapabilitySet( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245AlternativeCapabilitySet *pObj = (ASNH245AlternativeCapabilitySet *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245AlternativeCapabilitySet(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnSequenceOf( &(pObj->inheritance), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245AlternativeCapabilitySet( void *pObject )
{
	ASNH245AlternativeCapabilitySet *pObj = (ASNH245AlternativeCapabilitySet *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnSequenceOf( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245AlternativeCapabilitySet_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245AlternativeCapabilitySet *pObj = (ASNH245AlternativeCapabilitySet *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245AlternativeCapabilitySet_MakeMold( void *pObject ){
	AsnObject *moldObject = HS_NULL;
	ASNH245AlternativeCapabilitySet *pObj = (ASNH245AlternativeCapabilitySet *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	{
	ASNH245CapabilityTableEntryNumber *tmold = (ASNH245CapabilityTableEntryNumber *)HSMalloc( sizeof(ASNH245CapabilityTableEntryNumber) );
	new_ASNH245CapabilityTableEntryNumber(tmold);
	ASNH245CapabilityTableEntryNumber_MakeMold(tmold);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold,sizeof(ASNH245CapabilityTableEntryNumber),ASNH245CapabilityTableEntryNumber_MakeMold,ASNH245CapabilityTableEntryNumber_Encode,ASNH245CapabilityTableEntryNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245CapabilityTableEntryNumber_Print,
#endif
		delete_ASNH245CapabilityTableEntryNumber);
	AsnSequenceOf_SetMold( &(pObj->inheritance), moldObject );
	}

return HS_OK;
}
HS_RESULT ASNH245AlternativeCapabilitySet_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245AlternativeCapabilitySet *pObj = (ASNH245AlternativeCapabilitySet *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245AlternativeCapabilitySet_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245AlternativeCapabilitySet *pObj = (ASNH245AlternativeCapabilitySet *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245CapabilityTableEntryNumber( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245CapabilityTableEntryNumber *pObj = (ASNH245CapabilityTableEntryNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CapabilityTableEntryNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,1,65535,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245CapabilityTableEntryNumber( void *pObject )
{
	ASNH245CapabilityTableEntryNumber *pObj = (ASNH245CapabilityTableEntryNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CapabilityTableEntryNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245CapabilityTableEntryNumber *pObj = (ASNH245CapabilityTableEntryNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245CapabilityTableEntryNumber_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245CapabilityTableEntryNumber_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245CapabilityTableEntryNumber *pObj = (ASNH245CapabilityTableEntryNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245CapabilityTableEntryNumber_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245CapabilityTableEntryNumber *pObj = (ASNH245CapabilityTableEntryNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245CapabilityDescriptorNumber( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245CapabilityDescriptorNumber *pObj = (ASNH245CapabilityDescriptorNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CapabilityDescriptorNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,0,255,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245CapabilityDescriptorNumber( void *pObject )
{
	ASNH245CapabilityDescriptorNumber *pObj = (ASNH245CapabilityDescriptorNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CapabilityDescriptorNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245CapabilityDescriptorNumber *pObj = (ASNH245CapabilityDescriptorNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245CapabilityDescriptorNumber_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245CapabilityDescriptorNumber_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245CapabilityDescriptorNumber *pObj = (ASNH245CapabilityDescriptorNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245CapabilityDescriptorNumber_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245CapabilityDescriptorNumber *pObj = (ASNH245CapabilityDescriptorNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245EncryptionCapability( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245EncryptionCapability *pObj = (ASNH245EncryptionCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245EncryptionCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnSequenceOf( &(pObj->inheritance), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245EncryptionCapability( void *pObject )
{
	ASNH245EncryptionCapability *pObj = (ASNH245EncryptionCapability *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnSequenceOf( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245EncryptionCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245EncryptionCapability *pObj = (ASNH245EncryptionCapability *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245EncryptionCapability_MakeMold( void *pObject ){
	AsnObject *moldObject = HS_NULL;
	ASNH245EncryptionCapability *pObj = (ASNH245EncryptionCapability *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	{
	ASNH245MediaEncryptionAlgorithm *tmold = (ASNH245MediaEncryptionAlgorithm *)HSMalloc( sizeof(ASNH245MediaEncryptionAlgorithm) );
	new_ASNH245MediaEncryptionAlgorithm(tmold);
	ASNH245MediaEncryptionAlgorithm_MakeMold(tmold);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold,sizeof(ASNH245MediaEncryptionAlgorithm),ASNH245MediaEncryptionAlgorithm_MakeMold,ASNH245MediaEncryptionAlgorithm_Encode,ASNH245MediaEncryptionAlgorithm_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MediaEncryptionAlgorithm_Print,
#endif
		delete_ASNH245MediaEncryptionAlgorithm);
	AsnSequenceOf_SetMold( &(pObj->inheritance), moldObject );
	}

return HS_OK;
}
HS_RESULT ASNH245EncryptionCapability_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245EncryptionCapability *pObj = (ASNH245EncryptionCapability *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245EncryptionCapability_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245EncryptionCapability *pObj = (ASNH245EncryptionCapability *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245LogicalChannelNumber( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245LogicalChannelNumber *pObj = (ASNH245LogicalChannelNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245LogicalChannelNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,1,65535,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245LogicalChannelNumber( void *pObject )
{
	ASNH245LogicalChannelNumber *pObj = (ASNH245LogicalChannelNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245LogicalChannelNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245LogicalChannelNumber *pObj = (ASNH245LogicalChannelNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245LogicalChannelNumber_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245LogicalChannelNumber_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245LogicalChannelNumber *pObj = (ASNH245LogicalChannelNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245LogicalChannelNumber_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245LogicalChannelNumber *pObj = (ASNH245LogicalChannelNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245MultiplexTableEntryNumber( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245MultiplexTableEntryNumber *pObj = (ASNH245MultiplexTableEntryNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexTableEntryNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245MultiplexTableEntryNumber( void *pObject )
{
	ASNH245MultiplexTableEntryNumber *pObj = (ASNH245MultiplexTableEntryNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MultiplexTableEntryNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245MultiplexTableEntryNumber *pObj = (ASNH245MultiplexTableEntryNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245MultiplexTableEntryNumber_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245MultiplexTableEntryNumber_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245MultiplexTableEntryNumber *pObj = (ASNH245MultiplexTableEntryNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245MultiplexTableEntryNumber_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245MultiplexTableEntryNumber *pObj = (ASNH245MultiplexTableEntryNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245ModeDescription( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245ModeDescription *pObj = (ASNH245ModeDescription *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ModeDescription(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnSequenceOf( &(pObj->inheritance), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245ModeDescription( void *pObject )
{
	ASNH245ModeDescription *pObj = (ASNH245ModeDescription *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnSequenceOf( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ModeDescription_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245ModeDescription *pObj = (ASNH245ModeDescription *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245ModeDescription_MakeMold( void *pObject ){
	AsnObject *moldObject = HS_NULL;
	ASNH245ModeDescription *pObj = (ASNH245ModeDescription *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	{
	ASNH245ModeElement *tmold = (ASNH245ModeElement *)HSMalloc( sizeof(ASNH245ModeElement) );
	new_ASNH245ModeElement(tmold);
	ASNH245ModeElement_MakeMold(tmold);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold,sizeof(ASNH245ModeElement),ASNH245ModeElement_MakeMold,ASNH245ModeElement_Encode,ASNH245ModeElement_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245ModeElement_Print,
#endif
		delete_ASNH245ModeElement);
	AsnSequenceOf_SetMold( &(pObj->inheritance), moldObject );
	}

return HS_OK;
}
HS_RESULT ASNH245ModeDescription_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245ModeDescription *pObj = (ASNH245ModeDescription *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245ModeDescription_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245ModeDescription *pObj = (ASNH245ModeDescription *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245CertSelectionCriteria( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245CertSelectionCriteria *pObj = (ASNH245CertSelectionCriteria *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CertSelectionCriteria(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnSequenceOf( &(pObj->inheritance), e_constrained,1,16,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245CertSelectionCriteria( void *pObject )
{
	ASNH245CertSelectionCriteria *pObj = (ASNH245CertSelectionCriteria *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnSequenceOf( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245CertSelectionCriteria_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245CertSelectionCriteria *pObj = (ASNH245CertSelectionCriteria *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245CertSelectionCriteria_MakeMold( void *pObject ){
	AsnObject *moldObject = HS_NULL;
	ASNH245CertSelectionCriteria *pObj = (ASNH245CertSelectionCriteria *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	{
	ASNH245Criteria *tmold = (ASNH245Criteria *)HSMalloc( sizeof(ASNH245Criteria) );
	new_ASNH245Criteria(tmold);
	ASNH245Criteria_MakeMold(tmold);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold,sizeof(ASNH245Criteria),ASNH245Criteria_MakeMold,ASNH245Criteria_Encode,ASNH245Criteria_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245Criteria_Print,
#endif
		delete_ASNH245Criteria);
	AsnSequenceOf_SetMold( &(pObj->inheritance), moldObject );
	}

return HS_OK;
}
HS_RESULT ASNH245CertSelectionCriteria_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245CertSelectionCriteria *pObj = (ASNH245CertSelectionCriteria *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245CertSelectionCriteria_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245CertSelectionCriteria *pObj = (ASNH245CertSelectionCriteria *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSequenceOf_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245McuNumber( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245McuNumber *pObj = (ASNH245McuNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245McuNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,0,192,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245McuNumber( void *pObject )
{
	ASNH245McuNumber *pObj = (ASNH245McuNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245McuNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245McuNumber *pObj = (ASNH245McuNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245McuNumber_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245McuNumber_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245McuNumber *pObj = (ASNH245McuNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245McuNumber_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245McuNumber *pObj = (ASNH245McuNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245TerminalNumber( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245TerminalNumber *pObj = (ASNH245TerminalNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TerminalNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,0,192,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245TerminalNumber( void *pObject )
{
	ASNH245TerminalNumber *pObj = (ASNH245TerminalNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245TerminalNumber *pObj = (ASNH245TerminalNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245TerminalNumber_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245TerminalNumber_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245TerminalNumber *pObj = (ASNH245TerminalNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245TerminalNumber_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245TerminalNumber *pObj = (ASNH245TerminalNumber *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245TerminalID( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245TerminalID *pObj = (ASNH245TerminalID *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TerminalID(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnOctetString( &(pObj->inheritance), e_constrained,1,128,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245TerminalID( void *pObject )
{
	ASNH245TerminalID *pObj = (ASNH245TerminalID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnOctetString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245TerminalID_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245TerminalID *pObj = (ASNH245TerminalID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245TerminalID_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245TerminalID_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245TerminalID *pObj = (ASNH245TerminalID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245TerminalID_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245TerminalID *pObj = (ASNH245TerminalID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245ConferenceID( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245ConferenceID *pObj = (ASNH245ConferenceID *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ConferenceID(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnOctetString( &(pObj->inheritance), e_constrained,1,32,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245ConferenceID( void *pObject )
{
	ASNH245ConferenceID *pObj = (ASNH245ConferenceID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnOctetString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245ConferenceID_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245ConferenceID *pObj = (ASNH245ConferenceID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245ConferenceID_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245ConferenceID_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245ConferenceID *pObj = (ASNH245ConferenceID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245ConferenceID_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245ConferenceID *pObj = (ASNH245ConferenceID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245Password( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245Password *pObj = (ASNH245Password *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245Password(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnOctetString( &(pObj->inheritance), e_constrained,1,32,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245Password( void *pObject )
{
	ASNH245Password *pObj = (ASNH245Password *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnOctetString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245Password_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245Password *pObj = (ASNH245Password *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245Password_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245Password_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245Password *pObj = (ASNH245Password *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245Password_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245Password *pObj = (ASNH245Password *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH245MaximumBitRate( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH245MaximumBitRate *pObj = (ASNH245MaximumBitRate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MaximumBitRate(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH245MaximumBitRate( void *pObject )
{
	ASNH245MaximumBitRate *pObj = (ASNH245MaximumBitRate *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH245MaximumBitRate_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH245MaximumBitRate *pObj = (ASNH245MaximumBitRate *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH245MaximumBitRate_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH245MaximumBitRate_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH245MaximumBitRate *pObj = (ASNH245MaximumBitRate *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH245MaximumBitRate_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH245MaximumBitRate *pObj = (ASNH245MaximumBitRate *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/***************************************************************************************/
/* ASNH245NonStandardIdentifier_h221NonStandard Class
*/
/*ASNH245NonStandardIdentifier_h221NonStandard Constructor*/
HS_RESULT new_ASNH245NonStandardIdentifier_h221NonStandard(void *pObject)
{
	ASNH245NonStandardIdentifier_h221NonStandard *pObj = (ASNH245NonStandardIdentifier_h221NonStandard *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NonStandardIdentifier_h221NonStandard(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_t35CountryCode), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_t35Extension), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_manufacturerCode), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245NonStandardIdentifier_h221NonStandard Destructor */
HS_RESULT delete_ASNH245NonStandardIdentifier_h221NonStandard(void *pObject)
{
	ASNH245NonStandardIdentifier_h221NonStandard *pObj = (ASNH245NonStandardIdentifier_h221NonStandard *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NonStandardIdentifier_h221NonStandard(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_t35CountryCode) );
	delete_AsnInteger( &(pObj->m_t35Extension) );
	delete_AsnInteger( &(pObj->m_manufacturerCode) );
	return HS_OK;
}

/* ASNH245NonStandardIdentifier_h221NonStandard MakeMold */
HS_RESULT ASNH245NonStandardIdentifier_h221NonStandard_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NonStandardIdentifier_h221NonStandard *pObj = (ASNH245NonStandardIdentifier_h221NonStandard *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245NonStandardIdentifier_h221NonStandard Encode */
HS_RESULT ASNH245NonStandardIdentifier_h221NonStandard_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NonStandardIdentifier_h221NonStandard *pObj = (ASNH245NonStandardIdentifier_h221NonStandard *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_t35CountryCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_t35Extension),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_manufacturerCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NonStandardIdentifier_h221NonStandard Decode */
HS_RESULT ASNH245NonStandardIdentifier_h221NonStandard_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NonStandardIdentifier_h221NonStandard *pObj = (ASNH245NonStandardIdentifier_h221NonStandard *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_t35CountryCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_t35Extension),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_manufacturerCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NonStandardIdentifier_h221NonStandard Print */
HS_RESULT ASNH245NonStandardIdentifier_h221NonStandard_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NonStandardIdentifier_h221NonStandard *pObj = (ASNH245NonStandardIdentifier_h221NonStandard *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_h221NonStandard_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_t35CountryCode), pDepth+1, "t35CountryCode" );
	AsnInteger_Print( &(pObj->m_t35Extension), pDepth+1, "t35Extension" );
	AsnInteger_Print( &(pObj->m_manufacturerCode), pDepth+1, "manufacturerCode" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NonStandardIdentifier Struct
*/
/* ASNH245NonStandardIdentifier Constructor */
HS_RESULT new_ASNH245NonStandardIdentifier( void *pObject )
{
	ASNH245NonStandardIdentifier *pObj = (ASNH245NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NonStandardIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245NonStandardIdentifierChoice_object;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NonStandardIdentifierChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NonStandardIdentifier Destructor */
HS_RESULT delete_ASNH245NonStandardIdentifier( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NonStandardIdentifier *pObj = (ASNH245NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NonStandardIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NonStandardIdentifier_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NonStandardIdentifier(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NonStandardIdentifier SetChoice */
void* ASNH245NonStandardIdentifier_SetChoice( void *pObject, ASNH245NonStandardIdentifierChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NonStandardIdentifier *pObj = (ASNH245NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NonStandardIdentifierChoiceSizeExt ){
		if( pChoice > (ASNH245NonStandardIdentifierChoice)(e_ASNH245NonStandardIdentifierChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NonStandardIdentifier_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NonStandardIdentifier_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NonStandardIdentifier_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NonStandardIdentifierChoice_object ){
		AsnObjectIdentifier *tAlter = (AsnObjectIdentifier *)HSMalloc( sizeof(AsnObjectIdentifier) );
		new_AsnObjectIdentifier(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NonStandardIdentifierChoice_h221NonStandard ){
		ASNH245NonStandardIdentifier_h221NonStandard *tAlter = (ASNH245NonStandardIdentifier_h221NonStandard *)HSMalloc( sizeof(ASNH245NonStandardIdentifier_h221NonStandard) );
		new_ASNH245NonStandardIdentifier_h221NonStandard(tAlter);
		ASNH245NonStandardIdentifier_h221NonStandard_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NonStandardIdentifier DeleteAlternation */
HS_RESULT ASNH245NonStandardIdentifier_DeleteAlternation(void *pObject)
{
	ASNH245NonStandardIdentifier *pObj = (ASNH245NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NonStandardIdentifierChoice_object ){
			delete_AsnObjectIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NonStandardIdentifierChoice_h221NonStandard ){
			delete_ASNH245NonStandardIdentifier_h221NonStandard(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NonStandardIdentifier_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NonStandardIdentifier_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NonStandardIdentifier Encode */
HS_RESULT ASNH245NonStandardIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NonStandardIdentifier *pObj = (ASNH245NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NonStandardIdentifierChoiceSize )
		{
			if( pObj->choice > ((ASNH245NonStandardIdentifierChoice)(e_ASNH245NonStandardIdentifierChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NonStandardIdentifierChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NonStandardIdentifierChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NonStandardIdentifierChoice_object ){
		if( (tRet=AsnObjectIdentifier_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NonStandardIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NonStandardIdentifierChoice_h221NonStandard ){
		if( (tRet=ASNH245NonStandardIdentifier_h221NonStandard_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NonStandardIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NonStandardIdentifier Decode */
HS_RESULT ASNH245NonStandardIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NonStandardIdentifier *pObj = (ASNH245NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NonStandardIdentifierChoiceSize;
	}
	else
	{
		if( e_ASNH245NonStandardIdentifierChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NonStandardIdentifierChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NonStandardIdentifierChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NonStandardIdentifier_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NonStandardIdentifier_SetChoice( pObj, (ASNH245NonStandardIdentifierChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NonStandardIdentifierChoice_object ){
		if( (tRet=AsnObjectIdentifier_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NonStandardIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NonStandardIdentifierChoice_h221NonStandard ){
		if( (tRet=ASNH245NonStandardIdentifier_h221NonStandard_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NonStandardIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NonStandardIdentifier Print */
HS_RESULT ASNH245NonStandardIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NonStandardIdentifier *pObj = (ASNH245NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NonStandardIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NonStandardIdentifierChoice_object ){
		AsnObjectIdentifier_Print( pObj->alter, pDepth+1, "object" );
	}
	else if ( pObj->choice == e_ASNH245NonStandardIdentifierChoice_h221NonStandard ){
		ASNH245NonStandardIdentifier_h221NonStandard_Print( pObj->alter, pDepth+1, "h221NonStandard" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NonStandardParameter Class
*/
/*ASNH245NonStandardParameter Constructor*/
HS_RESULT new_ASNH245NonStandardParameter(void *pObject)
{
	ASNH245NonStandardParameter *pObj = (ASNH245NonStandardParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NonStandardParameter(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH245NonStandardIdentifier( &(pObj->m_nonStandardIdentifier) );
	new_AsnOctetString( &(pObj->m_data), e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245NonStandardParameter Destructor */
HS_RESULT delete_ASNH245NonStandardParameter(void *pObject)
{
	ASNH245NonStandardParameter *pObj = (ASNH245NonStandardParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NonStandardParameter(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245NonStandardIdentifier( &(pObj->m_nonStandardIdentifier) );
	delete_AsnOctetString( &(pObj->m_data) );
	return HS_OK;
}

/* ASNH245NonStandardParameter MakeMold */
HS_RESULT ASNH245NonStandardParameter_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NonStandardParameter *pObj = (ASNH245NonStandardParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardParameter_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245NonStandardIdentifier_MakeMold(&(pObj->m_nonStandardIdentifier));
	return HS_OK;
}

/* ASNH245NonStandardParameter Encode */
HS_RESULT ASNH245NonStandardParameter_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NonStandardParameter *pObj = (ASNH245NonStandardParameter *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardParameter_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245NonStandardIdentifier_Encode( &(pObj->m_nonStandardIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardParameter_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_data),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardParameter_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NonStandardParameter Decode */
HS_RESULT ASNH245NonStandardParameter_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NonStandardParameter *pObj = (ASNH245NonStandardParameter *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardParameter_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245NonStandardIdentifier_Decode(&(pObj->m_nonStandardIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardParameter_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_data),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardParameter_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NonStandardParameter Print */
HS_RESULT ASNH245NonStandardParameter_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NonStandardParameter *pObj = (ASNH245NonStandardParameter *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NonStandardParameter_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245NonStandardIdentifier_Print( &(pObj->m_nonStandardIdentifier), pDepth+1, "nonStandardIdentifier" );
	AsnOctetString_Print( &(pObj->m_data), pDepth+1, "data" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NonStandardMessage Class
*/
/*ASNH245NonStandardMessage Constructor*/
HS_RESULT new_ASNH245NonStandardMessage(void *pObject)
{
	ASNH245NonStandardMessage *pObj = (ASNH245NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NonStandardMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245NonStandardParameter( &(pObj->m_nonStandardData) );

	return HS_OK;
}

/* ASNH245NonStandardMessage Destructor */
HS_RESULT delete_ASNH245NonStandardMessage(void *pObject)
{
	ASNH245NonStandardMessage *pObj = (ASNH245NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NonStandardMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245NonStandardParameter( &(pObj->m_nonStandardData) );
	return HS_OK;
}

/* ASNH245NonStandardMessage MakeMold */
HS_RESULT ASNH245NonStandardMessage_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NonStandardMessage *pObj = (ASNH245NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardMessage_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	return HS_OK;
}

/* ASNH245NonStandardMessage Encode */
HS_RESULT ASNH245NonStandardMessage_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NonStandardMessage *pObj = (ASNH245NonStandardMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardMessage_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NonStandardMessage Decode */
HS_RESULT ASNH245NonStandardMessage_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NonStandardMessage *pObj = (ASNH245NonStandardMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardMessage_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NonStandardMessage_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NonStandardMessage Print */
HS_RESULT ASNH245NonStandardMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NonStandardMessage *pObj = (ASNH245NonStandardMessage *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NonStandardMessage_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MasterSlaveDetermination Class
*/
/*ASNH245MasterSlaveDetermination Constructor*/
HS_RESULT new_ASNH245MasterSlaveDetermination(void *pObject)
{
	ASNH245MasterSlaveDetermination *pObj = (ASNH245MasterSlaveDetermination *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MasterSlaveDetermination(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_terminalType), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_statusDeterminationNumber), e_constrained, 0, 16777215, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MasterSlaveDetermination Destructor */
HS_RESULT delete_ASNH245MasterSlaveDetermination(void *pObject)
{
	ASNH245MasterSlaveDetermination *pObj = (ASNH245MasterSlaveDetermination *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MasterSlaveDetermination(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_terminalType) );
	delete_AsnInteger( &(pObj->m_statusDeterminationNumber) );
	return HS_OK;
}

/* ASNH245MasterSlaveDetermination MakeMold */
HS_RESULT ASNH245MasterSlaveDetermination_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MasterSlaveDetermination *pObj = (ASNH245MasterSlaveDetermination *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDetermination_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MasterSlaveDetermination Encode */
HS_RESULT ASNH245MasterSlaveDetermination_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MasterSlaveDetermination *pObj = (ASNH245MasterSlaveDetermination *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDetermination_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_terminalType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDetermination_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_statusDeterminationNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDetermination_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MasterSlaveDetermination Decode */
HS_RESULT ASNH245MasterSlaveDetermination_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MasterSlaveDetermination *pObj = (ASNH245MasterSlaveDetermination *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDetermination_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_terminalType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDetermination_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_statusDeterminationNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDetermination_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MasterSlaveDetermination Print */
HS_RESULT ASNH245MasterSlaveDetermination_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MasterSlaveDetermination *pObj = (ASNH245MasterSlaveDetermination *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MasterSlaveDetermination_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_terminalType), pDepth+1, "terminalType" );
	AsnInteger_Print( &(pObj->m_statusDeterminationNumber), pDepth+1, "statusDeterminationNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VCCapability_aal1 Class
*/
/*ASNH245VCCapability_aal1 Constructor*/
HS_RESULT new_ASNH245VCCapability_aal1(void *pObject)
{
	ASNH245VCCapability_aal1 *pObj = (ASNH245VCCapability_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VCCapability_aal1(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_nullClockRecovery) );
	new_AsnBoolean( &(pObj->m_srtsClockRecovery) );
	new_AsnBoolean( &(pObj->m_adaptiveClockRecovery) );
	new_AsnBoolean( &(pObj->m_nullErrorCorrection) );
	new_AsnBoolean( &(pObj->m_longInterleaver) );
	new_AsnBoolean( &(pObj->m_shortInterleaver) );
	new_AsnBoolean( &(pObj->m_errorCorrectionOnly) );
	new_AsnBoolean( &(pObj->m_structuredDataTransfer) );
	new_AsnBoolean( &(pObj->m_partiallyFilledCells) );

	return HS_OK;
}

/* ASNH245VCCapability_aal1 Destructor */
HS_RESULT delete_ASNH245VCCapability_aal1(void *pObject)
{
	ASNH245VCCapability_aal1 *pObj = (ASNH245VCCapability_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VCCapability_aal1(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_nullClockRecovery) );
	delete_AsnBoolean( &(pObj->m_srtsClockRecovery) );
	delete_AsnBoolean( &(pObj->m_adaptiveClockRecovery) );
	delete_AsnBoolean( &(pObj->m_nullErrorCorrection) );
	delete_AsnBoolean( &(pObj->m_longInterleaver) );
	delete_AsnBoolean( &(pObj->m_shortInterleaver) );
	delete_AsnBoolean( &(pObj->m_errorCorrectionOnly) );
	delete_AsnBoolean( &(pObj->m_structuredDataTransfer) );
	delete_AsnBoolean( &(pObj->m_partiallyFilledCells) );
	return HS_OK;
}

/* ASNH245VCCapability_aal1 MakeMold */
HS_RESULT ASNH245VCCapability_aal1_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245VCCapability_aal1 *pObj = (ASNH245VCCapability_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245VCCapability_aal1 Encode */
HS_RESULT ASNH245VCCapability_aal1_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_aal1 *pObj = (ASNH245VCCapability_aal1 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_nullClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_srtsClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_adaptiveClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_nullErrorCorrection),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_longInterleaver),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_shortInterleaver),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_errorCorrectionOnly),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_structuredDataTransfer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_partiallyFilledCells),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245VCCapability_aal1 Decode */
HS_RESULT ASNH245VCCapability_aal1_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_aal1 *pObj = (ASNH245VCCapability_aal1 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_nullClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_srtsClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_adaptiveClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_nullErrorCorrection),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_longInterleaver),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_shortInterleaver),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_errorCorrectionOnly),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_structuredDataTransfer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_partiallyFilledCells),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VCCapability_aal1 Print */
HS_RESULT ASNH245VCCapability_aal1_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VCCapability_aal1 *pObj = (ASNH245VCCapability_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VCCapability_aal1_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_nullClockRecovery), pDepth+1, "nullClockRecovery" );
	AsnBoolean_Print( &(pObj->m_srtsClockRecovery), pDepth+1, "srtsClockRecovery" );
	AsnBoolean_Print( &(pObj->m_adaptiveClockRecovery), pDepth+1, "adaptiveClockRecovery" );
	AsnBoolean_Print( &(pObj->m_nullErrorCorrection), pDepth+1, "nullErrorCorrection" );
	AsnBoolean_Print( &(pObj->m_longInterleaver), pDepth+1, "longInterleaver" );
	AsnBoolean_Print( &(pObj->m_shortInterleaver), pDepth+1, "shortInterleaver" );
	AsnBoolean_Print( &(pObj->m_errorCorrectionOnly), pDepth+1, "errorCorrectionOnly" );
	AsnBoolean_Print( &(pObj->m_structuredDataTransfer), pDepth+1, "structuredDataTransfer" );
	AsnBoolean_Print( &(pObj->m_partiallyFilledCells), pDepth+1, "partiallyFilledCells" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VCCapability_aal5 Class
*/
/*ASNH245VCCapability_aal5 Constructor*/
HS_RESULT new_ASNH245VCCapability_aal5(void *pObject)
{
	ASNH245VCCapability_aal5 *pObj = (ASNH245VCCapability_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VCCapability_aal5(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_forwardMaximumSDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_backwardMaximumSDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245VCCapability_aal5 Destructor */
HS_RESULT delete_ASNH245VCCapability_aal5(void *pObject)
{
	ASNH245VCCapability_aal5 *pObj = (ASNH245VCCapability_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VCCapability_aal5(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_forwardMaximumSDUSize) );
	delete_AsnInteger( &(pObj->m_backwardMaximumSDUSize) );
	return HS_OK;
}

/* ASNH245VCCapability_aal5 MakeMold */
HS_RESULT ASNH245VCCapability_aal5_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245VCCapability_aal5 *pObj = (ASNH245VCCapability_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal5_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245VCCapability_aal5 Encode */
HS_RESULT ASNH245VCCapability_aal5_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_aal5 *pObj = (ASNH245VCCapability_aal5 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal5_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_forwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal5_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_backwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal5_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245VCCapability_aal5 Decode */
HS_RESULT ASNH245VCCapability_aal5_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_aal5 *pObj = (ASNH245VCCapability_aal5 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal5_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_forwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal5_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_backwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal5_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VCCapability_aal5 Print */
HS_RESULT ASNH245VCCapability_aal5_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VCCapability_aal5 *pObj = (ASNH245VCCapability_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VCCapability_aal5_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_forwardMaximumSDUSize), pDepth+1, "forwardMaximumSDUSize" );
	AsnInteger_Print( &(pObj->m_backwardMaximumSDUSize), pDepth+1, "backwardMaximumSDUSize" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VCCapability_availableBitRates_type_rangeOfBitRates Class
*/
/*ASNH245VCCapability_availableBitRates_type_rangeOfBitRates Constructor*/
HS_RESULT new_ASNH245VCCapability_availableBitRates_type_rangeOfBitRates(void *pObject)
{
	ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *pObj = (ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VCCapability_availableBitRates_type_rangeOfBitRates(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_lowerBitRate), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_higherBitRate), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245VCCapability_availableBitRates_type_rangeOfBitRates Destructor */
HS_RESULT delete_ASNH245VCCapability_availableBitRates_type_rangeOfBitRates(void *pObject)
{
	ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *pObj = (ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VCCapability_availableBitRates_type_rangeOfBitRates(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_lowerBitRate) );
	delete_AsnInteger( &(pObj->m_higherBitRate) );
	return HS_OK;
}

/* ASNH245VCCapability_availableBitRates_type_rangeOfBitRates MakeMold */
HS_RESULT ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *pObj = (ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245VCCapability_availableBitRates_type_rangeOfBitRates Encode */
HS_RESULT ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *pObj = (ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_lowerBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_higherBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245VCCapability_availableBitRates_type_rangeOfBitRates Decode */
HS_RESULT ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *pObj = (ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_lowerBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_higherBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VCCapability_availableBitRates_type_rangeOfBitRates Print */
HS_RESULT ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *pObj = (ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_lowerBitRate), pDepth+1, "lowerBitRate" );
	AsnInteger_Print( &(pObj->m_higherBitRate), pDepth+1, "higherBitRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VCCapability_availableBitRates_type Struct
*/
/* ASNH245VCCapability_availableBitRates_type Constructor */
HS_RESULT new_ASNH245VCCapability_availableBitRates_type( void *pObject )
{
	ASNH245VCCapability_availableBitRates_type *pObj = (ASNH245VCCapability_availableBitRates_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VCCapability_availableBitRates_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245VCCapability_availableBitRates_typeChoice_singleBitRate;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245VCCapability_availableBitRates_typeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245VCCapability_availableBitRates_type Destructor */
HS_RESULT delete_ASNH245VCCapability_availableBitRates_type( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245VCCapability_availableBitRates_type *pObj = (ASNH245VCCapability_availableBitRates_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VCCapability_availableBitRates_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245VCCapability_availableBitRates_type_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VCCapability_availableBitRates_type(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245VCCapability_availableBitRates_type SetChoice */
void* ASNH245VCCapability_availableBitRates_type_SetChoice( void *pObject, ASNH245VCCapability_availableBitRates_typeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245VCCapability_availableBitRates_type *pObj = (ASNH245VCCapability_availableBitRates_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245VCCapability_availableBitRates_typeChoiceSizeExt ){
		if( pChoice > (ASNH245VCCapability_availableBitRates_typeChoice)(e_ASNH245VCCapability_availableBitRates_typeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245VCCapability_availableBitRates_type_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245VCCapability_availableBitRates_typeChoice_singleBitRate ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,1,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245VCCapability_availableBitRates_typeChoice_rangeOfBitRates ){
		ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *tAlter = (ASNH245VCCapability_availableBitRates_type_rangeOfBitRates *)HSMalloc( sizeof(ASNH245VCCapability_availableBitRates_type_rangeOfBitRates) );
		new_ASNH245VCCapability_availableBitRates_type_rangeOfBitRates(tAlter);
		ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245VCCapability_availableBitRates_type DeleteAlternation */
HS_RESULT ASNH245VCCapability_availableBitRates_type_DeleteAlternation(void *pObject)
{
	ASNH245VCCapability_availableBitRates_type *pObj = (ASNH245VCCapability_availableBitRates_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245VCCapability_availableBitRates_typeChoice_singleBitRate ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245VCCapability_availableBitRates_typeChoice_rangeOfBitRates ){
			delete_ASNH245VCCapability_availableBitRates_type_rangeOfBitRates(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245VCCapability_availableBitRates_type_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245VCCapability_availableBitRates_type Encode */
HS_RESULT ASNH245VCCapability_availableBitRates_type_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245VCCapability_availableBitRates_type *pObj = (ASNH245VCCapability_availableBitRates_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245VCCapability_availableBitRates_typeChoiceSize )
		{
			if( pObj->choice > ((ASNH245VCCapability_availableBitRates_typeChoice)(e_ASNH245VCCapability_availableBitRates_typeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245VCCapability_availableBitRates_typeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245VCCapability_availableBitRates_typeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245VCCapability_availableBitRates_typeChoice_singleBitRate ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VCCapability_availableBitRates_typeChoice_rangeOfBitRates ){
		if( (tRet=ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245VCCapability_availableBitRates_type Decode */
HS_RESULT ASNH245VCCapability_availableBitRates_type_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245VCCapability_availableBitRates_type *pObj = (ASNH245VCCapability_availableBitRates_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245VCCapability_availableBitRates_typeChoiceSize;
	}
	else
	{
		if( e_ASNH245VCCapability_availableBitRates_typeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245VCCapability_availableBitRates_typeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245VCCapability_availableBitRates_typeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245VCCapability_availableBitRates_type_SetChoice( pObj, (ASNH245VCCapability_availableBitRates_typeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245VCCapability_availableBitRates_typeChoice_singleBitRate ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VCCapability_availableBitRates_typeChoice_rangeOfBitRates ){
		if( (tRet=ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VCCapability_availableBitRates_type Print */
HS_RESULT ASNH245VCCapability_availableBitRates_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VCCapability_availableBitRates_type *pObj = (ASNH245VCCapability_availableBitRates_type *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_type_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245VCCapability_availableBitRates_typeChoice_singleBitRate ){
		AsnInteger_Print( pObj->alter, pDepth+1, "singleBitRate" );
	}
	else if ( pObj->choice == e_ASNH245VCCapability_availableBitRates_typeChoice_rangeOfBitRates ){
		ASNH245VCCapability_availableBitRates_type_rangeOfBitRates_Print( pObj->alter, pDepth+1, "rangeOfBitRates" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VCCapability_availableBitRates Class
*/
/*ASNH245VCCapability_availableBitRates Constructor*/
HS_RESULT new_ASNH245VCCapability_availableBitRates(void *pObject)
{
	ASNH245VCCapability_availableBitRates *pObj = (ASNH245VCCapability_availableBitRates *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VCCapability_availableBitRates(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245VCCapability_availableBitRates_type( &(pObj->m_type) );

	return HS_OK;
}

/* ASNH245VCCapability_availableBitRates Destructor */
HS_RESULT delete_ASNH245VCCapability_availableBitRates(void *pObject)
{
	ASNH245VCCapability_availableBitRates *pObj = (ASNH245VCCapability_availableBitRates *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VCCapability_availableBitRates(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245VCCapability_availableBitRates_type( &(pObj->m_type) );
	return HS_OK;
}

/* ASNH245VCCapability_availableBitRates MakeMold */
HS_RESULT ASNH245VCCapability_availableBitRates_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245VCCapability_availableBitRates *pObj = (ASNH245VCCapability_availableBitRates *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245VCCapability_availableBitRates Encode */
HS_RESULT ASNH245VCCapability_availableBitRates_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_availableBitRates *pObj = (ASNH245VCCapability_availableBitRates *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245VCCapability_availableBitRates_type_Encode( &(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245VCCapability_availableBitRates Decode */
HS_RESULT ASNH245VCCapability_availableBitRates_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_availableBitRates *pObj = (ASNH245VCCapability_availableBitRates *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245VCCapability_availableBitRates_type_Decode(&(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VCCapability_availableBitRates Print */
HS_RESULT ASNH245VCCapability_availableBitRates_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VCCapability_availableBitRates *pObj = (ASNH245VCCapability_availableBitRates *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VCCapability_availableBitRates_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245VCCapability_availableBitRates_type_Print( &(pObj->m_type), pDepth+1, "type" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245Q2931Address_address Struct
*/
/* ASNH245Q2931Address_address Constructor */
HS_RESULT new_ASNH245Q2931Address_address( void *pObject )
{
	ASNH245Q2931Address_address *pObj = (ASNH245Q2931Address_address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245Q2931Address_address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245Q2931Address_addressChoice_internationalNumber;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245Q2931Address_addressChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245Q2931Address_address Destructor */
HS_RESULT delete_ASNH245Q2931Address_address( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245Q2931Address_address *pObj = (ASNH245Q2931Address_address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245Q2931Address_address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245Q2931Address_address_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245Q2931Address_address(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245Q2931Address_address SetChoice */
void* ASNH245Q2931Address_address_SetChoice( void *pObject, ASNH245Q2931Address_addressChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245Q2931Address_address *pObj = (ASNH245Q2931Address_address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_address_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245Q2931Address_addressChoiceSizeExt ){
		if( pChoice > (ASNH245Q2931Address_addressChoice)(e_ASNH245Q2931Address_addressChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_address_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245Q2931Address_address_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_address_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245Q2931Address_addressChoice_internationalNumber ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagNumericString,e_constrained,1,16,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245Q2931Address_addressChoice_nsapAddress ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_constrained,1,20,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_address_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245Q2931Address_address DeleteAlternation */
HS_RESULT ASNH245Q2931Address_address_DeleteAlternation(void *pObject)
{
	ASNH245Q2931Address_address *pObj = (ASNH245Q2931Address_address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_address_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245Q2931Address_addressChoice_internationalNumber ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245Q2931Address_addressChoice_nsapAddress ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_address_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245Q2931Address_address_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245Q2931Address_address Encode */
HS_RESULT ASNH245Q2931Address_address_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245Q2931Address_address *pObj = (ASNH245Q2931Address_address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_address_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_address_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245Q2931Address_addressChoiceSize )
		{
			if( pObj->choice > ((ASNH245Q2931Address_addressChoice)(e_ASNH245Q2931Address_addressChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245Q2931Address_addressChoiceSize)) )
	}
	else
	{
		if( e_ASNH245Q2931Address_addressChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245Q2931Address_addressChoice_internationalNumber ){
		if( (tRet=AsnSingleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245Q2931Address_addressChoice_nsapAddress ){
		if( (tRet=AsnOctetString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_address_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245Q2931Address_address Decode */
HS_RESULT ASNH245Q2931Address_address_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245Q2931Address_address *pObj = (ASNH245Q2931Address_address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_address_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245Q2931Address_addressChoiceSize;
	}
	else
	{
		if( e_ASNH245Q2931Address_addressChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245Q2931Address_addressChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245Q2931Address_addressChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_address_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245Q2931Address_address_SetChoice( pObj, (ASNH245Q2931Address_addressChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_address_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245Q2931Address_addressChoice_internationalNumber ){
		if( (tRet=AsnSingleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_address_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245Q2931Address_addressChoice_nsapAddress ){
		if( (tRet=AsnOctetString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_address_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_address_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245Q2931Address_address Print */
HS_RESULT ASNH245Q2931Address_address_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245Q2931Address_address *pObj = (ASNH245Q2931Address_address *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245Q2931Address_address_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245Q2931Address_addressChoice_internationalNumber ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "internationalNumber" );
	}
	else if ( pObj->choice == e_ASNH245Q2931Address_addressChoice_nsapAddress ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "nsapAddress" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245Q2931Address Class
*/
/*ASNH245Q2931Address Constructor*/
HS_RESULT new_ASNH245Q2931Address(void *pObject)
{
	ASNH245Q2931Address *pObj = (ASNH245Q2931Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245Q2931Address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245Q2931Address_address( &(pObj->m_address) );
	new_AsnOctetString( &(pObj->m_subaddress), e_constrained, 1, 20, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245Q2931Address Destructor */
HS_RESULT delete_ASNH245Q2931Address(void *pObject)
{
	ASNH245Q2931Address *pObj = (ASNH245Q2931Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245Q2931Address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245Q2931Address_address( &(pObj->m_address) );
	delete_AsnOctetString( &(pObj->m_subaddress) );
	return HS_OK;
}

/* ASNH245Q2931Address MakeMold */
HS_RESULT ASNH245Q2931Address_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245Q2931Address *pObj = (ASNH245Q2931Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245Q2931Address IncludeOptionalField */
HS_RESULT ASNH245Q2931Address_IncludeOptionField( void *pObject, ASNH245Q2931AddressOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245Q2931Address *pObj = (ASNH245Q2931Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245Q2931AddressOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245Q2931Address IsIncludeOptionalField */
BOOL ASNH245Q2931Address_IsIncludeOptionField( void *pObject, ASNH245Q2931AddressOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245Q2931Address *pObj = (ASNH245Q2931Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245Q2931AddressOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245Q2931Address Encode */
HS_RESULT ASNH245Q2931Address_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245Q2931Address *pObj = (ASNH245Q2931Address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245Q2931AddressOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245Q2931AddressOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245Q2931Address_address_Encode( &(pObj->m_address),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245Q2931Address_IsIncludeOptionField( pObj, e_ASNH245Q2931AddressOptionMap_subaddress ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_subaddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245Q2931Address Decode */
HS_RESULT ASNH245Q2931Address_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245Q2931Address *pObj = (ASNH245Q2931Address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245Q2931AddressOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245Q2931AddressOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245Q2931Address_address_Decode(&(pObj->m_address),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245Q2931Address_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245Q2931Address_IsIncludeOptionField( pObj, e_ASNH245Q2931AddressOptionMap_subaddress ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_subaddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245Q2931Address_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245Q2931Address Print */
HS_RESULT ASNH245Q2931Address_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245Q2931Address *pObj = (ASNH245Q2931Address *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245Q2931Address_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245Q2931Address_address_Print( &(pObj->m_address), pDepth+1, "address" );
	if( ASNH245Q2931Address_IsIncludeOptionField( pObj, e_ASNH245Q2931AddressOptionMap_subaddress ) )
		AsnOctetString_Print( &(pObj->m_subaddress), pDepth+1, "subaddress" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VCCapability_aal1ViaGateway Class
*/
/*ASNH245VCCapability_aal1ViaGateway Constructor*/
HS_RESULT new_ASNH245VCCapability_aal1ViaGateway(void *pObject)
{
	ASNH245VCCapability_aal1ViaGateway *pObj = (ASNH245VCCapability_aal1ViaGateway *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VCCapability_aal1ViaGateway(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_gatewayAddress), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_nullClockRecovery) );
	new_AsnBoolean( &(pObj->m_srtsClockRecovery) );
	new_AsnBoolean( &(pObj->m_adaptiveClockRecovery) );
	new_AsnBoolean( &(pObj->m_nullErrorCorrection) );
	new_AsnBoolean( &(pObj->m_longInterleaver) );
	new_AsnBoolean( &(pObj->m_shortInterleaver) );
	new_AsnBoolean( &(pObj->m_errorCorrectionOnly) );
	new_AsnBoolean( &(pObj->m_structuredDataTransfer) );
	new_AsnBoolean( &(pObj->m_partiallyFilledCells) );

	return HS_OK;
}

/* ASNH245VCCapability_aal1ViaGateway Destructor */
HS_RESULT delete_ASNH245VCCapability_aal1ViaGateway(void *pObject)
{
	ASNH245VCCapability_aal1ViaGateway *pObj = (ASNH245VCCapability_aal1ViaGateway *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VCCapability_aal1ViaGateway(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_gatewayAddress) );
	delete_AsnBoolean( &(pObj->m_nullClockRecovery) );
	delete_AsnBoolean( &(pObj->m_srtsClockRecovery) );
	delete_AsnBoolean( &(pObj->m_adaptiveClockRecovery) );
	delete_AsnBoolean( &(pObj->m_nullErrorCorrection) );
	delete_AsnBoolean( &(pObj->m_longInterleaver) );
	delete_AsnBoolean( &(pObj->m_shortInterleaver) );
	delete_AsnBoolean( &(pObj->m_errorCorrectionOnly) );
	delete_AsnBoolean( &(pObj->m_structuredDataTransfer) );
	delete_AsnBoolean( &(pObj->m_partiallyFilledCells) );
	return HS_OK;
}

/* ASNH245VCCapability_aal1ViaGateway MakeMold */
HS_RESULT ASNH245VCCapability_aal1ViaGateway_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245VCCapability_aal1ViaGateway *pObj = (ASNH245VCCapability_aal1ViaGateway *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245Q2931Address *tmold_gatewayAddress = (ASNH245Q2931Address *)HSMalloc( sizeof(ASNH245Q2931Address) );
	new_ASNH245Q2931Address(tmold_gatewayAddress);
	ASNH245Q2931Address_MakeMold(tmold_gatewayAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_gatewayAddress,sizeof(ASNH245Q2931Address),ASNH245Q2931Address_MakeMold,ASNH245Q2931Address_Encode,ASNH245Q2931Address_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245Q2931Address_Print,
#endif
		delete_ASNH245Q2931Address);
	AsnSequenceOf_SetMold( &(pObj->m_gatewayAddress), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_gatewayAddress.constraint.type = e_constrained;
	pObj->m_gatewayAddress.constraint.minValue = 1;
	pObj->m_gatewayAddress.constraint.maxValue = 256;
	pObj->m_gatewayAddress.extMinValue = 0;
	pObj->m_gatewayAddress.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245VCCapability_aal1ViaGateway Encode */
HS_RESULT ASNH245VCCapability_aal1ViaGateway_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_aal1ViaGateway *pObj = (ASNH245VCCapability_aal1ViaGateway *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_gatewayAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_nullClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_srtsClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_adaptiveClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_nullErrorCorrection),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_longInterleaver),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_shortInterleaver),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_errorCorrectionOnly),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_structuredDataTransfer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_partiallyFilledCells),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245VCCapability_aal1ViaGateway Decode */
HS_RESULT ASNH245VCCapability_aal1ViaGateway_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VCCapability_aal1ViaGateway *pObj = (ASNH245VCCapability_aal1ViaGateway *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_gatewayAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_nullClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_srtsClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_adaptiveClockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_nullErrorCorrection),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_longInterleaver),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_shortInterleaver),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_errorCorrectionOnly),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_structuredDataTransfer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_partiallyFilledCells),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VCCapability_aal1ViaGateway Print */
HS_RESULT ASNH245VCCapability_aal1ViaGateway_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VCCapability_aal1ViaGateway *pObj = (ASNH245VCCapability_aal1ViaGateway *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VCCapability_aal1ViaGateway_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSequenceOf_Print( &(pObj->m_gatewayAddress), pDepth+1, "gatewayAddress" );
	AsnBoolean_Print( &(pObj->m_nullClockRecovery), pDepth+1, "nullClockRecovery" );
	AsnBoolean_Print( &(pObj->m_srtsClockRecovery), pDepth+1, "srtsClockRecovery" );
	AsnBoolean_Print( &(pObj->m_adaptiveClockRecovery), pDepth+1, "adaptiveClockRecovery" );
	AsnBoolean_Print( &(pObj->m_nullErrorCorrection), pDepth+1, "nullErrorCorrection" );
	AsnBoolean_Print( &(pObj->m_longInterleaver), pDepth+1, "longInterleaver" );
	AsnBoolean_Print( &(pObj->m_shortInterleaver), pDepth+1, "shortInterleaver" );
	AsnBoolean_Print( &(pObj->m_errorCorrectionOnly), pDepth+1, "errorCorrectionOnly" );
	AsnBoolean_Print( &(pObj->m_structuredDataTransfer), pDepth+1, "structuredDataTransfer" );
	AsnBoolean_Print( &(pObj->m_partiallyFilledCells), pDepth+1, "partiallyFilledCells" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VCCapability Class
*/
/*ASNH245VCCapability Constructor*/
HS_RESULT new_ASNH245VCCapability(void *pObject)
{
	ASNH245VCCapability *pObj = (ASNH245VCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VCCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245VCCapability_aal1( &(pObj->m_aal1) );
	new_ASNH245VCCapability_aal5( &(pObj->m_aal5) );
	new_AsnBoolean( &(pObj->m_transportStream) );
	new_AsnBoolean( &(pObj->m_programStream) );
	new_ASNH245VCCapability_availableBitRates( &(pObj->m_availableBitRates) );
	new_ASNH245VCCapability_aal1ViaGateway( &(pObj->m_aal1ViaGateway) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245VCCapability Destructor */
HS_RESULT delete_ASNH245VCCapability(void *pObject)
{
	ASNH245VCCapability *pObj = (ASNH245VCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VCCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245VCCapability_aal1( &(pObj->m_aal1) );
	delete_ASNH245VCCapability_aal5( &(pObj->m_aal5) );
	delete_AsnBoolean( &(pObj->m_transportStream) );
	delete_AsnBoolean( &(pObj->m_programStream) );
	delete_ASNH245VCCapability_availableBitRates( &(pObj->m_availableBitRates) );
	delete_ASNH245VCCapability_aal1ViaGateway( &(pObj->m_aal1ViaGateway) );
	return HS_OK;
}

/* ASNH245VCCapability MakeMold */
HS_RESULT ASNH245VCCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245VCCapability *pObj = (ASNH245VCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245VCCapability_aal1_MakeMold(&(pObj->m_aal1));
	ASNH245VCCapability_aal5_MakeMold(&(pObj->m_aal5));
	ASNH245VCCapability_availableBitRates_MakeMold(&(pObj->m_availableBitRates));
	ASNH245VCCapability_aal1ViaGateway_MakeMold(&(pObj->m_aal1ViaGateway));
	return HS_OK;
}

/* ASNH245VCCapability IncludeOptionalField */
HS_RESULT ASNH245VCCapability_IncludeOptionField( void *pObject, ASNH245VCCapabilityOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245VCCapability *pObj = (ASNH245VCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245VCCapabilityOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245VCCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245VCCapabilityOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245VCCapability IsIncludeOptionalField */
BOOL ASNH245VCCapability_IsIncludeOptionField( void *pObject, ASNH245VCCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245VCCapability *pObj = (ASNH245VCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245VCCapabilityOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245VCCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245VCCapabilityOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245VCCapability Encode */
HS_RESULT ASNH245VCCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245VCCapability *pObj = (ASNH245VCCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245VCCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245VCCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245VCCapability_IsIncludeOptionField( pObj, e_ASNH245VCCapabilityOptionMap_aal1 ) ){
		if( (tRet=ASNH245VCCapability_aal1_Encode( &(pObj->m_aal1),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245VCCapability_IsIncludeOptionField( pObj, e_ASNH245VCCapabilityOptionMap_aal5 ) ){
		if( (tRet=ASNH245VCCapability_aal5_Encode( &(pObj->m_aal5),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_transportStream),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_programStream),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245VCCapability_availableBitRates_Encode( &(pObj->m_availableBitRates),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245VCCapability_IsIncludeOptionField( pObj, e_ASNH245VCCapabilityOptionMap_aal1ViaGateway ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_aal1ViaGateway), ASNH245VCCapability_aal1ViaGateway_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245VCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245VCCapability Decode */
HS_RESULT ASNH245VCCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245VCCapability *pObj = (ASNH245VCCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245VCCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245VCCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245VCCapability_IsIncludeOptionField( pObj, e_ASNH245VCCapabilityOptionMap_aal1 ) ){
		if( (tRet=ASNH245VCCapability_aal1_Decode(&(pObj->m_aal1),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245VCCapability_IsIncludeOptionField( pObj, e_ASNH245VCCapabilityOptionMap_aal5 ) ){
		if( (tRet=ASNH245VCCapability_aal5_Decode(&(pObj->m_aal5),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_transportStream),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_programStream),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245VCCapability_availableBitRates_Decode(&(pObj->m_availableBitRates),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245VCCapability_IsIncludeOptionField( pObj, e_ASNH245VCCapabilityOptionMap_aal1ViaGateway ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_aal1ViaGateway), ASNH245VCCapability_aal1ViaGateway_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VCCapability Print */
HS_RESULT ASNH245VCCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VCCapability *pObj = (ASNH245VCCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VCCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245VCCapability_IsIncludeOptionField( pObj, e_ASNH245VCCapabilityOptionMap_aal1 ) )
		ASNH245VCCapability_aal1_Print( &(pObj->m_aal1), pDepth+1, "aal1" );
	if( ASNH245VCCapability_IsIncludeOptionField( pObj, e_ASNH245VCCapabilityOptionMap_aal5 ) )
		ASNH245VCCapability_aal5_Print( &(pObj->m_aal5), pDepth+1, "aal5" );
	AsnBoolean_Print( &(pObj->m_transportStream), pDepth+1, "transportStream" );
	AsnBoolean_Print( &(pObj->m_programStream), pDepth+1, "programStream" );
	ASNH245VCCapability_availableBitRates_Print( &(pObj->m_availableBitRates), pDepth+1, "availableBitRates" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245VCCapability_IsIncludeOptionField( pObj, e_ASNH245VCCapabilityOptionMap_aal1ViaGateway ) )
		ASNH245VCCapability_aal1ViaGateway_Print( &(pObj->m_aal1ViaGateway), pDepth+1, "aal1ViaGateway" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H222Capability Class
*/
/*ASNH245H222Capability Constructor*/
HS_RESULT new_ASNH245H222Capability(void *pObject)
{
	ASNH245H222Capability *pObj = (ASNH245H222Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H222Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_numberOfVCs), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_vcCapability), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245H222Capability Destructor */
HS_RESULT delete_ASNH245H222Capability(void *pObject)
{
	ASNH245H222Capability *pObj = (ASNH245H222Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H222Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_numberOfVCs) );
	delete_AsnSequenceOf( &(pObj->m_vcCapability) );
	return HS_OK;
}

/* ASNH245H222Capability MakeMold */
HS_RESULT ASNH245H222Capability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H222Capability *pObj = (ASNH245H222Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H222Capability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245VCCapability *tmold_vcCapability = (ASNH245VCCapability *)HSMalloc( sizeof(ASNH245VCCapability) );
	new_ASNH245VCCapability(tmold_vcCapability);
	ASNH245VCCapability_MakeMold(tmold_vcCapability);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_vcCapability,sizeof(ASNH245VCCapability),ASNH245VCCapability_MakeMold,ASNH245VCCapability_Encode,ASNH245VCCapability_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245VCCapability_Print,
#endif
		delete_ASNH245VCCapability);
	AsnSequenceOf_SetMold( &(pObj->m_vcCapability), moldObject );
	}
	return HS_OK;
}

/* ASNH245H222Capability Encode */
HS_RESULT ASNH245H222Capability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H222Capability *pObj = (ASNH245H222Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H222Capability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_numberOfVCs),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H222Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_vcCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H222Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H222Capability Decode */
HS_RESULT ASNH245H222Capability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H222Capability *pObj = (ASNH245H222Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H222Capability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_numberOfVCs),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H222Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_vcCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H222Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H222Capability Print */
HS_RESULT ASNH245H222Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H222Capability *pObj = (ASNH245H222Capability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H222Capability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_numberOfVCs), pDepth+1, "numberOfVCs" );
	AsnSequenceOf_Print( &(pObj->m_vcCapability), pDepth+1, "vcCapability" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223Capability_h223MultiplexTableCapability_enhanced Class
*/
/*ASNH245H223Capability_h223MultiplexTableCapability_enhanced Constructor*/
HS_RESULT new_ASNH245H223Capability_h223MultiplexTableCapability_enhanced(void *pObject)
{
	ASNH245H223Capability_h223MultiplexTableCapability_enhanced *pObj = (ASNH245H223Capability_h223MultiplexTableCapability_enhanced *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223Capability_h223MultiplexTableCapability_enhanced(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_maximumNestingDepth), e_constrained, 1, 15, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maximumElementListSize), e_constrained, 2, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maximumSubElementListSize), e_constrained, 2, 255, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245H223Capability_h223MultiplexTableCapability_enhanced Destructor */
HS_RESULT delete_ASNH245H223Capability_h223MultiplexTableCapability_enhanced(void *pObject)
{
	ASNH245H223Capability_h223MultiplexTableCapability_enhanced *pObj = (ASNH245H223Capability_h223MultiplexTableCapability_enhanced *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223Capability_h223MultiplexTableCapability_enhanced(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_maximumNestingDepth) );
	delete_AsnInteger( &(pObj->m_maximumElementListSize) );
	delete_AsnInteger( &(pObj->m_maximumSubElementListSize) );
	return HS_OK;
}

/* ASNH245H223Capability_h223MultiplexTableCapability_enhanced MakeMold */
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_enhanced_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H223Capability_h223MultiplexTableCapability_enhanced *pObj = (ASNH245H223Capability_h223MultiplexTableCapability_enhanced *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H223Capability_h223MultiplexTableCapability_enhanced Encode */
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223Capability_h223MultiplexTableCapability_enhanced *pObj = (ASNH245H223Capability_h223MultiplexTableCapability_enhanced *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumNestingDepth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumElementListSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumSubElementListSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H223Capability_h223MultiplexTableCapability_enhanced Decode */
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223Capability_h223MultiplexTableCapability_enhanced *pObj = (ASNH245H223Capability_h223MultiplexTableCapability_enhanced *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumNestingDepth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumElementListSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumSubElementListSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223Capability_h223MultiplexTableCapability_enhanced Print */
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223Capability_h223MultiplexTableCapability_enhanced *pObj = (ASNH245H223Capability_h223MultiplexTableCapability_enhanced *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_maximumNestingDepth), pDepth+1, "maximumNestingDepth" );
	AsnInteger_Print( &(pObj->m_maximumElementListSize), pDepth+1, "maximumElementListSize" );
	AsnInteger_Print( &(pObj->m_maximumSubElementListSize), pDepth+1, "maximumSubElementListSize" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223Capability_h223MultiplexTableCapability Struct
*/
/* ASNH245H223Capability_h223MultiplexTableCapability Constructor */
HS_RESULT new_ASNH245H223Capability_h223MultiplexTableCapability( void *pObject )
{
	ASNH245H223Capability_h223MultiplexTableCapability *pObj = (ASNH245H223Capability_h223MultiplexTableCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223Capability_h223MultiplexTableCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_basic;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245H223Capability_h223MultiplexTableCapability Destructor */
HS_RESULT delete_ASNH245H223Capability_h223MultiplexTableCapability( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245H223Capability_h223MultiplexTableCapability *pObj = (ASNH245H223Capability_h223MultiplexTableCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223Capability_h223MultiplexTableCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245H223Capability_h223MultiplexTableCapability_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223Capability_h223MultiplexTableCapability(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245H223Capability_h223MultiplexTableCapability SetChoice */
void* ASNH245H223Capability_h223MultiplexTableCapability_SetChoice( void *pObject, ASNH245H223Capability_h223MultiplexTableCapabilityChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245H223Capability_h223MultiplexTableCapability *pObj = (ASNH245H223Capability_h223MultiplexTableCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSizeExt ){
		if( pChoice > (ASNH245H223Capability_h223MultiplexTableCapabilityChoice)(e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245H223Capability_h223MultiplexTableCapability_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_basic ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_enhanced ){
		ASNH245H223Capability_h223MultiplexTableCapability_enhanced *tAlter = (ASNH245H223Capability_h223MultiplexTableCapability_enhanced *)HSMalloc( sizeof(ASNH245H223Capability_h223MultiplexTableCapability_enhanced) );
		new_ASNH245H223Capability_h223MultiplexTableCapability_enhanced(tAlter);
		ASNH245H223Capability_h223MultiplexTableCapability_enhanced_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245H223Capability_h223MultiplexTableCapability DeleteAlternation */
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_DeleteAlternation(void *pObject)
{
	ASNH245H223Capability_h223MultiplexTableCapability *pObj = (ASNH245H223Capability_h223MultiplexTableCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_basic ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_enhanced ){
			delete_ASNH245H223Capability_h223MultiplexTableCapability_enhanced(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245H223Capability_h223MultiplexTableCapability Encode */
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245H223Capability_h223MultiplexTableCapability *pObj = (ASNH245H223Capability_h223MultiplexTableCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSize )
		{
			if( pObj->choice > ((ASNH245H223Capability_h223MultiplexTableCapabilityChoice)(e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSize)) )
	}
	else
	{
		if( e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_basic ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_enhanced ){
		if( (tRet=ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245H223Capability_h223MultiplexTableCapability Decode */
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245H223Capability_h223MultiplexTableCapability *pObj = (ASNH245H223Capability_h223MultiplexTableCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSize;
	}
	else
	{
		if( e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245H223Capability_h223MultiplexTableCapabilityChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245H223Capability_h223MultiplexTableCapability_SetChoice( pObj, (ASNH245H223Capability_h223MultiplexTableCapabilityChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_basic ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_enhanced ){
		if( (tRet=ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223Capability_h223MultiplexTableCapability Print */
HS_RESULT ASNH245H223Capability_h223MultiplexTableCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223Capability_h223MultiplexTableCapability *pObj = (ASNH245H223Capability_h223MultiplexTableCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223Capability_h223MultiplexTableCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_basic ){
		AsnNull_Print( pObj->alter, pDepth+1, "basic" );
	}
	else if ( pObj->choice == e_ASNH245H223Capability_h223MultiplexTableCapabilityChoice_enhanced ){
		ASNH245H223Capability_h223MultiplexTableCapability_enhanced_Print( pObj->alter, pDepth+1, "enhanced" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223Capability_mobileOperationTransmitCapability Class
*/
/*ASNH245H223Capability_mobileOperationTransmitCapability Constructor*/
HS_RESULT new_ASNH245H223Capability_mobileOperationTransmitCapability(void *pObject)
{
	ASNH245H223Capability_mobileOperationTransmitCapability *pObj = (ASNH245H223Capability_mobileOperationTransmitCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223Capability_mobileOperationTransmitCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_modeChangeCapability) );
	new_AsnBoolean( &(pObj->m_h223AnnexA) );
	new_AsnBoolean( &(pObj->m_h223AnnexADoubleFlag) );
	new_AsnBoolean( &(pObj->m_h223AnnexB) );
	new_AsnBoolean( &(pObj->m_h223AnnexBwithHeader) );

	return HS_OK;
}

/* ASNH245H223Capability_mobileOperationTransmitCapability Destructor */
HS_RESULT delete_ASNH245H223Capability_mobileOperationTransmitCapability(void *pObject)
{
	ASNH245H223Capability_mobileOperationTransmitCapability *pObj = (ASNH245H223Capability_mobileOperationTransmitCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223Capability_mobileOperationTransmitCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_modeChangeCapability) );
	delete_AsnBoolean( &(pObj->m_h223AnnexA) );
	delete_AsnBoolean( &(pObj->m_h223AnnexADoubleFlag) );
	delete_AsnBoolean( &(pObj->m_h223AnnexB) );
	delete_AsnBoolean( &(pObj->m_h223AnnexBwithHeader) );
	return HS_OK;
}

/* ASNH245H223Capability_mobileOperationTransmitCapability MakeMold */
HS_RESULT ASNH245H223Capability_mobileOperationTransmitCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H223Capability_mobileOperationTransmitCapability *pObj = (ASNH245H223Capability_mobileOperationTransmitCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H223Capability_mobileOperationTransmitCapability Encode */
HS_RESULT ASNH245H223Capability_mobileOperationTransmitCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223Capability_mobileOperationTransmitCapability *pObj = (ASNH245H223Capability_mobileOperationTransmitCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_modeChangeCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_h223AnnexA),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_h223AnnexADoubleFlag),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_h223AnnexB),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_h223AnnexBwithHeader),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H223Capability_mobileOperationTransmitCapability Decode */
HS_RESULT ASNH245H223Capability_mobileOperationTransmitCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223Capability_mobileOperationTransmitCapability *pObj = (ASNH245H223Capability_mobileOperationTransmitCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_modeChangeCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_h223AnnexA),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_h223AnnexADoubleFlag),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_h223AnnexB),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_h223AnnexBwithHeader),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223Capability_mobileOperationTransmitCapability Print */
HS_RESULT ASNH245H223Capability_mobileOperationTransmitCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223Capability_mobileOperationTransmitCapability *pObj = (ASNH245H223Capability_mobileOperationTransmitCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223Capability_mobileOperationTransmitCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_modeChangeCapability), pDepth+1, "modeChangeCapability" );
	AsnBoolean_Print( &(pObj->m_h223AnnexA), pDepth+1, "h223AnnexA" );
	AsnBoolean_Print( &(pObj->m_h223AnnexADoubleFlag), pDepth+1, "h223AnnexADoubleFlag" );
	AsnBoolean_Print( &(pObj->m_h223AnnexB), pDepth+1, "h223AnnexB" );
	AsnBoolean_Print( &(pObj->m_h223AnnexBwithHeader), pDepth+1, "h223AnnexBwithHeader" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223AnnexCCapability Class
*/
/*ASNH245H223AnnexCCapability Constructor*/
HS_RESULT new_ASNH245H223AnnexCCapability(void *pObject)
{
	ASNH245H223AnnexCCapability *pObj = (ASNH245H223AnnexCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223AnnexCCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_videoWithAL1M) );
	new_AsnBoolean( &(pObj->m_videoWithAL2M) );
	new_AsnBoolean( &(pObj->m_videoWithAL3M) );
	new_AsnBoolean( &(pObj->m_audioWithAL1M) );
	new_AsnBoolean( &(pObj->m_audioWithAL2M) );
	new_AsnBoolean( &(pObj->m_audioWithAL3M) );
	new_AsnBoolean( &(pObj->m_dataWithAL1M) );
	new_AsnBoolean( &(pObj->m_dataWithAL2M) );
	new_AsnBoolean( &(pObj->m_dataWithAL3M) );
	new_AsnBoolean( &(pObj->m_alpduInterleaving) );
	new_AsnInteger( &(pObj->m_maximumAL1MPDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maximumAL2MSDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maximumAL3MSDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_rsCodeCapability) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H223AnnexCCapability Destructor */
HS_RESULT delete_ASNH245H223AnnexCCapability(void *pObject)
{
	ASNH245H223AnnexCCapability *pObj = (ASNH245H223AnnexCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223AnnexCCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_videoWithAL1M) );
	delete_AsnBoolean( &(pObj->m_videoWithAL2M) );
	delete_AsnBoolean( &(pObj->m_videoWithAL3M) );
	delete_AsnBoolean( &(pObj->m_audioWithAL1M) );
	delete_AsnBoolean( &(pObj->m_audioWithAL2M) );
	delete_AsnBoolean( &(pObj->m_audioWithAL3M) );
	delete_AsnBoolean( &(pObj->m_dataWithAL1M) );
	delete_AsnBoolean( &(pObj->m_dataWithAL2M) );
	delete_AsnBoolean( &(pObj->m_dataWithAL3M) );
	delete_AsnBoolean( &(pObj->m_alpduInterleaving) );
	delete_AsnInteger( &(pObj->m_maximumAL1MPDUSize) );
	delete_AsnInteger( &(pObj->m_maximumAL2MSDUSize) );
	delete_AsnInteger( &(pObj->m_maximumAL3MSDUSize) );
	delete_AsnBoolean( &(pObj->m_rsCodeCapability) );
	return HS_OK;
}

/* ASNH245H223AnnexCCapability MakeMold */
HS_RESULT ASNH245H223AnnexCCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H223AnnexCCapability *pObj = (ASNH245H223AnnexCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H223AnnexCCapability IncludeOptionalField */
HS_RESULT ASNH245H223AnnexCCapability_IncludeOptionField( void *pObject, ASNH245H223AnnexCCapabilityOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H223AnnexCCapability *pObj = (ASNH245H223AnnexCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H223AnnexCCapabilityOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H223AnnexCCapabilityOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245H223AnnexCCapability IsIncludeOptionalField */
BOOL ASNH245H223AnnexCCapability_IsIncludeOptionField( void *pObject, ASNH245H223AnnexCCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H223AnnexCCapability *pObj = (ASNH245H223AnnexCCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H223AnnexCCapabilityOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H223AnnexCCapabilityOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H223AnnexCCapability Encode */
HS_RESULT ASNH245H223AnnexCCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223AnnexCCapability *pObj = (ASNH245H223AnnexCCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_videoWithAL1M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_videoWithAL2M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_videoWithAL3M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioWithAL1M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioWithAL2M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioWithAL3M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dataWithAL1M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dataWithAL2M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dataWithAL3M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_alpduInterleaving),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumAL1MPDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumAL2MSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumAL3MSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H223AnnexCCapability_IsIncludeOptionField( pObj, e_ASNH245H223AnnexCCapabilityOptionMap_rsCodeCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_rsCodeCapability), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H223AnnexCCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H223AnnexCCapability Decode */
HS_RESULT ASNH245H223AnnexCCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223AnnexCCapability *pObj = (ASNH245H223AnnexCCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_videoWithAL1M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_videoWithAL2M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_videoWithAL3M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioWithAL1M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioWithAL2M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioWithAL3M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dataWithAL1M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dataWithAL2M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dataWithAL3M),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_alpduInterleaving),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumAL1MPDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumAL2MSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumAL3MSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H223AnnexCCapability_IsIncludeOptionField( pObj, e_ASNH245H223AnnexCCapabilityOptionMap_rsCodeCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_rsCodeCapability), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223AnnexCCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223AnnexCCapability Print */
HS_RESULT ASNH245H223AnnexCCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223AnnexCCapability *pObj = (ASNH245H223AnnexCCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223AnnexCCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_videoWithAL1M), pDepth+1, "videoWithAL1M" );
	AsnBoolean_Print( &(pObj->m_videoWithAL2M), pDepth+1, "videoWithAL2M" );
	AsnBoolean_Print( &(pObj->m_videoWithAL3M), pDepth+1, "videoWithAL3M" );
	AsnBoolean_Print( &(pObj->m_audioWithAL1M), pDepth+1, "audioWithAL1M" );
	AsnBoolean_Print( &(pObj->m_audioWithAL2M), pDepth+1, "audioWithAL2M" );
	AsnBoolean_Print( &(pObj->m_audioWithAL3M), pDepth+1, "audioWithAL3M" );
	AsnBoolean_Print( &(pObj->m_dataWithAL1M), pDepth+1, "dataWithAL1M" );
	AsnBoolean_Print( &(pObj->m_dataWithAL2M), pDepth+1, "dataWithAL2M" );
	AsnBoolean_Print( &(pObj->m_dataWithAL3M), pDepth+1, "dataWithAL3M" );
	AsnBoolean_Print( &(pObj->m_alpduInterleaving), pDepth+1, "alpduInterleaving" );
	AsnInteger_Print( &(pObj->m_maximumAL1MPDUSize), pDepth+1, "maximumAL1MPDUSize" );
	AsnInteger_Print( &(pObj->m_maximumAL2MSDUSize), pDepth+1, "maximumAL2MSDUSize" );
	AsnInteger_Print( &(pObj->m_maximumAL3MSDUSize), pDepth+1, "maximumAL3MSDUSize" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H223AnnexCCapability_IsIncludeOptionField( pObj, e_ASNH245H223AnnexCCapabilityOptionMap_rsCodeCapability ) )
		AsnBoolean_Print( &(pObj->m_rsCodeCapability), pDepth+1, "rsCodeCapability" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223Capability_mobileMultilinkFrameCapability Class
*/
/*ASNH245H223Capability_mobileMultilinkFrameCapability Constructor*/
HS_RESULT new_ASNH245H223Capability_mobileMultilinkFrameCapability(void *pObject)
{
	ASNH245H223Capability_mobileMultilinkFrameCapability *pObj = (ASNH245H223Capability_mobileMultilinkFrameCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223Capability_mobileMultilinkFrameCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_maximumSampleSize), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maximumPayloadLength), e_constrained, 1, 65025, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245H223Capability_mobileMultilinkFrameCapability Destructor */
HS_RESULT delete_ASNH245H223Capability_mobileMultilinkFrameCapability(void *pObject)
{
	ASNH245H223Capability_mobileMultilinkFrameCapability *pObj = (ASNH245H223Capability_mobileMultilinkFrameCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223Capability_mobileMultilinkFrameCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_maximumSampleSize) );
	delete_AsnInteger( &(pObj->m_maximumPayloadLength) );
	return HS_OK;
}

/* ASNH245H223Capability_mobileMultilinkFrameCapability MakeMold */
HS_RESULT ASNH245H223Capability_mobileMultilinkFrameCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H223Capability_mobileMultilinkFrameCapability *pObj = (ASNH245H223Capability_mobileMultilinkFrameCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileMultilinkFrameCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H223Capability_mobileMultilinkFrameCapability Encode */
HS_RESULT ASNH245H223Capability_mobileMultilinkFrameCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223Capability_mobileMultilinkFrameCapability *pObj = (ASNH245H223Capability_mobileMultilinkFrameCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileMultilinkFrameCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumSampleSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileMultilinkFrameCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumPayloadLength),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileMultilinkFrameCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H223Capability_mobileMultilinkFrameCapability Decode */
HS_RESULT ASNH245H223Capability_mobileMultilinkFrameCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223Capability_mobileMultilinkFrameCapability *pObj = (ASNH245H223Capability_mobileMultilinkFrameCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileMultilinkFrameCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumSampleSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileMultilinkFrameCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumPayloadLength),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_mobileMultilinkFrameCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223Capability_mobileMultilinkFrameCapability Print */
HS_RESULT ASNH245H223Capability_mobileMultilinkFrameCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223Capability_mobileMultilinkFrameCapability *pObj = (ASNH245H223Capability_mobileMultilinkFrameCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223Capability_mobileMultilinkFrameCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_maximumSampleSize), pDepth+1, "maximumSampleSize" );
	AsnInteger_Print( &(pObj->m_maximumPayloadLength), pDepth+1, "maximumPayloadLength" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223Capability Class
*/
/*ASNH245H223Capability Constructor*/
HS_RESULT new_ASNH245H223Capability(void *pObject)
{
	ASNH245H223Capability *pObj = (ASNH245H223Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_transportWithI_frames) );
	new_AsnBoolean( &(pObj->m_videoWithAL1) );
	new_AsnBoolean( &(pObj->m_videoWithAL2) );
	new_AsnBoolean( &(pObj->m_videoWithAL3) );
	new_AsnBoolean( &(pObj->m_audioWithAL1) );
	new_AsnBoolean( &(pObj->m_audioWithAL2) );
	new_AsnBoolean( &(pObj->m_audioWithAL3) );
	new_AsnBoolean( &(pObj->m_dataWithAL1) );
	new_AsnBoolean( &(pObj->m_dataWithAL2) );
	new_AsnBoolean( &(pObj->m_dataWithAL3) );
	new_AsnInteger( &(pObj->m_maximumAl2SDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maximumAl3SDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maximumDelayJitter), e_constrained, 0, 1023, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245H223Capability_h223MultiplexTableCapability( &(pObj->m_h223MultiplexTableCapability) );
	new_AsnBoolean( &(pObj->m_maxMUXPDUSizeCapability) );
	new_AsnBoolean( &(pObj->m_nsrpSupport) );
	new_ASNH245H223Capability_mobileOperationTransmitCapability( &(pObj->m_mobileOperationTransmitCapability) );
	new_ASNH245H223AnnexCCapability( &(pObj->m_h223AnnexCCapability) );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 19200, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245H223Capability_mobileMultilinkFrameCapability( &(pObj->m_mobileMultilinkFrameCapability) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H223Capability Destructor */
HS_RESULT delete_ASNH245H223Capability(void *pObject)
{
	ASNH245H223Capability *pObj = (ASNH245H223Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_transportWithI_frames) );
	delete_AsnBoolean( &(pObj->m_videoWithAL1) );
	delete_AsnBoolean( &(pObj->m_videoWithAL2) );
	delete_AsnBoolean( &(pObj->m_videoWithAL3) );
	delete_AsnBoolean( &(pObj->m_audioWithAL1) );
	delete_AsnBoolean( &(pObj->m_audioWithAL2) );
	delete_AsnBoolean( &(pObj->m_audioWithAL3) );
	delete_AsnBoolean( &(pObj->m_dataWithAL1) );
	delete_AsnBoolean( &(pObj->m_dataWithAL2) );
	delete_AsnBoolean( &(pObj->m_dataWithAL3) );
	delete_AsnInteger( &(pObj->m_maximumAl2SDUSize) );
	delete_AsnInteger( &(pObj->m_maximumAl3SDUSize) );
	delete_AsnInteger( &(pObj->m_maximumDelayJitter) );
	delete_ASNH245H223Capability_h223MultiplexTableCapability( &(pObj->m_h223MultiplexTableCapability) );
	delete_AsnBoolean( &(pObj->m_maxMUXPDUSizeCapability) );
	delete_AsnBoolean( &(pObj->m_nsrpSupport) );
	delete_ASNH245H223Capability_mobileOperationTransmitCapability( &(pObj->m_mobileOperationTransmitCapability) );
	delete_ASNH245H223AnnexCCapability( &(pObj->m_h223AnnexCCapability) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	delete_ASNH245H223Capability_mobileMultilinkFrameCapability( &(pObj->m_mobileMultilinkFrameCapability) );
	return HS_OK;
}

/* ASNH245H223Capability MakeMold */
HS_RESULT ASNH245H223Capability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H223Capability *pObj = (ASNH245H223Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245H223Capability_mobileOperationTransmitCapability_MakeMold(&(pObj->m_mobileOperationTransmitCapability));
	ASNH245H223AnnexCCapability_MakeMold(&(pObj->m_h223AnnexCCapability));
	ASNH245H223Capability_mobileMultilinkFrameCapability_MakeMold(&(pObj->m_mobileMultilinkFrameCapability));
	return HS_OK;
}

/* ASNH245H223Capability IncludeOptionalField */
HS_RESULT ASNH245H223Capability_IncludeOptionField( void *pObject, ASNH245H223CapabilityOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H223Capability *pObj = (ASNH245H223Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H223CapabilityOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H223CapabilityOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245H223Capability IsIncludeOptionalField */
BOOL ASNH245H223Capability_IsIncludeOptionField( void *pObject, ASNH245H223CapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H223Capability *pObj = (ASNH245H223Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H223CapabilityOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H223CapabilityOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H223Capability Encode */
HS_RESULT ASNH245H223Capability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223Capability *pObj = (ASNH245H223Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_transportWithI_frames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_videoWithAL1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_videoWithAL2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_videoWithAL3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioWithAL1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioWithAL2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioWithAL3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dataWithAL1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dataWithAL2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dataWithAL3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumAl2SDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumAl3SDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumDelayJitter),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245H223Capability_h223MultiplexTableCapability_Encode( &(pObj->m_h223MultiplexTableCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_maxMUXPDUSizeCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_maxMUXPDUSizeCapability), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_nsrpSupport ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_nsrpSupport), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_mobileOperationTransmitCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_mobileOperationTransmitCapability), ASNH245H223Capability_mobileOperationTransmitCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_h223AnnexCCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h223AnnexCCapability), ASNH245H223AnnexCCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_bitRate ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_bitRate), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_mobileMultilinkFrameCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_mobileMultilinkFrameCapability), ASNH245H223Capability_mobileMultilinkFrameCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H223Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H223Capability Decode */
HS_RESULT ASNH245H223Capability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223Capability *pObj = (ASNH245H223Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_transportWithI_frames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_videoWithAL1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_videoWithAL2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_videoWithAL3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioWithAL1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioWithAL2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioWithAL3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dataWithAL1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dataWithAL2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dataWithAL3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumAl2SDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumAl3SDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumDelayJitter),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245H223Capability_h223MultiplexTableCapability_Decode(&(pObj->m_h223MultiplexTableCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_maxMUXPDUSizeCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_maxMUXPDUSizeCapability), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_nsrpSupport ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_nsrpSupport), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_mobileOperationTransmitCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_mobileOperationTransmitCapability), ASNH245H223Capability_mobileOperationTransmitCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_h223AnnexCCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_h223AnnexCCapability), ASNH245H223AnnexCCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_bitRate ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_bitRate), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_mobileMultilinkFrameCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_mobileMultilinkFrameCapability), ASNH245H223Capability_mobileMultilinkFrameCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223Capability Print */
HS_RESULT ASNH245H223Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223Capability *pObj = (ASNH245H223Capability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223Capability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_transportWithI_frames), pDepth+1, "transportWithI_frames" );
	AsnBoolean_Print( &(pObj->m_videoWithAL1), pDepth+1, "videoWithAL1" );
	AsnBoolean_Print( &(pObj->m_videoWithAL2), pDepth+1, "videoWithAL2" );
	AsnBoolean_Print( &(pObj->m_videoWithAL3), pDepth+1, "videoWithAL3" );
	AsnBoolean_Print( &(pObj->m_audioWithAL1), pDepth+1, "audioWithAL1" );
	AsnBoolean_Print( &(pObj->m_audioWithAL2), pDepth+1, "audioWithAL2" );
	AsnBoolean_Print( &(pObj->m_audioWithAL3), pDepth+1, "audioWithAL3" );
	AsnBoolean_Print( &(pObj->m_dataWithAL1), pDepth+1, "dataWithAL1" );
	AsnBoolean_Print( &(pObj->m_dataWithAL2), pDepth+1, "dataWithAL2" );
	AsnBoolean_Print( &(pObj->m_dataWithAL3), pDepth+1, "dataWithAL3" );
	AsnInteger_Print( &(pObj->m_maximumAl2SDUSize), pDepth+1, "maximumAl2SDUSize" );
	AsnInteger_Print( &(pObj->m_maximumAl3SDUSize), pDepth+1, "maximumAl3SDUSize" );
	AsnInteger_Print( &(pObj->m_maximumDelayJitter), pDepth+1, "maximumDelayJitter" );
	ASNH245H223Capability_h223MultiplexTableCapability_Print( &(pObj->m_h223MultiplexTableCapability), pDepth+1, "h223MultiplexTableCapability" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_maxMUXPDUSizeCapability ) )
		AsnBoolean_Print( &(pObj->m_maxMUXPDUSizeCapability), pDepth+1, "maxMUXPDUSizeCapability" );
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_nsrpSupport ) )
		AsnBoolean_Print( &(pObj->m_nsrpSupport), pDepth+1, "nsrpSupport" );
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_mobileOperationTransmitCapability ) )
		ASNH245H223Capability_mobileOperationTransmitCapability_Print( &(pObj->m_mobileOperationTransmitCapability), pDepth+1, "mobileOperationTransmitCapability" );
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_h223AnnexCCapability ) )
		ASNH245H223AnnexCCapability_Print( &(pObj->m_h223AnnexCCapability), pDepth+1, "h223AnnexCCapability" );
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_bitRate ) )
		AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	if( ASNH245H223Capability_IsIncludeOptionField( pObj, e_ASNH245H223CapabilityOptionMap_mobileMultilinkFrameCapability ) )
		ASNH245H223Capability_mobileMultilinkFrameCapability_Print( &(pObj->m_mobileMultilinkFrameCapability), pDepth+1, "mobileMultilinkFrameCapability" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245V75Capability Class
*/
/*ASNH245V75Capability Constructor*/
HS_RESULT new_ASNH245V75Capability(void *pObject)
{
	ASNH245V75Capability *pObj = (ASNH245V75Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V75Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_audioHeader) );

	return HS_OK;
}

/* ASNH245V75Capability Destructor */
HS_RESULT delete_ASNH245V75Capability(void *pObject)
{
	ASNH245V75Capability *pObj = (ASNH245V75Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V75Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_audioHeader) );
	return HS_OK;
}

/* ASNH245V75Capability MakeMold */
HS_RESULT ASNH245V75Capability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245V75Capability *pObj = (ASNH245V75Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Capability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245V75Capability Encode */
HS_RESULT ASNH245V75Capability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V75Capability *pObj = (ASNH245V75Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Capability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioHeader),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245V75Capability Decode */
HS_RESULT ASNH245V75Capability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V75Capability *pObj = (ASNH245V75Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Capability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioHeader),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V75Capability Print */
HS_RESULT ASNH245V75Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V75Capability *pObj = (ASNH245V75Capability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V75Capability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_audioHeader), pDepth+1, "audioHeader" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245V76Capability Class
*/
/*ASNH245V76Capability Constructor*/
HS_RESULT new_ASNH245V76Capability(void *pObject)
{
	ASNH245V76Capability *pObj = (ASNH245V76Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V76Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_suspendResumeCapabilitywAddress) );
	new_AsnBoolean( &(pObj->m_suspendResumeCapabilitywoAddress) );
	new_AsnBoolean( &(pObj->m_rejCapability) );
	new_AsnBoolean( &(pObj->m_sREJCapability) );
	new_AsnBoolean( &(pObj->m_mREJCapability) );
	new_AsnBoolean( &(pObj->m_crc8bitCapability) );
	new_AsnBoolean( &(pObj->m_crc16bitCapability) );
	new_AsnBoolean( &(pObj->m_crc32bitCapability) );
	new_AsnBoolean( &(pObj->m_uihCapability) );
	new_AsnInteger( &(pObj->m_numOfDLCS), e_constrained, 2, 8191, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_twoOctetAddressFieldCapability) );
	new_AsnBoolean( &(pObj->m_loopBackTestCapability) );
	new_AsnInteger( &(pObj->m_n401Capability), e_constrained, 1, 4095, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maxWindowSizeCapability), e_constrained, 1, 127, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245V75Capability( &(pObj->m_v75Capability) );

	return HS_OK;
}

/* ASNH245V76Capability Destructor */
HS_RESULT delete_ASNH245V76Capability(void *pObject)
{
	ASNH245V76Capability *pObj = (ASNH245V76Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_suspendResumeCapabilitywAddress) );
	delete_AsnBoolean( &(pObj->m_suspendResumeCapabilitywoAddress) );
	delete_AsnBoolean( &(pObj->m_rejCapability) );
	delete_AsnBoolean( &(pObj->m_sREJCapability) );
	delete_AsnBoolean( &(pObj->m_mREJCapability) );
	delete_AsnBoolean( &(pObj->m_crc8bitCapability) );
	delete_AsnBoolean( &(pObj->m_crc16bitCapability) );
	delete_AsnBoolean( &(pObj->m_crc32bitCapability) );
	delete_AsnBoolean( &(pObj->m_uihCapability) );
	delete_AsnInteger( &(pObj->m_numOfDLCS) );
	delete_AsnBoolean( &(pObj->m_twoOctetAddressFieldCapability) );
	delete_AsnBoolean( &(pObj->m_loopBackTestCapability) );
	delete_AsnInteger( &(pObj->m_n401Capability) );
	delete_AsnInteger( &(pObj->m_maxWindowSizeCapability) );
	delete_ASNH245V75Capability( &(pObj->m_v75Capability) );
	return HS_OK;
}

/* ASNH245V76Capability MakeMold */
HS_RESULT ASNH245V76Capability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245V76Capability *pObj = (ASNH245V76Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245V75Capability_MakeMold(&(pObj->m_v75Capability));
	return HS_OK;
}

/* ASNH245V76Capability Encode */
HS_RESULT ASNH245V76Capability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V76Capability *pObj = (ASNH245V76Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_suspendResumeCapabilitywAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_suspendResumeCapabilitywoAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_rejCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_sREJCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_mREJCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_crc8bitCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_crc16bitCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_crc32bitCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_uihCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_numOfDLCS),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_twoOctetAddressFieldCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_loopBackTestCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_n401Capability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maxWindowSizeCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V75Capability_Encode( &(pObj->m_v75Capability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245V76Capability Decode */
HS_RESULT ASNH245V76Capability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V76Capability *pObj = (ASNH245V76Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_suspendResumeCapabilitywAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_suspendResumeCapabilitywoAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_rejCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_sREJCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_mREJCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_crc8bitCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_crc16bitCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_crc32bitCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_uihCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_numOfDLCS),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_twoOctetAddressFieldCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_loopBackTestCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_n401Capability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxWindowSizeCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V75Capability_Decode(&(pObj->m_v75Capability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V76Capability Print */
HS_RESULT ASNH245V76Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V76Capability *pObj = (ASNH245V76Capability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V76Capability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_suspendResumeCapabilitywAddress), pDepth+1, "suspendResumeCapabilitywAddress" );
	AsnBoolean_Print( &(pObj->m_suspendResumeCapabilitywoAddress), pDepth+1, "suspendResumeCapabilitywoAddress" );
	AsnBoolean_Print( &(pObj->m_rejCapability), pDepth+1, "rejCapability" );
	AsnBoolean_Print( &(pObj->m_sREJCapability), pDepth+1, "sREJCapability" );
	AsnBoolean_Print( &(pObj->m_mREJCapability), pDepth+1, "mREJCapability" );
	AsnBoolean_Print( &(pObj->m_crc8bitCapability), pDepth+1, "crc8bitCapability" );
	AsnBoolean_Print( &(pObj->m_crc16bitCapability), pDepth+1, "crc16bitCapability" );
	AsnBoolean_Print( &(pObj->m_crc32bitCapability), pDepth+1, "crc32bitCapability" );
	AsnBoolean_Print( &(pObj->m_uihCapability), pDepth+1, "uihCapability" );
	AsnInteger_Print( &(pObj->m_numOfDLCS), pDepth+1, "numOfDLCS" );
	AsnBoolean_Print( &(pObj->m_twoOctetAddressFieldCapability), pDepth+1, "twoOctetAddressFieldCapability" );
	AsnBoolean_Print( &(pObj->m_loopBackTestCapability), pDepth+1, "loopBackTestCapability" );
	AsnInteger_Print( &(pObj->m_n401Capability), pDepth+1, "n401Capability" );
	AsnInteger_Print( &(pObj->m_maxWindowSizeCapability), pDepth+1, "maxWindowSizeCapability" );
	ASNH245V75Capability_Print( &(pObj->m_v75Capability), pDepth+1, "v75Capability" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245V42bis Class
*/
/*ASNH245V42bis Constructor*/
HS_RESULT new_ASNH245V42bis(void *pObject)
{
	ASNH245V42bis *pObj = (ASNH245V42bis *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V42bis(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_numberOfCodewords), e_constrained, 1, 65536, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maximumStringLength), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245V42bis Destructor */
HS_RESULT delete_ASNH245V42bis(void *pObject)
{
	ASNH245V42bis *pObj = (ASNH245V42bis *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V42bis(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_numberOfCodewords) );
	delete_AsnInteger( &(pObj->m_maximumStringLength) );
	return HS_OK;
}

/* ASNH245V42bis MakeMold */
HS_RESULT ASNH245V42bis_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245V42bis *pObj = (ASNH245V42bis *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V42bis_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245V42bis Encode */
HS_RESULT ASNH245V42bis_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V42bis *pObj = (ASNH245V42bis *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V42bis_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_numberOfCodewords),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V42bis_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumStringLength),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V42bis_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245V42bis Decode */
HS_RESULT ASNH245V42bis_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V42bis *pObj = (ASNH245V42bis *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V42bis_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_numberOfCodewords),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V42bis_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumStringLength),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V42bis_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V42bis Print */
HS_RESULT ASNH245V42bis_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V42bis *pObj = (ASNH245V42bis *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V42bis_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_numberOfCodewords), pDepth+1, "numberOfCodewords" );
	AsnInteger_Print( &(pObj->m_maximumStringLength), pDepth+1, "maximumStringLength" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CompressionType Struct
*/
/* ASNH245CompressionType Constructor */
HS_RESULT new_ASNH245CompressionType( void *pObject )
{
	ASNH245CompressionType *pObj = (ASNH245CompressionType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CompressionType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245CompressionTypeChoice_v42bis;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245CompressionTypeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245CompressionType Destructor */
HS_RESULT delete_ASNH245CompressionType( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245CompressionType *pObj = (ASNH245CompressionType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CompressionType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245CompressionType_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CompressionType(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245CompressionType SetChoice */
void* ASNH245CompressionType_SetChoice( void *pObject, ASNH245CompressionTypeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245CompressionType *pObj = (ASNH245CompressionType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CompressionType_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245CompressionTypeChoiceSizeExt ){
		if( pChoice > (ASNH245CompressionTypeChoice)(e_ASNH245CompressionTypeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CompressionType_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245CompressionType_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CompressionType_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245CompressionTypeChoice_v42bis ){
		ASNH245V42bis *tAlter = (ASNH245V42bis *)HSMalloc( sizeof(ASNH245V42bis) );
		new_ASNH245V42bis(tAlter);
		ASNH245V42bis_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CompressionType_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245CompressionType DeleteAlternation */
HS_RESULT ASNH245CompressionType_DeleteAlternation(void *pObject)
{
	ASNH245CompressionType *pObj = (ASNH245CompressionType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CompressionType_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245CompressionTypeChoice_v42bis ){
			delete_ASNH245V42bis(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CompressionType_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245CompressionType_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245CompressionType Encode */
HS_RESULT ASNH245CompressionType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245CompressionType *pObj = (ASNH245CompressionType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CompressionType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CompressionType_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245CompressionTypeChoiceSize )
		{
			if( pObj->choice > ((ASNH245CompressionTypeChoice)(e_ASNH245CompressionTypeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245CompressionTypeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245CompressionTypeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CompressionTypeChoice_v42bis ){
		if( (tRet=ASNH245V42bis_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CompressionType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CompressionType_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245CompressionType Decode */
HS_RESULT ASNH245CompressionType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245CompressionType *pObj = (ASNH245CompressionType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CompressionType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245CompressionTypeChoiceSize;
	}
	else
	{
		if( e_ASNH245CompressionTypeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245CompressionTypeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245CompressionTypeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CompressionType_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245CompressionType_SetChoice( pObj, (ASNH245CompressionTypeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CompressionType_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CompressionTypeChoice_v42bis ){
		if( (tRet=ASNH245V42bis_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CompressionType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CompressionType_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CompressionType Print */
HS_RESULT ASNH245CompressionType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CompressionType *pObj = (ASNH245CompressionType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CompressionType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CompressionTypeChoice_v42bis ){
		ASNH245V42bis_Print( pObj->alter, pDepth+1, "v42bis" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataProtocolCapability_v76wCompression Struct
*/
/* ASNH245DataProtocolCapability_v76wCompression Constructor */
HS_RESULT new_ASNH245DataProtocolCapability_v76wCompression( void *pObject )
{
	ASNH245DataProtocolCapability_v76wCompression *pObj = (ASNH245DataProtocolCapability_v76wCompression *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataProtocolCapability_v76wCompression(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitCompression;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245DataProtocolCapability_v76wCompressionChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245DataProtocolCapability_v76wCompression Destructor */
HS_RESULT delete_ASNH245DataProtocolCapability_v76wCompression( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245DataProtocolCapability_v76wCompression *pObj = (ASNH245DataProtocolCapability_v76wCompression *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataProtocolCapability_v76wCompression(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245DataProtocolCapability_v76wCompression_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataProtocolCapability_v76wCompression(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245DataProtocolCapability_v76wCompression SetChoice */
void* ASNH245DataProtocolCapability_v76wCompression_SetChoice( void *pObject, ASNH245DataProtocolCapability_v76wCompressionChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245DataProtocolCapability_v76wCompression *pObj = (ASNH245DataProtocolCapability_v76wCompression *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245DataProtocolCapability_v76wCompressionChoiceSizeExt ){
		if( pChoice > (ASNH245DataProtocolCapability_v76wCompressionChoice)(e_ASNH245DataProtocolCapability_v76wCompressionChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245DataProtocolCapability_v76wCompression_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitCompression ){
		ASNH245CompressionType *tAlter = (ASNH245CompressionType *)HSMalloc( sizeof(ASNH245CompressionType) );
		new_ASNH245CompressionType(tAlter);
		ASNH245CompressionType_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_receiveCompression ){
		ASNH245CompressionType *tAlter = (ASNH245CompressionType *)HSMalloc( sizeof(ASNH245CompressionType) );
		new_ASNH245CompressionType(tAlter);
		ASNH245CompressionType_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitAndReceiveCompression ){
		ASNH245CompressionType *tAlter = (ASNH245CompressionType *)HSMalloc( sizeof(ASNH245CompressionType) );
		new_ASNH245CompressionType(tAlter);
		ASNH245CompressionType_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245DataProtocolCapability_v76wCompression DeleteAlternation */
HS_RESULT ASNH245DataProtocolCapability_v76wCompression_DeleteAlternation(void *pObject)
{
	ASNH245DataProtocolCapability_v76wCompression *pObj = (ASNH245DataProtocolCapability_v76wCompression *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitCompression ){
			delete_ASNH245CompressionType(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_receiveCompression ){
			delete_ASNH245CompressionType(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitAndReceiveCompression ){
			delete_ASNH245CompressionType(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245DataProtocolCapability_v76wCompression_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245DataProtocolCapability_v76wCompression Encode */
HS_RESULT ASNH245DataProtocolCapability_v76wCompression_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245DataProtocolCapability_v76wCompression *pObj = (ASNH245DataProtocolCapability_v76wCompression *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245DataProtocolCapability_v76wCompressionChoiceSize )
		{
			if( pObj->choice > ((ASNH245DataProtocolCapability_v76wCompressionChoice)(e_ASNH245DataProtocolCapability_v76wCompressionChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245DataProtocolCapability_v76wCompressionChoiceSize)) )
	}
	else
	{
		if( e_ASNH245DataProtocolCapability_v76wCompressionChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitCompression ){
		if( (tRet=ASNH245CompressionType_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_receiveCompression ){
		if( (tRet=ASNH245CompressionType_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitAndReceiveCompression ){
		if( (tRet=ASNH245CompressionType_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245DataProtocolCapability_v76wCompression Decode */
HS_RESULT ASNH245DataProtocolCapability_v76wCompression_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245DataProtocolCapability_v76wCompression *pObj = (ASNH245DataProtocolCapability_v76wCompression *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245DataProtocolCapability_v76wCompressionChoiceSize;
	}
	else
	{
		if( e_ASNH245DataProtocolCapability_v76wCompressionChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245DataProtocolCapability_v76wCompressionChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245DataProtocolCapability_v76wCompressionChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245DataProtocolCapability_v76wCompression_SetChoice( pObj, (ASNH245DataProtocolCapability_v76wCompressionChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitCompression ){
		if( (tRet=ASNH245CompressionType_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_receiveCompression ){
		if( (tRet=ASNH245CompressionType_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitAndReceiveCompression ){
		if( (tRet=ASNH245CompressionType_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataProtocolCapability_v76wCompression Print */
HS_RESULT ASNH245DataProtocolCapability_v76wCompression_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataProtocolCapability_v76wCompression *pObj = (ASNH245DataProtocolCapability_v76wCompression *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataProtocolCapability_v76wCompression_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitCompression ){
		ASNH245CompressionType_Print( pObj->alter, pDepth+1, "transmitCompression" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_receiveCompression ){
		ASNH245CompressionType_Print( pObj->alter, pDepth+1, "receiveCompression" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapability_v76wCompressionChoice_transmitAndReceiveCompression ){
		ASNH245CompressionType_Print( pObj->alter, pDepth+1, "transmitAndReceiveCompression" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataProtocolCapability Struct
*/
/* ASNH245DataProtocolCapability Constructor */
HS_RESULT new_ASNH245DataProtocolCapability( void *pObject )
{
	ASNH245DataProtocolCapability *pObj = (ASNH245DataProtocolCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataProtocolCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245DataProtocolCapabilityChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245DataProtocolCapabilityChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245DataProtocolCapability Destructor */
HS_RESULT delete_ASNH245DataProtocolCapability( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245DataProtocolCapability *pObj = (ASNH245DataProtocolCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataProtocolCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245DataProtocolCapability_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataProtocolCapability(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245DataProtocolCapability SetChoice */
void* ASNH245DataProtocolCapability_SetChoice( void *pObject, ASNH245DataProtocolCapabilityChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245DataProtocolCapability *pObj = (ASNH245DataProtocolCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245DataProtocolCapabilityChoiceSizeExt ){
		if( pChoice > (ASNH245DataProtocolCapabilityChoice)(e_ASNH245DataProtocolCapabilityChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245DataProtocolCapability_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245DataProtocolCapabilityChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_v14buffered ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_v42lapm ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelling ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_h310SeparateVCStack ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_h310SingleVCStack ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_transparent ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_segmentationAndReassembly ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelingwSAR ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_v120 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_separateLANStack ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_v76wCompression ){
		ASNH245DataProtocolCapability_v76wCompression *tAlter = (ASNH245DataProtocolCapability_v76wCompression *)HSMalloc( sizeof(ASNH245DataProtocolCapability_v76wCompression) );
		new_ASNH245DataProtocolCapability_v76wCompression(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_tcp ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataProtocolCapabilityChoice_udp ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245DataProtocolCapability DeleteAlternation */
HS_RESULT ASNH245DataProtocolCapability_DeleteAlternation(void *pObject)
{
	ASNH245DataProtocolCapability *pObj = (ASNH245DataProtocolCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v14buffered ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v42lapm ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelling ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_h310SeparateVCStack ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_h310SingleVCStack ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_transparent ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_segmentationAndReassembly ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelingwSAR ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v120 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_separateLANStack ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v76wCompression ){
			delete_ASNH245DataProtocolCapability_v76wCompression(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_tcp ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_udp ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245DataProtocolCapability_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245DataProtocolCapability Encode */
HS_RESULT ASNH245DataProtocolCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245DataProtocolCapability *pObj = (ASNH245DataProtocolCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245DataProtocolCapabilityChoiceSize )
		{
			if( pObj->choice > ((ASNH245DataProtocolCapabilityChoice)(e_ASNH245DataProtocolCapabilityChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245DataProtocolCapabilityChoiceSize)) )
	}
	else
	{
		if( e_ASNH245DataProtocolCapabilityChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v14buffered ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v42lapm ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelling ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_h310SeparateVCStack ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_h310SingleVCStack ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_transparent ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_segmentationAndReassembly ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelingwSAR ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v120 ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_separateLANStack ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v76wCompression ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245DataProtocolCapability_v76wCompression_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_tcp ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_udp ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245DataProtocolCapability Decode */
HS_RESULT ASNH245DataProtocolCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245DataProtocolCapability *pObj = (ASNH245DataProtocolCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245DataProtocolCapabilityChoiceSize;
	}
	else
	{
		if( e_ASNH245DataProtocolCapabilityChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245DataProtocolCapabilityChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245DataProtocolCapabilityChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245DataProtocolCapability_SetChoice( pObj, (ASNH245DataProtocolCapabilityChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v14buffered ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v42lapm ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelling ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_h310SeparateVCStack ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_h310SingleVCStack ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_transparent ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_segmentationAndReassembly ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelingwSAR ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v120 ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_separateLANStack ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v76wCompression ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245DataProtocolCapability_v76wCompression_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_tcp ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_udp ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataProtocolCapability_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataProtocolCapability Print */
HS_RESULT ASNH245DataProtocolCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataProtocolCapability *pObj = (ASNH245DataProtocolCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataProtocolCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v14buffered ){
		AsnNull_Print( pObj->alter, pDepth+1, "v14buffered" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v42lapm ){
		AsnNull_Print( pObj->alter, pDepth+1, "v42lapm" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelling ){
		AsnNull_Print( pObj->alter, pDepth+1, "hdlcFrameTunnelling" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_h310SeparateVCStack ){
		AsnNull_Print( pObj->alter, pDepth+1, "h310SeparateVCStack" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_h310SingleVCStack ){
		AsnNull_Print( pObj->alter, pDepth+1, "h310SingleVCStack" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_transparent ){
		AsnNull_Print( pObj->alter, pDepth+1, "transparent" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_segmentationAndReassembly ){
		AsnNull_Print( pObj->alter, pDepth+1, "segmentationAndReassembly" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_hdlcFrameTunnelingwSAR ){
		AsnNull_Print( pObj->alter, pDepth+1, "hdlcFrameTunnelingwSAR" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v120 ){
		AsnNull_Print( pObj->alter, pDepth+1, "v120" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_separateLANStack ){
		AsnNull_Print( pObj->alter, pDepth+1, "separateLANStack" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_v76wCompression ){
		ASNH245DataProtocolCapability_v76wCompression_Print( pObj->alter, pDepth+1, "v76wCompression" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_tcp ){
		AsnNull_Print( pObj->alter, pDepth+1, "tcp" );
	}
	else if ( pObj->choice == e_ASNH245DataProtocolCapabilityChoice_udp ){
		AsnNull_Print( pObj->alter, pDepth+1, "udp" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245T84Profile_t84Restricted Class
*/
/*ASNH245T84Profile_t84Restricted Constructor*/
HS_RESULT new_ASNH245T84Profile_t84Restricted(void *pObject)
{
	ASNH245T84Profile_t84Restricted *pObj = (ASNH245T84Profile_t84Restricted *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245T84Profile_t84Restricted(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_qcif) );
	new_AsnBoolean( &(pObj->m_cif) );
	new_AsnBoolean( &(pObj->m_ccir601Seq) );
	new_AsnBoolean( &(pObj->m_ccir601Prog) );
	new_AsnBoolean( &(pObj->m_hdtvSeq) );
	new_AsnBoolean( &(pObj->m_hdtvProg) );
	new_AsnBoolean( &(pObj->m_g3FacsMH200x100) );
	new_AsnBoolean( &(pObj->m_g3FacsMH200x200) );
	new_AsnBoolean( &(pObj->m_g4FacsMMR200x100) );
	new_AsnBoolean( &(pObj->m_g4FacsMMR200x200) );
	new_AsnBoolean( &(pObj->m_jbig200x200Seq) );
	new_AsnBoolean( &(pObj->m_jbig200x200Prog) );
	new_AsnBoolean( &(pObj->m_jbig300x300Seq) );
	new_AsnBoolean( &(pObj->m_jbig300x300Prog) );
	new_AsnBoolean( &(pObj->m_digPhotoLow) );
	new_AsnBoolean( &(pObj->m_digPhotoMedSeq) );
	new_AsnBoolean( &(pObj->m_digPhotoMedProg) );
	new_AsnBoolean( &(pObj->m_digPhotoHighSeq) );
	new_AsnBoolean( &(pObj->m_digPhotoHighProg) );

	return HS_OK;
}

/* ASNH245T84Profile_t84Restricted Destructor */
HS_RESULT delete_ASNH245T84Profile_t84Restricted(void *pObject)
{
	ASNH245T84Profile_t84Restricted *pObj = (ASNH245T84Profile_t84Restricted *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T84Profile_t84Restricted(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_qcif) );
	delete_AsnBoolean( &(pObj->m_cif) );
	delete_AsnBoolean( &(pObj->m_ccir601Seq) );
	delete_AsnBoolean( &(pObj->m_ccir601Prog) );
	delete_AsnBoolean( &(pObj->m_hdtvSeq) );
	delete_AsnBoolean( &(pObj->m_hdtvProg) );
	delete_AsnBoolean( &(pObj->m_g3FacsMH200x100) );
	delete_AsnBoolean( &(pObj->m_g3FacsMH200x200) );
	delete_AsnBoolean( &(pObj->m_g4FacsMMR200x100) );
	delete_AsnBoolean( &(pObj->m_g4FacsMMR200x200) );
	delete_AsnBoolean( &(pObj->m_jbig200x200Seq) );
	delete_AsnBoolean( &(pObj->m_jbig200x200Prog) );
	delete_AsnBoolean( &(pObj->m_jbig300x300Seq) );
	delete_AsnBoolean( &(pObj->m_jbig300x300Prog) );
	delete_AsnBoolean( &(pObj->m_digPhotoLow) );
	delete_AsnBoolean( &(pObj->m_digPhotoMedSeq) );
	delete_AsnBoolean( &(pObj->m_digPhotoMedProg) );
	delete_AsnBoolean( &(pObj->m_digPhotoHighSeq) );
	delete_AsnBoolean( &(pObj->m_digPhotoHighProg) );
	return HS_OK;
}

/* ASNH245T84Profile_t84Restricted MakeMold */
HS_RESULT ASNH245T84Profile_t84Restricted_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245T84Profile_t84Restricted *pObj = (ASNH245T84Profile_t84Restricted *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245T84Profile_t84Restricted Encode */
HS_RESULT ASNH245T84Profile_t84Restricted_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245T84Profile_t84Restricted *pObj = (ASNH245T84Profile_t84Restricted *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_qcif),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_cif),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_ccir601Seq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_ccir601Prog),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_hdtvSeq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_hdtvProg),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_g3FacsMH200x100),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_g3FacsMH200x200),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_g4FacsMMR200x100),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_g4FacsMMR200x200),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_jbig200x200Seq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_jbig200x200Prog),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_jbig300x300Seq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_jbig300x300Prog),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_digPhotoLow),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_digPhotoMedSeq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_digPhotoMedProg),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_digPhotoHighSeq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_digPhotoHighProg),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245T84Profile_t84Restricted Decode */
HS_RESULT ASNH245T84Profile_t84Restricted_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245T84Profile_t84Restricted *pObj = (ASNH245T84Profile_t84Restricted *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_qcif),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_cif),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_ccir601Seq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_ccir601Prog),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_hdtvSeq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_hdtvProg),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_g3FacsMH200x100),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_g3FacsMH200x200),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_g4FacsMMR200x100),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_g4FacsMMR200x200),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_jbig200x200Seq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_jbig200x200Prog),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_jbig300x300Seq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_jbig300x300Prog),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_digPhotoLow),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_digPhotoMedSeq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_digPhotoMedProg),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_digPhotoHighSeq),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_digPhotoHighProg),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245T84Profile_t84Restricted Print */
HS_RESULT ASNH245T84Profile_t84Restricted_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245T84Profile_t84Restricted *pObj = (ASNH245T84Profile_t84Restricted *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245T84Profile_t84Restricted_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_qcif), pDepth+1, "qcif" );
	AsnBoolean_Print( &(pObj->m_cif), pDepth+1, "cif" );
	AsnBoolean_Print( &(pObj->m_ccir601Seq), pDepth+1, "ccir601Seq" );
	AsnBoolean_Print( &(pObj->m_ccir601Prog), pDepth+1, "ccir601Prog" );
	AsnBoolean_Print( &(pObj->m_hdtvSeq), pDepth+1, "hdtvSeq" );
	AsnBoolean_Print( &(pObj->m_hdtvProg), pDepth+1, "hdtvProg" );
	AsnBoolean_Print( &(pObj->m_g3FacsMH200x100), pDepth+1, "g3FacsMH200x100" );
	AsnBoolean_Print( &(pObj->m_g3FacsMH200x200), pDepth+1, "g3FacsMH200x200" );
	AsnBoolean_Print( &(pObj->m_g4FacsMMR200x100), pDepth+1, "g4FacsMMR200x100" );
	AsnBoolean_Print( &(pObj->m_g4FacsMMR200x200), pDepth+1, "g4FacsMMR200x200" );
	AsnBoolean_Print( &(pObj->m_jbig200x200Seq), pDepth+1, "jbig200x200Seq" );
	AsnBoolean_Print( &(pObj->m_jbig200x200Prog), pDepth+1, "jbig200x200Prog" );
	AsnBoolean_Print( &(pObj->m_jbig300x300Seq), pDepth+1, "jbig300x300Seq" );
	AsnBoolean_Print( &(pObj->m_jbig300x300Prog), pDepth+1, "jbig300x300Prog" );
	AsnBoolean_Print( &(pObj->m_digPhotoLow), pDepth+1, "digPhotoLow" );
	AsnBoolean_Print( &(pObj->m_digPhotoMedSeq), pDepth+1, "digPhotoMedSeq" );
	AsnBoolean_Print( &(pObj->m_digPhotoMedProg), pDepth+1, "digPhotoMedProg" );
	AsnBoolean_Print( &(pObj->m_digPhotoHighSeq), pDepth+1, "digPhotoHighSeq" );
	AsnBoolean_Print( &(pObj->m_digPhotoHighProg), pDepth+1, "digPhotoHighProg" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245T84Profile Struct
*/
/* ASNH245T84Profile Constructor */
HS_RESULT new_ASNH245T84Profile( void *pObject )
{
	ASNH245T84Profile *pObj = (ASNH245T84Profile *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245T84Profile(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245T84ProfileChoice_t84Unrestricted;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245T84ProfileChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245T84Profile Destructor */
HS_RESULT delete_ASNH245T84Profile( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245T84Profile *pObj = (ASNH245T84Profile *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T84Profile(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245T84Profile_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T84Profile(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245T84Profile SetChoice */
void* ASNH245T84Profile_SetChoice( void *pObject, ASNH245T84ProfileChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245T84Profile *pObj = (ASNH245T84Profile *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245T84ProfileChoiceSizeExt ){
		if( pChoice > (ASNH245T84ProfileChoice)(e_ASNH245T84ProfileChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T84Profile_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245T84Profile_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T84Profile_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245T84ProfileChoice_t84Unrestricted ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245T84ProfileChoice_t84Restricted ){
		ASNH245T84Profile_t84Restricted *tAlter = (ASNH245T84Profile_t84Restricted *)HSMalloc( sizeof(ASNH245T84Profile_t84Restricted) );
		new_ASNH245T84Profile_t84Restricted(tAlter);
		ASNH245T84Profile_t84Restricted_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245T84Profile DeleteAlternation */
HS_RESULT ASNH245T84Profile_DeleteAlternation(void *pObject)
{
	ASNH245T84Profile *pObj = (ASNH245T84Profile *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245T84ProfileChoice_t84Unrestricted ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245T84ProfileChoice_t84Restricted ){
			delete_ASNH245T84Profile_t84Restricted(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T84Profile_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245T84Profile_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245T84Profile Encode */
HS_RESULT ASNH245T84Profile_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245T84Profile *pObj = (ASNH245T84Profile *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245T84ProfileChoiceSize )
		{
			if( pObj->choice > ((ASNH245T84ProfileChoice)(e_ASNH245T84ProfileChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245T84ProfileChoiceSize)) )
	}
	else
	{
		if( e_ASNH245T84ProfileChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245T84ProfileChoice_t84Unrestricted ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T84Profile_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245T84ProfileChoice_t84Restricted ){
		if( (tRet=ASNH245T84Profile_t84Restricted_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T84Profile_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245T84Profile Decode */
HS_RESULT ASNH245T84Profile_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245T84Profile *pObj = (ASNH245T84Profile *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245T84ProfileChoiceSize;
	}
	else
	{
		if( e_ASNH245T84ProfileChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245T84ProfileChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245T84ProfileChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T84Profile_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245T84Profile_SetChoice( pObj, (ASNH245T84ProfileChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245T84ProfileChoice_t84Unrestricted ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T84Profile_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245T84ProfileChoice_t84Restricted ){
		if( (tRet=ASNH245T84Profile_t84Restricted_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T84Profile_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T84Profile_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245T84Profile Print */
HS_RESULT ASNH245T84Profile_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245T84Profile *pObj = (ASNH245T84Profile *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245T84Profile_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245T84ProfileChoice_t84Unrestricted ){
		AsnNull_Print( pObj->alter, pDepth+1, "t84Unrestricted" );
	}
	else if ( pObj->choice == e_ASNH245T84ProfileChoice_t84Restricted ){
		ASNH245T84Profile_t84Restricted_Print( pObj->alter, pDepth+1, "t84Restricted" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataApplicationCapability_application_t84 Class
*/
/*ASNH245DataApplicationCapability_application_t84 Constructor*/
HS_RESULT new_ASNH245DataApplicationCapability_application_t84(void *pObject)
{
	ASNH245DataApplicationCapability_application_t84 *pObj = (ASNH245DataApplicationCapability_application_t84 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataApplicationCapability_application_t84(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH245DataProtocolCapability( &(pObj->m_t84Protocol) );
	new_ASNH245T84Profile( &(pObj->m_t84Profile) );

	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_t84 Destructor */
HS_RESULT delete_ASNH245DataApplicationCapability_application_t84(void *pObject)
{
	ASNH245DataApplicationCapability_application_t84 *pObj = (ASNH245DataApplicationCapability_application_t84 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataApplicationCapability_application_t84(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245DataProtocolCapability( &(pObj->m_t84Protocol) );
	delete_ASNH245T84Profile( &(pObj->m_t84Profile) );
	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_t84 MakeMold */
HS_RESULT ASNH245DataApplicationCapability_application_t84_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245DataApplicationCapability_application_t84 *pObj = (ASNH245DataApplicationCapability_application_t84 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t84_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245DataProtocolCapability_MakeMold(&(pObj->m_t84Protocol));
	ASNH245T84Profile_MakeMold(&(pObj->m_t84Profile));
	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_t84 Encode */
HS_RESULT ASNH245DataApplicationCapability_application_t84_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataApplicationCapability_application_t84 *pObj = (ASNH245DataApplicationCapability_application_t84 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t84_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245DataProtocolCapability_Encode( &(pObj->m_t84Protocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t84_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245T84Profile_Encode( &(pObj->m_t84Profile),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t84_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_t84 Decode */
HS_RESULT ASNH245DataApplicationCapability_application_t84_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataApplicationCapability_application_t84 *pObj = (ASNH245DataApplicationCapability_application_t84 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t84_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245DataProtocolCapability_Decode(&(pObj->m_t84Protocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t84_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245T84Profile_Decode(&(pObj->m_t84Profile),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t84_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataApplicationCapability_application_t84 Print */
HS_RESULT ASNH245DataApplicationCapability_application_t84_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataApplicationCapability_application_t84 *pObj = (ASNH245DataApplicationCapability_application_t84 *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t84_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245DataProtocolCapability_Print( &(pObj->m_t84Protocol), pDepth+1, "t84Protocol" );
	ASNH245T84Profile_Print( &(pObj->m_t84Profile), pDepth+1, "t84Profile" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataApplicationCapability_application_nlpid Class
*/
/*ASNH245DataApplicationCapability_application_nlpid Constructor*/
HS_RESULT new_ASNH245DataApplicationCapability_application_nlpid(void *pObject)
{
	ASNH245DataApplicationCapability_application_nlpid *pObj = (ASNH245DataApplicationCapability_application_nlpid *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataApplicationCapability_application_nlpid(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH245DataProtocolCapability( &(pObj->m_nlpidProtocol) );
	new_AsnOctetString( &(pObj->m_nlpidData), e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_nlpid Destructor */
HS_RESULT delete_ASNH245DataApplicationCapability_application_nlpid(void *pObject)
{
	ASNH245DataApplicationCapability_application_nlpid *pObj = (ASNH245DataApplicationCapability_application_nlpid *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataApplicationCapability_application_nlpid(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245DataProtocolCapability( &(pObj->m_nlpidProtocol) );
	delete_AsnOctetString( &(pObj->m_nlpidData) );
	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_nlpid MakeMold */
HS_RESULT ASNH245DataApplicationCapability_application_nlpid_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245DataApplicationCapability_application_nlpid *pObj = (ASNH245DataApplicationCapability_application_nlpid *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_nlpid_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245DataProtocolCapability_MakeMold(&(pObj->m_nlpidProtocol));
	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_nlpid Encode */
HS_RESULT ASNH245DataApplicationCapability_application_nlpid_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataApplicationCapability_application_nlpid *pObj = (ASNH245DataApplicationCapability_application_nlpid *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_nlpid_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245DataProtocolCapability_Encode( &(pObj->m_nlpidProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_nlpid_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_nlpidData),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_nlpid_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_nlpid Decode */
HS_RESULT ASNH245DataApplicationCapability_application_nlpid_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataApplicationCapability_application_nlpid *pObj = (ASNH245DataApplicationCapability_application_nlpid *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_nlpid_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245DataProtocolCapability_Decode(&(pObj->m_nlpidProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_nlpid_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_nlpidData),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_nlpid_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataApplicationCapability_application_nlpid Print */
HS_RESULT ASNH245DataApplicationCapability_application_nlpid_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataApplicationCapability_application_nlpid *pObj = (ASNH245DataApplicationCapability_application_nlpid *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_nlpid_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245DataProtocolCapability_Print( &(pObj->m_nlpidProtocol), pDepth+1, "nlpidProtocol" );
	AsnOctetString_Print( &(pObj->m_nlpidData), pDepth+1, "nlpidData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245T38FaxRateManagement Struct
*/
/* ASNH245T38FaxRateManagement Constructor */
HS_RESULT new_ASNH245T38FaxRateManagement( void *pObject )
{
	ASNH245T38FaxRateManagement *pObj = (ASNH245T38FaxRateManagement *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245T38FaxRateManagement(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245T38FaxRateManagementChoice_localTCF;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245T38FaxRateManagementChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245T38FaxRateManagement Destructor */
HS_RESULT delete_ASNH245T38FaxRateManagement( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245T38FaxRateManagement *pObj = (ASNH245T38FaxRateManagement *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T38FaxRateManagement(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245T38FaxRateManagement_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T38FaxRateManagement(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245T38FaxRateManagement SetChoice */
void* ASNH245T38FaxRateManagement_SetChoice( void *pObject, ASNH245T38FaxRateManagementChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245T38FaxRateManagement *pObj = (ASNH245T38FaxRateManagement *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245T38FaxRateManagementChoiceSizeExt ){
		if( pChoice > (ASNH245T38FaxRateManagementChoice)(e_ASNH245T38FaxRateManagementChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxRateManagement_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245T38FaxRateManagement_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxRateManagement_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245T38FaxRateManagementChoice_localTCF ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245T38FaxRateManagementChoice_transferredTCF ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245T38FaxRateManagement DeleteAlternation */
HS_RESULT ASNH245T38FaxRateManagement_DeleteAlternation(void *pObject)
{
	ASNH245T38FaxRateManagement *pObj = (ASNH245T38FaxRateManagement *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245T38FaxRateManagementChoice_localTCF ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245T38FaxRateManagementChoice_transferredTCF ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxRateManagement_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245T38FaxRateManagement_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245T38FaxRateManagement Encode */
HS_RESULT ASNH245T38FaxRateManagement_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245T38FaxRateManagement *pObj = (ASNH245T38FaxRateManagement *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245T38FaxRateManagementChoiceSize )
		{
			if( pObj->choice > ((ASNH245T38FaxRateManagementChoice)(e_ASNH245T38FaxRateManagementChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245T38FaxRateManagementChoiceSize)) )
	}
	else
	{
		if( e_ASNH245T38FaxRateManagementChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245T38FaxRateManagementChoice_localTCF ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxRateManagement_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245T38FaxRateManagementChoice_transferredTCF ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxRateManagement_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245T38FaxRateManagement Decode */
HS_RESULT ASNH245T38FaxRateManagement_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245T38FaxRateManagement *pObj = (ASNH245T38FaxRateManagement *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245T38FaxRateManagementChoiceSize;
	}
	else
	{
		if( e_ASNH245T38FaxRateManagementChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245T38FaxRateManagementChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245T38FaxRateManagementChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxRateManagement_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245T38FaxRateManagement_SetChoice( pObj, (ASNH245T38FaxRateManagementChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245T38FaxRateManagementChoice_localTCF ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxRateManagement_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245T38FaxRateManagementChoice_transferredTCF ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxRateManagement_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245T38FaxRateManagement Print */
HS_RESULT ASNH245T38FaxRateManagement_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245T38FaxRateManagement *pObj = (ASNH245T38FaxRateManagement *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245T38FaxRateManagement_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245T38FaxRateManagementChoice_localTCF ){
		AsnNull_Print( pObj->alter, pDepth+1, "localTCF" );
	}
	else if ( pObj->choice == e_ASNH245T38FaxRateManagementChoice_transferredTCF ){
		AsnNull_Print( pObj->alter, pDepth+1, "transferredTCF" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245T38FaxUdpOptions_t38FaxUdpEC Struct
*/
/* ASNH245T38FaxUdpOptions_t38FaxUdpEC Constructor */
HS_RESULT new_ASNH245T38FaxUdpOptions_t38FaxUdpEC( void *pObject )
{
	ASNH245T38FaxUdpOptions_t38FaxUdpEC *pObj = (ASNH245T38FaxUdpOptions_t38FaxUdpEC *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245T38FaxUdpOptions_t38FaxUdpEC(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPFEC;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245T38FaxUdpOptions_t38FaxUdpEC Destructor */
HS_RESULT delete_ASNH245T38FaxUdpOptions_t38FaxUdpEC( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245T38FaxUdpOptions_t38FaxUdpEC *pObj = (ASNH245T38FaxUdpOptions_t38FaxUdpEC *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T38FaxUdpOptions_t38FaxUdpEC(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245T38FaxUdpOptions_t38FaxUdpEC_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T38FaxUdpOptions_t38FaxUdpEC(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245T38FaxUdpOptions_t38FaxUdpEC SetChoice */
void* ASNH245T38FaxUdpOptions_t38FaxUdpEC_SetChoice( void *pObject, ASNH245T38FaxUdpOptions_t38FaxUdpECChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245T38FaxUdpOptions_t38FaxUdpEC *pObj = (ASNH245T38FaxUdpOptions_t38FaxUdpEC *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSizeExt ){
		if( pChoice > (ASNH245T38FaxUdpOptions_t38FaxUdpECChoice)(e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245T38FaxUdpOptions_t38FaxUdpEC_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPFEC ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPRedundancy ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245T38FaxUdpOptions_t38FaxUdpEC DeleteAlternation */
HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_DeleteAlternation(void *pObject)
{
	ASNH245T38FaxUdpOptions_t38FaxUdpEC *pObj = (ASNH245T38FaxUdpOptions_t38FaxUdpEC *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPFEC ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPRedundancy ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245T38FaxUdpOptions_t38FaxUdpEC Encode */
HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245T38FaxUdpOptions_t38FaxUdpEC *pObj = (ASNH245T38FaxUdpOptions_t38FaxUdpEC *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSize )
		{
			if( pObj->choice > ((ASNH245T38FaxUdpOptions_t38FaxUdpECChoice)(e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSize)) )
	}
	else
	{
		if( e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPFEC ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPRedundancy ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245T38FaxUdpOptions_t38FaxUdpEC Decode */
HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245T38FaxUdpOptions_t38FaxUdpEC *pObj = (ASNH245T38FaxUdpOptions_t38FaxUdpEC *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSize;
	}
	else
	{
		if( e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245T38FaxUdpOptions_t38FaxUdpEC_SetChoice( pObj, (ASNH245T38FaxUdpOptions_t38FaxUdpECChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPFEC ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPRedundancy ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245T38FaxUdpOptions_t38FaxUdpEC Print */
HS_RESULT ASNH245T38FaxUdpOptions_t38FaxUdpEC_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245T38FaxUdpOptions_t38FaxUdpEC *pObj = (ASNH245T38FaxUdpOptions_t38FaxUdpEC *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_t38FaxUdpEC_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPFEC ){
		AsnNull_Print( pObj->alter, pDepth+1, "t38UDPFEC" );
	}
	else if ( pObj->choice == e_ASNH245T38FaxUdpOptions_t38FaxUdpECChoice_t38UDPRedundancy ){
		AsnNull_Print( pObj->alter, pDepth+1, "t38UDPRedundancy" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245T38FaxUdpOptions Class
*/
/*ASNH245T38FaxUdpOptions Constructor*/
HS_RESULT new_ASNH245T38FaxUdpOptions(void *pObject)
{
	ASNH245T38FaxUdpOptions *pObj = (ASNH245T38FaxUdpOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245T38FaxUdpOptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_t38FaxMaxBuffer), e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_t38FaxMaxDatagram), e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245T38FaxUdpOptions_t38FaxUdpEC( &(pObj->m_t38FaxUdpEC) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245T38FaxUdpOptions Destructor */
HS_RESULT delete_ASNH245T38FaxUdpOptions(void *pObject)
{
	ASNH245T38FaxUdpOptions *pObj = (ASNH245T38FaxUdpOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T38FaxUdpOptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_t38FaxMaxBuffer) );
	delete_AsnInteger( &(pObj->m_t38FaxMaxDatagram) );
	delete_ASNH245T38FaxUdpOptions_t38FaxUdpEC( &(pObj->m_t38FaxUdpEC) );
	return HS_OK;
}

/* ASNH245T38FaxUdpOptions MakeMold */
HS_RESULT ASNH245T38FaxUdpOptions_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245T38FaxUdpOptions *pObj = (ASNH245T38FaxUdpOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245T38FaxUdpOptions IncludeOptionalField */
HS_RESULT ASNH245T38FaxUdpOptions_IncludeOptionField( void *pObject, ASNH245T38FaxUdpOptionsOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245T38FaxUdpOptions *pObj = (ASNH245T38FaxUdpOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245T38FaxUdpOptionsOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245T38FaxUdpOptions IsIncludeOptionalField */
BOOL ASNH245T38FaxUdpOptions_IsIncludeOptionField( void *pObject, ASNH245T38FaxUdpOptionsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245T38FaxUdpOptions *pObj = (ASNH245T38FaxUdpOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245T38FaxUdpOptionsOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245T38FaxUdpOptions Encode */
HS_RESULT ASNH245T38FaxUdpOptions_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245T38FaxUdpOptions *pObj = (ASNH245T38FaxUdpOptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245T38FaxUdpOptionsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245T38FaxUdpOptionsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245T38FaxUdpOptions_IsIncludeOptionField( pObj, e_ASNH245T38FaxUdpOptionsOptionMap_t38FaxMaxBuffer ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_t38FaxMaxBuffer),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245T38FaxUdpOptions_IsIncludeOptionField( pObj, e_ASNH245T38FaxUdpOptionsOptionMap_t38FaxMaxDatagram ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_t38FaxMaxDatagram),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH245T38FaxUdpOptions_t38FaxUdpEC_Encode( &(pObj->m_t38FaxUdpEC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245T38FaxUdpOptions Decode */
HS_RESULT ASNH245T38FaxUdpOptions_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245T38FaxUdpOptions *pObj = (ASNH245T38FaxUdpOptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245T38FaxUdpOptionsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245T38FaxUdpOptionsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245T38FaxUdpOptions_IsIncludeOptionField( pObj, e_ASNH245T38FaxUdpOptionsOptionMap_t38FaxMaxBuffer ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_t38FaxMaxBuffer),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245T38FaxUdpOptions_IsIncludeOptionField( pObj, e_ASNH245T38FaxUdpOptionsOptionMap_t38FaxMaxDatagram ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_t38FaxMaxDatagram),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxUdpOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH245T38FaxUdpOptions_t38FaxUdpEC_Decode(&(pObj->m_t38FaxUdpEC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245T38FaxUdpOptions Print */
HS_RESULT ASNH245T38FaxUdpOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245T38FaxUdpOptions *pObj = (ASNH245T38FaxUdpOptions *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245T38FaxUdpOptions_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245T38FaxUdpOptions_IsIncludeOptionField( pObj, e_ASNH245T38FaxUdpOptionsOptionMap_t38FaxMaxBuffer ) )
		AsnInteger_Print( &(pObj->m_t38FaxMaxBuffer), pDepth+1, "t38FaxMaxBuffer" );
	if( ASNH245T38FaxUdpOptions_IsIncludeOptionField( pObj, e_ASNH245T38FaxUdpOptionsOptionMap_t38FaxMaxDatagram ) )
		AsnInteger_Print( &(pObj->m_t38FaxMaxDatagram), pDepth+1, "t38FaxMaxDatagram" );
	ASNH245T38FaxUdpOptions_t38FaxUdpEC_Print( &(pObj->m_t38FaxUdpEC), pDepth+1, "t38FaxUdpEC" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245T38FaxTcpOptions Class
*/
/*ASNH245T38FaxTcpOptions Constructor*/
HS_RESULT new_ASNH245T38FaxTcpOptions(void *pObject)
{
	ASNH245T38FaxTcpOptions *pObj = (ASNH245T38FaxTcpOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245T38FaxTcpOptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_t38TCPBidirectionalMode) );

	return HS_OK;
}

/* ASNH245T38FaxTcpOptions Destructor */
HS_RESULT delete_ASNH245T38FaxTcpOptions(void *pObject)
{
	ASNH245T38FaxTcpOptions *pObj = (ASNH245T38FaxTcpOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T38FaxTcpOptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_t38TCPBidirectionalMode) );
	return HS_OK;
}

/* ASNH245T38FaxTcpOptions MakeMold */
HS_RESULT ASNH245T38FaxTcpOptions_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245T38FaxTcpOptions *pObj = (ASNH245T38FaxTcpOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxTcpOptions_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245T38FaxTcpOptions Encode */
HS_RESULT ASNH245T38FaxTcpOptions_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245T38FaxTcpOptions *pObj = (ASNH245T38FaxTcpOptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxTcpOptions_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_t38TCPBidirectionalMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxTcpOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245T38FaxTcpOptions Decode */
HS_RESULT ASNH245T38FaxTcpOptions_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245T38FaxTcpOptions *pObj = (ASNH245T38FaxTcpOptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxTcpOptions_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_t38TCPBidirectionalMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxTcpOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245T38FaxTcpOptions Print */
HS_RESULT ASNH245T38FaxTcpOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245T38FaxTcpOptions *pObj = (ASNH245T38FaxTcpOptions *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245T38FaxTcpOptions_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_t38TCPBidirectionalMode), pDepth+1, "t38TCPBidirectionalMode" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245T38FaxProfile Class
*/
/*ASNH245T38FaxProfile Constructor*/
HS_RESULT new_ASNH245T38FaxProfile(void *pObject)
{
	ASNH245T38FaxProfile *pObj = (ASNH245T38FaxProfile *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245T38FaxProfile(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_fillBitRemoval) );
	new_AsnBoolean( &(pObj->m_transcodingJBIG) );
	new_AsnBoolean( &(pObj->m_transcodingMMR) );
	new_AsnInteger( &(pObj->m_version), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245T38FaxRateManagement( &(pObj->m_t38FaxRateManagement) );
	new_ASNH245T38FaxUdpOptions( &(pObj->m_t38FaxUdpOptions) );
	new_ASNH245T38FaxTcpOptions( &(pObj->m_t38FaxTcpOptions) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245T38FaxProfile Destructor */
HS_RESULT delete_ASNH245T38FaxProfile(void *pObject)
{
	ASNH245T38FaxProfile *pObj = (ASNH245T38FaxProfile *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245T38FaxProfile(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_fillBitRemoval) );
	delete_AsnBoolean( &(pObj->m_transcodingJBIG) );
	delete_AsnBoolean( &(pObj->m_transcodingMMR) );
	delete_AsnInteger( &(pObj->m_version) );
	delete_ASNH245T38FaxRateManagement( &(pObj->m_t38FaxRateManagement) );
	delete_ASNH245T38FaxUdpOptions( &(pObj->m_t38FaxUdpOptions) );
	delete_ASNH245T38FaxTcpOptions( &(pObj->m_t38FaxTcpOptions) );
	return HS_OK;
}

/* ASNH245T38FaxProfile MakeMold */
HS_RESULT ASNH245T38FaxProfile_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245T38FaxProfile *pObj = (ASNH245T38FaxProfile *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245T38FaxRateManagement_MakeMold(&(pObj->m_t38FaxRateManagement));
	ASNH245T38FaxUdpOptions_MakeMold(&(pObj->m_t38FaxUdpOptions));
	ASNH245T38FaxTcpOptions_MakeMold(&(pObj->m_t38FaxTcpOptions));
	return HS_OK;
}

/* ASNH245T38FaxProfile IncludeOptionalField */
HS_RESULT ASNH245T38FaxProfile_IncludeOptionField( void *pObject, ASNH245T38FaxProfileOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245T38FaxProfile *pObj = (ASNH245T38FaxProfile *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245T38FaxProfileOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245T38FaxProfileOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245T38FaxProfile IsIncludeOptionalField */
BOOL ASNH245T38FaxProfile_IsIncludeOptionField( void *pObject, ASNH245T38FaxProfileOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245T38FaxProfile *pObj = (ASNH245T38FaxProfile *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245T38FaxProfileOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245T38FaxProfileOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245T38FaxProfile Encode */
HS_RESULT ASNH245T38FaxProfile_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245T38FaxProfile *pObj = (ASNH245T38FaxProfile *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_fillBitRemoval),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_transcodingJBIG),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_transcodingMMR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_version ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_version), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245T38FaxProfile_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_t38FaxRateManagement ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_t38FaxRateManagement), ASNH245T38FaxRateManagement_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245T38FaxProfile_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_t38FaxUdpOptions ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_t38FaxUdpOptions), ASNH245T38FaxUdpOptions_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245T38FaxProfile_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_t38FaxTcpOptions ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_t38FaxTcpOptions), ASNH245T38FaxTcpOptions_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245T38FaxProfile_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245T38FaxProfile Decode */
HS_RESULT ASNH245T38FaxProfile_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245T38FaxProfile *pObj = (ASNH245T38FaxProfile *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_fillBitRemoval),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_transcodingJBIG),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_transcodingMMR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245T38FaxProfile_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_version ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_version), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxProfile_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_t38FaxRateManagement ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_t38FaxRateManagement), ASNH245T38FaxRateManagement_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxProfile_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_t38FaxUdpOptions ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_t38FaxUdpOptions), ASNH245T38FaxUdpOptions_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxProfile_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_t38FaxTcpOptions ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_t38FaxTcpOptions), ASNH245T38FaxTcpOptions_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245T38FaxProfile_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245T38FaxProfile Print */
HS_RESULT ASNH245T38FaxProfile_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245T38FaxProfile *pObj = (ASNH245T38FaxProfile *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245T38FaxProfile_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_fillBitRemoval), pDepth+1, "fillBitRemoval" );
	AsnBoolean_Print( &(pObj->m_transcodingJBIG), pDepth+1, "transcodingJBIG" );
	AsnBoolean_Print( &(pObj->m_transcodingMMR), pDepth+1, "transcodingMMR" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_version ) )
		AsnInteger_Print( &(pObj->m_version), pDepth+1, "version" );
	if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_t38FaxRateManagement ) )
		ASNH245T38FaxRateManagement_Print( &(pObj->m_t38FaxRateManagement), pDepth+1, "t38FaxRateManagement" );
	if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_t38FaxUdpOptions ) )
		ASNH245T38FaxUdpOptions_Print( &(pObj->m_t38FaxUdpOptions), pDepth+1, "t38FaxUdpOptions" );
	if( ASNH245T38FaxProfile_IsIncludeOptionField( pObj, e_ASNH245T38FaxProfileOptionMap_t38FaxTcpOptions ) )
		ASNH245T38FaxTcpOptions_Print( &(pObj->m_t38FaxTcpOptions), pDepth+1, "t38FaxTcpOptions" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataApplicationCapability_application_t38fax Class
*/
/*ASNH245DataApplicationCapability_application_t38fax Constructor*/
HS_RESULT new_ASNH245DataApplicationCapability_application_t38fax(void *pObject)
{
	ASNH245DataApplicationCapability_application_t38fax *pObj = (ASNH245DataApplicationCapability_application_t38fax *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataApplicationCapability_application_t38fax(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH245DataProtocolCapability( &(pObj->m_t38FaxProtocol) );
	new_ASNH245T38FaxProfile( &(pObj->m_t38FaxProfile) );

	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_t38fax Destructor */
HS_RESULT delete_ASNH245DataApplicationCapability_application_t38fax(void *pObject)
{
	ASNH245DataApplicationCapability_application_t38fax *pObj = (ASNH245DataApplicationCapability_application_t38fax *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataApplicationCapability_application_t38fax(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245DataProtocolCapability( &(pObj->m_t38FaxProtocol) );
	delete_ASNH245T38FaxProfile( &(pObj->m_t38FaxProfile) );
	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_t38fax MakeMold */
HS_RESULT ASNH245DataApplicationCapability_application_t38fax_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245DataApplicationCapability_application_t38fax *pObj = (ASNH245DataApplicationCapability_application_t38fax *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t38fax_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245DataProtocolCapability_MakeMold(&(pObj->m_t38FaxProtocol));
	ASNH245T38FaxProfile_MakeMold(&(pObj->m_t38FaxProfile));
	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_t38fax Encode */
HS_RESULT ASNH245DataApplicationCapability_application_t38fax_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataApplicationCapability_application_t38fax *pObj = (ASNH245DataApplicationCapability_application_t38fax *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t38fax_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245DataProtocolCapability_Encode( &(pObj->m_t38FaxProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t38fax_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245T38FaxProfile_Encode( &(pObj->m_t38FaxProfile),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t38fax_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245DataApplicationCapability_application_t38fax Decode */
HS_RESULT ASNH245DataApplicationCapability_application_t38fax_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataApplicationCapability_application_t38fax *pObj = (ASNH245DataApplicationCapability_application_t38fax *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t38fax_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245DataProtocolCapability_Decode(&(pObj->m_t38FaxProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t38fax_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245T38FaxProfile_Decode(&(pObj->m_t38FaxProfile),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t38fax_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataApplicationCapability_application_t38fax Print */
HS_RESULT ASNH245DataApplicationCapability_application_t38fax_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataApplicationCapability_application_t38fax *pObj = (ASNH245DataApplicationCapability_application_t38fax *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_t38fax_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245DataProtocolCapability_Print( &(pObj->m_t38FaxProtocol), pDepth+1, "t38FaxProtocol" );
	ASNH245T38FaxProfile_Print( &(pObj->m_t38FaxProfile), pDepth+1, "t38FaxProfile" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CapabilityIdentifier Struct
*/
/* ASNH245CapabilityIdentifier Constructor */
HS_RESULT new_ASNH245CapabilityIdentifier( void *pObject )
{
	ASNH245CapabilityIdentifier *pObj = (ASNH245CapabilityIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CapabilityIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245CapabilityIdentifierChoice_standard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245CapabilityIdentifierChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245CapabilityIdentifier Destructor */
HS_RESULT delete_ASNH245CapabilityIdentifier( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245CapabilityIdentifier *pObj = (ASNH245CapabilityIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CapabilityIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245CapabilityIdentifier_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CapabilityIdentifier(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245CapabilityIdentifier SetChoice */
void* ASNH245CapabilityIdentifier_SetChoice( void *pObject, ASNH245CapabilityIdentifierChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245CapabilityIdentifier *pObj = (ASNH245CapabilityIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245CapabilityIdentifierChoiceSizeExt ){
		if( pChoice > (ASNH245CapabilityIdentifierChoice)(e_ASNH245CapabilityIdentifierChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245CapabilityIdentifier_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245CapabilityIdentifierChoice_standard ){
		AsnObjectIdentifier *tAlter = (AsnObjectIdentifier *)HSMalloc( sizeof(AsnObjectIdentifier) );
		new_AsnObjectIdentifier(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CapabilityIdentifierChoice_h221NonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CapabilityIdentifierChoice_uuid ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_constrained,16,16,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CapabilityIdentifierChoice_domainBased ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagIA5String,e_constrained,1,64,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245CapabilityIdentifier DeleteAlternation */
HS_RESULT ASNH245CapabilityIdentifier_DeleteAlternation(void *pObject)
{
	ASNH245CapabilityIdentifier *pObj = (ASNH245CapabilityIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245CapabilityIdentifierChoice_standard ){
			delete_AsnObjectIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_h221NonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_uuid ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_domainBased ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245CapabilityIdentifier_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245CapabilityIdentifier Encode */
HS_RESULT ASNH245CapabilityIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245CapabilityIdentifier *pObj = (ASNH245CapabilityIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245CapabilityIdentifierChoiceSize )
		{
			if( pObj->choice > ((ASNH245CapabilityIdentifierChoice)(e_ASNH245CapabilityIdentifierChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245CapabilityIdentifierChoiceSize)) )
	}
	else
	{
		if( e_ASNH245CapabilityIdentifierChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CapabilityIdentifierChoice_standard ){
		if( (tRet=AsnObjectIdentifier_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_h221NonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_uuid ){
		if( (tRet=AsnOctetString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_domainBased ){
		if( (tRet=AsnSingleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245CapabilityIdentifier Decode */
HS_RESULT ASNH245CapabilityIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245CapabilityIdentifier *pObj = (ASNH245CapabilityIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245CapabilityIdentifierChoiceSize;
	}
	else
	{
		if( e_ASNH245CapabilityIdentifierChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245CapabilityIdentifierChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245CapabilityIdentifierChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245CapabilityIdentifier_SetChoice( pObj, (ASNH245CapabilityIdentifierChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CapabilityIdentifierChoice_standard ){
		if( (tRet=AsnObjectIdentifier_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_h221NonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_uuid ){
		if( (tRet=AsnOctetString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_domainBased ){
		if( (tRet=AsnSingleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CapabilityIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CapabilityIdentifier Print */
HS_RESULT ASNH245CapabilityIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CapabilityIdentifier *pObj = (ASNH245CapabilityIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CapabilityIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CapabilityIdentifierChoice_standard ){
		AsnObjectIdentifier_Print( pObj->alter, pDepth+1, "standard" );
	}
	else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_h221NonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "h221NonStandard" );
	}
	else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_uuid ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "uuid" );
	}
	else if ( pObj->choice == e_ASNH245CapabilityIdentifierChoice_domainBased ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "domainBased" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ParameterIdentifier Struct
*/
/* ASNH245ParameterIdentifier Constructor */
HS_RESULT new_ASNH245ParameterIdentifier( void *pObject )
{
	ASNH245ParameterIdentifier *pObj = (ASNH245ParameterIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ParameterIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245ParameterIdentifierChoice_standard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245ParameterIdentifierChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245ParameterIdentifier Destructor */
HS_RESULT delete_ASNH245ParameterIdentifier( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245ParameterIdentifier *pObj = (ASNH245ParameterIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ParameterIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245ParameterIdentifier_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ParameterIdentifier(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245ParameterIdentifier SetChoice */
void* ASNH245ParameterIdentifier_SetChoice( void *pObject, ASNH245ParameterIdentifierChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245ParameterIdentifier *pObj = (ASNH245ParameterIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterIdentifier_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245ParameterIdentifierChoiceSizeExt ){
		if( pChoice > (ASNH245ParameterIdentifierChoice)(e_ASNH245ParameterIdentifierChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245ParameterIdentifier_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245ParameterIdentifierChoice_standard ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,127,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterIdentifierChoice_h221NonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterIdentifierChoice_uuid ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_constrained,16,16,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterIdentifierChoice_domainBased ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagIA5String,e_constrained,1,64,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterIdentifier_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245ParameterIdentifier DeleteAlternation */
HS_RESULT ASNH245ParameterIdentifier_DeleteAlternation(void *pObject)
{
	ASNH245ParameterIdentifier *pObj = (ASNH245ParameterIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterIdentifier_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245ParameterIdentifierChoice_standard ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_h221NonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_uuid ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_domainBased ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245ParameterIdentifier_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245ParameterIdentifier Encode */
HS_RESULT ASNH245ParameterIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245ParameterIdentifier *pObj = (ASNH245ParameterIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterIdentifier_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245ParameterIdentifierChoiceSize )
		{
			if( pObj->choice > ((ASNH245ParameterIdentifierChoice)(e_ASNH245ParameterIdentifierChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245ParameterIdentifierChoiceSize)) )
	}
	else
	{
		if( e_ASNH245ParameterIdentifierChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ParameterIdentifierChoice_standard ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_h221NonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_uuid ){
		if( (tRet=AsnOctetString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_domainBased ){
		if( (tRet=AsnSingleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterIdentifier_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245ParameterIdentifier Decode */
HS_RESULT ASNH245ParameterIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245ParameterIdentifier *pObj = (ASNH245ParameterIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245ParameterIdentifierChoiceSize;
	}
	else
	{
		if( e_ASNH245ParameterIdentifierChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245ParameterIdentifierChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245ParameterIdentifierChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245ParameterIdentifier_SetChoice( pObj, (ASNH245ParameterIdentifierChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterIdentifier_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ParameterIdentifierChoice_standard ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_h221NonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_uuid ){
		if( (tRet=AsnOctetString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_domainBased ){
		if( (tRet=AsnSingleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterIdentifier_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ParameterIdentifier Print */
HS_RESULT ASNH245ParameterIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ParameterIdentifier *pObj = (ASNH245ParameterIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ParameterIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ParameterIdentifierChoice_standard ){
		AsnInteger_Print( pObj->alter, pDepth+1, "standard" );
	}
	else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_h221NonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "h221NonStandard" );
	}
	else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_uuid ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "uuid" );
	}
	else if ( pObj->choice == e_ASNH245ParameterIdentifierChoice_domainBased ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "domainBased" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ParameterValue Struct
*/
/* ASNH245ParameterValue Constructor */
HS_RESULT new_ASNH245ParameterValue( void *pObject )
{
	ASNH245ParameterValue *pObj = (ASNH245ParameterValue *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ParameterValue(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245ParameterValueChoice_logical;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245ParameterValueChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245ParameterValue Destructor */
HS_RESULT delete_ASNH245ParameterValue( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245ParameterValue *pObj = (ASNH245ParameterValue *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ParameterValue(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245ParameterValue_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ParameterValue(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245ParameterValue SetChoice */
void* ASNH245ParameterValue_SetChoice( void *pObject, ASNH245ParameterValueChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245ParameterValue *pObj = (ASNH245ParameterValue *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterValue_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245ParameterValueChoiceSizeExt ){
		if( pChoice > (ASNH245ParameterValueChoice)(e_ASNH245ParameterValueChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245ParameterValue_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245ParameterValueChoice_logical ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterValueChoice_booleanArray ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,255,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterValueChoice_unsignedMin ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterValueChoice_unsignedMax ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterValueChoice_unsigned32Min ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterValueChoice_unsigned32Max ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterValueChoice_octetString ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ParameterValueChoice_genericParameter ){
		ASNH245GenericParameter *tAlter = (ASNH245GenericParameter *)HSMalloc( sizeof(ASNH245GenericParameter) );
		new_ASNH245GenericParameter(tAlter);
		ASNH245GenericParameter_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH245GenericParameter),ASNH245GenericParameter_MakeMold,ASNH245GenericParameter_Encode,ASNH245GenericParameter_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH245GenericParameter_Print,
#endif
			delete_ASNH245GenericParameter );
		AsnSequenceOf_SetMold(aso,tmold);
		pObj->alter = aso;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterValue_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245ParameterValue DeleteAlternation */
HS_RESULT ASNH245ParameterValue_DeleteAlternation(void *pObject)
{
	ASNH245ParameterValue *pObj = (ASNH245ParameterValue *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterValue_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245ParameterValueChoice_logical ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterValueChoice_booleanArray ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsignedMin ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsignedMax ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsigned32Min ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsigned32Max ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterValueChoice_octetString ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ParameterValueChoice_genericParameter ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245ParameterValue_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245ParameterValue Encode */
HS_RESULT ASNH245ParameterValue_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245ParameterValue *pObj = (ASNH245ParameterValue *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterValue_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterValue_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245ParameterValueChoiceSize )
		{
			if( pObj->choice > ((ASNH245ParameterValueChoice)(e_ASNH245ParameterValueChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245ParameterValueChoiceSize)) )
	}
	else
	{
		if( e_ASNH245ParameterValueChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ParameterValueChoice_logical ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_booleanArray ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsignedMin ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsignedMax ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsigned32Min ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsigned32Max ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_octetString ){
		if( (tRet=AsnOctetString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_genericParameter ){
		if( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterValue_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245ParameterValue Decode */
HS_RESULT ASNH245ParameterValue_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245ParameterValue *pObj = (ASNH245ParameterValue *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterValue_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245ParameterValueChoiceSize;
	}
	else
	{
		if( e_ASNH245ParameterValueChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245ParameterValueChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245ParameterValueChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245ParameterValue_SetChoice( pObj, (ASNH245ParameterValueChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterValue_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ParameterValueChoice_logical ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_booleanArray ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsignedMin ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsignedMax ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsigned32Min ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsigned32Max ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_octetString ){
		if( (tRet=AsnOctetString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_genericParameter ){
		if( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ParameterValue_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ParameterValue_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ParameterValue Print */
HS_RESULT ASNH245ParameterValue_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ParameterValue *pObj = (ASNH245ParameterValue *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ParameterValue_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ParameterValueChoice_logical ){
		AsnNull_Print( pObj->alter, pDepth+1, "logical" );
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_booleanArray ){
		AsnInteger_Print( pObj->alter, pDepth+1, "booleanArray" );
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsignedMin ){
		AsnInteger_Print( pObj->alter, pDepth+1, "unsignedMin" );
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsignedMax ){
		AsnInteger_Print( pObj->alter, pDepth+1, "unsignedMax" );
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsigned32Min ){
		AsnInteger_Print( pObj->alter, pDepth+1, "unsigned32Min" );
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_unsigned32Max ){
		AsnInteger_Print( pObj->alter, pDepth+1, "unsigned32Max" );
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_octetString ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "octetString" );
	}
	else if ( pObj->choice == e_ASNH245ParameterValueChoice_genericParameter ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "genericParameter" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245GenericParameter Class
*/
/*ASNH245GenericParameter Constructor*/
HS_RESULT new_ASNH245GenericParameter(void *pObject)
{
	ASNH245GenericParameter *pObj = (ASNH245GenericParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245GenericParameter(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245ParameterIdentifier( &(pObj->m_parameterIdentifier) );
	new_ASNH245ParameterValue( &(pObj->m_parameterValue) );
	new_AsnSequenceOf( &(pObj->m_supersedes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245GenericParameter Destructor */
HS_RESULT delete_ASNH245GenericParameter(void *pObject)
{
	ASNH245GenericParameter *pObj = (ASNH245GenericParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245GenericParameter(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245ParameterIdentifier( &(pObj->m_parameterIdentifier) );
	delete_ASNH245ParameterValue( &(pObj->m_parameterValue) );
	delete_AsnSequenceOf( &(pObj->m_supersedes) );
	return HS_OK;
}

/* ASNH245GenericParameter MakeMold */
HS_RESULT ASNH245GenericParameter_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245GenericParameter *pObj = (ASNH245GenericParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericParameter_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245ParameterIdentifier_MakeMold(&(pObj->m_parameterIdentifier));
	ASNH245ParameterValue_MakeMold(&(pObj->m_parameterValue));
	{
	ASNH245ParameterIdentifier *tmold_supersedes = (ASNH245ParameterIdentifier *)HSMalloc( sizeof(ASNH245ParameterIdentifier) );
	new_ASNH245ParameterIdentifier(tmold_supersedes);
	ASNH245ParameterIdentifier_MakeMold(tmold_supersedes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supersedes,sizeof(ASNH245ParameterIdentifier),ASNH245ParameterIdentifier_MakeMold,ASNH245ParameterIdentifier_Encode,ASNH245ParameterIdentifier_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245ParameterIdentifier_Print,
#endif
		delete_ASNH245ParameterIdentifier);
	AsnSequenceOf_SetMold( &(pObj->m_supersedes), moldObject );
	}
	return HS_OK;
}

/* ASNH245GenericParameter IncludeOptionalField */
HS_RESULT ASNH245GenericParameter_IncludeOptionField( void *pObject, ASNH245GenericParameterOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245GenericParameter *pObj = (ASNH245GenericParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericParameter_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245GenericParameterOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245GenericParameter IsIncludeOptionalField */
BOOL ASNH245GenericParameter_IsIncludeOptionField( void *pObject, ASNH245GenericParameterOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245GenericParameter *pObj = (ASNH245GenericParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericParameter_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245GenericParameterOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245GenericParameter Encode */
HS_RESULT ASNH245GenericParameter_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245GenericParameter *pObj = (ASNH245GenericParameter *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericParameter_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245GenericParameterOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245GenericParameterOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245ParameterIdentifier_Encode( &(pObj->m_parameterIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericParameter_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245ParameterValue_Encode( &(pObj->m_parameterValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericParameter_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245GenericParameter_IsIncludeOptionField( pObj, e_ASNH245GenericParameterOptionMap_supersedes ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_supersedes),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericParameter_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245GenericParameter Decode */
HS_RESULT ASNH245GenericParameter_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245GenericParameter *pObj = (ASNH245GenericParameter *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericParameter_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245GenericParameterOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245GenericParameterOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245ParameterIdentifier_Decode(&(pObj->m_parameterIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericParameter_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245ParameterValue_Decode(&(pObj->m_parameterValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericParameter_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245GenericParameter_IsIncludeOptionField( pObj, e_ASNH245GenericParameterOptionMap_supersedes ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_supersedes),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericParameter_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245GenericParameter Print */
HS_RESULT ASNH245GenericParameter_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245GenericParameter *pObj = (ASNH245GenericParameter *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245GenericParameter_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245ParameterIdentifier_Print( &(pObj->m_parameterIdentifier), pDepth+1, "parameterIdentifier" );
	ASNH245ParameterValue_Print( &(pObj->m_parameterValue), pDepth+1, "parameterValue" );
	if( ASNH245GenericParameter_IsIncludeOptionField( pObj, e_ASNH245GenericParameterOptionMap_supersedes ) )
		AsnSequenceOf_Print( &(pObj->m_supersedes), pDepth+1, "supersedes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245GenericCapability Class
*/
/*ASNH245GenericCapability Constructor*/
HS_RESULT new_ASNH245GenericCapability(void *pObject)
{
	ASNH245GenericCapability *pObj = (ASNH245GenericCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245GenericCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245CapabilityIdentifier( &(pObj->m_capabilityIdentifier) );
	new_AsnInteger( &(pObj->m_maxBitRate), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_collapsing), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_nonCollapsing), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_nonCollapsingRaw), e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245DataProtocolCapability( &(pObj->m_transport) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245GenericCapability Destructor */
HS_RESULT delete_ASNH245GenericCapability(void *pObject)
{
	ASNH245GenericCapability *pObj = (ASNH245GenericCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245GenericCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245CapabilityIdentifier( &(pObj->m_capabilityIdentifier) );
	delete_AsnInteger( &(pObj->m_maxBitRate) );
	delete_AsnSequenceOf( &(pObj->m_collapsing) );
	delete_AsnSequenceOf( &(pObj->m_nonCollapsing) );
	delete_AsnOctetString( &(pObj->m_nonCollapsingRaw) );
	delete_ASNH245DataProtocolCapability( &(pObj->m_transport) );
	return HS_OK;
}

/* ASNH245GenericCapability MakeMold */
HS_RESULT ASNH245GenericCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245GenericCapability *pObj = (ASNH245GenericCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245CapabilityIdentifier_MakeMold(&(pObj->m_capabilityIdentifier));
	{
	ASNH245GenericParameter *tmold_collapsing = (ASNH245GenericParameter *)HSMalloc( sizeof(ASNH245GenericParameter) );
	new_ASNH245GenericParameter(tmold_collapsing);
	ASNH245GenericParameter_MakeMold(tmold_collapsing);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_collapsing,sizeof(ASNH245GenericParameter),ASNH245GenericParameter_MakeMold,ASNH245GenericParameter_Encode,ASNH245GenericParameter_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245GenericParameter_Print,
#endif
		delete_ASNH245GenericParameter);
	AsnSequenceOf_SetMold( &(pObj->m_collapsing), moldObject );
	}
	{
	ASNH245GenericParameter *tmold_nonCollapsing = (ASNH245GenericParameter *)HSMalloc( sizeof(ASNH245GenericParameter) );
	new_ASNH245GenericParameter(tmold_nonCollapsing);
	ASNH245GenericParameter_MakeMold(tmold_nonCollapsing);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_nonCollapsing,sizeof(ASNH245GenericParameter),ASNH245GenericParameter_MakeMold,ASNH245GenericParameter_Encode,ASNH245GenericParameter_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245GenericParameter_Print,
#endif
		delete_ASNH245GenericParameter);
	AsnSequenceOf_SetMold( &(pObj->m_nonCollapsing), moldObject );
	}
	ASNH245DataProtocolCapability_MakeMold(&(pObj->m_transport));
	return HS_OK;
}

/* ASNH245GenericCapability IncludeOptionalField */
HS_RESULT ASNH245GenericCapability_IncludeOptionField( void *pObject, ASNH245GenericCapabilityOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245GenericCapability *pObj = (ASNH245GenericCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245GenericCapabilityOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245GenericCapability IsIncludeOptionalField */
BOOL ASNH245GenericCapability_IsIncludeOptionField( void *pObject, ASNH245GenericCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245GenericCapability *pObj = (ASNH245GenericCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245GenericCapabilityOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245GenericCapability Encode */
HS_RESULT ASNH245GenericCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245GenericCapability *pObj = (ASNH245GenericCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245GenericCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245GenericCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245CapabilityIdentifier_Encode( &(pObj->m_capabilityIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_maxBitRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_maxBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_collapsing ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_collapsing),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_nonCollapsing ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_nonCollapsing),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_nonCollapsingRaw ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_nonCollapsingRaw),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_transport ) ){
		if( (tRet=ASNH245DataProtocolCapability_Encode( &(pObj->m_transport),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245GenericCapability Decode */
HS_RESULT ASNH245GenericCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245GenericCapability *pObj = (ASNH245GenericCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245GenericCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245GenericCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245CapabilityIdentifier_Decode(&(pObj->m_capabilityIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245GenericCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_maxBitRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_maxBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_collapsing ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_collapsing),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_nonCollapsing ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_nonCollapsing),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_nonCollapsingRaw ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_nonCollapsingRaw),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_transport ) ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(&(pObj->m_transport),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245GenericCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245GenericCapability Print */
HS_RESULT ASNH245GenericCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245GenericCapability *pObj = (ASNH245GenericCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245GenericCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245CapabilityIdentifier_Print( &(pObj->m_capabilityIdentifier), pDepth+1, "capabilityIdentifier" );
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_maxBitRate ) )
		AsnInteger_Print( &(pObj->m_maxBitRate), pDepth+1, "maxBitRate" );
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_collapsing ) )
		AsnSequenceOf_Print( &(pObj->m_collapsing), pDepth+1, "collapsing" );
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_nonCollapsing ) )
		AsnSequenceOf_Print( &(pObj->m_nonCollapsing), pDepth+1, "nonCollapsing" );
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_nonCollapsingRaw ) )
		AsnOctetString_Print( &(pObj->m_nonCollapsingRaw), pDepth+1, "nonCollapsingRaw" );
	if( ASNH245GenericCapability_IsIncludeOptionField( pObj, e_ASNH245GenericCapabilityOptionMap_transport ) )
		ASNH245DataProtocolCapability_Print( &(pObj->m_transport), pDepth+1, "transport" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataApplicationCapability_application Struct
*/
/* ASNH245DataApplicationCapability_application Constructor */
HS_RESULT new_ASNH245DataApplicationCapability_application( void *pObject )
{
	ASNH245DataApplicationCapability_application *pObj = (ASNH245DataApplicationCapability_application *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataApplicationCapability_application(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245DataApplicationCapability_applicationChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245DataApplicationCapability_applicationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245DataApplicationCapability_application Destructor */
HS_RESULT delete_ASNH245DataApplicationCapability_application( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245DataApplicationCapability_application *pObj = (ASNH245DataApplicationCapability_application *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataApplicationCapability_application(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245DataApplicationCapability_application_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataApplicationCapability_application(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245DataApplicationCapability_application SetChoice */
void* ASNH245DataApplicationCapability_application_SetChoice( void *pObject, ASNH245DataApplicationCapability_applicationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245DataApplicationCapability_application *pObj = (ASNH245DataApplicationCapability_application *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245DataApplicationCapability_applicationChoiceSizeExt ){
		if( pChoice > (ASNH245DataApplicationCapability_applicationChoice)(e_ASNH245DataApplicationCapability_applicationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245DataApplicationCapability_application_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_t120 ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_dsm_cc ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_userData ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_t84 ){
		ASNH245DataApplicationCapability_application_t84 *tAlter = (ASNH245DataApplicationCapability_application_t84 *)HSMalloc( sizeof(ASNH245DataApplicationCapability_application_t84) );
		new_ASNH245DataApplicationCapability_application_t84(tAlter);
		ASNH245DataApplicationCapability_application_t84_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_t434 ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_h224 ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_nlpid ){
		ASNH245DataApplicationCapability_application_nlpid *tAlter = (ASNH245DataApplicationCapability_application_nlpid *)HSMalloc( sizeof(ASNH245DataApplicationCapability_application_nlpid) );
		new_ASNH245DataApplicationCapability_application_nlpid(tAlter);
		ASNH245DataApplicationCapability_application_nlpid_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_dsvdControl ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_h222DataPartitioning ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_t30fax ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_t140 ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_t38fax ){
		ASNH245DataApplicationCapability_application_t38fax *tAlter = (ASNH245DataApplicationCapability_application_t38fax *)HSMalloc( sizeof(ASNH245DataApplicationCapability_application_t38fax) );
		new_ASNH245DataApplicationCapability_application_t38fax(tAlter);
		ASNH245DataApplicationCapability_application_t38fax_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataApplicationCapability_applicationChoice_genericDataCapability ){
		ASNH245GenericCapability *tAlter = (ASNH245GenericCapability *)HSMalloc( sizeof(ASNH245GenericCapability) );
		new_ASNH245GenericCapability(tAlter);
		ASNH245GenericCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245DataApplicationCapability_application DeleteAlternation */
HS_RESULT ASNH245DataApplicationCapability_application_DeleteAlternation(void *pObject)
{
	ASNH245DataApplicationCapability_application *pObj = (ASNH245DataApplicationCapability_application *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t120 ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_dsm_cc ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_userData ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t84 ){
			delete_ASNH245DataApplicationCapability_application_t84(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t434 ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_h224 ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_nlpid ){
			delete_ASNH245DataApplicationCapability_application_nlpid(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_dsvdControl ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_h222DataPartitioning ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t30fax ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t140 ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t38fax ){
			delete_ASNH245DataApplicationCapability_application_t38fax(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_genericDataCapability ){
			delete_ASNH245GenericCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245DataApplicationCapability_application_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245DataApplicationCapability_application Encode */
HS_RESULT ASNH245DataApplicationCapability_application_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245DataApplicationCapability_application *pObj = (ASNH245DataApplicationCapability_application *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245DataApplicationCapability_applicationChoiceSize )
		{
			if( pObj->choice > ((ASNH245DataApplicationCapability_applicationChoice)(e_ASNH245DataApplicationCapability_applicationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245DataApplicationCapability_applicationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245DataApplicationCapability_applicationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t120 ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_dsm_cc ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_userData ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t84 ){
		if( (tRet=ASNH245DataApplicationCapability_application_t84_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t434 ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_h224 ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_nlpid ){
		if( (tRet=ASNH245DataApplicationCapability_application_nlpid_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_dsvdControl ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_h222DataPartitioning ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t30fax ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245DataProtocolCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t140 ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245DataProtocolCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t38fax ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245DataApplicationCapability_application_t38fax_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_genericDataCapability ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245GenericCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245DataApplicationCapability_application Decode */
HS_RESULT ASNH245DataApplicationCapability_application_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245DataApplicationCapability_application *pObj = (ASNH245DataApplicationCapability_application *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245DataApplicationCapability_applicationChoiceSize;
	}
	else
	{
		if( e_ASNH245DataApplicationCapability_applicationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245DataApplicationCapability_applicationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245DataApplicationCapability_applicationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245DataApplicationCapability_application_SetChoice( pObj, (ASNH245DataApplicationCapability_applicationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t120 ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_dsm_cc ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_userData ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t84 ){
		if( (tRet=ASNH245DataApplicationCapability_application_t84_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t434 ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_h224 ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_nlpid ){
		if( (tRet=ASNH245DataApplicationCapability_application_nlpid_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_dsvdControl ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_h222DataPartitioning ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t30fax ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245DataProtocolCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t140 ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245DataProtocolCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t38fax ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245DataApplicationCapability_application_t38fax_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_genericDataCapability ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245GenericCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataApplicationCapability_application Print */
HS_RESULT ASNH245DataApplicationCapability_application_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataApplicationCapability_application *pObj = (ASNH245DataApplicationCapability_application *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataApplicationCapability_application_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t120 ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "t120" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_dsm_cc ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "dsm_cc" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_userData ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "userData" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t84 ){
		ASNH245DataApplicationCapability_application_t84_Print( pObj->alter, pDepth+1, "t84" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t434 ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "t434" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_h224 ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "h224" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_nlpid ){
		ASNH245DataApplicationCapability_application_nlpid_Print( pObj->alter, pDepth+1, "nlpid" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_dsvdControl ){
		AsnNull_Print( pObj->alter, pDepth+1, "dsvdControl" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_h222DataPartitioning ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "h222DataPartitioning" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t30fax ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "t30fax" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t140 ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "t140" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_t38fax ){
		ASNH245DataApplicationCapability_application_t38fax_Print( pObj->alter, pDepth+1, "t38fax" );
	}
	else if ( pObj->choice == e_ASNH245DataApplicationCapability_applicationChoice_genericDataCapability ){
		ASNH245GenericCapability_Print( pObj->alter, pDepth+1, "genericDataCapability" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataApplicationCapability Class
*/
/*ASNH245DataApplicationCapability Constructor*/
HS_RESULT new_ASNH245DataApplicationCapability(void *pObject)
{
	ASNH245DataApplicationCapability *pObj = (ASNH245DataApplicationCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataApplicationCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245DataApplicationCapability_application( &(pObj->m_application) );
	new_AsnInteger( &(pObj->m_maxBitRate), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245DataApplicationCapability Destructor */
HS_RESULT delete_ASNH245DataApplicationCapability(void *pObject)
{
	ASNH245DataApplicationCapability *pObj = (ASNH245DataApplicationCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataApplicationCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245DataApplicationCapability_application( &(pObj->m_application) );
	delete_AsnInteger( &(pObj->m_maxBitRate) );
	return HS_OK;
}

/* ASNH245DataApplicationCapability MakeMold */
HS_RESULT ASNH245DataApplicationCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245DataApplicationCapability *pObj = (ASNH245DataApplicationCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245DataApplicationCapability Encode */
HS_RESULT ASNH245DataApplicationCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataApplicationCapability *pObj = (ASNH245DataApplicationCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245DataApplicationCapability_application_Encode( &(pObj->m_application),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maxBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245DataApplicationCapability Decode */
HS_RESULT ASNH245DataApplicationCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataApplicationCapability *pObj = (ASNH245DataApplicationCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245DataApplicationCapability_application_Decode(&(pObj->m_application),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataApplicationCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataApplicationCapability Print */
HS_RESULT ASNH245DataApplicationCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataApplicationCapability *pObj = (ASNH245DataApplicationCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataApplicationCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245DataApplicationCapability_application_Print( &(pObj->m_application), pDepth+1, "application" );
	AsnInteger_Print( &(pObj->m_maxBitRate), pDepth+1, "maxBitRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MediaDistributionCapability Class
*/
/*ASNH245MediaDistributionCapability Constructor*/
HS_RESULT new_ASNH245MediaDistributionCapability(void *pObject)
{
	ASNH245MediaDistributionCapability *pObj = (ASNH245MediaDistributionCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MediaDistributionCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_centralizedControl) );
	new_AsnBoolean( &(pObj->m_distributedControl) );
	new_AsnBoolean( &(pObj->m_centralizedAudio) );
	new_AsnBoolean( &(pObj->m_distributedAudio) );
	new_AsnBoolean( &(pObj->m_centralizedVideo) );
	new_AsnBoolean( &(pObj->m_distributedVideo) );
	new_AsnSequenceOf( &(pObj->m_centralizedData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_distributedData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245MediaDistributionCapability Destructor */
HS_RESULT delete_ASNH245MediaDistributionCapability(void *pObject)
{
	ASNH245MediaDistributionCapability *pObj = (ASNH245MediaDistributionCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MediaDistributionCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_centralizedControl) );
	delete_AsnBoolean( &(pObj->m_distributedControl) );
	delete_AsnBoolean( &(pObj->m_centralizedAudio) );
	delete_AsnBoolean( &(pObj->m_distributedAudio) );
	delete_AsnBoolean( &(pObj->m_centralizedVideo) );
	delete_AsnBoolean( &(pObj->m_distributedVideo) );
	delete_AsnSequenceOf( &(pObj->m_centralizedData) );
	delete_AsnSequenceOf( &(pObj->m_distributedData) );
	return HS_OK;
}

/* ASNH245MediaDistributionCapability MakeMold */
HS_RESULT ASNH245MediaDistributionCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MediaDistributionCapability *pObj = (ASNH245MediaDistributionCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245DataApplicationCapability *tmold_centralizedData = (ASNH245DataApplicationCapability *)HSMalloc( sizeof(ASNH245DataApplicationCapability) );
	new_ASNH245DataApplicationCapability(tmold_centralizedData);
	ASNH245DataApplicationCapability_MakeMold(tmold_centralizedData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_centralizedData,sizeof(ASNH245DataApplicationCapability),ASNH245DataApplicationCapability_MakeMold,ASNH245DataApplicationCapability_Encode,ASNH245DataApplicationCapability_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245DataApplicationCapability_Print,
#endif
		delete_ASNH245DataApplicationCapability);
	AsnSequenceOf_SetMold( &(pObj->m_centralizedData), moldObject );
	}
	{
	ASNH245DataApplicationCapability *tmold_distributedData = (ASNH245DataApplicationCapability *)HSMalloc( sizeof(ASNH245DataApplicationCapability) );
	new_ASNH245DataApplicationCapability(tmold_distributedData);
	ASNH245DataApplicationCapability_MakeMold(tmold_distributedData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_distributedData,sizeof(ASNH245DataApplicationCapability),ASNH245DataApplicationCapability_MakeMold,ASNH245DataApplicationCapability_Encode,ASNH245DataApplicationCapability_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245DataApplicationCapability_Print,
#endif
		delete_ASNH245DataApplicationCapability);
	AsnSequenceOf_SetMold( &(pObj->m_distributedData), moldObject );
	}
	return HS_OK;
}

/* ASNH245MediaDistributionCapability IncludeOptionalField */
HS_RESULT ASNH245MediaDistributionCapability_IncludeOptionField( void *pObject, ASNH245MediaDistributionCapabilityOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245MediaDistributionCapability *pObj = (ASNH245MediaDistributionCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245MediaDistributionCapabilityOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245MediaDistributionCapability IsIncludeOptionalField */
BOOL ASNH245MediaDistributionCapability_IsIncludeOptionField( void *pObject, ASNH245MediaDistributionCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245MediaDistributionCapability *pObj = (ASNH245MediaDistributionCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245MediaDistributionCapabilityOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245MediaDistributionCapability Encode */
HS_RESULT ASNH245MediaDistributionCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245MediaDistributionCapability *pObj = (ASNH245MediaDistributionCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245MediaDistributionCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245MediaDistributionCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Encode( &(pObj->m_centralizedControl),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_distributedControl),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_centralizedAudio),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_distributedAudio),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_centralizedVideo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_distributedVideo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245MediaDistributionCapability_IsIncludeOptionField( pObj, e_ASNH245MediaDistributionCapabilityOptionMap_centralizedData ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_centralizedData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaDistributionCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245MediaDistributionCapability_IsIncludeOptionField( pObj, e_ASNH245MediaDistributionCapabilityOptionMap_distributedData ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_distributedData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaDistributionCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245MediaDistributionCapability Decode */
HS_RESULT ASNH245MediaDistributionCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245MediaDistributionCapability *pObj = (ASNH245MediaDistributionCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245MediaDistributionCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245MediaDistributionCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_centralizedControl),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_distributedControl),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_centralizedAudio),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_distributedAudio),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_centralizedVideo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_distributedVideo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245MediaDistributionCapability_IsIncludeOptionField( pObj, e_ASNH245MediaDistributionCapabilityOptionMap_centralizedData ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_centralizedData),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaDistributionCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245MediaDistributionCapability_IsIncludeOptionField( pObj, e_ASNH245MediaDistributionCapabilityOptionMap_distributedData ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_distributedData),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaDistributionCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MediaDistributionCapability Print */
HS_RESULT ASNH245MediaDistributionCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MediaDistributionCapability *pObj = (ASNH245MediaDistributionCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MediaDistributionCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_centralizedControl), pDepth+1, "centralizedControl" );
	AsnBoolean_Print( &(pObj->m_distributedControl), pDepth+1, "distributedControl" );
	AsnBoolean_Print( &(pObj->m_centralizedAudio), pDepth+1, "centralizedAudio" );
	AsnBoolean_Print( &(pObj->m_distributedAudio), pDepth+1, "distributedAudio" );
	AsnBoolean_Print( &(pObj->m_centralizedVideo), pDepth+1, "centralizedVideo" );
	AsnBoolean_Print( &(pObj->m_distributedVideo), pDepth+1, "distributedVideo" );
	if( ASNH245MediaDistributionCapability_IsIncludeOptionField( pObj, e_ASNH245MediaDistributionCapabilityOptionMap_centralizedData ) )
		AsnSequenceOf_Print( &(pObj->m_centralizedData), pDepth+1, "centralizedData" );
	if( ASNH245MediaDistributionCapability_IsIncludeOptionField( pObj, e_ASNH245MediaDistributionCapabilityOptionMap_distributedData ) )
		AsnSequenceOf_Print( &(pObj->m_distributedData), pDepth+1, "distributedData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultipointCapability Class
*/
/*ASNH245MultipointCapability Constructor*/
HS_RESULT new_ASNH245MultipointCapability(void *pObject)
{
	ASNH245MultipointCapability *pObj = (ASNH245MultipointCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultipointCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_multicastCapability) );
	new_AsnBoolean( &(pObj->m_multiUniCastConference) );
	new_AsnSequenceOf( &(pObj->m_mediaDistributionCapability), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MultipointCapability Destructor */
HS_RESULT delete_ASNH245MultipointCapability(void *pObject)
{
	ASNH245MultipointCapability *pObj = (ASNH245MultipointCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultipointCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_multicastCapability) );
	delete_AsnBoolean( &(pObj->m_multiUniCastConference) );
	delete_AsnSequenceOf( &(pObj->m_mediaDistributionCapability) );
	return HS_OK;
}

/* ASNH245MultipointCapability MakeMold */
HS_RESULT ASNH245MultipointCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultipointCapability *pObj = (ASNH245MultipointCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultipointCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245MediaDistributionCapability *tmold_mediaDistributionCapability = (ASNH245MediaDistributionCapability *)HSMalloc( sizeof(ASNH245MediaDistributionCapability) );
	new_ASNH245MediaDistributionCapability(tmold_mediaDistributionCapability);
	ASNH245MediaDistributionCapability_MakeMold(tmold_mediaDistributionCapability);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_mediaDistributionCapability,sizeof(ASNH245MediaDistributionCapability),ASNH245MediaDistributionCapability_MakeMold,ASNH245MediaDistributionCapability_Encode,ASNH245MediaDistributionCapability_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MediaDistributionCapability_Print,
#endif
		delete_ASNH245MediaDistributionCapability);
	AsnSequenceOf_SetMold( &(pObj->m_mediaDistributionCapability), moldObject );
	}
	return HS_OK;
}

/* ASNH245MultipointCapability Encode */
HS_RESULT ASNH245MultipointCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultipointCapability *pObj = (ASNH245MultipointCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultipointCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_multicastCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultipointCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_multiUniCastConference),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultipointCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_mediaDistributionCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultipointCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultipointCapability Decode */
HS_RESULT ASNH245MultipointCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultipointCapability *pObj = (ASNH245MultipointCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultipointCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_multicastCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultipointCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_multiUniCastConference),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultipointCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_mediaDistributionCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultipointCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultipointCapability Print */
HS_RESULT ASNH245MultipointCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultipointCapability *pObj = (ASNH245MultipointCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultipointCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_multicastCapability), pDepth+1, "multicastCapability" );
	AsnBoolean_Print( &(pObj->m_multiUniCastConference), pDepth+1, "multiUniCastConference" );
	AsnSequenceOf_Print( &(pObj->m_mediaDistributionCapability), pDepth+1, "mediaDistributionCapability" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H2250Capability_mcCapability Class
*/
/*ASNH245H2250Capability_mcCapability Constructor*/
HS_RESULT new_ASNH245H2250Capability_mcCapability(void *pObject)
{
	ASNH245H2250Capability_mcCapability *pObj = (ASNH245H2250Capability_mcCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H2250Capability_mcCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_centralizedConferenceMC) );
	new_AsnBoolean( &(pObj->m_decentralizedConferenceMC) );

	return HS_OK;
}

/* ASNH245H2250Capability_mcCapability Destructor */
HS_RESULT delete_ASNH245H2250Capability_mcCapability(void *pObject)
{
	ASNH245H2250Capability_mcCapability *pObj = (ASNH245H2250Capability_mcCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H2250Capability_mcCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_centralizedConferenceMC) );
	delete_AsnBoolean( &(pObj->m_decentralizedConferenceMC) );
	return HS_OK;
}

/* ASNH245H2250Capability_mcCapability MakeMold */
HS_RESULT ASNH245H2250Capability_mcCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H2250Capability_mcCapability *pObj = (ASNH245H2250Capability_mcCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_mcCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H2250Capability_mcCapability Encode */
HS_RESULT ASNH245H2250Capability_mcCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H2250Capability_mcCapability *pObj = (ASNH245H2250Capability_mcCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_mcCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_centralizedConferenceMC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_mcCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_decentralizedConferenceMC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_mcCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H2250Capability_mcCapability Decode */
HS_RESULT ASNH245H2250Capability_mcCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H2250Capability_mcCapability *pObj = (ASNH245H2250Capability_mcCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_mcCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_centralizedConferenceMC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_mcCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_decentralizedConferenceMC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_mcCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H2250Capability_mcCapability Print */
HS_RESULT ASNH245H2250Capability_mcCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H2250Capability_mcCapability *pObj = (ASNH245H2250Capability_mcCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H2250Capability_mcCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_centralizedConferenceMC), pDepth+1, "centralizedConferenceMC" );
	AsnBoolean_Print( &(pObj->m_decentralizedConferenceMC), pDepth+1, "decentralizedConferenceMC" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RTPPayloadType_payloadDescriptor Struct
*/
/* ASNH245RTPPayloadType_payloadDescriptor Constructor */
HS_RESULT new_ASNH245RTPPayloadType_payloadDescriptor( void *pObject )
{
	ASNH245RTPPayloadType_payloadDescriptor *pObj = (ASNH245RTPPayloadType_payloadDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RTPPayloadType_payloadDescriptor(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RTPPayloadType_payloadDescriptorChoice_nonStandardIdentifier;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RTPPayloadType_payloadDescriptorChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RTPPayloadType_payloadDescriptor Destructor */
HS_RESULT delete_ASNH245RTPPayloadType_payloadDescriptor( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RTPPayloadType_payloadDescriptor *pObj = (ASNH245RTPPayloadType_payloadDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RTPPayloadType_payloadDescriptor(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RTPPayloadType_payloadDescriptor_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RTPPayloadType_payloadDescriptor(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RTPPayloadType_payloadDescriptor SetChoice */
void* ASNH245RTPPayloadType_payloadDescriptor_SetChoice( void *pObject, ASNH245RTPPayloadType_payloadDescriptorChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RTPPayloadType_payloadDescriptor *pObj = (ASNH245RTPPayloadType_payloadDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RTPPayloadType_payloadDescriptorChoiceSizeExt ){
		if( pChoice > (ASNH245RTPPayloadType_payloadDescriptorChoice)(e_ASNH245RTPPayloadType_payloadDescriptorChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RTPPayloadType_payloadDescriptor_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_nonStandardIdentifier ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_rfc_number ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrainedExt,1,32768,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_oid ){
		AsnObjectIdentifier *tAlter = (AsnObjectIdentifier *)HSMalloc( sizeof(AsnObjectIdentifier) );
		new_AsnObjectIdentifier(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RTPPayloadType_payloadDescriptor DeleteAlternation */
HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_DeleteAlternation(void *pObject)
{
	ASNH245RTPPayloadType_payloadDescriptor *pObj = (ASNH245RTPPayloadType_payloadDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_nonStandardIdentifier ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_rfc_number ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_oid ){
			delete_AsnObjectIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RTPPayloadType_payloadDescriptor Encode */
HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RTPPayloadType_payloadDescriptor *pObj = (ASNH245RTPPayloadType_payloadDescriptor *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RTPPayloadType_payloadDescriptorChoiceSize )
		{
			if( pObj->choice > ((ASNH245RTPPayloadType_payloadDescriptorChoice)(e_ASNH245RTPPayloadType_payloadDescriptorChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RTPPayloadType_payloadDescriptorChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RTPPayloadType_payloadDescriptorChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_nonStandardIdentifier ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_rfc_number ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_oid ){
		if( (tRet=AsnObjectIdentifier_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RTPPayloadType_payloadDescriptor Decode */
HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RTPPayloadType_payloadDescriptor *pObj = (ASNH245RTPPayloadType_payloadDescriptor *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RTPPayloadType_payloadDescriptorChoiceSize;
	}
	else
	{
		if( e_ASNH245RTPPayloadType_payloadDescriptorChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RTPPayloadType_payloadDescriptorChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RTPPayloadType_payloadDescriptorChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RTPPayloadType_payloadDescriptor_SetChoice( pObj, (ASNH245RTPPayloadType_payloadDescriptorChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_nonStandardIdentifier ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_rfc_number ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_oid ){
		if( (tRet=AsnObjectIdentifier_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RTPPayloadType_payloadDescriptor Print */
HS_RESULT ASNH245RTPPayloadType_payloadDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RTPPayloadType_payloadDescriptor *pObj = (ASNH245RTPPayloadType_payloadDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RTPPayloadType_payloadDescriptor_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_nonStandardIdentifier ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandardIdentifier" );
	}
	else if ( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_rfc_number ){
		AsnInteger_Print( pObj->alter, pDepth+1, "rfc_number" );
	}
	else if ( pObj->choice == e_ASNH245RTPPayloadType_payloadDescriptorChoice_oid ){
		AsnObjectIdentifier_Print( pObj->alter, pDepth+1, "oid" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RTPPayloadType Class
*/
/*ASNH245RTPPayloadType Constructor*/
HS_RESULT new_ASNH245RTPPayloadType(void *pObject)
{
	ASNH245RTPPayloadType *pObj = (ASNH245RTPPayloadType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RTPPayloadType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245RTPPayloadType_payloadDescriptor( &(pObj->m_payloadDescriptor) );
	new_AsnInteger( &(pObj->m_payloadType), e_constrained, 0, 127, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245RTPPayloadType Destructor */
HS_RESULT delete_ASNH245RTPPayloadType(void *pObject)
{
	ASNH245RTPPayloadType *pObj = (ASNH245RTPPayloadType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RTPPayloadType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245RTPPayloadType_payloadDescriptor( &(pObj->m_payloadDescriptor) );
	delete_AsnInteger( &(pObj->m_payloadType) );
	return HS_OK;
}

/* ASNH245RTPPayloadType MakeMold */
HS_RESULT ASNH245RTPPayloadType_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RTPPayloadType *pObj = (ASNH245RTPPayloadType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245RTPPayloadType IncludeOptionalField */
HS_RESULT ASNH245RTPPayloadType_IncludeOptionField( void *pObject, ASNH245RTPPayloadTypeOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245RTPPayloadType *pObj = (ASNH245RTPPayloadType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245RTPPayloadTypeOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245RTPPayloadType IsIncludeOptionalField */
BOOL ASNH245RTPPayloadType_IsIncludeOptionField( void *pObject, ASNH245RTPPayloadTypeOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245RTPPayloadType *pObj = (ASNH245RTPPayloadType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245RTPPayloadTypeOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245RTPPayloadType Encode */
HS_RESULT ASNH245RTPPayloadType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RTPPayloadType *pObj = (ASNH245RTPPayloadType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245RTPPayloadTypeOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245RTPPayloadTypeOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245RTPPayloadType_payloadDescriptor_Encode( &(pObj->m_payloadDescriptor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245RTPPayloadType_IsIncludeOptionField( pObj, e_ASNH245RTPPayloadTypeOptionMap_payloadType ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_payloadType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245RTPPayloadType Decode */
HS_RESULT ASNH245RTPPayloadType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RTPPayloadType *pObj = (ASNH245RTPPayloadType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245RTPPayloadTypeOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245RTPPayloadTypeOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245RTPPayloadType_payloadDescriptor_Decode(&(pObj->m_payloadDescriptor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPPayloadType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245RTPPayloadType_IsIncludeOptionField( pObj, e_ASNH245RTPPayloadTypeOptionMap_payloadType ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_payloadType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPPayloadType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RTPPayloadType Print */
HS_RESULT ASNH245RTPPayloadType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RTPPayloadType *pObj = (ASNH245RTPPayloadType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RTPPayloadType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245RTPPayloadType_payloadDescriptor_Print( &(pObj->m_payloadDescriptor), pDepth+1, "payloadDescriptor" );
	if( ASNH245RTPPayloadType_IsIncludeOptionField( pObj, e_ASNH245RTPPayloadTypeOptionMap_payloadType ) )
		AsnInteger_Print( &(pObj->m_payloadType), pDepth+1, "payloadType" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MediaPacketizationCapability Class
*/
/*ASNH245MediaPacketizationCapability Constructor*/
HS_RESULT new_ASNH245MediaPacketizationCapability(void *pObject)
{
	ASNH245MediaPacketizationCapability *pObj = (ASNH245MediaPacketizationCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MediaPacketizationCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_h261aVideoPacketization) );
	new_AsnSequenceOf( &(pObj->m_rtpPayloadType), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245MediaPacketizationCapability Destructor */
HS_RESULT delete_ASNH245MediaPacketizationCapability(void *pObject)
{
	ASNH245MediaPacketizationCapability *pObj = (ASNH245MediaPacketizationCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MediaPacketizationCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_h261aVideoPacketization) );
	delete_AsnSequenceOf( &(pObj->m_rtpPayloadType) );
	return HS_OK;
}

/* ASNH245MediaPacketizationCapability MakeMold */
HS_RESULT ASNH245MediaPacketizationCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MediaPacketizationCapability *pObj = (ASNH245MediaPacketizationCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaPacketizationCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245RTPPayloadType *tmold_rtpPayloadType = (ASNH245RTPPayloadType *)HSMalloc( sizeof(ASNH245RTPPayloadType) );
	new_ASNH245RTPPayloadType(tmold_rtpPayloadType);
	ASNH245RTPPayloadType_MakeMold(tmold_rtpPayloadType);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_rtpPayloadType,sizeof(ASNH245RTPPayloadType),ASNH245RTPPayloadType_MakeMold,ASNH245RTPPayloadType_Encode,ASNH245RTPPayloadType_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245RTPPayloadType_Print,
#endif
		delete_ASNH245RTPPayloadType);
	AsnSequenceOf_SetMold( &(pObj->m_rtpPayloadType), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_rtpPayloadType.constraint.type = e_constrained;
	pObj->m_rtpPayloadType.constraint.minValue = 1;
	pObj->m_rtpPayloadType.constraint.maxValue = 256;
	pObj->m_rtpPayloadType.extMinValue = 0;
	pObj->m_rtpPayloadType.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245MediaPacketizationCapability IncludeOptionalField */
HS_RESULT ASNH245MediaPacketizationCapability_IncludeOptionField( void *pObject, ASNH245MediaPacketizationCapabilityOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245MediaPacketizationCapability *pObj = (ASNH245MediaPacketizationCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaPacketizationCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245MediaPacketizationCapabilityOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245MediaPacketizationCapabilityOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245MediaPacketizationCapability IsIncludeOptionalField */
BOOL ASNH245MediaPacketizationCapability_IsIncludeOptionField( void *pObject, ASNH245MediaPacketizationCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245MediaPacketizationCapability *pObj = (ASNH245MediaPacketizationCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaPacketizationCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245MediaPacketizationCapabilityOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245MediaPacketizationCapabilityOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245MediaPacketizationCapability Encode */
HS_RESULT ASNH245MediaPacketizationCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MediaPacketizationCapability *pObj = (ASNH245MediaPacketizationCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaPacketizationCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_h261aVideoPacketization),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaPacketizationCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245MediaPacketizationCapability_IsIncludeOptionField( pObj, e_ASNH245MediaPacketizationCapabilityOptionMap_rtpPayloadType ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_rtpPayloadType), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245MediaPacketizationCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245MediaPacketizationCapability Decode */
HS_RESULT ASNH245MediaPacketizationCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MediaPacketizationCapability *pObj = (ASNH245MediaPacketizationCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaPacketizationCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_h261aVideoPacketization),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaPacketizationCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245MediaPacketizationCapability_IsIncludeOptionField( pObj, e_ASNH245MediaPacketizationCapabilityOptionMap_rtpPayloadType ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_rtpPayloadType), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaPacketizationCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MediaPacketizationCapability Print */
HS_RESULT ASNH245MediaPacketizationCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MediaPacketizationCapability *pObj = (ASNH245MediaPacketizationCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MediaPacketizationCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_h261aVideoPacketization), pDepth+1, "h261aVideoPacketization" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245MediaPacketizationCapability_IsIncludeOptionField( pObj, e_ASNH245MediaPacketizationCapabilityOptionMap_rtpPayloadType ) )
		AsnSequenceOf_Print( &(pObj->m_rtpPayloadType), pDepth+1, "rtpPayloadType" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245QOSMode Struct
*/
/* ASNH245QOSMode Constructor */
HS_RESULT new_ASNH245QOSMode( void *pObject )
{
	ASNH245QOSMode *pObj = (ASNH245QOSMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245QOSMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245QOSModeChoice_guaranteedQOS;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245QOSModeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245QOSMode Destructor */
HS_RESULT delete_ASNH245QOSMode( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245QOSMode *pObj = (ASNH245QOSMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245QOSMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245QOSMode_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245QOSMode(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245QOSMode SetChoice */
void* ASNH245QOSMode_SetChoice( void *pObject, ASNH245QOSModeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245QOSMode *pObj = (ASNH245QOSMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSMode_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245QOSModeChoiceSizeExt ){
		if( pChoice > (ASNH245QOSModeChoice)(e_ASNH245QOSModeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSMode_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245QOSMode_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSMode_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245QOSModeChoice_guaranteedQOS ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245QOSModeChoice_controlledLoad ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSMode_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245QOSMode DeleteAlternation */
HS_RESULT ASNH245QOSMode_DeleteAlternation(void *pObject)
{
	ASNH245QOSMode *pObj = (ASNH245QOSMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSMode_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245QOSModeChoice_guaranteedQOS ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245QOSModeChoice_controlledLoad ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSMode_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245QOSMode_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245QOSMode Encode */
HS_RESULT ASNH245QOSMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245QOSMode *pObj = (ASNH245QOSMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSMode_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245QOSModeChoiceSize )
		{
			if( pObj->choice > ((ASNH245QOSModeChoice)(e_ASNH245QOSModeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245QOSModeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245QOSModeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245QOSModeChoice_guaranteedQOS ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245QOSModeChoice_controlledLoad ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSMode_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245QOSMode Decode */
HS_RESULT ASNH245QOSMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245QOSMode *pObj = (ASNH245QOSMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245QOSModeChoiceSize;
	}
	else
	{
		if( e_ASNH245QOSModeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245QOSModeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245QOSModeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSMode_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245QOSMode_SetChoice( pObj, (ASNH245QOSModeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSMode_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245QOSModeChoice_guaranteedQOS ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245QOSModeChoice_controlledLoad ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSMode_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245QOSMode Print */
HS_RESULT ASNH245QOSMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245QOSMode *pObj = (ASNH245QOSMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245QOSMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245QOSModeChoice_guaranteedQOS ){
		AsnNull_Print( pObj->alter, pDepth+1, "guaranteedQOS" );
	}
	else if ( pObj->choice == e_ASNH245QOSModeChoice_controlledLoad ){
		AsnNull_Print( pObj->alter, pDepth+1, "controlledLoad" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RSVPParameters Class
*/
/*ASNH245RSVPParameters Constructor*/
HS_RESULT new_ASNH245RSVPParameters(void *pObject)
{
	ASNH245RSVPParameters *pObj = (ASNH245RSVPParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RSVPParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245QOSMode( &(pObj->m_qosMode) );
	new_AsnInteger( &(pObj->m_tokenRate), e_constrained, 1, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_bucketSize), e_constrained, 1, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_peakRate), e_constrained, 1, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_minPoliced), e_constrained, 1, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maxPktSize), e_constrained, 1, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245RSVPParameters Destructor */
HS_RESULT delete_ASNH245RSVPParameters(void *pObject)
{
	ASNH245RSVPParameters *pObj = (ASNH245RSVPParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RSVPParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245QOSMode( &(pObj->m_qosMode) );
	delete_AsnInteger( &(pObj->m_tokenRate) );
	delete_AsnInteger( &(pObj->m_bucketSize) );
	delete_AsnInteger( &(pObj->m_peakRate) );
	delete_AsnInteger( &(pObj->m_minPoliced) );
	delete_AsnInteger( &(pObj->m_maxPktSize) );
	return HS_OK;
}

/* ASNH245RSVPParameters MakeMold */
HS_RESULT ASNH245RSVPParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RSVPParameters *pObj = (ASNH245RSVPParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RSVPParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245QOSMode_MakeMold(&(pObj->m_qosMode));
	return HS_OK;
}

/* ASNH245RSVPParameters IncludeOptionalField */
HS_RESULT ASNH245RSVPParameters_IncludeOptionField( void *pObject, ASNH245RSVPParametersOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245RSVPParameters *pObj = (ASNH245RSVPParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RSVPParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245RSVPParametersOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245RSVPParameters IsIncludeOptionalField */
BOOL ASNH245RSVPParameters_IsIncludeOptionField( void *pObject, ASNH245RSVPParametersOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245RSVPParameters *pObj = (ASNH245RSVPParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RSVPParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245RSVPParametersOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245RSVPParameters Encode */
HS_RESULT ASNH245RSVPParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RSVPParameters *pObj = (ASNH245RSVPParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RSVPParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245RSVPParametersOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245RSVPParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_qosMode ) ){
		if( (tRet=ASNH245QOSMode_Encode( &(pObj->m_qosMode),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_tokenRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_tokenRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_bucketSize ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_bucketSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_peakRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_peakRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_minPoliced ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_minPoliced),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_maxPktSize ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_maxPktSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245RSVPParameters Decode */
HS_RESULT ASNH245RSVPParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RSVPParameters *pObj = (ASNH245RSVPParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RSVPParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245RSVPParametersOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245RSVPParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_qosMode ) ){
		if( (tRet=ASNH245QOSMode_Decode(&(pObj->m_qosMode),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_tokenRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_tokenRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_bucketSize ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_bucketSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_peakRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_peakRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_minPoliced ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_minPoliced),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_maxPktSize ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_maxPktSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RSVPParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RSVPParameters Print */
HS_RESULT ASNH245RSVPParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RSVPParameters *pObj = (ASNH245RSVPParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RSVPParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_qosMode ) )
		ASNH245QOSMode_Print( &(pObj->m_qosMode), pDepth+1, "qosMode" );
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_tokenRate ) )
		AsnInteger_Print( &(pObj->m_tokenRate), pDepth+1, "tokenRate" );
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_bucketSize ) )
		AsnInteger_Print( &(pObj->m_bucketSize), pDepth+1, "bucketSize" );
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_peakRate ) )
		AsnInteger_Print( &(pObj->m_peakRate), pDepth+1, "peakRate" );
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_minPoliced ) )
		AsnInteger_Print( &(pObj->m_minPoliced), pDepth+1, "minPoliced" );
	if( ASNH245RSVPParameters_IsIncludeOptionField( pObj, e_ASNH245RSVPParametersOptionMap_maxPktSize ) )
		AsnInteger_Print( &(pObj->m_maxPktSize), pDepth+1, "maxPktSize" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ATMParameters Class
*/
/*ASNH245ATMParameters Constructor*/
HS_RESULT new_ASNH245ATMParameters(void *pObject)
{
	ASNH245ATMParameters *pObj = (ASNH245ATMParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ATMParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_maxNTUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_atmUBR) );
	new_AsnBoolean( &(pObj->m_atmrtVBR) );
	new_AsnBoolean( &(pObj->m_atmnrtVBR) );
	new_AsnBoolean( &(pObj->m_atmABR) );
	new_AsnBoolean( &(pObj->m_atmCBR) );

	return HS_OK;
}

/* ASNH245ATMParameters Destructor */
HS_RESULT delete_ASNH245ATMParameters(void *pObject)
{
	ASNH245ATMParameters *pObj = (ASNH245ATMParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ATMParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_maxNTUSize) );
	delete_AsnBoolean( &(pObj->m_atmUBR) );
	delete_AsnBoolean( &(pObj->m_atmrtVBR) );
	delete_AsnBoolean( &(pObj->m_atmnrtVBR) );
	delete_AsnBoolean( &(pObj->m_atmABR) );
	delete_AsnBoolean( &(pObj->m_atmCBR) );
	return HS_OK;
}

/* ASNH245ATMParameters MakeMold */
HS_RESULT ASNH245ATMParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245ATMParameters *pObj = (ASNH245ATMParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245ATMParameters Encode */
HS_RESULT ASNH245ATMParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245ATMParameters *pObj = (ASNH245ATMParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_maxNTUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_atmUBR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_atmrtVBR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_atmnrtVBR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_atmABR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_atmCBR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245ATMParameters Decode */
HS_RESULT ASNH245ATMParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245ATMParameters *pObj = (ASNH245ATMParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxNTUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_atmUBR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_atmrtVBR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_atmnrtVBR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_atmABR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_atmCBR),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ATMParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ATMParameters Print */
HS_RESULT ASNH245ATMParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ATMParameters *pObj = (ASNH245ATMParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ATMParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_maxNTUSize), pDepth+1, "maxNTUSize" );
	AsnBoolean_Print( &(pObj->m_atmUBR), pDepth+1, "atmUBR" );
	AsnBoolean_Print( &(pObj->m_atmrtVBR), pDepth+1, "atmrtVBR" );
	AsnBoolean_Print( &(pObj->m_atmnrtVBR), pDepth+1, "atmnrtVBR" );
	AsnBoolean_Print( &(pObj->m_atmABR), pDepth+1, "atmABR" );
	AsnBoolean_Print( &(pObj->m_atmCBR), pDepth+1, "atmCBR" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245QOSCapability Class
*/
/*ASNH245QOSCapability Constructor*/
HS_RESULT new_ASNH245QOSCapability(void *pObject)
{
	ASNH245QOSCapability *pObj = (ASNH245QOSCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245QOSCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH245RSVPParameters( &(pObj->m_rsvpParameters) );
	new_ASNH245ATMParameters( &(pObj->m_atmParameters) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245QOSCapability Destructor */
HS_RESULT delete_ASNH245QOSCapability(void *pObject)
{
	ASNH245QOSCapability *pObj = (ASNH245QOSCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245QOSCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH245RSVPParameters( &(pObj->m_rsvpParameters) );
	delete_ASNH245ATMParameters( &(pObj->m_atmParameters) );
	return HS_OK;
}

/* ASNH245QOSCapability MakeMold */
HS_RESULT ASNH245QOSCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245QOSCapability *pObj = (ASNH245QOSCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH245RSVPParameters_MakeMold(&(pObj->m_rsvpParameters));
	ASNH245ATMParameters_MakeMold(&(pObj->m_atmParameters));
	return HS_OK;
}

/* ASNH245QOSCapability IncludeOptionalField */
HS_RESULT ASNH245QOSCapability_IncludeOptionField( void *pObject, ASNH245QOSCapabilityOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245QOSCapability *pObj = (ASNH245QOSCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245QOSCapabilityOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245QOSCapability IsIncludeOptionalField */
BOOL ASNH245QOSCapability_IsIncludeOptionField( void *pObject, ASNH245QOSCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245QOSCapability *pObj = (ASNH245QOSCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245QOSCapabilityOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245QOSCapability Encode */
HS_RESULT ASNH245QOSCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245QOSCapability *pObj = (ASNH245QOSCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245QOSCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245QOSCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245QOSCapability_IsIncludeOptionField( pObj, e_ASNH245QOSCapabilityOptionMap_nonStandardData ) ){
		if( (tRet=ASNH245NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245QOSCapability_IsIncludeOptionField( pObj, e_ASNH245QOSCapabilityOptionMap_rsvpParameters ) ){
		if( (tRet=ASNH245RSVPParameters_Encode( &(pObj->m_rsvpParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245QOSCapability_IsIncludeOptionField( pObj, e_ASNH245QOSCapabilityOptionMap_atmParameters ) ){
		if( (tRet=ASNH245ATMParameters_Encode( &(pObj->m_atmParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245QOSCapability Decode */
HS_RESULT ASNH245QOSCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245QOSCapability *pObj = (ASNH245QOSCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245QOSCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245QOSCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245QOSCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245QOSCapability_IsIncludeOptionField( pObj, e_ASNH245QOSCapabilityOptionMap_nonStandardData ) ){
		if( (tRet=ASNH245NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245QOSCapability_IsIncludeOptionField( pObj, e_ASNH245QOSCapabilityOptionMap_rsvpParameters ) ){
		if( (tRet=ASNH245RSVPParameters_Decode(&(pObj->m_rsvpParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245QOSCapability_IsIncludeOptionField( pObj, e_ASNH245QOSCapabilityOptionMap_atmParameters ) ){
		if( (tRet=ASNH245ATMParameters_Decode(&(pObj->m_atmParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245QOSCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245QOSCapability Print */
HS_RESULT ASNH245QOSCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245QOSCapability *pObj = (ASNH245QOSCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245QOSCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245QOSCapability_IsIncludeOptionField( pObj, e_ASNH245QOSCapabilityOptionMap_nonStandardData ) )
		ASNH245NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH245QOSCapability_IsIncludeOptionField( pObj, e_ASNH245QOSCapabilityOptionMap_rsvpParameters ) )
		ASNH245RSVPParameters_Print( &(pObj->m_rsvpParameters), pDepth+1, "rsvpParameters" );
	if( ASNH245QOSCapability_IsIncludeOptionField( pObj, e_ASNH245QOSCapabilityOptionMap_atmParameters ) )
		ASNH245ATMParameters_Print( &(pObj->m_atmParameters), pDepth+1, "atmParameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MediaTransportType_atm_AAL5_compressed Class
*/
/*ASNH245MediaTransportType_atm_AAL5_compressed Constructor*/
HS_RESULT new_ASNH245MediaTransportType_atm_AAL5_compressed(void *pObject)
{
	ASNH245MediaTransportType_atm_AAL5_compressed *pObj = (ASNH245MediaTransportType_atm_AAL5_compressed *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MediaTransportType_atm_AAL5_compressed(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_variable_delta) );

	return HS_OK;
}

/* ASNH245MediaTransportType_atm_AAL5_compressed Destructor */
HS_RESULT delete_ASNH245MediaTransportType_atm_AAL5_compressed(void *pObject)
{
	ASNH245MediaTransportType_atm_AAL5_compressed *pObj = (ASNH245MediaTransportType_atm_AAL5_compressed *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MediaTransportType_atm_AAL5_compressed(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_variable_delta) );
	return HS_OK;
}

/* ASNH245MediaTransportType_atm_AAL5_compressed MakeMold */
HS_RESULT ASNH245MediaTransportType_atm_AAL5_compressed_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MediaTransportType_atm_AAL5_compressed *pObj = (ASNH245MediaTransportType_atm_AAL5_compressed *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_atm_AAL5_compressed_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MediaTransportType_atm_AAL5_compressed Encode */
HS_RESULT ASNH245MediaTransportType_atm_AAL5_compressed_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MediaTransportType_atm_AAL5_compressed *pObj = (ASNH245MediaTransportType_atm_AAL5_compressed *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_atm_AAL5_compressed_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_variable_delta),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_atm_AAL5_compressed_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MediaTransportType_atm_AAL5_compressed Decode */
HS_RESULT ASNH245MediaTransportType_atm_AAL5_compressed_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MediaTransportType_atm_AAL5_compressed *pObj = (ASNH245MediaTransportType_atm_AAL5_compressed *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_atm_AAL5_compressed_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_variable_delta),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_atm_AAL5_compressed_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MediaTransportType_atm_AAL5_compressed Print */
HS_RESULT ASNH245MediaTransportType_atm_AAL5_compressed_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MediaTransportType_atm_AAL5_compressed *pObj = (ASNH245MediaTransportType_atm_AAL5_compressed *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MediaTransportType_atm_AAL5_compressed_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_variable_delta), pDepth+1, "variable_delta" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MediaTransportType Struct
*/
/* ASNH245MediaTransportType Constructor */
HS_RESULT new_ASNH245MediaTransportType( void *pObject )
{
	ASNH245MediaTransportType *pObj = (ASNH245MediaTransportType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MediaTransportType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MediaTransportTypeChoice_ip_UDP;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MediaTransportTypeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MediaTransportType Destructor */
HS_RESULT delete_ASNH245MediaTransportType( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MediaTransportType *pObj = (ASNH245MediaTransportType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MediaTransportType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MediaTransportType_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MediaTransportType(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MediaTransportType SetChoice */
void* ASNH245MediaTransportType_SetChoice( void *pObject, ASNH245MediaTransportTypeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MediaTransportType *pObj = (ASNH245MediaTransportType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MediaTransportTypeChoiceSizeExt ){
		if( pChoice > (ASNH245MediaTransportTypeChoice)(e_ASNH245MediaTransportTypeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MediaTransportType_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MediaTransportTypeChoice_ip_UDP ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MediaTransportTypeChoice_ip_TCP ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_UNIDIR ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_BIDIR ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_compressed ){
		ASNH245MediaTransportType_atm_AAL5_compressed *tAlter = (ASNH245MediaTransportType_atm_AAL5_compressed *)HSMalloc( sizeof(ASNH245MediaTransportType_atm_AAL5_compressed) );
		new_ASNH245MediaTransportType_atm_AAL5_compressed(tAlter);
		ASNH245MediaTransportType_atm_AAL5_compressed_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MediaTransportType DeleteAlternation */
HS_RESULT ASNH245MediaTransportType_DeleteAlternation(void *pObject)
{
	ASNH245MediaTransportType *pObj = (ASNH245MediaTransportType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MediaTransportTypeChoice_ip_UDP ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_ip_TCP ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_UNIDIR ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_BIDIR ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_compressed ){
			delete_ASNH245MediaTransportType_atm_AAL5_compressed(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MediaTransportType_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MediaTransportType Encode */
HS_RESULT ASNH245MediaTransportType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MediaTransportType *pObj = (ASNH245MediaTransportType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MediaTransportTypeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MediaTransportTypeChoice)(e_ASNH245MediaTransportTypeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MediaTransportTypeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MediaTransportTypeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MediaTransportTypeChoice_ip_UDP ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_ip_TCP ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_UNIDIR ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_BIDIR ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_compressed ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MediaTransportType_atm_AAL5_compressed_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MediaTransportType Decode */
HS_RESULT ASNH245MediaTransportType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MediaTransportType *pObj = (ASNH245MediaTransportType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MediaTransportTypeChoiceSize;
	}
	else
	{
		if( e_ASNH245MediaTransportTypeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MediaTransportTypeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MediaTransportTypeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MediaTransportType_SetChoice( pObj, (ASNH245MediaTransportTypeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MediaTransportTypeChoice_ip_UDP ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_ip_TCP ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_UNIDIR ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_BIDIR ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_compressed ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MediaTransportType_atm_AAL5_compressed_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaTransportType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaTransportType_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MediaTransportType Print */
HS_RESULT ASNH245MediaTransportType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MediaTransportType *pObj = (ASNH245MediaTransportType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MediaTransportType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MediaTransportTypeChoice_ip_UDP ){
		AsnNull_Print( pObj->alter, pDepth+1, "ip_UDP" );
	}
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_ip_TCP ){
		AsnNull_Print( pObj->alter, pDepth+1, "ip_TCP" );
	}
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_UNIDIR ){
		AsnNull_Print( pObj->alter, pDepth+1, "atm_AAL5_UNIDIR" );
	}
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_BIDIR ){
		AsnNull_Print( pObj->alter, pDepth+1, "atm_AAL5_BIDIR" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MediaTransportTypeChoice_atm_AAL5_compressed ){
		ASNH245MediaTransportType_atm_AAL5_compressed_Print( pObj->alter, pDepth+1, "atm_AAL5_compressed" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MediaChannelCapability Class
*/
/*ASNH245MediaChannelCapability Constructor*/
HS_RESULT new_ASNH245MediaChannelCapability(void *pObject)
{
	ASNH245MediaChannelCapability *pObj = (ASNH245MediaChannelCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MediaChannelCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245MediaTransportType( &(pObj->m_mediaTransport) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245MediaChannelCapability Destructor */
HS_RESULT delete_ASNH245MediaChannelCapability(void *pObject)
{
	ASNH245MediaChannelCapability *pObj = (ASNH245MediaChannelCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MediaChannelCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MediaTransportType( &(pObj->m_mediaTransport) );
	return HS_OK;
}

/* ASNH245MediaChannelCapability MakeMold */
HS_RESULT ASNH245MediaChannelCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MediaChannelCapability *pObj = (ASNH245MediaChannelCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaChannelCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245MediaTransportType_MakeMold(&(pObj->m_mediaTransport));
	return HS_OK;
}

/* ASNH245MediaChannelCapability IncludeOptionalField */
HS_RESULT ASNH245MediaChannelCapability_IncludeOptionField( void *pObject, ASNH245MediaChannelCapabilityOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245MediaChannelCapability *pObj = (ASNH245MediaChannelCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaChannelCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245MediaChannelCapabilityOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245MediaChannelCapability IsIncludeOptionalField */
BOOL ASNH245MediaChannelCapability_IsIncludeOptionField( void *pObject, ASNH245MediaChannelCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245MediaChannelCapability *pObj = (ASNH245MediaChannelCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaChannelCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245MediaChannelCapabilityOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245MediaChannelCapability Encode */
HS_RESULT ASNH245MediaChannelCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245MediaChannelCapability *pObj = (ASNH245MediaChannelCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaChannelCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245MediaChannelCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245MediaChannelCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245MediaChannelCapability_IsIncludeOptionField( pObj, e_ASNH245MediaChannelCapabilityOptionMap_mediaTransport ) ){
		if( (tRet=ASNH245MediaTransportType_Encode( &(pObj->m_mediaTransport),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaChannelCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245MediaChannelCapability Decode */
HS_RESULT ASNH245MediaChannelCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245MediaChannelCapability *pObj = (ASNH245MediaChannelCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaChannelCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245MediaChannelCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245MediaChannelCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245MediaChannelCapability_IsIncludeOptionField( pObj, e_ASNH245MediaChannelCapabilityOptionMap_mediaTransport ) ){
		if( (tRet=ASNH245MediaTransportType_Decode(&(pObj->m_mediaTransport),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaChannelCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MediaChannelCapability Print */
HS_RESULT ASNH245MediaChannelCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MediaChannelCapability *pObj = (ASNH245MediaChannelCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MediaChannelCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245MediaChannelCapability_IsIncludeOptionField( pObj, e_ASNH245MediaChannelCapabilityOptionMap_mediaTransport ) )
		ASNH245MediaTransportType_Print( &(pObj->m_mediaTransport), pDepth+1, "mediaTransport" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TransportCapability Class
*/
/*ASNH245TransportCapability Constructor*/
HS_RESULT new_ASNH245TransportCapability(void *pObject)
{
	ASNH245TransportCapability *pObj = (ASNH245TransportCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TransportCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245NonStandardParameter( &(pObj->m_nonStandard) );
	new_AsnSequenceOf( &(pObj->m_qOSCapabilities), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_mediaChannelCapabilities), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245TransportCapability Destructor */
HS_RESULT delete_ASNH245TransportCapability(void *pObject)
{
	ASNH245TransportCapability *pObj = (ASNH245TransportCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TransportCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245NonStandardParameter( &(pObj->m_nonStandard) );
	delete_AsnSequenceOf( &(pObj->m_qOSCapabilities) );
	delete_AsnSequenceOf( &(pObj->m_mediaChannelCapabilities) );
	return HS_OK;
}

/* ASNH245TransportCapability MakeMold */
HS_RESULT ASNH245TransportCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245TransportCapability *pObj = (ASNH245TransportCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245NonStandardParameter_MakeMold(&(pObj->m_nonStandard));
	{
	ASNH245QOSCapability *tmold_qOSCapabilities = (ASNH245QOSCapability *)HSMalloc( sizeof(ASNH245QOSCapability) );
	new_ASNH245QOSCapability(tmold_qOSCapabilities);
	ASNH245QOSCapability_MakeMold(tmold_qOSCapabilities);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_qOSCapabilities,sizeof(ASNH245QOSCapability),ASNH245QOSCapability_MakeMold,ASNH245QOSCapability_Encode,ASNH245QOSCapability_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245QOSCapability_Print,
#endif
		delete_ASNH245QOSCapability);
	AsnSequenceOf_SetMold( &(pObj->m_qOSCapabilities), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_qOSCapabilities.constraint.type = e_constrained;
	pObj->m_qOSCapabilities.constraint.minValue = 1;
	pObj->m_qOSCapabilities.constraint.maxValue = 256;
	pObj->m_qOSCapabilities.extMinValue = 0;
	pObj->m_qOSCapabilities.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	{
	ASNH245MediaChannelCapability *tmold_mediaChannelCapabilities = (ASNH245MediaChannelCapability *)HSMalloc( sizeof(ASNH245MediaChannelCapability) );
	new_ASNH245MediaChannelCapability(tmold_mediaChannelCapabilities);
	ASNH245MediaChannelCapability_MakeMold(tmold_mediaChannelCapabilities);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_mediaChannelCapabilities,sizeof(ASNH245MediaChannelCapability),ASNH245MediaChannelCapability_MakeMold,ASNH245MediaChannelCapability_Encode,ASNH245MediaChannelCapability_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MediaChannelCapability_Print,
#endif
		delete_ASNH245MediaChannelCapability);
	AsnSequenceOf_SetMold( &(pObj->m_mediaChannelCapabilities), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_mediaChannelCapabilities.constraint.type = e_constrained;
	pObj->m_mediaChannelCapabilities.constraint.minValue = 1;
	pObj->m_mediaChannelCapabilities.constraint.maxValue = 256;
	pObj->m_mediaChannelCapabilities.extMinValue = 0;
	pObj->m_mediaChannelCapabilities.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245TransportCapability IncludeOptionalField */
HS_RESULT ASNH245TransportCapability_IncludeOptionField( void *pObject, ASNH245TransportCapabilityOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245TransportCapability *pObj = (ASNH245TransportCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245TransportCapabilityOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245TransportCapability IsIncludeOptionalField */
BOOL ASNH245TransportCapability_IsIncludeOptionField( void *pObject, ASNH245TransportCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245TransportCapability *pObj = (ASNH245TransportCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245TransportCapabilityOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245TransportCapability Encode */
HS_RESULT ASNH245TransportCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245TransportCapability *pObj = (ASNH245TransportCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245TransportCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245TransportCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245TransportCapability_IsIncludeOptionField( pObj, e_ASNH245TransportCapabilityOptionMap_nonStandard ) ){
		if( (tRet=ASNH245NonStandardParameter_Encode( &(pObj->m_nonStandard),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245TransportCapability_IsIncludeOptionField( pObj, e_ASNH245TransportCapabilityOptionMap_qOSCapabilities ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_qOSCapabilities),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245TransportCapability_IsIncludeOptionField( pObj, e_ASNH245TransportCapabilityOptionMap_mediaChannelCapabilities ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_mediaChannelCapabilities),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245TransportCapability Decode */
HS_RESULT ASNH245TransportCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245TransportCapability *pObj = (ASNH245TransportCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245TransportCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245TransportCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245TransportCapability_IsIncludeOptionField( pObj, e_ASNH245TransportCapabilityOptionMap_nonStandard ) ){
		if( (tRet=ASNH245NonStandardParameter_Decode(&(pObj->m_nonStandard),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245TransportCapability_IsIncludeOptionField( pObj, e_ASNH245TransportCapabilityOptionMap_qOSCapabilities ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_qOSCapabilities),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245TransportCapability_IsIncludeOptionField( pObj, e_ASNH245TransportCapabilityOptionMap_mediaChannelCapabilities ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_mediaChannelCapabilities),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TransportCapability Print */
HS_RESULT ASNH245TransportCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TransportCapability *pObj = (ASNH245TransportCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TransportCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245TransportCapability_IsIncludeOptionField( pObj, e_ASNH245TransportCapabilityOptionMap_nonStandard ) )
		ASNH245NonStandardParameter_Print( &(pObj->m_nonStandard), pDepth+1, "nonStandard" );
	if( ASNH245TransportCapability_IsIncludeOptionField( pObj, e_ASNH245TransportCapabilityOptionMap_qOSCapabilities ) )
		AsnSequenceOf_Print( &(pObj->m_qOSCapabilities), pDepth+1, "qOSCapabilities" );
	if( ASNH245TransportCapability_IsIncludeOptionField( pObj, e_ASNH245TransportCapabilityOptionMap_mediaChannelCapabilities ) )
		AsnSequenceOf_Print( &(pObj->m_mediaChannelCapabilities), pDepth+1, "mediaChannelCapabilities" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RTPH263VideoRedundancyFrameMapping Class
*/
/*ASNH245RTPH263VideoRedundancyFrameMapping Constructor*/
HS_RESULT new_ASNH245RTPH263VideoRedundancyFrameMapping(void *pObject)
{
	ASNH245RTPH263VideoRedundancyFrameMapping *pObj = (ASNH245RTPH263VideoRedundancyFrameMapping *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RTPH263VideoRedundancyFrameMapping(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_threadNumber), e_constrained, 0, 15, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_frameSequence), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyFrameMapping Destructor */
HS_RESULT delete_ASNH245RTPH263VideoRedundancyFrameMapping(void *pObject)
{
	ASNH245RTPH263VideoRedundancyFrameMapping *pObj = (ASNH245RTPH263VideoRedundancyFrameMapping *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RTPH263VideoRedundancyFrameMapping(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_threadNumber) );
	delete_AsnSequenceOf( &(pObj->m_frameSequence) );
	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyFrameMapping MakeMold */
HS_RESULT ASNH245RTPH263VideoRedundancyFrameMapping_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RTPH263VideoRedundancyFrameMapping *pObj = (ASNH245RTPH263VideoRedundancyFrameMapping *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyFrameMapping_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	AsnInteger *tmold_frameSequence = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
	new_AsnInteger(tmold_frameSequence,e_constrained,0,255,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_frameSequence,sizeof(AsnInteger),AsnInteger_MakeMold,AsnInteger_Encode,AsnInteger_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnInteger_Print,
#endif
		delete_AsnInteger);
	AsnSequenceOf_SetMold( &(pObj->m_frameSequence), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_frameSequence.constraint.type = e_constrained;
	pObj->m_frameSequence.constraint.minValue = 1;
	pObj->m_frameSequence.constraint.maxValue = 256;
	pObj->m_frameSequence.extMinValue = 0;
	pObj->m_frameSequence.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyFrameMapping Encode */
HS_RESULT ASNH245RTPH263VideoRedundancyFrameMapping_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RTPH263VideoRedundancyFrameMapping *pObj = (ASNH245RTPH263VideoRedundancyFrameMapping *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyFrameMapping_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_threadNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyFrameMapping_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_frameSequence),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyFrameMapping_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyFrameMapping Decode */
HS_RESULT ASNH245RTPH263VideoRedundancyFrameMapping_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RTPH263VideoRedundancyFrameMapping *pObj = (ASNH245RTPH263VideoRedundancyFrameMapping *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyFrameMapping_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_threadNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyFrameMapping_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_frameSequence),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyFrameMapping_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RTPH263VideoRedundancyFrameMapping Print */
HS_RESULT ASNH245RTPH263VideoRedundancyFrameMapping_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RTPH263VideoRedundancyFrameMapping *pObj = (ASNH245RTPH263VideoRedundancyFrameMapping *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyFrameMapping_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_threadNumber), pDepth+1, "threadNumber" );
	AsnSequenceOf_Print( &(pObj->m_frameSequence), pDepth+1, "frameSequence" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping Struct
*/
/* ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping Constructor */
HS_RESULT new_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping( void *pObject )
{
	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *pObj = (ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_roundrobin;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping Destructor */
HS_RESULT delete_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *pObj = (ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping SetChoice */
void* ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_SetChoice( void *pObject, ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *pObj = (ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSizeExt ){
		if( pChoice > (ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice)(e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_roundrobin ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_custom ){
		ASNH245RTPH263VideoRedundancyFrameMapping *tAlter = (ASNH245RTPH263VideoRedundancyFrameMapping *)HSMalloc( sizeof(ASNH245RTPH263VideoRedundancyFrameMapping) );
		new_ASNH245RTPH263VideoRedundancyFrameMapping(tAlter);
		ASNH245RTPH263VideoRedundancyFrameMapping_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH245RTPH263VideoRedundancyFrameMapping),ASNH245RTPH263VideoRedundancyFrameMapping_MakeMold,ASNH245RTPH263VideoRedundancyFrameMapping_Encode,ASNH245RTPH263VideoRedundancyFrameMapping_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH245RTPH263VideoRedundancyFrameMapping_Print,
#endif
			delete_ASNH245RTPH263VideoRedundancyFrameMapping );
		AsnSequenceOf_SetMold(aso,tmold);
		/* Sequence Of constraint */
		aso->constraint.type = e_constrained;
		aso->constraint.minValue = 1;
		aso->constraint.maxValue = 256;
		aso->extMinValue = 0;
		aso->extMaxValue = HS_ASN_MAX_CONSTRAINT;
		pObj->alter = aso;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping DeleteAlternation */
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_DeleteAlternation(void *pObject)
{
	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *pObj = (ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_roundrobin ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_custom ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping Encode */
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *pObj = (ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSize )
		{
			if( pObj->choice > ((ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice)(e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_roundrobin ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_custom ){
		if( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping Decode */
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *pObj = (ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSize;
	}
	else
	{
		if( e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_SetChoice( pObj, (ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_roundrobin ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_custom ){
		if( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping Print */
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *pObj = (ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_roundrobin ){
		AsnNull_Print( pObj->alter, pDepth+1, "roundrobin" );
	}
	else if ( pObj->choice == e_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMappingChoice_custom ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "custom" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RTPH263VideoRedundancyEncoding Class
*/
/*ASNH245RTPH263VideoRedundancyEncoding Constructor*/
HS_RESULT new_ASNH245RTPH263VideoRedundancyEncoding(void *pObject)
{
	ASNH245RTPH263VideoRedundancyEncoding *pObj = (ASNH245RTPH263VideoRedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RTPH263VideoRedundancyEncoding(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_numberOfThreads), e_constrained, 1, 16, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_framesBetweenSyncPoints), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping( &(pObj->m_frameToThreadMapping) );
	new_AsnSequenceOf( &(pObj->m_containedThreads), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyEncoding Destructor */
HS_RESULT delete_ASNH245RTPH263VideoRedundancyEncoding(void *pObject)
{
	ASNH245RTPH263VideoRedundancyEncoding *pObj = (ASNH245RTPH263VideoRedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RTPH263VideoRedundancyEncoding(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_numberOfThreads) );
	delete_AsnInteger( &(pObj->m_framesBetweenSyncPoints) );
	delete_ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping( &(pObj->m_frameToThreadMapping) );
	delete_AsnSequenceOf( &(pObj->m_containedThreads) );
	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyEncoding MakeMold */
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RTPH263VideoRedundancyEncoding *pObj = (ASNH245RTPH263VideoRedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	AsnInteger *tmold_containedThreads = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
	new_AsnInteger(tmold_containedThreads,e_constrained,0,15,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_containedThreads,sizeof(AsnInteger),AsnInteger_MakeMold,AsnInteger_Encode,AsnInteger_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnInteger_Print,
#endif
		delete_AsnInteger);
	AsnSequenceOf_SetMold( &(pObj->m_containedThreads), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_containedThreads.constraint.type = e_constrained;
	pObj->m_containedThreads.constraint.minValue = 1;
	pObj->m_containedThreads.constraint.maxValue = 256;
	pObj->m_containedThreads.extMinValue = 0;
	pObj->m_containedThreads.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyEncoding IncludeOptionalField */
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_IncludeOptionField( void *pObject, ASNH245RTPH263VideoRedundancyEncodingOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245RTPH263VideoRedundancyEncoding *pObj = (ASNH245RTPH263VideoRedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245RTPH263VideoRedundancyEncodingOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyEncoding IsIncludeOptionalField */
BOOL ASNH245RTPH263VideoRedundancyEncoding_IsIncludeOptionField( void *pObject, ASNH245RTPH263VideoRedundancyEncodingOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245RTPH263VideoRedundancyEncoding *pObj = (ASNH245RTPH263VideoRedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245RTPH263VideoRedundancyEncodingOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245RTPH263VideoRedundancyEncoding Encode */
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RTPH263VideoRedundancyEncoding *pObj = (ASNH245RTPH263VideoRedundancyEncoding *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245RTPH263VideoRedundancyEncodingOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245RTPH263VideoRedundancyEncodingOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Encode( &(pObj->m_numberOfThreads),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_framesBetweenSyncPoints),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Encode( &(pObj->m_frameToThreadMapping),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245RTPH263VideoRedundancyEncoding_IsIncludeOptionField( pObj, e_ASNH245RTPH263VideoRedundancyEncodingOptionMap_containedThreads ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_containedThreads),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245RTPH263VideoRedundancyEncoding Decode */
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RTPH263VideoRedundancyEncoding *pObj = (ASNH245RTPH263VideoRedundancyEncoding *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245RTPH263VideoRedundancyEncodingOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245RTPH263VideoRedundancyEncodingOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_numberOfThreads),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_framesBetweenSyncPoints),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Decode(&(pObj->m_frameToThreadMapping),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245RTPH263VideoRedundancyEncoding_IsIncludeOptionField( pObj, e_ASNH245RTPH263VideoRedundancyEncodingOptionMap_containedThreads ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_containedThreads),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RTPH263VideoRedundancyEncoding Print */
HS_RESULT ASNH245RTPH263VideoRedundancyEncoding_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RTPH263VideoRedundancyEncoding *pObj = (ASNH245RTPH263VideoRedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RTPH263VideoRedundancyEncoding_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_numberOfThreads), pDepth+1, "numberOfThreads" );
	AsnInteger_Print( &(pObj->m_framesBetweenSyncPoints), pDepth+1, "framesBetweenSyncPoints" );
	ASNH245RTPH263VideoRedundancyEncoding_frameToThreadMapping_Print( &(pObj->m_frameToThreadMapping), pDepth+1, "frameToThreadMapping" );
	if( ASNH245RTPH263VideoRedundancyEncoding_IsIncludeOptionField( pObj, e_ASNH245RTPH263VideoRedundancyEncodingOptionMap_containedThreads ) )
		AsnSequenceOf_Print( &(pObj->m_containedThreads), pDepth+1, "containedThreads" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RedundancyEncodingMethod Struct
*/
/* ASNH245RedundancyEncodingMethod Constructor */
HS_RESULT new_ASNH245RedundancyEncodingMethod( void *pObject )
{
	ASNH245RedundancyEncodingMethod *pObj = (ASNH245RedundancyEncodingMethod *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RedundancyEncodingMethod(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RedundancyEncodingMethodChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RedundancyEncodingMethodChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RedundancyEncodingMethod Destructor */
HS_RESULT delete_ASNH245RedundancyEncodingMethod( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RedundancyEncodingMethod *pObj = (ASNH245RedundancyEncodingMethod *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RedundancyEncodingMethod(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RedundancyEncodingMethod_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RedundancyEncodingMethod(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RedundancyEncodingMethod SetChoice */
void* ASNH245RedundancyEncodingMethod_SetChoice( void *pObject, ASNH245RedundancyEncodingMethodChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RedundancyEncodingMethod *pObj = (ASNH245RedundancyEncodingMethod *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RedundancyEncodingMethodChoiceSizeExt ){
		if( pChoice > (ASNH245RedundancyEncodingMethodChoice)(e_ASNH245RedundancyEncodingMethodChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RedundancyEncodingMethod_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RedundancyEncodingMethodChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RedundancyEncodingMethodChoice_rtpAudioRedundancyEncoding ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245RedundancyEncodingMethodChoice_rtpH263VideoRedundancyEncoding ){
		ASNH245RTPH263VideoRedundancyEncoding *tAlter = (ASNH245RTPH263VideoRedundancyEncoding *)HSMalloc( sizeof(ASNH245RTPH263VideoRedundancyEncoding) );
		new_ASNH245RTPH263VideoRedundancyEncoding(tAlter);
		ASNH245RTPH263VideoRedundancyEncoding_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RedundancyEncodingMethod DeleteAlternation */
HS_RESULT ASNH245RedundancyEncodingMethod_DeleteAlternation(void *pObject)
{
	ASNH245RedundancyEncodingMethod *pObj = (ASNH245RedundancyEncodingMethod *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_rtpAudioRedundancyEncoding ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_rtpH263VideoRedundancyEncoding ){
			delete_ASNH245RTPH263VideoRedundancyEncoding(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RedundancyEncodingMethod_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RedundancyEncodingMethod Encode */
HS_RESULT ASNH245RedundancyEncodingMethod_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RedundancyEncodingMethod *pObj = (ASNH245RedundancyEncodingMethod *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RedundancyEncodingMethodChoiceSize )
		{
			if( pObj->choice > ((ASNH245RedundancyEncodingMethodChoice)(e_ASNH245RedundancyEncodingMethodChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RedundancyEncodingMethodChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RedundancyEncodingMethodChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_rtpAudioRedundancyEncoding ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_rtpH263VideoRedundancyEncoding ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245RTPH263VideoRedundancyEncoding_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RedundancyEncodingMethod Decode */
HS_RESULT ASNH245RedundancyEncodingMethod_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RedundancyEncodingMethod *pObj = (ASNH245RedundancyEncodingMethod *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RedundancyEncodingMethodChoiceSize;
	}
	else
	{
		if( e_ASNH245RedundancyEncodingMethodChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RedundancyEncodingMethodChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RedundancyEncodingMethodChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RedundancyEncodingMethod_SetChoice( pObj, (ASNH245RedundancyEncodingMethodChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_rtpAudioRedundancyEncoding ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_rtpH263VideoRedundancyEncoding ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245RTPH263VideoRedundancyEncoding_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RedundancyEncodingMethod Print */
HS_RESULT ASNH245RedundancyEncodingMethod_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RedundancyEncodingMethod *pObj = (ASNH245RedundancyEncodingMethod *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RedundancyEncodingMethod_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_rtpAudioRedundancyEncoding ){
		AsnNull_Print( pObj->alter, pDepth+1, "rtpAudioRedundancyEncoding" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245RedundancyEncodingMethodChoice_rtpH263VideoRedundancyEncoding ){
		ASNH245RTPH263VideoRedundancyEncoding_Print( pObj->alter, pDepth+1, "rtpH263VideoRedundancyEncoding" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RedundancyEncodingCapability Class
*/
/*ASNH245RedundancyEncodingCapability Constructor*/
HS_RESULT new_ASNH245RedundancyEncodingCapability(void *pObject)
{
	ASNH245RedundancyEncodingCapability *pObj = (ASNH245RedundancyEncodingCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RedundancyEncodingCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245RedundancyEncodingMethod( &(pObj->m_redundancyEncodingMethod) );
	new_ASNH245CapabilityTableEntryNumber( &(pObj->m_primaryEncoding) );
	new_AsnSequenceOf( &(pObj->m_secondaryEncoding), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245RedundancyEncodingCapability Destructor */
HS_RESULT delete_ASNH245RedundancyEncodingCapability(void *pObject)
{
	ASNH245RedundancyEncodingCapability *pObj = (ASNH245RedundancyEncodingCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RedundancyEncodingCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245RedundancyEncodingMethod( &(pObj->m_redundancyEncodingMethod) );
	delete_ASNH245CapabilityTableEntryNumber( &(pObj->m_primaryEncoding) );
	delete_AsnSequenceOf( &(pObj->m_secondaryEncoding) );
	return HS_OK;
}

/* ASNH245RedundancyEncodingCapability MakeMold */
HS_RESULT ASNH245RedundancyEncodingCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RedundancyEncodingCapability *pObj = (ASNH245RedundancyEncodingCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245RedundancyEncodingMethod_MakeMold(&(pObj->m_redundancyEncodingMethod));
	ASNH245CapabilityTableEntryNumber_MakeMold(&(pObj->m_primaryEncoding));
	{
	ASNH245CapabilityTableEntryNumber *tmold_secondaryEncoding = (ASNH245CapabilityTableEntryNumber *)HSMalloc( sizeof(ASNH245CapabilityTableEntryNumber) );
	new_ASNH245CapabilityTableEntryNumber(tmold_secondaryEncoding);
	ASNH245CapabilityTableEntryNumber_MakeMold(tmold_secondaryEncoding);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_secondaryEncoding,sizeof(ASNH245CapabilityTableEntryNumber),ASNH245CapabilityTableEntryNumber_MakeMold,ASNH245CapabilityTableEntryNumber_Encode,ASNH245CapabilityTableEntryNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245CapabilityTableEntryNumber_Print,
#endif
		delete_ASNH245CapabilityTableEntryNumber);
	AsnSequenceOf_SetMold( &(pObj->m_secondaryEncoding), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_secondaryEncoding.constraint.type = e_constrained;
	pObj->m_secondaryEncoding.constraint.minValue = 1;
	pObj->m_secondaryEncoding.constraint.maxValue = 256;
	pObj->m_secondaryEncoding.extMinValue = 0;
	pObj->m_secondaryEncoding.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245RedundancyEncodingCapability IncludeOptionalField */
HS_RESULT ASNH245RedundancyEncodingCapability_IncludeOptionField( void *pObject, ASNH245RedundancyEncodingCapabilityOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245RedundancyEncodingCapability *pObj = (ASNH245RedundancyEncodingCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245RedundancyEncodingCapabilityOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245RedundancyEncodingCapability IsIncludeOptionalField */
BOOL ASNH245RedundancyEncodingCapability_IsIncludeOptionField( void *pObject, ASNH245RedundancyEncodingCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245RedundancyEncodingCapability *pObj = (ASNH245RedundancyEncodingCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245RedundancyEncodingCapabilityOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245RedundancyEncodingCapability Encode */
HS_RESULT ASNH245RedundancyEncodingCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RedundancyEncodingCapability *pObj = (ASNH245RedundancyEncodingCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245RedundancyEncodingCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245RedundancyEncodingCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245RedundancyEncodingMethod_Encode( &(pObj->m_redundancyEncodingMethod),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CapabilityTableEntryNumber_Encode( &(pObj->m_primaryEncoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245RedundancyEncodingCapability_IsIncludeOptionField( pObj, e_ASNH245RedundancyEncodingCapabilityOptionMap_secondaryEncoding ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_secondaryEncoding),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245RedundancyEncodingCapability Decode */
HS_RESULT ASNH245RedundancyEncodingCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RedundancyEncodingCapability *pObj = (ASNH245RedundancyEncodingCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245RedundancyEncodingCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245RedundancyEncodingCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245RedundancyEncodingMethod_Decode(&(pObj->m_redundancyEncodingMethod),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CapabilityTableEntryNumber_Decode(&(pObj->m_primaryEncoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245RedundancyEncodingCapability_IsIncludeOptionField( pObj, e_ASNH245RedundancyEncodingCapabilityOptionMap_secondaryEncoding ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_secondaryEncoding),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RedundancyEncodingCapability Print */
HS_RESULT ASNH245RedundancyEncodingCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RedundancyEncodingCapability *pObj = (ASNH245RedundancyEncodingCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RedundancyEncodingCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245RedundancyEncodingMethod_Print( &(pObj->m_redundancyEncodingMethod), pDepth+1, "redundancyEncodingMethod" );
	ASNH245CapabilityTableEntryNumber_Print( &(pObj->m_primaryEncoding), pDepth+1, "primaryEncoding" );
	if( ASNH245RedundancyEncodingCapability_IsIncludeOptionField( pObj, e_ASNH245RedundancyEncodingCapabilityOptionMap_secondaryEncoding ) )
		AsnSequenceOf_Print( &(pObj->m_secondaryEncoding), pDepth+1, "secondaryEncoding" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H2250Capability Class
*/
/*ASNH245H2250Capability Constructor*/
HS_RESULT new_ASNH245H2250Capability(void *pObject)
{
	ASNH245H2250Capability *pObj = (ASNH245H2250Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H2250Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_maximumAudioDelayJitter), e_constrained, 0, 1023, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245MultipointCapability( &(pObj->m_receiveMultipointCapability) );
	new_ASNH245MultipointCapability( &(pObj->m_transmitMultipointCapability) );
	new_ASNH245MultipointCapability( &(pObj->m_receiveAndTransmitMultipointCapability) );
	new_ASNH245H2250Capability_mcCapability( &(pObj->m_mcCapability) );
	new_AsnBoolean( &(pObj->m_rtcpVideoControlCapability) );
	new_ASNH245MediaPacketizationCapability( &(pObj->m_mediaPacketizationCapability) );
	new_ASNH245TransportCapability( &(pObj->m_transportCapability) );
	new_AsnSequenceOf( &(pObj->m_redundancyEncodingCapability), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_logicalChannelSwitchingCapability) );
	new_AsnBoolean( &(pObj->m_t120DynamicPortCapability) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H2250Capability Destructor */
HS_RESULT delete_ASNH245H2250Capability(void *pObject)
{
	ASNH245H2250Capability *pObj = (ASNH245H2250Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H2250Capability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_maximumAudioDelayJitter) );
	delete_ASNH245MultipointCapability( &(pObj->m_receiveMultipointCapability) );
	delete_ASNH245MultipointCapability( &(pObj->m_transmitMultipointCapability) );
	delete_ASNH245MultipointCapability( &(pObj->m_receiveAndTransmitMultipointCapability) );
	delete_ASNH245H2250Capability_mcCapability( &(pObj->m_mcCapability) );
	delete_AsnBoolean( &(pObj->m_rtcpVideoControlCapability) );
	delete_ASNH245MediaPacketizationCapability( &(pObj->m_mediaPacketizationCapability) );
	delete_ASNH245TransportCapability( &(pObj->m_transportCapability) );
	delete_AsnSequenceOf( &(pObj->m_redundancyEncodingCapability) );
	delete_AsnBoolean( &(pObj->m_logicalChannelSwitchingCapability) );
	delete_AsnBoolean( &(pObj->m_t120DynamicPortCapability) );
	return HS_OK;
}

/* ASNH245H2250Capability MakeMold */
HS_RESULT ASNH245H2250Capability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H2250Capability *pObj = (ASNH245H2250Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245MultipointCapability_MakeMold(&(pObj->m_receiveMultipointCapability));
	ASNH245MultipointCapability_MakeMold(&(pObj->m_transmitMultipointCapability));
	ASNH245MultipointCapability_MakeMold(&(pObj->m_receiveAndTransmitMultipointCapability));
	ASNH245H2250Capability_mcCapability_MakeMold(&(pObj->m_mcCapability));
	ASNH245MediaPacketizationCapability_MakeMold(&(pObj->m_mediaPacketizationCapability));
	ASNH245TransportCapability_MakeMold(&(pObj->m_transportCapability));
	{
	ASNH245RedundancyEncodingCapability *tmold_redundancyEncodingCapability = (ASNH245RedundancyEncodingCapability *)HSMalloc( sizeof(ASNH245RedundancyEncodingCapability) );
	new_ASNH245RedundancyEncodingCapability(tmold_redundancyEncodingCapability);
	ASNH245RedundancyEncodingCapability_MakeMold(tmold_redundancyEncodingCapability);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_redundancyEncodingCapability,sizeof(ASNH245RedundancyEncodingCapability),ASNH245RedundancyEncodingCapability_MakeMold,ASNH245RedundancyEncodingCapability_Encode,ASNH245RedundancyEncodingCapability_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245RedundancyEncodingCapability_Print,
#endif
		delete_ASNH245RedundancyEncodingCapability);
	AsnSequenceOf_SetMold( &(pObj->m_redundancyEncodingCapability), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_redundancyEncodingCapability.constraint.type = e_constrained;
	pObj->m_redundancyEncodingCapability.constraint.minValue = 1;
	pObj->m_redundancyEncodingCapability.constraint.maxValue = 256;
	pObj->m_redundancyEncodingCapability.extMinValue = 0;
	pObj->m_redundancyEncodingCapability.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245H2250Capability IncludeOptionalField */
HS_RESULT ASNH245H2250Capability_IncludeOptionField( void *pObject, ASNH245H2250CapabilityOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H2250Capability *pObj = (ASNH245H2250Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H2250CapabilityOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H2250CapabilityOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245H2250Capability IsIncludeOptionalField */
BOOL ASNH245H2250Capability_IsIncludeOptionField( void *pObject, ASNH245H2250CapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H2250Capability *pObj = (ASNH245H2250Capability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H2250CapabilityOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H2250CapabilityOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H2250Capability Encode */
HS_RESULT ASNH245H2250Capability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H2250Capability *pObj = (ASNH245H2250Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumAudioDelayJitter),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultipointCapability_Encode( &(pObj->m_receiveMultipointCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultipointCapability_Encode( &(pObj->m_transmitMultipointCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultipointCapability_Encode( &(pObj->m_receiveAndTransmitMultipointCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245H2250Capability_mcCapability_Encode( &(pObj->m_mcCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_rtcpVideoControlCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MediaPacketizationCapability_Encode( &(pObj->m_mediaPacketizationCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_transportCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_transportCapability), ASNH245TransportCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_redundancyEncodingCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_redundancyEncodingCapability), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_logicalChannelSwitchingCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_logicalChannelSwitchingCapability), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_t120DynamicPortCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_t120DynamicPortCapability), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H2250Capability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H2250Capability Decode */
HS_RESULT ASNH245H2250Capability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H2250Capability *pObj = (ASNH245H2250Capability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumAudioDelayJitter),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultipointCapability_Decode(&(pObj->m_receiveMultipointCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultipointCapability_Decode(&(pObj->m_transmitMultipointCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultipointCapability_Decode(&(pObj->m_receiveAndTransmitMultipointCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245H2250Capability_mcCapability_Decode(&(pObj->m_mcCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_rtcpVideoControlCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MediaPacketizationCapability_Decode(&(pObj->m_mediaPacketizationCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_transportCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_transportCapability), ASNH245TransportCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_redundancyEncodingCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_redundancyEncodingCapability), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_logicalChannelSwitchingCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_logicalChannelSwitchingCapability), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_t120DynamicPortCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_t120DynamicPortCapability), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250Capability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H2250Capability Print */
HS_RESULT ASNH245H2250Capability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H2250Capability *pObj = (ASNH245H2250Capability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H2250Capability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_maximumAudioDelayJitter), pDepth+1, "maximumAudioDelayJitter" );
	ASNH245MultipointCapability_Print( &(pObj->m_receiveMultipointCapability), pDepth+1, "receiveMultipointCapability" );
	ASNH245MultipointCapability_Print( &(pObj->m_transmitMultipointCapability), pDepth+1, "transmitMultipointCapability" );
	ASNH245MultipointCapability_Print( &(pObj->m_receiveAndTransmitMultipointCapability), pDepth+1, "receiveAndTransmitMultipointCapability" );
	ASNH245H2250Capability_mcCapability_Print( &(pObj->m_mcCapability), pDepth+1, "mcCapability" );
	AsnBoolean_Print( &(pObj->m_rtcpVideoControlCapability), pDepth+1, "rtcpVideoControlCapability" );
	ASNH245MediaPacketizationCapability_Print( &(pObj->m_mediaPacketizationCapability), pDepth+1, "mediaPacketizationCapability" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_transportCapability ) )
		ASNH245TransportCapability_Print( &(pObj->m_transportCapability), pDepth+1, "transportCapability" );
	if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_redundancyEncodingCapability ) )
		AsnSequenceOf_Print( &(pObj->m_redundancyEncodingCapability), pDepth+1, "redundancyEncodingCapability" );
	if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_logicalChannelSwitchingCapability ) )
		AsnBoolean_Print( &(pObj->m_logicalChannelSwitchingCapability), pDepth+1, "logicalChannelSwitchingCapability" );
	if( ASNH245H2250Capability_IsIncludeOptionField( pObj, e_ASNH245H2250CapabilityOptionMap_t120DynamicPortCapability ) )
		AsnBoolean_Print( &(pObj->m_t120DynamicPortCapability), pDepth+1, "t120DynamicPortCapability" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexCapability Struct
*/
/* ASNH245MultiplexCapability Constructor */
HS_RESULT new_ASNH245MultiplexCapability( void *pObject )
{
	ASNH245MultiplexCapability *pObj = (ASNH245MultiplexCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MultiplexCapabilityChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MultiplexCapabilityChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MultiplexCapability Destructor */
HS_RESULT delete_ASNH245MultiplexCapability( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MultiplexCapability *pObj = (ASNH245MultiplexCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MultiplexCapability_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexCapability(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MultiplexCapability SetChoice */
void* ASNH245MultiplexCapability_SetChoice( void *pObject, ASNH245MultiplexCapabilityChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MultiplexCapability *pObj = (ASNH245MultiplexCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexCapability_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MultiplexCapabilityChoiceSizeExt ){
		if( pChoice > (ASNH245MultiplexCapabilityChoice)(e_ASNH245MultiplexCapabilityChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MultiplexCapability_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MultiplexCapabilityChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultiplexCapabilityChoice_h222Capability ){
		ASNH245H222Capability *tAlter = (ASNH245H222Capability *)HSMalloc( sizeof(ASNH245H222Capability) );
		new_ASNH245H222Capability(tAlter);
		ASNH245H222Capability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultiplexCapabilityChoice_h223Capability ){
		ASNH245H223Capability *tAlter = (ASNH245H223Capability *)HSMalloc( sizeof(ASNH245H223Capability) );
		new_ASNH245H223Capability(tAlter);
		ASNH245H223Capability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultiplexCapabilityChoice_v76Capability ){
		ASNH245V76Capability *tAlter = (ASNH245V76Capability *)HSMalloc( sizeof(ASNH245V76Capability) );
		new_ASNH245V76Capability(tAlter);
		ASNH245V76Capability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245MultiplexCapabilityChoice_h2250Capability ){
		ASNH245H2250Capability *tAlter = (ASNH245H2250Capability *)HSMalloc( sizeof(ASNH245H2250Capability) );
		new_ASNH245H2250Capability(tAlter);
		ASNH245H2250Capability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultiplexCapabilityChoice_genericMultiplexCapability ){
		ASNH245GenericCapability *tAlter = (ASNH245GenericCapability *)HSMalloc( sizeof(ASNH245GenericCapability) );
		new_ASNH245GenericCapability(tAlter);
		ASNH245GenericCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexCapability_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MultiplexCapability DeleteAlternation */
HS_RESULT ASNH245MultiplexCapability_DeleteAlternation(void *pObject)
{
	ASNH245MultiplexCapability *pObj = (ASNH245MultiplexCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexCapability_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MultiplexCapabilityChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h222Capability ){
			delete_ASNH245H222Capability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h223Capability ){
			delete_ASNH245H223Capability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_v76Capability ){
			delete_ASNH245V76Capability(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h2250Capability ){
			delete_ASNH245H2250Capability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_genericMultiplexCapability ){
			delete_ASNH245GenericCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MultiplexCapability_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MultiplexCapability Encode */
HS_RESULT ASNH245MultiplexCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MultiplexCapability *pObj = (ASNH245MultiplexCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexCapability_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MultiplexCapabilityChoiceSize )
		{
			if( pObj->choice > ((ASNH245MultiplexCapabilityChoice)(e_ASNH245MultiplexCapabilityChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MultiplexCapabilityChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MultiplexCapabilityChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexCapabilityChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h222Capability ){
		if( (tRet=ASNH245H222Capability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h223Capability ){
		if( (tRet=ASNH245H223Capability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_v76Capability ){
		if( (tRet=ASNH245V76Capability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h2250Capability ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245H2250Capability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_genericMultiplexCapability ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245GenericCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexCapability_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MultiplexCapability Decode */
HS_RESULT ASNH245MultiplexCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MultiplexCapability *pObj = (ASNH245MultiplexCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MultiplexCapabilityChoiceSize;
	}
	else
	{
		if( e_ASNH245MultiplexCapabilityChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MultiplexCapabilityChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MultiplexCapabilityChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MultiplexCapability_SetChoice( pObj, (ASNH245MultiplexCapabilityChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexCapabilityChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h222Capability ){
		if( (tRet=ASNH245H222Capability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h223Capability ){
		if( (tRet=ASNH245H223Capability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_v76Capability ){
		if( (tRet=ASNH245V76Capability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h2250Capability ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245H2250Capability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_genericMultiplexCapability ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245GenericCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexCapability_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexCapability Print */
HS_RESULT ASNH245MultiplexCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexCapability *pObj = (ASNH245MultiplexCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexCapabilityChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h222Capability ){
		ASNH245H222Capability_Print( pObj->alter, pDepth+1, "h222Capability" );
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h223Capability ){
		ASNH245H223Capability_Print( pObj->alter, pDepth+1, "h223Capability" );
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_v76Capability ){
		ASNH245V76Capability_Print( pObj->alter, pDepth+1, "v76Capability" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_h2250Capability ){
		ASNH245H2250Capability_Print( pObj->alter, pDepth+1, "h2250Capability" );
	}
	else if ( pObj->choice == e_ASNH245MultiplexCapabilityChoice_genericMultiplexCapability ){
		ASNH245GenericCapability_Print( pObj->alter, pDepth+1, "genericMultiplexCapability" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H261VideoCapability Class
*/
/*ASNH245H261VideoCapability Constructor*/
HS_RESULT new_ASNH245H261VideoCapability(void *pObject)
{
	ASNH245H261VideoCapability *pObj = (ASNH245H261VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H261VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_qcifMPI), e_constrained, 1, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cifMPI), e_constrained, 1, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_temporalSpatialTradeOffCapability) );
	new_AsnInteger( &(pObj->m_maxBitRate), e_constrained, 1, 19200, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_stillImageTransmission) );
	new_AsnBoolean( &(pObj->m_videoBadMBsCap) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H261VideoCapability Destructor */
HS_RESULT delete_ASNH245H261VideoCapability(void *pObject)
{
	ASNH245H261VideoCapability *pObj = (ASNH245H261VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H261VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_qcifMPI) );
	delete_AsnInteger( &(pObj->m_cifMPI) );
	delete_AsnBoolean( &(pObj->m_temporalSpatialTradeOffCapability) );
	delete_AsnInteger( &(pObj->m_maxBitRate) );
	delete_AsnBoolean( &(pObj->m_stillImageTransmission) );
	delete_AsnBoolean( &(pObj->m_videoBadMBsCap) );
	return HS_OK;
}

/* ASNH245H261VideoCapability MakeMold */
HS_RESULT ASNH245H261VideoCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H261VideoCapability *pObj = (ASNH245H261VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H261VideoCapability IncludeOptionalField */
HS_RESULT ASNH245H261VideoCapability_IncludeOptionField( void *pObject, ASNH245H261VideoCapabilityOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H261VideoCapability *pObj = (ASNH245H261VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H261VideoCapabilityOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H261VideoCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H261VideoCapabilityOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245H261VideoCapability IsIncludeOptionalField */
BOOL ASNH245H261VideoCapability_IsIncludeOptionField( void *pObject, ASNH245H261VideoCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H261VideoCapability *pObj = (ASNH245H261VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H261VideoCapabilityOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H261VideoCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H261VideoCapabilityOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H261VideoCapability Encode */
HS_RESULT ASNH245H261VideoCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H261VideoCapability *pObj = (ASNH245H261VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245H261VideoCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245H261VideoCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245H261VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H261VideoCapabilityOptionMap_qcifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_qcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H261VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H261VideoCapabilityOptionMap_cifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_temporalSpatialTradeOffCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maxBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_stillImageTransmission),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H261VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H261VideoCapabilityOptionMap_videoBadMBsCap ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_videoBadMBsCap), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H261VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H261VideoCapability Decode */
HS_RESULT ASNH245H261VideoCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H261VideoCapability *pObj = (ASNH245H261VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245H261VideoCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245H261VideoCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245H261VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H261VideoCapabilityOptionMap_qcifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_qcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H261VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H261VideoCapabilityOptionMap_cifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_temporalSpatialTradeOffCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_stillImageTransmission),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H261VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H261VideoCapabilityOptionMap_videoBadMBsCap ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_videoBadMBsCap), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H261VideoCapability Print */
HS_RESULT ASNH245H261VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H261VideoCapability *pObj = (ASNH245H261VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H261VideoCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245H261VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H261VideoCapabilityOptionMap_qcifMPI ) )
		AsnInteger_Print( &(pObj->m_qcifMPI), pDepth+1, "qcifMPI" );
	if( ASNH245H261VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H261VideoCapabilityOptionMap_cifMPI ) )
		AsnInteger_Print( &(pObj->m_cifMPI), pDepth+1, "cifMPI" );
	AsnBoolean_Print( &(pObj->m_temporalSpatialTradeOffCapability), pDepth+1, "temporalSpatialTradeOffCapability" );
	AsnInteger_Print( &(pObj->m_maxBitRate), pDepth+1, "maxBitRate" );
	AsnBoolean_Print( &(pObj->m_stillImageTransmission), pDepth+1, "stillImageTransmission" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H261VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H261VideoCapabilityOptionMap_videoBadMBsCap ) )
		AsnBoolean_Print( &(pObj->m_videoBadMBsCap), pDepth+1, "videoBadMBsCap" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H262VideoCapability Class
*/
/*ASNH245H262VideoCapability Constructor*/
HS_RESULT new_ASNH245H262VideoCapability(void *pObject)
{
	ASNH245H262VideoCapability *pObj = (ASNH245H262VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H262VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_profileAndLevel_SPatML) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_MPatLL) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_MPatML) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_MPatH_14) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_MPatHL) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_SNRatLL) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_SNRatML) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_SpatialatH_14) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_HPatML) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_HPatH_14) );
	new_AsnBoolean( &(pObj->m_profileAndLevel_HPatHL) );
	new_AsnInteger( &(pObj->m_videoBitRate), e_constrained, 0, 1073741823, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_vbvBufferSize), e_constrained, 0, 262143, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_samplesPerLine), e_constrained, 0, 16383, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_linesPerFrame), e_constrained, 0, 16383, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_framesPerSecond), e_constrained, 0, 15, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_luminanceSampleRate), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_videoBadMBsCap) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H262VideoCapability Destructor */
HS_RESULT delete_ASNH245H262VideoCapability(void *pObject)
{
	ASNH245H262VideoCapability *pObj = (ASNH245H262VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H262VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_profileAndLevel_SPatML) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_MPatLL) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_MPatML) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_MPatH_14) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_MPatHL) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_SNRatLL) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_SNRatML) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_SpatialatH_14) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_HPatML) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_HPatH_14) );
	delete_AsnBoolean( &(pObj->m_profileAndLevel_HPatHL) );
	delete_AsnInteger( &(pObj->m_videoBitRate) );
	delete_AsnInteger( &(pObj->m_vbvBufferSize) );
	delete_AsnInteger( &(pObj->m_samplesPerLine) );
	delete_AsnInteger( &(pObj->m_linesPerFrame) );
	delete_AsnInteger( &(pObj->m_framesPerSecond) );
	delete_AsnInteger( &(pObj->m_luminanceSampleRate) );
	delete_AsnBoolean( &(pObj->m_videoBadMBsCap) );
	return HS_OK;
}

/* ASNH245H262VideoCapability MakeMold */
HS_RESULT ASNH245H262VideoCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H262VideoCapability *pObj = (ASNH245H262VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H262VideoCapability IncludeOptionalField */
HS_RESULT ASNH245H262VideoCapability_IncludeOptionField( void *pObject, ASNH245H262VideoCapabilityOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H262VideoCapability *pObj = (ASNH245H262VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H262VideoCapabilityOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H262VideoCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H262VideoCapabilityOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245H262VideoCapability IsIncludeOptionalField */
BOOL ASNH245H262VideoCapability_IsIncludeOptionField( void *pObject, ASNH245H262VideoCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H262VideoCapability *pObj = (ASNH245H262VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H262VideoCapabilityOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H262VideoCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H262VideoCapabilityOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H262VideoCapability Encode */
HS_RESULT ASNH245H262VideoCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H262VideoCapability *pObj = (ASNH245H262VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245H262VideoCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245H262VideoCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_SPatML),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_MPatLL),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_MPatML),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_MPatH_14),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_MPatHL),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_SNRatLL),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_SNRatML),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_SpatialatH_14),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_HPatML),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_HPatH_14),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_profileAndLevel_HPatHL),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_videoBitRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_videoBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_vbvBufferSize ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_vbvBufferSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_samplesPerLine ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_samplesPerLine),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_linesPerFrame ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_linesPerFrame),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_framesPerSecond ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_framesPerSecond),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_luminanceSampleRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_luminanceSampleRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_videoBadMBsCap ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_videoBadMBsCap), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H262VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H262VideoCapability Decode */
HS_RESULT ASNH245H262VideoCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H262VideoCapability *pObj = (ASNH245H262VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245H262VideoCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245H262VideoCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_SPatML),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_MPatLL),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_MPatML),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_MPatH_14),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_MPatHL),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_SNRatLL),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_SNRatML),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_SpatialatH_14),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_HPatML),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_HPatH_14),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_profileAndLevel_HPatHL),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_videoBitRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_videoBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_vbvBufferSize ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_vbvBufferSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_samplesPerLine ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_samplesPerLine),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_linesPerFrame ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_linesPerFrame),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_framesPerSecond ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_framesPerSecond),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_luminanceSampleRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_luminanceSampleRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_videoBadMBsCap ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_videoBadMBsCap), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H262VideoCapability Print */
HS_RESULT ASNH245H262VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H262VideoCapability *pObj = (ASNH245H262VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H262VideoCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_profileAndLevel_SPatML), pDepth+1, "profileAndLevel_SPatML" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_MPatLL), pDepth+1, "profileAndLevel_MPatLL" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_MPatML), pDepth+1, "profileAndLevel_MPatML" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_MPatH_14), pDepth+1, "profileAndLevel_MPatH_14" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_MPatHL), pDepth+1, "profileAndLevel_MPatHL" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_SNRatLL), pDepth+1, "profileAndLevel_SNRatLL" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_SNRatML), pDepth+1, "profileAndLevel_SNRatML" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_SpatialatH_14), pDepth+1, "profileAndLevel_SpatialatH_14" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_HPatML), pDepth+1, "profileAndLevel_HPatML" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_HPatH_14), pDepth+1, "profileAndLevel_HPatH_14" );
	AsnBoolean_Print( &(pObj->m_profileAndLevel_HPatHL), pDepth+1, "profileAndLevel_HPatHL" );
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_videoBitRate ) )
		AsnInteger_Print( &(pObj->m_videoBitRate), pDepth+1, "videoBitRate" );
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_vbvBufferSize ) )
		AsnInteger_Print( &(pObj->m_vbvBufferSize), pDepth+1, "vbvBufferSize" );
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_samplesPerLine ) )
		AsnInteger_Print( &(pObj->m_samplesPerLine), pDepth+1, "samplesPerLine" );
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_linesPerFrame ) )
		AsnInteger_Print( &(pObj->m_linesPerFrame), pDepth+1, "linesPerFrame" );
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_framesPerSecond ) )
		AsnInteger_Print( &(pObj->m_framesPerSecond), pDepth+1, "framesPerSecond" );
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_luminanceSampleRate ) )
		AsnInteger_Print( &(pObj->m_luminanceSampleRate), pDepth+1, "luminanceSampleRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H262VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H262VideoCapabilityOptionMap_videoBadMBsCap ) )
		AsnBoolean_Print( &(pObj->m_videoBadMBsCap), pDepth+1, "videoBadMBsCap" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TransparencyParameters Class
*/
/*ASNH245TransparencyParameters Constructor*/
HS_RESULT new_ASNH245TransparencyParameters(void *pObject)
{
	ASNH245TransparencyParameters *pObj = (ASNH245TransparencyParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TransparencyParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_presentationOrder), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_offset_x), e_constrained, -262144, 262143, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_offset_y), e_constrained, -262144, 262143, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_scale_x), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_scale_y), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245TransparencyParameters Destructor */
HS_RESULT delete_ASNH245TransparencyParameters(void *pObject)
{
	ASNH245TransparencyParameters *pObj = (ASNH245TransparencyParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TransparencyParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_presentationOrder) );
	delete_AsnInteger( &(pObj->m_offset_x) );
	delete_AsnInteger( &(pObj->m_offset_y) );
	delete_AsnInteger( &(pObj->m_scale_x) );
	delete_AsnInteger( &(pObj->m_scale_y) );
	return HS_OK;
}

/* ASNH245TransparencyParameters MakeMold */
HS_RESULT ASNH245TransparencyParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245TransparencyParameters *pObj = (ASNH245TransparencyParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245TransparencyParameters Encode */
HS_RESULT ASNH245TransparencyParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TransparencyParameters *pObj = (ASNH245TransparencyParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_presentationOrder),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_offset_x),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_offset_y),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_scale_x),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_scale_y),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245TransparencyParameters Decode */
HS_RESULT ASNH245TransparencyParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TransparencyParameters *pObj = (ASNH245TransparencyParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_presentationOrder),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_offset_x),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_offset_y),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_scale_x),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_scale_y),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransparencyParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TransparencyParameters Print */
HS_RESULT ASNH245TransparencyParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TransparencyParameters *pObj = (ASNH245TransparencyParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TransparencyParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_presentationOrder), pDepth+1, "presentationOrder" );
	AsnInteger_Print( &(pObj->m_offset_x), pDepth+1, "offset_x" );
	AsnInteger_Print( &(pObj->m_offset_y), pDepth+1, "offset_y" );
	AsnInteger_Print( &(pObj->m_scale_x), pDepth+1, "scale_x" );
	AsnInteger_Print( &(pObj->m_scale_y), pDepth+1, "scale_y" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RefPictureSelection_additionalPictureMemory Class
*/
/*ASNH245RefPictureSelection_additionalPictureMemory Constructor*/
HS_RESULT new_ASNH245RefPictureSelection_additionalPictureMemory(void *pObject)
{
	ASNH245RefPictureSelection_additionalPictureMemory *pObj = (ASNH245RefPictureSelection_additionalPictureMemory *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RefPictureSelection_additionalPictureMemory(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_sqcifAdditionalPictureMemory), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_qcifAdditionalPictureMemory), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cifAdditionalPictureMemory), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cif4AdditionalPictureMemory), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cif16AdditionalPictureMemory), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_bigCpfAdditionalPictureMemory), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245RefPictureSelection_additionalPictureMemory Destructor */
HS_RESULT delete_ASNH245RefPictureSelection_additionalPictureMemory(void *pObject)
{
	ASNH245RefPictureSelection_additionalPictureMemory *pObj = (ASNH245RefPictureSelection_additionalPictureMemory *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RefPictureSelection_additionalPictureMemory(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_sqcifAdditionalPictureMemory) );
	delete_AsnInteger( &(pObj->m_qcifAdditionalPictureMemory) );
	delete_AsnInteger( &(pObj->m_cifAdditionalPictureMemory) );
	delete_AsnInteger( &(pObj->m_cif4AdditionalPictureMemory) );
	delete_AsnInteger( &(pObj->m_cif16AdditionalPictureMemory) );
	delete_AsnInteger( &(pObj->m_bigCpfAdditionalPictureMemory) );
	return HS_OK;
}

/* ASNH245RefPictureSelection_additionalPictureMemory MakeMold */
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RefPictureSelection_additionalPictureMemory *pObj = (ASNH245RefPictureSelection_additionalPictureMemory *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245RefPictureSelection_additionalPictureMemory IncludeOptionalField */
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_IncludeOptionField( void *pObject, ASNH245RefPictureSelection_additionalPictureMemoryOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245RefPictureSelection_additionalPictureMemory *pObj = (ASNH245RefPictureSelection_additionalPictureMemory *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245RefPictureSelection_additionalPictureMemory IsIncludeOptionalField */
BOOL ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( void *pObject, ASNH245RefPictureSelection_additionalPictureMemoryOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245RefPictureSelection_additionalPictureMemory *pObj = (ASNH245RefPictureSelection_additionalPictureMemory *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245RefPictureSelection_additionalPictureMemory Encode */
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RefPictureSelection_additionalPictureMemory *pObj = (ASNH245RefPictureSelection_additionalPictureMemory *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_sqcifAdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_sqcifAdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_qcifAdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_qcifAdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cifAdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cifAdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cif4AdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cif4AdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cif16AdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cif16AdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_bigCpfAdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_bigCpfAdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245RefPictureSelection_additionalPictureMemory Decode */
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RefPictureSelection_additionalPictureMemory *pObj = (ASNH245RefPictureSelection_additionalPictureMemory *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_sqcifAdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_sqcifAdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_qcifAdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_qcifAdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cifAdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cifAdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cif4AdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cif4AdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cif16AdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cif16AdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_bigCpfAdditionalPictureMemory ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_bigCpfAdditionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RefPictureSelection_additionalPictureMemory Print */
HS_RESULT ASNH245RefPictureSelection_additionalPictureMemory_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RefPictureSelection_additionalPictureMemory *pObj = (ASNH245RefPictureSelection_additionalPictureMemory *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RefPictureSelection_additionalPictureMemory_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_sqcifAdditionalPictureMemory ) )
		AsnInteger_Print( &(pObj->m_sqcifAdditionalPictureMemory), pDepth+1, "sqcifAdditionalPictureMemory" );
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_qcifAdditionalPictureMemory ) )
		AsnInteger_Print( &(pObj->m_qcifAdditionalPictureMemory), pDepth+1, "qcifAdditionalPictureMemory" );
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cifAdditionalPictureMemory ) )
		AsnInteger_Print( &(pObj->m_cifAdditionalPictureMemory), pDepth+1, "cifAdditionalPictureMemory" );
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cif4AdditionalPictureMemory ) )
		AsnInteger_Print( &(pObj->m_cif4AdditionalPictureMemory), pDepth+1, "cif4AdditionalPictureMemory" );
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_cif16AdditionalPictureMemory ) )
		AsnInteger_Print( &(pObj->m_cif16AdditionalPictureMemory), pDepth+1, "cif16AdditionalPictureMemory" );
	if( ASNH245RefPictureSelection_additionalPictureMemory_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_additionalPictureMemoryOptionMap_bigCpfAdditionalPictureMemory ) )
		AsnInteger_Print( &(pObj->m_bigCpfAdditionalPictureMemory), pDepth+1, "bigCpfAdditionalPictureMemory" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RefPictureSelection_videoBackChannelSend Struct
*/
/* ASNH245RefPictureSelection_videoBackChannelSend Constructor */
HS_RESULT new_ASNH245RefPictureSelection_videoBackChannelSend( void *pObject )
{
	ASNH245RefPictureSelection_videoBackChannelSend *pObj = (ASNH245RefPictureSelection_videoBackChannelSend *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RefPictureSelection_videoBackChannelSend(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RefPictureSelection_videoBackChannelSendChoice_none;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RefPictureSelection_videoBackChannelSend Destructor */
HS_RESULT delete_ASNH245RefPictureSelection_videoBackChannelSend( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RefPictureSelection_videoBackChannelSend *pObj = (ASNH245RefPictureSelection_videoBackChannelSend *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RefPictureSelection_videoBackChannelSend(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RefPictureSelection_videoBackChannelSend_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RefPictureSelection_videoBackChannelSend(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RefPictureSelection_videoBackChannelSend SetChoice */
void* ASNH245RefPictureSelection_videoBackChannelSend_SetChoice( void *pObject, ASNH245RefPictureSelection_videoBackChannelSendChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RefPictureSelection_videoBackChannelSend *pObj = (ASNH245RefPictureSelection_videoBackChannelSend *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSizeExt ){
		if( pChoice > (ASNH245RefPictureSelection_videoBackChannelSendChoice)(e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RefPictureSelection_videoBackChannelSend_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_none ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackMessageOnly ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_nackMessageOnly ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackOrNackMessageOnly ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackAndNackMessage ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RefPictureSelection_videoBackChannelSend DeleteAlternation */
HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_DeleteAlternation(void *pObject)
{
	ASNH245RefPictureSelection_videoBackChannelSend *pObj = (ASNH245RefPictureSelection_videoBackChannelSend *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_none ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackMessageOnly ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_nackMessageOnly ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackOrNackMessageOnly ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackAndNackMessage ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RefPictureSelection_videoBackChannelSend Encode */
HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RefPictureSelection_videoBackChannelSend *pObj = (ASNH245RefPictureSelection_videoBackChannelSend *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSize )
		{
			if( pObj->choice > ((ASNH245RefPictureSelection_videoBackChannelSendChoice)(e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_none ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackMessageOnly ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_nackMessageOnly ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackOrNackMessageOnly ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackAndNackMessage ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RefPictureSelection_videoBackChannelSend Decode */
HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RefPictureSelection_videoBackChannelSend *pObj = (ASNH245RefPictureSelection_videoBackChannelSend *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSize;
	}
	else
	{
		if( e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RefPictureSelection_videoBackChannelSendChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RefPictureSelection_videoBackChannelSend_SetChoice( pObj, (ASNH245RefPictureSelection_videoBackChannelSendChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_none ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackMessageOnly ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_nackMessageOnly ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackOrNackMessageOnly ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackAndNackMessage ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RefPictureSelection_videoBackChannelSend Print */
HS_RESULT ASNH245RefPictureSelection_videoBackChannelSend_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RefPictureSelection_videoBackChannelSend *pObj = (ASNH245RefPictureSelection_videoBackChannelSend *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RefPictureSelection_videoBackChannelSend_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_none ){
		AsnNull_Print( pObj->alter, pDepth+1, "none" );
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackMessageOnly ){
		AsnNull_Print( pObj->alter, pDepth+1, "ackMessageOnly" );
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_nackMessageOnly ){
		AsnNull_Print( pObj->alter, pDepth+1, "nackMessageOnly" );
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackOrNackMessageOnly ){
		AsnNull_Print( pObj->alter, pDepth+1, "ackOrNackMessageOnly" );
	}
	else if ( pObj->choice == e_ASNH245RefPictureSelection_videoBackChannelSendChoice_ackAndNackMessage ){
		AsnNull_Print( pObj->alter, pDepth+1, "ackAndNackMessage" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters Class
*/
/*ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters Constructor*/
HS_RESULT new_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters(void *pObject)
{
	ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_mpuHorizMBs), e_constrained, 1, 128, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_mpuVertMBs), e_constrained, 1, 72, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_mpuTotalNumber), e_constrained, 1, 65536, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters Destructor */
HS_RESULT delete_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters(void *pObject)
{
	ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_mpuHorizMBs) );
	delete_AsnInteger( &(pObj->m_mpuVertMBs) );
	delete_AsnInteger( &(pObj->m_mpuTotalNumber) );
	return HS_OK;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters MakeMold */
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters Encode */
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_mpuHorizMBs),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_mpuVertMBs),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_mpuTotalNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters Decode */
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_mpuHorizMBs),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_mpuVertMBs),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_mpuTotalNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters Print */
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_mpuHorizMBs), pDepth+1, "mpuHorizMBs" );
	AsnInteger_Print( &(pObj->m_mpuVertMBs), pDepth+1, "mpuVertMBs" );
	AsnInteger_Print( &(pObj->m_mpuTotalNumber), pDepth+1, "mpuTotalNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RefPictureSelection_enhancedReferencePicSelect Class
*/
/*ASNH245RefPictureSelection_enhancedReferencePicSelect Constructor*/
HS_RESULT new_ASNH245RefPictureSelection_enhancedReferencePicSelect(void *pObject)
{
	ASNH245RefPictureSelection_enhancedReferencePicSelect *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RefPictureSelection_enhancedReferencePicSelect(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters( &(pObj->m_subPictureRemovalParameters) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect Destructor */
HS_RESULT delete_ASNH245RefPictureSelection_enhancedReferencePicSelect(void *pObject)
{
	ASNH245RefPictureSelection_enhancedReferencePicSelect *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RefPictureSelection_enhancedReferencePicSelect(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters( &(pObj->m_subPictureRemovalParameters) );
	return HS_OK;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect MakeMold */
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RefPictureSelection_enhancedReferencePicSelect *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_MakeMold(&(pObj->m_subPictureRemovalParameters));
	return HS_OK;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect IncludeOptionalField */
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_IncludeOptionField( void *pObject, ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245RefPictureSelection_enhancedReferencePicSelect *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect IsIncludeOptionalField */
BOOL ASNH245RefPictureSelection_enhancedReferencePicSelect_IsIncludeOptionField( void *pObject, ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245RefPictureSelection_enhancedReferencePicSelect *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect Encode */
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RefPictureSelection_enhancedReferencePicSelect *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245RefPictureSelection_enhancedReferencePicSelect_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMap_subPictureRemovalParameters ) ){
		if( (tRet=ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Encode( &(pObj->m_subPictureRemovalParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245RefPictureSelection_enhancedReferencePicSelect Decode */
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RefPictureSelection_enhancedReferencePicSelect *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245RefPictureSelection_enhancedReferencePicSelect_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMap_subPictureRemovalParameters ) ){
		if( (tRet=ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Decode(&(pObj->m_subPictureRemovalParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RefPictureSelection_enhancedReferencePicSelect Print */
HS_RESULT ASNH245RefPictureSelection_enhancedReferencePicSelect_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RefPictureSelection_enhancedReferencePicSelect *pObj = (ASNH245RefPictureSelection_enhancedReferencePicSelect *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RefPictureSelection_enhancedReferencePicSelect_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245RefPictureSelection_enhancedReferencePicSelect_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelection_enhancedReferencePicSelectOptionMap_subPictureRemovalParameters ) )
		ASNH245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters_Print( &(pObj->m_subPictureRemovalParameters), pDepth+1, "subPictureRemovalParameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RefPictureSelection Class
*/
/*ASNH245RefPictureSelection Constructor*/
HS_RESULT new_ASNH245RefPictureSelection(void *pObject)
{
	ASNH245RefPictureSelection *pObj = (ASNH245RefPictureSelection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RefPictureSelection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245RefPictureSelection_additionalPictureMemory( &(pObj->m_additionalPictureMemory) );
	new_AsnBoolean( &(pObj->m_videoMux) );
	new_ASNH245RefPictureSelection_videoBackChannelSend( &(pObj->m_videoBackChannelSend) );
	new_ASNH245RefPictureSelection_enhancedReferencePicSelect( &(pObj->m_enhancedReferencePicSelect) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245RefPictureSelection Destructor */
HS_RESULT delete_ASNH245RefPictureSelection(void *pObject)
{
	ASNH245RefPictureSelection *pObj = (ASNH245RefPictureSelection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RefPictureSelection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245RefPictureSelection_additionalPictureMemory( &(pObj->m_additionalPictureMemory) );
	delete_AsnBoolean( &(pObj->m_videoMux) );
	delete_ASNH245RefPictureSelection_videoBackChannelSend( &(pObj->m_videoBackChannelSend) );
	delete_ASNH245RefPictureSelection_enhancedReferencePicSelect( &(pObj->m_enhancedReferencePicSelect) );
	return HS_OK;
}

/* ASNH245RefPictureSelection MakeMold */
HS_RESULT ASNH245RefPictureSelection_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RefPictureSelection *pObj = (ASNH245RefPictureSelection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245RefPictureSelection_additionalPictureMemory_MakeMold(&(pObj->m_additionalPictureMemory));
	ASNH245RefPictureSelection_enhancedReferencePicSelect_MakeMold(&(pObj->m_enhancedReferencePicSelect));
	return HS_OK;
}

/* ASNH245RefPictureSelection IncludeOptionalField */
HS_RESULT ASNH245RefPictureSelection_IncludeOptionField( void *pObject, ASNH245RefPictureSelectionOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245RefPictureSelection *pObj = (ASNH245RefPictureSelection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245RefPictureSelectionOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245RefPictureSelectionOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245RefPictureSelectionOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245RefPictureSelection IsIncludeOptionalField */
BOOL ASNH245RefPictureSelection_IsIncludeOptionField( void *pObject, ASNH245RefPictureSelectionOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245RefPictureSelection *pObj = (ASNH245RefPictureSelection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245RefPictureSelectionOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245RefPictureSelectionOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245RefPictureSelectionOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245RefPictureSelection Encode */
HS_RESULT ASNH245RefPictureSelection_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RefPictureSelection *pObj = (ASNH245RefPictureSelection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245RefPictureSelectionOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245RefPictureSelectionOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245RefPictureSelection_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelectionOptionMap_additionalPictureMemory ) ){
		if( (tRet=ASNH245RefPictureSelection_additionalPictureMemory_Encode( &(pObj->m_additionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_videoMux),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RefPictureSelection_videoBackChannelSend_Encode( &(pObj->m_videoBackChannelSend),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245RefPictureSelection_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelectionOptionMap_enhancedReferencePicSelect ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_enhancedReferencePicSelect), ASNH245RefPictureSelection_enhancedReferencePicSelect_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245RefPictureSelection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245RefPictureSelection Decode */
HS_RESULT ASNH245RefPictureSelection_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RefPictureSelection *pObj = (ASNH245RefPictureSelection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245RefPictureSelectionOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245RefPictureSelectionOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245RefPictureSelection_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelectionOptionMap_additionalPictureMemory ) ){
		if( (tRet=ASNH245RefPictureSelection_additionalPictureMemory_Decode(&(pObj->m_additionalPictureMemory),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_videoMux),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RefPictureSelection_videoBackChannelSend_Decode(&(pObj->m_videoBackChannelSend),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RefPictureSelection_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245RefPictureSelection_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelectionOptionMap_enhancedReferencePicSelect ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_enhancedReferencePicSelect), ASNH245RefPictureSelection_enhancedReferencePicSelect_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RefPictureSelection_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RefPictureSelection Print */
HS_RESULT ASNH245RefPictureSelection_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RefPictureSelection *pObj = (ASNH245RefPictureSelection *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RefPictureSelection_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245RefPictureSelection_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelectionOptionMap_additionalPictureMemory ) )
		ASNH245RefPictureSelection_additionalPictureMemory_Print( &(pObj->m_additionalPictureMemory), pDepth+1, "additionalPictureMemory" );
	AsnBoolean_Print( &(pObj->m_videoMux), pDepth+1, "videoMux" );
	ASNH245RefPictureSelection_videoBackChannelSend_Print( &(pObj->m_videoBackChannelSend), pDepth+1, "videoBackChannelSend" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245RefPictureSelection_IsIncludeOptionField( pObj, e_ASNH245RefPictureSelectionOptionMap_enhancedReferencePicSelect ) )
		ASNH245RefPictureSelection_enhancedReferencePicSelect_Print( &(pObj->m_enhancedReferencePicSelect), pDepth+1, "enhancedReferencePicSelect" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CustomPictureClockFrequency Class
*/
/*ASNH245CustomPictureClockFrequency Constructor*/
HS_RESULT new_ASNH245CustomPictureClockFrequency(void *pObject)
{
	ASNH245CustomPictureClockFrequency *pObj = (ASNH245CustomPictureClockFrequency *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CustomPictureClockFrequency(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_clockConversionCode), e_constrained, 1000, 1001, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_clockDivisor), e_constrained, 1, 127, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_sqcifMPI), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_qcifMPI), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cifMPI), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cif4MPI), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cif16MPI), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245CustomPictureClockFrequency Destructor */
HS_RESULT delete_ASNH245CustomPictureClockFrequency(void *pObject)
{
	ASNH245CustomPictureClockFrequency *pObj = (ASNH245CustomPictureClockFrequency *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CustomPictureClockFrequency(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_clockConversionCode) );
	delete_AsnInteger( &(pObj->m_clockDivisor) );
	delete_AsnInteger( &(pObj->m_sqcifMPI) );
	delete_AsnInteger( &(pObj->m_qcifMPI) );
	delete_AsnInteger( &(pObj->m_cifMPI) );
	delete_AsnInteger( &(pObj->m_cif4MPI) );
	delete_AsnInteger( &(pObj->m_cif16MPI) );
	return HS_OK;
}

/* ASNH245CustomPictureClockFrequency MakeMold */
HS_RESULT ASNH245CustomPictureClockFrequency_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CustomPictureClockFrequency *pObj = (ASNH245CustomPictureClockFrequency *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245CustomPictureClockFrequency IncludeOptionalField */
HS_RESULT ASNH245CustomPictureClockFrequency_IncludeOptionField( void *pObject, ASNH245CustomPictureClockFrequencyOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245CustomPictureClockFrequency *pObj = (ASNH245CustomPictureClockFrequency *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245CustomPictureClockFrequencyOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245CustomPictureClockFrequency IsIncludeOptionalField */
BOOL ASNH245CustomPictureClockFrequency_IsIncludeOptionField( void *pObject, ASNH245CustomPictureClockFrequencyOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245CustomPictureClockFrequency *pObj = (ASNH245CustomPictureClockFrequency *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245CustomPictureClockFrequencyOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245CustomPictureClockFrequency Encode */
HS_RESULT ASNH245CustomPictureClockFrequency_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245CustomPictureClockFrequency *pObj = (ASNH245CustomPictureClockFrequency *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245CustomPictureClockFrequencyOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245CustomPictureClockFrequencyOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Encode( &(pObj->m_clockConversionCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_clockDivisor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_sqcifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_sqcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_qcifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_qcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_cifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_cif4MPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cif4MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_cif16MPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cif16MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245CustomPictureClockFrequency Decode */
HS_RESULT ASNH245CustomPictureClockFrequency_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245CustomPictureClockFrequency *pObj = (ASNH245CustomPictureClockFrequency *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245CustomPictureClockFrequencyOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245CustomPictureClockFrequencyOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_clockConversionCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_clockDivisor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_sqcifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_sqcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_qcifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_qcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_cifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_cif4MPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cif4MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_cif16MPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cif16MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CustomPictureClockFrequency Print */
HS_RESULT ASNH245CustomPictureClockFrequency_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CustomPictureClockFrequency *pObj = (ASNH245CustomPictureClockFrequency *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CustomPictureClockFrequency_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_clockConversionCode), pDepth+1, "clockConversionCode" );
	AsnInteger_Print( &(pObj->m_clockDivisor), pDepth+1, "clockDivisor" );
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_sqcifMPI ) )
		AsnInteger_Print( &(pObj->m_sqcifMPI), pDepth+1, "sqcifMPI" );
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_qcifMPI ) )
		AsnInteger_Print( &(pObj->m_qcifMPI), pDepth+1, "qcifMPI" );
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_cifMPI ) )
		AsnInteger_Print( &(pObj->m_cifMPI), pDepth+1, "cifMPI" );
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_cif4MPI ) )
		AsnInteger_Print( &(pObj->m_cif4MPI), pDepth+1, "cif4MPI" );
	if( ASNH245CustomPictureClockFrequency_IsIncludeOptionField( pObj, e_ASNH245CustomPictureClockFrequencyOptionMap_cif16MPI ) )
		AsnInteger_Print( &(pObj->m_cif16MPI), pDepth+1, "cif16MPI" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CustomPictureFormat_mPI_customPCF Class
*/
/*ASNH245CustomPictureFormat_mPI_customPCF Constructor*/
HS_RESULT new_ASNH245CustomPictureFormat_mPI_customPCF(void *pObject)
{
	ASNH245CustomPictureFormat_mPI_customPCF *pObj = (ASNH245CustomPictureFormat_mPI_customPCF *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CustomPictureFormat_mPI_customPCF(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_clockConversionCode), e_constrained, 1000, 1001, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_clockDivisor), e_constrained, 1, 127, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_customMPI), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245CustomPictureFormat_mPI_customPCF Destructor */
HS_RESULT delete_ASNH245CustomPictureFormat_mPI_customPCF(void *pObject)
{
	ASNH245CustomPictureFormat_mPI_customPCF *pObj = (ASNH245CustomPictureFormat_mPI_customPCF *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CustomPictureFormat_mPI_customPCF(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_clockConversionCode) );
	delete_AsnInteger( &(pObj->m_clockDivisor) );
	delete_AsnInteger( &(pObj->m_customMPI) );
	return HS_OK;
}

/* ASNH245CustomPictureFormat_mPI_customPCF MakeMold */
HS_RESULT ASNH245CustomPictureFormat_mPI_customPCF_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CustomPictureFormat_mPI_customPCF *pObj = (ASNH245CustomPictureFormat_mPI_customPCF *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245CustomPictureFormat_mPI_customPCF Encode */
HS_RESULT ASNH245CustomPictureFormat_mPI_customPCF_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CustomPictureFormat_mPI_customPCF *pObj = (ASNH245CustomPictureFormat_mPI_customPCF *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_clockConversionCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_clockDivisor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_customMPI),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245CustomPictureFormat_mPI_customPCF Decode */
HS_RESULT ASNH245CustomPictureFormat_mPI_customPCF_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CustomPictureFormat_mPI_customPCF *pObj = (ASNH245CustomPictureFormat_mPI_customPCF *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_clockConversionCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_clockDivisor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_customMPI),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CustomPictureFormat_mPI_customPCF Print */
HS_RESULT ASNH245CustomPictureFormat_mPI_customPCF_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CustomPictureFormat_mPI_customPCF *pObj = (ASNH245CustomPictureFormat_mPI_customPCF *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_customPCF_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_clockConversionCode), pDepth+1, "clockConversionCode" );
	AsnInteger_Print( &(pObj->m_clockDivisor), pDepth+1, "clockDivisor" );
	AsnInteger_Print( &(pObj->m_customMPI), pDepth+1, "customMPI" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CustomPictureFormat_mPI Class
*/
/*ASNH245CustomPictureFormat_mPI Constructor*/
HS_RESULT new_ASNH245CustomPictureFormat_mPI(void *pObject)
{
	ASNH245CustomPictureFormat_mPI *pObj = (ASNH245CustomPictureFormat_mPI *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CustomPictureFormat_mPI(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_standardMPI), e_constrained, 1, 31, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_customPCF), e_constrained,1,16,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245CustomPictureFormat_mPI Destructor */
HS_RESULT delete_ASNH245CustomPictureFormat_mPI(void *pObject)
{
	ASNH245CustomPictureFormat_mPI *pObj = (ASNH245CustomPictureFormat_mPI *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CustomPictureFormat_mPI(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_standardMPI) );
	delete_AsnSequenceOf( &(pObj->m_customPCF) );
	return HS_OK;
}

/* ASNH245CustomPictureFormat_mPI MakeMold */
HS_RESULT ASNH245CustomPictureFormat_mPI_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CustomPictureFormat_mPI *pObj = (ASNH245CustomPictureFormat_mPI *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245CustomPictureFormat_mPI_customPCF *tmold_customPCF = (ASNH245CustomPictureFormat_mPI_customPCF *)HSMalloc( sizeof(ASNH245CustomPictureFormat_mPI_customPCF) );
	new_ASNH245CustomPictureFormat_mPI_customPCF(tmold_customPCF);
	ASNH245CustomPictureFormat_mPI_customPCF_MakeMold(tmold_customPCF);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_customPCF,sizeof(ASNH245CustomPictureFormat_mPI_customPCF),ASNH245CustomPictureFormat_mPI_customPCF_MakeMold,ASNH245CustomPictureFormat_mPI_customPCF_Encode,ASNH245CustomPictureFormat_mPI_customPCF_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245CustomPictureFormat_mPI_customPCF_Print,
#endif
		delete_ASNH245CustomPictureFormat_mPI_customPCF);
	AsnSequenceOf_SetMold( &(pObj->m_customPCF), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_customPCF.constraint.type = e_constrained;
	pObj->m_customPCF.constraint.minValue = 1;
	pObj->m_customPCF.constraint.maxValue = 16;
	pObj->m_customPCF.extMinValue = 0;
	pObj->m_customPCF.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245CustomPictureFormat_mPI IncludeOptionalField */
HS_RESULT ASNH245CustomPictureFormat_mPI_IncludeOptionField( void *pObject, ASNH245CustomPictureFormat_mPIOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245CustomPictureFormat_mPI *pObj = (ASNH245CustomPictureFormat_mPI *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245CustomPictureFormat_mPIOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245CustomPictureFormat_mPI IsIncludeOptionalField */
BOOL ASNH245CustomPictureFormat_mPI_IsIncludeOptionField( void *pObject, ASNH245CustomPictureFormat_mPIOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245CustomPictureFormat_mPI *pObj = (ASNH245CustomPictureFormat_mPI *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245CustomPictureFormat_mPIOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245CustomPictureFormat_mPI Encode */
HS_RESULT ASNH245CustomPictureFormat_mPI_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245CustomPictureFormat_mPI *pObj = (ASNH245CustomPictureFormat_mPI *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245CustomPictureFormat_mPIOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245CustomPictureFormat_mPIOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245CustomPictureFormat_mPI_IsIncludeOptionField( pObj, e_ASNH245CustomPictureFormat_mPIOptionMap_standardMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_standardMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureFormat_mPI_IsIncludeOptionField( pObj, e_ASNH245CustomPictureFormat_mPIOptionMap_customPCF ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_customPCF),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245CustomPictureFormat_mPI Decode */
HS_RESULT ASNH245CustomPictureFormat_mPI_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245CustomPictureFormat_mPI *pObj = (ASNH245CustomPictureFormat_mPI *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245CustomPictureFormat_mPIOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245CustomPictureFormat_mPIOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245CustomPictureFormat_mPI_IsIncludeOptionField( pObj, e_ASNH245CustomPictureFormat_mPIOptionMap_standardMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_standardMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CustomPictureFormat_mPI_IsIncludeOptionField( pObj, e_ASNH245CustomPictureFormat_mPIOptionMap_customPCF ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_customPCF),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CustomPictureFormat_mPI Print */
HS_RESULT ASNH245CustomPictureFormat_mPI_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CustomPictureFormat_mPI *pObj = (ASNH245CustomPictureFormat_mPI *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CustomPictureFormat_mPI_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245CustomPictureFormat_mPI_IsIncludeOptionField( pObj, e_ASNH245CustomPictureFormat_mPIOptionMap_standardMPI ) )
		AsnInteger_Print( &(pObj->m_standardMPI), pDepth+1, "standardMPI" );
	if( ASNH245CustomPictureFormat_mPI_IsIncludeOptionField( pObj, e_ASNH245CustomPictureFormat_mPIOptionMap_customPCF ) )
		AsnSequenceOf_Print( &(pObj->m_customPCF), pDepth+1, "customPCF" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR Class
*/
/*ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR Constructor*/
HS_RESULT new_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR(void *pObject)
{
	ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_width), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_height), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR Destructor */
HS_RESULT delete_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR(void *pObject)
{
	ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_width) );
	delete_AsnInteger( &(pObj->m_height) );
	return HS_OK;
}

/* ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR MakeMold */
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR Encode */
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_width),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_height),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR Decode */
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_width),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_height),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR Print */
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_width), pDepth+1, "width" );
	AsnInteger_Print( &(pObj->m_height), pDepth+1, "height" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CustomPictureFormat_pixelAspectInformation Struct
*/
/* ASNH245CustomPictureFormat_pixelAspectInformation Constructor */
HS_RESULT new_ASNH245CustomPictureFormat_pixelAspectInformation( void *pObject )
{
	ASNH245CustomPictureFormat_pixelAspectInformation *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CustomPictureFormat_pixelAspectInformation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_anyPixelAspectRatio;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245CustomPictureFormat_pixelAspectInformation Destructor */
HS_RESULT delete_ASNH245CustomPictureFormat_pixelAspectInformation( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245CustomPictureFormat_pixelAspectInformation *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CustomPictureFormat_pixelAspectInformation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245CustomPictureFormat_pixelAspectInformation_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CustomPictureFormat_pixelAspectInformation(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245CustomPictureFormat_pixelAspectInformation SetChoice */
void* ASNH245CustomPictureFormat_pixelAspectInformation_SetChoice( void *pObject, ASNH245CustomPictureFormat_pixelAspectInformationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245CustomPictureFormat_pixelAspectInformation *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSizeExt ){
		if( pChoice > (ASNH245CustomPictureFormat_pixelAspectInformationChoice)(e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245CustomPictureFormat_pixelAspectInformation_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_anyPixelAspectRatio ){
		AsnBoolean *tAlter = (AsnBoolean *)HSMalloc( sizeof(AsnBoolean) );
		new_AsnBoolean(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_pixelAspectCode ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,1,14,0,HS_ASN_MAX_CONSTRAINT);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_constrained,1,14,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(AsnInteger),AsnInteger_MakeMold,AsnInteger_Encode,AsnInteger_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			AsnInteger_Print,
#endif
			delete_AsnInteger );
		AsnSequenceOf_SetMold(aso,tmold);
		/* Sequence Of constraint */
		aso->constraint.type = e_constrained;
		aso->constraint.minValue = 1;
		aso->constraint.maxValue = 14;
		aso->extMinValue = 0;
		aso->extMaxValue = HS_ASN_MAX_CONSTRAINT;
		pObj->alter = aso;
	}
	else if ( pChoice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_extendedPAR ){
		ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *tAlter = (ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR *)HSMalloc( sizeof(ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR) );
		new_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR(tAlter);
		ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR),ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_MakeMold,ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Encode,ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR_Print,
#endif
			delete_ASNH245CustomPictureFormat_pixelAspectInformation_extendedPAR );
		AsnSequenceOf_SetMold(aso,tmold);
		/* Sequence Of constraint */
		aso->constraint.type = e_constrained;
		aso->constraint.minValue = 1;
		aso->constraint.maxValue = 256;
		aso->extMinValue = 0;
		aso->extMaxValue = HS_ASN_MAX_CONSTRAINT;
		pObj->alter = aso;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245CustomPictureFormat_pixelAspectInformation DeleteAlternation */
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_DeleteAlternation(void *pObject)
{
	ASNH245CustomPictureFormat_pixelAspectInformation *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_anyPixelAspectRatio ){
			delete_AsnBoolean(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_pixelAspectCode ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_extendedPAR ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245CustomPictureFormat_pixelAspectInformation Encode */
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245CustomPictureFormat_pixelAspectInformation *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSize )
		{
			if( pObj->choice > ((ASNH245CustomPictureFormat_pixelAspectInformationChoice)(e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_anyPixelAspectRatio ){
		if( (tRet=AsnBoolean_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_pixelAspectCode ){
		if( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_extendedPAR ){
		if( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245CustomPictureFormat_pixelAspectInformation Decode */
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245CustomPictureFormat_pixelAspectInformation *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSize;
	}
	else
	{
		if( e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245CustomPictureFormat_pixelAspectInformationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245CustomPictureFormat_pixelAspectInformation_SetChoice( pObj, (ASNH245CustomPictureFormat_pixelAspectInformationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_anyPixelAspectRatio ){
		if( (tRet=AsnBoolean_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_pixelAspectCode ){
		if( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_extendedPAR ){
		if( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CustomPictureFormat_pixelAspectInformation Print */
HS_RESULT ASNH245CustomPictureFormat_pixelAspectInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CustomPictureFormat_pixelAspectInformation *pObj = (ASNH245CustomPictureFormat_pixelAspectInformation *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CustomPictureFormat_pixelAspectInformation_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_anyPixelAspectRatio ){
		AsnBoolean_Print( pObj->alter, pDepth+1, "anyPixelAspectRatio" );
	}
	else if ( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_pixelAspectCode ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "pixelAspectCode" );
	}
	else if ( pObj->choice == e_ASNH245CustomPictureFormat_pixelAspectInformationChoice_extendedPAR ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "extendedPAR" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CustomPictureFormat Class
*/
/*ASNH245CustomPictureFormat Constructor*/
HS_RESULT new_ASNH245CustomPictureFormat(void *pObject)
{
	ASNH245CustomPictureFormat *pObj = (ASNH245CustomPictureFormat *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CustomPictureFormat(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_maxCustomPictureWidth), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maxCustomPictureHeight), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_minCustomPictureWidth), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_minCustomPictureHeight), e_constrained, 1, 2048, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245CustomPictureFormat_mPI( &(pObj->m_mPI) );
	new_ASNH245CustomPictureFormat_pixelAspectInformation( &(pObj->m_pixelAspectInformation) );

	return HS_OK;
}

/* ASNH245CustomPictureFormat Destructor */
HS_RESULT delete_ASNH245CustomPictureFormat(void *pObject)
{
	ASNH245CustomPictureFormat *pObj = (ASNH245CustomPictureFormat *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CustomPictureFormat(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_maxCustomPictureWidth) );
	delete_AsnInteger( &(pObj->m_maxCustomPictureHeight) );
	delete_AsnInteger( &(pObj->m_minCustomPictureWidth) );
	delete_AsnInteger( &(pObj->m_minCustomPictureHeight) );
	delete_ASNH245CustomPictureFormat_mPI( &(pObj->m_mPI) );
	delete_ASNH245CustomPictureFormat_pixelAspectInformation( &(pObj->m_pixelAspectInformation) );
	return HS_OK;
}

/* ASNH245CustomPictureFormat MakeMold */
HS_RESULT ASNH245CustomPictureFormat_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CustomPictureFormat *pObj = (ASNH245CustomPictureFormat *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245CustomPictureFormat_mPI_MakeMold(&(pObj->m_mPI));
	return HS_OK;
}

/* ASNH245CustomPictureFormat Encode */
HS_RESULT ASNH245CustomPictureFormat_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CustomPictureFormat *pObj = (ASNH245CustomPictureFormat *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_maxCustomPictureWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maxCustomPictureHeight),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_minCustomPictureWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_minCustomPictureHeight),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CustomPictureFormat_mPI_Encode( &(pObj->m_mPI),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CustomPictureFormat_pixelAspectInformation_Encode( &(pObj->m_pixelAspectInformation),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245CustomPictureFormat Decode */
HS_RESULT ASNH245CustomPictureFormat_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CustomPictureFormat *pObj = (ASNH245CustomPictureFormat *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxCustomPictureWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxCustomPictureHeight),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_minCustomPictureWidth),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_minCustomPictureHeight),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CustomPictureFormat_mPI_Decode(&(pObj->m_mPI),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CustomPictureFormat_pixelAspectInformation_Decode(&(pObj->m_pixelAspectInformation),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CustomPictureFormat Print */
HS_RESULT ASNH245CustomPictureFormat_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CustomPictureFormat *pObj = (ASNH245CustomPictureFormat *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CustomPictureFormat_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_maxCustomPictureWidth), pDepth+1, "maxCustomPictureWidth" );
	AsnInteger_Print( &(pObj->m_maxCustomPictureHeight), pDepth+1, "maxCustomPictureHeight" );
	AsnInteger_Print( &(pObj->m_minCustomPictureWidth), pDepth+1, "minCustomPictureWidth" );
	AsnInteger_Print( &(pObj->m_minCustomPictureHeight), pDepth+1, "minCustomPictureHeight" );
	ASNH245CustomPictureFormat_mPI_Print( &(pObj->m_mPI), pDepth+1, "mPI" );
	ASNH245CustomPictureFormat_pixelAspectInformation_Print( &(pObj->m_pixelAspectInformation), pDepth+1, "pixelAspectInformation" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H263Version3Options Class
*/
/*ASNH245H263Version3Options Constructor*/
HS_RESULT new_ASNH245H263Version3Options(void *pObject)
{
	ASNH245H263Version3Options *pObj = (ASNH245H263Version3Options *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H263Version3Options(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_dataPartitionedSlices) );
	new_AsnBoolean( &(pObj->m_fixedPointIDCT0) );
	new_AsnBoolean( &(pObj->m_interlacedFields) );
	new_AsnBoolean( &(pObj->m_currentPictureHeaderRepetition) );
	new_AsnBoolean( &(pObj->m_previousPictureHeaderRepetition) );
	new_AsnBoolean( &(pObj->m_nextPictureHeaderRepetition) );
	new_AsnBoolean( &(pObj->m_pictureNumber) );
	new_AsnBoolean( &(pObj->m_spareReferencePictures) );

	return HS_OK;
}

/* ASNH245H263Version3Options Destructor */
HS_RESULT delete_ASNH245H263Version3Options(void *pObject)
{
	ASNH245H263Version3Options *pObj = (ASNH245H263Version3Options *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H263Version3Options(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_dataPartitionedSlices) );
	delete_AsnBoolean( &(pObj->m_fixedPointIDCT0) );
	delete_AsnBoolean( &(pObj->m_interlacedFields) );
	delete_AsnBoolean( &(pObj->m_currentPictureHeaderRepetition) );
	delete_AsnBoolean( &(pObj->m_previousPictureHeaderRepetition) );
	delete_AsnBoolean( &(pObj->m_nextPictureHeaderRepetition) );
	delete_AsnBoolean( &(pObj->m_pictureNumber) );
	delete_AsnBoolean( &(pObj->m_spareReferencePictures) );
	return HS_OK;
}

/* ASNH245H263Version3Options MakeMold */
HS_RESULT ASNH245H263Version3Options_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H263Version3Options *pObj = (ASNH245H263Version3Options *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H263Version3Options Encode */
HS_RESULT ASNH245H263Version3Options_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H263Version3Options *pObj = (ASNH245H263Version3Options *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_dataPartitionedSlices),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_fixedPointIDCT0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_interlacedFields),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_currentPictureHeaderRepetition),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_previousPictureHeaderRepetition),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_nextPictureHeaderRepetition),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_pictureNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_spareReferencePictures),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H263Version3Options Decode */
HS_RESULT ASNH245H263Version3Options_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H263Version3Options *pObj = (ASNH245H263Version3Options *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dataPartitionedSlices),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_fixedPointIDCT0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_interlacedFields),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_currentPictureHeaderRepetition),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_previousPictureHeaderRepetition),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_nextPictureHeaderRepetition),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_pictureNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_spareReferencePictures),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Version3Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H263Version3Options Print */
HS_RESULT ASNH245H263Version3Options_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H263Version3Options *pObj = (ASNH245H263Version3Options *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H263Version3Options_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_dataPartitionedSlices), pDepth+1, "dataPartitionedSlices" );
	AsnBoolean_Print( &(pObj->m_fixedPointIDCT0), pDepth+1, "fixedPointIDCT0" );
	AsnBoolean_Print( &(pObj->m_interlacedFields), pDepth+1, "interlacedFields" );
	AsnBoolean_Print( &(pObj->m_currentPictureHeaderRepetition), pDepth+1, "currentPictureHeaderRepetition" );
	AsnBoolean_Print( &(pObj->m_previousPictureHeaderRepetition), pDepth+1, "previousPictureHeaderRepetition" );
	AsnBoolean_Print( &(pObj->m_nextPictureHeaderRepetition), pDepth+1, "nextPictureHeaderRepetition" );
	AsnBoolean_Print( &(pObj->m_pictureNumber), pDepth+1, "pictureNumber" );
	AsnBoolean_Print( &(pObj->m_spareReferencePictures), pDepth+1, "spareReferencePictures" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H263ModeComboFlags Class
*/
/*ASNH245H263ModeComboFlags Constructor*/
HS_RESULT new_ASNH245H263ModeComboFlags(void *pObject)
{
	ASNH245H263ModeComboFlags *pObj = (ASNH245H263ModeComboFlags *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H263ModeComboFlags(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_unrestrictedVector) );
	new_AsnBoolean( &(pObj->m_arithmeticCoding) );
	new_AsnBoolean( &(pObj->m_advancedPrediction) );
	new_AsnBoolean( &(pObj->m_pbFrames) );
	new_AsnBoolean( &(pObj->m_advancedIntraCodingMode) );
	new_AsnBoolean( &(pObj->m_deblockingFilterMode) );
	new_AsnBoolean( &(pObj->m_unlimitedMotionVectors) );
	new_AsnBoolean( &(pObj->m_slicesInOrder_NonRect) );
	new_AsnBoolean( &(pObj->m_slicesInOrder_Rect) );
	new_AsnBoolean( &(pObj->m_slicesNoOrder_NonRect) );
	new_AsnBoolean( &(pObj->m_slicesNoOrder_Rect) );
	new_AsnBoolean( &(pObj->m_improvedPBFramesMode) );
	new_AsnBoolean( &(pObj->m_referencePicSelect) );
	new_AsnBoolean( &(pObj->m_dynamicPictureResizingByFour) );
	new_AsnBoolean( &(pObj->m_dynamicPictureResizingSixteenthPel) );
	new_AsnBoolean( &(pObj->m_dynamicWarpingHalfPel) );
	new_AsnBoolean( &(pObj->m_dynamicWarpingSixteenthPel) );
	new_AsnBoolean( &(pObj->m_reducedResolutionUpdate) );
	new_AsnBoolean( &(pObj->m_independentSegmentDecoding) );
	new_AsnBoolean( &(pObj->m_alternateInterVLCMode) );
	new_AsnBoolean( &(pObj->m_modifiedQuantizationMode) );
	new_AsnBoolean( &(pObj->m_enhancedReferencePicSelect) );
	new_ASNH245H263Version3Options( &(pObj->m_h263Version3Options) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H263ModeComboFlags Destructor */
HS_RESULT delete_ASNH245H263ModeComboFlags(void *pObject)
{
	ASNH245H263ModeComboFlags *pObj = (ASNH245H263ModeComboFlags *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H263ModeComboFlags(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_unrestrictedVector) );
	delete_AsnBoolean( &(pObj->m_arithmeticCoding) );
	delete_AsnBoolean( &(pObj->m_advancedPrediction) );
	delete_AsnBoolean( &(pObj->m_pbFrames) );
	delete_AsnBoolean( &(pObj->m_advancedIntraCodingMode) );
	delete_AsnBoolean( &(pObj->m_deblockingFilterMode) );
	delete_AsnBoolean( &(pObj->m_unlimitedMotionVectors) );
	delete_AsnBoolean( &(pObj->m_slicesInOrder_NonRect) );
	delete_AsnBoolean( &(pObj->m_slicesInOrder_Rect) );
	delete_AsnBoolean( &(pObj->m_slicesNoOrder_NonRect) );
	delete_AsnBoolean( &(pObj->m_slicesNoOrder_Rect) );
	delete_AsnBoolean( &(pObj->m_improvedPBFramesMode) );
	delete_AsnBoolean( &(pObj->m_referencePicSelect) );
	delete_AsnBoolean( &(pObj->m_dynamicPictureResizingByFour) );
	delete_AsnBoolean( &(pObj->m_dynamicPictureResizingSixteenthPel) );
	delete_AsnBoolean( &(pObj->m_dynamicWarpingHalfPel) );
	delete_AsnBoolean( &(pObj->m_dynamicWarpingSixteenthPel) );
	delete_AsnBoolean( &(pObj->m_reducedResolutionUpdate) );
	delete_AsnBoolean( &(pObj->m_independentSegmentDecoding) );
	delete_AsnBoolean( &(pObj->m_alternateInterVLCMode) );
	delete_AsnBoolean( &(pObj->m_modifiedQuantizationMode) );
	delete_AsnBoolean( &(pObj->m_enhancedReferencePicSelect) );
	delete_ASNH245H263Version3Options( &(pObj->m_h263Version3Options) );
	return HS_OK;
}

/* ASNH245H263ModeComboFlags MakeMold */
HS_RESULT ASNH245H263ModeComboFlags_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H263ModeComboFlags *pObj = (ASNH245H263ModeComboFlags *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245H263Version3Options_MakeMold(&(pObj->m_h263Version3Options));
	return HS_OK;
}

/* ASNH245H263ModeComboFlags IncludeOptionalField */
HS_RESULT ASNH245H263ModeComboFlags_IncludeOptionField( void *pObject, ASNH245H263ModeComboFlagsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H263ModeComboFlags *pObj = (ASNH245H263ModeComboFlags *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H263ModeComboFlagsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H263ModeComboFlagsOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245H263ModeComboFlags IsIncludeOptionalField */
BOOL ASNH245H263ModeComboFlags_IsIncludeOptionField( void *pObject, ASNH245H263ModeComboFlagsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H263ModeComboFlags *pObj = (ASNH245H263ModeComboFlags *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H263ModeComboFlagsOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H263ModeComboFlagsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H263ModeComboFlags Encode */
HS_RESULT ASNH245H263ModeComboFlags_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H263ModeComboFlags *pObj = (ASNH245H263ModeComboFlags *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_unrestrictedVector),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_arithmeticCoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_advancedPrediction),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_pbFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_advancedIntraCodingMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_deblockingFilterMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_unlimitedMotionVectors),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_slicesInOrder_NonRect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_slicesInOrder_Rect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_slicesNoOrder_NonRect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_slicesNoOrder_Rect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_improvedPBFramesMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_referencePicSelect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dynamicPictureResizingByFour),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dynamicPictureResizingSixteenthPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dynamicWarpingHalfPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dynamicWarpingSixteenthPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_reducedResolutionUpdate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_independentSegmentDecoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_alternateInterVLCMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_modifiedQuantizationMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H263ModeComboFlags_IsIncludeOptionField( pObj, e_ASNH245H263ModeComboFlagsOptionMap_enhancedReferencePicSelect ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_enhancedReferencePicSelect), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263ModeComboFlags_IsIncludeOptionField( pObj, e_ASNH245H263ModeComboFlagsOptionMap_h263Version3Options ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h263Version3Options), ASNH245H263Version3Options_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263ModeComboFlags_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H263ModeComboFlags Decode */
HS_RESULT ASNH245H263ModeComboFlags_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H263ModeComboFlags *pObj = (ASNH245H263ModeComboFlags *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_unrestrictedVector),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_arithmeticCoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_advancedPrediction),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_pbFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_advancedIntraCodingMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_deblockingFilterMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_unlimitedMotionVectors),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_slicesInOrder_NonRect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_slicesInOrder_Rect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_slicesNoOrder_NonRect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_slicesNoOrder_Rect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_improvedPBFramesMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_referencePicSelect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dynamicPictureResizingByFour),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dynamicPictureResizingSixteenthPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dynamicWarpingHalfPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dynamicWarpingSixteenthPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_reducedResolutionUpdate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_independentSegmentDecoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_alternateInterVLCMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_modifiedQuantizationMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H263ModeComboFlags_IsIncludeOptionField( pObj, e_ASNH245H263ModeComboFlagsOptionMap_enhancedReferencePicSelect ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_enhancedReferencePicSelect), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263ModeComboFlags_IsIncludeOptionField( pObj, e_ASNH245H263ModeComboFlagsOptionMap_h263Version3Options ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_h263Version3Options), ASNH245H263Version3Options_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263ModeComboFlags_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H263ModeComboFlags Print */
HS_RESULT ASNH245H263ModeComboFlags_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H263ModeComboFlags *pObj = (ASNH245H263ModeComboFlags *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H263ModeComboFlags_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_unrestrictedVector), pDepth+1, "unrestrictedVector" );
	AsnBoolean_Print( &(pObj->m_arithmeticCoding), pDepth+1, "arithmeticCoding" );
	AsnBoolean_Print( &(pObj->m_advancedPrediction), pDepth+1, "advancedPrediction" );
	AsnBoolean_Print( &(pObj->m_pbFrames), pDepth+1, "pbFrames" );
	AsnBoolean_Print( &(pObj->m_advancedIntraCodingMode), pDepth+1, "advancedIntraCodingMode" );
	AsnBoolean_Print( &(pObj->m_deblockingFilterMode), pDepth+1, "deblockingFilterMode" );
	AsnBoolean_Print( &(pObj->m_unlimitedMotionVectors), pDepth+1, "unlimitedMotionVectors" );
	AsnBoolean_Print( &(pObj->m_slicesInOrder_NonRect), pDepth+1, "slicesInOrder_NonRect" );
	AsnBoolean_Print( &(pObj->m_slicesInOrder_Rect), pDepth+1, "slicesInOrder_Rect" );
	AsnBoolean_Print( &(pObj->m_slicesNoOrder_NonRect), pDepth+1, "slicesNoOrder_NonRect" );
	AsnBoolean_Print( &(pObj->m_slicesNoOrder_Rect), pDepth+1, "slicesNoOrder_Rect" );
	AsnBoolean_Print( &(pObj->m_improvedPBFramesMode), pDepth+1, "improvedPBFramesMode" );
	AsnBoolean_Print( &(pObj->m_referencePicSelect), pDepth+1, "referencePicSelect" );
	AsnBoolean_Print( &(pObj->m_dynamicPictureResizingByFour), pDepth+1, "dynamicPictureResizingByFour" );
	AsnBoolean_Print( &(pObj->m_dynamicPictureResizingSixteenthPel), pDepth+1, "dynamicPictureResizingSixteenthPel" );
	AsnBoolean_Print( &(pObj->m_dynamicWarpingHalfPel), pDepth+1, "dynamicWarpingHalfPel" );
	AsnBoolean_Print( &(pObj->m_dynamicWarpingSixteenthPel), pDepth+1, "dynamicWarpingSixteenthPel" );
	AsnBoolean_Print( &(pObj->m_reducedResolutionUpdate), pDepth+1, "reducedResolutionUpdate" );
	AsnBoolean_Print( &(pObj->m_independentSegmentDecoding), pDepth+1, "independentSegmentDecoding" );
	AsnBoolean_Print( &(pObj->m_alternateInterVLCMode), pDepth+1, "alternateInterVLCMode" );
	AsnBoolean_Print( &(pObj->m_modifiedQuantizationMode), pDepth+1, "modifiedQuantizationMode" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H263ModeComboFlags_IsIncludeOptionField( pObj, e_ASNH245H263ModeComboFlagsOptionMap_enhancedReferencePicSelect ) )
		AsnBoolean_Print( &(pObj->m_enhancedReferencePicSelect), pDepth+1, "enhancedReferencePicSelect" );
	if( ASNH245H263ModeComboFlags_IsIncludeOptionField( pObj, e_ASNH245H263ModeComboFlagsOptionMap_h263Version3Options ) )
		ASNH245H263Version3Options_Print( &(pObj->m_h263Version3Options), pDepth+1, "h263Version3Options" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H263VideoModeCombos Class
*/
/*ASNH245H263VideoModeCombos Constructor*/
HS_RESULT new_ASNH245H263VideoModeCombos(void *pObject)
{
	ASNH245H263VideoModeCombos *pObj = (ASNH245H263VideoModeCombos *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H263VideoModeCombos(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245H263ModeComboFlags( &(pObj->m_h263VideoUncoupledModes) );
	new_AsnSequenceOf( &(pObj->m_h263VideoCoupledModes), e_constrained,1,16,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245H263VideoModeCombos Destructor */
HS_RESULT delete_ASNH245H263VideoModeCombos(void *pObject)
{
	ASNH245H263VideoModeCombos *pObj = (ASNH245H263VideoModeCombos *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H263VideoModeCombos(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245H263ModeComboFlags( &(pObj->m_h263VideoUncoupledModes) );
	delete_AsnSequenceOf( &(pObj->m_h263VideoCoupledModes) );
	return HS_OK;
}

/* ASNH245H263VideoModeCombos MakeMold */
HS_RESULT ASNH245H263VideoModeCombos_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H263VideoModeCombos *pObj = (ASNH245H263VideoModeCombos *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoModeCombos_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245H263ModeComboFlags_MakeMold(&(pObj->m_h263VideoUncoupledModes));
	{
	ASNH245H263ModeComboFlags *tmold_h263VideoCoupledModes = (ASNH245H263ModeComboFlags *)HSMalloc( sizeof(ASNH245H263ModeComboFlags) );
	new_ASNH245H263ModeComboFlags(tmold_h263VideoCoupledModes);
	ASNH245H263ModeComboFlags_MakeMold(tmold_h263VideoCoupledModes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_h263VideoCoupledModes,sizeof(ASNH245H263ModeComboFlags),ASNH245H263ModeComboFlags_MakeMold,ASNH245H263ModeComboFlags_Encode,ASNH245H263ModeComboFlags_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245H263ModeComboFlags_Print,
#endif
		delete_ASNH245H263ModeComboFlags);
	AsnSequenceOf_SetMold( &(pObj->m_h263VideoCoupledModes), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_h263VideoCoupledModes.constraint.type = e_constrained;
	pObj->m_h263VideoCoupledModes.constraint.minValue = 1;
	pObj->m_h263VideoCoupledModes.constraint.maxValue = 16;
	pObj->m_h263VideoCoupledModes.extMinValue = 0;
	pObj->m_h263VideoCoupledModes.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245H263VideoModeCombos Encode */
HS_RESULT ASNH245H263VideoModeCombos_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H263VideoModeCombos *pObj = (ASNH245H263VideoModeCombos *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoModeCombos_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245H263ModeComboFlags_Encode( &(pObj->m_h263VideoUncoupledModes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoModeCombos_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_h263VideoCoupledModes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoModeCombos_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H263VideoModeCombos Decode */
HS_RESULT ASNH245H263VideoModeCombos_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H263VideoModeCombos *pObj = (ASNH245H263VideoModeCombos *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoModeCombos_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245H263ModeComboFlags_Decode(&(pObj->m_h263VideoUncoupledModes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoModeCombos_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_h263VideoCoupledModes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoModeCombos_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H263VideoModeCombos Print */
HS_RESULT ASNH245H263VideoModeCombos_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H263VideoModeCombos *pObj = (ASNH245H263VideoModeCombos *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H263VideoModeCombos_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245H263ModeComboFlags_Print( &(pObj->m_h263VideoUncoupledModes), pDepth+1, "h263VideoUncoupledModes" );
	AsnSequenceOf_Print( &(pObj->m_h263VideoCoupledModes), pDepth+1, "h263VideoCoupledModes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H263Options Class
*/
/*ASNH245H263Options Constructor*/
HS_RESULT new_ASNH245H263Options(void *pObject)
{
	ASNH245H263Options *pObj = (ASNH245H263Options *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H263Options(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_advancedIntraCodingMode) );
	new_AsnBoolean( &(pObj->m_deblockingFilterMode) );
	new_AsnBoolean( &(pObj->m_improvedPBFramesMode) );
	new_AsnBoolean( &(pObj->m_unlimitedMotionVectors) );
	new_AsnBoolean( &(pObj->m_fullPictureFreeze) );
	new_AsnBoolean( &(pObj->m_partialPictureFreezeAndRelease) );
	new_AsnBoolean( &(pObj->m_resizingPartPicFreezeAndRelease) );
	new_AsnBoolean( &(pObj->m_fullPictureSnapshot) );
	new_AsnBoolean( &(pObj->m_partialPictureSnapshot) );
	new_AsnBoolean( &(pObj->m_videoSegmentTagging) );
	new_AsnBoolean( &(pObj->m_progressiveRefinement) );
	new_AsnBoolean( &(pObj->m_dynamicPictureResizingByFour) );
	new_AsnBoolean( &(pObj->m_dynamicPictureResizingSixteenthPel) );
	new_AsnBoolean( &(pObj->m_dynamicWarpingHalfPel) );
	new_AsnBoolean( &(pObj->m_dynamicWarpingSixteenthPel) );
	new_AsnBoolean( &(pObj->m_independentSegmentDecoding) );
	new_AsnBoolean( &(pObj->m_slicesInOrder_NonRect) );
	new_AsnBoolean( &(pObj->m_slicesInOrder_Rect) );
	new_AsnBoolean( &(pObj->m_slicesNoOrder_NonRect) );
	new_AsnBoolean( &(pObj->m_slicesNoOrder_Rect) );
	new_AsnBoolean( &(pObj->m_alternateInterVLCMode) );
	new_AsnBoolean( &(pObj->m_modifiedQuantizationMode) );
	new_AsnBoolean( &(pObj->m_reducedResolutionUpdate) );
	new_ASNH245TransparencyParameters( &(pObj->m_transparencyParameters) );
	new_AsnBoolean( &(pObj->m_separateVideoBackChannel) );
	new_ASNH245RefPictureSelection( &(pObj->m_refPictureSelection) );
	new_AsnSequenceOf( &(pObj->m_customPictureClockFrequency), e_constrained,1,16,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_customPictureFormat), e_constrained,1,16,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_modeCombos), e_constrained,1,16,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_videoBadMBsCap) );
	new_ASNH245H263Version3Options( &(pObj->m_h263Version3Options) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H263Options Destructor */
HS_RESULT delete_ASNH245H263Options(void *pObject)
{
	ASNH245H263Options *pObj = (ASNH245H263Options *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H263Options(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_advancedIntraCodingMode) );
	delete_AsnBoolean( &(pObj->m_deblockingFilterMode) );
	delete_AsnBoolean( &(pObj->m_improvedPBFramesMode) );
	delete_AsnBoolean( &(pObj->m_unlimitedMotionVectors) );
	delete_AsnBoolean( &(pObj->m_fullPictureFreeze) );
	delete_AsnBoolean( &(pObj->m_partialPictureFreezeAndRelease) );
	delete_AsnBoolean( &(pObj->m_resizingPartPicFreezeAndRelease) );
	delete_AsnBoolean( &(pObj->m_fullPictureSnapshot) );
	delete_AsnBoolean( &(pObj->m_partialPictureSnapshot) );
	delete_AsnBoolean( &(pObj->m_videoSegmentTagging) );
	delete_AsnBoolean( &(pObj->m_progressiveRefinement) );
	delete_AsnBoolean( &(pObj->m_dynamicPictureResizingByFour) );
	delete_AsnBoolean( &(pObj->m_dynamicPictureResizingSixteenthPel) );
	delete_AsnBoolean( &(pObj->m_dynamicWarpingHalfPel) );
	delete_AsnBoolean( &(pObj->m_dynamicWarpingSixteenthPel) );
	delete_AsnBoolean( &(pObj->m_independentSegmentDecoding) );
	delete_AsnBoolean( &(pObj->m_slicesInOrder_NonRect) );
	delete_AsnBoolean( &(pObj->m_slicesInOrder_Rect) );
	delete_AsnBoolean( &(pObj->m_slicesNoOrder_NonRect) );
	delete_AsnBoolean( &(pObj->m_slicesNoOrder_Rect) );
	delete_AsnBoolean( &(pObj->m_alternateInterVLCMode) );
	delete_AsnBoolean( &(pObj->m_modifiedQuantizationMode) );
	delete_AsnBoolean( &(pObj->m_reducedResolutionUpdate) );
	delete_ASNH245TransparencyParameters( &(pObj->m_transparencyParameters) );
	delete_AsnBoolean( &(pObj->m_separateVideoBackChannel) );
	delete_ASNH245RefPictureSelection( &(pObj->m_refPictureSelection) );
	delete_AsnSequenceOf( &(pObj->m_customPictureClockFrequency) );
	delete_AsnSequenceOf( &(pObj->m_customPictureFormat) );
	delete_AsnSequenceOf( &(pObj->m_modeCombos) );
	delete_AsnBoolean( &(pObj->m_videoBadMBsCap) );
	delete_ASNH245H263Version3Options( &(pObj->m_h263Version3Options) );
	return HS_OK;
}

/* ASNH245H263Options MakeMold */
HS_RESULT ASNH245H263Options_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H263Options *pObj = (ASNH245H263Options *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245TransparencyParameters_MakeMold(&(pObj->m_transparencyParameters));
	ASNH245RefPictureSelection_MakeMold(&(pObj->m_refPictureSelection));
	{
	ASNH245CustomPictureClockFrequency *tmold_customPictureClockFrequency = (ASNH245CustomPictureClockFrequency *)HSMalloc( sizeof(ASNH245CustomPictureClockFrequency) );
	new_ASNH245CustomPictureClockFrequency(tmold_customPictureClockFrequency);
	ASNH245CustomPictureClockFrequency_MakeMold(tmold_customPictureClockFrequency);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_customPictureClockFrequency,sizeof(ASNH245CustomPictureClockFrequency),ASNH245CustomPictureClockFrequency_MakeMold,ASNH245CustomPictureClockFrequency_Encode,ASNH245CustomPictureClockFrequency_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245CustomPictureClockFrequency_Print,
#endif
		delete_ASNH245CustomPictureClockFrequency);
	AsnSequenceOf_SetMold( &(pObj->m_customPictureClockFrequency), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_customPictureClockFrequency.constraint.type = e_constrained;
	pObj->m_customPictureClockFrequency.constraint.minValue = 1;
	pObj->m_customPictureClockFrequency.constraint.maxValue = 16;
	pObj->m_customPictureClockFrequency.extMinValue = 0;
	pObj->m_customPictureClockFrequency.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	{
	ASNH245CustomPictureFormat *tmold_customPictureFormat = (ASNH245CustomPictureFormat *)HSMalloc( sizeof(ASNH245CustomPictureFormat) );
	new_ASNH245CustomPictureFormat(tmold_customPictureFormat);
	ASNH245CustomPictureFormat_MakeMold(tmold_customPictureFormat);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_customPictureFormat,sizeof(ASNH245CustomPictureFormat),ASNH245CustomPictureFormat_MakeMold,ASNH245CustomPictureFormat_Encode,ASNH245CustomPictureFormat_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245CustomPictureFormat_Print,
#endif
		delete_ASNH245CustomPictureFormat);
	AsnSequenceOf_SetMold( &(pObj->m_customPictureFormat), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_customPictureFormat.constraint.type = e_constrained;
	pObj->m_customPictureFormat.constraint.minValue = 1;
	pObj->m_customPictureFormat.constraint.maxValue = 16;
	pObj->m_customPictureFormat.extMinValue = 0;
	pObj->m_customPictureFormat.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	{
	ASNH245H263VideoModeCombos *tmold_modeCombos = (ASNH245H263VideoModeCombos *)HSMalloc( sizeof(ASNH245H263VideoModeCombos) );
	new_ASNH245H263VideoModeCombos(tmold_modeCombos);
	ASNH245H263VideoModeCombos_MakeMold(tmold_modeCombos);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_modeCombos,sizeof(ASNH245H263VideoModeCombos),ASNH245H263VideoModeCombos_MakeMold,ASNH245H263VideoModeCombos_Encode,ASNH245H263VideoModeCombos_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245H263VideoModeCombos_Print,
#endif
		delete_ASNH245H263VideoModeCombos);
	AsnSequenceOf_SetMold( &(pObj->m_modeCombos), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_modeCombos.constraint.type = e_constrained;
	pObj->m_modeCombos.constraint.minValue = 1;
	pObj->m_modeCombos.constraint.maxValue = 16;
	pObj->m_modeCombos.extMinValue = 0;
	pObj->m_modeCombos.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	ASNH245H263Version3Options_MakeMold(&(pObj->m_h263Version3Options));
	return HS_OK;
}

/* ASNH245H263Options IncludeOptionalField */
HS_RESULT ASNH245H263Options_IncludeOptionField( void *pObject, ASNH245H263OptionsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H263Options *pObj = (ASNH245H263Options *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H263OptionsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H263OptionsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H263OptionsOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245H263Options IsIncludeOptionalField */
BOOL ASNH245H263Options_IsIncludeOptionField( void *pObject, ASNH245H263OptionsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H263Options *pObj = (ASNH245H263Options *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H263OptionsOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H263OptionsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H263OptionsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H263Options Encode */
HS_RESULT ASNH245H263Options_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H263Options *pObj = (ASNH245H263Options *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245H263OptionsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245H263OptionsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Encode( &(pObj->m_advancedIntraCodingMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_deblockingFilterMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_improvedPBFramesMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_unlimitedMotionVectors),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_fullPictureFreeze),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_partialPictureFreezeAndRelease),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_resizingPartPicFreezeAndRelease),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_fullPictureSnapshot),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_partialPictureSnapshot),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_videoSegmentTagging),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_progressiveRefinement),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dynamicPictureResizingByFour),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dynamicPictureResizingSixteenthPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dynamicWarpingHalfPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_dynamicWarpingSixteenthPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_independentSegmentDecoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_slicesInOrder_NonRect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_slicesInOrder_Rect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_slicesNoOrder_NonRect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_slicesNoOrder_Rect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_alternateInterVLCMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_modifiedQuantizationMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_reducedResolutionUpdate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_transparencyParameters ) ){
		if( (tRet=ASNH245TransparencyParameters_Encode( &(pObj->m_transparencyParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_separateVideoBackChannel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_refPictureSelection ) ){
		if( (tRet=ASNH245RefPictureSelection_Encode( &(pObj->m_refPictureSelection),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_customPictureClockFrequency ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_customPictureClockFrequency),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_customPictureFormat ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_customPictureFormat),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_modeCombos ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_modeCombos),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_videoBadMBsCap ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_videoBadMBsCap), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_h263Version3Options ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h263Version3Options), ASNH245H263Version3Options_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263Options_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H263Options Decode */
HS_RESULT ASNH245H263Options_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H263Options *pObj = (ASNH245H263Options *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245H263OptionsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245H263OptionsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_advancedIntraCodingMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_deblockingFilterMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_improvedPBFramesMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_unlimitedMotionVectors),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_fullPictureFreeze),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_partialPictureFreezeAndRelease),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_resizingPartPicFreezeAndRelease),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_fullPictureSnapshot),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_partialPictureSnapshot),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_videoSegmentTagging),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_progressiveRefinement),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dynamicPictureResizingByFour),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dynamicPictureResizingSixteenthPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dynamicWarpingHalfPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_dynamicWarpingSixteenthPel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_independentSegmentDecoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_slicesInOrder_NonRect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_slicesInOrder_Rect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_slicesNoOrder_NonRect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_slicesNoOrder_Rect),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_alternateInterVLCMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_modifiedQuantizationMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_reducedResolutionUpdate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_transparencyParameters ) ){
		if( (tRet=ASNH245TransparencyParameters_Decode(&(pObj->m_transparencyParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_separateVideoBackChannel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_refPictureSelection ) ){
		if( (tRet=ASNH245RefPictureSelection_Decode(&(pObj->m_refPictureSelection),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_customPictureClockFrequency ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_customPictureClockFrequency),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_customPictureFormat ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_customPictureFormat),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_modeCombos ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_modeCombos),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_videoBadMBsCap ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_videoBadMBsCap), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_h263Version3Options ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_h263Version3Options), ASNH245H263Version3Options_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263Options_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H263Options Print */
HS_RESULT ASNH245H263Options_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H263Options *pObj = (ASNH245H263Options *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H263Options_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_advancedIntraCodingMode), pDepth+1, "advancedIntraCodingMode" );
	AsnBoolean_Print( &(pObj->m_deblockingFilterMode), pDepth+1, "deblockingFilterMode" );
	AsnBoolean_Print( &(pObj->m_improvedPBFramesMode), pDepth+1, "improvedPBFramesMode" );
	AsnBoolean_Print( &(pObj->m_unlimitedMotionVectors), pDepth+1, "unlimitedMotionVectors" );
	AsnBoolean_Print( &(pObj->m_fullPictureFreeze), pDepth+1, "fullPictureFreeze" );
	AsnBoolean_Print( &(pObj->m_partialPictureFreezeAndRelease), pDepth+1, "partialPictureFreezeAndRelease" );
	AsnBoolean_Print( &(pObj->m_resizingPartPicFreezeAndRelease), pDepth+1, "resizingPartPicFreezeAndRelease" );
	AsnBoolean_Print( &(pObj->m_fullPictureSnapshot), pDepth+1, "fullPictureSnapshot" );
	AsnBoolean_Print( &(pObj->m_partialPictureSnapshot), pDepth+1, "partialPictureSnapshot" );
	AsnBoolean_Print( &(pObj->m_videoSegmentTagging), pDepth+1, "videoSegmentTagging" );
	AsnBoolean_Print( &(pObj->m_progressiveRefinement), pDepth+1, "progressiveRefinement" );
	AsnBoolean_Print( &(pObj->m_dynamicPictureResizingByFour), pDepth+1, "dynamicPictureResizingByFour" );
	AsnBoolean_Print( &(pObj->m_dynamicPictureResizingSixteenthPel), pDepth+1, "dynamicPictureResizingSixteenthPel" );
	AsnBoolean_Print( &(pObj->m_dynamicWarpingHalfPel), pDepth+1, "dynamicWarpingHalfPel" );
	AsnBoolean_Print( &(pObj->m_dynamicWarpingSixteenthPel), pDepth+1, "dynamicWarpingSixteenthPel" );
	AsnBoolean_Print( &(pObj->m_independentSegmentDecoding), pDepth+1, "independentSegmentDecoding" );
	AsnBoolean_Print( &(pObj->m_slicesInOrder_NonRect), pDepth+1, "slicesInOrder_NonRect" );
	AsnBoolean_Print( &(pObj->m_slicesInOrder_Rect), pDepth+1, "slicesInOrder_Rect" );
	AsnBoolean_Print( &(pObj->m_slicesNoOrder_NonRect), pDepth+1, "slicesNoOrder_NonRect" );
	AsnBoolean_Print( &(pObj->m_slicesNoOrder_Rect), pDepth+1, "slicesNoOrder_Rect" );
	AsnBoolean_Print( &(pObj->m_alternateInterVLCMode), pDepth+1, "alternateInterVLCMode" );
	AsnBoolean_Print( &(pObj->m_modifiedQuantizationMode), pDepth+1, "modifiedQuantizationMode" );
	AsnBoolean_Print( &(pObj->m_reducedResolutionUpdate), pDepth+1, "reducedResolutionUpdate" );
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_transparencyParameters ) )
		ASNH245TransparencyParameters_Print( &(pObj->m_transparencyParameters), pDepth+1, "transparencyParameters" );
	AsnBoolean_Print( &(pObj->m_separateVideoBackChannel), pDepth+1, "separateVideoBackChannel" );
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_refPictureSelection ) )
		ASNH245RefPictureSelection_Print( &(pObj->m_refPictureSelection), pDepth+1, "refPictureSelection" );
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_customPictureClockFrequency ) )
		AsnSequenceOf_Print( &(pObj->m_customPictureClockFrequency), pDepth+1, "customPictureClockFrequency" );
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_customPictureFormat ) )
		AsnSequenceOf_Print( &(pObj->m_customPictureFormat), pDepth+1, "customPictureFormat" );
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_modeCombos ) )
		AsnSequenceOf_Print( &(pObj->m_modeCombos), pDepth+1, "modeCombos" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_videoBadMBsCap ) )
		AsnBoolean_Print( &(pObj->m_videoBadMBsCap), pDepth+1, "videoBadMBsCap" );
	if( ASNH245H263Options_IsIncludeOptionField( pObj, e_ASNH245H263OptionsOptionMap_h263Version3Options ) )
		ASNH245H263Version3Options_Print( &(pObj->m_h263Version3Options), pDepth+1, "h263Version3Options" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245EnhancementOptions Class
*/
/*ASNH245EnhancementOptions Constructor*/
HS_RESULT new_ASNH245EnhancementOptions(void *pObject)
{
	ASNH245EnhancementOptions *pObj = (ASNH245EnhancementOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245EnhancementOptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_sqcifMPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_qcifMPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cifMPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cif4MPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cif16MPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maxBitRate), e_constrained, 1, 192400, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_unrestrictedVector) );
	new_AsnBoolean( &(pObj->m_arithmeticCoding) );
	new_AsnBoolean( &(pObj->m_temporalSpatialTradeOffCapability) );
	new_AsnInteger( &(pObj->m_slowSqcifMPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_slowQcifMPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_slowCifMPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_slowCif4MPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_slowCif16MPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_errorCompensation) );
	new_ASNH245H263Options( &(pObj->m_h263Options) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245EnhancementOptions Destructor */
HS_RESULT delete_ASNH245EnhancementOptions(void *pObject)
{
	ASNH245EnhancementOptions *pObj = (ASNH245EnhancementOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245EnhancementOptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_sqcifMPI) );
	delete_AsnInteger( &(pObj->m_qcifMPI) );
	delete_AsnInteger( &(pObj->m_cifMPI) );
	delete_AsnInteger( &(pObj->m_cif4MPI) );
	delete_AsnInteger( &(pObj->m_cif16MPI) );
	delete_AsnInteger( &(pObj->m_maxBitRate) );
	delete_AsnBoolean( &(pObj->m_unrestrictedVector) );
	delete_AsnBoolean( &(pObj->m_arithmeticCoding) );
	delete_AsnBoolean( &(pObj->m_temporalSpatialTradeOffCapability) );
	delete_AsnInteger( &(pObj->m_slowSqcifMPI) );
	delete_AsnInteger( &(pObj->m_slowQcifMPI) );
	delete_AsnInteger( &(pObj->m_slowCifMPI) );
	delete_AsnInteger( &(pObj->m_slowCif4MPI) );
	delete_AsnInteger( &(pObj->m_slowCif16MPI) );
	delete_AsnBoolean( &(pObj->m_errorCompensation) );
	delete_ASNH245H263Options( &(pObj->m_h263Options) );
	return HS_OK;
}

/* ASNH245EnhancementOptions MakeMold */
HS_RESULT ASNH245EnhancementOptions_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245EnhancementOptions *pObj = (ASNH245EnhancementOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245H263Options_MakeMold(&(pObj->m_h263Options));
	return HS_OK;
}

/* ASNH245EnhancementOptions IncludeOptionalField */
HS_RESULT ASNH245EnhancementOptions_IncludeOptionField( void *pObject, ASNH245EnhancementOptionsOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245EnhancementOptions *pObj = (ASNH245EnhancementOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245EnhancementOptionsOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245EnhancementOptions IsIncludeOptionalField */
BOOL ASNH245EnhancementOptions_IsIncludeOptionField( void *pObject, ASNH245EnhancementOptionsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245EnhancementOptions *pObj = (ASNH245EnhancementOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245EnhancementOptionsOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245EnhancementOptions Encode */
HS_RESULT ASNH245EnhancementOptions_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245EnhancementOptions *pObj = (ASNH245EnhancementOptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245EnhancementOptionsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245EnhancementOptionsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_sqcifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_sqcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_qcifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_qcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_cifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_cif4MPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cif4MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_cif16MPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cif16MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maxBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_unrestrictedVector),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_arithmeticCoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_temporalSpatialTradeOffCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowSqcifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_slowSqcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowQcifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_slowQcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowCifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_slowCifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowCif4MPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_slowCif4MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowCif16MPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_slowCif16MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_errorCompensation),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_h263Options ) ){
		if( (tRet=ASNH245H263Options_Encode( &(pObj->m_h263Options),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245EnhancementOptions Decode */
HS_RESULT ASNH245EnhancementOptions_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245EnhancementOptions *pObj = (ASNH245EnhancementOptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245EnhancementOptionsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245EnhancementOptionsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_sqcifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_sqcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_qcifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_qcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_cifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_cif4MPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cif4MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_cif16MPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cif16MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_unrestrictedVector),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_arithmeticCoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_temporalSpatialTradeOffCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowSqcifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_slowSqcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowQcifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_slowQcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowCifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_slowCifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowCif4MPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_slowCif4MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowCif16MPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_slowCif16MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_errorCompensation),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_h263Options ) ){
		if( (tRet=ASNH245H263Options_Decode(&(pObj->m_h263Options),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245EnhancementOptions Print */
HS_RESULT ASNH245EnhancementOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245EnhancementOptions *pObj = (ASNH245EnhancementOptions *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245EnhancementOptions_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_sqcifMPI ) )
		AsnInteger_Print( &(pObj->m_sqcifMPI), pDepth+1, "sqcifMPI" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_qcifMPI ) )
		AsnInteger_Print( &(pObj->m_qcifMPI), pDepth+1, "qcifMPI" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_cifMPI ) )
		AsnInteger_Print( &(pObj->m_cifMPI), pDepth+1, "cifMPI" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_cif4MPI ) )
		AsnInteger_Print( &(pObj->m_cif4MPI), pDepth+1, "cif4MPI" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_cif16MPI ) )
		AsnInteger_Print( &(pObj->m_cif16MPI), pDepth+1, "cif16MPI" );
	AsnInteger_Print( &(pObj->m_maxBitRate), pDepth+1, "maxBitRate" );
	AsnBoolean_Print( &(pObj->m_unrestrictedVector), pDepth+1, "unrestrictedVector" );
	AsnBoolean_Print( &(pObj->m_arithmeticCoding), pDepth+1, "arithmeticCoding" );
	AsnBoolean_Print( &(pObj->m_temporalSpatialTradeOffCapability), pDepth+1, "temporalSpatialTradeOffCapability" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowSqcifMPI ) )
		AsnInteger_Print( &(pObj->m_slowSqcifMPI), pDepth+1, "slowSqcifMPI" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowQcifMPI ) )
		AsnInteger_Print( &(pObj->m_slowQcifMPI), pDepth+1, "slowQcifMPI" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowCifMPI ) )
		AsnInteger_Print( &(pObj->m_slowCifMPI), pDepth+1, "slowCifMPI" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowCif4MPI ) )
		AsnInteger_Print( &(pObj->m_slowCif4MPI), pDepth+1, "slowCif4MPI" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_slowCif16MPI ) )
		AsnInteger_Print( &(pObj->m_slowCif16MPI), pDepth+1, "slowCif16MPI" );
	AsnBoolean_Print( &(pObj->m_errorCompensation), pDepth+1, "errorCompensation" );
	if( ASNH245EnhancementOptions_IsIncludeOptionField( pObj, e_ASNH245EnhancementOptionsOptionMap_h263Options ) )
		ASNH245H263Options_Print( &(pObj->m_h263Options), pDepth+1, "h263Options" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245BEnhancementParameters Class
*/
/*ASNH245BEnhancementParameters Constructor*/
HS_RESULT new_ASNH245BEnhancementParameters(void *pObject)
{
	ASNH245BEnhancementParameters *pObj = (ASNH245BEnhancementParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245BEnhancementParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245EnhancementOptions( &(pObj->m_enhancementOptions) );
	new_AsnInteger( &(pObj->m_numberOfBPictures), e_constrained, 1, 64, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245BEnhancementParameters Destructor */
HS_RESULT delete_ASNH245BEnhancementParameters(void *pObject)
{
	ASNH245BEnhancementParameters *pObj = (ASNH245BEnhancementParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245BEnhancementParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245EnhancementOptions( &(pObj->m_enhancementOptions) );
	delete_AsnInteger( &(pObj->m_numberOfBPictures) );
	return HS_OK;
}

/* ASNH245BEnhancementParameters MakeMold */
HS_RESULT ASNH245BEnhancementParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245BEnhancementParameters *pObj = (ASNH245BEnhancementParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245BEnhancementParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245EnhancementOptions_MakeMold(&(pObj->m_enhancementOptions));
	return HS_OK;
}

/* ASNH245BEnhancementParameters Encode */
HS_RESULT ASNH245BEnhancementParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245BEnhancementParameters *pObj = (ASNH245BEnhancementParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245BEnhancementParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245EnhancementOptions_Encode( &(pObj->m_enhancementOptions),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245BEnhancementParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_numberOfBPictures),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245BEnhancementParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245BEnhancementParameters Decode */
HS_RESULT ASNH245BEnhancementParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245BEnhancementParameters *pObj = (ASNH245BEnhancementParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245BEnhancementParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245EnhancementOptions_Decode(&(pObj->m_enhancementOptions),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245BEnhancementParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_numberOfBPictures),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245BEnhancementParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245BEnhancementParameters Print */
HS_RESULT ASNH245BEnhancementParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245BEnhancementParameters *pObj = (ASNH245BEnhancementParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245BEnhancementParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245EnhancementOptions_Print( &(pObj->m_enhancementOptions), pDepth+1, "enhancementOptions" );
	AsnInteger_Print( &(pObj->m_numberOfBPictures), pDepth+1, "numberOfBPictures" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245EnhancementLayerInfo Class
*/
/*ASNH245EnhancementLayerInfo Constructor*/
HS_RESULT new_ASNH245EnhancementLayerInfo(void *pObject)
{
	ASNH245EnhancementLayerInfo *pObj = (ASNH245EnhancementLayerInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245EnhancementLayerInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_baseBitRateConstrained) );
	new_AsnSequenceOf( &(pObj->m_snrEnhancement), e_constrained,1,14,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_spatialEnhancement), e_constrained,1,14,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_bPictureEnhancement), e_constrained,1,14,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245EnhancementLayerInfo Destructor */
HS_RESULT delete_ASNH245EnhancementLayerInfo(void *pObject)
{
	ASNH245EnhancementLayerInfo *pObj = (ASNH245EnhancementLayerInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245EnhancementLayerInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_baseBitRateConstrained) );
	delete_AsnSequenceOf( &(pObj->m_snrEnhancement) );
	delete_AsnSequenceOf( &(pObj->m_spatialEnhancement) );
	delete_AsnSequenceOf( &(pObj->m_bPictureEnhancement) );
	return HS_OK;
}

/* ASNH245EnhancementLayerInfo MakeMold */
HS_RESULT ASNH245EnhancementLayerInfo_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245EnhancementLayerInfo *pObj = (ASNH245EnhancementLayerInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementLayerInfo_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245EnhancementOptions *tmold_snrEnhancement = (ASNH245EnhancementOptions *)HSMalloc( sizeof(ASNH245EnhancementOptions) );
	new_ASNH245EnhancementOptions(tmold_snrEnhancement);
	ASNH245EnhancementOptions_MakeMold(tmold_snrEnhancement);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_snrEnhancement,sizeof(ASNH245EnhancementOptions),ASNH245EnhancementOptions_MakeMold,ASNH245EnhancementOptions_Encode,ASNH245EnhancementOptions_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245EnhancementOptions_Print,
#endif
		delete_ASNH245EnhancementOptions);
	AsnSequenceOf_SetMold( &(pObj->m_snrEnhancement), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_snrEnhancement.constraint.type = e_constrained;
	pObj->m_snrEnhancement.constraint.minValue = 1;
	pObj->m_snrEnhancement.constraint.maxValue = 14;
	pObj->m_snrEnhancement.extMinValue = 0;
	pObj->m_snrEnhancement.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	{
	ASNH245EnhancementOptions *tmold_spatialEnhancement = (ASNH245EnhancementOptions *)HSMalloc( sizeof(ASNH245EnhancementOptions) );
	new_ASNH245EnhancementOptions(tmold_spatialEnhancement);
	ASNH245EnhancementOptions_MakeMold(tmold_spatialEnhancement);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_spatialEnhancement,sizeof(ASNH245EnhancementOptions),ASNH245EnhancementOptions_MakeMold,ASNH245EnhancementOptions_Encode,ASNH245EnhancementOptions_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245EnhancementOptions_Print,
#endif
		delete_ASNH245EnhancementOptions);
	AsnSequenceOf_SetMold( &(pObj->m_spatialEnhancement), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_spatialEnhancement.constraint.type = e_constrained;
	pObj->m_spatialEnhancement.constraint.minValue = 1;
	pObj->m_spatialEnhancement.constraint.maxValue = 14;
	pObj->m_spatialEnhancement.extMinValue = 0;
	pObj->m_spatialEnhancement.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	{
	ASNH245BEnhancementParameters *tmold_bPictureEnhancement = (ASNH245BEnhancementParameters *)HSMalloc( sizeof(ASNH245BEnhancementParameters) );
	new_ASNH245BEnhancementParameters(tmold_bPictureEnhancement);
	ASNH245BEnhancementParameters_MakeMold(tmold_bPictureEnhancement);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_bPictureEnhancement,sizeof(ASNH245BEnhancementParameters),ASNH245BEnhancementParameters_MakeMold,ASNH245BEnhancementParameters_Encode,ASNH245BEnhancementParameters_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245BEnhancementParameters_Print,
#endif
		delete_ASNH245BEnhancementParameters);
	AsnSequenceOf_SetMold( &(pObj->m_bPictureEnhancement), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_bPictureEnhancement.constraint.type = e_constrained;
	pObj->m_bPictureEnhancement.constraint.minValue = 1;
	pObj->m_bPictureEnhancement.constraint.maxValue = 14;
	pObj->m_bPictureEnhancement.extMinValue = 0;
	pObj->m_bPictureEnhancement.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245EnhancementLayerInfo IncludeOptionalField */
HS_RESULT ASNH245EnhancementLayerInfo_IncludeOptionField( void *pObject, ASNH245EnhancementLayerInfoOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245EnhancementLayerInfo *pObj = (ASNH245EnhancementLayerInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementLayerInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245EnhancementLayerInfoOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245EnhancementLayerInfo IsIncludeOptionalField */
BOOL ASNH245EnhancementLayerInfo_IsIncludeOptionField( void *pObject, ASNH245EnhancementLayerInfoOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245EnhancementLayerInfo *pObj = (ASNH245EnhancementLayerInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementLayerInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245EnhancementLayerInfoOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245EnhancementLayerInfo Encode */
HS_RESULT ASNH245EnhancementLayerInfo_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245EnhancementLayerInfo *pObj = (ASNH245EnhancementLayerInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245EnhancementLayerInfoOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245EnhancementLayerInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Encode( &(pObj->m_baseBitRateConstrained),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245EnhancementLayerInfo_IsIncludeOptionField( pObj, e_ASNH245EnhancementLayerInfoOptionMap_snrEnhancement ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_snrEnhancement),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementLayerInfo_IsIncludeOptionField( pObj, e_ASNH245EnhancementLayerInfoOptionMap_spatialEnhancement ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_spatialEnhancement),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementLayerInfo_IsIncludeOptionField( pObj, e_ASNH245EnhancementLayerInfoOptionMap_bPictureEnhancement ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_bPictureEnhancement),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245EnhancementLayerInfo Decode */
HS_RESULT ASNH245EnhancementLayerInfo_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245EnhancementLayerInfo *pObj = (ASNH245EnhancementLayerInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245EnhancementLayerInfoOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245EnhancementLayerInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_baseBitRateConstrained),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245EnhancementLayerInfo_IsIncludeOptionField( pObj, e_ASNH245EnhancementLayerInfoOptionMap_snrEnhancement ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_snrEnhancement),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementLayerInfo_IsIncludeOptionField( pObj, e_ASNH245EnhancementLayerInfoOptionMap_spatialEnhancement ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_spatialEnhancement),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245EnhancementLayerInfo_IsIncludeOptionField( pObj, e_ASNH245EnhancementLayerInfoOptionMap_bPictureEnhancement ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_bPictureEnhancement),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245EnhancementLayerInfo Print */
HS_RESULT ASNH245EnhancementLayerInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245EnhancementLayerInfo *pObj = (ASNH245EnhancementLayerInfo *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245EnhancementLayerInfo_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_baseBitRateConstrained), pDepth+1, "baseBitRateConstrained" );
	if( ASNH245EnhancementLayerInfo_IsIncludeOptionField( pObj, e_ASNH245EnhancementLayerInfoOptionMap_snrEnhancement ) )
		AsnSequenceOf_Print( &(pObj->m_snrEnhancement), pDepth+1, "snrEnhancement" );
	if( ASNH245EnhancementLayerInfo_IsIncludeOptionField( pObj, e_ASNH245EnhancementLayerInfoOptionMap_spatialEnhancement ) )
		AsnSequenceOf_Print( &(pObj->m_spatialEnhancement), pDepth+1, "spatialEnhancement" );
	if( ASNH245EnhancementLayerInfo_IsIncludeOptionField( pObj, e_ASNH245EnhancementLayerInfoOptionMap_bPictureEnhancement ) )
		AsnSequenceOf_Print( &(pObj->m_bPictureEnhancement), pDepth+1, "bPictureEnhancement" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H263VideoCapability Class
*/
/*ASNH245H263VideoCapability Constructor*/
HS_RESULT new_ASNH245H263VideoCapability(void *pObject)
{
	ASNH245H263VideoCapability *pObj = (ASNH245H263VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H263VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_sqcifMPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_qcifMPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cifMPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cif4MPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_cif16MPI), e_constrained, 1, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_maxBitRate), e_constrained, 1, 192400, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_unrestrictedVector) );
	new_AsnBoolean( &(pObj->m_arithmeticCoding) );
	new_AsnBoolean( &(pObj->m_advancedPrediction) );
	new_AsnBoolean( &(pObj->m_pbFrames) );
	new_AsnBoolean( &(pObj->m_temporalSpatialTradeOffCapability) );
	new_AsnInteger( &(pObj->m_hrd_B), e_constrained, 0, 524287, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_bppMaxKb), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_slowSqcifMPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_slowQcifMPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_slowCifMPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_slowCif4MPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_slowCif16MPI), e_constrained, 1, 3600, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_errorCompensation) );
	new_ASNH245EnhancementLayerInfo( &(pObj->m_enhancementLayerInfo) );
	new_ASNH245H263Options( &(pObj->m_h263Options) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H263VideoCapability Destructor */
HS_RESULT delete_ASNH245H263VideoCapability(void *pObject)
{
	ASNH245H263VideoCapability *pObj = (ASNH245H263VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H263VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_sqcifMPI) );
	delete_AsnInteger( &(pObj->m_qcifMPI) );
	delete_AsnInteger( &(pObj->m_cifMPI) );
	delete_AsnInteger( &(pObj->m_cif4MPI) );
	delete_AsnInteger( &(pObj->m_cif16MPI) );
	delete_AsnInteger( &(pObj->m_maxBitRate) );
	delete_AsnBoolean( &(pObj->m_unrestrictedVector) );
	delete_AsnBoolean( &(pObj->m_arithmeticCoding) );
	delete_AsnBoolean( &(pObj->m_advancedPrediction) );
	delete_AsnBoolean( &(pObj->m_pbFrames) );
	delete_AsnBoolean( &(pObj->m_temporalSpatialTradeOffCapability) );
	delete_AsnInteger( &(pObj->m_hrd_B) );
	delete_AsnInteger( &(pObj->m_bppMaxKb) );
	delete_AsnInteger( &(pObj->m_slowSqcifMPI) );
	delete_AsnInteger( &(pObj->m_slowQcifMPI) );
	delete_AsnInteger( &(pObj->m_slowCifMPI) );
	delete_AsnInteger( &(pObj->m_slowCif4MPI) );
	delete_AsnInteger( &(pObj->m_slowCif16MPI) );
	delete_AsnBoolean( &(pObj->m_errorCompensation) );
	delete_ASNH245EnhancementLayerInfo( &(pObj->m_enhancementLayerInfo) );
	delete_ASNH245H263Options( &(pObj->m_h263Options) );
	return HS_OK;
}

/* ASNH245H263VideoCapability MakeMold */
HS_RESULT ASNH245H263VideoCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H263VideoCapability *pObj = (ASNH245H263VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245EnhancementLayerInfo_MakeMold(&(pObj->m_enhancementLayerInfo));
	ASNH245H263Options_MakeMold(&(pObj->m_h263Options));
	return HS_OK;
}

/* ASNH245H263VideoCapability IncludeOptionalField */
HS_RESULT ASNH245H263VideoCapability_IncludeOptionField( void *pObject, ASNH245H263VideoCapabilityOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H263VideoCapability *pObj = (ASNH245H263VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H263VideoCapabilityOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H263VideoCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H263VideoCapabilityOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245H263VideoCapability IsIncludeOptionalField */
BOOL ASNH245H263VideoCapability_IsIncludeOptionField( void *pObject, ASNH245H263VideoCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H263VideoCapability *pObj = (ASNH245H263VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H263VideoCapabilityOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H263VideoCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H263VideoCapabilityOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H263VideoCapability Encode */
HS_RESULT ASNH245H263VideoCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H263VideoCapability *pObj = (ASNH245H263VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245H263VideoCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245H263VideoCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_sqcifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_sqcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_qcifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_qcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_cifMPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_cif4MPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cif4MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_cif16MPI ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_cif16MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maxBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_unrestrictedVector),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_arithmeticCoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_advancedPrediction),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_pbFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_temporalSpatialTradeOffCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_hrd_B ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_hrd_B),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_bppMaxKb ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_bppMaxKb),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowSqcifMPI ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_slowSqcifMPI), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowQcifMPI ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_slowQcifMPI), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowCifMPI ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_slowCifMPI), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowCif4MPI ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_slowCif4MPI), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowCif16MPI ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_slowCif16MPI), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_errorCompensation ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_errorCompensation), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_enhancementLayerInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_enhancementLayerInfo), ASNH245EnhancementLayerInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_h263Options ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h263Options), ASNH245H263Options_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H263VideoCapability Decode */
HS_RESULT ASNH245H263VideoCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H263VideoCapability *pObj = (ASNH245H263VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245H263VideoCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245H263VideoCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_sqcifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_sqcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_qcifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_qcifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_cifMPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cifMPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_cif4MPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cif4MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_cif16MPI ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_cif16MPI),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_unrestrictedVector),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_arithmeticCoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_advancedPrediction),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_pbFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_temporalSpatialTradeOffCapability),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_hrd_B ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_hrd_B),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_bppMaxKb ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_bppMaxKb),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowSqcifMPI ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_slowSqcifMPI), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowQcifMPI ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_slowQcifMPI), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowCifMPI ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_slowCifMPI), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowCif4MPI ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_slowCif4MPI), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowCif16MPI ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_slowCif16MPI), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_errorCompensation ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_errorCompensation), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_enhancementLayerInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_enhancementLayerInfo), ASNH245EnhancementLayerInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_h263Options ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_h263Options), ASNH245H263Options_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H263VideoCapability Print */
HS_RESULT ASNH245H263VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H263VideoCapability *pObj = (ASNH245H263VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H263VideoCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_sqcifMPI ) )
		AsnInteger_Print( &(pObj->m_sqcifMPI), pDepth+1, "sqcifMPI" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_qcifMPI ) )
		AsnInteger_Print( &(pObj->m_qcifMPI), pDepth+1, "qcifMPI" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_cifMPI ) )
		AsnInteger_Print( &(pObj->m_cifMPI), pDepth+1, "cifMPI" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_cif4MPI ) )
		AsnInteger_Print( &(pObj->m_cif4MPI), pDepth+1, "cif4MPI" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_cif16MPI ) )
		AsnInteger_Print( &(pObj->m_cif16MPI), pDepth+1, "cif16MPI" );
	AsnInteger_Print( &(pObj->m_maxBitRate), pDepth+1, "maxBitRate" );
	AsnBoolean_Print( &(pObj->m_unrestrictedVector), pDepth+1, "unrestrictedVector" );
	AsnBoolean_Print( &(pObj->m_arithmeticCoding), pDepth+1, "arithmeticCoding" );
	AsnBoolean_Print( &(pObj->m_advancedPrediction), pDepth+1, "advancedPrediction" );
	AsnBoolean_Print( &(pObj->m_pbFrames), pDepth+1, "pbFrames" );
	AsnBoolean_Print( &(pObj->m_temporalSpatialTradeOffCapability), pDepth+1, "temporalSpatialTradeOffCapability" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_hrd_B ) )
		AsnInteger_Print( &(pObj->m_hrd_B), pDepth+1, "hrd_B" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_bppMaxKb ) )
		AsnInteger_Print( &(pObj->m_bppMaxKb), pDepth+1, "bppMaxKb" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowSqcifMPI ) )
		AsnInteger_Print( &(pObj->m_slowSqcifMPI), pDepth+1, "slowSqcifMPI" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowQcifMPI ) )
		AsnInteger_Print( &(pObj->m_slowQcifMPI), pDepth+1, "slowQcifMPI" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowCifMPI ) )
		AsnInteger_Print( &(pObj->m_slowCifMPI), pDepth+1, "slowCifMPI" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowCif4MPI ) )
		AsnInteger_Print( &(pObj->m_slowCif4MPI), pDepth+1, "slowCif4MPI" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_slowCif16MPI ) )
		AsnInteger_Print( &(pObj->m_slowCif16MPI), pDepth+1, "slowCif16MPI" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_errorCompensation ) )
		AsnBoolean_Print( &(pObj->m_errorCompensation), pDepth+1, "errorCompensation" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_enhancementLayerInfo ) )
		ASNH245EnhancementLayerInfo_Print( &(pObj->m_enhancementLayerInfo), pDepth+1, "enhancementLayerInfo" );
	if( ASNH245H263VideoCapability_IsIncludeOptionField( pObj, e_ASNH245H263VideoCapabilityOptionMap_h263Options ) )
		ASNH245H263Options_Print( &(pObj->m_h263Options), pDepth+1, "h263Options" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS11172VideoCapability Class
*/
/*ASNH245IS11172VideoCapability Constructor*/
HS_RESULT new_ASNH245IS11172VideoCapability(void *pObject)
{
	ASNH245IS11172VideoCapability *pObj = (ASNH245IS11172VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS11172VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_constrainedBitstream) );
	new_AsnInteger( &(pObj->m_videoBitRate), e_constrained, 0, 1073741823, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_vbvBufferSize), e_constrained, 0, 262143, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_samplesPerLine), e_constrained, 0, 16383, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_linesPerFrame), e_constrained, 0, 16383, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_pictureRate), e_constrained, 0, 15, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_luminanceSampleRate), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_videoBadMBsCap) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245IS11172VideoCapability Destructor */
HS_RESULT delete_ASNH245IS11172VideoCapability(void *pObject)
{
	ASNH245IS11172VideoCapability *pObj = (ASNH245IS11172VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_constrainedBitstream) );
	delete_AsnInteger( &(pObj->m_videoBitRate) );
	delete_AsnInteger( &(pObj->m_vbvBufferSize) );
	delete_AsnInteger( &(pObj->m_samplesPerLine) );
	delete_AsnInteger( &(pObj->m_linesPerFrame) );
	delete_AsnInteger( &(pObj->m_pictureRate) );
	delete_AsnInteger( &(pObj->m_luminanceSampleRate) );
	delete_AsnBoolean( &(pObj->m_videoBadMBsCap) );
	return HS_OK;
}

/* ASNH245IS11172VideoCapability MakeMold */
HS_RESULT ASNH245IS11172VideoCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245IS11172VideoCapability *pObj = (ASNH245IS11172VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245IS11172VideoCapability IncludeOptionalField */
HS_RESULT ASNH245IS11172VideoCapability_IncludeOptionField( void *pObject, ASNH245IS11172VideoCapabilityOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245IS11172VideoCapability *pObj = (ASNH245IS11172VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245IS11172VideoCapabilityOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245IS11172VideoCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245IS11172VideoCapabilityOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245IS11172VideoCapability IsIncludeOptionalField */
BOOL ASNH245IS11172VideoCapability_IsIncludeOptionField( void *pObject, ASNH245IS11172VideoCapabilityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245IS11172VideoCapability *pObj = (ASNH245IS11172VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoCapability_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245IS11172VideoCapabilityOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245IS11172VideoCapabilityOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245IS11172VideoCapabilityOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245IS11172VideoCapability Encode */
HS_RESULT ASNH245IS11172VideoCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245IS11172VideoCapability *pObj = (ASNH245IS11172VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245IS11172VideoCapabilityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245IS11172VideoCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Encode( &(pObj->m_constrainedBitstream),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_videoBitRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_videoBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_vbvBufferSize ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_vbvBufferSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_samplesPerLine ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_samplesPerLine),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_linesPerFrame ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_linesPerFrame),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_pictureRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_pictureRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_luminanceSampleRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_luminanceSampleRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_videoBadMBsCap ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_videoBadMBsCap), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245IS11172VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245IS11172VideoCapability Decode */
HS_RESULT ASNH245IS11172VideoCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245IS11172VideoCapability *pObj = (ASNH245IS11172VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245IS11172VideoCapabilityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245IS11172VideoCapabilityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_constrainedBitstream),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_videoBitRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_videoBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_vbvBufferSize ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_vbvBufferSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_samplesPerLine ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_samplesPerLine),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_linesPerFrame ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_linesPerFrame),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_pictureRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_pictureRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_luminanceSampleRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_luminanceSampleRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_videoBadMBsCap ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_videoBadMBsCap), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS11172VideoCapability Print */
HS_RESULT ASNH245IS11172VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS11172VideoCapability *pObj = (ASNH245IS11172VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS11172VideoCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_constrainedBitstream), pDepth+1, "constrainedBitstream" );
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_videoBitRate ) )
		AsnInteger_Print( &(pObj->m_videoBitRate), pDepth+1, "videoBitRate" );
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_vbvBufferSize ) )
		AsnInteger_Print( &(pObj->m_vbvBufferSize), pDepth+1, "vbvBufferSize" );
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_samplesPerLine ) )
		AsnInteger_Print( &(pObj->m_samplesPerLine), pDepth+1, "samplesPerLine" );
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_linesPerFrame ) )
		AsnInteger_Print( &(pObj->m_linesPerFrame), pDepth+1, "linesPerFrame" );
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_pictureRate ) )
		AsnInteger_Print( &(pObj->m_pictureRate), pDepth+1, "pictureRate" );
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_luminanceSampleRate ) )
		AsnInteger_Print( &(pObj->m_luminanceSampleRate), pDepth+1, "luminanceSampleRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245IS11172VideoCapability_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoCapabilityOptionMap_videoBadMBsCap ) )
		AsnBoolean_Print( &(pObj->m_videoBadMBsCap), pDepth+1, "videoBadMBsCap" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VideoCapability Struct
*/
/* ASNH245VideoCapability Constructor */
HS_RESULT new_ASNH245VideoCapability( void *pObject )
{
	ASNH245VideoCapability *pObj = (ASNH245VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245VideoCapabilityChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245VideoCapabilityChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245VideoCapability Destructor */
HS_RESULT delete_ASNH245VideoCapability( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245VideoCapability *pObj = (ASNH245VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VideoCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245VideoCapability_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VideoCapability(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245VideoCapability SetChoice */
void* ASNH245VideoCapability_SetChoice( void *pObject, ASNH245VideoCapabilityChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245VideoCapability *pObj = (ASNH245VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoCapability_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245VideoCapabilityChoiceSizeExt ){
		if( pChoice > (ASNH245VideoCapabilityChoice)(e_ASNH245VideoCapabilityChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245VideoCapability_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245VideoCapabilityChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245VideoCapabilityChoice_h261VideoCapability ){
		ASNH245H261VideoCapability *tAlter = (ASNH245H261VideoCapability *)HSMalloc( sizeof(ASNH245H261VideoCapability) );
		new_ASNH245H261VideoCapability(tAlter);
		ASNH245H261VideoCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245VideoCapabilityChoice_h262VideoCapability ){
		ASNH245H262VideoCapability *tAlter = (ASNH245H262VideoCapability *)HSMalloc( sizeof(ASNH245H262VideoCapability) );
		new_ASNH245H262VideoCapability(tAlter);
		ASNH245H262VideoCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245VideoCapabilityChoice_h263VideoCapability ){
		ASNH245H263VideoCapability *tAlter = (ASNH245H263VideoCapability *)HSMalloc( sizeof(ASNH245H263VideoCapability) );
		new_ASNH245H263VideoCapability(tAlter);
		ASNH245H263VideoCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245VideoCapabilityChoice_is11172VideoCapability ){
		ASNH245IS11172VideoCapability *tAlter = (ASNH245IS11172VideoCapability *)HSMalloc( sizeof(ASNH245IS11172VideoCapability) );
		new_ASNH245IS11172VideoCapability(tAlter);
		ASNH245IS11172VideoCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245VideoCapabilityChoice_genericVideoCapability ){
		ASNH245GenericCapability *tAlter = (ASNH245GenericCapability *)HSMalloc( sizeof(ASNH245GenericCapability) );
		new_ASNH245GenericCapability(tAlter);
		ASNH245GenericCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoCapability_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245VideoCapability DeleteAlternation */
HS_RESULT ASNH245VideoCapability_DeleteAlternation(void *pObject)
{
	ASNH245VideoCapability *pObj = (ASNH245VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoCapability_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245VideoCapabilityChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h261VideoCapability ){
			delete_ASNH245H261VideoCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h262VideoCapability ){
			delete_ASNH245H262VideoCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h263VideoCapability ){
			delete_ASNH245H263VideoCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_is11172VideoCapability ){
			delete_ASNH245IS11172VideoCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_genericVideoCapability ){
			delete_ASNH245GenericCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245VideoCapability_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245VideoCapability Encode */
HS_RESULT ASNH245VideoCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245VideoCapability *pObj = (ASNH245VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoCapability_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245VideoCapabilityChoiceSize )
		{
			if( pObj->choice > ((ASNH245VideoCapabilityChoice)(e_ASNH245VideoCapabilityChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245VideoCapabilityChoiceSize)) )
	}
	else
	{
		if( e_ASNH245VideoCapabilityChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245VideoCapabilityChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h261VideoCapability ){
		if( (tRet=ASNH245H261VideoCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h262VideoCapability ){
		if( (tRet=ASNH245H262VideoCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h263VideoCapability ){
		if( (tRet=ASNH245H263VideoCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_is11172VideoCapability ){
		if( (tRet=ASNH245IS11172VideoCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_genericVideoCapability ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245GenericCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoCapability_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245VideoCapability Decode */
HS_RESULT ASNH245VideoCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245VideoCapability *pObj = (ASNH245VideoCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245VideoCapabilityChoiceSize;
	}
	else
	{
		if( e_ASNH245VideoCapabilityChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245VideoCapabilityChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245VideoCapabilityChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245VideoCapability_SetChoice( pObj, (ASNH245VideoCapabilityChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoCapability_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245VideoCapabilityChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h261VideoCapability ){
		if( (tRet=ASNH245H261VideoCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h262VideoCapability ){
		if( (tRet=ASNH245H262VideoCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h263VideoCapability ){
		if( (tRet=ASNH245H263VideoCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_is11172VideoCapability ){
		if( (tRet=ASNH245IS11172VideoCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_genericVideoCapability ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245GenericCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoCapability_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoCapability_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VideoCapability Print */
HS_RESULT ASNH245VideoCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VideoCapability *pObj = (ASNH245VideoCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VideoCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245VideoCapabilityChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h261VideoCapability ){
		ASNH245H261VideoCapability_Print( pObj->alter, pDepth+1, "h261VideoCapability" );
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h262VideoCapability ){
		ASNH245H262VideoCapability_Print( pObj->alter, pDepth+1, "h262VideoCapability" );
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_h263VideoCapability ){
		ASNH245H263VideoCapability_Print( pObj->alter, pDepth+1, "h263VideoCapability" );
	}
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_is11172VideoCapability ){
		ASNH245IS11172VideoCapability_Print( pObj->alter, pDepth+1, "is11172VideoCapability" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245VideoCapabilityChoice_genericVideoCapability ){
		ASNH245GenericCapability_Print( pObj->alter, pDepth+1, "genericVideoCapability" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245AudioCapability_g7231 Class
*/
/*ASNH245AudioCapability_g7231 Constructor*/
HS_RESULT new_ASNH245AudioCapability_g7231(void *pObject)
{
	ASNH245AudioCapability_g7231 *pObj = (ASNH245AudioCapability_g7231 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245AudioCapability_g7231(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_maxAl_sduAudioFrames), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_silenceSuppression) );

	return HS_OK;
}

/* ASNH245AudioCapability_g7231 Destructor */
HS_RESULT delete_ASNH245AudioCapability_g7231(void *pObject)
{
	ASNH245AudioCapability_g7231 *pObj = (ASNH245AudioCapability_g7231 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245AudioCapability_g7231(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_maxAl_sduAudioFrames) );
	delete_AsnBoolean( &(pObj->m_silenceSuppression) );
	return HS_OK;
}

/* ASNH245AudioCapability_g7231 MakeMold */
HS_RESULT ASNH245AudioCapability_g7231_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245AudioCapability_g7231 *pObj = (ASNH245AudioCapability_g7231 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioCapability_g7231_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245AudioCapability_g7231 Encode */
HS_RESULT ASNH245AudioCapability_g7231_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245AudioCapability_g7231 *pObj = (ASNH245AudioCapability_g7231 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioCapability_g7231_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_maxAl_sduAudioFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioCapability_g7231_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_silenceSuppression),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioCapability_g7231_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245AudioCapability_g7231 Decode */
HS_RESULT ASNH245AudioCapability_g7231_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245AudioCapability_g7231 *pObj = (ASNH245AudioCapability_g7231 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioCapability_g7231_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxAl_sduAudioFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioCapability_g7231_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_silenceSuppression),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioCapability_g7231_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245AudioCapability_g7231 Print */
HS_RESULT ASNH245AudioCapability_g7231_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245AudioCapability_g7231 *pObj = (ASNH245AudioCapability_g7231 *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245AudioCapability_g7231_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_maxAl_sduAudioFrames), pDepth+1, "maxAl_sduAudioFrames" );
	AsnBoolean_Print( &(pObj->m_silenceSuppression), pDepth+1, "silenceSuppression" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS11172AudioCapability Class
*/
/*ASNH245IS11172AudioCapability Constructor*/
HS_RESULT new_ASNH245IS11172AudioCapability(void *pObject)
{
	ASNH245IS11172AudioCapability *pObj = (ASNH245IS11172AudioCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS11172AudioCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_audioLayer1) );
	new_AsnBoolean( &(pObj->m_audioLayer2) );
	new_AsnBoolean( &(pObj->m_audioLayer3) );
	new_AsnBoolean( &(pObj->m_audioSampling32k) );
	new_AsnBoolean( &(pObj->m_audioSampling44k1) );
	new_AsnBoolean( &(pObj->m_audioSampling48k) );
	new_AsnBoolean( &(pObj->m_singleChannel) );
	new_AsnBoolean( &(pObj->m_twoChannels) );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 448, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245IS11172AudioCapability Destructor */
HS_RESULT delete_ASNH245IS11172AudioCapability(void *pObject)
{
	ASNH245IS11172AudioCapability *pObj = (ASNH245IS11172AudioCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172AudioCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_audioLayer1) );
	delete_AsnBoolean( &(pObj->m_audioLayer2) );
	delete_AsnBoolean( &(pObj->m_audioLayer3) );
	delete_AsnBoolean( &(pObj->m_audioSampling32k) );
	delete_AsnBoolean( &(pObj->m_audioSampling44k1) );
	delete_AsnBoolean( &(pObj->m_audioSampling48k) );
	delete_AsnBoolean( &(pObj->m_singleChannel) );
	delete_AsnBoolean( &(pObj->m_twoChannels) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	return HS_OK;
}

/* ASNH245IS11172AudioCapability MakeMold */
HS_RESULT ASNH245IS11172AudioCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245IS11172AudioCapability *pObj = (ASNH245IS11172AudioCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245IS11172AudioCapability Encode */
HS_RESULT ASNH245IS11172AudioCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245IS11172AudioCapability *pObj = (ASNH245IS11172AudioCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioLayer1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioLayer2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioLayer3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioSampling32k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioSampling44k1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioSampling48k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_singleChannel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_twoChannels),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245IS11172AudioCapability Decode */
HS_RESULT ASNH245IS11172AudioCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245IS11172AudioCapability *pObj = (ASNH245IS11172AudioCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioLayer1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioLayer2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioLayer3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioSampling32k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioSampling44k1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioSampling48k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_singleChannel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_twoChannels),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS11172AudioCapability Print */
HS_RESULT ASNH245IS11172AudioCapability_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS11172AudioCapability *pObj = (ASNH245IS11172AudioCapability *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS11172AudioCapability_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_audioLayer1), pDepth+1, "audioLayer1" );
	AsnBoolean_Print( &(pObj->m_audioLayer2), pDepth+1, "audioLayer2" );
	AsnBoolean_Print( &(pObj->m_audioLayer3), pDepth+1, "audioLayer3" );
	AsnBoolean_Print( &(pObj->m_audioSampling32k), pDepth+1, "audioSampling32k" );
	AsnBoolean_Print( &(pObj->m_audioSampling44k1), pDepth+1, "audioSampling44k1" );
	AsnBoolean_Print( &(pObj->m_audioSampling48k), pDepth+1, "audioSampling48k" );
	AsnBoolean_Print( &(pObj->m_singleChannel), pDepth+1, "singleChannel" );
	AsnBoolean_Print( &(pObj->m_twoChannels), pDepth+1, "twoChannels" );
	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS13818AudioCapability Class
*/
/*ASNH245IS13818AudioCapability Constructor*/
HS_RESULT new_ASNH245IS13818AudioCapability(void *pObject)
{
	ASNH245IS13818AudioCapability *pObj = (ASNH245IS13818AudioCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS13818AudioCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_audioLayer1) );
	new_AsnBoolean( &(pObj->m_audioLayer2) );
	new_AsnBoolean( &(pObj->m_audioLayer3) );
	new_AsnBoolean( &(pObj->m_audioSampling16k) );
	new_AsnBoolean( &(pObj->m_audioSampling22k05) );
	new_AsnBoolean( &(pObj->m_audioSampling24k) );
	new_AsnBoolean( &(pObj->m_audioSampling32k) );
	new_AsnBoolean( &(pObj->m_audioSampling44k1) );
	new_AsnBoolean( &(pObj->m_audioSampling48k) );
	new_AsnBoolean( &(pObj->m_singleChannel) );
	new_AsnBoolean( &(pObj->m_twoChannels) );
	new_AsnBoolean( &(pObj->m_threeChannels2_1) );
	new_AsnBoolean( &(pObj->m_threeChannels3_0) );
	new_AsnBoolean( &(pObj->m_fourChannels2_0_2_0) );
	new_AsnBoolean( &(pObj->m_fourChannels2_2) );
	new_AsnBoolean( &(pObj->m_fourChannels3_1) );
	new_AsnBoolean( &(pObj->m_fiveChannels3_0_2_0) );
	new_AsnBoolean( &(pObj->m_fiveChannels3_2) );
	new_AsnBoolean( &(pObj->m_lowFrequencyEnhancement) );
	new_AsnBoolean( &(pObj->m_multilingual) );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 1130, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245IS13818AudioCapability Destructor */
HS_RESULT delete_ASNH245IS13818AudioCapability(void *pObject)
{
	ASNH245IS13818AudioCapability *pObj = (ASNH245IS13818AudioCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS13818AudioCapability(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_audioLayer1) );
	delete_AsnBoolean( &(pObj->m_audioLayer2) );
	delete_AsnBoolean( &(pObj->m_audioLayer3) );
	delete_AsnBoolean( &(pObj->m_audioSampling16k) );
	delete_AsnBoolean( &(pObj->m_audioSampling22k05) );
	delete_AsnBoolean( &(pObj->m_audioSampling24k) );
	delete_AsnBoolean( &(pObj->m_audioSampling32k) );
	delete_AsnBoolean( &(pObj->m_audioSampling44k1) );
	delete_AsnBoolean( &(pObj->m_audioSampling48k) );
	delete_AsnBoolean( &(pObj->m_singleChannel) );
	delete_AsnBoolean( &(pObj->m_twoChannels) );
	delete_AsnBoolean( &(pObj->m_threeChannels2_1) );
	delete_AsnBoolean( &(pObj->m_threeChannels3_0) );
	delete_AsnBoolean( &(pObj->m_fourChannels2_0_2_0) );
	delete_AsnBoolean( &(pObj->m_fourChannels2_2) );
	delete_AsnBoolean( &(pObj->m_fourChannels3_1) );
	delete_AsnBoolean( &(pObj->m_fiveChannels3_0_2_0) );
	delete_AsnBoolean( &(pObj->m_fiveChannels3_2) );
	delete_AsnBoolean( &(pObj->m_lowFrequencyEnhancement) );
	delete_AsnBoolean( &(pObj->m_multilingual) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	return HS_OK;
}

/* ASNH245IS13818AudioCapability MakeMold */
HS_RESULT ASNH245IS13818AudioCapability_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245IS13818AudioCapability *pObj = (ASNH245IS13818AudioCapability *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245IS13818AudioCapability Encode */
HS_RESULT ASNH245IS13818AudioCapability_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245IS13818AudioCapability *pObj = (ASNH245IS13818AudioCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioLayer1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioLayer2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioLayer3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioSampling16k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioSampling22k05),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioSampling24k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioSampling32k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioSampling44k1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioSampling48k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_singleChannel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_twoChannels),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_threeChannels2_1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_threeChannels3_0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_fourChannels2_0_2_0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_fourChannels2_2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_fourChannels3_1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_fiveChannels3_0_2_0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_fiveChannels3_2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_lowFrequencyEnhancement),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_multilingual),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245IS13818AudioCapability Decode */
HS_RESULT ASNH245IS13818AudioCapability_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245IS13818AudioCapability *pObj = (ASNH245IS13818AudioCapability *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioLayer1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioLayer2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioLayer3),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioSampling16k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioSampling22k05),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioSampling24k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioSampling32k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioSampling44k1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioSampling48k),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_singleChannel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_twoChannels),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_threeChannels2_1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_threeChannels3_0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_fourChannels2_0_2_0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_fourChannels2_2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_fourChannels3_1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_fiveChannels3_0_2_0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_fiveChannels3_2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_lowFrequencyEnhancement),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_multilingual),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioCapability_Decode(pObj,pStrm) -> tRe