/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<h245_1.c>

*/

#include "H245.h"

/***************************************************************************************/
/* ASNH245V76HDLCParameters Class
*/
/*ASNH245V76HDLCParameters Constructor*/
HS_RESULT new_ASNH245V76HDLCParameters(void *pObject)
{
	ASNH245V76HDLCParameters *pObj = (ASNH245V76HDLCParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V76HDLCParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245CRCLength( &(pObj->m_crcLength) );
	new_AsnInteger( &(pObj->m_n401), e_constrained, 1, 4095, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_loopbackTestProcedure) );

	return HS_OK;
}

/* ASNH245V76HDLCParameters Destructor */
HS_RESULT delete_ASNH245V76HDLCParameters(void *pObject)
{
	ASNH245V76HDLCParameters *pObj = (ASNH245V76HDLCParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76HDLCParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245CRCLength( &(pObj->m_crcLength) );
	delete_AsnInteger( &(pObj->m_n401) );
	delete_AsnBoolean( &(pObj->m_loopbackTestProcedure) );
	return HS_OK;
}

/* ASNH245V76HDLCParameters MakeMold */
HS_RESULT ASNH245V76HDLCParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245V76HDLCParameters *pObj = (ASNH245V76HDLCParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76HDLCParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245CRCLength_MakeMold(&(pObj->m_crcLength));
	return HS_OK;
}

/* ASNH245V76HDLCParameters Encode */
HS_RESULT ASNH245V76HDLCParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V76HDLCParameters *pObj = (ASNH245V76HDLCParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76HDLCParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245CRCLength_Encode( &(pObj->m_crcLength),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76HDLCParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_n401),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76HDLCParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_loopbackTestProcedure),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76HDLCParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245V76HDLCParameters Decode */
HS_RESULT ASNH245V76HDLCParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V76HDLCParameters *pObj = (ASNH245V76HDLCParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76HDLCParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245CRCLength_Decode(&(pObj->m_crcLength),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76HDLCParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_n401),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76HDLCParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_loopbackTestProcedure),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76HDLCParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V76HDLCParameters Print */
HS_RESULT ASNH245V76HDLCParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V76HDLCParameters *pObj = (ASNH245V76HDLCParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V76HDLCParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245CRCLength_Print( &(pObj->m_crcLength), pDepth+1, "crcLength" );
	AsnInteger_Print( &(pObj->m_n401), pDepth+1, "n401" );
	AsnBoolean_Print( &(pObj->m_loopbackTestProcedure), pDepth+1, "loopbackTestProcedure" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245V76LogicalChannelParameters_suspendResume Struct
*/
/* ASNH245V76LogicalChannelParameters_suspendResume Constructor */
HS_RESULT new_ASNH245V76LogicalChannelParameters_suspendResume( void *pObject )
{
	ASNH245V76LogicalChannelParameters_suspendResume *pObj = (ASNH245V76LogicalChannelParameters_suspendResume *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V76LogicalChannelParameters_suspendResume(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_noSuspendResume;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245V76LogicalChannelParameters_suspendResume Destructor */
HS_RESULT delete_ASNH245V76LogicalChannelParameters_suspendResume( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245V76LogicalChannelParameters_suspendResume *pObj = (ASNH245V76LogicalChannelParameters_suspendResume *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76LogicalChannelParameters_suspendResume(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245V76LogicalChannelParameters_suspendResume_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76LogicalChannelParameters_suspendResume(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245V76LogicalChannelParameters_suspendResume SetChoice */
void* ASNH245V76LogicalChannelParameters_suspendResume_SetChoice( void *pObject, ASNH245V76LogicalChannelParameters_suspendResumeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245V76LogicalChannelParameters_suspendResume *pObj = (ASNH245V76LogicalChannelParameters_suspendResume *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSizeExt ){
		if( pChoice > (ASNH245V76LogicalChannelParameters_suspendResumeChoice)(e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245V76LogicalChannelParameters_suspendResume_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_noSuspendResume ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewAddress ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewoAddress ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245V76LogicalChannelParameters_suspendResume DeleteAlternation */
HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_DeleteAlternation(void *pObject)
{
	ASNH245V76LogicalChannelParameters_suspendResume *pObj = (ASNH245V76LogicalChannelParameters_suspendResume *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_noSuspendResume ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewAddress ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewoAddress ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245V76LogicalChannelParameters_suspendResume Encode */
HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245V76LogicalChannelParameters_suspendResume *pObj = (ASNH245V76LogicalChannelParameters_suspendResume *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSize )
		{
			if( pObj->choice > ((ASNH245V76LogicalChannelParameters_suspendResumeChoice)(e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_noSuspendResume ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewAddress ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewoAddress ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters_suspendResume Decode */
HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245V76LogicalChannelParameters_suspendResume *pObj = (ASNH245V76LogicalChannelParameters_suspendResume *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSize;
	}
	else
	{
		if( e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245V76LogicalChannelParameters_suspendResumeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245V76LogicalChannelParameters_suspendResume_SetChoice( pObj, (ASNH245V76LogicalChannelParameters_suspendResumeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_noSuspendResume ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewAddress ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewoAddress ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V76LogicalChannelParameters_suspendResume Print */
HS_RESULT ASNH245V76LogicalChannelParameters_suspendResume_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V76LogicalChannelParameters_suspendResume *pObj = (ASNH245V76LogicalChannelParameters_suspendResume *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_suspendResume_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_noSuspendResume ){
		AsnNull_Print( pObj->alter, pDepth+1, "noSuspendResume" );
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewAddress ){
		AsnNull_Print( pObj->alter, pDepth+1, "suspendResumewAddress" );
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_suspendResumeChoice_suspendResumewoAddress ){
		AsnNull_Print( pObj->alter, pDepth+1, "suspendResumewoAddress" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245V76LogicalChannelParameters_mode_eRM_recovery Struct
*/
/* ASNH245V76LogicalChannelParameters_mode_eRM_recovery Constructor */
HS_RESULT new_ASNH245V76LogicalChannelParameters_mode_eRM_recovery( void *pObject )
{
	ASNH245V76LogicalChannelParameters_mode_eRM_recovery *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM_recovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V76LogicalChannelParameters_mode_eRM_recovery(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_rej;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245V76LogicalChannelParameters_mode_eRM_recovery Destructor */
HS_RESULT delete_ASNH245V76LogicalChannelParameters_mode_eRM_recovery( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245V76LogicalChannelParameters_mode_eRM_recovery *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM_recovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76LogicalChannelParameters_mode_eRM_recovery(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245V76LogicalChannelParameters_mode_eRM_recovery_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76LogicalChannelParameters_mode_eRM_recovery(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245V76LogicalChannelParameters_mode_eRM_recovery SetChoice */
void* ASNH245V76LogicalChannelParameters_mode_eRM_recovery_SetChoice( void *pObject, ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245V76LogicalChannelParameters_mode_eRM_recovery *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM_recovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSizeExt ){
		if( pChoice > (ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice)(e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245V76LogicalChannelParameters_mode_eRM_recovery_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_rej ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_sREJ ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_mSREJ ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245V76LogicalChannelParameters_mode_eRM_recovery DeleteAlternation */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_DeleteAlternation(void *pObject)
{
	ASNH245V76LogicalChannelParameters_mode_eRM_recovery *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM_recovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_rej ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_sREJ ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_mSREJ ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245V76LogicalChannelParameters_mode_eRM_recovery Encode */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245V76LogicalChannelParameters_mode_eRM_recovery *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM_recovery *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSize )
		{
			if( pObj->choice > ((ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice)(e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSize)) )
	}
	else
	{
		if( e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_rej ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_sREJ ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_mSREJ ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters_mode_eRM_recovery Decode */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245V76LogicalChannelParameters_mode_eRM_recovery *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM_recovery *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSize;
	}
	else
	{
		if( e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245V76LogicalChannelParameters_mode_eRM_recovery_SetChoice( pObj, (ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_rej ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_sREJ ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_mSREJ ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V76LogicalChannelParameters_mode_eRM_recovery Print */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V76LogicalChannelParameters_mode_eRM_recovery *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM_recovery *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_rej ){
		AsnNull_Print( pObj->alter, pDepth+1, "rej" );
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_sREJ ){
		AsnNull_Print( pObj->alter, pDepth+1, "sREJ" );
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_mode_eRM_recoveryChoice_mSREJ ){
		AsnNull_Print( pObj->alter, pDepth+1, "mSREJ" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245V76LogicalChannelParameters_mode_eRM Class
*/
/*ASNH245V76LogicalChannelParameters_mode_eRM Constructor*/
HS_RESULT new_ASNH245V76LogicalChannelParameters_mode_eRM(void *pObject)
{
	ASNH245V76LogicalChannelParameters_mode_eRM *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V76LogicalChannelParameters_mode_eRM(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_windowSize), e_constrained, 1, 127, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245V76LogicalChannelParameters_mode_eRM_recovery( &(pObj->m_recovery) );

	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters_mode_eRM Destructor */
HS_RESULT delete_ASNH245V76LogicalChannelParameters_mode_eRM(void *pObject)
{
	ASNH245V76LogicalChannelParameters_mode_eRM *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76LogicalChannelParameters_mode_eRM(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_windowSize) );
	delete_ASNH245V76LogicalChannelParameters_mode_eRM_recovery( &(pObj->m_recovery) );
	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters_mode_eRM MakeMold */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245V76LogicalChannelParameters_mode_eRM *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters_mode_eRM Encode */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V76LogicalChannelParameters_mode_eRM *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_windowSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Encode( &(pObj->m_recovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters_mode_eRM Decode */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V76LogicalChannelParameters_mode_eRM *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_windowSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Decode(&(pObj->m_recovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V76LogicalChannelParameters_mode_eRM Print */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_eRM_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V76LogicalChannelParameters_mode_eRM *pObj = (ASNH245V76LogicalChannelParameters_mode_eRM *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_eRM_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_windowSize), pDepth+1, "windowSize" );
	ASNH245V76LogicalChannelParameters_mode_eRM_recovery_Print( &(pObj->m_recovery), pDepth+1, "recovery" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245V76LogicalChannelParameters_mode Struct
*/
/* ASNH245V76LogicalChannelParameters_mode Constructor */
HS_RESULT new_ASNH245V76LogicalChannelParameters_mode( void *pObject )
{
	ASNH245V76LogicalChannelParameters_mode *pObj = (ASNH245V76LogicalChannelParameters_mode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V76LogicalChannelParameters_mode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245V76LogicalChannelParameters_modeChoice_eRM;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245V76LogicalChannelParameters_modeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245V76LogicalChannelParameters_mode Destructor */
HS_RESULT delete_ASNH245V76LogicalChannelParameters_mode( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245V76LogicalChannelParameters_mode *pObj = (ASNH245V76LogicalChannelParameters_mode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76LogicalChannelParameters_mode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245V76LogicalChannelParameters_mode_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76LogicalChannelParameters_mode(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245V76LogicalChannelParameters_mode SetChoice */
void* ASNH245V76LogicalChannelParameters_mode_SetChoice( void *pObject, ASNH245V76LogicalChannelParameters_modeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245V76LogicalChannelParameters_mode *pObj = (ASNH245V76LogicalChannelParameters_mode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245V76LogicalChannelParameters_modeChoiceSizeExt ){
		if( pChoice > (ASNH245V76LogicalChannelParameters_modeChoice)(e_ASNH245V76LogicalChannelParameters_modeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245V76LogicalChannelParameters_mode_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245V76LogicalChannelParameters_modeChoice_eRM ){
		ASNH245V76LogicalChannelParameters_mode_eRM *tAlter = (ASNH245V76LogicalChannelParameters_mode_eRM *)HSMalloc( sizeof(ASNH245V76LogicalChannelParameters_mode_eRM) );
		new_ASNH245V76LogicalChannelParameters_mode_eRM(tAlter);
		ASNH245V76LogicalChannelParameters_mode_eRM_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245V76LogicalChannelParameters_modeChoice_uNERM ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245V76LogicalChannelParameters_mode DeleteAlternation */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_DeleteAlternation(void *pObject)
{
	ASNH245V76LogicalChannelParameters_mode *pObj = (ASNH245V76LogicalChannelParameters_mode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_modeChoice_eRM ){
			delete_ASNH245V76LogicalChannelParameters_mode_eRM(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_modeChoice_uNERM ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245V76LogicalChannelParameters_mode_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245V76LogicalChannelParameters_mode Encode */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245V76LogicalChannelParameters_mode *pObj = (ASNH245V76LogicalChannelParameters_mode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245V76LogicalChannelParameters_modeChoiceSize )
		{
			if( pObj->choice > ((ASNH245V76LogicalChannelParameters_modeChoice)(e_ASNH245V76LogicalChannelParameters_modeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245V76LogicalChannelParameters_modeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245V76LogicalChannelParameters_modeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_modeChoice_eRM ){
		if( (tRet=ASNH245V76LogicalChannelParameters_mode_eRM_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_modeChoice_uNERM ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters_mode Decode */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245V76LogicalChannelParameters_mode *pObj = (ASNH245V76LogicalChannelParameters_mode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245V76LogicalChannelParameters_modeChoiceSize;
	}
	else
	{
		if( e_ASNH245V76LogicalChannelParameters_modeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245V76LogicalChannelParameters_modeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245V76LogicalChannelParameters_modeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245V76LogicalChannelParameters_mode_SetChoice( pObj, (ASNH245V76LogicalChannelParameters_modeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_modeChoice_eRM ){
		if( (tRet=ASNH245V76LogicalChannelParameters_mode_eRM_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_modeChoice_uNERM ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V76LogicalChannelParameters_mode Print */
HS_RESULT ASNH245V76LogicalChannelParameters_mode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V76LogicalChannelParameters_mode *pObj = (ASNH245V76LogicalChannelParameters_mode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_mode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245V76LogicalChannelParameters_modeChoice_eRM ){
		ASNH245V76LogicalChannelParameters_mode_eRM_Print( pObj->alter, pDepth+1, "eRM" );
	}
	else if ( pObj->choice == e_ASNH245V76LogicalChannelParameters_modeChoice_uNERM ){
		AsnNull_Print( pObj->alter, pDepth+1, "uNERM" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245V75Parameters Class
*/
/*ASNH245V75Parameters Constructor*/
HS_RESULT new_ASNH245V75Parameters(void *pObject)
{
	ASNH245V75Parameters *pObj = (ASNH245V75Parameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V75Parameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_audioHeaderPresent) );

	return HS_OK;
}

/* ASNH245V75Parameters Destructor */
HS_RESULT delete_ASNH245V75Parameters(void *pObject)
{
	ASNH245V75Parameters *pObj = (ASNH245V75Parameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V75Parameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_audioHeaderPresent) );
	return HS_OK;
}

/* ASNH245V75Parameters MakeMold */
HS_RESULT ASNH245V75Parameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245V75Parameters *pObj = (ASNH245V75Parameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Parameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245V75Parameters Encode */
HS_RESULT ASNH245V75Parameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V75Parameters *pObj = (ASNH245V75Parameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Parameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_audioHeaderPresent),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Parameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245V75Parameters Decode */
HS_RESULT ASNH245V75Parameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V75Parameters *pObj = (ASNH245V75Parameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Parameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_audioHeaderPresent),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V75Parameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V75Parameters Print */
HS_RESULT ASNH245V75Parameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V75Parameters *pObj = (ASNH245V75Parameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V75Parameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_audioHeaderPresent), pDepth+1, "audioHeaderPresent" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245V76LogicalChannelParameters Class
*/
/*ASNH245V76LogicalChannelParameters Constructor*/
HS_RESULT new_ASNH245V76LogicalChannelParameters(void *pObject)
{
	ASNH245V76LogicalChannelParameters *pObj = (ASNH245V76LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245V76LogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245V76HDLCParameters( &(pObj->m_hdlcParameters) );
	new_ASNH245V76LogicalChannelParameters_suspendResume( &(pObj->m_suspendResume) );
	new_AsnBoolean( &(pObj->m_uIH) );
	new_ASNH245V76LogicalChannelParameters_mode( &(pObj->m_mode) );
	new_ASNH245V75Parameters( &(pObj->m_v75Parameters) );

	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters Destructor */
HS_RESULT delete_ASNH245V76LogicalChannelParameters(void *pObject)
{
	ASNH245V76LogicalChannelParameters *pObj = (ASNH245V76LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245V76LogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245V76HDLCParameters( &(pObj->m_hdlcParameters) );
	delete_ASNH245V76LogicalChannelParameters_suspendResume( &(pObj->m_suspendResume) );
	delete_AsnBoolean( &(pObj->m_uIH) );
	delete_ASNH245V76LogicalChannelParameters_mode( &(pObj->m_mode) );
	delete_ASNH245V75Parameters( &(pObj->m_v75Parameters) );
	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters MakeMold */
HS_RESULT ASNH245V76LogicalChannelParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245V76LogicalChannelParameters *pObj = (ASNH245V76LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245V76HDLCParameters_MakeMold(&(pObj->m_hdlcParameters));
	ASNH245V75Parameters_MakeMold(&(pObj->m_v75Parameters));
	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters Encode */
HS_RESULT ASNH245V76LogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V76LogicalChannelParameters *pObj = (ASNH245V76LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245V76HDLCParameters_Encode( &(pObj->m_hdlcParameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V76LogicalChannelParameters_suspendResume_Encode( &(pObj->m_suspendResume),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_uIH),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V76LogicalChannelParameters_mode_Encode( &(pObj->m_mode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V75Parameters_Encode( &(pObj->m_v75Parameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245V76LogicalChannelParameters Decode */
HS_RESULT ASNH245V76LogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245V76LogicalChannelParameters *pObj = (ASNH245V76LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245V76HDLCParameters_Decode(&(pObj->m_hdlcParameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V76LogicalChannelParameters_suspendResume_Decode(&(pObj->m_suspendResume),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_uIH),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V76LogicalChannelParameters_mode_Decode(&(pObj->m_mode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245V75Parameters_Decode(&(pObj->m_v75Parameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245V76LogicalChannelParameters Print */
HS_RESULT ASNH245V76LogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245V76LogicalChannelParameters *pObj = (ASNH245V76LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245V76LogicalChannelParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245V76HDLCParameters_Print( &(pObj->m_hdlcParameters), pDepth+1, "hdlcParameters" );
	ASNH245V76LogicalChannelParameters_suspendResume_Print( &(pObj->m_suspendResume), pDepth+1, "suspendResume" );
	AsnBoolean_Print( &(pObj->m_uIH), pDepth+1, "uIH" );
	ASNH245V76LogicalChannelParameters_mode_Print( &(pObj->m_mode), pDepth+1, "mode" );
	ASNH245V75Parameters_Print( &(pObj->m_v75Parameters), pDepth+1, "v75Parameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UnicastAddress_iPAddress Class
*/
/*ASNH245UnicastAddress_iPAddress Constructor*/
HS_RESULT new_ASNH245UnicastAddress_iPAddress(void *pObject)
{
	ASNH245UnicastAddress_iPAddress *pObj = (ASNH245UnicastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UnicastAddress_iPAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_network), e_constrained, 4, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_tsapIdentifier), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245UnicastAddress_iPAddress Destructor */
HS_RESULT delete_ASNH245UnicastAddress_iPAddress(void *pObject)
{
	ASNH245UnicastAddress_iPAddress *pObj = (ASNH245UnicastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UnicastAddress_iPAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_network) );
	delete_AsnInteger( &(pObj->m_tsapIdentifier) );
	return HS_OK;
}

/* ASNH245UnicastAddress_iPAddress MakeMold */
HS_RESULT ASNH245UnicastAddress_iPAddress_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245UnicastAddress_iPAddress *pObj = (ASNH245UnicastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPAddress_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245UnicastAddress_iPAddress Encode */
HS_RESULT ASNH245UnicastAddress_iPAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UnicastAddress_iPAddress *pObj = (ASNH245UnicastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245UnicastAddress_iPAddress Decode */
HS_RESULT ASNH245UnicastAddress_iPAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UnicastAddress_iPAddress *pObj = (ASNH245UnicastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UnicastAddress_iPAddress Print */
HS_RESULT ASNH245UnicastAddress_iPAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UnicastAddress_iPAddress *pObj = (ASNH245UnicastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UnicastAddress_iPAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_network), pDepth+1, "network" );
	AsnInteger_Print( &(pObj->m_tsapIdentifier), pDepth+1, "tsapIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UnicastAddress_iPXAddress Class
*/
/*ASNH245UnicastAddress_iPXAddress Constructor*/
HS_RESULT new_ASNH245UnicastAddress_iPXAddress(void *pObject)
{
	ASNH245UnicastAddress_iPXAddress *pObj = (ASNH245UnicastAddress_iPXAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UnicastAddress_iPXAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_node), e_constrained, 6, 6, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_netnum), e_constrained, 4, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_tsapIdentifier), e_constrained, 2, 2, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245UnicastAddress_iPXAddress Destructor */
HS_RESULT delete_ASNH245UnicastAddress_iPXAddress(void *pObject)
{
	ASNH245UnicastAddress_iPXAddress *pObj = (ASNH245UnicastAddress_iPXAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UnicastAddress_iPXAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_node) );
	delete_AsnOctetString( &(pObj->m_netnum) );
	delete_AsnOctetString( &(pObj->m_tsapIdentifier) );
	return HS_OK;
}

/* ASNH245UnicastAddress_iPXAddress MakeMold */
HS_RESULT ASNH245UnicastAddress_iPXAddress_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245UnicastAddress_iPXAddress *pObj = (ASNH245UnicastAddress_iPXAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245UnicastAddress_iPXAddress Encode */
HS_RESULT ASNH245UnicastAddress_iPXAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UnicastAddress_iPXAddress *pObj = (ASNH245UnicastAddress_iPXAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_node),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_netnum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245UnicastAddress_iPXAddress Decode */
HS_RESULT ASNH245UnicastAddress_iPXAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UnicastAddress_iPXAddress *pObj = (ASNH245UnicastAddress_iPXAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_node),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_netnum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UnicastAddress_iPXAddress Print */
HS_RESULT ASNH245UnicastAddress_iPXAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UnicastAddress_iPXAddress *pObj = (ASNH245UnicastAddress_iPXAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UnicastAddress_iPXAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_node), pDepth+1, "node" );
	AsnOctetString_Print( &(pObj->m_netnum), pDepth+1, "netnum" );
	AsnOctetString_Print( &(pObj->m_tsapIdentifier), pDepth+1, "tsapIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UnicastAddress_iP6Address Class
*/
/*ASNH245UnicastAddress_iP6Address Constructor*/
HS_RESULT new_ASNH245UnicastAddress_iP6Address(void *pObject)
{
	ASNH245UnicastAddress_iP6Address *pObj = (ASNH245UnicastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UnicastAddress_iP6Address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_network), e_constrained, 16, 16, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_tsapIdentifier), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245UnicastAddress_iP6Address Destructor */
HS_RESULT delete_ASNH245UnicastAddress_iP6Address(void *pObject)
{
	ASNH245UnicastAddress_iP6Address *pObj = (ASNH245UnicastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UnicastAddress_iP6Address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_network) );
	delete_AsnInteger( &(pObj->m_tsapIdentifier) );
	return HS_OK;
}

/* ASNH245UnicastAddress_iP6Address MakeMold */
HS_RESULT ASNH245UnicastAddress_iP6Address_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245UnicastAddress_iP6Address *pObj = (ASNH245UnicastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iP6Address_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245UnicastAddress_iP6Address Encode */
HS_RESULT ASNH245UnicastAddress_iP6Address_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UnicastAddress_iP6Address *pObj = (ASNH245UnicastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iP6Address_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iP6Address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iP6Address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245UnicastAddress_iP6Address Decode */
HS_RESULT ASNH245UnicastAddress_iP6Address_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UnicastAddress_iP6Address *pObj = (ASNH245UnicastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iP6Address_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iP6Address_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iP6Address_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UnicastAddress_iP6Address Print */
HS_RESULT ASNH245UnicastAddress_iP6Address_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UnicastAddress_iP6Address *pObj = (ASNH245UnicastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UnicastAddress_iP6Address_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_network), pDepth+1, "network" );
	AsnInteger_Print( &(pObj->m_tsapIdentifier), pDepth+1, "tsapIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UnicastAddress_iPSourceRouteAddress_routing Struct
*/
/* ASNH245UnicastAddress_iPSourceRouteAddress_routing Constructor */
HS_RESULT new_ASNH245UnicastAddress_iPSourceRouteAddress_routing( void *pObject )
{
	ASNH245UnicastAddress_iPSourceRouteAddress_routing *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress_routing *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UnicastAddress_iPSourceRouteAddress_routing(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_strict;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245UnicastAddress_iPSourceRouteAddress_routing Destructor */
HS_RESULT delete_ASNH245UnicastAddress_iPSourceRouteAddress_routing( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245UnicastAddress_iPSourceRouteAddress_routing *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress_routing *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UnicastAddress_iPSourceRouteAddress_routing(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245UnicastAddress_iPSourceRouteAddress_routing_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UnicastAddress_iPSourceRouteAddress_routing(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245UnicastAddress_iPSourceRouteAddress_routing SetChoice */
void* ASNH245UnicastAddress_iPSourceRouteAddress_routing_SetChoice( void *pObject, ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245UnicastAddress_iPSourceRouteAddress_routing *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress_routing *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSizeExt ){
		if( pChoice > (ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice)(e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245UnicastAddress_iPSourceRouteAddress_routing_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_strict ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_loose ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245UnicastAddress_iPSourceRouteAddress_routing DeleteAlternation */
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_DeleteAlternation(void *pObject)
{
	ASNH245UnicastAddress_iPSourceRouteAddress_routing *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress_routing *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_strict ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_loose ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245UnicastAddress_iPSourceRouteAddress_routing Encode */
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245UnicastAddress_iPSourceRouteAddress_routing *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress_routing *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSize )
		{
			if( pObj->choice > ((ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice)(e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSize)) )
	}
	else
	{
		if( e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_strict ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_loose ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245UnicastAddress_iPSourceRouteAddress_routing Decode */
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245UnicastAddress_iPSourceRouteAddress_routing *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress_routing *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSize;
	}
	else
	{
		if( e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245UnicastAddress_iPSourceRouteAddress_routing_SetChoice( pObj, (ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_strict ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_loose ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UnicastAddress_iPSourceRouteAddress_routing Print */
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_routing_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UnicastAddress_iPSourceRouteAddress_routing *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress_routing *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_routing_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_strict ){
		AsnNull_Print( pObj->alter, pDepth+1, "strict" );
	}
	else if ( pObj->choice == e_ASNH245UnicastAddress_iPSourceRouteAddress_routingChoice_loose ){
		AsnNull_Print( pObj->alter, pDepth+1, "loose" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UnicastAddress_iPSourceRouteAddress Class
*/
/*ASNH245UnicastAddress_iPSourceRouteAddress Constructor*/
HS_RESULT new_ASNH245UnicastAddress_iPSourceRouteAddress(void *pObject)
{
	ASNH245UnicastAddress_iPSourceRouteAddress *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UnicastAddress_iPSourceRouteAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245UnicastAddress_iPSourceRouteAddress_routing( &(pObj->m_routing) );
	new_AsnOctetString( &(pObj->m_network), e_constrained, 4, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_tsapIdentifier), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_route), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245UnicastAddress_iPSourceRouteAddress Destructor */
HS_RESULT delete_ASNH245UnicastAddress_iPSourceRouteAddress(void *pObject)
{
	ASNH245UnicastAddress_iPSourceRouteAddress *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UnicastAddress_iPSourceRouteAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245UnicastAddress_iPSourceRouteAddress_routing( &(pObj->m_routing) );
	delete_AsnOctetString( &(pObj->m_network) );
	delete_AsnInteger( &(pObj->m_tsapIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_route) );
	return HS_OK;
}

/* ASNH245UnicastAddress_iPSourceRouteAddress MakeMold */
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245UnicastAddress_iPSourceRouteAddress *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	AsnOctetString *tmold_route = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_route,e_constrained,4,4,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_route,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_route), moldObject );
	}
	return HS_OK;
}

/* ASNH245UnicastAddress_iPSourceRouteAddress Encode */
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UnicastAddress_iPSourceRouteAddress *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245UnicastAddress_iPSourceRouteAddress_routing_Encode( &(pObj->m_routing),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_route),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245UnicastAddress_iPSourceRouteAddress Decode */
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UnicastAddress_iPSourceRouteAddress *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245UnicastAddress_iPSourceRouteAddress_routing_Decode(&(pObj->m_routing),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_route),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UnicastAddress_iPSourceRouteAddress Print */
HS_RESULT ASNH245UnicastAddress_iPSourceRouteAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UnicastAddress_iPSourceRouteAddress *pObj = (ASNH245UnicastAddress_iPSourceRouteAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UnicastAddress_iPSourceRouteAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245UnicastAddress_iPSourceRouteAddress_routing_Print( &(pObj->m_routing), pDepth+1, "routing" );
	AsnOctetString_Print( &(pObj->m_network), pDepth+1, "network" );
	AsnInteger_Print( &(pObj->m_tsapIdentifier), pDepth+1, "tsapIdentifier" );
	AsnSequenceOf_Print( &(pObj->m_route), pDepth+1, "route" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UnicastAddress Struct
*/
/* ASNH245UnicastAddress Constructor */
HS_RESULT new_ASNH245UnicastAddress( void *pObject )
{
	ASNH245UnicastAddress *pObj = (ASNH245UnicastAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UnicastAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245UnicastAddressChoice_iPAddress;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245UnicastAddressChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245UnicastAddress Destructor */
HS_RESULT delete_ASNH245UnicastAddress( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245UnicastAddress *pObj = (ASNH245UnicastAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UnicastAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245UnicastAddress_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UnicastAddress(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245UnicastAddress SetChoice */
void* ASNH245UnicastAddress_SetChoice( void *pObject, ASNH245UnicastAddressChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245UnicastAddress *pObj = (ASNH245UnicastAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245UnicastAddressChoiceSizeExt ){
		if( pChoice > (ASNH245UnicastAddressChoice)(e_ASNH245UnicastAddressChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245UnicastAddress_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245UnicastAddressChoice_iPAddress ){
		ASNH245UnicastAddress_iPAddress *tAlter = (ASNH245UnicastAddress_iPAddress *)HSMalloc( sizeof(ASNH245UnicastAddress_iPAddress) );
		new_ASNH245UnicastAddress_iPAddress(tAlter);
		ASNH245UnicastAddress_iPAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UnicastAddressChoice_iPXAddress ){
		ASNH245UnicastAddress_iPXAddress *tAlter = (ASNH245UnicastAddress_iPXAddress *)HSMalloc( sizeof(ASNH245UnicastAddress_iPXAddress) );
		new_ASNH245UnicastAddress_iPXAddress(tAlter);
		ASNH245UnicastAddress_iPXAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UnicastAddressChoice_iP6Address ){
		ASNH245UnicastAddress_iP6Address *tAlter = (ASNH245UnicastAddress_iP6Address *)HSMalloc( sizeof(ASNH245UnicastAddress_iP6Address) );
		new_ASNH245UnicastAddress_iP6Address(tAlter);
		ASNH245UnicastAddress_iP6Address_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UnicastAddressChoice_netBios ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_constrained,16,16,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UnicastAddressChoice_iPSourceRouteAddress ){
		ASNH245UnicastAddress_iPSourceRouteAddress *tAlter = (ASNH245UnicastAddress_iPSourceRouteAddress *)HSMalloc( sizeof(ASNH245UnicastAddress_iPSourceRouteAddress) );
		new_ASNH245UnicastAddress_iPSourceRouteAddress(tAlter);
		ASNH245UnicastAddress_iPSourceRouteAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245UnicastAddressChoice_nsap ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_constrained,1,20,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UnicastAddressChoice_nonStandardAddress ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245UnicastAddress DeleteAlternation */
HS_RESULT ASNH245UnicastAddress_DeleteAlternation(void *pObject)
{
	ASNH245UnicastAddress *pObj = (ASNH245UnicastAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245UnicastAddressChoice_iPAddress ){
			delete_ASNH245UnicastAddress_iPAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iPXAddress ){
			delete_ASNH245UnicastAddress_iPXAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iP6Address ){
			delete_ASNH245UnicastAddress_iP6Address(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UnicastAddressChoice_netBios ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iPSourceRouteAddress ){
			delete_ASNH245UnicastAddress_iPSourceRouteAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245UnicastAddressChoice_nsap ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UnicastAddressChoice_nonStandardAddress ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245UnicastAddress_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245UnicastAddress Encode */
HS_RESULT ASNH245UnicastAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245UnicastAddress *pObj = (ASNH245UnicastAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245UnicastAddressChoiceSize )
		{
			if( pObj->choice > ((ASNH245UnicastAddressChoice)(e_ASNH245UnicastAddressChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245UnicastAddressChoiceSize)) )
	}
	else
	{
		if( e_ASNH245UnicastAddressChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UnicastAddressChoice_iPAddress ){
		if( (tRet=ASNH245UnicastAddress_iPAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iPXAddress ){
		if( (tRet=ASNH245UnicastAddress_iPXAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iP6Address ){
		if( (tRet=ASNH245UnicastAddress_iP6Address_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_netBios ){
		if( (tRet=AsnOctetString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iPSourceRouteAddress ){
		if( (tRet=ASNH245UnicastAddress_iPSourceRouteAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_nsap ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnOctetString_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_nonStandardAddress ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245NonStandardParameter_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245UnicastAddress Decode */
HS_RESULT ASNH245UnicastAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245UnicastAddress *pObj = (ASNH245UnicastAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245UnicastAddressChoiceSize;
	}
	else
	{
		if( e_ASNH245UnicastAddressChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245UnicastAddressChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245UnicastAddressChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245UnicastAddress_SetChoice( pObj, (ASNH245UnicastAddressChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UnicastAddressChoice_iPAddress ){
		if( (tRet=ASNH245UnicastAddress_iPAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iPXAddress ){
		if( (tRet=ASNH245UnicastAddress_iPXAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iP6Address ){
		if( (tRet=ASNH245UnicastAddress_iP6Address_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_netBios ){
		if( (tRet=AsnOctetString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iPSourceRouteAddress ){
		if( (tRet=ASNH245UnicastAddress_iPSourceRouteAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_nsap ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnOctetString_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_nonStandardAddress ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245NonStandardParameter_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UnicastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UnicastAddress_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UnicastAddress Print */
HS_RESULT ASNH245UnicastAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UnicastAddress *pObj = (ASNH245UnicastAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UnicastAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UnicastAddressChoice_iPAddress ){
		ASNH245UnicastAddress_iPAddress_Print( pObj->alter, pDepth+1, "iPAddress" );
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iPXAddress ){
		ASNH245UnicastAddress_iPXAddress_Print( pObj->alter, pDepth+1, "iPXAddress" );
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iP6Address ){
		ASNH245UnicastAddress_iP6Address_Print( pObj->alter, pDepth+1, "iP6Address" );
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_netBios ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "netBios" );
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_iPSourceRouteAddress ){
		ASNH245UnicastAddress_iPSourceRouteAddress_Print( pObj->alter, pDepth+1, "iPSourceRouteAddress" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_nsap ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "nsap" );
	}
	else if ( pObj->choice == e_ASNH245UnicastAddressChoice_nonStandardAddress ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandardAddress" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MulticastAddress_iPAddress Class
*/
/*ASNH245MulticastAddress_iPAddress Constructor*/
HS_RESULT new_ASNH245MulticastAddress_iPAddress(void *pObject)
{
	ASNH245MulticastAddress_iPAddress *pObj = (ASNH245MulticastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MulticastAddress_iPAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_network), e_constrained, 4, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_tsapIdentifier), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MulticastAddress_iPAddress Destructor */
HS_RESULT delete_ASNH245MulticastAddress_iPAddress(void *pObject)
{
	ASNH245MulticastAddress_iPAddress *pObj = (ASNH245MulticastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MulticastAddress_iPAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_network) );
	delete_AsnInteger( &(pObj->m_tsapIdentifier) );
	return HS_OK;
}

/* ASNH245MulticastAddress_iPAddress MakeMold */
HS_RESULT ASNH245MulticastAddress_iPAddress_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MulticastAddress_iPAddress *pObj = (ASNH245MulticastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iPAddress_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MulticastAddress_iPAddress Encode */
HS_RESULT ASNH245MulticastAddress_iPAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MulticastAddress_iPAddress *pObj = (ASNH245MulticastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iPAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iPAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iPAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MulticastAddress_iPAddress Decode */
HS_RESULT ASNH245MulticastAddress_iPAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MulticastAddress_iPAddress *pObj = (ASNH245MulticastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iPAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iPAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iPAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MulticastAddress_iPAddress Print */
HS_RESULT ASNH245MulticastAddress_iPAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MulticastAddress_iPAddress *pObj = (ASNH245MulticastAddress_iPAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MulticastAddress_iPAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_network), pDepth+1, "network" );
	AsnInteger_Print( &(pObj->m_tsapIdentifier), pDepth+1, "tsapIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MulticastAddress_iP6Address Class
*/
/*ASNH245MulticastAddress_iP6Address Constructor*/
HS_RESULT new_ASNH245MulticastAddress_iP6Address(void *pObject)
{
	ASNH245MulticastAddress_iP6Address *pObj = (ASNH245MulticastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MulticastAddress_iP6Address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_network), e_constrained, 16, 16, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_tsapIdentifier), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MulticastAddress_iP6Address Destructor */
HS_RESULT delete_ASNH245MulticastAddress_iP6Address(void *pObject)
{
	ASNH245MulticastAddress_iP6Address *pObj = (ASNH245MulticastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MulticastAddress_iP6Address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_network) );
	delete_AsnInteger( &(pObj->m_tsapIdentifier) );
	return HS_OK;
}

/* ASNH245MulticastAddress_iP6Address MakeMold */
HS_RESULT ASNH245MulticastAddress_iP6Address_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MulticastAddress_iP6Address *pObj = (ASNH245MulticastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iP6Address_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MulticastAddress_iP6Address Encode */
HS_RESULT ASNH245MulticastAddress_iP6Address_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MulticastAddress_iP6Address *pObj = (ASNH245MulticastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iP6Address_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iP6Address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iP6Address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MulticastAddress_iP6Address Decode */
HS_RESULT ASNH245MulticastAddress_iP6Address_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MulticastAddress_iP6Address *pObj = (ASNH245MulticastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iP6Address_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_network),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iP6Address_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_tsapIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_iP6Address_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MulticastAddress_iP6Address Print */
HS_RESULT ASNH245MulticastAddress_iP6Address_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MulticastAddress_iP6Address *pObj = (ASNH245MulticastAddress_iP6Address *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MulticastAddress_iP6Address_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_network), pDepth+1, "network" );
	AsnInteger_Print( &(pObj->m_tsapIdentifier), pDepth+1, "tsapIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MulticastAddress Struct
*/
/* ASNH245MulticastAddress Constructor */
HS_RESULT new_ASNH245MulticastAddress( void *pObject )
{
	ASNH245MulticastAddress *pObj = (ASNH245MulticastAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MulticastAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MulticastAddressChoice_iPAddress;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MulticastAddressChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MulticastAddress Destructor */
HS_RESULT delete_ASNH245MulticastAddress( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MulticastAddress *pObj = (ASNH245MulticastAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MulticastAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MulticastAddress_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MulticastAddress(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MulticastAddress SetChoice */
void* ASNH245MulticastAddress_SetChoice( void *pObject, ASNH245MulticastAddressChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MulticastAddress *pObj = (ASNH245MulticastAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MulticastAddressChoiceSizeExt ){
		if( pChoice > (ASNH245MulticastAddressChoice)(e_ASNH245MulticastAddressChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MulticastAddress_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MulticastAddressChoice_iPAddress ){
		ASNH245MulticastAddress_iPAddress *tAlter = (ASNH245MulticastAddress_iPAddress *)HSMalloc( sizeof(ASNH245MulticastAddress_iPAddress) );
		new_ASNH245MulticastAddress_iPAddress(tAlter);
		ASNH245MulticastAddress_iPAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MulticastAddressChoice_iP6Address ){
		ASNH245MulticastAddress_iP6Address *tAlter = (ASNH245MulticastAddress_iP6Address *)HSMalloc( sizeof(ASNH245MulticastAddress_iP6Address) );
		new_ASNH245MulticastAddress_iP6Address(tAlter);
		ASNH245MulticastAddress_iP6Address_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245MulticastAddressChoice_nsap ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_constrained,1,20,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MulticastAddressChoice_nonStandardAddress ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MulticastAddress DeleteAlternation */
HS_RESULT ASNH245MulticastAddress_DeleteAlternation(void *pObject)
{
	ASNH245MulticastAddress *pObj = (ASNH245MulticastAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MulticastAddressChoice_iPAddress ){
			delete_ASNH245MulticastAddress_iPAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MulticastAddressChoice_iP6Address ){
			delete_ASNH245MulticastAddress_iP6Address(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245MulticastAddressChoice_nsap ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MulticastAddressChoice_nonStandardAddress ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MulticastAddress_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MulticastAddress Encode */
HS_RESULT ASNH245MulticastAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MulticastAddress *pObj = (ASNH245MulticastAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MulticastAddressChoiceSize )
		{
			if( pObj->choice > ((ASNH245MulticastAddressChoice)(e_ASNH245MulticastAddressChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MulticastAddressChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MulticastAddressChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MulticastAddressChoice_iPAddress ){
		if( (tRet=ASNH245MulticastAddress_iPAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MulticastAddressChoice_iP6Address ){
		if( (tRet=ASNH245MulticastAddress_iP6Address_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MulticastAddressChoice_nsap ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnOctetString_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MulticastAddressChoice_nonStandardAddress ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245NonStandardParameter_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MulticastAddress Decode */
HS_RESULT ASNH245MulticastAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MulticastAddress *pObj = (ASNH245MulticastAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MulticastAddressChoiceSize;
	}
	else
	{
		if( e_ASNH245MulticastAddressChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MulticastAddressChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MulticastAddressChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MulticastAddress_SetChoice( pObj, (ASNH245MulticastAddressChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MulticastAddressChoice_iPAddress ){
		if( (tRet=ASNH245MulticastAddress_iPAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MulticastAddressChoice_iP6Address ){
		if( (tRet=ASNH245MulticastAddress_iP6Address_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MulticastAddressChoice_nsap ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnOctetString_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MulticastAddressChoice_nonStandardAddress ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245NonStandardParameter_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MulticastAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MulticastAddress_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MulticastAddress Print */
HS_RESULT ASNH245MulticastAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MulticastAddress *pObj = (ASNH245MulticastAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MulticastAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MulticastAddressChoice_iPAddress ){
		ASNH245MulticastAddress_iPAddress_Print( pObj->alter, pDepth+1, "iPAddress" );
	}
	else if ( pObj->choice == e_ASNH245MulticastAddressChoice_iP6Address ){
		ASNH245MulticastAddress_iP6Address_Print( pObj->alter, pDepth+1, "iP6Address" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MulticastAddressChoice_nsap ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "nsap" );
	}
	else if ( pObj->choice == e_ASNH245MulticastAddressChoice_nonStandardAddress ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandardAddress" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TransportAddress Struct
*/
/* ASNH245TransportAddress Constructor */
HS_RESULT new_ASNH245TransportAddress( void *pObject )
{
	ASNH245TransportAddress *pObj = (ASNH245TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TransportAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245TransportAddressChoice_unicastAddress;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245TransportAddressChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245TransportAddress Destructor */
HS_RESULT delete_ASNH245TransportAddress( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245TransportAddress *pObj = (ASNH245TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TransportAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245TransportAddress_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TransportAddress(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245TransportAddress SetChoice */
void* ASNH245TransportAddress_SetChoice( void *pObject, ASNH245TransportAddressChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245TransportAddress *pObj = (ASNH245TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportAddress_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245TransportAddressChoiceSizeExt ){
		if( pChoice > (ASNH245TransportAddressChoice)(e_ASNH245TransportAddressChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportAddress_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245TransportAddress_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportAddress_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245TransportAddressChoice_unicastAddress ){
		ASNH245UnicastAddress *tAlter = (ASNH245UnicastAddress *)HSMalloc( sizeof(ASNH245UnicastAddress) );
		new_ASNH245UnicastAddress(tAlter);
		ASNH245UnicastAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245TransportAddressChoice_multicastAddress ){
		ASNH245MulticastAddress *tAlter = (ASNH245MulticastAddress *)HSMalloc( sizeof(ASNH245MulticastAddress) );
		new_ASNH245MulticastAddress(tAlter);
		ASNH245MulticastAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportAddress_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245TransportAddress DeleteAlternation */
HS_RESULT ASNH245TransportAddress_DeleteAlternation(void *pObject)
{
	ASNH245TransportAddress *pObj = (ASNH245TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportAddress_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245TransportAddressChoice_unicastAddress ){
			delete_ASNH245UnicastAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245TransportAddressChoice_multicastAddress ){
			delete_ASNH245MulticastAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportAddress_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245TransportAddress_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245TransportAddress Encode */
HS_RESULT ASNH245TransportAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245TransportAddress *pObj = (ASNH245TransportAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportAddress_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245TransportAddressChoiceSize )
		{
			if( pObj->choice > ((ASNH245TransportAddressChoice)(e_ASNH245TransportAddressChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245TransportAddressChoiceSize)) )
	}
	else
	{
		if( e_ASNH245TransportAddressChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245TransportAddressChoice_unicastAddress ){
		if( (tRet=ASNH245UnicastAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TransportAddressChoice_multicastAddress ){
		if( (tRet=ASNH245MulticastAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportAddress_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245TransportAddress Decode */
HS_RESULT ASNH245TransportAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245TransportAddress *pObj = (ASNH245TransportAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245TransportAddressChoiceSize;
	}
	else
	{
		if( e_ASNH245TransportAddressChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245TransportAddressChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245TransportAddressChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportAddress_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245TransportAddress_SetChoice( pObj, (ASNH245TransportAddressChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportAddress_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245TransportAddressChoice_unicastAddress ){
		if( (tRet=ASNH245UnicastAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TransportAddressChoice_multicastAddress ){
		if( (tRet=ASNH245MulticastAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TransportAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TransportAddress_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TransportAddress Print */
HS_RESULT ASNH245TransportAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TransportAddress *pObj = (ASNH245TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TransportAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245TransportAddressChoice_unicastAddress ){
		ASNH245UnicastAddress_Print( pObj->alter, pDepth+1, "unicastAddress" );
	}
	else if ( pObj->choice == e_ASNH245TransportAddressChoice_multicastAddress ){
		ASNH245MulticastAddress_Print( pObj->alter, pDepth+1, "multicastAddress" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TerminalLabel Class
*/
/*ASNH245TerminalLabel Constructor*/
HS_RESULT new_ASNH245TerminalLabel(void *pObject)
{
	ASNH245TerminalLabel *pObj = (ASNH245TerminalLabel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TerminalLabel(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245McuNumber( &(pObj->m_mcuNumber) );
	new_ASNH245TerminalNumber( &(pObj->m_terminalNumber) );

	return HS_OK;
}

/* ASNH245TerminalLabel Destructor */
HS_RESULT delete_ASNH245TerminalLabel(void *pObject)
{
	ASNH245TerminalLabel *pObj = (ASNH245TerminalLabel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TerminalLabel(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245McuNumber( &(pObj->m_mcuNumber) );
	delete_ASNH245TerminalNumber( &(pObj->m_terminalNumber) );
	return HS_OK;
}

/* ASNH245TerminalLabel MakeMold */
HS_RESULT ASNH245TerminalLabel_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245TerminalLabel *pObj = (ASNH245TerminalLabel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalLabel_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245McuNumber_MakeMold(&(pObj->m_mcuNumber));
	ASNH245TerminalNumber_MakeMold(&(pObj->m_terminalNumber));
	return HS_OK;
}

/* ASNH245TerminalLabel Encode */
HS_RESULT ASNH245TerminalLabel_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TerminalLabel *pObj = (ASNH245TerminalLabel *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalLabel_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245McuNumber_Encode( &(pObj->m_mcuNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalLabel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245TerminalNumber_Encode( &(pObj->m_terminalNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalLabel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245TerminalLabel Decode */
HS_RESULT ASNH245TerminalLabel_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TerminalLabel *pObj = (ASNH245TerminalLabel *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalLabel_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245McuNumber_Decode(&(pObj->m_mcuNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalLabel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245TerminalNumber_Decode(&(pObj->m_terminalNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalLabel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TerminalLabel Print */
HS_RESULT ASNH245TerminalLabel_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TerminalLabel *pObj = (ASNH245TerminalLabel *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TerminalLabel_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245McuNumber_Print( &(pObj->m_mcuNumber), pDepth+1, "mcuNumber" );
	ASNH245TerminalNumber_Print( &(pObj->m_terminalNumber), pDepth+1, "terminalNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H2250LogicalChannelParameters_mediaPacketization Struct
*/
/* ASNH245H2250LogicalChannelParameters_mediaPacketization Constructor */
HS_RESULT new_ASNH245H2250LogicalChannelParameters_mediaPacketization( void *pObject )
{
	ASNH245H2250LogicalChannelParameters_mediaPacketization *pObj = (ASNH245H2250LogicalChannelParameters_mediaPacketization *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H2250LogicalChannelParameters_mediaPacketization(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_h261aVideoPacketization;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245H2250LogicalChannelParameters_mediaPacketization Destructor */
HS_RESULT delete_ASNH245H2250LogicalChannelParameters_mediaPacketization( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245H2250LogicalChannelParameters_mediaPacketization *pObj = (ASNH245H2250LogicalChannelParameters_mediaPacketization *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H2250LogicalChannelParameters_mediaPacketization(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245H2250LogicalChannelParameters_mediaPacketization_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H2250LogicalChannelParameters_mediaPacketization(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245H2250LogicalChannelParameters_mediaPacketization SetChoice */
void* ASNH245H2250LogicalChannelParameters_mediaPacketization_SetChoice( void *pObject, ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245H2250LogicalChannelParameters_mediaPacketization *pObj = (ASNH245H2250LogicalChannelParameters_mediaPacketization *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSizeExt ){
		if( pChoice > (ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice)(e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245H2250LogicalChannelParameters_mediaPacketization_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_h261aVideoPacketization ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_rtpPayloadType ){
		ASNH245RTPPayloadType *tAlter = (ASNH245RTPPayloadType *)HSMalloc( sizeof(ASNH245RTPPayloadType) );
		new_ASNH245RTPPayloadType(tAlter);
		ASNH245RTPPayloadType_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245H2250LogicalChannelParameters_mediaPacketization DeleteAlternation */
HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_DeleteAlternation(void *pObject)
{
	ASNH245H2250LogicalChannelParameters_mediaPacketization *pObj = (ASNH245H2250LogicalChannelParameters_mediaPacketization *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_h261aVideoPacketization ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_rtpPayloadType ){
			delete_ASNH245RTPPayloadType(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245H2250LogicalChannelParameters_mediaPacketization Encode */
HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245H2250LogicalChannelParameters_mediaPacketization *pObj = (ASNH245H2250LogicalChannelParameters_mediaPacketization *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSize )
		{
			if( pObj->choice > ((ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice)(e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_h261aVideoPacketization ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_rtpPayloadType ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245RTPPayloadType_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245H2250LogicalChannelParameters_mediaPacketization Decode */
HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245H2250LogicalChannelParameters_mediaPacketization *pObj = (ASNH245H2250LogicalChannelParameters_mediaPacketization *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSize;
	}
	else
	{
		if( e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245H2250LogicalChannelParameters_mediaPacketization_SetChoice( pObj, (ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_h261aVideoPacketization ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_rtpPayloadType ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245RTPPayloadType_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H2250LogicalChannelParameters_mediaPacketization Print */
HS_RESULT ASNH245H2250LogicalChannelParameters_mediaPacketization_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H2250LogicalChannelParameters_mediaPacketization *pObj = (ASNH245H2250LogicalChannelParameters_mediaPacketization *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_mediaPacketization_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_h261aVideoPacketization ){
		AsnNull_Print( pObj->alter, pDepth+1, "h261aVideoPacketization" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245H2250LogicalChannelParameters_mediaPacketizationChoice_rtpPayloadType ){
		ASNH245RTPPayloadType_Print( pObj->alter, pDepth+1, "rtpPayloadType" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RedundancyEncoding Class
*/
/*ASNH245RedundancyEncoding Constructor*/
HS_RESULT new_ASNH245RedundancyEncoding(void *pObject)
{
	ASNH245RedundancyEncoding *pObj = (ASNH245RedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RedundancyEncoding(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245RedundancyEncodingMethod( &(pObj->m_redundancyEncodingMethod) );
	new_ASNH245DataType( &(pObj->m_secondaryEncoding) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245RedundancyEncoding Destructor */
HS_RESULT delete_ASNH245RedundancyEncoding(void *pObject)
{
	ASNH245RedundancyEncoding *pObj = (ASNH245RedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RedundancyEncoding(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245RedundancyEncodingMethod( &(pObj->m_redundancyEncodingMethod) );
	delete_ASNH245DataType( &(pObj->m_secondaryEncoding) );
	return HS_OK;
}

/* ASNH245RedundancyEncoding MakeMold */
HS_RESULT ASNH245RedundancyEncoding_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RedundancyEncoding *pObj = (ASNH245RedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncoding_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245RedundancyEncodingMethod_MakeMold(&(pObj->m_redundancyEncodingMethod));
	ASNH245DataType_MakeMold(&(pObj->m_secondaryEncoding));
	return HS_OK;
}

/* ASNH245RedundancyEncoding IncludeOptionalField */
HS_RESULT ASNH245RedundancyEncoding_IncludeOptionField( void *pObject, ASNH245RedundancyEncodingOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245RedundancyEncoding *pObj = (ASNH245RedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncoding_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245RedundancyEncodingOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245RedundancyEncoding IsIncludeOptionalField */
BOOL ASNH245RedundancyEncoding_IsIncludeOptionField( void *pObject, ASNH245RedundancyEncodingOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245RedundancyEncoding *pObj = (ASNH245RedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncoding_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245RedundancyEncodingOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245RedundancyEncoding Encode */
HS_RESULT ASNH245RedundancyEncoding_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RedundancyEncoding *pObj = (ASNH245RedundancyEncoding *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncoding_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245RedundancyEncodingOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245RedundancyEncodingOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245RedundancyEncodingMethod_Encode( &(pObj->m_redundancyEncodingMethod),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncoding_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245RedundancyEncoding_IsIncludeOptionField( pObj, e_ASNH245RedundancyEncodingOptionMap_secondaryEncoding ) ){
		if( (tRet=ASNH245DataType_Encode( &(pObj->m_secondaryEncoding),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncoding_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245RedundancyEncoding Decode */
HS_RESULT ASNH245RedundancyEncoding_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245RedundancyEncoding *pObj = (ASNH245RedundancyEncoding *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncoding_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245RedundancyEncodingOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245RedundancyEncodingOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245RedundancyEncodingMethod_Decode(&(pObj->m_redundancyEncodingMethod),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RedundancyEncoding_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245RedundancyEncoding_IsIncludeOptionField( pObj, e_ASNH245RedundancyEncodingOptionMap_secondaryEncoding ) ){
		if( (tRet=ASNH245DataType_Decode(&(pObj->m_secondaryEncoding),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RedundancyEncoding_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RedundancyEncoding Print */
HS_RESULT ASNH245RedundancyEncoding_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RedundancyEncoding *pObj = (ASNH245RedundancyEncoding *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RedundancyEncoding_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245RedundancyEncodingMethod_Print( &(pObj->m_redundancyEncodingMethod), pDepth+1, "redundancyEncodingMethod" );
	if( ASNH245RedundancyEncoding_IsIncludeOptionField( pObj, e_ASNH245RedundancyEncodingOptionMap_secondaryEncoding ) )
		ASNH245DataType_Print( &(pObj->m_secondaryEncoding), pDepth+1, "secondaryEncoding" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H2250LogicalChannelParameters Class
*/
/*ASNH245H2250LogicalChannelParameters Constructor*/
HS_RESULT new_ASNH245H2250LogicalChannelParameters(void *pObject)
{
	ASNH245H2250LogicalChannelParameters *pObj = (ASNH245H2250LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H2250LogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_nonStandard), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_sessionID), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_associatedSessionID), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245TransportAddress( &(pObj->m_mediaChannel) );
	new_AsnBoolean( &(pObj->m_mediaGuaranteedDelivery) );
	new_ASNH245TransportAddress( &(pObj->m_mediaControlChannel) );
	new_AsnBoolean( &(pObj->m_mediaControlGuaranteedDelivery) );
	new_AsnBoolean( &(pObj->m_silenceSuppression) );
	new_ASNH245TerminalLabel( &(pObj->m_destination) );
	new_AsnInteger( &(pObj->m_dynamicRTPPayloadType), e_constrained, 96, 127, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245H2250LogicalChannelParameters_mediaPacketization( &(pObj->m_mediaPacketization) );
	new_ASNH245TransportCapability( &(pObj->m_transportCapability) );
	new_ASNH245RedundancyEncoding( &(pObj->m_redundancyEncoding) );
	new_ASNH245TerminalLabel( &(pObj->m_source) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H2250LogicalChannelParameters Destructor */
HS_RESULT delete_ASNH245H2250LogicalChannelParameters(void *pObject)
{
	ASNH245H2250LogicalChannelParameters *pObj = (ASNH245H2250LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H2250LogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_nonStandard) );
	delete_AsnInteger( &(pObj->m_sessionID) );
	delete_AsnInteger( &(pObj->m_associatedSessionID) );
	delete_ASNH245TransportAddress( &(pObj->m_mediaChannel) );
	delete_AsnBoolean( &(pObj->m_mediaGuaranteedDelivery) );
	delete_ASNH245TransportAddress( &(pObj->m_mediaControlChannel) );
	delete_AsnBoolean( &(pObj->m_mediaControlGuaranteedDelivery) );
	delete_AsnBoolean( &(pObj->m_silenceSuppression) );
	delete_ASNH245TerminalLabel( &(pObj->m_destination) );
	delete_AsnInteger( &(pObj->m_dynamicRTPPayloadType) );
	delete_ASNH245H2250LogicalChannelParameters_mediaPacketization( &(pObj->m_mediaPacketization) );
	delete_ASNH245TransportCapability( &(pObj->m_transportCapability) );
	delete_ASNH245RedundancyEncoding( &(pObj->m_redundancyEncoding) );
	delete_ASNH245TerminalLabel( &(pObj->m_source) );
	return HS_OK;
}

/* ASNH245H2250LogicalChannelParameters MakeMold */
HS_RESULT ASNH245H2250LogicalChannelParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H2250LogicalChannelParameters *pObj = (ASNH245H2250LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245NonStandardParameter *tmold_nonStandard = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
	new_ASNH245NonStandardParameter(tmold_nonStandard);
	ASNH245NonStandardParameter_MakeMold(tmold_nonStandard);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_nonStandard,sizeof(ASNH245NonStandardParameter),ASNH245NonStandardParameter_MakeMold,ASNH245NonStandardParameter_Encode,ASNH245NonStandardParameter_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245NonStandardParameter_Print,
#endif
		delete_ASNH245NonStandardParameter);
	AsnSequenceOf_SetMold( &(pObj->m_nonStandard), moldObject );
	}
	ASNH245TransportAddress_MakeMold(&(pObj->m_mediaChannel));
	ASNH245TransportAddress_MakeMold(&(pObj->m_mediaControlChannel));
	ASNH245TerminalLabel_MakeMold(&(pObj->m_destination));
	ASNH245TransportCapability_MakeMold(&(pObj->m_transportCapability));
	ASNH245RedundancyEncoding_MakeMold(&(pObj->m_redundancyEncoding));
	ASNH245TerminalLabel_MakeMold(&(pObj->m_source));
	return HS_OK;
}

/* ASNH245H2250LogicalChannelParameters IncludeOptionalField */
HS_RESULT ASNH245H2250LogicalChannelParameters_IncludeOptionField( void *pObject, ASNH245H2250LogicalChannelParametersOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H2250LogicalChannelParameters *pObj = (ASNH245H2250LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H2250LogicalChannelParametersOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H2250LogicalChannelParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H2250LogicalChannelParametersOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245H2250LogicalChannelParameters IsIncludeOptionalField */
BOOL ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( void *pObject, ASNH245H2250LogicalChannelParametersOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H2250LogicalChannelParameters *pObj = (ASNH245H2250LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H2250LogicalChannelParametersOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H2250LogicalChannelParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H2250LogicalChannelParametersOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H2250LogicalChannelParameters Encode */
HS_RESULT ASNH245H2250LogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H2250LogicalChannelParameters *pObj = (ASNH245H2250LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245H2250LogicalChannelParametersOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245H2250LogicalChannelParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_nonStandard ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_nonStandard),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_sessionID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_associatedSessionID ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_associatedSessionID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaChannel ) ){
		if( (tRet=ASNH245TransportAddress_Encode( &(pObj->m_mediaChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaGuaranteedDelivery ) ){
		if( (tRet=AsnBoolean_Encode( &(pObj->m_mediaGuaranteedDelivery),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlChannel ) ){
		if( (tRet=ASNH245TransportAddress_Encode( &(pObj->m_mediaControlChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlGuaranteedDelivery ) ){
		if( (tRet=AsnBoolean_Encode( &(pObj->m_mediaControlGuaranteedDelivery),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_silenceSuppression ) ){
		if( (tRet=AsnBoolean_Encode( &(pObj->m_silenceSuppression),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_destination ) ){
		if( (tRet=ASNH245TerminalLabel_Encode( &(pObj->m_destination),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_dynamicRTPPayloadType ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_dynamicRTPPayloadType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaPacketization ) ){
		if( (tRet=ASNH245H2250LogicalChannelParameters_mediaPacketization_Encode( &(pObj->m_mediaPacketization),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_transportCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_transportCapability), ASNH245TransportCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_redundancyEncoding ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_redundancyEncoding), ASNH245RedundancyEncoding_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_source ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_source), ASNH245TerminalLabel_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H2250LogicalChannelParameters Decode */
HS_RESULT ASNH245H2250LogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H2250LogicalChannelParameters *pObj = (ASNH245H2250LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245H2250LogicalChannelParametersOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245H2250LogicalChannelParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_nonStandard ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_nonStandard),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_sessionID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_associatedSessionID ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_associatedSessionID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaChannel ) ){
		if( (tRet=ASNH245TransportAddress_Decode(&(pObj->m_mediaChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaGuaranteedDelivery ) ){
		if( (tRet=AsnBoolean_Decode(&(pObj->m_mediaGuaranteedDelivery),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlChannel ) ){
		if( (tRet=ASNH245TransportAddress_Decode(&(pObj->m_mediaControlChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlGuaranteedDelivery ) ){
		if( (tRet=AsnBoolean_Decode(&(pObj->m_mediaControlGuaranteedDelivery),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_silenceSuppression ) ){
		if( (tRet=AsnBoolean_Decode(&(pObj->m_silenceSuppression),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_destination ) ){
		if( (tRet=ASNH245TerminalLabel_Decode(&(pObj->m_destination),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_dynamicRTPPayloadType ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_dynamicRTPPayloadType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaPacketization ) ){
		if( (tRet=ASNH245H2250LogicalChannelParameters_mediaPacketization_Decode(&(pObj->m_mediaPacketization),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_transportCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_transportCapability), ASNH245TransportCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_redundancyEncoding ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_redundancyEncoding), ASNH245RedundancyEncoding_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_source ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_source), ASNH245TerminalLabel_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H2250LogicalChannelParameters Print */
HS_RESULT ASNH245H2250LogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H2250LogicalChannelParameters *pObj = (ASNH245H2250LogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H2250LogicalChannelParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_nonStandard ) )
		AsnSequenceOf_Print( &(pObj->m_nonStandard), pDepth+1, "nonStandard" );
	AsnInteger_Print( &(pObj->m_sessionID), pDepth+1, "sessionID" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_associatedSessionID ) )
		AsnInteger_Print( &(pObj->m_associatedSessionID), pDepth+1, "associatedSessionID" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaChannel ) )
		ASNH245TransportAddress_Print( &(pObj->m_mediaChannel), pDepth+1, "mediaChannel" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaGuaranteedDelivery ) )
		AsnBoolean_Print( &(pObj->m_mediaGuaranteedDelivery), pDepth+1, "mediaGuaranteedDelivery" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlChannel ) )
		ASNH245TransportAddress_Print( &(pObj->m_mediaControlChannel), pDepth+1, "mediaControlChannel" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlGuaranteedDelivery ) )
		AsnBoolean_Print( &(pObj->m_mediaControlGuaranteedDelivery), pDepth+1, "mediaControlGuaranteedDelivery" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_silenceSuppression ) )
		AsnBoolean_Print( &(pObj->m_silenceSuppression), pDepth+1, "silenceSuppression" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_destination ) )
		ASNH245TerminalLabel_Print( &(pObj->m_destination), pDepth+1, "destination" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_dynamicRTPPayloadType ) )
		AsnInteger_Print( &(pObj->m_dynamicRTPPayloadType), pDepth+1, "dynamicRTPPayloadType" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaPacketization ) )
		ASNH245H2250LogicalChannelParameters_mediaPacketization_Print( &(pObj->m_mediaPacketization), pDepth+1, "mediaPacketization" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_transportCapability ) )
		ASNH245TransportCapability_Print( &(pObj->m_transportCapability), pDepth+1, "transportCapability" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_redundancyEncoding ) )
		ASNH245RedundancyEncoding_Print( &(pObj->m_redundancyEncoding), pDepth+1, "redundancyEncoding" );
	if( ASNH245H2250LogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelParametersOptionMap_source ) )
		ASNH245TerminalLabel_Print( &(pObj->m_source), pDepth+1, "source" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters Struct
*/
/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters Constructor */
HS_RESULT new_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters( void *pObject )
{
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters SetChoice */
void* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice( void *pObject, ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSizeExt ){
		if( pChoice > (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice)(e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
		ASNH245H222LogicalChannelParameters *tAlter = (ASNH245H222LogicalChannelParameters *)HSMalloc( sizeof(ASNH245H222LogicalChannelParameters) );
		new_ASNH245H222LogicalChannelParameters(tAlter);
		ASNH245H222LogicalChannelParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
		ASNH245H223LogicalChannelParameters *tAlter = (ASNH245H223LogicalChannelParameters *)HSMalloc( sizeof(ASNH245H223LogicalChannelParameters) );
		new_ASNH245H223LogicalChannelParameters(tAlter);
		ASNH245H223LogicalChannelParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
		ASNH245V76LogicalChannelParameters *tAlter = (ASNH245V76LogicalChannelParameters *)HSMalloc( sizeof(ASNH245V76LogicalChannelParameters) );
		new_ASNH245V76LogicalChannelParameters(tAlter);
		ASNH245V76LogicalChannelParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		ASNH245H2250LogicalChannelParameters *tAlter = (ASNH245H2250LogicalChannelParameters *)HSMalloc( sizeof(ASNH245H2250LogicalChannelParameters) );
		new_ASNH245H2250LogicalChannelParameters(tAlter);
		ASNH245H2250LogicalChannelParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_none ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters DeleteAlternation */
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_DeleteAlternation(void *pObject)
{
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
			delete_ASNH245H222LogicalChannelParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
			delete_ASNH245H223LogicalChannelParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
			delete_ASNH245V76LogicalChannelParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
			delete_ASNH245H2250LogicalChannelParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_none ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters Encode */
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSize )
		{
			if( pObj->choice > ((ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice)(e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSize)) )
	}
	else
	{
		if( e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
		if( (tRet=ASNH245H222LogicalChannelParameters_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
		if( (tRet=ASNH245H223LogicalChannelParameters_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
		if( (tRet=ASNH245V76LogicalChannelParameters_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245H2250LogicalChannelParameters_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_none ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters Decode */
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSize;
	}
	else
	{
		if( e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice( pObj, (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
		if( (tRet=ASNH245H222LogicalChannelParameters_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
		if( (tRet=ASNH245H223LogicalChannelParameters_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
		if( (tRet=ASNH245V76LogicalChannelParameters_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245H2250LogicalChannelParameters_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_none ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters Print */
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
		ASNH245H222LogicalChannelParameters_Print( pObj->alter, pDepth+1, "h222LogicalChannelParameters" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
		ASNH245H223LogicalChannelParameters_Print( pObj->alter, pDepth+1, "h223LogicalChannelParameters" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
		ASNH245V76LogicalChannelParameters_Print( pObj->alter, pDepth+1, "v76LogicalChannelParameters" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		ASNH245H2250LogicalChannelParameters_Print( pObj->alter, pDepth+1, "h2250LogicalChannelParameters" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_none ){
		AsnNull_Print( pObj->alter, pDepth+1, "none" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters Class
*/
/*ASNH245OpenLogicalChannel_forwardLogicalChannelParameters Constructor*/
HS_RESULT new_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters(void *pObject)
{
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_portNumber), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245DataType( &(pObj->m_dataType) );
	new_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters( &(pObj->m_multiplexParameters) );
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelDependency) );
	new_ASNH245LogicalChannelNumber( &(pObj->m_replacementFor) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters(void *pObject)
{
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_portNumber) );
	delete_ASNH245DataType( &(pObj->m_dataType) );
	delete_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters( &(pObj->m_multiplexParameters) );
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelDependency) );
	delete_ASNH245LogicalChannelNumber( &(pObj->m_replacementFor) );
	return HS_OK;
}

/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters MakeMold */
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245DataType_MakeMold(&(pObj->m_dataType));
	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelDependency));
	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_replacementFor));
	return HS_OK;
}

/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters IncludeOptionalField */
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters IsIncludeOptionalField */
BOOL ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters Encode */
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_portNumber ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_portNumber),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH245DataType_Encode( &(pObj->m_dataType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Encode( &(pObj->m_multiplexParameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_forwardLogicalChannelDependency ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_forwardLogicalChannelDependency), ASNH245LogicalChannelNumber_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_replacementFor ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_replacementFor), ASNH245LogicalChannelNumber_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters Decode */
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_portNumber ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_portNumber),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH245DataType_Decode(&(pObj->m_dataType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Decode(&(pObj->m_multiplexParameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_forwardLogicalChannelDependency ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_forwardLogicalChannelDependency), ASNH245LogicalChannelNumber_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_replacementFor ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_replacementFor), ASNH245LogicalChannelNumber_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannel_forwardLogicalChannelParameters Print */
HS_RESULT ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_forwardLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_portNumber ) )
		AsnInteger_Print( &(pObj->m_portNumber), pDepth+1, "portNumber" );
	ASNH245DataType_Print( &(pObj->m_dataType), pDepth+1, "dataType" );
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_Print( &(pObj->m_multiplexParameters), pDepth+1, "multiplexParameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_forwardLogicalChannelDependency ) )
		ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelDependency), pDepth+1, "forwardLogicalChannelDependency" );
	if( ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_forwardLogicalChannelParametersOptionMap_replacementFor ) )
		ASNH245LogicalChannelNumber_Print( &(pObj->m_replacementFor), pDepth+1, "replacementFor" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters Struct
*/
/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters Constructor */
HS_RESULT new_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters( void *pObject )
{
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters SetChoice */
void* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_SetChoice( void *pObject, ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt ){
		if( pChoice > (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice)(e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
		ASNH245H223LogicalChannelParameters *tAlter = (ASNH245H223LogicalChannelParameters *)HSMalloc( sizeof(ASNH245H223LogicalChannelParameters) );
		new_ASNH245H223LogicalChannelParameters(tAlter);
		ASNH245H223LogicalChannelParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
		ASNH245V76LogicalChannelParameters *tAlter = (ASNH245V76LogicalChannelParameters *)HSMalloc( sizeof(ASNH245V76LogicalChannelParameters) );
		new_ASNH245V76LogicalChannelParameters(tAlter);
		ASNH245V76LogicalChannelParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		ASNH245H2250LogicalChannelParameters *tAlter = (ASNH245H2250LogicalChannelParameters *)HSMalloc( sizeof(ASNH245H2250LogicalChannelParameters) );
		new_ASNH245H2250LogicalChannelParameters(tAlter);
		ASNH245H2250LogicalChannelParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters DeleteAlternation */
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation(void *pObject)
{
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
			delete_ASNH245H223LogicalChannelParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
			delete_ASNH245V76LogicalChannelParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
			delete_ASNH245H2250LogicalChannelParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters Encode */
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSize )
		{
			if( pObj->choice > ((ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice)(e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSize)) )
	}
	else
	{
		if( e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
		if( (tRet=ASNH245H223LogicalChannelParameters_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
		if( (tRet=ASNH245V76LogicalChannelParameters_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245H2250LogicalChannelParameters_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters Decode */
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSize;
	}
	else
	{
		if( e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_SetChoice( pObj, (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
		if( (tRet=ASNH245H223LogicalChannelParameters_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
		if( (tRet=ASNH245V76LogicalChannelParameters_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245H2250LogicalChannelParameters_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters Print */
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h223LogicalChannelParameters ){
		ASNH245H223LogicalChannelParameters_Print( pObj->alter, pDepth+1, "h223LogicalChannelParameters" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_v76LogicalChannelParameters ){
		ASNH245V76LogicalChannelParameters_Print( pObj->alter, pDepth+1, "v76LogicalChannelParameters" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		ASNH245H2250LogicalChannelParameters_Print( pObj->alter, pDepth+1, "h2250LogicalChannelParameters" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters Class
*/
/*ASNH245OpenLogicalChannel_reverseLogicalChannelParameters Constructor*/
HS_RESULT new_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters(void *pObject)
{
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245DataType( &(pObj->m_dataType) );
	new_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters( &(pObj->m_multiplexParameters) );
	new_ASNH245LogicalChannelNumber( &(pObj->m_reverseLogicalChannelDependency) );
	new_ASNH245LogicalChannelNumber( &(pObj->m_replacementFor) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters(void *pObject)
{
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245DataType( &(pObj->m_dataType) );
	delete_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters( &(pObj->m_multiplexParameters) );
	delete_ASNH245LogicalChannelNumber( &(pObj->m_reverseLogicalChannelDependency) );
	delete_ASNH245LogicalChannelNumber( &(pObj->m_replacementFor) );
	return HS_OK;
}

/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters MakeMold */
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245DataType_MakeMold(&(pObj->m_dataType));
	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_reverseLogicalChannelDependency));
	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_replacementFor));
	return HS_OK;
}

/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters IncludeOptionalField */
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters IsIncludeOptionalField */
BOOL ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters Encode */
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245DataType_Encode( &(pObj->m_dataType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_multiplexParameters ) ){
		if( (tRet=ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Encode( &(pObj->m_multiplexParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_reverseLogicalChannelDependency ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_reverseLogicalChannelDependency), ASNH245LogicalChannelNumber_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_replacementFor ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_replacementFor), ASNH245LogicalChannelNumber_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters Decode */
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245DataType_Decode(&(pObj->m_dataType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_multiplexParameters ) ){
		if( (tRet=ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Decode(&(pObj->m_multiplexParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_reverseLogicalChannelDependency ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_reverseLogicalChannelDependency), ASNH245LogicalChannelNumber_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_replacementFor ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_replacementFor), ASNH245LogicalChannelNumber_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannel_reverseLogicalChannelParameters Print */
HS_RESULT ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannel_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245DataType_Print( &(pObj->m_dataType), pDepth+1, "dataType" );
	if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_multiplexParameters ) )
		ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_Print( &(pObj->m_multiplexParameters), pDepth+1, "multiplexParameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_reverseLogicalChannelDependency ) )
		ASNH245LogicalChannelNumber_Print( &(pObj->m_reverseLogicalChannelDependency), pDepth+1, "reverseLogicalChannelDependency" );
	if( ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_replacementFor ) )
		ASNH245LogicalChannelNumber_Print( &(pObj->m_replacementFor), pDepth+1, "replacementFor" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NetworkAccessParameters_distribution Struct
*/
/* ASNH245NetworkAccessParameters_distribution Constructor */
HS_RESULT new_ASNH245NetworkAccessParameters_distribution( void *pObject )
{
	ASNH245NetworkAccessParameters_distribution *pObj = (ASNH245NetworkAccessParameters_distribution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NetworkAccessParameters_distribution(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NetworkAccessParameters_distributionChoice_unicast;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NetworkAccessParameters_distributionChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NetworkAccessParameters_distribution Destructor */
HS_RESULT delete_ASNH245NetworkAccessParameters_distribution( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NetworkAccessParameters_distribution *pObj = (ASNH245NetworkAccessParameters_distribution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NetworkAccessParameters_distribution(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NetworkAccessParameters_distribution_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NetworkAccessParameters_distribution(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NetworkAccessParameters_distribution SetChoice */
void* ASNH245NetworkAccessParameters_distribution_SetChoice( void *pObject, ASNH245NetworkAccessParameters_distributionChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NetworkAccessParameters_distribution *pObj = (ASNH245NetworkAccessParameters_distribution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NetworkAccessParameters_distributionChoiceSizeExt ){
		if( pChoice > (ASNH245NetworkAccessParameters_distributionChoice)(e_ASNH245NetworkAccessParameters_distributionChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NetworkAccessParameters_distribution_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NetworkAccessParameters_distributionChoice_unicast ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NetworkAccessParameters_distributionChoice_multicast ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NetworkAccessParameters_distribution DeleteAlternation */
HS_RESULT ASNH245NetworkAccessParameters_distribution_DeleteAlternation(void *pObject)
{
	ASNH245NetworkAccessParameters_distribution *pObj = (ASNH245NetworkAccessParameters_distribution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NetworkAccessParameters_distributionChoice_unicast ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NetworkAccessParameters_distributionChoice_multicast ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NetworkAccessParameters_distribution_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NetworkAccessParameters_distribution Encode */
HS_RESULT ASNH245NetworkAccessParameters_distribution_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NetworkAccessParameters_distribution *pObj = (ASNH245NetworkAccessParameters_distribution *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NetworkAccessParameters_distributionChoiceSize )
		{
			if( pObj->choice > ((ASNH245NetworkAccessParameters_distributionChoice)(e_ASNH245NetworkAccessParameters_distributionChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NetworkAccessParameters_distributionChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NetworkAccessParameters_distributionChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NetworkAccessParameters_distributionChoice_unicast ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_distributionChoice_multicast ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NetworkAccessParameters_distribution Decode */
HS_RESULT ASNH245NetworkAccessParameters_distribution_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NetworkAccessParameters_distribution *pObj = (ASNH245NetworkAccessParameters_distribution *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NetworkAccessParameters_distributionChoiceSize;
	}
	else
	{
		if( e_ASNH245NetworkAccessParameters_distributionChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NetworkAccessParameters_distributionChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NetworkAccessParameters_distributionChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NetworkAccessParameters_distribution_SetChoice( pObj, (ASNH245NetworkAccessParameters_distributionChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NetworkAccessParameters_distributionChoice_unicast ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_distributionChoice_multicast ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NetworkAccessParameters_distribution Print */
HS_RESULT ASNH245NetworkAccessParameters_distribution_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NetworkAccessParameters_distribution *pObj = (ASNH245NetworkAccessParameters_distribution *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_distribution_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NetworkAccessParameters_distributionChoice_unicast ){
		AsnNull_Print( pObj->alter, pDepth+1, "unicast" );
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_distributionChoice_multicast ){
		AsnNull_Print( pObj->alter, pDepth+1, "multicast" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NetworkAccessParameters_networkAddress Struct
*/
/* ASNH245NetworkAccessParameters_networkAddress Constructor */
HS_RESULT new_ASNH245NetworkAccessParameters_networkAddress( void *pObject )
{
	ASNH245NetworkAccessParameters_networkAddress *pObj = (ASNH245NetworkAccessParameters_networkAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NetworkAccessParameters_networkAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NetworkAccessParameters_networkAddressChoice_q2931Address;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NetworkAccessParameters_networkAddressChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NetworkAccessParameters_networkAddress Destructor */
HS_RESULT delete_ASNH245NetworkAccessParameters_networkAddress( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NetworkAccessParameters_networkAddress *pObj = (ASNH245NetworkAccessParameters_networkAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NetworkAccessParameters_networkAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NetworkAccessParameters_networkAddress_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NetworkAccessParameters_networkAddress(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NetworkAccessParameters_networkAddress SetChoice */
void* ASNH245NetworkAccessParameters_networkAddress_SetChoice( void *pObject, ASNH245NetworkAccessParameters_networkAddressChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NetworkAccessParameters_networkAddress *pObj = (ASNH245NetworkAccessParameters_networkAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NetworkAccessParameters_networkAddressChoiceSizeExt ){
		if( pChoice > (ASNH245NetworkAccessParameters_networkAddressChoice)(e_ASNH245NetworkAccessParameters_networkAddressChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NetworkAccessParameters_networkAddress_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NetworkAccessParameters_networkAddressChoice_q2931Address ){
		ASNH245Q2931Address *tAlter = (ASNH245Q2931Address *)HSMalloc( sizeof(ASNH245Q2931Address) );
		new_ASNH245Q2931Address(tAlter);
		ASNH245Q2931Address_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NetworkAccessParameters_networkAddressChoice_e164Address ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagIA5String,e_constrained,1,128,0,HS_ASN_MAX_CONSTRAINT);
		/* FROM Constraint */
		strcpy((char*)(tAlter->fromConstraint), "#*,0123456789");
		tAlter->fromSize = 13;
		tAlter->reIndexing = GetStringTypeEncodingBits(
			tAlter->fromSize,
			ASN_IA5_STRING_VMAX,
			&(tAlter->encodingBitsOfAlign),
			&(tAlter->encodingBitsOfUnalign)
		);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NetworkAccessParameters_networkAddressChoice_localAreaAddress ){
		ASNH245TransportAddress *tAlter = (ASNH245TransportAddress *)HSMalloc( sizeof(ASNH245TransportAddress) );
		new_ASNH245TransportAddress(tAlter);
		ASNH245TransportAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NetworkAccessParameters_networkAddress DeleteAlternation */
HS_RESULT ASNH245NetworkAccessParameters_networkAddress_DeleteAlternation(void *pObject)
{
	ASNH245NetworkAccessParameters_networkAddress *pObj = (ASNH245NetworkAccessParameters_networkAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_q2931Address ){
			delete_ASNH245Q2931Address(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_e164Address ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_localAreaAddress ){
			delete_ASNH245TransportAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NetworkAccessParameters_networkAddress_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NetworkAccessParameters_networkAddress Encode */
HS_RESULT ASNH245NetworkAccessParameters_networkAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NetworkAccessParameters_networkAddress *pObj = (ASNH245NetworkAccessParameters_networkAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NetworkAccessParameters_networkAddressChoiceSize )
		{
			if( pObj->choice > ((ASNH245NetworkAccessParameters_networkAddressChoice)(e_ASNH245NetworkAccessParameters_networkAddressChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NetworkAccessParameters_networkAddressChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NetworkAccessParameters_networkAddressChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_q2931Address ){
		if( (tRet=ASNH245Q2931Address_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_e164Address ){
		if( (tRet=AsnSingleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_localAreaAddress ){
		if( (tRet=ASNH245TransportAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NetworkAccessParameters_networkAddress Decode */
HS_RESULT ASNH245NetworkAccessParameters_networkAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NetworkAccessParameters_networkAddress *pObj = (ASNH245NetworkAccessParameters_networkAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NetworkAccessParameters_networkAddressChoiceSize;
	}
	else
	{
		if( e_ASNH245NetworkAccessParameters_networkAddressChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NetworkAccessParameters_networkAddressChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NetworkAccessParameters_networkAddressChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NetworkAccessParameters_networkAddress_SetChoice( pObj, (ASNH245NetworkAccessParameters_networkAddressChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_q2931Address ){
		if( (tRet=ASNH245Q2931Address_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_e164Address ){
		if( (tRet=AsnSingleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_localAreaAddress ){
		if( (tRet=ASNH245TransportAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NetworkAccessParameters_networkAddress Print */
HS_RESULT ASNH245NetworkAccessParameters_networkAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NetworkAccessParameters_networkAddress *pObj = (ASNH245NetworkAccessParameters_networkAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_networkAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_q2931Address ){
		ASNH245Q2931Address_Print( pObj->alter, pDepth+1, "q2931Address" );
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_e164Address ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "e164Address" );
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_networkAddressChoice_localAreaAddress ){
		ASNH245TransportAddress_Print( pObj->alter, pDepth+1, "localAreaAddress" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NetworkAccessParameters_t120SetupProcedure Struct
*/
/* ASNH245NetworkAccessParameters_t120SetupProcedure Constructor */
HS_RESULT new_ASNH245NetworkAccessParameters_t120SetupProcedure( void *pObject )
{
	ASNH245NetworkAccessParameters_t120SetupProcedure *pObj = (ASNH245NetworkAccessParameters_t120SetupProcedure *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NetworkAccessParameters_t120SetupProcedure(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_originateCall;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NetworkAccessParameters_t120SetupProcedure Destructor */
HS_RESULT delete_ASNH245NetworkAccessParameters_t120SetupProcedure( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NetworkAccessParameters_t120SetupProcedure *pObj = (ASNH245NetworkAccessParameters_t120SetupProcedure *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NetworkAccessParameters_t120SetupProcedure(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NetworkAccessParameters_t120SetupProcedure_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NetworkAccessParameters_t120SetupProcedure(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NetworkAccessParameters_t120SetupProcedure SetChoice */
void* ASNH245NetworkAccessParameters_t120SetupProcedure_SetChoice( void *pObject, ASNH245NetworkAccessParameters_t120SetupProcedureChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NetworkAccessParameters_t120SetupProcedure *pObj = (ASNH245NetworkAccessParameters_t120SetupProcedure *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSizeExt ){
		if( pChoice > (ASNH245NetworkAccessParameters_t120SetupProcedureChoice)(e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NetworkAccessParameters_t120SetupProcedure_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_originateCall ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_waitForCall ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_issueQuery ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NetworkAccessParameters_t120SetupProcedure DeleteAlternation */
HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_DeleteAlternation(void *pObject)
{
	ASNH245NetworkAccessParameters_t120SetupProcedure *pObj = (ASNH245NetworkAccessParameters_t120SetupProcedure *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_originateCall ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_waitForCall ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_issueQuery ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NetworkAccessParameters_t120SetupProcedure Encode */
HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NetworkAccessParameters_t120SetupProcedure *pObj = (ASNH245NetworkAccessParameters_t120SetupProcedure *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSize )
		{
			if( pObj->choice > ((ASNH245NetworkAccessParameters_t120SetupProcedureChoice)(e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_originateCall ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_waitForCall ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_issueQuery ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NetworkAccessParameters_t120SetupProcedure Decode */
HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NetworkAccessParameters_t120SetupProcedure *pObj = (ASNH245NetworkAccessParameters_t120SetupProcedure *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSize;
	}
	else
	{
		if( e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NetworkAccessParameters_t120SetupProcedureChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NetworkAccessParameters_t120SetupProcedure_SetChoice( pObj, (ASNH245NetworkAccessParameters_t120SetupProcedureChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_originateCall ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_waitForCall ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_issueQuery ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NetworkAccessParameters_t120SetupProcedure Print */
HS_RESULT ASNH245NetworkAccessParameters_t120SetupProcedure_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NetworkAccessParameters_t120SetupProcedure *pObj = (ASNH245NetworkAccessParameters_t120SetupProcedure *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_t120SetupProcedure_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_originateCall ){
		AsnNull_Print( pObj->alter, pDepth+1, "originateCall" );
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_waitForCall ){
		AsnNull_Print( pObj->alter, pDepth+1, "waitForCall" );
	}
	else if ( pObj->choice == e_ASNH245NetworkAccessParameters_t120SetupProcedureChoice_issueQuery ){
		AsnNull_Print( pObj->alter, pDepth+1, "issueQuery" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NetworkAccessParameters Class
*/
/*ASNH245NetworkAccessParameters Constructor*/
HS_RESULT new_ASNH245NetworkAccessParameters(void *pObject)
{
	ASNH245NetworkAccessParameters *pObj = (ASNH245NetworkAccessParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NetworkAccessParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245NetworkAccessParameters_distribution( &(pObj->m_distribution) );
	new_ASNH245NetworkAccessParameters_networkAddress( &(pObj->m_networkAddress) );
	new_AsnBoolean( &(pObj->m_associateConference) );
	new_AsnOctetString( &(pObj->m_externalReference), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245NetworkAccessParameters_t120SetupProcedure( &(pObj->m_t120SetupProcedure) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245NetworkAccessParameters Destructor */
HS_RESULT delete_ASNH245NetworkAccessParameters(void *pObject)
{
	ASNH245NetworkAccessParameters *pObj = (ASNH245NetworkAccessParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NetworkAccessParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245NetworkAccessParameters_distribution( &(pObj->m_distribution) );
	delete_ASNH245NetworkAccessParameters_networkAddress( &(pObj->m_networkAddress) );
	delete_AsnBoolean( &(pObj->m_associateConference) );
	delete_AsnOctetString( &(pObj->m_externalReference) );
	delete_ASNH245NetworkAccessParameters_t120SetupProcedure( &(pObj->m_t120SetupProcedure) );
	return HS_OK;
}

/* ASNH245NetworkAccessParameters MakeMold */
HS_RESULT ASNH245NetworkAccessParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NetworkAccessParameters *pObj = (ASNH245NetworkAccessParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245NetworkAccessParameters IncludeOptionalField */
HS_RESULT ASNH245NetworkAccessParameters_IncludeOptionField( void *pObject, ASNH245NetworkAccessParametersOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245NetworkAccessParameters *pObj = (ASNH245NetworkAccessParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245NetworkAccessParametersOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245NetworkAccessParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245NetworkAccessParametersOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245NetworkAccessParameters IsIncludeOptionalField */
BOOL ASNH245NetworkAccessParameters_IsIncludeOptionField( void *pObject, ASNH245NetworkAccessParametersOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245NetworkAccessParameters *pObj = (ASNH245NetworkAccessParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245NetworkAccessParametersOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245NetworkAccessParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245NetworkAccessParametersOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245NetworkAccessParameters Encode */
HS_RESULT ASNH245NetworkAccessParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245NetworkAccessParameters *pObj = (ASNH245NetworkAccessParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245NetworkAccessParametersOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245NetworkAccessParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245NetworkAccessParameters_IsIncludeOptionField( pObj, e_ASNH245NetworkAccessParametersOptionMap_distribution ) ){
		if( (tRet=ASNH245NetworkAccessParameters_distribution_Encode( &(pObj->m_distribution),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH245NetworkAccessParameters_networkAddress_Encode( &(pObj->m_networkAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_associateConference),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245NetworkAccessParameters_IsIncludeOptionField( pObj, e_ASNH245NetworkAccessParametersOptionMap_externalReference ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_externalReference),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245NetworkAccessParameters_IsIncludeOptionField( pObj, e_ASNH245NetworkAccessParametersOptionMap_t120SetupProcedure ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_t120SetupProcedure), ASNH245NetworkAccessParameters_t120SetupProcedure_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245NetworkAccessParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245NetworkAccessParameters Decode */
HS_RESULT ASNH245NetworkAccessParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245NetworkAccessParameters *pObj = (ASNH245NetworkAccessParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245NetworkAccessParametersOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245NetworkAccessParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245NetworkAccessParameters_IsIncludeOptionField( pObj, e_ASNH245NetworkAccessParametersOptionMap_distribution ) ){
		if( (tRet=ASNH245NetworkAccessParameters_distribution_Decode(&(pObj->m_distribution),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH245NetworkAccessParameters_networkAddress_Decode(&(pObj->m_networkAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_associateConference),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245NetworkAccessParameters_IsIncludeOptionField( pObj, e_ASNH245NetworkAccessParametersOptionMap_externalReference ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_externalReference),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245NetworkAccessParameters_IsIncludeOptionField( pObj, e_ASNH245NetworkAccessParametersOptionMap_t120SetupProcedure ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_t120SetupProcedure), ASNH245NetworkAccessParameters_t120SetupProcedure_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NetworkAccessParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NetworkAccessParameters Print */
HS_RESULT ASNH245NetworkAccessParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NetworkAccessParameters *pObj = (ASNH245NetworkAccessParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NetworkAccessParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245NetworkAccessParameters_IsIncludeOptionField( pObj, e_ASNH245NetworkAccessParametersOptionMap_distribution ) )
		ASNH245NetworkAccessParameters_distribution_Print( &(pObj->m_distribution), pDepth+1, "distribution" );
	ASNH245NetworkAccessParameters_networkAddress_Print( &(pObj->m_networkAddress), pDepth+1, "networkAddress" );
	AsnBoolean_Print( &(pObj->m_associateConference), pDepth+1, "associateConference" );
	if( ASNH245NetworkAccessParameters_IsIncludeOptionField( pObj, e_ASNH245NetworkAccessParametersOptionMap_externalReference ) )
		AsnOctetString_Print( &(pObj->m_externalReference), pDepth+1, "externalReference" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245NetworkAccessParameters_IsIncludeOptionField( pObj, e_ASNH245NetworkAccessParametersOptionMap_t120SetupProcedure ) )
		ASNH245NetworkAccessParameters_t120SetupProcedure_Print( &(pObj->m_t120SetupProcedure), pDepth+1, "t120SetupProcedure" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245EscrowData Class
*/
/*ASNH245EscrowData Constructor*/
HS_RESULT new_ASNH245EscrowData(void *pObject)
{
	ASNH245EscrowData *pObj = (ASNH245EscrowData *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245EscrowData(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnObjectIdentifier( &(pObj->m_escrowID) );
	new_AsnBitString( &(pObj->m_escrowValue), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245EscrowData Destructor */
HS_RESULT delete_ASNH245EscrowData(void *pObject)
{
	ASNH245EscrowData *pObj = (ASNH245EscrowData *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245EscrowData(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnObjectIdentifier( &(pObj->m_escrowID) );
	delete_AsnBitString( &(pObj->m_escrowValue) );
	return HS_OK;
}

/* ASNH245EscrowData MakeMold */
HS_RESULT ASNH245EscrowData_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245EscrowData *pObj = (ASNH245EscrowData *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EscrowData_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245EscrowData Encode */
HS_RESULT ASNH245EscrowData_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245EscrowData *pObj = (ASNH245EscrowData *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EscrowData_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnObjectIdentifier_Encode( &(pObj->m_escrowID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EscrowData_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBitString_Encode( &(pObj->m_escrowValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EscrowData_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245EscrowData Decode */
HS_RESULT ASNH245EscrowData_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245EscrowData *pObj = (ASNH245EscrowData *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EscrowData_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnObjectIdentifier_Decode(&(pObj->m_escrowID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EscrowData_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBitString_Decode(&(pObj->m_escrowValue),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EscrowData_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245EscrowData Print */
HS_RESULT ASNH245EscrowData_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245EscrowData *pObj = (ASNH245EscrowData *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245EscrowData_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnObjectIdentifier_Print( &(pObj->m_escrowID), pDepth+1, "escrowID" );
	AsnBitString_Print( &(pObj->m_escrowValue), pDepth+1, "escrowValue" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245EncryptionSync Class
*/
/*ASNH245EncryptionSync Constructor*/
HS_RESULT new_ASNH245EncryptionSync(void *pObject)
{
	ASNH245EncryptionSync *pObj = (ASNH245EncryptionSync *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245EncryptionSync(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245NonStandardParameter( &(pObj->m_nonStandard) );
	new_AsnInteger( &(pObj->m_synchFlag), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_h235Key), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_escrowentry), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245EncryptionSync Destructor */
HS_RESULT delete_ASNH245EncryptionSync(void *pObject)
{
	ASNH245EncryptionSync *pObj = (ASNH245EncryptionSync *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245EncryptionSync(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245NonStandardParameter( &(pObj->m_nonStandard) );
	delete_AsnInteger( &(pObj->m_synchFlag) );
	delete_AsnOctetString( &(pObj->m_h235Key) );
	delete_AsnSequenceOf( &(pObj->m_escrowentry) );
	return HS_OK;
}

/* ASNH245EncryptionSync MakeMold */
HS_RESULT ASNH245EncryptionSync_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245EncryptionSync *pObj = (ASNH245EncryptionSync *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EncryptionSync_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245NonStandardParameter_MakeMold(&(pObj->m_nonStandard));
	{
	ASNH245EscrowData *tmold_escrowentry = (ASNH245EscrowData *)HSMalloc( sizeof(ASNH245EscrowData) );
	new_ASNH245EscrowData(tmold_escrowentry);
	ASNH245EscrowData_MakeMold(tmold_escrowentry);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_escrowentry,sizeof(ASNH245EscrowData),ASNH245EscrowData_MakeMold,ASNH245EscrowData_Encode,ASNH245EscrowData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245EscrowData_Print,
#endif
		delete_ASNH245EscrowData);
	AsnSequenceOf_SetMold( &(pObj->m_escrowentry), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_escrowentry.constraint.type = e_constrained;
	pObj->m_escrowentry.constraint.minValue = 1;
	pObj->m_escrowentry.constraint.maxValue = 256;
	pObj->m_escrowentry.extMinValue = 0;
	pObj->m_escrowentry.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245EncryptionSync IncludeOptionalField */
HS_RESULT ASNH245EncryptionSync_IncludeOptionField( void *pObject, ASNH245EncryptionSyncOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245EncryptionSync *pObj = (ASNH245EncryptionSync *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EncryptionSync_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245EncryptionSyncOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245EncryptionSync IsIncludeOptionalField */
BOOL ASNH245EncryptionSync_IsIncludeOptionField( void *pObject, ASNH245EncryptionSyncOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245EncryptionSync *pObj = (ASNH245EncryptionSync *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EncryptionSync_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245EncryptionSyncOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245EncryptionSync Encode */
HS_RESULT ASNH245EncryptionSync_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245EncryptionSync *pObj = (ASNH245EncryptionSync *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EncryptionSync_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245EncryptionSyncOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245EncryptionSyncOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245EncryptionSync_IsIncludeOptionField( pObj, e_ASNH245EncryptionSyncOptionMap_nonStandard ) ){
		if( (tRet=ASNH245NonStandardParameter_Encode( &(pObj->m_nonStandard),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EncryptionSync_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_synchFlag),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EncryptionSync_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_h235Key),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EncryptionSync_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245EncryptionSync_IsIncludeOptionField( pObj, e_ASNH245EncryptionSyncOptionMap_escrowentry ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_escrowentry),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EncryptionSync_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245EncryptionSync Decode */
HS_RESULT ASNH245EncryptionSync_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245EncryptionSync *pObj = (ASNH245EncryptionSync *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EncryptionSync_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245EncryptionSyncOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245EncryptionSyncOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245EncryptionSync_IsIncludeOptionField( pObj, e_ASNH245EncryptionSyncOptionMap_nonStandard ) ){
		if( (tRet=ASNH245NonStandardParameter_Decode(&(pObj->m_nonStandard),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EncryptionSync_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_synchFlag),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EncryptionSync_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_h235Key),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245EncryptionSync_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245EncryptionSync_IsIncludeOptionField( pObj, e_ASNH245EncryptionSyncOptionMap_escrowentry ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_escrowentry),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245EncryptionSync_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245EncryptionSync Print */
HS_RESULT ASNH245EncryptionSync_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245EncryptionSync *pObj = (ASNH245EncryptionSync *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245EncryptionSync_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245EncryptionSync_IsIncludeOptionField( pObj, e_ASNH245EncryptionSyncOptionMap_nonStandard ) )
		ASNH245NonStandardParameter_Print( &(pObj->m_nonStandard), pDepth+1, "nonStandard" );
	AsnInteger_Print( &(pObj->m_synchFlag), pDepth+1, "synchFlag" );
	AsnOctetString_Print( &(pObj->m_h235Key), pDepth+1, "h235Key" );
	if( ASNH245EncryptionSync_IsIncludeOptionField( pObj, e_ASNH245EncryptionSyncOptionMap_escrowentry ) )
		AsnSequenceOf_Print( &(pObj->m_escrowentry), pDepth+1, "escrowentry" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannel Class
*/
/*ASNH245OpenLogicalChannel Constructor*/
HS_RESULT new_ASNH245OpenLogicalChannel(void *pObject)
{
	ASNH245OpenLogicalChannel *pObj = (ASNH245OpenLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannel(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	new_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters( &(pObj->m_forwardLogicalChannelParameters) );
	new_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters( &(pObj->m_reverseLogicalChannelParameters) );
	new_ASNH245NetworkAccessParameters( &(pObj->m_separateStack) );
	new_ASNH245EncryptionSync( &(pObj->m_encryptionSync) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245OpenLogicalChannel Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannel(void *pObject)
{
	ASNH245OpenLogicalChannel *pObj = (ASNH245OpenLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannel(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	delete_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters( &(pObj->m_forwardLogicalChannelParameters) );
	delete_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters( &(pObj->m_reverseLogicalChannelParameters) );
	delete_ASNH245NetworkAccessParameters( &(pObj->m_separateStack) );
	delete_ASNH245EncryptionSync( &(pObj->m_encryptionSync) );
	return HS_OK;
}

/* ASNH245OpenLogicalChannel MakeMold */
HS_RESULT ASNH245OpenLogicalChannel_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245OpenLogicalChannel *pObj = (ASNH245OpenLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_MakeMold(&(pObj->m_forwardLogicalChannelParameters));
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_MakeMold(&(pObj->m_reverseLogicalChannelParameters));
	ASNH245NetworkAccessParameters_MakeMold(&(pObj->m_separateStack));
	ASNH245EncryptionSync_MakeMold(&(pObj->m_encryptionSync));
	return HS_OK;
}

/* ASNH245OpenLogicalChannel IncludeOptionalField */
HS_RESULT ASNH245OpenLogicalChannel_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannelOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannel *pObj = (ASNH245OpenLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannelOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannelOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannelOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannel IsIncludeOptionalField */
BOOL ASNH245OpenLogicalChannel_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannelOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannel *pObj = (ASNH245OpenLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannelOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannelOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannelOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245OpenLogicalChannel Encode */
HS_RESULT ASNH245OpenLogicalChannel_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannel *pObj = (ASNH245OpenLogicalChannel *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannelOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannelOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Encode( &(pObj->m_forwardLogicalChannelParameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245OpenLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelOptionMap_reverseLogicalChannelParameters ) ){
		if( (tRet=ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Encode( &(pObj->m_reverseLogicalChannelParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245OpenLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelOptionMap_separateStack ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_separateStack), ASNH245NetworkAccessParameters_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245OpenLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelOptionMap_encryptionSync ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_encryptionSync), ASNH245EncryptionSync_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245OpenLogicalChannel Decode */
HS_RESULT ASNH245OpenLogicalChannel_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannel *pObj = (ASNH245OpenLogicalChannel *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannelOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannelOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Decode(&(pObj->m_forwardLogicalChannelParameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245OpenLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelOptionMap_reverseLogicalChannelParameters ) ){
		if( (tRet=ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Decode(&(pObj->m_reverseLogicalChannelParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245OpenLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelOptionMap_separateStack ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_separateStack), ASNH245NetworkAccessParameters_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245OpenLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelOptionMap_encryptionSync ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_encryptionSync), ASNH245EncryptionSync_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannel Print */
HS_RESULT ASNH245OpenLogicalChannel_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannel *pObj = (ASNH245OpenLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannel_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_Print( &(pObj->m_forwardLogicalChannelParameters), pDepth+1, "forwardLogicalChannelParameters" );
	if( ASNH245OpenLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelOptionMap_reverseLogicalChannelParameters ) )
		ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_Print( &(pObj->m_reverseLogicalChannelParameters), pDepth+1, "reverseLogicalChannelParameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245OpenLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelOptionMap_separateStack ) )
		ASNH245NetworkAccessParameters_Print( &(pObj->m_separateStack), pDepth+1, "separateStack" );
	if( ASNH245OpenLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelOptionMap_encryptionSync ) )
		ASNH245EncryptionSync_Print( &(pObj->m_encryptionSync), pDepth+1, "encryptionSync" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CloseLogicalChannel_source Struct
*/
/* ASNH245CloseLogicalChannel_source Constructor */
HS_RESULT new_ASNH245CloseLogicalChannel_source( void *pObject )
{
	ASNH245CloseLogicalChannel_source *pObj = (ASNH245CloseLogicalChannel_source *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CloseLogicalChannel_source(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245CloseLogicalChannel_sourceChoice_user;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245CloseLogicalChannel_sourceChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245CloseLogicalChannel_source Destructor */
HS_RESULT delete_ASNH245CloseLogicalChannel_source( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245CloseLogicalChannel_source *pObj = (ASNH245CloseLogicalChannel_source *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CloseLogicalChannel_source(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245CloseLogicalChannel_source_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CloseLogicalChannel_source(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245CloseLogicalChannel_source SetChoice */
void* ASNH245CloseLogicalChannel_source_SetChoice( void *pObject, ASNH245CloseLogicalChannel_sourceChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245CloseLogicalChannel_source *pObj = (ASNH245CloseLogicalChannel_source *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245CloseLogicalChannel_sourceChoiceSizeExt ){
		if( pChoice > (ASNH245CloseLogicalChannel_sourceChoice)(e_ASNH245CloseLogicalChannel_sourceChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245CloseLogicalChannel_source_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245CloseLogicalChannel_sourceChoice_user ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CloseLogicalChannel_sourceChoice_lcse ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245CloseLogicalChannel_source DeleteAlternation */
HS_RESULT ASNH245CloseLogicalChannel_source_DeleteAlternation(void *pObject)
{
	ASNH245CloseLogicalChannel_source *pObj = (ASNH245CloseLogicalChannel_source *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245CloseLogicalChannel_sourceChoice_user ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CloseLogicalChannel_sourceChoice_lcse ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245CloseLogicalChannel_source_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245CloseLogicalChannel_source Encode */
HS_RESULT ASNH245CloseLogicalChannel_source_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245CloseLogicalChannel_source *pObj = (ASNH245CloseLogicalChannel_source *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245CloseLogicalChannel_sourceChoiceSize )
		{
			if( pObj->choice > ((ASNH245CloseLogicalChannel_sourceChoice)(e_ASNH245CloseLogicalChannel_sourceChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245CloseLogicalChannel_sourceChoiceSize)) )
	}
	else
	{
		if( e_ASNH245CloseLogicalChannel_sourceChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CloseLogicalChannel_sourceChoice_user ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CloseLogicalChannel_sourceChoice_lcse ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245CloseLogicalChannel_source Decode */
HS_RESULT ASNH245CloseLogicalChannel_source_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245CloseLogicalChannel_source *pObj = (ASNH245CloseLogicalChannel_source *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245CloseLogicalChannel_sourceChoiceSize;
	}
	else
	{
		if( e_ASNH245CloseLogicalChannel_sourceChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245CloseLogicalChannel_sourceChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245CloseLogicalChannel_sourceChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245CloseLogicalChannel_source_SetChoice( pObj, (ASNH245CloseLogicalChannel_sourceChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CloseLogicalChannel_sourceChoice_user ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CloseLogicalChannel_sourceChoice_lcse ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CloseLogicalChannel_source Print */
HS_RESULT ASNH245CloseLogicalChannel_source_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CloseLogicalChannel_source *pObj = (ASNH245CloseLogicalChannel_source *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_source_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CloseLogicalChannel_sourceChoice_user ){
		AsnNull_Print( pObj->alter, pDepth+1, "user" );
	}
	else if ( pObj->choice == e_ASNH245CloseLogicalChannel_sourceChoice_lcse ){
		AsnNull_Print( pObj->alter, pDepth+1, "lcse" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CloseLogicalChannel_reason Struct
*/
/* ASNH245CloseLogicalChannel_reason Constructor */
HS_RESULT new_ASNH245CloseLogicalChannel_reason( void *pObject )
{
	ASNH245CloseLogicalChannel_reason *pObj = (ASNH245CloseLogicalChannel_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CloseLogicalChannel_reason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245CloseLogicalChannel_reasonChoice_unknown;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245CloseLogicalChannel_reasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245CloseLogicalChannel_reason Destructor */
HS_RESULT delete_ASNH245CloseLogicalChannel_reason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245CloseLogicalChannel_reason *pObj = (ASNH245CloseLogicalChannel_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CloseLogicalChannel_reason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245CloseLogicalChannel_reason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CloseLogicalChannel_reason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245CloseLogicalChannel_reason SetChoice */
void* ASNH245CloseLogicalChannel_reason_SetChoice( void *pObject, ASNH245CloseLogicalChannel_reasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245CloseLogicalChannel_reason *pObj = (ASNH245CloseLogicalChannel_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245CloseLogicalChannel_reasonChoiceSizeExt ){
		if( pChoice > (ASNH245CloseLogicalChannel_reasonChoice)(e_ASNH245CloseLogicalChannel_reasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245CloseLogicalChannel_reason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245CloseLogicalChannel_reasonChoice_unknown ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CloseLogicalChannel_reasonChoice_reopen ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CloseLogicalChannel_reasonChoice_reservationFailure ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245CloseLogicalChannel_reason DeleteAlternation */
HS_RESULT ASNH245CloseLogicalChannel_reason_DeleteAlternation(void *pObject)
{
	ASNH245CloseLogicalChannel_reason *pObj = (ASNH245CloseLogicalChannel_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_unknown ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_reopen ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_reservationFailure ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245CloseLogicalChannel_reason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245CloseLogicalChannel_reason Encode */
HS_RESULT ASNH245CloseLogicalChannel_reason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245CloseLogicalChannel_reason *pObj = (ASNH245CloseLogicalChannel_reason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245CloseLogicalChannel_reasonChoiceSize )
		{
			if( pObj->choice > ((ASNH245CloseLogicalChannel_reasonChoice)(e_ASNH245CloseLogicalChannel_reasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245CloseLogicalChannel_reasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH245CloseLogicalChannel_reasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_unknown ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_reopen ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_reservationFailure ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245CloseLogicalChannel_reason Decode */
HS_RESULT ASNH245CloseLogicalChannel_reason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245CloseLogicalChannel_reason *pObj = (ASNH245CloseLogicalChannel_reason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245CloseLogicalChannel_reasonChoiceSize;
	}
	else
	{
		if( e_ASNH245CloseLogicalChannel_reasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245CloseLogicalChannel_reasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245CloseLogicalChannel_reasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245CloseLogicalChannel_reason_SetChoice( pObj, (ASNH245CloseLogicalChannel_reasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_unknown ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_reopen ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_reservationFailure ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CloseLogicalChannel_reason Print */
HS_RESULT ASNH245CloseLogicalChannel_reason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CloseLogicalChannel_reason *pObj = (ASNH245CloseLogicalChannel_reason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_reason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_unknown ){
		AsnNull_Print( pObj->alter, pDepth+1, "unknown" );
	}
	else if ( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_reopen ){
		AsnNull_Print( pObj->alter, pDepth+1, "reopen" );
	}
	else if ( pObj->choice == e_ASNH245CloseLogicalChannel_reasonChoice_reservationFailure ){
		AsnNull_Print( pObj->alter, pDepth+1, "reservationFailure" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CloseLogicalChannel Class
*/
/*ASNH245CloseLogicalChannel Constructor*/
HS_RESULT new_ASNH245CloseLogicalChannel(void *pObject)
{
	ASNH245CloseLogicalChannel *pObj = (ASNH245CloseLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CloseLogicalChannel(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	new_ASNH245CloseLogicalChannel_source( &(pObj->m_source) );
	new_ASNH245CloseLogicalChannel_reason( &(pObj->m_reason) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245CloseLogicalChannel Destructor */
HS_RESULT delete_ASNH245CloseLogicalChannel(void *pObject)
{
	ASNH245CloseLogicalChannel *pObj = (ASNH245CloseLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CloseLogicalChannel(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	delete_ASNH245CloseLogicalChannel_source( &(pObj->m_source) );
	delete_ASNH245CloseLogicalChannel_reason( &(pObj->m_reason) );
	return HS_OK;
}

/* ASNH245CloseLogicalChannel MakeMold */
HS_RESULT ASNH245CloseLogicalChannel_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CloseLogicalChannel *pObj = (ASNH245CloseLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	return HS_OK;
}

/* ASNH245CloseLogicalChannel IncludeOptionalField */
HS_RESULT ASNH245CloseLogicalChannel_IncludeOptionField( void *pObject, ASNH245CloseLogicalChannelOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245CloseLogicalChannel *pObj = (ASNH245CloseLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245CloseLogicalChannelOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245CloseLogicalChannelOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245CloseLogicalChannel IsIncludeOptionalField */
BOOL ASNH245CloseLogicalChannel_IsIncludeOptionField( void *pObject, ASNH245CloseLogicalChannelOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245CloseLogicalChannel *pObj = (ASNH245CloseLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245CloseLogicalChannelOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245CloseLogicalChannelOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245CloseLogicalChannel Encode */
HS_RESULT ASNH245CloseLogicalChannel_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CloseLogicalChannel *pObj = (ASNH245CloseLogicalChannel *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CloseLogicalChannel_source_Encode( &(pObj->m_source),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245CloseLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245CloseLogicalChannelOptionMap_reason ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_reason), ASNH245CloseLogicalChannel_reason_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245CloseLogicalChannel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245CloseLogicalChannel Decode */
HS_RESULT ASNH245CloseLogicalChannel_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CloseLogicalChannel *pObj = (ASNH245CloseLogicalChannel *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CloseLogicalChannel_source_Decode(&(pObj->m_source),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245CloseLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245CloseLogicalChannelOptionMap_reason ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_reason), ASNH245CloseLogicalChannel_reason_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CloseLogicalChannel_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CloseLogicalChannel Print */
HS_RESULT ASNH245CloseLogicalChannel_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CloseLogicalChannel *pObj = (ASNH245CloseLogicalChannel *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CloseLogicalChannel_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	ASNH245CloseLogicalChannel_source_Print( &(pObj->m_source), pDepth+1, "source" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245CloseLogicalChannel_IsIncludeOptionField( pObj, e_ASNH245CloseLogicalChannelOptionMap_reason ) )
		ASNH245CloseLogicalChannel_reason_Print( &(pObj->m_reason), pDepth+1, "reason" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestChannelClose_reason Struct
*/
/* ASNH245RequestChannelClose_reason Constructor */
HS_RESULT new_ASNH245RequestChannelClose_reason( void *pObject )
{
	ASNH245RequestChannelClose_reason *pObj = (ASNH245RequestChannelClose_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestChannelClose_reason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RequestChannelClose_reasonChoice_unknown;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RequestChannelClose_reasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RequestChannelClose_reason Destructor */
HS_RESULT delete_ASNH245RequestChannelClose_reason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RequestChannelClose_reason *pObj = (ASNH245RequestChannelClose_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestChannelClose_reason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RequestChannelClose_reason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestChannelClose_reason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RequestChannelClose_reason SetChoice */
void* ASNH245RequestChannelClose_reason_SetChoice( void *pObject, ASNH245RequestChannelClose_reasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RequestChannelClose_reason *pObj = (ASNH245RequestChannelClose_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RequestChannelClose_reasonChoiceSizeExt ){
		if( pChoice > (ASNH245RequestChannelClose_reasonChoice)(e_ASNH245RequestChannelClose_reasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RequestChannelClose_reason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RequestChannelClose_reasonChoice_unknown ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestChannelClose_reasonChoice_normal ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestChannelClose_reasonChoice_reopen ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestChannelClose_reasonChoice_reservationFailure ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RequestChannelClose_reason DeleteAlternation */
HS_RESULT ASNH245RequestChannelClose_reason_DeleteAlternation(void *pObject)
{
	ASNH245RequestChannelClose_reason *pObj = (ASNH245RequestChannelClose_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_unknown ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_normal ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_reopen ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_reservationFailure ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RequestChannelClose_reason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RequestChannelClose_reason Encode */
HS_RESULT ASNH245RequestChannelClose_reason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RequestChannelClose_reason *pObj = (ASNH245RequestChannelClose_reason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RequestChannelClose_reasonChoiceSize )
		{
			if( pObj->choice > ((ASNH245RequestChannelClose_reasonChoice)(e_ASNH245RequestChannelClose_reasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RequestChannelClose_reasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RequestChannelClose_reasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_unknown ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_normal ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_reopen ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_reservationFailure ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RequestChannelClose_reason Decode */
HS_RESULT ASNH245RequestChannelClose_reason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RequestChannelClose_reason *pObj = (ASNH245RequestChannelClose_reason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RequestChannelClose_reasonChoiceSize;
	}
	else
	{
		if( e_ASNH245RequestChannelClose_reasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RequestChannelClose_reasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RequestChannelClose_reasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RequestChannelClose_reason_SetChoice( pObj, (ASNH245RequestChannelClose_reasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_unknown ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_normal ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_reopen ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_reservationFailure ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestChannelClose_reason Print */
HS_RESULT ASNH245RequestChannelClose_reason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestChannelClose_reason *pObj = (ASNH245RequestChannelClose_reason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestChannelClose_reason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_unknown ){
		AsnNull_Print( pObj->alter, pDepth+1, "unknown" );
	}
	else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_normal ){
		AsnNull_Print( pObj->alter, pDepth+1, "normal" );
	}
	else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_reopen ){
		AsnNull_Print( pObj->alter, pDepth+1, "reopen" );
	}
	else if ( pObj->choice == e_ASNH245RequestChannelClose_reasonChoice_reservationFailure ){
		AsnNull_Print( pObj->alter, pDepth+1, "reservationFailure" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestChannelClose Class
*/
/*ASNH245RequestChannelClose Constructor*/
HS_RESULT new_ASNH245RequestChannelClose(void *pObject)
{
	ASNH245RequestChannelClose *pObj = (ASNH245RequestChannelClose *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestChannelClose(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	new_ASNH245QOSCapability( &(pObj->m_qosCapability) );
	new_ASNH245RequestChannelClose_reason( &(pObj->m_reason) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245RequestChannelClose Destructor */
HS_RESULT delete_ASNH245RequestChannelClose(void *pObject)
{
	ASNH245RequestChannelClose *pObj = (ASNH245RequestChannelClose *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestChannelClose(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	delete_ASNH245QOSCapability( &(pObj->m_qosCapability) );
	delete_ASNH245RequestChannelClose_reason( &(pObj->m_reason) );
	return HS_OK;
}

/* ASNH245RequestChannelClose MakeMold */
HS_RESULT ASNH245RequestChannelClose_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestChannelClose *pObj = (ASNH245RequestChannelClose *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	ASNH245QOSCapability_MakeMold(&(pObj->m_qosCapability));
	return HS_OK;
}

/* ASNH245RequestChannelClose IncludeOptionalField */
HS_RESULT ASNH245RequestChannelClose_IncludeOptionField( void *pObject, ASNH245RequestChannelCloseOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245RequestChannelClose *pObj = (ASNH245RequestChannelClose *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245RequestChannelCloseOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245RequestChannelCloseOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245RequestChannelClose IsIncludeOptionalField */
BOOL ASNH245RequestChannelClose_IsIncludeOptionField( void *pObject, ASNH245RequestChannelCloseOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245RequestChannelClose *pObj = (ASNH245RequestChannelClose *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245RequestChannelCloseOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245RequestChannelCloseOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245RequestChannelClose Encode */
HS_RESULT ASNH245RequestChannelClose_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestChannelClose *pObj = (ASNH245RequestChannelClose *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245RequestChannelClose_IsIncludeOptionField( pObj, e_ASNH245RequestChannelCloseOptionMap_qosCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_qosCapability), ASNH245QOSCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245RequestChannelClose_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245RequestChannelClose_IsIncludeOptionField( pObj, e_ASNH245RequestChannelCloseOptionMap_reason ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_reason), ASNH245RequestChannelClose_reason_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245RequestChannelClose_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245RequestChannelClose Decode */
HS_RESULT ASNH245RequestChannelClose_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestChannelClose *pObj = (ASNH245RequestChannelClose *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelClose_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245RequestChannelClose_IsIncludeOptionField( pObj, e_ASNH245RequestChannelCloseOptionMap_qosCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_qosCapability), ASNH245QOSCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245RequestChannelClose_IsIncludeOptionField( pObj, e_ASNH245RequestChannelCloseOptionMap_reason ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_reason), ASNH245RequestChannelClose_reason_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelClose_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestChannelClose Print */
HS_RESULT ASNH245RequestChannelClose_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestChannelClose *pObj = (ASNH245RequestChannelClose *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestChannelClose_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245RequestChannelClose_IsIncludeOptionField( pObj, e_ASNH245RequestChannelCloseOptionMap_qosCapability ) )
		ASNH245QOSCapability_Print( &(pObj->m_qosCapability), pDepth+1, "qosCapability" );
	if( ASNH245RequestChannelClose_IsIncludeOptionField( pObj, e_ASNH245RequestChannelCloseOptionMap_reason ) )
		ASNH245RequestChannelClose_reason_Print( &(pObj->m_reason), pDepth+1, "reason" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexElement_type Struct
*/
/* ASNH245MultiplexElement_type Constructor */
HS_RESULT new_ASNH245MultiplexElement_type( void *pObject )
{
	ASNH245MultiplexElement_type *pObj = (ASNH245MultiplexElement_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexElement_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245MultiplexElement_typeChoice_logicalChannelNumber;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MultiplexElement_typeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MultiplexElement_type Destructor */
HS_RESULT delete_ASNH245MultiplexElement_type( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MultiplexElement_type *pObj = (ASNH245MultiplexElement_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexElement_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MultiplexElement_type_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexElement_type(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MultiplexElement_type SetChoice */
void* ASNH245MultiplexElement_type_SetChoice( void *pObject, ASNH245MultiplexElement_typeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MultiplexElement_type *pObj = (ASNH245MultiplexElement_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_type_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MultiplexElement_typeChoiceSizeExt ){
		if( pChoice > (ASNH245MultiplexElement_typeChoice)(e_ASNH245MultiplexElement_typeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_type_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MultiplexElement_type_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_type_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MultiplexElement_typeChoice_logicalChannelNumber ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultiplexElement_typeChoice_subElementList ){
		ASNH245MultiplexElement *tAlter = (ASNH245MultiplexElement *)HSMalloc( sizeof(ASNH245MultiplexElement) );
		new_ASNH245MultiplexElement(tAlter);
		ASNH245MultiplexElement_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_constrained,2,255,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH245MultiplexElement),ASNH245MultiplexElement_MakeMold,ASNH245MultiplexElement_Encode,ASNH245MultiplexElement_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH245MultiplexElement_Print,
#endif
			delete_ASNH245MultiplexElement );
		AsnSequenceOf_SetMold(aso,tmold);
		/* Sequence Of constraint */
		aso->constraint.type = e_constrained;
		aso->constraint.minValue = 2;
		aso->constraint.maxValue = 255;
		aso->extMinValue = 0;
		aso->extMaxValue = HS_ASN_MAX_CONSTRAINT;
		pObj->alter = aso;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_type_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MultiplexElement_type DeleteAlternation */
HS_RESULT ASNH245MultiplexElement_type_DeleteAlternation(void *pObject)
{
	ASNH245MultiplexElement_type *pObj = (ASNH245MultiplexElement_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_type_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MultiplexElement_typeChoice_logicalChannelNumber ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultiplexElement_typeChoice_subElementList ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_type_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MultiplexElement_type_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MultiplexElement_type Encode */
HS_RESULT ASNH245MultiplexElement_type_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MultiplexElement_type *pObj = (ASNH245MultiplexElement_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_type_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_type_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MultiplexElement_typeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MultiplexElement_typeChoice)(e_ASNH245MultiplexElement_typeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MultiplexElement_typeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MultiplexElement_typeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexElement_typeChoice_logicalChannelNumber ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexElement_typeChoice_subElementList ){
		if( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_type_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MultiplexElement_type Decode */
HS_RESULT ASNH245MultiplexElement_type_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MultiplexElement_type *pObj = (ASNH245MultiplexElement_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_type_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MultiplexElement_typeChoiceSize;
	}
	else
	{
		if( e_ASNH245MultiplexElement_typeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MultiplexElement_typeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MultiplexElement_typeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_type_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MultiplexElement_type_SetChoice( pObj, (ASNH245MultiplexElement_typeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_type_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexElement_typeChoice_logicalChannelNumber ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexElement_typeChoice_subElementList ){
		if( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_type_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexElement_type Print */
HS_RESULT ASNH245MultiplexElement_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexElement_type *pObj = (ASNH245MultiplexElement_type *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexElement_type_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexElement_typeChoice_logicalChannelNumber ){
		AsnInteger_Print( pObj->alter, pDepth+1, "logicalChannelNumber" );
	}
	else if ( pObj->choice == e_ASNH245MultiplexElement_typeChoice_subElementList ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "subElementList" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexElement_repeatCount Struct
*/
/* ASNH245MultiplexElement_repeatCount Constructor */
HS_RESULT new_ASNH245MultiplexElement_repeatCount( void *pObject )
{
	ASNH245MultiplexElement_repeatCount *pObj = (ASNH245MultiplexElement_repeatCount *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexElement_repeatCount(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245MultiplexElement_repeatCountChoice_finite;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MultiplexElement_repeatCountChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MultiplexElement_repeatCount Destructor */
HS_RESULT delete_ASNH245MultiplexElement_repeatCount( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MultiplexElement_repeatCount *pObj = (ASNH245MultiplexElement_repeatCount *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexElement_repeatCount(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MultiplexElement_repeatCount_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexElement_repeatCount(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MultiplexElement_repeatCount SetChoice */
void* ASNH245MultiplexElement_repeatCount_SetChoice( void *pObject, ASNH245MultiplexElement_repeatCountChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MultiplexElement_repeatCount *pObj = (ASNH245MultiplexElement_repeatCount *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MultiplexElement_repeatCountChoiceSizeExt ){
		if( pChoice > (ASNH245MultiplexElement_repeatCountChoice)(e_ASNH245MultiplexElement_repeatCountChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MultiplexElement_repeatCount_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MultiplexElement_repeatCountChoice_finite ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,1,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultiplexElement_repeatCountChoice_untilClosingFlag ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MultiplexElement_repeatCount DeleteAlternation */
HS_RESULT ASNH245MultiplexElement_repeatCount_DeleteAlternation(void *pObject)
{
	ASNH245MultiplexElement_repeatCount *pObj = (ASNH245MultiplexElement_repeatCount *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MultiplexElement_repeatCountChoice_finite ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultiplexElement_repeatCountChoice_untilClosingFlag ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MultiplexElement_repeatCount_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MultiplexElement_repeatCount Encode */
HS_RESULT ASNH245MultiplexElement_repeatCount_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MultiplexElement_repeatCount *pObj = (ASNH245MultiplexElement_repeatCount *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MultiplexElement_repeatCountChoiceSize )
		{
			if( pObj->choice > ((ASNH245MultiplexElement_repeatCountChoice)(e_ASNH245MultiplexElement_repeatCountChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MultiplexElement_repeatCountChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MultiplexElement_repeatCountChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexElement_repeatCountChoice_finite ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexElement_repeatCountChoice_untilClosingFlag ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MultiplexElement_repeatCount Decode */
HS_RESULT ASNH245MultiplexElement_repeatCount_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MultiplexElement_repeatCount *pObj = (ASNH245MultiplexElement_repeatCount *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MultiplexElement_repeatCountChoiceSize;
	}
	else
	{
		if( e_ASNH245MultiplexElement_repeatCountChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MultiplexElement_repeatCountChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MultiplexElement_repeatCountChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MultiplexElement_repeatCount_SetChoice( pObj, (ASNH245MultiplexElement_repeatCountChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexElement_repeatCountChoice_finite ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexElement_repeatCountChoice_untilClosingFlag ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexElement_repeatCount Print */
HS_RESULT ASNH245MultiplexElement_repeatCount_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexElement_repeatCount *pObj = (ASNH245MultiplexElement_repeatCount *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexElement_repeatCount_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexElement_repeatCountChoice_finite ){
		AsnInteger_Print( pObj->alter, pDepth+1, "finite" );
	}
	else if ( pObj->choice == e_ASNH245MultiplexElement_repeatCountChoice_untilClosingFlag ){
		AsnNull_Print( pObj->alter, pDepth+1, "untilClosingFlag" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexElement Class
*/
/*ASNH245MultiplexElement Constructor*/
HS_RESULT new_ASNH245MultiplexElement(void *pObject)
{
	ASNH245MultiplexElement *pObj = (ASNH245MultiplexElement *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexElement(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH245MultiplexElement_type( &(pObj->m_type) );
	new_ASNH245MultiplexElement_repeatCount( &(pObj->m_repeatCount) );

	return HS_OK;
}

/* ASNH245MultiplexElement Destructor */
HS_RESULT delete_ASNH245MultiplexElement(void *pObject)
{
	ASNH245MultiplexElement *pObj = (ASNH245MultiplexElement *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexElement(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MultiplexElement_type( &(pObj->m_type) );
	delete_ASNH245MultiplexElement_repeatCount( &(pObj->m_repeatCount) );
	return HS_OK;
}

/* ASNH245MultiplexElement MakeMold */
HS_RESULT ASNH245MultiplexElement_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultiplexElement *pObj = (ASNH245MultiplexElement *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MultiplexElement Encode */
HS_RESULT ASNH245MultiplexElement_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexElement *pObj = (ASNH245MultiplexElement *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245MultiplexElement_type_Encode( &(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultiplexElement_repeatCount_Encode( &(pObj->m_repeatCount),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultiplexElement Decode */
HS_RESULT ASNH245MultiplexElement_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexElement *pObj = (ASNH245MultiplexElement *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245MultiplexElement_type_Decode(&(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultiplexElement_repeatCount_Decode(&(pObj->m_repeatCount),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexElement_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexElement Print */
HS_RESULT ASNH245MultiplexElement_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexElement *pObj = (ASNH245MultiplexElement *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexElement_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MultiplexElement_type_Print( &(pObj->m_type), pDepth+1, "type" );
	ASNH245MultiplexElement_repeatCount_Print( &(pObj->m_repeatCount), pDepth+1, "repeatCount" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexEntryDescriptor Class
*/
/*ASNH245MultiplexEntryDescriptor Constructor*/
HS_RESULT new_ASNH245MultiplexEntryDescriptor(void *pObject)
{
	ASNH245MultiplexEntryDescriptor *pObj = (ASNH245MultiplexEntryDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexEntryDescriptor(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH245MultiplexTableEntryNumber( &(pObj->m_multiplexTableEntryNumber) );
	new_AsnSequenceOf( &(pObj->m_elementList), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245MultiplexEntryDescriptor Destructor */
HS_RESULT delete_ASNH245MultiplexEntryDescriptor(void *pObject)
{
	ASNH245MultiplexEntryDescriptor *pObj = (ASNH245MultiplexEntryDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexEntryDescriptor(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MultiplexTableEntryNumber( &(pObj->m_multiplexTableEntryNumber) );
	delete_AsnSequenceOf( &(pObj->m_elementList) );
	return HS_OK;
}

/* ASNH245MultiplexEntryDescriptor MakeMold */
HS_RESULT ASNH245MultiplexEntryDescriptor_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultiplexEntryDescriptor *pObj = (ASNH245MultiplexEntryDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245MultiplexTableEntryNumber_MakeMold(&(pObj->m_multiplexTableEntryNumber));
	{
	ASNH245MultiplexElement *tmold_elementList = (ASNH245MultiplexElement *)HSMalloc( sizeof(ASNH245MultiplexElement) );
	new_ASNH245MultiplexElement(tmold_elementList);
	ASNH245MultiplexElement_MakeMold(tmold_elementList);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_elementList,sizeof(ASNH245MultiplexElement),ASNH245MultiplexElement_MakeMold,ASNH245MultiplexElement_Encode,ASNH245MultiplexElement_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MultiplexElement_Print,
#endif
		delete_ASNH245MultiplexElement);
	AsnSequenceOf_SetMold( &(pObj->m_elementList), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_elementList.constraint.type = e_constrained;
	pObj->m_elementList.constraint.minValue = 1;
	pObj->m_elementList.constraint.maxValue = 256;
	pObj->m_elementList.extMinValue = 0;
	pObj->m_elementList.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245MultiplexEntryDescriptor IncludeOptionalField */
HS_RESULT ASNH245MultiplexEntryDescriptor_IncludeOptionField( void *pObject, ASNH245MultiplexEntryDescriptorOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245MultiplexEntryDescriptor *pObj = (ASNH245MultiplexEntryDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245MultiplexEntryDescriptorOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245MultiplexEntryDescriptor IsIncludeOptionalField */
BOOL ASNH245MultiplexEntryDescriptor_IsIncludeOptionField( void *pObject, ASNH245MultiplexEntryDescriptorOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245MultiplexEntryDescriptor *pObj = (ASNH245MultiplexEntryDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245MultiplexEntryDescriptorOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245MultiplexEntryDescriptor Encode */
HS_RESULT ASNH245MultiplexEntryDescriptor_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245MultiplexEntryDescriptor *pObj = (ASNH245MultiplexEntryDescriptor *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245MultiplexEntryDescriptorOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245MultiplexEntryDescriptorOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245MultiplexTableEntryNumber_Encode( &(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245MultiplexEntryDescriptor_IsIncludeOptionField( pObj, e_ASNH245MultiplexEntryDescriptorOptionMap_elementList ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_elementList),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245MultiplexEntryDescriptor Decode */
HS_RESULT ASNH245MultiplexEntryDescriptor_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245MultiplexEntryDescriptor *pObj = (ASNH245MultiplexEntryDescriptor *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245MultiplexEntryDescriptorOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245MultiplexEntryDescriptorOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245MultiplexTableEntryNumber_Decode(&(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245MultiplexEntryDescriptor_IsIncludeOptionField( pObj, e_ASNH245MultiplexEntryDescriptorOptionMap_elementList ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_elementList),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexEntryDescriptor Print */
HS_RESULT ASNH245MultiplexEntryDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexEntryDescriptor *pObj = (ASNH245MultiplexEntryDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexEntryDescriptor_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MultiplexTableEntryNumber_Print( &(pObj->m_multiplexTableEntryNumber), pDepth+1, "multiplexTableEntryNumber" );
	if( ASNH245MultiplexEntryDescriptor_IsIncludeOptionField( pObj, e_ASNH245MultiplexEntryDescriptorOptionMap_elementList ) )
		AsnSequenceOf_Print( &(pObj->m_elementList), pDepth+1, "elementList" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexEntrySend Class
*/
/*ASNH245MultiplexEntrySend Constructor*/
HS_RESULT new_ASNH245MultiplexEntrySend(void *pObject)
{
	ASNH245MultiplexEntrySend *pObj = (ASNH245MultiplexEntrySend *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexEntrySend(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	new_AsnSequenceOf( &(pObj->m_multiplexEntryDescriptors), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MultiplexEntrySend Destructor */
HS_RESULT delete_ASNH245MultiplexEntrySend(void *pObject)
{
	ASNH245MultiplexEntrySend *pObj = (ASNH245MultiplexEntrySend *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexEntrySend(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	delete_AsnSequenceOf( &(pObj->m_multiplexEntryDescriptors) );
	return HS_OK;
}

/* ASNH245MultiplexEntrySend MakeMold */
HS_RESULT ASNH245MultiplexEntrySend_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultiplexEntrySend *pObj = (ASNH245MultiplexEntrySend *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySend_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	{
	ASNH245MultiplexEntryDescriptor *tmold_multiplexEntryDescriptors = (ASNH245MultiplexEntryDescriptor *)HSMalloc( sizeof(ASNH245MultiplexEntryDescriptor) );
	new_ASNH245MultiplexEntryDescriptor(tmold_multiplexEntryDescriptors);
	ASNH245MultiplexEntryDescriptor_MakeMold(tmold_multiplexEntryDescriptors);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_multiplexEntryDescriptors,sizeof(ASNH245MultiplexEntryDescriptor),ASNH245MultiplexEntryDescriptor_MakeMold,ASNH245MultiplexEntryDescriptor_Encode,ASNH245MultiplexEntryDescriptor_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MultiplexEntryDescriptor_Print,
#endif
		delete_ASNH245MultiplexEntryDescriptor);
	AsnSequenceOf_SetMold( &(pObj->m_multiplexEntryDescriptors), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_multiplexEntryDescriptors.constraint.type = e_constrained;
	pObj->m_multiplexEntryDescriptors.constraint.minValue = 1;
	pObj->m_multiplexEntryDescriptors.constraint.maxValue = 15;
	pObj->m_multiplexEntryDescriptors.extMinValue = 0;
	pObj->m_multiplexEntryDescriptors.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245MultiplexEntrySend Encode */
HS_RESULT ASNH245MultiplexEntrySend_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntrySend *pObj = (ASNH245MultiplexEntrySend *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySend_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySend_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_multiplexEntryDescriptors),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySend_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultiplexEntrySend Decode */
HS_RESULT ASNH245MultiplexEntrySend_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntrySend *pObj = (ASNH245MultiplexEntrySend *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySend_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySend_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_multiplexEntryDescriptors),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySend_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexEntrySend Print */
HS_RESULT ASNH245MultiplexEntrySend_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexEntrySend *pObj = (ASNH245MultiplexEntrySend *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexEntrySend_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	AsnSequenceOf_Print( &(pObj->m_multiplexEntryDescriptors), pDepth+1, "multiplexEntryDescriptors" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestMultiplexEntry Class
*/
/*ASNH245RequestMultiplexEntry Constructor*/
HS_RESULT new_ASNH245RequestMultiplexEntry(void *pObject)
{
	ASNH245RequestMultiplexEntry *pObj = (ASNH245RequestMultiplexEntry *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestMultiplexEntry(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_entryNumbers), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245RequestMultiplexEntry Destructor */
HS_RESULT delete_ASNH245RequestMultiplexEntry(void *pObject)
{
	ASNH245RequestMultiplexEntry *pObj = (ASNH245RequestMultiplexEntry *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMultiplexEntry(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_entryNumbers) );
	return HS_OK;
}

/* ASNH245RequestMultiplexEntry MakeMold */
HS_RESULT ASNH245RequestMultiplexEntry_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestMultiplexEntry *pObj = (ASNH245RequestMultiplexEntry *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntry_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245MultiplexTableEntryNumber *tmold_entryNumbers = (ASNH245MultiplexTableEntryNumber *)HSMalloc( sizeof(ASNH245MultiplexTableEntryNumber) );
	new_ASNH245MultiplexTableEntryNumber(tmold_entryNumbers);
	ASNH245MultiplexTableEntryNumber_MakeMold(tmold_entryNumbers);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_entryNumbers,sizeof(ASNH245MultiplexTableEntryNumber),ASNH245MultiplexTableEntryNumber_MakeMold,ASNH245MultiplexTableEntryNumber_Encode,ASNH245MultiplexTableEntryNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MultiplexTableEntryNumber_Print,
#endif
		delete_ASNH245MultiplexTableEntryNumber);
	AsnSequenceOf_SetMold( &(pObj->m_entryNumbers), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_entryNumbers.constraint.type = e_constrained;
	pObj->m_entryNumbers.constraint.minValue = 1;
	pObj->m_entryNumbers.constraint.maxValue = 15;
	pObj->m_entryNumbers.extMinValue = 0;
	pObj->m_entryNumbers.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245RequestMultiplexEntry Encode */
HS_RESULT ASNH245RequestMultiplexEntry_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntry *pObj = (ASNH245RequestMultiplexEntry *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntry_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_entryNumbers),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestMultiplexEntry Decode */
HS_RESULT ASNH245RequestMultiplexEntry_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntry *pObj = (ASNH245RequestMultiplexEntry *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntry_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_entryNumbers),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestMultiplexEntry Print */
HS_RESULT ASNH245RequestMultiplexEntry_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestMultiplexEntry *pObj = (ASNH245RequestMultiplexEntry *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestMultiplexEntry_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSequenceOf_Print( &(pObj->m_entryNumbers), pDepth+1, "entryNumbers" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestMode Class
*/
/*ASNH245RequestMode Constructor*/
HS_RESULT new_ASNH245RequestMode(void *pObject)
{
	ASNH245RequestMode *pObj = (ASNH245RequestMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	new_AsnSequenceOf( &(pObj->m_requestedModes), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245RequestMode Destructor */
HS_RESULT delete_ASNH245RequestMode(void *pObject)
{
	ASNH245RequestMode *pObj = (ASNH245RequestMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	delete_AsnSequenceOf( &(pObj->m_requestedModes) );
	return HS_OK;
}

/* ASNH245RequestMode MakeMold */
HS_RESULT ASNH245RequestMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestMode *pObj = (ASNH245RequestMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	{
	ASNH245ModeDescription *tmold_requestedModes = (ASNH245ModeDescription *)HSMalloc( sizeof(ASNH245ModeDescription) );
	new_ASNH245ModeDescription(tmold_requestedModes);
	ASNH245ModeDescription_MakeMold(tmold_requestedModes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_requestedModes,sizeof(ASNH245ModeDescription),ASNH245ModeDescription_MakeMold,ASNH245ModeDescription_Encode,ASNH245ModeDescription_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245ModeDescription_Print,
#endif
		delete_ASNH245ModeDescription);
	AsnSequenceOf_SetMold( &(pObj->m_requestedModes), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_requestedModes.constraint.type = e_constrained;
	pObj->m_requestedModes.constraint.minValue = 1;
	pObj->m_requestedModes.constraint.maxValue = 256;
	pObj->m_requestedModes.extMinValue = 0;
	pObj->m_requestedModes.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245RequestMode Encode */
HS_RESULT ASNH245RequestMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMode *pObj = (ASNH245RequestMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_requestedModes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestMode Decode */
HS_RESULT ASNH245RequestMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMode *pObj = (ASNH245RequestMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_requestedModes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestMode Print */
HS_RESULT ASNH245RequestMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestMode *pObj = (ASNH245RequestMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	AsnSequenceOf_Print( &(pObj->m_requestedModes), pDepth+1, "requestedModes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RoundTripDelayRequest Class
*/
/*ASNH245RoundTripDelayRequest Constructor*/
HS_RESULT new_ASNH245RoundTripDelayRequest(void *pObject)
{
	ASNH245RoundTripDelayRequest *pObj = (ASNH245RoundTripDelayRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RoundTripDelayRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );

	return HS_OK;
}

/* ASNH245RoundTripDelayRequest Destructor */
HS_RESULT delete_ASNH245RoundTripDelayRequest(void *pObject)
{
	ASNH245RoundTripDelayRequest *pObj = (ASNH245RoundTripDelayRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RoundTripDelayRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	return HS_OK;
}

/* ASNH245RoundTripDelayRequest MakeMold */
HS_RESULT ASNH245RoundTripDelayRequest_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RoundTripDelayRequest *pObj = (ASNH245RoundTripDelayRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayRequest_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	return HS_OK;
}

/* ASNH245RoundTripDelayRequest Encode */
HS_RESULT ASNH245RoundTripDelayRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RoundTripDelayRequest *pObj = (ASNH245RoundTripDelayRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RoundTripDelayRequest Decode */
HS_RESULT ASNH245RoundTripDelayRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RoundTripDelayRequest *pObj = (ASNH245RoundTripDelayRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RoundTripDelayRequest Print */
HS_RESULT ASNH245RoundTripDelayRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RoundTripDelayRequest *pObj = (ASNH245RoundTripDelayRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RoundTripDelayRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MaintenanceLoopRequest_type Struct
*/
/* ASNH245MaintenanceLoopRequest_type Constructor */
HS_RESULT new_ASNH245MaintenanceLoopRequest_type( void *pObject )
{
	ASNH245MaintenanceLoopRequest_type *pObj = (ASNH245MaintenanceLoopRequest_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MaintenanceLoopRequest_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MaintenanceLoopRequest_typeChoice_systemLoop;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MaintenanceLoopRequest_typeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MaintenanceLoopRequest_type Destructor */
HS_RESULT delete_ASNH245MaintenanceLoopRequest_type( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MaintenanceLoopRequest_type *pObj = (ASNH245MaintenanceLoopRequest_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopRequest_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MaintenanceLoopRequest_type_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopRequest_type(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MaintenanceLoopRequest_type SetChoice */
void* ASNH245MaintenanceLoopRequest_type_SetChoice( void *pObject, ASNH245MaintenanceLoopRequest_typeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MaintenanceLoopRequest_type *pObj = (ASNH245MaintenanceLoopRequest_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MaintenanceLoopRequest_typeChoiceSizeExt ){
		if( pChoice > (ASNH245MaintenanceLoopRequest_typeChoice)(e_ASNH245MaintenanceLoopRequest_typeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MaintenanceLoopRequest_type_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MaintenanceLoopRequest_typeChoice_systemLoop ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MaintenanceLoopRequest_typeChoice_mediaLoop ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MaintenanceLoopRequest_typeChoice_logicalChannelLoop ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MaintenanceLoopRequest_type DeleteAlternation */
HS_RESULT ASNH245MaintenanceLoopRequest_type_DeleteAlternation(void *pObject)
{
	ASNH245MaintenanceLoopRequest_type *pObj = (ASNH245MaintenanceLoopRequest_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_systemLoop ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_mediaLoop ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_logicalChannelLoop ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MaintenanceLoopRequest_type_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MaintenanceLoopRequest_type Encode */
HS_RESULT ASNH245MaintenanceLoopRequest_type_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MaintenanceLoopRequest_type *pObj = (ASNH245MaintenanceLoopRequest_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MaintenanceLoopRequest_typeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MaintenanceLoopRequest_typeChoice)(e_ASNH245MaintenanceLoopRequest_typeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MaintenanceLoopRequest_typeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MaintenanceLoopRequest_typeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_systemLoop ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_mediaLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_logicalChannelLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopRequest_type Decode */
HS_RESULT ASNH245MaintenanceLoopRequest_type_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MaintenanceLoopRequest_type *pObj = (ASNH245MaintenanceLoopRequest_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MaintenanceLoopRequest_typeChoiceSize;
	}
	else
	{
		if( e_ASNH245MaintenanceLoopRequest_typeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MaintenanceLoopRequest_typeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MaintenanceLoopRequest_typeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MaintenanceLoopRequest_type_SetChoice( pObj, (ASNH245MaintenanceLoopRequest_typeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_systemLoop ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_mediaLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_logicalChannelLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MaintenanceLoopRequest_type Print */
HS_RESULT ASNH245MaintenanceLoopRequest_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MaintenanceLoopRequest_type *pObj = (ASNH245MaintenanceLoopRequest_type *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_type_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_systemLoop ){
		AsnNull_Print( pObj->alter, pDepth+1, "systemLoop" );
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_mediaLoop ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "mediaLoop" );
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopRequest_typeChoice_logicalChannelLoop ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "logicalChannelLoop" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MaintenanceLoopRequest Class
*/
/*ASNH245MaintenanceLoopRequest Constructor*/
HS_RESULT new_ASNH245MaintenanceLoopRequest(void *pObject)
{
	ASNH245MaintenanceLoopRequest *pObj = (ASNH245MaintenanceLoopRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MaintenanceLoopRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245MaintenanceLoopRequest_type( &(pObj->m_type) );

	return HS_OK;
}

/* ASNH245MaintenanceLoopRequest Destructor */
HS_RESULT delete_ASNH245MaintenanceLoopRequest(void *pObject)
{
	ASNH245MaintenanceLoopRequest *pObj = (ASNH245MaintenanceLoopRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MaintenanceLoopRequest_type( &(pObj->m_type) );
	return HS_OK;
}

/* ASNH245MaintenanceLoopRequest MakeMold */
HS_RESULT ASNH245MaintenanceLoopRequest_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MaintenanceLoopRequest *pObj = (ASNH245MaintenanceLoopRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopRequest Encode */
HS_RESULT ASNH245MaintenanceLoopRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MaintenanceLoopRequest *pObj = (ASNH245MaintenanceLoopRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245MaintenanceLoopRequest_type_Encode( &(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopRequest Decode */
HS_RESULT ASNH245MaintenanceLoopRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MaintenanceLoopRequest *pObj = (ASNH245MaintenanceLoopRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245MaintenanceLoopRequest_type_Decode(&(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MaintenanceLoopRequest Print */
HS_RESULT ASNH245MaintenanceLoopRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MaintenanceLoopRequest *pObj = (ASNH245MaintenanceLoopRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MaintenanceLoopRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MaintenanceLoopRequest_type_Print( &(pObj->m_type), pDepth+1, "type" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CommunicationModeRequest Class
*/
/*ASNH245CommunicationModeRequest Constructor*/
HS_RESULT new_ASNH245CommunicationModeRequest(void *pObject)
{
	ASNH245CommunicationModeRequest *pObj = (ASNH245CommunicationModeRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CommunicationModeRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;

	return HS_OK;
}

/* ASNH245CommunicationModeRequest Destructor */
HS_RESULT delete_ASNH245CommunicationModeRequest(void *pObject)
{
	ASNH245CommunicationModeRequest *pObj = (ASNH245CommunicationModeRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CommunicationModeRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return HS_OK;
}

/* ASNH245CommunicationModeRequest MakeMold */
HS_RESULT ASNH245CommunicationModeRequest_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CommunicationModeRequest *pObj = (ASNH245CommunicationModeRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeRequest_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245CommunicationModeRequest Encode */
HS_RESULT ASNH245CommunicationModeRequest_Encode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245CommunicationModeRequest *pObj = (ASNH245CommunicationModeRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );


	return HS_OK;
}

/* ASNH245CommunicationModeRequest Decode */
HS_RESULT ASNH245CommunicationModeRequest_Decode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245CommunicationModeRequest *pObj = (ASNH245CommunicationModeRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CommunicationModeRequest Print */
HS_RESULT ASNH245CommunicationModeRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CommunicationModeRequest *pObj = (ASNH245CommunicationModeRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CommunicationModeRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ConferenceRequest_requestTerminalCertificate Class
*/
/*ASNH245ConferenceRequest_requestTerminalCertificate Constructor*/
HS_RESULT new_ASNH245ConferenceRequest_requestTerminalCertificate(void *pObject)
{
	ASNH245ConferenceRequest_requestTerminalCertificate *pObj = (ASNH245ConferenceRequest_requestTerminalCertificate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ConferenceRequest_requestTerminalCertificate(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245TerminalLabel( &(pObj->m_terminalLabel) );
	new_ASNH245CertSelectionCriteria( &(pObj->m_certSelectionCriteria) );
	new_AsnInteger( &(pObj->m_sRandom), e_constrained, 1, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245ConferenceRequest_requestTerminalCertificate Destructor */
HS_RESULT delete_ASNH245ConferenceRequest_requestTerminalCertificate(void *pObject)
{
	ASNH245ConferenceRequest_requestTerminalCertificate *pObj = (ASNH245ConferenceRequest_requestTerminalCertificate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConferenceRequest_requestTerminalCertificate(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245TerminalLabel( &(pObj->m_terminalLabel) );
	delete_ASNH245CertSelectionCriteria( &(pObj->m_certSelectionCriteria) );
	delete_AsnInteger( &(pObj->m_sRandom) );
	return HS_OK;
}

/* ASNH245ConferenceRequest_requestTerminalCertificate MakeMold */
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245ConferenceRequest_requestTerminalCertificate *pObj = (ASNH245ConferenceRequest_requestTerminalCertificate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245TerminalLabel_MakeMold(&(pObj->m_terminalLabel));
	ASNH245CertSelectionCriteria_MakeMold(&(pObj->m_certSelectionCriteria));
	return HS_OK;
}

/* ASNH245ConferenceRequest_requestTerminalCertificate IncludeOptionalField */
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_IncludeOptionField( void *pObject, ASNH245ConferenceRequest_requestTerminalCertificateOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245ConferenceRequest_requestTerminalCertificate *pObj = (ASNH245ConferenceRequest_requestTerminalCertificate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245ConferenceRequest_requestTerminalCertificate IsIncludeOptionalField */
BOOL ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( void *pObject, ASNH245ConferenceRequest_requestTerminalCertificateOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245ConferenceRequest_requestTerminalCertificate *pObj = (ASNH245ConferenceRequest_requestTerminalCertificate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245ConferenceRequest_requestTerminalCertificate Encode */
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245ConferenceRequest_requestTerminalCertificate *pObj = (ASNH245ConferenceRequest_requestTerminalCertificate *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( pObj, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_terminalLabel ) ){
		if( (tRet=ASNH245TerminalLabel_Encode( &(pObj->m_terminalLabel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( pObj, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_certSelectionCriteria ) ){
		if( (tRet=ASNH245CertSelectionCriteria_Encode( &(pObj->m_certSelectionCriteria),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( pObj, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_sRandom ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_sRandom),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245ConferenceRequest_requestTerminalCertificate Decode */
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245ConferenceRequest_requestTerminalCertificate *pObj = (ASNH245ConferenceRequest_requestTerminalCertificate *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( pObj, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_terminalLabel ) ){
		if( (tRet=ASNH245TerminalLabel_Decode(&(pObj->m_terminalLabel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( pObj, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_certSelectionCriteria ) ){
		if( (tRet=ASNH245CertSelectionCriteria_Decode(&(pObj->m_certSelectionCriteria),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( pObj, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_sRandom ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_sRandom),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ConferenceRequest_requestTerminalCertificate Print */
HS_RESULT ASNH245ConferenceRequest_requestTerminalCertificate_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ConferenceRequest_requestTerminalCertificate *pObj = (ASNH245ConferenceRequest_requestTerminalCertificate *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ConferenceRequest_requestTerminalCertificate_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( pObj, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_terminalLabel ) )
		ASNH245TerminalLabel_Print( &(pObj->m_terminalLabel), pDepth+1, "terminalLabel" );
	if( ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( pObj, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_certSelectionCriteria ) )
		ASNH245CertSelectionCriteria_Print( &(pObj->m_certSelectionCriteria), pDepth+1, "certSelectionCriteria" );
	if( ASNH245ConferenceRequest_requestTerminalCertificate_IsIncludeOptionField( pObj, e_ASNH245ConferenceRequest_requestTerminalCertificateOptionMap_sRandom ) )
		AsnInteger_Print( &(pObj->m_sRandom), pDepth+1, "sRandom" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RemoteMCRequest Struct
*/
/* ASNH245RemoteMCRequest Constructor */
HS_RESULT new_ASNH245RemoteMCRequest( void *pObject )
{
	ASNH245RemoteMCRequest *pObj = (ASNH245RemoteMCRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RemoteMCRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RemoteMCRequestChoice_masterActivate;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RemoteMCRequestChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RemoteMCRequest Destructor */
HS_RESULT delete_ASNH245RemoteMCRequest( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RemoteMCRequest *pObj = (ASNH245RemoteMCRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RemoteMCRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RemoteMCRequest_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RemoteMCRequest(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RemoteMCRequest SetChoice */
void* ASNH245RemoteMCRequest_SetChoice( void *pObject, ASNH245RemoteMCRequestChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RemoteMCRequest *pObj = (ASNH245RemoteMCRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RemoteMCRequest_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RemoteMCRequestChoiceSizeExt ){
		if( pChoice > (ASNH245RemoteMCRequestChoice)(e_ASNH245RemoteMCRequestChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RemoteMCRequest_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RemoteMCRequestChoice_masterActivate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RemoteMCRequestChoice_slaveActivate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RemoteMCRequestChoice_deActivate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RemoteMCRequest_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RemoteMCRequest DeleteAlternation */
HS_RESULT ASNH245RemoteMCRequest_DeleteAlternation(void *pObject)
{
	ASNH245RemoteMCRequest *pObj = (ASNH245RemoteMCRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RemoteMCRequest_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RemoteMCRequestChoice_masterActivate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RemoteMCRequestChoice_slaveActivate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RemoteMCRequestChoice_deActivate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RemoteMCRequest_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RemoteMCRequest Encode */
HS_RESULT ASNH245RemoteMCRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RemoteMCRequest *pObj = (ASNH245RemoteMCRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RemoteMCRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RemoteMCRequest_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RemoteMCRequestChoiceSize )
		{
			if( pObj->choice > ((ASNH245RemoteMCRequestChoice)(e_ASNH245RemoteMCRequestChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RemoteMCRequestChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RemoteMCRequestChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RemoteMCRequestChoice_masterActivate ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RemoteMCRequestChoice_slaveActivate ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RemoteMCRequestChoice_deActivate ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RemoteMCRequest_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RemoteMCRequest Decode */
HS_RESULT ASNH245RemoteMCRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RemoteMCRequest *pObj = (ASNH245RemoteMCRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RemoteMCRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RemoteMCRequestChoiceSize;
	}
	else
	{
		if( e_ASNH245RemoteMCRequestChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RemoteMCRequestChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RemoteMCRequestChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RemoteMCRequest_SetChoice( pObj, (ASNH245RemoteMCRequestChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RemoteMCRequest_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RemoteMCRequestChoice_masterActivate ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RemoteMCRequestChoice_slaveActivate ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RemoteMCRequestChoice_deActivate ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RemoteMCRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RemoteMCRequest_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RemoteMCRequest Print */
HS_RESULT ASNH245RemoteMCRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RemoteMCRequest *pObj = (ASNH245RemoteMCRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RemoteMCRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RemoteMCRequestChoice_masterActivate ){
		AsnNull_Print( pObj->alter, pDepth+1, "masterActivate" );
	}
	else if ( pObj->choice == e_ASNH245RemoteMCRequestChoice_slaveActivate ){
		AsnNull_Print( pObj->alter, pDepth+1, "slaveActivate" );
	}
	else if ( pObj->choice == e_ASNH245RemoteMCRequestChoice_deActivate ){
		AsnNull_Print( pObj->alter, pDepth+1, "deActivate" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ConferenceRequest Struct
*/
/* ASNH245ConferenceRequest Constructor */
HS_RESULT new_ASNH245ConferenceRequest( void *pObject )
{
	ASNH245ConferenceRequest *pObj = (ASNH245ConferenceRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ConferenceRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245ConferenceRequestChoice_terminalListRequest;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245ConferenceRequestChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245ConferenceRequest Destructor */
HS_RESULT delete_ASNH245ConferenceRequest( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245ConferenceRequest *pObj = (ASNH245ConferenceRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConferenceRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245ConferenceRequest_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConferenceRequest(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245ConferenceRequest SetChoice */
void* ASNH245ConferenceRequest_SetChoice( void *pObject, ASNH245ConferenceRequestChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245ConferenceRequest *pObj = (ASNH245ConferenceRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245ConferenceRequestChoiceSizeExt ){
		if( pChoice > (ASNH245ConferenceRequestChoice)(e_ASNH245ConferenceRequestChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245ConferenceRequest_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245ConferenceRequestChoice_terminalListRequest ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_makeMeChair ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_cancelMakeMeChair ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_dropTerminal ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_requestTerminalID ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_enterH243Password ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_enterH243TerminalID ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_enterH243ConferenceID ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_enterExtensionAddress ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_requestChairTokenOwner ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_requestTerminalCertificate ){
		ASNH245ConferenceRequest_requestTerminalCertificate *tAlter = (ASNH245ConferenceRequest_requestTerminalCertificate *)HSMalloc( sizeof(ASNH245ConferenceRequest_requestTerminalCertificate) );
		new_ASNH245ConferenceRequest_requestTerminalCertificate(tAlter);
		ASNH245ConferenceRequest_requestTerminalCertificate_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_broadcastMyLogicalChannel ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_makeTerminalBroadcaster ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_sendThisSource ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_requestAllTerminalIDs ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceRequestChoice_remoteMCRequest ){
		ASNH245RemoteMCRequest *tAlter = (ASNH245RemoteMCRequest *)HSMalloc( sizeof(ASNH245RemoteMCRequest) );
		new_ASNH245RemoteMCRequest(tAlter);
		ASNH245RemoteMCRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245ConferenceRequest DeleteAlternation */
HS_RESULT ASNH245ConferenceRequest_DeleteAlternation(void *pObject)
{
	ASNH245ConferenceRequest *pObj = (ASNH245ConferenceRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245ConferenceRequestChoice_terminalListRequest ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_makeMeChair ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_cancelMakeMeChair ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_dropTerminal ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestTerminalID ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243Password ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243TerminalID ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243ConferenceID ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterExtensionAddress ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestChairTokenOwner ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestTerminalCertificate ){
			delete_ASNH245ConferenceRequest_requestTerminalCertificate(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_broadcastMyLogicalChannel ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_makeTerminalBroadcaster ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_sendThisSource ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestAllTerminalIDs ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_remoteMCRequest ){
			delete_ASNH245RemoteMCRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245ConferenceRequest_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245ConferenceRequest Encode */
HS_RESULT ASNH245ConferenceRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245ConferenceRequest *pObj = (ASNH245ConferenceRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245ConferenceRequestChoiceSize )
		{
			if( pObj->choice > ((ASNH245ConferenceRequestChoice)(e_ASNH245ConferenceRequestChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245ConferenceRequestChoiceSize)) )
	}
	else
	{
		if( e_ASNH245ConferenceRequestChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ConferenceRequestChoice_terminalListRequest ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_makeMeChair ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_cancelMakeMeChair ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_dropTerminal ){
		if( (tRet=ASNH245TerminalLabel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestTerminalID ){
		if( (tRet=ASNH245TerminalLabel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243Password ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243TerminalID ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243ConferenceID ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterExtensionAddress ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestChairTokenOwner ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestTerminalCertificate ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245ConferenceRequest_requestTerminalCertificate_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_broadcastMyLogicalChannel ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245LogicalChannelNumber_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_makeTerminalBroadcaster ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245TerminalLabel_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_sendThisSource ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245TerminalLabel_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestAllTerminalIDs ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_remoteMCRequest ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245RemoteMCRequest_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245ConferenceRequest Decode */
HS_RESULT ASNH245ConferenceRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245ConferenceRequest *pObj = (ASNH245ConferenceRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245ConferenceRequestChoiceSize;
	}
	else
	{
		if( e_ASNH245ConferenceRequestChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245ConferenceRequestChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245ConferenceRequestChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245ConferenceRequest_SetChoice( pObj, (ASNH245ConferenceRequestChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ConferenceRequestChoice_terminalListRequest ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_makeMeChair ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_cancelMakeMeChair ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_dropTerminal ){
		if( (tRet=ASNH245TerminalLabel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestTerminalID ){
		if( (tRet=ASNH245TerminalLabel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243Password ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243TerminalID ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243ConferenceID ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterExtensionAddress ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestChairTokenOwner ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestTerminalCertificate ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245ConferenceRequest_requestTerminalCertificate_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_broadcastMyLogicalChannel ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245LogicalChannelNumber_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_makeTerminalBroadcaster ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245TerminalLabel_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_sendThisSource ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245TerminalLabel_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestAllTerminalIDs ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_remoteMCRequest ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245RemoteMCRequest_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceRequest_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ConferenceRequest Print */
HS_RESULT ASNH245ConferenceRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ConferenceRequest *pObj = (ASNH245ConferenceRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ConferenceRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ConferenceRequestChoice_terminalListRequest ){
		AsnNull_Print( pObj->alter, pDepth+1, "terminalListRequest" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_makeMeChair ){
		AsnNull_Print( pObj->alter, pDepth+1, "makeMeChair" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_cancelMakeMeChair ){
		AsnNull_Print( pObj->alter, pDepth+1, "cancelMakeMeChair" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_dropTerminal ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "dropTerminal" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestTerminalID ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "requestTerminalID" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243Password ){
		AsnNull_Print( pObj->alter, pDepth+1, "enterH243Password" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243TerminalID ){
		AsnNull_Print( pObj->alter, pDepth+1, "enterH243TerminalID" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterH243ConferenceID ){
		AsnNull_Print( pObj->alter, pDepth+1, "enterH243ConferenceID" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_enterExtensionAddress ){
		AsnNull_Print( pObj->alter, pDepth+1, "enterExtensionAddress" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestChairTokenOwner ){
		AsnNull_Print( pObj->alter, pDepth+1, "requestChairTokenOwner" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestTerminalCertificate ){
		ASNH245ConferenceRequest_requestTerminalCertificate_Print( pObj->alter, pDepth+1, "requestTerminalCertificate" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_broadcastMyLogicalChannel ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "broadcastMyLogicalChannel" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_makeTerminalBroadcaster ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "makeTerminalBroadcaster" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_sendThisSource ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "sendThisSource" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_requestAllTerminalIDs ){
		AsnNull_Print( pObj->alter, pDepth+1, "requestAllTerminalIDs" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceRequestChoice_remoteMCRequest ){
		ASNH245RemoteMCRequest_Print( pObj->alter, pDepth+1, "remoteMCRequest" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultilinkRequest_callInformation Class
*/
/*ASNH245MultilinkRequest_callInformation Constructor*/
HS_RESULT new_ASNH245MultilinkRequest_callInformation(void *pObject)
{
	ASNH245MultilinkRequest_callInformation *pObj = (ASNH245MultilinkRequest_callInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultilinkRequest_callInformation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_maxNumberOfAdditionalConnections), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MultilinkRequest_callInformation Destructor */
HS_RESULT delete_ASNH245MultilinkRequest_callInformation(void *pObject)
{
	ASNH245MultilinkRequest_callInformation *pObj = (ASNH245MultilinkRequest_callInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkRequest_callInformation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_maxNumberOfAdditionalConnections) );
	return HS_OK;
}

/* ASNH245MultilinkRequest_callInformation MakeMold */
HS_RESULT ASNH245MultilinkRequest_callInformation_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultilinkRequest_callInformation *pObj = (ASNH245MultilinkRequest_callInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_callInformation_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MultilinkRequest_callInformation Encode */
HS_RESULT ASNH245MultilinkRequest_callInformation_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkRequest_callInformation *pObj = (ASNH245MultilinkRequest_callInformation *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_callInformation_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_maxNumberOfAdditionalConnections),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_callInformation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultilinkRequest_callInformation Decode */
HS_RESULT ASNH245MultilinkRequest_callInformation_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkRequest_callInformation *pObj = (ASNH245MultilinkRequest_callInformation *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_callInformation_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxNumberOfAdditionalConnections),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_callInformation_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultilinkRequest_callInformation Print */
HS_RESULT ASNH245MultilinkRequest_callInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultilinkRequest_callInformation *pObj = (ASNH245MultilinkRequest_callInformation *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultilinkRequest_callInformation_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_maxNumberOfAdditionalConnections), pDepth+1, "maxNumberOfAdditionalConnections" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DialingInformationNetworkType Struct
*/
/* ASNH245DialingInformationNetworkType Constructor */
HS_RESULT new_ASNH245DialingInformationNetworkType( void *pObject )
{
	ASNH245DialingInformationNetworkType *pObj = (ASNH245DialingInformationNetworkType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DialingInformationNetworkType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245DialingInformationNetworkTypeChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245DialingInformationNetworkTypeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245DialingInformationNetworkType Destructor */
HS_RESULT delete_ASNH245DialingInformationNetworkType( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245DialingInformationNetworkType *pObj = (ASNH245DialingInformationNetworkType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DialingInformationNetworkType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245DialingInformationNetworkType_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DialingInformationNetworkType(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245DialingInformationNetworkType SetChoice */
void* ASNH245DialingInformationNetworkType_SetChoice( void *pObject, ASNH245DialingInformationNetworkTypeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245DialingInformationNetworkType *pObj = (ASNH245DialingInformationNetworkType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245DialingInformationNetworkTypeChoiceSizeExt ){
		if( pChoice > (ASNH245DialingInformationNetworkTypeChoice)(e_ASNH245DialingInformationNetworkTypeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245DialingInformationNetworkType_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245DialingInformationNetworkTypeChoice_nonStandard ){
		ASNH245NonStandardMessage *tAlter = (ASNH245NonStandardMessage *)HSMalloc( sizeof(ASNH245NonStandardMessage) );
		new_ASNH245NonStandardMessage(tAlter);
		ASNH245NonStandardMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DialingInformationNetworkTypeChoice_n_isdn ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DialingInformationNetworkTypeChoice_gstn ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245DialingInformationNetworkTypeChoice_mobile ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245DialingInformationNetworkType DeleteAlternation */
HS_RESULT ASNH245DialingInformationNetworkType_DeleteAlternation(void *pObject)
{
	ASNH245DialingInformationNetworkType *pObj = (ASNH245DialingInformationNetworkType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_nonStandard ){
			delete_ASNH245NonStandardMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_n_isdn ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_gstn ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_mobile ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245DialingInformationNetworkType_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245DialingInformationNetworkType Encode */
HS_RESULT ASNH245DialingInformationNetworkType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245DialingInformationNetworkType *pObj = (ASNH245DialingInformationNetworkType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245DialingInformationNetworkTypeChoiceSize )
		{
			if( pObj->choice > ((ASNH245DialingInformationNetworkTypeChoice)(e_ASNH245DialingInformationNetworkTypeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245DialingInformationNetworkTypeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245DialingInformationNetworkTypeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_n_isdn ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_gstn ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_mobile ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245DialingInformationNetworkType Decode */
HS_RESULT ASNH245DialingInformationNetworkType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245DialingInformationNetworkType *pObj = (ASNH245DialingInformationNetworkType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245DialingInformationNetworkTypeChoiceSize;
	}
	else
	{
		if( e_ASNH245DialingInformationNetworkTypeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245DialingInformationNetworkTypeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245DialingInformationNetworkTypeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245DialingInformationNetworkType_SetChoice( pObj, (ASNH245DialingInformationNetworkTypeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_n_isdn ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_gstn ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_mobile ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DialingInformationNetworkType Print */
HS_RESULT ASNH245DialingInformationNetworkType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DialingInformationNetworkType *pObj = (ASNH245DialingInformationNetworkType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DialingInformationNetworkType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_nonStandard ){
		ASNH245NonStandardMessage_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_n_isdn ){
		AsnNull_Print( pObj->alter, pDepth+1, "n_isdn" );
	}
	else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_gstn ){
		AsnNull_Print( pObj->alter, pDepth+1, "gstn" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DialingInformationNetworkTypeChoice_mobile ){
		AsnNull_Print( pObj->alter, pDepth+1, "mobile" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DialingInformationNumber Class
*/
/*ASNH245DialingInformationNumber Constructor*/
HS_RESULT new_ASNH245DialingInformationNumber(void *pObject)
{
	ASNH245DialingInformationNumber *pObj = (ASNH245DialingInformationNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DialingInformationNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSingleString( &(pObj->m_networkAddress), e_asnTagNumericString, e_constrained, 0, 40, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSingleString( &(pObj->m_subAddress), e_asnTagIA5String, e_constrained, 1, 40, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_networkType), e_constrained,1,255,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245DialingInformationNumber Destructor */
HS_RESULT delete_ASNH245DialingInformationNumber(void *pObject)
{
	ASNH245DialingInformationNumber *pObj = (ASNH245DialingInformationNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DialingInformationNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSingleString( &(pObj->m_networkAddress) );
	delete_AsnSingleString( &(pObj->m_subAddress) );
	delete_AsnSequenceOf( &(pObj->m_networkType) );
	return HS_OK;
}

/* ASNH245DialingInformationNumber MakeMold */
HS_RESULT ASNH245DialingInformationNumber_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245DialingInformationNumber *pObj = (ASNH245DialingInformationNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNumber_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245DialingInformationNetworkType *tmold_networkType = (ASNH245DialingInformationNetworkType *)HSMalloc( sizeof(ASNH245DialingInformationNetworkType) );
	new_ASNH245DialingInformationNetworkType(tmold_networkType);
	ASNH245DialingInformationNetworkType_MakeMold(tmold_networkType);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_networkType,sizeof(ASNH245DialingInformationNetworkType),ASNH245DialingInformationNetworkType_MakeMold,ASNH245DialingInformationNetworkType_Encode,ASNH245DialingInformationNetworkType_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245DialingInformationNetworkType_Print,
#endif
		delete_ASNH245DialingInformationNetworkType);
	AsnSequenceOf_SetMold( &(pObj->m_networkType), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_networkType.constraint.type = e_constrained;
	pObj->m_networkType.constraint.minValue = 1;
	pObj->m_networkType.constraint.maxValue = 255;
	pObj->m_networkType.extMinValue = 0;
	pObj->m_networkType.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245DialingInformationNumber IncludeOptionalField */
HS_RESULT ASNH245DialingInformationNumber_IncludeOptionField( void *pObject, ASNH245DialingInformationNumberOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245DialingInformationNumber *pObj = (ASNH245DialingInformationNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNumber_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245DialingInformationNumberOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245DialingInformationNumber IsIncludeOptionalField */
BOOL ASNH245DialingInformationNumber_IsIncludeOptionField( void *pObject, ASNH245DialingInformationNumberOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245DialingInformationNumber *pObj = (ASNH245DialingInformationNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNumber_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245DialingInformationNumberOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245DialingInformationNumber Encode */
HS_RESULT ASNH245DialingInformationNumber_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245DialingInformationNumber *pObj = (ASNH245DialingInformationNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNumber_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245DialingInformationNumberOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245DialingInformationNumberOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnSingleString_Encode( &(pObj->m_networkAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245DialingInformationNumber_IsIncludeOptionField( pObj, e_ASNH245DialingInformationNumberOptionMap_subAddress ) ){
		if( (tRet=AsnSingleString_Encode( &(pObj->m_subAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_networkType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245DialingInformationNumber Decode */
HS_RESULT ASNH245DialingInformationNumber_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245DialingInformationNumber *pObj = (ASNH245DialingInformationNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNumber_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245DialingInformationNumberOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245DialingInformationNumberOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnSingleString_Decode(&(pObj->m_networkAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNumber_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245DialingInformationNumber_IsIncludeOptionField( pObj, e_ASNH245DialingInformationNumberOptionMap_subAddress ) ){
		if( (tRet=AsnSingleString_Decode(&(pObj->m_subAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformationNumber_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_networkType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformationNumber_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DialingInformationNumber Print */
HS_RESULT ASNH245DialingInformationNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DialingInformationNumber *pObj = (ASNH245DialingInformationNumber *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DialingInformationNumber_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSingleString_Print( &(pObj->m_networkAddress), pDepth+1, "networkAddress" );
	if( ASNH245DialingInformationNumber_IsIncludeOptionField( pObj, e_ASNH245DialingInformationNumberOptionMap_subAddress ) )
		AsnSingleString_Print( &(pObj->m_subAddress), pDepth+1, "subAddress" );
	AsnSequenceOf_Print( &(pObj->m_networkType), pDepth+1, "networkType" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DialingInformation Struct
*/
/* ASNH245DialingInformation Constructor */
HS_RESULT new_ASNH245DialingInformation( void *pObject )
{
	ASNH245DialingInformation *pObj = (ASNH245DialingInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DialingInformation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245DialingInformationChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245DialingInformationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245DialingInformation Destructor */
HS_RESULT delete_ASNH245DialingInformation( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245DialingInformation *pObj = (ASNH245DialingInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DialingInformation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245DialingInformation_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DialingInformation(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245DialingInformation SetChoice */
void* ASNH245DialingInformation_SetChoice( void *pObject, ASNH245DialingInformationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245DialingInformation *pObj = (ASNH245DialingInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformation_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245DialingInformationChoiceSizeExt ){
		if( pChoice > (ASNH245DialingInformationChoice)(e_ASNH245DialingInformationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245DialingInformation_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245DialingInformationChoice_nonStandard ){
		ASNH245NonStandardMessage *tAlter = (ASNH245NonStandardMessage *)HSMalloc( sizeof(ASNH245NonStandardMessage) );
		new_ASNH245NonStandardMessage(tAlter);
		ASNH245NonStandardMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DialingInformationChoice_differential ){
		ASNH245DialingInformationNumber *tAlter = (ASNH245DialingInformationNumber *)HSMalloc( sizeof(ASNH245DialingInformationNumber) );
		new_ASNH245DialingInformationNumber(tAlter);
		ASNH245DialingInformationNumber_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_constrained,1,65535,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH245DialingInformationNumber),ASNH245DialingInformationNumber_MakeMold,ASNH245DialingInformationNumber_Encode,ASNH245DialingInformationNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH245DialingInformationNumber_Print,
#endif
			delete_ASNH245DialingInformationNumber );
		AsnSequenceOf_SetMold(aso,tmold);
		/* Sequence Of constraint */
		aso->constraint.type = e_constrained;
		aso->constraint.minValue = 1;
		aso->constraint.maxValue = 65535;
		aso->extMinValue = 0;
		aso->extMaxValue = HS_ASN_MAX_CONSTRAINT;
		pObj->alter = aso;
	}
	else if ( pChoice == e_ASNH245DialingInformationChoice_infoNotAvailable ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,1,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformation_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245DialingInformation DeleteAlternation */
HS_RESULT ASNH245DialingInformation_DeleteAlternation(void *pObject)
{
	ASNH245DialingInformation *pObj = (ASNH245DialingInformation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformation_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245DialingInformationChoice_nonStandard ){
			delete_ASNH245NonStandardMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DialingInformationChoice_differential ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DialingInformationChoice_infoNotAvailable ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245DialingInformation_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245DialingInformation Encode */
HS_RESULT ASNH245DialingInformation_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245DialingInformation *pObj = (ASNH245DialingInformation *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformation_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformation_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245DialingInformationChoiceSize )
		{
			if( pObj->choice > ((ASNH245DialingInformationChoice)(e_ASNH245DialingInformationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245DialingInformationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245DialingInformationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DialingInformationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DialingInformationChoice_differential ){
		if( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DialingInformationChoice_infoNotAvailable ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformation_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245DialingInformation Decode */
HS_RESULT ASNH245DialingInformation_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245DialingInformation *pObj = (ASNH245DialingInformation *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformation_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245DialingInformationChoiceSize;
	}
	else
	{
		if( e_ASNH245DialingInformationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245DialingInformationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245DialingInformationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245DialingInformation_SetChoice( pObj, (ASNH245DialingInformationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformation_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DialingInformationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DialingInformationChoice_differential ){
		if( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DialingInformationChoice_infoNotAvailable ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DialingInformation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DialingInformation_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DialingInformation Print */
HS_RESULT ASNH245DialingInformation_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DialingInformation *pObj = (ASNH245DialingInformation *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DialingInformation_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DialingInformationChoice_nonStandard ){
		ASNH245NonStandardMessage_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245DialingInformationChoice_differential ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "differential" );
	}
	else if ( pObj->choice == e_ASNH245DialingInformationChoice_infoNotAvailable ){
		AsnInteger_Print( pObj->alter, pDepth+1, "infoNotAvailable" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultilinkRequest_addConnection Class
*/
/*ASNH245MultilinkRequest_addConnection Constructor*/
HS_RESULT new_ASNH245MultilinkRequest_addConnection(void *pObject)
{
	ASNH245MultilinkRequest_addConnection *pObj = (ASNH245MultilinkRequest_addConnection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultilinkRequest_addConnection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	new_ASNH245DialingInformation( &(pObj->m_dialingInformation) );

	return HS_OK;
}

/* ASNH245MultilinkRequest_addConnection Destructor */
HS_RESULT delete_ASNH245MultilinkRequest_addConnection(void *pObject)
{
	ASNH245MultilinkRequest_addConnection *pObj = (ASNH245MultilinkRequest_addConnection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkRequest_addConnection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	delete_ASNH245DialingInformation( &(pObj->m_dialingInformation) );
	return HS_OK;
}

/* ASNH245MultilinkRequest_addConnection MakeMold */
HS_RESULT ASNH245MultilinkRequest_addConnection_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultilinkRequest_addConnection *pObj = (ASNH245MultilinkRequest_addConnection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_addConnection_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	ASNH245DialingInformation_MakeMold(&(pObj->m_dialingInformation));
	return HS_OK;
}

/* ASNH245MultilinkRequest_addConnection Encode */
HS_RESULT ASNH245MultilinkRequest_addConnection_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkRequest_addConnection *pObj = (ASNH245MultilinkRequest_addConnection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_addConnection_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_addConnection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245DialingInformation_Encode( &(pObj->m_dialingInformation),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_addConnection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultilinkRequest_addConnection Decode */
HS_RESULT ASNH245MultilinkRequest_addConnection_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkRequest_addConnection *pObj = (ASNH245MultilinkRequest_addConnection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_addConnection_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_addConnection_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245DialingInformation_Decode(&(pObj->m_dialingInformation),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_addConnection_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultilinkRequest_addConnection Print */
HS_RESULT ASNH245MultilinkRequest_addConnection_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultilinkRequest_addConnection *pObj = (ASNH245MultilinkRequest_addConnection *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultilinkRequest_addConnection_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	ASNH245DialingInformation_Print( &(pObj->m_dialingInformation), pDepth+1, "dialingInformation" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ConnectionIdentifier Class
*/
/*ASNH245ConnectionIdentifier Constructor*/
HS_RESULT new_ASNH245ConnectionIdentifier(void *pObject)
{
	ASNH245ConnectionIdentifier *pObj = (ASNH245ConnectionIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ConnectionIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_channelTag), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_sequenceNumber), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245ConnectionIdentifier Destructor */
HS_RESULT delete_ASNH245ConnectionIdentifier(void *pObject)
{
	ASNH245ConnectionIdentifier *pObj = (ASNH245ConnectionIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConnectionIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_channelTag) );
	delete_AsnInteger( &(pObj->m_sequenceNumber) );
	return HS_OK;
}

/* ASNH245ConnectionIdentifier MakeMold */
HS_RESULT ASNH245ConnectionIdentifier_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245ConnectionIdentifier *pObj = (ASNH245ConnectionIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConnectionIdentifier_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245ConnectionIdentifier Encode */
HS_RESULT ASNH245ConnectionIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245ConnectionIdentifier *pObj = (ASNH245ConnectionIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConnectionIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_channelTag),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConnectionIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConnectionIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245ConnectionIdentifier Decode */
HS_RESULT ASNH245ConnectionIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245ConnectionIdentifier *pObj = (ASNH245ConnectionIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConnectionIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_channelTag),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConnectionIdentifier_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConnectionIdentifier_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ConnectionIdentifier Print */
HS_RESULT ASNH245ConnectionIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ConnectionIdentifier *pObj = (ASNH245ConnectionIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ConnectionIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_channelTag), pDepth+1, "channelTag" );
	AsnInteger_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultilinkRequest_removeConnection Class
*/
/*ASNH245MultilinkRequest_removeConnection Constructor*/
HS_RESULT new_ASNH245MultilinkRequest_removeConnection(void *pObject)
{
	ASNH245MultilinkRequest_removeConnection *pObj = (ASNH245MultilinkRequest_removeConnection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultilinkRequest_removeConnection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245ConnectionIdentifier( &(pObj->m_connectionIdentifier) );

	return HS_OK;
}

/* ASNH245MultilinkRequest_removeConnection Destructor */
HS_RESULT delete_ASNH245MultilinkRequest_removeConnection(void *pObject)
{
	ASNH245MultilinkRequest_removeConnection *pObj = (ASNH245MultilinkRequest_removeConnection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkRequest_removeConnection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245ConnectionIdentifier( &(pObj->m_connectionIdentifier) );
	return HS_OK;
}

/* ASNH245MultilinkRequest_removeConnection MakeMold */
HS_RESULT ASNH245MultilinkRequest_removeConnection_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultilinkRequest_removeConnection *pObj = (ASNH245MultilinkRequest_removeConnection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_removeConnection_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245ConnectionIdentifier_MakeMold(&(pObj->m_connectionIdentifier));
	return HS_OK;
}

/* ASNH245MultilinkRequest_removeConnection Encode */
HS_RESULT ASNH245MultilinkRequest_removeConnection_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkRequest_removeConnection *pObj = (ASNH245MultilinkRequest_removeConnection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_removeConnection_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245ConnectionIdentifier_Encode( &(pObj->m_connectionIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_removeConnection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultilinkRequest_removeConnection Decode */
HS_RESULT ASNH245MultilinkRequest_removeConnection_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkRequest_removeConnection *pObj = (ASNH245MultilinkRequest_removeConnection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_removeConnection_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245ConnectionIdentifier_Decode(&(pObj->m_connectionIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_removeConnection_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultilinkRequest_removeConnection Print */
HS_RESULT ASNH245MultilinkRequest_removeConnection_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultilinkRequest_removeConnection *pObj = (ASNH245MultilinkRequest_removeConnection *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultilinkRequest_removeConnection_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245ConnectionIdentifier_Print( &(pObj->m_connectionIdentifier), pDepth+1, "connectionIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultilinkRequest_maximumHeaderInterval_requestType Struct
*/
/* ASNH245MultilinkRequest_maximumHeaderInterval_requestType Constructor */
HS_RESULT new_ASNH245MultilinkRequest_maximumHeaderInterval_requestType( void *pObject )
{
	ASNH245MultilinkRequest_maximumHeaderInterval_requestType *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval_requestType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultilinkRequest_maximumHeaderInterval_requestType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_currentIntervalInformation;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MultilinkRequest_maximumHeaderInterval_requestType Destructor */
HS_RESULT delete_ASNH245MultilinkRequest_maximumHeaderInterval_requestType( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MultilinkRequest_maximumHeaderInterval_requestType *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval_requestType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkRequest_maximumHeaderInterval_requestType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MultilinkRequest_maximumHeaderInterval_requestType_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkRequest_maximumHeaderInterval_requestType(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MultilinkRequest_maximumHeaderInterval_requestType SetChoice */
void* ASNH245MultilinkRequest_maximumHeaderInterval_requestType_SetChoice( void *pObject, ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MultilinkRequest_maximumHeaderInterval_requestType *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval_requestType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSizeExt ){
		if( pChoice > (ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice)(e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MultilinkRequest_maximumHeaderInterval_requestType_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_currentIntervalInformation ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_requestedInterval ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MultilinkRequest_maximumHeaderInterval_requestType DeleteAlternation */
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_DeleteAlternation(void *pObject)
{
	ASNH245MultilinkRequest_maximumHeaderInterval_requestType *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval_requestType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_currentIntervalInformation ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_requestedInterval ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MultilinkRequest_maximumHeaderInterval_requestType Encode */
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MultilinkRequest_maximumHeaderInterval_requestType *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval_requestType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice)(e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_currentIntervalInformation ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_requestedInterval ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MultilinkRequest_maximumHeaderInterval_requestType Decode */
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MultilinkRequest_maximumHeaderInterval_requestType *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval_requestType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSize;
	}
	else
	{
		if( e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MultilinkRequest_maximumHeaderInterval_requestType_SetChoice( pObj, (ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_currentIntervalInformation ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_requestedInterval ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultilinkRequest_maximumHeaderInterval_requestType Print */
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultilinkRequest_maximumHeaderInterval_requestType *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval_requestType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_currentIntervalInformation ){
		AsnNull_Print( pObj->alter, pDepth+1, "currentIntervalInformation" );
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequest_maximumHeaderInterval_requestTypeChoice_requestedInterval ){
		AsnInteger_Print( pObj->alter, pDepth+1, "requestedInterval" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultilinkRequest_maximumHeaderInterval Class
*/
/*ASNH245MultilinkRequest_maximumHeaderInterval Constructor*/
HS_RESULT new_ASNH245MultilinkRequest_maximumHeaderInterval(void *pObject)
{
	ASNH245MultilinkRequest_maximumHeaderInterval *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultilinkRequest_maximumHeaderInterval(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245MultilinkRequest_maximumHeaderInterval_requestType( &(pObj->m_requestType) );

	return HS_OK;
}

/* ASNH245MultilinkRequest_maximumHeaderInterval Destructor */
HS_RESULT delete_ASNH245MultilinkRequest_maximumHeaderInterval(void *pObject)
{
	ASNH245MultilinkRequest_maximumHeaderInterval *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkRequest_maximumHeaderInterval(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MultilinkRequest_maximumHeaderInterval_requestType( &(pObj->m_requestType) );
	return HS_OK;
}

/* ASNH245MultilinkRequest_maximumHeaderInterval MakeMold */
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultilinkRequest_maximumHeaderInterval *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MultilinkRequest_maximumHeaderInterval Encode */
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkRequest_maximumHeaderInterval *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Encode( &(pObj->m_requestType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultilinkRequest_maximumHeaderInterval Decode */
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkRequest_maximumHeaderInterval *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Decode(&(pObj->m_requestType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultilinkRequest_maximumHeaderInterval Print */
HS_RESULT ASNH245MultilinkRequest_maximumHeaderInterval_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultilinkRequest_maximumHeaderInterval *pObj = (ASNH245MultilinkRequest_maximumHeaderInterval *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultilinkRequest_maximumHeaderInterval_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MultilinkRequest_maximumHeaderInterval_requestType_Print( &(pObj->m_requestType), pDepth+1, "requestType" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultilinkRequest Struct
*/
/* ASNH245MultilinkRequest Constructor */
HS_RESULT new_ASNH245MultilinkRequest( void *pObject )
{
	ASNH245MultilinkRequest *pObj = (ASNH245MultilinkRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultilinkRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MultilinkRequestChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MultilinkRequestChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MultilinkRequest Destructor */
HS_RESULT delete_ASNH245MultilinkRequest( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MultilinkRequest *pObj = (ASNH245MultilinkRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MultilinkRequest_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkRequest(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MultilinkRequest SetChoice */
void* ASNH245MultilinkRequest_SetChoice( void *pObject, ASNH245MultilinkRequestChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MultilinkRequest *pObj = (ASNH245MultilinkRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MultilinkRequestChoiceSizeExt ){
		if( pChoice > (ASNH245MultilinkRequestChoice)(e_ASNH245MultilinkRequestChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MultilinkRequest_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MultilinkRequestChoice_nonStandard ){
		ASNH245NonStandardMessage *tAlter = (ASNH245NonStandardMessage *)HSMalloc( sizeof(ASNH245NonStandardMessage) );
		new_ASNH245NonStandardMessage(tAlter);
		ASNH245NonStandardMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultilinkRequestChoice_callInformation ){
		ASNH245MultilinkRequest_callInformation *tAlter = (ASNH245MultilinkRequest_callInformation *)HSMalloc( sizeof(ASNH245MultilinkRequest_callInformation) );
		new_ASNH245MultilinkRequest_callInformation(tAlter);
		ASNH245MultilinkRequest_callInformation_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultilinkRequestChoice_addConnection ){
		ASNH245MultilinkRequest_addConnection *tAlter = (ASNH245MultilinkRequest_addConnection *)HSMalloc( sizeof(ASNH245MultilinkRequest_addConnection) );
		new_ASNH245MultilinkRequest_addConnection(tAlter);
		ASNH245MultilinkRequest_addConnection_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultilinkRequestChoice_removeConnection ){
		ASNH245MultilinkRequest_removeConnection *tAlter = (ASNH245MultilinkRequest_removeConnection *)HSMalloc( sizeof(ASNH245MultilinkRequest_removeConnection) );
		new_ASNH245MultilinkRequest_removeConnection(tAlter);
		ASNH245MultilinkRequest_removeConnection_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultilinkRequestChoice_maximumHeaderInterval ){
		ASNH245MultilinkRequest_maximumHeaderInterval *tAlter = (ASNH245MultilinkRequest_maximumHeaderInterval *)HSMalloc( sizeof(ASNH245MultilinkRequest_maximumHeaderInterval) );
		new_ASNH245MultilinkRequest_maximumHeaderInterval(tAlter);
		ASNH245MultilinkRequest_maximumHeaderInterval_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MultilinkRequest DeleteAlternation */
HS_RESULT ASNH245MultilinkRequest_DeleteAlternation(void *pObject)
{
	ASNH245MultilinkRequest *pObj = (ASNH245MultilinkRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MultilinkRequestChoice_nonStandard ){
			delete_ASNH245NonStandardMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_callInformation ){
			delete_ASNH245MultilinkRequest_callInformation(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_addConnection ){
			delete_ASNH245MultilinkRequest_addConnection(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_removeConnection ){
			delete_ASNH245MultilinkRequest_removeConnection(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_maximumHeaderInterval ){
			delete_ASNH245MultilinkRequest_maximumHeaderInterval(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MultilinkRequest_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MultilinkRequest Encode */
HS_RESULT ASNH245MultilinkRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MultilinkRequest *pObj = (ASNH245MultilinkRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MultilinkRequestChoiceSize )
		{
			if( pObj->choice > ((ASNH245MultilinkRequestChoice)(e_ASNH245MultilinkRequestChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MultilinkRequestChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MultilinkRequestChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultilinkRequestChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_callInformation ){
		if( (tRet=ASNH245MultilinkRequest_callInformation_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_addConnection ){
		if( (tRet=ASNH245MultilinkRequest_addConnection_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_removeConnection ){
		if( (tRet=ASNH245MultilinkRequest_removeConnection_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_maximumHeaderInterval ){
		if( (tRet=ASNH245MultilinkRequest_maximumHeaderInterval_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MultilinkRequest Decode */
HS_RESULT ASNH245MultilinkRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MultilinkRequest *pObj = (ASNH245MultilinkRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MultilinkRequestChoiceSize;
	}
	else
	{
		if( e_ASNH245MultilinkRequestChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MultilinkRequestChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MultilinkRequestChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MultilinkRequest_SetChoice( pObj, (ASNH245MultilinkRequestChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultilinkRequestChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_callInformation ){
		if( (tRet=ASNH245MultilinkRequest_callInformation_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_addConnection ){
		if( (tRet=ASNH245MultilinkRequest_addConnection_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_removeConnection ){
		if( (tRet=ASNH245MultilinkRequest_removeConnection_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_maximumHeaderInterval ){
		if( (tRet=ASNH245MultilinkRequest_maximumHeaderInterval_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkRequest_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkRequest_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultilinkRequest Print */
HS_RESULT ASNH245MultilinkRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultilinkRequest *pObj = (ASNH245MultilinkRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultilinkRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultilinkRequestChoice_nonStandard ){
		ASNH245NonStandardMessage_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_callInformation ){
		ASNH245MultilinkRequest_callInformation_Print( pObj->alter, pDepth+1, "callInformation" );
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_addConnection ){
		ASNH245MultilinkRequest_addConnection_Print( pObj->alter, pDepth+1, "addConnection" );
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_removeConnection ){
		ASNH245MultilinkRequest_removeConnection_Print( pObj->alter, pDepth+1, "removeConnection" );
	}
	else if ( pObj->choice == e_ASNH245MultilinkRequestChoice_maximumHeaderInterval ){
		ASNH245MultilinkRequest_maximumHeaderInterval_Print( pObj->alter, pDepth+1, "maximumHeaderInterval" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245LogicalChannelRateRequest Class
*/
/*ASNH245LogicalChannelRateRequest Constructor*/
HS_RESULT new_ASNH245LogicalChannelRateRequest(void *pObject)
{
	ASNH245LogicalChannelRateRequest *pObj = (ASNH245LogicalChannelRateRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245LogicalChannelRateRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	new_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );
	new_ASNH245MaximumBitRate( &(pObj->m_maximumBitRate) );

	return HS_OK;
}

/* ASNH245LogicalChannelRateRequest Destructor */
HS_RESULT delete_ASNH245LogicalChannelRateRequest(void *pObject)
{
	ASNH245LogicalChannelRateRequest *pObj = (ASNH245LogicalChannelRateRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245LogicalChannelRateRequest(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	delete_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );
	delete_ASNH245MaximumBitRate( &(pObj->m_maximumBitRate) );
	return HS_OK;
}

/* ASNH245LogicalChannelRateRequest MakeMold */
HS_RESULT ASNH245LogicalChannelRateRequest_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245LogicalChannelRateRequest *pObj = (ASNH245LogicalChannelRateRequest *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_logicalChannelNumber));
	ASNH245MaximumBitRate_MakeMold(&(pObj->m_maximumBitRate));
	return HS_OK;
}

/* ASNH245LogicalChannelRateRequest Encode */
HS_RESULT ASNH245LogicalChannelRateRequest_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245LogicalChannelRateRequest *pObj = (ASNH245LogicalChannelRateRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MaximumBitRate_Encode( &(pObj->m_maximumBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245LogicalChannelRateRequest Decode */
HS_RESULT ASNH245LogicalChannelRateRequest_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245LogicalChannelRateRequest *pObj = (ASNH245LogicalChannelRateRequest *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MaximumBitRate_Decode(&(pObj->m_maximumBitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245LogicalChannelRateRequest Print */
HS_RESULT ASNH245LogicalChannelRateRequest_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245LogicalChannelRateRequest *pObj = (ASNH245LogicalChannelRateRequest *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245LogicalChannelRateRequest_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	ASNH245LogicalChannelNumber_Print( &(pObj->m_logicalChannelNumber), pDepth+1, "logicalChannelNumber" );
	ASNH245MaximumBitRate_Print( &(pObj->m_maximumBitRate), pDepth+1, "maximumBitRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestMessage Struct
*/
/* ASNH245RequestMessage Constructor */
HS_RESULT new_ASNH245RequestMessage( void *pObject )
{
	ASNH245RequestMessage *pObj = (ASNH245RequestMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RequestMessageChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RequestMessageChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RequestMessage Destructor */
HS_RESULT delete_ASNH245RequestMessage( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RequestMessage *pObj = (ASNH245RequestMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RequestMessage_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMessage(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RequestMessage SetChoice */
void* ASNH245RequestMessage_SetChoice( void *pObject, ASNH245RequestMessageChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RequestMessage *pObj = (ASNH245RequestMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMessage_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RequestMessageChoiceSizeExt ){
		if( pChoice > (ASNH245RequestMessageChoice)(e_ASNH245RequestMessageChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RequestMessage_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RequestMessageChoice_nonStandard ){
		ASNH245NonStandardMessage *tAlter = (ASNH245NonStandardMessage *)HSMalloc( sizeof(ASNH245NonStandardMessage) );
		new_ASNH245NonStandardMessage(tAlter);
		ASNH245NonStandardMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_masterSlaveDetermination ){
		ASNH245MasterSlaveDetermination *tAlter = (ASNH245MasterSlaveDetermination *)HSMalloc( sizeof(ASNH245MasterSlaveDetermination) );
		new_ASNH245MasterSlaveDetermination(tAlter);
		ASNH245MasterSlaveDetermination_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_terminalCapabilitySet ){
		ASNH245TerminalCapabilitySet *tAlter = (ASNH245TerminalCapabilitySet *)HSMalloc( sizeof(ASNH245TerminalCapabilitySet) );
		new_ASNH245TerminalCapabilitySet(tAlter);
		ASNH245TerminalCapabilitySet_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_openLogicalChannel ){
		ASNH245OpenLogicalChannel *tAlter = (ASNH245OpenLogicalChannel *)HSMalloc( sizeof(ASNH245OpenLogicalChannel) );
		new_ASNH245OpenLogicalChannel(tAlter);
		ASNH245OpenLogicalChannel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_closeLogicalChannel ){
		ASNH245CloseLogicalChannel *tAlter = (ASNH245CloseLogicalChannel *)HSMalloc( sizeof(ASNH245CloseLogicalChannel) );
		new_ASNH245CloseLogicalChannel(tAlter);
		ASNH245CloseLogicalChannel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_requestChannelClose ){
		ASNH245RequestChannelClose *tAlter = (ASNH245RequestChannelClose *)HSMalloc( sizeof(ASNH245RequestChannelClose) );
		new_ASNH245RequestChannelClose(tAlter);
		ASNH245RequestChannelClose_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_multiplexEntrySend ){
		ASNH245MultiplexEntrySend *tAlter = (ASNH245MultiplexEntrySend *)HSMalloc( sizeof(ASNH245MultiplexEntrySend) );
		new_ASNH245MultiplexEntrySend(tAlter);
		ASNH245MultiplexEntrySend_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_requestMultiplexEntry ){
		ASNH245RequestMultiplexEntry *tAlter = (ASNH245RequestMultiplexEntry *)HSMalloc( sizeof(ASNH245RequestMultiplexEntry) );
		new_ASNH245RequestMultiplexEntry(tAlter);
		ASNH245RequestMultiplexEntry_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_requestMode ){
		ASNH245RequestMode *tAlter = (ASNH245RequestMode *)HSMalloc( sizeof(ASNH245RequestMode) );
		new_ASNH245RequestMode(tAlter);
		ASNH245RequestMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_roundTripDelayRequest ){
		ASNH245RoundTripDelayRequest *tAlter = (ASNH245RoundTripDelayRequest *)HSMalloc( sizeof(ASNH245RoundTripDelayRequest) );
		new_ASNH245RoundTripDelayRequest(tAlter);
		ASNH245RoundTripDelayRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_maintenanceLoopRequest ){
		ASNH245MaintenanceLoopRequest *tAlter = (ASNH245MaintenanceLoopRequest *)HSMalloc( sizeof(ASNH245MaintenanceLoopRequest) );
		new_ASNH245MaintenanceLoopRequest(tAlter);
		ASNH245MaintenanceLoopRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245RequestMessageChoice_communicationModeRequest ){
		ASNH245CommunicationModeRequest *tAlter = (ASNH245CommunicationModeRequest *)HSMalloc( sizeof(ASNH245CommunicationModeRequest) );
		new_ASNH245CommunicationModeRequest(tAlter);
		ASNH245CommunicationModeRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_conferenceRequest ){
		ASNH245ConferenceRequest *tAlter = (ASNH245ConferenceRequest *)HSMalloc( sizeof(ASNH245ConferenceRequest) );
		new_ASNH245ConferenceRequest(tAlter);
		ASNH245ConferenceRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_multilinkRequest ){
		ASNH245MultilinkRequest *tAlter = (ASNH245MultilinkRequest *)HSMalloc( sizeof(ASNH245MultilinkRequest) );
		new_ASNH245MultilinkRequest(tAlter);
		ASNH245MultilinkRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestMessageChoice_logicalChannelRateRequest ){
		ASNH245LogicalChannelRateRequest *tAlter = (ASNH245LogicalChannelRateRequest *)HSMalloc( sizeof(ASNH245LogicalChannelRateRequest) );
		new_ASNH245LogicalChannelRateRequest(tAlter);
		ASNH245LogicalChannelRateRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMessage_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RequestMessage DeleteAlternation */
HS_RESULT ASNH245RequestMessage_DeleteAlternation(void *pObject)
{
	ASNH245RequestMessage *pObj = (ASNH245RequestMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMessage_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RequestMessageChoice_nonStandard ){
			delete_ASNH245NonStandardMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_masterSlaveDetermination ){
			delete_ASNH245MasterSlaveDetermination(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_terminalCapabilitySet ){
			delete_ASNH245TerminalCapabilitySet(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_openLogicalChannel ){
			delete_ASNH245OpenLogicalChannel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_closeLogicalChannel ){
			delete_ASNH245CloseLogicalChannel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestChannelClose ){
			delete_ASNH245RequestChannelClose(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_multiplexEntrySend ){
			delete_ASNH245MultiplexEntrySend(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestMultiplexEntry ){
			delete_ASNH245RequestMultiplexEntry(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestMode ){
			delete_ASNH245RequestMode(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_roundTripDelayRequest ){
			delete_ASNH245RoundTripDelayRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_maintenanceLoopRequest ){
			delete_ASNH245MaintenanceLoopRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_communicationModeRequest ){
			delete_ASNH245CommunicationModeRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_conferenceRequest ){
			delete_ASNH245ConferenceRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_multilinkRequest ){
			delete_ASNH245MultilinkRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestMessageChoice_logicalChannelRateRequest ){
			delete_ASNH245LogicalChannelRateRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RequestMessage_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RequestMessage Encode */
HS_RESULT ASNH245RequestMessage_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RequestMessage *pObj = (ASNH245RequestMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMessage_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMessage_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RequestMessageChoiceSize )
		{
			if( pObj->choice > ((ASNH245RequestMessageChoice)(e_ASNH245RequestMessageChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RequestMessageChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RequestMessageChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestMessageChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_masterSlaveDetermination ){
		if( (tRet=ASNH245MasterSlaveDetermination_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_terminalCapabilitySet ){
		if( (tRet=ASNH245TerminalCapabilitySet_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_openLogicalChannel ){
		if( (tRet=ASNH245OpenLogicalChannel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_closeLogicalChannel ){
		if( (tRet=ASNH245CloseLogicalChannel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestChannelClose ){
		if( (tRet=ASNH245RequestChannelClose_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_multiplexEntrySend ){
		if( (tRet=ASNH245MultiplexEntrySend_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestMultiplexEntry ){
		if( (tRet=ASNH245RequestMultiplexEntry_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestMode ){
		if( (tRet=ASNH245RequestMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_roundTripDelayRequest ){
		if( (tRet=ASNH245RoundTripDelayRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_maintenanceLoopRequest ){
		if( (tRet=ASNH245MaintenanceLoopRequest_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_communicationModeRequest ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245CommunicationModeRequest_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_conferenceRequest ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245ConferenceRequest_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_multilinkRequest ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MultilinkRequest_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_logicalChannelRateRequest ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245LogicalChannelRateRequest_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMessage_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RequestMessage Decode */
HS_RESULT ASNH245RequestMessage_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RequestMessage *pObj = (ASNH245RequestMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMessage_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RequestMessageChoiceSize;
	}
	else
	{
		if( e_ASNH245RequestMessageChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RequestMessageChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RequestMessageChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RequestMessage_SetChoice( pObj, (ASNH245RequestMessageChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMessage_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestMessageChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_masterSlaveDetermination ){
		if( (tRet=ASNH245MasterSlaveDetermination_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_terminalCapabilitySet ){
		if( (tRet=ASNH245TerminalCapabilitySet_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_openLogicalChannel ){
		if( (tRet=ASNH245OpenLogicalChannel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_closeLogicalChannel ){
		if( (tRet=ASNH245CloseLogicalChannel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestChannelClose ){
		if( (tRet=ASNH245RequestChannelClose_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_multiplexEntrySend ){
		if( (tRet=ASNH245MultiplexEntrySend_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestMultiplexEntry ){
		if( (tRet=ASNH245RequestMultiplexEntry_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestMode ){
		if( (tRet=ASNH245RequestMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_roundTripDelayRequest ){
		if( (tRet=ASNH245RoundTripDelayRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_maintenanceLoopRequest ){
		if( (tRet=ASNH245MaintenanceLoopRequest_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_communicationModeRequest ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245CommunicationModeRequest_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_conferenceRequest ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245ConferenceRequest_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_multilinkRequest ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MultilinkRequest_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_logicalChannelRateRequest ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245LogicalChannelRateRequest_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMessage_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestMessage Print */
HS_RESULT ASNH245RequestMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestMessage *pObj = (ASNH245RequestMessage *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestMessage_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestMessageChoice_nonStandard ){
		ASNH245NonStandardMessage_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_masterSlaveDetermination ){
		ASNH245MasterSlaveDetermination_Print( pObj->alter, pDepth+1, "masterSlaveDetermination" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_terminalCapabilitySet ){
		ASNH245TerminalCapabilitySet_Print( pObj->alter, pDepth+1, "terminalCapabilitySet" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_openLogicalChannel ){
		ASNH245OpenLogicalChannel_Print( pObj->alter, pDepth+1, "openLogicalChannel" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_closeLogicalChannel ){
		ASNH245CloseLogicalChannel_Print( pObj->alter, pDepth+1, "closeLogicalChannel" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestChannelClose ){
		ASNH245RequestChannelClose_Print( pObj->alter, pDepth+1, "requestChannelClose" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_multiplexEntrySend ){
		ASNH245MultiplexEntrySend_Print( pObj->alter, pDepth+1, "multiplexEntrySend" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestMultiplexEntry ){
		ASNH245RequestMultiplexEntry_Print( pObj->alter, pDepth+1, "requestMultiplexEntry" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_requestMode ){
		ASNH245RequestMode_Print( pObj->alter, pDepth+1, "requestMode" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_roundTripDelayRequest ){
		ASNH245RoundTripDelayRequest_Print( pObj->alter, pDepth+1, "roundTripDelayRequest" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_maintenanceLoopRequest ){
		ASNH245MaintenanceLoopRequest_Print( pObj->alter, pDepth+1, "maintenanceLoopRequest" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_communicationModeRequest ){
		ASNH245CommunicationModeRequest_Print( pObj->alter, pDepth+1, "communicationModeRequest" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_conferenceRequest ){
		ASNH245ConferenceRequest_Print( pObj->alter, pDepth+1, "conferenceRequest" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_multilinkRequest ){
		ASNH245MultilinkRequest_Print( pObj->alter, pDepth+1, "multilinkRequest" );
	}
	else if ( pObj->choice == e_ASNH245RequestMessageChoice_logicalChannelRateRequest ){
		ASNH245LogicalChannelRateRequest_Print( pObj->alter, pDepth+1, "logicalChannelRateRequest" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MasterSlaveDeterminationAck_decision Struct
*/
/* ASNH245MasterSlaveDeterminationAck_decision Constructor */
HS_RESULT new_ASNH245MasterSlaveDeterminationAck_decision( void *pObject )
{
	ASNH245MasterSlaveDeterminationAck_decision *pObj = (ASNH245MasterSlaveDeterminationAck_decision *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MasterSlaveDeterminationAck_decision(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245MasterSlaveDeterminationAck_decisionChoice_master;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MasterSlaveDeterminationAck_decision Destructor */
HS_RESULT delete_ASNH245MasterSlaveDeterminationAck_decision( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MasterSlaveDeterminationAck_decision *pObj = (ASNH245MasterSlaveDeterminationAck_decision *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MasterSlaveDeterminationAck_decision(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MasterSlaveDeterminationAck_decision_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MasterSlaveDeterminationAck_decision(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MasterSlaveDeterminationAck_decision SetChoice */
void* ASNH245MasterSlaveDeterminationAck_decision_SetChoice( void *pObject, ASNH245MasterSlaveDeterminationAck_decisionChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MasterSlaveDeterminationAck_decision *pObj = (ASNH245MasterSlaveDeterminationAck_decision *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSizeExt ){
		if( pChoice > (ASNH245MasterSlaveDeterminationAck_decisionChoice)(e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MasterSlaveDeterminationAck_decision_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_master ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_slave ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MasterSlaveDeterminationAck_decision DeleteAlternation */
HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_DeleteAlternation(void *pObject)
{
	ASNH245MasterSlaveDeterminationAck_decision *pObj = (ASNH245MasterSlaveDeterminationAck_decision *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_master ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_slave ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MasterSlaveDeterminationAck_decision Encode */
HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MasterSlaveDeterminationAck_decision *pObj = (ASNH245MasterSlaveDeterminationAck_decision *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSize )
		{
			if( pObj->choice > ((ASNH245MasterSlaveDeterminationAck_decisionChoice)(e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_master ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_slave ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationAck_decision Decode */
HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MasterSlaveDeterminationAck_decision *pObj = (ASNH245MasterSlaveDeterminationAck_decision *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSize;
	}
	else
	{
		if( e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MasterSlaveDeterminationAck_decisionChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MasterSlaveDeterminationAck_decision_SetChoice( pObj, (ASNH245MasterSlaveDeterminationAck_decisionChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_master ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_slave ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MasterSlaveDeterminationAck_decision Print */
HS_RESULT ASNH245MasterSlaveDeterminationAck_decision_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MasterSlaveDeterminationAck_decision *pObj = (ASNH245MasterSlaveDeterminationAck_decision *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_decision_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_master ){
		AsnNull_Print( pObj->alter, pDepth+1, "master" );
	}
	else if ( pObj->choice == e_ASNH245MasterSlaveDeterminationAck_decisionChoice_slave ){
		AsnNull_Print( pObj->alter, pDepth+1, "slave" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MasterSlaveDeterminationAck Class
*/
/*ASNH245MasterSlaveDeterminationAck Constructor*/
HS_RESULT new_ASNH245MasterSlaveDeterminationAck(void *pObject)
{
	ASNH245MasterSlaveDeterminationAck *pObj = (ASNH245MasterSlaveDeterminationAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MasterSlaveDeterminationAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245MasterSlaveDeterminationAck_decision( &(pObj->m_decision) );

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationAck Destructor */
HS_RESULT delete_ASNH245MasterSlaveDeterminationAck(void *pObject)
{
	ASNH245MasterSlaveDeterminationAck *pObj = (ASNH245MasterSlaveDeterminationAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MasterSlaveDeterminationAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MasterSlaveDeterminationAck_decision( &(pObj->m_decision) );
	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationAck MakeMold */
HS_RESULT ASNH245MasterSlaveDeterminationAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MasterSlaveDeterminationAck *pObj = (ASNH245MasterSlaveDeterminationAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationAck Encode */
HS_RESULT ASNH245MasterSlaveDeterminationAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MasterSlaveDeterminationAck *pObj = (ASNH245MasterSlaveDeterminationAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245MasterSlaveDeterminationAck_decision_Encode( &(pObj->m_decision),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationAck Decode */
HS_RESULT ASNH245MasterSlaveDeterminationAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MasterSlaveDeterminationAck *pObj = (ASNH245MasterSlaveDeterminationAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245MasterSlaveDeterminationAck_decision_Decode(&(pObj->m_decision),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MasterSlaveDeterminationAck Print */
HS_RESULT ASNH245MasterSlaveDeterminationAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MasterSlaveDeterminationAck *pObj = (ASNH245MasterSlaveDeterminationAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MasterSlaveDeterminationAck_decision_Print( &(pObj->m_decision), pDepth+1, "decision" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MasterSlaveDeterminationReject_cause Struct
*/
/* ASNH245MasterSlaveDeterminationReject_cause Constructor */
HS_RESULT new_ASNH245MasterSlaveDeterminationReject_cause( void *pObject )
{
	ASNH245MasterSlaveDeterminationReject_cause *pObj = (ASNH245MasterSlaveDeterminationReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MasterSlaveDeterminationReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MasterSlaveDeterminationReject_causeChoice_identicalNumbers;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MasterSlaveDeterminationReject_causeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MasterSlaveDeterminationReject_cause Destructor */
HS_RESULT delete_ASNH245MasterSlaveDeterminationReject_cause( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MasterSlaveDeterminationReject_cause *pObj = (ASNH245MasterSlaveDeterminationReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MasterSlaveDeterminationReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MasterSlaveDeterminationReject_cause_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MasterSlaveDeterminationReject_cause(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MasterSlaveDeterminationReject_cause SetChoice */
void* ASNH245MasterSlaveDeterminationReject_cause_SetChoice( void *pObject, ASNH245MasterSlaveDeterminationReject_causeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MasterSlaveDeterminationReject_cause *pObj = (ASNH245MasterSlaveDeterminationReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MasterSlaveDeterminationReject_causeChoiceSizeExt ){
		if( pChoice > (ASNH245MasterSlaveDeterminationReject_causeChoice)(e_ASNH245MasterSlaveDeterminationReject_causeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MasterSlaveDeterminationReject_cause_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MasterSlaveDeterminationReject_causeChoice_identicalNumbers ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MasterSlaveDeterminationReject_cause DeleteAlternation */
HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_DeleteAlternation(void *pObject)
{
	ASNH245MasterSlaveDeterminationReject_cause *pObj = (ASNH245MasterSlaveDeterminationReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MasterSlaveDeterminationReject_causeChoice_identicalNumbers ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MasterSlaveDeterminationReject_cause Encode */
HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MasterSlaveDeterminationReject_cause *pObj = (ASNH245MasterSlaveDeterminationReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MasterSlaveDeterminationReject_causeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MasterSlaveDeterminationReject_causeChoice)(e_ASNH245MasterSlaveDeterminationReject_causeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MasterSlaveDeterminationReject_causeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MasterSlaveDeterminationReject_causeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MasterSlaveDeterminationReject_causeChoice_identicalNumbers ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationReject_cause Decode */
HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MasterSlaveDeterminationReject_cause *pObj = (ASNH245MasterSlaveDeterminationReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MasterSlaveDeterminationReject_causeChoiceSize;
	}
	else
	{
		if( e_ASNH245MasterSlaveDeterminationReject_causeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MasterSlaveDeterminationReject_causeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MasterSlaveDeterminationReject_causeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MasterSlaveDeterminationReject_cause_SetChoice( pObj, (ASNH245MasterSlaveDeterminationReject_causeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MasterSlaveDeterminationReject_causeChoice_identicalNumbers ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MasterSlaveDeterminationReject_cause Print */
HS_RESULT ASNH245MasterSlaveDeterminationReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MasterSlaveDeterminationReject_cause *pObj = (ASNH245MasterSlaveDeterminationReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_cause_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MasterSlaveDeterminationReject_causeChoice_identicalNumbers ){
		AsnNull_Print( pObj->alter, pDepth+1, "identicalNumbers" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MasterSlaveDeterminationReject Class
*/
/*ASNH245MasterSlaveDeterminationReject Constructor*/
HS_RESULT new_ASNH245MasterSlaveDeterminationReject(void *pObject)
{
	ASNH245MasterSlaveDeterminationReject *pObj = (ASNH245MasterSlaveDeterminationReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MasterSlaveDeterminationReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245MasterSlaveDeterminationReject_cause( &(pObj->m_cause) );

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationReject Destructor */
HS_RESULT delete_ASNH245MasterSlaveDeterminationReject(void *pObject)
{
	ASNH245MasterSlaveDeterminationReject *pObj = (ASNH245MasterSlaveDeterminationReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MasterSlaveDeterminationReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MasterSlaveDeterminationReject_cause( &(pObj->m_cause) );
	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationReject MakeMold */
HS_RESULT ASNH245MasterSlaveDeterminationReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MasterSlaveDeterminationReject *pObj = (ASNH245MasterSlaveDeterminationReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationReject Encode */
HS_RESULT ASNH245MasterSlaveDeterminationReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MasterSlaveDeterminationReject *pObj = (ASNH245MasterSlaveDeterminationReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245MasterSlaveDeterminationReject_cause_Encode( &(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationReject Decode */
HS_RESULT ASNH245MasterSlaveDeterminationReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MasterSlaveDeterminationReject *pObj = (ASNH245MasterSlaveDeterminationReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245MasterSlaveDeterminationReject_cause_Decode(&(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MasterSlaveDeterminationReject Print */
HS_RESULT ASNH245MasterSlaveDeterminationReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MasterSlaveDeterminationReject *pObj = (ASNH245MasterSlaveDeterminationReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MasterSlaveDeterminationReject_cause_Print( &(pObj->m_cause), pDepth+1, "cause" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TerminalCapabilitySetAck Class
*/
/*ASNH245TerminalCapabilitySetAck Constructor*/
HS_RESULT new_ASNH245TerminalCapabilitySetAck(void *pObject)
{
	ASNH245TerminalCapabilitySetAck *pObj = (ASNH245TerminalCapabilitySetAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TerminalCapabilitySetAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );

	return HS_OK;
}

/* ASNH245TerminalCapabilitySetAck Destructor */
HS_RESULT delete_ASNH245TerminalCapabilitySetAck(void *pObject)
{
	ASNH245TerminalCapabilitySetAck *pObj = (ASNH245TerminalCapabilitySetAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TerminalCapabilitySetAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	return HS_OK;
}

/* ASNH245TerminalCapabilitySetAck MakeMold */
HS_RESULT ASNH245TerminalCapabilitySetAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245TerminalCapabilitySetAck *pObj = (ASNH245TerminalCapabilitySetAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	return HS_OK;
}

/* ASNH245TerminalCapabilitySetAck Encode */
HS_RESULT ASNH245TerminalCapabilitySetAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TerminalCapabilitySetAck *pObj = (ASNH245TerminalCapabilitySetAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245TerminalCapabilitySetAck Decode */
HS_RESULT ASNH245TerminalCapabilitySetAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TerminalCapabilitySetAck *pObj = (ASNH245TerminalCapabilitySetAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TerminalCapabilitySetAck Print */
HS_RESULT ASNH245TerminalCapabilitySetAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TerminalCapabilitySetAck *pObj = (ASNH245TerminalCapabilitySetAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded Struct
*/
/* ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded Constructor */
HS_RESULT new_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded( void *pObject )
{
	ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *pObj = (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_highestEntryNumberProcessed;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded Destructor */
HS_RESULT delete_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *pObj = (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded SetChoice */
void* ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_SetChoice( void *pObject, ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *pObj = (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSizeExt ){
		if( pChoice > (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice)(e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_highestEntryNumberProcessed ){
		ASNH245CapabilityTableEntryNumber *tAlter = (ASNH245CapabilityTableEntryNumber *)HSMalloc( sizeof(ASNH245CapabilityTableEntryNumber) );
		new_ASNH245CapabilityTableEntryNumber(tAlter);
		ASNH245CapabilityTableEntryNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_noneProcessed ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded DeleteAlternation */
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_DeleteAlternation(void *pObject)
{
	ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *pObj = (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_highestEntryNumberProcessed ){
			delete_ASNH245CapabilityTableEntryNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_noneProcessed ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded Encode */
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *pObj = (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSize )
		{
			if( pObj->choice > ((ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice)(e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSize)) )
	}
	else
	{
		if( e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_highestEntryNumberProcessed ){
		if( (tRet=ASNH245CapabilityTableEntryNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_noneProcessed ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded Decode */
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *pObj = (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSize;
	}
	else
	{
		if( e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_SetChoice( pObj, (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_highestEntryNumberProcessed ){
		if( (tRet=ASNH245CapabilityTableEntryNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_noneProcessed ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded Print */
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *pObj = (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_highestEntryNumberProcessed ){
		ASNH245CapabilityTableEntryNumber_Print( pObj->alter, pDepth+1, "highestEntryNumberProcessed" );
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceededChoice_noneProcessed ){
		AsnNull_Print( pObj->alter, pDepth+1, "noneProcessed" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TerminalCapabilitySetReject_cause Struct
*/
/* ASNH245TerminalCapabilitySetReject_cause Constructor */
HS_RESULT new_ASNH245TerminalCapabilitySetReject_cause( void *pObject )
{
	ASNH245TerminalCapabilitySetReject_cause *pObj = (ASNH245TerminalCapabilitySetReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TerminalCapabilitySetReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245TerminalCapabilitySetReject_causeChoice_unspecified;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245TerminalCapabilitySetReject_causeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245TerminalCapabilitySetReject_cause Destructor */
HS_RESULT delete_ASNH245TerminalCapabilitySetReject_cause( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245TerminalCapabilitySetReject_cause *pObj = (ASNH245TerminalCapabilitySetReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TerminalCapabilitySetReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245TerminalCapabilitySetReject_cause_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TerminalCapabilitySetReject_cause(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245TerminalCapabilitySetReject_cause SetChoice */
void* ASNH245TerminalCapabilitySetReject_cause_SetChoice( void *pObject, ASNH245TerminalCapabilitySetReject_causeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245TerminalCapabilitySetReject_cause *pObj = (ASNH245TerminalCapabilitySetReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245TerminalCapabilitySetReject_causeChoiceSizeExt ){
		if( pChoice > (ASNH245TerminalCapabilitySetReject_causeChoice)(e_ASNH245TerminalCapabilitySetReject_causeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245TerminalCapabilitySetReject_cause_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245TerminalCapabilitySetReject_causeChoice_unspecified ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245TerminalCapabilitySetReject_causeChoice_undefinedTableEntryUsed ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245TerminalCapabilitySetReject_causeChoice_descriptorCapacityExceeded ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245TerminalCapabilitySetReject_causeChoice_tableEntryCapacityExceeded ){
		ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *tAlter = (ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded *)HSMalloc( sizeof(ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded) );
		new_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245TerminalCapabilitySetReject_cause DeleteAlternation */
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_DeleteAlternation(void *pObject)
{
	ASNH245TerminalCapabilitySetReject_cause *pObj = (ASNH245TerminalCapabilitySetReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_unspecified ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_undefinedTableEntryUsed ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_descriptorCapacityExceeded ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_tableEntryCapacityExceeded ){
			delete_ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245TerminalCapabilitySetReject_cause_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245TerminalCapabilitySetReject_cause Encode */
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245TerminalCapabilitySetReject_cause *pObj = (ASNH245TerminalCapabilitySetReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245TerminalCapabilitySetReject_causeChoiceSize )
		{
			if( pObj->choice > ((ASNH245TerminalCapabilitySetReject_causeChoice)(e_ASNH245TerminalCapabilitySetReject_causeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245TerminalCapabilitySetReject_causeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245TerminalCapabilitySetReject_causeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_unspecified ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_undefinedTableEntryUsed ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_descriptorCapacityExceeded ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_tableEntryCapacityExceeded ){
		if( (tRet=ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245TerminalCapabilitySetReject_cause Decode */
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245TerminalCapabilitySetReject_cause *pObj = (ASNH245TerminalCapabilitySetReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245TerminalCapabilitySetReject_causeChoiceSize;
	}
	else
	{
		if( e_ASNH245TerminalCapabilitySetReject_causeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245TerminalCapabilitySetReject_causeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245TerminalCapabilitySetReject_causeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245TerminalCapabilitySetReject_cause_SetChoice( pObj, (ASNH245TerminalCapabilitySetReject_causeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_unspecified ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_undefinedTableEntryUsed ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_descriptorCapacityExceeded ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_tableEntryCapacityExceeded ){
		if( (tRet=ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TerminalCapabilitySetReject_cause Print */
HS_RESULT ASNH245TerminalCapabilitySetReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TerminalCapabilitySetReject_cause *pObj = (ASNH245TerminalCapabilitySetReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_cause_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_unspecified ){
		AsnNull_Print( pObj->alter, pDepth+1, "unspecified" );
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_undefinedTableEntryUsed ){
		AsnNull_Print( pObj->alter, pDepth+1, "undefinedTableEntryUsed" );
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_descriptorCapacityExceeded ){
		AsnNull_Print( pObj->alter, pDepth+1, "descriptorCapacityExceeded" );
	}
	else if ( pObj->choice == e_ASNH245TerminalCapabilitySetReject_causeChoice_tableEntryCapacityExceeded ){
		ASNH245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded_Print( pObj->alter, pDepth+1, "tableEntryCapacityExceeded" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TerminalCapabilitySetReject Class
*/
/*ASNH245TerminalCapabilitySetReject Constructor*/
HS_RESULT new_ASNH245TerminalCapabilitySetReject(void *pObject)
{
	ASNH245TerminalCapabilitySetReject *pObj = (ASNH245TerminalCapabilitySetReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TerminalCapabilitySetReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	new_ASNH245TerminalCapabilitySetReject_cause( &(pObj->m_cause) );

	return HS_OK;
}

/* ASNH245TerminalCapabilitySetReject Destructor */
HS_RESULT delete_ASNH245TerminalCapabilitySetReject(void *pObject)
{
	ASNH245TerminalCapabilitySetReject *pObj = (ASNH245TerminalCapabilitySetReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TerminalCapabilitySetReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	delete_ASNH245TerminalCapabilitySetReject_cause( &(pObj->m_cause) );
	return HS_OK;
}

/* ASNH245TerminalCapabilitySetReject MakeMold */
HS_RESULT ASNH245TerminalCapabilitySetReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245TerminalCapabilitySetReject *pObj = (ASNH245TerminalCapabilitySetReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	return HS_OK;
}

/* ASNH245TerminalCapabilitySetReject Encode */
HS_RESULT ASNH245TerminalCapabilitySetReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TerminalCapabilitySetReject *pObj = (ASNH245TerminalCapabilitySetReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245TerminalCapabilitySetReject_cause_Encode( &(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245TerminalCapabilitySetReject Decode */
HS_RESULT ASNH245TerminalCapabilitySetReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TerminalCapabilitySetReject *pObj = (ASNH245TerminalCapabilitySetReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245TerminalCapabilitySetReject_cause_Decode(&(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TerminalCapabilitySetReject Print */
HS_RESULT ASNH245TerminalCapabilitySetReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TerminalCapabilitySetReject *pObj = (ASNH245TerminalCapabilitySetReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	ASNH245TerminalCapabilitySetReject_cause_Print( &(pObj->m_cause), pDepth+1, "cause" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters Struct
*/
/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters Constructor */
HS_RESULT new_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters( void *pObject )
{
	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters SetChoice */
void* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_SetChoice( void *pObject, ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt ){
		if( pChoice > (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice)(e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
		ASNH245H222LogicalChannelParameters *tAlter = (ASNH245H222LogicalChannelParameters *)HSMalloc( sizeof(ASNH245H222LogicalChannelParameters) );
		new_ASNH245H222LogicalChannelParameters(tAlter);
		ASNH245H222LogicalChannelParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		ASNH245H2250LogicalChannelParameters *tAlter = (ASNH245H2250LogicalChannelParameters *)HSMalloc( sizeof(ASNH245H2250LogicalChannelParameters) );
		new_ASNH245H2250LogicalChannelParameters(tAlter);
		ASNH245H2250LogicalChannelParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters DeleteAlternation */
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation(void *pObject)
{
	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
			delete_ASNH245H222LogicalChannelParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
			delete_ASNH245H2250LogicalChannelParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters Encode */
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSize )
		{
			if( pObj->choice > ((ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice)(e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSize)) )
	}
	else
	{
		if( e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
		if( (tRet=ASNH245H222LogicalChannelParameters_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245H2250LogicalChannelParameters_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters Decode */
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSize;
	}
	else
	{
		if( e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_SetChoice( pObj, (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
		if( (tRet=ASNH245H222LogicalChannelParameters_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245H2250LogicalChannelParameters_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters Print */
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h222LogicalChannelParameters ){
		ASNH245H222LogicalChannelParameters_Print( pObj->alter, pDepth+1, "h222LogicalChannelParameters" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters ){
		ASNH245H2250LogicalChannelParameters_Print( pObj->alter, pDepth+1, "h2250LogicalChannelParameters" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters Class
*/
/*ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters Constructor*/
HS_RESULT new_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters(void *pObject)
{
	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_reverseLogicalChannelNumber) );
	new_AsnInteger( &(pObj->m_portNumber), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters( &(pObj->m_multiplexParameters) );
	new_ASNH245LogicalChannelNumber( &(pObj->m_replacementFor) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters(void *pObject)
{
	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_reverseLogicalChannelNumber) );
	delete_AsnInteger( &(pObj->m_portNumber) );
	delete_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters( &(pObj->m_multiplexParameters) );
	delete_ASNH245LogicalChannelNumber( &(pObj->m_replacementFor) );
	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters MakeMold */
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_reverseLogicalChannelNumber));
	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_replacementFor));
	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters IncludeOptionalField */
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters IsIncludeOptionalField */
BOOL ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters Encode */
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_reverseLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_portNumber ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_portNumber),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_multiplexParameters ) ){
		if( (tRet=ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Encode( &(pObj->m_multiplexParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_replacementFor ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_replacementFor), ASNH245LogicalChannelNumber_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters Decode */
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_reverseLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_portNumber ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_portNumber),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_multiplexParameters ) ){
		if( (tRet=ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Decode(&(pObj->m_multiplexParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_replacementFor ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_replacementFor), ASNH245LogicalChannelNumber_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters Print */
HS_RESULT ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *pObj = (ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_reverseLogicalChannelNumber), pDepth+1, "reverseLogicalChannelNumber" );
	if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_portNumber ) )
		AsnInteger_Print( &(pObj->m_portNumber), pDepth+1, "portNumber" );
	if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_multiplexParameters ) )
		ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters_Print( &(pObj->m_multiplexParameters), pDepth+1, "multiplexParameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParametersOptionMap_replacementFor ) )
		ASNH245LogicalChannelNumber_Print( &(pObj->m_replacementFor), pDepth+1, "replacementFor" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H2250LogicalChannelAckParameters Class
*/
/*ASNH245H2250LogicalChannelAckParameters Constructor*/
HS_RESULT new_ASNH245H2250LogicalChannelAckParameters(void *pObject)
{
	ASNH245H2250LogicalChannelAckParameters *pObj = (ASNH245H2250LogicalChannelAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H2250LogicalChannelAckParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_nonStandard), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_sessionID), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245TransportAddress( &(pObj->m_mediaChannel) );
	new_ASNH245TransportAddress( &(pObj->m_mediaControlChannel) );
	new_AsnInteger( &(pObj->m_dynamicRTPPayloadType), e_constrained, 96, 127, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_flowControlToZero) );
	new_AsnInteger( &(pObj->m_portNumber), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H2250LogicalChannelAckParameters Destructor */
HS_RESULT delete_ASNH245H2250LogicalChannelAckParameters(void *pObject)
{
	ASNH245H2250LogicalChannelAckParameters *pObj = (ASNH245H2250LogicalChannelAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H2250LogicalChannelAckParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_nonStandard) );
	delete_AsnInteger( &(pObj->m_sessionID) );
	delete_ASNH245TransportAddress( &(pObj->m_mediaChannel) );
	delete_ASNH245TransportAddress( &(pObj->m_mediaControlChannel) );
	delete_AsnInteger( &(pObj->m_dynamicRTPPayloadType) );
	delete_AsnBoolean( &(pObj->m_flowControlToZero) );
	delete_AsnInteger( &(pObj->m_portNumber) );
	return HS_OK;
}

/* ASNH245H2250LogicalChannelAckParameters MakeMold */
HS_RESULT ASNH245H2250LogicalChannelAckParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H2250LogicalChannelAckParameters *pObj = (ASNH245H2250LogicalChannelAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245NonStandardParameter *tmold_nonStandard = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
	new_ASNH245NonStandardParameter(tmold_nonStandard);
	ASNH245NonStandardParameter_MakeMold(tmold_nonStandard);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_nonStandard,sizeof(ASNH245NonStandardParameter),ASNH245NonStandardParameter_MakeMold,ASNH245NonStandardParameter_Encode,ASNH245NonStandardParameter_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245NonStandardParameter_Print,
#endif
		delete_ASNH245NonStandardParameter);
	AsnSequenceOf_SetMold( &(pObj->m_nonStandard), moldObject );
	}
	ASNH245TransportAddress_MakeMold(&(pObj->m_mediaChannel));
	ASNH245TransportAddress_MakeMold(&(pObj->m_mediaControlChannel));
	return HS_OK;
}

/* ASNH245H2250LogicalChannelAckParameters IncludeOptionalField */
HS_RESULT ASNH245H2250LogicalChannelAckParameters_IncludeOptionField( void *pObject, ASNH245H2250LogicalChannelAckParametersOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H2250LogicalChannelAckParameters *pObj = (ASNH245H2250LogicalChannelAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H2250LogicalChannelAckParametersOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H2250LogicalChannelAckParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H2250LogicalChannelAckParametersOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245H2250LogicalChannelAckParameters IsIncludeOptionalField */
BOOL ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( void *pObject, ASNH245H2250LogicalChannelAckParametersOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H2250LogicalChannelAckParameters *pObj = (ASNH245H2250LogicalChannelAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H2250LogicalChannelAckParametersOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245H2250LogicalChannelAckParametersOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H2250LogicalChannelAckParametersOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H2250LogicalChannelAckParameters Encode */
HS_RESULT ASNH245H2250LogicalChannelAckParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H2250LogicalChannelAckParameters *pObj = (ASNH245H2250LogicalChannelAckParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245H2250LogicalChannelAckParametersOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245H2250LogicalChannelAckParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_nonStandard ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_nonStandard),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_sessionID ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_sessionID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaChannel ) ){
		if( (tRet=ASNH245TransportAddress_Encode( &(pObj->m_mediaChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaControlChannel ) ){
		if( (tRet=ASNH245TransportAddress_Encode( &(pObj->m_mediaControlChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_dynamicRTPPayloadType ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_dynamicRTPPayloadType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_flowControlToZero ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_flowControlToZero), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_portNumber ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_portNumber), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H2250LogicalChannelAckParameters Decode */
HS_RESULT ASNH245H2250LogicalChannelAckParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H2250LogicalChannelAckParameters *pObj = (ASNH245H2250LogicalChannelAckParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245H2250LogicalChannelAckParametersOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245H2250LogicalChannelAckParametersOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_nonStandard ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_nonStandard),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_sessionID ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_sessionID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaChannel ) ){
		if( (tRet=ASNH245TransportAddress_Decode(&(pObj->m_mediaChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaControlChannel ) ){
		if( (tRet=ASNH245TransportAddress_Decode(&(pObj->m_mediaControlChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_dynamicRTPPayloadType ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_dynamicRTPPayloadType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_flowControlToZero ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_flowControlToZero), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_portNumber ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_portNumber), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H2250LogicalChannelAckParameters Print */
HS_RESULT ASNH245H2250LogicalChannelAckParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H2250LogicalChannelAckParameters *pObj = (ASNH245H2250LogicalChannelAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H2250LogicalChannelAckParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_nonStandard ) )
		AsnSequenceOf_Print( &(pObj->m_nonStandard), pDepth+1, "nonStandard" );
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_sessionID ) )
		AsnInteger_Print( &(pObj->m_sessionID), pDepth+1, "sessionID" );
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaChannel ) )
		ASNH245TransportAddress_Print( &(pObj->m_mediaChannel), pDepth+1, "mediaChannel" );
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_mediaControlChannel ) )
		ASNH245TransportAddress_Print( &(pObj->m_mediaControlChannel), pDepth+1, "mediaControlChannel" );
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_dynamicRTPPayloadType ) )
		AsnInteger_Print( &(pObj->m_dynamicRTPPayloadType), pDepth+1, "dynamicRTPPayloadType" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_flowControlToZero ) )
		AsnBoolean_Print( &(pObj->m_flowControlToZero), pDepth+1, "flowControlToZero" );
	if( ASNH245H2250LogicalChannelAckParameters_IsIncludeOptionField( pObj, e_ASNH245H2250LogicalChannelAckParametersOptionMap_portNumber ) )
		AsnInteger_Print( &(pObj->m_portNumber), pDepth+1, "portNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters Struct
*/
/* ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters Constructor */
HS_RESULT new_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters( void *pObject )
{
	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *pObj = (ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice_h2250LogicalChannelAckParameters;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *pObj = (ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters SetChoice */
void* ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_SetChoice( void *pObject, ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *pObj = (ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSizeExt ){
		if( pChoice > (ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice)(e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice_h2250LogicalChannelAckParameters ){
		ASNH245H2250LogicalChannelAckParameters *tAlter = (ASNH245H2250LogicalChannelAckParameters *)HSMalloc( sizeof(ASNH245H2250LogicalChannelAckParameters) );
		new_ASNH245H2250LogicalChannelAckParameters(tAlter);
		ASNH245H2250LogicalChannelAckParameters_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters DeleteAlternation */
HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_DeleteAlternation(void *pObject)
{
	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *pObj = (ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice_h2250LogicalChannelAckParameters ){
			delete_ASNH245H2250LogicalChannelAckParameters(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters Encode */
HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *pObj = (ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSize )
		{
			if( pObj->choice > ((ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice)(e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSize)) )
	}
	else
	{
		if( e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice_h2250LogicalChannelAckParameters ){
		if( (tRet=ASNH245H2250LogicalChannelAckParameters_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters Decode */
HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *pObj = (ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSize;
	}
	else
	{
		if( e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_SetChoice( pObj, (ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice_h2250LogicalChannelAckParameters ){
		if( (tRet=ASNH245H2250LogicalChannelAckParameters_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters Print */
HS_RESULT ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *pObj = (ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParametersChoice_h2250LogicalChannelAckParameters ){
		ASNH245H2250LogicalChannelAckParameters_Print( pObj->alter, pDepth+1, "h2250LogicalChannelAckParameters" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannelAck Class
*/
/*ASNH245OpenLogicalChannelAck Constructor*/
HS_RESULT new_ASNH245OpenLogicalChannelAck(void *pObject)
{
	ASNH245OpenLogicalChannelAck *pObj = (ASNH245OpenLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannelAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	new_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters( &(pObj->m_reverseLogicalChannelParameters) );
	new_ASNH245NetworkAccessParameters( &(pObj->m_separateStack) );
	new_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters( &(pObj->m_forwardMultiplexAckParameters) );
	new_ASNH245EncryptionSync( &(pObj->m_encryptionSync) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannelAck(void *pObject)
{
	ASNH245OpenLogicalChannelAck *pObj = (ASNH245OpenLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	delete_ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters( &(pObj->m_reverseLogicalChannelParameters) );
	delete_ASNH245NetworkAccessParameters( &(pObj->m_separateStack) );
	delete_ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters( &(pObj->m_forwardMultiplexAckParameters) );
	delete_ASNH245EncryptionSync( &(pObj->m_encryptionSync) );
	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck MakeMold */
HS_RESULT ASNH245OpenLogicalChannelAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245OpenLogicalChannelAck *pObj = (ASNH245OpenLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_MakeMold(&(pObj->m_reverseLogicalChannelParameters));
	ASNH245NetworkAccessParameters_MakeMold(&(pObj->m_separateStack));
	ASNH245EncryptionSync_MakeMold(&(pObj->m_encryptionSync));
	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck IncludeOptionalField */
HS_RESULT ASNH245OpenLogicalChannelAck_IncludeOptionField( void *pObject, ASNH245OpenLogicalChannelAckOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannelAck *pObj = (ASNH245OpenLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannelAckOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannelAckOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannelAckOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck IsIncludeOptionalField */
BOOL ASNH245OpenLogicalChannelAck_IsIncludeOptionField( void *pObject, ASNH245OpenLogicalChannelAckOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245OpenLogicalChannelAck *pObj = (ASNH245OpenLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245OpenLogicalChannelAckOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245OpenLogicalChannelAckOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245OpenLogicalChannelAckOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245OpenLogicalChannelAck Encode */
HS_RESULT ASNH245OpenLogicalChannelAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannelAck *pObj = (ASNH245OpenLogicalChannelAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannelAckOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannelAckOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_reverseLogicalChannelParameters ) ){
		if( (tRet=ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Encode( &(pObj->m_reverseLogicalChannelParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_separateStack ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_separateStack), ASNH245NetworkAccessParameters_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_forwardMultiplexAckParameters ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_forwardMultiplexAckParameters), ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_encryptionSync ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_encryptionSync), ASNH245EncryptionSync_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245OpenLogicalChannelAck Decode */
HS_RESULT ASNH245OpenLogicalChannelAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannelAck *pObj = (ASNH245OpenLogicalChannelAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245OpenLogicalChannelAckOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245OpenLogicalChannelAckOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_reverseLogicalChannelParameters ) ){
		if( (tRet=ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Decode(&(pObj->m_reverseLogicalChannelParameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_separateStack ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_separateStack), ASNH245NetworkAccessParameters_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_forwardMultiplexAckParameters ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_forwardMultiplexAckParameters), ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_encryptionSync ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_encryptionSync), ASNH245EncryptionSync_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannelAck Print */
HS_RESULT ASNH245OpenLogicalChannelAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannelAck *pObj = (ASNH245OpenLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannelAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_reverseLogicalChannelParameters ) )
		ASNH245OpenLogicalChannelAck_reverseLogicalChannelParameters_Print( &(pObj->m_reverseLogicalChannelParameters), pDepth+1, "reverseLogicalChannelParameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_separateStack ) )
		ASNH245NetworkAccessParameters_Print( &(pObj->m_separateStack), pDepth+1, "separateStack" );
	if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_forwardMultiplexAckParameters ) )
		ASNH245OpenLogicalChannelAck_forwardMultiplexAckParameters_Print( &(pObj->m_forwardMultiplexAckParameters), pDepth+1, "forwardMultiplexAckParameters" );
	if( ASNH245OpenLogicalChannelAck_IsIncludeOptionField( pObj, e_ASNH245OpenLogicalChannelAckOptionMap_encryptionSync ) )
		ASNH245EncryptionSync_Print( &(pObj->m_encryptionSync), pDepth+1, "encryptionSync" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannelReject_cause Struct
*/
/* ASNH245OpenLogicalChannelReject_cause Constructor */
HS_RESULT new_ASNH245OpenLogicalChannelReject_cause( void *pObject )
{
	ASNH245OpenLogicalChannelReject_cause *pObj = (ASNH245OpenLogicalChannelReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannelReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245OpenLogicalChannelReject_causeChoice_unspecified;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245OpenLogicalChannelReject_causeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245OpenLogicalChannelReject_cause Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannelReject_cause( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245OpenLogicalChannelReject_cause *pObj = (ASNH245OpenLogicalChannelReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245OpenLogicalChannelReject_cause_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelReject_cause(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245OpenLogicalChannelReject_cause SetChoice */
void* ASNH245OpenLogicalChannelReject_cause_SetChoice( void *pObject, ASNH245OpenLogicalChannelReject_causeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245OpenLogicalChannelReject_cause *pObj = (ASNH245OpenLogicalChannelReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245OpenLogicalChannelReject_causeChoiceSizeExt ){
		if( pChoice > (ASNH245OpenLogicalChannelReject_causeChoice)(e_ASNH245OpenLogicalChannelReject_causeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245OpenLogicalChannelReject_cause_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_unspecified ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_unsuitableReverseParameters ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotSupported ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotAvailable ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_unknownDataType ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeALCombinationNotSupported ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_multicastChannelNotAllowed ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_insufficientBandwidth ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_separateStackEstablishmentFailed ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidSessionID ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_masterSlaveConflict ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_waitForCommunicationMode ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidDependentChannel ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245OpenLogicalChannelReject_causeChoice_replacementForRejected ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245OpenLogicalChannelReject_cause DeleteAlternation */
HS_RESULT ASNH245OpenLogicalChannelReject_cause_DeleteAlternation(void *pObject)
{
	ASNH245OpenLogicalChannelReject_cause *pObj = (ASNH245OpenLogicalChannelReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unspecified ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unsuitableReverseParameters ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotSupported ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotAvailable ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unknownDataType ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeALCombinationNotSupported ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_multicastChannelNotAllowed ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_insufficientBandwidth ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_separateStackEstablishmentFailed ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidSessionID ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_masterSlaveConflict ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_waitForCommunicationMode ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidDependentChannel ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_replacementForRejected ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245OpenLogicalChannelReject_cause_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245OpenLogicalChannelReject_cause Encode */
HS_RESULT ASNH245OpenLogicalChannelReject_cause_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannelReject_cause *pObj = (ASNH245OpenLogicalChannelReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245OpenLogicalChannelReject_causeChoiceSize )
		{
			if( pObj->choice > ((ASNH245OpenLogicalChannelReject_causeChoice)(e_ASNH245OpenLogicalChannelReject_causeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245OpenLogicalChannelReject_causeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245OpenLogicalChannelReject_causeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unspecified ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unsuitableReverseParameters ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotSupported ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotAvailable ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unknownDataType ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeALCombinationNotSupported ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_multicastChannelNotAllowed ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_insufficientBandwidth ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_separateStackEstablishmentFailed ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidSessionID ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_masterSlaveConflict ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_waitForCommunicationMode ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidDependentChannel ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_replacementForRejected ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannelReject_cause Decode */
HS_RESULT ASNH245OpenLogicalChannelReject_cause_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245OpenLogicalChannelReject_cause *pObj = (ASNH245OpenLogicalChannelReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245OpenLogicalChannelReject_causeChoiceSize;
	}
	else
	{
		if( e_ASNH245OpenLogicalChannelReject_causeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245OpenLogicalChannelReject_causeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245OpenLogicalChannelReject_causeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245OpenLogicalChannelReject_cause_SetChoice( pObj, (ASNH245OpenLogicalChannelReject_causeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unspecified ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unsuitableReverseParameters ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotSupported ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotAvailable ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unknownDataType ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeALCombinationNotSupported ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_multicastChannelNotAllowed ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_insufficientBandwidth ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_separateStackEstablishmentFailed ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidSessionID ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_masterSlaveConflict ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_waitForCommunicationMode ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidDependentChannel ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_replacementForRejected ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannelReject_cause Print */
HS_RESULT ASNH245OpenLogicalChannelReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannelReject_cause *pObj = (ASNH245OpenLogicalChannelReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_cause_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unspecified ){
		AsnNull_Print( pObj->alter, pDepth+1, "unspecified" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unsuitableReverseParameters ){
		AsnNull_Print( pObj->alter, pDepth+1, "unsuitableReverseParameters" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotSupported ){
		AsnNull_Print( pObj->alter, pDepth+1, "dataTypeNotSupported" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeNotAvailable ){
		AsnNull_Print( pObj->alter, pDepth+1, "dataTypeNotAvailable" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_unknownDataType ){
		AsnNull_Print( pObj->alter, pDepth+1, "unknownDataType" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_dataTypeALCombinationNotSupported ){
		AsnNull_Print( pObj->alter, pDepth+1, "dataTypeALCombinationNotSupported" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_multicastChannelNotAllowed ){
		AsnNull_Print( pObj->alter, pDepth+1, "multicastChannelNotAllowed" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_insufficientBandwidth ){
		AsnNull_Print( pObj->alter, pDepth+1, "insufficientBandwidth" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_separateStackEstablishmentFailed ){
		AsnNull_Print( pObj->alter, pDepth+1, "separateStackEstablishmentFailed" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidSessionID ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidSessionID" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_masterSlaveConflict ){
		AsnNull_Print( pObj->alter, pDepth+1, "masterSlaveConflict" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_waitForCommunicationMode ){
		AsnNull_Print( pObj->alter, pDepth+1, "waitForCommunicationMode" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_invalidDependentChannel ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidDependentChannel" );
	}
	else if ( pObj->choice == e_ASNH245OpenLogicalChannelReject_causeChoice_replacementForRejected ){
		AsnNull_Print( pObj->alter, pDepth+1, "replacementForRejected" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannelReject Class
*/
/*ASNH245OpenLogicalChannelReject Constructor*/
HS_RESULT new_ASNH245OpenLogicalChannelReject(void *pObject)
{
	ASNH245OpenLogicalChannelReject *pObj = (ASNH245OpenLogicalChannelReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannelReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	new_ASNH245OpenLogicalChannelReject_cause( &(pObj->m_cause) );

	return HS_OK;
}

/* ASNH245OpenLogicalChannelReject Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannelReject(void *pObject)
{
	ASNH245OpenLogicalChannelReject *pObj = (ASNH245OpenLogicalChannelReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	delete_ASNH245OpenLogicalChannelReject_cause( &(pObj->m_cause) );
	return HS_OK;
}

/* ASNH245OpenLogicalChannelReject MakeMold */
HS_RESULT ASNH245OpenLogicalChannelReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245OpenLogicalChannelReject *pObj = (ASNH245OpenLogicalChannelReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	return HS_OK;
}

/* ASNH245OpenLogicalChannelReject Encode */
HS_RESULT ASNH245OpenLogicalChannelReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245OpenLogicalChannelReject *pObj = (ASNH245OpenLogicalChannelReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245OpenLogicalChannelReject_cause_Encode( &(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannelReject Decode */
HS_RESULT ASNH245OpenLogicalChannelReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245OpenLogicalChannelReject *pObj = (ASNH245OpenLogicalChannelReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245OpenLogicalChannelReject_cause_Decode(&(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannelReject Print */
HS_RESULT ASNH245OpenLogicalChannelReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannelReject *pObj = (ASNH245OpenLogicalChannelReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannelReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	ASNH245OpenLogicalChannelReject_cause_Print( &(pObj->m_cause), pDepth+1, "cause" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CloseLogicalChannelAck Class
*/
/*ASNH245CloseLogicalChannelAck Constructor*/
HS_RESULT new_ASNH245CloseLogicalChannelAck(void *pObject)
{
	ASNH245CloseLogicalChannelAck *pObj = (ASNH245CloseLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CloseLogicalChannelAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );

	return HS_OK;
}

/* ASNH245CloseLogicalChannelAck Destructor */
HS_RESULT delete_ASNH245CloseLogicalChannelAck(void *pObject)
{
	ASNH245CloseLogicalChannelAck *pObj = (ASNH245CloseLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CloseLogicalChannelAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	return HS_OK;
}

/* ASNH245CloseLogicalChannelAck MakeMold */
HS_RESULT ASNH245CloseLogicalChannelAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CloseLogicalChannelAck *pObj = (ASNH245CloseLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannelAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	return HS_OK;
}

/* ASNH245CloseLogicalChannelAck Encode */
HS_RESULT ASNH245CloseLogicalChannelAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CloseLogicalChannelAck *pObj = (ASNH245CloseLogicalChannelAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannelAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannelAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245CloseLogicalChannelAck Decode */
HS_RESULT ASNH245CloseLogicalChannelAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CloseLogicalChannelAck *pObj = (ASNH245CloseLogicalChannelAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannelAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CloseLogicalChannelAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CloseLogicalChannelAck Print */
HS_RESULT ASNH245CloseLogicalChannelAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CloseLogicalChannelAck *pObj = (ASNH245CloseLogicalChannelAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CloseLogicalChannelAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestChannelCloseAck Class
*/
/*ASNH245RequestChannelCloseAck Constructor*/
HS_RESULT new_ASNH245RequestChannelCloseAck(void *pObject)
{
	ASNH245RequestChannelCloseAck *pObj = (ASNH245RequestChannelCloseAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestChannelCloseAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );

	return HS_OK;
}

/* ASNH245RequestChannelCloseAck Destructor */
HS_RESULT delete_ASNH245RequestChannelCloseAck(void *pObject)
{
	ASNH245RequestChannelCloseAck *pObj = (ASNH245RequestChannelCloseAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestChannelCloseAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	return HS_OK;
}

/* ASNH245RequestChannelCloseAck MakeMold */
HS_RESULT ASNH245RequestChannelCloseAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestChannelCloseAck *pObj = (ASNH245RequestChannelCloseAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	return HS_OK;
}

/* ASNH245RequestChannelCloseAck Encode */
HS_RESULT ASNH245RequestChannelCloseAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestChannelCloseAck *pObj = (ASNH245RequestChannelCloseAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestChannelCloseAck Decode */
HS_RESULT ASNH245RequestChannelCloseAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestChannelCloseAck *pObj = (ASNH245RequestChannelCloseAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestChannelCloseAck Print */
HS_RESULT ASNH245RequestChannelCloseAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestChannelCloseAck *pObj = (ASNH245RequestChannelCloseAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestChannelCloseAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestChannelCloseReject_cause Struct
*/
/* ASNH245RequestChannelCloseReject_cause Constructor */
HS_RESULT new_ASNH245RequestChannelCloseReject_cause( void *pObject )
{
	ASNH245RequestChannelCloseReject_cause *pObj = (ASNH245RequestChannelCloseReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestChannelCloseReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RequestChannelCloseReject_causeChoice_unspecified;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RequestChannelCloseReject_causeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RequestChannelCloseReject_cause Destructor */
HS_RESULT delete_ASNH245RequestChannelCloseReject_cause( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RequestChannelCloseReject_cause *pObj = (ASNH245RequestChannelCloseReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestChannelCloseReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RequestChannelCloseReject_cause_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestChannelCloseReject_cause(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RequestChannelCloseReject_cause SetChoice */
void* ASNH245RequestChannelCloseReject_cause_SetChoice( void *pObject, ASNH245RequestChannelCloseReject_causeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RequestChannelCloseReject_cause *pObj = (ASNH245RequestChannelCloseReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RequestChannelCloseReject_causeChoiceSizeExt ){
		if( pChoice > (ASNH245RequestChannelCloseReject_causeChoice)(e_ASNH245RequestChannelCloseReject_causeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RequestChannelCloseReject_cause_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RequestChannelCloseReject_causeChoice_unspecified ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RequestChannelCloseReject_cause DeleteAlternation */
HS_RESULT ASNH245RequestChannelCloseReject_cause_DeleteAlternation(void *pObject)
{
	ASNH245RequestChannelCloseReject_cause *pObj = (ASNH245RequestChannelCloseReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RequestChannelCloseReject_causeChoice_unspecified ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RequestChannelCloseReject_cause_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RequestChannelCloseReject_cause Encode */
HS_RESULT ASNH245RequestChannelCloseReject_cause_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RequestChannelCloseReject_cause *pObj = (ASNH245RequestChannelCloseReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RequestChannelCloseReject_causeChoiceSize )
		{
			if( pObj->choice > ((ASNH245RequestChannelCloseReject_causeChoice)(e_ASNH245RequestChannelCloseReject_causeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RequestChannelCloseReject_causeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RequestChannelCloseReject_causeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestChannelCloseReject_causeChoice_unspecified ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RequestChannelCloseReject_cause Decode */
HS_RESULT ASNH245RequestChannelCloseReject_cause_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RequestChannelCloseReject_cause *pObj = (ASNH245RequestChannelCloseReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RequestChannelCloseReject_causeChoiceSize;
	}
	else
	{
		if( e_ASNH245RequestChannelCloseReject_causeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RequestChannelCloseReject_causeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RequestChannelCloseReject_causeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RequestChannelCloseReject_cause_SetChoice( pObj, (ASNH245RequestChannelCloseReject_causeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestChannelCloseReject_causeChoice_unspecified ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestChannelCloseReject_cause Print */
HS_RESULT ASNH245RequestChannelCloseReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestChannelCloseReject_cause *pObj = (ASNH245RequestChannelCloseReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_cause_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestChannelCloseReject_causeChoice_unspecified ){
		AsnNull_Print( pObj->alter, pDepth+1, "unspecified" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestChannelCloseReject Class
*/
/*ASNH245RequestChannelCloseReject Constructor*/
HS_RESULT new_ASNH245RequestChannelCloseReject(void *pObject)
{
	ASNH245RequestChannelCloseReject *pObj = (ASNH245RequestChannelCloseReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestChannelCloseReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	new_ASNH245RequestChannelCloseReject_cause( &(pObj->m_cause) );

	return HS_OK;
}

/* ASNH245RequestChannelCloseReject Destructor */
HS_RESULT delete_ASNH245RequestChannelCloseReject(void *pObject)
{
	ASNH245RequestChannelCloseReject *pObj = (ASNH245RequestChannelCloseReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestChannelCloseReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	delete_ASNH245RequestChannelCloseReject_cause( &(pObj->m_cause) );
	return HS_OK;
}

/* ASNH245RequestChannelCloseReject MakeMold */
HS_RESULT ASNH245RequestChannelCloseReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestChannelCloseReject *pObj = (ASNH245RequestChannelCloseReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	return HS_OK;
}

/* ASNH245RequestChannelCloseReject Encode */
HS_RESULT ASNH245RequestChannelCloseReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestChannelCloseReject *pObj = (ASNH245RequestChannelCloseReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RequestChannelCloseReject_cause_Encode( &(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestChannelCloseReject Decode */
HS_RESULT ASNH245RequestChannelCloseReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestChannelCloseReject *pObj = (ASNH245RequestChannelCloseReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RequestChannelCloseReject_cause_Decode(&(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestChannelCloseReject Print */
HS_RESULT ASNH245RequestChannelCloseReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestChannelCloseReject *pObj = (ASNH245RequestChannelCloseReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestChannelCloseReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	ASNH245RequestChannelCloseReject_cause_Print( &(pObj->m_cause), pDepth+1, "cause" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexEntrySendAck Class
*/
/*ASNH245MultiplexEntrySendAck Constructor*/
HS_RESULT new_ASNH245MultiplexEntrySendAck(void *pObject)
{
	ASNH245MultiplexEntrySendAck *pObj = (ASNH245MultiplexEntrySendAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexEntrySendAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	new_AsnSequenceOf( &(pObj->m_multiplexTableEntryNumber), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MultiplexEntrySendAck Destructor */
HS_RESULT delete_ASNH245MultiplexEntrySendAck(void *pObject)
{
	ASNH245MultiplexEntrySendAck *pObj = (ASNH245MultiplexEntrySendAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexEntrySendAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	delete_AsnSequenceOf( &(pObj->m_multiplexTableEntryNumber) );
	return HS_OK;
}

/* ASNH245MultiplexEntrySendAck MakeMold */
HS_RESULT ASNH245MultiplexEntrySendAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultiplexEntrySendAck *pObj = (ASNH245MultiplexEntrySendAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	{
	ASNH245MultiplexTableEntryNumber *tmold_multiplexTableEntryNumber = (ASNH245MultiplexTableEntryNumber *)HSMalloc( sizeof(ASNH245MultiplexTableEntryNumber) );
	new_ASNH245MultiplexTableEntryNumber(tmold_multiplexTableEntryNumber);
	ASNH245MultiplexTableEntryNumber_MakeMold(tmold_multiplexTableEntryNumber);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_multiplexTableEntryNumber,sizeof(ASNH245MultiplexTableEntryNumber),ASNH245MultiplexTableEntryNumber_MakeMold,ASNH245MultiplexTableEntryNumber_Encode,ASNH245MultiplexTableEntryNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MultiplexTableEntryNumber_Print,
#endif
		delete_ASNH245MultiplexTableEntryNumber);
	AsnSequenceOf_SetMold( &(pObj->m_multiplexTableEntryNumber), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_multiplexTableEntryNumber.constraint.type = e_constrained;
	pObj->m_multiplexTableEntryNumber.constraint.minValue = 1;
	pObj->m_multiplexTableEntryNumber.constraint.maxValue = 15;
	pObj->m_multiplexTableEntryNumber.extMinValue = 0;
	pObj->m_multiplexTableEntryNumber.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245MultiplexEntrySendAck Encode */
HS_RESULT ASNH245MultiplexEntrySendAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntrySendAck *pObj = (ASNH245MultiplexEntrySendAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultiplexEntrySendAck Decode */
HS_RESULT ASNH245MultiplexEntrySendAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntrySendAck *pObj = (ASNH245MultiplexEntrySendAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexEntrySendAck Print */
HS_RESULT ASNH245MultiplexEntrySendAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexEntrySendAck *pObj = (ASNH245MultiplexEntrySendAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexEntrySendAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	AsnSequenceOf_Print( &(pObj->m_multiplexTableEntryNumber), pDepth+1, "multiplexTableEntryNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexEntryRejectionDescriptions_cause Struct
*/
/* ASNH245MultiplexEntryRejectionDescriptions_cause Constructor */
HS_RESULT new_ASNH245MultiplexEntryRejectionDescriptions_cause( void *pObject )
{
	ASNH245MultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245MultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexEntryRejectionDescriptions_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MultiplexEntryRejectionDescriptions_cause Destructor */
HS_RESULT delete_ASNH245MultiplexEntryRejectionDescriptions_cause( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245MultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexEntryRejectionDescriptions_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MultiplexEntryRejectionDescriptions_cause_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexEntryRejectionDescriptions_cause(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MultiplexEntryRejectionDescriptions_cause SetChoice */
void* ASNH245MultiplexEntryRejectionDescriptions_cause_SetChoice( void *pObject, ASNH245MultiplexEntryRejectionDescriptions_causeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245MultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSizeExt ){
		if( pChoice > (ASNH245MultiplexEntryRejectionDescriptions_causeChoice)(e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MultiplexEntryRejectionDescriptions_cause_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_descriptorTooComplex ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MultiplexEntryRejectionDescriptions_cause DeleteAlternation */
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_DeleteAlternation(void *pObject)
{
	ASNH245MultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245MultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_descriptorTooComplex ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MultiplexEntryRejectionDescriptions_cause Encode */
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245MultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MultiplexEntryRejectionDescriptions_causeChoice)(e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_descriptorTooComplex ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MultiplexEntryRejectionDescriptions_cause Decode */
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245MultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSize;
	}
	else
	{
		if( e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MultiplexEntryRejectionDescriptions_causeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MultiplexEntryRejectionDescriptions_cause_SetChoice( pObj, (ASNH245MultiplexEntryRejectionDescriptions_causeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_descriptorTooComplex ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexEntryRejectionDescriptions_cause Print */
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245MultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_cause_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
		AsnNull_Print( pObj->alter, pDepth+1, "unspecifiedCause" );
	}
	else if ( pObj->choice == e_ASNH245MultiplexEntryRejectionDescriptions_causeChoice_descriptorTooComplex ){
		AsnNull_Print( pObj->alter, pDepth+1, "descriptorTooComplex" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexEntryRejectionDescriptions Class
*/
/*ASNH245MultiplexEntryRejectionDescriptions Constructor*/
HS_RESULT new_ASNH245MultiplexEntryRejectionDescriptions(void *pObject)
{
	ASNH245MultiplexEntryRejectionDescriptions *pObj = (ASNH245MultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexEntryRejectionDescriptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245MultiplexTableEntryNumber( &(pObj->m_multiplexTableEntryNumber) );
	new_ASNH245MultiplexEntryRejectionDescriptions_cause( &(pObj->m_cause) );

	return HS_OK;
}

/* ASNH245MultiplexEntryRejectionDescriptions Destructor */
HS_RESULT delete_ASNH245MultiplexEntryRejectionDescriptions(void *pObject)
{
	ASNH245MultiplexEntryRejectionDescriptions *pObj = (ASNH245MultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexEntryRejectionDescriptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MultiplexTableEntryNumber( &(pObj->m_multiplexTableEntryNumber) );
	delete_ASNH245MultiplexEntryRejectionDescriptions_cause( &(pObj->m_cause) );
	return HS_OK;
}

/* ASNH245MultiplexEntryRejectionDescriptions MakeMold */
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultiplexEntryRejectionDescriptions *pObj = (ASNH245MultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245MultiplexTableEntryNumber_MakeMold(&(pObj->m_multiplexTableEntryNumber));
	return HS_OK;
}

/* ASNH245MultiplexEntryRejectionDescriptions Encode */
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntryRejectionDescriptions *pObj = (ASNH245MultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245MultiplexTableEntryNumber_Encode( &(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultiplexEntryRejectionDescriptions_cause_Encode( &(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultiplexEntryRejectionDescriptions Decode */
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntryRejectionDescriptions *pObj = (ASNH245MultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245MultiplexTableEntryNumber_Decode(&(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MultiplexEntryRejectionDescriptions_cause_Decode(&(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexEntryRejectionDescriptions Print */
HS_RESULT ASNH245MultiplexEntryRejectionDescriptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexEntryRejectionDescriptions *pObj = (ASNH245MultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexEntryRejectionDescriptions_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MultiplexTableEntryNumber_Print( &(pObj->m_multiplexTableEntryNumber), pDepth+1, "multiplexTableEntryNumber" );
	ASNH245MultiplexEntryRejectionDescriptions_cause_Print( &(pObj->m_cause), pDepth+1, "cause" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexEntrySendReject Class
*/
/*ASNH245MultiplexEntrySendReject Constructor*/
HS_RESULT new_ASNH245MultiplexEntrySendReject(void *pObject)
{
	ASNH245MultiplexEntrySendReject *pObj = (ASNH245MultiplexEntrySendReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexEntrySendReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	new_AsnSequenceOf( &(pObj->m_rejectionDescriptions), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MultiplexEntrySendReject Destructor */
HS_RESULT delete_ASNH245MultiplexEntrySendReject(void *pObject)
{
	ASNH245MultiplexEntrySendReject *pObj = (ASNH245MultiplexEntrySendReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexEntrySendReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	delete_AsnSequenceOf( &(pObj->m_rejectionDescriptions) );
	return HS_OK;
}

/* ASNH245MultiplexEntrySendReject MakeMold */
HS_RESULT ASNH245MultiplexEntrySendReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultiplexEntrySendReject *pObj = (ASNH245MultiplexEntrySendReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	{
	ASNH245MultiplexEntryRejectionDescriptions *tmold_rejectionDescriptions = (ASNH245MultiplexEntryRejectionDescriptions *)HSMalloc( sizeof(ASNH245MultiplexEntryRejectionDescriptions) );
	new_ASNH245MultiplexEntryRejectionDescriptions(tmold_rejectionDescriptions);
	ASNH245MultiplexEntryRejectionDescriptions_MakeMold(tmold_rejectionDescriptions);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_rejectionDescriptions,sizeof(ASNH245MultiplexEntryRejectionDescriptions),ASNH245MultiplexEntryRejectionDescriptions_MakeMold,ASNH245MultiplexEntryRejectionDescriptions_Encode,ASNH245MultiplexEntryRejectionDescriptions_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MultiplexEntryRejectionDescriptions_Print,
#endif
		delete_ASNH245MultiplexEntryRejectionDescriptions);
	AsnSequenceOf_SetMold( &(pObj->m_rejectionDescriptions), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_rejectionDescriptions.constraint.type = e_constrained;
	pObj->m_rejectionDescriptions.constraint.minValue = 1;
	pObj->m_rejectionDescriptions.constraint.maxValue = 15;
	pObj->m_rejectionDescriptions.extMinValue = 0;
	pObj->m_rejectionDescriptions.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245MultiplexEntrySendReject Encode */
HS_RESULT ASNH245MultiplexEntrySendReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntrySendReject *pObj = (ASNH245MultiplexEntrySendReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_rejectionDescriptions),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultiplexEntrySendReject Decode */
HS_RESULT ASNH245MultiplexEntrySendReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntrySendReject *pObj = (ASNH245MultiplexEntrySendReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_rejectionDescriptions),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexEntrySendReject Print */
HS_RESULT ASNH245MultiplexEntrySendReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexEntrySendReject *pObj = (ASNH245MultiplexEntrySendReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexEntrySendReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	AsnSequenceOf_Print( &(pObj->m_rejectionDescriptions), pDepth+1, "rejectionDescriptions" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestMultiplexEntryAck Class
*/
/*ASNH245RequestMultiplexEntryAck Constructor*/
HS_RESULT new_ASNH245RequestMultiplexEntryAck(void *pObject)
{
	ASNH245RequestMultiplexEntryAck *pObj = (ASNH245RequestMultiplexEntryAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestMultiplexEntryAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_entryNumbers), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245RequestMultiplexEntryAck Destructor */
HS_RESULT delete_ASNH245RequestMultiplexEntryAck(void *pObject)
{
	ASNH245RequestMultiplexEntryAck *pObj = (ASNH245RequestMultiplexEntryAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMultiplexEntryAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_entryNumbers) );
	return HS_OK;
}

/* ASNH245RequestMultiplexEntryAck MakeMold */
HS_RESULT ASNH245RequestMultiplexEntryAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestMultiplexEntryAck *pObj = (ASNH245RequestMultiplexEntryAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245MultiplexTableEntryNumber *tmold_entryNumbers = (ASNH245MultiplexTableEntryNumber *)HSMalloc( sizeof(ASNH245MultiplexTableEntryNumber) );
	new_ASNH245MultiplexTableEntryNumber(tmold_entryNumbers);
	ASNH245MultiplexTableEntryNumber_MakeMold(tmold_entryNumbers);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_entryNumbers,sizeof(ASNH245MultiplexTableEntryNumber),ASNH245MultiplexTableEntryNumber_MakeMold,ASNH245MultiplexTableEntryNumber_Encode,ASNH245MultiplexTableEntryNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MultiplexTableEntryNumber_Print,
#endif
		delete_ASNH245MultiplexTableEntryNumber);
	AsnSequenceOf_SetMold( &(pObj->m_entryNumbers), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_entryNumbers.constraint.type = e_constrained;
	pObj->m_entryNumbers.constraint.minValue = 1;
	pObj->m_entryNumbers.constraint.maxValue = 15;
	pObj->m_entryNumbers.extMinValue = 0;
	pObj->m_entryNumbers.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245RequestMultiplexEntryAck Encode */
HS_RESULT ASNH245RequestMultiplexEntryAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntryAck *pObj = (ASNH245RequestMultiplexEntryAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_entryNumbers),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestMultiplexEntryAck Decode */
HS_RESULT ASNH245RequestMultiplexEntryAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntryAck *pObj = (ASNH245RequestMultiplexEntryAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_entryNumbers),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestMultiplexEntryAck Print */
HS_RESULT ASNH245RequestMultiplexEntryAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestMultiplexEntryAck *pObj = (ASNH245RequestMultiplexEntryAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSequenceOf_Print( &(pObj->m_entryNumbers), pDepth+1, "entryNumbers" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestMultiplexEntryRejectionDescriptions_cause Struct
*/
/* ASNH245RequestMultiplexEntryRejectionDescriptions_cause Constructor */
HS_RESULT new_ASNH245RequestMultiplexEntryRejectionDescriptions_cause( void *pObject )
{
	ASNH245RequestMultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestMultiplexEntryRejectionDescriptions_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RequestMultiplexEntryRejectionDescriptions_cause Destructor */
HS_RESULT delete_ASNH245RequestMultiplexEntryRejectionDescriptions_cause( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RequestMultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMultiplexEntryRejectionDescriptions_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RequestMultiplexEntryRejectionDescriptions_cause_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMultiplexEntryRejectionDescriptions_cause(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RequestMultiplexEntryRejectionDescriptions_cause SetChoice */
void* ASNH245RequestMultiplexEntryRejectionDescriptions_cause_SetChoice( void *pObject, ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RequestMultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSizeExt ){
		if( pChoice > (ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice)(e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RequestMultiplexEntryRejectionDescriptions_cause_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RequestMultiplexEntryRejectionDescriptions_cause DeleteAlternation */
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_DeleteAlternation(void *pObject)
{
	ASNH245RequestMultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RequestMultiplexEntryRejectionDescriptions_cause Encode */
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RequestMultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSize )
		{
			if( pObj->choice > ((ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice)(e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RequestMultiplexEntryRejectionDescriptions_cause Decode */
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RequestMultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSize;
	}
	else
	{
		if( e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RequestMultiplexEntryRejectionDescriptions_cause_SetChoice( pObj, (ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestMultiplexEntryRejectionDescriptions_cause Print */
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestMultiplexEntryRejectionDescriptions_cause *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions_cause *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestMultiplexEntryRejectionDescriptions_causeChoice_unspecifiedCause ){
		AsnNull_Print( pObj->alter, pDepth+1, "unspecifiedCause" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestMultiplexEntryRejectionDescriptions Class
*/
/*ASNH245RequestMultiplexEntryRejectionDescriptions Constructor*/
HS_RESULT new_ASNH245RequestMultiplexEntryRejectionDescriptions(void *pObject)
{
	ASNH245RequestMultiplexEntryRejectionDescriptions *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestMultiplexEntryRejectionDescriptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245MultiplexTableEntryNumber( &(pObj->m_multiplexTableEntryNumber) );
	new_ASNH245RequestMultiplexEntryRejectionDescriptions_cause( &(pObj->m_cause) );

	return HS_OK;
}

/* ASNH245RequestMultiplexEntryRejectionDescriptions Destructor */
HS_RESULT delete_ASNH245RequestMultiplexEntryRejectionDescriptions(void *pObject)
{
	ASNH245RequestMultiplexEntryRejectionDescriptions *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMultiplexEntryRejectionDescriptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MultiplexTableEntryNumber( &(pObj->m_multiplexTableEntryNumber) );
	delete_ASNH245RequestMultiplexEntryRejectionDescriptions_cause( &(pObj->m_cause) );
	return HS_OK;
}

/* ASNH245RequestMultiplexEntryRejectionDescriptions MakeMold */
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestMultiplexEntryRejectionDescriptions *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245MultiplexTableEntryNumber_MakeMold(&(pObj->m_multiplexTableEntryNumber));
	return HS_OK;
}

/* ASNH245RequestMultiplexEntryRejectionDescriptions Encode */
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntryRejectionDescriptions *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245MultiplexTableEntryNumber_Encode( &(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Encode( &(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestMultiplexEntryRejectionDescriptions Decode */
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntryRejectionDescriptions *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245MultiplexTableEntryNumber_Decode(&(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Decode(&(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestMultiplexEntryRejectionDescriptions Print */
HS_RESULT ASNH245RequestMultiplexEntryRejectionDescriptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestMultiplexEntryRejectionDescriptions *pObj = (ASNH245RequestMultiplexEntryRejectionDescriptions *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRejectionDescriptions_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MultiplexTableEntryNumber_Print( &(pObj->m_multiplexTableEntryNumber), pDepth+1, "multiplexTableEntryNumber" );
	ASNH245RequestMultiplexEntryRejectionDescriptions_cause_Print( &(pObj->m_cause), pDepth+1, "cause" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestMultiplexEntryReject Class
*/
/*ASNH245RequestMultiplexEntryReject Constructor*/
HS_RESULT new_ASNH245RequestMultiplexEntryReject(void *pObject)
{
	ASNH245RequestMultiplexEntryReject *pObj = (ASNH245RequestMultiplexEntryReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestMultiplexEntryReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_entryNumbers), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_rejectionDescriptions), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245RequestMultiplexEntryReject Destructor */
HS_RESULT delete_ASNH245RequestMultiplexEntryReject(void *pObject)
{
	ASNH245RequestMultiplexEntryReject *pObj = (ASNH245RequestMultiplexEntryReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMultiplexEntryReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_entryNumbers) );
	delete_AsnSequenceOf( &(pObj->m_rejectionDescriptions) );
	return HS_OK;
}

/* ASNH245RequestMultiplexEntryReject MakeMold */
HS_RESULT ASNH245RequestMultiplexEntryReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestMultiplexEntryReject *pObj = (ASNH245RequestMultiplexEntryReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245MultiplexTableEntryNumber *tmold_entryNumbers = (ASNH245MultiplexTableEntryNumber *)HSMalloc( sizeof(ASNH245MultiplexTableEntryNumber) );
	new_ASNH245MultiplexTableEntryNumber(tmold_entryNumbers);
	ASNH245MultiplexTableEntryNumber_MakeMold(tmold_entryNumbers);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_entryNumbers,sizeof(ASNH245MultiplexTableEntryNumber),ASNH245MultiplexTableEntryNumber_MakeMold,ASNH245MultiplexTableEntryNumber_Encode,ASNH245MultiplexTableEntryNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MultiplexTableEntryNumber_Print,
#endif
		delete_ASNH245MultiplexTableEntryNumber);
	AsnSequenceOf_SetMold( &(pObj->m_entryNumbers), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_entryNumbers.constraint.type = e_constrained;
	pObj->m_entryNumbers.constraint.minValue = 1;
	pObj->m_entryNumbers.constraint.maxValue = 15;
	pObj->m_entryNumbers.extMinValue = 0;
	pObj->m_entryNumbers.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	{
	ASNH245RequestMultiplexEntryRejectionDescriptions *tmold_rejectionDescriptions = (ASNH245RequestMultiplexEntryRejectionDescriptions *)HSMalloc( sizeof(ASNH245RequestMultiplexEntryRejectionDescriptions) );
	new_ASNH245RequestMultiplexEntryRejectionDescriptions(tmold_rejectionDescriptions);
	ASNH245RequestMultiplexEntryRejectionDescriptions_MakeMold(tmold_rejectionDescriptions);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_rejectionDescriptions,sizeof(ASNH245RequestMultiplexEntryRejectionDescriptions),ASNH245RequestMultiplexEntryRejectionDescriptions_MakeMold,ASNH245RequestMultiplexEntryRejectionDescriptions_Encode,ASNH245RequestMultiplexEntryRejectionDescriptions_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245RequestMultiplexEntryRejectionDescriptions_Print,
#endif
		delete_ASNH245RequestMultiplexEntryRejectionDescriptions);
	AsnSequenceOf_SetMold( &(pObj->m_rejectionDescriptions), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_rejectionDescriptions.constraint.type = e_constrained;
	pObj->m_rejectionDescriptions.constraint.minValue = 1;
	pObj->m_rejectionDescriptions.constraint.maxValue = 15;
	pObj->m_rejectionDescriptions.extMinValue = 0;
	pObj->m_rejectionDescriptions.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245RequestMultiplexEntryReject Encode */
HS_RESULT ASNH245RequestMultiplexEntryReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntryReject *pObj = (ASNH245RequestMultiplexEntryReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_entryNumbers),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_rejectionDescriptions),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestMultiplexEntryReject Decode */
HS_RESULT ASNH245RequestMultiplexEntryReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntryReject *pObj = (ASNH245RequestMultiplexEntryReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_entryNumbers),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_rejectionDescriptions),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestMultiplexEntryReject Print */
HS_RESULT ASNH245RequestMultiplexEntryReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestMultiplexEntryReject *pObj = (ASNH245RequestMultiplexEntryReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSequenceOf_Print( &(pObj->m_entryNumbers), pDepth+1, "entryNumbers" );
	AsnSequenceOf_Print( &(pObj->m_rejectionDescriptions), pDepth+1, "rejectionDescriptions" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestModeAck_response Struct
*/
/* ASNH245RequestModeAck_response Constructor */
HS_RESULT new_ASNH245RequestModeAck_response( void *pObject )
{
	ASNH245RequestModeAck_response *pObj = (ASNH245RequestModeAck_response *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestModeAck_response(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RequestModeAck_responseChoice_willTransmitMostPreferredMode;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RequestModeAck_responseChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RequestModeAck_response Destructor */
HS_RESULT delete_ASNH245RequestModeAck_response( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RequestModeAck_response *pObj = (ASNH245RequestModeAck_response *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestModeAck_response(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RequestModeAck_response_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestModeAck_response(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RequestModeAck_response SetChoice */
void* ASNH245RequestModeAck_response_SetChoice( void *pObject, ASNH245RequestModeAck_responseChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RequestModeAck_response *pObj = (ASNH245RequestModeAck_response *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_response_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RequestModeAck_responseChoiceSizeExt ){
		if( pChoice > (ASNH245RequestModeAck_responseChoice)(e_ASNH245RequestModeAck_responseChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeAck_response_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RequestModeAck_response_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeAck_response_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RequestModeAck_responseChoice_willTransmitMostPreferredMode ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestModeAck_responseChoice_willTransmitLessPreferredMode ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_response_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RequestModeAck_response DeleteAlternation */
HS_RESULT ASNH245RequestModeAck_response_DeleteAlternation(void *pObject)
{
	ASNH245RequestModeAck_response *pObj = (ASNH245RequestModeAck_response *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_response_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RequestModeAck_responseChoice_willTransmitMostPreferredMode ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestModeAck_responseChoice_willTransmitLessPreferredMode ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeAck_response_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RequestModeAck_response_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RequestModeAck_response Encode */
HS_RESULT ASNH245RequestModeAck_response_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RequestModeAck_response *pObj = (ASNH245RequestModeAck_response *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_response_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_response_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RequestModeAck_responseChoiceSize )
		{
			if( pObj->choice > ((ASNH245RequestModeAck_responseChoice)(e_ASNH245RequestModeAck_responseChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RequestModeAck_responseChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RequestModeAck_responseChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestModeAck_responseChoice_willTransmitMostPreferredMode ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeAck_response_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestModeAck_responseChoice_willTransmitLessPreferredMode ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeAck_response_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_response_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RequestModeAck_response Decode */
HS_RESULT ASNH245RequestModeAck_response_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RequestModeAck_response *pObj = (ASNH245RequestModeAck_response *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_response_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RequestModeAck_responseChoiceSize;
	}
	else
	{
		if( e_ASNH245RequestModeAck_responseChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RequestModeAck_responseChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RequestModeAck_responseChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeAck_response_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RequestModeAck_response_SetChoice( pObj, (ASNH245RequestModeAck_responseChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_response_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestModeAck_responseChoice_willTransmitMostPreferredMode ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeAck_response_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestModeAck_responseChoice_willTransmitLessPreferredMode ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeAck_response_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_response_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestModeAck_response Print */
HS_RESULT ASNH245RequestModeAck_response_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestModeAck_response *pObj = (ASNH245RequestModeAck_response *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestModeAck_response_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestModeAck_responseChoice_willTransmitMostPreferredMode ){
		AsnNull_Print( pObj->alter, pDepth+1, "willTransmitMostPreferredMode" );
	}
	else if ( pObj->choice == e_ASNH245RequestModeAck_responseChoice_willTransmitLessPreferredMode ){
		AsnNull_Print( pObj->alter, pDepth+1, "willTransmitLessPreferredMode" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestModeAck Class
*/
/*ASNH245RequestModeAck Constructor*/
HS_RESULT new_ASNH245RequestModeAck(void *pObject)
{
	ASNH245RequestModeAck *pObj = (ASNH245RequestModeAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestModeAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	new_ASNH245RequestModeAck_response( &(pObj->m_response) );

	return HS_OK;
}

/* ASNH245RequestModeAck Destructor */
HS_RESULT delete_ASNH245RequestModeAck(void *pObject)
{
	ASNH245RequestModeAck *pObj = (ASNH245RequestModeAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestModeAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	delete_ASNH245RequestModeAck_response( &(pObj->m_response) );
	return HS_OK;
}

/* ASNH245RequestModeAck MakeMold */
HS_RESULT ASNH245RequestModeAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestModeAck *pObj = (ASNH245RequestModeAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	return HS_OK;
}

/* ASNH245RequestModeAck Encode */
HS_RESULT ASNH245RequestModeAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestModeAck *pObj = (ASNH245RequestModeAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RequestModeAck_response_Encode( &(pObj->m_response),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestModeAck Decode */
HS_RESULT ASNH245RequestModeAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestModeAck *pObj = (ASNH245RequestModeAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RequestModeAck_response_Decode(&(pObj->m_response),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestModeAck Print */
HS_RESULT ASNH245RequestModeAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestModeAck *pObj = (ASNH245RequestModeAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestModeAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	ASNH245RequestModeAck_response_Print( &(pObj->m_response), pDepth+1, "response" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestModeReject_cause Struct
*/
/* ASNH245RequestModeReject_cause Constructor */
HS_RESULT new_ASNH245RequestModeReject_cause( void *pObject )
{
	ASNH245RequestModeReject_cause *pObj = (ASNH245RequestModeReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestModeReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245RequestModeReject_causeChoice_modeUnavailable;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245RequestModeReject_causeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245RequestModeReject_cause Destructor */
HS_RESULT delete_ASNH245RequestModeReject_cause( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245RequestModeReject_cause *pObj = (ASNH245RequestModeReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestModeReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245RequestModeReject_cause_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestModeReject_cause(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245RequestModeReject_cause SetChoice */
void* ASNH245RequestModeReject_cause_SetChoice( void *pObject, ASNH245RequestModeReject_causeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245RequestModeReject_cause *pObj = (ASNH245RequestModeReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245RequestModeReject_causeChoiceSizeExt ){
		if( pChoice > (ASNH245RequestModeReject_causeChoice)(e_ASNH245RequestModeReject_causeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245RequestModeReject_cause_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245RequestModeReject_causeChoice_modeUnavailable ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestModeReject_causeChoice_multipointConstraint ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245RequestModeReject_causeChoice_requestDenied ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245RequestModeReject_cause DeleteAlternation */
HS_RESULT ASNH245RequestModeReject_cause_DeleteAlternation(void *pObject)
{
	ASNH245RequestModeReject_cause *pObj = (ASNH245RequestModeReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245RequestModeReject_causeChoice_modeUnavailable ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestModeReject_causeChoice_multipointConstraint ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245RequestModeReject_causeChoice_requestDenied ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245RequestModeReject_cause_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245RequestModeReject_cause Encode */
HS_RESULT ASNH245RequestModeReject_cause_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245RequestModeReject_cause *pObj = (ASNH245RequestModeReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245RequestModeReject_causeChoiceSize )
		{
			if( pObj->choice > ((ASNH245RequestModeReject_causeChoice)(e_ASNH245RequestModeReject_causeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245RequestModeReject_causeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245RequestModeReject_causeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestModeReject_causeChoice_modeUnavailable ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestModeReject_causeChoice_multipointConstraint ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestModeReject_causeChoice_requestDenied ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245RequestModeReject_cause Decode */
HS_RESULT ASNH245RequestModeReject_cause_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245RequestModeReject_cause *pObj = (ASNH245RequestModeReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245RequestModeReject_causeChoiceSize;
	}
	else
	{
		if( e_ASNH245RequestModeReject_causeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245RequestModeReject_causeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245RequestModeReject_causeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245RequestModeReject_cause_SetChoice( pObj, (ASNH245RequestModeReject_causeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestModeReject_causeChoice_modeUnavailable ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestModeReject_causeChoice_multipointConstraint ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245RequestModeReject_causeChoice_requestDenied ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245RequestModeReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestModeReject_cause Print */
HS_RESULT ASNH245RequestModeReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestModeReject_cause *pObj = (ASNH245RequestModeReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestModeReject_cause_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245RequestModeReject_causeChoice_modeUnavailable ){
		AsnNull_Print( pObj->alter, pDepth+1, "modeUnavailable" );
	}
	else if ( pObj->choice == e_ASNH245RequestModeReject_causeChoice_multipointConstraint ){
		AsnNull_Print( pObj->alter, pDepth+1, "multipointConstraint" );
	}
	else if ( pObj->choice == e_ASNH245RequestModeReject_causeChoice_requestDenied ){
		AsnNull_Print( pObj->alter, pDepth+1, "requestDenied" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestModeReject Class
*/
/*ASNH245RequestModeReject Constructor*/
HS_RESULT new_ASNH245RequestModeReject(void *pObject)
{
	ASNH245RequestModeReject *pObj = (ASNH245RequestModeReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestModeReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	new_ASNH245RequestModeReject_cause( &(pObj->m_cause) );

	return HS_OK;
}

/* ASNH245RequestModeReject Destructor */
HS_RESULT delete_ASNH245RequestModeReject(void *pObject)
{
	ASNH245RequestModeReject *pObj = (ASNH245RequestModeReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestModeReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	delete_ASNH245RequestModeReject_cause( &(pObj->m_cause) );
	return HS_OK;
}

/* ASNH245RequestModeReject MakeMold */
HS_RESULT ASNH245RequestModeReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestModeReject *pObj = (ASNH245RequestModeReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	return HS_OK;
}

/* ASNH245RequestModeReject Encode */
HS_RESULT ASNH245RequestModeReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestModeReject *pObj = (ASNH245RequestModeReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RequestModeReject_cause_Encode( &(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestModeReject Decode */
HS_RESULT ASNH245RequestModeReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestModeReject *pObj = (ASNH245RequestModeReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245RequestModeReject_cause_Decode(&(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestModeReject Print */
HS_RESULT ASNH245RequestModeReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestModeReject *pObj = (ASNH245RequestModeReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestModeReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	ASNH245RequestModeReject_cause_Print( &(pObj->m_cause), pDepth+1, "cause" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RoundTripDelayResponse Class
*/
/*ASNH245RoundTripDelayResponse Constructor*/
HS_RESULT new_ASNH245RoundTripDelayResponse(void *pObject)
{
	ASNH245RoundTripDelayResponse *pObj = (ASNH245RoundTripDelayResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RoundTripDelayResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );

	return HS_OK;
}

/* ASNH245RoundTripDelayResponse Destructor */
HS_RESULT delete_ASNH245RoundTripDelayResponse(void *pObject)
{
	ASNH245RoundTripDelayResponse *pObj = (ASNH245RoundTripDelayResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RoundTripDelayResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245SequenceNumber( &(pObj->m_sequenceNumber) );
	return HS_OK;
}

/* ASNH245RoundTripDelayResponse MakeMold */
HS_RESULT ASNH245RoundTripDelayResponse_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RoundTripDelayResponse *pObj = (ASNH245RoundTripDelayResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayResponse_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245SequenceNumber_MakeMold(&(pObj->m_sequenceNumber));
	return HS_OK;
}

/* ASNH245RoundTripDelayResponse Encode */
HS_RESULT ASNH245RoundTripDelayResponse_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RoundTripDelayResponse *pObj = (ASNH245RoundTripDelayResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayResponse_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245SequenceNumber_Encode( &(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RoundTripDelayResponse Decode */
HS_RESULT ASNH245RoundTripDelayResponse_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RoundTripDelayResponse *pObj = (ASNH245RoundTripDelayResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayResponse_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245SequenceNumber_Decode(&(pObj->m_sequenceNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RoundTripDelayResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RoundTripDelayResponse Print */
HS_RESULT ASNH245RoundTripDelayResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RoundTripDelayResponse *pObj = (ASNH245RoundTripDelayResponse *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RoundTripDelayResponse_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245SequenceNumber_Print( &(pObj->m_sequenceNumber), pDepth+1, "sequenceNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MaintenanceLoopAck_type Struct
*/
/* ASNH245MaintenanceLoopAck_type Constructor */
HS_RESULT new_ASNH245MaintenanceLoopAck_type( void *pObject )
{
	ASNH245MaintenanceLoopAck_type *pObj = (ASNH245MaintenanceLoopAck_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MaintenanceLoopAck_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MaintenanceLoopAck_typeChoice_systemLoop;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MaintenanceLoopAck_typeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MaintenanceLoopAck_type Destructor */
HS_RESULT delete_ASNH245MaintenanceLoopAck_type( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MaintenanceLoopAck_type *pObj = (ASNH245MaintenanceLoopAck_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopAck_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MaintenanceLoopAck_type_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopAck_type(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MaintenanceLoopAck_type SetChoice */
void* ASNH245MaintenanceLoopAck_type_SetChoice( void *pObject, ASNH245MaintenanceLoopAck_typeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MaintenanceLoopAck_type *pObj = (ASNH245MaintenanceLoopAck_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MaintenanceLoopAck_typeChoiceSizeExt ){
		if( pChoice > (ASNH245MaintenanceLoopAck_typeChoice)(e_ASNH245MaintenanceLoopAck_typeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MaintenanceLoopAck_type_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MaintenanceLoopAck_typeChoice_systemLoop ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MaintenanceLoopAck_typeChoice_mediaLoop ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MaintenanceLoopAck_typeChoice_logicalChannelLoop ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MaintenanceLoopAck_type DeleteAlternation */
HS_RESULT ASNH245MaintenanceLoopAck_type_DeleteAlternation(void *pObject)
{
	ASNH245MaintenanceLoopAck_type *pObj = (ASNH245MaintenanceLoopAck_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_systemLoop ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_mediaLoop ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_logicalChannelLoop ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MaintenanceLoopAck_type_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MaintenanceLoopAck_type Encode */
HS_RESULT ASNH245MaintenanceLoopAck_type_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MaintenanceLoopAck_type *pObj = (ASNH245MaintenanceLoopAck_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MaintenanceLoopAck_typeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MaintenanceLoopAck_typeChoice)(e_ASNH245MaintenanceLoopAck_typeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MaintenanceLoopAck_typeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MaintenanceLoopAck_typeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_systemLoop ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_mediaLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_logicalChannelLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopAck_type Decode */
HS_RESULT ASNH245MaintenanceLoopAck_type_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MaintenanceLoopAck_type *pObj = (ASNH245MaintenanceLoopAck_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MaintenanceLoopAck_typeChoiceSize;
	}
	else
	{
		if( e_ASNH245MaintenanceLoopAck_typeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MaintenanceLoopAck_typeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MaintenanceLoopAck_typeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MaintenanceLoopAck_type_SetChoice( pObj, (ASNH245MaintenanceLoopAck_typeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_systemLoop ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_mediaLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_logicalChannelLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MaintenanceLoopAck_type Print */
HS_RESULT ASNH245MaintenanceLoopAck_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MaintenanceLoopAck_type *pObj = (ASNH245MaintenanceLoopAck_type *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_type_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_systemLoop ){
		AsnNull_Print( pObj->alter, pDepth+1, "systemLoop" );
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_mediaLoop ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "mediaLoop" );
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopAck_typeChoice_logicalChannelLoop ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "logicalChannelLoop" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MaintenanceLoopAck Class
*/
/*ASNH245MaintenanceLoopAck Constructor*/
HS_RESULT new_ASNH245MaintenanceLoopAck(void *pObject)
{
	ASNH245MaintenanceLoopAck *pObj = (ASNH245MaintenanceLoopAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MaintenanceLoopAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245MaintenanceLoopAck_type( &(pObj->m_type) );

	return HS_OK;
}

/* ASNH245MaintenanceLoopAck Destructor */
HS_RESULT delete_ASNH245MaintenanceLoopAck(void *pObject)
{
	ASNH245MaintenanceLoopAck *pObj = (ASNH245MaintenanceLoopAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopAck(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MaintenanceLoopAck_type( &(pObj->m_type) );
	return HS_OK;
}

/* ASNH245MaintenanceLoopAck MakeMold */
HS_RESULT ASNH245MaintenanceLoopAck_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MaintenanceLoopAck *pObj = (ASNH245MaintenanceLoopAck *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopAck Encode */
HS_RESULT ASNH245MaintenanceLoopAck_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MaintenanceLoopAck *pObj = (ASNH245MaintenanceLoopAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245MaintenanceLoopAck_type_Encode( &(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopAck Decode */
HS_RESULT ASNH245MaintenanceLoopAck_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MaintenanceLoopAck *pObj = (ASNH245MaintenanceLoopAck *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245MaintenanceLoopAck_type_Decode(&(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MaintenanceLoopAck Print */
HS_RESULT ASNH245MaintenanceLoopAck_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MaintenanceLoopAck *pObj = (ASNH245MaintenanceLoopAck *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MaintenanceLoopAck_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MaintenanceLoopAck_type_Print( &(pObj->m_type), pDepth+1, "type" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MaintenanceLoopReject_type Struct
*/
/* ASNH245MaintenanceLoopReject_type Constructor */
HS_RESULT new_ASNH245MaintenanceLoopReject_type( void *pObject )
{
	ASNH245MaintenanceLoopReject_type *pObj = (ASNH245MaintenanceLoopReject_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MaintenanceLoopReject_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MaintenanceLoopReject_typeChoice_systemLoop;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MaintenanceLoopReject_typeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MaintenanceLoopReject_type Destructor */
HS_RESULT delete_ASNH245MaintenanceLoopReject_type( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MaintenanceLoopReject_type *pObj = (ASNH245MaintenanceLoopReject_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopReject_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MaintenanceLoopReject_type_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopReject_type(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MaintenanceLoopReject_type SetChoice */
void* ASNH245MaintenanceLoopReject_type_SetChoice( void *pObject, ASNH245MaintenanceLoopReject_typeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MaintenanceLoopReject_type *pObj = (ASNH245MaintenanceLoopReject_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MaintenanceLoopReject_typeChoiceSizeExt ){
		if( pChoice > (ASNH245MaintenanceLoopReject_typeChoice)(e_ASNH245MaintenanceLoopReject_typeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MaintenanceLoopReject_type_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MaintenanceLoopReject_typeChoice_systemLoop ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MaintenanceLoopReject_typeChoice_mediaLoop ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MaintenanceLoopReject_typeChoice_logicalChannelLoop ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MaintenanceLoopReject_type DeleteAlternation */
HS_RESULT ASNH245MaintenanceLoopReject_type_DeleteAlternation(void *pObject)
{
	ASNH245MaintenanceLoopReject_type *pObj = (ASNH245MaintenanceLoopReject_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_systemLoop ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_mediaLoop ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_logicalChannelLoop ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MaintenanceLoopReject_type_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MaintenanceLoopReject_type Encode */
HS_RESULT ASNH245MaintenanceLoopReject_type_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MaintenanceLoopReject_type *pObj = (ASNH245MaintenanceLoopReject_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MaintenanceLoopReject_typeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MaintenanceLoopReject_typeChoice)(e_ASNH245MaintenanceLoopReject_typeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MaintenanceLoopReject_typeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MaintenanceLoopReject_typeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_systemLoop ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_mediaLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_logicalChannelLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopReject_type Decode */
HS_RESULT ASNH245MaintenanceLoopReject_type_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MaintenanceLoopReject_type *pObj = (ASNH245MaintenanceLoopReject_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MaintenanceLoopReject_typeChoiceSize;
	}
	else
	{
		if( e_ASNH245MaintenanceLoopReject_typeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MaintenanceLoopReject_typeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MaintenanceLoopReject_typeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MaintenanceLoopReject_type_SetChoice( pObj, (ASNH245MaintenanceLoopReject_typeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_systemLoop ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_mediaLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_logicalChannelLoop ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MaintenanceLoopReject_type Print */
HS_RESULT ASNH245MaintenanceLoopReject_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MaintenanceLoopReject_type *pObj = (ASNH245MaintenanceLoopReject_type *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_type_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_systemLoop ){
		AsnNull_Print( pObj->alter, pDepth+1, "systemLoop" );
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_mediaLoop ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "mediaLoop" );
	}
	else if ( pObj->choice == e_ASNH245MaintenanceLoopReject_typeChoice_logicalChannelLoop ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "logicalChannelLoop" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MaintenanceLoopReject_cause Struct
*/
/* ASNH245MaintenanceLoopReject_cause Constructor */
HS_RESULT new_ASNH245MaintenanceLoopReject_cause( void *pObject )
{
	ASNH245MaintenanceLoopReject_cause *pObj = (ASNH245MaintenanceLoopReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MaintenanceLoopReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MaintenanceLoopReject_causeChoice_canNotPerformLoop;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MaintenanceLoopReject_causeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MaintenanceLoopReject_cause Destructor */
HS_RESULT delete_ASNH245MaintenanceLoopReject_cause( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MaintenanceLoopReject_cause *pObj = (ASNH245MaintenanceLoopReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopReject_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MaintenanceLoopReject_cause_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopReject_cause(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MaintenanceLoopReject_cause SetChoice */
void* ASNH245MaintenanceLoopReject_cause_SetChoice( void *pObject, ASNH245MaintenanceLoopReject_causeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MaintenanceLoopReject_cause *pObj = (ASNH245MaintenanceLoopReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MaintenanceLoopReject_causeChoiceSizeExt ){
		if( pChoice > (ASNH245MaintenanceLoopReject_causeChoice)(e_ASNH245MaintenanceLoopReject_causeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MaintenanceLoopReject_cause_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MaintenanceLoopReject_causeChoice_canNotPerformLoop ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MaintenanceLoopReject_cause DeleteAlternation */
HS_RESULT ASNH245MaintenanceLoopReject_cause_DeleteAlternation(void *pObject)
{
	ASNH245MaintenanceLoopReject_cause *pObj = (ASNH245MaintenanceLoopReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MaintenanceLoopReject_causeChoice_canNotPerformLoop ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MaintenanceLoopReject_cause_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MaintenanceLoopReject_cause Encode */
HS_RESULT ASNH245MaintenanceLoopReject_cause_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MaintenanceLoopReject_cause *pObj = (ASNH245MaintenanceLoopReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MaintenanceLoopReject_causeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MaintenanceLoopReject_causeChoice)(e_ASNH245MaintenanceLoopReject_causeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MaintenanceLoopReject_causeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MaintenanceLoopReject_causeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopReject_causeChoice_canNotPerformLoop ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopReject_cause Decode */
HS_RESULT ASNH245MaintenanceLoopReject_cause_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MaintenanceLoopReject_cause *pObj = (ASNH245MaintenanceLoopReject_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MaintenanceLoopReject_causeChoiceSize;
	}
	else
	{
		if( e_ASNH245MaintenanceLoopReject_causeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MaintenanceLoopReject_causeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MaintenanceLoopReject_causeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MaintenanceLoopReject_cause_SetChoice( pObj, (ASNH245MaintenanceLoopReject_causeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopReject_causeChoice_canNotPerformLoop ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MaintenanceLoopReject_cause Print */
HS_RESULT ASNH245MaintenanceLoopReject_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MaintenanceLoopReject_cause *pObj = (ASNH245MaintenanceLoopReject_cause *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_cause_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MaintenanceLoopReject_causeChoice_canNotPerformLoop ){
		AsnNull_Print( pObj->alter, pDepth+1, "canNotPerformLoop" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MaintenanceLoopReject Class
*/
/*ASNH245MaintenanceLoopReject Constructor*/
HS_RESULT new_ASNH245MaintenanceLoopReject(void *pObject)
{
	ASNH245MaintenanceLoopReject *pObj = (ASNH245MaintenanceLoopReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MaintenanceLoopReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245MaintenanceLoopReject_type( &(pObj->m_type) );
	new_ASNH245MaintenanceLoopReject_cause( &(pObj->m_cause) );

	return HS_OK;
}

/* ASNH245MaintenanceLoopReject Destructor */
HS_RESULT delete_ASNH245MaintenanceLoopReject(void *pObject)
{
	ASNH245MaintenanceLoopReject *pObj = (ASNH245MaintenanceLoopReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MaintenanceLoopReject(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245MaintenanceLoopReject_type( &(pObj->m_type) );
	delete_ASNH245MaintenanceLoopReject_cause( &(pObj->m_cause) );
	return HS_OK;
}

/* ASNH245MaintenanceLoopReject MakeMold */
HS_RESULT ASNH245MaintenanceLoopReject_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MaintenanceLoopReject *pObj = (ASNH245MaintenanceLoopReject *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopReject Encode */
HS_RESULT ASNH245MaintenanceLoopReject_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MaintenanceLoopReject *pObj = (ASNH245MaintenanceLoopReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245MaintenanceLoopReject_type_Encode( &(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MaintenanceLoopReject_cause_Encode( &(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MaintenanceLoopReject Decode */
HS_RESULT ASNH245MaintenanceLoopReject_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MaintenanceLoopReject *pObj = (ASNH245MaintenanceLoopReject *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245MaintenanceLoopReject_type_Decode(&(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MaintenanceLoopReject_cause_Decode(&(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MaintenanceLoopReject Print */
HS_RESULT ASNH245MaintenanceLoopReject_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MaintenanceLoopReject *pObj = (ASNH245MaintenanceLoopReject *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MaintenanceLoopReject_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245MaintenanceLoopReject_type_Print( &(pObj->m_type), pDepth+1, "type" );
	ASNH245MaintenanceLoopReject_cause_Print( &(pObj->m_cause), pDepth+1, "cause" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CommunicationModeTableEntry_dataType Struct
*/
/* ASNH245CommunicationModeTableEntry_dataType Constructor */
HS_RESULT new_ASNH245CommunicationModeTableEntry_dataType( void *pObject )
{
	ASNH245CommunicationModeTableEntry_dataType *pObj = (ASNH245CommunicationModeTableEntry_dataType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CommunicationModeTableEntry_dataType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245CommunicationModeTableEntry_dataTypeChoice_videoData;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245CommunicationModeTableEntry_dataType Destructor */
HS_RESULT delete_ASNH245CommunicationModeTableEntry_dataType( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245CommunicationModeTableEntry_dataType *pObj = (ASNH245CommunicationModeTableEntry_dataType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CommunicationModeTableEntry_dataType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245CommunicationModeTableEntry_dataType_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CommunicationModeTableEntry_dataType(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245CommunicationModeTableEntry_dataType SetChoice */
void* ASNH245CommunicationModeTableEntry_dataType_SetChoice( void *pObject, ASNH245CommunicationModeTableEntry_dataTypeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245CommunicationModeTableEntry_dataType *pObj = (ASNH245CommunicationModeTableEntry_dataType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSizeExt ){
		if( pChoice > (ASNH245CommunicationModeTableEntry_dataTypeChoice)(e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245CommunicationModeTableEntry_dataType_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_videoData ){
		ASNH245VideoCapability *tAlter = (ASNH245VideoCapability *)HSMalloc( sizeof(ASNH245VideoCapability) );
		new_ASNH245VideoCapability(tAlter);
		ASNH245VideoCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_audioData ){
		ASNH245AudioCapability *tAlter = (ASNH245AudioCapability *)HSMalloc( sizeof(ASNH245AudioCapability) );
		new_ASNH245AudioCapability(tAlter);
		ASNH245AudioCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_data ){
		ASNH245DataApplicationCapability *tAlter = (ASNH245DataApplicationCapability *)HSMalloc( sizeof(ASNH245DataApplicationCapability) );
		new_ASNH245DataApplicationCapability(tAlter);
		ASNH245DataApplicationCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245CommunicationModeTableEntry_dataType DeleteAlternation */
HS_RESULT ASNH245CommunicationModeTableEntry_dataType_DeleteAlternation(void *pObject)
{
	ASNH245CommunicationModeTableEntry_dataType *pObj = (ASNH245CommunicationModeTableEntry_dataType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_videoData ){
			delete_ASNH245VideoCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_audioData ){
			delete_ASNH245AudioCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_data ){
			delete_ASNH245DataApplicationCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245CommunicationModeTableEntry_dataType_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245CommunicationModeTableEntry_dataType Encode */
HS_RESULT ASNH245CommunicationModeTableEntry_dataType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245CommunicationModeTableEntry_dataType *pObj = (ASNH245CommunicationModeTableEntry_dataType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSize )
		{
			if( pObj->choice > ((ASNH245CommunicationModeTableEntry_dataTypeChoice)(e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_videoData ){
		if( (tRet=ASNH245VideoCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_audioData ){
		if( (tRet=ASNH245AudioCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_data ){
		if( (tRet=ASNH245DataApplicationCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245CommunicationModeTableEntry_dataType Decode */
HS_RESULT ASNH245CommunicationModeTableEntry_dataType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245CommunicationModeTableEntry_dataType *pObj = (ASNH245CommunicationModeTableEntry_dataType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSize;
	}
	else
	{
		if( e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245CommunicationModeTableEntry_dataTypeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245CommunicationModeTableEntry_dataType_SetChoice( pObj, (ASNH245CommunicationModeTableEntry_dataTypeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_videoData ){
		if( (tRet=ASNH245VideoCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_audioData ){
		if( (tRet=ASNH245AudioCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_data ){
		if( (tRet=ASNH245DataApplicationCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CommunicationModeTableEntry_dataType Print */
HS_RESULT ASNH245CommunicationModeTableEntry_dataType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CommunicationModeTableEntry_dataType *pObj = (ASNH245CommunicationModeTableEntry_dataType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_dataType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_videoData ){
		ASNH245VideoCapability_Print( pObj->alter, pDepth+1, "videoData" );
	}
	else if ( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_audioData ){
		ASNH245AudioCapability_Print( pObj->alter, pDepth+1, "audioData" );
	}
	else if ( pObj->choice == e_ASNH245CommunicationModeTableEntry_dataTypeChoice_data ){
		ASNH245DataApplicationCapability_Print( pObj->alter, pDepth+1, "data" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CommunicationModeTableEntry Class
*/
/*ASNH245CommunicationModeTableEntry Constructor*/
HS_RESULT new_ASNH245CommunicationModeTableEntry(void *pObject)
{
	ASNH245CommunicationModeTableEntry *pObj = (ASNH245CommunicationModeTableEntry *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CommunicationModeTableEntry(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_nonStandard), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_sessionID), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_associatedSessionID), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245TerminalLabel( &(pObj->m_terminalLabel) );
	new_AsnDoubleString( &(pObj->m_sessionDescription), e_asnTagBMPString, e_constrained, 1, 128, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245CommunicationModeTableEntry_dataType( &(pObj->m_dataType) );
	new_ASNH245TransportAddress( &(pObj->m_mediaChannel) );
	new_AsnBoolean( &(pObj->m_mediaGuaranteedDelivery) );
	new_ASNH245TransportAddress( &(pObj->m_mediaControlChannel) );
	new_AsnBoolean( &(pObj->m_mediaControlGuaranteedDelivery) );
	new_ASNH245RedundancyEncoding( &(pObj->m_redundancyEncoding) );
	new_AsnInteger( &(pObj->m_sessionDependency), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245TerminalLabel( &(pObj->m_destination) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245CommunicationModeTableEntry Destructor */
HS_RESULT delete_ASNH245CommunicationModeTableEntry(void *pObject)
{
	ASNH245CommunicationModeTableEntry *pObj = (ASNH245CommunicationModeTableEntry *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CommunicationModeTableEntry(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_nonStandard) );
	delete_AsnInteger( &(pObj->m_sessionID) );
	delete_AsnInteger( &(pObj->m_associatedSessionID) );
	delete_ASNH245TerminalLabel( &(pObj->m_terminalLabel) );
	delete_AsnDoubleString( &(pObj->m_sessionDescription) );
	delete_ASNH245CommunicationModeTableEntry_dataType( &(pObj->m_dataType) );
	delete_ASNH245TransportAddress( &(pObj->m_mediaChannel) );
	delete_AsnBoolean( &(pObj->m_mediaGuaranteedDelivery) );
	delete_ASNH245TransportAddress( &(pObj->m_mediaControlChannel) );
	delete_AsnBoolean( &(pObj->m_mediaControlGuaranteedDelivery) );
	delete_ASNH245RedundancyEncoding( &(pObj->m_redundancyEncoding) );
	delete_AsnInteger( &(pObj->m_sessionDependency) );
	delete_ASNH245TerminalLabel( &(pObj->m_destination) );
	return HS_OK;
}

/* ASNH245CommunicationModeTableEntry MakeMold */
HS_RESULT ASNH245CommunicationModeTableEntry_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CommunicationModeTableEntry *pObj = (ASNH245CommunicationModeTableEntry *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245NonStandardParameter *tmold_nonStandard = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
	new_ASNH245NonStandardParameter(tmold_nonStandard);
	ASNH245NonStandardParameter_MakeMold(tmold_nonStandard);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_nonStandard,sizeof(ASNH245NonStandardParameter),ASNH245NonStandardParameter_MakeMold,ASNH245NonStandardParameter_Encode,ASNH245NonStandardParameter_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245NonStandardParameter_Print,
#endif
		delete_ASNH245NonStandardParameter);
	AsnSequenceOf_SetMold( &(pObj->m_nonStandard), moldObject );
	}
	ASNH245TerminalLabel_MakeMold(&(pObj->m_terminalLabel));
	ASNH245TransportAddress_MakeMold(&(pObj->m_mediaChannel));
	ASNH245TransportAddress_MakeMold(&(pObj->m_mediaControlChannel));
	ASNH245RedundancyEncoding_MakeMold(&(pObj->m_redundancyEncoding));
	ASNH245TerminalLabel_MakeMold(&(pObj->m_destination));
	return HS_OK;
}

/* ASNH245CommunicationModeTableEntry IncludeOptionalField */
HS_RESULT ASNH245CommunicationModeTableEntry_IncludeOptionField( void *pObject, ASNH245CommunicationModeTableEntryOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245CommunicationModeTableEntry *pObj = (ASNH245CommunicationModeTableEntry *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245CommunicationModeTableEntryOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245CommunicationModeTableEntryOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245CommunicationModeTableEntryOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245CommunicationModeTableEntry IsIncludeOptionalField */
BOOL ASNH245CommunicationModeTableEntry_IsIncludeOptionField( void *pObject, ASNH245CommunicationModeTableEntryOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245CommunicationModeTableEntry *pObj = (ASNH245CommunicationModeTableEntry *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245CommunicationModeTableEntryOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245CommunicationModeTableEntryOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245CommunicationModeTableEntryOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245CommunicationModeTableEntry Encode */
HS_RESULT ASNH245CommunicationModeTableEntry_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245CommunicationModeTableEntry *pObj = (ASNH245CommunicationModeTableEntry *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245CommunicationModeTableEntryOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245CommunicationModeTableEntryOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_nonStandard ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_nonStandard),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_sessionID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_associatedSessionID ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_associatedSessionID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_terminalLabel ) ){
		if( (tRet=ASNH245TerminalLabel_Encode( &(pObj->m_terminalLabel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnDoubleString_Encode( &(pObj->m_sessionDescription),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CommunicationModeTableEntry_dataType_Encode( &(pObj->m_dataType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaChannel ) ){
		if( (tRet=ASNH245TransportAddress_Encode( &(pObj->m_mediaChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaGuaranteedDelivery ) ){
		if( (tRet=AsnBoolean_Encode( &(pObj->m_mediaGuaranteedDelivery),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaControlChannel ) ){
		if( (tRet=ASNH245TransportAddress_Encode( &(pObj->m_mediaControlChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaControlGuaranteedDelivery ) ){
		if( (tRet=AsnBoolean_Encode( &(pObj->m_mediaControlGuaranteedDelivery),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_redundancyEncoding ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_redundancyEncoding), ASNH245RedundancyEncoding_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_sessionDependency ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_sessionDependency), AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_destination ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destination), ASNH245TerminalLabel_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245CommunicationModeTableEntry Decode */
HS_RESULT ASNH245CommunicationModeTableEntry_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245CommunicationModeTableEntry *pObj = (ASNH245CommunicationModeTableEntry *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245CommunicationModeTableEntryOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245CommunicationModeTableEntryOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_nonStandard ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_nonStandard),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_sessionID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_associatedSessionID ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_associatedSessionID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_terminalLabel ) ){
		if( (tRet=ASNH245TerminalLabel_Decode(&(pObj->m_terminalLabel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnDoubleString_Decode(&(pObj->m_sessionDescription),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245CommunicationModeTableEntry_dataType_Decode(&(pObj->m_dataType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaChannel ) ){
		if( (tRet=ASNH245TransportAddress_Decode(&(pObj->m_mediaChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaGuaranteedDelivery ) ){
		if( (tRet=AsnBoolean_Decode(&(pObj->m_mediaGuaranteedDelivery),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaControlChannel ) ){
		if( (tRet=ASNH245TransportAddress_Decode(&(pObj->m_mediaControlChannel),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaControlGuaranteedDelivery ) ){
		if( (tRet=AsnBoolean_Decode(&(pObj->m_mediaControlGuaranteedDelivery),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_redundancyEncoding ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_redundancyEncoding), ASNH245RedundancyEncoding_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_sessionDependency ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_sessionDependency), AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_destination ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_destination), ASNH245TerminalLabel_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CommunicationModeTableEntry Print */
HS_RESULT ASNH245CommunicationModeTableEntry_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CommunicationModeTableEntry *pObj = (ASNH245CommunicationModeTableEntry *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CommunicationModeTableEntry_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_nonStandard ) )
		AsnSequenceOf_Print( &(pObj->m_nonStandard), pDepth+1, "nonStandard" );
	AsnInteger_Print( &(pObj->m_sessionID), pDepth+1, "sessionID" );
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_associatedSessionID ) )
		AsnInteger_Print( &(pObj->m_associatedSessionID), pDepth+1, "associatedSessionID" );
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_terminalLabel ) )
		ASNH245TerminalLabel_Print( &(pObj->m_terminalLabel), pDepth+1, "terminalLabel" );
	AsnDoubleString_Print( &(pObj->m_sessionDescription), pDepth+1, "sessionDescription" );
	ASNH245CommunicationModeTableEntry_dataType_Print( &(pObj->m_dataType), pDepth+1, "dataType" );
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaChannel ) )
		ASNH245TransportAddress_Print( &(pObj->m_mediaChannel), pDepth+1, "mediaChannel" );
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaGuaranteedDelivery ) )
		AsnBoolean_Print( &(pObj->m_mediaGuaranteedDelivery), pDepth+1, "mediaGuaranteedDelivery" );
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaControlChannel ) )
		ASNH245TransportAddress_Print( &(pObj->m_mediaControlChannel), pDepth+1, "mediaControlChannel" );
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_mediaControlGuaranteedDelivery ) )
		AsnBoolean_Print( &(pObj->m_mediaControlGuaranteedDelivery), pDepth+1, "mediaControlGuaranteedDelivery" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_redundancyEncoding ) )
		ASNH245RedundancyEncoding_Print( &(pObj->m_redundancyEncoding), pDepth+1, "redundancyEncoding" );
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_sessionDependency ) )
		AsnInteger_Print( &(pObj->m_sessionDependency), pDepth+1, "sessionDependency" );
	if( ASNH245CommunicationModeTableEntry_IsIncludeOptionField( pObj, e_ASNH245CommunicationModeTableEntryOptionMap_destination ) )
		ASNH245TerminalLabel_Print( &(pObj->m_destination), pDepth+1, "destination" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CommunicationModeResponse Struct
*/
/* ASNH245CommunicationModeResponse Constructor */
HS_RESULT new_ASNH245CommunicationModeResponse( void *pObject )
{
	ASNH245CommunicationModeResponse *pObj = (ASNH245CommunicationModeResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CommunicationModeResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245CommunicationModeResponseChoice_communicationModeTable;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245CommunicationModeResponseChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245CommunicationModeResponse Destructor */
HS_RESULT delete_ASNH245CommunicationModeResponse( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245CommunicationModeResponse *pObj = (ASNH245CommunicationModeResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CommunicationModeResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245CommunicationModeResponse_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CommunicationModeResponse(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245CommunicationModeResponse SetChoice */
void* ASNH245CommunicationModeResponse_SetChoice( void *pObject, ASNH245CommunicationModeResponseChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245CommunicationModeResponse *pObj = (ASNH245CommunicationModeResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245CommunicationModeResponseChoiceSizeExt ){
		if( pChoice > (ASNH245CommunicationModeResponseChoice)(e_ASNH245CommunicationModeResponseChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeResponse_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245CommunicationModeResponse_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeResponse_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245CommunicationModeResponseChoice_communicationModeTable ){
		ASNH245CommunicationModeTableEntry *tAlter = (ASNH245CommunicationModeTableEntry *)HSMalloc( sizeof(ASNH245CommunicationModeTableEntry) );
		new_ASNH245CommunicationModeTableEntry(tAlter);
		ASNH245CommunicationModeTableEntry_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH245CommunicationModeTableEntry),ASNH245CommunicationModeTableEntry_MakeMold,ASNH245CommunicationModeTableEntry_Encode,ASNH245CommunicationModeTableEntry_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH245CommunicationModeTableEntry_Print,
#endif
			delete_ASNH245CommunicationModeTableEntry );
		AsnSequenceOf_SetMold(aso,tmold);
		/* Sequence Of constraint */
		aso->constraint.type = e_constrained;
		aso->constraint.minValue = 1;
		aso->constraint.maxValue = 256;
		aso->extMinValue = 0;
		aso->extMaxValue = HS_ASN_MAX_CONSTRAINT;
		pObj->alter = aso;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245CommunicationModeResponse DeleteAlternation */
HS_RESULT ASNH245CommunicationModeResponse_DeleteAlternation(void *pObject)
{
	ASNH245CommunicationModeResponse *pObj = (ASNH245CommunicationModeResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245CommunicationModeResponseChoice_communicationModeTable ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeResponse_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245CommunicationModeResponse_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245CommunicationModeResponse Encode */
HS_RESULT ASNH245CommunicationModeResponse_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245CommunicationModeResponse *pObj = (ASNH245CommunicationModeResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245CommunicationModeResponseChoiceSize )
		{
			if( pObj->choice > ((ASNH245CommunicationModeResponseChoice)(e_ASNH245CommunicationModeResponseChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245CommunicationModeResponseChoiceSize)) )
	}
	else
	{
		if( e_ASNH245CommunicationModeResponseChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CommunicationModeResponseChoice_communicationModeTable ){
		if( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245CommunicationModeResponse Decode */
HS_RESULT ASNH245CommunicationModeResponse_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245CommunicationModeResponse *pObj = (ASNH245CommunicationModeResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245CommunicationModeResponseChoiceSize;
	}
	else
	{
		if( e_ASNH245CommunicationModeResponseChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245CommunicationModeResponseChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245CommunicationModeResponseChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeResponse_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245CommunicationModeResponse_SetChoice( pObj, (ASNH245CommunicationModeResponseChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CommunicationModeResponseChoice_communicationModeTable ){
		if( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommunicationModeResponse_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CommunicationModeResponse Print */
HS_RESULT ASNH245CommunicationModeResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CommunicationModeResponse *pObj = (ASNH245CommunicationModeResponse *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CommunicationModeResponse_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CommunicationModeResponseChoice_communicationModeTable ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "communicationModeTable" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ConferenceResponse_mCTerminalIDResponse Class
*/
/*ASNH245ConferenceResponse_mCTerminalIDResponse Constructor*/
HS_RESULT new_ASNH245ConferenceResponse_mCTerminalIDResponse(void *pObject)
{
	ASNH245ConferenceResponse_mCTerminalIDResponse *pObj = (ASNH245ConferenceResponse_mCTerminalIDResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ConferenceResponse_mCTerminalIDResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245TerminalLabel( &(pObj->m_terminalLabel) );
	new_ASNH245TerminalID( &(pObj->m_terminalID) );

	return HS_OK;
}

/* ASNH245ConferenceResponse_mCTerminalIDResponse Destructor */
HS_RESULT delete_ASNH245ConferenceResponse_mCTerminalIDResponse(void *pObject)
{
	ASNH245ConferenceResponse_mCTerminalIDResponse *pObj = (ASNH245ConferenceResponse_mCTerminalIDResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConferenceResponse_mCTerminalIDResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245TerminalLabel( &(pObj->m_terminalLabel) );
	delete_ASNH245TerminalID( &(pObj->m_terminalID) );
	return HS_OK;
}

/* ASNH245ConferenceResponse_mCTerminalIDResponse MakeMold */
HS_RESULT ASNH245ConferenceResponse_mCTerminalIDResponse_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245ConferenceResponse_mCTerminalIDResponse *pObj = (ASNH245ConferenceResponse_mCTerminalIDResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_mCTerminalIDResponse_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245TerminalLabel_MakeMold(&(pObj->m_terminalLabel));
	ASNH245TerminalID_MakeMold(&(pObj->m_terminalID));
	return HS_OK;
}

/* ASNH245ConferenceResponse_mCTerminalIDResponse Encode */
HS_RESULT ASNH245ConferenceResponse_mCTerminalIDResponse_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245ConferenceResponse_mCTerminalIDResponse *pObj = (ASNH245ConferenceResponse_mCTerminalIDResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_mCTerminalIDResponse_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245TerminalLabel_Encode( &(pObj->m_terminalLabel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_mCTerminalIDResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245TerminalID_Encode( &(pObj->m_terminalID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_mCTerminalIDResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245ConferenceResponse_mCTerminalIDResponse Decode */
HS_RESULT ASNH245ConferenceResponse_mCTerminalIDResponse_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245ConferenceResponse_mCTerminalIDResponse *pObj = (ASNH245ConferenceResponse_mCTerminalIDResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_mCTerminalIDResponse_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245TerminalLabel_Decode(&(pObj->m_terminalLabel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_mCTerminalIDResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245TerminalID_Decode(&(pObj->m_terminalID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_mCTerminalIDResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ConferenceResponse_mCTerminalIDResponse Print */
HS_RESULT ASNH245ConferenceResponse_mCTerminalIDResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ConferenceResponse_mCTerminalIDResponse *pObj = (ASNH245ConferenceResponse_mCTerminalIDResponse *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ConferenceResponse_mCTerminalIDResponse_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245TerminalLabel_Print( &(pObj->m_terminalLabel), pDepth+1, "terminalLabel" );
	ASNH245TerminalID_Print( &(pObj->m_terminalID), pDepth+1, "terminalID" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ConferenceResponse_terminalIDResponse Class
*/
/*ASNH245ConferenceResponse_terminalIDResponse Constructor*/
HS_RESULT new_ASNH245ConferenceResponse_terminalIDResponse(void *pObject)
{
	ASNH245ConferenceResponse_terminalIDResponse *pObj = (ASNH245ConferenceResponse_terminalIDResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ConferenceResponse_terminalIDResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245TerminalLabel( &(pObj->m_terminalLabel) );
	new_ASNH245TerminalID( &(pObj->m_terminalID) );

	return HS_OK;
}

/* ASNH245ConferenceResponse_terminalIDResponse Destructor */
HS_RESULT delete_ASNH245ConferenceResponse_terminalIDResponse(void *pObject)
{
	ASNH245ConferenceResponse_terminalIDResponse *pObj = (ASNH245ConferenceResponse_terminalIDResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConferenceResponse_terminalIDResponse(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245TerminalLabel( &(pObj->m_terminalLabel) );
	delete_ASNH245TerminalID( &(pObj->m_terminalID) );
	return HS_OK;
}

/* ASNH245ConferenceResponse_terminalIDResponse MakeMold */
HS_RESULT ASNH245ConferenceResponse_terminalIDResponse_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245ConferenceResponse_terminalIDResponse *pObj = (ASNH245ConferenceResponse_terminalIDResponse *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_terminalIDResponse_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245TerminalLabel_MakeMold(&(pObj->m_terminalLabel));
	ASNH245TerminalID_MakeMold(&(pObj->m_terminalID));
	return HS_OK;
}

/* ASNH245ConferenceResponse_terminalIDResponse Encode */
HS_RESULT ASNH245ConferenceResponse_terminalIDResponse_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245ConferenceResponse_terminalIDResponse *pObj = (ASNH245ConferenceResponse_terminalIDResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_terminalIDResponse_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245TerminalLabel_Encode( &(pObj->m_terminalLabel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_terminalIDResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245TerminalID_Encode( &(pObj->m_terminalID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_terminalIDResponse_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245ConferenceResponse_terminalIDResponse Decode */
HS_RESULT ASNH245ConferenceResponse_terminalIDResponse_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245ConferenceResponse_terminalIDResponse *pObj = (ASNH245ConferenceResponse_terminalIDResponse *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_terminalIDResponse_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245TerminalLabel_Decode(&(pObj->m_terminalLabel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_terminalIDResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245TerminalID_Decode(&(pObj->m_terminalID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceResponse_terminalIDResponse_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ConferenceResponse_terminalIDResponse Print */
HS_RESULT ASNH245ConferenceResponse_terminalIDResponse_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ConferenceResponse_terminalIDResponse *pObj = (ASNH245ConferenceResponse_terminalIDResponse *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ConferenceResponse_terminalIDResponse_Pri