/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<h245.h>

*/

#include "H245.h"

/***************************************************************************************/
/* ASNH245MiscellaneousCommand_type Struct
*/
/* ASNH245MiscellaneousCommand_type Constructor */
HS_RESULT new_ASNH245MiscellaneousCommand_type( void *pObject )
{
	ASNH245MiscellaneousCommand_type *pObj = (ASNH245MiscellaneousCommand_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MiscellaneousCommand_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MiscellaneousCommand_typeChoice_equaliseDelay;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MiscellaneousCommand_typeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MiscellaneousCommand_type Destructor */
HS_RESULT delete_ASNH245MiscellaneousCommand_type( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MiscellaneousCommand_type *pObj = (ASNH245MiscellaneousCommand_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MiscellaneousCommand_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MiscellaneousCommand_type_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MiscellaneousCommand_type(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MiscellaneousCommand_type SetChoice */
void* ASNH245MiscellaneousCommand_type_SetChoice( void *pObject, ASNH245MiscellaneousCommand_typeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MiscellaneousCommand_type *pObj = (ASNH245MiscellaneousCommand_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MiscellaneousCommand_typeChoiceSizeExt ){
		if( pChoice > (ASNH245MiscellaneousCommand_typeChoice)(e_ASNH245MiscellaneousCommand_typeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MiscellaneousCommand_type_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_equaliseDelay ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_zeroDelay ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_multipointModeCommand ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_cancelMultipointModeCommand ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_videoFreezePicture ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdatePicture ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateGOB ){
		ASNH245MiscellaneousCommand_type_videoFastUpdateGOB *tAlter = (ASNH245MiscellaneousCommand_type_videoFastUpdateGOB *)HSMalloc( sizeof(ASNH245MiscellaneousCommand_type_videoFastUpdateGOB) );
		new_ASNH245MiscellaneousCommand_type_videoFastUpdateGOB(tAlter);
		ASNH245MiscellaneousCommand_type_videoFastUpdateGOB_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_videoTemporalSpatialTradeOff ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,31,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOB ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOBCancel ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateMB ){
		ASNH245MiscellaneousCommand_type_videoFastUpdateMB *tAlter = (ASNH245MiscellaneousCommand_type_videoFastUpdateMB *)HSMalloc( sizeof(ASNH245MiscellaneousCommand_type_videoFastUpdateMB) );
		new_ASNH245MiscellaneousCommand_type_videoFastUpdateMB(tAlter);
		ASNH245MiscellaneousCommand_type_videoFastUpdateMB_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_maxH223MUXPDUsize ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,1,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdate ){
		ASNH245EncryptionSync *tAlter = (ASNH245EncryptionSync *)HSMalloc( sizeof(ASNH245EncryptionSync) );
		new_ASNH245EncryptionSync(tAlter);
		ASNH245EncryptionSync_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdateRequest ){
		ASNH245EncryptionUpdateRequest *tAlter = (ASNH245EncryptionUpdateRequest *)HSMalloc( sizeof(ASNH245EncryptionUpdateRequest) );
		new_ASNH245EncryptionUpdateRequest(tAlter);
		ASNH245EncryptionUpdateRequest_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOff ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOn ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementStart ){
		ASNH245MiscellaneousCommand_type_progressiveRefinementStart *tAlter = (ASNH245MiscellaneousCommand_type_progressiveRefinementStart *)HSMalloc( sizeof(ASNH245MiscellaneousCommand_type_progressiveRefinementStart) );
		new_ASNH245MiscellaneousCommand_type_progressiveRefinementStart(tAlter);
		ASNH245MiscellaneousCommand_type_progressiveRefinementStart_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortOne ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortContinuous ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_videoBadMBs ){
		ASNH245MiscellaneousCommand_type_videoBadMBs *tAlter = (ASNH245MiscellaneousCommand_type_videoBadMBs *)HSMalloc( sizeof(ASNH245MiscellaneousCommand_type_videoBadMBs) );
		new_ASNH245MiscellaneousCommand_type_videoBadMBs(tAlter);
		ASNH245MiscellaneousCommand_type_videoBadMBs_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_lostPicture ){
		ASNH245PictureReference *tAlter = (ASNH245PictureReference *)HSMalloc( sizeof(ASNH245PictureReference) );
		new_ASNH245PictureReference(tAlter);
		ASNH245PictureReference_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH245PictureReference),ASNH245PictureReference_MakeMold,ASNH245PictureReference_Encode,ASNH245PictureReference_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH245PictureReference_Print,
#endif
			delete_ASNH245PictureReference );
		AsnSequenceOf_SetMold(aso,tmold);
		pObj->alter = aso;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_lostPartialPicture ){
		ASNH245MiscellaneousCommand_type_lostPartialPicture *tAlter = (ASNH245MiscellaneousCommand_type_lostPartialPicture *)HSMalloc( sizeof(ASNH245MiscellaneousCommand_type_lostPartialPicture) );
		new_ASNH245MiscellaneousCommand_type_lostPartialPicture(tAlter);
		ASNH245MiscellaneousCommand_type_lostPartialPicture_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousCommand_typeChoice_recoveryReferencePicture ){
		ASNH245PictureReference *tAlter = (ASNH245PictureReference *)HSMalloc( sizeof(ASNH245PictureReference) );
		new_ASNH245PictureReference(tAlter);
		ASNH245PictureReference_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH245PictureReference),ASNH245PictureReference_MakeMold,ASNH245PictureReference_Encode,ASNH245PictureReference_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH245PictureReference_Print,
#endif
			delete_ASNH245PictureReference );
		AsnSequenceOf_SetMold(aso,tmold);
		pObj->alter = aso;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MiscellaneousCommand_type DeleteAlternation */
HS_RESULT ASNH245MiscellaneousCommand_type_DeleteAlternation(void *pObject)
{
	ASNH245MiscellaneousCommand_type *pObj = (ASNH245MiscellaneousCommand_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_equaliseDelay ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_zeroDelay ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_multipointModeCommand ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_cancelMultipointModeCommand ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFreezePicture ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdatePicture ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateGOB ){
			delete_ASNH245MiscellaneousCommand_type_videoFastUpdateGOB(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoTemporalSpatialTradeOff ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOB ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOBCancel ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateMB ){
			delete_ASNH245MiscellaneousCommand_type_videoFastUpdateMB(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_maxH223MUXPDUsize ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdate ){
			delete_ASNH245EncryptionSync(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdateRequest ){
			delete_ASNH245EncryptionUpdateRequest(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOff ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOn ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementStart ){
			delete_ASNH245MiscellaneousCommand_type_progressiveRefinementStart(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortOne ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortContinuous ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoBadMBs ){
			delete_ASNH245MiscellaneousCommand_type_videoBadMBs(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_lostPicture ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_lostPartialPicture ){
			delete_ASNH245MiscellaneousCommand_type_lostPartialPicture(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_recoveryReferencePicture ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MiscellaneousCommand_type_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MiscellaneousCommand_type Encode */
HS_RESULT ASNH245MiscellaneousCommand_type_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MiscellaneousCommand_type *pObj = (ASNH245MiscellaneousCommand_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MiscellaneousCommand_typeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MiscellaneousCommand_typeChoice)(e_ASNH245MiscellaneousCommand_typeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MiscellaneousCommand_typeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MiscellaneousCommand_typeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_equaliseDelay ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_zeroDelay ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_multipointModeCommand ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_cancelMultipointModeCommand ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFreezePicture ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdatePicture ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateGOB ){
		if( (tRet=ASNH245MiscellaneousCommand_type_videoFastUpdateGOB_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoTemporalSpatialTradeOff ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOB ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOBCancel ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateMB ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MiscellaneousCommand_type_videoFastUpdateMB_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_maxH223MUXPDUsize ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdate ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245EncryptionSync_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdateRequest ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245EncryptionUpdateRequest_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOff ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOn ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementStart ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MiscellaneousCommand_type_progressiveRefinementStart_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortOne ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortContinuous ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoBadMBs ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MiscellaneousCommand_type_videoBadMBs_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_lostPicture ){
		AsnStream tTempStrm;
		 new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_lostPartialPicture ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MiscellaneousCommand_type_lostPartialPicture_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_recoveryReferencePicture ){
		AsnStream tTempStrm;
		 new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MiscellaneousCommand_type Decode */
HS_RESULT ASNH245MiscellaneousCommand_type_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MiscellaneousCommand_type *pObj = (ASNH245MiscellaneousCommand_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MiscellaneousCommand_typeChoiceSize;
	}
	else
	{
		if( e_ASNH245MiscellaneousCommand_typeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MiscellaneousCommand_typeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MiscellaneousCommand_typeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MiscellaneousCommand_type_SetChoice( pObj, (ASNH245MiscellaneousCommand_typeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_equaliseDelay ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_zeroDelay ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_multipointModeCommand ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_cancelMultipointModeCommand ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFreezePicture ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdatePicture ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateGOB ){
		if( (tRet=ASNH245MiscellaneousCommand_type_videoFastUpdateGOB_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoTemporalSpatialTradeOff ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOB ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOBCancel ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateMB ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MiscellaneousCommand_type_videoFastUpdateMB_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_maxH223MUXPDUsize ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdate ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245EncryptionSync_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdateRequest ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245EncryptionUpdateRequest_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOff ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOn ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementStart ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MiscellaneousCommand_type_progressiveRefinementStart_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortOne ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortContinuous ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoBadMBs ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MiscellaneousCommand_type_videoBadMBs_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_lostPicture ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_lostPartialPicture ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MiscellaneousCommand_type_lostPartialPicture_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_recoveryReferencePicture ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MiscellaneousCommand_type Print */
HS_RESULT ASNH245MiscellaneousCommand_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MiscellaneousCommand_type *pObj = (ASNH245MiscellaneousCommand_type *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_type_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_equaliseDelay ){
		AsnNull_Print( pObj->alter, pDepth+1, "equaliseDelay" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_zeroDelay ){
		AsnNull_Print( pObj->alter, pDepth+1, "zeroDelay" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_multipointModeCommand ){
		AsnNull_Print( pObj->alter, pDepth+1, "multipointModeCommand" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_cancelMultipointModeCommand ){
		AsnNull_Print( pObj->alter, pDepth+1, "cancelMultipointModeCommand" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFreezePicture ){
		AsnNull_Print( pObj->alter, pDepth+1, "videoFreezePicture" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdatePicture ){
		AsnNull_Print( pObj->alter, pDepth+1, "videoFastUpdatePicture" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateGOB ){
		ASNH245MiscellaneousCommand_type_videoFastUpdateGOB_Print( pObj->alter, pDepth+1, "videoFastUpdateGOB" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoTemporalSpatialTradeOff ){
		AsnInteger_Print( pObj->alter, pDepth+1, "videoTemporalSpatialTradeOff" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOB ){
		AsnNull_Print( pObj->alter, pDepth+1, "videoSendSyncEveryGOB" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoSendSyncEveryGOBCancel ){
		AsnNull_Print( pObj->alter, pDepth+1, "videoSendSyncEveryGOBCancel" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoFastUpdateMB ){
		ASNH245MiscellaneousCommand_type_videoFastUpdateMB_Print( pObj->alter, pDepth+1, "videoFastUpdateMB" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_maxH223MUXPDUsize ){
		AsnInteger_Print( pObj->alter, pDepth+1, "maxH223MUXPDUsize" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdate ){
		ASNH245EncryptionSync_Print( pObj->alter, pDepth+1, "encryptionUpdate" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_encryptionUpdateRequest ){
		ASNH245EncryptionUpdateRequest_Print( pObj->alter, pDepth+1, "encryptionUpdateRequest" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOff ){
		AsnNull_Print( pObj->alter, pDepth+1, "switchReceiveMediaOff" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_switchReceiveMediaOn ){
		AsnNull_Print( pObj->alter, pDepth+1, "switchReceiveMediaOn" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementStart ){
		ASNH245MiscellaneousCommand_type_progressiveRefinementStart_Print( pObj->alter, pDepth+1, "progressiveRefinementStart" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortOne ){
		AsnNull_Print( pObj->alter, pDepth+1, "progressiveRefinementAbortOne" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_progressiveRefinementAbortContinuous ){
		AsnNull_Print( pObj->alter, pDepth+1, "progressiveRefinementAbortContinuous" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_videoBadMBs ){
		ASNH245MiscellaneousCommand_type_videoBadMBs_Print( pObj->alter, pDepth+1, "videoBadMBs" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_lostPicture ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "lostPicture" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_lostPartialPicture ){
		ASNH245MiscellaneousCommand_type_lostPartialPicture_Print( pObj->alter, pDepth+1, "lostPartialPicture" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousCommand_typeChoice_recoveryReferencePicture ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "recoveryReferencePicture" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MiscellaneousCommand Class
*/
/*ASNH245MiscellaneousCommand Constructor*/
HS_RESULT new_ASNH245MiscellaneousCommand(void *pObject)
{
	ASNH245MiscellaneousCommand *pObj = (ASNH245MiscellaneousCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MiscellaneousCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );
	new_ASNH245MiscellaneousCommand_type( &(pObj->m_type) );

	return HS_OK;
}

/* ASNH245MiscellaneousCommand Destructor */
HS_RESULT delete_ASNH245MiscellaneousCommand(void *pObject)
{
	ASNH245MiscellaneousCommand *pObj = (ASNH245MiscellaneousCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MiscellaneousCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );
	delete_ASNH245MiscellaneousCommand_type( &(pObj->m_type) );
	return HS_OK;
}

/* ASNH245MiscellaneousCommand MakeMold */
HS_RESULT ASNH245MiscellaneousCommand_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MiscellaneousCommand *pObj = (ASNH245MiscellaneousCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_logicalChannelNumber));
	return HS_OK;
}

/* ASNH245MiscellaneousCommand Encode */
HS_RESULT ASNH245MiscellaneousCommand_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MiscellaneousCommand *pObj = (ASNH245MiscellaneousCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MiscellaneousCommand_type_Encode( &(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MiscellaneousCommand Decode */
HS_RESULT ASNH245MiscellaneousCommand_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MiscellaneousCommand *pObj = (ASNH245MiscellaneousCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MiscellaneousCommand_type_Decode(&(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MiscellaneousCommand Print */
HS_RESULT ASNH245MiscellaneousCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MiscellaneousCommand *pObj = (ASNH245MiscellaneousCommand *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MiscellaneousCommand_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_logicalChannelNumber), pDepth+1, "logicalChannelNumber" );
	ASNH245MiscellaneousCommand_type_Print( &(pObj->m_type), pDepth+1, "type" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CommunicationModeCommand Class
*/
/*ASNH245CommunicationModeCommand Constructor*/
HS_RESULT new_ASNH245CommunicationModeCommand(void *pObject)
{
	ASNH245CommunicationModeCommand *pObj = (ASNH245CommunicationModeCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CommunicationModeCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_communicationModeTable), e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245CommunicationModeCommand Destructor */
HS_RESULT delete_ASNH245CommunicationModeCommand(void *pObject)
{
	ASNH245CommunicationModeCommand *pObj = (ASNH245CommunicationModeCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CommunicationModeCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_communicationModeTable) );
	return HS_OK;
}

/* ASNH245CommunicationModeCommand MakeMold */
HS_RESULT ASNH245CommunicationModeCommand_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245CommunicationModeCommand *pObj = (ASNH245CommunicationModeCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeCommand_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245CommunicationModeTableEntry *tmold_communicationModeTable = (ASNH245CommunicationModeTableEntry *)HSMalloc( sizeof(ASNH245CommunicationModeTableEntry) );
	new_ASNH245CommunicationModeTableEntry(tmold_communicationModeTable);
	ASNH245CommunicationModeTableEntry_MakeMold(tmold_communicationModeTable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_communicationModeTable,sizeof(ASNH245CommunicationModeTableEntry),ASNH245CommunicationModeTableEntry_MakeMold,ASNH245CommunicationModeTableEntry_Encode,ASNH245CommunicationModeTableEntry_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245CommunicationModeTableEntry_Print,
#endif
		delete_ASNH245CommunicationModeTableEntry);
	AsnSequenceOf_SetMold( &(pObj->m_communicationModeTable), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_communicationModeTable.constraint.type = e_constrained;
	pObj->m_communicationModeTable.constraint.minValue = 1;
	pObj->m_communicationModeTable.constraint.maxValue = 256;
	pObj->m_communicationModeTable.extMinValue = 0;
	pObj->m_communicationModeTable.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245CommunicationModeCommand Encode */
HS_RESULT ASNH245CommunicationModeCommand_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CommunicationModeCommand *pObj = (ASNH245CommunicationModeCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeCommand_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_communicationModeTable),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245CommunicationModeCommand Decode */
HS_RESULT ASNH245CommunicationModeCommand_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245CommunicationModeCommand *pObj = (ASNH245CommunicationModeCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeCommand_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_communicationModeTable),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommunicationModeCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CommunicationModeCommand Print */
HS_RESULT ASNH245CommunicationModeCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CommunicationModeCommand *pObj = (ASNH245CommunicationModeCommand *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CommunicationModeCommand_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSequenceOf_Print( &(pObj->m_communicationModeTable), pDepth+1, "communicationModeTable" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245SubstituteConferenceIDCommand Class
*/
/*ASNH245SubstituteConferenceIDCommand Constructor*/
HS_RESULT new_ASNH245SubstituteConferenceIDCommand(void *pObject)
{
	ASNH245SubstituteConferenceIDCommand *pObj = (ASNH245SubstituteConferenceIDCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245SubstituteConferenceIDCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_conferenceIdentifier), e_constrained, 16, 16, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245SubstituteConferenceIDCommand Destructor */
HS_RESULT delete_ASNH245SubstituteConferenceIDCommand(void *pObject)
{
	ASNH245SubstituteConferenceIDCommand *pObj = (ASNH245SubstituteConferenceIDCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245SubstituteConferenceIDCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_conferenceIdentifier) );
	return HS_OK;
}

/* ASNH245SubstituteConferenceIDCommand MakeMold */
HS_RESULT ASNH245SubstituteConferenceIDCommand_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245SubstituteConferenceIDCommand *pObj = (ASNH245SubstituteConferenceIDCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245SubstituteConferenceIDCommand_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245SubstituteConferenceIDCommand Encode */
HS_RESULT ASNH245SubstituteConferenceIDCommand_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245SubstituteConferenceIDCommand *pObj = (ASNH245SubstituteConferenceIDCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245SubstituteConferenceIDCommand_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_conferenceIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245SubstituteConferenceIDCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245SubstituteConferenceIDCommand Decode */
HS_RESULT ASNH245SubstituteConferenceIDCommand_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245SubstituteConferenceIDCommand *pObj = (ASNH245SubstituteConferenceIDCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245SubstituteConferenceIDCommand_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_conferenceIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245SubstituteConferenceIDCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245SubstituteConferenceIDCommand Print */
HS_RESULT ASNH245SubstituteConferenceIDCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245SubstituteConferenceIDCommand *pObj = (ASNH245SubstituteConferenceIDCommand *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245SubstituteConferenceIDCommand_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_conferenceIdentifier), pDepth+1, "conferenceIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ConferenceCommand Struct
*/
/* ASNH245ConferenceCommand Constructor */
HS_RESULT new_ASNH245ConferenceCommand( void *pObject )
{
	ASNH245ConferenceCommand *pObj = (ASNH245ConferenceCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ConferenceCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245ConferenceCommandChoice_broadcastMyLogicalChannel;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245ConferenceCommandChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245ConferenceCommand Destructor */
HS_RESULT delete_ASNH245ConferenceCommand( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245ConferenceCommand *pObj = (ASNH245ConferenceCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConferenceCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245ConferenceCommand_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConferenceCommand(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245ConferenceCommand SetChoice */
void* ASNH245ConferenceCommand_SetChoice( void *pObject, ASNH245ConferenceCommandChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245ConferenceCommand *pObj = (ASNH245ConferenceCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceCommand_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245ConferenceCommandChoiceSizeExt ){
		if( pChoice > (ASNH245ConferenceCommandChoice)(e_ASNH245ConferenceCommandChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245ConferenceCommand_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245ConferenceCommandChoice_broadcastMyLogicalChannel ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceCommandChoice_cancelBroadcastMyLogicalChannel ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceCommandChoice_makeTerminalBroadcaster ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceCommandChoice_cancelMakeTerminalBroadcaster ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceCommandChoice_sendThisSource ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceCommandChoice_cancelSendThisSource ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceCommandChoice_dropConference ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245ConferenceCommandChoice_substituteConferenceIDCommand ){
		ASNH245SubstituteConferenceIDCommand *tAlter = (ASNH245SubstituteConferenceIDCommand *)HSMalloc( sizeof(ASNH245SubstituteConferenceIDCommand) );
		new_ASNH245SubstituteConferenceIDCommand(tAlter);
		ASNH245SubstituteConferenceIDCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceCommand_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245ConferenceCommand DeleteAlternation */
HS_RESULT ASNH245ConferenceCommand_DeleteAlternation(void *pObject)
{
	ASNH245ConferenceCommand *pObj = (ASNH245ConferenceCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceCommand_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245ConferenceCommandChoice_broadcastMyLogicalChannel ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelBroadcastMyLogicalChannel ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_makeTerminalBroadcaster ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelMakeTerminalBroadcaster ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_sendThisSource ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelSendThisSource ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_dropConference ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_substituteConferenceIDCommand ){
			delete_ASNH245SubstituteConferenceIDCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245ConferenceCommand_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245ConferenceCommand Encode */
HS_RESULT ASNH245ConferenceCommand_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245ConferenceCommand *pObj = (ASNH245ConferenceCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245ConferenceCommandChoiceSize )
		{
			if( pObj->choice > ((ASNH245ConferenceCommandChoice)(e_ASNH245ConferenceCommandChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245ConferenceCommandChoiceSize)) )
	}
	else
	{
		if( e_ASNH245ConferenceCommandChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ConferenceCommandChoice_broadcastMyLogicalChannel ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelBroadcastMyLogicalChannel ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_makeTerminalBroadcaster ){
		if( (tRet=ASNH245TerminalLabel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelMakeTerminalBroadcaster ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_sendThisSource ){
		if( (tRet=ASNH245TerminalLabel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelSendThisSource ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_dropConference ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_substituteConferenceIDCommand ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245SubstituteConferenceIDCommand_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceCommand_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245ConferenceCommand Decode */
HS_RESULT ASNH245ConferenceCommand_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245ConferenceCommand *pObj = (ASNH245ConferenceCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245ConferenceCommandChoiceSize;
	}
	else
	{
		if( e_ASNH245ConferenceCommandChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245ConferenceCommandChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245ConferenceCommandChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245ConferenceCommand_SetChoice( pObj, (ASNH245ConferenceCommandChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ConferenceCommandChoice_broadcastMyLogicalChannel ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelBroadcastMyLogicalChannel ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_makeTerminalBroadcaster ){
		if( (tRet=ASNH245TerminalLabel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelMakeTerminalBroadcaster ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_sendThisSource ){
		if( (tRet=ASNH245TerminalLabel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelSendThisSource ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_dropConference ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_substituteConferenceIDCommand ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245SubstituteConferenceIDCommand_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceCommand_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ConferenceCommand Print */
HS_RESULT ASNH245ConferenceCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ConferenceCommand *pObj = (ASNH245ConferenceCommand *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ConferenceCommand_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ConferenceCommandChoice_broadcastMyLogicalChannel ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "broadcastMyLogicalChannel" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelBroadcastMyLogicalChannel ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "cancelBroadcastMyLogicalChannel" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_makeTerminalBroadcaster ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "makeTerminalBroadcaster" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelMakeTerminalBroadcaster ){
		AsnNull_Print( pObj->alter, pDepth+1, "cancelMakeTerminalBroadcaster" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_sendThisSource ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "sendThisSource" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_cancelSendThisSource ){
		AsnNull_Print( pObj->alter, pDepth+1, "cancelSendThisSource" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_dropConference ){
		AsnNull_Print( pObj->alter, pDepth+1, "dropConference" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245ConferenceCommandChoice_substituteConferenceIDCommand ){
		ASNH245SubstituteConferenceIDCommand_Print( pObj->alter, pDepth+1, "substituteConferenceIDCommand" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223MultiplexReconfiguration_h223ModeChange Struct
*/
/* ASNH245H223MultiplexReconfiguration_h223ModeChange Constructor */
HS_RESULT new_ASNH245H223MultiplexReconfiguration_h223ModeChange( void *pObject )
{
	ASNH245H223MultiplexReconfiguration_h223ModeChange *pObj = (ASNH245H223MultiplexReconfiguration_h223ModeChange *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223MultiplexReconfiguration_h223ModeChange(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel0;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245H223MultiplexReconfiguration_h223ModeChange Destructor */
HS_RESULT delete_ASNH245H223MultiplexReconfiguration_h223ModeChange( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245H223MultiplexReconfiguration_h223ModeChange *pObj = (ASNH245H223MultiplexReconfiguration_h223ModeChange *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223MultiplexReconfiguration_h223ModeChange(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245H223MultiplexReconfiguration_h223ModeChange_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223MultiplexReconfiguration_h223ModeChange(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245H223MultiplexReconfiguration_h223ModeChange SetChoice */
void* ASNH245H223MultiplexReconfiguration_h223ModeChange_SetChoice( void *pObject, ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245H223MultiplexReconfiguration_h223ModeChange *pObj = (ASNH245H223MultiplexReconfiguration_h223ModeChange *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSizeExt ){
		if( pChoice > (ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice)(e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245H223MultiplexReconfiguration_h223ModeChange_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel0 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel1 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2withOptionalHeader ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245H223MultiplexReconfiguration_h223ModeChange DeleteAlternation */
HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_DeleteAlternation(void *pObject)
{
	ASNH245H223MultiplexReconfiguration_h223ModeChange *pObj = (ASNH245H223MultiplexReconfiguration_h223ModeChange *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel0 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel1 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2withOptionalHeader ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245H223MultiplexReconfiguration_h223ModeChange Encode */
HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245H223MultiplexReconfiguration_h223ModeChange *pObj = (ASNH245H223MultiplexReconfiguration_h223ModeChange *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSize )
		{
			if( pObj->choice > ((ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice)(e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel0 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel1 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2withOptionalHeader ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245H223MultiplexReconfiguration_h223ModeChange Decode */
HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245H223MultiplexReconfiguration_h223ModeChange *pObj = (ASNH245H223MultiplexReconfiguration_h223ModeChange *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSize;
	}
	else
	{
		if( e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245H223MultiplexReconfiguration_h223ModeChange_SetChoice( pObj, (ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel0 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel1 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2withOptionalHeader ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223MultiplexReconfiguration_h223ModeChange Print */
HS_RESULT ASNH245H223MultiplexReconfiguration_h223ModeChange_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223MultiplexReconfiguration_h223ModeChange *pObj = (ASNH245H223MultiplexReconfiguration_h223ModeChange *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223ModeChange_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel0 ){
		AsnNull_Print( pObj->alter, pDepth+1, "toLevel0" );
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel1 ){
		AsnNull_Print( pObj->alter, pDepth+1, "toLevel1" );
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2 ){
		AsnNull_Print( pObj->alter, pDepth+1, "toLevel2" );
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223ModeChangeChoice_toLevel2withOptionalHeader ){
		AsnNull_Print( pObj->alter, pDepth+1, "toLevel2withOptionalHeader" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag Struct
*/
/* ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag Constructor */
HS_RESULT new_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag( void *pObject )
{
	ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *pObj = (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_start;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag Destructor */
HS_RESULT delete_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *pObj = (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag SetChoice */
void* ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_SetChoice( void *pObject, ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *pObj = (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSizeExt ){
		if( pChoice > (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice)(e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_start ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_stop ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag DeleteAlternation */
HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_DeleteAlternation(void *pObject)
{
	ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *pObj = (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_start ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_stop ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag Encode */
HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *pObj = (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSize )
		{
			if( pObj->choice > ((ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice)(e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSize)) )
	}
	else
	{
		if( e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_start ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_stop ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag Decode */
HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *pObj = (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSize;
	}
	else
	{
		if( e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_SetChoice( pObj, (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_start ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_stop ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag Print */
HS_RESULT ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *pObj = (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_start ){
		AsnNull_Print( pObj->alter, pDepth+1, "start" );
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlagChoice_stop ){
		AsnNull_Print( pObj->alter, pDepth+1, "stop" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223MultiplexReconfiguration Struct
*/
/* ASNH245H223MultiplexReconfiguration Constructor */
HS_RESULT new_ASNH245H223MultiplexReconfiguration( void *pObject )
{
	ASNH245H223MultiplexReconfiguration *pObj = (ASNH245H223MultiplexReconfiguration *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223MultiplexReconfiguration(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245H223MultiplexReconfigurationChoice_h223ModeChange;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245H223MultiplexReconfigurationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245H223MultiplexReconfiguration Destructor */
HS_RESULT delete_ASNH245H223MultiplexReconfiguration( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245H223MultiplexReconfiguration *pObj = (ASNH245H223MultiplexReconfiguration *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223MultiplexReconfiguration(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245H223MultiplexReconfiguration_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223MultiplexReconfiguration(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245H223MultiplexReconfiguration SetChoice */
void* ASNH245H223MultiplexReconfiguration_SetChoice( void *pObject, ASNH245H223MultiplexReconfigurationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245H223MultiplexReconfiguration *pObj = (ASNH245H223MultiplexReconfiguration *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245H223MultiplexReconfigurationChoiceSizeExt ){
		if( pChoice > (ASNH245H223MultiplexReconfigurationChoice)(e_ASNH245H223MultiplexReconfigurationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245H223MultiplexReconfiguration_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245H223MultiplexReconfigurationChoice_h223ModeChange ){
		ASNH245H223MultiplexReconfiguration_h223ModeChange *tAlter = (ASNH245H223MultiplexReconfiguration_h223ModeChange *)HSMalloc( sizeof(ASNH245H223MultiplexReconfiguration_h223ModeChange) );
		new_ASNH245H223MultiplexReconfiguration_h223ModeChange(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H223MultiplexReconfigurationChoice_h223AnnexADoubleFlag ){
		ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *tAlter = (ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag *)HSMalloc( sizeof(ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag) );
		new_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245H223MultiplexReconfiguration DeleteAlternation */
HS_RESULT ASNH245H223MultiplexReconfiguration_DeleteAlternation(void *pObject)
{
	ASNH245H223MultiplexReconfiguration *pObj = (ASNH245H223MultiplexReconfiguration *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245H223MultiplexReconfigurationChoice_h223ModeChange ){
			delete_ASNH245H223MultiplexReconfiguration_h223ModeChange(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H223MultiplexReconfigurationChoice_h223AnnexADoubleFlag ){
			delete_ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245H223MultiplexReconfiguration_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245H223MultiplexReconfiguration Encode */
HS_RESULT ASNH245H223MultiplexReconfiguration_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245H223MultiplexReconfiguration *pObj = (ASNH245H223MultiplexReconfiguration *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245H223MultiplexReconfigurationChoiceSize )
		{
			if( pObj->choice > ((ASNH245H223MultiplexReconfigurationChoice)(e_ASNH245H223MultiplexReconfigurationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245H223MultiplexReconfigurationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245H223MultiplexReconfigurationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223MultiplexReconfigurationChoice_h223ModeChange ){
		if( (tRet=ASNH245H223MultiplexReconfiguration_h223ModeChange_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfigurationChoice_h223AnnexADoubleFlag ){
		if( (tRet=ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245H223MultiplexReconfiguration Decode */
HS_RESULT ASNH245H223MultiplexReconfiguration_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245H223MultiplexReconfiguration *pObj = (ASNH245H223MultiplexReconfiguration *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245H223MultiplexReconfigurationChoiceSize;
	}
	else
	{
		if( e_ASNH245H223MultiplexReconfigurationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245H223MultiplexReconfigurationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245H223MultiplexReconfigurationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245H223MultiplexReconfiguration_SetChoice( pObj, (ASNH245H223MultiplexReconfigurationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223MultiplexReconfigurationChoice_h223ModeChange ){
		if( (tRet=ASNH245H223MultiplexReconfiguration_h223ModeChange_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfigurationChoice_h223AnnexADoubleFlag ){
		if( (tRet=ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223MultiplexReconfiguration Print */
HS_RESULT ASNH245H223MultiplexReconfiguration_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223MultiplexReconfiguration *pObj = (ASNH245H223MultiplexReconfiguration *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223MultiplexReconfiguration_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H223MultiplexReconfigurationChoice_h223ModeChange ){
		ASNH245H223MultiplexReconfiguration_h223ModeChange_Print( pObj->alter, pDepth+1, "h223ModeChange" );
	}
	else if ( pObj->choice == e_ASNH245H223MultiplexReconfigurationChoice_h223AnnexADoubleFlag ){
		ASNH245H223MultiplexReconfiguration_h223AnnexADoubleFlag_Print( pObj->alter, pDepth+1, "h223AnnexADoubleFlag" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCCommand_aal_aal1_clockRecovery Struct
*/
/* ASNH245NewATMVCCommand_aal_aal1_clockRecovery Constructor */
HS_RESULT new_ASNH245NewATMVCCommand_aal_aal1_clockRecovery( void *pObject )
{
	ASNH245NewATMVCCommand_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCCommand_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCCommand_aal_aal1_clockRecovery(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_nullClockRecovery;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCCommand_aal_aal1_clockRecovery Destructor */
HS_RESULT delete_ASNH245NewATMVCCommand_aal_aal1_clockRecovery( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCCommand_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCCommand_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_aal_aal1_clockRecovery(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCCommand_aal_aal1_clockRecovery_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_aal_aal1_clockRecovery(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCCommand_aal_aal1_clockRecovery SetChoice */
void* ASNH245NewATMVCCommand_aal_aal1_clockRecovery_SetChoice( void *pObject, ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCCommand_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCCommand_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice)(e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCCommand_aal_aal1_clockRecovery_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCCommand_aal_aal1_clockRecovery DeleteAlternation */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCCommand_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCCommand_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCCommand_aal_aal1_clockRecovery Encode */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCCommand_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice)(e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal1_clockRecovery Decode */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCCommand_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCCommand_aal_aal1_clockRecovery_SetChoice( pObj, (ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCCommand_aal_aal1_clockRecovery Print */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCCommand_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCCommand_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
		AsnNull_Print( pObj->alter, pDepth+1, "nullClockRecovery" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
		AsnNull_Print( pObj->alter, pDepth+1, "srtsClockRecovery" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
		AsnNull_Print( pObj->alter, pDepth+1, "adaptiveClockRecovery" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCCommand_aal_aal1_errorCorrection Struct
*/
/* ASNH245NewATMVCCommand_aal_aal1_errorCorrection Constructor */
HS_RESULT new_ASNH245NewATMVCCommand_aal_aal1_errorCorrection( void *pObject )
{
	ASNH245NewATMVCCommand_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCCommand_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCCommand_aal_aal1_errorCorrection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_nullErrorCorrection;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCCommand_aal_aal1_errorCorrection Destructor */
HS_RESULT delete_ASNH245NewATMVCCommand_aal_aal1_errorCorrection( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCCommand_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCCommand_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_aal_aal1_errorCorrection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCCommand_aal_aal1_errorCorrection_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_aal_aal1_errorCorrection(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCCommand_aal_aal1_errorCorrection SetChoice */
void* ASNH245NewATMVCCommand_aal_aal1_errorCorrection_SetChoice( void *pObject, ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCCommand_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCCommand_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice)(e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCCommand_aal_aal1_errorCorrection_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_longInterleaver ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_shortInterleaver ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCCommand_aal_aal1_errorCorrection DeleteAlternation */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCCommand_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCCommand_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_longInterleaver ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_shortInterleaver ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCCommand_aal_aal1_errorCorrection Encode */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCCommand_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice)(e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_longInterleaver ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_shortInterleaver ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal1_errorCorrection Decode */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCCommand_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCCommand_aal_aal1_errorCorrection_SetChoice( pObj, (ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_longInterleaver ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_shortInterleaver ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCCommand_aal_aal1_errorCorrection Print */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCCommand_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCCommand_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
		AsnNull_Print( pObj->alter, pDepth+1, "nullErrorCorrection" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_longInterleaver ){
		AsnNull_Print( pObj->alter, pDepth+1, "longInterleaver" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_shortInterleaver ){
		AsnNull_Print( pObj->alter, pDepth+1, "shortInterleaver" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
		AsnNull_Print( pObj->alter, pDepth+1, "errorCorrectionOnly" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCCommand_aal_aal1 Class
*/
/*ASNH245NewATMVCCommand_aal_aal1 Constructor*/
HS_RESULT new_ASNH245NewATMVCCommand_aal_aal1(void *pObject)
{
	ASNH245NewATMVCCommand_aal_aal1 *pObj = (ASNH245NewATMVCCommand_aal_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCCommand_aal_aal1(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245NewATMVCCommand_aal_aal1_clockRecovery( &(pObj->m_clockRecovery) );
	new_ASNH245NewATMVCCommand_aal_aal1_errorCorrection( &(pObj->m_errorCorrection) );
	new_AsnBoolean( &(pObj->m_structuredDataTransfer) );
	new_AsnBoolean( &(pObj->m_partiallyFilledCells) );

	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal1 Destructor */
HS_RESULT delete_ASNH245NewATMVCCommand_aal_aal1(void *pObject)
{
	ASNH245NewATMVCCommand_aal_aal1 *pObj = (ASNH245NewATMVCCommand_aal_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_aal_aal1(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245NewATMVCCommand_aal_aal1_clockRecovery( &(pObj->m_clockRecovery) );
	delete_ASNH245NewATMVCCommand_aal_aal1_errorCorrection( &(pObj->m_errorCorrection) );
	delete_AsnBoolean( &(pObj->m_structuredDataTransfer) );
	delete_AsnBoolean( &(pObj->m_partiallyFilledCells) );
	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal1 MakeMold */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NewATMVCCommand_aal_aal1 *pObj = (ASNH245NewATMVCCommand_aal_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal1 Encode */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCCommand_aal_aal1 *pObj = (ASNH245NewATMVCCommand_aal_aal1 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Encode( &(pObj->m_clockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Encode( &(pObj->m_errorCorrection),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_structuredDataTransfer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_partiallyFilledCells),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal1 Decode */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCCommand_aal_aal1 *pObj = (ASNH245NewATMVCCommand_aal_aal1 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Decode(&(pObj->m_clockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Decode(&(pObj->m_errorCorrection),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_structuredDataTransfer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_partiallyFilledCells),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCCommand_aal_aal1 Print */
HS_RESULT ASNH245NewATMVCCommand_aal_aal1_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCCommand_aal_aal1 *pObj = (ASNH245NewATMVCCommand_aal_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal1_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245NewATMVCCommand_aal_aal1_clockRecovery_Print( &(pObj->m_clockRecovery), pDepth+1, "clockRecovery" );
	ASNH245NewATMVCCommand_aal_aal1_errorCorrection_Print( &(pObj->m_errorCorrection), pDepth+1, "errorCorrection" );
	AsnBoolean_Print( &(pObj->m_structuredDataTransfer), pDepth+1, "structuredDataTransfer" );
	AsnBoolean_Print( &(pObj->m_partiallyFilledCells), pDepth+1, "partiallyFilledCells" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCCommand_aal_aal5 Class
*/
/*ASNH245NewATMVCCommand_aal_aal5 Constructor*/
HS_RESULT new_ASNH245NewATMVCCommand_aal_aal5(void *pObject)
{
	ASNH245NewATMVCCommand_aal_aal5 *pObj = (ASNH245NewATMVCCommand_aal_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCCommand_aal_aal5(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_forwardMaximumSDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_backwardMaximumSDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal5 Destructor */
HS_RESULT delete_ASNH245NewATMVCCommand_aal_aal5(void *pObject)
{
	ASNH245NewATMVCCommand_aal_aal5 *pObj = (ASNH245NewATMVCCommand_aal_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_aal_aal5(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_forwardMaximumSDUSize) );
	delete_AsnInteger( &(pObj->m_backwardMaximumSDUSize) );
	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal5 MakeMold */
HS_RESULT ASNH245NewATMVCCommand_aal_aal5_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NewATMVCCommand_aal_aal5 *pObj = (ASNH245NewATMVCCommand_aal_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal5_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal5 Encode */
HS_RESULT ASNH245NewATMVCCommand_aal_aal5_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCCommand_aal_aal5 *pObj = (ASNH245NewATMVCCommand_aal_aal5 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal5_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_forwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal5_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_backwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal5_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal_aal5 Decode */
HS_RESULT ASNH245NewATMVCCommand_aal_aal5_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCCommand_aal_aal5 *pObj = (ASNH245NewATMVCCommand_aal_aal5 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal5_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_forwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal5_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_backwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal5_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCCommand_aal_aal5 Print */
HS_RESULT ASNH245NewATMVCCommand_aal_aal5_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCCommand_aal_aal5 *pObj = (ASNH245NewATMVCCommand_aal_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_aal5_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_forwardMaximumSDUSize), pDepth+1, "forwardMaximumSDUSize" );
	AsnInteger_Print( &(pObj->m_backwardMaximumSDUSize), pDepth+1, "backwardMaximumSDUSize" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCCommand_aal Struct
*/
/* ASNH245NewATMVCCommand_aal Constructor */
HS_RESULT new_ASNH245NewATMVCCommand_aal( void *pObject )
{
	ASNH245NewATMVCCommand_aal *pObj = (ASNH245NewATMVCCommand_aal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCCommand_aal(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCCommand_aalChoice_aal1;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCCommand_aalChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCCommand_aal Destructor */
HS_RESULT delete_ASNH245NewATMVCCommand_aal( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCCommand_aal *pObj = (ASNH245NewATMVCCommand_aal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_aal(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCCommand_aal_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_aal(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCCommand_aal SetChoice */
void* ASNH245NewATMVCCommand_aal_SetChoice( void *pObject, ASNH245NewATMVCCommand_aalChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCCommand_aal *pObj = (ASNH245NewATMVCCommand_aal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCCommand_aalChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCCommand_aalChoice)(e_ASNH245NewATMVCCommand_aalChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCCommand_aal_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCCommand_aalChoice_aal1 ){
		ASNH245NewATMVCCommand_aal_aal1 *tAlter = (ASNH245NewATMVCCommand_aal_aal1 *)HSMalloc( sizeof(ASNH245NewATMVCCommand_aal_aal1) );
		new_ASNH245NewATMVCCommand_aal_aal1(tAlter);
		ASNH245NewATMVCCommand_aal_aal1_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_aalChoice_aal5 ){
		ASNH245NewATMVCCommand_aal_aal5 *tAlter = (ASNH245NewATMVCCommand_aal_aal5 *)HSMalloc( sizeof(ASNH245NewATMVCCommand_aal_aal5) );
		new_ASNH245NewATMVCCommand_aal_aal5(tAlter);
		ASNH245NewATMVCCommand_aal_aal5_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCCommand_aal DeleteAlternation */
HS_RESULT ASNH245NewATMVCCommand_aal_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCCommand_aal *pObj = (ASNH245NewATMVCCommand_aal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCCommand_aalChoice_aal1 ){
			delete_ASNH245NewATMVCCommand_aal_aal1(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_aalChoice_aal5 ){
			delete_ASNH245NewATMVCCommand_aal_aal5(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCCommand_aal_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCCommand_aal Encode */
HS_RESULT ASNH245NewATMVCCommand_aal_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_aal *pObj = (ASNH245NewATMVCCommand_aal *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCCommand_aalChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCCommand_aalChoice)(e_ASNH245NewATMVCCommand_aalChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCCommand_aalChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_aalChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_aalChoice_aal1 ){
		if( (tRet=ASNH245NewATMVCCommand_aal_aal1_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aalChoice_aal5 ){
		if( (tRet=ASNH245NewATMVCCommand_aal_aal5_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_aal Decode */
HS_RESULT ASNH245NewATMVCCommand_aal_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_aal *pObj = (ASNH245NewATMVCCommand_aal *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCCommand_aalChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_aalChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCCommand_aalChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCCommand_aalChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCCommand_aal_SetChoice( pObj, (ASNH245NewATMVCCommand_aalChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_aalChoice_aal1 ){
		if( (tRet=ASNH245NewATMVCCommand_aal_aal1_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aalChoice_aal5 ){
		if( (tRet=ASNH245NewATMVCCommand_aal_aal5_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCCommand_aal Print */
HS_RESULT ASNH245NewATMVCCommand_aal_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCCommand_aal *pObj = (ASNH245NewATMVCCommand_aal *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCCommand_aal_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_aalChoice_aal1 ){
		ASNH245NewATMVCCommand_aal_aal1_Print( pObj->alter, pDepth+1, "aal1" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_aalChoice_aal5 ){
		ASNH245NewATMVCCommand_aal_aal5_Print( pObj->alter, pDepth+1, "aal5" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCCommand_multiplex Struct
*/
/* ASNH245NewATMVCCommand_multiplex Constructor */
HS_RESULT new_ASNH245NewATMVCCommand_multiplex( void *pObject )
{
	ASNH245NewATMVCCommand_multiplex *pObj = (ASNH245NewATMVCCommand_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCCommand_multiplex(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCCommand_multiplexChoice_noMultiplex;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCCommand_multiplexChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCCommand_multiplex Destructor */
HS_RESULT delete_ASNH245NewATMVCCommand_multiplex( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCCommand_multiplex *pObj = (ASNH245NewATMVCCommand_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_multiplex(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCCommand_multiplex_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_multiplex(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCCommand_multiplex SetChoice */
void* ASNH245NewATMVCCommand_multiplex_SetChoice( void *pObject, ASNH245NewATMVCCommand_multiplexChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCCommand_multiplex *pObj = (ASNH245NewATMVCCommand_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCCommand_multiplexChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCCommand_multiplexChoice)(e_ASNH245NewATMVCCommand_multiplexChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCCommand_multiplex_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCCommand_multiplexChoice_noMultiplex ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_multiplexChoice_transportStream ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_multiplexChoice_programStream ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCCommand_multiplex DeleteAlternation */
HS_RESULT ASNH245NewATMVCCommand_multiplex_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCCommand_multiplex *pObj = (ASNH245NewATMVCCommand_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_noMultiplex ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_transportStream ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_programStream ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCCommand_multiplex_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCCommand_multiplex Encode */
HS_RESULT ASNH245NewATMVCCommand_multiplex_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_multiplex *pObj = (ASNH245NewATMVCCommand_multiplex *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCCommand_multiplexChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCCommand_multiplexChoice)(e_ASNH245NewATMVCCommand_multiplexChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCCommand_multiplexChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_multiplexChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_noMultiplex ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_transportStream ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_programStream ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_multiplex Decode */
HS_RESULT ASNH245NewATMVCCommand_multiplex_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_multiplex *pObj = (ASNH245NewATMVCCommand_multiplex *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCCommand_multiplexChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_multiplexChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCCommand_multiplexChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCCommand_multiplexChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCCommand_multiplex_SetChoice( pObj, (ASNH245NewATMVCCommand_multiplexChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_noMultiplex ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_transportStream ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_programStream ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCCommand_multiplex Print */
HS_RESULT ASNH245NewATMVCCommand_multiplex_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCCommand_multiplex *pObj = (ASNH245NewATMVCCommand_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCCommand_multiplex_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_noMultiplex ){
		AsnNull_Print( pObj->alter, pDepth+1, "noMultiplex" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_transportStream ){
		AsnNull_Print( pObj->alter, pDepth+1, "transportStream" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_multiplexChoice_programStream ){
		AsnNull_Print( pObj->alter, pDepth+1, "programStream" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCCommand_reverseParameters_multiplex Struct
*/
/* ASNH245NewATMVCCommand_reverseParameters_multiplex Constructor */
HS_RESULT new_ASNH245NewATMVCCommand_reverseParameters_multiplex( void *pObject )
{
	ASNH245NewATMVCCommand_reverseParameters_multiplex *pObj = (ASNH245NewATMVCCommand_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCCommand_reverseParameters_multiplex(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_noMultiplex;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCCommand_reverseParameters_multiplex Destructor */
HS_RESULT delete_ASNH245NewATMVCCommand_reverseParameters_multiplex( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCCommand_reverseParameters_multiplex *pObj = (ASNH245NewATMVCCommand_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_reverseParameters_multiplex(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCCommand_reverseParameters_multiplex_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_reverseParameters_multiplex(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCCommand_reverseParameters_multiplex SetChoice */
void* ASNH245NewATMVCCommand_reverseParameters_multiplex_SetChoice( void *pObject, ASNH245NewATMVCCommand_reverseParameters_multiplexChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCCommand_reverseParameters_multiplex *pObj = (ASNH245NewATMVCCommand_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCCommand_reverseParameters_multiplexChoice)(e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCCommand_reverseParameters_multiplex_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_noMultiplex ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_transportStream ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_programStream ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCCommand_reverseParameters_multiplex DeleteAlternation */
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCCommand_reverseParameters_multiplex *pObj = (ASNH245NewATMVCCommand_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_noMultiplex ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_transportStream ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_programStream ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCCommand_reverseParameters_multiplex Encode */
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_reverseParameters_multiplex *pObj = (ASNH245NewATMVCCommand_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCCommand_reverseParameters_multiplexChoice)(e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_noMultiplex ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_transportStream ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_programStream ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_reverseParameters_multiplex Decode */
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCCommand_reverseParameters_multiplex *pObj = (ASNH245NewATMVCCommand_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCCommand_reverseParameters_multiplex_SetChoice( pObj, (ASNH245NewATMVCCommand_reverseParameters_multiplexChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_noMultiplex ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_transportStream ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_programStream ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCCommand_reverseParameters_multiplex Print */
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_multiplex_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCCommand_reverseParameters_multiplex *pObj = (ASNH245NewATMVCCommand_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_multiplex_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_noMultiplex ){
		AsnNull_Print( pObj->alter, pDepth+1, "noMultiplex" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_transportStream ){
		AsnNull_Print( pObj->alter, pDepth+1, "transportStream" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCCommand_reverseParameters_multiplexChoice_programStream ){
		AsnNull_Print( pObj->alter, pDepth+1, "programStream" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCCommand_reverseParameters Class
*/
/*ASNH245NewATMVCCommand_reverseParameters Constructor*/
HS_RESULT new_ASNH245NewATMVCCommand_reverseParameters(void *pObject)
{
	ASNH245NewATMVCCommand_reverseParameters *pObj = (ASNH245NewATMVCCommand_reverseParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCCommand_reverseParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_bitRateLockedToPCRClock) );
	new_AsnBoolean( &(pObj->m_bitRateLockedToNetworkClock) );
	new_ASNH245NewATMVCCommand_reverseParameters_multiplex( &(pObj->m_multiplex) );

	return HS_OK;
}

/* ASNH245NewATMVCCommand_reverseParameters Destructor */
HS_RESULT delete_ASNH245NewATMVCCommand_reverseParameters(void *pObject)
{
	ASNH245NewATMVCCommand_reverseParameters *pObj = (ASNH245NewATMVCCommand_reverseParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand_reverseParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_bitRate) );
	delete_AsnBoolean( &(pObj->m_bitRateLockedToPCRClock) );
	delete_AsnBoolean( &(pObj->m_bitRateLockedToNetworkClock) );
	delete_ASNH245NewATMVCCommand_reverseParameters_multiplex( &(pObj->m_multiplex) );
	return HS_OK;
}

/* ASNH245NewATMVCCommand_reverseParameters MakeMold */
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NewATMVCCommand_reverseParameters *pObj = (ASNH245NewATMVCCommand_reverseParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_reverseParameters Encode */
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCCommand_reverseParameters *pObj = (ASNH245NewATMVCCommand_reverseParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_bitRateLockedToPCRClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_bitRateLockedToNetworkClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_reverseParameters_multiplex_Encode( &(pObj->m_multiplex),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand_reverseParameters Decode */
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCCommand_reverseParameters *pObj = (ASNH245NewATMVCCommand_reverseParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_bitRateLockedToPCRClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_bitRateLockedToNetworkClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_reverseParameters_multiplex_Decode(&(pObj->m_multiplex),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCCommand_reverseParameters Print */
HS_RESULT ASNH245NewATMVCCommand_reverseParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCCommand_reverseParameters *pObj = (ASNH245NewATMVCCommand_reverseParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCCommand_reverseParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	AsnBoolean_Print( &(pObj->m_bitRateLockedToPCRClock), pDepth+1, "bitRateLockedToPCRClock" );
	AsnBoolean_Print( &(pObj->m_bitRateLockedToNetworkClock), pDepth+1, "bitRateLockedToNetworkClock" );
	ASNH245NewATMVCCommand_reverseParameters_multiplex_Print( &(pObj->m_multiplex), pDepth+1, "multiplex" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCCommand Class
*/
/*ASNH245NewATMVCCommand Constructor*/
HS_RESULT new_ASNH245NewATMVCCommand(void *pObject)
{
	ASNH245NewATMVCCommand *pObj = (ASNH245NewATMVCCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_resourceID), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_bitRateLockedToPCRClock) );
	new_AsnBoolean( &(pObj->m_bitRateLockedToNetworkClock) );
	new_ASNH245NewATMVCCommand_aal( &(pObj->m_aal) );
	new_ASNH245NewATMVCCommand_multiplex( &(pObj->m_multiplex) );
	new_ASNH245NewATMVCCommand_reverseParameters( &(pObj->m_reverseParameters) );

	return HS_OK;
}

/* ASNH245NewATMVCCommand Destructor */
HS_RESULT delete_ASNH245NewATMVCCommand(void *pObject)
{
	ASNH245NewATMVCCommand *pObj = (ASNH245NewATMVCCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_resourceID) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	delete_AsnBoolean( &(pObj->m_bitRateLockedToPCRClock) );
	delete_AsnBoolean( &(pObj->m_bitRateLockedToNetworkClock) );
	delete_ASNH245NewATMVCCommand_aal( &(pObj->m_aal) );
	delete_ASNH245NewATMVCCommand_multiplex( &(pObj->m_multiplex) );
	delete_ASNH245NewATMVCCommand_reverseParameters( &(pObj->m_reverseParameters) );
	return HS_OK;
}

/* ASNH245NewATMVCCommand MakeMold */
HS_RESULT ASNH245NewATMVCCommand_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NewATMVCCommand *pObj = (ASNH245NewATMVCCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245NewATMVCCommand_reverseParameters_MakeMold(&(pObj->m_reverseParameters));
	return HS_OK;
}

/* ASNH245NewATMVCCommand Encode */
HS_RESULT ASNH245NewATMVCCommand_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCCommand *pObj = (ASNH245NewATMVCCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_resourceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_bitRateLockedToPCRClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_bitRateLockedToNetworkClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_aal_Encode( &(pObj->m_aal),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_multiplex_Encode( &(pObj->m_multiplex),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_reverseParameters_Encode( &(pObj->m_reverseParameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NewATMVCCommand Decode */
HS_RESULT ASNH245NewATMVCCommand_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCCommand *pObj = (ASNH245NewATMVCCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_resourceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_bitRateLockedToPCRClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_bitRateLockedToNetworkClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_aal_Decode(&(pObj->m_aal),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_multiplex_Decode(&(pObj->m_multiplex),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCCommand_reverseParameters_Decode(&(pObj->m_reverseParameters),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCCommand Print */
HS_RESULT ASNH245NewATMVCCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCCommand *pObj = (ASNH245NewATMVCCommand *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCCommand_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_resourceID), pDepth+1, "resourceID" );
	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	AsnBoolean_Print( &(pObj->m_bitRateLockedToPCRClock), pDepth+1, "bitRateLockedToPCRClock" );
	AsnBoolean_Print( &(pObj->m_bitRateLockedToNetworkClock), pDepth+1, "bitRateLockedToNetworkClock" );
	ASNH245NewATMVCCommand_aal_Print( &(pObj->m_aal), pDepth+1, "aal" );
	ASNH245NewATMVCCommand_multiplex_Print( &(pObj->m_multiplex), pDepth+1, "multiplex" );
	ASNH245NewATMVCCommand_reverseParameters_Print( &(pObj->m_reverseParameters), pDepth+1, "reverseParameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MobileMultilinkReconfigurationCommand_status Struct
*/
/* ASNH245MobileMultilinkReconfigurationCommand_status Constructor */
HS_RESULT new_ASNH245MobileMultilinkReconfigurationCommand_status( void *pObject )
{
	ASNH245MobileMultilinkReconfigurationCommand_status *pObj = (ASNH245MobileMultilinkReconfigurationCommand_status *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MobileMultilinkReconfigurationCommand_status(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_synchronized;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MobileMultilinkReconfigurationCommand_status Destructor */
HS_RESULT delete_ASNH245MobileMultilinkReconfigurationCommand_status( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MobileMultilinkReconfigurationCommand_status *pObj = (ASNH245MobileMultilinkReconfigurationCommand_status *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MobileMultilinkReconfigurationCommand_status(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MobileMultilinkReconfigurationCommand_status_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MobileMultilinkReconfigurationCommand_status(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MobileMultilinkReconfigurationCommand_status SetChoice */
void* ASNH245MobileMultilinkReconfigurationCommand_status_SetChoice( void *pObject, ASNH245MobileMultilinkReconfigurationCommand_statusChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MobileMultilinkReconfigurationCommand_status *pObj = (ASNH245MobileMultilinkReconfigurationCommand_status *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSizeExt ){
		if( pChoice > (ASNH245MobileMultilinkReconfigurationCommand_statusChoice)(e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MobileMultilinkReconfigurationCommand_status_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_synchronized ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_reconfiguration ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MobileMultilinkReconfigurationCommand_status DeleteAlternation */
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_DeleteAlternation(void *pObject)
{
	ASNH245MobileMultilinkReconfigurationCommand_status *pObj = (ASNH245MobileMultilinkReconfigurationCommand_status *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_synchronized ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_reconfiguration ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MobileMultilinkReconfigurationCommand_status Encode */
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MobileMultilinkReconfigurationCommand_status *pObj = (ASNH245MobileMultilinkReconfigurationCommand_status *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSize )
		{
			if( pObj->choice > ((ASNH245MobileMultilinkReconfigurationCommand_statusChoice)(e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_synchronized ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_reconfiguration ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MobileMultilinkReconfigurationCommand_status Decode */
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MobileMultilinkReconfigurationCommand_status *pObj = (ASNH245MobileMultilinkReconfigurationCommand_status *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSize;
	}
	else
	{
		if( e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MobileMultilinkReconfigurationCommand_statusChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MobileMultilinkReconfigurationCommand_status_SetChoice( pObj, (ASNH245MobileMultilinkReconfigurationCommand_statusChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_synchronized ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_reconfiguration ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MobileMultilinkReconfigurationCommand_status Print */
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_status_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MobileMultilinkReconfigurationCommand_status *pObj = (ASNH245MobileMultilinkReconfigurationCommand_status *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_status_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_synchronized ){
		AsnNull_Print( pObj->alter, pDepth+1, "synchronized" );
	}
	else if ( pObj->choice == e_ASNH245MobileMultilinkReconfigurationCommand_statusChoice_reconfiguration ){
		AsnNull_Print( pObj->alter, pDepth+1, "reconfiguration" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MobileMultilinkReconfigurationCommand Class
*/
/*ASNH245MobileMultilinkReconfigurationCommand Constructor*/
HS_RESULT new_ASNH245MobileMultilinkReconfigurationCommand(void *pObject)
{
	ASNH245MobileMultilinkReconfigurationCommand *pObj = (ASNH245MobileMultilinkReconfigurationCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MobileMultilinkReconfigurationCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_sampleSize), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_samplesPerFrame), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245MobileMultilinkReconfigurationCommand_status( &(pObj->m_status) );

	return HS_OK;
}

/* ASNH245MobileMultilinkReconfigurationCommand Destructor */
HS_RESULT delete_ASNH245MobileMultilinkReconfigurationCommand(void *pObject)
{
	ASNH245MobileMultilinkReconfigurationCommand *pObj = (ASNH245MobileMultilinkReconfigurationCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MobileMultilinkReconfigurationCommand(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_sampleSize) );
	delete_AsnInteger( &(pObj->m_samplesPerFrame) );
	delete_ASNH245MobileMultilinkReconfigurationCommand_status( &(pObj->m_status) );
	return HS_OK;
}

/* ASNH245MobileMultilinkReconfigurationCommand MakeMold */
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MobileMultilinkReconfigurationCommand *pObj = (ASNH245MobileMultilinkReconfigurationCommand *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MobileMultilinkReconfigurationCommand Encode */
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MobileMultilinkReconfigurationCommand *pObj = (ASNH245MobileMultilinkReconfigurationCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_sampleSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_samplesPerFrame),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MobileMultilinkReconfigurationCommand_status_Encode( &(pObj->m_status),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MobileMultilinkReconfigurationCommand Decode */
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MobileMultilinkReconfigurationCommand *pObj = (ASNH245MobileMultilinkReconfigurationCommand *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_sampleSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_samplesPerFrame),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MobileMultilinkReconfigurationCommand_status_Decode(&(pObj->m_status),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MobileMultilinkReconfigurationCommand Print */
HS_RESULT ASNH245MobileMultilinkReconfigurationCommand_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MobileMultilinkReconfigurationCommand *pObj = (ASNH245MobileMultilinkReconfigurationCommand *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationCommand_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_sampleSize), pDepth+1, "sampleSize" );
	AsnInteger_Print( &(pObj->m_samplesPerFrame), pDepth+1, "samplesPerFrame" );
	ASNH245MobileMultilinkReconfigurationCommand_status_Print( &(pObj->m_status), pDepth+1, "status" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245CommandMessage Struct
*/
/* ASNH245CommandMessage Constructor */
HS_RESULT new_ASNH245CommandMessage( void *pObject )
{
	ASNH245CommandMessage *pObj = (ASNH245CommandMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245CommandMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245CommandMessageChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245CommandMessageChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245CommandMessage Destructor */
HS_RESULT delete_ASNH245CommandMessage( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245CommandMessage *pObj = (ASNH245CommandMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CommandMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245CommandMessage_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245CommandMessage(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245CommandMessage SetChoice */
void* ASNH245CommandMessage_SetChoice( void *pObject, ASNH245CommandMessageChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245CommandMessage *pObj = (ASNH245CommandMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommandMessage_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245CommandMessageChoiceSizeExt ){
		if( pChoice > (ASNH245CommandMessageChoice)(e_ASNH245CommandMessageChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245CommandMessage_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245CommandMessageChoice_nonStandard ){
		ASNH245NonStandardMessage *tAlter = (ASNH245NonStandardMessage *)HSMalloc( sizeof(ASNH245NonStandardMessage) );
		new_ASNH245NonStandardMessage(tAlter);
		ASNH245NonStandardMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_maintenanceLoopOffCommand ){
		ASNH245MaintenanceLoopOffCommand *tAlter = (ASNH245MaintenanceLoopOffCommand *)HSMalloc( sizeof(ASNH245MaintenanceLoopOffCommand) );
		new_ASNH245MaintenanceLoopOffCommand(tAlter);
		ASNH245MaintenanceLoopOffCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_sendTerminalCapabilitySet ){
		ASNH245SendTerminalCapabilitySet *tAlter = (ASNH245SendTerminalCapabilitySet *)HSMalloc( sizeof(ASNH245SendTerminalCapabilitySet) );
		new_ASNH245SendTerminalCapabilitySet(tAlter);
		ASNH245SendTerminalCapabilitySet_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_encryptionCommand ){
		ASNH245EncryptionCommand *tAlter = (ASNH245EncryptionCommand *)HSMalloc( sizeof(ASNH245EncryptionCommand) );
		new_ASNH245EncryptionCommand(tAlter);
		ASNH245EncryptionCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_flowControlCommand ){
		ASNH245FlowControlCommand *tAlter = (ASNH245FlowControlCommand *)HSMalloc( sizeof(ASNH245FlowControlCommand) );
		new_ASNH245FlowControlCommand(tAlter);
		ASNH245FlowControlCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_endSessionCommand ){
		ASNH245EndSessionCommand *tAlter = (ASNH245EndSessionCommand *)HSMalloc( sizeof(ASNH245EndSessionCommand) );
		new_ASNH245EndSessionCommand(tAlter);
		ASNH245EndSessionCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_miscellaneousCommand ){
		ASNH245MiscellaneousCommand *tAlter = (ASNH245MiscellaneousCommand *)HSMalloc( sizeof(ASNH245MiscellaneousCommand) );
		new_ASNH245MiscellaneousCommand(tAlter);
		ASNH245MiscellaneousCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245CommandMessageChoice_communicationModeCommand ){
		ASNH245CommunicationModeCommand *tAlter = (ASNH245CommunicationModeCommand *)HSMalloc( sizeof(ASNH245CommunicationModeCommand) );
		new_ASNH245CommunicationModeCommand(tAlter);
		ASNH245CommunicationModeCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_conferenceCommand ){
		ASNH245ConferenceCommand *tAlter = (ASNH245ConferenceCommand *)HSMalloc( sizeof(ASNH245ConferenceCommand) );
		new_ASNH245ConferenceCommand(tAlter);
		ASNH245ConferenceCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_h223MultiplexReconfiguration ){
		ASNH245H223MultiplexReconfiguration *tAlter = (ASNH245H223MultiplexReconfiguration *)HSMalloc( sizeof(ASNH245H223MultiplexReconfiguration) );
		new_ASNH245H223MultiplexReconfiguration(tAlter);
		ASNH245H223MultiplexReconfiguration_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_newATMVCCommand ){
		ASNH245NewATMVCCommand *tAlter = (ASNH245NewATMVCCommand *)HSMalloc( sizeof(ASNH245NewATMVCCommand) );
		new_ASNH245NewATMVCCommand(tAlter);
		ASNH245NewATMVCCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245CommandMessageChoice_mobileMultilinkReconfigurationCommand ){
		ASNH245MobileMultilinkReconfigurationCommand *tAlter = (ASNH245MobileMultilinkReconfigurationCommand *)HSMalloc( sizeof(ASNH245MobileMultilinkReconfigurationCommand) );
		new_ASNH245MobileMultilinkReconfigurationCommand(tAlter);
		ASNH245MobileMultilinkReconfigurationCommand_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommandMessage_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245CommandMessage DeleteAlternation */
HS_RESULT ASNH245CommandMessage_DeleteAlternation(void *pObject)
{
	ASNH245CommandMessage *pObj = (ASNH245CommandMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommandMessage_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245CommandMessageChoice_nonStandard ){
			delete_ASNH245NonStandardMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_maintenanceLoopOffCommand ){
			delete_ASNH245MaintenanceLoopOffCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_sendTerminalCapabilitySet ){
			delete_ASNH245SendTerminalCapabilitySet(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_encryptionCommand ){
			delete_ASNH245EncryptionCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_flowControlCommand ){
			delete_ASNH245FlowControlCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_endSessionCommand ){
			delete_ASNH245EndSessionCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_miscellaneousCommand ){
			delete_ASNH245MiscellaneousCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_communicationModeCommand ){
			delete_ASNH245CommunicationModeCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_conferenceCommand ){
			delete_ASNH245ConferenceCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_h223MultiplexReconfiguration ){
			delete_ASNH245H223MultiplexReconfiguration(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_newATMVCCommand ){
			delete_ASNH245NewATMVCCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245CommandMessageChoice_mobileMultilinkReconfigurationCommand ){
			delete_ASNH245MobileMultilinkReconfigurationCommand(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245CommandMessage_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245CommandMessage Encode */
HS_RESULT ASNH245CommandMessage_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245CommandMessage *pObj = (ASNH245CommandMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommandMessage_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommandMessage_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245CommandMessageChoiceSize )
		{
			if( pObj->choice > ((ASNH245CommandMessageChoice)(e_ASNH245CommandMessageChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245CommandMessageChoiceSize)) )
	}
	else
	{
		if( e_ASNH245CommandMessageChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CommandMessageChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_maintenanceLoopOffCommand ){
		if( (tRet=ASNH245MaintenanceLoopOffCommand_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_sendTerminalCapabilitySet ){
		if( (tRet=ASNH245SendTerminalCapabilitySet_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_encryptionCommand ){
		if( (tRet=ASNH245EncryptionCommand_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_flowControlCommand ){
		if( (tRet=ASNH245FlowControlCommand_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_endSessionCommand ){
		if( (tRet=ASNH245EndSessionCommand_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_miscellaneousCommand ){
		if( (tRet=ASNH245MiscellaneousCommand_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_communicationModeCommand ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245CommunicationModeCommand_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_conferenceCommand ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245ConferenceCommand_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_h223MultiplexReconfiguration ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245H223MultiplexReconfiguration_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_newATMVCCommand ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245NewATMVCCommand_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_mobileMultilinkReconfigurationCommand ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MobileMultilinkReconfigurationCommand_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommandMessage_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245CommandMessage Decode */
HS_RESULT ASNH245CommandMessage_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245CommandMessage *pObj = (ASNH245CommandMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommandMessage_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245CommandMessageChoiceSize;
	}
	else
	{
		if( e_ASNH245CommandMessageChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245CommandMessageChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245CommandMessageChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245CommandMessage_SetChoice( pObj, (ASNH245CommandMessageChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommandMessage_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CommandMessageChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_maintenanceLoopOffCommand ){
		if( (tRet=ASNH245MaintenanceLoopOffCommand_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_sendTerminalCapabilitySet ){
		if( (tRet=ASNH245SendTerminalCapabilitySet_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_encryptionCommand ){
		if( (tRet=ASNH245EncryptionCommand_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_flowControlCommand ){
		if( (tRet=ASNH245FlowControlCommand_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_endSessionCommand ){
		if( (tRet=ASNH245EndSessionCommand_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_miscellaneousCommand ){
		if( (tRet=ASNH245MiscellaneousCommand_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_communicationModeCommand ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245CommunicationModeCommand_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_conferenceCommand ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245ConferenceCommand_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_h223MultiplexReconfiguration ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245H223MultiplexReconfiguration_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_newATMVCCommand ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245NewATMVCCommand_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_mobileMultilinkReconfigurationCommand ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MobileMultilinkReconfigurationCommand_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245CommandMessage_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245CommandMessage Print */
HS_RESULT ASNH245CommandMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245CommandMessage *pObj = (ASNH245CommandMessage *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245CommandMessage_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245CommandMessageChoice_nonStandard ){
		ASNH245NonStandardMessage_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_maintenanceLoopOffCommand ){
		ASNH245MaintenanceLoopOffCommand_Print( pObj->alter, pDepth+1, "maintenanceLoopOffCommand" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_sendTerminalCapabilitySet ){
		ASNH245SendTerminalCapabilitySet_Print( pObj->alter, pDepth+1, "sendTerminalCapabilitySet" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_encryptionCommand ){
		ASNH245EncryptionCommand_Print( pObj->alter, pDepth+1, "encryptionCommand" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_flowControlCommand ){
		ASNH245FlowControlCommand_Print( pObj->alter, pDepth+1, "flowControlCommand" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_endSessionCommand ){
		ASNH245EndSessionCommand_Print( pObj->alter, pDepth+1, "endSessionCommand" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_miscellaneousCommand ){
		ASNH245MiscellaneousCommand_Print( pObj->alter, pDepth+1, "miscellaneousCommand" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_communicationModeCommand ){
		ASNH245CommunicationModeCommand_Print( pObj->alter, pDepth+1, "communicationModeCommand" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_conferenceCommand ){
		ASNH245ConferenceCommand_Print( pObj->alter, pDepth+1, "conferenceCommand" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_h223MultiplexReconfiguration ){
		ASNH245H223MultiplexReconfiguration_Print( pObj->alter, pDepth+1, "h223MultiplexReconfiguration" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_newATMVCCommand ){
		ASNH245NewATMVCCommand_Print( pObj->alter, pDepth+1, "newATMVCCommand" );
	}
	else if ( pObj->choice == e_ASNH245CommandMessageChoice_mobileMultilinkReconfigurationCommand ){
		ASNH245MobileMultilinkReconfigurationCommand_Print( pObj->alter, pDepth+1, "mobileMultilinkReconfigurationCommand" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245FunctionNotUnderstood Struct
*/
/* ASNH245FunctionNotUnderstood Constructor */
HS_RESULT new_ASNH245FunctionNotUnderstood( void *pObject )
{
	ASNH245FunctionNotUnderstood *pObj = (ASNH245FunctionNotUnderstood *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245FunctionNotUnderstood(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245FunctionNotUnderstoodChoice_request;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245FunctionNotUnderstoodChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245FunctionNotUnderstood Destructor */
HS_RESULT delete_ASNH245FunctionNotUnderstood( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245FunctionNotUnderstood *pObj = (ASNH245FunctionNotUnderstood *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FunctionNotUnderstood(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245FunctionNotUnderstood_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FunctionNotUnderstood(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245FunctionNotUnderstood SetChoice */
void* ASNH245FunctionNotUnderstood_SetChoice( void *pObject, ASNH245FunctionNotUnderstoodChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245FunctionNotUnderstood *pObj = (ASNH245FunctionNotUnderstood *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245FunctionNotUnderstoodChoiceSizeExt ){
		if( pChoice > (ASNH245FunctionNotUnderstoodChoice)(e_ASNH245FunctionNotUnderstoodChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245FunctionNotUnderstood_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245FunctionNotUnderstoodChoice_request ){
		ASNH245RequestMessage *tAlter = (ASNH245RequestMessage *)HSMalloc( sizeof(ASNH245RequestMessage) );
		new_ASNH245RequestMessage(tAlter);
		ASNH245RequestMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245FunctionNotUnderstoodChoice_response ){
		ASNH245ResponseMessage *tAlter = (ASNH245ResponseMessage *)HSMalloc( sizeof(ASNH245ResponseMessage) );
		new_ASNH245ResponseMessage(tAlter);
		ASNH245ResponseMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245FunctionNotUnderstoodChoice_command ){
		ASNH245CommandMessage *tAlter = (ASNH245CommandMessage *)HSMalloc( sizeof(ASNH245CommandMessage) );
		new_ASNH245CommandMessage(tAlter);
		ASNH245CommandMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245FunctionNotUnderstood DeleteAlternation */
HS_RESULT ASNH245FunctionNotUnderstood_DeleteAlternation(void *pObject)
{
	ASNH245FunctionNotUnderstood *pObj = (ASNH245FunctionNotUnderstood *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_request ){
			delete_ASNH245RequestMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_response ){
			delete_ASNH245ResponseMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_command ){
			delete_ASNH245CommandMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245FunctionNotUnderstood_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245FunctionNotUnderstood Encode */
HS_RESULT ASNH245FunctionNotUnderstood_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245FunctionNotUnderstood *pObj = (ASNH245FunctionNotUnderstood *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245FunctionNotUnderstoodChoiceSize )
		{
			if( pObj->choice > ((ASNH245FunctionNotUnderstoodChoice)(e_ASNH245FunctionNotUnderstoodChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245FunctionNotUnderstoodChoiceSize)) )
	}
	else
	{
		if( e_ASNH245FunctionNotUnderstoodChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_request ){
		if( (tRet=ASNH245RequestMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_response ){
		if( (tRet=ASNH245ResponseMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_command ){
		if( (tRet=ASNH245CommandMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245FunctionNotUnderstood Decode */
HS_RESULT ASNH245FunctionNotUnderstood_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245FunctionNotUnderstood *pObj = (ASNH245FunctionNotUnderstood *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245FunctionNotUnderstoodChoiceSize;
	}
	else
	{
		if( e_ASNH245FunctionNotUnderstoodChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245FunctionNotUnderstoodChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245FunctionNotUnderstoodChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245FunctionNotUnderstood_SetChoice( pObj, (ASNH245FunctionNotUnderstoodChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_request ){
		if( (tRet=ASNH245RequestMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_response ){
		if( (tRet=ASNH245ResponseMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_command ){
		if( (tRet=ASNH245CommandMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245FunctionNotUnderstood Print */
HS_RESULT ASNH245FunctionNotUnderstood_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245FunctionNotUnderstood *pObj = (ASNH245FunctionNotUnderstood *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245FunctionNotUnderstood_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_request ){
		ASNH245RequestMessage_Print( pObj->alter, pDepth+1, "request" );
	}
	else if ( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_response ){
		ASNH245ResponseMessage_Print( pObj->alter, pDepth+1, "response" );
	}
	else if ( pObj->choice == e_ASNH245FunctionNotUnderstoodChoice_command ){
		ASNH245CommandMessage_Print( pObj->alter, pDepth+1, "command" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MasterSlaveDeterminationRelease Class
*/
/*ASNH245MasterSlaveDeterminationRelease Constructor*/
HS_RESULT new_ASNH245MasterSlaveDeterminationRelease(void *pObject)
{
	ASNH245MasterSlaveDeterminationRelease *pObj = (ASNH245MasterSlaveDeterminationRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MasterSlaveDeterminationRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationRelease Destructor */
HS_RESULT delete_ASNH245MasterSlaveDeterminationRelease(void *pObject)
{
	ASNH245MasterSlaveDeterminationRelease *pObj = (ASNH245MasterSlaveDeterminationRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MasterSlaveDeterminationRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationRelease MakeMold */
HS_RESULT ASNH245MasterSlaveDeterminationRelease_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MasterSlaveDeterminationRelease *pObj = (ASNH245MasterSlaveDeterminationRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationRelease_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationRelease Encode */
HS_RESULT ASNH245MasterSlaveDeterminationRelease_Encode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245MasterSlaveDeterminationRelease *pObj = (ASNH245MasterSlaveDeterminationRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationRelease_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );


	return HS_OK;
}

/* ASNH245MasterSlaveDeterminationRelease Decode */
HS_RESULT ASNH245MasterSlaveDeterminationRelease_Decode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245MasterSlaveDeterminationRelease *pObj = (ASNH245MasterSlaveDeterminationRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationRelease_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MasterSlaveDeterminationRelease Print */
HS_RESULT ASNH245MasterSlaveDeterminationRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MasterSlaveDeterminationRelease *pObj = (ASNH245MasterSlaveDeterminationRelease *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MasterSlaveDeterminationRelease_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TerminalCapabilitySetRelease Class
*/
/*ASNH245TerminalCapabilitySetRelease Constructor*/
HS_RESULT new_ASNH245TerminalCapabilitySetRelease(void *pObject)
{
	ASNH245TerminalCapabilitySetRelease *pObj = (ASNH245TerminalCapabilitySetRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TerminalCapabilitySetRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;

	return HS_OK;
}

/* ASNH245TerminalCapabilitySetRelease Destructor */
HS_RESULT delete_ASNH245TerminalCapabilitySetRelease(void *pObject)
{
	ASNH245TerminalCapabilitySetRelease *pObj = (ASNH245TerminalCapabilitySetRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TerminalCapabilitySetRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return HS_OK;
}

/* ASNH245TerminalCapabilitySetRelease MakeMold */
HS_RESULT ASNH245TerminalCapabilitySetRelease_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245TerminalCapabilitySetRelease *pObj = (ASNH245TerminalCapabilitySetRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetRelease_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245TerminalCapabilitySetRelease Encode */
HS_RESULT ASNH245TerminalCapabilitySetRelease_Encode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245TerminalCapabilitySetRelease *pObj = (ASNH245TerminalCapabilitySetRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetRelease_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );


	return HS_OK;
}

/* ASNH245TerminalCapabilitySetRelease Decode */
HS_RESULT ASNH245TerminalCapabilitySetRelease_Decode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245TerminalCapabilitySetRelease *pObj = (ASNH245TerminalCapabilitySetRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetRelease_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TerminalCapabilitySetRelease Print */
HS_RESULT ASNH245TerminalCapabilitySetRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TerminalCapabilitySetRelease *pObj = (ASNH245TerminalCapabilitySetRelease *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TerminalCapabilitySetRelease_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245OpenLogicalChannelConfirm Class
*/
/*ASNH245OpenLogicalChannelConfirm Constructor*/
HS_RESULT new_ASNH245OpenLogicalChannelConfirm(void *pObject)
{
	ASNH245OpenLogicalChannelConfirm *pObj = (ASNH245OpenLogicalChannelConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245OpenLogicalChannelConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );

	return HS_OK;
}

/* ASNH245OpenLogicalChannelConfirm Destructor */
HS_RESULT delete_ASNH245OpenLogicalChannelConfirm(void *pObject)
{
	ASNH245OpenLogicalChannelConfirm *pObj = (ASNH245OpenLogicalChannelConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245OpenLogicalChannelConfirm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	return HS_OK;
}

/* ASNH245OpenLogicalChannelConfirm MakeMold */
HS_RESULT ASNH245OpenLogicalChannelConfirm_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245OpenLogicalChannelConfirm *pObj = (ASNH245OpenLogicalChannelConfirm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelConfirm_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	return HS_OK;
}

/* ASNH245OpenLogicalChannelConfirm Encode */
HS_RESULT ASNH245OpenLogicalChannelConfirm_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245OpenLogicalChannelConfirm *pObj = (ASNH245OpenLogicalChannelConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelConfirm_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelConfirm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245OpenLogicalChannelConfirm Decode */
HS_RESULT ASNH245OpenLogicalChannelConfirm_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245OpenLogicalChannelConfirm *pObj = (ASNH245OpenLogicalChannelConfirm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelConfirm_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245OpenLogicalChannelConfirm_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245OpenLogicalChannelConfirm Print */
HS_RESULT ASNH245OpenLogicalChannelConfirm_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245OpenLogicalChannelConfirm *pObj = (ASNH245OpenLogicalChannelConfirm *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245OpenLogicalChannelConfirm_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestChannelCloseRelease Class
*/
/*ASNH245RequestChannelCloseRelease Constructor*/
HS_RESULT new_ASNH245RequestChannelCloseRelease(void *pObject)
{
	ASNH245RequestChannelCloseRelease *pObj = (ASNH245RequestChannelCloseRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestChannelCloseRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );

	return HS_OK;
}

/* ASNH245RequestChannelCloseRelease Destructor */
HS_RESULT delete_ASNH245RequestChannelCloseRelease(void *pObject)
{
	ASNH245RequestChannelCloseRelease *pObj = (ASNH245RequestChannelCloseRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestChannelCloseRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_forwardLogicalChannelNumber) );
	return HS_OK;
}

/* ASNH245RequestChannelCloseRelease MakeMold */
HS_RESULT ASNH245RequestChannelCloseRelease_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestChannelCloseRelease *pObj = (ASNH245RequestChannelCloseRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseRelease_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_forwardLogicalChannelNumber));
	return HS_OK;
}

/* ASNH245RequestChannelCloseRelease Encode */
HS_RESULT ASNH245RequestChannelCloseRelease_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestChannelCloseRelease *pObj = (ASNH245RequestChannelCloseRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseRelease_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseRelease_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestChannelCloseRelease Decode */
HS_RESULT ASNH245RequestChannelCloseRelease_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestChannelCloseRelease *pObj = (ASNH245RequestChannelCloseRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseRelease_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_forwardLogicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestChannelCloseRelease_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestChannelCloseRelease Print */
HS_RESULT ASNH245RequestChannelCloseRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestChannelCloseRelease *pObj = (ASNH245RequestChannelCloseRelease *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestChannelCloseRelease_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_forwardLogicalChannelNumber), pDepth+1, "forwardLogicalChannelNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultiplexEntrySendRelease Class
*/
/*ASNH245MultiplexEntrySendRelease Constructor*/
HS_RESULT new_ASNH245MultiplexEntrySendRelease(void *pObject)
{
	ASNH245MultiplexEntrySendRelease *pObj = (ASNH245MultiplexEntrySendRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultiplexEntrySendRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_multiplexTableEntryNumber), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MultiplexEntrySendRelease Destructor */
HS_RESULT delete_ASNH245MultiplexEntrySendRelease(void *pObject)
{
	ASNH245MultiplexEntrySendRelease *pObj = (ASNH245MultiplexEntrySendRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultiplexEntrySendRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_multiplexTableEntryNumber) );
	return HS_OK;
}

/* ASNH245MultiplexEntrySendRelease MakeMold */
HS_RESULT ASNH245MultiplexEntrySendRelease_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultiplexEntrySendRelease *pObj = (ASNH245MultiplexEntrySendRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendRelease_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245MultiplexTableEntryNumber *tmold_multiplexTableEntryNumber = (ASNH245MultiplexTableEntryNumber *)HSMalloc( sizeof(ASNH245MultiplexTableEntryNumber) );
	new_ASNH245MultiplexTableEntryNumber(tmold_multiplexTableEntryNumber);
	ASNH245MultiplexTableEntryNumber_MakeMold(tmold_multiplexTableEntryNumber);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_multiplexTableEntryNumber,sizeof(ASNH245MultiplexTableEntryNumber),ASNH245MultiplexTableEntryNumber_MakeMold,ASNH245MultiplexTableEntryNumber_Encode,ASNH245MultiplexTableEntryNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MultiplexTableEntryNumber_Print,
#endif
		delete_ASNH245MultiplexTableEntryNumber);
	AsnSequenceOf_SetMold( &(pObj->m_multiplexTableEntryNumber), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_multiplexTableEntryNumber.constraint.type = e_constrained;
	pObj->m_multiplexTableEntryNumber.constraint.minValue = 1;
	pObj->m_multiplexTableEntryNumber.constraint.maxValue = 15;
	pObj->m_multiplexTableEntryNumber.extMinValue = 0;
	pObj->m_multiplexTableEntryNumber.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245MultiplexEntrySendRelease Encode */
HS_RESULT ASNH245MultiplexEntrySendRelease_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntrySendRelease *pObj = (ASNH245MultiplexEntrySendRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendRelease_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendRelease_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultiplexEntrySendRelease Decode */
HS_RESULT ASNH245MultiplexEntrySendRelease_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultiplexEntrySendRelease *pObj = (ASNH245MultiplexEntrySendRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendRelease_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_multiplexTableEntryNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultiplexEntrySendRelease_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultiplexEntrySendRelease Print */
HS_RESULT ASNH245MultiplexEntrySendRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultiplexEntrySendRelease *pObj = (ASNH245MultiplexEntrySendRelease *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultiplexEntrySendRelease_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSequenceOf_Print( &(pObj->m_multiplexTableEntryNumber), pDepth+1, "multiplexTableEntryNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestMultiplexEntryRelease Class
*/
/*ASNH245RequestMultiplexEntryRelease Constructor*/
HS_RESULT new_ASNH245RequestMultiplexEntryRelease(void *pObject)
{
	ASNH245RequestMultiplexEntryRelease *pObj = (ASNH245RequestMultiplexEntryRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestMultiplexEntryRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_entryNumbers), e_constrained,1,15,0,HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245RequestMultiplexEntryRelease Destructor */
HS_RESULT delete_ASNH245RequestMultiplexEntryRelease(void *pObject)
{
	ASNH245RequestMultiplexEntryRelease *pObj = (ASNH245RequestMultiplexEntryRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestMultiplexEntryRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_entryNumbers) );
	return HS_OK;
}

/* ASNH245RequestMultiplexEntryRelease MakeMold */
HS_RESULT ASNH245RequestMultiplexEntryRelease_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestMultiplexEntryRelease *pObj = (ASNH245RequestMultiplexEntryRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRelease_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH245MultiplexTableEntryNumber *tmold_entryNumbers = (ASNH245MultiplexTableEntryNumber *)HSMalloc( sizeof(ASNH245MultiplexTableEntryNumber) );
	new_ASNH245MultiplexTableEntryNumber(tmold_entryNumbers);
	ASNH245MultiplexTableEntryNumber_MakeMold(tmold_entryNumbers);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_entryNumbers,sizeof(ASNH245MultiplexTableEntryNumber),ASNH245MultiplexTableEntryNumber_MakeMold,ASNH245MultiplexTableEntryNumber_Encode,ASNH245MultiplexTableEntryNumber_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH245MultiplexTableEntryNumber_Print,
#endif
		delete_ASNH245MultiplexTableEntryNumber);
	AsnSequenceOf_SetMold( &(pObj->m_entryNumbers), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_entryNumbers.constraint.type = e_constrained;
	pObj->m_entryNumbers.constraint.minValue = 1;
	pObj->m_entryNumbers.constraint.maxValue = 15;
	pObj->m_entryNumbers.extMinValue = 0;
	pObj->m_entryNumbers.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH245RequestMultiplexEntryRelease Encode */
HS_RESULT ASNH245RequestMultiplexEntryRelease_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntryRelease *pObj = (ASNH245RequestMultiplexEntryRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRelease_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_entryNumbers),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRelease_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245RequestMultiplexEntryRelease Decode */
HS_RESULT ASNH245RequestMultiplexEntryRelease_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245RequestMultiplexEntryRelease *pObj = (ASNH245RequestMultiplexEntryRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRelease_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_entryNumbers),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRelease_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestMultiplexEntryRelease Print */
HS_RESULT ASNH245RequestMultiplexEntryRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestMultiplexEntryRelease *pObj = (ASNH245RequestMultiplexEntryRelease *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestMultiplexEntryRelease_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSequenceOf_Print( &(pObj->m_entryNumbers), pDepth+1, "entryNumbers" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245RequestModeRelease Class
*/
/*ASNH245RequestModeRelease Constructor*/
HS_RESULT new_ASNH245RequestModeRelease(void *pObject)
{
	ASNH245RequestModeRelease *pObj = (ASNH245RequestModeRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245RequestModeRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;

	return HS_OK;
}

/* ASNH245RequestModeRelease Destructor */
HS_RESULT delete_ASNH245RequestModeRelease(void *pObject)
{
	ASNH245RequestModeRelease *pObj = (ASNH245RequestModeRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245RequestModeRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return HS_OK;
}

/* ASNH245RequestModeRelease MakeMold */
HS_RESULT ASNH245RequestModeRelease_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245RequestModeRelease *pObj = (ASNH245RequestModeRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeRelease_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245RequestModeRelease Encode */
HS_RESULT ASNH245RequestModeRelease_Encode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245RequestModeRelease *pObj = (ASNH245RequestModeRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeRelease_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );


	return HS_OK;
}

/* ASNH245RequestModeRelease Decode */
HS_RESULT ASNH245RequestModeRelease_Decode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245RequestModeRelease *pObj = (ASNH245RequestModeRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245RequestModeRelease_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245RequestModeRelease Print */
HS_RESULT ASNH245RequestModeRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245RequestModeRelease *pObj = (ASNH245RequestModeRelease *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245RequestModeRelease_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MiscellaneousIndication_type_videoNotDecodedMBs Class
*/
/*ASNH245MiscellaneousIndication_type_videoNotDecodedMBs Constructor*/
HS_RESULT new_ASNH245MiscellaneousIndication_type_videoNotDecodedMBs(void *pObject)
{
	ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *pObj = (ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MiscellaneousIndication_type_videoNotDecodedMBs(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_firstMB), e_constrained, 1, 8192, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_numberOfMBs), e_constrained, 1, 8192, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_temporalReference), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MiscellaneousIndication_type_videoNotDecodedMBs Destructor */
HS_RESULT delete_ASNH245MiscellaneousIndication_type_videoNotDecodedMBs(void *pObject)
{
	ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *pObj = (ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MiscellaneousIndication_type_videoNotDecodedMBs(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_firstMB) );
	delete_AsnInteger( &(pObj->m_numberOfMBs) );
	delete_AsnInteger( &(pObj->m_temporalReference) );
	return HS_OK;
}

/* ASNH245MiscellaneousIndication_type_videoNotDecodedMBs MakeMold */
HS_RESULT ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *pObj = (ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MiscellaneousIndication_type_videoNotDecodedMBs Encode */
HS_RESULT ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *pObj = (ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_firstMB),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_numberOfMBs),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_temporalReference),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MiscellaneousIndication_type_videoNotDecodedMBs Decode */
HS_RESULT ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *pObj = (ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_firstMB),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_numberOfMBs),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_temporalReference),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MiscellaneousIndication_type_videoNotDecodedMBs Print */
HS_RESULT ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *pObj = (ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_firstMB), pDepth+1, "firstMB" );
	AsnInteger_Print( &(pObj->m_numberOfMBs), pDepth+1, "numberOfMBs" );
	AsnInteger_Print( &(pObj->m_temporalReference), pDepth+1, "temporalReference" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MiscellaneousIndication_type Struct
*/
/* ASNH245MiscellaneousIndication_type Constructor */
HS_RESULT new_ASNH245MiscellaneousIndication_type( void *pObject )
{
	ASNH245MiscellaneousIndication_type *pObj = (ASNH245MiscellaneousIndication_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MiscellaneousIndication_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelActive;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MiscellaneousIndication_typeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MiscellaneousIndication_type Destructor */
HS_RESULT delete_ASNH245MiscellaneousIndication_type( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MiscellaneousIndication_type *pObj = (ASNH245MiscellaneousIndication_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MiscellaneousIndication_type(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MiscellaneousIndication_type_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MiscellaneousIndication_type(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MiscellaneousIndication_type SetChoice */
void* ASNH245MiscellaneousIndication_type_SetChoice( void *pObject, ASNH245MiscellaneousIndication_typeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MiscellaneousIndication_type *pObj = (ASNH245MiscellaneousIndication_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MiscellaneousIndication_typeChoiceSizeExt ){
		if( pChoice > (ASNH245MiscellaneousIndication_typeChoice)(e_ASNH245MiscellaneousIndication_typeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MiscellaneousIndication_type_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelActive ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelInactive ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_multipointConference ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointConference ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_multipointZeroComm ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointZeroComm ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_multipointSecondaryStatus ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointSecondaryStatus ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_videoIndicateReadyToActivate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_videoTemporalSpatialTradeOff ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,31,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_videoNotDecodedMBs ){
		ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *tAlter = (ASNH245MiscellaneousIndication_type_videoNotDecodedMBs *)HSMalloc( sizeof(ASNH245MiscellaneousIndication_type_videoNotDecodedMBs) );
		new_ASNH245MiscellaneousIndication_type_videoNotDecodedMBs(tAlter);
		ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MiscellaneousIndication_typeChoice_transportCapability ){
		ASNH245TransportCapability *tAlter = (ASNH245TransportCapability *)HSMalloc( sizeof(ASNH245TransportCapability) );
		new_ASNH245TransportCapability(tAlter);
		ASNH245TransportCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MiscellaneousIndication_type DeleteAlternation */
HS_RESULT ASNH245MiscellaneousIndication_type_DeleteAlternation(void *pObject)
{
	ASNH245MiscellaneousIndication_type *pObj = (ASNH245MiscellaneousIndication_type *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelActive ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelInactive ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointConference ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointConference ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointZeroComm ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointZeroComm ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointSecondaryStatus ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointSecondaryStatus ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoIndicateReadyToActivate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoTemporalSpatialTradeOff ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoNotDecodedMBs ){
			delete_ASNH245MiscellaneousIndication_type_videoNotDecodedMBs(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_transportCapability ){
			delete_ASNH245TransportCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MiscellaneousIndication_type_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MiscellaneousIndication_type Encode */
HS_RESULT ASNH245MiscellaneousIndication_type_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MiscellaneousIndication_type *pObj = (ASNH245MiscellaneousIndication_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MiscellaneousIndication_typeChoiceSize )
		{
			if( pObj->choice > ((ASNH245MiscellaneousIndication_typeChoice)(e_ASNH245MiscellaneousIndication_typeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MiscellaneousIndication_typeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MiscellaneousIndication_typeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelActive ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelInactive ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointConference ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointConference ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointZeroComm ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointZeroComm ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointSecondaryStatus ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointSecondaryStatus ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoIndicateReadyToActivate ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoTemporalSpatialTradeOff ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoNotDecodedMBs ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_transportCapability ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245TransportCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MiscellaneousIndication_type Decode */
HS_RESULT ASNH245MiscellaneousIndication_type_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MiscellaneousIndication_type *pObj = (ASNH245MiscellaneousIndication_type *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MiscellaneousIndication_typeChoiceSize;
	}
	else
	{
		if( e_ASNH245MiscellaneousIndication_typeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MiscellaneousIndication_typeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MiscellaneousIndication_typeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MiscellaneousIndication_type_SetChoice( pObj, (ASNH245MiscellaneousIndication_typeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelActive ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelInactive ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointConference ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointConference ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointZeroComm ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointZeroComm ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointSecondaryStatus ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointSecondaryStatus ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoIndicateReadyToActivate ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoTemporalSpatialTradeOff ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoNotDecodedMBs ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_transportCapability ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245TransportCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MiscellaneousIndication_type Print */
HS_RESULT ASNH245MiscellaneousIndication_type_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MiscellaneousIndication_type *pObj = (ASNH245MiscellaneousIndication_type *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_type_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelActive ){
		AsnNull_Print( pObj->alter, pDepth+1, "logicalChannelActive" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_logicalChannelInactive ){
		AsnNull_Print( pObj->alter, pDepth+1, "logicalChannelInactive" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointConference ){
		AsnNull_Print( pObj->alter, pDepth+1, "multipointConference" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointConference ){
		AsnNull_Print( pObj->alter, pDepth+1, "cancelMultipointConference" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointZeroComm ){
		AsnNull_Print( pObj->alter, pDepth+1, "multipointZeroComm" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointZeroComm ){
		AsnNull_Print( pObj->alter, pDepth+1, "cancelMultipointZeroComm" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_multipointSecondaryStatus ){
		AsnNull_Print( pObj->alter, pDepth+1, "multipointSecondaryStatus" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_cancelMultipointSecondaryStatus ){
		AsnNull_Print( pObj->alter, pDepth+1, "cancelMultipointSecondaryStatus" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoIndicateReadyToActivate ){
		AsnNull_Print( pObj->alter, pDepth+1, "videoIndicateReadyToActivate" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoTemporalSpatialTradeOff ){
		AsnInteger_Print( pObj->alter, pDepth+1, "videoTemporalSpatialTradeOff" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_videoNotDecodedMBs ){
		ASNH245MiscellaneousIndication_type_videoNotDecodedMBs_Print( pObj->alter, pDepth+1, "videoNotDecodedMBs" );
	}
	else if ( pObj->choice == e_ASNH245MiscellaneousIndication_typeChoice_transportCapability ){
		ASNH245TransportCapability_Print( pObj->alter, pDepth+1, "transportCapability" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MiscellaneousIndication Class
*/
/*ASNH245MiscellaneousIndication Constructor*/
HS_RESULT new_ASNH245MiscellaneousIndication(void *pObject)
{
	ASNH245MiscellaneousIndication *pObj = (ASNH245MiscellaneousIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MiscellaneousIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );
	new_ASNH245MiscellaneousIndication_type( &(pObj->m_type) );

	return HS_OK;
}

/* ASNH245MiscellaneousIndication Destructor */
HS_RESULT delete_ASNH245MiscellaneousIndication(void *pObject)
{
	ASNH245MiscellaneousIndication *pObj = (ASNH245MiscellaneousIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MiscellaneousIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );
	delete_ASNH245MiscellaneousIndication_type( &(pObj->m_type) );
	return HS_OK;
}

/* ASNH245MiscellaneousIndication MakeMold */
HS_RESULT ASNH245MiscellaneousIndication_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MiscellaneousIndication *pObj = (ASNH245MiscellaneousIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_logicalChannelNumber));
	return HS_OK;
}

/* ASNH245MiscellaneousIndication Encode */
HS_RESULT ASNH245MiscellaneousIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MiscellaneousIndication *pObj = (ASNH245MiscellaneousIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MiscellaneousIndication_type_Encode( &(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MiscellaneousIndication Decode */
HS_RESULT ASNH245MiscellaneousIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MiscellaneousIndication *pObj = (ASNH245MiscellaneousIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245MiscellaneousIndication_type_Decode(&(pObj->m_type),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MiscellaneousIndication Print */
HS_RESULT ASNH245MiscellaneousIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MiscellaneousIndication *pObj = (ASNH245MiscellaneousIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MiscellaneousIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_logicalChannelNumber), pDepth+1, "logicalChannelNumber" );
	ASNH245MiscellaneousIndication_type_Print( &(pObj->m_type), pDepth+1, "type" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245JitterIndication_scope Struct
*/
/* ASNH245JitterIndication_scope Constructor */
HS_RESULT new_ASNH245JitterIndication_scope( void *pObject )
{
	ASNH245JitterIndication_scope *pObj = (ASNH245JitterIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245JitterIndication_scope(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245JitterIndication_scopeChoice_logicalChannelNumber;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245JitterIndication_scopeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245JitterIndication_scope Destructor */
HS_RESULT delete_ASNH245JitterIndication_scope( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245JitterIndication_scope *pObj = (ASNH245JitterIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245JitterIndication_scope(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245JitterIndication_scope_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245JitterIndication_scope(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245JitterIndication_scope SetChoice */
void* ASNH245JitterIndication_scope_SetChoice( void *pObject, ASNH245JitterIndication_scopeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245JitterIndication_scope *pObj = (ASNH245JitterIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_scope_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245JitterIndication_scopeChoiceSizeExt ){
		if( pChoice > (ASNH245JitterIndication_scopeChoice)(e_ASNH245JitterIndication_scopeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245JitterIndication_scope_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245JitterIndication_scopeChoice_logicalChannelNumber ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245JitterIndication_scopeChoice_resourceID ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245JitterIndication_scopeChoice_wholeMultiplex ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_scope_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245JitterIndication_scope DeleteAlternation */
HS_RESULT ASNH245JitterIndication_scope_DeleteAlternation(void *pObject)
{
	ASNH245JitterIndication_scope *pObj = (ASNH245JitterIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_scope_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245JitterIndication_scopeChoice_logicalChannelNumber ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245JitterIndication_scopeChoice_resourceID ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245JitterIndication_scopeChoice_wholeMultiplex ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245JitterIndication_scope_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245JitterIndication_scope Encode */
HS_RESULT ASNH245JitterIndication_scope_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245JitterIndication_scope *pObj = (ASNH245JitterIndication_scope *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_scope_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_scope_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245JitterIndication_scopeChoiceSize )
		{
			if( pObj->choice > ((ASNH245JitterIndication_scopeChoice)(e_ASNH245JitterIndication_scopeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245JitterIndication_scopeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245JitterIndication_scopeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245JitterIndication_scopeChoice_logicalChannelNumber ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245JitterIndication_scopeChoice_resourceID ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245JitterIndication_scopeChoice_wholeMultiplex ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_scope_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245JitterIndication_scope Decode */
HS_RESULT ASNH245JitterIndication_scope_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245JitterIndication_scope *pObj = (ASNH245JitterIndication_scope *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_scope_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245JitterIndication_scopeChoiceSize;
	}
	else
	{
		if( e_ASNH245JitterIndication_scopeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245JitterIndication_scopeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245JitterIndication_scopeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245JitterIndication_scope_SetChoice( pObj, (ASNH245JitterIndication_scopeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_scope_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245JitterIndication_scopeChoice_logicalChannelNumber ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245JitterIndication_scopeChoice_resourceID ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245JitterIndication_scopeChoice_wholeMultiplex ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_scope_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_scope_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245JitterIndication_scope Print */
HS_RESULT ASNH245JitterIndication_scope_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245JitterIndication_scope *pObj = (ASNH245JitterIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245JitterIndication_scope_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245JitterIndication_scopeChoice_logicalChannelNumber ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "logicalChannelNumber" );
	}
	else if ( pObj->choice == e_ASNH245JitterIndication_scopeChoice_resourceID ){
		AsnInteger_Print( pObj->alter, pDepth+1, "resourceID" );
	}
	else if ( pObj->choice == e_ASNH245JitterIndication_scopeChoice_wholeMultiplex ){
		AsnNull_Print( pObj->alter, pDepth+1, "wholeMultiplex" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245JitterIndication Class
*/
/*ASNH245JitterIndication Constructor*/
HS_RESULT new_ASNH245JitterIndication(void *pObject)
{
	ASNH245JitterIndication *pObj = (ASNH245JitterIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245JitterIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245JitterIndication_scope( &(pObj->m_scope) );
	new_AsnInteger( &(pObj->m_estimatedReceivedJitterMantissa), e_constrained, 0, 3, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_estimatedReceivedJitterExponent), e_constrained, 0, 7, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_skippedFrameCount), e_constrained, 0, 15, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_additionalDecoderBuffer), e_constrained, 0, 262143, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245JitterIndication Destructor */
HS_RESULT delete_ASNH245JitterIndication(void *pObject)
{
	ASNH245JitterIndication *pObj = (ASNH245JitterIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245JitterIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245JitterIndication_scope( &(pObj->m_scope) );
	delete_AsnInteger( &(pObj->m_estimatedReceivedJitterMantissa) );
	delete_AsnInteger( &(pObj->m_estimatedReceivedJitterExponent) );
	delete_AsnInteger( &(pObj->m_skippedFrameCount) );
	delete_AsnInteger( &(pObj->m_additionalDecoderBuffer) );
	return HS_OK;
}

/* ASNH245JitterIndication MakeMold */
HS_RESULT ASNH245JitterIndication_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245JitterIndication *pObj = (ASNH245JitterIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245JitterIndication IncludeOptionalField */
HS_RESULT ASNH245JitterIndication_IncludeOptionField( void *pObject, ASNH245JitterIndicationOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245JitterIndication *pObj = (ASNH245JitterIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245JitterIndicationOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245JitterIndication IsIncludeOptionalField */
BOOL ASNH245JitterIndication_IsIncludeOptionField( void *pObject, ASNH245JitterIndicationOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245JitterIndication *pObj = (ASNH245JitterIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245JitterIndicationOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245JitterIndication Encode */
HS_RESULT ASNH245JitterIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245JitterIndication *pObj = (ASNH245JitterIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245JitterIndicationOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245JitterIndicationOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245JitterIndication_scope_Encode( &(pObj->m_scope),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_estimatedReceivedJitterMantissa),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_estimatedReceivedJitterExponent),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245JitterIndication_IsIncludeOptionField( pObj, e_ASNH245JitterIndicationOptionMap_skippedFrameCount ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_skippedFrameCount),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245JitterIndication_IsIncludeOptionField( pObj, e_ASNH245JitterIndicationOptionMap_additionalDecoderBuffer ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_additionalDecoderBuffer),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245JitterIndication Decode */
HS_RESULT ASNH245JitterIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245JitterIndication *pObj = (ASNH245JitterIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245JitterIndicationOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245JitterIndicationOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245JitterIndication_scope_Decode(&(pObj->m_scope),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_estimatedReceivedJitterMantissa),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_estimatedReceivedJitterExponent),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245JitterIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245JitterIndication_IsIncludeOptionField( pObj, e_ASNH245JitterIndicationOptionMap_skippedFrameCount ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_skippedFrameCount),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245JitterIndication_IsIncludeOptionField( pObj, e_ASNH245JitterIndicationOptionMap_additionalDecoderBuffer ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_additionalDecoderBuffer),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245JitterIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245JitterIndication Print */
HS_RESULT ASNH245JitterIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245JitterIndication *pObj = (ASNH245JitterIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245JitterIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245JitterIndication_scope_Print( &(pObj->m_scope), pDepth+1, "scope" );
	AsnInteger_Print( &(pObj->m_estimatedReceivedJitterMantissa), pDepth+1, "estimatedReceivedJitterMantissa" );
	AsnInteger_Print( &(pObj->m_estimatedReceivedJitterExponent), pDepth+1, "estimatedReceivedJitterExponent" );
	if( ASNH245JitterIndication_IsIncludeOptionField( pObj, e_ASNH245JitterIndicationOptionMap_skippedFrameCount ) )
		AsnInteger_Print( &(pObj->m_skippedFrameCount), pDepth+1, "skippedFrameCount" );
	if( ASNH245JitterIndication_IsIncludeOptionField( pObj, e_ASNH245JitterIndicationOptionMap_additionalDecoderBuffer ) )
		AsnInteger_Print( &(pObj->m_additionalDecoderBuffer), pDepth+1, "additionalDecoderBuffer" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H223SkewIndication Class
*/
/*ASNH245H223SkewIndication Constructor*/
HS_RESULT new_ASNH245H223SkewIndication(void *pObject)
{
	ASNH245H223SkewIndication *pObj = (ASNH245H223SkewIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H223SkewIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber1) );
	new_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber2) );
	new_AsnInteger( &(pObj->m_skew), e_constrained, 0, 4095, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245H223SkewIndication Destructor */
HS_RESULT delete_ASNH245H223SkewIndication(void *pObject)
{
	ASNH245H223SkewIndication *pObj = (ASNH245H223SkewIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H223SkewIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber1) );
	delete_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber2) );
	delete_AsnInteger( &(pObj->m_skew) );
	return HS_OK;
}

/* ASNH245H223SkewIndication MakeMold */
HS_RESULT ASNH245H223SkewIndication_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H223SkewIndication *pObj = (ASNH245H223SkewIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223SkewIndication_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_logicalChannelNumber1));
	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_logicalChannelNumber2));
	return HS_OK;
}

/* ASNH245H223SkewIndication Encode */
HS_RESULT ASNH245H223SkewIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223SkewIndication *pObj = (ASNH245H223SkewIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223SkewIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_logicalChannelNumber1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223SkewIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_logicalChannelNumber2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223SkewIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_skew),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223SkewIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H223SkewIndication Decode */
HS_RESULT ASNH245H223SkewIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H223SkewIndication *pObj = (ASNH245H223SkewIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223SkewIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_logicalChannelNumber1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223SkewIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_logicalChannelNumber2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223SkewIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_skew),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H223SkewIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H223SkewIndication Print */
HS_RESULT ASNH245H223SkewIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H223SkewIndication *pObj = (ASNH245H223SkewIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H223SkewIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_logicalChannelNumber1), pDepth+1, "logicalChannelNumber1" );
	ASNH245LogicalChannelNumber_Print( &(pObj->m_logicalChannelNumber2), pDepth+1, "logicalChannelNumber2" );
	AsnInteger_Print( &(pObj->m_skew), pDepth+1, "skew" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCIndication_aal_aal1_clockRecovery Struct
*/
/* ASNH245NewATMVCIndication_aal_aal1_clockRecovery Constructor */
HS_RESULT new_ASNH245NewATMVCIndication_aal_aal1_clockRecovery( void *pObject )
{
	ASNH245NewATMVCIndication_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCIndication_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCIndication_aal_aal1_clockRecovery(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_nullClockRecovery;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCIndication_aal_aal1_clockRecovery Destructor */
HS_RESULT delete_ASNH245NewATMVCIndication_aal_aal1_clockRecovery( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCIndication_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCIndication_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_aal_aal1_clockRecovery(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCIndication_aal_aal1_clockRecovery_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_aal_aal1_clockRecovery(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCIndication_aal_aal1_clockRecovery SetChoice */
void* ASNH245NewATMVCIndication_aal_aal1_clockRecovery_SetChoice( void *pObject, ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCIndication_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCIndication_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice)(e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCIndication_aal_aal1_clockRecovery_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCIndication_aal_aal1_clockRecovery DeleteAlternation */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCIndication_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCIndication_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCIndication_aal_aal1_clockRecovery Encode */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCIndication_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice)(e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal1_clockRecovery Decode */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCIndication_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCIndication_aal_aal1_clockRecovery_SetChoice( pObj, (ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCIndication_aal_aal1_clockRecovery Print */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCIndication_aal_aal1_clockRecovery *pObj = (ASNH245NewATMVCIndication_aal_aal1_clockRecovery *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_nullClockRecovery ){
		AsnNull_Print( pObj->alter, pDepth+1, "nullClockRecovery" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_srtsClockRecovery ){
		AsnNull_Print( pObj->alter, pDepth+1, "srtsClockRecovery" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_clockRecoveryChoice_adaptiveClockRecovery ){
		AsnNull_Print( pObj->alter, pDepth+1, "adaptiveClockRecovery" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCIndication_aal_aal1_errorCorrection Struct
*/
/* ASNH245NewATMVCIndication_aal_aal1_errorCorrection Constructor */
HS_RESULT new_ASNH245NewATMVCIndication_aal_aal1_errorCorrection( void *pObject )
{
	ASNH245NewATMVCIndication_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCIndication_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCIndication_aal_aal1_errorCorrection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_nullErrorCorrection;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCIndication_aal_aal1_errorCorrection Destructor */
HS_RESULT delete_ASNH245NewATMVCIndication_aal_aal1_errorCorrection( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCIndication_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCIndication_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_aal_aal1_errorCorrection(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCIndication_aal_aal1_errorCorrection_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_aal_aal1_errorCorrection(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCIndication_aal_aal1_errorCorrection SetChoice */
void* ASNH245NewATMVCIndication_aal_aal1_errorCorrection_SetChoice( void *pObject, ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCIndication_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCIndication_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice)(e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCIndication_aal_aal1_errorCorrection_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_longInterleaver ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_shortInterleaver ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCIndication_aal_aal1_errorCorrection DeleteAlternation */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCIndication_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCIndication_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_longInterleaver ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_shortInterleaver ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCIndication_aal_aal1_errorCorrection Encode */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCIndication_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice)(e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_longInterleaver ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_shortInterleaver ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal1_errorCorrection Decode */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCIndication_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCIndication_aal_aal1_errorCorrection_SetChoice( pObj, (ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_longInterleaver ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_shortInterleaver ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCIndication_aal_aal1_errorCorrection Print */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCIndication_aal_aal1_errorCorrection *pObj = (ASNH245NewATMVCIndication_aal_aal1_errorCorrection *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_nullErrorCorrection ){
		AsnNull_Print( pObj->alter, pDepth+1, "nullErrorCorrection" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_longInterleaver ){
		AsnNull_Print( pObj->alter, pDepth+1, "longInterleaver" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_shortInterleaver ){
		AsnNull_Print( pObj->alter, pDepth+1, "shortInterleaver" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aal_aal1_errorCorrectionChoice_errorCorrectionOnly ){
		AsnNull_Print( pObj->alter, pDepth+1, "errorCorrectionOnly" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCIndication_aal_aal1 Class
*/
/*ASNH245NewATMVCIndication_aal_aal1 Constructor*/
HS_RESULT new_ASNH245NewATMVCIndication_aal_aal1(void *pObject)
{
	ASNH245NewATMVCIndication_aal_aal1 *pObj = (ASNH245NewATMVCIndication_aal_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCIndication_aal_aal1(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245NewATMVCIndication_aal_aal1_clockRecovery( &(pObj->m_clockRecovery) );
	new_ASNH245NewATMVCIndication_aal_aal1_errorCorrection( &(pObj->m_errorCorrection) );
	new_AsnBoolean( &(pObj->m_structuredDataTransfer) );
	new_AsnBoolean( &(pObj->m_partiallyFilledCells) );

	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal1 Destructor */
HS_RESULT delete_ASNH245NewATMVCIndication_aal_aal1(void *pObject)
{
	ASNH245NewATMVCIndication_aal_aal1 *pObj = (ASNH245NewATMVCIndication_aal_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_aal_aal1(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245NewATMVCIndication_aal_aal1_clockRecovery( &(pObj->m_clockRecovery) );
	delete_ASNH245NewATMVCIndication_aal_aal1_errorCorrection( &(pObj->m_errorCorrection) );
	delete_AsnBoolean( &(pObj->m_structuredDataTransfer) );
	delete_AsnBoolean( &(pObj->m_partiallyFilledCells) );
	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal1 MakeMold */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NewATMVCIndication_aal_aal1 *pObj = (ASNH245NewATMVCIndication_aal_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal1 Encode */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCIndication_aal_aal1 *pObj = (ASNH245NewATMVCIndication_aal_aal1 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Encode( &(pObj->m_clockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Encode( &(pObj->m_errorCorrection),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_structuredDataTransfer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_partiallyFilledCells),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal1 Decode */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCIndication_aal_aal1 *pObj = (ASNH245NewATMVCIndication_aal_aal1 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Decode(&(pObj->m_clockRecovery),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Decode(&(pObj->m_errorCorrection),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_structuredDataTransfer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_partiallyFilledCells),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCIndication_aal_aal1 Print */
HS_RESULT ASNH245NewATMVCIndication_aal_aal1_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCIndication_aal_aal1 *pObj = (ASNH245NewATMVCIndication_aal_aal1 *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal1_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245NewATMVCIndication_aal_aal1_clockRecovery_Print( &(pObj->m_clockRecovery), pDepth+1, "clockRecovery" );
	ASNH245NewATMVCIndication_aal_aal1_errorCorrection_Print( &(pObj->m_errorCorrection), pDepth+1, "errorCorrection" );
	AsnBoolean_Print( &(pObj->m_structuredDataTransfer), pDepth+1, "structuredDataTransfer" );
	AsnBoolean_Print( &(pObj->m_partiallyFilledCells), pDepth+1, "partiallyFilledCells" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCIndication_aal_aal5 Class
*/
/*ASNH245NewATMVCIndication_aal_aal5 Constructor*/
HS_RESULT new_ASNH245NewATMVCIndication_aal_aal5(void *pObject)
{
	ASNH245NewATMVCIndication_aal_aal5 *pObj = (ASNH245NewATMVCIndication_aal_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCIndication_aal_aal5(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_forwardMaximumSDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_backwardMaximumSDUSize), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal5 Destructor */
HS_RESULT delete_ASNH245NewATMVCIndication_aal_aal5(void *pObject)
{
	ASNH245NewATMVCIndication_aal_aal5 *pObj = (ASNH245NewATMVCIndication_aal_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_aal_aal5(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_forwardMaximumSDUSize) );
	delete_AsnInteger( &(pObj->m_backwardMaximumSDUSize) );
	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal5 MakeMold */
HS_RESULT ASNH245NewATMVCIndication_aal_aal5_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NewATMVCIndication_aal_aal5 *pObj = (ASNH245NewATMVCIndication_aal_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal5_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal5 Encode */
HS_RESULT ASNH245NewATMVCIndication_aal_aal5_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCIndication_aal_aal5 *pObj = (ASNH245NewATMVCIndication_aal_aal5 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal5_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_forwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal5_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_backwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal5_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal_aal5 Decode */
HS_RESULT ASNH245NewATMVCIndication_aal_aal5_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCIndication_aal_aal5 *pObj = (ASNH245NewATMVCIndication_aal_aal5 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal5_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_forwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal5_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_backwardMaximumSDUSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal5_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCIndication_aal_aal5 Print */
HS_RESULT ASNH245NewATMVCIndication_aal_aal5_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCIndication_aal_aal5 *pObj = (ASNH245NewATMVCIndication_aal_aal5 *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_aal5_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_forwardMaximumSDUSize), pDepth+1, "forwardMaximumSDUSize" );
	AsnInteger_Print( &(pObj->m_backwardMaximumSDUSize), pDepth+1, "backwardMaximumSDUSize" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCIndication_aal Struct
*/
/* ASNH245NewATMVCIndication_aal Constructor */
HS_RESULT new_ASNH245NewATMVCIndication_aal( void *pObject )
{
	ASNH245NewATMVCIndication_aal *pObj = (ASNH245NewATMVCIndication_aal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCIndication_aal(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCIndication_aalChoice_aal1;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCIndication_aalChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCIndication_aal Destructor */
HS_RESULT delete_ASNH245NewATMVCIndication_aal( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCIndication_aal *pObj = (ASNH245NewATMVCIndication_aal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_aal(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCIndication_aal_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_aal(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCIndication_aal SetChoice */
void* ASNH245NewATMVCIndication_aal_SetChoice( void *pObject, ASNH245NewATMVCIndication_aalChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCIndication_aal *pObj = (ASNH245NewATMVCIndication_aal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCIndication_aalChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCIndication_aalChoice)(e_ASNH245NewATMVCIndication_aalChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCIndication_aal_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCIndication_aalChoice_aal1 ){
		ASNH245NewATMVCIndication_aal_aal1 *tAlter = (ASNH245NewATMVCIndication_aal_aal1 *)HSMalloc( sizeof(ASNH245NewATMVCIndication_aal_aal1) );
		new_ASNH245NewATMVCIndication_aal_aal1(tAlter);
		ASNH245NewATMVCIndication_aal_aal1_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_aalChoice_aal5 ){
		ASNH245NewATMVCIndication_aal_aal5 *tAlter = (ASNH245NewATMVCIndication_aal_aal5 *)HSMalloc( sizeof(ASNH245NewATMVCIndication_aal_aal5) );
		new_ASNH245NewATMVCIndication_aal_aal5(tAlter);
		ASNH245NewATMVCIndication_aal_aal5_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCIndication_aal DeleteAlternation */
HS_RESULT ASNH245NewATMVCIndication_aal_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCIndication_aal *pObj = (ASNH245NewATMVCIndication_aal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCIndication_aalChoice_aal1 ){
			delete_ASNH245NewATMVCIndication_aal_aal1(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_aalChoice_aal5 ){
			delete_ASNH245NewATMVCIndication_aal_aal5(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCIndication_aal_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCIndication_aal Encode */
HS_RESULT ASNH245NewATMVCIndication_aal_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_aal *pObj = (ASNH245NewATMVCIndication_aal *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCIndication_aalChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCIndication_aalChoice)(e_ASNH245NewATMVCIndication_aalChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCIndication_aalChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_aalChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_aalChoice_aal1 ){
		if( (tRet=ASNH245NewATMVCIndication_aal_aal1_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aalChoice_aal5 ){
		if( (tRet=ASNH245NewATMVCIndication_aal_aal5_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_aal Decode */
HS_RESULT ASNH245NewATMVCIndication_aal_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_aal *pObj = (ASNH245NewATMVCIndication_aal *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCIndication_aalChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_aalChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCIndication_aalChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCIndication_aalChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCIndication_aal_SetChoice( pObj, (ASNH245NewATMVCIndication_aalChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_aalChoice_aal1 ){
		if( (tRet=ASNH245NewATMVCIndication_aal_aal1_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aalChoice_aal5 ){
		if( (tRet=ASNH245NewATMVCIndication_aal_aal5_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCIndication_aal Print */
HS_RESULT ASNH245NewATMVCIndication_aal_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCIndication_aal *pObj = (ASNH245NewATMVCIndication_aal *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCIndication_aal_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_aalChoice_aal1 ){
		ASNH245NewATMVCIndication_aal_aal1_Print( pObj->alter, pDepth+1, "aal1" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_aalChoice_aal5 ){
		ASNH245NewATMVCIndication_aal_aal5_Print( pObj->alter, pDepth+1, "aal5" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCIndication_multiplex Struct
*/
/* ASNH245NewATMVCIndication_multiplex Constructor */
HS_RESULT new_ASNH245NewATMVCIndication_multiplex( void *pObject )
{
	ASNH245NewATMVCIndication_multiplex *pObj = (ASNH245NewATMVCIndication_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCIndication_multiplex(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCIndication_multiplexChoice_noMultiplex;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCIndication_multiplexChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCIndication_multiplex Destructor */
HS_RESULT delete_ASNH245NewATMVCIndication_multiplex( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCIndication_multiplex *pObj = (ASNH245NewATMVCIndication_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_multiplex(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCIndication_multiplex_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_multiplex(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCIndication_multiplex SetChoice */
void* ASNH245NewATMVCIndication_multiplex_SetChoice( void *pObject, ASNH245NewATMVCIndication_multiplexChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCIndication_multiplex *pObj = (ASNH245NewATMVCIndication_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCIndication_multiplexChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCIndication_multiplexChoice)(e_ASNH245NewATMVCIndication_multiplexChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCIndication_multiplex_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCIndication_multiplexChoice_noMultiplex ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_multiplexChoice_transportStream ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_multiplexChoice_programStream ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCIndication_multiplex DeleteAlternation */
HS_RESULT ASNH245NewATMVCIndication_multiplex_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCIndication_multiplex *pObj = (ASNH245NewATMVCIndication_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_noMultiplex ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_transportStream ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_programStream ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCIndication_multiplex_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCIndication_multiplex Encode */
HS_RESULT ASNH245NewATMVCIndication_multiplex_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_multiplex *pObj = (ASNH245NewATMVCIndication_multiplex *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCIndication_multiplexChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCIndication_multiplexChoice)(e_ASNH245NewATMVCIndication_multiplexChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCIndication_multiplexChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_multiplexChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_noMultiplex ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_transportStream ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_programStream ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_multiplex Decode */
HS_RESULT ASNH245NewATMVCIndication_multiplex_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_multiplex *pObj = (ASNH245NewATMVCIndication_multiplex *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCIndication_multiplexChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_multiplexChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCIndication_multiplexChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCIndication_multiplexChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCIndication_multiplex_SetChoice( pObj, (ASNH245NewATMVCIndication_multiplexChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_noMultiplex ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_transportStream ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_programStream ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCIndication_multiplex Print */
HS_RESULT ASNH245NewATMVCIndication_multiplex_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCIndication_multiplex *pObj = (ASNH245NewATMVCIndication_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCIndication_multiplex_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_noMultiplex ){
		AsnNull_Print( pObj->alter, pDepth+1, "noMultiplex" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_transportStream ){
		AsnNull_Print( pObj->alter, pDepth+1, "transportStream" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_multiplexChoice_programStream ){
		AsnNull_Print( pObj->alter, pDepth+1, "programStream" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCIndication_reverseParameters_multiplex Struct
*/
/* ASNH245NewATMVCIndication_reverseParameters_multiplex Constructor */
HS_RESULT new_ASNH245NewATMVCIndication_reverseParameters_multiplex( void *pObject )
{
	ASNH245NewATMVCIndication_reverseParameters_multiplex *pObj = (ASNH245NewATMVCIndication_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCIndication_reverseParameters_multiplex(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_noMultiplex;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245NewATMVCIndication_reverseParameters_multiplex Destructor */
HS_RESULT delete_ASNH245NewATMVCIndication_reverseParameters_multiplex( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245NewATMVCIndication_reverseParameters_multiplex *pObj = (ASNH245NewATMVCIndication_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_reverseParameters_multiplex(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245NewATMVCIndication_reverseParameters_multiplex_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_reverseParameters_multiplex(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245NewATMVCIndication_reverseParameters_multiplex SetChoice */
void* ASNH245NewATMVCIndication_reverseParameters_multiplex_SetChoice( void *pObject, ASNH245NewATMVCIndication_reverseParameters_multiplexChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245NewATMVCIndication_reverseParameters_multiplex *pObj = (ASNH245NewATMVCIndication_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSizeExt ){
		if( pChoice > (ASNH245NewATMVCIndication_reverseParameters_multiplexChoice)(e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245NewATMVCIndication_reverseParameters_multiplex_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_noMultiplex ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_transportStream ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_programStream ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245NewATMVCIndication_reverseParameters_multiplex DeleteAlternation */
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_DeleteAlternation(void *pObject)
{
	ASNH245NewATMVCIndication_reverseParameters_multiplex *pObj = (ASNH245NewATMVCIndication_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_noMultiplex ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_transportStream ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_programStream ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245NewATMVCIndication_reverseParameters_multiplex Encode */
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_reverseParameters_multiplex *pObj = (ASNH245NewATMVCIndication_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSize )
		{
			if( pObj->choice > ((ASNH245NewATMVCIndication_reverseParameters_multiplexChoice)(e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSize)) )
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_noMultiplex ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_transportStream ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_programStream ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_reverseParameters_multiplex Decode */
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245NewATMVCIndication_reverseParameters_multiplex *pObj = (ASNH245NewATMVCIndication_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSize;
	}
	else
	{
		if( e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245NewATMVCIndication_reverseParameters_multiplex_SetChoice( pObj, (ASNH245NewATMVCIndication_reverseParameters_multiplexChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_noMultiplex ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_transportStream ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_programStream ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCIndication_reverseParameters_multiplex Print */
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_multiplex_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCIndication_reverseParameters_multiplex *pObj = (ASNH245NewATMVCIndication_reverseParameters_multiplex *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_multiplex_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_noMultiplex ){
		AsnNull_Print( pObj->alter, pDepth+1, "noMultiplex" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_transportStream ){
		AsnNull_Print( pObj->alter, pDepth+1, "transportStream" );
	}
	else if ( pObj->choice == e_ASNH245NewATMVCIndication_reverseParameters_multiplexChoice_programStream ){
		AsnNull_Print( pObj->alter, pDepth+1, "programStream" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCIndication_reverseParameters Class
*/
/*ASNH245NewATMVCIndication_reverseParameters Constructor*/
HS_RESULT new_ASNH245NewATMVCIndication_reverseParameters(void *pObject)
{
	ASNH245NewATMVCIndication_reverseParameters *pObj = (ASNH245NewATMVCIndication_reverseParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCIndication_reverseParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_bitRateLockedToPCRClock) );
	new_AsnBoolean( &(pObj->m_bitRateLockedToNetworkClock) );
	new_ASNH245NewATMVCIndication_reverseParameters_multiplex( &(pObj->m_multiplex) );

	return HS_OK;
}

/* ASNH245NewATMVCIndication_reverseParameters Destructor */
HS_RESULT delete_ASNH245NewATMVCIndication_reverseParameters(void *pObject)
{
	ASNH245NewATMVCIndication_reverseParameters *pObj = (ASNH245NewATMVCIndication_reverseParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication_reverseParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_bitRate) );
	delete_AsnBoolean( &(pObj->m_bitRateLockedToPCRClock) );
	delete_AsnBoolean( &(pObj->m_bitRateLockedToNetworkClock) );
	delete_ASNH245NewATMVCIndication_reverseParameters_multiplex( &(pObj->m_multiplex) );
	return HS_OK;
}

/* ASNH245NewATMVCIndication_reverseParameters MakeMold */
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NewATMVCIndication_reverseParameters *pObj = (ASNH245NewATMVCIndication_reverseParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_reverseParameters Encode */
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCIndication_reverseParameters *pObj = (ASNH245NewATMVCIndication_reverseParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_bitRateLockedToPCRClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_bitRateLockedToNetworkClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCIndication_reverseParameters_multiplex_Encode( &(pObj->m_multiplex),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245NewATMVCIndication_reverseParameters Decode */
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCIndication_reverseParameters *pObj = (ASNH245NewATMVCIndication_reverseParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_bitRateLockedToPCRClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_bitRateLockedToNetworkClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCIndication_reverseParameters_multiplex_Decode(&(pObj->m_multiplex),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCIndication_reverseParameters Print */
HS_RESULT ASNH245NewATMVCIndication_reverseParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCIndication_reverseParameters *pObj = (ASNH245NewATMVCIndication_reverseParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCIndication_reverseParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	AsnBoolean_Print( &(pObj->m_bitRateLockedToPCRClock), pDepth+1, "bitRateLockedToPCRClock" );
	AsnBoolean_Print( &(pObj->m_bitRateLockedToNetworkClock), pDepth+1, "bitRateLockedToNetworkClock" );
	ASNH245NewATMVCIndication_reverseParameters_multiplex_Print( &(pObj->m_multiplex), pDepth+1, "multiplex" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245NewATMVCIndication Class
*/
/*ASNH245NewATMVCIndication Constructor*/
HS_RESULT new_ASNH245NewATMVCIndication(void *pObject)
{
	ASNH245NewATMVCIndication *pObj = (ASNH245NewATMVCIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245NewATMVCIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_resourceID), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_bitRateLockedToPCRClock) );
	new_AsnBoolean( &(pObj->m_bitRateLockedToNetworkClock) );
	new_ASNH245NewATMVCIndication_aal( &(pObj->m_aal) );
	new_ASNH245NewATMVCIndication_multiplex( &(pObj->m_multiplex) );
	new_ASNH245NewATMVCIndication_reverseParameters( &(pObj->m_reverseParameters) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245NewATMVCIndication Destructor */
HS_RESULT delete_ASNH245NewATMVCIndication(void *pObject)
{
	ASNH245NewATMVCIndication *pObj = (ASNH245NewATMVCIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245NewATMVCIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_resourceID) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	delete_AsnBoolean( &(pObj->m_bitRateLockedToPCRClock) );
	delete_AsnBoolean( &(pObj->m_bitRateLockedToNetworkClock) );
	delete_ASNH245NewATMVCIndication_aal( &(pObj->m_aal) );
	delete_ASNH245NewATMVCIndication_multiplex( &(pObj->m_multiplex) );
	delete_ASNH245NewATMVCIndication_reverseParameters( &(pObj->m_reverseParameters) );
	return HS_OK;
}

/* ASNH245NewATMVCIndication MakeMold */
HS_RESULT ASNH245NewATMVCIndication_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245NewATMVCIndication *pObj = (ASNH245NewATMVCIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245NewATMVCIndication_reverseParameters_MakeMold(&(pObj->m_reverseParameters));
	return HS_OK;
}

/* ASNH245NewATMVCIndication IncludeOptionalField */
HS_RESULT ASNH245NewATMVCIndication_IncludeOptionField( void *pObject, ASNH245NewATMVCIndicationOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245NewATMVCIndication *pObj = (ASNH245NewATMVCIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245NewATMVCIndicationOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245NewATMVCIndicationOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245NewATMVCIndication IsIncludeOptionalField */
BOOL ASNH245NewATMVCIndication_IsIncludeOptionField( void *pObject, ASNH245NewATMVCIndicationOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245NewATMVCIndication *pObj = (ASNH245NewATMVCIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245NewATMVCIndicationOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245NewATMVCIndicationOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245NewATMVCIndication Encode */
HS_RESULT ASNH245NewATMVCIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCIndication *pObj = (ASNH245NewATMVCIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_resourceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_bitRateLockedToPCRClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_bitRateLockedToNetworkClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCIndication_aal_Encode( &(pObj->m_aal),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCIndication_multiplex_Encode( &(pObj->m_multiplex),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245NewATMVCIndication_IsIncludeOptionField( pObj, e_ASNH245NewATMVCIndicationOptionMap_reverseParameters ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_reverseParameters), ASNH245NewATMVCIndication_reverseParameters_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245NewATMVCIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245NewATMVCIndication Decode */
HS_RESULT ASNH245NewATMVCIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245NewATMVCIndication *pObj = (ASNH245NewATMVCIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_resourceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_bitRateLockedToPCRClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_bitRateLockedToNetworkClock),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCIndication_aal_Decode(&(pObj->m_aal),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245NewATMVCIndication_multiplex_Decode(&(pObj->m_multiplex),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245NewATMVCIndication_IsIncludeOptionField( pObj, e_ASNH245NewATMVCIndicationOptionMap_reverseParameters ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_reverseParameters), ASNH245NewATMVCIndication_reverseParameters_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245NewATMVCIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245NewATMVCIndication Print */
HS_RESULT ASNH245NewATMVCIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245NewATMVCIndication *pObj = (ASNH245NewATMVCIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245NewATMVCIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_resourceID), pDepth+1, "resourceID" );
	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	AsnBoolean_Print( &(pObj->m_bitRateLockedToPCRClock), pDepth+1, "bitRateLockedToPCRClock" );
	AsnBoolean_Print( &(pObj->m_bitRateLockedToNetworkClock), pDepth+1, "bitRateLockedToNetworkClock" );
	ASNH245NewATMVCIndication_aal_Print( &(pObj->m_aal), pDepth+1, "aal" );
	ASNH245NewATMVCIndication_multiplex_Print( &(pObj->m_multiplex), pDepth+1, "multiplex" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245NewATMVCIndication_IsIncludeOptionField( pObj, e_ASNH245NewATMVCIndicationOptionMap_reverseParameters ) )
		ASNH245NewATMVCIndication_reverseParameters_Print( &(pObj->m_reverseParameters), pDepth+1, "reverseParameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UserInputIndication_userInputSupportIndication Struct
*/
/* ASNH245UserInputIndication_userInputSupportIndication Constructor */
HS_RESULT new_ASNH245UserInputIndication_userInputSupportIndication( void *pObject )
{
	ASNH245UserInputIndication_userInputSupportIndication *pObj = (ASNH245UserInputIndication_userInputSupportIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UserInputIndication_userInputSupportIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245UserInputIndication_userInputSupportIndicationChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245UserInputIndication_userInputSupportIndication Destructor */
HS_RESULT delete_ASNH245UserInputIndication_userInputSupportIndication( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication_userInputSupportIndication *pObj = (ASNH245UserInputIndication_userInputSupportIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UserInputIndication_userInputSupportIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245UserInputIndication_userInputSupportIndication_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UserInputIndication_userInputSupportIndication(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245UserInputIndication_userInputSupportIndication SetChoice */
void* ASNH245UserInputIndication_userInputSupportIndication_SetChoice( void *pObject, ASNH245UserInputIndication_userInputSupportIndicationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245UserInputIndication_userInputSupportIndication *pObj = (ASNH245UserInputIndication_userInputSupportIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSizeExt ){
		if( pChoice > (ASNH245UserInputIndication_userInputSupportIndicationChoice)(e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245UserInputIndication_userInputSupportIndication_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_basicString ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_iA5String ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_generalString ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245UserInputIndication_userInputSupportIndication DeleteAlternation */
HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_DeleteAlternation(void *pObject)
{
	ASNH245UserInputIndication_userInputSupportIndication *pObj = (ASNH245UserInputIndication_userInputSupportIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_basicString ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_iA5String ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_generalString ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245UserInputIndication_userInputSupportIndication Encode */
HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245UserInputIndication_userInputSupportIndication *pObj = (ASNH245UserInputIndication_userInputSupportIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSize )
		{
			if( pObj->choice > ((ASNH245UserInputIndication_userInputSupportIndicationChoice)(e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_basicString ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_iA5String ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_generalString ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245UserInputIndication_userInputSupportIndication Decode */
HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245UserInputIndication_userInputSupportIndication *pObj = (ASNH245UserInputIndication_userInputSupportIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSize;
	}
	else
	{
		if( e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245UserInputIndication_userInputSupportIndicationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245UserInputIndication_userInputSupportIndication_SetChoice( pObj, (ASNH245UserInputIndication_userInputSupportIndicationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_basicString ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_iA5String ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_generalString ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UserInputIndication_userInputSupportIndication Print */
HS_RESULT ASNH245UserInputIndication_userInputSupportIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UserInputIndication_userInputSupportIndication *pObj = (ASNH245UserInputIndication_userInputSupportIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UserInputIndication_userInputSupportIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_basicString ){
		AsnNull_Print( pObj->alter, pDepth+1, "basicString" );
	}
	else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_iA5String ){
		AsnNull_Print( pObj->alter, pDepth+1, "iA5String" );
	}
	else if ( pObj->choice == e_ASNH245UserInputIndication_userInputSupportIndicationChoice_generalString ){
		AsnNull_Print( pObj->alter, pDepth+1, "generalString" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UserInputIndication_signal_rtp Class
*/
/*ASNH245UserInputIndication_signal_rtp Constructor*/
HS_RESULT new_ASNH245UserInputIndication_signal_rtp(void *pObject)
{
	ASNH245UserInputIndication_signal_rtp *pObj = (ASNH245UserInputIndication_signal_rtp *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UserInputIndication_signal_rtp(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_timestamp), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_expirationTime), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245UserInputIndication_signal_rtp Destructor */
HS_RESULT delete_ASNH245UserInputIndication_signal_rtp(void *pObject)
{
	ASNH245UserInputIndication_signal_rtp *pObj = (ASNH245UserInputIndication_signal_rtp *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UserInputIndication_signal_rtp(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_timestamp) );
	delete_AsnInteger( &(pObj->m_expirationTime) );
	delete_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );
	return HS_OK;
}

/* ASNH245UserInputIndication_signal_rtp MakeMold */
HS_RESULT ASNH245UserInputIndication_signal_rtp_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245UserInputIndication_signal_rtp *pObj = (ASNH245UserInputIndication_signal_rtp *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_logicalChannelNumber));
	return HS_OK;
}

/* ASNH245UserInputIndication_signal_rtp IncludeOptionalField */
HS_RESULT ASNH245UserInputIndication_signal_rtp_IncludeOptionField( void *pObject, ASNH245UserInputIndication_signal_rtpOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245UserInputIndication_signal_rtp *pObj = (ASNH245UserInputIndication_signal_rtp *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245UserInputIndication_signal_rtpOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245UserInputIndication_signal_rtp IsIncludeOptionalField */
BOOL ASNH245UserInputIndication_signal_rtp_IsIncludeOptionField( void *pObject, ASNH245UserInputIndication_signal_rtpOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245UserInputIndication_signal_rtp *pObj = (ASNH245UserInputIndication_signal_rtp *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245UserInputIndication_signal_rtpOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245UserInputIndication_signal_rtp Encode */
HS_RESULT ASNH245UserInputIndication_signal_rtp_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication_signal_rtp *pObj = (ASNH245UserInputIndication_signal_rtp *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245UserInputIndication_signal_rtpOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245UserInputIndication_signal_rtpOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245UserInputIndication_signal_rtp_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signal_rtpOptionMap_timestamp ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_timestamp),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245UserInputIndication_signal_rtp_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signal_rtpOptionMap_expirationTime ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_expirationTime),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245UserInputIndication_signal_rtp Decode */
HS_RESULT ASNH245UserInputIndication_signal_rtp_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication_signal_rtp *pObj = (ASNH245UserInputIndication_signal_rtp *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245UserInputIndication_signal_rtpOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245UserInputIndication_signal_rtpOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH245UserInputIndication_signal_rtp_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signal_rtpOptionMap_timestamp ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_timestamp),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245UserInputIndication_signal_rtp_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signal_rtpOptionMap_expirationTime ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_expirationTime),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UserInputIndication_signal_rtp Print */
HS_RESULT ASNH245UserInputIndication_signal_rtp_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UserInputIndication_signal_rtp *pObj = (ASNH245UserInputIndication_signal_rtp *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_rtp_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH245UserInputIndication_signal_rtp_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signal_rtpOptionMap_timestamp ) )
		AsnInteger_Print( &(pObj->m_timestamp), pDepth+1, "timestamp" );
	if( ASNH245UserInputIndication_signal_rtp_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signal_rtpOptionMap_expirationTime ) )
		AsnInteger_Print( &(pObj->m_expirationTime), pDepth+1, "expirationTime" );
	ASNH245LogicalChannelNumber_Print( &(pObj->m_logicalChannelNumber), pDepth+1, "logicalChannelNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UserInputIndication_signal Class
*/
/*ASNH245UserInputIndication_signal Constructor*/
HS_RESULT new_ASNH245UserInputIndication_signal(void *pObject)
{
	ASNH245UserInputIndication_signal *pObj = (ASNH245UserInputIndication_signal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UserInputIndication_signal(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSingleString( &(pObj->m_signalType), e_asnTagIA5String, e_constrained, 1, 1, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_duration), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245UserInputIndication_signal_rtp( &(pObj->m_rtp) );
	new_AsnNull( &(pObj->m_rtpPayloadIndication) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	/* FROM Constraint */
	strcpy((char*)(pObj->m_signalType.fromConstraint), "!#*0123456789ABCD");
	pObj->m_signalType.fromSize = 17;
	pObj->m_signalType.reIndexing =	GetStringTypeEncodingBits(
		pObj->m_signalType.fromSize,
		ASN_IA5_STRING_VMAX,
		&(pObj->m_signalType.encodingBitsOfAlign),
		&(pObj->m_signalType.encodingBitsOfUnalign)
	);
	return HS_OK;
}

/* ASNH245UserInputIndication_signal Destructor */
HS_RESULT delete_ASNH245UserInputIndication_signal(void *pObject)
{
	ASNH245UserInputIndication_signal *pObj = (ASNH245UserInputIndication_signal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UserInputIndication_signal(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSingleString( &(pObj->m_signalType) );
	delete_AsnInteger( &(pObj->m_duration) );
	delete_ASNH245UserInputIndication_signal_rtp( &(pObj->m_rtp) );
	delete_AsnNull( &(pObj->m_rtpPayloadIndication) );
	return HS_OK;
}

/* ASNH245UserInputIndication_signal MakeMold */
HS_RESULT ASNH245UserInputIndication_signal_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245UserInputIndication_signal *pObj = (ASNH245UserInputIndication_signal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245UserInputIndication_signal_rtp_MakeMold(&(pObj->m_rtp));
	return HS_OK;
}

/* ASNH245UserInputIndication_signal IncludeOptionalField */
HS_RESULT ASNH245UserInputIndication_signal_IncludeOptionField( void *pObject, ASNH245UserInputIndication_signalOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245UserInputIndication_signal *pObj = (ASNH245UserInputIndication_signal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245UserInputIndication_signalOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245UserInputIndication_signalOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245UserInputIndication_signalOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH245UserInputIndication_signal IsIncludeOptionalField */
BOOL ASNH245UserInputIndication_signal_IsIncludeOptionField( void *pObject, ASNH245UserInputIndication_signalOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245UserInputIndication_signal *pObj = (ASNH245UserInputIndication_signal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245UserInputIndication_signalOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH245UserInputIndication_signalOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245UserInputIndication_signalOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245UserInputIndication_signal Encode */
HS_RESULT ASNH245UserInputIndication_signal_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication_signal *pObj = (ASNH245UserInputIndication_signal *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245UserInputIndication_signalOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245UserInputIndication_signalOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnSingleString_Encode( &(pObj->m_signalType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245UserInputIndication_signal_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalOptionMap_duration ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_duration),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245UserInputIndication_signal_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalOptionMap_rtp ) ){
		if( (tRet=ASNH245UserInputIndication_signal_rtp_Encode( &(pObj->m_rtp),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245UserInputIndication_signal_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalOptionMap_rtpPayloadIndication ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_rtpPayloadIndication), AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245UserInputIndication_signal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245UserInputIndication_signal Decode */
HS_RESULT ASNH245UserInputIndication_signal_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication_signal *pObj = (ASNH245UserInputIndication_signal *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245UserInputIndication_signalOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245UserInputIndication_signalOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnSingleString_Decode(&(pObj->m_signalType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245UserInputIndication_signal_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalOptionMap_duration ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_duration),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signal_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245UserInputIndication_signal_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalOptionMap_rtp ) ){
		if( (tRet=ASNH245UserInputIndication_signal_rtp_Decode(&(pObj->m_rtp),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signal_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245UserInputIndication_signal_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalOptionMap_rtpPayloadIndication ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_rtpPayloadIndication), AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signal_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UserInputIndication_signal Print */
HS_RESULT ASNH245UserInputIndication_signal_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UserInputIndication_signal *pObj = (ASNH245UserInputIndication_signal *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UserInputIndication_signal_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSingleString_Print( &(pObj->m_signalType), pDepth+1, "signalType" );
	if( ASNH245UserInputIndication_signal_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalOptionMap_duration ) )
		AsnInteger_Print( &(pObj->m_duration), pDepth+1, "duration" );
	if( ASNH245UserInputIndication_signal_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalOptionMap_rtp ) )
		ASNH245UserInputIndication_signal_rtp_Print( &(pObj->m_rtp), pDepth+1, "rtp" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245UserInputIndication_signal_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalOptionMap_rtpPayloadIndication ) )
		AsnNull_Print( &(pObj->m_rtpPayloadIndication), pDepth+1, "rtpPayloadIndication" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UserInputIndication_signalUpdate_rtp Class
*/
/*ASNH245UserInputIndication_signalUpdate_rtp Constructor*/
HS_RESULT new_ASNH245UserInputIndication_signalUpdate_rtp(void *pObject)
{
	ASNH245UserInputIndication_signalUpdate_rtp *pObj = (ASNH245UserInputIndication_signalUpdate_rtp *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UserInputIndication_signalUpdate_rtp(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );

	return HS_OK;
}

/* ASNH245UserInputIndication_signalUpdate_rtp Destructor */
HS_RESULT delete_ASNH245UserInputIndication_signalUpdate_rtp(void *pObject)
{
	ASNH245UserInputIndication_signalUpdate_rtp *pObj = (ASNH245UserInputIndication_signalUpdate_rtp *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UserInputIndication_signalUpdate_rtp(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber) );
	return HS_OK;
}

/* ASNH245UserInputIndication_signalUpdate_rtp MakeMold */
HS_RESULT ASNH245UserInputIndication_signalUpdate_rtp_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245UserInputIndication_signalUpdate_rtp *pObj = (ASNH245UserInputIndication_signalUpdate_rtp *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_rtp_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_logicalChannelNumber));
	return HS_OK;
}

/* ASNH245UserInputIndication_signalUpdate_rtp Encode */
HS_RESULT ASNH245UserInputIndication_signalUpdate_rtp_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UserInputIndication_signalUpdate_rtp *pObj = (ASNH245UserInputIndication_signalUpdate_rtp *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_rtp_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_rtp_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245UserInputIndication_signalUpdate_rtp Decode */
HS_RESULT ASNH245UserInputIndication_signalUpdate_rtp_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245UserInputIndication_signalUpdate_rtp *pObj = (ASNH245UserInputIndication_signalUpdate_rtp *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_rtp_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_logicalChannelNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_rtp_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UserInputIndication_signalUpdate_rtp Print */
HS_RESULT ASNH245UserInputIndication_signalUpdate_rtp_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UserInputIndication_signalUpdate_rtp *pObj = (ASNH245UserInputIndication_signalUpdate_rtp *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_rtp_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_logicalChannelNumber), pDepth+1, "logicalChannelNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UserInputIndication_signalUpdate Class
*/
/*ASNH245UserInputIndication_signalUpdate Constructor*/
HS_RESULT new_ASNH245UserInputIndication_signalUpdate(void *pObject)
{
	ASNH245UserInputIndication_signalUpdate *pObj = (ASNH245UserInputIndication_signalUpdate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UserInputIndication_signalUpdate(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_duration), e_constrained, 1, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH245UserInputIndication_signalUpdate_rtp( &(pObj->m_rtp) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245UserInputIndication_signalUpdate Destructor */
HS_RESULT delete_ASNH245UserInputIndication_signalUpdate(void *pObject)
{
	ASNH245UserInputIndication_signalUpdate *pObj = (ASNH245UserInputIndication_signalUpdate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UserInputIndication_signalUpdate(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_duration) );
	delete_ASNH245UserInputIndication_signalUpdate_rtp( &(pObj->m_rtp) );
	return HS_OK;
}

/* ASNH245UserInputIndication_signalUpdate MakeMold */
HS_RESULT ASNH245UserInputIndication_signalUpdate_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245UserInputIndication_signalUpdate *pObj = (ASNH245UserInputIndication_signalUpdate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245UserInputIndication_signalUpdate_rtp_MakeMold(&(pObj->m_rtp));
	return HS_OK;
}

/* ASNH245UserInputIndication_signalUpdate IncludeOptionalField */
HS_RESULT ASNH245UserInputIndication_signalUpdate_IncludeOptionField( void *pObject, ASNH245UserInputIndication_signalUpdateOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245UserInputIndication_signalUpdate *pObj = (ASNH245UserInputIndication_signalUpdate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245UserInputIndication_signalUpdateOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245UserInputIndication_signalUpdate IsIncludeOptionalField */
BOOL ASNH245UserInputIndication_signalUpdate_IsIncludeOptionField( void *pObject, ASNH245UserInputIndication_signalUpdateOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245UserInputIndication_signalUpdate *pObj = (ASNH245UserInputIndication_signalUpdate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245UserInputIndication_signalUpdateOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245UserInputIndication_signalUpdate Encode */
HS_RESULT ASNH245UserInputIndication_signalUpdate_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication_signalUpdate *pObj = (ASNH245UserInputIndication_signalUpdate *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245UserInputIndication_signalUpdateOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245UserInputIndication_signalUpdateOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Encode( &(pObj->m_duration),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245UserInputIndication_signalUpdate_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalUpdateOptionMap_rtp ) ){
		if( (tRet=ASNH245UserInputIndication_signalUpdate_rtp_Encode( &(pObj->m_rtp),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245UserInputIndication_signalUpdate Decode */
HS_RESULT ASNH245UserInputIndication_signalUpdate_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication_signalUpdate *pObj = (ASNH245UserInputIndication_signalUpdate *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245UserInputIndication_signalUpdateOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245UserInputIndication_signalUpdateOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_duration),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245UserInputIndication_signalUpdate_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalUpdateOptionMap_rtp ) ){
		if( (tRet=ASNH245UserInputIndication_signalUpdate_rtp_Decode(&(pObj->m_rtp),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UserInputIndication_signalUpdate Print */
HS_RESULT ASNH245UserInputIndication_signalUpdate_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UserInputIndication_signalUpdate *pObj = (ASNH245UserInputIndication_signalUpdate *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UserInputIndication_signalUpdate_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_duration), pDepth+1, "duration" );
	if( ASNH245UserInputIndication_signalUpdate_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_signalUpdateOptionMap_rtp ) )
		ASNH245UserInputIndication_signalUpdate_rtp_Print( &(pObj->m_rtp), pDepth+1, "rtp" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UserInputIndication_extendedAlphanumeric Class
*/
/*ASNH245UserInputIndication_extendedAlphanumeric Constructor*/
HS_RESULT new_ASNH245UserInputIndication_extendedAlphanumeric(void *pObject)
{
	ASNH245UserInputIndication_extendedAlphanumeric *pObj = (ASNH245UserInputIndication_extendedAlphanumeric *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UserInputIndication_extendedAlphanumeric(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSingleString( &(pObj->m_alphanumeric), e_asnTagGeneralString, e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnNull( &(pObj->m_rtpPayloadIndication) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245UserInputIndication_extendedAlphanumeric Destructor */
HS_RESULT delete_ASNH245UserInputIndication_extendedAlphanumeric(void *pObject)
{
	ASNH245UserInputIndication_extendedAlphanumeric *pObj = (ASNH245UserInputIndication_extendedAlphanumeric *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UserInputIndication_extendedAlphanumeric(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSingleString( &(pObj->m_alphanumeric) );
	delete_AsnNull( &(pObj->m_rtpPayloadIndication) );
	return HS_OK;
}

/* ASNH245UserInputIndication_extendedAlphanumeric MakeMold */
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245UserInputIndication_extendedAlphanumeric *pObj = (ASNH245UserInputIndication_extendedAlphanumeric *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245UserInputIndication_extendedAlphanumeric IncludeOptionalField */
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_IncludeOptionField( void *pObject, ASNH245UserInputIndication_extendedAlphanumericOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245UserInputIndication_extendedAlphanumeric *pObj = (ASNH245UserInputIndication_extendedAlphanumeric *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245UserInputIndication_extendedAlphanumericOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245UserInputIndication_extendedAlphanumeric IsIncludeOptionalField */
BOOL ASNH245UserInputIndication_extendedAlphanumeric_IsIncludeOptionField( void *pObject, ASNH245UserInputIndication_extendedAlphanumericOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245UserInputIndication_extendedAlphanumeric *pObj = (ASNH245UserInputIndication_extendedAlphanumeric *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245UserInputIndication_extendedAlphanumericOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245UserInputIndication_extendedAlphanumeric Encode */
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication_extendedAlphanumeric *pObj = (ASNH245UserInputIndication_extendedAlphanumeric *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245UserInputIndication_extendedAlphanumericOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245UserInputIndication_extendedAlphanumericOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnSingleString_Encode( &(pObj->m_alphanumeric),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245UserInputIndication_extendedAlphanumeric_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_extendedAlphanumericOptionMap_rtpPayloadIndication ) ){
		if( (tRet=AsnNull_Encode( &(pObj->m_rtpPayloadIndication),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245UserInputIndication_extendedAlphanumeric Decode */
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication_extendedAlphanumeric *pObj = (ASNH245UserInputIndication_extendedAlphanumeric *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245UserInputIndication_extendedAlphanumericOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245UserInputIndication_extendedAlphanumericOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnSingleString_Decode(&(pObj->m_alphanumeric),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245UserInputIndication_extendedAlphanumeric_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_extendedAlphanumericOptionMap_rtpPayloadIndication ) ){
		if( (tRet=AsnNull_Decode(&(pObj->m_rtpPayloadIndication),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UserInputIndication_extendedAlphanumeric Print */
HS_RESULT ASNH245UserInputIndication_extendedAlphanumeric_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UserInputIndication_extendedAlphanumeric *pObj = (ASNH245UserInputIndication_extendedAlphanumeric *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UserInputIndication_extendedAlphanumeric_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSingleString_Print( &(pObj->m_alphanumeric), pDepth+1, "alphanumeric" );
	if( ASNH245UserInputIndication_extendedAlphanumeric_IsIncludeOptionField( pObj, e_ASNH245UserInputIndication_extendedAlphanumericOptionMap_rtpPayloadIndication ) )
		AsnNull_Print( &(pObj->m_rtpPayloadIndication), pDepth+1, "rtpPayloadIndication" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245UserInputIndication Struct
*/
/* ASNH245UserInputIndication Constructor */
HS_RESULT new_ASNH245UserInputIndication( void *pObject )
{
	ASNH245UserInputIndication *pObj = (ASNH245UserInputIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245UserInputIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245UserInputIndicationChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245UserInputIndicationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245UserInputIndication Destructor */
HS_RESULT delete_ASNH245UserInputIndication( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245UserInputIndication *pObj = (ASNH245UserInputIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UserInputIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245UserInputIndication_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245UserInputIndication(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245UserInputIndication SetChoice */
void* ASNH245UserInputIndication_SetChoice( void *pObject, ASNH245UserInputIndicationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245UserInputIndication *pObj = (ASNH245UserInputIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245UserInputIndicationChoiceSizeExt ){
		if( pChoice > (ASNH245UserInputIndicationChoice)(e_ASNH245UserInputIndicationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245UserInputIndication_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245UserInputIndicationChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UserInputIndicationChoice_alphanumeric ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagGeneralString,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245UserInputIndicationChoice_userInputSupportIndication ){
		ASNH245UserInputIndication_userInputSupportIndication *tAlter = (ASNH245UserInputIndication_userInputSupportIndication *)HSMalloc( sizeof(ASNH245UserInputIndication_userInputSupportIndication) );
		new_ASNH245UserInputIndication_userInputSupportIndication(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UserInputIndicationChoice_signal ){
		ASNH245UserInputIndication_signal *tAlter = (ASNH245UserInputIndication_signal *)HSMalloc( sizeof(ASNH245UserInputIndication_signal) );
		new_ASNH245UserInputIndication_signal(tAlter);
		ASNH245UserInputIndication_signal_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UserInputIndicationChoice_signalUpdate ){
		ASNH245UserInputIndication_signalUpdate *tAlter = (ASNH245UserInputIndication_signalUpdate *)HSMalloc( sizeof(ASNH245UserInputIndication_signalUpdate) );
		new_ASNH245UserInputIndication_signalUpdate(tAlter);
		ASNH245UserInputIndication_signalUpdate_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245UserInputIndicationChoice_extendedAlphanumeric ){
		ASNH245UserInputIndication_extendedAlphanumeric *tAlter = (ASNH245UserInputIndication_extendedAlphanumeric *)HSMalloc( sizeof(ASNH245UserInputIndication_extendedAlphanumeric) );
		new_ASNH245UserInputIndication_extendedAlphanumeric(tAlter);
		ASNH245UserInputIndication_extendedAlphanumeric_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245UserInputIndication DeleteAlternation */
HS_RESULT ASNH245UserInputIndication_DeleteAlternation(void *pObject)
{
	ASNH245UserInputIndication *pObj = (ASNH245UserInputIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245UserInputIndicationChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_alphanumeric ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_userInputSupportIndication ){
			delete_ASNH245UserInputIndication_userInputSupportIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_signal ){
			delete_ASNH245UserInputIndication_signal(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_signalUpdate ){
			delete_ASNH245UserInputIndication_signalUpdate(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_extendedAlphanumeric ){
			delete_ASNH245UserInputIndication_extendedAlphanumeric(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245UserInputIndication_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245UserInputIndication Encode */
HS_RESULT ASNH245UserInputIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245UserInputIndication *pObj = (ASNH245UserInputIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245UserInputIndicationChoiceSize )
		{
			if( pObj->choice > ((ASNH245UserInputIndicationChoice)(e_ASNH245UserInputIndicationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245UserInputIndicationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245UserInputIndicationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UserInputIndicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_alphanumeric ){
		if( (tRet=AsnSingleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_userInputSupportIndication ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245UserInputIndication_userInputSupportIndication_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_signal ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245UserInputIndication_signal_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_signalUpdate ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245UserInputIndication_signalUpdate_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_extendedAlphanumeric ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245UserInputIndication_extendedAlphanumeric_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245UserInputIndication Decode */
HS_RESULT ASNH245UserInputIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245UserInputIndication *pObj = (ASNH245UserInputIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245UserInputIndicationChoiceSize;
	}
	else
	{
		if( e_ASNH245UserInputIndicationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245UserInputIndicationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245UserInputIndicationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245UserInputIndication_SetChoice( pObj, (ASNH245UserInputIndicationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UserInputIndicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_alphanumeric ){
		if( (tRet=AsnSingleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_userInputSupportIndication ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245UserInputIndication_userInputSupportIndication_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_signal ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245UserInputIndication_signal_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_signalUpdate ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245UserInputIndication_signalUpdate_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_extendedAlphanumeric ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245UserInputIndication_extendedAlphanumeric_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245UserInputIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245UserInputIndication_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245UserInputIndication Print */
HS_RESULT ASNH245UserInputIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245UserInputIndication *pObj = (ASNH245UserInputIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245UserInputIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245UserInputIndicationChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_alphanumeric ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "alphanumeric" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_userInputSupportIndication ){
		ASNH245UserInputIndication_userInputSupportIndication_Print( pObj->alter, pDepth+1, "userInputSupportIndication" );
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_signal ){
		ASNH245UserInputIndication_signal_Print( pObj->alter, pDepth+1, "signal" );
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_signalUpdate ){
		ASNH245UserInputIndication_signalUpdate_Print( pObj->alter, pDepth+1, "signalUpdate" );
	}
	else if ( pObj->choice == e_ASNH245UserInputIndicationChoice_extendedAlphanumeric ){
		ASNH245UserInputIndication_extendedAlphanumeric_Print( pObj->alter, pDepth+1, "extendedAlphanumeric" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H2250MaximumSkewIndication Class
*/
/*ASNH245H2250MaximumSkewIndication Constructor*/
HS_RESULT new_ASNH245H2250MaximumSkewIndication(void *pObject)
{
	ASNH245H2250MaximumSkewIndication *pObj = (ASNH245H2250MaximumSkewIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H2250MaximumSkewIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber1) );
	new_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber2) );
	new_AsnInteger( &(pObj->m_maximumSkew), e_constrained, 0, 4095, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245H2250MaximumSkewIndication Destructor */
HS_RESULT delete_ASNH245H2250MaximumSkewIndication(void *pObject)
{
	ASNH245H2250MaximumSkewIndication *pObj = (ASNH245H2250MaximumSkewIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H2250MaximumSkewIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber1) );
	delete_ASNH245LogicalChannelNumber( &(pObj->m_logicalChannelNumber2) );
	delete_AsnInteger( &(pObj->m_maximumSkew) );
	return HS_OK;
}

/* ASNH245H2250MaximumSkewIndication MakeMold */
HS_RESULT ASNH245H2250MaximumSkewIndication_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H2250MaximumSkewIndication *pObj = (ASNH245H2250MaximumSkewIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_logicalChannelNumber1));
	ASNH245LogicalChannelNumber_MakeMold(&(pObj->m_logicalChannelNumber2));
	return HS_OK;
}

/* ASNH245H2250MaximumSkewIndication Encode */
HS_RESULT ASNH245H2250MaximumSkewIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H2250MaximumSkewIndication *pObj = (ASNH245H2250MaximumSkewIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_logicalChannelNumber1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245LogicalChannelNumber_Encode( &(pObj->m_logicalChannelNumber2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_maximumSkew),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H2250MaximumSkewIndication Decode */
HS_RESULT ASNH245H2250MaximumSkewIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H2250MaximumSkewIndication *pObj = (ASNH245H2250MaximumSkewIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_logicalChannelNumber1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245LogicalChannelNumber_Decode(&(pObj->m_logicalChannelNumber2),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_maximumSkew),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H2250MaximumSkewIndication Print */
HS_RESULT ASNH245H2250MaximumSkewIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H2250MaximumSkewIndication *pObj = (ASNH245H2250MaximumSkewIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H2250MaximumSkewIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245LogicalChannelNumber_Print( &(pObj->m_logicalChannelNumber1), pDepth+1, "logicalChannelNumber1" );
	ASNH245LogicalChannelNumber_Print( &(pObj->m_logicalChannelNumber2), pDepth+1, "logicalChannelNumber2" );
	AsnInteger_Print( &(pObj->m_maximumSkew), pDepth+1, "maximumSkew" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MCLocationIndication Class
*/
/*ASNH245MCLocationIndication Constructor*/
HS_RESULT new_ASNH245MCLocationIndication(void *pObject)
{
	ASNH245MCLocationIndication *pObj = (ASNH245MCLocationIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MCLocationIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245TransportAddress( &(pObj->m_signalAddress) );

	return HS_OK;
}

/* ASNH245MCLocationIndication Destructor */
HS_RESULT delete_ASNH245MCLocationIndication(void *pObject)
{
	ASNH245MCLocationIndication *pObj = (ASNH245MCLocationIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MCLocationIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245TransportAddress( &(pObj->m_signalAddress) );
	return HS_OK;
}

/* ASNH245MCLocationIndication MakeMold */
HS_RESULT ASNH245MCLocationIndication_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MCLocationIndication *pObj = (ASNH245MCLocationIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MCLocationIndication_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245TransportAddress_MakeMold(&(pObj->m_signalAddress));
	return HS_OK;
}

/* ASNH245MCLocationIndication Encode */
HS_RESULT ASNH245MCLocationIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MCLocationIndication *pObj = (ASNH245MCLocationIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MCLocationIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245TransportAddress_Encode( &(pObj->m_signalAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MCLocationIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MCLocationIndication Decode */
HS_RESULT ASNH245MCLocationIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MCLocationIndication *pObj = (ASNH245MCLocationIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MCLocationIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245TransportAddress_Decode(&(pObj->m_signalAddress),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MCLocationIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MCLocationIndication Print */
HS_RESULT ASNH245MCLocationIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MCLocationIndication *pObj = (ASNH245MCLocationIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MCLocationIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245TransportAddress_Print( &(pObj->m_signalAddress), pDepth+1, "signalAddress" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245TerminalYouAreSeeingInSubPictureNumber Class
*/
/*ASNH245TerminalYouAreSeeingInSubPictureNumber Constructor*/
HS_RESULT new_ASNH245TerminalYouAreSeeingInSubPictureNumber(void *pObject)
{
	ASNH245TerminalYouAreSeeingInSubPictureNumber *pObj = (ASNH245TerminalYouAreSeeingInSubPictureNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245TerminalYouAreSeeingInSubPictureNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245TerminalNumber( &(pObj->m_terminalNumber) );
	new_AsnInteger( &(pObj->m_subPictureNumber), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245TerminalYouAreSeeingInSubPictureNumber Destructor */
HS_RESULT delete_ASNH245TerminalYouAreSeeingInSubPictureNumber(void *pObject)
{
	ASNH245TerminalYouAreSeeingInSubPictureNumber *pObj = (ASNH245TerminalYouAreSeeingInSubPictureNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245TerminalYouAreSeeingInSubPictureNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245TerminalNumber( &(pObj->m_terminalNumber) );
	delete_AsnInteger( &(pObj->m_subPictureNumber) );
	return HS_OK;
}

/* ASNH245TerminalYouAreSeeingInSubPictureNumber MakeMold */
HS_RESULT ASNH245TerminalYouAreSeeingInSubPictureNumber_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245TerminalYouAreSeeingInSubPictureNumber *pObj = (ASNH245TerminalYouAreSeeingInSubPictureNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalYouAreSeeingInSubPictureNumber_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245TerminalNumber_MakeMold(&(pObj->m_terminalNumber));
	return HS_OK;
}

/* ASNH245TerminalYouAreSeeingInSubPictureNumber Encode */
HS_RESULT ASNH245TerminalYouAreSeeingInSubPictureNumber_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TerminalYouAreSeeingInSubPictureNumber *pObj = (ASNH245TerminalYouAreSeeingInSubPictureNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalYouAreSeeingInSubPictureNumber_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245TerminalNumber_Encode( &(pObj->m_terminalNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalYouAreSeeingInSubPictureNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_subPictureNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalYouAreSeeingInSubPictureNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245TerminalYouAreSeeingInSubPictureNumber Decode */
HS_RESULT ASNH245TerminalYouAreSeeingInSubPictureNumber_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245TerminalYouAreSeeingInSubPictureNumber *pObj = (ASNH245TerminalYouAreSeeingInSubPictureNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalYouAreSeeingInSubPictureNumber_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245TerminalNumber_Decode(&(pObj->m_terminalNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalYouAreSeeingInSubPictureNumber_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_subPictureNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245TerminalYouAreSeeingInSubPictureNumber_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245TerminalYouAreSeeingInSubPictureNumber Print */
HS_RESULT ASNH245TerminalYouAreSeeingInSubPictureNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245TerminalYouAreSeeingInSubPictureNumber *pObj = (ASNH245TerminalYouAreSeeingInSubPictureNumber *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245TerminalYouAreSeeingInSubPictureNumber_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245TerminalNumber_Print( &(pObj->m_terminalNumber), pDepth+1, "terminalNumber" );
	AsnInteger_Print( &(pObj->m_subPictureNumber), pDepth+1, "subPictureNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VideoIndicateCompose Class
*/
/*ASNH245VideoIndicateCompose Constructor*/
HS_RESULT new_ASNH245VideoIndicateCompose(void *pObject)
{
	ASNH245VideoIndicateCompose *pObj = (ASNH245VideoIndicateCompose *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VideoIndicateCompose(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_compositionNumber), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245VideoIndicateCompose Destructor */
HS_RESULT delete_ASNH245VideoIndicateCompose(void *pObject)
{
	ASNH245VideoIndicateCompose *pObj = (ASNH245VideoIndicateCompose *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VideoIndicateCompose(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_compositionNumber) );
	return HS_OK;
}

/* ASNH245VideoIndicateCompose MakeMold */
HS_RESULT ASNH245VideoIndicateCompose_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245VideoIndicateCompose *pObj = (ASNH245VideoIndicateCompose *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoIndicateCompose_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245VideoIndicateCompose Encode */
HS_RESULT ASNH245VideoIndicateCompose_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VideoIndicateCompose *pObj = (ASNH245VideoIndicateCompose *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoIndicateCompose_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_compositionNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoIndicateCompose_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245VideoIndicateCompose Decode */
HS_RESULT ASNH245VideoIndicateCompose_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245VideoIndicateCompose *pObj = (ASNH245VideoIndicateCompose *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoIndicateCompose_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_compositionNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoIndicateCompose_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VideoIndicateCompose Print */
HS_RESULT ASNH245VideoIndicateCompose_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VideoIndicateCompose *pObj = (ASNH245VideoIndicateCompose *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VideoIndicateCompose_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_compositionNumber), pDepth+1, "compositionNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245ConferenceIndication Struct
*/
/* ASNH245ConferenceIndication Constructor */
HS_RESULT new_ASNH245ConferenceIndication( void *pObject )
{
	ASNH245ConferenceIndication *pObj = (ASNH245ConferenceIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245ConferenceIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245ConferenceIndicationChoice_sbeNumber;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245ConferenceIndicationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245ConferenceIndication Destructor */
HS_RESULT delete_ASNH245ConferenceIndication( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245ConferenceIndication *pObj = (ASNH245ConferenceIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConferenceIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245ConferenceIndication_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245ConferenceIndication(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245ConferenceIndication SetChoice */
void* ASNH245ConferenceIndication_SetChoice( void *pObject, ASNH245ConferenceIndicationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245ConferenceIndication *pObj = (ASNH245ConferenceIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceIndication_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245ConferenceIndicationChoiceSizeExt ){
		if( pChoice > (ASNH245ConferenceIndicationChoice)(e_ASNH245ConferenceIndicationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245ConferenceIndication_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245ConferenceIndicationChoice_sbeNumber ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,9,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_terminalNumberAssign ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_terminalJoinedConference ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_terminalLeftConference ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_seenByAtLeastOneOther ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAtLeastOneOther ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_seenByAll ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAll ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeing ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_requestForFloor ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_withdrawChairToken ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_floorRequested ){
		ASNH245TerminalLabel *tAlter = (ASNH245TerminalLabel *)HSMalloc( sizeof(ASNH245TerminalLabel) );
		new_ASNH245TerminalLabel(tAlter);
		ASNH245TerminalLabel_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeingInSubPictureNumber ){
		ASNH245TerminalYouAreSeeingInSubPictureNumber *tAlter = (ASNH245TerminalYouAreSeeingInSubPictureNumber *)HSMalloc( sizeof(ASNH245TerminalYouAreSeeingInSubPictureNumber) );
		new_ASNH245TerminalYouAreSeeingInSubPictureNumber(tAlter);
		ASNH245TerminalYouAreSeeingInSubPictureNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245ConferenceIndicationChoice_videoIndicateCompose ){
		ASNH245VideoIndicateCompose *tAlter = (ASNH245VideoIndicateCompose *)HSMalloc( sizeof(ASNH245VideoIndicateCompose) );
		new_ASNH245VideoIndicateCompose(tAlter);
		ASNH245VideoIndicateCompose_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceIndication_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245ConferenceIndication DeleteAlternation */
HS_RESULT ASNH245ConferenceIndication_DeleteAlternation(void *pObject)
{
	ASNH245ConferenceIndication *pObj = (ASNH245ConferenceIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceIndication_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245ConferenceIndicationChoice_sbeNumber ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalNumberAssign ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalJoinedConference ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalLeftConference ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_seenByAtLeastOneOther ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAtLeastOneOther ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_seenByAll ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAll ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeing ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_requestForFloor ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_withdrawChairToken ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_floorRequested ){
			delete_ASNH245TerminalLabel(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeingInSubPictureNumber ){
			delete_ASNH245TerminalYouAreSeeingInSubPictureNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_videoIndicateCompose ){
			delete_ASNH245VideoIndicateCompose(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245ConferenceIndication_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245ConferenceIndication Encode */
HS_RESULT ASNH245ConferenceIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245ConferenceIndication *pObj = (ASNH245ConferenceIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245ConferenceIndicationChoiceSize )
		{
			if( pObj->choice > ((ASNH245ConferenceIndicationChoice)(e_ASNH245ConferenceIndicationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245ConferenceIndicationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245ConferenceIndicationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ConferenceIndicationChoice_sbeNumber ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalNumberAssign ){
		if( (tRet=ASNH245TerminalLabel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalJoinedConference ){
		if( (tRet=ASNH245TerminalLabel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalLeftConference ){
		if( (tRet=ASNH245TerminalLabel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_seenByAtLeastOneOther ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAtLeastOneOther ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_seenByAll ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAll ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeing ){
		if( (tRet=ASNH245TerminalLabel_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_requestForFloor ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_withdrawChairToken ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_floorRequested ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245TerminalLabel_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeingInSubPictureNumber ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245TerminalYouAreSeeingInSubPictureNumber_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_videoIndicateCompose ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245VideoIndicateCompose_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceIndication_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245ConferenceIndication Decode */
HS_RESULT ASNH245ConferenceIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245ConferenceIndication *pObj = (ASNH245ConferenceIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245ConferenceIndicationChoiceSize;
	}
	else
	{
		if( e_ASNH245ConferenceIndicationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245ConferenceIndicationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245ConferenceIndicationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245ConferenceIndication_SetChoice( pObj, (ASNH245ConferenceIndicationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ConferenceIndicationChoice_sbeNumber ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalNumberAssign ){
		if( (tRet=ASNH245TerminalLabel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalJoinedConference ){
		if( (tRet=ASNH245TerminalLabel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalLeftConference ){
		if( (tRet=ASNH245TerminalLabel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_seenByAtLeastOneOther ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAtLeastOneOther ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_seenByAll ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAll ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeing ){
		if( (tRet=ASNH245TerminalLabel_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_requestForFloor ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_withdrawChairToken ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_floorRequested ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245TerminalLabel_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeingInSubPictureNumber ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245TerminalYouAreSeeingInSubPictureNumber_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_videoIndicateCompose ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245VideoIndicateCompose_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245ConferenceIndication_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245ConferenceIndication Print */
HS_RESULT ASNH245ConferenceIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245ConferenceIndication *pObj = (ASNH245ConferenceIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245ConferenceIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245ConferenceIndicationChoice_sbeNumber ){
		AsnInteger_Print( pObj->alter, pDepth+1, "sbeNumber" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalNumberAssign ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "terminalNumberAssign" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalJoinedConference ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "terminalJoinedConference" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalLeftConference ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "terminalLeftConference" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_seenByAtLeastOneOther ){
		AsnNull_Print( pObj->alter, pDepth+1, "seenByAtLeastOneOther" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAtLeastOneOther ){
		AsnNull_Print( pObj->alter, pDepth+1, "cancelSeenByAtLeastOneOther" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_seenByAll ){
		AsnNull_Print( pObj->alter, pDepth+1, "seenByAll" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_cancelSeenByAll ){
		AsnNull_Print( pObj->alter, pDepth+1, "cancelSeenByAll" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeing ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "terminalYouAreSeeing" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_requestForFloor ){
		AsnNull_Print( pObj->alter, pDepth+1, "requestForFloor" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_withdrawChairToken ){
		AsnNull_Print( pObj->alter, pDepth+1, "withdrawChairToken" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_floorRequested ){
		ASNH245TerminalLabel_Print( pObj->alter, pDepth+1, "floorRequested" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_terminalYouAreSeeingInSubPictureNumber ){
		ASNH245TerminalYouAreSeeingInSubPictureNumber_Print( pObj->alter, pDepth+1, "terminalYouAreSeeingInSubPictureNumber" );
	}
	else if ( pObj->choice == e_ASNH245ConferenceIndicationChoice_videoIndicateCompose ){
		ASNH245VideoIndicateCompose_Print( pObj->alter, pDepth+1, "videoIndicateCompose" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VendorIdentification Class
*/
/*ASNH245VendorIdentification Constructor*/
HS_RESULT new_ASNH245VendorIdentification(void *pObject)
{
	ASNH245VendorIdentification *pObj = (ASNH245VendorIdentification *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VendorIdentification(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245NonStandardIdentifier( &(pObj->m_vendor) );
	new_AsnOctetString( &(pObj->m_productNumber), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_versionNumber), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245VendorIdentification Destructor */
HS_RESULT delete_ASNH245VendorIdentification(void *pObject)
{
	ASNH245VendorIdentification *pObj = (ASNH245VendorIdentification *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VendorIdentification(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245NonStandardIdentifier( &(pObj->m_vendor) );
	delete_AsnOctetString( &(pObj->m_productNumber) );
	delete_AsnOctetString( &(pObj->m_versionNumber) );
	return HS_OK;
}

/* ASNH245VendorIdentification MakeMold */
HS_RESULT ASNH245VendorIdentification_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245VendorIdentification *pObj = (ASNH245VendorIdentification *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VendorIdentification_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245NonStandardIdentifier_MakeMold(&(pObj->m_vendor));
	return HS_OK;
}

/* ASNH245VendorIdentification IncludeOptionalField */
HS_RESULT ASNH245VendorIdentification_IncludeOptionField( void *pObject, ASNH245VendorIdentificationOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245VendorIdentification *pObj = (ASNH245VendorIdentification *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VendorIdentification_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245VendorIdentificationOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245VendorIdentification IsIncludeOptionalField */
BOOL ASNH245VendorIdentification_IsIncludeOptionField( void *pObject, ASNH245VendorIdentificationOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245VendorIdentification *pObj = (ASNH245VendorIdentification *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VendorIdentification_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245VendorIdentificationOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245VendorIdentification Encode */
HS_RESULT ASNH245VendorIdentification_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245VendorIdentification *pObj = (ASNH245VendorIdentification *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VendorIdentification_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245VendorIdentificationOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245VendorIdentificationOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245NonStandardIdentifier_Encode( &(pObj->m_vendor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VendorIdentification_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245VendorIdentification_IsIncludeOptionField( pObj, e_ASNH245VendorIdentificationOptionMap_productNumber ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_productNumber),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VendorIdentification_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245VendorIdentification_IsIncludeOptionField( pObj, e_ASNH245VendorIdentificationOptionMap_versionNumber ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_versionNumber),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VendorIdentification_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245VendorIdentification Decode */
HS_RESULT ASNH245VendorIdentification_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245VendorIdentification *pObj = (ASNH245VendorIdentification *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VendorIdentification_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245VendorIdentificationOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245VendorIdentificationOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245NonStandardIdentifier_Decode(&(pObj->m_vendor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VendorIdentification_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245VendorIdentification_IsIncludeOptionField( pObj, e_ASNH245VendorIdentificationOptionMap_productNumber ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_productNumber),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VendorIdentification_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245VendorIdentification_IsIncludeOptionField( pObj, e_ASNH245VendorIdentificationOptionMap_versionNumber ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_versionNumber),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VendorIdentification_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VendorIdentification Print */
HS_RESULT ASNH245VendorIdentification_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VendorIdentification *pObj = (ASNH245VendorIdentification *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VendorIdentification_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245NonStandardIdentifier_Print( &(pObj->m_vendor), pDepth+1, "vendor" );
	if( ASNH245VendorIdentification_IsIncludeOptionField( pObj, e_ASNH245VendorIdentificationOptionMap_productNumber ) )
		AsnOctetString_Print( &(pObj->m_productNumber), pDepth+1, "productNumber" );
	if( ASNH245VendorIdentification_IsIncludeOptionField( pObj, e_ASNH245VendorIdentificationOptionMap_versionNumber ) )
		AsnOctetString_Print( &(pObj->m_versionNumber), pDepth+1, "versionNumber" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245FunctionNotSupported_cause Struct
*/
/* ASNH245FunctionNotSupported_cause Constructor */
HS_RESULT new_ASNH245FunctionNotSupported_cause( void *pObject )
{
	ASNH245FunctionNotSupported_cause *pObj = (ASNH245FunctionNotSupported_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245FunctionNotSupported_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245FunctionNotSupported_causeChoice_syntaxError;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245FunctionNotSupported_causeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245FunctionNotSupported_cause Destructor */
HS_RESULT delete_ASNH245FunctionNotSupported_cause( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245FunctionNotSupported_cause *pObj = (ASNH245FunctionNotSupported_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FunctionNotSupported_cause(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245FunctionNotSupported_cause_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FunctionNotSupported_cause(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245FunctionNotSupported_cause SetChoice */
void* ASNH245FunctionNotSupported_cause_SetChoice( void *pObject, ASNH245FunctionNotSupported_causeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245FunctionNotSupported_cause *pObj = (ASNH245FunctionNotSupported_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245FunctionNotSupported_causeChoiceSizeExt ){
		if( pChoice > (ASNH245FunctionNotSupported_causeChoice)(e_ASNH245FunctionNotSupported_causeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245FunctionNotSupported_cause_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245FunctionNotSupported_causeChoice_syntaxError ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245FunctionNotSupported_causeChoice_semanticError ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245FunctionNotSupported_causeChoice_unknownFunction ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245FunctionNotSupported_cause DeleteAlternation */
HS_RESULT ASNH245FunctionNotSupported_cause_DeleteAlternation(void *pObject)
{
	ASNH245FunctionNotSupported_cause *pObj = (ASNH245FunctionNotSupported_cause *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_syntaxError ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_semanticError ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_unknownFunction ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245FunctionNotSupported_cause_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245FunctionNotSupported_cause Encode */
HS_RESULT ASNH245FunctionNotSupported_cause_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245FunctionNotSupported_cause *pObj = (ASNH245FunctionNotSupported_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245FunctionNotSupported_causeChoiceSize )
		{
			if( pObj->choice > ((ASNH245FunctionNotSupported_causeChoice)(e_ASNH245FunctionNotSupported_causeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245FunctionNotSupported_causeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245FunctionNotSupported_causeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_syntaxError ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_semanticError ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_unknownFunction ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245FunctionNotSupported_cause Decode */
HS_RESULT ASNH245FunctionNotSupported_cause_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245FunctionNotSupported_cause *pObj = (ASNH245FunctionNotSupported_cause *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245FunctionNotSupported_causeChoiceSize;
	}
	else
	{
		if( e_ASNH245FunctionNotSupported_causeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245FunctionNotSupported_causeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245FunctionNotSupported_causeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245FunctionNotSupported_cause_SetChoice( pObj, (ASNH245FunctionNotSupported_causeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_syntaxError ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_semanticError ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_unknownFunction ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245FunctionNotSupported_cause Print */
HS_RESULT ASNH245FunctionNotSupported_cause_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245FunctionNotSupported_cause *pObj = (ASNH245FunctionNotSupported_cause *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245FunctionNotSupported_cause_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_syntaxError ){
		AsnNull_Print( pObj->alter, pDepth+1, "syntaxError" );
	}
	else if ( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_semanticError ){
		AsnNull_Print( pObj->alter, pDepth+1, "semanticError" );
	}
	else if ( pObj->choice == e_ASNH245FunctionNotSupported_causeChoice_unknownFunction ){
		AsnNull_Print( pObj->alter, pDepth+1, "unknownFunction" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245FunctionNotSupported Class
*/
/*ASNH245FunctionNotSupported Constructor*/
HS_RESULT new_ASNH245FunctionNotSupported(void *pObject)
{
	ASNH245FunctionNotSupported *pObj = (ASNH245FunctionNotSupported *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245FunctionNotSupported(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245FunctionNotSupported_cause( &(pObj->m_cause) );
	new_AsnOctetString( &(pObj->m_returnedFunction), e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245FunctionNotSupported Destructor */
HS_RESULT delete_ASNH245FunctionNotSupported(void *pObject)
{
	ASNH245FunctionNotSupported *pObj = (ASNH245FunctionNotSupported *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FunctionNotSupported(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245FunctionNotSupported_cause( &(pObj->m_cause) );
	delete_AsnOctetString( &(pObj->m_returnedFunction) );
	return HS_OK;
}

/* ASNH245FunctionNotSupported MakeMold */
HS_RESULT ASNH245FunctionNotSupported_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245FunctionNotSupported *pObj = (ASNH245FunctionNotSupported *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245FunctionNotSupported IncludeOptionalField */
HS_RESULT ASNH245FunctionNotSupported_IncludeOptionField( void *pObject, ASNH245FunctionNotSupportedOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245FunctionNotSupported *pObj = (ASNH245FunctionNotSupported *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245FunctionNotSupportedOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245FunctionNotSupported IsIncludeOptionalField */
BOOL ASNH245FunctionNotSupported_IsIncludeOptionField( void *pObject, ASNH245FunctionNotSupportedOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245FunctionNotSupported *pObj = (ASNH245FunctionNotSupported *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245FunctionNotSupportedOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245FunctionNotSupported Encode */
HS_RESULT ASNH245FunctionNotSupported_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245FunctionNotSupported *pObj = (ASNH245FunctionNotSupported *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245FunctionNotSupportedOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245FunctionNotSupportedOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245FunctionNotSupported_cause_Encode( &(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245FunctionNotSupported_IsIncludeOptionField( pObj, e_ASNH245FunctionNotSupportedOptionMap_returnedFunction ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_returnedFunction),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245FunctionNotSupported Decode */
HS_RESULT ASNH245FunctionNotSupported_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245FunctionNotSupported *pObj = (ASNH245FunctionNotSupported *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245FunctionNotSupportedOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245FunctionNotSupportedOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245FunctionNotSupported_cause_Decode(&(pObj->m_cause),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FunctionNotSupported_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245FunctionNotSupported_IsIncludeOptionField( pObj, e_ASNH245FunctionNotSupportedOptionMap_returnedFunction ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_returnedFunction),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FunctionNotSupported_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245FunctionNotSupported Print */
HS_RESULT ASNH245FunctionNotSupported_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245FunctionNotSupported *pObj = (ASNH245FunctionNotSupported *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245FunctionNotSupported_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245FunctionNotSupported_cause_Print( &(pObj->m_cause), pDepth+1, "cause" );
	if( ASNH245FunctionNotSupported_IsIncludeOptionField( pObj, e_ASNH245FunctionNotSupportedOptionMap_returnedFunction ) )
		AsnOctetString_Print( &(pObj->m_returnedFunction), pDepth+1, "returnedFunction" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultilinkIndication_crcDesired Class
*/
/*ASNH245MultilinkIndication_crcDesired Constructor*/
HS_RESULT new_ASNH245MultilinkIndication_crcDesired(void *pObject)
{
	ASNH245MultilinkIndication_crcDesired *pObj = (ASNH245MultilinkIndication_crcDesired *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultilinkIndication_crcDesired(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;

	return HS_OK;
}

/* ASNH245MultilinkIndication_crcDesired Destructor */
HS_RESULT delete_ASNH245MultilinkIndication_crcDesired(void *pObject)
{
	ASNH245MultilinkIndication_crcDesired *pObj = (ASNH245MultilinkIndication_crcDesired *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkIndication_crcDesired(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return HS_OK;
}

/* ASNH245MultilinkIndication_crcDesired MakeMold */
HS_RESULT ASNH245MultilinkIndication_crcDesired_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultilinkIndication_crcDesired *pObj = (ASNH245MultilinkIndication_crcDesired *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_crcDesired_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MultilinkIndication_crcDesired Encode */
HS_RESULT ASNH245MultilinkIndication_crcDesired_Encode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245MultilinkIndication_crcDesired *pObj = (ASNH245MultilinkIndication_crcDesired *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_crcDesired_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );


	return HS_OK;
}

/* ASNH245MultilinkIndication_crcDesired Decode */
HS_RESULT ASNH245MultilinkIndication_crcDesired_Decode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245MultilinkIndication_crcDesired *pObj = (ASNH245MultilinkIndication_crcDesired *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_crcDesired_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultilinkIndication_crcDesired Print */
HS_RESULT ASNH245MultilinkIndication_crcDesired_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultilinkIndication_crcDesired *pObj = (ASNH245MultilinkIndication_crcDesired *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultilinkIndication_crcDesired_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultilinkIndication_excessiveError Class
*/
/*ASNH245MultilinkIndication_excessiveError Constructor*/
HS_RESULT new_ASNH245MultilinkIndication_excessiveError(void *pObject)
{
	ASNH245MultilinkIndication_excessiveError *pObj = (ASNH245MultilinkIndication_excessiveError *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultilinkIndication_excessiveError(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245ConnectionIdentifier( &(pObj->m_connectionIdentifier) );

	return HS_OK;
}

/* ASNH245MultilinkIndication_excessiveError Destructor */
HS_RESULT delete_ASNH245MultilinkIndication_excessiveError(void *pObject)
{
	ASNH245MultilinkIndication_excessiveError *pObj = (ASNH245MultilinkIndication_excessiveError *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkIndication_excessiveError(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245ConnectionIdentifier( &(pObj->m_connectionIdentifier) );
	return HS_OK;
}

/* ASNH245MultilinkIndication_excessiveError MakeMold */
HS_RESULT ASNH245MultilinkIndication_excessiveError_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MultilinkIndication_excessiveError *pObj = (ASNH245MultilinkIndication_excessiveError *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_excessiveError_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245ConnectionIdentifier_MakeMold(&(pObj->m_connectionIdentifier));
	return HS_OK;
}

/* ASNH245MultilinkIndication_excessiveError Encode */
HS_RESULT ASNH245MultilinkIndication_excessiveError_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkIndication_excessiveError *pObj = (ASNH245MultilinkIndication_excessiveError *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_excessiveError_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245ConnectionIdentifier_Encode( &(pObj->m_connectionIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_excessiveError_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MultilinkIndication_excessiveError Decode */
HS_RESULT ASNH245MultilinkIndication_excessiveError_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MultilinkIndication_excessiveError *pObj = (ASNH245MultilinkIndication_excessiveError *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_excessiveError_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245ConnectionIdentifier_Decode(&(pObj->m_connectionIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_excessiveError_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultilinkIndication_excessiveError Print */
HS_RESULT ASNH245MultilinkIndication_excessiveError_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultilinkIndication_excessiveError *pObj = (ASNH245MultilinkIndication_excessiveError *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultilinkIndication_excessiveError_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245ConnectionIdentifier_Print( &(pObj->m_connectionIdentifier), pDepth+1, "connectionIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultilinkIndication Struct
*/
/* ASNH245MultilinkIndication Constructor */
HS_RESULT new_ASNH245MultilinkIndication( void *pObject )
{
	ASNH245MultilinkIndication *pObj = (ASNH245MultilinkIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultilinkIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MultilinkIndicationChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MultilinkIndicationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MultilinkIndication Destructor */
HS_RESULT delete_ASNH245MultilinkIndication( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MultilinkIndication *pObj = (ASNH245MultilinkIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MultilinkIndication_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultilinkIndication(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MultilinkIndication SetChoice */
void* ASNH245MultilinkIndication_SetChoice( void *pObject, ASNH245MultilinkIndicationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MultilinkIndication *pObj = (ASNH245MultilinkIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MultilinkIndicationChoiceSizeExt ){
		if( pChoice > (ASNH245MultilinkIndicationChoice)(e_ASNH245MultilinkIndicationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MultilinkIndication_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MultilinkIndicationChoice_nonStandard ){
		ASNH245NonStandardMessage *tAlter = (ASNH245NonStandardMessage *)HSMalloc( sizeof(ASNH245NonStandardMessage) );
		new_ASNH245NonStandardMessage(tAlter);
		ASNH245NonStandardMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultilinkIndicationChoice_crcDesired ){
		ASNH245MultilinkIndication_crcDesired *tAlter = (ASNH245MultilinkIndication_crcDesired *)HSMalloc( sizeof(ASNH245MultilinkIndication_crcDesired) );
		new_ASNH245MultilinkIndication_crcDesired(tAlter);
		ASNH245MultilinkIndication_crcDesired_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultilinkIndicationChoice_excessiveError ){
		ASNH245MultilinkIndication_excessiveError *tAlter = (ASNH245MultilinkIndication_excessiveError *)HSMalloc( sizeof(ASNH245MultilinkIndication_excessiveError) );
		new_ASNH245MultilinkIndication_excessiveError(tAlter);
		ASNH245MultilinkIndication_excessiveError_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MultilinkIndication DeleteAlternation */
HS_RESULT ASNH245MultilinkIndication_DeleteAlternation(void *pObject)
{
	ASNH245MultilinkIndication *pObj = (ASNH245MultilinkIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MultilinkIndicationChoice_nonStandard ){
			delete_ASNH245NonStandardMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultilinkIndicationChoice_crcDesired ){
			delete_ASNH245MultilinkIndication_crcDesired(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultilinkIndicationChoice_excessiveError ){
			delete_ASNH245MultilinkIndication_excessiveError(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MultilinkIndication_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MultilinkIndication Encode */
HS_RESULT ASNH245MultilinkIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MultilinkIndication *pObj = (ASNH245MultilinkIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MultilinkIndicationChoiceSize )
		{
			if( pObj->choice > ((ASNH245MultilinkIndicationChoice)(e_ASNH245MultilinkIndicationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MultilinkIndicationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MultilinkIndicationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultilinkIndicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkIndicationChoice_crcDesired ){
		if( (tRet=ASNH245MultilinkIndication_crcDesired_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkIndicationChoice_excessiveError ){
		if( (tRet=ASNH245MultilinkIndication_excessiveError_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MultilinkIndication Decode */
HS_RESULT ASNH245MultilinkIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MultilinkIndication *pObj = (ASNH245MultilinkIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MultilinkIndicationChoiceSize;
	}
	else
	{
		if( e_ASNH245MultilinkIndicationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MultilinkIndicationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MultilinkIndicationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MultilinkIndication_SetChoice( pObj, (ASNH245MultilinkIndicationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultilinkIndicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkIndicationChoice_crcDesired ){
		if( (tRet=ASNH245MultilinkIndication_crcDesired_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultilinkIndicationChoice_excessiveError ){
		if( (tRet=ASNH245MultilinkIndication_excessiveError_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultilinkIndication_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultilinkIndication_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultilinkIndication Print */
HS_RESULT ASNH245MultilinkIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultilinkIndication *pObj = (ASNH245MultilinkIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultilinkIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultilinkIndicationChoice_nonStandard ){
		ASNH245NonStandardMessage_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245MultilinkIndicationChoice_crcDesired ){
		ASNH245MultilinkIndication_crcDesired_Print( pObj->alter, pDepth+1, "crcDesired" );
	}
	else if ( pObj->choice == e_ASNH245MultilinkIndicationChoice_excessiveError ){
		ASNH245MultilinkIndication_excessiveError_Print( pObj->alter, pDepth+1, "excessiveError" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245LogicalChannelRateRelease Class
*/
/*ASNH245LogicalChannelRateRelease Constructor*/
HS_RESULT new_ASNH245LogicalChannelRateRelease(void *pObject)
{
	ASNH245LogicalChannelRateRelease *pObj = (ASNH245LogicalChannelRateRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245LogicalChannelRateRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;

	return HS_OK;
}

/* ASNH245LogicalChannelRateRelease Destructor */
HS_RESULT delete_ASNH245LogicalChannelRateRelease(void *pObject)
{
	ASNH245LogicalChannelRateRelease *pObj = (ASNH245LogicalChannelRateRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245LogicalChannelRateRelease(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return HS_OK;
}

/* ASNH245LogicalChannelRateRelease MakeMold */
HS_RESULT ASNH245LogicalChannelRateRelease_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245LogicalChannelRateRelease *pObj = (ASNH245LogicalChannelRateRelease *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRelease_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245LogicalChannelRateRelease Encode */
HS_RESULT ASNH245LogicalChannelRateRelease_Encode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245LogicalChannelRateRelease *pObj = (ASNH245LogicalChannelRateRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRelease_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );


	return HS_OK;
}

/* ASNH245LogicalChannelRateRelease Decode */
HS_RESULT ASNH245LogicalChannelRateRelease_Decode( void *pObject, AsnStream *pStrm )
{
	
	ASNH245LogicalChannelRateRelease *pObj = (ASNH245LogicalChannelRateRelease *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245LogicalChannelRateRelease_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245LogicalChannelRateRelease Print */
HS_RESULT ASNH245LogicalChannelRateRelease_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245LogicalChannelRateRelease *pObj = (ASNH245LogicalChannelRateRelease *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245LogicalChannelRateRelease_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245FlowControlIndication_scope Struct
*/
/* ASNH245FlowControlIndication_scope Constructor */
HS_RESULT new_ASNH245FlowControlIndication_scope( void *pObject )
{
	ASNH245FlowControlIndication_scope *pObj = (ASNH245FlowControlIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245FlowControlIndication_scope(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245FlowControlIndication_scopeChoice_logicalChannelNumber;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245FlowControlIndication_scopeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245FlowControlIndication_scope Destructor */
HS_RESULT delete_ASNH245FlowControlIndication_scope( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245FlowControlIndication_scope *pObj = (ASNH245FlowControlIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FlowControlIndication_scope(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245FlowControlIndication_scope_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FlowControlIndication_scope(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245FlowControlIndication_scope SetChoice */
void* ASNH245FlowControlIndication_scope_SetChoice( void *pObject, ASNH245FlowControlIndication_scopeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245FlowControlIndication_scope *pObj = (ASNH245FlowControlIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245FlowControlIndication_scopeChoiceSizeExt ){
		if( pChoice > (ASNH245FlowControlIndication_scopeChoice)(e_ASNH245FlowControlIndication_scopeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245FlowControlIndication_scope_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245FlowControlIndication_scopeChoice_logicalChannelNumber ){
		ASNH245LogicalChannelNumber *tAlter = (ASNH245LogicalChannelNumber *)HSMalloc( sizeof(ASNH245LogicalChannelNumber) );
		new_ASNH245LogicalChannelNumber(tAlter);
		ASNH245LogicalChannelNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245FlowControlIndication_scopeChoice_resourceID ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245FlowControlIndication_scopeChoice_wholeMultiplex ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245FlowControlIndication_scope DeleteAlternation */
HS_RESULT ASNH245FlowControlIndication_scope_DeleteAlternation(void *pObject)
{
	ASNH245FlowControlIndication_scope *pObj = (ASNH245FlowControlIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_logicalChannelNumber ){
			delete_ASNH245LogicalChannelNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_resourceID ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_wholeMultiplex ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245FlowControlIndication_scope_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245FlowControlIndication_scope Encode */
HS_RESULT ASNH245FlowControlIndication_scope_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245FlowControlIndication_scope *pObj = (ASNH245FlowControlIndication_scope *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245FlowControlIndication_scopeChoiceSize )
		{
			if( pObj->choice > ((ASNH245FlowControlIndication_scopeChoice)(e_ASNH245FlowControlIndication_scopeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245FlowControlIndication_scopeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245FlowControlIndication_scopeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_logicalChannelNumber ){
		if( (tRet=ASNH245LogicalChannelNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_resourceID ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_wholeMultiplex ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245FlowControlIndication_scope Decode */
HS_RESULT ASNH245FlowControlIndication_scope_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245FlowControlIndication_scope *pObj = (ASNH245FlowControlIndication_scope *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245FlowControlIndication_scopeChoiceSize;
	}
	else
	{
		if( e_ASNH245FlowControlIndication_scopeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245FlowControlIndication_scopeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245FlowControlIndication_scopeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245FlowControlIndication_scope_SetChoice( pObj, (ASNH245FlowControlIndication_scopeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_logicalChannelNumber ){
		if( (tRet=ASNH245LogicalChannelNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_resourceID ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_wholeMultiplex ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245FlowControlIndication_scope Print */
HS_RESULT ASNH245FlowControlIndication_scope_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245FlowControlIndication_scope *pObj = (ASNH245FlowControlIndication_scope *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245FlowControlIndication_scope_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_logicalChannelNumber ){
		ASNH245LogicalChannelNumber_Print( pObj->alter, pDepth+1, "logicalChannelNumber" );
	}
	else if ( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_resourceID ){
		AsnInteger_Print( pObj->alter, pDepth+1, "resourceID" );
	}
	else if ( pObj->choice == e_ASNH245FlowControlIndication_scopeChoice_wholeMultiplex ){
		AsnNull_Print( pObj->alter, pDepth+1, "wholeMultiplex" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245FlowControlIndication_restriction Struct
*/
/* ASNH245FlowControlIndication_restriction Constructor */
HS_RESULT new_ASNH245FlowControlIndication_restriction( void *pObject )
{
	ASNH245FlowControlIndication_restriction *pObj = (ASNH245FlowControlIndication_restriction *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245FlowControlIndication_restriction(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245FlowControlIndication_restrictionChoice_maximumBitRate;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245FlowControlIndication_restrictionChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245FlowControlIndication_restriction Destructor */
HS_RESULT delete_ASNH245FlowControlIndication_restriction( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245FlowControlIndication_restriction *pObj = (ASNH245FlowControlIndication_restriction *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FlowControlIndication_restriction(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245FlowControlIndication_restriction_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FlowControlIndication_restriction(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245FlowControlIndication_restriction SetChoice */
void* ASNH245FlowControlIndication_restriction_SetChoice( void *pObject, ASNH245FlowControlIndication_restrictionChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245FlowControlIndication_restriction *pObj = (ASNH245FlowControlIndication_restriction *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245FlowControlIndication_restrictionChoiceSizeExt ){
		if( pChoice > (ASNH245FlowControlIndication_restrictionChoice)(e_ASNH245FlowControlIndication_restrictionChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245FlowControlIndication_restriction_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245FlowControlIndication_restrictionChoice_maximumBitRate ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,16777215,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245FlowControlIndication_restrictionChoice_noRestriction ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245FlowControlIndication_restriction DeleteAlternation */
HS_RESULT ASNH245FlowControlIndication_restriction_DeleteAlternation(void *pObject)
{
	ASNH245FlowControlIndication_restriction *pObj = (ASNH245FlowControlIndication_restriction *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245FlowControlIndication_restrictionChoice_maximumBitRate ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245FlowControlIndication_restrictionChoice_noRestriction ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245FlowControlIndication_restriction_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245FlowControlIndication_restriction Encode */
HS_RESULT ASNH245FlowControlIndication_restriction_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245FlowControlIndication_restriction *pObj = (ASNH245FlowControlIndication_restriction *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245FlowControlIndication_restrictionChoiceSize )
		{
			if( pObj->choice > ((ASNH245FlowControlIndication_restrictionChoice)(e_ASNH245FlowControlIndication_restrictionChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245FlowControlIndication_restrictionChoiceSize)) )
	}
	else
	{
		if( e_ASNH245FlowControlIndication_restrictionChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FlowControlIndication_restrictionChoice_maximumBitRate ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FlowControlIndication_restrictionChoice_noRestriction ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245FlowControlIndication_restriction Decode */
HS_RESULT ASNH245FlowControlIndication_restriction_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245FlowControlIndication_restriction *pObj = (ASNH245FlowControlIndication_restriction *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245FlowControlIndication_restrictionChoiceSize;
	}
	else
	{
		if( e_ASNH245FlowControlIndication_restrictionChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245FlowControlIndication_restrictionChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245FlowControlIndication_restrictionChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245FlowControlIndication_restriction_SetChoice( pObj, (ASNH245FlowControlIndication_restrictionChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FlowControlIndication_restrictionChoice_maximumBitRate ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245FlowControlIndication_restrictionChoice_noRestriction ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245FlowControlIndication_restriction Print */
HS_RESULT ASNH245FlowControlIndication_restriction_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245FlowControlIndication_restriction *pObj = (ASNH245FlowControlIndication_restriction *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245FlowControlIndication_restriction_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245FlowControlIndication_restrictionChoice_maximumBitRate ){
		AsnInteger_Print( pObj->alter, pDepth+1, "maximumBitRate" );
	}
	else if ( pObj->choice == e_ASNH245FlowControlIndication_restrictionChoice_noRestriction ){
		AsnNull_Print( pObj->alter, pDepth+1, "noRestriction" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245FlowControlIndication Class
*/
/*ASNH245FlowControlIndication Constructor*/
HS_RESULT new_ASNH245FlowControlIndication(void *pObject)
{
	ASNH245FlowControlIndication *pObj = (ASNH245FlowControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245FlowControlIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245FlowControlIndication_scope( &(pObj->m_scope) );
	new_ASNH245FlowControlIndication_restriction( &(pObj->m_restriction) );

	return HS_OK;
}

/* ASNH245FlowControlIndication Destructor */
HS_RESULT delete_ASNH245FlowControlIndication(void *pObject)
{
	ASNH245FlowControlIndication *pObj = (ASNH245FlowControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245FlowControlIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245FlowControlIndication_scope( &(pObj->m_scope) );
	delete_ASNH245FlowControlIndication_restriction( &(pObj->m_restriction) );
	return HS_OK;
}

/* ASNH245FlowControlIndication MakeMold */
HS_RESULT ASNH245FlowControlIndication_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245FlowControlIndication *pObj = (ASNH245FlowControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245FlowControlIndication Encode */
HS_RESULT ASNH245FlowControlIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245FlowControlIndication *pObj = (ASNH245FlowControlIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245FlowControlIndication_scope_Encode( &(pObj->m_scope),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245FlowControlIndication_restriction_Encode( &(pObj->m_restriction),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245FlowControlIndication Decode */
HS_RESULT ASNH245FlowControlIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245FlowControlIndication *pObj = (ASNH245FlowControlIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245FlowControlIndication_scope_Decode(&(pObj->m_scope),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245FlowControlIndication_restriction_Decode(&(pObj->m_restriction),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245FlowControlIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245FlowControlIndication Print */
HS_RESULT ASNH245FlowControlIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245FlowControlIndication *pObj = (ASNH245FlowControlIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245FlowControlIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245FlowControlIndication_scope_Print( &(pObj->m_scope), pDepth+1, "scope" );
	ASNH245FlowControlIndication_restriction_Print( &(pObj->m_restriction), pDepth+1, "restriction" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MobileMultilinkReconfigurationIndication Class
*/
/*ASNH245MobileMultilinkReconfigurationIndication Constructor*/
HS_RESULT new_ASNH245MobileMultilinkReconfigurationIndication(void *pObject)
{
	ASNH245MobileMultilinkReconfigurationIndication *pObj = (ASNH245MobileMultilinkReconfigurationIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MobileMultilinkReconfigurationIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_sampleSize), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_samplesPerFrame), e_constrained, 1, 255, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245MobileMultilinkReconfigurationIndication Destructor */
HS_RESULT delete_ASNH245MobileMultilinkReconfigurationIndication(void *pObject)
{
	ASNH245MobileMultilinkReconfigurationIndication *pObj = (ASNH245MobileMultilinkReconfigurationIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MobileMultilinkReconfigurationIndication(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_sampleSize) );
	delete_AsnInteger( &(pObj->m_samplesPerFrame) );
	return HS_OK;
}

/* ASNH245MobileMultilinkReconfigurationIndication MakeMold */
HS_RESULT ASNH245MobileMultilinkReconfigurationIndication_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245MobileMultilinkReconfigurationIndication *pObj = (ASNH245MobileMultilinkReconfigurationIndication *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationIndication_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245MobileMultilinkReconfigurationIndication Encode */
HS_RESULT ASNH245MobileMultilinkReconfigurationIndication_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MobileMultilinkReconfigurationIndication *pObj = (ASNH245MobileMultilinkReconfigurationIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationIndication_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_sampleSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_samplesPerFrame),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationIndication_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245MobileMultilinkReconfigurationIndication Decode */
HS_RESULT ASNH245MobileMultilinkReconfigurationIndication_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245MobileMultilinkReconfigurationIndication *pObj = (ASNH245MobileMultilinkReconfigurationIndication *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationIndication_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_sampleSize),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_samplesPerFrame),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationIndication_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MobileMultilinkReconfigurationIndication Print */
HS_RESULT ASNH245MobileMultilinkReconfigurationIndication_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MobileMultilinkReconfigurationIndication *pObj = (ASNH245MobileMultilinkReconfigurationIndication *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MobileMultilinkReconfigurationIndication_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_sampleSize), pDepth+1, "sampleSize" );
	AsnInteger_Print( &(pObj->m_samplesPerFrame), pDepth+1, "samplesPerFrame" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IndicationMessage Struct
*/
/* ASNH245IndicationMessage Constructor */
HS_RESULT new_ASNH245IndicationMessage( void *pObject )
{
	ASNH245IndicationMessage *pObj = (ASNH245IndicationMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IndicationMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245IndicationMessageChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245IndicationMessageChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245IndicationMessage Destructor */
HS_RESULT delete_ASNH245IndicationMessage( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245IndicationMessage *pObj = (ASNH245IndicationMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IndicationMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245IndicationMessage_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IndicationMessage(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245IndicationMessage SetChoice */
void* ASNH245IndicationMessage_SetChoice( void *pObject, ASNH245IndicationMessageChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245IndicationMessage *pObj = (ASNH245IndicationMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IndicationMessage_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245IndicationMessageChoiceSizeExt ){
		if( pChoice > (ASNH245IndicationMessageChoice)(e_ASNH245IndicationMessageChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245IndicationMessage_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245IndicationMessageChoice_nonStandard ){
		ASNH245NonStandardMessage *tAlter = (ASNH245NonStandardMessage *)HSMalloc( sizeof(ASNH245NonStandardMessage) );
		new_ASNH245NonStandardMessage(tAlter);
		ASNH245NonStandardMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_functionNotUnderstood ){
		ASNH245FunctionNotUnderstood *tAlter = (ASNH245FunctionNotUnderstood *)HSMalloc( sizeof(ASNH245FunctionNotUnderstood) );
		new_ASNH245FunctionNotUnderstood(tAlter);
		ASNH245FunctionNotUnderstood_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_masterSlaveDeterminationRelease ){
		ASNH245MasterSlaveDeterminationRelease *tAlter = (ASNH245MasterSlaveDeterminationRelease *)HSMalloc( sizeof(ASNH245MasterSlaveDeterminationRelease) );
		new_ASNH245MasterSlaveDeterminationRelease(tAlter);
		ASNH245MasterSlaveDeterminationRelease_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_terminalCapabilitySetRelease ){
		ASNH245TerminalCapabilitySetRelease *tAlter = (ASNH245TerminalCapabilitySetRelease *)HSMalloc( sizeof(ASNH245TerminalCapabilitySetRelease) );
		new_ASNH245TerminalCapabilitySetRelease(tAlter);
		ASNH245TerminalCapabilitySetRelease_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_openLogicalChannelConfirm ){
		ASNH245OpenLogicalChannelConfirm *tAlter = (ASNH245OpenLogicalChannelConfirm *)HSMalloc( sizeof(ASNH245OpenLogicalChannelConfirm) );
		new_ASNH245OpenLogicalChannelConfirm(tAlter);
		ASNH245OpenLogicalChannelConfirm_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_requestChannelCloseRelease ){
		ASNH245RequestChannelCloseRelease *tAlter = (ASNH245RequestChannelCloseRelease *)HSMalloc( sizeof(ASNH245RequestChannelCloseRelease) );
		new_ASNH245RequestChannelCloseRelease(tAlter);
		ASNH245RequestChannelCloseRelease_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_multiplexEntrySendRelease ){
		ASNH245MultiplexEntrySendRelease *tAlter = (ASNH245MultiplexEntrySendRelease *)HSMalloc( sizeof(ASNH245MultiplexEntrySendRelease) );
		new_ASNH245MultiplexEntrySendRelease(tAlter);
		ASNH245MultiplexEntrySendRelease_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_requestMultiplexEntryRelease ){
		ASNH245RequestMultiplexEntryRelease *tAlter = (ASNH245RequestMultiplexEntryRelease *)HSMalloc( sizeof(ASNH245RequestMultiplexEntryRelease) );
		new_ASNH245RequestMultiplexEntryRelease(tAlter);
		ASNH245RequestMultiplexEntryRelease_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_requestModeRelease ){
		ASNH245RequestModeRelease *tAlter = (ASNH245RequestModeRelease *)HSMalloc( sizeof(ASNH245RequestModeRelease) );
		new_ASNH245RequestModeRelease(tAlter);
		ASNH245RequestModeRelease_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_miscellaneousIndication ){
		ASNH245MiscellaneousIndication *tAlter = (ASNH245MiscellaneousIndication *)HSMalloc( sizeof(ASNH245MiscellaneousIndication) );
		new_ASNH245MiscellaneousIndication(tAlter);
		ASNH245MiscellaneousIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_jitterIndication ){
		ASNH245JitterIndication *tAlter = (ASNH245JitterIndication *)HSMalloc( sizeof(ASNH245JitterIndication) );
		new_ASNH245JitterIndication(tAlter);
		ASNH245JitterIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_h223SkewIndication ){
		ASNH245H223SkewIndication *tAlter = (ASNH245H223SkewIndication *)HSMalloc( sizeof(ASNH245H223SkewIndication) );
		new_ASNH245H223SkewIndication(tAlter);
		ASNH245H223SkewIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_newATMVCIndication ){
		ASNH245NewATMVCIndication *tAlter = (ASNH245NewATMVCIndication *)HSMalloc( sizeof(ASNH245NewATMVCIndication) );
		new_ASNH245NewATMVCIndication(tAlter);
		ASNH245NewATMVCIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_userInput ){
		ASNH245UserInputIndication *tAlter = (ASNH245UserInputIndication *)HSMalloc( sizeof(ASNH245UserInputIndication) );
		new_ASNH245UserInputIndication(tAlter);
		ASNH245UserInputIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245IndicationMessageChoice_h2250MaximumSkewIndication ){
		ASNH245H2250MaximumSkewIndication *tAlter = (ASNH245H2250MaximumSkewIndication *)HSMalloc( sizeof(ASNH245H2250MaximumSkewIndication) );
		new_ASNH245H2250MaximumSkewIndication(tAlter);
		ASNH245H2250MaximumSkewIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_mcLocationIndication ){
		ASNH245MCLocationIndication *tAlter = (ASNH245MCLocationIndication *)HSMalloc( sizeof(ASNH245MCLocationIndication) );
		new_ASNH245MCLocationIndication(tAlter);
		ASNH245MCLocationIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_conferenceIndication ){
		ASNH245ConferenceIndication *tAlter = (ASNH245ConferenceIndication *)HSMalloc( sizeof(ASNH245ConferenceIndication) );
		new_ASNH245ConferenceIndication(tAlter);
		ASNH245ConferenceIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_vendorIdentification ){
		ASNH245VendorIdentification *tAlter = (ASNH245VendorIdentification *)HSMalloc( sizeof(ASNH245VendorIdentification) );
		new_ASNH245VendorIdentification(tAlter);
		ASNH245VendorIdentification_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_functionNotSupported ){
		ASNH245FunctionNotSupported *tAlter = (ASNH245FunctionNotSupported *)HSMalloc( sizeof(ASNH245FunctionNotSupported) );
		new_ASNH245FunctionNotSupported(tAlter);
		ASNH245FunctionNotSupported_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_multilinkIndication ){
		ASNH245MultilinkIndication *tAlter = (ASNH245MultilinkIndication *)HSMalloc( sizeof(ASNH245MultilinkIndication) );
		new_ASNH245MultilinkIndication(tAlter);
		ASNH245MultilinkIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_logicalChannelRateRelease ){
		ASNH245LogicalChannelRateRelease *tAlter = (ASNH245LogicalChannelRateRelease *)HSMalloc( sizeof(ASNH245LogicalChannelRateRelease) );
		new_ASNH245LogicalChannelRateRelease(tAlter);
		ASNH245LogicalChannelRateRelease_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_flowControlIndication ){
		ASNH245FlowControlIndication *tAlter = (ASNH245FlowControlIndication *)HSMalloc( sizeof(ASNH245FlowControlIndication) );
		new_ASNH245FlowControlIndication(tAlter);
		ASNH245FlowControlIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IndicationMessageChoice_mobileMultilinkReconfigurationIndication ){
		ASNH245MobileMultilinkReconfigurationIndication *tAlter = (ASNH245MobileMultilinkReconfigurationIndication *)HSMalloc( sizeof(ASNH245MobileMultilinkReconfigurationIndication) );
		new_ASNH245MobileMultilinkReconfigurationIndication(tAlter);
		ASNH245MobileMultilinkReconfigurationIndication_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IndicationMessage_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245IndicationMessage DeleteAlternation */
HS_RESULT ASNH245IndicationMessage_DeleteAlternation(void *pObject)
{
	ASNH245IndicationMessage *pObj = (ASNH245IndicationMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IndicationMessage_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245IndicationMessageChoice_nonStandard ){
			delete_ASNH245NonStandardMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_functionNotUnderstood ){
			delete_ASNH245FunctionNotUnderstood(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_masterSlaveDeterminationRelease ){
			delete_ASNH245MasterSlaveDeterminationRelease(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_terminalCapabilitySetRelease ){
			delete_ASNH245TerminalCapabilitySetRelease(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_openLogicalChannelConfirm ){
			delete_ASNH245OpenLogicalChannelConfirm(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestChannelCloseRelease ){
			delete_ASNH245RequestChannelCloseRelease(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_multiplexEntrySendRelease ){
			delete_ASNH245MultiplexEntrySendRelease(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestMultiplexEntryRelease ){
			delete_ASNH245RequestMultiplexEntryRelease(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestModeRelease ){
			delete_ASNH245RequestModeRelease(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_miscellaneousIndication ){
			delete_ASNH245MiscellaneousIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_jitterIndication ){
			delete_ASNH245JitterIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_h223SkewIndication ){
			delete_ASNH245H223SkewIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_newATMVCIndication ){
			delete_ASNH245NewATMVCIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_userInput ){
			delete_ASNH245UserInputIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_h2250MaximumSkewIndication ){
			delete_ASNH245H2250MaximumSkewIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_mcLocationIndication ){
			delete_ASNH245MCLocationIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_conferenceIndication ){
			delete_ASNH245ConferenceIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_vendorIdentification ){
			delete_ASNH245VendorIdentification(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_functionNotSupported ){
			delete_ASNH245FunctionNotSupported(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_multilinkIndication ){
			delete_ASNH245MultilinkIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_logicalChannelRateRelease ){
			delete_ASNH245LogicalChannelRateRelease(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_flowControlIndication ){
			delete_ASNH245FlowControlIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IndicationMessageChoice_mobileMultilinkReconfigurationIndication ){
			delete_ASNH245MobileMultilinkReconfigurationIndication(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245IndicationMessage_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245IndicationMessage Encode */
HS_RESULT ASNH245IndicationMessage_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245IndicationMessage *pObj = (ASNH245IndicationMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IndicationMessage_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245IndicationMessageChoiceSize )
		{
			if( pObj->choice > ((ASNH245IndicationMessageChoice)(e_ASNH245IndicationMessageChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245IndicationMessageChoiceSize)) )
	}
	else
	{
		if( e_ASNH245IndicationMessageChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IndicationMessageChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_functionNotUnderstood ){
		if( (tRet=ASNH245FunctionNotUnderstood_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_masterSlaveDeterminationRelease ){
		if( (tRet=ASNH245MasterSlaveDeterminationRelease_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_terminalCapabilitySetRelease ){
		if( (tRet=ASNH245TerminalCapabilitySetRelease_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_openLogicalChannelConfirm ){
		if( (tRet=ASNH245OpenLogicalChannelConfirm_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestChannelCloseRelease ){
		if( (tRet=ASNH245RequestChannelCloseRelease_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_multiplexEntrySendRelease ){
		if( (tRet=ASNH245MultiplexEntrySendRelease_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestMultiplexEntryRelease ){
		if( (tRet=ASNH245RequestMultiplexEntryRelease_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestModeRelease ){
		if( (tRet=ASNH245RequestModeRelease_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_miscellaneousIndication ){
		if( (tRet=ASNH245MiscellaneousIndication_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_jitterIndication ){
		if( (tRet=ASNH245JitterIndication_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_h223SkewIndication ){
		if( (tRet=ASNH245H223SkewIndication_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_newATMVCIndication ){
		if( (tRet=ASNH245NewATMVCIndication_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_userInput ){
		if( (tRet=ASNH245UserInputIndication_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_h2250MaximumSkewIndication ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245H2250MaximumSkewIndication_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_mcLocationIndication ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MCLocationIndication_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_conferenceIndication ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245ConferenceIndication_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_vendorIdentification ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245VendorIdentification_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_functionNotSupported ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245FunctionNotSupported_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_multilinkIndication ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MultilinkIndication_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_logicalChannelRateRelease ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245LogicalChannelRateRelease_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_flowControlIndication ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245FlowControlIndication_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_mobileMultilinkReconfigurationIndication ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245MobileMultilinkReconfigurationIndication_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IndicationMessage_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245IndicationMessage Decode */
HS_RESULT ASNH245IndicationMessage_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245IndicationMessage *pObj = (ASNH245IndicationMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IndicationMessage_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245IndicationMessageChoiceSize;
	}
	else
	{
		if( e_ASNH245IndicationMessageChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245IndicationMessageChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245IndicationMessageChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245IndicationMessage_SetChoice( pObj, (ASNH245IndicationMessageChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IndicationMessage_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IndicationMessageChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_functionNotUnderstood ){
		if( (tRet=ASNH245FunctionNotUnderstood_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_masterSlaveDeterminationRelease ){
		if( (tRet=ASNH245MasterSlaveDeterminationRelease_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_terminalCapabilitySetRelease ){
		if( (tRet=ASNH245TerminalCapabilitySetRelease_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_openLogicalChannelConfirm ){
		if( (tRet=ASNH245OpenLogicalChannelConfirm_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestChannelCloseRelease ){
		if( (tRet=ASNH245RequestChannelCloseRelease_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_multiplexEntrySendRelease ){
		if( (tRet=ASNH245MultiplexEntrySendRelease_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestMultiplexEntryRelease ){
		if( (tRet=ASNH245RequestMultiplexEntryRelease_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestModeRelease ){
		if( (tRet=ASNH245RequestModeRelease_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_miscellaneousIndication ){
		if( (tRet=ASNH245MiscellaneousIndication_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_jitterIndication ){
		if( (tRet=ASNH245JitterIndication_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_h223SkewIndication ){
		if( (tRet=ASNH245H223SkewIndication_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_newATMVCIndication ){
		if( (tRet=ASNH245NewATMVCIndication_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_userInput ){
		if( (tRet=ASNH245UserInputIndication_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_h2250MaximumSkewIndication ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245H2250MaximumSkewIndication_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_mcLocationIndication ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MCLocationIndication_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_conferenceIndication ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245ConferenceIndication_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_vendorIdentification ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245VendorIdentification_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_functionNotSupported ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245FunctionNotSupported_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_multilinkIndication ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MultilinkIndication_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_logicalChannelRateRelease ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245LogicalChannelRateRelease_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_flowControlIndication ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245FlowControlIndication_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_mobileMultilinkReconfigurationIndication ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245MobileMultilinkReconfigurationIndication_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IndicationMessage_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IndicationMessage Print */
HS_RESULT ASNH245IndicationMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IndicationMessage *pObj = (ASNH245IndicationMessage *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IndicationMessage_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IndicationMessageChoice_nonStandard ){
		ASNH245NonStandardMessage_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_functionNotUnderstood ){
		ASNH245FunctionNotUnderstood_Print( pObj->alter, pDepth+1, "functionNotUnderstood" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_masterSlaveDeterminationRelease ){
		ASNH245MasterSlaveDeterminationRelease_Print( pObj->alter, pDepth+1, "masterSlaveDeterminationRelease" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_terminalCapabilitySetRelease ){
		ASNH245TerminalCapabilitySetRelease_Print( pObj->alter, pDepth+1, "terminalCapabilitySetRelease" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_openLogicalChannelConfirm ){
		ASNH245OpenLogicalChannelConfirm_Print( pObj->alter, pDepth+1, "openLogicalChannelConfirm" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestChannelCloseRelease ){
		ASNH245RequestChannelCloseRelease_Print( pObj->alter, pDepth+1, "requestChannelCloseRelease" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_multiplexEntrySendRelease ){
		ASNH245MultiplexEntrySendRelease_Print( pObj->alter, pDepth+1, "multiplexEntrySendRelease" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestMultiplexEntryRelease ){
		ASNH245RequestMultiplexEntryRelease_Print( pObj->alter, pDepth+1, "requestMultiplexEntryRelease" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_requestModeRelease ){
		ASNH245RequestModeRelease_Print( pObj->alter, pDepth+1, "requestModeRelease" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_miscellaneousIndication ){
		ASNH245MiscellaneousIndication_Print( pObj->alter, pDepth+1, "miscellaneousIndication" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_jitterIndication ){
		ASNH245JitterIndication_Print( pObj->alter, pDepth+1, "jitterIndication" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_h223SkewIndication ){
		ASNH245H223SkewIndication_Print( pObj->alter, pDepth+1, "h223SkewIndication" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_newATMVCIndication ){
		ASNH245NewATMVCIndication_Print( pObj->alter, pDepth+1, "newATMVCIndication" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_userInput ){
		ASNH245UserInputIndication_Print( pObj->alter, pDepth+1, "userInput" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_h2250MaximumSkewIndication ){
		ASNH245H2250MaximumSkewIndication_Print( pObj->alter, pDepth+1, "h2250MaximumSkewIndication" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_mcLocationIndication ){
		ASNH245MCLocationIndication_Print( pObj->alter, pDepth+1, "mcLocationIndication" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_conferenceIndication ){
		ASNH245ConferenceIndication_Print( pObj->alter, pDepth+1, "conferenceIndication" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_vendorIdentification ){
		ASNH245VendorIdentification_Print( pObj->alter, pDepth+1, "vendorIdentification" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_functionNotSupported ){
		ASNH245FunctionNotSupported_Print( pObj->alter, pDepth+1, "functionNotSupported" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_multilinkIndication ){
		ASNH245MultilinkIndication_Print( pObj->alter, pDepth+1, "multilinkIndication" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_logicalChannelRateRelease ){
		ASNH245LogicalChannelRateRelease_Print( pObj->alter, pDepth+1, "logicalChannelRateRelease" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_flowControlIndication ){
		ASNH245FlowControlIndication_Print( pObj->alter, pDepth+1, "flowControlIndication" );
	}
	else if ( pObj->choice == e_ASNH245IndicationMessageChoice_mobileMultilinkReconfigurationIndication ){
		ASNH245MobileMultilinkReconfigurationIndication_Print( pObj->alter, pDepth+1, "mobileMultilinkReconfigurationIndication" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MultimediaSystemControlMessage Struct
*/
/* ASNH245MultimediaSystemControlMessage Constructor */
HS_RESULT new_ASNH245MultimediaSystemControlMessage( void *pObject )
{
	ASNH245MultimediaSystemControlMessage *pObj = (ASNH245MultimediaSystemControlMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MultimediaSystemControlMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MultimediaSystemControlMessageChoice_request;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MultimediaSystemControlMessageChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MultimediaSystemControlMessage Destructor */
HS_RESULT delete_ASNH245MultimediaSystemControlMessage( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MultimediaSystemControlMessage *pObj = (ASNH245MultimediaSystemControlMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultimediaSystemControlMessage(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MultimediaSystemControlMessage_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MultimediaSystemControlMessage(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MultimediaSystemControlMessage SetChoice */
void* ASNH245MultimediaSystemControlMessage_SetChoice( void *pObject, ASNH245MultimediaSystemControlMessageChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MultimediaSystemControlMessage *pObj = (ASNH245MultimediaSystemControlMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MultimediaSystemControlMessageChoiceSizeExt ){
		if( pChoice > (ASNH245MultimediaSystemControlMessageChoice)(e_ASNH245MultimediaSystemControlMessageChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MultimediaSystemControlMessage_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MultimediaSystemControlMessageChoice_request ){
		ASNH245RequestMessage *tAlter = (ASNH245RequestMessage *)HSMalloc( sizeof(ASNH245RequestMessage) );
		new_ASNH245RequestMessage(tAlter);
		ASNH245RequestMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultimediaSystemControlMessageChoice_response ){
		ASNH245ResponseMessage *tAlter = (ASNH245ResponseMessage *)HSMalloc( sizeof(ASNH245ResponseMessage) );
		new_ASNH245ResponseMessage(tAlter);
		ASNH245ResponseMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultimediaSystemControlMessageChoice_command ){
		ASNH245CommandMessage *tAlter = (ASNH245CommandMessage *)HSMalloc( sizeof(ASNH245CommandMessage) );
		new_ASNH245CommandMessage(tAlter);
		ASNH245CommandMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MultimediaSystemControlMessageChoice_indication ){
		ASNH245IndicationMessage *tAlter = (ASNH245IndicationMessage *)HSMalloc( sizeof(ASNH245IndicationMessage) );
		new_ASNH245IndicationMessage(tAlter);
		ASNH245IndicationMessage_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MultimediaSystemControlMessage DeleteAlternation */
HS_RESULT ASNH245MultimediaSystemControlMessage_DeleteAlternation(void *pObject)
{
	ASNH245MultimediaSystemControlMessage *pObj = (ASNH245MultimediaSystemControlMessage *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_request ){
			delete_ASNH245RequestMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_response ){
			delete_ASNH245ResponseMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_command ){
			delete_ASNH245CommandMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_indication ){
			delete_ASNH245IndicationMessage(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MultimediaSystemControlMessage_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MultimediaSystemControlMessage Encode */
HS_RESULT ASNH245MultimediaSystemControlMessage_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MultimediaSystemControlMessage *pObj = (ASNH245MultimediaSystemControlMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MultimediaSystemControlMessageChoiceSize )
		{
			if( pObj->choice > ((ASNH245MultimediaSystemControlMessageChoice)(e_ASNH245MultimediaSystemControlMessageChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MultimediaSystemControlMessageChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MultimediaSystemControlMessageChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_request ){
		if( (tRet=ASNH245RequestMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_response ){
		if( (tRet=ASNH245ResponseMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_command ){
		if( (tRet=ASNH245CommandMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_indication ){
		if( (tRet=ASNH245IndicationMessage_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MultimediaSystemControlMessage Decode */
HS_RESULT ASNH245MultimediaSystemControlMessage_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MultimediaSystemControlMessage *pObj = (ASNH245MultimediaSystemControlMessage *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MultimediaSystemControlMessageChoiceSize;
	}
	else
	{
		if( e_ASNH245MultimediaSystemControlMessageChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MultimediaSystemControlMessageChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MultimediaSystemControlMessageChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MultimediaSystemControlMessage_SetChoice( pObj, (ASNH245MultimediaSystemControlMessageChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_request ){
		if( (tRet=ASNH245RequestMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_response ){
		if( (tRet=ASNH245ResponseMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_command ){
		if( (tRet=ASNH245CommandMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_indication ){
		if( (tRet=ASNH245IndicationMessage_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MultimediaSystemControlMessage Print */
HS_RESULT ASNH245MultimediaSystemControlMessage_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MultimediaSystemControlMessage *pObj = (ASNH245MultimediaSystemControlMessage *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MultimediaSystemControlMessage_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_request ){
		ASNH245RequestMessage_Print( pObj->alter, pDepth+1, "request" );
	}
	else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_response ){
		ASNH245ResponseMessage_Print( pObj->alter, pDepth+1, "response" );
	}
	else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_command ){
		ASNH245CommandMessage_Print( pObj->alter, pDepth+1, "command" );
	}
	else if ( pObj->choice == e_ASNH245MultimediaSystemControlMessageChoice_indication ){
		ASNH245IndicationMessage_Print( pObj->alter, pDepth+1, "indication" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245MediaEncryptionAlgorithm Struct
*/
/* ASNH245MediaEncryptionAlgorithm Constructor */
HS_RESULT new_ASNH245MediaEncryptionAlgorithm( void *pObject )
{
	ASNH245MediaEncryptionAlgorithm *pObj = (ASNH245MediaEncryptionAlgorithm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245MediaEncryptionAlgorithm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245MediaEncryptionAlgorithmChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245MediaEncryptionAlgorithmChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245MediaEncryptionAlgorithm Destructor */
HS_RESULT delete_ASNH245MediaEncryptionAlgorithm( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245MediaEncryptionAlgorithm *pObj = (ASNH245MediaEncryptionAlgorithm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MediaEncryptionAlgorithm(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245MediaEncryptionAlgorithm_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245MediaEncryptionAlgorithm(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245MediaEncryptionAlgorithm SetChoice */
void* ASNH245MediaEncryptionAlgorithm_SetChoice( void *pObject, ASNH245MediaEncryptionAlgorithmChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245MediaEncryptionAlgorithm *pObj = (ASNH245MediaEncryptionAlgorithm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245MediaEncryptionAlgorithmChoiceSizeExt ){
		if( pChoice > (ASNH245MediaEncryptionAlgorithmChoice)(e_ASNH245MediaEncryptionAlgorithmChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245MediaEncryptionAlgorithm_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245MediaEncryptionAlgorithmChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245MediaEncryptionAlgorithmChoice_algorithm ){
		AsnObjectIdentifier *tAlter = (AsnObjectIdentifier *)HSMalloc( sizeof(AsnObjectIdentifier) );
		new_AsnObjectIdentifier(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245MediaEncryptionAlgorithm DeleteAlternation */
HS_RESULT ASNH245MediaEncryptionAlgorithm_DeleteAlternation(void *pObject)
{
	ASNH245MediaEncryptionAlgorithm *pObj = (ASNH245MediaEncryptionAlgorithm *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245MediaEncryptionAlgorithmChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245MediaEncryptionAlgorithmChoice_algorithm ){
			delete_AsnObjectIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245MediaEncryptionAlgorithm_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245MediaEncryptionAlgorithm Encode */
HS_RESULT ASNH245MediaEncryptionAlgorithm_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245MediaEncryptionAlgorithm *pObj = (ASNH245MediaEncryptionAlgorithm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245MediaEncryptionAlgorithmChoiceSize )
		{
			if( pObj->choice > ((ASNH245MediaEncryptionAlgorithmChoice)(e_ASNH245MediaEncryptionAlgorithmChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245MediaEncryptionAlgorithmChoiceSize)) )
	}
	else
	{
		if( e_ASNH245MediaEncryptionAlgorithmChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MediaEncryptionAlgorithmChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MediaEncryptionAlgorithmChoice_algorithm ){
		if( (tRet=AsnObjectIdentifier_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245MediaEncryptionAlgorithm Decode */
HS_RESULT ASNH245MediaEncryptionAlgorithm_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245MediaEncryptionAlgorithm *pObj = (ASNH245MediaEncryptionAlgorithm *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245MediaEncryptionAlgorithmChoiceSize;
	}
	else
	{
		if( e_ASNH245MediaEncryptionAlgorithmChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245MediaEncryptionAlgorithmChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245MediaEncryptionAlgorithmChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245MediaEncryptionAlgorithm_SetChoice( pObj, (ASNH245MediaEncryptionAlgorithmChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MediaEncryptionAlgorithmChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245MediaEncryptionAlgorithmChoice_algorithm ){
		if( (tRet=AsnObjectIdentifier_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245MediaEncryptionAlgorithm Print */
HS_RESULT ASNH245MediaEncryptionAlgorithm_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245MediaEncryptionAlgorithm *pObj = (ASNH245MediaEncryptionAlgorithm *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245MediaEncryptionAlgorithm_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245MediaEncryptionAlgorithmChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245MediaEncryptionAlgorithmChoice_algorithm ){
		AsnObjectIdentifier_Print( pObj->alter, pDepth+1, "algorithm" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H261VideoMode_resolution Struct
*/
/* ASNH245H261VideoMode_resolution Constructor */
HS_RESULT new_ASNH245H261VideoMode_resolution( void *pObject )
{
	ASNH245H261VideoMode_resolution *pObj = (ASNH245H261VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H261VideoMode_resolution(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245H261VideoMode_resolutionChoice_qcif;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245H261VideoMode_resolutionChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245H261VideoMode_resolution Destructor */
HS_RESULT delete_ASNH245H261VideoMode_resolution( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245H261VideoMode_resolution *pObj = (ASNH245H261VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H261VideoMode_resolution(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245H261VideoMode_resolution_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H261VideoMode_resolution(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245H261VideoMode_resolution SetChoice */
void* ASNH245H261VideoMode_resolution_SetChoice( void *pObject, ASNH245H261VideoMode_resolutionChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245H261VideoMode_resolution *pObj = (ASNH245H261VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245H261VideoMode_resolutionChoiceSizeExt ){
		if( pChoice > (ASNH245H261VideoMode_resolutionChoice)(e_ASNH245H261VideoMode_resolutionChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoMode_resolution_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245H261VideoMode_resolution_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoMode_resolution_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245H261VideoMode_resolutionChoice_qcif ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H261VideoMode_resolutionChoice_cif ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245H261VideoMode_resolution DeleteAlternation */
HS_RESULT ASNH245H261VideoMode_resolution_DeleteAlternation(void *pObject)
{
	ASNH245H261VideoMode_resolution *pObj = (ASNH245H261VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245H261VideoMode_resolutionChoice_qcif ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H261VideoMode_resolutionChoice_cif ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoMode_resolution_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245H261VideoMode_resolution_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245H261VideoMode_resolution Encode */
HS_RESULT ASNH245H261VideoMode_resolution_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245H261VideoMode_resolution *pObj = (ASNH245H261VideoMode_resolution *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245H261VideoMode_resolutionChoiceSize )
		{
			if( pObj->choice > ((ASNH245H261VideoMode_resolutionChoice)(e_ASNH245H261VideoMode_resolutionChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245H261VideoMode_resolutionChoiceSize)) )
	}
	else
	{
		if( e_ASNH245H261VideoMode_resolutionChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H261VideoMode_resolutionChoice_qcif ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H261VideoMode_resolutionChoice_cif ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245H261VideoMode_resolution Decode */
HS_RESULT ASNH245H261VideoMode_resolution_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245H261VideoMode_resolution *pObj = (ASNH245H261VideoMode_resolution *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245H261VideoMode_resolutionChoiceSize;
	}
	else
	{
		if( e_ASNH245H261VideoMode_resolutionChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245H261VideoMode_resolutionChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245H261VideoMode_resolutionChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245H261VideoMode_resolution_SetChoice( pObj, (ASNH245H261VideoMode_resolutionChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H261VideoMode_resolutionChoice_qcif ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H261VideoMode_resolutionChoice_cif ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H261VideoMode_resolution Print */
HS_RESULT ASNH245H261VideoMode_resolution_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H261VideoMode_resolution *pObj = (ASNH245H261VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H261VideoMode_resolution_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H261VideoMode_resolutionChoice_qcif ){
		AsnNull_Print( pObj->alter, pDepth+1, "qcif" );
	}
	else if ( pObj->choice == e_ASNH245H261VideoMode_resolutionChoice_cif ){
		AsnNull_Print( pObj->alter, pDepth+1, "cif" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H261VideoMode Class
*/
/*ASNH245H261VideoMode Constructor*/
HS_RESULT new_ASNH245H261VideoMode(void *pObject)
{
	ASNH245H261VideoMode *pObj = (ASNH245H261VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H261VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245H261VideoMode_resolution( &(pObj->m_resolution) );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 19200, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_stillImageTransmission) );

	return HS_OK;
}

/* ASNH245H261VideoMode Destructor */
HS_RESULT delete_ASNH245H261VideoMode(void *pObject)
{
	ASNH245H261VideoMode *pObj = (ASNH245H261VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H261VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245H261VideoMode_resolution( &(pObj->m_resolution) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	delete_AsnBoolean( &(pObj->m_stillImageTransmission) );
	return HS_OK;
}

/* ASNH245H261VideoMode MakeMold */
HS_RESULT ASNH245H261VideoMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H261VideoMode *pObj = (ASNH245H261VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H261VideoMode Encode */
HS_RESULT ASNH245H261VideoMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H261VideoMode *pObj = (ASNH245H261VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245H261VideoMode_resolution_Encode( &(pObj->m_resolution),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_stillImageTransmission),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245H261VideoMode Decode */
HS_RESULT ASNH245H261VideoMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H261VideoMode *pObj = (ASNH245H261VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245H261VideoMode_resolution_Decode(&(pObj->m_resolution),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_stillImageTransmission),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H261VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H261VideoMode Print */
HS_RESULT ASNH245H261VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H261VideoMode *pObj = (ASNH245H261VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H261VideoMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245H261VideoMode_resolution_Print( &(pObj->m_resolution), pDepth+1, "resolution" );
	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	AsnBoolean_Print( &(pObj->m_stillImageTransmission), pDepth+1, "stillImageTransmission" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H262VideoMode_profileAndLevel Struct
*/
/* ASNH245H262VideoMode_profileAndLevel Constructor */
HS_RESULT new_ASNH245H262VideoMode_profileAndLevel( void *pObject )
{
	ASNH245H262VideoMode_profileAndLevel *pObj = (ASNH245H262VideoMode_profileAndLevel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H262VideoMode_profileAndLevel(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SPatML;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245H262VideoMode_profileAndLevelChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245H262VideoMode_profileAndLevel Destructor */
HS_RESULT delete_ASNH245H262VideoMode_profileAndLevel( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245H262VideoMode_profileAndLevel *pObj = (ASNH245H262VideoMode_profileAndLevel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H262VideoMode_profileAndLevel(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245H262VideoMode_profileAndLevel_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H262VideoMode_profileAndLevel(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245H262VideoMode_profileAndLevel SetChoice */
void* ASNH245H262VideoMode_profileAndLevel_SetChoice( void *pObject, ASNH245H262VideoMode_profileAndLevelChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245H262VideoMode_profileAndLevel *pObj = (ASNH245H262VideoMode_profileAndLevel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245H262VideoMode_profileAndLevelChoiceSizeExt ){
		if( pChoice > (ASNH245H262VideoMode_profileAndLevelChoice)(e_ASNH245H262VideoMode_profileAndLevelChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245H262VideoMode_profileAndLevel_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SPatML ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatLL ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatML ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatH_14 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatHL ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatLL ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatML ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SpatialatH_14 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatML ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatH_14 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatHL ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245H262VideoMode_profileAndLevel DeleteAlternation */
HS_RESULT ASNH245H262VideoMode_profileAndLevel_DeleteAlternation(void *pObject)
{
	ASNH245H262VideoMode_profileAndLevel *pObj = (ASNH245H262VideoMode_profileAndLevel *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SPatML ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatLL ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatML ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatH_14 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatHL ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatLL ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatML ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SpatialatH_14 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatML ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatH_14 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatHL ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245H262VideoMode_profileAndLevel_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245H262VideoMode_profileAndLevel Encode */
HS_RESULT ASNH245H262VideoMode_profileAndLevel_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245H262VideoMode_profileAndLevel *pObj = (ASNH245H262VideoMode_profileAndLevel *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245H262VideoMode_profileAndLevelChoiceSize )
		{
			if( pObj->choice > ((ASNH245H262VideoMode_profileAndLevelChoice)(e_ASNH245H262VideoMode_profileAndLevelChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245H262VideoMode_profileAndLevelChoiceSize)) )
	}
	else
	{
		if( e_ASNH245H262VideoMode_profileAndLevelChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SPatML ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatLL ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatML ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatH_14 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatHL ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatLL ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatML ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SpatialatH_14 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatML ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatH_14 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatHL ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245H262VideoMode_profileAndLevel Decode */
HS_RESULT ASNH245H262VideoMode_profileAndLevel_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245H262VideoMode_profileAndLevel *pObj = (ASNH245H262VideoMode_profileAndLevel *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245H262VideoMode_profileAndLevelChoiceSize;
	}
	else
	{
		if( e_ASNH245H262VideoMode_profileAndLevelChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245H262VideoMode_profileAndLevelChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245H262VideoMode_profileAndLevelChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245H262VideoMode_profileAndLevel_SetChoice( pObj, (ASNH245H262VideoMode_profileAndLevelChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SPatML ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatLL ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatML ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatH_14 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatHL ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatLL ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatML ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SpatialatH_14 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatML ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatH_14 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatHL ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H262VideoMode_profileAndLevel Print */
HS_RESULT ASNH245H262VideoMode_profileAndLevel_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H262VideoMode_profileAndLevel *pObj = (ASNH245H262VideoMode_profileAndLevel *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H262VideoMode_profileAndLevel_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SPatML ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_SPatML" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatLL ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_MPatLL" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatML ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_MPatML" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatH_14 ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_MPatH_14" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_MPatHL ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_MPatHL" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatLL ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_SNRatLL" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SNRatML ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_SNRatML" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_SpatialatH_14 ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_SpatialatH_14" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatML ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_HPatML" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatH_14 ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_HPatH_14" );
	}
	else if ( pObj->choice == e_ASNH245H262VideoMode_profileAndLevelChoice_profileAndLevel_HPatHL ){
		AsnNull_Print( pObj->alter, pDepth+1, "profileAndLevel_HPatHL" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H262VideoMode Class
*/
/*ASNH245H262VideoMode Constructor*/
HS_RESULT new_ASNH245H262VideoMode(void *pObject)
{
	ASNH245H262VideoMode *pObj = (ASNH245H262VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H262VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245H262VideoMode_profileAndLevel( &(pObj->m_profileAndLevel) );
	new_AsnInteger( &(pObj->m_videoBitRate), e_constrained, 0, 1073741823, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_vbvBufferSize), e_constrained, 0, 262143, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_samplesPerLine), e_constrained, 0, 16383, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_linesPerFrame), e_constrained, 0, 16383, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_framesPerSecond), e_constrained, 0, 15, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_luminanceSampleRate), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245H262VideoMode Destructor */
HS_RESULT delete_ASNH245H262VideoMode(void *pObject)
{
	ASNH245H262VideoMode *pObj = (ASNH245H262VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H262VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245H262VideoMode_profileAndLevel( &(pObj->m_profileAndLevel) );
	delete_AsnInteger( &(pObj->m_videoBitRate) );
	delete_AsnInteger( &(pObj->m_vbvBufferSize) );
	delete_AsnInteger( &(pObj->m_samplesPerLine) );
	delete_AsnInteger( &(pObj->m_linesPerFrame) );
	delete_AsnInteger( &(pObj->m_framesPerSecond) );
	delete_AsnInteger( &(pObj->m_luminanceSampleRate) );
	return HS_OK;
}

/* ASNH245H262VideoMode MakeMold */
HS_RESULT ASNH245H262VideoMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H262VideoMode *pObj = (ASNH245H262VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245H262VideoMode IncludeOptionalField */
HS_RESULT ASNH245H262VideoMode_IncludeOptionField( void *pObject, ASNH245H262VideoModeOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H262VideoMode *pObj = (ASNH245H262VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H262VideoModeOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245H262VideoMode IsIncludeOptionalField */
BOOL ASNH245H262VideoMode_IsIncludeOptionField( void *pObject, ASNH245H262VideoModeOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245H262VideoMode *pObj = (ASNH245H262VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H262VideoModeOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H262VideoMode Encode */
HS_RESULT ASNH245H262VideoMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H262VideoMode *pObj = (ASNH245H262VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245H262VideoModeOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245H262VideoModeOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245H262VideoMode_profileAndLevel_Encode( &(pObj->m_profileAndLevel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_videoBitRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_videoBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_vbvBufferSize ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_vbvBufferSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_samplesPerLine ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_samplesPerLine),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_linesPerFrame ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_linesPerFrame),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_framesPerSecond ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_framesPerSecond),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_luminanceSampleRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_luminanceSampleRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245H262VideoMode Decode */
HS_RESULT ASNH245H262VideoMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245H262VideoMode *pObj = (ASNH245H262VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245H262VideoModeOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245H262VideoModeOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH245H262VideoMode_profileAndLevel_Decode(&(pObj->m_profileAndLevel),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H262VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_videoBitRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_videoBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_vbvBufferSize ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_vbvBufferSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_samplesPerLine ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_samplesPerLine),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_linesPerFrame ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_linesPerFrame),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_framesPerSecond ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_framesPerSecond),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_luminanceSampleRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_luminanceSampleRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H262VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H262VideoMode Print */
HS_RESULT ASNH245H262VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H262VideoMode *pObj = (ASNH245H262VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H262VideoMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245H262VideoMode_profileAndLevel_Print( &(pObj->m_profileAndLevel), pDepth+1, "profileAndLevel" );
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_videoBitRate ) )
		AsnInteger_Print( &(pObj->m_videoBitRate), pDepth+1, "videoBitRate" );
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_vbvBufferSize ) )
		AsnInteger_Print( &(pObj->m_vbvBufferSize), pDepth+1, "vbvBufferSize" );
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_samplesPerLine ) )
		AsnInteger_Print( &(pObj->m_samplesPerLine), pDepth+1, "samplesPerLine" );
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_linesPerFrame ) )
		AsnInteger_Print( &(pObj->m_linesPerFrame), pDepth+1, "linesPerFrame" );
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_framesPerSecond ) )
		AsnInteger_Print( &(pObj->m_framesPerSecond), pDepth+1, "framesPerSecond" );
	if( ASNH245H262VideoMode_IsIncludeOptionField( pObj, e_ASNH245H262VideoModeOptionMap_luminanceSampleRate ) )
		AsnInteger_Print( &(pObj->m_luminanceSampleRate), pDepth+1, "luminanceSampleRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H263VideoMode_resolution Struct
*/
/* ASNH245H263VideoMode_resolution Constructor */
HS_RESULT new_ASNH245H263VideoMode_resolution( void *pObject )
{
	ASNH245H263VideoMode_resolution *pObj = (ASNH245H263VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H263VideoMode_resolution(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245H263VideoMode_resolutionChoice_sqcif;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245H263VideoMode_resolutionChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245H263VideoMode_resolution Destructor */
HS_RESULT delete_ASNH245H263VideoMode_resolution( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245H263VideoMode_resolution *pObj = (ASNH245H263VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H263VideoMode_resolution(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245H263VideoMode_resolution_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H263VideoMode_resolution(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245H263VideoMode_resolution SetChoice */
void* ASNH245H263VideoMode_resolution_SetChoice( void *pObject, ASNH245H263VideoMode_resolutionChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245H263VideoMode_resolution *pObj = (ASNH245H263VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245H263VideoMode_resolutionChoiceSizeExt ){
		if( pChoice > (ASNH245H263VideoMode_resolutionChoice)(e_ASNH245H263VideoMode_resolutionChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245H263VideoMode_resolution_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245H263VideoMode_resolutionChoice_sqcif ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H263VideoMode_resolutionChoice_qcif ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H263VideoMode_resolutionChoice_cif ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H263VideoMode_resolutionChoice_cif4 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H263VideoMode_resolutionChoice_cif16 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245H263VideoMode_resolution DeleteAlternation */
HS_RESULT ASNH245H263VideoMode_resolution_DeleteAlternation(void *pObject)
{
	ASNH245H263VideoMode_resolution *pObj = (ASNH245H263VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_sqcif ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_qcif ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif4 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif16 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245H263VideoMode_resolution_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245H263VideoMode_resolution Encode */
HS_RESULT ASNH245H263VideoMode_resolution_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245H263VideoMode_resolution *pObj = (ASNH245H263VideoMode_resolution *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245H263VideoMode_resolutionChoiceSize )
		{
			if( pObj->choice > ((ASNH245H263VideoMode_resolutionChoice)(e_ASNH245H263VideoMode_resolutionChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245H263VideoMode_resolutionChoiceSize)) )
	}
	else
	{
		if( e_ASNH245H263VideoMode_resolutionChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_sqcif ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_qcif ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif4 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif16 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245H263VideoMode_resolution Decode */
HS_RESULT ASNH245H263VideoMode_resolution_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245H263VideoMode_resolution *pObj = (ASNH245H263VideoMode_resolution *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245H263VideoMode_resolutionChoiceSize;
	}
	else
	{
		if( e_ASNH245H263VideoMode_resolutionChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245H263VideoMode_resolutionChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245H263VideoMode_resolutionChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245H263VideoMode_resolution_SetChoice( pObj, (ASNH245H263VideoMode_resolutionChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_sqcif ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_qcif ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif4 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif16 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H263VideoMode_resolution Print */
HS_RESULT ASNH245H263VideoMode_resolution_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H263VideoMode_resolution *pObj = (ASNH245H263VideoMode_resolution *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H263VideoMode_resolution_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_sqcif ){
		AsnNull_Print( pObj->alter, pDepth+1, "sqcif" );
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_qcif ){
		AsnNull_Print( pObj->alter, pDepth+1, "qcif" );
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif ){
		AsnNull_Print( pObj->alter, pDepth+1, "cif" );
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif4 ){
		AsnNull_Print( pObj->alter, pDepth+1, "cif4" );
	}
	else if ( pObj->choice == e_ASNH245H263VideoMode_resolutionChoice_cif16 ){
		AsnNull_Print( pObj->alter, pDepth+1, "cif16" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H263VideoMode Class
*/
/*ASNH245H263VideoMode Constructor*/
HS_RESULT new_ASNH245H263VideoMode(void *pObject)
{
	ASNH245H263VideoMode *pObj = (ASNH245H263VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H263VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245H263VideoMode_resolution( &(pObj->m_resolution) );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 19200, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_unrestrictedVector) );
	new_AsnBoolean( &(pObj->m_arithmeticCoding) );
	new_AsnBoolean( &(pObj->m_advancedPrediction) );
	new_AsnBoolean( &(pObj->m_pbFrames) );
	new_AsnBoolean( &(pObj->m_errorCompensation) );
	new_ASNH245EnhancementLayerInfo( &(pObj->m_enhancementLayerInfo) );
	new_ASNH245H263Options( &(pObj->m_h263Options) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH245H263VideoMode Destructor */
HS_RESULT delete_ASNH245H263VideoMode(void *pObject)
{
	ASNH245H263VideoMode *pObj = (ASNH245H263VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H263VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245H263VideoMode_resolution( &(pObj->m_resolution) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	delete_AsnBoolean( &(pObj->m_unrestrictedVector) );
	delete_AsnBoolean( &(pObj->m_arithmeticCoding) );
	delete_AsnBoolean( &(pObj->m_advancedPrediction) );
	delete_AsnBoolean( &(pObj->m_pbFrames) );
	delete_AsnBoolean( &(pObj->m_errorCompensation) );
	delete_ASNH245EnhancementLayerInfo( &(pObj->m_enhancementLayerInfo) );
	delete_ASNH245H263Options( &(pObj->m_h263Options) );
	return HS_OK;
}

/* ASNH245H263VideoMode MakeMold */
HS_RESULT ASNH245H263VideoMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H263VideoMode *pObj = (ASNH245H263VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245EnhancementLayerInfo_MakeMold(&(pObj->m_enhancementLayerInfo));
	ASNH245H263Options_MakeMold(&(pObj->m_h263Options));
	return HS_OK;
}

/* ASNH245H263VideoMode IncludeOptionalField */
HS_RESULT ASNH245H263VideoMode_IncludeOptionField( void *pObject, ASNH245H263VideoModeOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245H263VideoMode *pObj = (ASNH245H263VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245H263VideoModeOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H263VideoModeOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH245H263VideoMode IsIncludeOptionalField */
BOOL ASNH245H263VideoMode_IsIncludeOptionField( void *pObject, ASNH245H263VideoModeOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH245H263VideoMode *pObj = (ASNH245H263VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245H263VideoModeOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH245H263VideoModeOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245H263VideoMode Encode */
HS_RESULT ASNH245H263VideoMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H263VideoMode *pObj = (ASNH245H263VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245H263VideoMode_resolution_Encode( &(pObj->m_resolution),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_unrestrictedVector),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_arithmeticCoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_advancedPrediction),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_pbFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH245H263VideoMode_IsIncludeOptionField( pObj, e_ASNH245H263VideoModeOptionMap_errorCompensation ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_errorCompensation), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263VideoMode_IsIncludeOptionField( pObj, e_ASNH245H263VideoModeOptionMap_enhancementLayerInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_enhancementLayerInfo), ASNH245EnhancementLayerInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH245H263VideoMode_IsIncludeOptionField( pObj, e_ASNH245H263VideoModeOptionMap_h263Options ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h263Options), ASNH245H263Options_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH245H263VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH245H263VideoMode Decode */
HS_RESULT ASNH245H263VideoMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H263VideoMode *pObj = (ASNH245H263VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245H263VideoMode_resolution_Decode(&(pObj->m_resolution),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_unrestrictedVector),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_arithmeticCoding),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_advancedPrediction),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_pbFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H263VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH245H263VideoMode_IsIncludeOptionField( pObj, e_ASNH245H263VideoModeOptionMap_errorCompensation ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_errorCompensation), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoMode_IsIncludeOptionField( pObj, e_ASNH245H263VideoModeOptionMap_enhancementLayerInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_enhancementLayerInfo), ASNH245EnhancementLayerInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245H263VideoMode_IsIncludeOptionField( pObj, e_ASNH245H263VideoModeOptionMap_h263Options ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_h263Options), ASNH245H263Options_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H263VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H263VideoMode Print */
HS_RESULT ASNH245H263VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H263VideoMode *pObj = (ASNH245H263VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H263VideoMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245H263VideoMode_resolution_Print( &(pObj->m_resolution), pDepth+1, "resolution" );
	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	AsnBoolean_Print( &(pObj->m_unrestrictedVector), pDepth+1, "unrestrictedVector" );
	AsnBoolean_Print( &(pObj->m_arithmeticCoding), pDepth+1, "arithmeticCoding" );
	AsnBoolean_Print( &(pObj->m_advancedPrediction), pDepth+1, "advancedPrediction" );
	AsnBoolean_Print( &(pObj->m_pbFrames), pDepth+1, "pbFrames" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH245H263VideoMode_IsIncludeOptionField( pObj, e_ASNH245H263VideoModeOptionMap_errorCompensation ) )
		AsnBoolean_Print( &(pObj->m_errorCompensation), pDepth+1, "errorCompensation" );
	if( ASNH245H263VideoMode_IsIncludeOptionField( pObj, e_ASNH245H263VideoModeOptionMap_enhancementLayerInfo ) )
		ASNH245EnhancementLayerInfo_Print( &(pObj->m_enhancementLayerInfo), pDepth+1, "enhancementLayerInfo" );
	if( ASNH245H263VideoMode_IsIncludeOptionField( pObj, e_ASNH245H263VideoModeOptionMap_h263Options ) )
		ASNH245H263Options_Print( &(pObj->m_h263Options), pDepth+1, "h263Options" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS11172VideoMode Class
*/
/*ASNH245IS11172VideoMode Constructor*/
HS_RESULT new_ASNH245IS11172VideoMode(void *pObject)
{
	ASNH245IS11172VideoMode *pObj = (ASNH245IS11172VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS11172VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_constrainedBitstream) );
	new_AsnInteger( &(pObj->m_videoBitRate), e_constrained, 0, 1073741823, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_vbvBufferSize), e_constrained, 0, 262143, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_samplesPerLine), e_constrained, 0, 16383, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_linesPerFrame), e_constrained, 0, 16383, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_pictureRate), e_constrained, 0, 15, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_luminanceSampleRate), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH245IS11172VideoMode Destructor */
HS_RESULT delete_ASNH245IS11172VideoMode(void *pObject)
{
	ASNH245IS11172VideoMode *pObj = (ASNH245IS11172VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_constrainedBitstream) );
	delete_AsnInteger( &(pObj->m_videoBitRate) );
	delete_AsnInteger( &(pObj->m_vbvBufferSize) );
	delete_AsnInteger( &(pObj->m_samplesPerLine) );
	delete_AsnInteger( &(pObj->m_linesPerFrame) );
	delete_AsnInteger( &(pObj->m_pictureRate) );
	delete_AsnInteger( &(pObj->m_luminanceSampleRate) );
	return HS_OK;
}

/* ASNH245IS11172VideoMode MakeMold */
HS_RESULT ASNH245IS11172VideoMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245IS11172VideoMode *pObj = (ASNH245IS11172VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245IS11172VideoMode IncludeOptionalField */
HS_RESULT ASNH245IS11172VideoMode_IncludeOptionField( void *pObject, ASNH245IS11172VideoModeOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH245IS11172VideoMode *pObj = (ASNH245IS11172VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoMode_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH245IS11172VideoModeOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH245IS11172VideoMode IsIncludeOptionalField */
BOOL ASNH245IS11172VideoMode_IsIncludeOptionField( void *pObject, ASNH245IS11172VideoModeOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH245IS11172VideoMode *pObj = (ASNH245IS11172VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoMode_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH245IS11172VideoModeOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH245IS11172VideoMode Encode */
HS_RESULT ASNH245IS11172VideoMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245IS11172VideoMode *pObj = (ASNH245IS11172VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH245IS11172VideoModeOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH245IS11172VideoModeOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Encode( &(pObj->m_constrainedBitstream),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_videoBitRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_videoBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_vbvBufferSize ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_vbvBufferSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_samplesPerLine ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_samplesPerLine),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_linesPerFrame ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_linesPerFrame),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_pictureRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_pictureRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_luminanceSampleRate ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_luminanceSampleRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH245IS11172VideoMode Decode */
HS_RESULT ASNH245IS11172VideoMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH245IS11172VideoMode *pObj = (ASNH245IS11172VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH245IS11172VideoModeOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH245IS11172VideoModeOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_constrainedBitstream),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_videoBitRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_videoBitRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_vbvBufferSize ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_vbvBufferSize),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_samplesPerLine ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_samplesPerLine),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_linesPerFrame ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_linesPerFrame),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_pictureRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_pictureRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_luminanceSampleRate ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_luminanceSampleRate),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172VideoMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS11172VideoMode Print */
HS_RESULT ASNH245IS11172VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS11172VideoMode *pObj = (ASNH245IS11172VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS11172VideoMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_constrainedBitstream), pDepth+1, "constrainedBitstream" );
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_videoBitRate ) )
		AsnInteger_Print( &(pObj->m_videoBitRate), pDepth+1, "videoBitRate" );
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_vbvBufferSize ) )
		AsnInteger_Print( &(pObj->m_vbvBufferSize), pDepth+1, "vbvBufferSize" );
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_samplesPerLine ) )
		AsnInteger_Print( &(pObj->m_samplesPerLine), pDepth+1, "samplesPerLine" );
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_linesPerFrame ) )
		AsnInteger_Print( &(pObj->m_linesPerFrame), pDepth+1, "linesPerFrame" );
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_pictureRate ) )
		AsnInteger_Print( &(pObj->m_pictureRate), pDepth+1, "pictureRate" );
	if( ASNH245IS11172VideoMode_IsIncludeOptionField( pObj, e_ASNH245IS11172VideoModeOptionMap_luminanceSampleRate ) )
		AsnInteger_Print( &(pObj->m_luminanceSampleRate), pDepth+1, "luminanceSampleRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245VideoMode Struct
*/
/* ASNH245VideoMode Constructor */
HS_RESULT new_ASNH245VideoMode( void *pObject )
{
	ASNH245VideoMode *pObj = (ASNH245VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245VideoModeChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245VideoModeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245VideoMode Destructor */
HS_RESULT delete_ASNH245VideoMode( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245VideoMode *pObj = (ASNH245VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VideoMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245VideoMode_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245VideoMode(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245VideoMode SetChoice */
void* ASNH245VideoMode_SetChoice( void *pObject, ASNH245VideoModeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245VideoMode *pObj = (ASNH245VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoMode_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245VideoModeChoiceSizeExt ){
		if( pChoice > (ASNH245VideoModeChoice)(e_ASNH245VideoModeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245VideoMode_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245VideoModeChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245VideoModeChoice_h261VideoMode ){
		ASNH245H261VideoMode *tAlter = (ASNH245H261VideoMode *)HSMalloc( sizeof(ASNH245H261VideoMode) );
		new_ASNH245H261VideoMode(tAlter);
		ASNH245H261VideoMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245VideoModeChoice_h262VideoMode ){
		ASNH245H262VideoMode *tAlter = (ASNH245H262VideoMode *)HSMalloc( sizeof(ASNH245H262VideoMode) );
		new_ASNH245H262VideoMode(tAlter);
		ASNH245H262VideoMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245VideoModeChoice_h263VideoMode ){
		ASNH245H263VideoMode *tAlter = (ASNH245H263VideoMode *)HSMalloc( sizeof(ASNH245H263VideoMode) );
		new_ASNH245H263VideoMode(tAlter);
		ASNH245H263VideoMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245VideoModeChoice_is11172VideoMode ){
		ASNH245IS11172VideoMode *tAlter = (ASNH245IS11172VideoMode *)HSMalloc( sizeof(ASNH245IS11172VideoMode) );
		new_ASNH245IS11172VideoMode(tAlter);
		ASNH245IS11172VideoMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245VideoModeChoice_genericVideoMode ){
		ASNH245GenericCapability *tAlter = (ASNH245GenericCapability *)HSMalloc( sizeof(ASNH245GenericCapability) );
		new_ASNH245GenericCapability(tAlter);
		ASNH245GenericCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoMode_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245VideoMode DeleteAlternation */
HS_RESULT ASNH245VideoMode_DeleteAlternation(void *pObject)
{
	ASNH245VideoMode *pObj = (ASNH245VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoMode_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245VideoModeChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245VideoModeChoice_h261VideoMode ){
			delete_ASNH245H261VideoMode(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245VideoModeChoice_h262VideoMode ){
			delete_ASNH245H262VideoMode(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245VideoModeChoice_h263VideoMode ){
			delete_ASNH245H263VideoMode(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245VideoModeChoice_is11172VideoMode ){
			delete_ASNH245IS11172VideoMode(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245VideoModeChoice_genericVideoMode ){
			delete_ASNH245GenericCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245VideoMode_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245VideoMode Encode */
HS_RESULT ASNH245VideoMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245VideoMode *pObj = (ASNH245VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoMode_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245VideoModeChoiceSize )
		{
			if( pObj->choice > ((ASNH245VideoModeChoice)(e_ASNH245VideoModeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245VideoModeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245VideoModeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245VideoModeChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_h261VideoMode ){
		if( (tRet=ASNH245H261VideoMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_h262VideoMode ){
		if( (tRet=ASNH245H262VideoMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_h263VideoMode ){
		if( (tRet=ASNH245H263VideoMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_is11172VideoMode ){
		if( (tRet=ASNH245IS11172VideoMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245VideoModeChoice_genericVideoMode ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245GenericCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoMode_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245VideoMode Decode */
HS_RESULT ASNH245VideoMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245VideoMode *pObj = (ASNH245VideoMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245VideoModeChoiceSize;
	}
	else
	{
		if( e_ASNH245VideoModeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245VideoModeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245VideoModeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245VideoMode_SetChoice( pObj, (ASNH245VideoModeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoMode_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245VideoModeChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_h261VideoMode ){
		if( (tRet=ASNH245H261VideoMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_h262VideoMode ){
		if( (tRet=ASNH245H262VideoMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_h263VideoMode ){
		if( (tRet=ASNH245H263VideoMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_is11172VideoMode ){
		if( (tRet=ASNH245IS11172VideoMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245VideoModeChoice_genericVideoMode ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245GenericCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245VideoMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245VideoMode_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245VideoMode Print */
HS_RESULT ASNH245VideoMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245VideoMode *pObj = (ASNH245VideoMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245VideoMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245VideoModeChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_h261VideoMode ){
		ASNH245H261VideoMode_Print( pObj->alter, pDepth+1, "h261VideoMode" );
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_h262VideoMode ){
		ASNH245H262VideoMode_Print( pObj->alter, pDepth+1, "h262VideoMode" );
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_h263VideoMode ){
		ASNH245H263VideoMode_Print( pObj->alter, pDepth+1, "h263VideoMode" );
	}
	else if ( pObj->choice == e_ASNH245VideoModeChoice_is11172VideoMode ){
		ASNH245IS11172VideoMode_Print( pObj->alter, pDepth+1, "is11172VideoMode" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245VideoModeChoice_genericVideoMode ){
		ASNH245GenericCapability_Print( pObj->alter, pDepth+1, "genericVideoMode" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245AudioMode_g7231 Struct
*/
/* ASNH245AudioMode_g7231 Constructor */
HS_RESULT new_ASNH245AudioMode_g7231( void *pObject )
{
	ASNH245AudioMode_g7231 *pObj = (ASNH245AudioMode_g7231 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245AudioMode_g7231(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionLowRate;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245AudioMode_g7231ChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245AudioMode_g7231 Destructor */
HS_RESULT delete_ASNH245AudioMode_g7231( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245AudioMode_g7231 *pObj = (ASNH245AudioMode_g7231 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245AudioMode_g7231(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245AudioMode_g7231_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245AudioMode_g7231(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245AudioMode_g7231 SetChoice */
void* ASNH245AudioMode_g7231_SetChoice( void *pObject, ASNH245AudioMode_g7231Choice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245AudioMode_g7231 *pObj = (ASNH245AudioMode_g7231 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_g7231_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245AudioMode_g7231ChoiceSizeExt ){
		if( pChoice > (ASNH245AudioMode_g7231Choice)(e_ASNH245AudioMode_g7231ChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245AudioMode_g7231_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionLowRate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionHighRate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionLowRate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionHighRate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_g7231_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245AudioMode_g7231 DeleteAlternation */
HS_RESULT ASNH245AudioMode_g7231_DeleteAlternation(void *pObject)
{
	ASNH245AudioMode_g7231 *pObj = (ASNH245AudioMode_g7231 *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_g7231_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionLowRate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionHighRate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionLowRate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionHighRate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245AudioMode_g7231_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245AudioMode_g7231 Encode */
HS_RESULT ASNH245AudioMode_g7231_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245AudioMode_g7231 *pObj = (ASNH245AudioMode_g7231 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_g7231_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_g7231_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245AudioMode_g7231ChoiceSize )
		{
			if( pObj->choice > ((ASNH245AudioMode_g7231Choice)(e_ASNH245AudioMode_g7231ChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245AudioMode_g7231ChoiceSize)) )
	}
	else
	{
		if( e_ASNH245AudioMode_g7231ChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionLowRate ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionHighRate ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionLowRate ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionHighRate ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_g7231_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245AudioMode_g7231 Decode */
HS_RESULT ASNH245AudioMode_g7231_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245AudioMode_g7231 *pObj = (ASNH245AudioMode_g7231 *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_g7231_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245AudioMode_g7231ChoiceSize;
	}
	else
	{
		if( e_ASNH245AudioMode_g7231ChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245AudioMode_g7231ChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245AudioMode_g7231ChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245AudioMode_g7231_SetChoice( pObj, (ASNH245AudioMode_g7231Choice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_g7231_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionLowRate ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionHighRate ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionLowRate ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionHighRate ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_g7231_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_g7231_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245AudioMode_g7231 Print */
HS_RESULT ASNH245AudioMode_g7231_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245AudioMode_g7231 *pObj = (ASNH245AudioMode_g7231 *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245AudioMode_g7231_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionLowRate ){
		AsnNull_Print( pObj->alter, pDepth+1, "noSilenceSuppressionLowRate" );
	}
	else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_noSilenceSuppressionHighRate ){
		AsnNull_Print( pObj->alter, pDepth+1, "noSilenceSuppressionHighRate" );
	}
	else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionLowRate ){
		AsnNull_Print( pObj->alter, pDepth+1, "silenceSuppressionLowRate" );
	}
	else if ( pObj->choice == e_ASNH245AudioMode_g7231Choice_silenceSuppressionHighRate ){
		AsnNull_Print( pObj->alter, pDepth+1, "silenceSuppressionHighRate" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS11172AudioMode_audioLayer Struct
*/
/* ASNH245IS11172AudioMode_audioLayer Constructor */
HS_RESULT new_ASNH245IS11172AudioMode_audioLayer( void *pObject )
{
	ASNH245IS11172AudioMode_audioLayer *pObj = (ASNH245IS11172AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS11172AudioMode_audioLayer(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer1;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245IS11172AudioMode_audioLayerChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245IS11172AudioMode_audioLayer Destructor */
HS_RESULT delete_ASNH245IS11172AudioMode_audioLayer( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245IS11172AudioMode_audioLayer *pObj = (ASNH245IS11172AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172AudioMode_audioLayer(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245IS11172AudioMode_audioLayer_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172AudioMode_audioLayer(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245IS11172AudioMode_audioLayer SetChoice */
void* ASNH245IS11172AudioMode_audioLayer_SetChoice( void *pObject, ASNH245IS11172AudioMode_audioLayerChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245IS11172AudioMode_audioLayer *pObj = (ASNH245IS11172AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245IS11172AudioMode_audioLayerChoiceSizeExt ){
		if( pChoice > (ASNH245IS11172AudioMode_audioLayerChoice)(e_ASNH245IS11172AudioMode_audioLayerChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245IS11172AudioMode_audioLayer_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer1 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer2 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer3 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245IS11172AudioMode_audioLayer DeleteAlternation */
HS_RESULT ASNH245IS11172AudioMode_audioLayer_DeleteAlternation(void *pObject)
{
	ASNH245IS11172AudioMode_audioLayer *pObj = (ASNH245IS11172AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer1 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer2 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer3 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245IS11172AudioMode_audioLayer_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245IS11172AudioMode_audioLayer Encode */
HS_RESULT ASNH245IS11172AudioMode_audioLayer_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245IS11172AudioMode_audioLayer *pObj = (ASNH245IS11172AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245IS11172AudioMode_audioLayerChoiceSize )
		{
			if( pObj->choice > ((ASNH245IS11172AudioMode_audioLayerChoice)(e_ASNH245IS11172AudioMode_audioLayerChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245IS11172AudioMode_audioLayerChoiceSize)) )
	}
	else
	{
		if( e_ASNH245IS11172AudioMode_audioLayerChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer1 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer2 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer3 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245IS11172AudioMode_audioLayer Decode */
HS_RESULT ASNH245IS11172AudioMode_audioLayer_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245IS11172AudioMode_audioLayer *pObj = (ASNH245IS11172AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245IS11172AudioMode_audioLayerChoiceSize;
	}
	else
	{
		if( e_ASNH245IS11172AudioMode_audioLayerChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245IS11172AudioMode_audioLayerChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245IS11172AudioMode_audioLayerChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245IS11172AudioMode_audioLayer_SetChoice( pObj, (ASNH245IS11172AudioMode_audioLayerChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer1 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer2 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer3 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS11172AudioMode_audioLayer Print */
HS_RESULT ASNH245IS11172AudioMode_audioLayer_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS11172AudioMode_audioLayer *pObj = (ASNH245IS11172AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioLayer_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer1 ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioLayer1" );
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer2 ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioLayer2" );
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioLayerChoice_audioLayer3 ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioLayer3" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS11172AudioMode_audioSampling Struct
*/
/* ASNH245IS11172AudioMode_audioSampling Constructor */
HS_RESULT new_ASNH245IS11172AudioMode_audioSampling( void *pObject )
{
	ASNH245IS11172AudioMode_audioSampling *pObj = (ASNH245IS11172AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS11172AudioMode_audioSampling(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling32k;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245IS11172AudioMode_audioSamplingChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245IS11172AudioMode_audioSampling Destructor */
HS_RESULT delete_ASNH245IS11172AudioMode_audioSampling( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245IS11172AudioMode_audioSampling *pObj = (ASNH245IS11172AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172AudioMode_audioSampling(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245IS11172AudioMode_audioSampling_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172AudioMode_audioSampling(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245IS11172AudioMode_audioSampling SetChoice */
void* ASNH245IS11172AudioMode_audioSampling_SetChoice( void *pObject, ASNH245IS11172AudioMode_audioSamplingChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245IS11172AudioMode_audioSampling *pObj = (ASNH245IS11172AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245IS11172AudioMode_audioSamplingChoiceSizeExt ){
		if( pChoice > (ASNH245IS11172AudioMode_audioSamplingChoice)(e_ASNH245IS11172AudioMode_audioSamplingChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245IS11172AudioMode_audioSampling_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling32k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling44k1 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling48k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245IS11172AudioMode_audioSampling DeleteAlternation */
HS_RESULT ASNH245IS11172AudioMode_audioSampling_DeleteAlternation(void *pObject)
{
	ASNH245IS11172AudioMode_audioSampling *pObj = (ASNH245IS11172AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling32k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling44k1 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling48k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245IS11172AudioMode_audioSampling_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245IS11172AudioMode_audioSampling Encode */
HS_RESULT ASNH245IS11172AudioMode_audioSampling_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245IS11172AudioMode_audioSampling *pObj = (ASNH245IS11172AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245IS11172AudioMode_audioSamplingChoiceSize )
		{
			if( pObj->choice > ((ASNH245IS11172AudioMode_audioSamplingChoice)(e_ASNH245IS11172AudioMode_audioSamplingChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245IS11172AudioMode_audioSamplingChoiceSize)) )
	}
	else
	{
		if( e_ASNH245IS11172AudioMode_audioSamplingChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling32k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling44k1 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling48k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245IS11172AudioMode_audioSampling Decode */
HS_RESULT ASNH245IS11172AudioMode_audioSampling_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245IS11172AudioMode_audioSampling *pObj = (ASNH245IS11172AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245IS11172AudioMode_audioSamplingChoiceSize;
	}
	else
	{
		if( e_ASNH245IS11172AudioMode_audioSamplingChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245IS11172AudioMode_audioSamplingChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245IS11172AudioMode_audioSamplingChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245IS11172AudioMode_audioSampling_SetChoice( pObj, (ASNH245IS11172AudioMode_audioSamplingChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling32k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling44k1 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling48k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS11172AudioMode_audioSampling Print */
HS_RESULT ASNH245IS11172AudioMode_audioSampling_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS11172AudioMode_audioSampling *pObj = (ASNH245IS11172AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS11172AudioMode_audioSampling_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling32k ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioSampling32k" );
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling44k1 ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioSampling44k1" );
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_audioSamplingChoice_audioSampling48k ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioSampling48k" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS11172AudioMode_multichannelType Struct
*/
/* ASNH245IS11172AudioMode_multichannelType Constructor */
HS_RESULT new_ASNH245IS11172AudioMode_multichannelType( void *pObject )
{
	ASNH245IS11172AudioMode_multichannelType *pObj = (ASNH245IS11172AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS11172AudioMode_multichannelType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245IS11172AudioMode_multichannelTypeChoice_singleChannel;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245IS11172AudioMode_multichannelTypeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245IS11172AudioMode_multichannelType Destructor */
HS_RESULT delete_ASNH245IS11172AudioMode_multichannelType( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245IS11172AudioMode_multichannelType *pObj = (ASNH245IS11172AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172AudioMode_multichannelType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245IS11172AudioMode_multichannelType_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172AudioMode_multichannelType(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245IS11172AudioMode_multichannelType SetChoice */
void* ASNH245IS11172AudioMode_multichannelType_SetChoice( void *pObject, ASNH245IS11172AudioMode_multichannelTypeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245IS11172AudioMode_multichannelType *pObj = (ASNH245IS11172AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245IS11172AudioMode_multichannelTypeChoiceSizeExt ){
		if( pChoice > (ASNH245IS11172AudioMode_multichannelTypeChoice)(e_ASNH245IS11172AudioMode_multichannelTypeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245IS11172AudioMode_multichannelType_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_singleChannel ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelStereo ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelDual ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245IS11172AudioMode_multichannelType DeleteAlternation */
HS_RESULT ASNH245IS11172AudioMode_multichannelType_DeleteAlternation(void *pObject)
{
	ASNH245IS11172AudioMode_multichannelType *pObj = (ASNH245IS11172AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_singleChannel ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelStereo ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelDual ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245IS11172AudioMode_multichannelType_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245IS11172AudioMode_multichannelType Encode */
HS_RESULT ASNH245IS11172AudioMode_multichannelType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245IS11172AudioMode_multichannelType *pObj = (ASNH245IS11172AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245IS11172AudioMode_multichannelTypeChoiceSize )
		{
			if( pObj->choice > ((ASNH245IS11172AudioMode_multichannelTypeChoice)(e_ASNH245IS11172AudioMode_multichannelTypeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245IS11172AudioMode_multichannelTypeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245IS11172AudioMode_multichannelTypeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_singleChannel ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelStereo ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelDual ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245IS11172AudioMode_multichannelType Decode */
HS_RESULT ASNH245IS11172AudioMode_multichannelType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245IS11172AudioMode_multichannelType *pObj = (ASNH245IS11172AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245IS11172AudioMode_multichannelTypeChoiceSize;
	}
	else
	{
		if( e_ASNH245IS11172AudioMode_multichannelTypeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245IS11172AudioMode_multichannelTypeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245IS11172AudioMode_multichannelTypeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245IS11172AudioMode_multichannelType_SetChoice( pObj, (ASNH245IS11172AudioMode_multichannelTypeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_singleChannel ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelStereo ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelDual ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS11172AudioMode_multichannelType Print */
HS_RESULT ASNH245IS11172AudioMode_multichannelType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS11172AudioMode_multichannelType *pObj = (ASNH245IS11172AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS11172AudioMode_multichannelType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_singleChannel ){
		AsnNull_Print( pObj->alter, pDepth+1, "singleChannel" );
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelStereo ){
		AsnNull_Print( pObj->alter, pDepth+1, "twoChannelStereo" );
	}
	else if ( pObj->choice == e_ASNH245IS11172AudioMode_multichannelTypeChoice_twoChannelDual ){
		AsnNull_Print( pObj->alter, pDepth+1, "twoChannelDual" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS11172AudioMode Class
*/
/*ASNH245IS11172AudioMode Constructor*/
HS_RESULT new_ASNH245IS11172AudioMode(void *pObject)
{
	ASNH245IS11172AudioMode *pObj = (ASNH245IS11172AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS11172AudioMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245IS11172AudioMode_audioLayer( &(pObj->m_audioLayer) );
	new_ASNH245IS11172AudioMode_audioSampling( &(pObj->m_audioSampling) );
	new_ASNH245IS11172AudioMode_multichannelType( &(pObj->m_multichannelType) );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 448, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245IS11172AudioMode Destructor */
HS_RESULT delete_ASNH245IS11172AudioMode(void *pObject)
{
	ASNH245IS11172AudioMode *pObj = (ASNH245IS11172AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS11172AudioMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245IS11172AudioMode_audioLayer( &(pObj->m_audioLayer) );
	delete_ASNH245IS11172AudioMode_audioSampling( &(pObj->m_audioSampling) );
	delete_ASNH245IS11172AudioMode_multichannelType( &(pObj->m_multichannelType) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	return HS_OK;
}

/* ASNH245IS11172AudioMode MakeMold */
HS_RESULT ASNH245IS11172AudioMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245IS11172AudioMode *pObj = (ASNH245IS11172AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245IS11172AudioMode Encode */
HS_RESULT ASNH245IS11172AudioMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245IS11172AudioMode *pObj = (ASNH245IS11172AudioMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245IS11172AudioMode_audioLayer_Encode( &(pObj->m_audioLayer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245IS11172AudioMode_audioSampling_Encode( &(pObj->m_audioSampling),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245IS11172AudioMode_multichannelType_Encode( &(pObj->m_multichannelType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245IS11172AudioMode Decode */
HS_RESULT ASNH245IS11172AudioMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245IS11172AudioMode *pObj = (ASNH245IS11172AudioMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245IS11172AudioMode_audioLayer_Decode(&(pObj->m_audioLayer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245IS11172AudioMode_audioSampling_Decode(&(pObj->m_audioSampling),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245IS11172AudioMode_multichannelType_Decode(&(pObj->m_multichannelType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS11172AudioMode Print */
HS_RESULT ASNH245IS11172AudioMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS11172AudioMode *pObj = (ASNH245IS11172AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS11172AudioMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245IS11172AudioMode_audioLayer_Print( &(pObj->m_audioLayer), pDepth+1, "audioLayer" );
	ASNH245IS11172AudioMode_audioSampling_Print( &(pObj->m_audioSampling), pDepth+1, "audioSampling" );
	ASNH245IS11172AudioMode_multichannelType_Print( &(pObj->m_multichannelType), pDepth+1, "multichannelType" );
	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS13818AudioMode_audioLayer Struct
*/
/* ASNH245IS13818AudioMode_audioLayer Constructor */
HS_RESULT new_ASNH245IS13818AudioMode_audioLayer( void *pObject )
{
	ASNH245IS13818AudioMode_audioLayer *pObj = (ASNH245IS13818AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS13818AudioMode_audioLayer(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer1;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245IS13818AudioMode_audioLayerChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245IS13818AudioMode_audioLayer Destructor */
HS_RESULT delete_ASNH245IS13818AudioMode_audioLayer( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245IS13818AudioMode_audioLayer *pObj = (ASNH245IS13818AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS13818AudioMode_audioLayer(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245IS13818AudioMode_audioLayer_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS13818AudioMode_audioLayer(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245IS13818AudioMode_audioLayer SetChoice */
void* ASNH245IS13818AudioMode_audioLayer_SetChoice( void *pObject, ASNH245IS13818AudioMode_audioLayerChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245IS13818AudioMode_audioLayer *pObj = (ASNH245IS13818AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245IS13818AudioMode_audioLayerChoiceSizeExt ){
		if( pChoice > (ASNH245IS13818AudioMode_audioLayerChoice)(e_ASNH245IS13818AudioMode_audioLayerChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245IS13818AudioMode_audioLayer_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer1 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer2 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer3 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245IS13818AudioMode_audioLayer DeleteAlternation */
HS_RESULT ASNH245IS13818AudioMode_audioLayer_DeleteAlternation(void *pObject)
{
	ASNH245IS13818AudioMode_audioLayer *pObj = (ASNH245IS13818AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer1 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer2 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer3 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245IS13818AudioMode_audioLayer_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245IS13818AudioMode_audioLayer Encode */
HS_RESULT ASNH245IS13818AudioMode_audioLayer_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245IS13818AudioMode_audioLayer *pObj = (ASNH245IS13818AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245IS13818AudioMode_audioLayerChoiceSize )
		{
			if( pObj->choice > ((ASNH245IS13818AudioMode_audioLayerChoice)(e_ASNH245IS13818AudioMode_audioLayerChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245IS13818AudioMode_audioLayerChoiceSize)) )
	}
	else
	{
		if( e_ASNH245IS13818AudioMode_audioLayerChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer1 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer2 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer3 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245IS13818AudioMode_audioLayer Decode */
HS_RESULT ASNH245IS13818AudioMode_audioLayer_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245IS13818AudioMode_audioLayer *pObj = (ASNH245IS13818AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245IS13818AudioMode_audioLayerChoiceSize;
	}
	else
	{
		if( e_ASNH245IS13818AudioMode_audioLayerChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245IS13818AudioMode_audioLayerChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245IS13818AudioMode_audioLayerChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245IS13818AudioMode_audioLayer_SetChoice( pObj, (ASNH245IS13818AudioMode_audioLayerChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer1 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer2 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer3 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS13818AudioMode_audioLayer Print */
HS_RESULT ASNH245IS13818AudioMode_audioLayer_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS13818AudioMode_audioLayer *pObj = (ASNH245IS13818AudioMode_audioLayer *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioLayer_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer1 ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioLayer1" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer2 ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioLayer2" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioLayerChoice_audioLayer3 ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioLayer3" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS13818AudioMode_audioSampling Struct
*/
/* ASNH245IS13818AudioMode_audioSampling Constructor */
HS_RESULT new_ASNH245IS13818AudioMode_audioSampling( void *pObject )
{
	ASNH245IS13818AudioMode_audioSampling *pObj = (ASNH245IS13818AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS13818AudioMode_audioSampling(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling16k;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245IS13818AudioMode_audioSamplingChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245IS13818AudioMode_audioSampling Destructor */
HS_RESULT delete_ASNH245IS13818AudioMode_audioSampling( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245IS13818AudioMode_audioSampling *pObj = (ASNH245IS13818AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS13818AudioMode_audioSampling(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245IS13818AudioMode_audioSampling_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS13818AudioMode_audioSampling(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245IS13818AudioMode_audioSampling SetChoice */
void* ASNH245IS13818AudioMode_audioSampling_SetChoice( void *pObject, ASNH245IS13818AudioMode_audioSamplingChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245IS13818AudioMode_audioSampling *pObj = (ASNH245IS13818AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245IS13818AudioMode_audioSamplingChoiceSizeExt ){
		if( pChoice > (ASNH245IS13818AudioMode_audioSamplingChoice)(e_ASNH245IS13818AudioMode_audioSamplingChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245IS13818AudioMode_audioSampling_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling16k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling22k05 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling24k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling32k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling44k1 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling48k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245IS13818AudioMode_audioSampling DeleteAlternation */
HS_RESULT ASNH245IS13818AudioMode_audioSampling_DeleteAlternation(void *pObject)
{
	ASNH245IS13818AudioMode_audioSampling *pObj = (ASNH245IS13818AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling16k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling22k05 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling24k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling32k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling44k1 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling48k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245IS13818AudioMode_audioSampling_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245IS13818AudioMode_audioSampling Encode */
HS_RESULT ASNH245IS13818AudioMode_audioSampling_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245IS13818AudioMode_audioSampling *pObj = (ASNH245IS13818AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245IS13818AudioMode_audioSamplingChoiceSize )
		{
			if( pObj->choice > ((ASNH245IS13818AudioMode_audioSamplingChoice)(e_ASNH245IS13818AudioMode_audioSamplingChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245IS13818AudioMode_audioSamplingChoiceSize)) )
	}
	else
	{
		if( e_ASNH245IS13818AudioMode_audioSamplingChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling16k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling22k05 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling24k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling32k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling44k1 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling48k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245IS13818AudioMode_audioSampling Decode */
HS_RESULT ASNH245IS13818AudioMode_audioSampling_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245IS13818AudioMode_audioSampling *pObj = (ASNH245IS13818AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245IS13818AudioMode_audioSamplingChoiceSize;
	}
	else
	{
		if( e_ASNH245IS13818AudioMode_audioSamplingChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245IS13818AudioMode_audioSamplingChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245IS13818AudioMode_audioSamplingChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245IS13818AudioMode_audioSampling_SetChoice( pObj, (ASNH245IS13818AudioMode_audioSamplingChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling16k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling22k05 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling24k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling32k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling44k1 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling48k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS13818AudioMode_audioSampling Print */
HS_RESULT ASNH245IS13818AudioMode_audioSampling_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS13818AudioMode_audioSampling *pObj = (ASNH245IS13818AudioMode_audioSampling *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS13818AudioMode_audioSampling_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling16k ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioSampling16k" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling22k05 ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioSampling22k05" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling24k ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioSampling24k" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling32k ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioSampling32k" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling44k1 ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioSampling44k1" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_audioSamplingChoice_audioSampling48k ){
		AsnNull_Print( pObj->alter, pDepth+1, "audioSampling48k" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS13818AudioMode_multichannelType Struct
*/
/* ASNH245IS13818AudioMode_multichannelType Constructor */
HS_RESULT new_ASNH245IS13818AudioMode_multichannelType( void *pObject )
{
	ASNH245IS13818AudioMode_multichannelType *pObj = (ASNH245IS13818AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS13818AudioMode_multichannelType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = FALSE;
	pObj->choice	 = e_ASNH245IS13818AudioMode_multichannelTypeChoice_singleChannel;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245IS13818AudioMode_multichannelTypeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245IS13818AudioMode_multichannelType Destructor */
HS_RESULT delete_ASNH245IS13818AudioMode_multichannelType( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245IS13818AudioMode_multichannelType *pObj = (ASNH245IS13818AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS13818AudioMode_multichannelType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245IS13818AudioMode_multichannelType_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS13818AudioMode_multichannelType(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245IS13818AudioMode_multichannelType SetChoice */
void* ASNH245IS13818AudioMode_multichannelType_SetChoice( void *pObject, ASNH245IS13818AudioMode_multichannelTypeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245IS13818AudioMode_multichannelType *pObj = (ASNH245IS13818AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245IS13818AudioMode_multichannelTypeChoiceSizeExt ){
		if( pChoice > (ASNH245IS13818AudioMode_multichannelTypeChoice)(e_ASNH245IS13818AudioMode_multichannelTypeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245IS13818AudioMode_multichannelType_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_singleChannel ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelStereo ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelDual ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels2_1 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels3_0 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_0_2_0 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_2 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels3_1 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_0_2_0 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_2 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245IS13818AudioMode_multichannelType DeleteAlternation */
HS_RESULT ASNH245IS13818AudioMode_multichannelType_DeleteAlternation(void *pObject)
{
	ASNH245IS13818AudioMode_multichannelType *pObj = (ASNH245IS13818AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_singleChannel ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelStereo ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelDual ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels2_1 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels3_0 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_0_2_0 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_2 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels3_1 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_0_2_0 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_2 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245IS13818AudioMode_multichannelType_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245IS13818AudioMode_multichannelType Encode */
HS_RESULT ASNH245IS13818AudioMode_multichannelType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245IS13818AudioMode_multichannelType *pObj = (ASNH245IS13818AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245IS13818AudioMode_multichannelTypeChoiceSize )
		{
			if( pObj->choice > ((ASNH245IS13818AudioMode_multichannelTypeChoice)(e_ASNH245IS13818AudioMode_multichannelTypeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245IS13818AudioMode_multichannelTypeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245IS13818AudioMode_multichannelTypeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_singleChannel ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelStereo ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelDual ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels2_1 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels3_0 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_0_2_0 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_2 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels3_1 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_0_2_0 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_2 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245IS13818AudioMode_multichannelType Decode */
HS_RESULT ASNH245IS13818AudioMode_multichannelType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245IS13818AudioMode_multichannelType *pObj = (ASNH245IS13818AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245IS13818AudioMode_multichannelTypeChoiceSize;
	}
	else
	{
		if( e_ASNH245IS13818AudioMode_multichannelTypeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245IS13818AudioMode_multichannelTypeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245IS13818AudioMode_multichannelTypeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245IS13818AudioMode_multichannelType_SetChoice( pObj, (ASNH245IS13818AudioMode_multichannelTypeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_singleChannel ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelStereo ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelDual ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels2_1 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels3_0 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_0_2_0 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_2 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels3_1 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_0_2_0 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_2 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS13818AudioMode_multichannelType Print */
HS_RESULT ASNH245IS13818AudioMode_multichannelType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS13818AudioMode_multichannelType *pObj = (ASNH245IS13818AudioMode_multichannelType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS13818AudioMode_multichannelType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_singleChannel ){
		AsnNull_Print( pObj->alter, pDepth+1, "singleChannel" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelStereo ){
		AsnNull_Print( pObj->alter, pDepth+1, "twoChannelStereo" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_twoChannelDual ){
		AsnNull_Print( pObj->alter, pDepth+1, "twoChannelDual" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels2_1 ){
		AsnNull_Print( pObj->alter, pDepth+1, "threeChannels2_1" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_threeChannels3_0 ){
		AsnNull_Print( pObj->alter, pDepth+1, "threeChannels3_0" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_0_2_0 ){
		AsnNull_Print( pObj->alter, pDepth+1, "fourChannels2_0_2_0" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels2_2 ){
		AsnNull_Print( pObj->alter, pDepth+1, "fourChannels2_2" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fourChannels3_1 ){
		AsnNull_Print( pObj->alter, pDepth+1, "fourChannels3_1" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_0_2_0 ){
		AsnNull_Print( pObj->alter, pDepth+1, "fiveChannels3_0_2_0" );
	}
	else if ( pObj->choice == e_ASNH245IS13818AudioMode_multichannelTypeChoice_fiveChannels3_2 ){
		AsnNull_Print( pObj->alter, pDepth+1, "fiveChannels3_2" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245IS13818AudioMode Class
*/
/*ASNH245IS13818AudioMode Constructor*/
HS_RESULT new_ASNH245IS13818AudioMode(void *pObject)
{
	ASNH245IS13818AudioMode *pObj = (ASNH245IS13818AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245IS13818AudioMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245IS13818AudioMode_audioLayer( &(pObj->m_audioLayer) );
	new_ASNH245IS13818AudioMode_audioSampling( &(pObj->m_audioSampling) );
	new_ASNH245IS13818AudioMode_multichannelType( &(pObj->m_multichannelType) );
	new_AsnBoolean( &(pObj->m_lowFrequencyEnhancement) );
	new_AsnBoolean( &(pObj->m_multilingual) );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 1, 1130, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245IS13818AudioMode Destructor */
HS_RESULT delete_ASNH245IS13818AudioMode(void *pObject)
{
	ASNH245IS13818AudioMode *pObj = (ASNH245IS13818AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245IS13818AudioMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245IS13818AudioMode_audioLayer( &(pObj->m_audioLayer) );
	delete_ASNH245IS13818AudioMode_audioSampling( &(pObj->m_audioSampling) );
	delete_ASNH245IS13818AudioMode_multichannelType( &(pObj->m_multichannelType) );
	delete_AsnBoolean( &(pObj->m_lowFrequencyEnhancement) );
	delete_AsnBoolean( &(pObj->m_multilingual) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	return HS_OK;
}

/* ASNH245IS13818AudioMode MakeMold */
HS_RESULT ASNH245IS13818AudioMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245IS13818AudioMode *pObj = (ASNH245IS13818AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245IS13818AudioMode Encode */
HS_RESULT ASNH245IS13818AudioMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245IS13818AudioMode *pObj = (ASNH245IS13818AudioMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245IS13818AudioMode_audioLayer_Encode( &(pObj->m_audioLayer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245IS13818AudioMode_audioSampling_Encode( &(pObj->m_audioSampling),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245IS13818AudioMode_multichannelType_Encode( &(pObj->m_multichannelType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_lowFrequencyEnhancement),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_multilingual),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245IS13818AudioMode Decode */
HS_RESULT ASNH245IS13818AudioMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245IS13818AudioMode *pObj = (ASNH245IS13818AudioMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245IS13818AudioMode_audioLayer_Decode(&(pObj->m_audioLayer),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245IS13818AudioMode_audioSampling_Decode(&(pObj->m_audioSampling),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245IS13818AudioMode_multichannelType_Decode(&(pObj->m_multichannelType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_lowFrequencyEnhancement),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_multilingual),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245IS13818AudioMode Print */
HS_RESULT ASNH245IS13818AudioMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245IS13818AudioMode *pObj = (ASNH245IS13818AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245IS13818AudioMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245IS13818AudioMode_audioLayer_Print( &(pObj->m_audioLayer), pDepth+1, "audioLayer" );
	ASNH245IS13818AudioMode_audioSampling_Print( &(pObj->m_audioSampling), pDepth+1, "audioSampling" );
	ASNH245IS13818AudioMode_multichannelType_Print( &(pObj->m_multichannelType), pDepth+1, "multichannelType" );
	AsnBoolean_Print( &(pObj->m_lowFrequencyEnhancement), pDepth+1, "lowFrequencyEnhancement" );
	AsnBoolean_Print( &(pObj->m_multilingual), pDepth+1, "multilingual" );
	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245G7231AnnexCMode_g723AnnexCAudioMode Class
*/
/*ASNH245G7231AnnexCMode_g723AnnexCAudioMode Constructor*/
HS_RESULT new_ASNH245G7231AnnexCMode_g723AnnexCAudioMode(void *pObject)
{
	ASNH245G7231AnnexCMode_g723AnnexCAudioMode *pObj = (ASNH245G7231AnnexCMode_g723AnnexCAudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245G7231AnnexCMode_g723AnnexCAudioMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_highRateMode0), e_constrained, 27, 78, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_highRateMode1), e_constrained, 27, 78, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_lowRateMode0), e_constrained, 23, 66, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_lowRateMode1), e_constrained, 23, 66, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_sidMode0), e_constrained, 6, 17, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_sidMode1), e_constrained, 6, 17, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245G7231AnnexCMode_g723AnnexCAudioMode Destructor */
HS_RESULT delete_ASNH245G7231AnnexCMode_g723AnnexCAudioMode(void *pObject)
{
	ASNH245G7231AnnexCMode_g723AnnexCAudioMode *pObj = (ASNH245G7231AnnexCMode_g723AnnexCAudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245G7231AnnexCMode_g723AnnexCAudioMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_highRateMode0) );
	delete_AsnInteger( &(pObj->m_highRateMode1) );
	delete_AsnInteger( &(pObj->m_lowRateMode0) );
	delete_AsnInteger( &(pObj->m_lowRateMode1) );
	delete_AsnInteger( &(pObj->m_sidMode0) );
	delete_AsnInteger( &(pObj->m_sidMode1) );
	return HS_OK;
}

/* ASNH245G7231AnnexCMode_g723AnnexCAudioMode MakeMold */
HS_RESULT ASNH245G7231AnnexCMode_g723AnnexCAudioMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245G7231AnnexCMode_g723AnnexCAudioMode *pObj = (ASNH245G7231AnnexCMode_g723AnnexCAudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245G7231AnnexCMode_g723AnnexCAudioMode Encode */
HS_RESULT ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245G7231AnnexCMode_g723AnnexCAudioMode *pObj = (ASNH245G7231AnnexCMode_g723AnnexCAudioMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_highRateMode0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_highRateMode1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_lowRateMode0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_lowRateMode1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_sidMode0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_sidMode1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245G7231AnnexCMode_g723AnnexCAudioMode Decode */
HS_RESULT ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245G7231AnnexCMode_g723AnnexCAudioMode *pObj = (ASNH245G7231AnnexCMode_g723AnnexCAudioMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_highRateMode0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_highRateMode1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_lowRateMode0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_lowRateMode1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_sidMode0),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_sidMode1),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245G7231AnnexCMode_g723AnnexCAudioMode Print */
HS_RESULT ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245G7231AnnexCMode_g723AnnexCAudioMode *pObj = (ASNH245G7231AnnexCMode_g723AnnexCAudioMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_highRateMode0), pDepth+1, "highRateMode0" );
	AsnInteger_Print( &(pObj->m_highRateMode1), pDepth+1, "highRateMode1" );
	AsnInteger_Print( &(pObj->m_lowRateMode0), pDepth+1, "lowRateMode0" );
	AsnInteger_Print( &(pObj->m_lowRateMode1), pDepth+1, "lowRateMode1" );
	AsnInteger_Print( &(pObj->m_sidMode0), pDepth+1, "sidMode0" );
	AsnInteger_Print( &(pObj->m_sidMode1), pDepth+1, "sidMode1" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245G7231AnnexCMode Class
*/
/*ASNH245G7231AnnexCMode Constructor*/
HS_RESULT new_ASNH245G7231AnnexCMode(void *pObject)
{
	ASNH245G7231AnnexCMode *pObj = (ASNH245G7231AnnexCMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245G7231AnnexCMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_maxAl_sduAudioFrames), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_silenceSuppression) );
	new_ASNH245G7231AnnexCMode_g723AnnexCAudioMode( &(pObj->m_g723AnnexCAudioMode) );

	return HS_OK;
}

/* ASNH245G7231AnnexCMode Destructor */
HS_RESULT delete_ASNH245G7231AnnexCMode(void *pObject)
{
	ASNH245G7231AnnexCMode *pObj = (ASNH245G7231AnnexCMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245G7231AnnexCMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_maxAl_sduAudioFrames) );
	delete_AsnBoolean( &(pObj->m_silenceSuppression) );
	delete_ASNH245G7231AnnexCMode_g723AnnexCAudioMode( &(pObj->m_g723AnnexCAudioMode) );
	return HS_OK;
}

/* ASNH245G7231AnnexCMode MakeMold */
HS_RESULT ASNH245G7231AnnexCMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245G7231AnnexCMode *pObj = (ASNH245G7231AnnexCMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245G7231AnnexCMode_g723AnnexCAudioMode_MakeMold(&(pObj->m_g723AnnexCAudioMode));
	return HS_OK;
}

/* ASNH245G7231AnnexCMode Encode */
HS_RESULT ASNH245G7231AnnexCMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245G7231AnnexCMode *pObj = (ASNH245G7231AnnexCMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_maxAl_sduAudioFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_silenceSuppression),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Encode( &(pObj->m_g723AnnexCAudioMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245G7231AnnexCMode Decode */
HS_RESULT ASNH245G7231AnnexCMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245G7231AnnexCMode *pObj = (ASNH245G7231AnnexCMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_maxAl_sduAudioFrames),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_silenceSuppression),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Decode(&(pObj->m_g723AnnexCAudioMode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245G7231AnnexCMode Print */
HS_RESULT ASNH245G7231AnnexCMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245G7231AnnexCMode *pObj = (ASNH245G7231AnnexCMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245G7231AnnexCMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_maxAl_sduAudioFrames), pDepth+1, "maxAl_sduAudioFrames" );
	AsnBoolean_Print( &(pObj->m_silenceSuppression), pDepth+1, "silenceSuppression" );
	ASNH245G7231AnnexCMode_g723AnnexCAudioMode_Print( &(pObj->m_g723AnnexCAudioMode), pDepth+1, "g723AnnexCAudioMode" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245AudioMode Struct
*/
/* ASNH245AudioMode Constructor */
HS_RESULT new_ASNH245AudioMode( void *pObject )
{
	ASNH245AudioMode *pObj = (ASNH245AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245AudioMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245AudioModeChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245AudioModeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245AudioMode Destructor */
HS_RESULT delete_ASNH245AudioMode( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245AudioMode *pObj = (ASNH245AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245AudioMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245AudioMode_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245AudioMode(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245AudioMode SetChoice */
void* ASNH245AudioMode_SetChoice( void *pObject, ASNH245AudioModeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245AudioMode *pObj = (ASNH245AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245AudioModeChoiceSizeExt ){
		if( pChoice > (ASNH245AudioModeChoice)(e_ASNH245AudioModeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245AudioMode_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245AudioModeChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g711Alaw64k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g711Alaw56k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g711Ulaw64k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g711Ulaw56k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g722_64k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g722_56k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g722_48k ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g728 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g729 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g729AnnexA ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g7231 ){
		ASNH245AudioMode_g7231 *tAlter = (ASNH245AudioMode_g7231 *)HSMalloc( sizeof(ASNH245AudioMode_g7231) );
		new_ASNH245AudioMode_g7231(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_is11172AudioMode ){
		ASNH245IS11172AudioMode *tAlter = (ASNH245IS11172AudioMode *)HSMalloc( sizeof(ASNH245IS11172AudioMode) );
		new_ASNH245IS11172AudioMode(tAlter);
		ASNH245IS11172AudioMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_is13818AudioMode ){
		ASNH245IS13818AudioMode *tAlter = (ASNH245IS13818AudioMode *)HSMalloc( sizeof(ASNH245IS13818AudioMode) );
		new_ASNH245IS13818AudioMode(tAlter);
		ASNH245IS13818AudioMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245AudioModeChoice_g729wAnnexB ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g729AnnexAwAnnexB ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g7231AnnexCMode ){
		ASNH245G7231AnnexCMode *tAlter = (ASNH245G7231AnnexCMode *)HSMalloc( sizeof(ASNH245G7231AnnexCMode) );
		new_ASNH245G7231AnnexCMode(tAlter);
		ASNH245G7231AnnexCMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_gsmFullRate ){
		ASNH245GSMAudioCapability *tAlter = (ASNH245GSMAudioCapability *)HSMalloc( sizeof(ASNH245GSMAudioCapability) );
		new_ASNH245GSMAudioCapability(tAlter);
		ASNH245GSMAudioCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_gsmHalfRate ){
		ASNH245GSMAudioCapability *tAlter = (ASNH245GSMAudioCapability *)HSMalloc( sizeof(ASNH245GSMAudioCapability) );
		new_ASNH245GSMAudioCapability(tAlter);
		ASNH245GSMAudioCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_gsmEnhancedFullRate ){
		ASNH245GSMAudioCapability *tAlter = (ASNH245GSMAudioCapability *)HSMalloc( sizeof(ASNH245GSMAudioCapability) );
		new_ASNH245GSMAudioCapability(tAlter);
		ASNH245GSMAudioCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_genericAudioMode ){
		ASNH245GenericCapability *tAlter = (ASNH245GenericCapability *)HSMalloc( sizeof(ASNH245GenericCapability) );
		new_ASNH245GenericCapability(tAlter);
		ASNH245GenericCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245AudioModeChoice_g729Extensions ){
		ASNH245G729Extensions *tAlter = (ASNH245G729Extensions *)HSMalloc( sizeof(ASNH245G729Extensions) );
		new_ASNH245G729Extensions(tAlter);
		ASNH245G729Extensions_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245AudioMode DeleteAlternation */
HS_RESULT ASNH245AudioMode_DeleteAlternation(void *pObject)
{
	ASNH245AudioMode *pObj = (ASNH245AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245AudioModeChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Alaw64k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Alaw56k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Ulaw64k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Ulaw56k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_64k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_56k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_48k ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g728 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g729 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g729AnnexA ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g7231 ){
			delete_ASNH245AudioMode_g7231(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_is11172AudioMode ){
			delete_ASNH245IS11172AudioMode(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_is13818AudioMode ){
			delete_ASNH245IS13818AudioMode(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g729wAnnexB ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g729AnnexAwAnnexB ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g7231AnnexCMode ){
			delete_ASNH245G7231AnnexCMode(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmFullRate ){
			delete_ASNH245GSMAudioCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmHalfRate ){
			delete_ASNH245GSMAudioCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmEnhancedFullRate ){
			delete_ASNH245GSMAudioCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_genericAudioMode ){
			delete_ASNH245GenericCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245AudioModeChoice_g729Extensions ){
			delete_ASNH245G729Extensions(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245AudioMode_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245AudioMode Encode */
HS_RESULT ASNH245AudioMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245AudioMode *pObj = (ASNH245AudioMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245AudioModeChoiceSize )
		{
			if( pObj->choice > ((ASNH245AudioModeChoice)(e_ASNH245AudioModeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245AudioModeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245AudioModeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245AudioModeChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Alaw64k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Alaw56k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Ulaw64k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Ulaw56k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_64k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_56k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_48k ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g728 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729AnnexA ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g7231 ){
		if( (tRet=ASNH245AudioMode_g7231_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_is11172AudioMode ){
		if( (tRet=ASNH245IS11172AudioMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_is13818AudioMode ){
		if( (tRet=ASNH245IS13818AudioMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729wAnnexB ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729AnnexAwAnnexB ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnInteger_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g7231AnnexCMode ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245G7231AnnexCMode_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmFullRate ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245GSMAudioCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmHalfRate ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245GSMAudioCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmEnhancedFullRate ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245GSMAudioCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_genericAudioMode ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245GenericCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729Extensions ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245G729Extensions_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245AudioMode Decode */
HS_RESULT ASNH245AudioMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245AudioMode *pObj = (ASNH245AudioMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245AudioModeChoiceSize;
	}
	else
	{
		if( e_ASNH245AudioModeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245AudioModeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245AudioModeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245AudioMode_SetChoice( pObj, (ASNH245AudioModeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245AudioModeChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Alaw64k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Alaw56k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Ulaw64k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Ulaw56k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_64k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_56k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_48k ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g728 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729AnnexA ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g7231 ){
		if( (tRet=ASNH245AudioMode_g7231_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_is11172AudioMode ){
		if( (tRet=ASNH245IS11172AudioMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_is13818AudioMode ){
		if( (tRet=ASNH245IS13818AudioMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729wAnnexB ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729AnnexAwAnnexB ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnInteger_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g7231AnnexCMode ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245G7231AnnexCMode_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmFullRate ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245GSMAudioCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmHalfRate ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245GSMAudioCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmEnhancedFullRate ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245GSMAudioCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_genericAudioMode ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245GenericCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729Extensions ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245G729Extensions_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245AudioMode_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245AudioMode Print */
HS_RESULT ASNH245AudioMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245AudioMode *pObj = (ASNH245AudioMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245AudioMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245AudioModeChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Alaw64k ){
		AsnNull_Print( pObj->alter, pDepth+1, "g711Alaw64k" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Alaw56k ){
		AsnNull_Print( pObj->alter, pDepth+1, "g711Alaw56k" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Ulaw64k ){
		AsnNull_Print( pObj->alter, pDepth+1, "g711Ulaw64k" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g711Ulaw56k ){
		AsnNull_Print( pObj->alter, pDepth+1, "g711Ulaw56k" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_64k ){
		AsnNull_Print( pObj->alter, pDepth+1, "g722_64k" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_56k ){
		AsnNull_Print( pObj->alter, pDepth+1, "g722_56k" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g722_48k ){
		AsnNull_Print( pObj->alter, pDepth+1, "g722_48k" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g728 ){
		AsnNull_Print( pObj->alter, pDepth+1, "g728" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729 ){
		AsnNull_Print( pObj->alter, pDepth+1, "g729" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729AnnexA ){
		AsnNull_Print( pObj->alter, pDepth+1, "g729AnnexA" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g7231 ){
		ASNH245AudioMode_g7231_Print( pObj->alter, pDepth+1, "g7231" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_is11172AudioMode ){
		ASNH245IS11172AudioMode_Print( pObj->alter, pDepth+1, "is11172AudioMode" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_is13818AudioMode ){
		ASNH245IS13818AudioMode_Print( pObj->alter, pDepth+1, "is13818AudioMode" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729wAnnexB ){
		AsnInteger_Print( pObj->alter, pDepth+1, "g729wAnnexB" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729AnnexAwAnnexB ){
		AsnInteger_Print( pObj->alter, pDepth+1, "g729AnnexAwAnnexB" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g7231AnnexCMode ){
		ASNH245G7231AnnexCMode_Print( pObj->alter, pDepth+1, "g7231AnnexCMode" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmFullRate ){
		ASNH245GSMAudioCapability_Print( pObj->alter, pDepth+1, "gsmFullRate" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmHalfRate ){
		ASNH245GSMAudioCapability_Print( pObj->alter, pDepth+1, "gsmHalfRate" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_gsmEnhancedFullRate ){
		ASNH245GSMAudioCapability_Print( pObj->alter, pDepth+1, "gsmEnhancedFullRate" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_genericAudioMode ){
		ASNH245GenericCapability_Print( pObj->alter, pDepth+1, "genericAudioMode" );
	}
	else if ( pObj->choice == e_ASNH245AudioModeChoice_g729Extensions ){
		ASNH245G729Extensions_Print( pObj->alter, pDepth+1, "g729Extensions" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataMode_application_nlpid Class
*/
/*ASNH245DataMode_application_nlpid Constructor*/
HS_RESULT new_ASNH245DataMode_application_nlpid(void *pObject)
{
	ASNH245DataMode_application_nlpid *pObj = (ASNH245DataMode_application_nlpid *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataMode_application_nlpid(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH245DataProtocolCapability( &(pObj->m_nlpidProtocol) );
	new_AsnOctetString( &(pObj->m_nlpidData), e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245DataMode_application_nlpid Destructor */
HS_RESULT delete_ASNH245DataMode_application_nlpid(void *pObject)
{
	ASNH245DataMode_application_nlpid *pObj = (ASNH245DataMode_application_nlpid *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataMode_application_nlpid(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245DataProtocolCapability( &(pObj->m_nlpidProtocol) );
	delete_AsnOctetString( &(pObj->m_nlpidData) );
	return HS_OK;
}

/* ASNH245DataMode_application_nlpid MakeMold */
HS_RESULT ASNH245DataMode_application_nlpid_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245DataMode_application_nlpid *pObj = (ASNH245DataMode_application_nlpid *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_nlpid_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245DataProtocolCapability_MakeMold(&(pObj->m_nlpidProtocol));
	return HS_OK;
}

/* ASNH245DataMode_application_nlpid Encode */
HS_RESULT ASNH245DataMode_application_nlpid_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataMode_application_nlpid *pObj = (ASNH245DataMode_application_nlpid *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_nlpid_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245DataProtocolCapability_Encode( &(pObj->m_nlpidProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_nlpid_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_nlpidData),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_nlpid_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245DataMode_application_nlpid Decode */
HS_RESULT ASNH245DataMode_application_nlpid_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataMode_application_nlpid *pObj = (ASNH245DataMode_application_nlpid *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_nlpid_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245DataProtocolCapability_Decode(&(pObj->m_nlpidProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_nlpid_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_nlpidData),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_nlpid_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataMode_application_nlpid Print */
HS_RESULT ASNH245DataMode_application_nlpid_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataMode_application_nlpid *pObj = (ASNH245DataMode_application_nlpid *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataMode_application_nlpid_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245DataProtocolCapability_Print( &(pObj->m_nlpidProtocol), pDepth+1, "nlpidProtocol" );
	AsnOctetString_Print( &(pObj->m_nlpidData), pDepth+1, "nlpidData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataMode_application_t38fax Class
*/
/*ASNH245DataMode_application_t38fax Constructor*/
HS_RESULT new_ASNH245DataMode_application_t38fax(void *pObject)
{
	ASNH245DataMode_application_t38fax *pObj = (ASNH245DataMode_application_t38fax *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataMode_application_t38fax(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH245DataProtocolCapability( &(pObj->m_t38FaxProtocol) );
	new_ASNH245T38FaxProfile( &(pObj->m_t38FaxProfile) );

	return HS_OK;
}

/* ASNH245DataMode_application_t38fax Destructor */
HS_RESULT delete_ASNH245DataMode_application_t38fax(void *pObject)
{
	ASNH245DataMode_application_t38fax *pObj = (ASNH245DataMode_application_t38fax *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataMode_application_t38fax(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245DataProtocolCapability( &(pObj->m_t38FaxProtocol) );
	delete_ASNH245T38FaxProfile( &(pObj->m_t38FaxProfile) );
	return HS_OK;
}

/* ASNH245DataMode_application_t38fax MakeMold */
HS_RESULT ASNH245DataMode_application_t38fax_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245DataMode_application_t38fax *pObj = (ASNH245DataMode_application_t38fax *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_t38fax_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245DataProtocolCapability_MakeMold(&(pObj->m_t38FaxProtocol));
	ASNH245T38FaxProfile_MakeMold(&(pObj->m_t38FaxProfile));
	return HS_OK;
}

/* ASNH245DataMode_application_t38fax Encode */
HS_RESULT ASNH245DataMode_application_t38fax_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataMode_application_t38fax *pObj = (ASNH245DataMode_application_t38fax *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_t38fax_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245DataProtocolCapability_Encode( &(pObj->m_t38FaxProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_t38fax_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245T38FaxProfile_Encode( &(pObj->m_t38FaxProfile),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_t38fax_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245DataMode_application_t38fax Decode */
HS_RESULT ASNH245DataMode_application_t38fax_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataMode_application_t38fax *pObj = (ASNH245DataMode_application_t38fax *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_t38fax_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245DataProtocolCapability_Decode(&(pObj->m_t38FaxProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_t38fax_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH245T38FaxProfile_Decode(&(pObj->m_t38FaxProfile),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_t38fax_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataMode_application_t38fax Print */
HS_RESULT ASNH245DataMode_application_t38fax_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataMode_application_t38fax *pObj = (ASNH245DataMode_application_t38fax *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataMode_application_t38fax_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245DataProtocolCapability_Print( &(pObj->m_t38FaxProtocol), pDepth+1, "t38FaxProtocol" );
	ASNH245T38FaxProfile_Print( &(pObj->m_t38FaxProfile), pDepth+1, "t38FaxProfile" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataMode_application Struct
*/
/* ASNH245DataMode_application Constructor */
HS_RESULT new_ASNH245DataMode_application( void *pObject )
{
	ASNH245DataMode_application *pObj = (ASNH245DataMode_application *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataMode_application(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245DataMode_applicationChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245DataMode_applicationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245DataMode_application Destructor */
HS_RESULT delete_ASNH245DataMode_application( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245DataMode_application *pObj = (ASNH245DataMode_application *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataMode_application(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245DataMode_application_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataMode_application(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245DataMode_application SetChoice */
void* ASNH245DataMode_application_SetChoice( void *pObject, ASNH245DataMode_applicationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245DataMode_application *pObj = (ASNH245DataMode_application *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245DataMode_applicationChoiceSizeExt ){
		if( pChoice > (ASNH245DataMode_applicationChoice)(e_ASNH245DataMode_applicationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245DataMode_application_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245DataMode_applicationChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_t120 ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_dsm_cc ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_userData ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_t84 ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_t434 ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_h224 ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_nlpid ){
		ASNH245DataMode_application_nlpid *tAlter = (ASNH245DataMode_application_nlpid *)HSMalloc( sizeof(ASNH245DataMode_application_nlpid) );
		new_ASNH245DataMode_application_nlpid(tAlter);
		ASNH245DataMode_application_nlpid_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_dsvdControl ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_h222DataPartitioning ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_t30fax ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_t140 ){
		ASNH245DataProtocolCapability *tAlter = (ASNH245DataProtocolCapability *)HSMalloc( sizeof(ASNH245DataProtocolCapability) );
		new_ASNH245DataProtocolCapability(tAlter);
		ASNH245DataProtocolCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_t38fax ){
		ASNH245DataMode_application_t38fax *tAlter = (ASNH245DataMode_application_t38fax *)HSMalloc( sizeof(ASNH245DataMode_application_t38fax) );
		new_ASNH245DataMode_application_t38fax(tAlter);
		ASNH245DataMode_application_t38fax_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245DataMode_applicationChoice_genericDataMode ){
		ASNH245GenericCapability *tAlter = (ASNH245GenericCapability *)HSMalloc( sizeof(ASNH245GenericCapability) );
		new_ASNH245GenericCapability(tAlter);
		ASNH245GenericCapability_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245DataMode_application DeleteAlternation */
HS_RESULT ASNH245DataMode_application_DeleteAlternation(void *pObject)
{
	ASNH245DataMode_application *pObj = (ASNH245DataMode_application *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245DataMode_applicationChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t120 ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_dsm_cc ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_userData ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t84 ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t434 ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_h224 ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_nlpid ){
			delete_ASNH245DataMode_application_nlpid(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_dsvdControl ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_h222DataPartitioning ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t30fax ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t140 ){
			delete_ASNH245DataProtocolCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t38fax ){
			delete_ASNH245DataMode_application_t38fax(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_genericDataMode ){
			delete_ASNH245GenericCapability(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245DataMode_application_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245DataMode_application Encode */
HS_RESULT ASNH245DataMode_application_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245DataMode_application *pObj = (ASNH245DataMode_application *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245DataMode_applicationChoiceSize )
		{
			if( pObj->choice > ((ASNH245DataMode_applicationChoice)(e_ASNH245DataMode_applicationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245DataMode_applicationChoiceSize)) )
	}
	else
	{
		if( e_ASNH245DataMode_applicationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataMode_applicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t120 ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_dsm_cc ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_userData ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t84 ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t434 ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_h224 ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_nlpid ){
		if( (tRet=ASNH245DataMode_application_nlpid_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_dsvdControl ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_h222DataPartitioning ){
		if( (tRet=ASNH245DataProtocolCapability_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t30fax ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245DataProtocolCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t140 ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245DataProtocolCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t38fax ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245DataMode_application_t38fax_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_genericDataMode ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH245GenericCapability_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245DataMode_application Decode */
HS_RESULT ASNH245DataMode_application_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245DataMode_application *pObj = (ASNH245DataMode_application *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245DataMode_applicationChoiceSize;
	}
	else
	{
		if( e_ASNH245DataMode_applicationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245DataMode_applicationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245DataMode_applicationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245DataMode_application_SetChoice( pObj, (ASNH245DataMode_applicationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataMode_applicationChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t120 ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_dsm_cc ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_userData ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t84 ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t434 ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_h224 ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_nlpid ){
		if( (tRet=ASNH245DataMode_application_nlpid_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_dsvdControl ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_h222DataPartitioning ){
		if( (tRet=ASNH245DataProtocolCapability_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t30fax ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245DataProtocolCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t140 ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245DataProtocolCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t38fax ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245DataMode_application_t38fax_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_genericDataMode ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH245GenericCapability_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_application_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataMode_application Print */
HS_RESULT ASNH245DataMode_application_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataMode_application *pObj = (ASNH245DataMode_application *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataMode_application_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245DataMode_applicationChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t120 ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "t120" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_dsm_cc ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "dsm_cc" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_userData ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "userData" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t84 ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "t84" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t434 ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "t434" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_h224 ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "h224" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_nlpid ){
		ASNH245DataMode_application_nlpid_Print( pObj->alter, pDepth+1, "nlpid" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_dsvdControl ){
		AsnNull_Print( pObj->alter, pDepth+1, "dsvdControl" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_h222DataPartitioning ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "h222DataPartitioning" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t30fax ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "t30fax" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t140 ){
		ASNH245DataProtocolCapability_Print( pObj->alter, pDepth+1, "t140" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_t38fax ){
		ASNH245DataMode_application_t38fax_Print( pObj->alter, pDepth+1, "t38fax" );
	}
	else if ( pObj->choice == e_ASNH245DataMode_applicationChoice_genericDataMode ){
		ASNH245GenericCapability_Print( pObj->alter, pDepth+1, "genericDataMode" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245DataMode Class
*/
/*ASNH245DataMode Constructor*/
HS_RESULT new_ASNH245DataMode(void *pObject)
{
	ASNH245DataMode *pObj = (ASNH245DataMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245DataMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245DataMode_application( &(pObj->m_application) );
	new_AsnInteger( &(pObj->m_bitRate), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH245DataMode Destructor */
HS_RESULT delete_ASNH245DataMode(void *pObject)
{
	ASNH245DataMode *pObj = (ASNH245DataMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245DataMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245DataMode_application( &(pObj->m_application) );
	delete_AsnInteger( &(pObj->m_bitRate) );
	return HS_OK;
}

/* ASNH245DataMode MakeMold */
HS_RESULT ASNH245DataMode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245DataMode *pObj = (ASNH245DataMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH245DataMode Encode */
HS_RESULT ASNH245DataMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataMode *pObj = (ASNH245DataMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH245DataMode_application_Encode( &(pObj->m_application),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH245DataMode Decode */
HS_RESULT ASNH245DataMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245DataMode *pObj = (ASNH245DataMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH245DataMode_application_Decode(&(pObj->m_application),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_bitRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245DataMode_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245DataMode Print */
HS_RESULT ASNH245DataMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245DataMode *pObj = (ASNH245DataMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245DataMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH245DataMode_application_Print( &(pObj->m_application), pDepth+1, "application" );
	AsnInteger_Print( &(pObj->m_bitRate), pDepth+1, "bitRate" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H235Mode_mediaMode Struct
*/
/* ASNH245H235Mode_mediaMode Constructor */
HS_RESULT new_ASNH245H235Mode_mediaMode( void *pObject )
{
	ASNH245H235Mode_mediaMode *pObj = (ASNH245H235Mode_mediaMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H235Mode_mediaMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH245H235Mode_mediaModeChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH245H235Mode_mediaModeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH245H235Mode_mediaMode Destructor */
HS_RESULT delete_ASNH245H235Mode_mediaMode( void *pObject )
{
	HS_RESULT	tRet;

	ASNH245H235Mode_mediaMode *pObj = (ASNH245H235Mode_mediaMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H235Mode_mediaMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH245H235Mode_mediaMode_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H235Mode_mediaMode(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH245H235Mode_mediaMode SetChoice */
void* ASNH245H235Mode_mediaMode_SetChoice( void *pObject, ASNH245H235Mode_mediaModeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH245H235Mode_mediaMode *pObj = (ASNH245H235Mode_mediaMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH245H235Mode_mediaModeChoiceSizeExt ){
		if( pChoice > (ASNH245H235Mode_mediaModeChoice)(e_ASNH245H235Mode_mediaModeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH245H235Mode_mediaMode_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH245H235Mode_mediaModeChoice_nonStandard ){
		ASNH245NonStandardParameter *tAlter = (ASNH245NonStandardParameter *)HSMalloc( sizeof(ASNH245NonStandardParameter) );
		new_ASNH245NonStandardParameter(tAlter);
		ASNH245NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H235Mode_mediaModeChoice_videoMode ){
		ASNH245VideoMode *tAlter = (ASNH245VideoMode *)HSMalloc( sizeof(ASNH245VideoMode) );
		new_ASNH245VideoMode(tAlter);
		ASNH245VideoMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H235Mode_mediaModeChoice_audioMode ){
		ASNH245AudioMode *tAlter = (ASNH245AudioMode *)HSMalloc( sizeof(ASNH245AudioMode) );
		new_ASNH245AudioMode(tAlter);
		ASNH245AudioMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH245H235Mode_mediaModeChoice_dataMode ){
		ASNH245DataMode *tAlter = (ASNH245DataMode *)HSMalloc( sizeof(ASNH245DataMode) );
		new_ASNH245DataMode(tAlter);
		ASNH245DataMode_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH245H235Mode_mediaMode DeleteAlternation */
HS_RESULT ASNH245H235Mode_mediaMode_DeleteAlternation(void *pObject)
{
	ASNH245H235Mode_mediaMode *pObj = (ASNH245H235Mode_mediaMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_nonStandard ){
			delete_ASNH245NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_videoMode ){
			delete_ASNH245VideoMode(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_audioMode ){
			delete_ASNH245AudioMode(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_dataMode ){
			delete_ASNH245DataMode(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH245H235Mode_mediaMode_MakeMold( void *pObject ){return HS_OK;};

/* ASNH245H235Mode_mediaMode Encode */
HS_RESULT ASNH245H235Mode_mediaMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH245H235Mode_mediaMode *pObj = (ASNH245H235Mode_mediaMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH245H235Mode_mediaModeChoiceSize )
		{
			if( pObj->choice > ((ASNH245H235Mode_mediaModeChoice)(e_ASNH245H235Mode_mediaModeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH245H235Mode_mediaModeChoiceSize)) )
	}
	else
	{
		if( e_ASNH245H235Mode_mediaModeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_videoMode ){
		if( (tRet=ASNH245VideoMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_audioMode ){
		if( (tRet=ASNH245AudioMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_dataMode ){
		if( (tRet=ASNH245DataMode_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH245H235Mode_mediaMode Decode */
HS_RESULT ASNH245H235Mode_mediaMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH245H235Mode_mediaMode *pObj = (ASNH245H235Mode_mediaMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH245H235Mode_mediaModeChoiceSize;
	}
	else
	{
		if( e_ASNH245H235Mode_mediaModeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH245H235Mode_mediaModeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH245H235Mode_mediaModeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH245H235Mode_mediaMode_SetChoice( pObj, (ASNH245H235Mode_mediaModeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_nonStandard ){
		if( (tRet=ASNH245NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_videoMode ){
		if( (tRet=ASNH245VideoMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_audioMode ){
		if( (tRet=ASNH245AudioMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_dataMode ){
		if( (tRet=ASNH245DataMode_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH245H235Mode_mediaMode Print */
HS_RESULT ASNH245H235Mode_mediaMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH245H235Mode_mediaMode *pObj = (ASNH245H235Mode_mediaMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH245H235Mode_mediaMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_nonStandard ){
		ASNH245NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_videoMode ){
		ASNH245VideoMode_Print( pObj->alter, pDepth+1, "videoMode" );
	}
	else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_audioMode ){
		ASNH245AudioMode_Print( pObj->alter, pDepth+1, "audioMode" );
	}
	else if ( pObj->choice == e_ASNH245H235Mode_mediaModeChoice_dataMode ){
		ASNH245DataMode_Print( pObj->alter, pDepth+1, "dataMode" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH245H235Mode Class
*/
/*ASNH245H235Mode Constructor*/
HS_RESULT new_ASNH245H235Mode(void *pObject)
{
	ASNH245H235Mode *pObj = (ASNH245H235Mode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH245H235Mode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH245EncryptionAuthenticationAndIntegrity( &(pObj->m_encryptionAuthenticationAndIntegrity) );
	new_ASNH245H235Mode_mediaMode( &(pObj->m_mediaMode) );

	return HS_OK;
}

/* ASNH245H235Mode Destructor */
HS_RESULT delete_ASNH245H235Mode(void *pObject)
{
	ASNH245H235Mode *pObj = (ASNH245H235Mode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH245H235Mode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH245EncryptionAuthenticationAndIntegrity( &(pObj->m_encryptionAuthenticationAndIntegrity) );
	delete_ASNH245H235Mode_mediaMode( &(pObj->m_mediaMode) );
	return HS_OK;
}

/* ASNH245H235Mode MakeMold */
HS_RESULT ASNH245H235Mode_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH245H235Mode *pObj = (ASNH245H235Mode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH245EncryptionAuthenticationAndIntegrity_MakeMold(&(pObj->m_encryptionAuthenticationAndIntegrity));
	return HS_OK;
}

/* ASNH245H235Mode Encode */
HS_RESULT ASNH245H235Mode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH245H235Mode *pObj = (ASNH245H235Mode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH245H235Mode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj-