/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<handship.cxx>	2005-02-20,19:25

*/


#include "handship.h"





/*********************************************************************************************************/
/* ASNScreeningIndicator Members
*/
/* ASNScreeningIndicator Constructor */
#ifdef HS_CPLUSPLUS
ASNH225ScreeningIndicator::ASNH225ScreeningIndicator()
: AsnObject( e_asnTagEnumerated )
#else
HS_RESULT new_ASNH225ScreeningIndicator( void *pObject )
#endif
{
	int i=0;
#ifndef HS_CPLUSPLUS
	ASNH225ScreeningIndicator *pObj = (ASNH225ScreeningIndicator *)pObject;
#else
	ASNH225ScreeningIndicator *pObj = this;
#endif
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN
		HSPrint( "\n Error on ASNScreeningIndicator::ASNScreeningIndicator(NULL) -> null parameter" );
#endif/*HS_DEBUG_ASN*/
#ifdef HS_CPLUSPLUS
		return;
#else
		return HS_ERR_NULL_PARAM;
#endif
	}

	pObj->value = e_enum_userProvidedNotScreened;
	pObj->extensionPoint = e_enum_networkProvided;

	pObj->enumSize = 0;
	for( i=0; i<HS_MAX_ENUMERATED; i++ )
		pObj->enumValue[i] = i;

#ifndef HS_CPLUSPLUS
	return HS_OK;
#endif
}


/* ASNScreeningIndicator Destructor */
#ifdef HS_CPLUSPLUS
ASNH225ScreeningIndicator::~ASNH225ScreeningIndicator(){}
#else
HS_RESULT delete_ASNH225ScreeningIndicator( void *pObject ){return HS_OK;}
HS_RESULT ASNH225ScreeningIndicator_MakeMold( void *pObject ){return HS_OK;}
#endif

/* ASNScreeningIndicator AddEnumValue */
#ifdef HS_CPLUSPLUS
HS_RESULT ASNH225ScreeningIndicator::AddEnumValue( int pEnumValue )
#else
HS_RESULT ASNH225ScreeningIndicator_AddEnumValue( void *pObject, int pEnumValue )
#endif
{
#ifndef HS_CPLUSPLUS
	ASNH225ScreeningIndicator *pObj = (ASNH225ScreeningIndicator *)pObject;
#else
	ASNH225ScreeningIndicator *pObj = this;
#endif
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN
		HSPrint( "\n Error on ASNScreeningIndicator::AddEnumValue(NULL,%d) -> null parameter", pEnumValue );
#endif/*HS_DEBUG_ASN*/
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->enumSize < HS_MAX_ENUMERATED )
		pObj->enumValue[ pObj->enumSize ++ ] = pEnumValue;
	else
	{
#ifdef HS_DEBUG_ASN
		HSPrint( "\n Error on ASNScreeningIndicator::AddEnumValue(pObj,%d) -> full", pEnumValue );
#endif/*HS_DEBUG_ASN*/
		return HS_ERR_ASN_ENUMFULL;
	}

	return HS_OK;
}


/* ASNScreeningIndicator GetEnumValue */
#ifdef HS_CPLUSPLUS
HS_RESULT ASNH225ScreeningIndicator::GetEnumValue( HS_UINT pPoint, int *pEnumValue )
#else
HS_RESULT ASNH225ScreeningIndicator_GetEnumValue( void *pObject, HS_UINT pPoint, int *pEnumValue )
#endif
{
#ifndef HS_CPLUSPLUS
	ASNH225ScreeningIndicator *pObj = (ASNH225ScreeningIndicator *)pObject;
#else
	ASNH225ScreeningIndicator *pObj = this;
#endif
	if( pObj == HS_NULL || pEnumValue == HS_NULL )
	{
#ifdef HS_DEBUG_ASN
		HSPrint( "\n Error on ASNScreeningIndicator::GetEnumValue(%x,%u,%x) -> null parameter", pObj, pPoint, pEnumValue );
#endif/*HS_DEBUG_ASN*/
		return HS_ERR_NULL_PARAM;
	}

	if( pPoint > (pObj->enumSize-1) )
	{
#ifdef HS_DEBUG_ASN
		HSPrint( "\n Error on ASNScreeningIndicator::GetEnumValue(pObj,%u,pEnumValue) -> range over", pPoint );
#endif/*HS_DEBUG_ASN*/
		return HS_ERR_ASN_OUTOF_RANGE;
	}
	
	*pEnumValue = pObj->enumValue[ pPoint ];
	return HS_OK;
}


/* ASNScreeningIndicator SetValue */
#ifdef HS_CPLUSPLUS
HS_RESULT ASNH225ScreeningIndicator::SetValue( ASNScreeningIndicator_AsnEnumerated pEnum )
#else
HS_RESULT ASNH225ScreeningIndicator_SetValue( void *pObject, ASNScreeningIndicator_AsnEnumerated pEnum )
#endif
{
#ifndef HS_CPLUSPLUS
	ASNH225ScreeningIndicator *pObj = (ASNH225ScreeningIndicator *)pObject;
#else
	ASNH225ScreeningIndicator *pObj = this;
#endif
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN
		HSPrint( "\n Error on ASNScreeningIndicator::SetValue(NULL,%d) -> null parameter", (int)pEnum );
#endif/*HS_DEBUG_ASN*/
		return HS_ERR_NULL_PARAM;
	}

	pObj->value = pEnum;
	return HS_OK;
}


/* ASNScreeningIndicator Encode */
#ifdef HS_CPLUSPLUS
HS_RESULT ASNH225ScreeningIndicator::Encode( AsnStream *pStrm )
#else
HS_RESULT ASNH225ScreeningIndicator_Encode( void *pObject, AsnStream *pStrm )
#endif
{
	BOOL	tExtended = FALSE;
#ifndef HS_CPLUSPLUS
	ASNH225ScreeningIndicator *pObj = (ASNH225ScreeningIndicator *)pObject;
#else
	ASNH225ScreeningIndicator *pObj = this;
#endif
	if( pObj== HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN
		HSPrint( "\n Error on ASNScreeningIndicator::Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif/*HS_ASN_DEBG*/
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->extensionPoint < e_enum_networkProvided )
	{
		if( pObj->extensionPoint < pObj->value ) tExtended = TRUE;
		else									 tExtended = FALSE;

#ifdef HS_CPLUSPLUS
		pStrm->BitEncoding(tExtended);
#else
		AsnStream_BitEncoding( pStrm, tExtended );
#endif
	}

	if( tExtended )
		return SmallNumberEncoding( pStrm, (HS_UINT)(pObj->value) );
	else
		return ConstrainedNumberEncoding( pStrm, 0, (HS_UINT)e_enum_networkProvided, (HS_UINT)(pObj->value) );

	return HS_OK;
}


/* ASNScreeningIndicator Decode */
#ifdef HS_CPLUSPLUS
HS_RESULT ASNH225ScreeningIndicator::Decode( AsnStream *pStrm )
#else
HS_RESULT ASNH225ScreeningIndicator_Decode( void *pObject, AsnStream *pStrm )
#endif
{
	HS_RESULT		ret;
	HS_UINT			tValue;
	BOOL			tExtended = FALSE;
#ifndef HS_CPLUSPLUS
	ASNH225ScreeningIndicator *pObj = (ASNH225ScreeningIndicator *)pObject;
#else
	ASNH225ScreeningIndicator *pObj = this;
#endif
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN
		HSPrint( "\n Error on ASNScreeningIndicator::Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif/*HS_ASN_DEBG*/
		return HS_ERR_NULL_PARAM;
	}


	if( pObj->extensionPoint < e_enum_userProvidedNotScreened )
#ifdef HS_CPLUSPLUS
		pStrm->BitDecoding(&tExtended);
#else
		AsnStream_BitDecoding( pStrm, &tExtended );
#endif

	if( tExtended )
	{
		if( (ret = SmallNumberDecoding(pStrm,&tValue)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN
			HSPrint( "\n Error on ASNScreeningIndicator::Decode(pObj,pStrm) -> %d, line(%d)", ret, __LINE__ );
#endif/*HS_ASN_DEBG*/
			return ret;
		}

		pObj->value = (ASNScreeningIndicator_AsnEnumerated)( pObj->extensionPoint + tValue + 1 );
	}
	else
	{
		if( (ret = ConstrainedNumberDecoding(pStrm,0,e_enum_userProvidedNotScreened,&tValue)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN
			HSPrint( "\n Error on ASNScreeningIndicator::Decode(pObj,pStrm) -> %d, line(%d)", ret, __LINE__ );
#endif/*HS_ASN_DEBG*/
			return ret;
		}

		pObj->value = (ASNScreeningIndicator_AsnEnumerated)tValue;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNScreeningIndicator Print */
#ifdef HS_CPLUSPLUS
HS_RESULT ASNH225ScreeningIndicator::Print( HS_UINT pDepth, char *pTypeName )
#else
HS_RESULT ASNH225ScreeningIndicator_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
#endif
{
	HS_UINT i;
#ifndef HS_CPLUSPLUS
	ASNH225ScreeningIndicator *pObj = (ASNH225ScreeningIndicator *)pObject;
#else
	ASNH225ScreeningIndicator *pObj = this;
#endif	
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNScreeningIndicator::Print(NULL,%u,%s) -> null parameter", pDepth, (pTypeName==HS_NULL)? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint("\n");
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL )
		HSPrint( "%s<ENUMERATED> %d", pTypeName, (int)(pObj->value) );
	else
		HSPrint( "<ENUMERATED> %d", (int)(pObj->value) );

	return HS_OK;
}
#endif/*HS_DEBUG_ASN_PRINT*/
