/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<asnClass.cpp>		/AsnParser Project

*/


#include "asnClass.h"



const char *GetAsnTypeName( AsnType at )
{
	switch(at)
	{
		case e_extension:			return "exten";
		case e_choice:				return "chois";
		case e_set:					return "  set";
		case e_sequence:			return "  seq";
		case e_class:				return "class";
		case e_boolean:				return "booln";
		case e_integer:				return "integ";
		case e_bitString:			return "bitst";
		case e_octetString:			return "octst";
		case e_null:				return " null";
		case e_objectIdentifier:	return "objid";
		case e_enumerated:			return "enumu";
		case e_printableString:		return "pntst";
		case e_ia5String:			return "ia5st";
		case e_numericString:		return "numst";
		case e_generalString:		return "genst";
		case e_bmpString:			return "bmpst";
	}

	return "unkwn";
}
const char *GetConstraintTypeName( ConstType	ct )
{
	switch(ct)
	{
		case e_uncons:		return "uncon";
		case e_semicons:	return "secon";
		case e_cons:		return "const";
		case e_extcons:		return "excon";
	}

	return "unkwn";
}
char *SkipUnknownAsnClass( char *cName )
{
	if( ! cName ) return 0;

	if( !strcmp( cName, "ASNH225DataProtocolCapability" ) )
		return 0;
	if( !strcmp( cName, "ASNH225T38FaxProfile" ) )
		return 0;
	if( !strcmp( cName, "ASNH225ClearToken" ) )
		return 0;
	if( !strcmp( cName, "ASNH225CryptoH323Token" ) )
		return 0;
	if( !strcmp( cName, "ASNH225TimeStamp" ) )
		return 0;
	if( !strcmp( cName, "ASNH225AuthenticationMechanism" ) )
		return 0;
	if( !strcmp( cName, "AsnBoolean" ) )
		return 0;
	if( !strcmp( cName, "AsnNull" ) )
		return 0;
	if( !strcmp( cName, "AsnInteger" ) )
		return 0;
	if( !strcmp( cName, "AsnOctetString" ) )
		return 0;
	if( !strcmp( cName, "AsnBitString" ) )
		return 0;
	if( !strcmp( cName, "AsnSingleString" ) )
		return 0;
	if( !strcmp( cName, "AsnDoubleString" ) )
		return 0;
	if( !strcmp( cName, "AsnObjectIdentifier" ) )
		return 0;
	if( !strcmp( cName, "AsnEnumerated" ) )
		return 0;

	return cName;
}






/***************************************************/
/* AsnMember
*/
AsnMember::AsnMember()
{
	mName[0] = 0;
	cName[0] = 0;
	from[0]  = 0;

	type = e_extension;
	cons.type = e_uncons;
	cons.nMin = 0;
	cons.nMax = 0xffffffff;
	cons.eMin = 0;
	cons.eMax = 0xffffffff;
	consOf.type = e_uncons;
	consOf.nMin = 0;
	consOf.nMax = 0xffffffff;
	consOf.eMin = 0;
	consOf.eMax = 0xffffffff;

	of = false;
	optional = false;
	extended = false;
}
AsnMember::~AsnMember()
{
}

void AsnMember::SetMemberName( char *pName )
{
	if( pName == 0 ) return;
	strcpy( mName, pName );
}

void AsnMember::SetClassName()
{
	sprintf( cName, "%s_%s", mother->cName, mName );
}

void AsnMember::SetClassName( char *pName, const char *pFile )
{
	if( pName == 0 ) return;
	sprintf( cName, "ASN%s%s", pFile, pName );
}

void AsnMember::SetClassName( AsnType at )
{
	switch(at)
	{
		case e_boolean:				strcpy( cName, "AsnBoolean" );				break;
		case e_integer:				strcpy( cName, "AsnInteger" );				break;
		case e_bitString:			strcpy( cName, "AsnBitString" );			break;
		case e_octetString:			strcpy( cName, "AsnOctetString" );			break;
		case e_null:				strcpy( cName, "AsnNull" );					break;
		case e_objectIdentifier:	strcpy( cName, "AsnObjectIdentifier" );		break;
		case e_enumerated:			strcpy( cName, "AsnEnumerated" );			break;
		case e_printableString:
		case e_ia5String:
		case e_numericString:
		case e_generalString:		strcpy( cName, "AsnSingleString" );			break;
		case e_bmpString:			strcpy( cName, "AsnDoubleString" );			break;
	}
}








/***************************************************/
/* AsnClass
*/
AsnClass::AsnClass()
{
	cName[0]=0;
	sName[0]=0;
	from[0]=0;
	
	type = e_extension;
	cons.type = e_uncons;
	cons.nMin = 0;
	cons.nMax = 0xffffffff;
	cons.eMin = 0;
	cons.eMax = 0xffffffff;
	consOf.type = e_uncons;
	consOf.nMin = 0;
	consOf.nMax = 0xffffffff;
	consOf.eMin = 0;
	consOf.eMax = 0xffffffff;

	of = false;
	optional = false;
	extendable = false;

	mSize = 0;
	sorted = false;
	handship = false;

	for( int i=0; i<256; i++ )
		member[i].mother = this;
}
AsnClass::~AsnClass()
{
}
void AsnClass::PrintToFile(FILE *pFp)
{
	unsigned int j;
	bool opened=false;

	if( pFp == 0 )
	{
		char fileName[260];
		sprintf( fileName, "%s.txt", cName );
		pFp = fopen( fileName, "w" );
		if( pFp == 0 ) return;

		opened = true;
	}
	
	fprintf( pFp,
		"\n--------------------------------------------------------------------------------------------------------------"
	);

	for( j=0; j<mSize; j++ )
	{
		if( member[j].type == e_extension )
			fprintf( pFp, "\n ...," );
		else
		{
			fprintf( pFp, "\n[%s] %s/%s", GetAsnTypeName(member[j].type), member[j].cName, member[j].mName );
			if( member[j].cons.type == e_semicons )
				fprintf( pFp, " semicon(%d)", member[j].cons.nMin );
			else if( member[j].cons.type == e_cons )
				fprintf( pFp, " cons(%d..%u)", member[j].cons.nMin, member[j].cons.nMax );
			else if( member[j].cons.type == e_extcons )
				fprintf( pFp, " extcon(%d..%u,...,%d..%u)", member[j].cons.nMin, member[j].cons.nMax, member[j].cons.eMin, member[j].cons.eMax );

			if(member[j].of)
			{
				fprintf( pFp, " SeqOf" );
				if( member[j].consOf.type == e_semicons )
					fprintf( pFp, " of_semicon(%d)", member[j].consOf.nMin );
				else if( member[j].consOf.type == e_cons )
					fprintf( pFp, " of_cons(%d..%u)", member[j].consOf.nMin, member[j].consOf.nMax );
				else if( member[j].consOf.type == e_extcons )
					fprintf( pFp, " of_extcon(%d..%u,...,%d..%u)", member[j].consOf.nMin, member[j].consOf.nMax, member[j].consOf.eMin, member[j].consOf.eMax );
			}

			if( member[j].optional ) fprintf( pFp, " optional" );
			if( member[j].extended ) fprintf( pFp, " extended" );
			if( member[j].from[0] ) fprintf( pFp, " from(%s)", member[j].from );

		}
	}

	if( opened ) fclose(pFp);
}
bool AsnClass::MakeClass(AsnClassBox *acb, AsnContent *ctnt, ParseState pps, const char *pFile)
{
	ParseState ps = pps;
	int bDepth = 0;

	if( ctnt->word == 0 )
	{
		printf( "\n AsnClass() -> Class Making Complete" );
		return false;
	}

	while( ctnt->word )
	{
		switch(ctnt->word->kind)
		{
			case e_kword_end:
				printf( "\n AsnClass() -> line(%d) : unexpected 'END' keyword", ctnt->word->line );
				return false;
			case e_kword_begin:
				printf( "\n AsnClass() -> line(%d) : unexpected 'BEGIN' keyword", ctnt->word->line );
				return false;
			case e_kword_optional:
				if( ps==e_readyComma || ps==e_readyCommaOf ) member[mSize].optional = true;
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'OPTIONAL' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_choice:
				if( ps==e_readyType ){ type = e_choice;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType ){ member[mSize].type = e_choice;		ps=e_readyComma;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'CHOICE' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_set:
				if( ps==e_readyType ){ type = e_set;	ps=e_readyBrecisOf;	}
				else if( ps==e_readyMType ){ member[mSize].type = e_set;	ps=e_readyCommaOf;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'SET' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_sequence:
				if( ps==e_readyType ){ type = e_sequence;	ps=e_readyBrecisOf;	}
				else if( ps==e_readyMType ){ member[mSize].type = e_sequence;	ps=e_readyCommaOf;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'SEQUENCE' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_boolean:
				if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_boolean;		handship=true;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_boolean;	member[mSize].SetClassName(e_boolean);	ps=e_readyComma;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'BOOLEAN' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_integer:
				if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_integer;		handship=true;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_integer;	member[mSize].SetClassName(e_integer);	ps=e_readyComma;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'INTEGER' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_null:
				if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_null;		handship=true;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_null;	member[mSize].SetClassName(e_null);	ps=e_readyComma;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'NULL' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_enumerated:
#if 0
				if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_enumerated;		handship=true;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_enumerated;	member[mSize].SetClassName(e_enumerated);	ps=e_readyComma;	}
				else
				{
#endif
					printf( "\n AsnClass() -> line(%d) : 'ENUMERATED' (%s)", ctnt->word->line, cName );
#if 1
					ctnt->GoToBrecisClose();
					type=e_enumerated;
					handship = true;
					return true;
#else
					return false;
				}
#endif
				break;
			case e_kword_printableString:
				if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_printableString;		handship=true;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_printableString;	member[mSize].SetClassName(e_printableString);	ps=e_readyComma;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'PrintableString' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_ia5String:
				if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_ia5String;		handship=true;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_ia5String;	member[mSize].SetClassName(e_ia5String);	ps=e_readyComma;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'IA5String' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_numericString:
				if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_numericString;		handship=true;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_numericString;	member[mSize].SetClassName(e_numericString);	ps=e_readyComma;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'NumericString' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_generalString:
				if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_generalString;		handship=true;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_generalString;	member[mSize].SetClassName(e_generalString);	ps=e_readyComma;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'GeneralString' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_bmpString:
				if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_bmpString;		handship=true;	ps=e_readyBrecis;	}
				else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type=e_bmpString;	member[mSize].SetClassName(e_bmpString);	ps=e_readyComma;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'BMPString' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_kword_object:
				if( ctnt->GetNext() )
				{
					if( ctnt->word->kind == e_kword_identifier )
					{
						if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_objectIdentifier;		handship=true;	ps=e_readyBrecis;	break;	}
						else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type=e_objectIdentifier;	member[mSize].SetClassName(e_objectIdentifier);	ps=e_readyComma;	break;	}
					}
				}
				printf( "\n AsnClass() -> line(%d) : unexpected 'OBJECT' keyword", ctnt->word->line );
				return false;
			case e_kword_identifier:
				printf( "\n AsnClass() -> line(%d) : unexpected 'IDENTIFIER' keyword", ctnt->word->line );
				return false;
			case e_kword_bit:
				if( ctnt->GetNext() )
				{
					if( ctnt->word->kind == e_kword_string )
					{
						if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_bitString;		handship=true;	ps=e_readyBrecis;	break;	}
						else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_bitString;	member[mSize].SetClassName(e_bitString);	ps=e_readyComma;	break;	}
					}
				}
				printf( "\n AsnClass() -> line(%d) : unexpected 'BIT' keyword", ctnt->word->line );
				return false;
			case e_kword_octet:
				if( ctnt->GetNext() )
				{
					if( ctnt->word->kind == e_kword_string )
					{
						if( ps==e_readyType || ps==e_readyBrecisOf ){	type=e_octetString;		handship=true;	ps=e_readyBrecis;	break;	}
						else if( ps==e_readyMType || ps==e_readyCommaOf ){ member[mSize].type = e_octetString;	member[mSize].SetClassName(e_octetString);	ps=e_readyComma;	break;	}
					}
				}
				printf( "\n AsnClass() -> line(%d) : unexpected 'OCTET' keyword", ctnt->word->line );
				return false;
			case e_kword_string:
				printf( "\n AsnClass() -> line(%d) : unexpected 'STRING' keyword", ctnt->word->line );
				return false;
			case e_kword_size:
				if( ctnt->GetNext() )
				{
					if( ps==e_readyBrecis )
					{
						if( ctnt->GetSizeConstraint( &cons ) ) break;
					}
					else if( ps==e_readyBrecisOf )
					{
						if( ctnt->GetSizeConstraint( &consOf ) ) break;
					}
					else if( ps==e_readyComma )
					{
						if( ctnt->GetSizeConstraint( &(member[mSize].cons) ) ) break;
					}
					else if( ps==e_readyCommaOf )
					{
						if( ctnt->GetSizeConstraint( &(member[mSize].consOf) ) ) break;
					}
				}
				printf( "\n AsnClass() -> line(%d) : unexpected 'SIZE' keyword", ctnt->word->line );
				return false;
			case e_kword_from:
				if( ctnt->GetNext() )
				{
					if( ps==e_readyBrecis )
					{
						if( type==e_ia5String || type==e_printableString || type==e_numericString || type==e_generalString || type==e_bmpString )
						{
							if( ctnt->GetFromConstraint( from ) ) break;
						}
					}
					if( ps==e_readyComma )
					{
						if( member[mSize].type==e_ia5String || member[mSize].type==e_printableString || member[mSize].type==e_numericString || member[mSize].type==e_generalString || member[mSize].type==e_bmpString )
						{
							if( ctnt->GetFromConstraint( member[mSize].from ) ) break;
						}
					}
				}
				printf( "\n AsnClass() -> line(%d) : unexpected 'FROM' keyword", ctnt->word->line );
				return false;
			case e_kword_of:
				if( ps==e_readyBrecisOf ){	of=true;	ps=e_readyType;	}
				else if( ps==e_readyCommaOf ){	member[mSize].of=true;	ps=e_readyMType;	}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected 'OF' keyword", ctnt->word->line );
					return false;
				}
				break;
			case e_optr_note:
			case e_optr_class:
				break;
			case e_optr_brecisOpen:
				if( ps==e_readyBrecis || ps==e_readyBrecisOf ) ps=e_readyMember;
				else if( ps==e_readyComma || ps==e_readyCommaOf )
				{
					AsnClass *ac = new AsnClass();
					member[mSize].SetClassName();
					strcpy( ac->cName, member[mSize].cName );
					ac->type = member[mSize].type;
					if( ! ctnt->GetNext() )
					{
						printf( "\n AsnClass() -> line() : unexpected end of file(1)" );
						return false;
					}
					if( ac->MakeClass(acb,ctnt,e_readyMember,pFile) )
						acb->AddClass(ac);
					else
						return false;
				}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected '{' operator", ctnt->word->line );
					return false;
				}
				break;
			case e_optr_brecisClose:
				if( ps==e_readyMember || ps==e_readyComma || ps==e_readyCommaOf )
				{
					if( bDepth != 0 )
					{
						printf( "\n AsnClass() -> line(%d) : blank depth error (%d)", ctnt->word->line, bDepth );
						return false;
					}
					
					if(mSize)
					{
						if( member[mSize-1].type == e_extension || member[mSize-1].extended )
							member[mSize].extended = true;
					}
					mSize++;
					return true;
				}
				printf( "\n AsnClass() -> line(%d) : unexpected '}' operator", ctnt->word->line );
				return false;
			case e_optr_blankOpen:
				if( ps==e_readyComma || ps==e_readyCommaOf )
				{
					if( member[mSize].type == e_integer )
					{
						if( ! ctnt->GetSizeConstraint( &(member[mSize].cons) ) ) return false;
					}
					else bDepth++;
				}
				else if( ps==e_readyBrecis || ps==e_readyBrecisOf )
				{
					if( type == e_integer )
					{
						if( ! ctnt->GetSizeConstraint( &(cons) ) ) return false;
					}
					else bDepth++;
				}
				else bDepth++;
				break;
			case e_optr_blankClose:
				bDepth--;
				break;
			case e_optr_comma:
				if( ps==e_readyComma || ps==e_readyCommaOf )
				{
					if(mSize)
					{
						if( member[mSize-1].type == e_extension || member[mSize-1].extended )
							member[mSize].extended = true;
					}
					
					mSize++;
					ps=e_readyMember;
				}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected ',' operator", ctnt->word->line );
					return false;
				}
				break;
			case e_optr_dot1:
				printf( "\n AsnClass() -> line(%d) : unexpected '.' operator", ctnt->word->line );
				return false;
			case e_optr_dot2:
				printf( "\n AsnClass() -> line(%d) : unexpected '..' operator", ctnt->word->line );
				return false;
			case e_optr_dot3:
				if( ps==e_readyMember )
				{
					ps=e_readyComma;
					extendable = true;
				}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected '...' operator", ctnt->word->line );
					return false;
				}
				break;
			case e_optr_arrow:
				break;
			case e_word_normal:
				if( ps==e_readyClass )
				{
					sprintf( cName, "ASN%s%s", pFile, ctnt->word->str );
					ps=e_readyType;
				}
				else if( ps==e_readyType )
				{
					type = e_class;
					handship = true;
					sprintf( sName, "ASN%s%s", pFile, ctnt->word->str );
					ps=e_readyBrecis;
				}
				else if( ps==e_readyMember )
				{
					member[mSize].SetMemberName(ctnt->word->str);
					ps = e_readyMType;
				}
				else if( ps==e_readyMType )
				{
					member[mSize].type = e_class;
					member[mSize].SetClassName(ctnt->word->str,pFile);
					ps = e_readyComma;
				}
				else if( ps==e_readyBrecis || ps==e_readyBrecisOf )
				{
					handship = true;
					printf( "\n AsnClass() -> line(%d) : handship class(%s)", ctnt->word->line, cName );
					return true;
				}
				else
				{
					printf( "\n AsnClass() -> line(%d) : unexpected '%s' class", ctnt->word->line, ctnt->word->str );
					return false;
				}
				break;
			case e_word_string:
				printf( "\n AsnClass() -> line(%d) : unexpected '%s' string", ctnt->word->line, ctnt->word->str );
				return false;
			case e_word_numeric:
				printf( "\n AsnClass() -> line(%d) : unexpected '%s' number", ctnt->word->line, ctnt->word->str );
				return false;
			default:
				printf( "\n AsnClass() -> line(%d) : unexpected keyword type", ctnt->word->line );
				return false;
		}

		ctnt->GetNext();
	}

	printf( "\n AsnClass() -> line() : unexpected end of file(0)" );
	return false;
}






/***************************************************/
/* AsnClassBox
*/
AsnClassBox::AsnClassBox()
{
	unsigned int i;
	for( i=0; i<MAX_ASNCLASS; i++ )
		ac[i] = 0;

	acSize=0;
	handshipSize=0;
}
AsnClassBox::~AsnClassBox()
{
	AsnClass *deleter;
	unsigned int i;

	for( i=0; i<MAX_ASNCLASS; i++ )
	{
		if(ac[i])
		{
			deleter = (AsnClass*)(ac[i]);
			delete deleter;
		}
	}
}
void AsnClassBox::AddClass(AsnClass *c)
{
	if( acSize < MAX_ASNCLASS -1 )
		ac[acSize++] = c;
}
unsigned int AsnClassBox::FindClass( char *cName )
{
	unsigned int i;
	AsnClass *ret;

	for( i=0; i<acSize; i++ )
	{
		ret = (AsnClass*)(ac[i]);
		if( !strcmp(ret->cName,cName) )
			return i;
	}

	return 0xffffffff;
}
void AsnClassBox::PrintToFile( FILE *pFp )
{
	unsigned int i;
	AsnClass *tac=0;
	bool opened=false;

	if( pFp == 0 )
	{
		pFp = fopen( "AsnClassBox.txt", "w" );
		if( pFp == 0 ) return;

		opened = true;
	}

	for( i=0; i<acSize; i++ )
	{
		if( tac = (AsnClass *)ac[i] )
		{
			fprintf( pFp, "\n\n<%u> [%s] %s(%s), member:%u, ",
				i, GetAsnTypeName(tac->type), tac->cName, tac->sName[0]? tac->sName:"", tac->mSize
			);
			
			if( tac->cons.type == e_semicons )
				fprintf( pFp, " semicon(%d)", tac->cons.nMin );
			else if( tac->cons.type == e_cons )
				fprintf( pFp, " cons(%d..%u)", tac->cons.nMin, tac->cons.nMax );
			else if( tac->cons.type == e_extcons )
				fprintf( pFp, " extcon(%d..%u,...,%d..%u)", tac->cons.nMin, tac->cons.nMax, tac->cons.eMin, tac->cons.eMax );

			if(tac->of)
			{
				if( tac->consOf.type == e_semicons )
					fprintf( pFp, " of_semicon(%d)", tac->consOf.nMin );
				else if( tac->consOf.type == e_cons )
					fprintf( pFp, " of_cons(%d..%u)", tac->consOf.nMin, tac->consOf.nMax );
				else if( tac->consOf.type == e_extcons )
					fprintf( pFp, " of_extcon(%d..%u,...,%d..%u)", tac->consOf.nMin, tac->consOf.nMax, tac->consOf.eMin, tac->consOf.eMax );
			}

			if(tac->optional) fprintf( pFp, " optional" );
			if(tac->extendable) fprintf( pFp, " extendable" );
			if(tac->handship) fprintf( pFp, " handship" );
			if(tac->from[0]) fprintf( pFp, " from(%s)", tac->from );

			tac->PrintToFile(pFp);
		}
	}

	if( opened ) fclose(pFp);
}






bool MiroSort( AsnClassBox *boxTo, AsnClassBox *boxFrom, AsnClass *ac, unsigned int *pStack, unsigned int *pPos, CommandSet *cs )
{
	int i, j, k;

	unsigned int temp;
	unsigned int sPos = *pPos;
	char *cName;
	AsnClass *nClass;
	bool skip = false;

#if 0
	printf( "\n" );
	for( k=0; k<sPos; k++ )
		printf( "%d>", pStack[k] );
#endif

	for( i=0; i<ac->mSize; i++ )
	{
		if( cs->IsElement( ac->member[i].cName ) )
			cName = 0;
		else
			cName = ac->member[i].cName;

		if( ac->member[i].type == e_extension )
			cName = 0;

		if( cName )
		{
			temp = boxFrom->FindClass( cName );
			if( temp > boxFrom->acSize-1 )
			{
				printf( "\n Err:FileSort:NoClass:class[%s]:member[%s]:index[%d]", ac->cName, cName, i );
				return false;

			}

			skip = false;
			for( j=0; j<sPos; j++ )
			{
				if( pStack[j] == temp )
				{
					if( ac->type != e_choice )
					{
						printf( "\n" );
						for( k=0; k<sPos; k++ )
							printf( "%d=", pStack[k] );
						printf( "\n Err:FileSort:Conflict:class[%s]:member[%s]:temp[%d]", ac->cName, cName, temp );
						return false;
					}

					printf( "\n Inf:FileSort:SkipChoice:%s", ac->member[i].cName );
					skip = true;
				}
			}

			if( ! skip )
			{
				pStack[sPos++] = temp;
				if( sPos > boxFrom->acSize )
				{
					printf( "\n Err:FileSort:Stack is too big" );
					return false;
				}


				nClass = (AsnClass*)(boxFrom->ac[temp]);

				if( nClass->sorted || nClass->handship )
					sPos--;
				else
				{
					if( ! MiroSort(boxTo,boxFrom,nClass,pStack,&sPos,cs) )
						return false;
				}
			}
			else
			{
				skip = false;
			}
		}
	}


	sPos--;
	*pPos = sPos;

#if 0
	printf( "\n" );
	for( k=0; k<sPos; k++ )
		printf( "%d>", pStack[k] );
#endif

	AsnClass *nac = new AsnClass(*ac);
	ac->sorted = true;
	boxTo->AddClass(nac);
	return true;
}

AsnClassBox *AsnClassBoxSort( AsnClassBox *acb, CommandSet *cs )
{
	unsigned int dataStack[MAX_ASNCLASS+10];
	unsigned int i, stackPos=0;
	unsigned int hsSize=0;

	if( ! acb->acSize ) return 0;

	AsnClassBox *ret = new AsnClassBox();
	unsigned int size = acb->acSize;


	for( i=0; i<acb->acSize; i++ )
	{
		AsnClass *ac = (AsnClass*)acb->ac[i];
		if( ac->handship )
		{
			AsnClass *nac = new AsnClass(*ac);
			ac->sorted = true;
			ret->AddClass(nac);
			hsSize++;
		}
	}
	ret->handshipSize = hsSize;

	for( i=0; i<acb->acSize; i++ )
	{
		AsnClass *ac = (AsnClass*)acb->ac[i];
		if( ! ac->sorted )
		{
			dataStack[0] = i;
			stackPos=1;

			if( ! MiroSort( ret, acb, ac, dataStack, &stackPos, cs ) )
			{
				delete ret;
				return 0;
			}
		}
	}
	return ret;
}

