/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<AsnParser.cpp>	2005-02-13,16:00

*/
#include "asnFile.h"



#include <stdio.h>
#include <string>
#include <conio.h>






/*
c:\>asnparser H225 ASN323 -c -inc H235/TimeStamp H245/DataProtocolCapability,T38FaxProfile -nouse ClearToken,CryptoH323Token,AuthenticationMechanism
*/
int main( int argc, char **argv )
{
	FILE *fpAsn;
	CommandSet	cs;

	unsigned char	*fp;
	unsigned int	fpLen=0;
	unsigned char	fName[256];

	if( cs.MakeSet(argc,argv) == false )
	{
		printf( 
			"\n Usage : asnparser asnfilename outputDirectory -c|-cpp\n"
			"         -inc includeFileName/includeElement1,..,includeElementN ..\n"
			"         -nouse nouseElement1,..nouseElementN"
		);
		return 0;
	}

	sprintf( (char*)fName, ".%sASN\\%s.asn", DEFAULT_DIRECTORY, cs.pFile );
	fpAsn = fopen( (const char*)fName, "r" );
	if( fpAsn == 0 )
	{
		printf( "\n Err:FileOpen:Original:%s.asn", cs.pFile );
		return 0;
	}

	while(!feof(fpAsn))
	{
		fgetc(fpAsn);
		fpLen++;
	}

	fp = (unsigned char*)HSMalloc(fpLen+10);
	if( fp==0 )
	{
		printf( "\n Err:Malloc  :fp" );
		fclose(fpAsn);
	}

	fpLen = 0;
	fseek(fpAsn,0,SEEK_SET);
	while(!feof(fpAsn))
		fp[fpLen++]=fgetc(fpAsn);

	fp[fpLen] = 0;
	fclose(fpAsn);


	AsnClassBox acb;
	AsnContent ctnt(fp);
	while(1)
	{
		AsnClass *ac = new AsnClass();

		if( ac->MakeClass(&acb,&ctnt,e_readyClass,argv[1]) )
		{
			acb.AddClass(ac);
			
			if( ! ac->handship || ac->type == e_enumerated )
				ctnt.GetNext();
		}
		else break;
	}

	AsnClassBox *box = AsnClassBoxSort(&acb,&cs);
	if(box)
	{
		printf( "\n main() -> Box Sorting Complete" );
		box->PrintToFile(0);

		if( MakeAsnFile( box, &cs ) )
			printf( "\n main() -> File Making Complete" );
	}

	delete box;
	return 0;
}