/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<asnString.cpp>		2005-02-27,10:11

*/

#include "asnString.h"



const char *GetConstraintTypeNameForParsing( ConstType	ct )
{
	switch(ct)
	{
		case e_uncons:		return "e_unconstrained";
		case e_semicons:	return "e_semiConstrained";
		case e_cons:		return "e_constrained";
		case e_extcons:		return "e_constrainedExt";
	}

	return "e_unconstrained";
}
const char *GetSingleStringTagName( AsnType at )
{
	switch(at)
	{
		case e_printableString:	return "e_asnTagPrintableString";
		case e_ia5String:		return "e_asnTagIA5String";
		case e_numericString:	return "e_asnTagNumericString";
		case e_generalString:	return "e_asnTagGeneralString";
	}

	return "e_asnTagNumericString";
}
const char *GetSingleStringVminName( AsnType at )
{
	switch(at)
	{
		case e_printableString:	return "ASN_PRINTABLE_STRING_VMIN";
		case e_ia5String:		return "ASN_IA5_STRING_VMIN";
		case e_numericString:	return "ASN_NUMERIC_STRING_VMIN";
		case e_generalString:	return "ASN_GENERAL_STRING_VMIN";
	}

	return "ASN_NUMERIC_STRING_VMIN";
}
const char *GetSingleStringVmaxName( AsnType at )
{
	switch(at)
	{
		case e_printableString:	return "ASN_PRINTABLE_STRING_VMAX";
		case e_ia5String:		return "ASN_IA5_STRING_VMAX";
		case e_numericString:	return "ASN_NUMERIC_STRING_VMAX";
		case e_generalString:	return "ASN_GENERAL_STRING_VMAX";
	}

	return "ASN_NUMERIC_STRING_VMAX";
}
const char *GetDoubleStringTagName( AsnType at )
{
	switch(at)
	{
		case e_bmpString:	return "e_asnTagBMPString";
	}

	return "e_asnTagBMPString";
}
const char *GetDoubleStringVminName( AsnType at )
{
	switch(at)
	{
		case e_bmpString:		return "ASN_BMP_STRING_VMIN";
	}

	return "ASN_BMP_STRING_VMIN";
}
const char *GetDoubleStringVmaxName( AsnType at )
{
	switch(at)
	{
		case e_bmpString:	return "ASN_BMP_STRING_VMAX";
	}

	return "ASN_BMP_STRING_VMAX";
}