/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<commandSet.cpp>	2005-03-05,10:59

*/

#include "commandSet.h"



IncludeElement::IncludeElement(){	includeFile[0]=0;	size=0;	}
IncludeElement::~IncludeElement(){}

bool IncludeElement::MakeSet( char *pCmd )
{
	int i, pos;
	char elementName[256];
	int len = strlen(pCmd);

	if( pCmd == 0 ) return false;

	for( i=0; i<len; i++ )
	{
		if( pCmd[i] == '/' ) break;
	}

	if( i==len ) return false;
	memcpy(includeFile,pCmd,i);
	includeFile[i] = 0;

	i++;
	pos = 0;
	for( ; i<len; i++ )
	{
		if( pCmd[i] == ',' )
		{
			elementName[pos] = 0;
			strcpy(element[size++],elementName);
			pos = 0;
		}
		else 
			elementName[pos++] = pCmd[i];
	}

	elementName[pos] = 0;
	strcpy(element[size++],elementName);
	pos = 0;
	return true;
}


bool IncludeElement::IsElement( char *pName, char *pFileName )
{
	int i;
	char cmpStr[256];

	if( pName == 0 ) return false;

	for( i=0; i<size; i++ )
	{
		sprintf( cmpStr, "ASN%s%s", pFileName, element[i] );
		if( !strcmp(cmpStr,pName) ) return true;
	}

	return false;
}

bool IncludeElement::MakeCHeaderFile( FILE *pf, char *pFileName )
{
	int i;

	if( pf == 0 || pFileName == 0 ) return false;
	if( pFileName[0] == 0 || includeFile[0] == 0 ) return false;

	fprintf( pf, "#include \"%s.h\"\n", includeFile );
	for( i=0; i<size; i++ )
	{
		if( element[0] == 0 ) return false;
		fprintf( pf,
			"#define ASN%s%s ASN%s%s\n"
			"#define new_ASN%s%s new_ASN%s%s\n"
			"#define delete_ASN%s%s delete_ASN%s%s\n"
			"#define ASN%s%s_MakeMold ASN%s%s_MakeMold\n"
			"#define ASN%s%s_Print ASN%s%s_Print\n"
			"#define ASN%s%s_Encode ASN%s%s_Encode\n"
			"#define ASN%s%s_Decode ASN%s%s_Decode\n",
			pFileName, element[i], includeFile, element[i],
			pFileName, element[i], includeFile, element[i],
			pFileName, element[i], includeFile, element[i],
			pFileName, element[i], includeFile, element[i],
			pFileName, element[i], includeFile, element[i],
			pFileName, element[i], includeFile, element[i],
			pFileName, element[i], includeFile, element[i]
		);
	}

	return true;
}

bool IncludeElement::MakeCppHeaderFile( FILE *pf, char *pFileName )
{
	int i;

	if( pf == 0 || pFileName == 0 ) return false;
	if( pFileName[0] == 0 || includeFile[0] == 0 ) return false;

	fprintf( pf, "#include \"%s.h\"\n", includeFile );
	for( i=0; i<size; i++ )
	{
		if( element[0] == 0 ) return false;
		fprintf( pf,
			"#define ASN%s%s ASN%s%s\n",
			pFileName, element[i], includeFile, element[i]
		);
	}

	return true;
}

bool IncludeElement::MakeCSourceFile( FILE *pf, char *pFileName )
{
	return true;
}
bool IncludeElement::MakeCppSourceFile( FILE *pf, char *pFileName )
{
	return true;
}



IncludeElements::IncludeElements(){	size = 0;	}
IncludeElements::~IncludeElements(){}

bool IncludeElements::MakeSet( int pos, int maxPos, char **pCmds )
{
	int i;

	if( maxPos<=pos || pCmds == 0 ) return false;

	for( i=pos; i<maxPos; i++ )
	{
		if( pCmds[i][0] == '-' ) return true;
		if( element[size++].MakeSet( pCmds[i] ) == false ) return false;
	}

	return true;
}

bool IncludeElements::IsElement( char *pName, char *pFileName )
{
	int i;

	for( i=0; i<size; i++ )
	{
		if( element[i].IsElement( pName, pFileName ) == true ) return true;
	}

	return false;
}

bool IncludeElements::MakeCHeaderFile( FILE *pf, char *pFileName )
{
	int i;
	
	if( pf == 0 ) return false;

	for( i=0; i<size; i++ )
	{
		if( element[i].MakeCHeaderFile(pf,pFileName) == false ) return false;
	}

	return true;
}
bool IncludeElements::MakeCppHeaderFile( FILE *pf, char *pFileName )
{
	int i;
	
	if( pf == 0 ) return false;

	for( i=0; i<size; i++ )
	{
		if( element[i].MakeCppHeaderFile(pf,pFileName) == false ) return false;
	}

	return true;
}
bool IncludeElements::MakeCSourceFile( FILE *pf, char *pFileName )
{
	int i;
	
	if( pf == 0 ) return false;

	for( i=0; i<size; i++ )
	{
		if( element[i].MakeCSourceFile(pf,pFileName) == false ) return false;
	}

	return true;
}
bool IncludeElements::MakeCppSourceFile( FILE *pf, char *pFileName )
{
	int i;
	
	if( pf == 0 ) return false;

	for( i=0; i<size; i++ )
	{
		if( element[i].MakeCppSourceFile(pf,pFileName) == false ) return false;
	}

	return true;
}



NouseElements::NouseElements(){	size=0;	}
NouseElements::~NouseElements(){}

bool NouseElements::MakeSet( char *pCmd )
{
	int i, pos;
	char elementName[265];
	int len = strlen(pCmd);

	if( pCmd == 0 ) return false;

	pos = 0;
	for( i=0; i<len; i++ )
	{
		if( pCmd[i] == ',' )
		{
			elementName[pos] = 0;
			strcpy( element[size++], elementName );
			pos = 0;
		}
		else
			elementName[pos++] = pCmd[i];
	}

	elementName[pos] = 0;
	strcpy( element[size++], elementName );
	pos = 0;
	return true;
}

bool NouseElements::IsElement( char *pName, char *pFileName )
{
	int i;
	char cmpStr[256];

	if( pName == 0 ) return false;

	for( i=0; i<size; i++ )
	{
		sprintf( cmpStr, "ASN%s%s", pFileName, element[i] );
		if( !strcmp(cmpStr,pName) ) return true;
	}

	return false;
}

bool NouseElements::MakeCHeaderFile( FILE *pf, char *pFileName )
{
	int i;

	if( pf == 0 ) return false;

	for( i=0; i<size; i++ )
	{
		fprintf( pf, "ASN_NO_USE_YET(%s%s,\"%s%s\")\n", pFileName, element[i], pFileName, element[i] );
	}

	return true;
}

bool NouseElements::MakeCppHeaderFile( FILE *pf, char *pFileName )
{
	int i;

	if( pf == 0 ) return false;

	for( i=0; i<size; i++ )
	{
		fprintf( pf, "ASN_NO_USE_YET(%s%s,\"%s%s\")\n", pFileName, element[i], pFileName, element[i] );
	}

	return true;
}
bool NouseElements::MakeCSourceFile( FILE *pf, char *pFileName )
{
	int i;

	if( pf == 0 ) return false;

	for( i=0; i<size; i++ )
	{
		fprintf( pf, "ASN_NO_USE_YET_C(%s%s,\"%s%s\")\n", pFileName, element[i], pFileName, element[i] );
	}

	return true;
}
bool NouseElements::MakeCppSourceFile( FILE *pf, char *pFileName )
{
	return true;
}



CommandSet::CommandSet(){	cn=e_c;	pFile[0]=0;	pFolder[0]=0;	}
CommandSet::~CommandSet(){}

bool CommandSet::MakeSet( int pArgc, char **pArgv )
{
	int i, incPos=-1, usePos=-1;

	if( pArgc < 3 || pArgv == 0 ) return false;

	strcpy( pFile, pArgv[1] );
	strcpy( pFolder, pArgv[2] );

	for( i=0; i<pArgc; i++ )
	{
		if( pArgv[i][0] == '-' )
		{
			if( !strcmp( pArgv[i], "-c" ) )
				cn=e_c;
			else if( !strcmp( pArgv[i], "-cpp" ) )
				cn=e_cpp;
			else if( !strcmp( pArgv[i], "-inc" ) )
			{
				if( i+1 == pArgc ) return false;
				incPos = i+1;
			}
			else if( !strcmp( pArgv[i], "-nouse" ) )
			{
				if( i+1 == pArgc ) return false;
				usePos = i+1;
			}
			else return false;
		}
	}

	if( incPos > 3 )
	{
		if( inc.MakeSet( incPos, pArgc, pArgv ) == false ) return false;
	}
	if( usePos > 3 )
	{
		if( nouse.MakeSet( pArgv[usePos] ) == false ) return false;
	}

	return true;
}

bool CommandSet::IsElement( char *pName )
{
	if( pName == 0 ) return false;

	if( !strcmp( pName, "AsnBoolean" ) )
		return true;
	if( !strcmp( pName, "AsnNull" ) )
		return true;
	if( !strcmp( pName, "AsnInteger" ) )
		return true;
	if( !strcmp( pName, "AsnOctetString" ) )
		return true;
	if( !strcmp( pName, "AsnBitString" ) )
		return true;
	if( !strcmp( pName, "AsnSingleString" ) )
		return true;
	if( !strcmp( pName, "AsnDoubleString" ) )
		return true;
	if( !strcmp( pName, "AsnObjectIdentifier" ) )
		return true;
	if( !strcmp( pName, "AsnEnumerated" ) )
		return true;

	if( inc.IsElement( pName, pFile ) == true ) return true;
	if( nouse.IsElement( pName, pFile ) == true ) return true;

	return false;
}

bool CommandSet::MakeCHeaderFile( FILE *pf )
{
	if( nouse.MakeCHeaderFile(pf,pFile) == false ) return false;
	if( inc.MakeCHeaderFile(pf,pFile) == false ) return false;

	return true;
}
bool CommandSet::MakeCppHeaderFile( FILE *pf )
{
	if( nouse.MakeCppHeaderFile(pf,pFile) == false ) return false;
	if( inc.MakeCppHeaderFile(pf,pFile) == false ) return false;

	return true;
}
bool CommandSet::MakeCSourceFile( FILE *pf )
{
	if( nouse.MakeCSourceFile(pf,pFile) == false ) return false;
	if( inc.MakeCSourceFile(pf,pFile) == false ) return false;

	return true;
}
bool CommandSet::MakeCppSourceFile( FILE *pf )
{
	if( nouse.MakeCppSourceFile(pf,pFile) == false ) return false;
	if( inc.MakeCppSourceFile(pf,pFile) == false ) return false;

	return true;
}

