/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<commandSet.h>	2005-03-05,10:54

*/

#ifndef __2005_03_05__10_54__COMMANDSET_H__
#define __2005_03_05__10_54__COMMANDSET_H__

#include <string>





#define HSMalloc	malloc
#define HSFree		free





/*
c:\>asnparser H225 ASN323
    -c 
    -inc H235/TimeStamp H245/DataProtocolCapability,T38FaxProfile
    -nouse ClearToken,CryptoH323Token,AuthenticationMechanism
*/
//#define DEFAULT_DIRECTORY	"\\Zparser\\"
#define DEFAULT_DIRECTORY	"\\"

class IncludeElement
{
public:
	IncludeElement();
	~IncludeElement();

	bool MakeSet( char *pCmd );
	bool IsElement( char *pName, char *pFileName );

	bool MakeCHeaderFile( FILE *pf, char *pFileName );
	bool MakeCppHeaderFile( FILE *pf, char *pFileName );
	bool MakeCSourceFile( FILE *pf, char *pFileName );
	bool MakeCppSourceFile( FILE *pf, char *pFileName );

	char includeFile[256];
	char element[64][256];
	unsigned size;
};



class IncludeElements
{
public:
	IncludeElements();
	~IncludeElements();

	bool MakeSet( int pos, int maxPos, char **pCmds );
	bool IsElement( char *pName, char *pFileName );

	bool MakeCHeaderFile( FILE *pf, char *pFileName );
	bool MakeCppHeaderFile( FILE *pf, char *pFileName );
	bool MakeCSourceFile( FILE *pf, char *pFileName );
	bool MakeCppSourceFile( FILE *pf, char *pFileName );

	IncludeElement	element[32];
	unsigned size;
};


class NouseElements
{
public:
	NouseElements();
	~NouseElements();

	bool MakeSet( char *pCmd );
	bool IsElement( char *pName, char *pFileName );

	bool MakeCHeaderFile( FILE *pf, char *pFileName );
	bool MakeCppHeaderFile( FILE *pf, char *pFileName );
	bool MakeCSourceFile( FILE *pf, char *pFileName );
	bool MakeCppSourceFile( FILE *pf, char *pFileName );

	char element[64][256];
	unsigned size;
};


typedef enum
{
	e_c,
	e_cpp
} CompilerName;

class CommandSet
{
public:
	CommandSet();
	~CommandSet();

	bool MakeSet( int pArgc, char **pArgv );
	bool IsElement( char *pName );

	bool MakeCHeaderFile( FILE *pf );
	bool MakeCppHeaderFile( FILE *pf );
	bool MakeCSourceFile( FILE *pf );
	bool MakeCppSourceFile( FILE *pf );

	CompilerName	cn;

	char pFile[256];
	char pFolder[256];
	IncludeElements	inc;
	NouseElements	nouse;
};

#endif/*__2005_03_05__10_54__COMMANDSET_H__*/
