/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<CallClose.c>	2005-04-17,10:04

*/

#include "CallClose.h"



/* close H.245 channel,
   disengage admission,
   close Q.931 channel,
   CallbackRemoveCall,
   RMOVE_SOCKET_SET
*/
HS_RESULT CallClosing(
	StackInfo *pStack,
	IEndpoint *pEndpoint,
	NoLockList *pCalls,
	NoLockList *pWaits,
	ICall *pCall,
	CallCloseReason	pUserReason,
	ASNH225DisengageReasonChoice pDisReason,
	Q931CauseType pCause
)
{
	HS_RESULT tRet = HS_OK;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pCalls==HS_NULL || pWaits==HS_NULL ||
		pCall==HS_NULL ) return HS_ERR_NULL_PARAM;

	if( pUserReason > e_CallCloseReasonMax-1 )
		pUserReason = e_CallCloseReason_Normal;
	if( pDisReason > e_ASNH225DisengageReasonChoiceSizeExt-1 )
		pDisReason = e_ASNH225DisengageReasonChoice_normalDrop;
	if( pCause > e_Q931CauseType_InterworkingUnspecified )
		pCause = 0x100;

	if( (tRet=ReleaseControlChannel(pStack, pEndpoint, pCall)) != HS_OK )
	{
		if( pEndpoint->CallbackException != HS_NULL )
			pEndpoint->CallbackException(e_exception_h245close, tRet);
	}
	if( (tRet=ReleaseAdmission(pStack, pEndpoint, pCall, pWaits, pDisReason)) != HS_OK )
	{
		if( pEndpoint->CallbackException != HS_NULL )
			pEndpoint->CallbackException(e_exception_disengage, tRet);
	}
	if( (tRet=ReleaseSignalChannel(pStack, pEndpoint, pWaits, pCall, pCause)) != HS_OK )
	{
		if( pEndpoint->CallbackException != HS_NULL )
			pEndpoint->CallbackException(e_exception_q931close, tRet);
	}

	if( pEndpoint->CallbackCallRemoved != HS_NULL )
		pEndpoint->CallbackCallRemoved(pCall->handle, pUserReason, pCause);

	_HSThreadSendMessage(pStack->enetDemonQ,HS_QMESSAGE_REMOVE_SOCKET_SET,0,(LPARAM)(pCall->handle));
	return NoLockList_DeleteCallByHandle(pCalls, pCall->handle);
}


HS_RESULT ReleaseControlChannel(StackInfo *pStack, IEndpoint *pEndpoint, ICall *pCall )
{
	HS_RESULT tRet = HS_OK;
	ControlMsg *t245Msg = HS_NULL;

	if( pStack == HS_NULL || pEndpoint == HS_NULL || pCall == HS_NULL ) return HS_ERR_NULL_PARAM;

	/*stop media channels (made by faststart)*/
	CloseMedia(pStack, pEndpoint, pCall);
	NoLockList_Clear( &(pCall->receivedOlcSetList) );
	NoLockList_Clear( &(pCall->sendedOlcSetList) );

	if( pCall->h245State.session == HS_NO ) return HS_OK;

	t245Msg = MakeEndSessionCommandForDisconnect();
	if( t245Msg != HS_NULL )
	{
		tRet=AttemptH245Message(pStack, pEndpoint, t245Msg, pCall);
		delete_ControlMsg(t245Msg);
		HSFree(t245Msg);
	}
	else
		tRet = HS_ERR_H323_MAKE_MESSAGE;

#ifdef HS_DEBUG_H323
	if( tRet != HS_OK )
		HSPrint( "\n $ Fail to send H245 ESC" );
#endif

	_HSThreadSendMessage(pStack->enetDemonQ, HS_QMESSAGE_H245_CLOSE, 0, (LPARAM)(pCall->handle));
	return tRet;
}


HS_RESULT ReleaseAdmission(StackInfo *pStack, IEndpoint *pEndpoint, ICall *pCall, NoLockList *pWaits, ASNH225DisengageReasonChoice pReason )
{
	HS_USHORT tSN;
	HS_RESULT tRet;
	RasMsg *drq = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pCall==HS_NULL || pWaits==HS_NULL ||
		pReason > e_ASNH225DisengageReasonChoiceSizeExt-1 ) return HS_ERR_NULL_PARAM;
	if( pCall->isAdmission == HS_NO ) return HS_OK;
	if( (drq=MakeDRQ(pEndpoint, pCall, pReason, &tSN)) == HS_NULL ) return HS_ERR_H323_MAKE_MESSAGE;

	tRet = AttemptRasMessage(pStack, pEndpoint, pWaits, pCall->handle, tSN, drq);

	delete_RasMsg(drq);
	HSFree(drq);
	return tRet;
}


HS_RESULT ReleaseSignalChannel(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall, Q931CauseType pCause )
{
	HS_RESULT tRet = HS_OK;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_ERR_NULL_PARAM;

	/* stop IRR frequency timer
	   (sending that don't care ReleaseComplete transaction)
	*/
	HSKillTimer(HS_TID_IRR, pCall->handle);
	/* stop media channels (made by faststart)
	*/
	CloseMediaWithFastStart(pStack, pEndpoint, pCall);
	/* send releaseComplete
	*/
	if( pCall->q931State > e_Q931State_ReadySetup )
	{
		Q931Message *tQ931Msg = MakeQ931ReleaseComplete(pStack, pWaits, pCall, pCause);

		if( tQ931Msg != HS_NULL )
		{
			tRet = AttemptQ931Message(pStack, pEndpoint, pWaits, tQ931Msg, pCall);
			delete_Q931Message(tQ931Msg);
			HSFree(tQ931Msg);
		}
		else
			tRet = HS_ERR_H323_MAKE_MESSAGE;

#ifdef HS_DEBUG_H323
		if( tRet != HS_OK )
			HSPrint( "\n $ Fail to send Q931 RC" );
#endif
	}
	/* close socket
	*/
	_HSThreadSendMessage(pStack->enetDemonQ, HS_QMESSAGE_Q931_CLOSE, 0, (LPARAM)(pCall->handle));
	return tRet;
}

