/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<CallMessageMaker.c>	2005-03-20,10:49

*/

#include "CallMessageMaker.h"



unsigned char gPID_H225_V2_Q931[] = {gPID_H225_V2};
unsigned gSize_PID_H225_V2_Q931   = gSize_PID_H225_V2;



/************************************************************/
/* FastStart Messages
*/
/* MakeForwardFastStart */
static HS_RESULT MakeForwardFastStart( AsnOctetString *pOctetString, IEndpoint *pEndpoint, ICall *pCall, ICapability *pCapability, HS_USHORT pLCN )
{
	HS_RESULT tRet = HS_OK;
	HS_UINT tSessionId = 0;
	HS_UINT tRtpListenPort = HS_INVALID_PORT;

	AsnStream tStrm;
	ASNH245OpenLogicalChannel olc;
	ASNH245H2250LogicalChannelParameters *t2250 = HS_NULL;

	if( pOctetString == HS_NULL || pCapability == HS_NULL || pCall == HS_NULL ) return HS_ERR_NULL_PARAM;

	if( pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveVideoCapability )
		return HS_ERR_H323;
	else if( pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveAudioCapability )
		tSessionId = SESSION_ID_VIDEO;
	else if( pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveDataApplicationCapability )
		tSessionId = SESSION_ID_AUDIO;
	else
		return HS_ERR_H323;

	new_AsnStream(&tStrm, 128, TRUE);
	new_ASNH245OpenLogicalChannel(&olc);
	ASNH245OpenLogicalChannel_MakeMold(&olc);

	AsnInteger_SetValue( &(olc.m_forwardLogicalChannelNumber.inheritance), pLCN+100 );

	if( tSessionId == SESSION_ID_VIDEO )
	{
		tRtpListenPort = pCall->rtpListenPort+2;

		tRet = ASNH245VideoCapability_Copy(
			ASNH245DataType_SetChoice( &(olc.m_forwardLogicalChannelParameters.m_dataType), e_ASNH245DataTypeChoice_videoData ),
			pCapability->capability.alter
		);
		if( tRet != HS_OK )
		{
			delete_AsnStream(&tStrm);
			delete_ASNH245OpenLogicalChannel(&olc);
			return tRet;
		}
		AsnStream_Clear(&tStrm);
	}
	else
	{
		tRtpListenPort = pCall->rtpListenPort;

		tRet = ASNH245AudioCapability_Copy(
			ASNH245DataType_SetChoice( &(olc.m_forwardLogicalChannelParameters.m_dataType), e_ASNH245DataTypeChoice_audioData ),
			pCapability->capability.alter
		);
		if( tRet != HS_OK )
		{
			delete_AsnStream(&tStrm);
			delete_ASNH245OpenLogicalChannel(&olc);
			return tRet;
		}
		AsnStream_Clear(&tStrm);
	}

	t2250 =
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice(
		&(olc.m_forwardLogicalChannelParameters.m_multiplexParameters),
		e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters
	);

	if( t2250 == HS_NULL )
	{
		delete_AsnStream(&tStrm);
		delete_ASNH245OpenLogicalChannel(&olc);
		return HS_ERR_H323;
	}

	AsnInteger_SetValue( &(t2250->m_sessionID), tSessionId );
	ASNH245H2250LogicalChannelParameters_IncludeOptionField(
		t2250, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlChannel
	);
	ASNH225TransportAddress2ASNH245TransportAddress_WithPort(
		&(t2250->m_mediaControlChannel), &(pEndpoint->csaTsap), (HS_USHORT)(tRtpListenPort+1)
	);

	if( (tRet=ASNH245OpenLogicalChannel_Encode(&olc,&tStrm)) == HS_OK )
	{
		AsnStream_Aligning(&tStrm);
		AsnOctetString_SetValue(pOctetString, tStrm.byteOffset, tStrm.datas );
	}

	delete_AsnStream(&tStrm);
	delete_ASNH245OpenLogicalChannel(&olc);
	return tRet;
}


/* MakeReverseFastStart */
static HS_RESULT MakeReverseFastStart( AsnOctetString *pOctetString, IEndpoint *pEndpoint, ICall *pCall, ICapability *pCapability, HS_USHORT pLCN )
{
	HS_RESULT tRet = HS_OK;
	HS_UINT tSessionId = 0;
	HS_UINT tRtpListenPort = HS_INVALID_PORT;

	AsnStream tStrm;
	ASNH245OpenLogicalChannel olc;
	ASNH245H2250LogicalChannelParameters *t2250 = HS_NULL;

	if( pOctetString == HS_NULL || pCapability == HS_NULL || pCall == HS_NULL ) return HS_ERR_NULL_PARAM;

	if( pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveVideoCapability )
		return HS_ERR_H323;
	else if( pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveAudioCapability )
		tSessionId = SESSION_ID_VIDEO;
	else if( pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveDataApplicationCapability )
		tSessionId = SESSION_ID_AUDIO;
	else
		return HS_ERR_H323;

	new_AsnStream(&tStrm, 128, TRUE);
	new_ASNH245OpenLogicalChannel(&olc);
	ASNH245OpenLogicalChannel_MakeMold(&olc);

	AsnInteger_SetValue( &(olc.m_forwardLogicalChannelNumber.inheritance), pLCN );

	ASNH245DataType_SetChoice( &(olc.m_forwardLogicalChannelParameters.m_dataType), e_ASNH245DataTypeChoice_nullData );
	ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters_SetChoice(
		&(olc.m_forwardLogicalChannelParameters.m_multiplexParameters),
		e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_none
	);

	ASNH245OpenLogicalChannel_IncludeOptionField( &olc,
		e_ASNH245OpenLogicalChannelOptionMap_reverseLogicalChannelParameters );

	if( tSessionId == SESSION_ID_VIDEO )
	{
		tRtpListenPort = pCall->rtpListenPort+2;

		tRet = ASNH245VideoCapability_Copy(
			ASNH245DataType_SetChoice( &(olc.m_reverseLogicalChannelParameters.m_dataType), e_ASNH245DataTypeChoice_videoData ),
			pCapability->capability.alter
		);
		if( tRet != HS_OK )
		{
			delete_AsnStream(&tStrm);
			delete_ASNH245OpenLogicalChannel(&olc);
			return tRet;
		}
		AsnStream_Clear(&tStrm);
	}
	else
	{
		tRtpListenPort = pCall->rtpListenPort;

		tRet = ASNH245AudioCapability_Copy(
			ASNH245DataType_SetChoice( &(olc.m_reverseLogicalChannelParameters.m_dataType), e_ASNH245DataTypeChoice_audioData ),
			pCapability->capability.alter
		);
		if( tRet != HS_OK )
		{
			delete_AsnStream(&tStrm);
			delete_ASNH245OpenLogicalChannel(&olc);
			return tRet;
		}
		AsnStream_Clear(&tStrm);
	}

	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_IncludeOptionField(
		&(olc.m_reverseLogicalChannelParameters),
		e_ASNH245OpenLogicalChannel_reverseLogicalChannelParametersOptionMap_multiplexParameters
	);

	t2250 =
	ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters_SetChoice(
		&(olc.m_reverseLogicalChannelParameters.m_multiplexParameters),
		e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters
	);

	if( t2250 == HS_NULL )
	{
		delete_AsnStream(&tStrm);
		delete_ASNH245OpenLogicalChannel(&olc);
		return HS_ERR_H323;
	}

	AsnInteger_SetValue( &(t2250->m_sessionID), tSessionId );
	ASNH245H2250LogicalChannelParameters_IncludeOptionField(
		t2250, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaChannel
	);
	ASNH245H2250LogicalChannelParameters_IncludeOptionField(
		t2250, e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlChannel
	);
	ASNH225TransportAddress2ASNH245TransportAddress_WithPort(
		&(t2250->m_mediaChannel), &(pEndpoint->csaTsap), (HS_USHORT)(tRtpListenPort)
	);
	ASNH225TransportAddress2ASNH245TransportAddress_WithPort(
		&(t2250->m_mediaControlChannel), &(pEndpoint->csaTsap), (HS_USHORT)(tRtpListenPort+1)
	);

	if( (tRet=ASNH245OpenLogicalChannel_Encode(&olc,&tStrm)) == HS_OK )
	{
		AsnStream_Aligning(&tStrm);
		AsnOctetString_SetValue(pOctetString, tStrm.byteOffset, tStrm.datas );
	}

	delete_AsnStream(&tStrm);
	delete_ASNH245OpenLogicalChannel(&olc);
	return tRet;
}


/* MakeFastStartRequest */
HS_RESULT MakeFastStartRequest( AsnSequenceOf *pSequenceOf, IEndpoint *pEndpoint, ICall *pCall )
{
	HS_UINT i;
	HS_RESULT tRet;
	HS_USHORT tLCN;
	HS_UINT tAVSize = 0;

	NoLockList	*tCapabilities = HS_NULL;
	ChainUnit	*rounder = HS_NULL;
	ICapability	*pCapability = HS_NULL;


	if( pSequenceOf == HS_NULL || pEndpoint == HS_NULL || pCall == HS_NULL ) return HS_ERR_NULL_PARAM;

	tCapabilities = &(pCall->capabilities);
	if( tCapabilities->size == 0 ) return HS_ERR_H323_NOUNIT;


	rounder = tCapabilities->units;
	for( i=0; i<tCapabilities->size; i++ )
	{
		if( rounder == HS_NULL ) return HS_ERR_H323_CONFLICT;
		if( rounder->data == HS_NULL ) return HS_ERR_H323_CONFLICT;

		pCapability = (ICapability*)(rounder->data);
		if( pCapability->capability.choice > e_ASNH245CapabilityChoice_nonStandard &&
			pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveDataApplicationCapability )
			tAVSize++;

		rounder = rounder->next;
	}
	if( tAVSize == 0 ) return HS_ERR_H323_NOUNIT;

	AsnSequenceOf_SetSize(pSequenceOf, tAVSize*2 );

	rounder = tCapabilities->units;
	for( i=0; i<tAVSize; i++ )
	{
		pCapability = (ICapability*)(rounder->data);
		if( pCapability->capability.choice > e_ASNH245CapabilityChoice_nonStandard &&
			pCapability->capability.choice < e_ASNH245CapabilityChoice_receiveDataApplicationCapability )
		{
			if( (tLCN=ICall_MakeOLCChannelNumber(pCall)) == HS_INVALID_LOGICAL_CHANNEL_NUMBER ) return HS_ERR_H323;

			tRet = MakeForwardFastStart( AsnSequenceOf_GetUnit(pSequenceOf,i*2), pEndpoint, pCall, rounder->data, (HS_USHORT)tLCN );
			if( tRet != HS_OK ) return tRet;
			tRet = MakeReverseFastStart( AsnSequenceOf_GetUnit(pSequenceOf,(i*2)+1), pEndpoint, pCall, rounder->data, 1/*reverse direction is a call buddy's job*/ );
			if( tRet != HS_OK ) return tRet;
		}

		rounder = rounder->next;
	}

	return HS_OK;
}


/* MakeFastStartResponseUnit */
static HS_RESULT MakeFastStartResponseUnit( AsnOctetString *pOctetString, IEndpoint *pEndpoint, ICall *pCall, ASNH245OpenLogicalChannel *pOLC )
{
	HS_RESULT tRet;
	HS_USHORT tLCN;
	HS_UINT tRtpListenPort;
	AsnStream tStrm;
	ASNH245H2250LogicalChannelParameters *t2250 = HS_NULL;

	if( pOctetString == HS_NULL || pEndpoint == HS_NULL || pOLC == HS_NULL ) return HS_ERR_NULL_PARAM;

	/*reverse direction faststart*/
	if( ASNH245OpenLogicalChannel_IsIncludeOptionField(pOLC, e_ASNH245OpenLogicalChannelOptionMap_reverseLogicalChannelParameters ) )
	{
		/*set reverse logical channel number*/
		if( (tLCN=ICall_MakeOLCChannelNumber(pCall)) == HS_INVALID_LOGICAL_CHANNEL_NUMBER ) return HS_ERR_H323;
		AsnInteger_SetValue( &(pOLC->m_forwardLogicalChannelNumber.inheritance), (HS_UINT)(tLCN+100) );

		/*check data type*/
		if( pOLC->m_reverseLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_audioData )
			tRtpListenPort = pCall->rtpListenPort;
		else if( pOLC->m_reverseLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_videoData )
			tRtpListenPort = pCall->rtpListenPort+2;
		else
			return HS_ERR_H323_NOTFOUND;

		/*make response message*/
		if( pOLC->m_reverseLogicalChannelParameters.m_multiplexParameters.choice !=
			e_ASNH245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters
		) return HS_ERR_H323_INVALID_VALUE;

		t2250 = (ASNH245H2250LogicalChannelParameters*)(pOLC->m_reverseLogicalChannelParameters.m_multiplexParameters.alter);
		if( t2250 == HS_NULL ) return HS_ERR_H323_CONFLICT;

		t2250->optionMap[0] &= 0xdf;	/*1101 1111 : exclude mediaChannel option*/
		ASNH245H2250LogicalChannelParameters_IncludeOptionField(t2250,
			e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlChannel );

		ASNH225TransportAddress2ASNH245TransportAddress_WithPort(
			&(t2250->m_mediaControlChannel), &(pEndpoint->csaTsap), (HS_USHORT)(tRtpListenPort+1)
		);
	}

	/*forward direction faststart*/
	else
	{
		/*check data type*/
		if( pOLC->m_forwardLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_audioData )
			tRtpListenPort = pCall->rtpListenPort;
		else if( pOLC->m_forwardLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_videoData )
			tRtpListenPort = pCall->rtpListenPort+2;
		else
			return HS_ERR_H323_NOTFOUND;

		/*make response message*/
		if( pOLC->m_forwardLogicalChannelParameters.m_multiplexParameters.choice !=
			e_ASNH245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParametersChoice_h2250LogicalChannelParameters
		) return HS_ERR_H323_INVALID_VALUE;

		t2250 = (ASNH245H2250LogicalChannelParameters*)(pOLC->m_forwardLogicalChannelParameters.m_multiplexParameters.alter);
		if( t2250 == HS_NULL ) return HS_ERR_H323_CONFLICT;

		ASNH245H2250LogicalChannelParameters_IncludeOptionField(t2250,
			e_ASNH245H2250LogicalChannelParametersOptionMap_mediaChannel );
		ASNH245H2250LogicalChannelParameters_IncludeOptionField(t2250,
			e_ASNH245H2250LogicalChannelParametersOptionMap_mediaControlChannel );

		ASNH225TransportAddress2ASNH245TransportAddress_WithPort(
			&(t2250->m_mediaChannel), &(pEndpoint->csaTsap), (HS_USHORT)(tRtpListenPort)
		);
		ASNH225TransportAddress2ASNH245TransportAddress_WithPort(
			&(t2250->m_mediaControlChannel), &(pEndpoint->csaTsap), (HS_USHORT)(tRtpListenPort+1)
		);
	}

	new_AsnStream(&tStrm, 128, TRUE);
	if( (tRet=ASNH245OpenLogicalChannel_Encode(pOLC,&tStrm)) == HS_OK )
	{
		AsnStream_Aligning(&tStrm);
		AsnOctetString_SetValue(pOctetString, tStrm.byteOffset, tStrm.datas );
	}

	delete_AsnStream(&tStrm);
	return HS_OK;
}


/* MakeFastStartResponse */
HS_RESULT MakeFastStartResponse( AsnSequenceOf *pSequenceOf, IEndpoint *pEndpoint, ICall *pCall )
{
	HS_UINT i;
	HS_RESULT tRet;
	ChainUnit *rounder = HS_NULL;

	if( pSequenceOf == HS_NULL || pEndpoint == HS_NULL || pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( pCall->fsList.size == 0 ) return HS_ERR_H323_NOUNIT;

	AsnSequenceOf_SetSize(pSequenceOf, pCall->fsList.size);

	rounder = pCall->fsList.units;
	for( i=0; i<pCall->fsList.size; i++ )
	{
		if( rounder == HS_NULL ) return HS_ERR_H323_CONFLICT;
		if( rounder->data == HS_NULL ) return HS_ERR_H323_CONFLICT;

		tRet = MakeFastStartResponseUnit(
			AsnSequenceOf_GetUnit(pSequenceOf, i),
			pEndpoint, pCall, rounder->data
		);
		
		if( tRet != HS_OK ) return tRet;

		rounder = rounder->next;
	}

	return HS_OK;
}



/************************************************************/
/* Make UserToUser Message
*/
/* MakeSetup */
ASNH225H323_UserInformation *MakeSetup(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	HS_RESULT tRet;
	ASNH225Setup_UUIE *tSetup = HS_NULL;
	ASNH225H323_UserInformation *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (ASNH225H323_UserInformation*)HSMalloc( sizeof(ASNH225H323_UserInformation) );
	if( msg == HS_NULL ) return HS_NULL;

	new_ASNH225H323_UserInformation(msg);
	ASNH225H323_UserInformation_MakeMold(msg);

	ASNH225H323_UU_PDU_IncludeOptionField( &(msg->m_h323_uu_pdu), e_ASNH225H323_UU_PDUOptionMap_h245Tunneling );
	if( pCall->isTunneling )
	{
		msg->m_h323_uu_pdu.m_h245Tunneling.value = TRUE;
		if( TunnelingH245Message(pEndpoint, pCall, msg) != HS_OK )
		{
			delete_ASNH225H323_UserInformation(msg);
			HSFree(msg);
			return HS_NULL;
		}
	}
	else
		msg->m_h323_uu_pdu.m_h245Tunneling.value = FALSE;

	tSetup = (ASNH225Setup_UUIE*) ASNH225H323_UU_PDU_h323_message_body_SetChoice(
		&(msg->m_h323_uu_pdu.m_h323_message_body),
		e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setup
	);
	if( tSetup == HS_NULL )
	{
		delete_ASNH225H323_UserInformation(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnObjectIdentifier_SetValue( &(tSetup->m_protocolIdentifier), gPID_H225_V2_Q931, gSize_PID_H225_V2_Q931 );

	if( pCall->h245ListenPoint == e_H245ListenPoint_Setup &&
		pCall->isTunneling == HS_NO && pCall->h245ListenPort != HS_INVALID_PORT )
	{
		ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_h245Address );
		tRet=ASNH225TransportAddress_CopyWithPort( &(tSetup->m_h245Address), &(pEndpoint->csaTsap), (HS_USHORT)pCall->h245ListenPort );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}

	ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_sourceAddress );
	tRet = AliasAddresses2AsnSequenceOf( &(tSetup->m_sourceAddress), &(pCall->sourceAliases) );
	if( tRet != HS_OK )
	{
		delete_Q931Message( msg );
		HSFree( msg );
		return HS_NULL;
	}

	tSetup->m_sourceInfo.m_mc.value = FALSE;
	tSetup->m_sourceInfo.m_undefinedNode.value = FALSE;

	if( pEndpoint->type == e_EndpointType_gateway )
		ASNH225EndpointType_IncludeOptionField( &(tSetup->m_sourceInfo), e_ASNH225EndpointTypeOptionMap_gateway );
	else if( pEndpoint->type == e_EndpointType_terminal )
		ASNH225EndpointType_IncludeOptionField( &(tSetup->m_sourceInfo), e_ASNH225EndpointTypeOptionMap_terminal );

	ASNH225EndpointType_IncludeOptionField( &(tSetup->m_sourceInfo), e_ASNH225EndpointTypeOptionMap_vendor );
	AsnInteger_SetValue( &(tSetup->m_sourceInfo.m_vendor.m_vendor.m_t35CountryCode), pEndpoint->countryCode );
	AsnInteger_SetValue( &(tSetup->m_sourceInfo.m_vendor.m_vendor.m_t35Extension), pEndpoint->extensionCode );
	AsnInteger_SetValue( &(tSetup->m_sourceInfo.m_vendor.m_vendor.m_manufacturerCode), pEndpoint->manufactureCode );

	ASNH225VendorIdentifier_IncludeOptionField( &(tSetup->m_sourceInfo.m_vendor), e_ASNH225VendorIdentifierOptionMap_productId );
	AsnOctetString_SetValue( &(tSetup->m_sourceInfo.m_vendor.m_productId), strlen(pEndpoint->productId), pEndpoint->productId );
	ASNH225VendorIdentifier_IncludeOptionField( &(tSetup->m_sourceInfo.m_vendor), e_ASNH225VendorIdentifierOptionMap_versionId );
	AsnOctetString_SetValue( &(tSetup->m_sourceInfo.m_vendor.m_versionId), strlen(pEndpoint->versionId), pEndpoint->versionId );

	if( pCall->destAliases.size > 0 )
	{
		ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_destinationAddress );
		tRet = AliasAddresses2AsnSequenceOf( &(tSetup->m_destinationAddress), &(pCall->destAliases) );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}
	if( pCall->destExtraCallInfo.size > 0 )
	{
		ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_destExtraCallInfo );
		tRet = AliasAddresses2AsnSequenceOf( &(tSetup->m_destExtraCallInfo), &(pCall->destExtraCallInfo) );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}
	if( pCall->remoteExtensionAddress.size > 0 )
	{
		ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_remoteExtensionAddress );
		tRet = ASNH225AliasAddress_Copy(
			&(tSetup->m_remoteExtensionAddress), 
			NoLockList_GetData(&(pCall->remoteExtensionAddress),0)
		);
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}

	if( pCall->dcsaTsap.alter != HS_NULL )
	{
		ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_destCallSignalAddress );
		tRet=ASNH225TransportAddress_Copy( &(tSetup->m_destCallSignalAddress), &(pCall->dcsaTsap) );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}

	tSetup->m_activeMC.value = FALSE;
	AsnOctetString_SetValue( &(tSetup->m_conferenceID.inheritance), 16, pCall->confId );
	ASNH225Setup_UUIE_conferenceGoal_SetChoice(
		&(tSetup->m_conferenceGoal), e_ASNH225Setup_UUIE_conferenceGoalChoice_create
	);
	ASNH225CallType_SetChoice( &(tSetup->m_callType), e_ASNH225CallTypeChoice_pointToPoint );

	if( pCall->scsaTsap.alter != HS_NULL )
	{
		ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_sourceCallSignalAddress );
		tRet=ASNH225TransportAddress_Copy( &(tSetup->m_sourceCallSignalAddress), &(pCall->scsaTsap) );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}

	ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_callIdentifier );
	AsnOctetString_SetValue( &(tSetup->m_callIdentifier.m_guid.inheritance), 16, pCall->callId );

	if( pCall->isFastStart )
	{
		ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_fastStart );
		if( (tRet=MakeFastStartRequest( &(tSetup->m_fastStart), pEndpoint, pCall )) != HS_OK )
		{
			delete_Q931Message(msg);
			HSFree(msg);
			return HS_NULL;
		}
	}

	ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_mediaWaitForConnect );
	ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_canOverlapSend );
	ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_multipleCalls );
	ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_maintainConnection );

	if( IGatekeeper_IsRegisted(&(pEndpoint->gatekeeper)) == TRUE )
	{
		if( pEndpoint->gatekeeper.endpointIdentifier.inheritance.length > 0 )
		{
			ASNH225Setup_UUIE_IncludeOptionField( tSetup, e_ASNH225Setup_UUIEOptionMap_endpointIdentifier );
			ASNH225EndpointIdentifier_Copy( &(tSetup->m_endpointIdentifier), &(pEndpoint->gatekeeper.endpointIdentifier) );
		}
	}

	tSetup->m_mediaWaitForConnect.value = FALSE;
	tSetup->m_canOverlapSend.value = FALSE;
	tSetup->m_multipleCalls.value = TRUE;
	tSetup->m_maintainConnection.value = FALSE;

	return msg;
}


/* MakeCallProceed */
ASNH225H323_UserInformation *MakeCallProceed(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	HS_RESULT tRet;
	ASNH225CallProceeding_UUIE *tProceed = HS_NULL;
	ASNH225H323_UserInformation *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (ASNH225H323_UserInformation*)HSMalloc( sizeof(ASNH225H323_UserInformation) );
	if( msg == HS_NULL ) return HS_NULL;

	new_ASNH225H323_UserInformation(msg);
	ASNH225H323_UserInformation_MakeMold(msg);

	ASNH225H323_UU_PDU_IncludeOptionField( &(msg->m_h323_uu_pdu), e_ASNH225H323_UU_PDUOptionMap_h245Tunneling );
	if( pCall->isTunneling )
	{
		msg->m_h323_uu_pdu.m_h245Tunneling.value = TRUE;
		if( TunnelingH245Message(pEndpoint, pCall, msg) != HS_OK )
		{
			delete_ASNH225H323_UserInformation(msg);
			HSFree(msg);
			return HS_NULL;
		}
	}
	else
		msg->m_h323_uu_pdu.m_h245Tunneling.value = FALSE;

	tProceed = (ASNH225CallProceeding_UUIE*) ASNH225H323_UU_PDU_h323_message_body_SetChoice(
		&(msg->m_h323_uu_pdu.m_h323_message_body),
		e_ASNH225H323_UU_PDU_h323_message_bodyChoice_callProceeding
	);
	if( tProceed == HS_NULL )
	{
		delete_ASNH225H323_UserInformation(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnObjectIdentifier_SetValue( &(tProceed->m_protocolIdentifier), gPID_H225_V2_Q931, gSize_PID_H225_V2_Q931 );

	tProceed->m_destinationInfo.m_mc.value = FALSE;
	tProceed->m_destinationInfo.m_undefinedNode.value = FALSE;

	if( pEndpoint->type == e_EndpointType_gateway )
		ASNH225EndpointType_IncludeOptionField( &(tProceed->m_destinationInfo), e_ASNH225EndpointTypeOptionMap_gateway );
	else if( pEndpoint->type == e_EndpointType_terminal )
		ASNH225EndpointType_IncludeOptionField( &(tProceed->m_destinationInfo), e_ASNH225EndpointTypeOptionMap_terminal );

	ASNH225EndpointType_IncludeOptionField( &(tProceed->m_destinationInfo), e_ASNH225EndpointTypeOptionMap_vendor );
	AsnInteger_SetValue( &(tProceed->m_destinationInfo.m_vendor.m_vendor.m_t35CountryCode), pEndpoint->countryCode );
	AsnInteger_SetValue( &(tProceed->m_destinationInfo.m_vendor.m_vendor.m_t35Extension), pEndpoint->extensionCode );
	AsnInteger_SetValue( &(tProceed->m_destinationInfo.m_vendor.m_vendor.m_manufacturerCode), pEndpoint->manufactureCode );

	ASNH225VendorIdentifier_IncludeOptionField( &(tProceed->m_destinationInfo.m_vendor), e_ASNH225VendorIdentifierOptionMap_productId );
	AsnOctetString_SetValue( &(tProceed->m_destinationInfo.m_vendor.m_productId), strlen(pEndpoint->productId), pEndpoint->productId );
	ASNH225VendorIdentifier_IncludeOptionField( &(tProceed->m_destinationInfo.m_vendor), e_ASNH225VendorIdentifierOptionMap_versionId );
	AsnOctetString_SetValue( &(tProceed->m_destinationInfo.m_vendor.m_versionId), strlen(pEndpoint->versionId), pEndpoint->versionId );

	if( pCall->h245ListenPoint == e_H245ListenPoint_CallProceed &&
		pCall->isTunneling == HS_NO && pCall->h245ListenPort != HS_INVALID_PORT )
	{
		ASNH225CallProceeding_UUIE_IncludeOptionField( tProceed, e_ASNH225CallProceeding_UUIEOptionMap_h245Address );
		tRet=ASNH225TransportAddress_CopyWithPort( &(tProceed->m_h245Address), &(pEndpoint->csaTsap), (HS_USHORT)pCall->h245ListenPort );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}

	ASNH225CallProceeding_UUIE_IncludeOptionField( tProceed, e_ASNH225CallProceeding_UUIEOptionMap_callIdentifier );
	AsnOctetString_SetValue( &(tProceed->m_callIdentifier.m_guid.inheritance), 16, pCall->callId );

	if( pCall->isFastStart )
	{
		if( pCall->fastStartPoint == e_FastStartResponsePoint_Idle )
		{
			ASNH225CallProceeding_UUIE_IncludeOptionField( tProceed, e_ASNH225CallProceeding_UUIEOptionMap_fastConnectRefused );
			pCall->isFastStart = HS_NO;
			if( pCall->remoteTCS != HS_NULL )
			{
				if( pEndpoint->CallbackCheckTerminalCapabilitySet != HS_NULL )
					tRet = pEndpoint->CallbackCheckTerminalCapabilitySet(
						pStack, pEndpoint, pCall,
						((ASNH245RequestMessage*)(pCall->remoteTCS->alter))->alter
					);
				else
					tRet = CheckTerminalCapabilitySet(
						pStack, pEndpoint, pCall,
						((ASNH245RequestMessage*)(pCall->remoteTCS->alter))->alter
					);

				if( tRet == HS_OK ) DischargeH245Message(pStack, pEndpoint, pWaits, pCall);
			}
		}

		else if( pCall->fastStartPoint == e_FastStartResponsePoint_CallProceed )
		{
			if( (tRet=MakeFastStartResponse( &(tProceed->m_fastStart), pEndpoint, pCall )) == HS_OK )
				ASNH225CallProceeding_UUIE_IncludeOptionField( tProceed, e_ASNH225CallProceeding_UUIEOptionMap_fastStart );
		}
	}

	ASNH225CallProceeding_UUIE_IncludeOptionField( tProceed, e_ASNH225CallProceeding_UUIEOptionMap_multipleCalls );
	ASNH225CallProceeding_UUIE_IncludeOptionField( tProceed, e_ASNH225CallProceeding_UUIEOptionMap_maintainConnection );
	tProceed->m_multipleCalls.value = TRUE;
	tProceed->m_maintainConnection.value = FALSE;

	return msg;
}


/* MakeAlert */
ASNH225H323_UserInformation *MakeAlert(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	HS_RESULT tRet;
	ASNH225Alerting_UUIE *tAlert = HS_NULL;
	ASNH225H323_UserInformation *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (ASNH225H323_UserInformation*)HSMalloc( sizeof(ASNH225H323_UserInformation) );
	if( msg == HS_NULL ) return HS_NULL;

	new_ASNH225H323_UserInformation(msg);
	ASNH225H323_UserInformation_MakeMold(msg);

	ASNH225H323_UU_PDU_IncludeOptionField( &(msg->m_h323_uu_pdu), e_ASNH225H323_UU_PDUOptionMap_h245Tunneling );
	if( pCall->isTunneling )
	{
		msg->m_h323_uu_pdu.m_h245Tunneling.value = TRUE;
		if( TunnelingH245Message(pEndpoint, pCall, msg) != HS_OK )
		{
			delete_ASNH225H323_UserInformation(msg);
			HSFree(msg);
			return HS_NULL;
		}
	}
	else
		msg->m_h323_uu_pdu.m_h245Tunneling.value = FALSE;

	tAlert = (ASNH225Alerting_UUIE*) ASNH225H323_UU_PDU_h323_message_body_SetChoice(
		&(msg->m_h323_uu_pdu.m_h323_message_body),
		e_ASNH225H323_UU_PDU_h323_message_bodyChoice_alerting
	);
	if( tAlert == HS_NULL )
	{
		delete_ASNH225H323_UserInformation(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnObjectIdentifier_SetValue( &(tAlert->m_protocolIdentifier), gPID_H225_V2_Q931, gSize_PID_H225_V2_Q931 );

	tAlert->m_destinationInfo.m_mc.value = FALSE;
	tAlert->m_destinationInfo.m_undefinedNode.value = FALSE;

	if( pEndpoint->type == e_EndpointType_gateway )
		ASNH225EndpointType_IncludeOptionField( &(tAlert->m_destinationInfo), e_ASNH225EndpointTypeOptionMap_gateway );
	else if( pEndpoint->type == e_EndpointType_terminal )
		ASNH225EndpointType_IncludeOptionField( &(tAlert->m_destinationInfo), e_ASNH225EndpointTypeOptionMap_terminal );

	ASNH225EndpointType_IncludeOptionField( &(tAlert->m_destinationInfo), e_ASNH225EndpointTypeOptionMap_vendor );
	AsnInteger_SetValue( &(tAlert->m_destinationInfo.m_vendor.m_vendor.m_t35CountryCode), pEndpoint->countryCode );
	AsnInteger_SetValue( &(tAlert->m_destinationInfo.m_vendor.m_vendor.m_t35Extension), pEndpoint->extensionCode );
	AsnInteger_SetValue( &(tAlert->m_destinationInfo.m_vendor.m_vendor.m_manufacturerCode), pEndpoint->manufactureCode );

	ASNH225VendorIdentifier_IncludeOptionField( &(tAlert->m_destinationInfo.m_vendor), e_ASNH225VendorIdentifierOptionMap_productId );
	AsnOctetString_SetValue( &(tAlert->m_destinationInfo.m_vendor.m_productId), strlen(pEndpoint->productId), pEndpoint->productId );
	ASNH225VendorIdentifier_IncludeOptionField( &(tAlert->m_destinationInfo.m_vendor), e_ASNH225VendorIdentifierOptionMap_versionId );
	AsnOctetString_SetValue( &(tAlert->m_destinationInfo.m_vendor.m_versionId), strlen(pEndpoint->versionId), pEndpoint->versionId );

	if( pCall->h245ListenPoint == e_H245ListenPoint_Alert &&
		pCall->isTunneling == HS_NO && pCall->h245ListenPort != HS_INVALID_PORT )
	{
		ASNH225Alerting_UUIE_IncludeOptionField( tAlert, e_ASNH225Alerting_UUIEOptionMap_h245Address );
		tRet=ASNH225TransportAddress_CopyWithPort( &(tAlert->m_h245Address), &(pEndpoint->csaTsap), (HS_USHORT)pCall->h245ListenPort );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}

	ASNH225Alerting_UUIE_IncludeOptionField( tAlert, e_ASNH225Alerting_UUIEOptionMap_callIdentifier );
	AsnOctetString_SetValue( &(tAlert->m_callIdentifier.m_guid.inheritance), 16, pCall->callId );

	if( pCall->isFastStart )
	{
		if( pCall->fastStartPoint == e_FastStartResponsePoint_Idle )
		{
			ASNH225Alerting_UUIE_IncludeOptionField( tAlert, e_ASNH225Alerting_UUIEOptionMap_fastConnectRefused );
			pCall->isFastStart = HS_NO;
			if( pCall->remoteTCS != HS_NULL )
			{
				if( pEndpoint->CallbackCheckTerminalCapabilitySet != HS_NULL )
					tRet = pEndpoint->CallbackCheckTerminalCapabilitySet(
						pStack, pEndpoint, pCall,
						((ASNH245RequestMessage*)(pCall->remoteTCS->alter))->alter
					);
				else
					tRet = CheckTerminalCapabilitySet(
						pStack, pEndpoint, pCall,
						((ASNH245RequestMessage*)(pCall->remoteTCS->alter))->alter
					);

				if( tRet == HS_OK ) DischargeH245Message(pStack, pEndpoint, pWaits, pCall);
			}
		}

		else if( pCall->fastStartPoint == e_FastStartResponsePoint_Alert )
		{
			if( (tRet=MakeFastStartResponse( &(tAlert->m_fastStart), pEndpoint, pCall )) == HS_OK )
				ASNH225Alerting_UUIE_IncludeOptionField( tAlert, e_ASNH225Alerting_UUIEOptionMap_fastStart );
		}
	}

	ASNH225Alerting_UUIE_IncludeOptionField( tAlert, e_ASNH225Alerting_UUIEOptionMap_multipleCalls );
	ASNH225Alerting_UUIE_IncludeOptionField( tAlert, e_ASNH225Alerting_UUIEOptionMap_maintainConnection );
	tAlert->m_multipleCalls.value = TRUE;
	tAlert->m_maintainConnection.value = FALSE;

	return msg;
}


/* MakeConnect */
ASNH225H323_UserInformation *MakeConnect(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	HS_RESULT tRet;
	ASNH225Connect_UUIE *tConnect = HS_NULL;
	ASNH225H323_UserInformation *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (ASNH225H323_UserInformation*)HSMalloc( sizeof(ASNH225H323_UserInformation) );
	if( msg == HS_NULL ) return HS_NULL;

	new_ASNH225H323_UserInformation(msg);
	ASNH225H323_UserInformation_MakeMold(msg);

	ASNH225H323_UU_PDU_IncludeOptionField( &(msg->m_h323_uu_pdu), e_ASNH225H323_UU_PDUOptionMap_h245Tunneling );
	if( pCall->isTunneling )
	{
		msg->m_h323_uu_pdu.m_h245Tunneling.value = TRUE;
		if( TunnelingH245Message(pEndpoint, pCall, msg) != HS_OK )
		{
			delete_ASNH225H323_UserInformation(msg);
			HSFree(msg);
			return HS_NULL;
		}
	}
	else
		msg->m_h323_uu_pdu.m_h245Tunneling.value = FALSE;

	tConnect = (ASNH225Connect_UUIE*) ASNH225H323_UU_PDU_h323_message_body_SetChoice(
		&(msg->m_h323_uu_pdu.m_h323_message_body),
		e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect
	);
	if( tConnect == HS_NULL )
	{
		delete_ASNH225H323_UserInformation(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnObjectIdentifier_SetValue( &(tConnect->m_protocolIdentifier), gPID_H225_V2_Q931, gSize_PID_H225_V2_Q931 );

	if( pCall->h245ListenPoint == e_H245ListenPoint_Connect &&
		pCall->isTunneling == HS_NO && pCall->h245ListenPort )
	{
		ASNH225Connect_UUIE_IncludeOptionField( tConnect, e_ASNH225Connect_UUIEOptionMap_h245Address );
		tRet=ASNH225TransportAddress_CopyWithPort( &(tConnect->m_h245Address), &(pEndpoint->csaTsap), (HS_USHORT)pCall->h245ListenPort );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}

	tConnect->m_destinationInfo.m_mc.value = FALSE;
	tConnect->m_destinationInfo.m_undefinedNode.value = FALSE;

	if( pEndpoint->type == e_EndpointType_gateway )
		ASNH225EndpointType_IncludeOptionField( &(tConnect->m_destinationInfo), e_ASNH225EndpointTypeOptionMap_gateway );
	else if( pEndpoint->type == e_EndpointType_terminal )
		ASNH225EndpointType_IncludeOptionField( &(tConnect->m_destinationInfo), e_ASNH225EndpointTypeOptionMap_terminal );

	ASNH225EndpointType_IncludeOptionField( &(tConnect->m_destinationInfo), e_ASNH225EndpointTypeOptionMap_vendor );
	AsnInteger_SetValue( &(tConnect->m_destinationInfo.m_vendor.m_vendor.m_t35CountryCode), pEndpoint->countryCode );
	AsnInteger_SetValue( &(tConnect->m_destinationInfo.m_vendor.m_vendor.m_t35Extension), pEndpoint->extensionCode );
	AsnInteger_SetValue( &(tConnect->m_destinationInfo.m_vendor.m_vendor.m_manufacturerCode), pEndpoint->manufactureCode );

	ASNH225VendorIdentifier_IncludeOptionField( &(tConnect->m_destinationInfo.m_vendor), e_ASNH225VendorIdentifierOptionMap_productId );
	AsnOctetString_SetValue( &(tConnect->m_destinationInfo.m_vendor.m_productId), strlen(pEndpoint->productId), pEndpoint->productId );
	ASNH225VendorIdentifier_IncludeOptionField( &(tConnect->m_destinationInfo.m_vendor), e_ASNH225VendorIdentifierOptionMap_versionId );
	AsnOctetString_SetValue( &(tConnect->m_destinationInfo.m_vendor.m_versionId), strlen(pEndpoint->versionId), pEndpoint->versionId );

	AsnOctetString_SetValue( &(tConnect->m_conferenceID.inheritance), 16, pCall->confId );

	ASNH225Connect_UUIE_IncludeOptionField( tConnect, e_ASNH225Connect_UUIEOptionMap_callIdentifier );
	AsnOctetString_SetValue( &(tConnect->m_callIdentifier.m_guid.inheritance), 16, pCall->callId );

	if( pCall->isFastStart )
	{
		if( pCall->fastStartPoint == e_FastStartResponsePoint_Idle )
		{
			ASNH225Connect_UUIE_IncludeOptionField( tConnect, e_ASNH225Connect_UUIEOptionMap_fastConnectRefused );
			pCall->isFastStart = HS_NO;
			if( pCall->remoteTCS != HS_NULL )
			{
				if( pEndpoint->CallbackCheckTerminalCapabilitySet != HS_NULL )
					tRet = pEndpoint->CallbackCheckTerminalCapabilitySet(
						pStack, pEndpoint, pCall,
						((ASNH245RequestMessage*)(pCall->remoteTCS->alter))->alter
					);
				else
					tRet = CheckTerminalCapabilitySet(
						pStack, pEndpoint, pCall,
						((ASNH245RequestMessage*)(pCall->remoteTCS->alter))->alter
					);

				if( tRet == HS_OK ) DischargeH245Message(pStack, pEndpoint, pWaits, pCall);
			}
		}

		else if( pCall->fastStartPoint == e_FastStartResponsePoint_Connect )
		{
			if( (tRet=MakeFastStartResponse( &(tConnect->m_fastStart), pEndpoint, pCall )) == HS_OK )
				ASNH225Connect_UUIE_IncludeOptionField( tConnect, e_ASNH225Connect_UUIEOptionMap_fastStart );
		}
	}

	ASNH225Connect_UUIE_IncludeOptionField( tConnect, e_ASNH225Connect_UUIEOptionMap_multipleCalls );
	ASNH225Connect_UUIE_IncludeOptionField( tConnect, e_ASNH225Connect_UUIEOptionMap_maintainConnection );
	tConnect->m_multipleCalls.value = TRUE;
	tConnect->m_maintainConnection.value = FALSE;

	return msg;
}


/* MakeFacility */
ASNH225H323_UserInformation *MakeFacility(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall, ASNH225FacilityReasonChoice pReason)
{
	HS_RESULT tRet;
	ASNH225Facility_UUIE *tFacility = HS_NULL;
	ASNH225H323_UserInformation *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;
	if( pReason > e_ASNH225FacilityReasonChoiceSizeExt - 1 ) return HS_NULL;

	msg = (ASNH225H323_UserInformation*)HSMalloc( sizeof(ASNH225H323_UserInformation) );
	if( msg == HS_NULL ) return HS_NULL;

	new_ASNH225H323_UserInformation(msg);
	ASNH225H323_UserInformation_MakeMold(msg);

	ASNH225H323_UU_PDU_IncludeOptionField( &(msg->m_h323_uu_pdu), e_ASNH225H323_UU_PDUOptionMap_h245Tunneling );
	if( pCall->isTunneling )
	{
		msg->m_h323_uu_pdu.m_h245Tunneling.value = TRUE;
		if( TunnelingH245Message(pEndpoint, pCall, msg) != HS_OK )
		{
			delete_ASNH225H323_UserInformation(msg);
			HSFree(msg);
			return HS_NULL;
		}
	}
	else
		msg->m_h323_uu_pdu.m_h245Tunneling.value = FALSE;

	tFacility = (ASNH225Facility_UUIE*) ASNH225H323_UU_PDU_h323_message_body_SetChoice(
		&(msg->m_h323_uu_pdu.m_h323_message_body),
		e_ASNH225H323_UU_PDU_h323_message_bodyChoice_facility
	);
	if( tFacility == HS_NULL )
	{
		delete_ASNH225H323_UserInformation(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnObjectIdentifier_SetValue( &(tFacility->m_protocolIdentifier), gPID_H225_V2_Q931, gSize_PID_H225_V2_Q931 );

	ASNH225Facility_UUIE_IncludeOptionField( tFacility, e_ASNH225Facility_UUIEOptionMap_conferenceID );
	AsnOctetString_SetValue( &(tFacility->m_conferenceID.inheritance), 16, pCall->confId );

	if( ASNH225FacilityReason_SetChoice( &(tFacility->m_reason), pReason ) == HS_NULL )
	{
		delete_Q931Message( msg );
		HSFree( msg );
		return HS_NULL;
	}
	
	ASNH225Facility_UUIE_IncludeOptionField( tFacility, e_ASNH225Facility_UUIEOptionMap_callIdentifier );
	AsnOctetString_SetValue( &(tFacility->m_callIdentifier.m_guid.inheritance), 16, pCall->callId );

	if( pCall->isFastStart )
	{
		if( pCall->fastStartPoint == e_FastStartResponsePoint_Idle )
		{
			ASNH225Facility_UUIE_IncludeOptionField( tFacility, e_ASNH225Facility_UUIEOptionMap_fastConnectRefused );
			pCall->isFastStart = HS_NO;
			if( pCall->remoteTCS != HS_NULL )
			{
				if( pEndpoint->CallbackCheckTerminalCapabilitySet != HS_NULL )
					tRet = pEndpoint->CallbackCheckTerminalCapabilitySet(
						pStack, pEndpoint, pCall,
						((ASNH245RequestMessage*)(pCall->remoteTCS->alter))->alter
					);
				else
					tRet = CheckTerminalCapabilitySet(
						pStack, pEndpoint, pCall,
						((ASNH245RequestMessage*)(pCall->remoteTCS->alter))->alter
					);

				if( tRet == HS_OK ) DischargeH245Message(pStack, pEndpoint, pWaits, pCall);
			}
		}

		else if( pCall->fastStartPoint == e_FastStartResponsePoint_Facility )
		{
			if( (tRet=MakeFastStartResponse( &(tFacility->m_fastStart), pEndpoint, pCall )) == HS_OK )
				ASNH225Facility_UUIE_IncludeOptionField( tFacility, e_ASNH225Facility_UUIEOptionMap_fastStart );
		}
	}

	if( pCall->h245ListenPoint == e_H245ListenPoint_Facility &&
		pCall->isTunneling == HS_NO && pCall->h245ListenPort != HS_INVALID_PORT )
	{
		ASNH225Facility_UUIE_IncludeOptionField( tFacility, e_ASNH225Facility_UUIEOptionMap_h245Address );
		tRet=ASNH225TransportAddress_CopyWithPort( &(tFacility->m_h245Address), &(pEndpoint->csaTsap), (HS_USHORT)pCall->h245ListenPort );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}

	ASNH225Facility_UUIE_IncludeOptionField( tFacility, e_ASNH225Facility_UUIEOptionMap_multipleCalls );
	ASNH225Facility_UUIE_IncludeOptionField( tFacility, e_ASNH225Facility_UUIEOptionMap_maintainConnection );
	tFacility->m_multipleCalls.value = TRUE;
	tFacility->m_maintainConnection.value = FALSE;

	return msg;
}


/* MakeEmpty */
ASNH225H323_UserInformation *MakeEmpty(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	ASNH225H323_UserInformation *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (ASNH225H323_UserInformation*)HSMalloc( sizeof(ASNH225H323_UserInformation) );
	if( msg == HS_NULL ) return HS_NULL;

	new_ASNH225H323_UserInformation(msg);
	ASNH225H323_UserInformation_MakeMold(msg);

	ASNH225H323_UU_PDU_IncludeOptionField( &(msg->m_h323_uu_pdu), e_ASNH225H323_UU_PDUOptionMap_h245Tunneling );
	if( pCall->isTunneling )
	{
		msg->m_h323_uu_pdu.m_h245Tunneling.value = TRUE;
		if( TunnelingH245Message(pEndpoint, pCall, msg) != HS_OK )
		{
			delete_ASNH225H323_UserInformation(msg);
			HSFree(msg);
			return HS_NULL;
		}
	}
	else
		msg->m_h323_uu_pdu.m_h245Tunneling.value = FALSE;

	if(
		ASNH225H323_UU_PDU_h323_message_body_SetChoice(
			&(msg->m_h323_uu_pdu.m_h323_message_body),
			e_ASNH225H323_UU_PDU_h323_message_bodyChoice_empty
		)  == HS_NULL )
	{
		delete_ASNH225H323_UserInformation(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}


/* MakeReleaseComplete */
ASNH225H323_UserInformation *MakeReleaseComplete(StackInfo *pStack, NoLockList *pWaits, ICall *pCall)
{
	ASNH225ReleaseComplete_UUIE *tRelease = HS_NULL;
	ASNH225H323_UserInformation *msg = HS_NULL;

	if( pStack==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (ASNH225H323_UserInformation*)HSMalloc( sizeof(ASNH225H323_UserInformation) );
	if( msg == HS_NULL ) return HS_NULL;

	new_ASNH225H323_UserInformation(msg);
	ASNH225H323_UserInformation_MakeMold(msg);

	ASNH225H323_UU_PDU_IncludeOptionField( &(msg->m_h323_uu_pdu), e_ASNH225H323_UU_PDUOptionMap_h245Tunneling );
	if( pCall->isTunneling ) msg->m_h323_uu_pdu.m_h245Tunneling.value = TRUE;
	else					 msg->m_h323_uu_pdu.m_h245Tunneling.value = FALSE;

	tRelease = (ASNH225ReleaseComplete_UUIE*)
		ASNH225H323_UU_PDU_h323_message_body_SetChoice(
			&(msg->m_h323_uu_pdu.m_h323_message_body),
			e_ASNH225H323_UU_PDU_h323_message_bodyChoice_releaseComplete
		);
	if( tRelease == HS_NULL )
	{
		delete_ASNH225H323_UserInformation(msg);
		HSFree(msg);
		return HS_NULL;
	}

	AsnObjectIdentifier_SetValue( &(tRelease->m_protocolIdentifier), gPID_H225_V2_Q931, gSize_PID_H225_V2_Q931 );

	ASNH225ReleaseComplete_UUIE_IncludeOptionField(tRelease, e_ASNH225ReleaseComplete_UUIEOptionMap_callIdentifier);
	AsnOctetString_SetValue( &(tRelease->m_callIdentifier.m_guid.inheritance), 16, pCall->callId );

	return msg;
}



/***************************************************************/
/* Make Q931 Message
*/
/* MakeQ931Setup */
Q931Message *MakeQ931Setup(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	HS_RESULT tRet;
	Q931Message *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (Q931Message*)HSMalloc( sizeof(Q931Message) );
	if( msg == HS_NULL ) return HS_NULL;
	new_Q931Message( msg );

	if( pCall->isAnswerCall )	msg->origin = FALSE;
	else						msg->origin = TRUE;
	msg->crv = pCall->crv;
	msg->type = e_Q931MessageType_Setup;

	/* Q931 BearerCapability */
	tRet = Q931Message_AddElementEx( msg, e_Q931ElementType_BearerCapability, HS_NULL, 0 );
	if( tRet != HS_OK )
	{
		delete_Q931Message( msg );
		HSFree( msg );
		return HS_NULL;
	}
	/* Q931 CallingPartyNumber */
	if( pCall->callingParty[0] != 0 && IsE164(pCall->callingParty) )
	{
		tRet = Q931Message_AddElementInVisible( msg, e_Q931ElementType_CallingPartyNumber, pCall->callingParty );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}
	/* Q931 CalledPartyNumber */
	if( pCall->calledParty[0] != 0 && IsE164(pCall->calledParty) )
	{
		tRet = Q931Message_AddElementInVisible( msg, e_Q931ElementType_CalledPartyNumber, pCall->calledParty );
		if( tRet != HS_OK )
		{
			delete_Q931Message( msg );
			HSFree( msg );
			return HS_NULL;
		}
	}
	/* Q931 UserToUser */
	msg->uuie = MakeSetup(pStack, pEndpoint, pWaits, pCall);
	if( msg->uuie == HS_NULL )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}


/* MakeQ931CallProceed */
Q931Message *MakeQ931CallProceed(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	Q931Message *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (Q931Message*)HSMalloc( sizeof(Q931Message) );
	if( msg == HS_NULL ) return HS_NULL;
	new_Q931Message( msg );

	if( pCall->isAnswerCall )	msg->origin = FALSE;
	else						msg->origin = TRUE;
	msg->crv = pCall->crv;
	msg->type = e_Q931MessageType_CallProceeding;

	/* Q931 UserToUser */
	msg->uuie = MakeCallProceed(pStack, pEndpoint, pWaits, pCall);
	if( msg->uuie == HS_NULL )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}


/* MakeQ931Alert */
Q931Message *MakeQ931Alert(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	Q931Message *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (Q931Message*)HSMalloc( sizeof(Q931Message) );
	if( msg == HS_NULL ) return HS_NULL;
	new_Q931Message( msg );

	if( pCall->isAnswerCall )	msg->origin = FALSE;
	else						msg->origin = TRUE;
	msg->crv = pCall->crv;
	msg->type = e_Q931MessageType_Alerting;

	/* Q931 UserToUser */
	msg->uuie = MakeAlert(pStack, pEndpoint, pWaits, pCall);
	if( msg->uuie == HS_NULL )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}


/* MakeQ931Connect */
Q931Message *MakeQ931Connect(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	Q931Message *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (Q931Message*)HSMalloc( sizeof(Q931Message) );
	if( msg == HS_NULL ) return HS_NULL;
	new_Q931Message( msg );

	if( pCall->isAnswerCall )	msg->origin = FALSE;
	else						msg->origin = TRUE;
	msg->crv = pCall->crv;
	msg->type = e_Q931MessageType_Connect;

	/* Q931 UserToUser */
	msg->uuie = MakeConnect(pStack, pEndpoint, pWaits, pCall);
	if( msg->uuie == HS_NULL )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}


/* MakeQ931Facility */
Q931Message *MakeQ931Facility(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall, ASNH225FacilityReasonChoice pReason)
{
	HS_RESULT tRet;
	Q931Message *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (Q931Message*)HSMalloc( sizeof(Q931Message) );
	if( msg == HS_NULL ) return HS_NULL;
	new_Q931Message( msg );

	if( pCall->isAnswerCall )	msg->origin = FALSE;
	else						msg->origin = TRUE;
	msg->crv = pCall->crv;
	msg->type = e_Q931MessageType_Facility;

	/* Q931 Facility */
	tRet = Q931Message_AddElementEx( msg, e_Q931ElementType_Facility, HS_NULL, 0 );
	if( tRet != HS_OK )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}
	/* Q931 Display {*/
	tRet = Q931Message_AddElementInVisible( msg, e_Q931ElementType_Display, "itsme, Inc." );
	if( tRet != HS_OK )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}
	/* } */

	/* Q931 UserToUser */
	msg->uuie = MakeFacility(pStack, pEndpoint, pWaits, pCall, pReason);
	if( msg->uuie == HS_NULL )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}


/* MakeQ931Empty */
Q931Message *MakeQ931Empty(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, ICall *pCall)
{
	HS_RESULT tRet;
	Q931Message *msg = HS_NULL;

	if( pStack==HS_NULL || pEndpoint==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (Q931Message*)HSMalloc( sizeof(Q931Message) );
	if( msg == HS_NULL ) return HS_NULL;
	new_Q931Message( msg );

	if( pCall->isAnswerCall )	msg->origin = FALSE;
	else						msg->origin = TRUE;
	msg->crv = pCall->crv;
	msg->type = e_Q931MessageType_Facility;

	/* Q931 Facility */
	tRet = Q931Message_AddElementEx( msg, e_Q931ElementType_Facility, HS_NULL, 0 );
	if( tRet != HS_OK )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}

	/* Q931 UserToUser */
	msg->uuie = MakeEmpty(pStack, pEndpoint, pWaits, pCall);
	if( msg->uuie == HS_NULL )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}


/* MakeQ931ReleaseComplete */
Q931Message *MakeQ931ReleaseComplete(StackInfo *pStack, NoLockList *pWaits, ICall *pCall, Q931CauseType pCause)
{
	HS_RESULT tRet;
	Q931Message *msg = HS_NULL;

	if( pStack==HS_NULL || pWaits==HS_NULL || pCall==HS_NULL ) return HS_NULL;

	msg = (Q931Message*)HSMalloc( sizeof(Q931Message) );
	if( msg == HS_NULL ) return HS_NULL;
	new_Q931Message( msg );

	if( pCall->isAnswerCall )	msg->origin = FALSE;
	else						msg->origin = TRUE;
	msg->crv = pCall->crv;
	msg->type = e_Q931MessageType_ReleaseComplete;

	/*Q931 Cause*/
	tRet = Q931Message_AddElementCauseValue( msg, pCause );
	if( tRet != HS_OK )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}

	/*Q931 UserToUser*/
	msg->uuie = MakeReleaseComplete(pStack, pWaits, pCall);
	if( msg->uuie == HS_NULL )
	{
		delete_Q931Message(msg);
		HSFree(msg);
		return HS_NULL;
	}

	return msg;
}
