/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<H323Demon.c>	2005-03-20,11:26

*/

#include "H323Demon.h"

#ifdef _WIN32
#include <time.h>
#endif





H323Demon *newm_H323Demon()
{
	H323Demon *tResult = NULL;

	if( (tResult=(H323Demon*)HSMalloc(sizeof(H323Demon)))==NULL )
		return NULL;

	HS_THREAD_INIT(tResult,"H323Demon");
	tResult->mStack = NULL;
	tResult->mEndpoint = NULL;
	return tResult;
}


HS_RESULT deletem_H323Demon(void *pObject)
{
	H323Demon *pObj = (H323Demon*)pObject;
	IEndpoint *tEndpoint = NULL;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( (tEndpoint=pObj->mEndpoint) != NULL )
	{
		delete_IEndpoint(tEndpoint);
		HSFree(tEndpoint);
	}

	HSFree(pObj);
	return HS_OK;
}





/* H323Demon main function
*/
HS_RESULT H323Demon_Main(HS_TQ pQ,void *pObject,void *pArg)
{
	HSQmsg tQmsg;
	HS_RESULT tRet = HS_OK;

	StackInfo *tStack = NULL;
	IEndpoint *tEndpoint = NULL;

	NoLockList callList;
	NoLockList rasWaitList;

	H323Demon *pObj = (H323Demon*)pObject;

	HSSrand();

	if( pObj==NULL ) return HSExitThread(pQ,HS_ERR_NULL_PARAM);
	if( (tStack=pObj->mStack)==NULL )
	{
		deletem_H323Demon(pObj);
		return HSExitThread(pQ,HS_ERR_INVALID_PARAM);
	}
	if( (tEndpoint=pObj->mEndpoint)==NULL )
	{
		deletem_H323Demon(pObj);
		return HSExitThread(pQ,HS_ERR_INVALID_PARAM);
	}

	/* Lists Initializing */
	new_NoLockList(&callList, delete_ICall);
	new_NoLockList(&rasWaitList, delete_RasWaitSet);

	/*	IEndpoint, NoLockList(callList), NoLockList(rasWaitList) 's pointer
		using JUST show the state, READ ONLY on #HapiStateXXXXX# functions.
		NEVER handle the memory space! (alloc, HSFree, ..)
	*/
	tStack->endpoint = tEndpoint;
	tStack->calls	 = &callList;
	tStack->waits	 = &rasWaitList;

	pObj->mActive = TRUE;
	while(pObj->mActive)
	{
		if( HSThreadGetMessage(pQ,&tQmsg,HS_QM,HS_QM_MAX,TRUE)==HS_OK )
		{
            switch(tQmsg.message)
			{
				/********************User Command Message{**********************/
				case HS_QMESSAGE_MAKE_CALL:
					HSPrint( "\n[+] H323->MAKECALL" );
					tRet=H323DemonEventMakeCall(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_CHANGE_GK:
					HSPrint( "\n[+] H323->CHANGE_GK" );
					tRet=H323DemonEventChangeGk(tQmsg.lParam, tStack, tEndpoint, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_ACCEPT_CALL:
					HSPrint( "\n[+] H323->ACCEPT_CALL" );
					tRet=H323DemonEventAcceptCall(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_REMOVE_CALL:
					HSPrint( "\n[+] H323->REMOVE_CALL" );
					tRet=H323DemonEventRemoveCall(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_USE_GRQ:
					HSPrint( "\n[+] H323->USE_GRQ" );
					if( tQmsg.lParam == HS_NO )	tEndpoint->gatekeeper.isGRQ = HS_NO;
					else						tEndpoint->gatekeeper.isGRQ = HS_YES;
					HSPrint( "\n[-] H323:0" );
					break;
				case HS_QMESSAGE_CHANGE_BANDWIDTH:
					HSPrint( "\n[+] H323->CHANGE_BANDWIDTH" );
					tRet=H323DemonEventChangeBandwidth(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_H245USERINPUTINDICATION:
					HSPrint( "\n[+] H323->H245USERINPUTINDICATION" );
					tRet=H323DemonEventH245UserInputIndication(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_CHANGE_ALIASES:
					HSPrint( "\n[+] H323->CHANGE_ALIASES" );
					tRet=H323DemonEventChangeAliases(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				/********************User Command Message}**********************/
				case HS_QM_TIMER:
					HSPrint( "\n[+] H323->TIMER" );
					tRet=H323DemonEventTimer(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_Q931_CONNECTED:
					HSPrint( "\n[+] H323->Q931_CONNECTED" );
					tRet=H323DemonEventQ931Connected(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_H245_CONNECTED:
					HSPrint( "\n[+] H323->H245_CONNECTED" );
					tRet=H323DemonEventH245Connected(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_RECV_RAS_MESSAGE:
					HSPrint( "\n[+] H323->RECV_RAS_MESSAGE" );
					tRet=H323DemonEventReceiveRasMessage(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_Q931_MESSAGE:
					HSPrint( "\n[+] H323->RECV_Q931_MESSAGE" );
					tRet=H323DemonEventReceiveQ931Message(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_H245_MESSAGE:
					HSPrint( "\n[+] H323->RECV_H245_MESSAGE" );
					tRet=H323DemonEventReceiveH245Message(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_Q931_ACCEPTED:
					HSPrint( "\n[+] H323->Q931_ACCEPTED" );
					tRet=H323DemonEventQ931Accepted(tQmsg.lParam, tStack, tEndpoint, &callList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_H245_ACCEPTED:
					HSPrint( "\n[+] H323->H245_ACCEPTED" );
					tRet=H323DemonEventH245Accepted(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_Q931_CLOSE:
					HSPrint( "\n[+] H323->Q931_CLOSE" );
					tRet=H323DemonEventQ931Close(tQmsg.lParam, tStack, tEndpoint, &callList, &rasWaitList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QMESSAGE_H245_CLOSE:
					HSPrint( "\n[+] H323->H245_CLOSE" );
					tRet=H323DemonEventH245Close(tQmsg.lParam, &callList);
					HSPrint( "\n[-] H323:%u", tRet );
					break;
				case HS_QM_STOP:
					HSPrint( "\n[+] H323->END_THREAD" );
					pObj->mActive = FALSE;
					break;
            }
        }
    }

	if( tEndpoint->gatekeeper.registrar != HS_NULL )
	{
		if( tEndpoint->gatekeeper.registrar->registed == HS_YES )
			TryUnregistration(tStack, tEndpoint, &rasWaitList);
	}

	/*	IEndpoint, NoLockList(callList), NoLockList(rasWaitList) 's pointer
		using JUST show the state, READ ONLY on #HapiStateXXXXX# functions.
		NEVER handle the memory space! (alloc, HSFree, ..)
	*/
	tStack->endpoint = HS_NULL;
	tStack->calls	 = HS_NULL;
	tStack->waits	 = HS_NULL;

#ifdef HS_DEBUG_H323DEMON
	HSPrint("\n <H323Demon> Ended");
#endif
	delete_NoLockList(&callList);
	delete_NoLockList(&rasWaitList);

	deletem_H323Demon(pObj);
    return HSExitThread(pQ,HS_OK);
}









