/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<H323UI.c>		2005-03-20,11:36

*/

#include "H323UI.h"



/*call handle generator:
	even numbered handle is a originated call.
*/
static BOOL gStackStarted = FALSE;
HSSemaphore gSemaCallHandleInH323UI;

static HS_USHORT callHandleInH323UI=0;
static HS_UINT GetCallHandleInH323UI()
{
	HS_UINT result;

	HSLockSemaphore(gSemaCallHandleInH323UI);
	result = (HS_UINT)callHandleInH323UI;
	callHandleInH323UI += 2;
	HSUnlockSemaphore(gSemaCallHandleInH323UI);

	return result;
}



/*functions for JUST simple test
*/
void HapiOpenStackForTest()
{
	/* semaphore initialize */
	HSOpenSemaphore(gSemaCallHandleInH323UI);
}
void HapiCloseStackForTest()
{
	/* semaphore close */
	HSCloseSemaphore(gSemaCallHandleInH323UI);
}



/*making call for application user
*/
ICall *HapiCallOpen()
{
	ICall *tRet = (ICall*)HSMalloc(sizeof(ICall));

	if( tRet == HS_NULL ) return HS_NULL;

	new_ICall(tRet, HS_NO);
	tRet->handle = GetCallHandleInH323UI();
	return tRet;
}
HS_RESULT HapiCallClose(ICall *pCall)
{
	HS_RESULT tRet;

	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;

	tRet = delete_ICall(pCall);
	HSFree(pCall);
	return tRet;
}



/*alias setting functions
*/
static HS_RESULT AddAliasAddress( NoLockList *pList, ASNH225AliasAddressChoice pType, char *pAlias )
{
	HS_RESULT tRet;
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225AliasAddress *tAlias = HS_NULL;

	if( pList==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;

	tAlias = (ASNH225AliasAddress*)HSMalloc( sizeof(ASNH225AliasAddress) );
	if(tAlias==HS_NULL) return HS_ERR_H323_MALLOC;

	switch(pType)
	{
		case e_ASNH225AliasAddressChoice_dialedDigits:
		case e_ASNH225AliasAddressChoice_url_ID:
		case e_ASNH225AliasAddressChoice_email_ID:
			new_ASNH225AliasAddress(tAlias);
			ASNH225AliasAddress_MakeMold(tAlias);
			ss = (AsnSingleString*)ASNH225AliasAddress_SetChoice(tAlias,pType);
			if(ss==HS_NULL)
			{
				delete_ASNH225AliasAddress(tAlias);
				HSFree(tAlias);
				return HS_ERR_H323;
			}
			AsnSingleString_SetValueInVisible(ss,pAlias);
			break;
		case e_ASNH225AliasAddressChoice_h323_ID:
			new_ASNH225AliasAddress(tAlias);
			ASNH225AliasAddress_MakeMold(tAlias);
			ds = (AsnDoubleString*)ASNH225AliasAddress_SetChoice(tAlias,pType);
			if(ds==HS_NULL)
			{
				delete_ASNH225AliasAddress(tAlias);
				HSFree(tAlias);
				return HS_ERR_H323;
			}
			AsnDoubleString_SetValueInVisible(ds,pAlias);
			break;
		default:
			HSFree(tAlias);
			return HS_ERR_H323_NOTFOUND;
	}

	tRet = NoLockList_AttachData( pList, tAlias );

	if( tRet != HS_OK )
	{
		delete_ASNH225AliasAddress(tAlias);
		HSFree(tAlias);
	}

	return tRet;
}
static HS_RESULT AddAliasAddressEx( NoLockList *pList, HS_USHORT *pAlias, HS_UINT pLen )
{
	HS_RESULT tRet;
	AsnDoubleString *ds = HS_NULL;
	ASNH225AliasAddress *tAlias = HS_NULL;

	if( pList==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;

	tAlias = (ASNH225AliasAddress*)HSMalloc( sizeof(ASNH225AliasAddress) );
	if(tAlias==HS_NULL) return HS_ERR_H323_MALLOC;

	new_ASNH225AliasAddress(tAlias);
	ASNH225AliasAddress_MakeMold(tAlias);
	ds = (AsnDoubleString*)ASNH225AliasAddress_SetChoice(tAlias,e_ASNH225AliasAddressChoice_h323_ID);
	if(ds==HS_NULL)
	{
		delete_ASNH225AliasAddress(tAlias);
		HSFree(tAlias);
		return HS_ERR_H323;
	}
	AsnDoubleString_SetValue(ds,pAlias,pLen);

	tRet = NoLockList_AttachData( pList, tAlias );
	if( tRet != HS_OK )
	{
		delete_ASNH225AliasAddress(tAlias);
		HSFree(tAlias);
	}

	return tRet;
}


HS_RESULT HapiAddEndpointAliasDial(IEndpoint *pEndpoint, char *pAlias)
{
	if( pEndpoint==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pEndpoint->aliases),
		e_ASNH225AliasAddressChoice_dialedDigits,
		pAlias
	);
}
HS_RESULT HapiAddEndpointAliasH323Id(IEndpoint *pEndpoint, char *pAlias)
{
	if( pEndpoint==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pEndpoint->aliases),
		e_ASNH225AliasAddressChoice_h323_ID,
		pAlias
	);
}
HS_RESULT HapiAddEndpointAliasH323IdEx(IEndpoint *pEndpoint, HS_USHORT *pAlias, HS_UINT pLen)
{
	if( pEndpoint==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddressEx( &(pEndpoint->aliases), pAlias, pLen );
}
HS_RESULT HapiAddEndpointAliasUrlId(IEndpoint *pEndpoint, char *pAlias)
{
	if( pEndpoint==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pEndpoint->aliases),
		e_ASNH225AliasAddressChoice_url_ID,
		pAlias
	);
}
HS_RESULT HapiAddEndpointAliasEmailId(IEndpoint *pEndpoint, char *pAlias)
{
	if( pEndpoint==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pEndpoint->aliases),
		e_ASNH225AliasAddressChoice_email_ID,
		pAlias
	);
}

HS_RESULT HapiAddCallingAliasDial(ICall *pCall, char *pAlias)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pCall->sourceAliases),
		e_ASNH225AliasAddressChoice_dialedDigits,
		pAlias
	);
}
HS_RESULT HapiAddCallingAliasH323Id(ICall *pCall, char *pAlias)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pCall->sourceAliases),
		e_ASNH225AliasAddressChoice_h323_ID,
		pAlias
	);
}
HS_RESULT HapiAddCallingAliasH323IdEx(ICall *pCall, HS_USHORT *pAlias, HS_UINT pLen)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddressEx( &(pCall->sourceAliases), pAlias, pLen );
}
HS_RESULT HapiAddCallingAliasUrlId(ICall *pCall, char *pAlias)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pCall->sourceAliases),
		e_ASNH225AliasAddressChoice_url_ID,
		pAlias
	);
}
HS_RESULT HapiAddCallingAliasEmailId(ICall *pCall, char *pAlias)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pCall->sourceAliases),
		e_ASNH225AliasAddressChoice_email_ID,
		pAlias
	);
}

HS_RESULT HapiAddCalledAliasDial(ICall *pCall, char *pAlias)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pCall->destAliases),
		e_ASNH225AliasAddressChoice_dialedDigits,
		pAlias
	);
}
HS_RESULT HapiAddCalledAliasH323Id(ICall *pCall, char *pAlias)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pCall->destAliases),
		e_ASNH225AliasAddressChoice_h323_ID,
		pAlias
	);
}
HS_RESULT HapiAddCalledAliasH323IdEx(ICall *pCall, HS_USHORT *pAlias, HS_UINT pLen)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddressEx( &(pCall->destAliases), pAlias, pLen );
}
HS_RESULT HapiAddCalledAliasUrlId(ICall *pCall, char *pAlias)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pCall->destAliases),
		e_ASNH225AliasAddressChoice_url_ID,
		pAlias
	);
}
HS_RESULT HapiAddCalledAliasEmailId(ICall *pCall, char *pAlias)
{
	if( pCall==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(
		&(pCall->destAliases),
		e_ASNH225AliasAddressChoice_email_ID,
		pAlias
	);
}



/* make alias address list for change #IEndpoint#'s  #aliases#
*/
NoLockList *HapiMakeAliasList()
{
	NoLockList *result = HS_NULL;
	if( (result=(NoLockList*)HSMalloc(sizeof(NoLockList))) == HS_NULL ) return HS_NULL;
	if( new_NoLockList(result, delete_ASNH225AliasAddress) != HS_OK )
	{
		HSFree(result);
		return HS_NULL;
	}
	return result;
}
HS_RESULT HapiAddAliasDial(NoLockList *pList, char *pAlias)
{
	if( pList==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(pList, e_ASNH225AliasAddressChoice_dialedDigits, pAlias);
}
HS_RESULT HapiAddAliasH323Id(NoLockList *pList, char *pAlias)
{
	if( pList==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(pList, e_ASNH225AliasAddressChoice_h323_ID, pAlias);
}
HS_RESULT HapiAddAliasH323IdEx(NoLockList *pList, HS_USHORT *pAlias, HS_UINT pLen)
{
	if( pList==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddressEx( pList, pAlias, pLen );
}
HS_RESULT HapiAddAliasUrlId(NoLockList *pList, char *pAlias)
{
	if( pList==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(pList, e_ASNH225AliasAddressChoice_url_ID, pAlias);
}
HS_RESULT HapiAddAliasEmailId(NoLockList *pList, char *pAlias)
{
	if( pList==HS_NULL || pAlias==HS_NULL ) return HS_ERR_NULL_PARAM;
	return AddAliasAddress(pList, e_ASNH225AliasAddressChoice_email_ID, pAlias);
}



/*capability setting
*/
/*1 parameter capabilities*/
HS_RESULT HapiAddG711Alaw64k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g711Alaw64k,pValue
	);
}
HS_RESULT HapiAddG711Alaw56k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g711Alaw56k,pValue
	);
}
HS_RESULT HapiAddG711Ulaw64k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g711Ulaw64k,pValue
	);
}
HS_RESULT HapiAddG711Ulaw56k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g711Ulaw56k,pValue
	);
}
HS_RESULT HapiAddG72264k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g722_64k,pValue
	);
}
HS_RESULT HapiAddG72256k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g722_56k,pValue
	);
}
HS_RESULT HapiAddG72248k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g722_48k,pValue
	);
}
HS_RESULT HapiAddG728(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g728,pValue
	);
}
HS_RESULT HapiAddG729(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g729,pValue
	);
}
HS_RESULT HapiAddG729AnnexA(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g729AnnexA,pValue
	);
}
HS_RESULT HapiAddG729wAnnexB(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g729wAnnexB,pValue
	);
}
HS_RESULT HapiAddG729AnnexAwAnnexB(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddIntegerFactor(
		&(pCall->capabilities),pSimul,e_IntegerFactor_g729AnnexAwAnnexB,pValue
	);
}
/*2 parameter capabilities*/
HS_RESULT HapiAddG7231(ICall *pCall, HS_UINT pSimul, HS_UCHAR pMaxAl, BOOL pSilence)
{
	if( pCall == HS_NULL ) return HS_ERR_NULL_PARAM;
	return ICapabilities_AddG7231( &(pCall->capabilities),pSimul,pMaxAl,pSilence);
}



/*transport address setting functions
*/
HS_RESULT HapiSetRasAddress( IEndpoint *pEndpoint, HS_UCHAR *pIp, HS_USHORT pPort )
{
	ASNH225TransportAddress_ipAddress *ipAddr = HS_NULL;

	if( pEndpoint==HS_NULL || pIp==HS_NULL ) return HS_ERR_NULL_PARAM;
	pEndpoint->rasListenPort = pPort;

	return Tsap2ASNH225TransportAddress( &(pEndpoint->rasTsap), pIp, pPort );
}
HS_RESULT HapiSetCallSignalingAddress( IEndpoint *pEndpoint, HS_UCHAR *pIp, HS_USHORT pPort )
{
	ASNH225TransportAddress_ipAddress *ipAddr = HS_NULL;

	if( pEndpoint==HS_NULL || pIp==HS_NULL ) return HS_ERR_NULL_PARAM;
	pEndpoint->callListenPort= pPort;

	return Tsap2ASNH225TransportAddress( &(pEndpoint->csaTsap), pIp, pPort );
}



/*add media channel functions*/
HS_RESULT HapiAddOpenLogicalChannel(IEndpoint *pEndpoint, ICall *pCall, ICapability *pCapa)
{
	return AddOpenLogicalChannel(pEndpoint, pCall, pCapa);
}
HS_RESULT HapiAddOpenLogicalChannelEx(IEndpoint *pEndpoint, ICall *pCall, HS_UINT pIndex)
{
	return AddOpenLogicalChannelEx(pEndpoint, pCall, pIndex);
}
HS_RESULT HapiAddForwardFastStart(ICall *pCall, ASNH245OpenLogicalChannel *olc)
{
	return AddForwardFastStart(pCall, olc);
}
HS_RESULT HapiAddReverseFastStart(ICall *pCall, ASNH245OpenLogicalChannel *olc)
{
	return AddReverseFastStart(pCall, olc);
}


/* user READ ONLY state functions
*/
BOOL HapiStateIsRegisted( HS_STACK_HANDLE pHandle )
{
	IEndpoint *tEndpoint = HS_NULL;
	StackInfo *tStack = HS_NULL;
	
	tStack = (StackInfo*)pHandle;
	if( tStack == HS_NULL ) return HS_NO;
	tEndpoint = (IEndpoint*)(tStack->endpoint);
	if( tEndpoint == HS_NULL ) return HS_NO;
	if( tEndpoint->gatekeeper.registrar == HS_NULL ) return HS_NO;

	return tEndpoint->gatekeeper.registrar->registed;
}


HS_CALL_HANDLE HapiGetCallHandle(ICall *pCall)
{
	if( pCall==NULL ) return HS_INVALID_HANDLE;
	return pCall->handle;
}



/***************************************************************************/
/*
	User Command Message : Command Functions {
*/
HS_RESULT HapiCommandMakeCall( HS_STACK_HANDLE pHandle, ICall *pCall )
{
	StackInfo *tStack = (StackInfo*)pHandle;

	if( tStack == HS_NULL || pCall == HS_NULL ) return HS_ERR_NULL_PARAM;

	_HSThreadSendMessage(tStack->h323DemonQ, HS_QMESSAGE_MAKE_CALL, 0, (LPARAM)pCall );
	return HS_OK;
}


HS_RESULT HapiCommandChangeGatekeeper( HS_STACK_HANDLE pHandle, char *pTarget )
{
	Registrar *tReg = HS_NULL;
	StackInfo *tStack = (StackInfo*)pHandle;

	if( tStack==HS_NULL || pTarget==HS_NULL ) return HS_ERR_NULL_PARAM;

	if( (tReg=(Registrar*)HSMalloc(sizeof(Registrar))) != HS_NULL )
	{
		new_Registrar(tReg);
		strcpy(tReg->target,pTarget);
		_HSThreadSendMessage(tStack->h323DemonQ, HS_QMESSAGE_CHANGE_GK, 0, (LPARAM)tReg);
	}

	return HS_OK;
}


HS_RESULT HapiCommandAcceptCall( HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle )
{
	StackInfo *tStack = (StackInfo*)hStack;
	if( tStack == HS_INVALID_STACK_HANDLE ) return HS_ERR_NULL_PARAM;

	_HSThreadSendMessage(tStack->h323DemonQ, HS_QMESSAGE_ACCEPT_CALL, 0, (LPARAM)pHandle);
	return HS_OK;
}


HS_RESULT HapiCommandRemoveCall( HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, CallCloseReason pReason )
{
	QMRemoveCall *qMsg = HS_NULL;
	StackInfo *tStack = (StackInfo*)hStack;

	if( tStack == HS_INVALID_STACK_HANDLE ) return HS_ERR_NULL_PARAM;
	if( (qMsg=new_QMRemoveCall(pReason,pHandle)) == HS_NULL ) return HS_ERR_H323_MALLOC;

	_HSThreadSendMessage(tStack->h323DemonQ, HS_QMESSAGE_REMOVE_CALL, 0, (LPARAM)qMsg);
	return HS_OK;
}


HS_RESULT HapiCommandUseGRQ( HS_STACK_HANDLE pHandle, BOOL pUse )
{
	StackInfo *tStack = (StackInfo*)pHandle;

	if( tStack == HS_NULL ) return HS_ERR_NULL_PARAM;

	_HSThreadSendMessage(tStack->h323DemonQ, HS_QMESSAGE_USE_GRQ, 0, (LPARAM)pUse);
	return HS_OK;
}


HS_RESULT HapiCommandChangeBandwidth( HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, HS_UINT pBandwidth )
{
	QMBandwidth *qMsg = HS_NULL;
	StackInfo *tStack = (StackInfo*)hStack;

	if( tStack == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( (qMsg=new_QMBandwidth(pBandwidth,pHandle)) == HS_NULL ) return HS_ERR_H323_MALLOC;

	_HSThreadSendMessage(tStack->h323DemonQ, HS_QMESSAGE_CHANGE_BANDWIDTH, 0, (LPARAM)qMsg);
	return HS_OK;
}


HS_RESULT HapiCommandH245UserInputIndication( HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, ControlMsg *pMsg )
{
	QMH245UserInputIndication *qMsg = HS_NULL;
	StackInfo *tStack = (StackInfo*)hStack;

	if( tStack == HS_NULL || pMsg == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( (qMsg=new_QMH245UserInputIndication(pMsg,pHandle)) == HS_NULL ) return HS_ERR_H323_MALLOC;

	_HSThreadSendMessage(tStack->h323DemonQ, HS_QMESSAGE_H245USERINPUTINDICATION, 0, (LPARAM)qMsg);
	return HS_OK;
}


HS_RESULT HapiCommandChangeEndpointAliases( HS_STACK_HANDLE hStack, NoLockList *pList )
{
	StackInfo *tStack = (StackInfo*)hStack;

	if( tStack == HS_NULL || pList == HS_NULL ) return HS_ERR_NULL_PARAM;

	/* if Registed, unregistration.
	*/
	if( HapiStateIsRegisted(hStack) == HS_YES )
		HapiCommandChangeGatekeeper(hStack, "");

	_HSThreadSendMessage(tStack->h323DemonQ, HS_QMESSAGE_CHANGE_ALIASES, 0, (LPARAM)pList);
	return HS_OK;
}
/*
	User Command Message : Command Functions }
*/
/***************************************************************************/





/* stack start/stop functions
*/
HS_STACK_HANDLE HapiStartStack( IEndpoint *pEndpoint )
{
	HS_QID t323Q, tNetQ;
	StackInfo *tStack = NULL;
	H323Demon *t323Demon = NULL;
	EnetDemon *tNetDemon = NULL;
	HS_UINT tActiveCnt = 0;

	/* check licence time
	*/
	if( H323EndpointCheckLicenceTime() != HS_OK )
	{
		delete_IEndpoint(pEndpoint);
		HSFree(pEndpoint);
		return NULL;
	}

	if( gStackStarted == TRUE )
	{
		delete_IEndpoint(pEndpoint);
		HSFree(pEndpoint);
		return HS_INVALID_STACK_HANDLE;
	}
	gStackStarted = TRUE;

	if( pEndpoint==NULL )
	{
		gStackStarted = FALSE;
		return HS_INVALID_STACK_HANDLE;
	}
	if( (t323Demon=newm_H323Demon())==NULL )
	{
		delete_IEndpoint(pEndpoint);
		HSFree(pEndpoint);
		gStackStarted = FALSE;
		return HS_INVALID_STACK_HANDLE;
	}
	if( (tNetDemon=newm_EnetDemon(pEndpoint->rasListenPort,pEndpoint->callListenPort))==NULL )
	{
		delete_IEndpoint(pEndpoint);
		HSFree(pEndpoint);
		deletem_H323Demon(t323Demon);
		gStackStarted = FALSE;
		return HS_INVALID_STACK_HANDLE;
	}

	if( (tStack=(StackInfo*)HSMalloc(sizeof(StackInfo)))==NULL )
	{
		delete_IEndpoint(pEndpoint);
		HSFree(pEndpoint);
		deletem_H323Demon(t323Demon);
		deletem_EnetDemon(tNetDemon);
		gStackStarted = FALSE;
		return HS_INVALID_STACK_HANDLE;
	}
	new_StackInfo(tStack);
	tNetDemon->mStack = tStack;
	t323Demon->mStack = tStack;
	t323Demon->mEndpoint = pEndpoint;

	/* semaphore Initialize */
	HSOpenSemaphore(gSemaCallHandleInH323UI);

	/* start threads
	*/
	t323Q = HSThreadStart(t323Demon,NULL,H323Demon_Main);
	tNetQ = HSThreadStart(tNetDemon,NULL,EnetDemon_Main);
	if( t323Q==HS_INVALID_QID || tNetQ==HS_INVALID_QID )
	{
		gStackStarted = FALSE;
		return HS_INVALID_STACK_HANDLE;
	}

	tStack->h323DemonQ = t323Q;
	tStack->enetDemonQ = tNetQ;

	/* wait for starting thread
	*/
	tActiveCnt = 0;
	while( ! HS_THREAD_IS_ACTIVE(t323Demon) || ! HS_THREAD_IS_ACTIVE(tNetDemon) )
	{
		HSSleep(50);
		tActiveCnt++;
		if( tActiveCnt==20 ) break;
	}
	if( tActiveCnt==20 )
	{
		_HSThreadStop(t323Q);
		_HSThreadStop(tNetQ);
		gStackStarted = FALSE;
		return HS_INVALID_STACK_HANDLE;
	}
	HSSleep(100);

	return tStack;
}


HS_RESULT HapiStopStack( HS_STACK_HANDLE handle )
{
	StackInfo *tStack = (StackInfo*)handle;

	/* check parameter
	*/
	if( tStack==NULL ) return HS_ERR_H323_INVALID_HANDLE;
	if( gStackStarted == FALSE ) return HS_ERR_H323_NOT_STARTED;

	/* stop threads
	*/
	_HSThreadStop(tStack->h323DemonQ);
	_HSThreadStop(tStack->enetDemonQ);

	/* clear semaphores
	*/
	HSCloseSemaphore(gSemaCallHandleInH323UI);

	delete_StackInfo(tStack);
	HSFree(tStack);

	gStackStarted = FALSE;
    return HS_OK;
}





/* check H.323 Endpoint licence time
*/
HS_RESULT H323EndpointCheckLicenceTime()
{
	if		( !strcmp(RELEASED_VENDOR,"voiper") )
		return HSCheckLicenceTime();
	else if ( !strcmp(RELEASED_VENDOR,"my vendor") )
		return HSCheckLicenceTime();

	return HS_ERR;
}
