/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/ 

/*

	<H323UI.h>		2005-03-20,11:34

*/

#ifndef __2005_03_20__11_34__H323UI_H__
#define __2005_03_20__11_34__H323UI_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "H323Demon.h"



#define HS_THREAD_STARTING_TIME		500
#define HS_THREAD_ENDING_TIME		500



/*
FILE COMMENT:
	- 'Hapi' prefix means "H323 API Function"
*/



/* check H.323 Endpoint licence time
*/
HS_RESULT H323EndpointCheckLicenceTime();


/* functions for JUST simple test
*/
void HapiOpenStackForTest();
void HapiCloseStackForTest();


/* making call for application user
*/
ICall *HapiCallOpen();
HS_RESULT HapiCallClose(ICall *pCall);


/* alias setting functions
*/
HS_RESULT HapiAddEndpointAliasDial(IEndpoint *pEndpoint, char *pAlias);
HS_RESULT HapiAddEndpointAliasH323Id(IEndpoint *pEndpoint, char *pAlias);
HS_RESULT HapiAddEndpointAliasH323IdEx(IEndpoint *pEndpoint, HS_USHORT *pAlias, HS_UINT pLen);
HS_RESULT HapiAddEndpointAliasUrlId(IEndpoint *pEndpoint, char *pAlias);
HS_RESULT HapiAddEndpointAliasEmailId(IEndpoint *pEndpoint, char *pAlias);

HS_RESULT HapiAddCallingAliasDial(ICall *pCall, char *pAlias);
HS_RESULT HapiAddCallingAliasH323Id(ICall *pCall, char *pAlias);
HS_RESULT HapiAddCallingAliasH323IdEx(ICall *pCall, HS_USHORT *pAlias, HS_UINT pLen);
HS_RESULT HapiAddCallingAliasUrlId(ICall *pCall, char *pAlias);
HS_RESULT HapiAddCallingAliasEmailId(ICall *pCall, char *pAlias);

HS_RESULT HapiAddCalledAliasDial(ICall *pCall, char *pAlias);
HS_RESULT HapiAddCalledAliasH323Id(ICall *pCall, char *pAlias);
HS_RESULT HapiAddCalledAliasH323IdEx(ICall *pCall, HS_USHORT *pAlias, HS_UINT pLen);
HS_RESULT HapiAddCalledAliasUrlId(ICall *pCall, char *pAlias);
HS_RESULT HapiAddCalledAliasEmailId(ICall *pCall, char *pAlias);


/* make alias address list for change #IEndpoint#'s  #aliases#
*/
NoLockList *HapiMakeAliasList();
HS_RESULT HapiAddAliasDial(NoLockList *pList, char *pAlias);
HS_RESULT HapiAddAliasH323Id(NoLockList *pList, char *pAlias);
HS_RESULT HapiAddAliasH323IdEx(NoLockList *pList, HS_USHORT *pAlias, HS_UINT pLen);
HS_RESULT HapiAddAliasUrlId(NoLockList *pList, char *pAlias);
HS_RESULT HapiAddAliasEmailId(NoLockList *pList, char *pAlias);


/* capability setting
*/
HS_RESULT HapiAddG711Alaw64k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG711Alaw56k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG711Ulaw64k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG711Ulaw56k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG72264k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG72256k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG72248k(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG7231(ICall *pCall, HS_UINT pSimul, HS_UCHAR pMaxAl, BOOL pSilence);
HS_RESULT HapiAddG728(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG729(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG729AnnexA(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG729wAnnexB(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);
HS_RESULT HapiAddG729AnnexAwAnnexB(ICall *pCall, HS_UINT pSimul, HS_UCHAR pValue);


/* transport address setting functions
*/
HS_RESULT HapiSetRasAddress( IEndpoint *pEndpoint, HS_UCHAR *pIp, HS_USHORT pPort );
HS_RESULT HapiSetCallSignalingAddress( IEndpoint *pEndpoint, HS_UCHAR *pIp, HS_USHORT pPort );


/* media add functions
*/
HS_RESULT HapiAddOpenLogicalChannel(IEndpoint *pEndpoint, ICall *pCall, ICapability *pCapa);
HS_RESULT HapiAddOpenLogicalChannelEx(IEndpoint *pEndpoint, ICall *pCall, HS_UINT pIndex);
HS_RESULT HapiAddForwardFastStart(ICall *pCall, ASNH245OpenLogicalChannel *olc);
HS_RESULT HapiAddReverseFastStart(ICall *pCall, ASNH245OpenLogicalChannel *olc);


/* functions for getting information
*/
BOOL HapiStateIsRegisted( HS_STACK_HANDLE pHandle );
HS_CALL_HANDLE HapiGetCallHandle(ICall *pCall);



/***************************************************************************/
/*
	User Command Message : Command Functions {
*/
HS_RESULT HapiCommandMakeCall( HS_STACK_HANDLE pHandle, ICall *pCall );
/* pTarget == ""            : unregistration
   pTarget == "@"           : regist to multicast address
   pTarget == <"something"> : regist to <"something">
*/
HS_RESULT HapiCommandChangeGatekeeper( HS_STACK_HANDLE pHandle, char *pTarget );
HS_RESULT HapiCommandAcceptCall( HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle );
HS_RESULT HapiCommandRemoveCall( HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, CallCloseReason pReason );
HS_RESULT HapiCommandUseGRQ( HS_STACK_HANDLE pHandle, BOOL pUse );
HS_RESULT HapiCommandChangeBandwidth( HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, HS_UINT pBandwidth );
HS_RESULT HapiCommandH245UserInputIndication( HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, ControlMsg *pMsg );
HS_RESULT HapiCommandChangeEndpointAliases( HS_STACK_HANDLE hStack, NoLockList *pList );
/*
	User Command Message : Command Functions }
*/
/***************************************************************************/


/* stack start/stop functions
*/
HS_STACK_HANDLE HapiStartStack( IEndpoint *pEndpoint );
HS_RESULT HapiStopStack( HS_STACK_HANDLE handle );



#endif/*__2005_03_20__11_34__H323UI_H__*/


